'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DRAWING_BUFFERS = undefined;
exports.default = initializeDrawBuffers;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var DRAWING_BUFFERS = exports.DRAWING_BUFFERS = [
// The fragment shader is not written to any color buffer.
'NONE',
// Fragment shader is written to the back color buffer.
'BACK',
// Fragment shader is written to the nth color attachment of the framebuffer.
'COLOR_ATTACHMENT0', 'COLOR_ATTACHMENT1', 'COLOR_ATTACHMENT2', 'COLOR_ATTACHMENT3', 'COLOR_ATTACHMENT4', 'COLOR_ATTACHMENT5', 'COLOR_ATTACHMENT6', 'COLOR_ATTACHMENT7', 'COLOR_ATTACHMENT8', 'COLOR_ATTACHMENT9', 'COLOR_ATTACHMENT10', 'COLOR_ATTACHMENT11', 'COLOR_ATTACHMENT12', 'COLOR_ATTACHMENT13', 'COLOR_ATTACHMENT14', 'COLOR_ATTACHMENT15'];

// Map bufferName string or enum to correct enum (extension version)
// WebGL2 polyfill of drawBuffers using the 'WEBGL_draw_buffers' extension.
// Note: The tricky part is copying the extension constants onto the gl context

/* global WebGLRenderingContext, WebGL2RenderingContext */
function getExtConstant(ext, constant) {
  if (constant.indexOf('COLOR_ATTACHMENT') === 0) {
    constant = constant + '_WEBGL';
  }
  return ext[constant];
}

/**
 * @param {WebGLRenderingContext} gl - gl context
 * @param {GLenum/String[]} buffers - array of enums
 */
function drawBuffers(gl, buffers) {
  var ext = gl.getExtension('WEBGL_draw_buffers');
  (0, _assert2.default)(ext, 'WEBGL_draw_buffers');
  ext.drawBuffersWEBGL(buffers);
}

// Only add if WebGL2RenderingContext is not available
if (!WebGL2RenderingContext) {

  var prototype = WebGLRenderingContext.prototype;

  prototype.drawBuffers = prototype.drawBuffers || drawBuffers;
}

function initializeDrawBuffers(gl) {
  var ext = gl.getExtension('WEBGL_draw_buffers');
  (0, _assert2.default)(ext, 'WEBGL_draw_buffers');
  for (var constant in DRAWING_BUFFERS) {
    gl[constant] = gl[constant] || getExtConstant(ext, constant);
  }
}
//# sourceMappingURL=data:application/json;base64,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