'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = polyfillInstancedArrays;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function polyfillInstancedArrays(gl) {
  // Only add if WebGL2RenderingContext is not available
  if (!(gl instanceof WebGL2RenderingContext)) {
    var ext = gl.getExtension('ANGLE_instanced_arrays');
    (0, _assert2.default)(ext, 'WebGL extension not available: ANGLE_instanced_arrays');

    var _WebGLRenderingContex = WebGLRenderingContext;
    var prototype = _WebGLRenderingContex.prototype;

    prototype.vertexAttribDivisor = ext.vertexAttribDivisorANGLE.bind(ext);
    prototype.drawArraysInstanced = ext.drawArraysInstancedANGLE.bind(ext);
    prototype.drawElementsInstanced = ext.drawElementsInstancedANGLE.bind(ext);
    prototype.VERTEX_ATTRIB_ARRAY_DIVISOR = ext.VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE;
  }
} // WebGL2 Polyfills for instanced rendering
// using ANGLE_instanced_arrays extension

/* eslint-disable max-params */
/* global WebGLRenderingContext, WebGL2RenderingContext */
//# sourceMappingURL=data:application/json;base64,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