'use strict';

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function createVertexArray(gl) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  return ext.createVertexArrayOES();
} // WebGL2 Polyfills for iVertexArray Objects
// using OES_vertex_array_object extension

/* global WebGLRenderingContext, WebGL2RenderingContext */


function deleteVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  ext.deleteVertexArrayOES(vertexArray);
}

function isVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  return ext.isVertexArrayOES(vertexArray);
}

function bindVertexArray(gl, vertexArray) {
  var ext = gl.getExtension('OES_vertex_array_object');
  (0, _assert2.default)(gl, 'OES_vertex_array_object');
  return ext.bindVertexArrayOES(vertexArray);
}

// Only add if WebGL2RenderingContext is not available
if (!WebGL2RenderingContext) {

  var prototype = WebGLRenderingContext.prototype;

  prototype.createVertexArray = prototype.createVertexArray || createVertexArray;

  prototype.deleteVertexArray = prototype.deleteVertexArray || deleteVertexArray;

  prototype.isVertexArray = prototype.isVertexArray || isVertexArray;

  prototype.bindVertexArray = prototype.bindVertexArray || bindVertexArray;
}
//# sourceMappingURL=data:application/json;base64,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