describe 'up.Config', ->

  describe 'constructor', ->

    it 'creates an object from a function that productes the initial attributes', ->
      object = new up.Config(-> a: 1, b: 2)
      expect(object.a).toBe(1)
      expect(object.b).toBe(2)

  describe '#reset', ->

    it 'resets the object to its original state', ->
      object = new up.Config(-> a: 1)
      expect(object.b).toBeUndefined()
      object.a = 2
      expect(object.a).toBe(2)
      object.reset()
      expect(object.a).toBe(1)

    it 'does not remove the #reset method from the object', ->
      object = new up.Config(-> a: 1)
      object.b = 2
      object.reset()
      expect(object.reset).toBeDefined()
