precision mediump float;

attribute vec3 position, nextPosition;
attribute float arcLength, lineWidth;
attribute vec4 color;

uniform vec2 screenShape;
uniform float pixelRatio;
uniform mat4 model, view, projection;

varying vec4 fragColor;
varying vec3 worldPosition;
varying float pixelArcLength;

void main() {
  vec4 projected = projection * view * model * vec4(position, 1.0);
  vec4 tangentClip = projection * view * model * vec4(nextPosition - position, 0.0);
  vec2 tangent = normalize(screenShape * tangentClip.xy);
  vec2 offset = 0.5 * pixelRatio * lineWidth * vec2(tangent.y, -tangent.x) / screenShape;

  gl_Position = vec4(projected.xy + projected.w * offset, projected.zw);

  worldPosition = position;
  pixelArcLength = arcLength;
  fragColor = color;
}
