"use strict";

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var invariant = require("invariant");
var defer = require("promise-defer");
var React = require("react");
var Component = React.Component;
var PropTypes = React.PropTypes;

var raf = require("raf");
var now = require("performance-now");
var createShader = require("gl-shader");
var createTexture = require("gl-texture2d");
var createFBO = require("gl-fbo");
var pool = require("typedarray-pool");

var _require = require("gl-react");

var Shaders = _require.Shaders;

var GLImage = require("./GLImage");
var vertShader = require("./static.vert");
var pointerEventsProperty = require("./pointerEventsProperty");
var canvasPool = require("./canvasPool");

var disposeFunction = function disposeFunction(o) {
  return o.dispose();
};

// call f(obj, key) on all objects that have disappeared from oldMap to newMap
function diffCall(newMap, oldMap, f) {
  for (var o in oldMap) {
    if (!(o in newMap)) {
      f(oldMap[o], o);
    }
  }
}

// set obj.shape only if it has changed
function syncShape(obj, shape) {
  if (obj.shape[0] !== shape[0] || obj.shape[1] !== shape[1]) {
    obj.shape = shape;
  }
}

function imageObjectToId(image) {
  return image.uri;
}

function countPreloaded(loaded, toLoad) {
  var nb = 0;
  for (var i = 0; i < toLoad.length; i++) {
    if (loaded.indexOf(imageObjectToId(toLoad[i])) !== -1) nb++;
  }
  return nb;
}

function extractShaderDebug(shader) {
  var uniforms = shader.types.uniforms;

  return { types: { uniforms: uniforms } };
}

var GLCanvas = function (_Component) {
  _inherits(GLCanvas, _Component);

  // Life-cycle methods

  function GLCanvas(props) {
    _classCallCheck(this, GLCanvas);

    var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(GLCanvas).call(this, props));

    _this._getFBO = function (id) {
      var fbos = _this._cache._fbos; // pool of FBOs
      invariant(id >= 0, "fbo id must be a positive integer");
      if (id in fbos) {
        return fbos[id]; // re-use existing FBO from pool
      } else {
          var fbo = createFBO(_this._gl, [2, 2]);
          fbo.color[0].minFilter = fbo.color[0].magFilter = _this._gl.LINEAR;
          fbos[id] = fbo;
          return fbo;
        }
    };

    _this._onImageLoad = function (loadedObj) {
      _this._preloading.push(loadedObj);
      var _this$props = _this.props;
      var imagesToPreload = _this$props.imagesToPreload;
      var onProgress = _this$props.onProgress;

      var loaded = countPreloaded(_this._preloading, imagesToPreload);
      var total = imagesToPreload.length;
      if (onProgress) onProgress({
        progress: loaded / total,
        loaded: loaded,
        total: total
      });
      _this._dirtyOnLoad = true;
      _this._requestSyncData();
    };

    _this._handleDraw = function () {
      delete _this._rafDraw;
      if (_this._needsSyncData) {
        try {
          _this._syncData(_this._data);
        } catch (e) {
          if (!("rawError" in e)) {
            // Duck-typing on gl-shader error. can be improved
            throw e;
          }
        }
      }
      if (!_this._haveRemainingToPreload()) {
        _this._draw();
      }
    };

    _this._data = props.data;
    return _this;
  }

  _createClass(GLCanvas, [{
    key: "_mount",
    value: function _mount(container) {
      this._drawCleanups = [];
      // Create the WebGL Context and init the rendering
      this._poolObject = canvasPool.create(container);
      if (!this._poolObject) return;
      this._cache = this._poolObject.cache;
      var _poolObject = this._poolObject;
      var canvas = _poolObject.canvas;
      var gl = _poolObject.gl;
      var resize = _poolObject.resize;
      var data = this.props.data;

      if (data) resize(data.width, data.height, data.pixelRatio);
      this._canvas = canvas;

      this._dirtyOnLoad = true;
      this._preloading = Object.keys(this._cache._images);
      this._autoredraw = this.props.autoRedraw;
      this._pendingCaptureFrame = {};

      this._gl = gl;

      this._resizeUniformContentTextures(this.props.nbContentTextures);
      this._requestSyncData();
      this._syncAutoRedraw();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var _this2 = this;

      this._drawCleanups.forEach(function (f) {
        return f();
      });
      this._drawCleanups = null;
      if (this._poolObject) {
        this._poolObject.dispose();
      }
      if (this._allocatedFromPool) {
        this._allocatedFromPool.forEach(pool.freeUint8);
      }
      this.setDebugProbe(null);
      this._mountPoint = null;
      this._canvas = null;
      this._gl = null;
      this._cache = null;
      if (this._rafAutoRedraw) raf.cancel(this._rafAutoRedraw);
      if (this._rafDraw) raf.cancel(this._rafDraw);
      Object.keys(this._pendingCaptureFrame).forEach(function (key) {
        _this2._pendingCaptureFrame[key].reject(new Error("GLCanvas is unmounting"));
      });
      this._pendingCaptureFrame = null;
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(props) {
      // react on props changes only for things we can't pre-compute
      if (props.nbContentTextures !== this.props.nbContentTextures) this._resizeUniformContentTextures(props.nbContentTextures);

      if (props.data !== this.props.data) {
        this._data = props.data;
        this._requestSyncData();
      }

      this._autoredraw = props.autoRedraw;
      this._syncAutoRedraw();
    }
  }, {
    key: "componentWillUpdate",
    value: function componentWillUpdate() {
      if (this._poolObject) {
        var data = this.props.data;

        if (data) this._poolObject.resize(data.width, data.height, data.pixelRatio);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _extends2,
          _this3 = this;

      var _props = this.props;
      var width = _props.width;
      var height = _props.height;
      var pixelRatio = _props.pixelRatio;
      var style = _props.style;
      var data = _props.data;
      var nbContentTextures = _props.nbContentTextures;
      var imagesToPreload = _props.imagesToPreload;
      var renderId = _props.renderId;
      var onLoad = _props.onLoad;
      var onProgress = _props.onProgress;
      var autoRedraw = _props.autoRedraw;
      var eventsThrough = _props.eventsThrough;
      var visibleContent = _props.visibleContent;

      var rest = _objectWithoutProperties(_props, ["width", "height", "pixelRatio", "style", "data", "nbContentTextures", "imagesToPreload", "renderId", "onLoad", "onProgress", "autoRedraw", "eventsThrough", "visibleContent"]);

      var styles = _extends({}, style, (_extends2 = {
        width: width + "px",
        height: height + "px"
      }, _defineProperty(_extends2, pointerEventsProperty, eventsThrough ? "none" : "auto"), _defineProperty(_extends2, "position", "relative"), _defineProperty(_extends2, "display", "inline-block"), _extends2));
      return React.createElement("div", _extends({}, rest, {
        ref: function ref(_ref) {
          if (_ref && !_this3._mountPoint) {
            _this3._mount(_this3._mountPoint = _ref);
          }
        },
        style: styles
      }));
    }

    // Exposed methods

  }, {
    key: "captureFrame",
    value: function captureFrame(config) {
      var opts = undefined;
      if (config) {
        invariant((typeof config === "undefined" ? "undefined" : _typeof(config)) === "object", "captureFrame takes an object option in parameter");
        var nb = 0;
        if ("format" in config) {
          invariant(typeof config.format === "string", "captureFrame({format}): format must be a string (e.g: 'base64', 'blob'), Got: '%s'", config.format);
          nb++;
        }
        if ("type" in config) {
          invariant(typeof config.type === "string", "captureFrame({type}): type must be a string (e.g: 'png', 'jpg'), Got: '%s'", config.type);
          nb++;
        }
        if ("quality" in config) {
          invariant(typeof config.quality === "number" && config.quality >= 0 && config.quality <= 1, "captureFrame({quality}): quality must be a number between 0 and 1, Got: '%s'", config.quality);
          nb++;
        }
        var keys = Object.keys(config);
        invariant(keys.length === nb, "captureFrame(opts): opts must be an object with {format, type, quality}, found some invalid keys in '%s'", keys);
        opts = config;
      }
      opts = _extends({
        format: "base64",
        type: "png",
        quality: 1
      }, opts);
      var promise = this._addPendingCaptureFrame(opts).promise;
      this._requestDraw();
      return promise;
    }
  }, {
    key: "setDebugProbe",
    value: function setDebugProbe(params) {
      // Free old
      if (this._debugProbe) {
        this._debugProbe = null;
      }
      if (params) {
        invariant(typeof params.onDraw === "function", "onDraw is required in setDebugProbe({ onDraw })");
        params = _extends({
          profile: true,
          capture: true,
          captureRate: 0 }, params);
        this._debugProbe = _extends({}, params, {
          lastCapture: 0
        });
        this._requestDraw();
      }
    }
  }, {
    key: "setNativeProps",
    value: function setNativeProps(props) {
      if ("data" in props && props.data !== this._data) {
        this._data = props.data;
        this._requestSyncData();
      }
    }
  }, {
    key: "requestDraw",
    value: function requestDraw() {
      this._requestDraw();
    }

    // Private methods

  }, {
    key: "_addPendingCaptureFrame",
    value: function _addPendingCaptureFrame(opts) {
      var key = opts.format + ":" + opts.type + ":" + opts.quality;
      return this._pendingCaptureFrame[key] || (this._pendingCaptureFrame[key] = _extends({}, defer(), { opts: opts }));
    }
  }, {
    key: "_capture",
    value: function _capture(_ref2) {
      var format = _ref2.format;
      var type = _ref2.type;
      var quality = _ref2.quality;

      var canvas = this._canvas;
      try {
        switch (format) {
          case "base64":
            return Promise.resolve(canvas.toDataURL(type, quality));
          case "blob":
            return new Promise(function (resolve) {
              return canvas.toBlob(resolve, type, quality);
            });
          default:
            invariant(false, "invalid capture format '%s'", format);
        }
      } catch (e) {
        return Promise.reject(e);
      }
    }
  }, {
    key: "_syncData",
    value: function _syncData(data) {
      var _this4 = this;

      // Synchronize the data props that contains every data needed for render
      var gl = this._gl;
      if (!gl) return;

      var _onImageLoad = this._onImageLoad;
      var contentTextures = this._cache._contentTextures;
      var _getFBO = this._getFBO;

      // old values
      var prevShaders = this._cache._shaders;
      var prevImages = this._cache._images;
      var prevStandaloneTextures = this._cache._standaloneTextures;

      // new values (mutated from traverseTree)
      var shaders = {}; // shaders cache (per Shader ID)
      var images = {}; // images cache (per src)
      var standaloneTextures = [];

      // traverseTree compute renderData from the data.
      // frameIndex is the framebuffer index of a node. (root is -1)
      function traverseTree(data) {
        var s = data.shader;
        var dataUniforms = data.uniforms;
        var dataChildren = data.children;
        var dataContextChildren = data.contextChildren;
        var width = data.width;
        var height = data.height;
        var pixelRatio = data.pixelRatio;
        var fboId = data.fboId;


        var contextChildren = dataContextChildren.map(traverseTree);

        // Traverse children and compute children renderData.
        // We build a framebuffer mapping (from child index to fbo index)
        var children = dataChildren.map(traverseTree);

        // Sync shader
        var shader = undefined;
        if (s in shaders) {
          shader = shaders[s]; // re-use existing gl-shader instance
        } else if (s in prevShaders) {
            shader = shaders[s] = prevShaders[s]; // re-use old gl-shader instance
          } else {
              // Retrieve/Compiles/Prepare the shader
              var shaderObj = Shaders.get(s);
              invariant(shaderObj, "Shader #%s does not exists", s);
              shader = createShader(gl, vertShader, shaderObj.frag);
              shader.name = shaderObj.name;
              shader.attributes._p.pointer();
              shaders[s] = shader;
            }

        // extract uniforms and textures
        var uniforms = {}; // will contains all uniforms values (including texture units)
        var textures = {}; // a texture is an object with a bind() function
        var units = 0; // Starting from 0, we will affect texture units to texture uniforms
        for (var uniformName in dataUniforms) {
          var value = dataUniforms[uniformName];
          var type = shader.types.uniforms[uniformName];

          invariant(type, "Shader '%s': Uniform '%s' is not defined/used", shader.name, uniformName);

          if (type === "sampler2D" || type === "samplerCube") {
            // This is a texture
            uniforms[uniformName] = units++; // affect a texture unit
            if (!value) {
              var emptyTexture = createTexture(gl, [2, 2]); // empty texture
              textures[uniformName] = emptyTexture;
              standaloneTextures.push(emptyTexture);
            } else switch (value.type) {
              case "content":
                // contents are DOM elements that can be rendered as texture (<canvas>, <img>, <video>)
                textures[uniformName] = contentTextures[value.id];
                break;

              case "fbo":
                // framebuffers are a children rendering
                var fbo = _getFBO(value.id);
                textures[uniformName] = fbo.color[0];
                break;

              case "uri":
                var src = value.uri;
                invariant(src && typeof src === "string", "Shader '%s': An image src is defined for uniform '%s'", shader.name, uniformName);
                var image = undefined;
                if (src in images) {
                  image = images[src];
                } else if (src in prevImages) {
                  image = images[src] = prevImages[src];
                } else {
                  image = new GLImage(gl, _onImageLoad);
                  images[src] = image;
                }
                image.src = src; // Always set the image src. GLImage internally won't do anything if it doesn't change
                textures[uniformName] = image.getTexture(); // GLImage will compute and cache a gl-texture2d instance
                break;

              case "ndarray":
                var tex = createTexture(gl, value.ndarray);
                var opts = value.opts || {}; // TODO: in next releases we will generalize opts to more types.
                if (!opts.disableLinearInterpolation) tex.minFilter = tex.magFilter = gl.LINEAR;
                textures[uniformName] = tex;
                standaloneTextures.push(tex);
                break;

              default:
                invariant(false, "Shader '%s': invalid uniform '%s' value of type '%s'", shader.name, uniformName, value.type);
            }
          } else {
            // In all other cases, we just copy the uniform value
            uniforms[uniformName] = value;
          }
        }

        var notProvided = Object.keys(shader.uniforms).filter(function (u) {
          return !(u in uniforms);
        });
        invariant(notProvided.length === 0, "Shader '%s': All defined uniforms must be provided. Missing: '" + notProvided.join("', '") + "'", shader.name);

        return { shader: shader, uniforms: uniforms, textures: textures, children: children, contextChildren: contextChildren, width: width, height: height, pixelRatio: pixelRatio, fboId: fboId, data: data };
      }

      this._renderData = traverseTree(data);

      diffCall(images, prevImages, function (img, src) {
        var i = _this4._preloading.indexOf(src);
        if (i !== -1) _this4._preloading.splice(i, 1);
      });
      // Destroy previous states that have disappeared
      this._dispatchDrawCleanup(function () {
        diffCall(shaders, prevShaders, disposeFunction);
        diffCall(images, prevImages, disposeFunction);
        prevStandaloneTextures.forEach(disposeFunction);
      });

      this._cache._shaders = shaders;
      this._cache._images = images;
      this._cache._standaloneTextures = standaloneTextures;

      this._needsSyncData = false;
    }
  }, {
    key: "_dispatchDrawCleanup",
    value: function _dispatchDrawCleanup(f) {
      this._drawCleanups.push(f);
    }
  }, {
    key: "_draw",
    value: function _draw() {
      var _this5 = this;

      this._needsDraw = false;
      var gl = this._gl;
      var renderData = this._renderData;
      if (!gl || !renderData) return;
      var _getFBO = this._getFBO;
      var buffer = this._cache._buffer;

      var allocatedFromPool = [];
      var debugProbe = this._debugProbe;
      var shouldDebugCapture = false,
          shouldProfile = false;
      if (debugProbe) {
        if (debugProbe.capture) {
          var t = now();
          if (t - debugProbe.lastCapture > debugProbe.captureRate) {
            debugProbe.lastCapture = t;
            shouldDebugCapture = true;
          }
        }
        shouldProfile = debugProbe.profile;
      }

      function recDraw(renderData) {
        var shader = renderData.shader;
        var uniforms = renderData.uniforms;
        var textures = renderData.textures;
        var children = renderData.children;
        var contextChildren = renderData.contextChildren;
        var width = renderData.width;
        var height = renderData.height;
        var pixelRatio = renderData.pixelRatio;
        var fboId = renderData.fboId;
        var data = renderData.data;


        var debugNode = debugProbe ? _extends({}, data, { shaderInfos: extractShaderDebug(shader) }) : {};
        var profileExclusive = undefined;

        var w = width * pixelRatio,
            h = height * pixelRatio;

        // contextChildren are rendered BEFORE children and parent because are contextual to them
        debugNode.contextChildren = contextChildren.map(recDraw);

        // children are rendered BEFORE the parent
        debugNode.children = children.map(recDraw);

        if (shouldProfile) {
          profileExclusive = now();
        }

        var fbo = undefined;
        if (fboId === -1) {
          // special case for root FBO
          gl.bindFramebuffer(gl.FRAMEBUFFER, null);
          gl.viewport(0, 0, w, h);
          gl.blendFunc(gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
        } else {
          // Use the framebuffer of the node
          fbo = _getFBO(fboId);
          syncShape(fbo, [w, h]);
          fbo.bind();
          gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
        }

        // Prepare the shader/buffer
        shader.bind();
        gl.bindBuffer(gl.ARRAY_BUFFER, buffer);

        // Bind the textures
        for (var uniformName in textures) {
          textures[uniformName].bind(uniforms[uniformName]);
        }

        // Set the uniforms
        for (var uniformName in uniforms) {
          shader.uniforms[uniformName] = uniforms[uniformName];
        }

        // Render
        gl.clearColor(0.0, 0.0, 0.0, 0.0);
        gl.clear(gl.COLOR_BUFFER_BIT);
        gl.drawArrays(gl.TRIANGLES, 0, 6);

        if (shouldProfile) {
          profileExclusive = now() - profileExclusive;
          var profileInclusiveSum = 0;
          debugNode.contextChildren.forEach(function (_ref3) {
            var profileInclusive = _ref3.profileInclusive;

            profileInclusiveSum += profileInclusive;
          });
          debugNode.children.forEach(function (_ref4) {
            var profileInclusive = _ref4.profileInclusive;

            profileInclusiveSum += profileInclusive;
          });
          Object.keys(data.uniforms).forEach(function (key) {
            var value = data.uniforms[key];
            if ((typeof value === "undefined" ? "undefined" : _typeof(value)) === "object" && value.type === "content") profileInclusiveSum += debugContents[value.id].profileExclusive;
          });
          debugNode.profileExclusive = profileExclusive;
          debugNode.profileInclusive = profileInclusiveSum + profileExclusive;
        }

        if (shouldDebugCapture) {
          var pixels = pool.mallocUint8(w * h * 4);
          allocatedFromPool.push(pixels);
          gl.readPixels(0, 0, w, h, gl.RGBA, gl.UNSIGNED_BYTE, pixels);
          debugNode.capture = { pixels: pixels, width: w, height: h };
        }

        return debugNode;
      }

      // Draw the content to contentTextures (assuming they ALWAYS change and need a re-_syncData)
      var contents = this._getDrawingUniforms();
      var contentTextures = this._cache._contentTextures;
      var debugContents = contents.map(function (content, i) {
        var profile = undefined;
        if (shouldProfile) {
          profile = now();
        }
        _this5._syncUniformTexture(contentTextures[i], content);
        if (shouldProfile) {
          profile = now() - profile;
        }
        if (debugProbe) {
          var capture = undefined;
          if (shouldDebugCapture) {
            capture = content; // gl-texture2d can reconciliate dom node rendering
          }
          return {
            code: content.parentNode.innerHTML,
            capture: capture,
            profileExclusive: profile,
            profileInclusive: profile
          };
        }
      });

      // Draw everything

      gl.enable(gl.BLEND);
      var debugTree = recDraw(renderData);
      gl.disable(gl.BLEND);

      if (this._drawCleanups.length > 0) {
        this._drawCleanups.forEach(function (f) {
          return f();
        });
        this._drawCleanups = [];
      }

      if (debugProbe) {
        if (this._allocatedFromPool) {
          this._allocatedFromPool.forEach(pool.freeUint8);
        }
        this._allocatedFromPool = allocatedFromPool;
        debugProbe.onDraw({
          tree: debugTree,
          contents: debugContents,
          Shaders: Shaders
        });
      }

      var _pendingCaptureFrame = this._pendingCaptureFrame;
      var pendingCaptureFramePerOption = Object.keys(_pendingCaptureFrame);
      if (pendingCaptureFramePerOption.length > 0) {
        pendingCaptureFramePerOption.forEach(function (key) {
          var _pendingCaptureFrame$ = _pendingCaptureFrame[key];
          var opts = _pendingCaptureFrame$.opts;
          var resolve = _pendingCaptureFrame$.resolve;
          var reject = _pendingCaptureFrame$.reject;

          _this5._capture(opts).then(resolve, reject);
        });
        this._pendingCaptureFrame = {};
      }

      if (this._dirtyOnLoad && !this._haveRemainingToPreload()) {
        this._dirtyOnLoad = false;
        if (this.props.onLoad) {
          this.props.onLoad();
        }
      }
    }
  }, {
    key: "_haveRemainingToPreload",
    value: function _haveRemainingToPreload() {
      var _this6 = this;

      return this.props.imagesToPreload.some(function (o) {
        return _this6._preloading.indexOf(imageObjectToId(o)) === -1;
      });
    }
  }, {
    key: "_resizeUniformContentTextures",
    value: function _resizeUniformContentTextures(n) {
      // Resize the pool of textures for the contentTextures
      var gl = this._gl;
      var contentTextures = this._cache._contentTextures;
      var length = contentTextures.length;
      if (length === n) return;
      if (n < length) {
        for (var i = n; i < length; i++) {
          contentTextures[i].dispose();
        }
        contentTextures.length = n;
      } else {
        for (var i = contentTextures.length; i < n; i++) {
          var texture = createTexture(gl, [2, 2]);
          texture.minFilter = texture.magFilter = gl.LINEAR;
          contentTextures.push(texture);
        }
      }
    }
  }, {
    key: "_getDrawingUniforms",
    value: function _getDrawingUniforms() {
      var nbContentTextures = this.props.nbContentTextures;

      if (nbContentTextures === 0) return [];
      var children = this._mountPoint.parentNode.children;
      var all = [];
      for (var i = 0; i < nbContentTextures; i++) {
        all[i] = children[i].firstChild;
      }
      return all;
    }
  }, {
    key: "_syncAutoRedraw",
    value: function _syncAutoRedraw() {
      var _this7 = this;

      if (!this._autoredraw || this._rafAutoRedraw) return;
      var loop = function loop() {
        if (!_this7._autoredraw) {
          delete _this7._rafAutoRedraw;
          return;
        }
        _this7._rafAutoRedraw = raf(loop);
        _this7._draw();
      };
      this._rafAutoRedraw = raf(loop);
    }
  }, {
    key: "_syncUniformTexture",
    value: function _syncUniformTexture(texture, content) {
      var width = content.width || content.videoWidth;
      var height = content.height || content.videoHeight;
      if (width && height) {
        // ensure the resource is loaded
        syncShape(texture, [width, height]);
        texture.setPixels(content);
      } else {
        texture.shape = [2, 2];
      }
    }
  }, {
    key: "_requestSyncData",
    value: function _requestSyncData() {
      this._needsSyncData = true;
      this._requestDraw();
    }
  }, {
    key: "_requestDraw",
    value: function _requestDraw() {
      if (this._rafDraw) return;
      this._rafDraw = raf(this._handleDraw);
    }
  }]);

  return GLCanvas;
}(Component);

GLCanvas.propTypes = {
  width: PropTypes.number.isRequired,
  height: PropTypes.number.isRequired,
  pixelRatio: PropTypes.number.isRequired,
  data: PropTypes.object.isRequired,
  nbContentTextures: PropTypes.number.isRequired
};

module.exports = GLCanvas;
//# sourceMappingURL=GLCanvas.js.map