"use strict";

function GLCanvasCache(gl) {
  this.gl = gl;
  this._images = {};
  this._shaders = {};
  this._fbos = {};
  this._contentTextures = [];
  this._standaloneTextures = [];

  gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);

  var buffer = gl.createBuffer();
  gl.bindBuffer(gl.ARRAY_BUFFER, buffer);
  gl.bufferData(gl.ARRAY_BUFFER, new Float32Array([-1.0, -1.0, 1.0, -1.0, -1.0, 1.0, -1.0, 1.0, 1.0, -1.0, 1.0, 1.0]), gl.STATIC_DRAW);

  this._buffer = buffer;
}

GLCanvasCache.prototype = {
  dispose: function dispose() {
    // Destroy everything to avoid leaks.
    this._contentTextures.forEach(function (t) {
      return t.dispose();
    });
    this._standaloneTextures.forEach(function (t) {
      return t.dispose();
    });
    [this._shaders, this._images, this._fbos].forEach(function (coll) {
      for (var k in coll) {
        coll[k].dispose();
        delete coll[k];
      }
    });

    if (this.gl) this.gl.deleteBuffer(this._buffer);
    this.gl = null;
  }
};

module.exports = GLCanvasCache;
//# sourceMappingURL=GLCanvasCache.js.map