"use strict";

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var React = require("react");
var GLCanvas = require("./GLCanvas");

var _require = require("gl-react");

var createSurface = _require.createSurface;

var pointerEventsProperty = require("./pointerEventsProperty");

var getPixelRatio = function getPixelRatio(props) {
  return props.scale || window.devicePixelRatio || 1;
};

function renderVcontent(width, height, id, children, _ref) {
  var visibleContent = _ref.visibleContent;

  var content = React.Children.only(children);
  var childrenStyle = {
    position: "absolute",
    top: 0,
    left: 0,
    width: width + "px",
    height: height + "px",
    visibility: visibleContent ? "visible" : "hidden"
  };
  return React.createElement(
    "div",
    { key: "content-" + id, style: childrenStyle },
    content
  );
}

function renderVGL(props) {
  return React.createElement(GLCanvas, _extends({ ref: "canvas" }, props));
}

function renderVcontainer(_ref2, contents, renderer) {
  var style = _ref2.style;
  var visibleContent = _ref2.visibleContent;
  var eventsThrough = _ref2.eventsThrough;
  var width = _ref2.width;
  var height = _ref2.height;

  var parentStyle = _extends({
    position: "relative"
  }, style, _defineProperty({
    width: width + "px",
    height: height + "px",
    overflow: "hidden"
  }, pointerEventsProperty, !visibleContent && eventsThrough ? "none" : "auto"));
  return React.createElement(
    "div",
    { style: parentStyle },
    contents,
    renderer
  );
}

module.exports = createSurface(renderVcontainer, renderVcontent, renderVGL, getPixelRatio);
//# sourceMappingURL=Surface.js.map