"use strict";

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var Cache = require("./GLCanvasCache");
var pointerEventsProperty = require("./pointerEventsProperty");
var getContext = require("./getContext");

var maxSizePool = 20;
var pool = [];

function setSize(size) {
  maxSizePool = size;
  pool.splice(size).forEach(function (p) {
    return p.dispose(true);
  });
}

function clear() {
  pool.splice(0).forEach(function (p) {
    return p.dispose(true);
  });
}

function create(parentNode) {
  var poolObject = undefined;

  if (pool.length > 0) {
    // reuse most recently used canvas
    poolObject = pool.splice(pool.length - 1)[0];
  } else {
    var _ret = function () {
      // create a new canvas / context
      var canvas = document.createElement("canvas");
      canvas.style[pointerEventsProperty] = "none";
      canvas.style.width = "100%";
      canvas.style.height = "100%";

      var opts = {};
      var gl = getContext(canvas, opts);

      if (!gl) return {
          v: null
        };

      var dispose = function dispose(dontReuse) {
        if (canvas.parentNode) {
          canvas.parentNode.removeChild(canvas);
        }
        var reachPoolLimit = pool.length >= maxSizePool;
        if (reachPoolLimit) {
          console.warn( // eslint-disable-line no-console
          "gl-react-dom: canvasPool of size " + maxSizePool + " reached, you might want to increase pool size, use less concurrent WebGL Canvases or consider using gl-react-dom-static-container library");
        }
        if (!dontReuse && !reachPoolLimit && pool.indexOf(poolObject) === -1) {
          pool.push(poolObject);
          gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
          gl.clearColor(0.0, 0.0, 0.0, 0.0);
          gl.clear(gl.COLOR_BUFFER_BIT);
        } else {
          poolObject.cache.dispose();
        }
      };

      var _w = -1,
          _h = -1,
          _s = -1;
      var resize = function resize(w, h, scale) {
        var scaleChanged = scale !== _s;
        if (scaleChanged) {
          _s = scale;
        }
        if (w !== _w || scaleChanged) {
          _w = w;
          canvas.width = scale * w;
        }
        if (h !== _h || scaleChanged) {
          _h = h;
          canvas.height = scale * h;
        }
      };

      poolObject = {
        canvas: canvas,
        gl: gl,
        dispose: dispose,
        resize: resize,
        cache: new Cache(gl)
      };
    }();

    if ((typeof _ret === "undefined" ? "undefined" : _typeof(_ret)) === "object") return _ret.v;
  }

  parentNode.appendChild(poolObject.canvas);

  return poolObject;
}

module.exports = {
  create: create,
  clear: clear,
  setSize: setSize
};
//# sourceMappingURL=canvasPool.js.map