"use strict";

var _require = require("gl-react");

var Shaders = _require.Shaders;

var createShader = require("gl-shader");
var getContext = require("./getContext");
var vertexCode = require("./static.vert");
var mockCanvas = document.createElement("canvas");
var mockGl = getContext(mockCanvas, {});

var checkCompiles = function checkCompiles(o) {
  if (!mockGl) throw new Error("WebGL context unavailable"); // we skip validation when webgl is not supported
  var shader = createShader(mockGl, vertexCode, o.frag);
  var uniforms = shader.types.uniforms;

  shader.dispose();
  return { uniforms: uniforms };
};

Shaders.setImplementation({
  add: function add(id, shader) {
    return Promise.resolve().then(function () {
      try {
        return checkCompiles(shader);
      } catch (e) {
        throw e.rawError || e.message;
      }
    });
  },
  remove: function remove() {}
});
//# sourceMappingURL=compileShaders.js.map