var GenericCache = (function () {
    function GenericCache() {
        this.cache = {};
    }
    GenericCache.prototype.add = function (key, val) {
        if (!this.has(key)) {
            this.cache[key] = val;
        }
    };
    GenericCache.prototype.has = function (key) {
        return this.cache[key] != null;
    };
    GenericCache.prototype.get = function (key) {
        return this.cache[key];
    };
    GenericCache.prototype.flush = function () {
        this.cache = {};
    };
    GenericCache.prototype.counts = function () {
        return Object.keys(this.cache).length;
    };
    GenericCache.prototype.keys = function () {
        return Object.keys(this.cache);
    };
    return GenericCache;
}());
export { GenericCache };
//# sourceMappingURL=GenericCache.js.map