import { isLikeRule, idFor } from '../utils';
import { GenericCache } from './GenericCache';
export { GenericCache };
/**
 * This variable will be used to store each created style object using the hash value of this object (id) as a key
 */
export var registered = new GenericCache();
/**
 * This vaiable will be used to store each created rule using the hash value of Spec object(id) as a key.
 *
 * A cached rule looks like: {data-css-<id>: ''}
 */
export var ruleCache = new GenericCache();
/**
 * Store if a rule is successfully inserted in the StyleSheet (in <style> tag) using the id as a key
 */
export var inserted = new GenericCache();
export function getRegistered(rule) {
    if (isLikeRule(rule)) {
        var ret = registered.get(idFor(rule));
        if (ret == null) {
            throw new Error('[glamor] an unexpected rule cache miss occurred. This is probably a sign of multiple glamor instances in your app. See https://github.com/threepointone/glamor/issues/79');
        }
        return ret;
    }
    return rule;
}
//# sourceMappingURL=index.js.map