var possibles = [':', '.', '[', '>', ' '];
/**
 * Check if the key is a css selector like (:, ., [, >, ' ' )
 * @param key
 */
export function isSelector(key) {
    var ch = key.charAt(0);
    var found = false;
    for (var _i = 0, possibles_1 = possibles; _i < possibles_1.length; _i++) {
        var possible = possibles_1[_i];
        if (ch === possible) {
            found = true;
            break;
        }
    }
    return found || (key.indexOf('&') >= 0);
}
export function joinSelectors(a, b) {
    var as = a.split(',').map(function (a) { return !(a.indexOf('&') >= 0) ? '&' + a : a; });
    var bs = b.split(',').map(function (b) { return !(b.indexOf('&') >= 0) ? '&' + b : b; });
    return bs.reduce(function (arr, b) { return arr.concat(as.map(function (a) { return b.replace(/\&/g, a); })); }, []).join(',');
}
/**
 * Compine two @media quieries with "and" operator, and return one @media query
 *
 * ex. a: @media only print
 * b:@media only screen and (max-device-width: 480px)
 * => result: @media only print and only screen and (max-device-width: 480px)
 * @param a
 * @param b
 */
export function joinMediaQueries(a, b) {
    return a ? "@media " + a.substring(6) + " and " + b.substring(6) : b;
}
/**
 * Check if the key representing a media query
 * Media query start with "@media"
 * @param key
 */
export function isMediaQuery(key) {
    return key.indexOf('@media') === 0;
}
/**
 * Check if the key represents a support query
 * Support query starts with "@supports"
 * ex: @support (conditions){ some css magic! }
 * @param key
 */
export function isSupports(key) {
    return key.indexOf('@supports') === 0;
}
/**
 * Compine two @support quieries with "and" operator, and return one @support query
 * @param a
 * @param b
 * ex a = @supports (display: flex)'
 *    b = '@supports (-webkit-appearance: caret)
 *    result :'@supports  (display: flex) and  (-webkit-appearance: caret)'
 */
export function joinSupports(a, b) {
    return a ? "@supports " + a.substring(9) + " and " + b.substring(9) : b;
}
//# sourceMappingURL=helper.js.map