import { PluginSet } from './plugins/PluginSet';
import { prefix } from './plugins/prefix';
import { fallbacks } from './plugins/fallbacks';
import { StyleSheet } from './StyleSheet';
import { clean, isLikeRule, hashify, nullRule, cssLabels } from './utils';
import { generateCss, toCSS, insertKeyframe, insertFontFace, cssFor } from './css';
import { registered, ruleCache, inserted } from './cache';
import { multiIndexCache } from './cache/MultiIndexCache';
var cachedCss = (typeof WeakMap !== 'undefined') ? multiIndexCache(generateCss, function (spec) { return registered.has(spec.toString().substring(4)); }) : generateCss;
export var styleSheet = new StyleSheet();
styleSheet.inject();
export var plugins = new PluginSet([prefix, fallbacks]);
export var keyframesPlugins = new PluginSet([prefix]);
export function speedy(bool) {
    return styleSheet.speedy(bool);
}
function css() {
    // if (rules[0] && rules[0].length && rules[0].raw) {
    //   throw new Error('you forgot to include glamor/babel in your babel plugins.')
    // }
    var rules = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        rules[_i] = arguments[_i];
    }
    var cleanedRules = clean(rules);
    if (!cleanedRules) {
        return nullRule;
    }
    return cachedCss(cleanedRules);
}
(function (css_1) {
    function insert(css) {
        var spec = {
            id: hashify(css),
            css: css,
            type: 'raw'
        };
        registered.add(spec.id, spec);
        if (!inserted.has(spec.id)) {
            styleSheet.insert(spec.css);
            inserted.add(spec.id, true);
        }
    }
    css_1.insert = insert;
    function global(selector, style) {
        return css.insert(toCSS({ selector: selector, style: style }));
    }
    css_1.global = global;
    function keyframes(arg1, arg2) {
        var name = 'animation';
        var kfs;
        if (arg2 != null) {
            name = arg1;
            kfs = arg2;
        }
        else {
            kfs = arg1;
        }
        // do not ignore empty keyframe definitions for now.
        kfs = clean(kfs) || {};
        var spec = {
            id: hashify(name, kfs),
            type: 'keyframes',
            name: name,
            keyframes: kfs
        };
        registered.add(spec.id, spec);
        insertKeyframe(spec);
        return name + '_' + spec.id;
    }
    css_1.keyframes = keyframes;
    function fontFace(font) {
        font = clean(font);
        var spec = {
            id: hashify(font),
            type: 'font-face',
            font: font
        };
        registered.add(spec.id, spec);
        insertFontFace(spec);
        return font.fontFamily;
    }
    css_1.fontFace = fontFace;
})(css || (css = {}));
export { css };
export var insertRule = css.insert;
export var insertGlobal = css.global;
export var keyframes = css.keyframes;
export var fontFace = css.fontFace;
// rehydrate the insertion cache with ids sent from
// renderStatic / renderStaticOptimized
export function rehydrate(ids) {
    for (var _i = 0, ids_1 = ids; _i < ids_1.length; _i++) {
        var id = ids_1[_i];
        inserted.add(id, true);
    }
}
export function flush() {
    inserted.flush();
    registered.flush();
    ruleCache.flush();
    styleSheet.flush();
    styleSheet.inject();
}
export { simulate, simulations } from './Simulations';
export { isLikeRule, cssLabels, cssFor };
export var caches = {
    inserted: inserted,
    registered: registered
};
//# sourceMappingURL=index.js.map