var PluginSet = (function () {
    function PluginSet(initial) {
        if (initial === void 0) { initial = []; }
        this.fns = initial;
    }
    /**
       * Takes a list of functions(plugins) as an input parameters and add them to the plugin set if they do not exist.
       *
       * Can be called like: add(func1, func2, ...)
       * @param functionsList an array of different functions to add it to
       */
    PluginSet.prototype.add = function () {
        var _this = this;
        var fns = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            fns[_i] = arguments[_i];
        }
        fns.forEach(function (fn) {
            if (_this.fns.indexOf(fn) >= 0) {
                if (process.env.NODE_ENV !== 'production') {
                    console.warn('adding the same plugin again, ignoring');
                }
            }
            else {
                _this.fns = [fn].concat(_this.fns);
            }
        });
    };
    PluginSet.prototype.remove = function (fn) {
        this.fns = this.fns.filter(function (x) { return x !== fn; });
    };
    PluginSet.prototype.clear = function () {
        this.fns = [];
    };
    PluginSet.prototype.transform = function (o) {
        return this.fns.reduce(function (o, fn) { return fn(o); }, o);
    };
    return PluginSet;
}());
export { PluginSet };
//# sourceMappingURL=PluginSet.js.map