// Returns true for null, false, undefined and {}
function isFalsy(value) {
    return value === null ||
        value === undefined ||
        value === false ||
        (typeof value === 'object' && Object.keys(value).length === 0);
}
function cleanObject(object) {
    if (isFalsy(object)) {
        return null;
    }
    if (typeof object !== 'object') {
        return object;
    }
    var acc = {}, keys = Object.keys(object), hasFalsy = false;
    for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
        var key = keys_1[_i];
        var value = object[key];
        var filteredValue = clean(value);
        if (filteredValue === null || filteredValue !== value) {
            hasFalsy = true;
        }
        if (filteredValue !== null) {
            acc[key] = filteredValue;
        }
    }
    return Object.keys(acc).length === 0 ? null : hasFalsy ? acc : object;
}
function cleanArray(rules) {
    var hasFalsy = false;
    var filtered = [];
    rules.forEach(function (rule) {
        var filteredRule = clean(rule);
        if (filteredRule === null || filteredRule !== rule) {
            hasFalsy = true;
        }
        if (filteredRule !== null) {
            filtered.push(filteredRule);
        }
    });
    return filtered.length === 0 ? null :
        hasFalsy ? filtered : rules;
}
/**
 * Takes style array or object provided by user and clears all the falsy data.
 *
 *  If there is no styles left after filtration returns null
 * @param input
 */
export function clean(input) {
    return Array.isArray(input) ? cleanArray(input) : cleanObject(input);
}
//# sourceMappingURL=clean.js.map