/**
 * Check if the key is a css selector like (:, ., [, >, ' ' )
 * @param key
 */
export declare function isSelector(key: string): boolean;
export declare function joinSelectors(a: string, b: string): string;
/**
 * Compine two @media quieries with "and" operator, and return one @media query
 *
 * ex. a: @media only print
 * b:@media only screen and (max-device-width: 480px)
 * => result: @media only print and only screen and (max-device-width: 480px)
 * @param a
 * @param b
 */
export declare function joinMediaQueries(a: string | null, b: string): string;
/**
 * Check if the key representing a media query
 * Media query start with "@media"
 * @param key
 */
export declare function isMediaQuery(key: string): boolean;
/**
 * Check if the key represents a support query
 * Support query starts with "@supports"
 * ex: @support (conditions){ some css magic! }
 * @param key
 */
export declare function isSupports(key: string): boolean;
/**
 * Compine two @support quieries with "and" operator, and return one @support query
 * @param a
 * @param b
 * ex a = @supports (display: flex)'
 *    b = '@supports (-webkit-appearance: caret)
 *    result :'@supports  (display: flex) and  (-webkit-appearance: caret)'
 */
export declare function joinSupports(a: string | null, b: string): string;
