import { PluginSet } from './plugins/PluginSet';
import { StyleSheet } from './StyleSheet';
import { isLikeRule, cssLabels } from './utils';
import { CSSSpec, RawSpec, Rule, StyleAttribute, CSSProperties, KeyframesSpec, FontFaceSpec, cssFor } from './css';
import { GenericCache } from './cache';
export declare const styleSheet: StyleSheet;
export declare const plugins: PluginSet;
export declare const keyframesPlugins: PluginSet;
export declare function speedy(bool: boolean): void;
declare function css(...rules: Array<Rule>): StyleAttribute;
declare namespace css {
    function insert(css: string): void;
    function global(selector: string, style: CSSProperties): void;
    function keyframes(kfs: {
        [key: string]: CSSProperties;
    }): string;
    function keyframes(name: string, kfs: {
        [key: string]: CSSProperties;
    }): string;
    function fontFace(font: CSSProperties): string;
}
export { css, Rule, CSSProperties, StyleAttribute };
export declare const insertRule: typeof css.insert;
export declare const insertGlobal: typeof css.global;
export declare const keyframes: typeof css.keyframes;
export declare const fontFace: typeof css.fontFace;
export declare function rehydrate(ids: Array<string>): void;
export declare function flush(): void;
export { simulate, simulations } from './Simulations';
export { isLikeRule, cssLabels, cssFor };
export declare const caches: {
    inserted: GenericCache<boolean>;
    registered: GenericCache<CSSSpec | RawSpec | KeyframesSpec | FontFaceSpec>;
};
