import { CSSProperties } from '../css/index';
export declare type Node = {
    id?: string;
    name?: string;
    style: CSSProperties;
    selector?: string;
};
export declare type Plugin = (style: Node) => Node;
export declare class PluginSet {
    private fns;
    constructor(initial?: Array<Plugin>);
    /**
       * Takes a list of functions(plugins) as an input parameters and add them to the plugin set if they do not exist.
       *
       * Can be called like: add(func1, func2, ...)
       * @param functionsList an array of different functions to add it to
       */
    add(...fns: Array<Plugin>): void;
    remove(fn: Plugin): void;
    clear(): void;
    transform(o: Node): Node;
}
