import { StyleAttribute } from '../css/index';
export declare const isBrowser: boolean;
export declare const isDev: boolean;
export declare const isTest: boolean;
export declare const idRegex: RegExp;
export { hashify } from './hash';
export { clean } from './clean';
/**** labels ****/
export declare let hasLabels: boolean;
export declare function cssLabels(bool: boolean): void;
/**
 * Check if the passed value is a css rule.
 * CSS rule object must contain the key 'data-css-<id>'
 * @param rule
 */
export declare function isLikeRule(rule: StyleAttribute): boolean;
/**
 * Get the id from a rule, the rule looks like { 'data-css-<id>': ''}
 * @param rule
 */
export declare function idFor(rule: StyleAttribute): string;
export declare const nullRule: {
    'data-css-nil': string;
};
/**
 * Create a selector string. Selector string looks like '.css-1j2tyha,[data-css-1j2tyha]'
 * @param id
 * @param path
 */
export declare function selector(id?: string, path?: string): string;
/**
 * Remove every charachter that is not a letter or a number and turn the capital-case to lowercase.
 *
 * Ex: simple('abc$%#12 3abc') => return 'abc123abc'
 * @param str
 */
export declare function simple(str: string): string;
/**
 * Flatten a nasted array, destructure an array of arrays into a single simple array
 * Example: input is arr1[arr2[val1, val2, val3], val4, val5 ,arr3[val6, val7] ] =>
 * Output is : arr [val1, val2, val3, val4, val5, val6, val7]
 * @param inArr
 */
export declare function flatten<T>(inArr: Array<Array<T>> | Array<T>): Array<T>;
