/**
 * Optimization: Cache the results of calling a function with multiple parameters, in order to prevent re-excuting the function when it has been called
 * with the same parameters more than one time.
 * more explenation can be found here:
 * https://github.com/threepointone/glamor/blob/master/docs/weakmaps.md
 *
 * @param fn the dunction which we want to cache its results
 * @param check : optional function that returns boolean, when it's not needed do not send anything
 *
 * example: if we have a function fn(...args) which sum numbers and return the result
 * 1- calling fn(1,2,3): the function will be excuted normally and the result will be cached
 * 2- calling fn(1,3) : the function also will be excuted normally and the result will be cached.
 * 3- calling fn(1,2,3): the function will not be excuted because we called it one timebefore with the same parameters (in the same order!),
 * a cached result will be returned in this case
 */
export declare function multiIndexCache<Y extends Function>(fn: Y, check?: (spec: any) => boolean): Y;
