import { GenericCache } from './GenericCache';
import { StyleAttribute, Spec } from '../css';
export { GenericCache };
/**
 * This variable will be used to store each created style object using the hash value of this object (id) as a key
 */
export declare const registered: GenericCache<Spec>;
/**
 * This vaiable will be used to store each created rule using the hash value of Spec object(id) as a key.
 *
 * A cached rule looks like: {data-css-<id>: ''}
 */
export declare const ruleCache: GenericCache<StyleAttribute>;
/**
 * Store if a rule is successfully inserted in the StyleSheet (in <style> tag) using the id as a key
 */
export declare const inserted: GenericCache<boolean>;
export declare function getRegistered(rule: any): Spec;
