// Copyright 2013 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Compact number formatting symbols.
 *
 * This file is generated by
 *   //depot/google3/i18n/tools/java/com/google/i18n/generator:generator
 * using the --for_closure flag.
 *
 * File generated from CLDR ver. 30.0.2
 * go/js-locale-data-update
 *
 * Before checking, this file could have been manually edited. This is
 * to incorporate changes before we could fix CLDR. All manual
 * modification must be documented in this section, and should be
 * removed after those changes land to CLDR.
 *
 * This file covers those locales that are not covered in
 * "compactnumberformatsymbols.js".
 *
 * @suppress {const,missingRequire} Missing requires for names like
 *     goog.i18n.CompactNumberFormatSymbols_af though they are included
 *     by requiring goog.i18n.CompactNumberFormatSymbols.
 */

// clang-format off

goog.provide('goog.i18n.CompactNumberFormatSymbolsExt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_af_NA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_af_ZA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_agq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_agq_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ak');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ak_GH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_am_ET');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_001');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_AE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_BH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_DJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_DZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_EG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_EH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_ER');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_IL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_IQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_JO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_KM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_KW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_LB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_LY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_MA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_MR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_OM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_PS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_QA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_SA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_SD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_SO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_SS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_SY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_TD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_TN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_XB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ar_YE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_as');
goog.provide('goog.i18n.CompactNumberFormatSymbols_as_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_asa');
goog.provide('goog.i18n.CompactNumberFormatSymbols_asa_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ast');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ast_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_az_Cyrl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_az_Cyrl_AZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_az_Latn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_az_Latn_AZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bas');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bas_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_be_BY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bem');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bem_ZM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bez');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bez_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bg_BG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bm');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bm_ML');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bn_BD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bn_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bo_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bo_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_br_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_brx');
goog.provide('goog.i18n.CompactNumberFormatSymbols_brx_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bs_Cyrl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bs_Cyrl_BA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bs_Latn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_bs_Latn_BA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_AD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ca_IT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ce');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ce_RU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cgg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cgg_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_chr_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ckb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ckb_IQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ckb_IR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cs_CZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_cy_GB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_da_DK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_da_GL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dav');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dav_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_BE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_IT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_LI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_de_LU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dje');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dje_NE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dsb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dsb_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dua');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dua_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dyo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dyo_SN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dz');
goog.provide('goog.i18n.CompactNumberFormatSymbols_dz_BT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ebu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ebu_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ee');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ee_GH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ee_TG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_el_CY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_el_GR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_001');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_150');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_AT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_BZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CX');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_CY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_DG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_DK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_DM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_ER');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_FI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_FJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_FK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_FM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_GY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_HK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_IO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_JE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_JM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_KI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_KN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_KY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_LC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_LR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_LS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_MY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_NZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_PW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_RW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SX');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_SZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TV');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_UM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_US_POSIX');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_VC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_VG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_VI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_VU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_WS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_XA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_ZM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_en_ZW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_eo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_AR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_BO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_BR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_CL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_CO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_CR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_CU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_DO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_EA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_EC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_GQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_GT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_HN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_IC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_NI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_PA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_PE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_PH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_PR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_PY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_SV');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_UY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_es_VE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_et_EE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_eu_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ewo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ewo_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fa_AF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fa_IR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ff');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ff_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ff_GN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ff_MR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ff_SN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fi_FI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fil_PH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fo_DK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fo_FO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_BE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_BF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_BI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_BJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_BL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_DJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_DZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_GQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_HT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_KM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_LU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_ML');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_MU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_NC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_NE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_PF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_PM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_RE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_RW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_SC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_SN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_SY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_TD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_TG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_TN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_VU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_WF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fr_YT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fur');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fur_IT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fy');
goog.provide('goog.i18n.CompactNumberFormatSymbols_fy_NL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ga_IE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gd');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gd_GB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gl_ES');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw_FR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gsw_LI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gu_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_guz');
goog.provide('goog.i18n.CompactNumberFormatSymbols_guz_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gv');
goog.provide('goog.i18n.CompactNumberFormatSymbols_gv_IM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ha');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ha_GH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ha_NE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ha_NG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_haw_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_he_IL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hi_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hr_BA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hr_HR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hsb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hsb_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hu_HU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_hy_AM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_id_ID');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ig');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ig_NG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ii');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ii_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_is_IS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it_IT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_it_SM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ja_JP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_jgo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_jgo_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_jmc');
goog.provide('goog.i18n.CompactNumberFormatSymbols_jmc_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ka_GE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kab');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kab_DZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kam');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kam_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kde');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kde_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kea');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kea_CV');
goog.provide('goog.i18n.CompactNumberFormatSymbols_khq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_khq_ML');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ki');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ki_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kk_KZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kkj');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kkj_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kl_GL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kln');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kln_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_km_KH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kn_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ko_KP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ko_KR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kok');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kok_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ks');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ks_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ksb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ksb_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ksf');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ksf_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ksh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ksh_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_kw_GB');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ky_KG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lag');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lag_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lb');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lb_LU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lg_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lkt');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lkt_US');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln_AO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln_CD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln_CF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ln_CG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lo_LA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lrc');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lrc_IQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lrc_IR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lt_LT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lu_CD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_luo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_luo_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_luy');
goog.provide('goog.i18n.CompactNumberFormatSymbols_luy_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_lv_LV');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mas');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mas_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mas_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mer');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mer_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mfe');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mfe_MU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mg_MG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mgh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mgh_MZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mgo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mgo_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mk_MK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ml_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mn_MN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mr_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ms_BN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ms_MY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ms_SG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mt_MT');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mua');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mua_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_my_MM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mzn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_mzn_IR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_naq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_naq_NA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nb_NO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nb_SJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nd');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nd_ZW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nds');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nds_DE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nds_NL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ne_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ne_NP');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_AW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_BE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_BQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_CW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_NL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_SR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nl_SX');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nmg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nmg_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nn_NO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nnh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nnh_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nus');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nus_SS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nyn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_nyn_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_om');
goog.provide('goog.i18n.CompactNumberFormatSymbols_om_ET');
goog.provide('goog.i18n.CompactNumberFormatSymbols_om_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_or_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_os');
goog.provide('goog.i18n.CompactNumberFormatSymbols_os_GE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_os_RU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pa_Arab');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pa_Arab_PK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pa_Guru');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pa_Guru_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pl_PL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ps');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ps_AF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_AO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_CV');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_GQ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_GW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_LU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_MO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_MZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_ST');
goog.provide('goog.i18n.CompactNumberFormatSymbols_pt_TL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_qu');
goog.provide('goog.i18n.CompactNumberFormatSymbols_qu_BO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_qu_EC');
goog.provide('goog.i18n.CompactNumberFormatSymbols_qu_PE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rm');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rm_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rn_BI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ro_MD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ro_RO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rof');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rof_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_BY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_KG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_KZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_MD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_RU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ru_UA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rw');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rw_RW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rwk');
goog.provide('goog.i18n.CompactNumberFormatSymbols_rwk_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sah');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sah_RU');
goog.provide('goog.i18n.CompactNumberFormatSymbols_saq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_saq_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sbp');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sbp_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_se');
goog.provide('goog.i18n.CompactNumberFormatSymbols_se_FI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_se_NO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_se_SE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_seh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_seh_MZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ses');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ses_ML');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sg');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sg_CF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_shi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_shi_Latn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_shi_Latn_MA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_shi_Tfng');
goog.provide('goog.i18n.CompactNumberFormatSymbols_shi_Tfng_MA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_si_LK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sk_SK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sl_SI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_smn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_smn_FI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sn_ZW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_so');
goog.provide('goog.i18n.CompactNumberFormatSymbols_so_DJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_so_ET');
goog.provide('goog.i18n.CompactNumberFormatSymbols_so_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_so_SO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sq_AL');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sq_MK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sq_XK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Cyrl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_BA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_ME');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_RS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_XK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Latn_BA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Latn_ME');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Latn_RS');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sr_Latn_XK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sv_AX');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sv_FI');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sv_SE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw_CD');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_sw_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta_LK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta_MY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ta_SG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_te_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_teo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_teo_KE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_teo_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_th_TH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ti');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ti_ER');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ti_ET');
goog.provide('goog.i18n.CompactNumberFormatSymbols_to');
goog.provide('goog.i18n.CompactNumberFormatSymbols_to_TO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tr_CY');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tr_TR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_twq');
goog.provide('goog.i18n.CompactNumberFormatSymbols_twq_NE');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tzm');
goog.provide('goog.i18n.CompactNumberFormatSymbols_tzm_MA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ug');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ug_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uk_UA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ur_IN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_ur_PK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz_Arab');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz_Arab_AF');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz_Cyrl');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz_Cyrl_UZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz_Latn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_uz_Latn_UZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vai');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vai_Latn');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vai_Latn_LR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vai_Vaii');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vai_Vaii_LR');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vi_VN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vun');
goog.provide('goog.i18n.CompactNumberFormatSymbols_vun_TZ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_wae');
goog.provide('goog.i18n.CompactNumberFormatSymbols_wae_CH');
goog.provide('goog.i18n.CompactNumberFormatSymbols_xog');
goog.provide('goog.i18n.CompactNumberFormatSymbols_xog_UG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yav');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yav_CM');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yi');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yi_001');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yo');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yo_BJ');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yo_NG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yue');
goog.provide('goog.i18n.CompactNumberFormatSymbols_yue_HK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zgh');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zgh_MA');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hans');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hans_CN');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hans_HK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hans_MO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hans_SG');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hant');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hant_HK');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hant_MO');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zh_Hant_TW');
goog.provide('goog.i18n.CompactNumberFormatSymbols_zu_ZA');
goog.require('goog.i18n.CompactNumberFormatSymbols');


/**
 * Compact number formatting symbols for locale af_NA.
 */
goog.i18n.CompactNumberFormatSymbols_af_NA = goog.i18n.CompactNumberFormatSymbols_af;


/**
 * Compact number formatting symbols for locale af_ZA.
 */
goog.i18n.CompactNumberFormatSymbols_af_ZA = goog.i18n.CompactNumberFormatSymbols_af;


/**
 * Compact number formatting symbols for locale agq.
 */
goog.i18n.CompactNumberFormatSymbols_agq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale agq_CM.
 */
goog.i18n.CompactNumberFormatSymbols_agq_CM = goog.i18n.CompactNumberFormatSymbols_agq;


/**
 * Compact number formatting symbols for locale ak.
 */
goog.i18n.CompactNumberFormatSymbols_ak = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ak_GH.
 */
goog.i18n.CompactNumberFormatSymbols_ak_GH = goog.i18n.CompactNumberFormatSymbols_ak;


/**
 * Compact number formatting symbols for locale am_ET.
 */
goog.i18n.CompactNumberFormatSymbols_am_ET = goog.i18n.CompactNumberFormatSymbols_am;


/**
 * Compact number formatting symbols for locale ar_001.
 */
goog.i18n.CompactNumberFormatSymbols_ar_001 = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_AE.
 */
goog.i18n.CompactNumberFormatSymbols_ar_AE = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_BH.
 */
goog.i18n.CompactNumberFormatSymbols_ar_BH = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_DJ.
 */
goog.i18n.CompactNumberFormatSymbols_ar_DJ = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_DZ.
 */
goog.i18n.CompactNumberFormatSymbols_ar_DZ = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_EG.
 */
goog.i18n.CompactNumberFormatSymbols_ar_EG = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_EH.
 */
goog.i18n.CompactNumberFormatSymbols_ar_EH = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_ER.
 */
goog.i18n.CompactNumberFormatSymbols_ar_ER = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_IL.
 */
goog.i18n.CompactNumberFormatSymbols_ar_IL = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_IQ.
 */
goog.i18n.CompactNumberFormatSymbols_ar_IQ = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_JO.
 */
goog.i18n.CompactNumberFormatSymbols_ar_JO = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_KM.
 */
goog.i18n.CompactNumberFormatSymbols_ar_KM = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_KW.
 */
goog.i18n.CompactNumberFormatSymbols_ar_KW = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_LB.
 */
goog.i18n.CompactNumberFormatSymbols_ar_LB = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_LY.
 */
goog.i18n.CompactNumberFormatSymbols_ar_LY = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_MA.
 */
goog.i18n.CompactNumberFormatSymbols_ar_MA = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_MR.
 */
goog.i18n.CompactNumberFormatSymbols_ar_MR = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_OM.
 */
goog.i18n.CompactNumberFormatSymbols_ar_OM = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_PS.
 */
goog.i18n.CompactNumberFormatSymbols_ar_PS = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_QA.
 */
goog.i18n.CompactNumberFormatSymbols_ar_QA = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_SA.
 */
goog.i18n.CompactNumberFormatSymbols_ar_SA = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_SD.
 */
goog.i18n.CompactNumberFormatSymbols_ar_SD = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_SO.
 */
goog.i18n.CompactNumberFormatSymbols_ar_SO = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_SS.
 */
goog.i18n.CompactNumberFormatSymbols_ar_SS = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_SY.
 */
goog.i18n.CompactNumberFormatSymbols_ar_SY = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_TD.
 */
goog.i18n.CompactNumberFormatSymbols_ar_TD = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_TN.
 */
goog.i18n.CompactNumberFormatSymbols_ar_TN = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_XB.
 */
goog.i18n.CompactNumberFormatSymbols_ar_XB = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale ar_YE.
 */
goog.i18n.CompactNumberFormatSymbols_ar_YE = goog.i18n.CompactNumberFormatSymbols_ar;


/**
 * Compact number formatting symbols for locale as.
 */
goog.i18n.CompactNumberFormatSymbols_as = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale as_IN.
 */
goog.i18n.CompactNumberFormatSymbols_as_IN = goog.i18n.CompactNumberFormatSymbols_as;


/**
 * Compact number formatting symbols for locale asa.
 */
goog.i18n.CompactNumberFormatSymbols_asa = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale asa_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_asa_TZ = goog.i18n.CompactNumberFormatSymbols_asa;


/**
 * Compact number formatting symbols for locale ast.
 */
goog.i18n.CompactNumberFormatSymbols_ast = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 millares'
    },
    '10000': {
      'other': '00 millares'
    },
    '100000': {
      'other': '000 millares'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ast_ES.
 */
goog.i18n.CompactNumberFormatSymbols_ast_ES = goog.i18n.CompactNumberFormatSymbols_ast;


/**
 * Compact number formatting symbols for locale az_Cyrl.
 */
goog.i18n.CompactNumberFormatSymbols_az_Cyrl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale az_Cyrl_AZ.
 */
goog.i18n.CompactNumberFormatSymbols_az_Cyrl_AZ = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale az_Latn.
 */
goog.i18n.CompactNumberFormatSymbols_az_Latn = goog.i18n.CompactNumberFormatSymbols_az;


/**
 * Compact number formatting symbols for locale az_Latn_AZ.
 */
goog.i18n.CompactNumberFormatSymbols_az_Latn_AZ = goog.i18n.CompactNumberFormatSymbols_az;


/**
 * Compact number formatting symbols for locale bas.
 */
goog.i18n.CompactNumberFormatSymbols_bas = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale bas_CM.
 */
goog.i18n.CompactNumberFormatSymbols_bas_CM = goog.i18n.CompactNumberFormatSymbols_bas;


/**
 * Compact number formatting symbols for locale be_BY.
 */
goog.i18n.CompactNumberFormatSymbols_be_BY = goog.i18n.CompactNumberFormatSymbols_be;


/**
 * Compact number formatting symbols for locale bem.
 */
goog.i18n.CompactNumberFormatSymbols_bem = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale bem_ZM.
 */
goog.i18n.CompactNumberFormatSymbols_bem_ZM = goog.i18n.CompactNumberFormatSymbols_bem;


/**
 * Compact number formatting symbols for locale bez.
 */
goog.i18n.CompactNumberFormatSymbols_bez = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale bez_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_bez_TZ = goog.i18n.CompactNumberFormatSymbols_bez;


/**
 * Compact number formatting symbols for locale bg_BG.
 */
goog.i18n.CompactNumberFormatSymbols_bg_BG = goog.i18n.CompactNumberFormatSymbols_bg;


/**
 * Compact number formatting symbols for locale bm.
 */
goog.i18n.CompactNumberFormatSymbols_bm = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale bm_ML.
 */
goog.i18n.CompactNumberFormatSymbols_bm_ML = goog.i18n.CompactNumberFormatSymbols_bm;


/**
 * Compact number formatting symbols for locale bn_BD.
 */
goog.i18n.CompactNumberFormatSymbols_bn_BD = goog.i18n.CompactNumberFormatSymbols_bn;


/**
 * Compact number formatting symbols for locale bn_IN.
 */
goog.i18n.CompactNumberFormatSymbols_bn_IN = goog.i18n.CompactNumberFormatSymbols_bn;


/**
 * Compact number formatting symbols for locale bo.
 */
goog.i18n.CompactNumberFormatSymbols_bo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale bo_CN.
 */
goog.i18n.CompactNumberFormatSymbols_bo_CN = goog.i18n.CompactNumberFormatSymbols_bo;


/**
 * Compact number formatting symbols for locale bo_IN.
 */
goog.i18n.CompactNumberFormatSymbols_bo_IN = goog.i18n.CompactNumberFormatSymbols_bo;


/**
 * Compact number formatting symbols for locale br_FR.
 */
goog.i18n.CompactNumberFormatSymbols_br_FR = goog.i18n.CompactNumberFormatSymbols_br;


/**
 * Compact number formatting symbols for locale brx.
 */
goog.i18n.CompactNumberFormatSymbols_brx = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale brx_IN.
 */
goog.i18n.CompactNumberFormatSymbols_brx_IN = goog.i18n.CompactNumberFormatSymbols_brx;


/**
 * Compact number formatting symbols for locale bs_Cyrl.
 */
goog.i18n.CompactNumberFormatSymbols_bs_Cyrl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00 хиљ'
    },
    '100000': {
      'other': '000 хиљ'
    },
    '1000000': {
      'other': '0 мил'
    },
    '10000000': {
      'other': '00 мил'
    },
    '100000000': {
      'other': '000 мил'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 бил'
    },
    '10000000000000': {
      'other': '00 бил'
    },
    '100000000000000': {
      'other': '000 бил'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00 хиљ'
    },
    '100000': {
      'other': '000 хиљ'
    },
    '1000000': {
      'other': '0 мил'
    },
    '10000000': {
      'other': '00 мил'
    },
    '100000000': {
      'other': '000 мил'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 бил'
    },
    '10000000000000': {
      'other': '00 бил'
    },
    '100000000000000': {
      'other': '000 бил'
    }
  }
};


/**
 * Compact number formatting symbols for locale bs_Cyrl_BA.
 */
goog.i18n.CompactNumberFormatSymbols_bs_Cyrl_BA = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00 хиљ'
    },
    '100000': {
      'other': '000 хиљ'
    },
    '1000000': {
      'other': '0 мил'
    },
    '10000000': {
      'other': '00 мил'
    },
    '100000000': {
      'other': '000 мил'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 бил'
    },
    '10000000000000': {
      'other': '00 бил'
    },
    '100000000000000': {
      'other': '000 бил'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0'
    },
    '10000': {
      'other': '00 хиљ'
    },
    '100000': {
      'other': '000 хиљ'
    },
    '1000000': {
      'other': '0 мил'
    },
    '10000000': {
      'other': '00 мил'
    },
    '100000000': {
      'other': '000 мил'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 бил'
    },
    '10000000000000': {
      'other': '00 бил'
    },
    '100000000000000': {
      'other': '000 бил'
    }
  }
};


/**
 * Compact number formatting symbols for locale bs_Latn.
 */
goog.i18n.CompactNumberFormatSymbols_bs_Latn = goog.i18n.CompactNumberFormatSymbols_bs;


/**
 * Compact number formatting symbols for locale bs_Latn_BA.
 */
goog.i18n.CompactNumberFormatSymbols_bs_Latn_BA = goog.i18n.CompactNumberFormatSymbols_bs;


/**
 * Compact number formatting symbols for locale ca_AD.
 */
goog.i18n.CompactNumberFormatSymbols_ca_AD = goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ca_ES.
 */
goog.i18n.CompactNumberFormatSymbols_ca_ES = goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ca_FR.
 */
goog.i18n.CompactNumberFormatSymbols_ca_FR = goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ca_IT.
 */
goog.i18n.CompactNumberFormatSymbols_ca_IT = goog.i18n.CompactNumberFormatSymbols_ca;


/**
 * Compact number formatting symbols for locale ce.
 */
goog.i18n.CompactNumberFormatSymbols_ce = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 эзар'
    },
    '10000': {
      'other': '00 эзар'
    },
    '100000': {
      'other': '000 эзар'
    },
    '1000000': {
      'other': '0 млн'
    },
    '10000000': {
      'other': '00 млн'
    },
    '100000000': {
      'other': '000 млн'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 эзар'
    },
    '10000': {
      'other': '00 эзар'
    },
    '100000': {
      'other': '000 эзар'
    },
    '1000000': {
      'other': '0 миллион'
    },
    '10000000': {
      'other': '00 миллион'
    },
    '100000000': {
      'other': '000 миллион'
    },
    '1000000000': {
      'other': '0 миллиард'
    },
    '10000000000': {
      'other': '00 миллиард'
    },
    '100000000000': {
      'other': '000 миллиард'
    },
    '1000000000000': {
      'other': '0 триллион'
    },
    '10000000000000': {
      'other': '00 триллион'
    },
    '100000000000000': {
      'other': '000 триллион'
    }
  }
};


/**
 * Compact number formatting symbols for locale ce_RU.
 */
goog.i18n.CompactNumberFormatSymbols_ce_RU = goog.i18n.CompactNumberFormatSymbols_ce;


/**
 * Compact number formatting symbols for locale cgg.
 */
goog.i18n.CompactNumberFormatSymbols_cgg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale cgg_UG.
 */
goog.i18n.CompactNumberFormatSymbols_cgg_UG = goog.i18n.CompactNumberFormatSymbols_cgg;


/**
 * Compact number formatting symbols for locale chr_US.
 */
goog.i18n.CompactNumberFormatSymbols_chr_US = goog.i18n.CompactNumberFormatSymbols_chr;


/**
 * Compact number formatting symbols for locale ckb.
 */
goog.i18n.CompactNumberFormatSymbols_ckb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ckb_IQ.
 */
goog.i18n.CompactNumberFormatSymbols_ckb_IQ = goog.i18n.CompactNumberFormatSymbols_ckb;


/**
 * Compact number formatting symbols for locale ckb_IR.
 */
goog.i18n.CompactNumberFormatSymbols_ckb_IR = goog.i18n.CompactNumberFormatSymbols_ckb;


/**
 * Compact number formatting symbols for locale cs_CZ.
 */
goog.i18n.CompactNumberFormatSymbols_cs_CZ = goog.i18n.CompactNumberFormatSymbols_cs;


/**
 * Compact number formatting symbols for locale cy_GB.
 */
goog.i18n.CompactNumberFormatSymbols_cy_GB = goog.i18n.CompactNumberFormatSymbols_cy;


/**
 * Compact number formatting symbols for locale da_DK.
 */
goog.i18n.CompactNumberFormatSymbols_da_DK = goog.i18n.CompactNumberFormatSymbols_da;


/**
 * Compact number formatting symbols for locale da_GL.
 */
goog.i18n.CompactNumberFormatSymbols_da_GL = goog.i18n.CompactNumberFormatSymbols_da;


/**
 * Compact number formatting symbols for locale dav.
 */
goog.i18n.CompactNumberFormatSymbols_dav = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale dav_KE.
 */
goog.i18n.CompactNumberFormatSymbols_dav_KE = goog.i18n.CompactNumberFormatSymbols_dav;


/**
 * Compact number formatting symbols for locale de_BE.
 */
goog.i18n.CompactNumberFormatSymbols_de_BE = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_DE.
 */
goog.i18n.CompactNumberFormatSymbols_de_DE = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_IT.
 */
goog.i18n.CompactNumberFormatSymbols_de_IT = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_LI.
 */
goog.i18n.CompactNumberFormatSymbols_de_LI = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale de_LU.
 */
goog.i18n.CompactNumberFormatSymbols_de_LU = goog.i18n.CompactNumberFormatSymbols_de;


/**
 * Compact number formatting symbols for locale dje.
 */
goog.i18n.CompactNumberFormatSymbols_dje = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale dje_NE.
 */
goog.i18n.CompactNumberFormatSymbols_dje_NE = goog.i18n.CompactNumberFormatSymbols_dje;


/**
 * Compact number formatting symbols for locale dsb.
 */
goog.i18n.CompactNumberFormatSymbols_dsb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tys.'
    },
    '10000': {
      'other': '00 tys.'
    },
    '100000': {
      'other': '000 tys.'
    },
    '1000000': {
      'other': '0 mio.'
    },
    '10000000': {
      'other': '00 mio.'
    },
    '100000000': {
      'other': '000 mio.'
    },
    '1000000000': {
      'other': '0 mrd.'
    },
    '10000000000': {
      'other': '00 mrd.'
    },
    '100000000000': {
      'other': '000 mrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tysac'
    },
    '10000': {
      'other': '00 tysac'
    },
    '100000': {
      'other': '000 tysac'
    },
    '1000000': {
      'other': '0 milionow'
    },
    '10000000': {
      'other': '00 milionow'
    },
    '100000000': {
      'other': '000 milionow'
    },
    '1000000000': {
      'other': '0 miliardow'
    },
    '10000000000': {
      'other': '00 miliardow'
    },
    '100000000000': {
      'other': '000 miliardow'
    },
    '1000000000000': {
      'other': '0 bilionow'
    },
    '10000000000000': {
      'other': '00 bilionow'
    },
    '100000000000000': {
      'other': '000 bilionow'
    }
  }
};


/**
 * Compact number formatting symbols for locale dsb_DE.
 */
goog.i18n.CompactNumberFormatSymbols_dsb_DE = goog.i18n.CompactNumberFormatSymbols_dsb;


/**
 * Compact number formatting symbols for locale dua.
 */
goog.i18n.CompactNumberFormatSymbols_dua = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale dua_CM.
 */
goog.i18n.CompactNumberFormatSymbols_dua_CM = goog.i18n.CompactNumberFormatSymbols_dua;


/**
 * Compact number formatting symbols for locale dyo.
 */
goog.i18n.CompactNumberFormatSymbols_dyo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale dyo_SN.
 */
goog.i18n.CompactNumberFormatSymbols_dyo_SN = goog.i18n.CompactNumberFormatSymbols_dyo;


/**
 * Compact number formatting symbols for locale dz.
 */
goog.i18n.CompactNumberFormatSymbols_dz = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': 'སྟོང་ཕྲག 0'
    },
    '10000': {
      'other': 'ཁྲི་ཕྲག 0'
    },
    '100000': {
      'other': 'འབུམ་ཕྲག 0'
    },
    '1000000': {
      'other': 'ས་ཡ་ 0'
    },
    '10000000': {
      'other': 'བྱེ་བ་ 0'
    },
    '100000000': {
      'other': 'དུང་ཕྱུར་ 0'
    },
    '1000000000': {
      'other': 'དུང་ཕྱུར་ 00'
    },
    '10000000000': {
      'other': 'དུང་ཕྱུར་བརྒྱ་ 0'
    },
    '100000000000': {
      'other': 'དུང་ཕྱུར་སྟོང 0'
    },
    '1000000000000': {
      'other': 'དུང་ཕྱུར་ཁྲི་ 0'
    },
    '10000000000000': {
      'other': 'དུང་ཕྱུར་འབུམ་ 0'
    },
    '100000000000000': {
      'other': 'དུང་ཕྱུར་ས་ཡ་ 0'
    }
  }
};


/**
 * Compact number formatting symbols for locale dz_BT.
 */
goog.i18n.CompactNumberFormatSymbols_dz_BT = goog.i18n.CompactNumberFormatSymbols_dz;


/**
 * Compact number formatting symbols for locale ebu.
 */
goog.i18n.CompactNumberFormatSymbols_ebu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ebu_KE.
 */
goog.i18n.CompactNumberFormatSymbols_ebu_KE = goog.i18n.CompactNumberFormatSymbols_ebu;


/**
 * Compact number formatting symbols for locale ee.
 */
goog.i18n.CompactNumberFormatSymbols_ee = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0000M'
    },
    '10000000000': {
      'other': '00000M'
    },
    '100000000000': {
      'other': '000000M'
    },
    '1000000000000': {
      'other': '0B'
    },
    '10000000000000': {
      'other': '00B'
    },
    '100000000000000': {
      'other': '000B'
    }
  }
};


/**
 * Compact number formatting symbols for locale ee_GH.
 */
goog.i18n.CompactNumberFormatSymbols_ee_GH = goog.i18n.CompactNumberFormatSymbols_ee;


/**
 * Compact number formatting symbols for locale ee_TG.
 */
goog.i18n.CompactNumberFormatSymbols_ee_TG = goog.i18n.CompactNumberFormatSymbols_ee;


/**
 * Compact number formatting symbols for locale el_CY.
 */
goog.i18n.CompactNumberFormatSymbols_el_CY = goog.i18n.CompactNumberFormatSymbols_el;


/**
 * Compact number formatting symbols for locale el_GR.
 */
goog.i18n.CompactNumberFormatSymbols_el_GR = goog.i18n.CompactNumberFormatSymbols_el;


/**
 * Compact number formatting symbols for locale en_001.
 */
goog.i18n.CompactNumberFormatSymbols_en_001 = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_150.
 */
goog.i18n.CompactNumberFormatSymbols_en_150 = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_AG.
 */
goog.i18n.CompactNumberFormatSymbols_en_AG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_AI.
 */
goog.i18n.CompactNumberFormatSymbols_en_AI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_AS.
 */
goog.i18n.CompactNumberFormatSymbols_en_AS = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_AT.
 */
goog.i18n.CompactNumberFormatSymbols_en_AT = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BB.
 */
goog.i18n.CompactNumberFormatSymbols_en_BB = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BE.
 */
goog.i18n.CompactNumberFormatSymbols_en_BE = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BI.
 */
goog.i18n.CompactNumberFormatSymbols_en_BI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BM.
 */
goog.i18n.CompactNumberFormatSymbols_en_BM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BS.
 */
goog.i18n.CompactNumberFormatSymbols_en_BS = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BW.
 */
goog.i18n.CompactNumberFormatSymbols_en_BW = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_BZ.
 */
goog.i18n.CompactNumberFormatSymbols_en_BZ = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CC.
 */
goog.i18n.CompactNumberFormatSymbols_en_CC = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CH.
 */
goog.i18n.CompactNumberFormatSymbols_en_CH = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CK.
 */
goog.i18n.CompactNumberFormatSymbols_en_CK = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CM.
 */
goog.i18n.CompactNumberFormatSymbols_en_CM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CX.
 */
goog.i18n.CompactNumberFormatSymbols_en_CX = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_CY.
 */
goog.i18n.CompactNumberFormatSymbols_en_CY = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_DE.
 */
goog.i18n.CompactNumberFormatSymbols_en_DE = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_DG.
 */
goog.i18n.CompactNumberFormatSymbols_en_DG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_DK.
 */
goog.i18n.CompactNumberFormatSymbols_en_DK = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_DM.
 */
goog.i18n.CompactNumberFormatSymbols_en_DM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_ER.
 */
goog.i18n.CompactNumberFormatSymbols_en_ER = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_FI.
 */
goog.i18n.CompactNumberFormatSymbols_en_FI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_FJ.
 */
goog.i18n.CompactNumberFormatSymbols_en_FJ = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_FK.
 */
goog.i18n.CompactNumberFormatSymbols_en_FK = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_FM.
 */
goog.i18n.CompactNumberFormatSymbols_en_FM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GD.
 */
goog.i18n.CompactNumberFormatSymbols_en_GD = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GG.
 */
goog.i18n.CompactNumberFormatSymbols_en_GG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GH.
 */
goog.i18n.CompactNumberFormatSymbols_en_GH = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GI.
 */
goog.i18n.CompactNumberFormatSymbols_en_GI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GM.
 */
goog.i18n.CompactNumberFormatSymbols_en_GM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GU.
 */
goog.i18n.CompactNumberFormatSymbols_en_GU = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_GY.
 */
goog.i18n.CompactNumberFormatSymbols_en_GY = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_HK.
 */
goog.i18n.CompactNumberFormatSymbols_en_HK = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_IL.
 */
goog.i18n.CompactNumberFormatSymbols_en_IL = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_IM.
 */
goog.i18n.CompactNumberFormatSymbols_en_IM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_IO.
 */
goog.i18n.CompactNumberFormatSymbols_en_IO = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_JE.
 */
goog.i18n.CompactNumberFormatSymbols_en_JE = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_JM.
 */
goog.i18n.CompactNumberFormatSymbols_en_JM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_KE.
 */
goog.i18n.CompactNumberFormatSymbols_en_KE = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_KI.
 */
goog.i18n.CompactNumberFormatSymbols_en_KI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_KN.
 */
goog.i18n.CompactNumberFormatSymbols_en_KN = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_KY.
 */
goog.i18n.CompactNumberFormatSymbols_en_KY = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_LC.
 */
goog.i18n.CompactNumberFormatSymbols_en_LC = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_LR.
 */
goog.i18n.CompactNumberFormatSymbols_en_LR = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_LS.
 */
goog.i18n.CompactNumberFormatSymbols_en_LS = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MG.
 */
goog.i18n.CompactNumberFormatSymbols_en_MG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MH.
 */
goog.i18n.CompactNumberFormatSymbols_en_MH = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MO.
 */
goog.i18n.CompactNumberFormatSymbols_en_MO = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MP.
 */
goog.i18n.CompactNumberFormatSymbols_en_MP = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MS.
 */
goog.i18n.CompactNumberFormatSymbols_en_MS = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MT.
 */
goog.i18n.CompactNumberFormatSymbols_en_MT = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MU.
 */
goog.i18n.CompactNumberFormatSymbols_en_MU = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MW.
 */
goog.i18n.CompactNumberFormatSymbols_en_MW = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_MY.
 */
goog.i18n.CompactNumberFormatSymbols_en_MY = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NA.
 */
goog.i18n.CompactNumberFormatSymbols_en_NA = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NF.
 */
goog.i18n.CompactNumberFormatSymbols_en_NF = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NG.
 */
goog.i18n.CompactNumberFormatSymbols_en_NG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NL.
 */
goog.i18n.CompactNumberFormatSymbols_en_NL = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NR.
 */
goog.i18n.CompactNumberFormatSymbols_en_NR = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NU.
 */
goog.i18n.CompactNumberFormatSymbols_en_NU = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_NZ.
 */
goog.i18n.CompactNumberFormatSymbols_en_NZ = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PG.
 */
goog.i18n.CompactNumberFormatSymbols_en_PG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PH.
 */
goog.i18n.CompactNumberFormatSymbols_en_PH = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PK.
 */
goog.i18n.CompactNumberFormatSymbols_en_PK = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PN.
 */
goog.i18n.CompactNumberFormatSymbols_en_PN = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PR.
 */
goog.i18n.CompactNumberFormatSymbols_en_PR = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_PW.
 */
goog.i18n.CompactNumberFormatSymbols_en_PW = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_RW.
 */
goog.i18n.CompactNumberFormatSymbols_en_RW = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SB.
 */
goog.i18n.CompactNumberFormatSymbols_en_SB = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SC.
 */
goog.i18n.CompactNumberFormatSymbols_en_SC = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SD.
 */
goog.i18n.CompactNumberFormatSymbols_en_SD = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SE.
 */
goog.i18n.CompactNumberFormatSymbols_en_SE = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SH.
 */
goog.i18n.CompactNumberFormatSymbols_en_SH = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SI.
 */
goog.i18n.CompactNumberFormatSymbols_en_SI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SL.
 */
goog.i18n.CompactNumberFormatSymbols_en_SL = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SS.
 */
goog.i18n.CompactNumberFormatSymbols_en_SS = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SX.
 */
goog.i18n.CompactNumberFormatSymbols_en_SX = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_SZ.
 */
goog.i18n.CompactNumberFormatSymbols_en_SZ = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_TC.
 */
goog.i18n.CompactNumberFormatSymbols_en_TC = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_TK.
 */
goog.i18n.CompactNumberFormatSymbols_en_TK = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_TO.
 */
goog.i18n.CompactNumberFormatSymbols_en_TO = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_TT.
 */
goog.i18n.CompactNumberFormatSymbols_en_TT = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_TV.
 */
goog.i18n.CompactNumberFormatSymbols_en_TV = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_en_TZ = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_UG.
 */
goog.i18n.CompactNumberFormatSymbols_en_UG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_UM.
 */
goog.i18n.CompactNumberFormatSymbols_en_UM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_US_POSIX.
 */
goog.i18n.CompactNumberFormatSymbols_en_US_POSIX = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_VC.
 */
goog.i18n.CompactNumberFormatSymbols_en_VC = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_VG.
 */
goog.i18n.CompactNumberFormatSymbols_en_VG = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_VI.
 */
goog.i18n.CompactNumberFormatSymbols_en_VI = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_VU.
 */
goog.i18n.CompactNumberFormatSymbols_en_VU = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_WS.
 */
goog.i18n.CompactNumberFormatSymbols_en_WS = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_XA.
 */
goog.i18n.CompactNumberFormatSymbols_en_XA = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_ZM.
 */
goog.i18n.CompactNumberFormatSymbols_en_ZM = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale en_ZW.
 */
goog.i18n.CompactNumberFormatSymbols_en_ZW = goog.i18n.CompactNumberFormatSymbols_en;


/**
 * Compact number formatting symbols for locale eo.
 */
goog.i18n.CompactNumberFormatSymbols_eo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_AR.
 */
goog.i18n.CompactNumberFormatSymbols_es_AR = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_BO.
 */
goog.i18n.CompactNumberFormatSymbols_es_BO = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_BR.
 */
goog.i18n.CompactNumberFormatSymbols_es_BR = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_CL.
 */
goog.i18n.CompactNumberFormatSymbols_es_CL = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_CO.
 */
goog.i18n.CompactNumberFormatSymbols_es_CO = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_CR.
 */
goog.i18n.CompactNumberFormatSymbols_es_CR = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_CU.
 */
goog.i18n.CompactNumberFormatSymbols_es_CU = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_DO.
 */
goog.i18n.CompactNumberFormatSymbols_es_DO = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_EA.
 */
goog.i18n.CompactNumberFormatSymbols_es_EA = goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_EC.
 */
goog.i18n.CompactNumberFormatSymbols_es_EC = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_GQ.
 */
goog.i18n.CompactNumberFormatSymbols_es_GQ = goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_GT.
 */
goog.i18n.CompactNumberFormatSymbols_es_GT = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_HN.
 */
goog.i18n.CompactNumberFormatSymbols_es_HN = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_IC.
 */
goog.i18n.CompactNumberFormatSymbols_es_IC = goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_NI.
 */
goog.i18n.CompactNumberFormatSymbols_es_NI = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_PA.
 */
goog.i18n.CompactNumberFormatSymbols_es_PA = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_PE.
 */
goog.i18n.CompactNumberFormatSymbols_es_PE = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_PH.
 */
goog.i18n.CompactNumberFormatSymbols_es_PH = goog.i18n.CompactNumberFormatSymbols_es;


/**
 * Compact number formatting symbols for locale es_PR.
 */
goog.i18n.CompactNumberFormatSymbols_es_PR = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_PY.
 */
goog.i18n.CompactNumberFormatSymbols_es_PY = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_SV.
 */
goog.i18n.CompactNumberFormatSymbols_es_SV = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_UY.
 */
goog.i18n.CompactNumberFormatSymbols_es_UY = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale es_VE.
 */
goog.i18n.CompactNumberFormatSymbols_es_VE = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000000': {
      'other': '0k M'
    },
    '10000000000': {
      'other': '00k M'
    },
    '100000000000': {
      'other': '000k M'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 millones'
    },
    '10000000': {
      'other': '00 millones'
    },
    '100000000': {
      'other': '000 millones'
    },
    '1000000000': {
      'other': '0 mil millones'
    },
    '10000000000': {
      'other': '00 mil millones'
    },
    '100000000000': {
      'other': '000 mil millones'
    },
    '1000000000000': {
      'other': '0 billones'
    },
    '10000000000000': {
      'other': '00 billones'
    },
    '100000000000000': {
      'other': '000 billones'
    }
  }
};


/**
 * Compact number formatting symbols for locale et_EE.
 */
goog.i18n.CompactNumberFormatSymbols_et_EE = goog.i18n.CompactNumberFormatSymbols_et;


/**
 * Compact number formatting symbols for locale eu_ES.
 */
goog.i18n.CompactNumberFormatSymbols_eu_ES = goog.i18n.CompactNumberFormatSymbols_eu;


/**
 * Compact number formatting symbols for locale ewo.
 */
goog.i18n.CompactNumberFormatSymbols_ewo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ewo_CM.
 */
goog.i18n.CompactNumberFormatSymbols_ewo_CM = goog.i18n.CompactNumberFormatSymbols_ewo;


/**
 * Compact number formatting symbols for locale fa_AF.
 */
goog.i18n.CompactNumberFormatSymbols_fa_AF = goog.i18n.CompactNumberFormatSymbols_fa;


/**
 * Compact number formatting symbols for locale fa_IR.
 */
goog.i18n.CompactNumberFormatSymbols_fa_IR = goog.i18n.CompactNumberFormatSymbols_fa;


/**
 * Compact number formatting symbols for locale ff.
 */
goog.i18n.CompactNumberFormatSymbols_ff = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ff_CM.
 */
goog.i18n.CompactNumberFormatSymbols_ff_CM = goog.i18n.CompactNumberFormatSymbols_ff;


/**
 * Compact number formatting symbols for locale ff_GN.
 */
goog.i18n.CompactNumberFormatSymbols_ff_GN = goog.i18n.CompactNumberFormatSymbols_ff;


/**
 * Compact number formatting symbols for locale ff_MR.
 */
goog.i18n.CompactNumberFormatSymbols_ff_MR = goog.i18n.CompactNumberFormatSymbols_ff;


/**
 * Compact number formatting symbols for locale ff_SN.
 */
goog.i18n.CompactNumberFormatSymbols_ff_SN = goog.i18n.CompactNumberFormatSymbols_ff;


/**
 * Compact number formatting symbols for locale fi_FI.
 */
goog.i18n.CompactNumberFormatSymbols_fi_FI = goog.i18n.CompactNumberFormatSymbols_fi;


/**
 * Compact number formatting symbols for locale fil_PH.
 */
goog.i18n.CompactNumberFormatSymbols_fil_PH = goog.i18n.CompactNumberFormatSymbols_fil;


/**
 * Compact number formatting symbols for locale fo.
 */
goog.i18n.CompactNumberFormatSymbols_fo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tús.'
    },
    '10000': {
      'other': '00 tús.'
    },
    '100000': {
      'other': '000 tús.'
    },
    '1000000': {
      'other': '0 mió.'
    },
    '10000000': {
      'other': '00 mió.'
    },
    '100000000': {
      'other': '000 mió.'
    },
    '1000000000': {
      'other': '0 mia.'
    },
    '10000000000': {
      'other': '00 mia.'
    },
    '100000000000': {
      'other': '000 mia.'
    },
    '1000000000000': {
      'other': '0 bió.'
    },
    '10000000000000': {
      'other': '00 bió.'
    },
    '100000000000000': {
      'other': '000 bió.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 túsund'
    },
    '10000': {
      'other': '00 túsund'
    },
    '100000': {
      'other': '000 túsund'
    },
    '1000000': {
      'other': '0 milliónir'
    },
    '10000000': {
      'other': '00 milliónir'
    },
    '100000000': {
      'other': '000 milliónir'
    },
    '1000000000': {
      'other': '0 milliardir'
    },
    '10000000000': {
      'other': '00 milliardir'
    },
    '100000000000': {
      'other': '000 milliardir'
    },
    '1000000000000': {
      'other': '0 billiónir'
    },
    '10000000000000': {
      'other': '00 billiónir'
    },
    '100000000000000': {
      'other': '000 billiónir'
    }
  }
};


/**
 * Compact number formatting symbols for locale fo_DK.
 */
goog.i18n.CompactNumberFormatSymbols_fo_DK = goog.i18n.CompactNumberFormatSymbols_fo;


/**
 * Compact number formatting symbols for locale fo_FO.
 */
goog.i18n.CompactNumberFormatSymbols_fo_FO = goog.i18n.CompactNumberFormatSymbols_fo;


/**
 * Compact number formatting symbols for locale fr_BE.
 */
goog.i18n.CompactNumberFormatSymbols_fr_BE = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_BF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_BF = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_BI.
 */
goog.i18n.CompactNumberFormatSymbols_fr_BI = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_BJ.
 */
goog.i18n.CompactNumberFormatSymbols_fr_BJ = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_BL.
 */
goog.i18n.CompactNumberFormatSymbols_fr_BL = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CD.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CD = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CF = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CG.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CG = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CH.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CH = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CI.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CI = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_CM.
 */
goog.i18n.CompactNumberFormatSymbols_fr_CM = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_DJ.
 */
goog.i18n.CompactNumberFormatSymbols_fr_DJ = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_DZ.
 */
goog.i18n.CompactNumberFormatSymbols_fr_DZ = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_FR.
 */
goog.i18n.CompactNumberFormatSymbols_fr_FR = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GA.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GA = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GF = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GN.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GN = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GP.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GP = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_GQ.
 */
goog.i18n.CompactNumberFormatSymbols_fr_GQ = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_HT.
 */
goog.i18n.CompactNumberFormatSymbols_fr_HT = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_KM.
 */
goog.i18n.CompactNumberFormatSymbols_fr_KM = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_LU.
 */
goog.i18n.CompactNumberFormatSymbols_fr_LU = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MA.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MA = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MC.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MC = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MF = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MG.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MG = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_ML.
 */
goog.i18n.CompactNumberFormatSymbols_fr_ML = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MQ.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MQ = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MR.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MR = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_MU.
 */
goog.i18n.CompactNumberFormatSymbols_fr_MU = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_NC.
 */
goog.i18n.CompactNumberFormatSymbols_fr_NC = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_NE.
 */
goog.i18n.CompactNumberFormatSymbols_fr_NE = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_PF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_PF = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_PM.
 */
goog.i18n.CompactNumberFormatSymbols_fr_PM = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_RE.
 */
goog.i18n.CompactNumberFormatSymbols_fr_RE = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_RW.
 */
goog.i18n.CompactNumberFormatSymbols_fr_RW = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_SC.
 */
goog.i18n.CompactNumberFormatSymbols_fr_SC = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_SN.
 */
goog.i18n.CompactNumberFormatSymbols_fr_SN = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_SY.
 */
goog.i18n.CompactNumberFormatSymbols_fr_SY = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_TD.
 */
goog.i18n.CompactNumberFormatSymbols_fr_TD = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_TG.
 */
goog.i18n.CompactNumberFormatSymbols_fr_TG = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_TN.
 */
goog.i18n.CompactNumberFormatSymbols_fr_TN = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_VU.
 */
goog.i18n.CompactNumberFormatSymbols_fr_VU = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_WF.
 */
goog.i18n.CompactNumberFormatSymbols_fr_WF = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fr_YT.
 */
goog.i18n.CompactNumberFormatSymbols_fr_YT = goog.i18n.CompactNumberFormatSymbols_fr;


/**
 * Compact number formatting symbols for locale fur.
 */
goog.i18n.CompactNumberFormatSymbols_fur = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale fur_IT.
 */
goog.i18n.CompactNumberFormatSymbols_fur_IT = goog.i18n.CompactNumberFormatSymbols_fur;


/**
 * Compact number formatting symbols for locale fy.
 */
goog.i18n.CompactNumberFormatSymbols_fy = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0 mln.'
    },
    '10000000': {
      'other': '00 mln.'
    },
    '100000000': {
      'other': '000 mln.'
    },
    '1000000000': {
      'other': '0 mld.'
    },
    '10000000000': {
      'other': '00 mld.'
    },
    '100000000000': {
      'other': '000 mld.'
    },
    '1000000000000': {
      'other': '0 bln.'
    },
    '10000000000000': {
      'other': '00 bln.'
    },
    '100000000000000': {
      'other': '000 bln.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tûzen'
    },
    '10000': {
      'other': '00 tûzen'
    },
    '100000': {
      'other': '000 tûzen'
    },
    '1000000': {
      'other': '0 miljoen'
    },
    '10000000': {
      'other': '00 miljoen'
    },
    '100000000': {
      'other': '000 miljoen'
    },
    '1000000000': {
      'other': '0 miljard'
    },
    '10000000000': {
      'other': '00 miljard'
    },
    '100000000000': {
      'other': '000 miljard'
    },
    '1000000000000': {
      'other': '0 biljoen'
    },
    '10000000000000': {
      'other': '00 biljoen'
    },
    '100000000000000': {
      'other': '000 biljoen'
    }
  }
};


/**
 * Compact number formatting symbols for locale fy_NL.
 */
goog.i18n.CompactNumberFormatSymbols_fy_NL = goog.i18n.CompactNumberFormatSymbols_fy;


/**
 * Compact number formatting symbols for locale ga_IE.
 */
goog.i18n.CompactNumberFormatSymbols_ga_IE = goog.i18n.CompactNumberFormatSymbols_ga;


/**
 * Compact number formatting symbols for locale gd.
 */
goog.i18n.CompactNumberFormatSymbols_gd = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mìle'
    },
    '10000': {
      'other': '00 mìle'
    },
    '100000': {
      'other': '000 mìle'
    },
    '1000000': {
      'other': '0 millean'
    },
    '10000000': {
      'other': '00 millean'
    },
    '100000000': {
      'other': '000 millean'
    },
    '1000000000': {
      'other': '0 billean'
    },
    '10000000000': {
      'other': '00 billean'
    },
    '100000000000': {
      'other': '000 bhillean'
    },
    '1000000000000': {
      'other': '0 trillean'
    },
    '10000000000000': {
      'other': '00 trillean'
    },
    '100000000000000': {
      'other': '000 trillean'
    }
  }
};


/**
 * Compact number formatting symbols for locale gd_GB.
 */
goog.i18n.CompactNumberFormatSymbols_gd_GB = goog.i18n.CompactNumberFormatSymbols_gd;


/**
 * Compact number formatting symbols for locale gl_ES.
 */
goog.i18n.CompactNumberFormatSymbols_gl_ES = goog.i18n.CompactNumberFormatSymbols_gl;


/**
 * Compact number formatting symbols for locale gsw_CH.
 */
goog.i18n.CompactNumberFormatSymbols_gsw_CH = goog.i18n.CompactNumberFormatSymbols_gsw;


/**
 * Compact number formatting symbols for locale gsw_FR.
 */
goog.i18n.CompactNumberFormatSymbols_gsw_FR = goog.i18n.CompactNumberFormatSymbols_gsw;


/**
 * Compact number formatting symbols for locale gsw_LI.
 */
goog.i18n.CompactNumberFormatSymbols_gsw_LI = goog.i18n.CompactNumberFormatSymbols_gsw;


/**
 * Compact number formatting symbols for locale gu_IN.
 */
goog.i18n.CompactNumberFormatSymbols_gu_IN = goog.i18n.CompactNumberFormatSymbols_gu;


/**
 * Compact number formatting symbols for locale guz.
 */
goog.i18n.CompactNumberFormatSymbols_guz = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale guz_KE.
 */
goog.i18n.CompactNumberFormatSymbols_guz_KE = goog.i18n.CompactNumberFormatSymbols_guz;


/**
 * Compact number formatting symbols for locale gv.
 */
goog.i18n.CompactNumberFormatSymbols_gv = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale gv_IM.
 */
goog.i18n.CompactNumberFormatSymbols_gv_IM = goog.i18n.CompactNumberFormatSymbols_gv;


/**
 * Compact number formatting symbols for locale ha.
 */
goog.i18n.CompactNumberFormatSymbols_ha = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0D'
    },
    '10000': {
      'other': '00D'
    },
    '100000': {
      'other': '000D'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': 'Dubu 0'
    },
    '10000': {
      'other': 'Dubu 00'
    },
    '100000': {
      'other': 'Dubu 000'
    },
    '1000000': {
      'other': 'Miliyan 0'
    },
    '10000000': {
      'other': 'Miliyan 00'
    },
    '100000000': {
      'other': 'Miliyan 000'
    },
    '1000000000': {
      'other': 'Biliyan 0'
    },
    '10000000000': {
      'other': 'Biliyan 00'
    },
    '100000000000': {
      'other': 'Biliyan 000'
    },
    '1000000000000': {
      'other': 'Triliyan 0'
    },
    '10000000000000': {
      'other': 'Triliyan 00'
    },
    '100000000000000': {
      'other': 'Triliyan 000'
    }
  }
};


/**
 * Compact number formatting symbols for locale ha_GH.
 */
goog.i18n.CompactNumberFormatSymbols_ha_GH = goog.i18n.CompactNumberFormatSymbols_ha;


/**
 * Compact number formatting symbols for locale ha_NE.
 */
goog.i18n.CompactNumberFormatSymbols_ha_NE = goog.i18n.CompactNumberFormatSymbols_ha;


/**
 * Compact number formatting symbols for locale ha_NG.
 */
goog.i18n.CompactNumberFormatSymbols_ha_NG = goog.i18n.CompactNumberFormatSymbols_ha;


/**
 * Compact number formatting symbols for locale haw_US.
 */
goog.i18n.CompactNumberFormatSymbols_haw_US = goog.i18n.CompactNumberFormatSymbols_haw;


/**
 * Compact number formatting symbols for locale he_IL.
 */
goog.i18n.CompactNumberFormatSymbols_he_IL = goog.i18n.CompactNumberFormatSymbols_he;


/**
 * Compact number formatting symbols for locale hi_IN.
 */
goog.i18n.CompactNumberFormatSymbols_hi_IN = goog.i18n.CompactNumberFormatSymbols_hi;


/**
 * Compact number formatting symbols for locale hr_BA.
 */
goog.i18n.CompactNumberFormatSymbols_hr_BA = goog.i18n.CompactNumberFormatSymbols_hr;


/**
 * Compact number formatting symbols for locale hr_HR.
 */
goog.i18n.CompactNumberFormatSymbols_hr_HR = goog.i18n.CompactNumberFormatSymbols_hr;


/**
 * Compact number formatting symbols for locale hsb.
 */
goog.i18n.CompactNumberFormatSymbols_hsb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tys.'
    },
    '10000': {
      'other': '00 tys.'
    },
    '100000': {
      'other': '000 tys.'
    },
    '1000000': {
      'other': '0 mio.'
    },
    '10000000': {
      'other': '00 mio.'
    },
    '100000000': {
      'other': '000 mio.'
    },
    '1000000000': {
      'other': '0 mrd.'
    },
    '10000000000': {
      'other': '00 mrd.'
    },
    '100000000000': {
      'other': '000 mrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tysac'
    },
    '10000': {
      'other': '00 tysac'
    },
    '100000': {
      'other': '000 tysac'
    },
    '1000000': {
      'other': '0 milionow'
    },
    '10000000': {
      'other': '00 milionow'
    },
    '100000000': {
      'other': '000 milionow'
    },
    '1000000000': {
      'other': '0 miliardow'
    },
    '10000000000': {
      'other': '00 miliardow'
    },
    '100000000000': {
      'other': '000 miliardow'
    },
    '1000000000000': {
      'other': '0 bilionow'
    },
    '10000000000000': {
      'other': '00 bilionow'
    },
    '100000000000000': {
      'other': '000 bilionow'
    }
  }
};


/**
 * Compact number formatting symbols for locale hsb_DE.
 */
goog.i18n.CompactNumberFormatSymbols_hsb_DE = goog.i18n.CompactNumberFormatSymbols_hsb;


/**
 * Compact number formatting symbols for locale hu_HU.
 */
goog.i18n.CompactNumberFormatSymbols_hu_HU = goog.i18n.CompactNumberFormatSymbols_hu;


/**
 * Compact number formatting symbols for locale hy_AM.
 */
goog.i18n.CompactNumberFormatSymbols_hy_AM = goog.i18n.CompactNumberFormatSymbols_hy;


/**
 * Compact number formatting symbols for locale id_ID.
 */
goog.i18n.CompactNumberFormatSymbols_id_ID = goog.i18n.CompactNumberFormatSymbols_id;


/**
 * Compact number formatting symbols for locale ig.
 */
goog.i18n.CompactNumberFormatSymbols_ig = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ig_NG.
 */
goog.i18n.CompactNumberFormatSymbols_ig_NG = goog.i18n.CompactNumberFormatSymbols_ig;


/**
 * Compact number formatting symbols for locale ii.
 */
goog.i18n.CompactNumberFormatSymbols_ii = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ii_CN.
 */
goog.i18n.CompactNumberFormatSymbols_ii_CN = goog.i18n.CompactNumberFormatSymbols_ii;


/**
 * Compact number formatting symbols for locale is_IS.
 */
goog.i18n.CompactNumberFormatSymbols_is_IS = goog.i18n.CompactNumberFormatSymbols_is;


/**
 * Compact number formatting symbols for locale it_CH.
 */
goog.i18n.CompactNumberFormatSymbols_it_CH = goog.i18n.CompactNumberFormatSymbols_it;


/**
 * Compact number formatting symbols for locale it_IT.
 */
goog.i18n.CompactNumberFormatSymbols_it_IT = goog.i18n.CompactNumberFormatSymbols_it;


/**
 * Compact number formatting symbols for locale it_SM.
 */
goog.i18n.CompactNumberFormatSymbols_it_SM = goog.i18n.CompactNumberFormatSymbols_it;


/**
 * Compact number formatting symbols for locale ja_JP.
 */
goog.i18n.CompactNumberFormatSymbols_ja_JP = goog.i18n.CompactNumberFormatSymbols_ja;


/**
 * Compact number formatting symbols for locale jgo.
 */
goog.i18n.CompactNumberFormatSymbols_jgo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale jgo_CM.
 */
goog.i18n.CompactNumberFormatSymbols_jgo_CM = goog.i18n.CompactNumberFormatSymbols_jgo;


/**
 * Compact number formatting symbols for locale jmc.
 */
goog.i18n.CompactNumberFormatSymbols_jmc = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale jmc_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_jmc_TZ = goog.i18n.CompactNumberFormatSymbols_jmc;


/**
 * Compact number formatting symbols for locale ka_GE.
 */
goog.i18n.CompactNumberFormatSymbols_ka_GE = goog.i18n.CompactNumberFormatSymbols_ka;


/**
 * Compact number formatting symbols for locale kab.
 */
goog.i18n.CompactNumberFormatSymbols_kab = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kab_DZ.
 */
goog.i18n.CompactNumberFormatSymbols_kab_DZ = goog.i18n.CompactNumberFormatSymbols_kab;


/**
 * Compact number formatting symbols for locale kam.
 */
goog.i18n.CompactNumberFormatSymbols_kam = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kam_KE.
 */
goog.i18n.CompactNumberFormatSymbols_kam_KE = goog.i18n.CompactNumberFormatSymbols_kam;


/**
 * Compact number formatting symbols for locale kde.
 */
goog.i18n.CompactNumberFormatSymbols_kde = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kde_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_kde_TZ = goog.i18n.CompactNumberFormatSymbols_kde;


/**
 * Compact number formatting symbols for locale kea.
 */
goog.i18n.CompactNumberFormatSymbols_kea = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 MM'
    },
    '10000000000': {
      'other': '00 MM'
    },
    '100000000000': {
      'other': '000 MM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 mil'
    },
    '10000': {
      'other': '00 mil'
    },
    '100000': {
      'other': '000 mil'
    },
    '1000000': {
      'other': '0 milhãu'
    },
    '10000000': {
      'other': '00 milhãu'
    },
    '100000000': {
      'other': '000 milhãu'
    },
    '1000000000': {
      'other': '0 mil milhãu'
    },
    '10000000000': {
      'other': '00 mil milhãu'
    },
    '100000000000': {
      'other': '000 mil milhãu'
    },
    '1000000000000': {
      'other': '0 bilhãu'
    },
    '10000000000000': {
      'other': '00 bilhãu'
    },
    '100000000000000': {
      'other': '000 bilhãu'
    }
  }
};


/**
 * Compact number formatting symbols for locale kea_CV.
 */
goog.i18n.CompactNumberFormatSymbols_kea_CV = goog.i18n.CompactNumberFormatSymbols_kea;


/**
 * Compact number formatting symbols for locale khq.
 */
goog.i18n.CompactNumberFormatSymbols_khq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale khq_ML.
 */
goog.i18n.CompactNumberFormatSymbols_khq_ML = goog.i18n.CompactNumberFormatSymbols_khq;


/**
 * Compact number formatting symbols for locale ki.
 */
goog.i18n.CompactNumberFormatSymbols_ki = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ki_KE.
 */
goog.i18n.CompactNumberFormatSymbols_ki_KE = goog.i18n.CompactNumberFormatSymbols_ki;


/**
 * Compact number formatting symbols for locale kk_KZ.
 */
goog.i18n.CompactNumberFormatSymbols_kk_KZ = goog.i18n.CompactNumberFormatSymbols_kk;


/**
 * Compact number formatting symbols for locale kkj.
 */
goog.i18n.CompactNumberFormatSymbols_kkj = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kkj_CM.
 */
goog.i18n.CompactNumberFormatSymbols_kkj_CM = goog.i18n.CompactNumberFormatSymbols_kkj;


/**
 * Compact number formatting symbols for locale kl.
 */
goog.i18n.CompactNumberFormatSymbols_kl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kl_GL.
 */
goog.i18n.CompactNumberFormatSymbols_kl_GL = goog.i18n.CompactNumberFormatSymbols_kl;


/**
 * Compact number formatting symbols for locale kln.
 */
goog.i18n.CompactNumberFormatSymbols_kln = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kln_KE.
 */
goog.i18n.CompactNumberFormatSymbols_kln_KE = goog.i18n.CompactNumberFormatSymbols_kln;


/**
 * Compact number formatting symbols for locale km_KH.
 */
goog.i18n.CompactNumberFormatSymbols_km_KH = goog.i18n.CompactNumberFormatSymbols_km;


/**
 * Compact number formatting symbols for locale kn_IN.
 */
goog.i18n.CompactNumberFormatSymbols_kn_IN = goog.i18n.CompactNumberFormatSymbols_kn;


/**
 * Compact number formatting symbols for locale ko_KP.
 */
goog.i18n.CompactNumberFormatSymbols_ko_KP = goog.i18n.CompactNumberFormatSymbols_ko;


/**
 * Compact number formatting symbols for locale ko_KR.
 */
goog.i18n.CompactNumberFormatSymbols_ko_KR = goog.i18n.CompactNumberFormatSymbols_ko;


/**
 * Compact number formatting symbols for locale kok.
 */
goog.i18n.CompactNumberFormatSymbols_kok = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kok_IN.
 */
goog.i18n.CompactNumberFormatSymbols_kok_IN = goog.i18n.CompactNumberFormatSymbols_kok;


/**
 * Compact number formatting symbols for locale ks.
 */
goog.i18n.CompactNumberFormatSymbols_ks = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ks_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ks_IN = goog.i18n.CompactNumberFormatSymbols_ks;


/**
 * Compact number formatting symbols for locale ksb.
 */
goog.i18n.CompactNumberFormatSymbols_ksb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ksb_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_ksb_TZ = goog.i18n.CompactNumberFormatSymbols_ksb;


/**
 * Compact number formatting symbols for locale ksf.
 */
goog.i18n.CompactNumberFormatSymbols_ksf = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ksf_CM.
 */
goog.i18n.CompactNumberFormatSymbols_ksf_CM = goog.i18n.CompactNumberFormatSymbols_ksf;


/**
 * Compact number formatting symbols for locale ksh.
 */
goog.i18n.CompactNumberFormatSymbols_ksh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 tsd'
    },
    '10000': {
      'other': '00 tsd'
    },
    '100000': {
      'other': '000 tsd'
    },
    '1000000': {
      'other': '0 Mio'
    },
    '10000000': {
      'other': '00 Mio'
    },
    '100000000': {
      'other': '000 Mio'
    },
    '1000000000': {
      'other': '0 Mrd'
    },
    '10000000000': {
      'other': '00 Mrd'
    },
    '100000000000': {
      'other': '000 Mrd'
    },
    '1000000000000': {
      'other': '0 Bio'
    },
    '10000000000000': {
      'other': '00 Bio'
    },
    '100000000000000': {
      'other': '000 Bio'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Dousend'
    },
    '10000': {
      'other': '00 Dousend'
    },
    '100000': {
      'other': '000 Dousend'
    },
    '1000000': {
      'other': '0 Milljuhne'
    },
    '10000000': {
      'other': '00 Millionen'
    },
    '100000000': {
      'other': '000 Millionen'
    },
    '1000000000': {
      'other': '0 Milljarde'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billjuhn'
    },
    '10000000000000': {
      'other': '00 Billionen'
    },
    '100000000000000': {
      'other': '000 Billionen'
    }
  }
};


/**
 * Compact number formatting symbols for locale ksh_DE.
 */
goog.i18n.CompactNumberFormatSymbols_ksh_DE = goog.i18n.CompactNumberFormatSymbols_ksh;


/**
 * Compact number formatting symbols for locale kw.
 */
goog.i18n.CompactNumberFormatSymbols_kw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale kw_GB.
 */
goog.i18n.CompactNumberFormatSymbols_kw_GB = goog.i18n.CompactNumberFormatSymbols_kw;


/**
 * Compact number formatting symbols for locale ky_KG.
 */
goog.i18n.CompactNumberFormatSymbols_ky_KG = goog.i18n.CompactNumberFormatSymbols_ky;


/**
 * Compact number formatting symbols for locale lag.
 */
goog.i18n.CompactNumberFormatSymbols_lag = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale lag_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_lag_TZ = goog.i18n.CompactNumberFormatSymbols_lag;


/**
 * Compact number formatting symbols for locale lb.
 */
goog.i18n.CompactNumberFormatSymbols_lb = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 Dsd.'
    },
    '10000': {
      'other': '00 Dsd.'
    },
    '100000': {
      'other': '000 Dsd.'
    },
    '1000000': {
      'other': '0 Mio.'
    },
    '10000000': {
      'other': '00 Mio.'
    },
    '100000000': {
      'other': '000 Mio.'
    },
    '1000000000': {
      'other': '0 Mrd.'
    },
    '10000000000': {
      'other': '00 Mrd.'
    },
    '100000000000': {
      'other': '000 Mrd.'
    },
    '1000000000000': {
      'other': '0 Bio.'
    },
    '10000000000000': {
      'other': '00 Bio.'
    },
    '100000000000000': {
      'other': '000 Bio.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 Dausend'
    },
    '10000': {
      'other': '00 Dausend'
    },
    '100000': {
      'other': '000 Dausend'
    },
    '1000000': {
      'other': '0 Milliounen'
    },
    '10000000': {
      'other': '00 Milliounen'
    },
    '100000000': {
      'other': '000 Milliounen'
    },
    '1000000000': {
      'other': '0 Milliarden'
    },
    '10000000000': {
      'other': '00 Milliarden'
    },
    '100000000000': {
      'other': '000 Milliarden'
    },
    '1000000000000': {
      'other': '0 Billiounen'
    },
    '10000000000000': {
      'other': '00 Billiounen'
    },
    '100000000000000': {
      'other': '000 Billiounen'
    }
  }
};


/**
 * Compact number formatting symbols for locale lb_LU.
 */
goog.i18n.CompactNumberFormatSymbols_lb_LU = goog.i18n.CompactNumberFormatSymbols_lb;


/**
 * Compact number formatting symbols for locale lg.
 */
goog.i18n.CompactNumberFormatSymbols_lg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale lg_UG.
 */
goog.i18n.CompactNumberFormatSymbols_lg_UG = goog.i18n.CompactNumberFormatSymbols_lg;


/**
 * Compact number formatting symbols for locale lkt.
 */
goog.i18n.CompactNumberFormatSymbols_lkt = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale lkt_US.
 */
goog.i18n.CompactNumberFormatSymbols_lkt_US = goog.i18n.CompactNumberFormatSymbols_lkt;


/**
 * Compact number formatting symbols for locale ln_AO.
 */
goog.i18n.CompactNumberFormatSymbols_ln_AO = goog.i18n.CompactNumberFormatSymbols_ln;


/**
 * Compact number formatting symbols for locale ln_CD.
 */
goog.i18n.CompactNumberFormatSymbols_ln_CD = goog.i18n.CompactNumberFormatSymbols_ln;


/**
 * Compact number formatting symbols for locale ln_CF.
 */
goog.i18n.CompactNumberFormatSymbols_ln_CF = goog.i18n.CompactNumberFormatSymbols_ln;


/**
 * Compact number formatting symbols for locale ln_CG.
 */
goog.i18n.CompactNumberFormatSymbols_ln_CG = goog.i18n.CompactNumberFormatSymbols_ln;


/**
 * Compact number formatting symbols for locale lo_LA.
 */
goog.i18n.CompactNumberFormatSymbols_lo_LA = goog.i18n.CompactNumberFormatSymbols_lo;


/**
 * Compact number formatting symbols for locale lrc.
 */
goog.i18n.CompactNumberFormatSymbols_lrc = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale lrc_IQ.
 */
goog.i18n.CompactNumberFormatSymbols_lrc_IQ = goog.i18n.CompactNumberFormatSymbols_lrc;


/**
 * Compact number formatting symbols for locale lrc_IR.
 */
goog.i18n.CompactNumberFormatSymbols_lrc_IR = goog.i18n.CompactNumberFormatSymbols_lrc;


/**
 * Compact number formatting symbols for locale lt_LT.
 */
goog.i18n.CompactNumberFormatSymbols_lt_LT = goog.i18n.CompactNumberFormatSymbols_lt;


/**
 * Compact number formatting symbols for locale lu.
 */
goog.i18n.CompactNumberFormatSymbols_lu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale lu_CD.
 */
goog.i18n.CompactNumberFormatSymbols_lu_CD = goog.i18n.CompactNumberFormatSymbols_lu;


/**
 * Compact number formatting symbols for locale luo.
 */
goog.i18n.CompactNumberFormatSymbols_luo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale luo_KE.
 */
goog.i18n.CompactNumberFormatSymbols_luo_KE = goog.i18n.CompactNumberFormatSymbols_luo;


/**
 * Compact number formatting symbols for locale luy.
 */
goog.i18n.CompactNumberFormatSymbols_luy = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale luy_KE.
 */
goog.i18n.CompactNumberFormatSymbols_luy_KE = goog.i18n.CompactNumberFormatSymbols_luy;


/**
 * Compact number formatting symbols for locale lv_LV.
 */
goog.i18n.CompactNumberFormatSymbols_lv_LV = goog.i18n.CompactNumberFormatSymbols_lv;


/**
 * Compact number formatting symbols for locale mas.
 */
goog.i18n.CompactNumberFormatSymbols_mas = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mas_KE.
 */
goog.i18n.CompactNumberFormatSymbols_mas_KE = goog.i18n.CompactNumberFormatSymbols_mas;


/**
 * Compact number formatting symbols for locale mas_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_mas_TZ = goog.i18n.CompactNumberFormatSymbols_mas;


/**
 * Compact number formatting symbols for locale mer.
 */
goog.i18n.CompactNumberFormatSymbols_mer = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mer_KE.
 */
goog.i18n.CompactNumberFormatSymbols_mer_KE = goog.i18n.CompactNumberFormatSymbols_mer;


/**
 * Compact number formatting symbols for locale mfe.
 */
goog.i18n.CompactNumberFormatSymbols_mfe = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mfe_MU.
 */
goog.i18n.CompactNumberFormatSymbols_mfe_MU = goog.i18n.CompactNumberFormatSymbols_mfe;


/**
 * Compact number formatting symbols for locale mg.
 */
goog.i18n.CompactNumberFormatSymbols_mg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mg_MG.
 */
goog.i18n.CompactNumberFormatSymbols_mg_MG = goog.i18n.CompactNumberFormatSymbols_mg;


/**
 * Compact number formatting symbols for locale mgh.
 */
goog.i18n.CompactNumberFormatSymbols_mgh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mgh_MZ.
 */
goog.i18n.CompactNumberFormatSymbols_mgh_MZ = goog.i18n.CompactNumberFormatSymbols_mgh;


/**
 * Compact number formatting symbols for locale mgo.
 */
goog.i18n.CompactNumberFormatSymbols_mgo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mgo_CM.
 */
goog.i18n.CompactNumberFormatSymbols_mgo_CM = goog.i18n.CompactNumberFormatSymbols_mgo;


/**
 * Compact number formatting symbols for locale mk_MK.
 */
goog.i18n.CompactNumberFormatSymbols_mk_MK = goog.i18n.CompactNumberFormatSymbols_mk;


/**
 * Compact number formatting symbols for locale ml_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ml_IN = goog.i18n.CompactNumberFormatSymbols_ml;


/**
 * Compact number formatting symbols for locale mn_MN.
 */
goog.i18n.CompactNumberFormatSymbols_mn_MN = goog.i18n.CompactNumberFormatSymbols_mn;


/**
 * Compact number formatting symbols for locale mr_IN.
 */
goog.i18n.CompactNumberFormatSymbols_mr_IN = goog.i18n.CompactNumberFormatSymbols_mr;


/**
 * Compact number formatting symbols for locale ms_BN.
 */
goog.i18n.CompactNumberFormatSymbols_ms_BN = goog.i18n.CompactNumberFormatSymbols_ms;


/**
 * Compact number formatting symbols for locale ms_MY.
 */
goog.i18n.CompactNumberFormatSymbols_ms_MY = goog.i18n.CompactNumberFormatSymbols_ms;


/**
 * Compact number formatting symbols for locale ms_SG.
 */
goog.i18n.CompactNumberFormatSymbols_ms_SG = goog.i18n.CompactNumberFormatSymbols_ms;


/**
 * Compact number formatting symbols for locale mt_MT.
 */
goog.i18n.CompactNumberFormatSymbols_mt_MT = goog.i18n.CompactNumberFormatSymbols_mt;


/**
 * Compact number formatting symbols for locale mua.
 */
goog.i18n.CompactNumberFormatSymbols_mua = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mua_CM.
 */
goog.i18n.CompactNumberFormatSymbols_mua_CM = goog.i18n.CompactNumberFormatSymbols_mua;


/**
 * Compact number formatting symbols for locale my_MM.
 */
goog.i18n.CompactNumberFormatSymbols_my_MM = goog.i18n.CompactNumberFormatSymbols_my;


/**
 * Compact number formatting symbols for locale mzn.
 */
goog.i18n.CompactNumberFormatSymbols_mzn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale mzn_IR.
 */
goog.i18n.CompactNumberFormatSymbols_mzn_IR = goog.i18n.CompactNumberFormatSymbols_mzn;


/**
 * Compact number formatting symbols for locale naq.
 */
goog.i18n.CompactNumberFormatSymbols_naq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale naq_NA.
 */
goog.i18n.CompactNumberFormatSymbols_naq_NA = goog.i18n.CompactNumberFormatSymbols_naq;


/**
 * Compact number formatting symbols for locale nb_NO.
 */
goog.i18n.CompactNumberFormatSymbols_nb_NO = goog.i18n.CompactNumberFormatSymbols_nb;


/**
 * Compact number formatting symbols for locale nb_SJ.
 */
goog.i18n.CompactNumberFormatSymbols_nb_SJ = goog.i18n.CompactNumberFormatSymbols_nb;


/**
 * Compact number formatting symbols for locale nd.
 */
goog.i18n.CompactNumberFormatSymbols_nd = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nd_ZW.
 */
goog.i18n.CompactNumberFormatSymbols_nd_ZW = goog.i18n.CompactNumberFormatSymbols_nd;


/**
 * Compact number formatting symbols for locale nds.
 */
goog.i18n.CompactNumberFormatSymbols_nds = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nds_DE.
 */
goog.i18n.CompactNumberFormatSymbols_nds_DE = goog.i18n.CompactNumberFormatSymbols_nds;


/**
 * Compact number formatting symbols for locale nds_NL.
 */
goog.i18n.CompactNumberFormatSymbols_nds_NL = goog.i18n.CompactNumberFormatSymbols_nds;


/**
 * Compact number formatting symbols for locale ne_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ne_IN = goog.i18n.CompactNumberFormatSymbols_ne;


/**
 * Compact number formatting symbols for locale ne_NP.
 */
goog.i18n.CompactNumberFormatSymbols_ne_NP = goog.i18n.CompactNumberFormatSymbols_ne;


/**
 * Compact number formatting symbols for locale nl_AW.
 */
goog.i18n.CompactNumberFormatSymbols_nl_AW = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nl_BE.
 */
goog.i18n.CompactNumberFormatSymbols_nl_BE = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nl_BQ.
 */
goog.i18n.CompactNumberFormatSymbols_nl_BQ = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nl_CW.
 */
goog.i18n.CompactNumberFormatSymbols_nl_CW = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nl_NL.
 */
goog.i18n.CompactNumberFormatSymbols_nl_NL = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nl_SR.
 */
goog.i18n.CompactNumberFormatSymbols_nl_SR = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nl_SX.
 */
goog.i18n.CompactNumberFormatSymbols_nl_SX = goog.i18n.CompactNumberFormatSymbols_nl;


/**
 * Compact number formatting symbols for locale nmg.
 */
goog.i18n.CompactNumberFormatSymbols_nmg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nmg_CM.
 */
goog.i18n.CompactNumberFormatSymbols_nmg_CM = goog.i18n.CompactNumberFormatSymbols_nmg;


/**
 * Compact number formatting symbols for locale nn.
 */
goog.i18n.CompactNumberFormatSymbols_nn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nn_NO.
 */
goog.i18n.CompactNumberFormatSymbols_nn_NO = goog.i18n.CompactNumberFormatSymbols_nn;


/**
 * Compact number formatting symbols for locale nnh.
 */
goog.i18n.CompactNumberFormatSymbols_nnh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nnh_CM.
 */
goog.i18n.CompactNumberFormatSymbols_nnh_CM = goog.i18n.CompactNumberFormatSymbols_nnh;


/**
 * Compact number formatting symbols for locale nus.
 */
goog.i18n.CompactNumberFormatSymbols_nus = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nus_SS.
 */
goog.i18n.CompactNumberFormatSymbols_nus_SS = goog.i18n.CompactNumberFormatSymbols_nus;


/**
 * Compact number formatting symbols for locale nyn.
 */
goog.i18n.CompactNumberFormatSymbols_nyn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale nyn_UG.
 */
goog.i18n.CompactNumberFormatSymbols_nyn_UG = goog.i18n.CompactNumberFormatSymbols_nyn;


/**
 * Compact number formatting symbols for locale om.
 */
goog.i18n.CompactNumberFormatSymbols_om = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale om_ET.
 */
goog.i18n.CompactNumberFormatSymbols_om_ET = goog.i18n.CompactNumberFormatSymbols_om;


/**
 * Compact number formatting symbols for locale om_KE.
 */
goog.i18n.CompactNumberFormatSymbols_om_KE = goog.i18n.CompactNumberFormatSymbols_om;


/**
 * Compact number formatting symbols for locale or_IN.
 */
goog.i18n.CompactNumberFormatSymbols_or_IN = goog.i18n.CompactNumberFormatSymbols_or;


/**
 * Compact number formatting symbols for locale os.
 */
goog.i18n.CompactNumberFormatSymbols_os = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale os_GE.
 */
goog.i18n.CompactNumberFormatSymbols_os_GE = goog.i18n.CompactNumberFormatSymbols_os;


/**
 * Compact number formatting symbols for locale os_RU.
 */
goog.i18n.CompactNumberFormatSymbols_os_RU = goog.i18n.CompactNumberFormatSymbols_os;


/**
 * Compact number formatting symbols for locale pa_Arab.
 */
goog.i18n.CompactNumberFormatSymbols_pa_Arab = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale pa_Arab_PK.
 */
goog.i18n.CompactNumberFormatSymbols_pa_Arab_PK = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale pa_Guru.
 */
goog.i18n.CompactNumberFormatSymbols_pa_Guru = goog.i18n.CompactNumberFormatSymbols_pa;


/**
 * Compact number formatting symbols for locale pa_Guru_IN.
 */
goog.i18n.CompactNumberFormatSymbols_pa_Guru_IN = goog.i18n.CompactNumberFormatSymbols_pa;


/**
 * Compact number formatting symbols for locale pl_PL.
 */
goog.i18n.CompactNumberFormatSymbols_pl_PL = goog.i18n.CompactNumberFormatSymbols_pl;


/**
 * Compact number formatting symbols for locale ps.
 */
goog.i18n.CompactNumberFormatSymbols_ps = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ps_AF.
 */
goog.i18n.CompactNumberFormatSymbols_ps_AF = goog.i18n.CompactNumberFormatSymbols_ps;


/**
 * Compact number formatting symbols for locale pt_AO.
 */
goog.i18n.CompactNumberFormatSymbols_pt_AO = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_CH.
 */
goog.i18n.CompactNumberFormatSymbols_pt_CH = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_CV.
 */
goog.i18n.CompactNumberFormatSymbols_pt_CV = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_GQ.
 */
goog.i18n.CompactNumberFormatSymbols_pt_GQ = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_GW.
 */
goog.i18n.CompactNumberFormatSymbols_pt_GW = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_LU.
 */
goog.i18n.CompactNumberFormatSymbols_pt_LU = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_MO.
 */
goog.i18n.CompactNumberFormatSymbols_pt_MO = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_MZ.
 */
goog.i18n.CompactNumberFormatSymbols_pt_MZ = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_ST.
 */
goog.i18n.CompactNumberFormatSymbols_pt_ST = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale pt_TL.
 */
goog.i18n.CompactNumberFormatSymbols_pt_TL = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000': {
      'other': '0 M'
    },
    '10000000': {
      'other': '00 M'
    },
    '100000000': {
      'other': '000 M'
    },
    '1000000000': {
      'other': '0 mM'
    },
    '10000000000': {
      'other': '00 mM'
    },
    '100000000000': {
      'other': '000 mM'
    },
    '1000000000000': {
      'other': '0 Bi'
    },
    '10000000000000': {
      'other': '00 Bi'
    },
    '100000000000000': {
      'other': '000 Bi'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000': {
      'other': '0 milhões'
    },
    '10000000': {
      'other': '00 milhões'
    },
    '100000000': {
      'other': '000 milhões'
    },
    '1000000000': {
      'other': '0 mil milhões'
    },
    '10000000000': {
      'other': '00 mil milhões'
    },
    '100000000000': {
      'other': '000 mil milhões'
    },
    '1000000000000': {
      'other': '0 biliões'
    },
    '10000000000000': {
      'other': '00 biliões'
    },
    '100000000000000': {
      'other': '000 biliões'
    }
  }
};


/**
 * Compact number formatting symbols for locale qu.
 */
goog.i18n.CompactNumberFormatSymbols_qu = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale qu_BO.
 */
goog.i18n.CompactNumberFormatSymbols_qu_BO = goog.i18n.CompactNumberFormatSymbols_qu;


/**
 * Compact number formatting symbols for locale qu_EC.
 */
goog.i18n.CompactNumberFormatSymbols_qu_EC = goog.i18n.CompactNumberFormatSymbols_qu;


/**
 * Compact number formatting symbols for locale qu_PE.
 */
goog.i18n.CompactNumberFormatSymbols_qu_PE = goog.i18n.CompactNumberFormatSymbols_qu;


/**
 * Compact number formatting symbols for locale rm.
 */
goog.i18n.CompactNumberFormatSymbols_rm = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale rm_CH.
 */
goog.i18n.CompactNumberFormatSymbols_rm_CH = goog.i18n.CompactNumberFormatSymbols_rm;


/**
 * Compact number formatting symbols for locale rn.
 */
goog.i18n.CompactNumberFormatSymbols_rn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale rn_BI.
 */
goog.i18n.CompactNumberFormatSymbols_rn_BI = goog.i18n.CompactNumberFormatSymbols_rn;


/**
 * Compact number formatting symbols for locale ro_MD.
 */
goog.i18n.CompactNumberFormatSymbols_ro_MD = goog.i18n.CompactNumberFormatSymbols_ro;


/**
 * Compact number formatting symbols for locale ro_RO.
 */
goog.i18n.CompactNumberFormatSymbols_ro_RO = goog.i18n.CompactNumberFormatSymbols_ro;


/**
 * Compact number formatting symbols for locale rof.
 */
goog.i18n.CompactNumberFormatSymbols_rof = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale rof_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_rof_TZ = goog.i18n.CompactNumberFormatSymbols_rof;


/**
 * Compact number formatting symbols for locale ru_BY.
 */
goog.i18n.CompactNumberFormatSymbols_ru_BY = goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale ru_KG.
 */
goog.i18n.CompactNumberFormatSymbols_ru_KG = goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale ru_KZ.
 */
goog.i18n.CompactNumberFormatSymbols_ru_KZ = goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale ru_MD.
 */
goog.i18n.CompactNumberFormatSymbols_ru_MD = goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale ru_RU.
 */
goog.i18n.CompactNumberFormatSymbols_ru_RU = goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale ru_UA.
 */
goog.i18n.CompactNumberFormatSymbols_ru_UA = goog.i18n.CompactNumberFormatSymbols_ru;


/**
 * Compact number formatting symbols for locale rw.
 */
goog.i18n.CompactNumberFormatSymbols_rw = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale rw_RW.
 */
goog.i18n.CompactNumberFormatSymbols_rw_RW = goog.i18n.CompactNumberFormatSymbols_rw;


/**
 * Compact number formatting symbols for locale rwk.
 */
goog.i18n.CompactNumberFormatSymbols_rwk = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale rwk_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_rwk_TZ = goog.i18n.CompactNumberFormatSymbols_rwk;


/**
 * Compact number formatting symbols for locale sah.
 */
goog.i18n.CompactNumberFormatSymbols_sah = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 тыһ.'
    },
    '10000': {
      'other': '00 тыһ.'
    },
    '100000': {
      'other': '000 тыһ.'
    },
    '1000000': {
      'other': '0 мөл'
    },
    '10000000': {
      'other': '00 мөл'
    },
    '100000000': {
      'other': '000 мөл'
    },
    '1000000000': {
      'other': '0 млрд'
    },
    '10000000000': {
      'other': '00 млрд'
    },
    '100000000000': {
      'other': '000 млрд'
    },
    '1000000000000': {
      'other': '0 трлн'
    },
    '10000000000000': {
      'other': '00 трлн'
    },
    '100000000000000': {
      'other': '000 трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 тыһыынча'
    },
    '10000': {
      'other': '00 тыһыынча'
    },
    '100000': {
      'other': '000 тыһыынча'
    },
    '1000000': {
      'other': '0 мөлүйүөн'
    },
    '10000000': {
      'other': '00 мөлүйүөн'
    },
    '100000000': {
      'other': '000 мөлүйүөн'
    },
    '1000000000': {
      'other': '0 миллиард'
    },
    '10000000000': {
      'other': '00 миллиард'
    },
    '100000000000': {
      'other': '000 миллиард'
    },
    '1000000000000': {
      'other': '0 триллион'
    },
    '10000000000000': {
      'other': '00 триллион'
    },
    '100000000000000': {
      'other': '000 триллион'
    }
  }
};


/**
 * Compact number formatting symbols for locale sah_RU.
 */
goog.i18n.CompactNumberFormatSymbols_sah_RU = goog.i18n.CompactNumberFormatSymbols_sah;


/**
 * Compact number formatting symbols for locale saq.
 */
goog.i18n.CompactNumberFormatSymbols_saq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale saq_KE.
 */
goog.i18n.CompactNumberFormatSymbols_saq_KE = goog.i18n.CompactNumberFormatSymbols_saq;


/**
 * Compact number formatting symbols for locale sbp.
 */
goog.i18n.CompactNumberFormatSymbols_sbp = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale sbp_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_sbp_TZ = goog.i18n.CompactNumberFormatSymbols_sbp;


/**
 * Compact number formatting symbols for locale se.
 */
goog.i18n.CompactNumberFormatSymbols_se = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 dt'
    },
    '10000': {
      'other': '00 dt'
    },
    '100000': {
      'other': '000 dt'
    },
    '1000000': {
      'other': '0 mn'
    },
    '10000000': {
      'other': '00 mn'
    },
    '100000000': {
      'other': '000 mn'
    },
    '1000000000': {
      'other': '0 md'
    },
    '10000000000': {
      'other': '00 md'
    },
    '100000000000': {
      'other': '000 md'
    },
    '1000000000000': {
      'other': '0 bn'
    },
    '10000000000000': {
      'other': '00 bn'
    },
    '100000000000000': {
      'other': '000 bn'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 duháhat'
    },
    '10000': {
      'other': '00 duháhat'
    },
    '100000': {
      'other': '000 duháhat'
    },
    '1000000': {
      'other': '0 miljonat'
    },
    '10000000': {
      'other': '00 miljonat'
    },
    '100000000': {
      'other': '000 miljonat'
    },
    '1000000000': {
      'other': '0 miljardit'
    },
    '10000000000': {
      'other': '00 miljardit'
    },
    '100000000000': {
      'other': '000 miljardit'
    },
    '1000000000000': {
      'other': '0 biljonat'
    },
    '10000000000000': {
      'other': '00 biljonat'
    },
    '100000000000000': {
      'other': '000 biljonat'
    }
  }
};


/**
 * Compact number formatting symbols for locale se_FI.
 */
goog.i18n.CompactNumberFormatSymbols_se_FI = goog.i18n.CompactNumberFormatSymbols_se;


/**
 * Compact number formatting symbols for locale se_NO.
 */
goog.i18n.CompactNumberFormatSymbols_se_NO = goog.i18n.CompactNumberFormatSymbols_se;


/**
 * Compact number formatting symbols for locale se_SE.
 */
goog.i18n.CompactNumberFormatSymbols_se_SE = goog.i18n.CompactNumberFormatSymbols_se;


/**
 * Compact number formatting symbols for locale seh.
 */
goog.i18n.CompactNumberFormatSymbols_seh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale seh_MZ.
 */
goog.i18n.CompactNumberFormatSymbols_seh_MZ = goog.i18n.CompactNumberFormatSymbols_seh;


/**
 * Compact number formatting symbols for locale ses.
 */
goog.i18n.CompactNumberFormatSymbols_ses = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ses_ML.
 */
goog.i18n.CompactNumberFormatSymbols_ses_ML = goog.i18n.CompactNumberFormatSymbols_ses;


/**
 * Compact number formatting symbols for locale sg.
 */
goog.i18n.CompactNumberFormatSymbols_sg = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale sg_CF.
 */
goog.i18n.CompactNumberFormatSymbols_sg_CF = goog.i18n.CompactNumberFormatSymbols_sg;


/**
 * Compact number formatting symbols for locale shi.
 */
goog.i18n.CompactNumberFormatSymbols_shi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale shi_Latn.
 */
goog.i18n.CompactNumberFormatSymbols_shi_Latn = goog.i18n.CompactNumberFormatSymbols_shi;


/**
 * Compact number formatting symbols for locale shi_Latn_MA.
 */
goog.i18n.CompactNumberFormatSymbols_shi_Latn_MA = goog.i18n.CompactNumberFormatSymbols_shi;


/**
 * Compact number formatting symbols for locale shi_Tfng.
 */
goog.i18n.CompactNumberFormatSymbols_shi_Tfng = goog.i18n.CompactNumberFormatSymbols_shi;


/**
 * Compact number formatting symbols for locale shi_Tfng_MA.
 */
goog.i18n.CompactNumberFormatSymbols_shi_Tfng_MA = goog.i18n.CompactNumberFormatSymbols_shi;


/**
 * Compact number formatting symbols for locale si_LK.
 */
goog.i18n.CompactNumberFormatSymbols_si_LK = goog.i18n.CompactNumberFormatSymbols_si;


/**
 * Compact number formatting symbols for locale sk_SK.
 */
goog.i18n.CompactNumberFormatSymbols_sk_SK = goog.i18n.CompactNumberFormatSymbols_sk;


/**
 * Compact number formatting symbols for locale sl_SI.
 */
goog.i18n.CompactNumberFormatSymbols_sl_SI = goog.i18n.CompactNumberFormatSymbols_sl;


/**
 * Compact number formatting symbols for locale smn.
 */
goog.i18n.CompactNumberFormatSymbols_smn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 tuhháát'
    },
    '10000': {
      'other': '00 tuhháát'
    },
    '100000': {
      'other': '000 tuhháát'
    },
    '1000000': {
      'other': '0 miljovn'
    },
    '10000000': {
      'other': '00 miljovn'
    },
    '100000000': {
      'other': '000 miljovn'
    },
    '1000000000': {
      'other': '0 miljard'
    },
    '10000000000': {
      'other': '00 miljard'
    },
    '100000000000': {
      'other': '000 miljard'
    },
    '1000000000000': {
      'other': '0 biljovn'
    },
    '10000000000000': {
      'other': '00 biljovn'
    },
    '100000000000000': {
      'other': '000 biljovn'
    }
  }
};


/**
 * Compact number formatting symbols for locale smn_FI.
 */
goog.i18n.CompactNumberFormatSymbols_smn_FI = goog.i18n.CompactNumberFormatSymbols_smn;


/**
 * Compact number formatting symbols for locale sn.
 */
goog.i18n.CompactNumberFormatSymbols_sn = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale sn_ZW.
 */
goog.i18n.CompactNumberFormatSymbols_sn_ZW = goog.i18n.CompactNumberFormatSymbols_sn;


/**
 * Compact number formatting symbols for locale so.
 */
goog.i18n.CompactNumberFormatSymbols_so = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    }
  }
};


/**
 * Compact number formatting symbols for locale so_DJ.
 */
goog.i18n.CompactNumberFormatSymbols_so_DJ = goog.i18n.CompactNumberFormatSymbols_so;


/**
 * Compact number formatting symbols for locale so_ET.
 */
goog.i18n.CompactNumberFormatSymbols_so_ET = goog.i18n.CompactNumberFormatSymbols_so;


/**
 * Compact number formatting symbols for locale so_KE.
 */
goog.i18n.CompactNumberFormatSymbols_so_KE = goog.i18n.CompactNumberFormatSymbols_so;


/**
 * Compact number formatting symbols for locale so_SO.
 */
goog.i18n.CompactNumberFormatSymbols_so_SO = goog.i18n.CompactNumberFormatSymbols_so;


/**
 * Compact number formatting symbols for locale sq_AL.
 */
goog.i18n.CompactNumberFormatSymbols_sq_AL = goog.i18n.CompactNumberFormatSymbols_sq;


/**
 * Compact number formatting symbols for locale sq_MK.
 */
goog.i18n.CompactNumberFormatSymbols_sq_MK = goog.i18n.CompactNumberFormatSymbols_sq;


/**
 * Compact number formatting symbols for locale sq_XK.
 */
goog.i18n.CompactNumberFormatSymbols_sq_XK = goog.i18n.CompactNumberFormatSymbols_sq;


/**
 * Compact number formatting symbols for locale sr_Cyrl.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Cyrl = goog.i18n.CompactNumberFormatSymbols_sr;


/**
 * Compact number formatting symbols for locale sr_Cyrl_BA.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_BA = goog.i18n.CompactNumberFormatSymbols_sr;


/**
 * Compact number formatting symbols for locale sr_Cyrl_ME.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_ME = goog.i18n.CompactNumberFormatSymbols_sr;


/**
 * Compact number formatting symbols for locale sr_Cyrl_RS.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_RS = goog.i18n.CompactNumberFormatSymbols_sr;


/**
 * Compact number formatting symbols for locale sr_Cyrl_XK.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_XK = goog.i18n.CompactNumberFormatSymbols_sr;


/**
 * Compact number formatting symbols for locale sr_Latn_BA.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Latn_BA = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale sr_Latn_ME.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Latn_ME = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale sr_Latn_RS.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Latn_RS = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale sr_Latn_XK.
 */
goog.i18n.CompactNumberFormatSymbols_sr_Latn_XK = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0 hilj.'
    },
    '10000': {
      'other': '00 hilj.'
    },
    '100000': {
      'other': '000 hilj.'
    },
    '1000000': {
      'other': '0 mil.'
    },
    '10000000': {
      'other': '00 mil.'
    },
    '100000000': {
      'other': '000 mil.'
    },
    '1000000000': {
      'other': '0 mlrd.'
    },
    '10000000000': {
      'other': '00 mlrd.'
    },
    '100000000000': {
      'other': '000 mlrd.'
    },
    '1000000000000': {
      'other': '0 bil.'
    },
    '10000000000000': {
      'other': '00 bil.'
    },
    '100000000000000': {
      'other': '000 bil.'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 hiljada'
    },
    '10000': {
      'other': '00 hiljada'
    },
    '100000': {
      'other': '000 hiljada'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 milijardi'
    },
    '10000000000': {
      'other': '00 milijardi'
    },
    '100000000000': {
      'other': '000 milijardi'
    },
    '1000000000000': {
      'other': '0 biliona'
    },
    '10000000000000': {
      'other': '00 biliona'
    },
    '100000000000000': {
      'other': '000 biliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale sv_AX.
 */
goog.i18n.CompactNumberFormatSymbols_sv_AX = goog.i18n.CompactNumberFormatSymbols_sv;


/**
 * Compact number formatting symbols for locale sv_FI.
 */
goog.i18n.CompactNumberFormatSymbols_sv_FI = goog.i18n.CompactNumberFormatSymbols_sv;


/**
 * Compact number formatting symbols for locale sv_SE.
 */
goog.i18n.CompactNumberFormatSymbols_sv_SE = goog.i18n.CompactNumberFormatSymbols_sv;


/**
 * Compact number formatting symbols for locale sw_CD.
 */
goog.i18n.CompactNumberFormatSymbols_sw_CD = goog.i18n.CompactNumberFormatSymbols_sw;


/**
 * Compact number formatting symbols for locale sw_KE.
 */
goog.i18n.CompactNumberFormatSymbols_sw_KE = goog.i18n.CompactNumberFormatSymbols_sw;


/**
 * Compact number formatting symbols for locale sw_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_sw_TZ = goog.i18n.CompactNumberFormatSymbols_sw;


/**
 * Compact number formatting symbols for locale sw_UG.
 */
goog.i18n.CompactNumberFormatSymbols_sw_UG = goog.i18n.CompactNumberFormatSymbols_sw;


/**
 * Compact number formatting symbols for locale ta_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ta_IN = goog.i18n.CompactNumberFormatSymbols_ta;


/**
 * Compact number formatting symbols for locale ta_LK.
 */
goog.i18n.CompactNumberFormatSymbols_ta_LK = goog.i18n.CompactNumberFormatSymbols_ta;


/**
 * Compact number formatting symbols for locale ta_MY.
 */
goog.i18n.CompactNumberFormatSymbols_ta_MY = goog.i18n.CompactNumberFormatSymbols_ta;


/**
 * Compact number formatting symbols for locale ta_SG.
 */
goog.i18n.CompactNumberFormatSymbols_ta_SG = goog.i18n.CompactNumberFormatSymbols_ta;


/**
 * Compact number formatting symbols for locale te_IN.
 */
goog.i18n.CompactNumberFormatSymbols_te_IN = goog.i18n.CompactNumberFormatSymbols_te;


/**
 * Compact number formatting symbols for locale teo.
 */
goog.i18n.CompactNumberFormatSymbols_teo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale teo_KE.
 */
goog.i18n.CompactNumberFormatSymbols_teo_KE = goog.i18n.CompactNumberFormatSymbols_teo;


/**
 * Compact number formatting symbols for locale teo_UG.
 */
goog.i18n.CompactNumberFormatSymbols_teo_UG = goog.i18n.CompactNumberFormatSymbols_teo;


/**
 * Compact number formatting symbols for locale th_TH.
 */
goog.i18n.CompactNumberFormatSymbols_th_TH = goog.i18n.CompactNumberFormatSymbols_th;


/**
 * Compact number formatting symbols for locale ti.
 */
goog.i18n.CompactNumberFormatSymbols_ti = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale ti_ER.
 */
goog.i18n.CompactNumberFormatSymbols_ti_ER = goog.i18n.CompactNumberFormatSymbols_ti;


/**
 * Compact number formatting symbols for locale ti_ET.
 */
goog.i18n.CompactNumberFormatSymbols_ti_ET = goog.i18n.CompactNumberFormatSymbols_ti;


/**
 * Compact number formatting symbols for locale to.
 */
goog.i18n.CompactNumberFormatSymbols_to = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0k'
    },
    '10000': {
      'other': '00k'
    },
    '100000': {
      'other': '000k'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0Ki'
    },
    '10000000000': {
      'other': '00Ki'
    },
    '100000000000': {
      'other': '000Ki'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 afe'
    },
    '10000': {
      'other': '0 mano'
    },
    '100000': {
      'other': '0 kilu'
    },
    '1000000': {
      'other': '0 miliona'
    },
    '10000000': {
      'other': '00 miliona'
    },
    '100000000': {
      'other': '000 miliona'
    },
    '1000000000': {
      'other': '0 piliona'
    },
    '10000000000': {
      'other': '00 piliona'
    },
    '100000000000': {
      'other': '000 piliona'
    },
    '1000000000000': {
      'other': '0 tiliona'
    },
    '10000000000000': {
      'other': '00 tiliona'
    },
    '100000000000000': {
      'other': '000 tiliona'
    }
  }
};


/**
 * Compact number formatting symbols for locale to_TO.
 */
goog.i18n.CompactNumberFormatSymbols_to_TO = goog.i18n.CompactNumberFormatSymbols_to;


/**
 * Compact number formatting symbols for locale tr_CY.
 */
goog.i18n.CompactNumberFormatSymbols_tr_CY = goog.i18n.CompactNumberFormatSymbols_tr;


/**
 * Compact number formatting symbols for locale tr_TR.
 */
goog.i18n.CompactNumberFormatSymbols_tr_TR = goog.i18n.CompactNumberFormatSymbols_tr;


/**
 * Compact number formatting symbols for locale twq.
 */
goog.i18n.CompactNumberFormatSymbols_twq = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale twq_NE.
 */
goog.i18n.CompactNumberFormatSymbols_twq_NE = goog.i18n.CompactNumberFormatSymbols_twq;


/**
 * Compact number formatting symbols for locale tzm.
 */
goog.i18n.CompactNumberFormatSymbols_tzm = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale tzm_MA.
 */
goog.i18n.CompactNumberFormatSymbols_tzm_MA = goog.i18n.CompactNumberFormatSymbols_tzm;


/**
 * Compact number formatting symbols for locale ug.
 */
goog.i18n.CompactNumberFormatSymbols_ug = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0مىڭ'
    },
    '10000': {
      'other': '00مىڭ'
    },
    '100000': {
      'other': '000مىڭ'
    },
    '1000000': {
      'other': '0مىليون'
    },
    '10000000': {
      'other': '00مىليون'
    },
    '100000000': {
      'other': '000مىليون'
    },
    '1000000000': {
      'other': '0مىليارد'
    },
    '10000000000': {
      'other': '00مىليارد'
    },
    '100000000000': {
      'other': '000مىليارد'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 مىڭ'
    },
    '10000': {
      'other': '00 مىڭ'
    },
    '100000': {
      'other': '000 مىڭ'
    },
    '1000000': {
      'other': '0 مىليون'
    },
    '10000000': {
      'other': '00 مىليون'
    },
    '100000000': {
      'other': '000 مىليون'
    },
    '1000000000': {
      'other': '0 مىليارد'
    },
    '10000000000': {
      'other': '00 مىليارد'
    },
    '100000000000': {
      'other': '000 مىليارد'
    },
    '1000000000000': {
      'other': '0 تىرىليون'
    },
    '10000000000000': {
      'other': '00 تىرىليون'
    },
    '100000000000000': {
      'other': '000 تىرىليون'
    }
  }
};


/**
 * Compact number formatting symbols for locale ug_CN.
 */
goog.i18n.CompactNumberFormatSymbols_ug_CN = goog.i18n.CompactNumberFormatSymbols_ug;


/**
 * Compact number formatting symbols for locale uk_UA.
 */
goog.i18n.CompactNumberFormatSymbols_uk_UA = goog.i18n.CompactNumberFormatSymbols_uk;


/**
 * Compact number formatting symbols for locale ur_IN.
 */
goog.i18n.CompactNumberFormatSymbols_ur_IN = goog.i18n.CompactNumberFormatSymbols_ur;


/**
 * Compact number formatting symbols for locale ur_PK.
 */
goog.i18n.CompactNumberFormatSymbols_ur_PK = goog.i18n.CompactNumberFormatSymbols_ur;


/**
 * Compact number formatting symbols for locale uz_Arab.
 */
goog.i18n.CompactNumberFormatSymbols_uz_Arab = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale uz_Arab_AF.
 */
goog.i18n.CompactNumberFormatSymbols_uz_Arab_AF = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale uz_Cyrl.
 */
goog.i18n.CompactNumberFormatSymbols_uz_Cyrl = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0минг'
    },
    '10000': {
      'other': '00минг'
    },
    '100000': {
      'other': '000минг'
    },
    '1000000': {
      'other': '0млн'
    },
    '10000000': {
      'other': '00млн'
    },
    '100000000': {
      'other': '000млн'
    },
    '1000000000': {
      'other': '0млрд'
    },
    '10000000000': {
      'other': '00млрд'
    },
    '100000000000': {
      'other': '000млрд'
    },
    '1000000000000': {
      'other': '0трлн'
    },
    '10000000000000': {
      'other': '00трлн'
    },
    '100000000000000': {
      'other': '000трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 минг'
    },
    '10000': {
      'other': '00 минг'
    },
    '100000': {
      'other': '000 минг'
    },
    '1000000': {
      'other': '0 миллион'
    },
    '10000000': {
      'other': '00 миллион'
    },
    '100000000': {
      'other': '000 миллион'
    },
    '1000000000': {
      'other': '0 миллиард'
    },
    '10000000000': {
      'other': '00 миллиард'
    },
    '100000000000': {
      'other': '000 миллиард'
    },
    '1000000000000': {
      'other': '0 трилион'
    },
    '10000000000000': {
      'other': '00 трилион'
    },
    '100000000000000': {
      'other': '000 трилион'
    }
  }
};


/**
 * Compact number formatting symbols for locale uz_Cyrl_UZ.
 */
goog.i18n.CompactNumberFormatSymbols_uz_Cyrl_UZ = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0минг'
    },
    '10000': {
      'other': '00минг'
    },
    '100000': {
      'other': '000минг'
    },
    '1000000': {
      'other': '0млн'
    },
    '10000000': {
      'other': '00млн'
    },
    '100000000': {
      'other': '000млн'
    },
    '1000000000': {
      'other': '0млрд'
    },
    '10000000000': {
      'other': '00млрд'
    },
    '100000000000': {
      'other': '000млрд'
    },
    '1000000000000': {
      'other': '0трлн'
    },
    '10000000000000': {
      'other': '00трлн'
    },
    '100000000000000': {
      'other': '000трлн'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0 минг'
    },
    '10000': {
      'other': '00 минг'
    },
    '100000': {
      'other': '000 минг'
    },
    '1000000': {
      'other': '0 миллион'
    },
    '10000000': {
      'other': '00 миллион'
    },
    '100000000': {
      'other': '000 миллион'
    },
    '1000000000': {
      'other': '0 миллиард'
    },
    '10000000000': {
      'other': '00 миллиард'
    },
    '100000000000': {
      'other': '000 миллиард'
    },
    '1000000000000': {
      'other': '0 трилион'
    },
    '10000000000000': {
      'other': '00 трилион'
    },
    '100000000000000': {
      'other': '000 трилион'
    }
  }
};


/**
 * Compact number formatting symbols for locale uz_Latn.
 */
goog.i18n.CompactNumberFormatSymbols_uz_Latn = goog.i18n.CompactNumberFormatSymbols_uz;


/**
 * Compact number formatting symbols for locale uz_Latn_UZ.
 */
goog.i18n.CompactNumberFormatSymbols_uz_Latn_UZ = goog.i18n.CompactNumberFormatSymbols_uz;


/**
 * Compact number formatting symbols for locale vai.
 */
goog.i18n.CompactNumberFormatSymbols_vai = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale vai_Latn.
 */
goog.i18n.CompactNumberFormatSymbols_vai_Latn = goog.i18n.CompactNumberFormatSymbols_vai;


/**
 * Compact number formatting symbols for locale vai_Latn_LR.
 */
goog.i18n.CompactNumberFormatSymbols_vai_Latn_LR = goog.i18n.CompactNumberFormatSymbols_vai;


/**
 * Compact number formatting symbols for locale vai_Vaii.
 */
goog.i18n.CompactNumberFormatSymbols_vai_Vaii = goog.i18n.CompactNumberFormatSymbols_vai;


/**
 * Compact number formatting symbols for locale vai_Vaii_LR.
 */
goog.i18n.CompactNumberFormatSymbols_vai_Vaii_LR = goog.i18n.CompactNumberFormatSymbols_vai;


/**
 * Compact number formatting symbols for locale vi_VN.
 */
goog.i18n.CompactNumberFormatSymbols_vi_VN = goog.i18n.CompactNumberFormatSymbols_vi;


/**
 * Compact number formatting symbols for locale vun.
 */
goog.i18n.CompactNumberFormatSymbols_vun = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale vun_TZ.
 */
goog.i18n.CompactNumberFormatSymbols_vun_TZ = goog.i18n.CompactNumberFormatSymbols_vun;


/**
 * Compact number formatting symbols for locale wae.
 */
goog.i18n.CompactNumberFormatSymbols_wae = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale wae_CH.
 */
goog.i18n.CompactNumberFormatSymbols_wae_CH = goog.i18n.CompactNumberFormatSymbols_wae;


/**
 * Compact number formatting symbols for locale xog.
 */
goog.i18n.CompactNumberFormatSymbols_xog = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale xog_UG.
 */
goog.i18n.CompactNumberFormatSymbols_xog_UG = goog.i18n.CompactNumberFormatSymbols_xog;


/**
 * Compact number formatting symbols for locale yav.
 */
goog.i18n.CompactNumberFormatSymbols_yav = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale yav_CM.
 */
goog.i18n.CompactNumberFormatSymbols_yav_CM = goog.i18n.CompactNumberFormatSymbols_yav;


/**
 * Compact number formatting symbols for locale yi.
 */
goog.i18n.CompactNumberFormatSymbols_yi = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale yi_001.
 */
goog.i18n.CompactNumberFormatSymbols_yi_001 = goog.i18n.CompactNumberFormatSymbols_yi;


/**
 * Compact number formatting symbols for locale yo.
 */
goog.i18n.CompactNumberFormatSymbols_yo = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale yo_BJ.
 */
goog.i18n.CompactNumberFormatSymbols_yo_BJ = goog.i18n.CompactNumberFormatSymbols_yo;


/**
 * Compact number formatting symbols for locale yo_NG.
 */
goog.i18n.CompactNumberFormatSymbols_yo_NG = goog.i18n.CompactNumberFormatSymbols_yo;


/**
 * Compact number formatting symbols for locale yue.
 */
goog.i18n.CompactNumberFormatSymbols_yue = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale yue_HK.
 */
goog.i18n.CompactNumberFormatSymbols_yue_HK = goog.i18n.CompactNumberFormatSymbols_yue;


/**
 * Compact number formatting symbols for locale zgh.
 */
goog.i18n.CompactNumberFormatSymbols_zgh = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0G'
    },
    '10000000000': {
      'other': '00G'
    },
    '100000000000': {
      'other': '000G'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  }
};


/**
 * Compact number formatting symbols for locale zgh_MA.
 */
goog.i18n.CompactNumberFormatSymbols_zgh_MA = goog.i18n.CompactNumberFormatSymbols_zgh;


/**
 * Compact number formatting symbols for locale zh_Hans.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hans = goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_Hans_CN.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hans_CN = goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_Hans_HK.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hans_HK = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000000000000': {
      'other': '0万亿'
    },
    '10000000000000': {
      'other': '00万亿'
    },
    '100000000000000': {
      'other': '000万亿'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000000000000': {
      'other': '0万亿'
    },
    '10000000000000': {
      'other': '00万亿'
    },
    '100000000000000': {
      'other': '000万亿'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_Hans_MO.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hans_MO = goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_Hans_SG.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hans_SG = goog.i18n.CompactNumberFormatSymbols_zh;


/**
 * Compact number formatting symbols for locale zh_Hant.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hant = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_Hant_HK.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hant_HK = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_Hant_MO.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hant_MO = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0K'
    },
    '10000': {
      'other': '00K'
    },
    '100000': {
      'other': '000K'
    },
    '1000000': {
      'other': '0M'
    },
    '10000000': {
      'other': '00M'
    },
    '100000000': {
      'other': '000M'
    },
    '1000000000': {
      'other': '0B'
    },
    '10000000000': {
      'other': '00B'
    },
    '100000000000': {
      'other': '000B'
    },
    '1000000000000': {
      'other': '0T'
    },
    '10000000000000': {
      'other': '00T'
    },
    '100000000000000': {
      'other': '000T'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale zh_Hant_TW.
 */
goog.i18n.CompactNumberFormatSymbols_zh_Hant_TW = {
  COMPACT_DECIMAL_SHORT_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  },
  COMPACT_DECIMAL_LONG_PATTERN: {
    '1000': {
      'other': '0千'
    },
    '10000': {
      'other': '0萬'
    },
    '100000': {
      'other': '00萬'
    },
    '1000000': {
      'other': '000萬'
    },
    '10000000': {
      'other': '0000萬'
    },
    '100000000': {
      'other': '0億'
    },
    '1000000000': {
      'other': '00億'
    },
    '10000000000': {
      'other': '000億'
    },
    '100000000000': {
      'other': '0000億'
    },
    '1000000000000': {
      'other': '0兆'
    },
    '10000000000000': {
      'other': '00兆'
    },
    '100000000000000': {
      'other': '000兆'
    }
  }
};


/**
 * Compact number formatting symbols for locale zu_ZA.
 */
goog.i18n.CompactNumberFormatSymbols_zu_ZA = goog.i18n.CompactNumberFormatSymbols_zu;


/**
 * Select compact number formatting symbols by locale.
 */
if (goog.LOCALE == 'af_NA' || goog.LOCALE == 'af-NA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_af_NA;
}

if (goog.LOCALE == 'af_ZA' || goog.LOCALE == 'af-ZA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_af_ZA;
}

if (goog.LOCALE == 'agq') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_agq;
}

if (goog.LOCALE == 'agq_CM' || goog.LOCALE == 'agq-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_agq_CM;
}

if (goog.LOCALE == 'ak') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ak;
}

if (goog.LOCALE == 'ak_GH' || goog.LOCALE == 'ak-GH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ak_GH;
}

if (goog.LOCALE == 'am_ET' || goog.LOCALE == 'am-ET') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_am_ET;
}

if (goog.LOCALE == 'ar_001' || goog.LOCALE == 'ar-001') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_001;
}

if (goog.LOCALE == 'ar_AE' || goog.LOCALE == 'ar-AE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_AE;
}

if (goog.LOCALE == 'ar_BH' || goog.LOCALE == 'ar-BH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_BH;
}

if (goog.LOCALE == 'ar_DJ' || goog.LOCALE == 'ar-DJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_DJ;
}

if (goog.LOCALE == 'ar_DZ' || goog.LOCALE == 'ar-DZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_DZ;
}

if (goog.LOCALE == 'ar_EG' || goog.LOCALE == 'ar-EG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_EG;
}

if (goog.LOCALE == 'ar_EH' || goog.LOCALE == 'ar-EH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_EH;
}

if (goog.LOCALE == 'ar_ER' || goog.LOCALE == 'ar-ER') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_ER;
}

if (goog.LOCALE == 'ar_IL' || goog.LOCALE == 'ar-IL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_IL;
}

if (goog.LOCALE == 'ar_IQ' || goog.LOCALE == 'ar-IQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_IQ;
}

if (goog.LOCALE == 'ar_JO' || goog.LOCALE == 'ar-JO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_JO;
}

if (goog.LOCALE == 'ar_KM' || goog.LOCALE == 'ar-KM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_KM;
}

if (goog.LOCALE == 'ar_KW' || goog.LOCALE == 'ar-KW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_KW;
}

if (goog.LOCALE == 'ar_LB' || goog.LOCALE == 'ar-LB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_LB;
}

if (goog.LOCALE == 'ar_LY' || goog.LOCALE == 'ar-LY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_LY;
}

if (goog.LOCALE == 'ar_MA' || goog.LOCALE == 'ar-MA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_MA;
}

if (goog.LOCALE == 'ar_MR' || goog.LOCALE == 'ar-MR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_MR;
}

if (goog.LOCALE == 'ar_OM' || goog.LOCALE == 'ar-OM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_OM;
}

if (goog.LOCALE == 'ar_PS' || goog.LOCALE == 'ar-PS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_PS;
}

if (goog.LOCALE == 'ar_QA' || goog.LOCALE == 'ar-QA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_QA;
}

if (goog.LOCALE == 'ar_SA' || goog.LOCALE == 'ar-SA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_SA;
}

if (goog.LOCALE == 'ar_SD' || goog.LOCALE == 'ar-SD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_SD;
}

if (goog.LOCALE == 'ar_SO' || goog.LOCALE == 'ar-SO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_SO;
}

if (goog.LOCALE == 'ar_SS' || goog.LOCALE == 'ar-SS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_SS;
}

if (goog.LOCALE == 'ar_SY' || goog.LOCALE == 'ar-SY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_SY;
}

if (goog.LOCALE == 'ar_TD' || goog.LOCALE == 'ar-TD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_TD;
}

if (goog.LOCALE == 'ar_TN' || goog.LOCALE == 'ar-TN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_TN;
}

if (goog.LOCALE == 'ar_XB' || goog.LOCALE == 'ar-XB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_XB;
}

if (goog.LOCALE == 'ar_YE' || goog.LOCALE == 'ar-YE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ar_YE;
}

if (goog.LOCALE == 'as') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_as;
}

if (goog.LOCALE == 'as_IN' || goog.LOCALE == 'as-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_as_IN;
}

if (goog.LOCALE == 'asa') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_asa;
}

if (goog.LOCALE == 'asa_TZ' || goog.LOCALE == 'asa-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_asa_TZ;
}

if (goog.LOCALE == 'ast') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ast;
}

if (goog.LOCALE == 'ast_ES' || goog.LOCALE == 'ast-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ast_ES;
}

if (goog.LOCALE == 'az_Cyrl' || goog.LOCALE == 'az-Cyrl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_az_Cyrl;
}

if (goog.LOCALE == 'az_Cyrl_AZ' || goog.LOCALE == 'az-Cyrl-AZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_az_Cyrl_AZ;
}

if (goog.LOCALE == 'az_Latn' || goog.LOCALE == 'az-Latn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_az_Latn;
}

if (goog.LOCALE == 'az_Latn_AZ' || goog.LOCALE == 'az-Latn-AZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_az_Latn_AZ;
}

if (goog.LOCALE == 'bas') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bas;
}

if (goog.LOCALE == 'bas_CM' || goog.LOCALE == 'bas-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bas_CM;
}

if (goog.LOCALE == 'be_BY' || goog.LOCALE == 'be-BY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_be_BY;
}

if (goog.LOCALE == 'bem') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bem;
}

if (goog.LOCALE == 'bem_ZM' || goog.LOCALE == 'bem-ZM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bem_ZM;
}

if (goog.LOCALE == 'bez') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bez;
}

if (goog.LOCALE == 'bez_TZ' || goog.LOCALE == 'bez-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bez_TZ;
}

if (goog.LOCALE == 'bg_BG' || goog.LOCALE == 'bg-BG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bg_BG;
}

if (goog.LOCALE == 'bm') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bm;
}

if (goog.LOCALE == 'bm_ML' || goog.LOCALE == 'bm-ML') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bm_ML;
}

if (goog.LOCALE == 'bn_BD' || goog.LOCALE == 'bn-BD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bn_BD;
}

if (goog.LOCALE == 'bn_IN' || goog.LOCALE == 'bn-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bn_IN;
}

if (goog.LOCALE == 'bo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bo;
}

if (goog.LOCALE == 'bo_CN' || goog.LOCALE == 'bo-CN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bo_CN;
}

if (goog.LOCALE == 'bo_IN' || goog.LOCALE == 'bo-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bo_IN;
}

if (goog.LOCALE == 'br_FR' || goog.LOCALE == 'br-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_br_FR;
}

if (goog.LOCALE == 'brx') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_brx;
}

if (goog.LOCALE == 'brx_IN' || goog.LOCALE == 'brx-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_brx_IN;
}

if (goog.LOCALE == 'bs_Cyrl' || goog.LOCALE == 'bs-Cyrl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bs_Cyrl;
}

if (goog.LOCALE == 'bs_Cyrl_BA' || goog.LOCALE == 'bs-Cyrl-BA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bs_Cyrl_BA;
}

if (goog.LOCALE == 'bs_Latn' || goog.LOCALE == 'bs-Latn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bs_Latn;
}

if (goog.LOCALE == 'bs_Latn_BA' || goog.LOCALE == 'bs-Latn-BA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_bs_Latn_BA;
}

if (goog.LOCALE == 'ca_AD' || goog.LOCALE == 'ca-AD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca_AD;
}

if (goog.LOCALE == 'ca_ES' || goog.LOCALE == 'ca-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca_ES;
}

if (goog.LOCALE == 'ca_FR' || goog.LOCALE == 'ca-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca_FR;
}

if (goog.LOCALE == 'ca_IT' || goog.LOCALE == 'ca-IT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ca_IT;
}

if (goog.LOCALE == 'ce') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ce;
}

if (goog.LOCALE == 'ce_RU' || goog.LOCALE == 'ce-RU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ce_RU;
}

if (goog.LOCALE == 'cgg') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cgg;
}

if (goog.LOCALE == 'cgg_UG' || goog.LOCALE == 'cgg-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cgg_UG;
}

if (goog.LOCALE == 'chr_US' || goog.LOCALE == 'chr-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_chr_US;
}

if (goog.LOCALE == 'ckb') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ckb;
}

if (goog.LOCALE == 'ckb_IQ' || goog.LOCALE == 'ckb-IQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ckb_IQ;
}

if (goog.LOCALE == 'ckb_IR' || goog.LOCALE == 'ckb-IR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ckb_IR;
}

if (goog.LOCALE == 'cs_CZ' || goog.LOCALE == 'cs-CZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cs_CZ;
}

if (goog.LOCALE == 'cy_GB' || goog.LOCALE == 'cy-GB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_cy_GB;
}

if (goog.LOCALE == 'da_DK' || goog.LOCALE == 'da-DK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_da_DK;
}

if (goog.LOCALE == 'da_GL' || goog.LOCALE == 'da-GL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_da_GL;
}

if (goog.LOCALE == 'dav') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dav;
}

if (goog.LOCALE == 'dav_KE' || goog.LOCALE == 'dav-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dav_KE;
}

if (goog.LOCALE == 'de_BE' || goog.LOCALE == 'de-BE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_BE;
}

if (goog.LOCALE == 'de_DE' || goog.LOCALE == 'de-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_DE;
}

if (goog.LOCALE == 'de_IT' || goog.LOCALE == 'de-IT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_IT;
}

if (goog.LOCALE == 'de_LI' || goog.LOCALE == 'de-LI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_LI;
}

if (goog.LOCALE == 'de_LU' || goog.LOCALE == 'de-LU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_de_LU;
}

if (goog.LOCALE == 'dje') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dje;
}

if (goog.LOCALE == 'dje_NE' || goog.LOCALE == 'dje-NE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dje_NE;
}

if (goog.LOCALE == 'dsb') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dsb;
}

if (goog.LOCALE == 'dsb_DE' || goog.LOCALE == 'dsb-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dsb_DE;
}

if (goog.LOCALE == 'dua') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dua;
}

if (goog.LOCALE == 'dua_CM' || goog.LOCALE == 'dua-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dua_CM;
}

if (goog.LOCALE == 'dyo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dyo;
}

if (goog.LOCALE == 'dyo_SN' || goog.LOCALE == 'dyo-SN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dyo_SN;
}

if (goog.LOCALE == 'dz') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dz;
}

if (goog.LOCALE == 'dz_BT' || goog.LOCALE == 'dz-BT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_dz_BT;
}

if (goog.LOCALE == 'ebu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ebu;
}

if (goog.LOCALE == 'ebu_KE' || goog.LOCALE == 'ebu-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ebu_KE;
}

if (goog.LOCALE == 'ee') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ee;
}

if (goog.LOCALE == 'ee_GH' || goog.LOCALE == 'ee-GH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ee_GH;
}

if (goog.LOCALE == 'ee_TG' || goog.LOCALE == 'ee-TG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ee_TG;
}

if (goog.LOCALE == 'el_CY' || goog.LOCALE == 'el-CY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_el_CY;
}

if (goog.LOCALE == 'el_GR' || goog.LOCALE == 'el-GR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_el_GR;
}

if (goog.LOCALE == 'en_001' || goog.LOCALE == 'en-001') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_001;
}

if (goog.LOCALE == 'en_150' || goog.LOCALE == 'en-150') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_150;
}

if (goog.LOCALE == 'en_AG' || goog.LOCALE == 'en-AG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_AG;
}

if (goog.LOCALE == 'en_AI' || goog.LOCALE == 'en-AI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_AI;
}

if (goog.LOCALE == 'en_AS' || goog.LOCALE == 'en-AS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_AS;
}

if (goog.LOCALE == 'en_AT' || goog.LOCALE == 'en-AT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_AT;
}

if (goog.LOCALE == 'en_BB' || goog.LOCALE == 'en-BB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BB;
}

if (goog.LOCALE == 'en_BE' || goog.LOCALE == 'en-BE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BE;
}

if (goog.LOCALE == 'en_BI' || goog.LOCALE == 'en-BI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BI;
}

if (goog.LOCALE == 'en_BM' || goog.LOCALE == 'en-BM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BM;
}

if (goog.LOCALE == 'en_BS' || goog.LOCALE == 'en-BS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BS;
}

if (goog.LOCALE == 'en_BW' || goog.LOCALE == 'en-BW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BW;
}

if (goog.LOCALE == 'en_BZ' || goog.LOCALE == 'en-BZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_BZ;
}

if (goog.LOCALE == 'en_CC' || goog.LOCALE == 'en-CC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CC;
}

if (goog.LOCALE == 'en_CH' || goog.LOCALE == 'en-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CH;
}

if (goog.LOCALE == 'en_CK' || goog.LOCALE == 'en-CK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CK;
}

if (goog.LOCALE == 'en_CM' || goog.LOCALE == 'en-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CM;
}

if (goog.LOCALE == 'en_CX' || goog.LOCALE == 'en-CX') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CX;
}

if (goog.LOCALE == 'en_CY' || goog.LOCALE == 'en-CY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_CY;
}

if (goog.LOCALE == 'en_DE' || goog.LOCALE == 'en-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_DE;
}

if (goog.LOCALE == 'en_DG' || goog.LOCALE == 'en-DG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_DG;
}

if (goog.LOCALE == 'en_DK' || goog.LOCALE == 'en-DK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_DK;
}

if (goog.LOCALE == 'en_DM' || goog.LOCALE == 'en-DM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_DM;
}

if (goog.LOCALE == 'en_ER' || goog.LOCALE == 'en-ER') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_ER;
}

if (goog.LOCALE == 'en_FI' || goog.LOCALE == 'en-FI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_FI;
}

if (goog.LOCALE == 'en_FJ' || goog.LOCALE == 'en-FJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_FJ;
}

if (goog.LOCALE == 'en_FK' || goog.LOCALE == 'en-FK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_FK;
}

if (goog.LOCALE == 'en_FM' || goog.LOCALE == 'en-FM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_FM;
}

if (goog.LOCALE == 'en_GD' || goog.LOCALE == 'en-GD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GD;
}

if (goog.LOCALE == 'en_GG' || goog.LOCALE == 'en-GG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GG;
}

if (goog.LOCALE == 'en_GH' || goog.LOCALE == 'en-GH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GH;
}

if (goog.LOCALE == 'en_GI' || goog.LOCALE == 'en-GI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GI;
}

if (goog.LOCALE == 'en_GM' || goog.LOCALE == 'en-GM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GM;
}

if (goog.LOCALE == 'en_GU' || goog.LOCALE == 'en-GU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GU;
}

if (goog.LOCALE == 'en_GY' || goog.LOCALE == 'en-GY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_GY;
}

if (goog.LOCALE == 'en_HK' || goog.LOCALE == 'en-HK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_HK;
}

if (goog.LOCALE == 'en_IL' || goog.LOCALE == 'en-IL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IL;
}

if (goog.LOCALE == 'en_IM' || goog.LOCALE == 'en-IM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IM;
}

if (goog.LOCALE == 'en_IO' || goog.LOCALE == 'en-IO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_IO;
}

if (goog.LOCALE == 'en_JE' || goog.LOCALE == 'en-JE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_JE;
}

if (goog.LOCALE == 'en_JM' || goog.LOCALE == 'en-JM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_JM;
}

if (goog.LOCALE == 'en_KE' || goog.LOCALE == 'en-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_KE;
}

if (goog.LOCALE == 'en_KI' || goog.LOCALE == 'en-KI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_KI;
}

if (goog.LOCALE == 'en_KN' || goog.LOCALE == 'en-KN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_KN;
}

if (goog.LOCALE == 'en_KY' || goog.LOCALE == 'en-KY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_KY;
}

if (goog.LOCALE == 'en_LC' || goog.LOCALE == 'en-LC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_LC;
}

if (goog.LOCALE == 'en_LR' || goog.LOCALE == 'en-LR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_LR;
}

if (goog.LOCALE == 'en_LS' || goog.LOCALE == 'en-LS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_LS;
}

if (goog.LOCALE == 'en_MG' || goog.LOCALE == 'en-MG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MG;
}

if (goog.LOCALE == 'en_MH' || goog.LOCALE == 'en-MH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MH;
}

if (goog.LOCALE == 'en_MO' || goog.LOCALE == 'en-MO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MO;
}

if (goog.LOCALE == 'en_MP' || goog.LOCALE == 'en-MP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MP;
}

if (goog.LOCALE == 'en_MS' || goog.LOCALE == 'en-MS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MS;
}

if (goog.LOCALE == 'en_MT' || goog.LOCALE == 'en-MT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MT;
}

if (goog.LOCALE == 'en_MU' || goog.LOCALE == 'en-MU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MU;
}

if (goog.LOCALE == 'en_MW' || goog.LOCALE == 'en-MW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MW;
}

if (goog.LOCALE == 'en_MY' || goog.LOCALE == 'en-MY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_MY;
}

if (goog.LOCALE == 'en_NA' || goog.LOCALE == 'en-NA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NA;
}

if (goog.LOCALE == 'en_NF' || goog.LOCALE == 'en-NF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NF;
}

if (goog.LOCALE == 'en_NG' || goog.LOCALE == 'en-NG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NG;
}

if (goog.LOCALE == 'en_NL' || goog.LOCALE == 'en-NL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NL;
}

if (goog.LOCALE == 'en_NR' || goog.LOCALE == 'en-NR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NR;
}

if (goog.LOCALE == 'en_NU' || goog.LOCALE == 'en-NU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NU;
}

if (goog.LOCALE == 'en_NZ' || goog.LOCALE == 'en-NZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_NZ;
}

if (goog.LOCALE == 'en_PG' || goog.LOCALE == 'en-PG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_PG;
}

if (goog.LOCALE == 'en_PH' || goog.LOCALE == 'en-PH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_PH;
}

if (goog.LOCALE == 'en_PK' || goog.LOCALE == 'en-PK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_PK;
}

if (goog.LOCALE == 'en_PN' || goog.LOCALE == 'en-PN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_PN;
}

if (goog.LOCALE == 'en_PR' || goog.LOCALE == 'en-PR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_PR;
}

if (goog.LOCALE == 'en_PW' || goog.LOCALE == 'en-PW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_PW;
}

if (goog.LOCALE == 'en_RW' || goog.LOCALE == 'en-RW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_RW;
}

if (goog.LOCALE == 'en_SB' || goog.LOCALE == 'en-SB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SB;
}

if (goog.LOCALE == 'en_SC' || goog.LOCALE == 'en-SC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SC;
}

if (goog.LOCALE == 'en_SD' || goog.LOCALE == 'en-SD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SD;
}

if (goog.LOCALE == 'en_SE' || goog.LOCALE == 'en-SE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SE;
}

if (goog.LOCALE == 'en_SH' || goog.LOCALE == 'en-SH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SH;
}

if (goog.LOCALE == 'en_SI' || goog.LOCALE == 'en-SI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SI;
}

if (goog.LOCALE == 'en_SL' || goog.LOCALE == 'en-SL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SL;
}

if (goog.LOCALE == 'en_SS' || goog.LOCALE == 'en-SS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SS;
}

if (goog.LOCALE == 'en_SX' || goog.LOCALE == 'en-SX') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SX;
}

if (goog.LOCALE == 'en_SZ' || goog.LOCALE == 'en-SZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_SZ;
}

if (goog.LOCALE == 'en_TC' || goog.LOCALE == 'en-TC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_TC;
}

if (goog.LOCALE == 'en_TK' || goog.LOCALE == 'en-TK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_TK;
}

if (goog.LOCALE == 'en_TO' || goog.LOCALE == 'en-TO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_TO;
}

if (goog.LOCALE == 'en_TT' || goog.LOCALE == 'en-TT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_TT;
}

if (goog.LOCALE == 'en_TV' || goog.LOCALE == 'en-TV') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_TV;
}

if (goog.LOCALE == 'en_TZ' || goog.LOCALE == 'en-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_TZ;
}

if (goog.LOCALE == 'en_UG' || goog.LOCALE == 'en-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_UG;
}

if (goog.LOCALE == 'en_UM' || goog.LOCALE == 'en-UM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_UM;
}

if (goog.LOCALE == 'en_US_POSIX' || goog.LOCALE == 'en-US-POSIX') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_US_POSIX;
}

if (goog.LOCALE == 'en_VC' || goog.LOCALE == 'en-VC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_VC;
}

if (goog.LOCALE == 'en_VG' || goog.LOCALE == 'en-VG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_VG;
}

if (goog.LOCALE == 'en_VI' || goog.LOCALE == 'en-VI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_VI;
}

if (goog.LOCALE == 'en_VU' || goog.LOCALE == 'en-VU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_VU;
}

if (goog.LOCALE == 'en_WS' || goog.LOCALE == 'en-WS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_WS;
}

if (goog.LOCALE == 'en_XA' || goog.LOCALE == 'en-XA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_XA;
}

if (goog.LOCALE == 'en_ZM' || goog.LOCALE == 'en-ZM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_ZM;
}

if (goog.LOCALE == 'en_ZW' || goog.LOCALE == 'en-ZW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_en_ZW;
}

if (goog.LOCALE == 'eo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_eo;
}

if (goog.LOCALE == 'es_AR' || goog.LOCALE == 'es-AR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_AR;
}

if (goog.LOCALE == 'es_BO' || goog.LOCALE == 'es-BO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_BO;
}

if (goog.LOCALE == 'es_BR' || goog.LOCALE == 'es-BR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_BR;
}

if (goog.LOCALE == 'es_CL' || goog.LOCALE == 'es-CL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_CL;
}

if (goog.LOCALE == 'es_CO' || goog.LOCALE == 'es-CO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_CO;
}

if (goog.LOCALE == 'es_CR' || goog.LOCALE == 'es-CR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_CR;
}

if (goog.LOCALE == 'es_CU' || goog.LOCALE == 'es-CU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_CU;
}

if (goog.LOCALE == 'es_DO' || goog.LOCALE == 'es-DO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_DO;
}

if (goog.LOCALE == 'es_EA' || goog.LOCALE == 'es-EA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_EA;
}

if (goog.LOCALE == 'es_EC' || goog.LOCALE == 'es-EC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_EC;
}

if (goog.LOCALE == 'es_GQ' || goog.LOCALE == 'es-GQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_GQ;
}

if (goog.LOCALE == 'es_GT' || goog.LOCALE == 'es-GT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_GT;
}

if (goog.LOCALE == 'es_HN' || goog.LOCALE == 'es-HN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_HN;
}

if (goog.LOCALE == 'es_IC' || goog.LOCALE == 'es-IC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_IC;
}

if (goog.LOCALE == 'es_NI' || goog.LOCALE == 'es-NI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_NI;
}

if (goog.LOCALE == 'es_PA' || goog.LOCALE == 'es-PA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_PA;
}

if (goog.LOCALE == 'es_PE' || goog.LOCALE == 'es-PE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_PE;
}

if (goog.LOCALE == 'es_PH' || goog.LOCALE == 'es-PH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_PH;
}

if (goog.LOCALE == 'es_PR' || goog.LOCALE == 'es-PR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_PR;
}

if (goog.LOCALE == 'es_PY' || goog.LOCALE == 'es-PY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_PY;
}

if (goog.LOCALE == 'es_SV' || goog.LOCALE == 'es-SV') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_SV;
}

if (goog.LOCALE == 'es_UY' || goog.LOCALE == 'es-UY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_UY;
}

if (goog.LOCALE == 'es_VE' || goog.LOCALE == 'es-VE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_es_VE;
}

if (goog.LOCALE == 'et_EE' || goog.LOCALE == 'et-EE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_et_EE;
}

if (goog.LOCALE == 'eu_ES' || goog.LOCALE == 'eu-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_eu_ES;
}

if (goog.LOCALE == 'ewo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ewo;
}

if (goog.LOCALE == 'ewo_CM' || goog.LOCALE == 'ewo-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ewo_CM;
}

if (goog.LOCALE == 'fa_AF' || goog.LOCALE == 'fa-AF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fa_AF;
}

if (goog.LOCALE == 'fa_IR' || goog.LOCALE == 'fa-IR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fa_IR;
}

if (goog.LOCALE == 'ff') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ff;
}

if (goog.LOCALE == 'ff_CM' || goog.LOCALE == 'ff-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ff_CM;
}

if (goog.LOCALE == 'ff_GN' || goog.LOCALE == 'ff-GN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ff_GN;
}

if (goog.LOCALE == 'ff_MR' || goog.LOCALE == 'ff-MR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ff_MR;
}

if (goog.LOCALE == 'ff_SN' || goog.LOCALE == 'ff-SN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ff_SN;
}

if (goog.LOCALE == 'fi_FI' || goog.LOCALE == 'fi-FI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fi_FI;
}

if (goog.LOCALE == 'fil_PH' || goog.LOCALE == 'fil-PH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fil_PH;
}

if (goog.LOCALE == 'fo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fo;
}

if (goog.LOCALE == 'fo_DK' || goog.LOCALE == 'fo-DK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fo_DK;
}

if (goog.LOCALE == 'fo_FO' || goog.LOCALE == 'fo-FO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fo_FO;
}

if (goog.LOCALE == 'fr_BE' || goog.LOCALE == 'fr-BE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_BE;
}

if (goog.LOCALE == 'fr_BF' || goog.LOCALE == 'fr-BF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_BF;
}

if (goog.LOCALE == 'fr_BI' || goog.LOCALE == 'fr-BI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_BI;
}

if (goog.LOCALE == 'fr_BJ' || goog.LOCALE == 'fr-BJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_BJ;
}

if (goog.LOCALE == 'fr_BL' || goog.LOCALE == 'fr-BL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_BL;
}

if (goog.LOCALE == 'fr_CD' || goog.LOCALE == 'fr-CD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CD;
}

if (goog.LOCALE == 'fr_CF' || goog.LOCALE == 'fr-CF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CF;
}

if (goog.LOCALE == 'fr_CG' || goog.LOCALE == 'fr-CG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CG;
}

if (goog.LOCALE == 'fr_CH' || goog.LOCALE == 'fr-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CH;
}

if (goog.LOCALE == 'fr_CI' || goog.LOCALE == 'fr-CI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CI;
}

if (goog.LOCALE == 'fr_CM' || goog.LOCALE == 'fr-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_CM;
}

if (goog.LOCALE == 'fr_DJ' || goog.LOCALE == 'fr-DJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_DJ;
}

if (goog.LOCALE == 'fr_DZ' || goog.LOCALE == 'fr-DZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_DZ;
}

if (goog.LOCALE == 'fr_FR' || goog.LOCALE == 'fr-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_FR;
}

if (goog.LOCALE == 'fr_GA' || goog.LOCALE == 'fr-GA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_GA;
}

if (goog.LOCALE == 'fr_GF' || goog.LOCALE == 'fr-GF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_GF;
}

if (goog.LOCALE == 'fr_GN' || goog.LOCALE == 'fr-GN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_GN;
}

if (goog.LOCALE == 'fr_GP' || goog.LOCALE == 'fr-GP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_GP;
}

if (goog.LOCALE == 'fr_GQ' || goog.LOCALE == 'fr-GQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_GQ;
}

if (goog.LOCALE == 'fr_HT' || goog.LOCALE == 'fr-HT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_HT;
}

if (goog.LOCALE == 'fr_KM' || goog.LOCALE == 'fr-KM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_KM;
}

if (goog.LOCALE == 'fr_LU' || goog.LOCALE == 'fr-LU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_LU;
}

if (goog.LOCALE == 'fr_MA' || goog.LOCALE == 'fr-MA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MA;
}

if (goog.LOCALE == 'fr_MC' || goog.LOCALE == 'fr-MC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MC;
}

if (goog.LOCALE == 'fr_MF' || goog.LOCALE == 'fr-MF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MF;
}

if (goog.LOCALE == 'fr_MG' || goog.LOCALE == 'fr-MG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MG;
}

if (goog.LOCALE == 'fr_ML' || goog.LOCALE == 'fr-ML') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_ML;
}

if (goog.LOCALE == 'fr_MQ' || goog.LOCALE == 'fr-MQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MQ;
}

if (goog.LOCALE == 'fr_MR' || goog.LOCALE == 'fr-MR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MR;
}

if (goog.LOCALE == 'fr_MU' || goog.LOCALE == 'fr-MU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_MU;
}

if (goog.LOCALE == 'fr_NC' || goog.LOCALE == 'fr-NC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_NC;
}

if (goog.LOCALE == 'fr_NE' || goog.LOCALE == 'fr-NE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_NE;
}

if (goog.LOCALE == 'fr_PF' || goog.LOCALE == 'fr-PF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_PF;
}

if (goog.LOCALE == 'fr_PM' || goog.LOCALE == 'fr-PM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_PM;
}

if (goog.LOCALE == 'fr_RE' || goog.LOCALE == 'fr-RE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_RE;
}

if (goog.LOCALE == 'fr_RW' || goog.LOCALE == 'fr-RW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_RW;
}

if (goog.LOCALE == 'fr_SC' || goog.LOCALE == 'fr-SC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_SC;
}

if (goog.LOCALE == 'fr_SN' || goog.LOCALE == 'fr-SN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_SN;
}

if (goog.LOCALE == 'fr_SY' || goog.LOCALE == 'fr-SY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_SY;
}

if (goog.LOCALE == 'fr_TD' || goog.LOCALE == 'fr-TD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_TD;
}

if (goog.LOCALE == 'fr_TG' || goog.LOCALE == 'fr-TG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_TG;
}

if (goog.LOCALE == 'fr_TN' || goog.LOCALE == 'fr-TN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_TN;
}

if (goog.LOCALE == 'fr_VU' || goog.LOCALE == 'fr-VU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_VU;
}

if (goog.LOCALE == 'fr_WF' || goog.LOCALE == 'fr-WF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_WF;
}

if (goog.LOCALE == 'fr_YT' || goog.LOCALE == 'fr-YT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fr_YT;
}

if (goog.LOCALE == 'fur') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fur;
}

if (goog.LOCALE == 'fur_IT' || goog.LOCALE == 'fur-IT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fur_IT;
}

if (goog.LOCALE == 'fy') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fy;
}

if (goog.LOCALE == 'fy_NL' || goog.LOCALE == 'fy-NL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_fy_NL;
}

if (goog.LOCALE == 'ga_IE' || goog.LOCALE == 'ga-IE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ga_IE;
}

if (goog.LOCALE == 'gd') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gd;
}

if (goog.LOCALE == 'gd_GB' || goog.LOCALE == 'gd-GB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gd_GB;
}

if (goog.LOCALE == 'gl_ES' || goog.LOCALE == 'gl-ES') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gl_ES;
}

if (goog.LOCALE == 'gsw_CH' || goog.LOCALE == 'gsw-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw_CH;
}

if (goog.LOCALE == 'gsw_FR' || goog.LOCALE == 'gsw-FR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw_FR;
}

if (goog.LOCALE == 'gsw_LI' || goog.LOCALE == 'gsw-LI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gsw_LI;
}

if (goog.LOCALE == 'gu_IN' || goog.LOCALE == 'gu-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gu_IN;
}

if (goog.LOCALE == 'guz') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_guz;
}

if (goog.LOCALE == 'guz_KE' || goog.LOCALE == 'guz-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_guz_KE;
}

if (goog.LOCALE == 'gv') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gv;
}

if (goog.LOCALE == 'gv_IM' || goog.LOCALE == 'gv-IM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_gv_IM;
}

if (goog.LOCALE == 'ha') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ha;
}

if (goog.LOCALE == 'ha_GH' || goog.LOCALE == 'ha-GH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ha_GH;
}

if (goog.LOCALE == 'ha_NE' || goog.LOCALE == 'ha-NE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ha_NE;
}

if (goog.LOCALE == 'ha_NG' || goog.LOCALE == 'ha-NG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ha_NG;
}

if (goog.LOCALE == 'haw_US' || goog.LOCALE == 'haw-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_haw_US;
}

if (goog.LOCALE == 'he_IL' || goog.LOCALE == 'he-IL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_he_IL;
}

if (goog.LOCALE == 'hi_IN' || goog.LOCALE == 'hi-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hi_IN;
}

if (goog.LOCALE == 'hr_BA' || goog.LOCALE == 'hr-BA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hr_BA;
}

if (goog.LOCALE == 'hr_HR' || goog.LOCALE == 'hr-HR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hr_HR;
}

if (goog.LOCALE == 'hsb') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hsb;
}

if (goog.LOCALE == 'hsb_DE' || goog.LOCALE == 'hsb-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hsb_DE;
}

if (goog.LOCALE == 'hu_HU' || goog.LOCALE == 'hu-HU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hu_HU;
}

if (goog.LOCALE == 'hy_AM' || goog.LOCALE == 'hy-AM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_hy_AM;
}

if (goog.LOCALE == 'id_ID' || goog.LOCALE == 'id-ID') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_id_ID;
}

if (goog.LOCALE == 'ig') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ig;
}

if (goog.LOCALE == 'ig_NG' || goog.LOCALE == 'ig-NG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ig_NG;
}

if (goog.LOCALE == 'ii') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ii;
}

if (goog.LOCALE == 'ii_CN' || goog.LOCALE == 'ii-CN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ii_CN;
}

if (goog.LOCALE == 'is_IS' || goog.LOCALE == 'is-IS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_is_IS;
}

if (goog.LOCALE == 'it_CH' || goog.LOCALE == 'it-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it_CH;
}

if (goog.LOCALE == 'it_IT' || goog.LOCALE == 'it-IT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it_IT;
}

if (goog.LOCALE == 'it_SM' || goog.LOCALE == 'it-SM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_it_SM;
}

if (goog.LOCALE == 'ja_JP' || goog.LOCALE == 'ja-JP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ja_JP;
}

if (goog.LOCALE == 'jgo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_jgo;
}

if (goog.LOCALE == 'jgo_CM' || goog.LOCALE == 'jgo-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_jgo_CM;
}

if (goog.LOCALE == 'jmc') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_jmc;
}

if (goog.LOCALE == 'jmc_TZ' || goog.LOCALE == 'jmc-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_jmc_TZ;
}

if (goog.LOCALE == 'ka_GE' || goog.LOCALE == 'ka-GE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ka_GE;
}

if (goog.LOCALE == 'kab') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kab;
}

if (goog.LOCALE == 'kab_DZ' || goog.LOCALE == 'kab-DZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kab_DZ;
}

if (goog.LOCALE == 'kam') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kam;
}

if (goog.LOCALE == 'kam_KE' || goog.LOCALE == 'kam-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kam_KE;
}

if (goog.LOCALE == 'kde') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kde;
}

if (goog.LOCALE == 'kde_TZ' || goog.LOCALE == 'kde-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kde_TZ;
}

if (goog.LOCALE == 'kea') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kea;
}

if (goog.LOCALE == 'kea_CV' || goog.LOCALE == 'kea-CV') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kea_CV;
}

if (goog.LOCALE == 'khq') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_khq;
}

if (goog.LOCALE == 'khq_ML' || goog.LOCALE == 'khq-ML') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_khq_ML;
}

if (goog.LOCALE == 'ki') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ki;
}

if (goog.LOCALE == 'ki_KE' || goog.LOCALE == 'ki-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ki_KE;
}

if (goog.LOCALE == 'kk_KZ' || goog.LOCALE == 'kk-KZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kk_KZ;
}

if (goog.LOCALE == 'kkj') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kkj;
}

if (goog.LOCALE == 'kkj_CM' || goog.LOCALE == 'kkj-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kkj_CM;
}

if (goog.LOCALE == 'kl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kl;
}

if (goog.LOCALE == 'kl_GL' || goog.LOCALE == 'kl-GL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kl_GL;
}

if (goog.LOCALE == 'kln') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kln;
}

if (goog.LOCALE == 'kln_KE' || goog.LOCALE == 'kln-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kln_KE;
}

if (goog.LOCALE == 'km_KH' || goog.LOCALE == 'km-KH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_km_KH;
}

if (goog.LOCALE == 'kn_IN' || goog.LOCALE == 'kn-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kn_IN;
}

if (goog.LOCALE == 'ko_KP' || goog.LOCALE == 'ko-KP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ko_KP;
}

if (goog.LOCALE == 'ko_KR' || goog.LOCALE == 'ko-KR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ko_KR;
}

if (goog.LOCALE == 'kok') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kok;
}

if (goog.LOCALE == 'kok_IN' || goog.LOCALE == 'kok-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kok_IN;
}

if (goog.LOCALE == 'ks') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ks;
}

if (goog.LOCALE == 'ks_IN' || goog.LOCALE == 'ks-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ks_IN;
}

if (goog.LOCALE == 'ksb') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ksb;
}

if (goog.LOCALE == 'ksb_TZ' || goog.LOCALE == 'ksb-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ksb_TZ;
}

if (goog.LOCALE == 'ksf') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ksf;
}

if (goog.LOCALE == 'ksf_CM' || goog.LOCALE == 'ksf-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ksf_CM;
}

if (goog.LOCALE == 'ksh') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ksh;
}

if (goog.LOCALE == 'ksh_DE' || goog.LOCALE == 'ksh-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ksh_DE;
}

if (goog.LOCALE == 'kw') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kw;
}

if (goog.LOCALE == 'kw_GB' || goog.LOCALE == 'kw-GB') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_kw_GB;
}

if (goog.LOCALE == 'ky_KG' || goog.LOCALE == 'ky-KG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ky_KG;
}

if (goog.LOCALE == 'lag') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lag;
}

if (goog.LOCALE == 'lag_TZ' || goog.LOCALE == 'lag-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lag_TZ;
}

if (goog.LOCALE == 'lb') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lb;
}

if (goog.LOCALE == 'lb_LU' || goog.LOCALE == 'lb-LU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lb_LU;
}

if (goog.LOCALE == 'lg') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lg;
}

if (goog.LOCALE == 'lg_UG' || goog.LOCALE == 'lg-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lg_UG;
}

if (goog.LOCALE == 'lkt') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lkt;
}

if (goog.LOCALE == 'lkt_US' || goog.LOCALE == 'lkt-US') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lkt_US;
}

if (goog.LOCALE == 'ln_AO' || goog.LOCALE == 'ln-AO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln_AO;
}

if (goog.LOCALE == 'ln_CD' || goog.LOCALE == 'ln-CD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln_CD;
}

if (goog.LOCALE == 'ln_CF' || goog.LOCALE == 'ln-CF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln_CF;
}

if (goog.LOCALE == 'ln_CG' || goog.LOCALE == 'ln-CG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ln_CG;
}

if (goog.LOCALE == 'lo_LA' || goog.LOCALE == 'lo-LA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lo_LA;
}

if (goog.LOCALE == 'lrc') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lrc;
}

if (goog.LOCALE == 'lrc_IQ' || goog.LOCALE == 'lrc-IQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lrc_IQ;
}

if (goog.LOCALE == 'lrc_IR' || goog.LOCALE == 'lrc-IR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lrc_IR;
}

if (goog.LOCALE == 'lt_LT' || goog.LOCALE == 'lt-LT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lt_LT;
}

if (goog.LOCALE == 'lu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lu;
}

if (goog.LOCALE == 'lu_CD' || goog.LOCALE == 'lu-CD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lu_CD;
}

if (goog.LOCALE == 'luo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_luo;
}

if (goog.LOCALE == 'luo_KE' || goog.LOCALE == 'luo-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_luo_KE;
}

if (goog.LOCALE == 'luy') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_luy;
}

if (goog.LOCALE == 'luy_KE' || goog.LOCALE == 'luy-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_luy_KE;
}

if (goog.LOCALE == 'lv_LV' || goog.LOCALE == 'lv-LV') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_lv_LV;
}

if (goog.LOCALE == 'mas') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mas;
}

if (goog.LOCALE == 'mas_KE' || goog.LOCALE == 'mas-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mas_KE;
}

if (goog.LOCALE == 'mas_TZ' || goog.LOCALE == 'mas-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mas_TZ;
}

if (goog.LOCALE == 'mer') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mer;
}

if (goog.LOCALE == 'mer_KE' || goog.LOCALE == 'mer-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mer_KE;
}

if (goog.LOCALE == 'mfe') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mfe;
}

if (goog.LOCALE == 'mfe_MU' || goog.LOCALE == 'mfe-MU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mfe_MU;
}

if (goog.LOCALE == 'mg') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mg;
}

if (goog.LOCALE == 'mg_MG' || goog.LOCALE == 'mg-MG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mg_MG;
}

if (goog.LOCALE == 'mgh') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mgh;
}

if (goog.LOCALE == 'mgh_MZ' || goog.LOCALE == 'mgh-MZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mgh_MZ;
}

if (goog.LOCALE == 'mgo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mgo;
}

if (goog.LOCALE == 'mgo_CM' || goog.LOCALE == 'mgo-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mgo_CM;
}

if (goog.LOCALE == 'mk_MK' || goog.LOCALE == 'mk-MK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mk_MK;
}

if (goog.LOCALE == 'ml_IN' || goog.LOCALE == 'ml-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ml_IN;
}

if (goog.LOCALE == 'mn_MN' || goog.LOCALE == 'mn-MN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mn_MN;
}

if (goog.LOCALE == 'mr_IN' || goog.LOCALE == 'mr-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mr_IN;
}

if (goog.LOCALE == 'ms_BN' || goog.LOCALE == 'ms-BN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ms_BN;
}

if (goog.LOCALE == 'ms_MY' || goog.LOCALE == 'ms-MY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ms_MY;
}

if (goog.LOCALE == 'ms_SG' || goog.LOCALE == 'ms-SG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ms_SG;
}

if (goog.LOCALE == 'mt_MT' || goog.LOCALE == 'mt-MT') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mt_MT;
}

if (goog.LOCALE == 'mua') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mua;
}

if (goog.LOCALE == 'mua_CM' || goog.LOCALE == 'mua-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mua_CM;
}

if (goog.LOCALE == 'my_MM' || goog.LOCALE == 'my-MM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_my_MM;
}

if (goog.LOCALE == 'mzn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mzn;
}

if (goog.LOCALE == 'mzn_IR' || goog.LOCALE == 'mzn-IR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_mzn_IR;
}

if (goog.LOCALE == 'naq') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_naq;
}

if (goog.LOCALE == 'naq_NA' || goog.LOCALE == 'naq-NA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_naq_NA;
}

if (goog.LOCALE == 'nb_NO' || goog.LOCALE == 'nb-NO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nb_NO;
}

if (goog.LOCALE == 'nb_SJ' || goog.LOCALE == 'nb-SJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nb_SJ;
}

if (goog.LOCALE == 'nd') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nd;
}

if (goog.LOCALE == 'nd_ZW' || goog.LOCALE == 'nd-ZW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nd_ZW;
}

if (goog.LOCALE == 'nds') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nds;
}

if (goog.LOCALE == 'nds_DE' || goog.LOCALE == 'nds-DE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nds_DE;
}

if (goog.LOCALE == 'nds_NL' || goog.LOCALE == 'nds-NL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nds_NL;
}

if (goog.LOCALE == 'ne_IN' || goog.LOCALE == 'ne-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ne_IN;
}

if (goog.LOCALE == 'ne_NP' || goog.LOCALE == 'ne-NP') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ne_NP;
}

if (goog.LOCALE == 'nl_AW' || goog.LOCALE == 'nl-AW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_AW;
}

if (goog.LOCALE == 'nl_BE' || goog.LOCALE == 'nl-BE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_BE;
}

if (goog.LOCALE == 'nl_BQ' || goog.LOCALE == 'nl-BQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_BQ;
}

if (goog.LOCALE == 'nl_CW' || goog.LOCALE == 'nl-CW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_CW;
}

if (goog.LOCALE == 'nl_NL' || goog.LOCALE == 'nl-NL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_NL;
}

if (goog.LOCALE == 'nl_SR' || goog.LOCALE == 'nl-SR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_SR;
}

if (goog.LOCALE == 'nl_SX' || goog.LOCALE == 'nl-SX') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nl_SX;
}

if (goog.LOCALE == 'nmg') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nmg;
}

if (goog.LOCALE == 'nmg_CM' || goog.LOCALE == 'nmg-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nmg_CM;
}

if (goog.LOCALE == 'nn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nn;
}

if (goog.LOCALE == 'nn_NO' || goog.LOCALE == 'nn-NO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nn_NO;
}

if (goog.LOCALE == 'nnh') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nnh;
}

if (goog.LOCALE == 'nnh_CM' || goog.LOCALE == 'nnh-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nnh_CM;
}

if (goog.LOCALE == 'nus') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nus;
}

if (goog.LOCALE == 'nus_SS' || goog.LOCALE == 'nus-SS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nus_SS;
}

if (goog.LOCALE == 'nyn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nyn;
}

if (goog.LOCALE == 'nyn_UG' || goog.LOCALE == 'nyn-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_nyn_UG;
}

if (goog.LOCALE == 'om') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_om;
}

if (goog.LOCALE == 'om_ET' || goog.LOCALE == 'om-ET') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_om_ET;
}

if (goog.LOCALE == 'om_KE' || goog.LOCALE == 'om-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_om_KE;
}

if (goog.LOCALE == 'or_IN' || goog.LOCALE == 'or-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_or_IN;
}

if (goog.LOCALE == 'os') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_os;
}

if (goog.LOCALE == 'os_GE' || goog.LOCALE == 'os-GE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_os_GE;
}

if (goog.LOCALE == 'os_RU' || goog.LOCALE == 'os-RU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_os_RU;
}

if (goog.LOCALE == 'pa_Arab' || goog.LOCALE == 'pa-Arab') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pa_Arab;
}

if (goog.LOCALE == 'pa_Arab_PK' || goog.LOCALE == 'pa-Arab-PK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pa_Arab_PK;
}

if (goog.LOCALE == 'pa_Guru' || goog.LOCALE == 'pa-Guru') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pa_Guru;
}

if (goog.LOCALE == 'pa_Guru_IN' || goog.LOCALE == 'pa-Guru-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pa_Guru_IN;
}

if (goog.LOCALE == 'pl_PL' || goog.LOCALE == 'pl-PL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pl_PL;
}

if (goog.LOCALE == 'ps') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ps;
}

if (goog.LOCALE == 'ps_AF' || goog.LOCALE == 'ps-AF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ps_AF;
}

if (goog.LOCALE == 'pt_AO' || goog.LOCALE == 'pt-AO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_AO;
}

if (goog.LOCALE == 'pt_CH' || goog.LOCALE == 'pt-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_CH;
}

if (goog.LOCALE == 'pt_CV' || goog.LOCALE == 'pt-CV') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_CV;
}

if (goog.LOCALE == 'pt_GQ' || goog.LOCALE == 'pt-GQ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_GQ;
}

if (goog.LOCALE == 'pt_GW' || goog.LOCALE == 'pt-GW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_GW;
}

if (goog.LOCALE == 'pt_LU' || goog.LOCALE == 'pt-LU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_LU;
}

if (goog.LOCALE == 'pt_MO' || goog.LOCALE == 'pt-MO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_MO;
}

if (goog.LOCALE == 'pt_MZ' || goog.LOCALE == 'pt-MZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_MZ;
}

if (goog.LOCALE == 'pt_ST' || goog.LOCALE == 'pt-ST') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_ST;
}

if (goog.LOCALE == 'pt_TL' || goog.LOCALE == 'pt-TL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_pt_TL;
}

if (goog.LOCALE == 'qu') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_qu;
}

if (goog.LOCALE == 'qu_BO' || goog.LOCALE == 'qu-BO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_qu_BO;
}

if (goog.LOCALE == 'qu_EC' || goog.LOCALE == 'qu-EC') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_qu_EC;
}

if (goog.LOCALE == 'qu_PE' || goog.LOCALE == 'qu-PE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_qu_PE;
}

if (goog.LOCALE == 'rm') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rm;
}

if (goog.LOCALE == 'rm_CH' || goog.LOCALE == 'rm-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rm_CH;
}

if (goog.LOCALE == 'rn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rn;
}

if (goog.LOCALE == 'rn_BI' || goog.LOCALE == 'rn-BI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rn_BI;
}

if (goog.LOCALE == 'ro_MD' || goog.LOCALE == 'ro-MD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ro_MD;
}

if (goog.LOCALE == 'ro_RO' || goog.LOCALE == 'ro-RO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ro_RO;
}

if (goog.LOCALE == 'rof') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rof;
}

if (goog.LOCALE == 'rof_TZ' || goog.LOCALE == 'rof-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rof_TZ;
}

if (goog.LOCALE == 'ru_BY' || goog.LOCALE == 'ru-BY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru_BY;
}

if (goog.LOCALE == 'ru_KG' || goog.LOCALE == 'ru-KG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru_KG;
}

if (goog.LOCALE == 'ru_KZ' || goog.LOCALE == 'ru-KZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru_KZ;
}

if (goog.LOCALE == 'ru_MD' || goog.LOCALE == 'ru-MD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru_MD;
}

if (goog.LOCALE == 'ru_RU' || goog.LOCALE == 'ru-RU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru_RU;
}

if (goog.LOCALE == 'ru_UA' || goog.LOCALE == 'ru-UA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ru_UA;
}

if (goog.LOCALE == 'rw') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rw;
}

if (goog.LOCALE == 'rw_RW' || goog.LOCALE == 'rw-RW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rw_RW;
}

if (goog.LOCALE == 'rwk') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rwk;
}

if (goog.LOCALE == 'rwk_TZ' || goog.LOCALE == 'rwk-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_rwk_TZ;
}

if (goog.LOCALE == 'sah') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sah;
}

if (goog.LOCALE == 'sah_RU' || goog.LOCALE == 'sah-RU') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sah_RU;
}

if (goog.LOCALE == 'saq') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_saq;
}

if (goog.LOCALE == 'saq_KE' || goog.LOCALE == 'saq-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_saq_KE;
}

if (goog.LOCALE == 'sbp') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sbp;
}

if (goog.LOCALE == 'sbp_TZ' || goog.LOCALE == 'sbp-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sbp_TZ;
}

if (goog.LOCALE == 'se') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_se;
}

if (goog.LOCALE == 'se_FI' || goog.LOCALE == 'se-FI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_se_FI;
}

if (goog.LOCALE == 'se_NO' || goog.LOCALE == 'se-NO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_se_NO;
}

if (goog.LOCALE == 'se_SE' || goog.LOCALE == 'se-SE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_se_SE;
}

if (goog.LOCALE == 'seh') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_seh;
}

if (goog.LOCALE == 'seh_MZ' || goog.LOCALE == 'seh-MZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_seh_MZ;
}

if (goog.LOCALE == 'ses') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ses;
}

if (goog.LOCALE == 'ses_ML' || goog.LOCALE == 'ses-ML') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ses_ML;
}

if (goog.LOCALE == 'sg') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sg;
}

if (goog.LOCALE == 'sg_CF' || goog.LOCALE == 'sg-CF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sg_CF;
}

if (goog.LOCALE == 'shi') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_shi;
}

if (goog.LOCALE == 'shi_Latn' || goog.LOCALE == 'shi-Latn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_shi_Latn;
}

if (goog.LOCALE == 'shi_Latn_MA' || goog.LOCALE == 'shi-Latn-MA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_shi_Latn_MA;
}

if (goog.LOCALE == 'shi_Tfng' || goog.LOCALE == 'shi-Tfng') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_shi_Tfng;
}

if (goog.LOCALE == 'shi_Tfng_MA' || goog.LOCALE == 'shi-Tfng-MA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_shi_Tfng_MA;
}

if (goog.LOCALE == 'si_LK' || goog.LOCALE == 'si-LK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_si_LK;
}

if (goog.LOCALE == 'sk_SK' || goog.LOCALE == 'sk-SK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sk_SK;
}

if (goog.LOCALE == 'sl_SI' || goog.LOCALE == 'sl-SI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sl_SI;
}

if (goog.LOCALE == 'smn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_smn;
}

if (goog.LOCALE == 'smn_FI' || goog.LOCALE == 'smn-FI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_smn_FI;
}

if (goog.LOCALE == 'sn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sn;
}

if (goog.LOCALE == 'sn_ZW' || goog.LOCALE == 'sn-ZW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sn_ZW;
}

if (goog.LOCALE == 'so') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_so;
}

if (goog.LOCALE == 'so_DJ' || goog.LOCALE == 'so-DJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_so_DJ;
}

if (goog.LOCALE == 'so_ET' || goog.LOCALE == 'so-ET') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_so_ET;
}

if (goog.LOCALE == 'so_KE' || goog.LOCALE == 'so-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_so_KE;
}

if (goog.LOCALE == 'so_SO' || goog.LOCALE == 'so-SO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_so_SO;
}

if (goog.LOCALE == 'sq_AL' || goog.LOCALE == 'sq-AL') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sq_AL;
}

if (goog.LOCALE == 'sq_MK' || goog.LOCALE == 'sq-MK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sq_MK;
}

if (goog.LOCALE == 'sq_XK' || goog.LOCALE == 'sq-XK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sq_XK;
}

if (goog.LOCALE == 'sr_Cyrl' || goog.LOCALE == 'sr-Cyrl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Cyrl;
}

if (goog.LOCALE == 'sr_Cyrl_BA' || goog.LOCALE == 'sr-Cyrl-BA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_BA;
}

if (goog.LOCALE == 'sr_Cyrl_ME' || goog.LOCALE == 'sr-Cyrl-ME') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_ME;
}

if (goog.LOCALE == 'sr_Cyrl_RS' || goog.LOCALE == 'sr-Cyrl-RS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_RS;
}

if (goog.LOCALE == 'sr_Cyrl_XK' || goog.LOCALE == 'sr-Cyrl-XK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Cyrl_XK;
}

if (goog.LOCALE == 'sr_Latn_BA' || goog.LOCALE == 'sr-Latn-BA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Latn_BA;
}

if (goog.LOCALE == 'sr_Latn_ME' || goog.LOCALE == 'sr-Latn-ME') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Latn_ME;
}

if (goog.LOCALE == 'sr_Latn_RS' || goog.LOCALE == 'sr-Latn-RS') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Latn_RS;
}

if (goog.LOCALE == 'sr_Latn_XK' || goog.LOCALE == 'sr-Latn-XK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sr_Latn_XK;
}

if (goog.LOCALE == 'sv_AX' || goog.LOCALE == 'sv-AX') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sv_AX;
}

if (goog.LOCALE == 'sv_FI' || goog.LOCALE == 'sv-FI') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sv_FI;
}

if (goog.LOCALE == 'sv_SE' || goog.LOCALE == 'sv-SE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sv_SE;
}

if (goog.LOCALE == 'sw_CD' || goog.LOCALE == 'sw-CD') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw_CD;
}

if (goog.LOCALE == 'sw_KE' || goog.LOCALE == 'sw-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw_KE;
}

if (goog.LOCALE == 'sw_TZ' || goog.LOCALE == 'sw-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw_TZ;
}

if (goog.LOCALE == 'sw_UG' || goog.LOCALE == 'sw-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_sw_UG;
}

if (goog.LOCALE == 'ta_IN' || goog.LOCALE == 'ta-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta_IN;
}

if (goog.LOCALE == 'ta_LK' || goog.LOCALE == 'ta-LK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta_LK;
}

if (goog.LOCALE == 'ta_MY' || goog.LOCALE == 'ta-MY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta_MY;
}

if (goog.LOCALE == 'ta_SG' || goog.LOCALE == 'ta-SG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ta_SG;
}

if (goog.LOCALE == 'te_IN' || goog.LOCALE == 'te-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_te_IN;
}

if (goog.LOCALE == 'teo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_teo;
}

if (goog.LOCALE == 'teo_KE' || goog.LOCALE == 'teo-KE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_teo_KE;
}

if (goog.LOCALE == 'teo_UG' || goog.LOCALE == 'teo-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_teo_UG;
}

if (goog.LOCALE == 'th_TH' || goog.LOCALE == 'th-TH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_th_TH;
}

if (goog.LOCALE == 'ti') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ti;
}

if (goog.LOCALE == 'ti_ER' || goog.LOCALE == 'ti-ER') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ti_ER;
}

if (goog.LOCALE == 'ti_ET' || goog.LOCALE == 'ti-ET') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ti_ET;
}

if (goog.LOCALE == 'to') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_to;
}

if (goog.LOCALE == 'to_TO' || goog.LOCALE == 'to-TO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_to_TO;
}

if (goog.LOCALE == 'tr_CY' || goog.LOCALE == 'tr-CY') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tr_CY;
}

if (goog.LOCALE == 'tr_TR' || goog.LOCALE == 'tr-TR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tr_TR;
}

if (goog.LOCALE == 'twq') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_twq;
}

if (goog.LOCALE == 'twq_NE' || goog.LOCALE == 'twq-NE') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_twq_NE;
}

if (goog.LOCALE == 'tzm') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tzm;
}

if (goog.LOCALE == 'tzm_MA' || goog.LOCALE == 'tzm-MA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_tzm_MA;
}

if (goog.LOCALE == 'ug') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ug;
}

if (goog.LOCALE == 'ug_CN' || goog.LOCALE == 'ug-CN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ug_CN;
}

if (goog.LOCALE == 'uk_UA' || goog.LOCALE == 'uk-UA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uk_UA;
}

if (goog.LOCALE == 'ur_IN' || goog.LOCALE == 'ur-IN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ur_IN;
}

if (goog.LOCALE == 'ur_PK' || goog.LOCALE == 'ur-PK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_ur_PK;
}

if (goog.LOCALE == 'uz_Arab' || goog.LOCALE == 'uz-Arab') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz_Arab;
}

if (goog.LOCALE == 'uz_Arab_AF' || goog.LOCALE == 'uz-Arab-AF') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz_Arab_AF;
}

if (goog.LOCALE == 'uz_Cyrl' || goog.LOCALE == 'uz-Cyrl') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz_Cyrl;
}

if (goog.LOCALE == 'uz_Cyrl_UZ' || goog.LOCALE == 'uz-Cyrl-UZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz_Cyrl_UZ;
}

if (goog.LOCALE == 'uz_Latn' || goog.LOCALE == 'uz-Latn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz_Latn;
}

if (goog.LOCALE == 'uz_Latn_UZ' || goog.LOCALE == 'uz-Latn-UZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_uz_Latn_UZ;
}

if (goog.LOCALE == 'vai') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vai;
}

if (goog.LOCALE == 'vai_Latn' || goog.LOCALE == 'vai-Latn') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vai_Latn;
}

if (goog.LOCALE == 'vai_Latn_LR' || goog.LOCALE == 'vai-Latn-LR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vai_Latn_LR;
}

if (goog.LOCALE == 'vai_Vaii' || goog.LOCALE == 'vai-Vaii') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vai_Vaii;
}

if (goog.LOCALE == 'vai_Vaii_LR' || goog.LOCALE == 'vai-Vaii-LR') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vai_Vaii_LR;
}

if (goog.LOCALE == 'vi_VN' || goog.LOCALE == 'vi-VN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vi_VN;
}

if (goog.LOCALE == 'vun') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vun;
}

if (goog.LOCALE == 'vun_TZ' || goog.LOCALE == 'vun-TZ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_vun_TZ;
}

if (goog.LOCALE == 'wae') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_wae;
}

if (goog.LOCALE == 'wae_CH' || goog.LOCALE == 'wae-CH') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_wae_CH;
}

if (goog.LOCALE == 'xog') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_xog;
}

if (goog.LOCALE == 'xog_UG' || goog.LOCALE == 'xog-UG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_xog_UG;
}

if (goog.LOCALE == 'yav') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yav;
}

if (goog.LOCALE == 'yav_CM' || goog.LOCALE == 'yav-CM') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yav_CM;
}

if (goog.LOCALE == 'yi') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yi;
}

if (goog.LOCALE == 'yi_001' || goog.LOCALE == 'yi-001') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yi_001;
}

if (goog.LOCALE == 'yo') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yo;
}

if (goog.LOCALE == 'yo_BJ' || goog.LOCALE == 'yo-BJ') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yo_BJ;
}

if (goog.LOCALE == 'yo_NG' || goog.LOCALE == 'yo-NG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yo_NG;
}

if (goog.LOCALE == 'yue') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yue;
}

if (goog.LOCALE == 'yue_HK' || goog.LOCALE == 'yue-HK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_yue_HK;
}

if (goog.LOCALE == 'zgh') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zgh;
}

if (goog.LOCALE == 'zgh_MA' || goog.LOCALE == 'zgh-MA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zgh_MA;
}

if (goog.LOCALE == 'zh_Hans' || goog.LOCALE == 'zh-Hans') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hans;
}

if (goog.LOCALE == 'zh_Hans_CN' || goog.LOCALE == 'zh-Hans-CN') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hans_CN;
}

if (goog.LOCALE == 'zh_Hans_HK' || goog.LOCALE == 'zh-Hans-HK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hans_HK;
}

if (goog.LOCALE == 'zh_Hans_MO' || goog.LOCALE == 'zh-Hans-MO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hans_MO;
}

if (goog.LOCALE == 'zh_Hans_SG' || goog.LOCALE == 'zh-Hans-SG') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hans_SG;
}

if (goog.LOCALE == 'zh_Hant' || goog.LOCALE == 'zh-Hant') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hant;
}

if (goog.LOCALE == 'zh_Hant_HK' || goog.LOCALE == 'zh-Hant-HK') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hant_HK;
}

if (goog.LOCALE == 'zh_Hant_MO' || goog.LOCALE == 'zh-Hant-MO') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hant_MO;
}

if (goog.LOCALE == 'zh_Hant_TW' || goog.LOCALE == 'zh-Hant-TW') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zh_Hant_TW;
}

if (goog.LOCALE == 'zu_ZA' || goog.LOCALE == 'zu-ZA') {
  goog.i18n.CompactNumberFormatSymbols = goog.i18n.CompactNumberFormatSymbols_zu_ZA;
}
