// Copyright 2016 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// NOTE: This is a generated file.  Do not edit.

// clang-format off

/** @fileoverview @nocompile */
var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.ASSUME_ES5=false;$jscomp.ASSUME_NO_NATIVE_MAP=false;$jscomp.ASSUME_NO_NATIVE_SET=false;$jscomp.SIMPLE_FROUND_POLYFILL=false;$jscomp.defineProperty=$jscomp.ASSUME_ES5||typeof Object.defineProperties=="function"?Object.defineProperty:function(target,property,descriptor){descriptor=descriptor;if(target==Array.prototype||target==Object.prototype)return;target[property]=descriptor.value};
$jscomp.getGlobal=function(maybeGlobal){return typeof window!="undefined"&&window===maybeGlobal?maybeGlobal:typeof global!="undefined"&&global!=null?global:maybeGlobal};$jscomp.global=$jscomp.getGlobal(this);
$jscomp.polyfill=function(target,polyfill,fromLang,toLang){if(!polyfill)return;var obj=$jscomp.global;var split=target.split(".");for(var i=0;i<split.length-1;i++){var key=split[i];if(!(key in obj))obj[key]={};obj=obj[key]}var property=split[split.length-1];var orig=obj[property];var impl=polyfill(orig);if(impl==orig||impl==null)return;$jscomp.defineProperty(obj,property,{configurable:true,writable:true,value:impl})};
$jscomp.polyfill("Array.prototype.copyWithin",function(orig){if(orig)return orig;var polyfill=function(target,start,opt_end){var len=this.length;target=toInteger(target);start=toInteger(start);var end=opt_end===undefined?len:toInteger(opt_end);var to=target<0?Math.max(len+target,0):Math.min(target,len);var from=start<0?Math.max(len+start,0):Math.min(start,len);var final=end<0?Math.max(len+end,0):Math.min(end,len);if(to<from)while(from<final)if(from in this)this[to++]=this[from++];else{delete this[to++];
from++}else{final=Math.min(final,len+from-to);to+=final-from;while(final>from)if(--final in this)this[--to]=this[final];else delete this[--to]}return this};function toInteger(arg){var n=Number(arg);if(n===Infinity||n===-Infinity)return n;return n|0}return polyfill},"es6","es3");$jscomp.arrayIteratorImpl=function(array){var index=0;return function(){if(index<array.length)return{done:false,value:array[index++]};else return{done:true}}};$jscomp.arrayIterator=function(array){return{next:$jscomp.arrayIteratorImpl(array)}};
$jscomp.SYMBOL_PREFIX="jscomp_symbol_";$jscomp.initSymbol=function(){$jscomp.initSymbol=function(){};if(!$jscomp.global["Symbol"])$jscomp.global["Symbol"]=$jscomp.Symbol};$jscomp.SymbolClass=function(id,opt_description){this.$jscomp$symbol$id_=id;this.description;$jscomp.defineProperty(this,"description",{configurable:true,writable:true,value:opt_description})};$jscomp.SymbolClass.prototype.toString=function(){return this.$jscomp$symbol$id_};
$jscomp.Symbol=function(){var counter=0;function Symbol(opt_description){if(this instanceof Symbol)throw new TypeError("Symbol is not a constructor");return new $jscomp.SymbolClass($jscomp.SYMBOL_PREFIX+(opt_description||"")+"_"+counter++,opt_description)}return Symbol}();
$jscomp.initSymbolIterator=function(){$jscomp.initSymbol();var symbolIterator=$jscomp.global["Symbol"].iterator;if(!symbolIterator)symbolIterator=$jscomp.global["Symbol"].iterator=$jscomp.global["Symbol"]("Symbol.iterator");if(typeof Array.prototype[symbolIterator]!="function")$jscomp.defineProperty(Array.prototype,symbolIterator,{configurable:true,writable:true,value:function(){return $jscomp.iteratorPrototype($jscomp.arrayIteratorImpl(this))}});$jscomp.initSymbolIterator=function(){}};
$jscomp.initSymbolAsyncIterator=function(){$jscomp.initSymbol();var symbolAsyncIterator=$jscomp.global["Symbol"].asyncIterator;if(!symbolAsyncIterator)symbolAsyncIterator=$jscomp.global["Symbol"].asyncIterator=$jscomp.global["Symbol"]("Symbol.asyncIterator");$jscomp.initSymbolAsyncIterator=function(){}};$jscomp.iteratorPrototype=function(next){$jscomp.initSymbolIterator();var iterator={next:next};iterator[$jscomp.global["Symbol"].iterator]=function(){return this};return iterator};
$jscomp.iteratorFromArray=function(array,transform){$jscomp.initSymbolIterator();if(array instanceof String)array=array+"";var i=0;var iter={next:function(){if(i<array.length){var index=i++;return{value:transform(index,array[index]),done:false}}iter.next=function(){return{done:true,value:void 0}};return iter.next()}};iter[Symbol.iterator]=function(){return iter};return iter};
$jscomp.polyfill("Array.prototype.entries",function(orig){if(orig)return orig;var polyfill=function(){return $jscomp.iteratorFromArray(this,function(i,v){return[i,v]})};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.fill",function(orig){if(orig)return orig;var polyfill=function(value,opt_start,opt_end){var length=this.length||0;if(opt_start<0)opt_start=Math.max(0,length+opt_start);if(opt_end==null||opt_end>length)opt_end=length;opt_end=Number(opt_end);if(opt_end<0)opt_end=Math.max(0,length+opt_end);for(var i=Number(opt_start||0);i<opt_end;i++)this[i]=value;return this};return polyfill},"es6","es3");
$jscomp.findInternal=function(array,callback,thisArg){if(array instanceof String)array=String(array);var len=array.length;for(var i=0;i<len;i++){var value=array[i];if(callback.call(thisArg,value,i,array))return{i:i,v:value}}return{i:-1,v:void 0}};$jscomp.polyfill("Array.prototype.find",function(orig){if(orig)return orig;var polyfill=function(callback,opt_thisArg){return $jscomp.findInternal(this,callback,opt_thisArg).v};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.findIndex",function(orig){if(orig)return orig;var polyfill=function(callback,opt_thisArg){return $jscomp.findInternal(this,callback,opt_thisArg).i};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.flat",function(orig){if(orig)return orig;var flat=function(depth){depth=depth===undefined?1:Number(depth);var flattened=[];for(var i=0;i<this.length;i++){var element=this[i];if(Array.isArray(element)&&depth>0){var inner=Array.prototype.flat.call(element,depth-1);flattened.push.apply(flattened,inner)}else flattened.push(element)}return flattened};return flat},"es9","es5");
$jscomp.polyfill("Array.prototype.flatMap",function(orig){if(orig)return orig;var flatMap=function(callback,thisArg){var mapped=[];for(var i=0;i<this.length;i++){var result=callback.call(thisArg,this[i],i,this);if(Array.isArray(result))mapped.push.apply(mapped,result);else mapped.push(result)}return mapped};return flatMap},"es9","es5");
$jscomp.polyfill("Array.from",function(orig){if(orig)return orig;var polyfill=function(arrayLike,opt_mapFn,opt_thisArg){opt_mapFn=opt_mapFn!=null?opt_mapFn:function(x){return x};var result=[];var iteratorFunction=typeof Symbol!="undefined"&&Symbol.iterator&&arrayLike[Symbol.iterator];if(typeof iteratorFunction=="function"){arrayLike=iteratorFunction.call(arrayLike);var next;var k=0;while(!(next=arrayLike.next()).done)result.push(opt_mapFn.call(opt_thisArg,next.value,k++))}else{var len=arrayLike.length;
for(var i=0;i<len;i++)result.push(opt_mapFn.call(opt_thisArg,arrayLike[i],i))}return result};return polyfill},"es6","es3");$jscomp.polyfill("Object.is",function(orig){if(orig)return orig;var polyfill=function(left,right){if(left===right)return left!==0||1/left===1/right;else return left!==left&&right!==right};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.includes",function(orig){if(orig)return orig;var includes=function(searchElement,opt_fromIndex){var array=this;if(array instanceof String)array=String(array);var len=array.length;var i=opt_fromIndex||0;if(i<0)i=Math.max(i+len,0);for(;i<len;i++){var element=array[i];if(element===searchElement||Object.is(element,searchElement))return true}return false};return includes},"es7","es3");
$jscomp.polyfill("Array.prototype.keys",function(orig){if(orig)return orig;var polyfill=function(){return $jscomp.iteratorFromArray(this,function(i){return i})};return polyfill},"es6","es3");$jscomp.polyfill("Array.of",function(orig){if(orig)return orig;var polyfill=function(var_args){return Array.from(arguments)};return polyfill},"es6","es3");
$jscomp.polyfill("Array.prototype.values",function(orig){if(orig)return orig;var polyfill=function(){return $jscomp.iteratorFromArray(this,function(k,v){return v})};return polyfill},"es8","es3");$jscomp.makeIterator=function(iterable){var iteratorFunction=typeof Symbol!="undefined"&&Symbol.iterator&&iterable[Symbol.iterator];return iteratorFunction?iteratorFunction.call(iterable):$jscomp.arrayIterator(iterable)};$jscomp.FORCE_POLYFILL_PROMISE=false;
$jscomp.polyfill("Promise",function(NativePromise){if(NativePromise&&!$jscomp.FORCE_POLYFILL_PROMISE)return NativePromise;function AsyncExecutor(){this.batch_=null}AsyncExecutor.prototype.asyncExecute=function(f){if(this.batch_==null){this.batch_=[];var self=this;this.asyncExecuteFunction(function(){self.executeBatch_()})}this.batch_.push(f)};var nativeSetTimeout=$jscomp.global["setTimeout"];AsyncExecutor.prototype.asyncExecuteFunction=function(f){nativeSetTimeout(f,0)};AsyncExecutor.prototype.executeBatch_=
function(){while(this.batch_&&this.batch_.length){var executingBatch=this.batch_;this.batch_=[];for(var i=0;i<executingBatch.length;++i){var f=executingBatch[i];executingBatch[i]=null;try{f()}catch(error){this.asyncThrow_(error)}}}this.batch_=null};AsyncExecutor.prototype.asyncThrow_=function(exception){this.asyncExecuteFunction(function(){throw exception;})};var PromiseState={PENDING:0,FULFILLED:1,REJECTED:2};var PolyfillPromise=function(executor){this.state_=PromiseState.PENDING;this.result_=undefined;
this.onSettledCallbacks_=[];var resolveAndReject=this.createResolveAndReject_();try{executor(resolveAndReject.resolve,resolveAndReject.reject)}catch(e){resolveAndReject.reject(e)}};PolyfillPromise.prototype.createResolveAndReject_=function(){var thisPromise=this;var alreadyCalled=false;function firstCallWins(method){return function(x){if(!alreadyCalled){alreadyCalled=true;method.call(thisPromise,x)}}}return{resolve:firstCallWins(this.resolveTo_),reject:firstCallWins(this.reject_)}};PolyfillPromise.prototype.resolveTo_=
function(value){if(value===this)this.reject_(new TypeError("A Promise cannot resolve to itself"));else if(value instanceof PolyfillPromise)this.settleSameAsPromise_(value);else if(isObject(value))this.resolveToNonPromiseObj_(value);else this.fulfill_(value)};PolyfillPromise.prototype.resolveToNonPromiseObj_=function(obj){var thenMethod=undefined;try{thenMethod=obj.then}catch(error){this.reject_(error);return}if(typeof thenMethod=="function")this.settleSameAsThenable_(thenMethod,obj);else this.fulfill_(obj)};
function isObject(value){switch(typeof value){case "object":return value!=null;case "function":return true;default:return false}}PolyfillPromise.prototype.reject_=function(reason){this.settle_(PromiseState.REJECTED,reason)};PolyfillPromise.prototype.fulfill_=function(value){this.settle_(PromiseState.FULFILLED,value)};PolyfillPromise.prototype.settle_=function(settledState,valueOrReason){if(this.state_!=PromiseState.PENDING)throw new Error("Cannot settle("+settledState+", "+valueOrReason+"): Promise already settled in state"+
this.state_);this.state_=settledState;this.result_=valueOrReason;this.executeOnSettledCallbacks_()};PolyfillPromise.prototype.executeOnSettledCallbacks_=function(){if(this.onSettledCallbacks_!=null){for(var i=0;i<this.onSettledCallbacks_.length;++i)asyncExecutor.asyncExecute(this.onSettledCallbacks_[i]);this.onSettledCallbacks_=null}};var asyncExecutor=new AsyncExecutor;PolyfillPromise.prototype.settleSameAsPromise_=function(promise){var methods=this.createResolveAndReject_();promise.callWhenSettled_(methods.resolve,
methods.reject)};PolyfillPromise.prototype.settleSameAsThenable_=function(thenMethod,thenable){var methods=this.createResolveAndReject_();try{thenMethod.call(thenable,methods.resolve,methods.reject)}catch(error){methods.reject(error)}};PolyfillPromise.prototype.then=function(onFulfilled,onRejected){var resolveChild;var rejectChild;var childPromise=new PolyfillPromise(function(resolve,reject){resolveChild=resolve;rejectChild=reject});function createCallback(paramF,defaultF){if(typeof paramF=="function")return function(x){try{resolveChild(paramF(x))}catch(error){rejectChild(error)}};
else return defaultF}this.callWhenSettled_(createCallback(onFulfilled,resolveChild),createCallback(onRejected,rejectChild));return childPromise};PolyfillPromise.prototype["catch"]=function(onRejected){return this.then(undefined,onRejected)};PolyfillPromise.prototype.callWhenSettled_=function(onFulfilled,onRejected){var thisPromise=this;function callback(){switch(thisPromise.state_){case PromiseState.FULFILLED:onFulfilled(thisPromise.result_);break;case PromiseState.REJECTED:onRejected(thisPromise.result_);
break;default:throw new Error("Unexpected state: "+thisPromise.state_);}}if(this.onSettledCallbacks_==null)asyncExecutor.asyncExecute(callback);else this.onSettledCallbacks_.push(callback)};function resolvingPromise(opt_value){if(opt_value instanceof PolyfillPromise)return opt_value;else return new PolyfillPromise(function(resolve,reject){resolve(opt_value)})}PolyfillPromise["resolve"]=resolvingPromise;PolyfillPromise["reject"]=function(opt_reason){return new PolyfillPromise(function(resolve,reject){reject(opt_reason)})};
PolyfillPromise["race"]=function(thenablesOrValues){return new PolyfillPromise(function(resolve,reject){var iterator=$jscomp.makeIterator(thenablesOrValues);for(var iterRec=iterator.next();!iterRec.done;iterRec=iterator.next())resolvingPromise(iterRec.value).callWhenSettled_(resolve,reject)})};PolyfillPromise["all"]=function(thenablesOrValues){var iterator=$jscomp.makeIterator(thenablesOrValues);var iterRec=iterator.next();if(iterRec.done)return resolvingPromise([]);else return new PolyfillPromise(function(resolveAll,
rejectAll){var resultsArray=[];var unresolvedCount=0;function onFulfilled(i){return function(ithResult){resultsArray[i]=ithResult;unresolvedCount--;if(unresolvedCount==0)resolveAll(resultsArray)}}do{resultsArray.push(undefined);unresolvedCount++;resolvingPromise(iterRec.value).callWhenSettled_(onFulfilled(resultsArray.length-1),rejectAll);iterRec=iterator.next()}while(!iterRec.done)})};return PolyfillPromise},"es6","es3");
$jscomp.polyfill("Promise.prototype.finally",function(orig){if(orig)return orig;var polyfill=function(onFinally){return this.then(function(value){var promise=Promise.resolve(onFinally());return promise.then(function(){return value})},function(reason){var promise=Promise.resolve(onFinally());return promise.then(function(){throw reason;})})};return polyfill},"es9","es3");
$jscomp.makeAsyncIterator=function(iterable){$jscomp.initSymbolAsyncIterator();var asyncIteratorFunction=iterable[Symbol.asyncIterator];if(asyncIteratorFunction!==undefined)return asyncIteratorFunction.call(iterable);return new $jscomp.AsyncIteratorFromSyncWrapper($jscomp.makeIterator(iterable))};
$jscomp.AsyncIteratorFromSyncWrapper=function(iterator){this[Symbol.asyncIterator]=function(){return this};this[Symbol.iterator]=function(){return iterator};this.next=function(param){return Promise.resolve(iterator.next(param))};if(iterator["throw"]!==undefined)this["throw"]=function(param){return Promise.resolve(iterator["throw"](param))};if(iterator["return"]!==undefined)this["return"]=function(param){return Promise.resolve(iterator["return"](param))}};
$jscomp.AsyncGeneratorWrapper$ActionEnum={YIELD_VALUE:0,YIELD_STAR:1,AWAIT_VALUE:2};$jscomp.AsyncGeneratorWrapper$ActionRecord=function(action,value){this.action=action;this.value=value};$jscomp.AsyncGeneratorWrapper$GeneratorMethod={NEXT:"next",THROW:"throw",RETURN:"return"};$jscomp.AsyncGeneratorWrapper$ExecutionFrame_=function(method,param,resolve,reject){this.method=method;this.param=param;this.resolve=resolve;this.reject=reject};
$jscomp.AsyncGeneratorWrapper$ExecutionNode_=function(frame,next){this.frame=frame;this.next=next};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_=function(){this.head_=null;this.tail_=null};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.isEmpty=function(){return this.head_===null};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.first=function(){if(this.head_)return this.head_.frame;else throw new Error("no frames in executionQueue");};
$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.drop=function(){if(this.head_){this.head_=this.head_.next;if(!this.head_)this.tail_=null}};$jscomp.AsyncGeneratorWrapper$ExecutionQueue_.prototype.enqueue=function(newFrame){var node=new $jscomp.AsyncGeneratorWrapper$ExecutionNode_(newFrame,null);if(this.tail_){this.tail_.next=node;this.tail_=node}else{this.head_=node;this.tail_=node}};
$jscomp.AsyncGeneratorWrapper=function(generator){this.generator_=generator;this.delegate_=null;this.executionQueue_=new $jscomp.AsyncGeneratorWrapper$ExecutionQueue_;$jscomp.initSymbolAsyncIterator();this[Symbol.asyncIterator]=function(){return this};var self=this;this.boundHandleDelegateResult_=function(record){self.handleDelegateResult_(record)};this.boundHandleDelegateError_=function(thrownError){self.handleDelegateError_(thrownError)};this.boundRejectAndClose_=function(err){self.rejectAndClose_(err)}};
$jscomp.AsyncGeneratorWrapper.prototype.enqueueMethod_=function(method,param){var self=this;return new Promise(function(resolve,reject){var wasEmpty=self.executionQueue_.isEmpty();self.executionQueue_.enqueue(new $jscomp.AsyncGeneratorWrapper$ExecutionFrame_(method,param,resolve,reject));if(wasEmpty)self.runFrame_()})};$jscomp.AsyncGeneratorWrapper.prototype.next=function(opt_value){return this.enqueueMethod_($jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT,opt_value)};
$jscomp.AsyncGeneratorWrapper.prototype["return"]=function(value){return this.enqueueMethod_($jscomp.AsyncGeneratorWrapper$GeneratorMethod.RETURN,new $jscomp.AsyncGeneratorWrapper$ActionRecord($jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE,value))};$jscomp.AsyncGeneratorWrapper.prototype["throw"]=function(exception){return this.enqueueMethod_($jscomp.AsyncGeneratorWrapper$GeneratorMethod.THROW,exception)};
$jscomp.AsyncGeneratorWrapper.prototype.runFrame_=function(){if(!this.executionQueue_.isEmpty())try{if(this.delegate_)this.runDelegateFrame_();else this.runGeneratorFrame_()}catch(err){this.rejectAndClose_(err)}};
$jscomp.AsyncGeneratorWrapper.prototype.runGeneratorFrame_=function(){var self=this;var frame=this.executionQueue_.first();try{var genRec=this.generator_[frame.method](frame.param);if(genRec.value instanceof $jscomp.AsyncGeneratorWrapper$ActionRecord)switch(genRec.value.action){case $jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE:Promise.resolve(genRec.value.value).then(function(resolvedValue){frame.resolve({value:resolvedValue,done:genRec.done});self.executionQueue_.drop();self.runFrame_()},
function(e){frame.reject(e);self.executionQueue_.drop();self.runFrame_()})["catch"](this.boundRejectAndClose_);return;case $jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR:self.delegate_=$jscomp.makeAsyncIterator(genRec.value.value);frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT;frame.param=undefined;self.runFrame_();return;case $jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE:Promise.resolve(genRec.value.value).then(function(resolvedValue){frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT;
frame.param=resolvedValue;self.runFrame_()},function(thrownErr){frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.THROW;frame.param=thrownErr;self.runFrame_()})["catch"](this.boundRejectAndClose_);return;default:throw new Error("Unrecognized AsyncGeneratorWrapper$ActionEnum");}else{frame.resolve(genRec);self.executionQueue_.drop();self.runFrame_()}}catch(e){frame.reject(e);self.executionQueue_.drop();self.runFrame_()}};
$jscomp.AsyncGeneratorWrapper.prototype.runDelegateFrame_=function(){if(!this.delegate_)throw new Error("no delegate to perform execution");var frame=this.executionQueue_.first();if(frame.method in this.delegate_)try{this.delegate_[frame.method](frame.param).then(this.boundHandleDelegateResult_,this.boundHandleDelegateError_)["catch"](this.boundRejectAndClose_)}catch(err){this.handleDelegateError_(err)}else{this.delegate_=null;this.runFrame_()}};
$jscomp.AsyncGeneratorWrapper.prototype.handleDelegateResult_=function(record){var frame=this.executionQueue_.first();if(record.done===true){this.delegate_=null;frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.NEXT;frame.param=record.value;this.runFrame_()}else{frame.resolve({value:record.value,done:false});this.executionQueue_.drop();this.runFrame_()}};
$jscomp.AsyncGeneratorWrapper.prototype.handleDelegateError_=function(thrownError){var frame=this.executionQueue_.first();this.delegate_=null;frame.method=$jscomp.AsyncGeneratorWrapper$GeneratorMethod.THROW;frame.param=thrownError;this.runFrame_()};
$jscomp.AsyncGeneratorWrapper.prototype.rejectAndClose_=function(err){if(!this.executionQueue_.isEmpty()){this.executionQueue_.first().reject(err);this.executionQueue_.drop()}if(this.delegate_&&"return"in this.delegate_){this.delegate_["return"](undefined);this.delegate_=null}this.generator_["return"](undefined);this.runFrame_()};$jscomp.underscoreProtoCanBeSet=function(){var x={a:true};var y={};try{y.__proto__=x;return y.a}catch(e){}return false};
$jscomp.setPrototypeOf=typeof Object.setPrototypeOf=="function"?Object.setPrototypeOf:$jscomp.underscoreProtoCanBeSet()?function(target,proto){target.__proto__=proto;if(target.__proto__!==proto)throw new TypeError(target+" is not extensible");return target}:null;$jscomp.generator={};$jscomp.generator.ensureIteratorResultIsObject_=function(result){if(result instanceof Object)return;throw new TypeError("Iterator result "+result+" is not an object");};
$jscomp.generator.Context=function(){this.isRunning_=false;this.yieldAllIterator_=null;this.yieldResult=undefined;this.nextAddress=1;this.catchAddress_=0;this.finallyAddress_=0;this.abruptCompletion_=null;this.finallyContexts_=null};$jscomp.generator.Context.prototype.start_=function(){if(this.isRunning_)throw new TypeError("Generator is already running");this.isRunning_=true};$jscomp.generator.Context.prototype.stop_=function(){this.isRunning_=false};
$jscomp.generator.Context.prototype.jumpToErrorHandler_=function(){this.nextAddress=this.catchAddress_||this.finallyAddress_};$jscomp.generator.Context.prototype.next_=function(value){this.yieldResult=value};$jscomp.generator.Context.prototype.throw_=function(e){this.abruptCompletion_={exception:e,isException:true};this.jumpToErrorHandler_()};$jscomp.generator.Context.prototype["return"]=function(value){this.abruptCompletion_={"return":value};this.nextAddress=this.finallyAddress_};
$jscomp.generator.Context.prototype.jumpThroughFinallyBlocks=function(nextAddress){this.abruptCompletion_={jumpTo:nextAddress};this.nextAddress=this.finallyAddress_};$jscomp.generator.Context.prototype.yield=function(value,resumeAddress){this.nextAddress=resumeAddress;return{value:value}};
$jscomp.generator.Context.prototype.yieldAll=function(iterable,resumeAddress){var iterator=$jscomp.makeIterator(iterable);var result=iterator.next();$jscomp.generator.ensureIteratorResultIsObject_(result);if(result.done){this.yieldResult=result.value;this.nextAddress=resumeAddress;return}this.yieldAllIterator_=iterator;return this.yield(result.value,resumeAddress)};$jscomp.generator.Context.prototype.jumpTo=function(nextAddress){this.nextAddress=nextAddress};
$jscomp.generator.Context.prototype.jumpToEnd=function(){this.nextAddress=0};$jscomp.generator.Context.prototype.setCatchFinallyBlocks=function(catchAddress,finallyAddress){this.catchAddress_=catchAddress;if(finallyAddress!=undefined)this.finallyAddress_=finallyAddress};$jscomp.generator.Context.prototype.setFinallyBlock=function(finallyAddress){this.catchAddress_=0;this.finallyAddress_=finallyAddress||0};
$jscomp.generator.Context.prototype.leaveTryBlock=function(nextAddress,catchAddress){this.nextAddress=nextAddress;this.catchAddress_=catchAddress||0};$jscomp.generator.Context.prototype.enterCatchBlock=function(nextCatchBlockAddress){this.catchAddress_=nextCatchBlockAddress||0;var exception=this.abruptCompletion_.exception;this.abruptCompletion_=null;return exception};
$jscomp.generator.Context.prototype.enterFinallyBlock=function(nextCatchAddress,nextFinallyAddress,finallyDepth){if(!finallyDepth)this.finallyContexts_=[this.abruptCompletion_];else this.finallyContexts_[finallyDepth]=this.abruptCompletion_;this.catchAddress_=nextCatchAddress||0;this.finallyAddress_=nextFinallyAddress||0};
$jscomp.generator.Context.prototype.leaveFinallyBlock=function(nextAddress,finallyDepth){var preservedContext=this.finallyContexts_.splice(finallyDepth||0)[0];var abruptCompletion=this.abruptCompletion_=this.abruptCompletion_||preservedContext;if(abruptCompletion){if(abruptCompletion.isException)return this.jumpToErrorHandler_();if(abruptCompletion.jumpTo!=undefined&&this.finallyAddress_<abruptCompletion.jumpTo){this.nextAddress=abruptCompletion.jumpTo;this.abruptCompletion_=null}else this.nextAddress=
this.finallyAddress_}else this.nextAddress=nextAddress};$jscomp.generator.Context.prototype.forIn=function(object){return new $jscomp.generator.Context.PropertyIterator(object)};$jscomp.generator.Context.PropertyIterator=function(object){this.object_=object;this.properties_=[];for(var property in object)this.properties_.push(property);this.properties_.reverse()};
$jscomp.generator.Context.PropertyIterator.prototype.getNext=function(){while(this.properties_.length>0){var property=this.properties_.pop();if(property in this.object_)return property}return null};$jscomp.generator.Engine_=function(program){this.context_=new $jscomp.generator.Context;this.program_=program};
$jscomp.generator.Engine_.prototype.next_=function(value){this.context_.start_();if(this.context_.yieldAllIterator_)return this.yieldAllStep_(this.context_.yieldAllIterator_.next,value,this.context_.next_);this.context_.next_(value);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.return_=function(value){this.context_.start_();var yieldAllIterator=this.context_.yieldAllIterator_;if(yieldAllIterator){var returnFunction="return"in yieldAllIterator?yieldAllIterator["return"]:function(v){return{value:v,done:true}};return this.yieldAllStep_(returnFunction,value,this.context_["return"])}this.context_["return"](value);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.throw_=function(exception){this.context_.start_();if(this.context_.yieldAllIterator_)return this.yieldAllStep_(this.context_.yieldAllIterator_["throw"],exception,this.context_.next_);this.context_.throw_(exception);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.yieldAllStep_=function(action,value,nextAction){try{var result=action.call(this.context_.yieldAllIterator_,value);$jscomp.generator.ensureIteratorResultIsObject_(result);if(!result.done){this.context_.stop_();return result}var resultValue=result.value}catch(e){this.context_.yieldAllIterator_=null;this.context_.throw_(e);return this.nextStep_()}this.context_.yieldAllIterator_=null;nextAction.call(this.context_,resultValue);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.nextStep_=function(){while(this.context_.nextAddress)try{var yieldValue=this.program_(this.context_);if(yieldValue){this.context_.stop_();return{value:yieldValue.value,done:false}}}catch(e){this.context_.yieldResult=undefined;this.context_.throw_(e)}this.context_.stop_();if(this.context_.abruptCompletion_){var abruptCompletion=this.context_.abruptCompletion_;this.context_.abruptCompletion_=null;if(abruptCompletion.isException)throw abruptCompletion.exception;return{value:abruptCompletion["return"],
done:true}}return{value:undefined,done:true}};$jscomp.generator.Generator_=function(engine){this.next=function(opt_value){return engine.next_(opt_value)};this["throw"]=function(exception){return engine.throw_(exception)};this["return"]=function(value){return engine.return_(value)};$jscomp.initSymbolIterator();this[Symbol.iterator]=function(){return this}};
$jscomp.generator.createGenerator=function(generator,program){var result=new $jscomp.generator.Generator_(new $jscomp.generator.Engine_(program));if($jscomp.setPrototypeOf)$jscomp.setPrototypeOf(result,generator.prototype);return result};
$jscomp.asyncExecutePromiseGenerator=function(generator){function passValueToGenerator(value){return generator.next(value)}function passErrorToGenerator(error){return generator["throw"](error)}return new Promise(function(resolve,reject){function handleGeneratorRecord(genRec){if(genRec.done)resolve(genRec.value);else Promise.resolve(genRec.value).then(passValueToGenerator,passErrorToGenerator).then(handleGeneratorRecord,reject)}handleGeneratorRecord(generator.next())})};
$jscomp.asyncExecutePromiseGeneratorFunction=function(generatorFunction){return $jscomp.asyncExecutePromiseGenerator(generatorFunction())};$jscomp.asyncExecutePromiseGeneratorProgram=function(program){return $jscomp.asyncExecutePromiseGenerator(new $jscomp.generator.Generator_(new $jscomp.generator.Engine_(program)))};
$jscomp.checkEs6ConformanceViaProxy=function(){try{var proxied={};var proxy=Object.create(new $jscomp.global["Proxy"](proxied,{"get":function(target,key,receiver){return target==proxied&&key=="q"&&receiver==proxy}}));return proxy["q"]===true}catch(err){return false}};$jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS=false;$jscomp.ES6_CONFORMANCE=$jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS&&$jscomp.checkEs6ConformanceViaProxy();
$jscomp.owns=function(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop)};
$jscomp.polyfill("WeakMap",function(NativeWeakMap){function isConformant(){if(!NativeWeakMap||!Object.seal)return false;try{var x=Object.seal({});var y=Object.seal({});var map=new NativeWeakMap([[x,2],[y,3]]);if(map.get(x)!=2||map.get(y)!=3)return false;map["delete"](x);map.set(y,4);return!map.has(x)&&map.get(y)==4}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeWeakMap&&$jscomp.ES6_CONFORMANCE)return NativeWeakMap}else if(isConformant())return NativeWeakMap;var prop=
"$jscomp_hidden_"+Math.random();function WeakMapMembership(){}function insert(target){if(!$jscomp.owns(target,prop)){var obj=new WeakMapMembership;$jscomp.defineProperty(target,prop,{value:obj})}}function patch(name){var prev=Object[name];if(prev)Object[name]=function(target){if(target instanceof WeakMapMembership)return target;else{insert(target);return prev(target)}}}patch("freeze");patch("preventExtensions");patch("seal");var index=0;var PolyfillWeakMap=function(opt_iterable){this.id_=(index+=
Math.random()+1).toString();if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);var entry;while(!(entry=iter.next()).done){var item=entry.value;this.set(item[0],item[1])}}};PolyfillWeakMap.prototype.set=function(key,value){insert(key);if(!$jscomp.owns(key,prop))throw new Error("WeakMap key fail: "+key);key[prop][this.id_]=value;return this};PolyfillWeakMap.prototype.get=function(key){return $jscomp.owns(key,prop)?key[prop][this.id_]:undefined};PolyfillWeakMap.prototype.has=function(key){return $jscomp.owns(key,
prop)&&$jscomp.owns(key[prop],this.id_)};PolyfillWeakMap.prototype["delete"]=function(key){if(!$jscomp.owns(key,prop)||!$jscomp.owns(key[prop],this.id_))return false;return delete key[prop][this.id_]};return PolyfillWeakMap},"es6","es3");$jscomp.MapEntry=function(){this.previous;this.next;this.head;this.key;this.value};
$jscomp.polyfill("Map",function(NativeMap){function isConformant(){if($jscomp.ASSUME_NO_NATIVE_MAP||!NativeMap||typeof NativeMap!="function"||!NativeMap.prototype.entries||typeof Object.seal!="function")return false;try{NativeMap=NativeMap;var key=Object.seal({x:4});var map=new NativeMap($jscomp.makeIterator([[key,"s"]]));if(map.get(key)!="s"||map.size!=1||map.get({x:4})||map.set({x:4},"t")!=map||map.size!=2)return false;var iter=map.entries();var item=iter.next();if(item.done||item.value[0]!=key||
item.value[1]!="s")return false;item=iter.next();if(item.done||item.value[0].x!=4||item.value[1]!="t"||!iter.next().done)return false;return true}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeMap&&$jscomp.ES6_CONFORMANCE)return NativeMap}else if(isConformant())return NativeMap;$jscomp.initSymbolIterator();var idMap=new WeakMap;var PolyfillMap=function(opt_iterable){this.data_={};this.head_=createHead();this.size=0;if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);
var entry;while(!(entry=iter.next()).done){var item=entry.value;this.set(item[0],item[1])}}};PolyfillMap.prototype.set=function(key,value){key=key===0?0:key;var r=maybeGetEntry(this,key);if(!r.list)r.list=this.data_[r.id]=[];if(!r.entry){r.entry={next:this.head_,previous:this.head_.previous,head:this.head_,key:key,value:value};r.list.push(r.entry);this.head_.previous.next=r.entry;this.head_.previous=r.entry;this.size++}else r.entry.value=value;return this};PolyfillMap.prototype["delete"]=function(key){var r=
maybeGetEntry(this,key);if(r.entry&&r.list){r.list.splice(r.index,1);if(!r.list.length)delete this.data_[r.id];r.entry.previous.next=r.entry.next;r.entry.next.previous=r.entry.previous;r.entry.head=null;this.size--;return true}return false};PolyfillMap.prototype.clear=function(){this.data_={};this.head_=this.head_.previous=createHead();this.size=0};PolyfillMap.prototype.has=function(key){return!!maybeGetEntry(this,key).entry};PolyfillMap.prototype.get=function(key){var entry=maybeGetEntry(this,key).entry;
return entry&&entry.value};PolyfillMap.prototype.entries=function(){return makeIterator(this,function(entry){return[entry.key,entry.value]})};PolyfillMap.prototype.keys=function(){return makeIterator(this,function(entry){return entry.key})};PolyfillMap.prototype.values=function(){return makeIterator(this,function(entry){return entry.value})};PolyfillMap.prototype.forEach=function(callback,opt_thisArg){var iter=this.entries();var item;while(!(item=iter.next()).done){var entry=item.value;callback.call(opt_thisArg,
entry[1],entry[0],this)}};PolyfillMap.prototype[Symbol.iterator]=PolyfillMap.prototype.entries;var maybeGetEntry=function(map,key){var id=getId(key);var list=map.data_[id];if(list&&$jscomp.owns(map.data_,id))for(var index=0;index<list.length;index++){var entry=list[index];if(key!==key&&entry.key!==entry.key||key===entry.key)return{id:id,list:list,index:index,entry:entry}}return{id:id,list:list,index:-1,entry:undefined}};var makeIterator=function(map,func){var entry=map.head_;return $jscomp.iteratorPrototype(function(){if(entry){while(entry.head!=
map.head_)entry=entry.previous;while(entry.next!=entry.head){entry=entry.next;return{done:false,value:func(entry)}}entry=null}return{done:true,value:void 0}})};var createHead=function(){var head={};head.previous=head.next=head.head=head;return head};var mapIndex=0;var getId=function(obj){var type=obj&&typeof obj;if(type=="object"||type=="function"){obj=obj;if(!idMap.has(obj)){var id=""+ ++mapIndex;idMap.set(obj,id);return id}return idMap.get(obj)}return"p_"+obj};return PolyfillMap},"es6","es3");
$jscomp.polyfill("Math.acosh",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);return Math.log(x+Math.sqrt(x*x-1))};return polyfill},"es6","es3");$jscomp.polyfill("Math.asinh",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x===0)return x;var y=Math.log(Math.abs(x)+Math.sqrt(x*x+1));return x<0?-y:y};return polyfill},"es6","es3");
$jscomp.polyfill("Math.log1p",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x<.25&&x>-.25){var y=x;var d=1;var z=x;var zPrev=0;var s=1;while(zPrev!=z){y*=x;s*=-1;z=(zPrev=z)+s*y/++d}return z}return Math.log(1+x)};return polyfill},"es6","es3");$jscomp.polyfill("Math.atanh",function(orig){if(orig)return orig;var log1p=Math.log1p;var polyfill=function(x){x=Number(x);return(log1p(x)-log1p(-x))/2};return polyfill},"es6","es3");
$jscomp.polyfill("Math.cbrt",function(orig){if(orig)return orig;var polyfill=function(x){if(x===0)return x;x=Number(x);var y=Math.pow(Math.abs(x),1/3);return x<0?-y:y};return polyfill},"es6","es3");
$jscomp.polyfill("Math.clz32",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x)>>>0;if(x===0)return 32;var result=0;if((x&4294901760)===0){x<<=16;result+=16}if((x&4278190080)===0){x<<=8;result+=8}if((x&4026531840)===0){x<<=4;result+=4}if((x&3221225472)===0){x<<=2;result+=2}if((x&2147483648)===0)result++;return result};return polyfill},"es6","es3");
$jscomp.polyfill("Math.cosh",function(orig){if(orig)return orig;var exp=Math.exp;var polyfill=function(x){x=Number(x);return(exp(x)+exp(-x))/2};return polyfill},"es6","es3");$jscomp.polyfill("Math.expm1",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x<.25&&x>-.25){var y=x;var d=1;var z=x;var zPrev=0;while(zPrev!=z){y*=x/++d;z=(zPrev=z)+y}return z}return Math.exp(x)-1};return polyfill},"es6","es3");
$jscomp.polyfill("Math.fround",function(orig){if(orig)return orig;if($jscomp.SIMPLE_FROUND_POLYFILL||typeof Float32Array!=="function")return function(arg){return arg};var arr=new Float32Array(1);var polyfill=function(arg){arr[0]=arg;return arr[0]};return polyfill},"es6","es3");
$jscomp.polyfill("Math.hypot",function(orig){if(orig)return orig;var polyfill=function(var_args){if(arguments.length<2)return arguments.length?Math.abs(arguments[0]):0;var i,z,sum,max;for(max=0,i=0;i<arguments.length;i++)max=Math.max(max,Math.abs(arguments[i]));if(max>1E100||max<1E-100){if(!max)return max;sum=0;for(i=0;i<arguments.length;i++){z=Number(arguments[i])/max;sum+=z*z}return Math.sqrt(sum)*max}else{sum=0;for(i=0;i<arguments.length;i++){z=Number(arguments[i]);sum+=z*z}return Math.sqrt(sum)}};
return polyfill},"es6","es3");$jscomp.polyfill("Math.imul",function(orig){if(orig)return orig;var polyfill=function(a,b){a=Number(a);b=Number(b);var ah=a>>>16&65535;var al=a&65535;var bh=b>>>16&65535;var bl=b&65535;var lh=ah*bl+al*bh<<16>>>0;return al*bl+lh|0};return polyfill},"es6","es3");$jscomp.polyfill("Math.log10",function(orig){if(orig)return orig;var polyfill=function(x){return Math.log(x)/Math.LN10};return polyfill},"es6","es3");
$jscomp.polyfill("Math.log2",function(orig){if(orig)return orig;var polyfill=function(x){return Math.log(x)/Math.LN2};return polyfill},"es6","es3");$jscomp.polyfill("Math.sign",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);return x===0||isNaN(x)?x:x>0?1:-1};return polyfill},"es6","es3");$jscomp.polyfill("Math.sinh",function(orig){if(orig)return orig;var exp=Math.exp;var polyfill=function(x){x=Number(x);if(x===0)return x;return(exp(x)-exp(-x))/2};return polyfill},"es6","es3");
$jscomp.polyfill("Math.tanh",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(x===0)return x;var y=Math.exp(-2*Math.abs(x));var z=(1-y)/(1+y);return x<0?-z:z};return polyfill},"es6","es3");$jscomp.polyfill("Math.trunc",function(orig){if(orig)return orig;var polyfill=function(x){x=Number(x);if(isNaN(x)||x===Infinity||x===-Infinity||x===0)return x;var y=Math.floor(Math.abs(x));return x<0?-y:y};return polyfill},"es6","es3");
$jscomp.polyfill("Number.EPSILON",function(orig){return Math.pow(2,-52)},"es6","es3");$jscomp.polyfill("Number.MAX_SAFE_INTEGER",function(){return 9007199254740991},"es6","es3");$jscomp.polyfill("Number.MIN_SAFE_INTEGER",function(){return-9007199254740991},"es6","es3");$jscomp.polyfill("Number.isFinite",function(orig){if(orig)return orig;var polyfill=function(x){if(typeof x!=="number")return false;return!isNaN(x)&&x!==Infinity&&x!==-Infinity};return polyfill},"es6","es3");
$jscomp.polyfill("Number.isInteger",function(orig){if(orig)return orig;var polyfill=function(x){if(!Number.isFinite(x))return false;return x===Math.floor(x)};return polyfill},"es6","es3");$jscomp.polyfill("Number.isNaN",function(orig){if(orig)return orig;var polyfill=function(x){return typeof x==="number"&&isNaN(x)};return polyfill},"es6","es3");
$jscomp.polyfill("Number.isSafeInteger",function(orig){if(orig)return orig;var polyfill=function(x){return Number.isInteger(x)&&Math.abs(x)<=Number.MAX_SAFE_INTEGER};return polyfill},"es6","es3");$jscomp.polyfill("Number.parseFloat",function(orig){return orig||parseFloat},"es6","es3");$jscomp.polyfill("Number.parseInt",function(orig){return orig||parseInt},"es6","es3");
$jscomp.assign=typeof Object.assign=="function"?Object.assign:function(target,var_args){for(var i=1;i<arguments.length;i++){var source=arguments[i];if(!source)continue;for(var key in source)if($jscomp.owns(source,key))target[key]=source[key]}return target};$jscomp.polyfill("Object.assign",function(orig){return orig||$jscomp.assign},"es6","es3");
$jscomp.polyfill("Object.entries",function(orig){if(orig)return orig;var entries=function(obj){var result=[];for(var key in obj)if($jscomp.owns(obj,key))result.push([key,obj[key]]);return result};return entries},"es8","es3");$jscomp.polyfill("Object.getOwnPropertySymbols",function(orig){if(orig)return orig;return function(){return[]}},"es6","es5");
$jscomp.polyfill("Reflect.ownKeys",function(orig){if(orig)return orig;var symbolPrefix="jscomp_symbol_";function isSymbol(key){return key.substring(0,symbolPrefix.length)==symbolPrefix}var polyfill=function(target){var keys=[];var names=Object.getOwnPropertyNames(target);var symbols=Object.getOwnPropertySymbols(target);for(var i=0;i<names.length;i++)(isSymbol(names[i])?symbols:keys).push(names[i]);return keys.concat(symbols)};return polyfill},"es6","es5");
$jscomp.polyfill("Object.getOwnPropertyDescriptors",function(orig){if(orig)return orig;var getOwnPropertyDescriptors=function(obj){var result={};var keys=Reflect.ownKeys(obj);for(var i=0;i<keys.length;i++)result[keys[i]]=Object.getOwnPropertyDescriptor(obj,keys[i]);return result};return getOwnPropertyDescriptors},"es8","es5");$jscomp.polyfill("Object.setPrototypeOf",function(orig){return orig||$jscomp.setPrototypeOf},"es6","es5");
$jscomp.polyfill("Object.values",function(orig){if(orig)return orig;var values=function(obj){var result=[];for(var key in obj)if($jscomp.owns(obj,key))result.push(obj[key]);return result};return values},"es8","es3");$jscomp.polyfill("Reflect.apply",function(orig){if(orig)return orig;var apply=Function.prototype.apply;var polyfill=function(target,thisArg,argList){return apply.call(target,thisArg,argList)};return polyfill},"es6","es3");
$jscomp.objectCreate=$jscomp.ASSUME_ES5||typeof Object.create=="function"?Object.create:function(prototype){var ctor=function(){};ctor.prototype=prototype;return new ctor};
$jscomp.construct=function(){function reflectConstructWorks(){function Base(){}function Derived(){}new Base;Reflect.construct(Base,[],Derived);return new Base instanceof Base}if(typeof Reflect!="undefined"&&Reflect.construct){if(reflectConstructWorks())return Reflect.construct;var brokenConstruct=Reflect.construct;var patchedConstruct=function(target,argList,opt_newTarget){var out=brokenConstruct(target,argList);if(opt_newTarget)Reflect.setPrototypeOf(out,opt_newTarget.prototype);return out};return patchedConstruct}function construct(target,
argList,opt_newTarget){if(opt_newTarget===undefined)opt_newTarget=target;var proto=opt_newTarget.prototype||Object.prototype;var obj=$jscomp.objectCreate(proto);var apply=Function.prototype.apply;var out=apply.call(target,obj,argList);return out||obj}return construct}();$jscomp.polyfill("Reflect.construct",function(orig){return $jscomp.construct},"es6","es3");
$jscomp.polyfill("Reflect.defineProperty",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey,attributes){try{Object.defineProperty(target,propertyKey,attributes);var desc=Object.getOwnPropertyDescriptor(target,propertyKey);if(!desc)return false;return desc.configurable===(attributes.configurable||false)&&desc.enumerable===(attributes.enumerable||false)&&("value"in desc?desc.value===attributes.value&&desc.writable===(attributes.writable||false):desc.get===attributes.get&&desc.set===
attributes.set)}catch(err){return false}};return polyfill},"es6","es5");$jscomp.polyfill("Reflect.deleteProperty",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey){if(!$jscomp.owns(target,propertyKey))return true;try{return delete target[propertyKey]}catch(err){return false}};return polyfill},"es6","es3");$jscomp.polyfill("Reflect.getOwnPropertyDescriptor",function(orig){return orig||Object.getOwnPropertyDescriptor},"es6","es5");
$jscomp.polyfill("Reflect.getPrototypeOf",function(orig){return orig||Object.getPrototypeOf},"es6","es5");$jscomp.findDescriptor=function(target,propertyKey){var obj=target;while(obj){var property=Reflect.getOwnPropertyDescriptor(obj,propertyKey);if(property)return property;obj=Reflect.getPrototypeOf(obj)}return undefined};
$jscomp.polyfill("Reflect.get",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey,opt_receiver){if(arguments.length<=2)return target[propertyKey];var property=$jscomp.findDescriptor(target,propertyKey);if(property)return property.get?property.get.call(opt_receiver):property.value;return undefined};return polyfill},"es6","es5");
$jscomp.polyfill("Reflect.has",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey){return propertyKey in target};return polyfill},"es6","es3");$jscomp.polyfill("Reflect.isExtensible",function(orig){if(orig)return orig;if($jscomp.ASSUME_ES5||typeof Object.isExtensible=="function")return Object.isExtensible;return function(){return true}},"es6","es3");
$jscomp.polyfill("Reflect.preventExtensions",function(orig){if(orig)return orig;if(!($jscomp.ASSUME_ES5||typeof Object.preventExtensions=="function"))return function(){return false};var polyfill=function(target){Object.preventExtensions(target);return!Object.isExtensible(target)};return polyfill},"es6","es3");
$jscomp.polyfill("Reflect.set",function(orig){if(orig)return orig;var polyfill=function(target,propertyKey,value,opt_receiver){var property=$jscomp.findDescriptor(target,propertyKey);if(!property){if(Reflect.isExtensible(target)){target[propertyKey]=value;return true}return false}if(property.set){property.set.call(arguments.length>3?opt_receiver:target,value);return true}else if(property.writable&&!Object.isFrozen(target)){target[propertyKey]=value;return true}return false};return polyfill},"es6",
"es5");$jscomp.polyfill("Reflect.setPrototypeOf",function(orig){if(orig)return orig;else if($jscomp.setPrototypeOf){var setPrototypeOf=$jscomp.setPrototypeOf;var polyfill=function(target,proto){try{setPrototypeOf(target,proto);return true}catch(e){return false}};return polyfill}else return null},"es6","es5");
$jscomp.polyfill("Set",function(NativeSet){function isConformant(){if($jscomp.ASSUME_NO_NATIVE_SET||!NativeSet||typeof NativeSet!="function"||!NativeSet.prototype.entries||typeof Object.seal!="function")return false;try{NativeSet=NativeSet;var value=Object.seal({x:4});var set=new NativeSet($jscomp.makeIterator([value]));if(!set.has(value)||set.size!=1||set.add(value)!=set||set.size!=1||set.add({x:4})!=set||set.size!=2)return false;var iter=set.entries();var item=iter.next();if(item.done||item.value[0]!=
value||item.value[1]!=value)return false;item=iter.next();if(item.done||item.value[0]==value||item.value[0].x!=4||item.value[1]!=item.value[0])return false;return iter.next().done}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeSet&&$jscomp.ES6_CONFORMANCE)return NativeSet}else if(isConformant())return NativeSet;$jscomp.initSymbolIterator();var PolyfillSet=function(opt_iterable){this.map_=new Map;if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);var entry;
while(!(entry=iter.next()).done){var item=entry.value;this.add(item)}}this.size=this.map_.size};PolyfillSet.prototype.add=function(value){value=value===0?0:value;this.map_.set(value,value);this.size=this.map_.size;return this};PolyfillSet.prototype["delete"]=function(value){var result=this.map_["delete"](value);this.size=this.map_.size;return result};PolyfillSet.prototype.clear=function(){this.map_.clear();this.size=0};PolyfillSet.prototype.has=function(value){return this.map_.has(value)};PolyfillSet.prototype.entries=
function(){return this.map_.entries()};PolyfillSet.prototype.values=function(){return this.map_.values()};PolyfillSet.prototype.keys=PolyfillSet.prototype.values;PolyfillSet.prototype[Symbol.iterator]=PolyfillSet.prototype.values;PolyfillSet.prototype.forEach=function(callback,opt_thisArg){var set=this;this.map_.forEach(function(value){return callback.call(opt_thisArg,value,value,set)})};return PolyfillSet},"es6","es3");
$jscomp.checkStringArgs=function(thisArg,arg,func){if(thisArg==null)throw new TypeError("The 'this' value for String.prototype."+func+" must not be null or undefined");if(arg instanceof RegExp)throw new TypeError("First argument to String.prototype."+func+" must not be a regular expression");return thisArg+""};
$jscomp.polyfill("String.prototype.codePointAt",function(orig){if(orig)return orig;var polyfill=function(position){var string=$jscomp.checkStringArgs(this,null,"codePointAt");var size=string.length;position=Number(position)||0;if(!(position>=0&&position<size))return void 0;position=position|0;var first=string.charCodeAt(position);if(first<55296||first>56319||position+1===size)return first;var second=string.charCodeAt(position+1);if(second<56320||second>57343)return first;return(first-55296)*1024+
second+9216};return polyfill},"es6","es3");$jscomp.polyfill("String.prototype.endsWith",function(orig){if(orig)return orig;var polyfill=function(searchString,opt_position){var string=$jscomp.checkStringArgs(this,searchString,"endsWith");searchString=searchString+"";if(opt_position===void 0)opt_position=string.length;var i=Math.max(0,Math.min(opt_position|0,string.length));var j=searchString.length;while(j>0&&i>0)if(string[--i]!=searchString[--j])return false;return j<=0};return polyfill},"es6","es3");
$jscomp.polyfill("String.fromCodePoint",function(orig){if(orig)return orig;var polyfill=function(var_args){var result="";for(var i=0;i<arguments.length;i++){var code=Number(arguments[i]);if(code<0||code>1114111||code!==Math.floor(code))throw new RangeError("invalid_code_point "+code);if(code<=65535)result+=String.fromCharCode(code);else{code-=65536;result+=String.fromCharCode(code>>>10&1023|55296);result+=String.fromCharCode(code&1023|56320)}}return result};return polyfill},"es6","es3");
$jscomp.polyfill("String.prototype.includes",function(orig){if(orig)return orig;var polyfill=function(searchString,opt_position){var string=$jscomp.checkStringArgs(this,searchString,"includes");return string.indexOf(searchString,opt_position||0)!==-1};return polyfill},"es6","es3");
$jscomp.polyfill("String.prototype.repeat",function(orig){if(orig)return orig;var polyfill=function(copies){var string=$jscomp.checkStringArgs(this,null,"repeat");if(copies<0||copies>1342177279)throw new RangeError("Invalid count value");copies=copies|0;var result="";while(copies){if(copies&1)result+=string;if(copies>>>=1)string+=string}return result};return polyfill},"es6","es3");
$jscomp.stringPadding=function(padString,padLength){var padding=padString!==undefined?String(padString):" ";if(!(padLength>0)||!padding)return"";var repeats=Math.ceil(padLength/padding.length);return padding.repeat(repeats).substring(0,padLength)};
$jscomp.polyfill("String.prototype.padEnd",function(orig){if(orig)return orig;var padEnd=function(targetLength,opt_padString){var string=$jscomp.checkStringArgs(this,null,"padStart");var padLength=targetLength-string.length;return string+$jscomp.stringPadding(opt_padString,padLength)};return padEnd},"es8","es3");
$jscomp.polyfill("String.prototype.padStart",function(orig){if(orig)return orig;var padStart=function(targetLength,opt_padString){var string=$jscomp.checkStringArgs(this,null,"padStart");var padLength=targetLength-string.length;return $jscomp.stringPadding(opt_padString,padLength)+string};return padStart},"es8","es3");
$jscomp.polyfill("String.prototype.startsWith",function(orig){if(orig)return orig;var polyfill=function(searchString,opt_position){var string=$jscomp.checkStringArgs(this,searchString,"startsWith");searchString=searchString+"";var strLen=string.length;var searchLen=searchString.length;var i=Math.max(0,Math.min(opt_position|0,string.length));var j=0;while(j<searchLen&&i<strLen)if(string[i++]!=searchString[j++])return false;return j>=searchLen};return polyfill},"es6","es3");
$jscomp.arrayFromIterator=function(iterator){var i;var arr=[];while(!(i=iterator.next()).done)arr.push(i.value);return arr};$jscomp.arrayFromIterable=function(iterable){if(iterable instanceof Array)return iterable;else return $jscomp.arrayFromIterator($jscomp.makeIterator(iterable))};
$jscomp.inherits=function(childCtor,parentCtor){childCtor.prototype=$jscomp.objectCreate(parentCtor.prototype);childCtor.prototype.constructor=childCtor;if($jscomp.setPrototypeOf){var setPrototypeOf=$jscomp.setPrototypeOf;setPrototypeOf(childCtor,parentCtor)}else for(var p in parentCtor){if(p=="prototype")continue;if(Object.defineProperties){var descriptor=Object.getOwnPropertyDescriptor(parentCtor,p);if(descriptor)Object.defineProperty(childCtor,p,descriptor)}else childCtor[p]=parentCtor[p]}childCtor.superClass_=
parentCtor.prototype};
$jscomp.polyfill("WeakSet",function(NativeWeakSet){function isConformant(){if(!NativeWeakSet||!Object.seal)return false;try{var x=Object.seal({});var y=Object.seal({});var set=new NativeWeakSet([x]);if(!set.has(x)||set.has(y))return false;set["delete"](x);set.add(y);return!set.has(x)&&set.has(y)}catch(err){return false}}if($jscomp.USE_PROXY_FOR_ES6_CONFORMANCE_CHECKS){if(NativeWeakSet&&$jscomp.ES6_CONFORMANCE)return NativeWeakSet}else if(isConformant())return NativeWeakSet;var PolyfillWeakSet=function(opt_iterable){this.map_=
new WeakMap;if(opt_iterable){var iter=$jscomp.makeIterator(opt_iterable);var entry;while(!(entry=iter.next()).done){var item=entry.value;this.add(item)}}};PolyfillWeakSet.prototype.add=function(elem){this.map_.set(elem,true);return this};PolyfillWeakSet.prototype.has=function(elem){return this.map_.has(elem)};PolyfillWeakSet.prototype["delete"]=function(elem){return this.map_["delete"](elem)};return PolyfillWeakSet},"es6","es3");
(function(){var Module=function(id,opt_exports){this.id=id;this.exports=opt_exports||{}};Module.prototype.exportAllFrom=function(other){var module=this;var define={};for(var key in other){if(key=="default"||key in module.exports||key in define)continue;define[key]={enumerable:true,get:function(key){return function(){return other[key]}}(key)}}$jscomp.global.Object.defineProperties(module.exports,define)};var CacheEntry=function(def,module,path){this.def=def;this.module=module;this.path=path;this.blockingDeps=
new Set};CacheEntry.prototype.load=function(){if(this.def){var def=this.def;this.def=null;callRequireCallback(def,this.module)}return this.module.exports};function callRequireCallback(callback,opt_module){var oldPath=currentModulePath;try{if(opt_module){currentModulePath=opt_module.id;callback.call(opt_module,createRequire(opt_module),opt_module.exports,opt_module)}else callback($jscomp.require)}finally{currentModulePath=oldPath}}var moduleCache=new Map;var currentModulePath="";function normalizePath(path){var components=
path.split("/");var i=0;while(i<components.length)if(components[i]==".")components.splice(i,1);else if(i&&components[i]==".."&&components[i-1]&&components[i-1]!="..")components.splice(--i,2);else i++;return components.join("/")}$jscomp.getCurrentModulePath=function(){return currentModulePath};function getCacheEntry(id){var cacheEntry=moduleCache.get(id);if(cacheEntry===undefined)throw new Error("Module "+id+" does not exist.");return cacheEntry}var ensureMap=new Map;var CallbackEntry=function(requireSet,
callback){this.requireSet=requireSet;this.callback=callback};function maybeNormalizePath(root,absOrRelativePath){if(absOrRelativePath.startsWith("./")||absOrRelativePath.startsWith("../"))return normalizePath(root+"/../"+absOrRelativePath);else return absOrRelativePath}function createRequire(opt_module){function require(absOrRelativePath){var absPath=absOrRelativePath;if(opt_module)absPath=maybeNormalizePath(opt_module.id,absPath);return getCacheEntry(absPath).load()}function requireEnsure(requires,
callback){if(currentModulePath)for(var i=0;i<requires.length;i++)requires[i]=maybeNormalizePath(currentModulePath,requires[i]);var blockingRequires=[];for(var i=0;i<requires.length;i++){var required=moduleCache.get(requires[i]);if(!required||required.blockingDeps.size)blockingRequires.push(requires[i])}if(blockingRequires.length){var requireSet=new Set(blockingRequires);var callbackEntry=new CallbackEntry(requireSet,callback);requireSet.forEach(function(require){var arr=ensureMap.get(require);if(!arr){arr=
[];ensureMap.set(require,arr)}arr.push(callbackEntry)})}else callback(require)}require.ensure=requireEnsure;return require}$jscomp.require=createRequire();$jscomp.hasModule=function(id){return moduleCache.has(id)};function markAvailable(absModulePath){var ensures=ensureMap.get(absModulePath);if(ensures){for(var i=0;i<ensures.length;i++){var entry=ensures[i];entry.requireSet["delete"](absModulePath);if(!entry.requireSet.size){ensures.splice(i--,1);callRequireCallback(entry.callback)}}if(!ensures.length)ensureMap["delete"](absModulePath)}}
$jscomp.registerModule=function(moduleDef,absModulePath,opt_shallowDeps){if(moduleCache.has(absModulePath))throw new Error("Module "+absModulePath+" has already been registered.");if(currentModulePath)throw new Error("Cannot nest modules.");var shallowDeps=opt_shallowDeps||[];for(var i=0;i<shallowDeps.length;i++)shallowDeps[i]=maybeNormalizePath(absModulePath,shallowDeps[i]);var blockingDeps=new Set;for(var i=0;i<shallowDeps.length;i++)getTransitiveBlockingDepsOf(shallowDeps[i]).forEach(function(transitive){blockingDeps.add(transitive)});
blockingDeps["delete"](absModulePath);var cacheEntry=new CacheEntry(moduleDef,new Module(absModulePath),absModulePath);moduleCache.set(absModulePath,cacheEntry);blockingDeps.forEach(function(blocker){addAsBlocking(cacheEntry,blocker)});if(!blockingDeps.size)markAvailable(cacheEntry.module.id);removeAsBlocking(cacheEntry)};function getTransitiveBlockingDepsOf(moduleId){var cacheEntry=moduleCache.get(moduleId);var blocking=new Set;if(cacheEntry)cacheEntry.blockingDeps.forEach(function(dep){getTransitiveBlockingDepsOf(dep).forEach(function(transitive){blocking.add(transitive)})});
else blocking.add(moduleId);return blocking}var blockingModulePathToBlockedModules=new Map;function addAsBlocking(blocked,blocker){if(blocked.module.id!=blocker){var blockedModules=blockingModulePathToBlockedModules.get(blocker);if(!blockedModules){blockedModules=new Set;blockingModulePathToBlockedModules.set(blocker,blockedModules)}blockedModules.add(blocked);blocked.blockingDeps.add(blocker)}}function removeAsBlocking(cacheEntry){var blocked=blockingModulePathToBlockedModules.get(cacheEntry.module.id);
if(blocked){blockingModulePathToBlockedModules["delete"](cacheEntry.module.id);blocked.forEach(function(blockedCacheEntry){blockedCacheEntry.blockingDeps["delete"](cacheEntry.module.id);cacheEntry.blockingDeps.forEach(function(blocker){addAsBlocking(blockedCacheEntry,blocker)});if(!blockedCacheEntry.blockingDeps.size){removeAsBlocking(blockedCacheEntry);markAvailable(blockedCacheEntry.module.id)}})}}$jscomp.registerAndLoadModule=function(moduleDef,absModulePath,shallowDeps){$jscomp.require.ensure([absModulePath],
function(require){require(absModulePath)});$jscomp.registerModule(moduleDef,absModulePath,shallowDeps)};$jscomp.registerEs6ModuleExports=function(absModulePath,exports){if(moduleCache.has(absModulePath))throw new Error("Module at path "+absModulePath+" is already registered.");var entry=new CacheEntry(null,new Module(absModulePath,exports),absModulePath);moduleCache.set(absModulePath,entry);markAvailable(absModulePath)};$jscomp.clearModules=function(){moduleCache.clear()}})();
(function(){var globalRef=function(){if(typeof window!="undefined")return window;else if(this)return this;else if(typeof global!="undefined")return global;else if(typeof self!="undefined")return self;else throw Error("Cannot infer global object.");}();var localJscomp=$jscomp;var globalJscomp=globalRef["$jscomp"];if(localJscomp==globalJscomp)return;if(globalJscomp)for(var key in globalJscomp)localJscomp[key]=globalJscomp[key];globalRef["$jscomp"]=localJscomp})();(function(window){var $wnd={"Error":{}};var $doc={},$moduleName,$moduleBase;function OZ(){}function JZ(){}function xb(){}function Hb(){}function sc(){}function Fd(){}function Ok(){}function Qk(){}function Sk(){}function Uk(){}function Wk(){}function Yk(){}function $k(){}function al(){}function cs(){}function Es(){}function ED(){}function eD(){}function oD(){}function oE(){}function eE(){}function vE(){}function Xt(){}function Xy(){}function Ty(){}function TA(){}function sA(){}function kC(){}function YC(){}
function i_(){}function i1(){}function $0(){}function B5(){}function e6(){}function ecb(){}function zab(){}function zbb(){}function zfb(){}function zib(){}function Eib(){}function Enb(){}function lnb(){}function Anb(){}function ndb(){}function Ceb(){}function Cjb(){}function vkb(){}function Hkb(){}function Jkb(){}function jrb(){}function rrb(){}function vrb(){}function asb(){}function zsb(){}function Esb(){}function wtb(){}function oub(){}function hvb(){}function Ovb(){}function Bwb(){}function Hwb(){}
function bCb(){}function KDb(){}function qEb(){}function xEb(){}function BEb(){}function DEb(){}function FEb(){}function fFb(){}function iFb(){}function kFb(){}function sFb(){}function hGb(){}function pGb(){}function iJb(){}function S1b(){}function P2b(){}function b3b(){}function A5b(){}function F5b(){}function L5b(){}function Q5b(){}function T5b(){}function Z5b(){}function plc(){}function opc(){}function spc(){}function wpc(){}function Apc(){}function Epc(){}function Ipc(){}function Mpc(){}function Qpc(){}
function kyc(){}function Myc(){}function Vyc(){}function bzc(){}function bGc(){}function YGc(){}function YFc(){}function cFc(){}function eFc(){}function KBc(){}function OBc(){}function fIc(){}function iIc(){}function lIc(){}function oIc(){}function TIc(){}function XIc(){}function _Ic(){}function bJc(){}function cKc(){}function fKc(){}function wKc(){}function wJc(a){}function vJc(a){}function xhc(a){}function Snb(a){}function cyb(a){Sd(a)}function qub(a){a.Ud()}function fEb(){XDb()}function PZ(){sGb()}
function iq(){this.a=0}function $x(){this.a=8}function $e(a){this.a=a}function Ie(a){this.a=a}function nc(a){this.a=a}function uh(a){this.a=a}function Ah(a){this.a=a}function Xj(a){this.a=a}function hk(a){this.a=a}function mk(a){this.a=a}function Fk(a){this.a=a}function cl(a){this.a=a}function _l(a){this.a=a}function _r(a){this.a=a}function ar(a){this.a=a}function gp(a){this.a=a}function ft(a){this.a=a}function Nt(a){this.a=a}function yu(a){this.a=a}function hu(a){this.b=a}function Bu(a){this.b=a}
function ix(a){this.b=a}function Lx(a){this.a=a}function Lz(a){this.a=a}function jw(a){this.a=a}function wy(a){this.a=a}function Ay(a){this.a=a}function Sy(a){this.a=a}function _y(a){this.a=a}function zA(a){this.a=a}function DA(a){this.a=a}function QA(a){this.a=a}function VA(a){this.a=a}function IA(a){this.b=a}function rC(a){this.e=a}function TC(a){this.a=a}function L1(a){this.a=a}function k5(a){this.a=a}function b8(a){this.a=a}function d8(a){this.a=a}function f8(a){this.a=a}function h8(a){this.a=
a}function j8(a){this.a=a}function l8(a){this.a=a}function dD(a){this.c=a}function XZ(a){this.e=a}function nZ(a){return a}function y7(a,b){a.j=b}function z7(a,b){a.p=b}function D8(a,b){a.j=b}function q9(a,b){a.oc=b}function Twb(a,b){a.c=b}function jEb(a,b){a.d=b}function vNb(a,b){a.d=b}function wNb(a,b){a.e=b}function w5b(a,b){a.g=b}function s5b(a,b){a.f=b}function y5b(a,b){a.j=b}function N5b(a,b){a.b=b}function N2b(a,b){a.p=b}function K2b(a,b){a.a=b}function M2b(a,b){a.n=b}function A9b(a,b){a.n=
b}function t9b(a,b){a.e=b}function v9b(a,b){a.j=b}function w9b(a,b){a.k=b}function O5b(a,b){a.c=b}function P5b(a,b){a.d=b}function Fjc(a,b){a.k=b}function Wmc(a,b){a.a=b}function eKc(a,b){a.a=b}function efb(a){this.a=a}function Dfb(a){this.a=a}function vbb(a){this.a=a}function Hdb(a){this.a=a}function Odb(a){this.a=a}function Mdb(a){this.b=a}function chb(a){this.b=a}function tgb(a){this.a=a}function qib(a){this.a=a}function wib(a){this.c=a}function zlb(a){this.a=a}function Emb(a){this.a=a}function Inb(a){this.a=
a}function frb(a){this.a=a}function nrb(a){this.a=a}function Yrb(a){this.a=a}function Yxb(a){this.a=a}function _ub(a){this.a=a}function Fwb(a){this.a=a}function TCb(a){this.a=a}function zEb(a){this.a=a}function fGb(a){this.a=a}function tMb(a){this.a=a}function cTb(a){this.a=a}function S2b(a){this.a=a}function _3b(a){this.a=a}function sWb(a){this.d=a}function T$b(a){this.j=a}function B5b(a){this.c=a}function rkc(a){this.c=a}function eac(a){this.a=a}function iac(a){this.a=a}function Kbc(a){this.a=a}
function Obc(a){this.a=a}function yqc(a){this.a=a}function Sqc(a){this.a=a}function Krc(a){this.a=a}function _rc(a){this.a=a}function Rtc(a){this.a=a}function puc(a){this.a=a}function Wuc(a){this.a=a}function Guc(a){this.d=a}function jnc(a){this.b=a}function Tvc(a){this.b=a}function avc(a){this.a=a}function fvc(a){this.a=a}function kvc(a){this.a=a}function Ivc(a){this.a=a}function Yvc(a){this.a=a}function ewc(a){this.a=a}function eyc(a){this.a=a}function jzc(a){this.a=a}function tzc(a){this.a=a}function Fzc(a){this.b=
a}function Wzc(a){this.b=a}function WAc(a){this.a=a}function _Ac(a){this.a=a}function uAc(a){this.d=a}function wxc(a){this.c=a}function wBc(a){this.a=a}function ABc(a){this.a=a}function SBc(a){this.a=a}function vCc(a){this.a=a}function pDc(a){this.a=a}function pFc(a){this.a=a}function DFc(a){this.a=a}function FFc(a){this.a=a}function KEc(a){this.a=a}function EHc(a){this.a=a}function BJc(a){this.a=a}function QJc(a){this.a=a}function iKc(a){this.a=a}function zKc(a){this.a=a}function gf(){this.a="."}
function Ai(a){a.c=a.d.d}function p4(a){a.d=new fDc}function gZ(a){return a.e}function GFb(a){return a}function _x(a){fl(a,aMc)}function r4(a,b){L3(a.c,b)}function S3(a,b){b&&a.Ug()}function vc(a){this.a=Sd(a)}function Pc(a){this.a=Sd(a)}function Px(a){this.a=Sd(a)}function Vl(a){this.a=Sd(a)}function Uw(a){this.a=Sd(a)}function Zw(a){this.a=Sd(a)}function ny(a){this.a=Sd(a)}function Hh(a){this.b=Sd(a)}function Eu(a){this.b=Sd(a)}function w6(a,b){Ywc(a.d,b)}function v8(a,b){Ywc(a.e,b)}function t7(a,
b){bxc(a.d,b)}function Cwc(){jwc(this)}function fxc(){Wwc(this)}function gxc(){Wwc(this)}function FD(){GB.call(this)}function Ptc(){Ptc=JZ;yKc()}function _Dc(){this.a=WDc()}function Zr(){this.a=new fxc}function hs(){this.b=new fxc}function Rs(){this.b=new fxc}function Ns(){this.a=new tEc}function iC(){this.a=new tEc}function mob(a){a.d=new fDc}function nv(a,b){a.e=b;b.b=a}function h9(a,b){jbb(a.wd,b)}function Xhb(a,b){kwc(a.c,b)}function eib(a,b){lib(a.j,b)}function ilc(a,b,c){a.u[b]=c}function qn(a){bn();
this.a=a}function rs(a){bn();this.a=a}function xs(a){bn();this.a=a}function Pt(a){Bn();this.a=a}function qx(a){Bn();this.a=a}function jE(a){iE();hE.fg(a)}function Src(a){return a&-a}function rKc(a,b){a.length=b}function Eqc(){FD.call(this)}function Hrc(){FD.call(this)}function msc(){FD.call(this)}function ytc(){FD.call(this)}function WBc(){FD.call(this)}function jFc(){FD.call(this)}function pnb(){FD.call(this)}function V1b(){FD.call(this)}function Jqc(){GB.call(this)}function rc(){rc=JZ;qc=new sc}
function yc(){yc=JZ;xc=new zc}function Gb(){Gb=JZ;Fb=new Hb}function KD(){KD=JZ;JD=new xb}function Am(){Am=JZ;zm=new Bm}function Zu(){Zu=JZ;Yu=new $u}function Wy(){Wy=JZ;Vy=new Xy}function bE(){bE=JZ;aE=new eE}function ht(){ht=JZ;oo();Wy()}function U5b(){T5b.call(this)}function W5b(){T5b.call(this)}function Y5b(){W5b.call(this)}function fDc(){euc.call(this)}function xDc(){euc.call(this)}function gDc(){fuc.call(this)}function mDc(){this.a=new fDc}function nDc(){this.a=new gDc}function SHc(){this.a=
new gDc}function RHc(){this.a=new fDc}function uIc(){this.a=new fDc}function Reb(){this.a=new mDc}function Grb(){this.a=new mDc}function w2b(){this.c=new stc}function CHc(){this.a=new xGc}function EC(a){return a.b<a.c}function mc(a,b){return b==a.a}function pk(a){Zf.call(this,a)}function hx(a){Zw.call(this,a)}function Fx(a){Eu.call(this,a)}function Hx(a){Eu.call(this,a)}function ur(a){Lq.call(this,a)}function zr(a){Lq.call(this,a)}function Br(a){pk.call(this,a)}function ev(a){pk.call(this,a)}function Lr(a){Qo.call(this,
a)}function Rr(a){Qo.call(this,a)}function jz(a){Qo.call(this,a)}function Tr(a){wp.call(this,a)}function OB(a){HB.call(this,a)}function QB(a){OB.call(this,a)}function rD(a){OB.call(this,a)}function GD(a){OB.call(this,a)}function jdb(a){cdb();this.a=a}function Tdb(a){Rdb();this.a=a}function zeb(a){yeb();this.a=a}function Meb(a){Leb();this.a=a}function Rfb(a){Qfb();this.a=a}function ujb(a){sjb();this.a=a}function uvb(a){rvb();this.a=a}function fvb(a){evb();this.a=a}function CGb(a){AGb();this.a=a}function ygb(a){vgb();
this.b=a}function Bxb(a){zxb();this.c=a}function Bub(a){Sd(a);this.b=a}function Xub(a){Sd(a);this.a=a}function jGc(a){a.b=null;a.c=0}function DB(a,b){a.e=b;CB(a,b)}function k9b(a,b){j9b(a.g,a,b)}function Ry(a,b,c){lj(a.a,b,c)}function x4(a,b){L3(a.c,R4(b))}function w1(a,b){return b.b==a}function ee(a,b){return a.f-b.f}function QWb(a){while(PWb(a));}function by(a){this.a=fl(a,aMc)}function dy(a){this.a=fl(a,aMc)}function Rb(){throw gZ(new ytc);}function uf(){throw gZ(new ytc);}function om(){throw gZ(new ytc);
}function cn(){throw gZ(new ytc);}function en(){throw gZ(new ytc);}function fn(){throw gZ(new ytc);}function ro(){throw gZ(new ytc);}function DZ(){BZ==null&&(BZ=[])}function my(a,b){a.a.we().Wd(b)}function hD(a,b){a.a=b;return a}function AD(a,b){a.a=b;return a}function iD(a,b){a.b=b;return a}function BD(a,b){a.b=b;return a}function jD(a,b){a.d=b;return a}function DD(a,b){a.d=b;return a}function kD(a,b){a.e=b;return a}function lD(a,b){a.f=b;return a}function mD(a,b){a.g=b;return a}function nD(a,b){a.i=
b;return a}function CD(a,b){a.c=b;return a}function R0(a,b){a.b=b;return a}function T0(a,b){a.d=b;return a}function X0(a,b){a.i=b;return a}function Y0(a,b){a.j=b;return a}function g5(a,b){a.g=b;return a}function h5(a,b){a.i=b;return a}function i5(a,b){a.e=b;return a}function onb(a){OB.call(this,a)}function lGb(a){OB.call(this,a)}function qnb(a){GD.call(this,a)}function snb(a){ID.call(this,a)}function b2b(a){GD.call(this,a)}function e2b(a){GD.call(this,a)}function f2b(a){GD.call(this,a)}function Q2b(a){GD.call(this,
a)}function Dqc(a){GD.call(this,a)}function Fqc(a){GD.call(this,a)}function Irc(a){GD.call(this,a)}function nsc(a){GD.call(this,a)}function ztc(a){GD.call(this,a)}function Hqc(a){HB.call(this,a)}function Ixc(a){Mxc(a,a.length)}function Jxc(a){Nxc(a,a.length)}function swc(a){return a.b==a.c}function twc(a){return a.a[a.b]}function $wc(a,b){return a.a[b]}function _kc(a,b){return a.u[b]}function pGc(a){return!!a&&a.b}function fv(a){Sf(a);nv(a.a,a.a)}function Wj(a,b,c){Ry(a.a,b,c.a)}function Xxb(a,b,
c){u1(a.a,b,c)}function Al(a,b,c){a.Od(c).Hd(b)}function ov(a,b){a.Uf(b);b.Tf(a)}function xE(a,b){return prc(a,b)}function W7(a){return new uCb(a)}function SZ(a){return a==1||a==2}function gy(a){this.a=a;this.b=2}function iy(a){this.a=a;this.b=2}function ky(a){this.a=a;this.b=2}function hob(a){iob.call(this,a)}function Zz(a){bn();this.a=Sd(a)}function TD(){TD=JZ;!!(iE(),hE)}function SDc(){SDc=JZ;RDc=UDc()}function otb(){throw gZ(new ytc);}function Cub(a){a.e=new Iub(a.f)}function Aub(a,b){a.d=b;return a}
function Wub(a,b){a.c=b;return a}function M$b(a,b){a.c=b;return a}function J$b(a,b){a.a=b;return a}function axb(a,b){a.a=b;return a}function Sgb(a,b){a.b=b;return a}function Ssb(a,b){a.n=b;return a}function P$b(a,b){a.n=b;return a}function L$b(a,b){a.b=b;return a}function N$b(a,b){a.f=b;return a}function O$b(a,b){a.d=b;return a}function Q$b(a,b){a.g=b;return a}function R$b(a,b){a.o=b;return a}function S$b(a,b){a.i=b;return a}function r9b(a,b){a.d=b;return a}function Bic(a,b){a.d=b;return a}function zic(a,
b){a.b=b;return a}function Aic(a,b){a.c=b;return a}function Cic(a,b){a.i=b;return a}function Dic(a,b){a.g=b;return a}function Gic(a,b){a.j=b;return a}function Jic(a,b){a.k=b;return a}function Kic(a,b){a.n=b;return a}function Bd(a){a.d=true;return a}function qhc(a){dgc.call(this,a)}function ukc(a){rkc.call(this,a)}function Akc(a){rkc.call(this,a)}function Gqc(a){Fqc.call(this,a)}function wtc(a){Fqc.call(this,a)}function vtc(a){yqc.call(this,a)}function stc(){yqc.call(this,"")}function ttc(){yqc.call(this,
"")}function Vbc(a){J9b.call(this,a)}function usc(a){qnb.call(this,a)}function JAc(a){Fzc.call(this,a)}function QAc(a){JAc.call(this,a)}function gBc(a){_zc.call(this,a)}function Sfc(a,b){a.B=Qnc(a.B,b)}function sKc(a,b){return DE(a,b)}function erc(a){return a.e&&a.e()}function frc(a){drc(a);return a.p}function grc(a){drc(a);return a.n}function AKc(a){zKc.call(this,a)}function Xwc(a,b,c){oKc(a.a,b,c)}function CFc(a,b){while(a.hf(b));}function Tf(a,b){return a.c.se(b)}function Hp(a,b){return a.a.Xe(b)}
function No(a,b){return Ax(a.d,b)}function Ju(a,b){return a.a.Od(b)}function mf(a){return Ue(a.a,a.b)}function zx(a){return!a?null:a.g}function Ex(a){return!a?null:a.i}function Yz(a,b){return zb(a.a,b)}function bF(a){return a.l|a.m<<22}function oZ(a,b){return iZ(a,b)>0}function qZ(a,b){return iZ(a,b)<0}function Yr(a,b){Qr(a,b);return a}function Vhb(a){vwc(a.c);vwc(a.i)}function Vzc(){throw gZ(new ytc);}function xzc(){throw gZ(new ytc);}function yzc(){throw gZ(new ytc);}function zzc(){throw gZ(new ytc);
}function Czc(){throw gZ(new ytc);}function Dzc(){throw gZ(new ytc);}function Uyc(){throw gZ(new jFc);}function Wbb(){Wbb=JZ;Vbb=new fDc}function yjb(){yjb=JZ;xjb=new Cjb}function a3b(){a3b=JZ;_2b=new b3b}function Kvb(){Kvb=JZ;Jvb=new Ovb}function nEb(){nEb=JZ;mEb=new qEb}function EFb(){EFb=JZ;DFb=new HFb}function _D(){QD!=0&&(QD=0);SD=-1}function qOb(a){a.a=a.i-a.f-a.r-1}function ctb(a){this.a=a;this.b=1}function dyb(){Sd(iRc);this.a=iRc}function d7b(a,b){a.d&&t5b(a.a,b)}function c7b(a,b){a.d&&s5b(a.a,
b)}function hnc(a,b){a!=$mc&&(a.a=b)}function JBc(a,b){return Oqc(a,b)}function jtc(a,b){a.a+=b;return a}function ktc(a,b){a.a+=b;return a}function K$b(a){a.e=true;return a}function JJc(a){lJc(a);return a.a}function Tyc(){Tyc=JZ;Syc=new Vyc}function nFc(){nFc=JZ;mFc=new fDc}function DHc(a){this.a=new yGc(a)}function nf(a,b){this.a=a;this.b=b}function Oj(a,b){this.a=a;this.b=b}function Aj(a,b){this.a=a;this.c=b}function Fj(a,b){this.a=a;this.c=b}function Wh(a,b){this.b=a;this.c=b}function Wg(a,b){this.b=
a;this.a=b}function El(a,b){this.b=a;this.a=b}function kl(a,b){this.a=a;this.b=b}function ql(a,b){this.a=a;this.b=b}function sl(a,b){this.a=a;this.b=b}function Cl(a,b){this.a=a;this.b=b}function Ml(a,b){this.a=a;this.b=b}function Ol(a,b){this.a=a;this.b=b}function pm(a,b){this.a=a;this.b=b}function fq(a,b){this.a=a;this.b=b}function Sq(a,b){this.b=a;this.a=b}function nr(a,b){this.b=a;this.a=b}function he(a,b){this.e=a;this.f=b}function Wq(a,b){this.g=a;this.i=b}function Ws(a,b){this.a=a;this.b=b}
function gw(a,b){this.a=a;this.b=b}function vw(a,b){this.a=a;this.f=b}function Dz(a,b){this.a=a;this.b=b}function uA(a,b){this.a=a;this.b=b}function _B(a,b){this.b=a;this.a=b}function te(a,b){he.call(this,a,b)}function PB(a,b){IB.call(this,a,b)}function HD(a,b){PB.call(this,a,b)}function Mv(a,b){return Utc(a.b,b)}function Oo(a,b){return rAc(a.d,b)}function h$(a,b){return pEc(a.e,b)}function j$(a,b){return oEc(a.e,b)}function GC(a){return zsc(a.a,a.b)}function Yb(a){return a>=65&&a<=90}function Hr(a,
b){return a>b&&b<$Lc}function iB(a,b){return a.g[b%a.d]}function lZ(a,b){return iZ(a,b)==0}function tZ(a,b){return iZ(a,b)!=0}function H$(a,b){he.call(this,a,b)}function F2(a,b){he.call(this,a,b)}function b6(a,b){he.call(this,a,b)}function c9(a,b){he.call(this,a,b)}function D9(a,b){he.call(this,a,b)}function I9(a,b){he.call(this,a,b)}function P9(a,b){he.call(this,a,b)}function V9(a,b){he.call(this,a,b)}function _9(a,b){he.call(this,a,b)}function F5(a,b){m5.call(this,a,b)}function n8(a,b){this.a=a;
this.b=b}function U7(a,b){this.d=a;this.c=b}function HFc(a,b){while(a.Aj(b));}function w7(a,b){s7(a,G6(b));i7(a)}function Ybb(a,b){return a.b.Sd(b)}function lQb(a,b){return a.a.Sd(b)}function cnc(a,b){return a.b.Ie(b)}function Azc(a,b){return a.b.Sd(b)}function Bzc(a,b){return a.b.Td(b)}function Ezc(a,b){return a.b.ae(b)}function pAc(a,b){return a.d.Ge(b)}function rAc(a,b){return zb(a.d,b)}function R2b(a,b){return Po(a.a,b)}function NAc(a,b){return a.b.Sd(b)}function kDc(a,b){return a.a.se(b)}function duc(a){return a.d.c+
a.e.b}function aDc(a){this.c=a;ZCc(this)}function xGc(){yGc.call(this,null)}function rJc(){nJc.call(this,null)}function qKc(a,b,c){a.splice(b,c)}function sKb(a,b,c){t9b(a,c.c-b.c)}function Urb(a,b,c){fpb(a.b,a,b,c)}function i2b(a,b,c){ntc(a.c,b,0,c)}function Ue(a,b){return a.c.je(a,b)}function $C(a,b){return b.b+a.c.i.b}function i9(a,b){return lbb(a.wd,b)}function j9(a,b){return mbb(a.wd,b)}function p9(a,b){a.hc=new Ie(Sd(b))}function eab(a,b){he.call(this,a,b)}function xab(a,b){he.call(this,a,b)}
function Eab(a,b){he.call(this,a,b)}function Kab(a,b){he.call(this,a,b)}function Qab(a,b){he.call(this,a,b)}function Yab(a,b){he.call(this,a,b)}function cbb(a,b){he.call(this,a,b)}function Tbb(a,b){he.call(this,a,b)}function kz(a){oo();Ro.call(this,a)}function nz(a){mz();wp.call(this,a)}function Xcb(a,b){he.call(this,a,b)}function gcb(a,b){this.a=a;this.b=b}function geb(a,b){this.a=a;this.b=b}function Peb(a,b){this.a=a;this.b=b}function dfb(a,b){this.f=a;this.b=b}function Lfb(a,b){this.a=a;this.c=
b}function kgb(a,b){this.b=a;this.a=b}function qgb(a,b){he.call(this,a,b)}function Xgb(a,b){he.call(this,a,b)}function Zgb(a,b){this.b=a;this.a=b}function Ahb(a,b){this.b=a;this.a=b}function rib(a,b){this.a=a;this.b=b}function Jib(a){this.a=a;this.b=ANc}function Mib(a,b){this.b=a;this.a=b}function Slb(a,b){he.call(this,a,b)}function dmb(a,b){he.call(this,a,b)}function rnb(a,b){HD.call(this,a,b)}function Fr(){tj.call(this,new fDc)}function Cm(){this.c=(Gb(),Gb(),Fb)}function Qrb(a,b){this.b=a;this.a=
b}function Vrb(a,b){this.b=a;this.a=b}function $rb(a,b){this.b=a;this.a=b}function Dsb(a,b){this.j=a;this.i=b}function utb(a,b){this.b=a;this.a=b}function jtb(a,b){he.call(this,a,b)}function mub(a,b){he.call(this,a,b)}function Gub(a,b){this.a=a;this.b=b}function Gvb(a,b){this.a=a;this.b=b}function bvb(a,b){this.a=a;this.b=b}function xwb(a,b){this.a=a;this.b=b}function dxb(a,b){this.b=a;this.a=b}function jxb(a,b){he.call(this,a,b)}function Mwb(a,b){he.call(this,a,b)}function txb(a,b){he.call(this,
a,b)}function mxb(){jxb.call(this,COc,0)}function vxb(){txb.call(this,gRc,0)}function fDb(a,b){he.call(this,a,b)}function NEb(a,b){he.call(this,a,b)}function xFb(a,b){he.call(this,a,b)}function OFb(a,b){he.call(this,a,b)}function mGb(a,b){PB.call(this,a,b)}function UIb(a,b){he.call(this,a,b)}function nJb(a,b){he.call(this,a,b)}function GJb(a,b){he.call(this,a,b)}function LJb(a,b){he.call(this,a,b)}function qFb(a,b){this.b=a;this.a=b}function FNb(a,b){this.a=a;this.b=b}function KNb(a,b){he.call(this,
a,b)}function gOb(a,b){he.call(this,a,b)}function FOb(a,b){this.c=a;this.b=b}function IOb(a,b){this.a=a;this.b=b}function keb(a,b){return Yjb(b,a.b)}function leb(a,b){return Yjb(b,a.f)}function Nnb(a,b){return Yjb(b,a.e)}function xWb(a,b){return b>=0&b<a.c}function OKb(a){return a>=48&&a<=55}function Xb(a){return a>=97&&a<=122}function rXb(a,b){this.a=a;this.b=b}function NRb(a,b){this.e=a;this.d=b}function IZb(a,b){this.p=a;this.o=b}function Z1b(a,b){this.b=a;this.a=b}function Z$b(a,b){he.call(this,
a,b)}function f$b(a,b){he.call(this,a,b)}function f6b(a,b){he.call(this,a,b)}function jWb(a,b){he.call(this,a,b)}function o1b(a,b){he.call(this,a,b)}function H7b(a,b){this.a=a;this.b=b}function nac(a,b){this.c=a;this.b=b}function Ibc(a,b){he.call(this,a,b)}function tcc(a,b){he.call(this,a,b)}function Bfc(a,b){he.call(this,a,b)}function ekc(a,b){he.call(this,a,b)}function ync(a,b){this.b=a;this.a=b}function zoc(a,b){he.call(this,a,b)}function Boc(){zoc.call(this,PSc,0)}function Foc(){zoc.call(this,
OSc,1)}function $D(a){$wnd.clearTimeout(a)}function xic(a){a.e=a.e|2;return a}function Fic(a){a.e=a.e|8;return a}function alc(a){Sd(a.o);return a.o}function Y2b(a,b){X2b();return a[b]}function l6b(a,b){return S4b(a.a,b)}function Qtc(a,b){return Stc(a.a,b)}function uqc(a,b){return zsc(a.a,b)}function xqc(a,b){return Usc(a.a,b)}function gzc(a,b){return Utc(a.a,b)}function Jtc(a,b){he.call(this,a,b)}function Jrc(a,b){HD.call(this,a,b)}function Iqc(a,b){IB.call(this,a,b)}function sBc(a,b){this.a=a;this.b=
b}function wvc(a,b){this.d=a;this.e=b}function GCc(a,b){this.b=a;this.a=b}function pHc(a,b){he.call(this,a,b)}function BFc(a){tFc.call(this,a,21)}function VJc(a,b){this.a=a;this.b=b}function $Jc(a,b){this.a=a;this.b=b}function jKc(a,b){this.b=a;this.a=b}function Tic(a,b){Xd(!a.$i());a.p=b}function oEc(a,b){return Utc(a.c,b)}function YDc(a,b){return a.a.get(b)}function Duc(a){return a.b<a.d.Yd()}function QEc(a){return a.b!=a.c.a.b}function I2b(a){return a>=48&&a<=57}function qF(a){return typeof a===
XKc}function rF(a){return typeof a===YKc}function tF(a){return typeof a===$Kc}function uF(a){return a==null?null:a}function Hg(a){return!a?null:a.We()}function FC(a){return zsc(a.a,a.b++)}function Xn(a,b){return zb(a.xf(),b)}function Yn(a,b){return a.xf().ce(b)}function Zn(a,b){return a.xf().ae(b)}function b_(a){return a_(Se(Ze(),a))}function pZ(a){return typeof a===YKc}function WDc(){SDc();return new RDc}function ci(a){ai(a);return a.d.Yd()}function H8(a){I8.call(this,a,false)}function jsb(a){U7.call(this,
a,true)}function wxb(){txb.call(this,"V3",1)}function B0(a){this.a=a;this.c=false}function Brb(a){this.b=a;this.a=true}function hyb(){this.a=mZ(Date.now())}function SPb(){SPb=JZ;RPb=je(QPb())}function $xb(a,b){a.b=byb(b,a.a,a.b)}function bJb(a,b){a.b=mp(b);return a}function hJb(a,b){a.i=mp(b);return a}function eEb(a,b){a.i=In(b);return a}function cEb(a,b){a.f=In(b);return a}function dEb(a,b){a.g=In(b);return a}function _Db(a,b){a.c=wo(b);return a}function pOb(a,b){a.q[a.r++]=b;--a.b}function tKb(a,
b){vKb(a,b.d.b,b.d.a)}function kQb(a,b){return a.a.Td(b.a)}function ltc(a,b){return a.a+=""+b,a}function Usc(a,b){return a.substr(b)}function O8b(a){return!!a.c&&!a.c.f}function lXb(a){return kXb(a)&&a!=42}function rOb(a){sOb.call(this,a,0,0)}function utc(a){yqc.call(this,NZ(a))}function QFc(a,b){IFc.call(this,a,b)}function oKc(a,b,c){a.splice(b,0,c)}function XJc(a,b,c){b.jf(a.a.Od(c))}function klc(a,b,c){Vf(a.q,c.Xi(),b)}function EWb(a,b,c,d){DOb(a.e,b,c,d)}function ul(a,b,c){return a.d=b.Od(c)}
function wb(a,b){return uF(a)===uF(b)}function Tt(a){return Sd(a),new Gm(a)}function GE(a){return HE(a.l,a.m,a.h)}function Gm(a){this.a=a;Cm.call(this)}function Jm(a){this.a=a;Cm.call(this)}function J1(a){this.a=new yq;this.b=a}function Zf(a){Kd(a.Yd()==0);this.c=a}function etb(a){this.b=a;this.a=a.b.b}function Pv(){this.b=(wx(12),new gDc)}function gob(){iob.call(this,new nob)}function RFb(){RFb=JZ;QFb=new Pc("/")}function ghb(a,b){p8b(a.c,b,F8b(a.c))}function UVb(a,b,c){DOb(a.c,b,"%s",c)}function n7b(a,
b){h4b(a.a,b);a.e=true}function A7(a,b){b>1?a.K=1:a.K=b}function m9b(a,b){a.k=$9b(T9b(a.k),b)}function wWb(a,b){return ZSb(a.i.b,b)}function qTb(a,b){return TSb(b,a.b.d)}function Hsc(a,b){return a.indexOf(b)}function hCc(a,b,c){return gCc(a,b,c)}function Erc(a){return rF(a)?a:a.pj()}function R4b(a){return!!a.d&&!!a.d.n}function N8b(a){return!!a.c&&!!a.c.f}function F8b(a){return a.c?a.c.i:null}function dgc(a){egc.call(this,a,null)}function ZEc(){pDc.call(this,new uEc)}function YEc(){pDc.call(this,
new tEc)}function CKc(){zKc.call(this,"UTF-8")}function ttb(a){utb.call(this,a,false)}function Ti(a,b,c){Pi.call(this,a,b,c)}function Owb(){Mwb.call(this,"LINE",0)}function Yub(){this.a=null;this.b=null}function HDc(a){this.a=WDc();this.b=a}function jA(a,b){this.c=a;this.b=Sd(b)}function Wxc(a,b){Sxc(a,0,a.length,b)}function mtc(a,b){a.a+=""+b;return a}function otc(a,b){a.a+=""+b;return a}function ptc(a,b){a.a+=""+b;return a}function fC(a,b){var c;c=qD(b);eC(a,c)}function l9b(a,b){c9b(a,(Hbc(),Hac),
b)}function n9b(a,b){d9b(a,(Hbc(),Nac),b)}function p9b(a,b){d9b(a,(Hbc(),cbc),b)}function s9b(a,b){d9b(a,(Hbc(),Dbc),b)}function y9b(a,b){d9b(a,(Hbc(),ybc),b)}function Hyb(a,b){Fyb();Iyb(a,b,!b.ad)}function QSb(a){OSb();return Po(pSb,a)}function jcc(a){n8b();J9b.call(this,a)}function Wgc(a){Ofc();dgc.call(this,a)}function thc(a){Ofc();qhc.call(this,a)}function vmc(a){Ofc();imc.call(this,a)}function Fmc(a){Ofc();vmc.call(this,a)}function Mmc(a){Ofc();qhc.call(this,a)}function Smc(a){Ofc();qhc.call(this,
a)}function Anc(a){Ofc();qhc.call(this,a)}function Enc(a){Ofc();qhc.call(this,a)}function mqc(a){Ofc();qhc.call(this,a)}function $t(a){return wu(a.a.Vd(),a.b)}function w4b(a){return!a.d?null:a.d.b}function x4b(a){return!a.d?null:a.d.c}function y4b(a){return!a.d?null:a.d.d}function D4b(a){return!a.d?null:a.d.j}function E4b(a){return!a.d?null:a.d.k}function lFc(a){return a!=null?Db(a):0}function lsc(a,b){return iZ(a,b)>0?a:b}function Esc(a,b){return uF(a)===uF(b)}function wlc(a,b){return b?b:a.e.u[51]}
function bgc(a){return pF(a,48)?a:null}function cgc(a){return pF(a,48)?a:null}function _Bc(a){return a<10?"0"+a:""+a}function qBc(a,b,c){return JBc(b.a,c.a)}function MIc(a,b){if(zIc)return;a.b=b}function Js(a,b){Bn();this.a=a;this.b=b}function at(a,b){Bn();Ws.call(this,a,b)}function Ji(a){this.a=a;Di.call(this,a)}function rr(a){this.a=a;Hh.call(this,a)}function wr(a){this.a=a;Hh.call(this,a)}function HC(a){this.a=a;this.c=a.length}function yHc(){pHc.call(this,"Tail",3)}function tHc(){pHc.call(this,
"Head",1)}function Ce(){te.call(this,"IS_NULL",2)}function z3(){y3();A3.call(this,new e6)}function Kdb(a){this.a=a;this.b=new fxc}function deb(a){this.b=a;this.a=new Cwc}function Erb(a){this.b=a;this.a=new mDc}function Iub(a){this.b=a;this.a=new tEc}function Ofb(a){this.b=new YEc;this.a=a}function $ub(a){this.c=new YEc;this.a=a}function XCb(a){this.b=a;this.a=new fxc}function bxb(){this.a=(scc(),qcc);Ptc()}function O3b(a){return n8b(),new tac(a)}function pfb(a,b){return _kc(U6(a.a),b)}function pTb(a,
b){return new Z1b(b,a.f)}function jQb(a,b){return a.a.Td(LCc(b))}function Lrc(a,b){return a<b?-1:a>b?1:0}function HE(a,b,c){return{l:a,m:b,h:c}}function Q9b(a,b){n8b();return(a&b)==b}function Icb(a,b){_tc(Gcb,a,b);return b}function Ps(a,b){Sd(b);Pr(a,b);return a}function dxc(a,b){Vxc(a.a,a.a.length,b)}function $Cc(a){return a.a<a.c.a.length}function WIc(a,b){return new VIc(a.a,b)}function hKc(a,b,c){return LJc(a.a,b,c)}function MJc(a,b,c){eKc(a,hKc(b,a.a,c))}function TEc(a){this.c=a;this.b=a.a.b.a}
function xnc(a){this.c=new fDc;this.d=a}function jwc(a){a.a=zE(iW,mLc,1,8,5,1)}function Wwc(a){a.a=zE(iW,mLc,1,0,5,1)}function AB(a){a.i=zE(kW,mLc,143,0,0,1)}function gGc(){hGc.call(this,"/","","")}function vHc(){pHc.call(this,"Range",2)}function Fe(){te.call(this,"NOT_NULL",3)}function $u(){he.call(this,"INSTANCE",0)}function Kd(a){if(!a)throw gZ(new pnb);}function Xd(a){if(!a)throw gZ(new Hrc);}function Rv(a){if(!a)throw gZ(new jFc);}function D7(a,b,c,d){r8(new p8(a,b,d,c))}function vx(a,b){return new Jx(a.Vd(),
b)}function pF(a,b){return a!=null&&mF(a,b)}function su(a){return a.Id()?a.Jd():null}function Wob(a,b,c){a.i=b;a.p=c;a.d=null}function sgb(a,b){o8b(a.a.g,b,a.a);a.a=b}function AVb(a,b){return DWb(a.g,0).e==b}function SSb(a){OSb();return!!Po(pSb,a)}function _Sb(a){this.b=a;this.a=aTb(a.a)}function H2b(a){this.a=a;this.c=a.length}function d2b(a){GD.call(this,"Width:"+a)}function fbb(a,b){GD.call(this,x2b(a,b))}function Pwb(){Mwb.call(this,"REGION",1)}function zFb(){xFb.call(this,"ESCAPE",0)}function Mzb(){jsb.call(this,
"es6ForOf")}function V4b(a){return!!a.d&&J5b(a.d,4)}function X4b(a){return!!a.d&&J5b(a.d,5)}function Y4b(a){return!!a.d&&J5b(a.d,6)}function Z4b(a){return!!a.d&&J5b(a.d,0)}function $4b(a){return!!a.d&&J5b(a.d,3)}function _4b(a){return!!a.d&&J5b(a.d,2)}function c5b(a){return!!a.d&&J5b(a.d,1)}function Xnc(a){return a.c.Yd()-a.d.Yd()}function Luc(a){return a.a.ce(a.c=--a.b)}function lDc(a,b){return a.a.Ke(b)!=null}function zsc(a,b){return a.charCodeAt(b)}function BHc(a,b){return a.a.Ke(b)!=null}function G8b(a){return a==
a.g.c?null:a.i}function etc(a){return a==null?jLc:NZ(a)}function ftc(a){return gtc(a,0,a.length)}function Nc(a,b){return Lc(a,new stc,b).a}function Se(a,b){Sd(b);return new nf(a,b)}function qj(a,b){Sd(b);hFc(a.a,new Xj(b))}function rEc(a,b){if(a.a){FEc(b);EEc(b)}}function Xr(a,b){Ywc(a.a,Sd(b));return a}function Os(a,b){Ywc(a.b,Sd(b));return a}function LJc(a,b,c){a.a.Ue(b,c);return b}function vic(a){a.b=(dkc(),akc);return a}function Bi(a){a.b.Kd();--a.d.f.d;bi(a.d)}function qt(a){hs.call(this);this.a=
Sd(a)}function It(a){Rs.call(this);this.a=Sd(a)}function Oh(a,b){this.a=a;Hh.call(this,b)}function lr(a,b){this.a=a;Lq.call(this,b)}function Qq(a,b){this.a=b;Lq.call(this,a)}function Ku(a,b){this.a=b;Eu.call(this,a)}function Jx(a,b){this.a=b;Eu.call(this,a)}function LA(a){this.a=a;IA.call(this,a.a)}function GB(){AB(this);BB(this);this.Zf()}function G8(a,b){F8.call(this,a,a.rh(),b)}function wu(a,b){Sd(b);return new Ku(a,b)}function fw(a,b){return new Cw(a.a,a.b,b)}function QE(a){return a.l+a.m*vMc+
a.h*wMc}function Xx(a){return fl(2,aMc),new gy(a)}function Yx(a){return fl(2,aMc),new iy(a)}function Zx(a){return fl(2,aMc),new ky(a)}function Jqb(a){ppb();return QCc(jpb,a.n)}function Glb(a){var b;for(b=a.n;b;b=b.n);}function RVb(a,b){a.d=oQb(a.d,b);return a}function bfb(a,b){a.a=b;a.d=true;return a}function cfb(a,b){a.g=b;a.e=true;return a}function I$b(a,b){a.k=b;return new H$b(a)}function Bjb(a,b){yjb();this.a=a;this.b=b}function CZb(a,b){DZb.call(this,a,b,null)}function oxb(){jxb.call(this,"SYMBOLS",
1)}function HFb(){he.call(this,"RELATIVE",0)}function dcc(){J9b.call(this,(Afc(),jfc))}function Joc(){zoc.call(this,"UNKNOWN",2)}function zlc(a,b){Alc.call(this,a,b,null)}function t8b(a,b){s8b(a,b,a.c?a.c.i:null)}function VVb(a,b,c){DOb(a.c,vWb(a.g),b,c)}function Yhb(a,b,c){kwc(a.c,b);kwc(a.i,c)}function Isc(a,b,c){return a.indexOf(b,c)}function Jsc(a,b){return a.lastIndexOf(b)}function hzc(a,b){return auc(a.a,b)!=null}function Frc(a){return rF(a)?vF(a):a.qj()}function N3b(a){return Z3b((Afc(),zec),
a)}function $3b(a){return Z3b((Afc(),vfc),a)}function QCc(a,b){return!!b&&a.b[b.f]==b}function qwc(a){var b;b=a.a[a.b];return b}function b7(a){s9(a.G)&&o7(a);return null}function EKc(a){if(!a)throw gZ(new pnb);}function HKc(a){if(!a)throw gZ(new jFc);}function Gwc(a){if(!a)throw gZ(new WBc);}function Hc(){Hc=JZ;Gc=Trc(31);Fc=new Ic}function Nqc(){Nqc=JZ;Lqc=false;Mqc=true}function _zc(a){Fzc.call(this,a);this.a=a}function kAc(a){Wzc.call(this,a);this.a=a}function kBc(a){JAc.call(this,a);this.a=a}
function hBc(a){uAc.call(this,a);this.a=a}function Af(a,b){Vd(b,a);this.d=a;this.c=b}function Cc(a,b){this.a=Sd(a);this.b=Sd(b)}function qC(a,b){this.i=a;this.a=new HC(b)}function VGc(a){this.a=a;Tvc.call(this,a)}function zi(a,b,c,d){ri.call(this,a,b,c,d)}function Ajb(a){yjb();Bjb.call(this,a,xjb)}function yJc(a,b){!!b&&(a.a=(lJc(b),b.a))}function WJb(a,b){return XJb(a,UJb(a,b.d))}function Sib(a,b){return UFb(pFb(a.e,b).a)}function zVb(a,b,c){return DWb(a.g,b).e==c}function J6(a,b){Sd(a.G);return nbb(a.S,
b)}function CWb(a){DWb(a,0);return axc(a.d,0)}function mE(a){iE();return parseInt(a)||-1}function NKc(a){return a.$H||(a.$H=++MKc)}function ge(a){return a.e!=null?a.e:""+a.f}function P4b(a){return!!(!a.d?null:a.d.a)}function Q4b(a){return!!(!a.d?null:a.d.i)}function _8b(a,b){return a9b(a,b,b.length)}function Cn(a,b){return new Vr(a,a.Yd(),b)}function Tsc(a,b,c){return a.substr(b,c-b)}function Vsc(a,b,c){return a.substr(b,c-b)}function kcc(a,b){n8b();L9b.call(this,a,b)}function o9b(a,b){c9b(a,(Hbc(),
gbc),b?1:0)}function x9b(a,b){c9b(a,(Hbc(),zbc),b?1:0)}function B9b(a,b){c9b(a,(Hbc(),Gbc),b?1:0)}function Bxc(a,b){return Dxc(a,a.length,b)}function Cxc(a,b){return Exc(a,a.length,b)}function tGb(){return(new Date).getTime()}function Ghc(a){dgc.call(this,a);xhc(this)}function GEc(a){HEc.call(this,a,null,null)}function z1(){v1.call(this,(bn(),mz(),lz))}function we(){te.call(this,"ALWAYS_TRUE",0)}function Pi(a,b,c){di.call(this,a,b,c,null)}function Ei(a,b){this.d=a;Ai(this);this.b=b}function jc(a,
b){Kd(b>=a);this.b=a;this.a=b}function tj(a){Kd(a.d.c+a.e.b==0);this.a=a}function Fuc(a){a.d.fe(a.c);a.b=a.c;a.c=-1}function cuc(a){a.d=new HDc(a);a.e=new _Dc}function Ttc(a){a.d=new HDc(a);a.e=new _Dc}function mEc(a){a.b=new GEc(a);a.c=new fDc}function _7(){this.c=new stc;this.d=new mDc}function Lm(a,b){this.a=b;Af.call(this,a,0)}function acb(a){Wbb();$bb.call(this,null,a)}function bcb(a){Wbb();_bb.call(this,null,a)}function IBc(a){HBc();return a==EBc?null:a}function Ieb(a){Feb();this.a=a;this.b=
false}function R3(a,b){a.Mg();b&&a.Ug();a.s=false}function P3(a){Xd(a.u==a.v);a.Lg("`");++a.u}function E8(a,b){Kd(!b||!a.k||a.k==b);a.k=b}function $l(a,b){var c;c=a.a;a.a=b;return c}function T6(a){!a.N&&(a.N=h7(a));return a.N}function z8b(a){Sd(a.g);e9b(a.g,a);return a}function Tgb(a){this.b=(Wgb(),Ugb);this.a=a}function lOb(a){return a.g==a.d?a.c+a.a:a.a}function Bwc(a){return a.c-a.b&a.a.length-1}function Csc(a){return ftc(BKc(a,a.length))}function t9(a){return a.xc||a.zb==($9(),X9)}function PCc(a,
b){return pF(b,12)&&QCc(a,b)}function RCc(a,b){return pF(b,12)&&SCc(a,b)}function _wb(a,b,c){return new cxb(b,c,a.a)}function FIc(a,b){if(zIc)return;Ywc(a.a,b)}function drc(a){if(a.p!=null)return;urc(a)}function XBc(a){this.a=new $wnd.Date(xZ(a))}function Qgc(a){Ofc();return!a?null:a.Ii()}function S9b(a){n8b();return a==-1?-1:a&xMc}function Bc(a,b){return a.a.Md(b)||a.b.Md(b)}function fg(a){return pF(a,54)?a.de():a.Vd()}function nF(a){return String.fromCharCode(a)}function iFc(){GD.call(this,"no key found")}
function $cb(){Xcb.call(this,"MULTILINE",1)}function ze(){te.call(this,"ALWAYS_FALSE",1)}function Bm(){pm.call(this,(oo(),oo(),no),0)}function I8(a,b){G8.call(this,new wnb(a),b)}function KJc(a,b){nJc.call(this,a);this.a=b}function Mbb(a,b){this.a=a;this.c=b;this.b=0}function Tu(a){this.a=(Nu(),Mu);this.d=Sd(a)}function inc(){_mc();jnc.call(this,new xGc)}function RKc(){RKc=JZ;OKc=new xb;QKc=new xb}function Feb(){Feb=JZ;Eeb=Qe(Ye(new nc(46)))}function dKb(a,b){return w8b(new J9b(b),a.s)}function qQb(a,
b){return new uQb(AQb(a.a,b))}function UD(a,b,c){return a.apply(b,c);var d}function r7(a,b,c){c.b=a;return PHc(a.u,b,c)}function V_(a,b){b0((Afc(),pec),b);r0(a,b.c)}function K6(a){!a.G&&_6(a,new v9);return a.g}function _h(a){a.b?_h(a.b):a.f.c.Je(a.e,a.d)}function n_b(a){IZb.call(this,(n1b(),B0b),a)}function r_b(a){IZb.call(this,(n1b(),G0b),a)}function s_b(a){IZb.call(this,(n1b(),H0b),a)}function w$b(a){IZb.call(this,(n1b(),b0b),a)}function h$b(a){IZb.call(this,(n1b(),P_b),a)}function i$b(a){IZb.call(this,
(n1b(),Q_b),a)}function j$b(a){IZb.call(this,(n1b(),O_b),a)}function r$b(a){IZb.call(this,(n1b(),Y_b),a)}function x1b(a){IZb.call(this,(n1b(),U0b),a)}function C1b(a){IZb.call(this,(n1b(),Z0b),a)}function _1b(a){GD.call(this,"codePoint:"+a)}function Zcb(){Xcb.call(this,"SINGLELINE",0)}function adb(){Xcb.call(this,"SOURCELESS",2)}function gkc(a,b,c){hkc.call(this,a,b,c,b.B)}function PDc(a,b){var c;c=a[ISc];c.call(a,b)}function QDc(a,b){var c;c=a[ISc];c.call(a,b)}function pvc(a,b){var c;c=a.e;a.e=b;
return c}function Bvc(a,b){var c;c=b;return!!a.wj(c)}function t6b(a,b){a.e=true;return p4b(a.a,b)}function t5b(a,b){if(!d5b(a))return;a.b.i=b}function lEc(a,b){while(a.Id())b.jf(a.Jd())}function nEc(a){cuc(a.c);a.b.b=a.b;a.b.a=a.b}function xuc(a){a.c.Kd();a.c=null;a.b=vuc(a)}function oJc(a){nJc.call(this,null);this.a=a}function wnb(a){this.a=new _3b(a.b);this.c=a}function uFc(a){this.d=a;this.a=0;this.c=LLc}function xd(a,b,c){this.b=a;this.a=b;this.c=c}function Gl(a,b,c){this.c=b;this.b=c;this.a=
a}function df(a,b,c){this.a=c;bf.call(this,a,b)}function jf(a,b,c){this.a=c;bf.call(this,a,b)}function Qc(a,b,c){Sd(c);return new xd(c,a,b)}function Ye(a){Sd(a);return new We(new $e(a))}function Oc(a){Sd(a);return pF(a,432)?a:NZ(a)}function T9b(a){n8b();return a==-1?-1:a>>>12}function btc(a){return tF(a)?a.length:a.ij()}function nKc(a,b){return sKc(new Array(b),a)}function Wn(a,b){return b!=null&&a.xf().Sd(b)}function zD(a){return new yD(a.d,a.c,a.a,a.b)}function bn(){bn=JZ;new qn((Cyc(),Cyc(),Ayc))}
function wp(a){bn();this.b=(Cyc(),new JAc(a))}function Qo(a){oo();this.d=(Cyc(),new uAc(a))}function Vr(a,b,c){this.a=a;Af.call(this,b,c)}function N1(a,b,c){this.a=a;this.c=b;this.b=c}function a1(a,b,c){this.c=a;this.b=b;this.a=c}function WC(a,b,c){this.j=a;this.b=b;this.a=c}function aB(a,b,c){this.b=a;this.a=b;this.c=c}function c$(a,b,c){he.call(this,a,b);this.a=c}function r$(a,b,c){he.call(this,a,b);this.a=c}function Dy(a,b){Zf.call(this,a);this.a=Sd(b)}function Hy(a,b){pk.call(this,a);this.a=Sd(b)}
function nvb(a){kvb();this.a=a;this.b=new fDc}function Ddb(a){sdb();this.a=a;this.b=new Cwc}function Zeb(a){Ueb();this.a=a;this.b=new Cwc}function Lwb(){Lwb=JZ;Jwb=new Owb;Kwb=new Pwb}function ixb(){ixb=JZ;gxb=new mxb;hxb=new oxb}function sxb(){sxb=JZ;qxb=new vxb;rxb=new wxb}function wFb(){wFb=JZ;vFb=new zFb;uFb=new BFb}function U6(a){!a.P&&(a.P=new llc);return a.P}function GMb(a){var b;b=a.o;a.o=null;return b}function Hnb(a,b){if(a.a)return a.a;return b}function cib(a,b){oib(a.j,b);Ywc(a.a,b);a.j=
b}function RC(a,b){SC(a,"file",false);a.a+=""+b}function e3b(a,b){return i3b((Afc(),vcc),a,b)}function L3b(a,b){return i3b((Afc(),vec),a,b)}function G3b(a,b){return i3b((Afc(),lec),a,b)}function o3b(a,b){return i3b((Afc(),edc),a,b)}function s3b(a,b){return i3b((Afc(),xdc),a,b)}function X3b(a,b){return i3b((Afc(),efc),a,b)}function gyb(a){return vZ(mZ(Date.now()),a.a)}function Hfc(a){return new kcc((Afc(),Bcc),a)}function Cjc(a){return Yfc(a.k)?a.A.u[51]:a.k}function Ksc(a,b,c){return a.lastIndexOf(b,
c)}function Vub(a){a.b=U6(a.a);return new Rub(a)}function _Vb(a){this.b=a;this.a=(Bn(),new Zr)}function c2b(a){GD.call(this,"Precision: "+a)}function dJc(){this.a=iLc;this.b="";this.c=""}function zJc(a){this.b=a;QFc.call(this,LLc,0)}function Re(a){return new Xe(a.c,true,a.d,a.a)}function Po(a,b){return b==null?null:Bx(a.d,b)}function qs(a,b){return dn(po(a.a)).ce(b).Ve()}function f5b(a,b){!a.d&&(a.d=new L5b);a.d.a=b}function g5b(a,b){!a.d&&(a.d=new L5b);a.d.b=b}function j5b(a,b){!a.d&&(a.d=new L5b);
a.d.d=b}function l5b(a,b){!a.d&&(a.d=new L5b);a.d.i=b}function m5b(a,b){!a.d&&(a.d=new L5b);a.d.j=b}function n5b(a,b){!a.d&&(a.d=new L5b);a.d.k=b}function NIc(a,b){if(zIc)return;!!b&&(a.d=b)}function Lcb(a,b){return pF(b,5)&&Esc(b.b,a.b)}function Qmb(a,b){Kd(true);b.k=null;bxc(a.d,b)}function _sb(a,b){this.c=a;this.b=b.d;this.a=b}function Mcb(a,b,c){this.b=a;this.c=b;this.a=c}function smb(a,b,c){this.a=a;this.c=b;this.b=c}function hub(a,b,c){he.call(this,a,b);this.a=c}function Ivb(a,b,c){this.b=a;
this.c=b;this.a=c}function du(a){this.a=a;this.b=1;Cm.call(this)}function iAb(a,b,c){this.a=a;this.b=b;this.c=c}function pDb(a,b,c){he.call(this,a,b);this.a=c}function AJb(a,b,c){he.call(this,a,b);this.a=c}function ENb(a,b,c){this.c=a;this.b=b;this.a=c}function a5(a,b){b5.call(this,a,b,false,false)}function r0(a,b){while(b){q0(a,b,false);b=b.f}}function Nub(a,b){return Hnb(Gnb(b.d,a.d),a.f)}function Cvb(a,b){return kQb(l9(a.a.G),wab(b))}function mQb(a,b){return new uQb(AQb(a.a,b.a))}function pQb(a,
b){return new uQb(AQb(a.a,b.a))}function tQb(a,b){return new uQb(wQb(a.a,b.a))}function PPb(a){NPb();return ne((SPb(),RPb),a)}function reb(){reb=JZ;qeb=tQb((iQb(),$Pb),ZPb)}function Cyc(){Cyc=JZ;Ayc=new Myc;Byc=new bzc}function bFc(){bFc=JZ;_Ec=new cFc;aFc=new eFc}function h5b(a){!a.d&&(a.d=new L5b);K5b(a.d,4)}function o5b(a){!a.d&&(a.d=new L5b);K5b(a.d,5)}function p5b(a){!a.d&&(a.d=new L5b);K5b(a.d,6)}function r5b(a){!a.d&&(a.d=new L5b);K5b(a.d,0)}function u5b(a){!a.d&&(a.d=new L5b);K5b(a.d,3)}function v5b(a){!a.d&&
(a.d=new L5b);K5b(a.d,2)}function z5b(a){!a.d&&(a.d=new L5b);K5b(a.d,1)}function eoc(a,b,c){return b==c||b==Unc(a.c,c)}function I4b(a){return(HPc&a.a)==$Lc?a.i:null}function M4b(a){return(HPc&a.a)==WPc?a.i:null}function uwc(a){return a.a[a.c-1&a.a.length-1]}function Hhc(a,b){egc.call(this,a,b);xhc(this)}function Ikc(a,b,c){he.call(this,a,b);this.a=c}function DZb(a,b,c){he.call(this,a,b);this.a=c}function $Zb(a,b,c){this.c=a;this.a=b;this.b=c}function TCc(a,b,c){this.a=a;this.b=b;this.c=c}function hEc(a,
b,c){this.a=a;this.b=b;this.c=c}function Di(a){this.d=a;Ai(this);this.b=fg(a.d)}function hxc(a){Wwc(this);pKc(this.a,0,a._d())}function rBc(a,b,c){return Lrc(a.Oh(b),a.Oh(c))}function uZ(a,b){return jZ($E(pZ(a)?wZ(a):a,b))}function wj(a,b){if(!a)return 0;return $l(a,b)}function jl(a,b){Sd(a);Sd(b);return new kl(a,b)}function Wt(a,b){Sd(a);Sd(b);return new _t(a,b)}function Yjb(a,b){Rjb();!!b&&(a.d=b,a);return a}function Hic(a,b){a.k=Xkc(a.f,b,null);return a}function mrc(){var a;a=jrc(null);a.i=2;return a}
function Nw(a){var b;b=new fxc;mu(b,a);return b}function sz(a){var b;b=new mDc;mu(b,a);return b}function H6(a){var b;b=a.G.F;b=b?b:a.e;return b}function q9b(a,b){d9b(a,(Hbc(),mbc),b);return a}function gib(a,b,c){nib(a.j,b,Ghb(a,b,false,c))}function dTb(a,b,c){NRb.call(this,a,c);this.c=b}function oac(a,b,c){nac.call(this,a,c);this.a=b}function yac(a,b,c){nac.call(this,a,c);this.a=b}function HEc(a,b,c){this.c=a;wvc.call(this,b,c)}function pKc(a,b,c){mKc(c,0,a,b,c.length,false)}function Ywc(a,b){a.a[a.a.length]=
b;return true}function Rsb(a,b){a.r=b;a.a=C1(new J1(a.b),a.d)}function zo(a,b){oo();el(a,b);return new Wq(a,b)}function Ho(a,b){oo();return el(a,b),new Sz(a,b)}function uCb(a){qCb();this.b=a;this.a=new B0(a)}function Gs(a){this.b=a;this.a=po(this.b.a).uf()}function _t(a,b){this.a=a;this.b=b;Cm.call(this)}function tzb(){jsb.call(this,"es6ConvertSuper")}function Izb(){jsb.call(this,"lateConvertEs6")}function Xyb(){jsb.call(this,"Es6RewriteClass")}function zc(){vc.call(this,"CharMatcher.none()")}function yZ(a){if(pZ(a))return a|
0;return bF(a)}function krc(a){var b;b=jrc(a);yrc(a,b);return b}function $Gc(a,b){return!!b&&_Gc(a,b.d)?b:null}function yfb(a){return a.n==(Afc(),Jdc)||Aqb(a)}function E0(a){return a.b==(Sbb(),Qbb)||a.b==Pbb}function Flb(a){return!a.n?a.b:Flb(a.n)+"."+a.b}function $Jb(a,b){return!!a.b&&a.b.a.a.c<=b.b.c}function nkb(a,b){return Ssc(b,a.g+"_const"+_Pc)}function eKb(a,b,c){return w8b(new L9b(b,c),a.s)}function rQb(a,b){return new uQb(AQb(a.a,op(b)))}function jB(a,b){return b<a.e.length&&a.e[b]!=-1}function Tob(a,
b){ppb();QCc(ipb,b.n)&&kwc(a.b,b)}function lib(a,b){Xd(!a.d);Xd(I3b(b));q8b(a.a,b)}function n0(a,b,c){F_(a,(IRb(),xRb),c);m0(a,b,c)}function EOb(a,b,c,d){var e;e=x2b(c,d);a.Rh(b,e)}function YVb(a,b,c){ZVb.call(this,a,b,c,0,false)}function hzb(){jsb.call(this,"RewritePolyfills")}function Gfc(){Gfc=JZ;Ffc=new $wnd.RegExp("\\s")}function X2b(){X2b=JZ;W2b=$wnd.JSON.parse($2b())}function g2b(a){throw gZ(new a2b(a.b.b,Bb(a.a)));}function Tnc(a){return a.c.wf(a.d.Yd(),a.c.Yd())}function mlc(a){a=a.Fi();
return!!a.Ji()||_fc(a)}function Z3b(a,b){Xd(H3b(b));return new L9b(a,b)}function ljc(a,b){!a.j&&(a.j=new fxc);Ywc(a.j,b)}function hlc(a,b){flc(a,b,b.di(new stc,false).a)}function Vxc(a,b,c){GKc(b,a.length);Sxc(a,0,b,c)}function Ewc(a){Dwc.call(this,a.Yd());Rc(this,a)}function goc(a,b){foc.call(this,a,b);this.b=true}function vFc(a,b){this.d=a;this.a=16449;this.c=b}function Ch(a){this.c=a;this.b=this.c.a.He().Vd()}function FEc(a){a.a.b=a.b;a.b.a=a.a;a.a=a.b=null}function _Cc(a){a.b=a.a;ZCc(a);return a.c.b[a.b]}
function Q3(a){Xd(a.u==a.v+1);a.Lg("${");++a.v}function Fv(a){if(a.c.e!=a.a)throw gZ(new WBc);}function ow(a){if(a.e.c!=a.b)throw gZ(new WBc);}function ou(a){Sd(a);while(a.Id()){a.Jd();a.Kd()}}function Wz(a){Bn();this.a=(Cyc(),new tzc(Sd(a)))}function zZ(a){if(pZ(a))return""+a;return cF(a)}function f5(a,b){a.c=b;a.d=b.wc;a.b=b.Ub;return a}function gu(a){var b;b=Qb(a.b);a.a=false;return b}function BE(a){return Array.isArray(a)&&a.Hj===OZ}function Wnb(a){TZ();Xnb.call(this,a,(Lwb(),Jwb))}function Znb(a,
b){z1.call(this);this.a=a;this.b=b}function Tyb(){jsb.call(this,"Es6ExtractClasses")}function Yzb(){jsb.call(this,"rewriteGenerators")}function C7b(a){B7b.call(this,new B5b(a),a,false)}function X7(){U7.call(this,"validityCheck",false)}function lcc(a,b){n8b();J9b.call(this,a);this.a=b}function T6b(a,b){m5b(a.a,b);a.e=true;return true}function NWb(a,b){a.d.a=zE(iW,mLc,1,0,5,1);a.f=b}function Nu(){Nu=JZ;Mu=new Ou(zE(iW,mLc,1,0,5,1))}function $rc(){$rc=JZ;Zrc=zE(bW,mLc,132,256,0,1)}function ksc(){ksc=
JZ;jsc=zE(eW,mLc,156,256,0,1)}function brc(){brc=JZ;arc=zE(UV,mLc,186,128,0,1)}function _mc(){_mc=JZ;$mc=new jnc((oo(),oo(),no))}function Okc(a,b,c){return Mkc(a,b,Vkc(a,true,c))}function Qkc(a,b,c){return Pkc(a,b,Vkc(a,true,c))}function Rfc(a,b){return pF(b,23)&&$fc(a,b,false)}function fCc(a,b){return PCc(a.a,b)?a.b[b.f]:null}function W4b(a){return(a.a&512)!=0||(a.a&bPc)!=0}function T8b(a){return a.n==(Afc(),Fec)||a.n==Acc}function oF(a){return!Array.isArray(a)&&a.Hj===OZ}function hl(a,b){return new Gl(fJc(a).Ej(),
b,1296)}function We(a){Xe.call(this,a,false,(yc(),xc),_Kc)}function $Ec(a){pDc.call(this,new tEc);Rc(this,a)}function BCc(a){this.c=a;this.a=new aDc(this.c.a)}function Ou(a){Af.call(this,0,0);this.a=a;this.b=0}function _pc(a,b){Ofc();Ghc.call(this,a);this.a=b}function Kxc(a,b){var c;for(c=0;c<b;++c)a[c]=-1}function Mxc(a,b){var c;for(c=0;c<b;++c)a[c]=-1}function nj(a,b){var c;c=Bx(a.a,b);return!c?0:c.a}function qtc(a,b){a.a+=gtc(b,0,b.length);return a}function Q0(a,b){a.a=(Nqc(),b?true:false);return a}
function Cmb(a){a.n==(Afc(),Qcc)&&(a=a.c);return a}function fE(a,b){!a&&(a=[]);a[a.length]=b;return a}function f$(a){var b;b=a;while(b.b)b=b.b;return b}function MMb(a){var b;b=nOb(a.j);a.o=null;return b}function g9b(a){var b;b=a.c;!!b&&e9b(a,b);return b}function uKb(a,b){T9b(a.k)==-1&&vKb(a,b.o.b,b.o.a)}function oib(a,b){if(!a.d&&!a.a.c){Xd(!b.d);a.d=b}}function Thb(a,b){if(b)return b;return new pib(a)}function Vwb(a,b,c){return _wb(axb(new bxb,c),a,b)}function Nkc(a,b,c){return Mkc(a,b,Vkc(a,false,
c))}function Emc(a,b,c,d){return Igc(a,b,c,d)||!b.ti()}function auc(a,b){return tF(b)?buc(a,b):GDc(a.d,b)}function MCc(a,b){var c;c=LCc(a);Dyc(c,b);return c}function Lxc(a,b,c){var d;for(d=0;d<b;++d)a[d]=c}function gCc(a,b,c){NCc(a.a,b);return jCc(a,b.f,c)}function oEb(a,b,c,d){nEb();kEb.call(this,a,b,c,d)}function oDc(a){this.a=(a.Yd(),new gDc);Rc(this,a)}function wIc(a,b){this.a=a;this.b=b;mZ(Date.now())}function euc(){this.d=new HDc(this);this.e=new _Dc}function fuc(){this.d=new HDc(this);this.e=
new _Dc}function Ki(a,b){this.a=a;Ei.call(this,a,a.d.ee(b))}function ri(a,b,c,d){this.a=a;di.call(this,a,b,c,d)}function Ve(a,b){Sd(b);return new Xe(a.c,a.b,b,a.a)}function po(a){if(a.e)return a.e;return a.e=a.yf()}function qo(a){if(a.f)return a.f;return a.f=a.zf()}function so(a){if(a.g)return a.g;return a.g=a.Af()}function Kf(a){var b;b=a.g;return!b?a.g=a.ue():b}function dn(a){var b;b=a.c;return!b?a.c=a.tf():b}function nrc(a){var b;b=jrc(a);b.o=a;b.i=1;return b}function k7(a){a.K=0;ebb(a.G);g7(a);
l7(a);a.K=.15}function bi(a){a.b?bi(a.b):a.d.Ud()&&a.f.c.Ke(a.e)}function s9(a){return!a.ad&&!a.A&&a.zb!=($9(),X9)}function TE(a,b){return HE(a.l&b.l,a.m&b.m,a.h&b.h)}function dF(a,b){return HE(a.l^b.l,a.m^b.m,a.h^b.h)}function oB(a,b){return yZ(kZ(hZ(rZ(a.b.a,b),7),8))}function XDc(a,b){return!(a.a.get(b)===undefined)}function ZDb(a,b){a.a=(Nqc(),b?true:false);return a}function $Db(a,b){a.b=(Nqc(),b?true:false);return a}function Omb(a,b){Ywc(a.d,b);Kd(!b.k||b.k==a);b.k=a}function eJb(a,b){a.e=(Nqc(),
b?true:false);return a}function pmb(){pmb=JZ;omb=new smb(null,false,null)}function iob(a){this.b=new Cwc;this.c=a;this.a=true}function gsb(a){this.c=new fDc;this.b=a;this.a=true}function HB(a){AB(this);this.g=a;BB(this);this.Zf()}function rB(a,b,c){qB.call(this,new kB(a,Wsc(b)),c)}function zB(a,b,c){yB.call(this,new kB(a,Wsc(b)),c)}function sAb(){jsb.call(this,"rewriteObjectSpread")}function IAb(){U7.call(this,"es6ExternsCheck",true)}function BFb(){xFb.call(this,"CANONICALIZE_ONLY",1)}function uQb(a){iQb();
var b;this.a=(bn(),b=a,mp(b))}function G2b(a){throw gZ(new Q2b(Vsc(a.a,a.d,a.b)));}function V3b(a){return n8b(),new Wbc((Afc(),bfc),a)}function Vtc(a,b){return Wtc(a,b,a.e)||Wtc(a,b,a.d)}function asc(a,b){return iZ(a,b)<0?-1:iZ(a,b)>0?1:0}function ylc(a,b){a.e=b;pF(b,48)?a.d=b:a.d=null}function Nxc(a,b){var c;for(c=0;c<b;++c)a[c]=null}function fe(a){var b,c;b=a.Fj;c=b.f;return c==XV?b:c}function wTb(a){var b;b=CWb(a.g);a.f=b.d.a;return b}function Poc(a){Yoc(new Epc,a.b)&&Voc(a);return a.b}function Ooc(a){Yoc(new opc,
a.b)&&Voc(a);return a.a}function Yw(a,b){var c;c=a.a.Yd();Vd(b,c);return c-b}function $B(a){var b;b=(a&1)==1;a=a>>1;return b?-a:a}function yGc(a){this.b=null;this.a=(HBc(),!a?EBc:a)}function IFc(a,b){this.e=a;this.d=(b&64)!=0?b|JLc:b}function Vi(a,b,c){this.a=a;di.call(this,a,b,c,null)}function Xs(a,b){Bn();Ws.call(this,a,Vn(new eyc(b)))}function wpb(a,b,c){ppb();return Zpb(a,new nrb(b),c)}function rmb(a,b){return b==a.c?a:new smb(a.a,b,a.b)}function Im(a){return new Tu(new Lm(a.a.length,a.a))}function aq(a,
b){return new aB(a.Ve(),b.Ve(),b.We())}function hKb(a,b){return w8b((n8b(),new tac(b)),a.s)}function fKb(a,b,c,d){return w8b(new N9b(b,c,d),a.s)}function Amb(a,b,c){return c?"{"+Dmb(a,c.a)+"} "+b:b}function CDb(a,b,c){wDb();this.b=a;this.a=b;this.c=c}function J9b(a){n8b();this.n=a;this.g=null;this.k=-1}function Wbc(a,b){n8b();J9b.call(this,a);Ubc(this,b)}function Kyb(a,b){Fyb();a.g.a.d!=0||z7(a,tQb(a.p,b))}function K5b(a,b){var c;c=(Ld(b>=0,lTc),1<<b);a.p|=c}function Jfc(a,b){!!b&&d9b(a,(Hbc(),Nac),
b);return a}function Qic(a){this.b=new J9b((Afc(),Jec));this.a=a}function TFc(){TFc=JZ;SFc=new bGc;TFc();RFc=new YFc}function rFc(a){if(!a.d){a.d=a.b.Vd();a.c=a.b.Yd()}}function SJc(a,b,c){if(a.a.Nd(c)){a.b=true;b.jf(c)}}function qKb(a,b){a.i&&a.d.Ah(ZQc,a.q,b.b.b+1,b.b.a)}function b0(a,b){b.n!=a&&D0(QMc+a+" but was "+b.n,b)}function Utc(a,b){return tF(b)?Ztc(a,b):!!EDc(a.d,b)}function Ssc(a,b){return Esc(a.substr(0,b.length),b)}function joc(a,b){return!!b.Li()&&Zfc(a.e,b.Li().e)}function AHc(a,b){return a.a.Je(b,
(Nqc(),Lqc))==null}function jDc(a,b){var c;c=a.a.Je(b,a);return c==null}function jCc(a,b,c){var d;d=a.b[b];a.b[b]=c;return d}function cxc(a,b,c){var d;d=a.a[b];a.a[b]=c;return d}function $Ic(a,b,c){this.c=a;this.a=b;Cyc();this.b=c}function Nz(a){this.a=Sd(a);this.b=(Cyc(),new kBc(a))}function mz(){mz=JZ;bn();lz=new nz((Cyc(),Cyc(),Byc))}function Bn(){Bn=JZ;bn();An=new hz((Cyc(),Cyc(),Ayc))}function dv(){Zu();return CE(xE(wI,1),sLc,346,0,[Yu])}function Ihc(a){Ofc();return!a?null:pF(a,48)?a:null}function SEc(a){FEc(a.a);
auc(a.c.a.c,a.a.d);a.a=null}function U3(a){Xd(a.v>0);Xd(a.u==a.v);a.Lg("}");--a.v}function A8(a){if(a.g)return In(a.o);return y8(a).g}function _fc(a){if(pF(a,76))return a.n;return false}function L6(a,b){if(!b)return null;return OHc(a.u,b)}function Dhb(a,b,c,d){return F9b(t3b(Chb(a,b,c,d)),b)}function aib(a,b,c,d){return F9b(S3b(Chb(a,b,c,d)),b)}function sQb(a,b,c){return new uQb(wQb(a.a,MCc(b,c)))}function pFb(a,b){return new qFb(a.b,a.b.c.Mh(a.a,b))}function mhb(a,b){while(b.c)thb(a,g9b(b),null,
null)}function Gsc(a,b,c,d,e){while(b<c)d[e++]=zsc(a,b++)}function CC(a,b,c,d,e){xC.call(this,a,b,c,d);this.a=e}function ghc(a,b,c){Ofc();hhc.call(this,a,b,c,false)}function yB(a,b){qB.call(this,a,b);Kd(a.c.length==64)}function kAb(){jsb.call(this,"rewriteAsyncFunctions")}function oAb(){jsb.call(this,"rewriteAsyncIteration")}function Ic(){vc.call(this,"CharMatcher.whitespace()")}function Euc(a){a.b<a.d.Yd();return a.d.ce(a.c=a.b++)}function sq(a){var b;b=a.d;return!b?a.d=new ar(a):b}function _cb(a){var b;
b=(TZ(),new Vnb);b.d=a;return b}function J$(a,b){var c;c=i3b((Afc(),wcc),a,b);return c}function L$(a,b){var c;c=i3b((Afc(),edc),a,b);return c}function Q$(a,b){var c;c=i3b((Afc(),Zdc),a,b);return c}function _$(a,b){var c;c=i3b((Afc(),Hec),a,b);return c}function Xw(a,b){var c;c=a.a.Yd();Rd(b,c);return c-1-b}function lKc(a,b){var c;c=a.slice(0,b);return DE(c,a)}function kJc(a,b){!a.c?Ywc(a.b,b):kJc(a.c,b);return a}function Eic(a,b,c){a.g=b;a.e=c?a.e|4:a.e&-5;return a}function Sd(a){if(a==null)throw gZ(new msc);
return a}function wz(a){if(pF(a,336))return a;return new Nz(a)}function J8(a,b){return(bn(),Qs(new Rs,a)).Of(b).Pf()}function fzc(a,b){return $tc(a.a,b,(Nqc(),Mqc))==null}function Xdb(){Xdb=JZ;Wdb=oQb((iQb(),TPb),(IRb(),MQb))}function cdb(){cdb=JZ;bdb=oQb((iQb(),TPb),(IRb(),BRb))}function sdb(){sdb=JZ;rdb=oQb((iQb(),TPb),(IRb(),BRb))}function ieb(){ieb=JZ;heb=oQb((iQb(),TPb),(IRb(),ZQb))}function yeb(){yeb=JZ;xeb=oQb((iQb(),TPb),(IRb(),XQb))}function Ueb(){Ueb=JZ;Teb=oQb((iQb(),TPb),(IRb(),GQb))}
function Qfb(){Qfb=JZ;Pfb=oQb((iQb(),TPb),(IRb(),KQb))}function vgb(){vgb=JZ;ugb=oQb((iQb(),TPb),(IRb(),MQb))}function _gb(){_gb=JZ;$gb=oQb((iQb(),TPb),(IRb(),$Qb))}function $jb(){$jb=JZ;Zjb=oQb((iQb(),TPb),(IRb(),WQb))}function tub(){tub=JZ;rub=oQb((iQb(),TPb),(IRb(),HQb))}function evb(){evb=JZ;dvb=oQb((iQb(),TPb),(IRb(),pRb))}function rvb(){rvb=JZ;qvb=oQb((iQb(),TPb),(IRb(),mRb))}function XDb(){XDb=JZ;oo();el(mNc,kNc);new Sz(mNc,kNc)}function Bnb(a){this.b=new fxc;this.c=new fxc;this.a=a}function Ysb(a){this.f=
a;this.d=new fxc;this.c=new mDc}function eAb(a,b,c){this.a=b;this.b=c;jsb.call(this,a)}function tnb(a,b,c){qnb.call(this,a);this.b=b;this.a=c}function Alc(a,b,c){Hhc.call(this,a,c);ylc(this,Sd(b))}function nlc(a,b,c,d){Ofc();Mjc.call(this,a,nPc,b,c,d)}function tWb(a,b,c){return new NRb(b,$Sb(a.i.b,c,a.f))}function Xtc(a,b){return tF(b)?Ytc(a,b):Hg(EDc(a.d,b))}function Zsc(a,b){return tF(a)?a.charCodeAt(b):a.hj(b)}function htc(a,b){return a.a+=String.fromCharCode(b),a}function itc(a,b){a.a+=String.fromCharCode(b);
return a}function wqc(a,b){vqc(a,b,b+1,String.fromCharCode(32))}function yyc(a,b){var c;c=b+1;c>a.length&&(a.length=c)}function uKc(a,b){var c;c=console[a];c.call(console,b)}function axc(a,b){var c;c=a.a[b];qKc(a.a,b,1);return c}function Bhc(a){var b;b=new CHc;anc(a.Vi(),b);return b}function IKc(a){if(a==null)throw gZ(new msc);return a}function xGb(){z1.call(this);this.a=_cb((Wcb(),false))}function Pyb(){jsb.call(this,"Es6ExtractClassExtends")}function wB(){vB.call(this,new kB("base16()",Wsc(fLc)))}
function oo(){oo=JZ;no=new kz(CE(xE(QX,1),PLc,50,0,[]))}function Dd(a){this.b=new Fd;this.c=this.b;this.a=Sd(a)}function Gv(a){this.c=a;this.b=this.c.a;this.a=this.c.e}function it(a,b){ht();Qo.call(this,a);this.a=b;this.c=a}function Ijb(a,b,c){this.a=a;this.c=b;this.d=c;Xd(true)}function E7(a,b){!a.G&&_6(a,new v9);return F7(a,b,true)}function Gd(a,b){return uF(a)===uF(b)||a!=null&&zb(a,b)}function m9(a,b){return kQb(wab(a.Sb),b)&&!kQb(l9(a),b)}function n9(a,b){return lQb(wab(a.Sb),b)&&!lQb(l9(a),
b)}function Phb(a,b){return K3b(b+(a.r.b==0?"":"$"+a.r.b))}function c_(a){return Xd(H3b(a)),new L9b((Afc(),Uec),a)}function q_(a,b){var c;c=C8b(a);b!=c&&D0(QMc+b+RMc+c,a)}function Dmb(a,b){var c;c=new stc;ymb(a,c,b);return c.a}function _Eb(a,b){!b?a.a=new sFb:a.a=b;jEb(a.c,a.a)}function PRb(a,b){NRb.call(this,(AZb(),iYb),a);this.a=b}function KZb(a,b){IZb.call(this,(n1b(),y_b),a);this.a=b}function LZb(a,b){IZb.call(this,(n1b(),z_b),a);this.a=b}function MZb(a,b){IZb.call(this,(n1b(),A_b),a);this.a=
b}function NZb(a,b){IZb.call(this,(n1b(),B_b),a);this.a=b}function OZb(a,b){IZb.call(this,(n1b(),C_b),a);this.a=b}function PZb(a,b){IZb.call(this,(n1b(),D_b),a);this.a=b}function QZb(a,b){IZb.call(this,(n1b(),E_b),a);this.a=b}function SZb(a,b){IZb.call(this,(n1b(),G_b),a);this.a=b}function TZb(a,b){IZb.call(this,(n1b(),H_b),a);this.a=b}function ZZb(a,b){IZb.call(this,(n1b(),N_b),a);this.a=b}function q$b(a,b){IZb.call(this,(n1b(),X_b),a);this.a=b}function s$b(a,b){IZb.call(this,(n1b(),Z_b),a);this.a=
b}function v$b(a,b){IZb.call(this,(n1b(),a0b),a);this.a=b}function A$b(a,b){IZb.call(this,(n1b(),f0b),a);this.a=b}function B$b(a,b){IZb.call(this,(n1b(),g0b),a);this.a=b}function G$b(a,b){IZb.call(this,(n1b(),h0b),a);this.a=b}function a_b(a,b){IZb.call(this,(n1b(),o0b),a);this.a=b}function c_b(a,b){IZb.call(this,(n1b(),q0b),a);this.a=b}function j_b(a,b){IZb.call(this,(n1b(),x0b),a);this.a=b}function p_b(a,b){IZb.call(this,(n1b(),E0b),a);this.a=b}function t_b(a,b){IZb.call(this,(n1b(),I0b),a);this.a=
b}function u_b(a,b){IZb.call(this,(n1b(),J0b),a);this.a=b}function v_b(a,b){IZb.call(this,(n1b(),K0b),a);this.a=b}function x_b(a,b){IZb.call(this,(n1b(),M0b),a);this.a=b}function s1b(a,b){IZb.call(this,(n1b(),P0b),a);this.a=b}function t1b(a,b){IZb.call(this,(n1b(),Q0b),a);this.a=b}function u1b(a,b){IZb.call(this,(n1b(),R0b),a);this.a=b}function w1b(a,b){IZb.call(this,(n1b(),T0b),a);this.a=b}function A1b(a,b){IZb.call(this,(n1b(),X0b),a);this.a=b}function B1b(a,b){IZb.call(this,(n1b(),Y0b),a);this.a=
b}function D1b(a,b){IZb.call(this,(n1b(),$0b),a);this.a=b}function G1b(a,b){IZb.call(this,(n1b(),c1b),a);this.a=b}function H1b(a,b){IZb.call(this,(n1b(),d1b),a);this.a=b}function K1b(a,b){IZb.call(this,(n1b(),f1b),a);this.a=b}function O1b(a,b){IZb.call(this,(n1b(),j1b),a);this.a=b}function Ezb(){jsb.call(this,"es6RewriteRestAndSpread")}function dzb(){jsb.call(this,"Es6RewriteArrowFunction")}function Iqb(a){ppb();return a.n!=(Afc(),pec)&&Jqb(a.g)}function qqb(a){ppb();return a.n==(Afc(),Pdc)||a.n==
Odc}function _Gc(a,b){return nGc(a.c,a.f,b,a.b,a.a,a.e,a.d)}function QHc(a,b,c){return NHc(a,b)?OHc(a,b):PHc(a,b,c)}function fJc(a){if(0>=a)return new rJc;return gJc(a-1)}function lJc(a){if(!a.c){mJc(a);a.d=true}else lJc(a.c)}function Ci(a){ai(a.d);if(a.d.d!=a.c)throw gZ(new WBc);}function T3(a){Xd(a.u>0);Xd(a.u==a.v+1);a.Lg("`");--a.u}function eCc(a){Tc(a.a);a.b=zE(iW,mLc,1,a.b.length,5,1)}function egc(a,b){this.A=a;this.B=!b?Xkc(a,null,null):b}function Xe(a,b,c,d){this.c=a;this.b=b;this.d=c;this.a=
d}function sD(a,b,c,d){this.c=a;this.d=b;this.b=c;this.a=d}function yD(a,b,c,d){this.d=a;this.c=b;this.a=c;this.b=d}function p8(a,b,c,d){this.a=a;this.b=b;this.d=c;this.c=d}function pv(a,b,c,d){Wq.call(this,a,b);this.d=c;this.a=d}function b5(a,b,c,d){he.call(this,a,b);this.b=c;this.a=d}function $q(a,b,c,d){Wq.call(this,a,c);this.a=b;this.f=d}function u5(a,b,c,d){m5.call(this,c,d);this.a=a;this.c=b}function oz(a){wp.call(this,a);this.a=(Cyc(),new kBc(a))}function Rj(a){this.e=a;this.c=new yuc((new puc(a.a)).a)}
function is(a){this.b=(fl(a,"initialArraySize"),new gxc)}function fib(a,b){lib(a.j,b);eib(a,Fhb(a,b));a.j.e=false}function Jyb(a,b,c){Fyb();a.g.a.d!=0||z7(a,sQb(a.p,b,c))}function owb(a,b,c,d,e){u7(a.a,lwb(a,b,c,d,e,(E2(),B2)))}function pwb(a,b,c,d,e){u7(a.a,lwb(a,b,c,d,e,(E2(),D2)))}function gKb(a,b,c,d,e){return w8b(new O9b(b,c,d,e),a.s)}function iKb(a,b,c){return w8b((n8b(),new Wbc(b,c)),a.s)}function kKb(a,b,c){return w8b((n8b(),new ecc(b,c)),a.s)}function c6(){a6();return CE(xE(nL,1),sLc,275,
0,[$5,_5])}function J9(){H9();return CE(xE(EL,1),sLc,262,0,[F9,G9])}function FFb(){EFb();return CE(xE(WQ,1),sLc,264,0,[DFb])}function S3b(a){Xd(H3b(a));return new L9b((Afc(),Uec),a)}function U3b(a){Xd(H3b(a));return new L9b((Afc(),_ec),a)}function Wqc(a){var b;b=a-10;return(b<0?48+a:97+b)&dLc}function zub(a){a.a=new i_;a.c=U6(a.b);return new vub(a)}function Tkc(a,b){var c;c=new Qic(a);Mic(c,b);return c.b}function OMb(a,b){a.o=!a.o?mOb(a.j):GMb(a);return a.o==b}function _pb(a){ppb();Kd(a.n==(Afc(),
ofc));return P8b(a)}function Vrc(a,b){while(b-- >0)a=a<<1|(a<0?1:0);return a}function rwc(a){var b;b=a.a[a.c-1&a.a.length-1];return b}function Rwc(a){this.d=a;this.a=this.d.b;this.b=this.d.c}function sXb(a,b){this.c=a;this.a=b;this.b=new _Sb(this)}function vkc(a,b){this.b=a;this.c=b;this.a=DKc(a)^DKc(b)}function Mkc(a,b,c){return uic(Dic(Bic(new Lic(a),c),b))}function aic(a,b,c,d){return Igc(a,b,c,d)||a.d.Ai(b,c,d)}function $tc(a,b,c){return tF(b)?_tc(a,b,c):FDc(a.d,b,c)}function iCc(a,b){return RCc(a.a,
b)?jCc(a,b.f,null):null}function kFc(a,b){return uF(a)===uF(b)||a!=null&&zb(a,b)}function BZb(a){return a.a==null?(OSb(),Po(pSb,a)).c:a.a}function $sc(a){return String.fromCharCode.apply(null,a)}function qAc(a){!a.b&&(a.b=new QAc(a.d.He()));return a.b}function sAc(a){!a.c&&(a.c=new JAc(a.d.we()));return a.c}function tAc(a){!a.e&&(a.e=new Fzc(a.d.Le()));return a.e}function Yi(a){var b;b=a.c;!b&&(a.c=b=new hk(a));return b}function Zi(a){var b;b=a.d;!b&&(a.d=b=new mk(a));return b}function cu(a){var b;
b=mf(a.a);nu(b,a.b);return new hu(b)}function Tc(a){var b;for(b=a.Vd();b.Id();){b.Jd();b.Kd()}}function Iyc(a){Cyc();return!a?(HBc(),HBc(),GBc):a.nf()}function h_(a){return Yd(H3b(a),a),new L9b((Afc(),Ddc),a)}function Kmb(a,b,c){return new Gmb(null,null,-1,-1,b,a,c)}function vqc(a,b,c,d){a.a=Vsc(a.a,0,b)+(""+d)+Usc(a.a,c)}function kEb(a,b,c,d){this.e=a;this.f=b;this.d=c;this.g=d}function tFc(a,b){this.b=a;this.a=(b&4096)==0?b|64|JLc:b}function dlb(a){this.a=a;this.b=!a.j?new YEc:new $Ec(a.j)}function Zbb(a){Wbb();
this.a=null;this.b=(bn(),new Zz(a))}function j5(a){this.c=new v9;this.a=new k5(this);this.f=a}function X1b(a,b,c,d){this.d=a;this.c=b;this.b=c;this.a=d}function qWb(a,b,c,d){he.call(this,a,b);this.b=c;this.a=d}function JRb(a,b,c,d){he.call(this,a,b);this.a=c;this.b=d}function tac(a){n8b();J9b.call(this,(Afc(),Cec));this.a=a}function Uic(a,b,c){Xic.call(this,a,b,c,false,null,false)}function Xmc(a,b,c,d){this.c=a;this.e=b;this.b=c;this.d=d}function Inc(a,b){Ofc();zlc.call(this,a,a.u[51]);this.a=b}function x2b(a,
b){var c;c=new w2b;h2b(c,a,b);return c.c.a}function E7b(a){if(!a)return new C7b(true);return D7b(a)}function buc(a,b){return b==null?GDc(a.d,null):$Dc(a.e,b)}function uWb(a){return a.d.a.length==0?a.f:DWb(a,0).d.b.c}function DOb(a,b,c,d){var e;a.d=true;e=x2b(c,d);a.Qh(b,e)}function DIc(a,b,c,d){var e;e=new wIc(b,c);e.c=d;EIc(a,e)}function EJc(a,b){mJc(a);return new KJc(a,new TJc(b,a.a))}function FJc(a,b){mJc(a);return new KJc(a,new YJc(b,a.a))}function gv(a){var b;return b=a.g,!b?a.g=new Oh(a,a.c):
b}function XA(a){return pF(a,21)?a.$d():new KJc(null,a.Zd())}function HBc(){HBc=JZ;EBc=new KBc;FBc=new KBc;GBc=new OBc}function yoc(){yoc=JZ;voc=new Boc;woc=new Foc;xoc=new Joc}function Wcb(){Wcb=JZ;Ucb=new Zcb;Tcb=new $cb;Vcb=new adb}function iE(){iE=JZ;var a,b;b=!nE();a=new vE;hE=b?new oE:a}function Asc(a,b){var c,d;c=a;d=b;return c==d?0:c<d?-1:1}function s4(a,b){var c;for(c=b;c;c=c.f)a.fh(c,(_4(),W4))}function vsc(a,b,c){this.a=rMc;this.d=a;this.b=b;this.c=c}function bf(a,b){this.f=a.d;this.d=
a.b;this.b=a.a;this.e=b}function Xnb(a,b){XZ.call(this,a);Snb(this);Sd(a);this.a=b}function pbb(a){obb.call(this,(Bn(),Sd(a),In(new eyc(a))))}function xzb(){jsb.call(this,"es6InjectRuntimeLibraries")}function wAb(){jsb.call(this,"rewriteCatchWithNoBinding")}function Myb(){U7.call(this,"es6RewriteModuleToCjs",true)}function AAb(){jsb.call(this,"rewriteExponentialOperator")}function ccb(a){Wbb();gFc(Vbb,a,new ecb);return Xtc(Vbb,a)}function Wjb(a,b,c){Rjb();if(!a)return null;return b.u[c]}function zkc(a,
b,c,d){$tc(a.b,new Bkc(a,b,c),d);return d.a}function Mmb(a,b,c,d,e,f){return new Gmb(a,null,b,c,e,d,f)}function t3b(a){Yd(H3b(a),a);return new L9b((Afc(),Ddc),a)}function dub(a,b,c){var d;hub.call(this,a,b,(d=c,Afc(),d))}function eub(a,b,c){var d;hub.call(this,a,b,(d=c,Afc(),d))}function fub(a,b,c){var d;hub.call(this,a,b,(d=c,Afc(),d))}function ctc(a,b,c){return tF(a)?a.substr(b,c-b):a.jj(b,c)}function Lsc(a,b){return(new RegExp("^("+b+")$")).test(a)}function v8b(a){return!a.c?(Cyc(),Cyc(),Byc):
new Kbc(a.c)}function izc(a){return!a.b&&(a.b=new Wuc(a.a)),a.b.a.Yd()}function lCc(a){this.a=OCc(a.a);this.b=lKc(a.b,a.b.length)}function Eub(a){this.f=a;Cub(this);this.b=null;this.a=null}function uw(a){this.b=a;this.c=a;a.e=null;a.c=null;this.a=1}function OJc(a,b,c,d){this.b=a;this.c=d;QFc.call(this,b,c)}function z_(a){b0((Afc(),udc),a);W_(a.c);A_(a.c?a.c.i:null)}function BB(a){if(a.k){a.e!==eMc&&a.Zf();a.i=null}return a}function ZD(a){TD();$wnd.setTimeout(function(){throw a;},0)}function v1(a){var b;
this.c=new DHc(new Bwb);bn();b=a;mp(b)}function se(){se=JZ;pe=new we;oe=new ze;qe=new Ce;re=new Fe}function UKc(){if(PKc==256){OKc=QKc;QKc=new xb;PKc=0}++PKc}function t$(){q$();return CE(xE(MK,1),sLc,240,0,[n$,o$,p$])}function I$(){G$();return CE(xE(PK,1),sLc,231,0,[E$,F$,D$])}function G2(){E2();return CE(xE(bL,1),sLc,229,0,[B2,D2,C2])}function W9(){U9();return CE(xE(GL,1),sLc,225,0,[R9,S9,T9])}function AZ(a,b){return jZ(dF(pZ(a)?wZ(a):a,pZ(b)?wZ(b):b))}function $Eb(a,b){return new qFb(a,dFb(a.e.Ph(GFb(b)),
a.d))}function QMb(a,b){return w8b(new K9b(b,a.j.g,lOb(a.j)),a.n)}function Ztc(a,b){return b==null?!!EDc(a.d,null):XDc(a.e,b)}function T4b(a){return(a.a&37)!=0||(!a.d?null:a.d.d)!=null}function Yfc(a){return a.ti()||a.ri()||a.si()||a==a.A.u[64]}function k9(a){return a.Pb.Fd((Nqc(),vab(a.Sb)?true:false))}function Lob(a){while(!!a&&a.n!=(Afc(),Xec))a=a.g;return a}function C8b(a){var b,c;b=0;for(c=a.c;c;c=c.f)++b;return b}function B8b(a,b){var c;c=a.c;while(b>0){c=c.f;--b}return c}function FB(a,b){var c;
c=frc(a.Fj);return b==null?c:c+": "+b}function ZC(a,b){var c,d;d=b.b;c=b.a;return d!=0?c:c+a.c.i.a}function x6(a){var b;if(a.G.zc){b=I6(a);Esc(b,a.A)||(a.A=b)}}function PIc(a,b){if(!BIc)return;LIc(a,(bIc(),aIc),b,null)}function GIc(a,b){if(!xIc)return;LIc(a,(bIc(),ZHc),b,null)}function JIc(a,b){if(!yIc)return;LIc(a,(bIc(),$Hc),b,null)}function OIc(a,b){if(!AIc)return;LIc(a,(bIc(),_Hc),b,null)}function Lyc(a){Cyc();return pF(a,69)?new gBc(a):new _zc(a)}function fab(){dab();return CE(xE(IL,1),sLc,263,
0,[cab,bab])}function ktb(){itb();return CE(xE(FO,1),sLc,268,0,[htb,gtb])}function nub(){lub();return CE(xE(KO,1),sLc,267,0,[kub,jub])}function Ygb(){Wgb();return CE(xE(UM,1),sLc,303,0,[Ugb,Vgb])}function Nwb(){Lwb();return CE(xE(rP,1),sLc,185,0,[Jwb,Kwb])}function lxb(){ixb();return CE(xE(yP,1),sLc,195,0,[gxb,hxb])}function uxb(){sxb();return CE(xE(BP,1),sLc,194,0,[qxb,rxb])}function aab(){$9();return CE(xE(HL,1),sLc,224,0,[Y9,X9,Z9])}function yFb(){wFb();return CE(xE(UQ,1),sLc,190,0,[vFb,uFb])}
function HJb(){FJb();return CE(xE(qR,1),sLc,271,0,[EJb,DJb])}function MJb(){KJb();return CE(xE(rR,1),sLc,270,0,[JJb,IJb])}function Jcb(a,b){var c;c=new $bb(a,b);_tc(Gcb,a,c);return c}function Kcb(a,b){var c;c=new _bb(a,b);_tc(Gcb,a,c);return c}function epb(a,b,c){var d;d=new dpb(a,c,new Ajb(a));Yob(d,b)}function slb(a,b,c,d,e,f){var g;g=plb(a,e);jlb(a,g,d,f,b,c)}function Wic(a,b,c,d,e){Ofc();Xic.call(this,a,b,c,d,e,false)}function Xbc(a,b,c,d){n8b();K9b.call(this,a,c,d);Ubc(this,b)}function Muc(a,
b){this.a=a;Guc.call(this,a);a.Yd();this.b=b}function $pc(a,b){this.a=new fxc;this.i=a;this.g=30;this.k=b}function tXb(a,b,c){dTb.call(this,(AZb(),gZb),a,b);this.a=c}function wKb(a,b){u9b(a,T9b(b.k));m9b(a,S9b(b.k));t9b(a,b.e)}function OAc(a,b){var c;c=a.b.ae(b);PAc(c,a.b.Yd());return c}function wuc(a){var b;a.c=a.a;b=a.a.Jd();a.b=vuc(a);return b}function Zfc(a,b){var c;return c=new ukc(false),Qfc(a,b,0,c)}function PAc(a,b){var c;for(c=0;c<b;++c)a[c]=new _Ac(a[c])}function EDc(a,b){return CDc(a,b,
DDc(a,b==null?0:a.b.sj(b)))}function enc(a){if(!a.a)return Bn(),Bn(),An;return a.a.Ri()}function ouc(a,b){if(pF(b,50))return ug(a.a,b);return false}function uCc(a,b){if(pF(b,50))return ug(a.a,b);return false}function IEc(a,b){if(pF(b,50))return ug(a.a,b);return false}function rrc(a){if(a.oj())return null;var b=a.o;return GZ[b]}function LZ(a){function b(){}b.prototype=a||{};return new b}function Vt(a){if(pF(a,21))return a.Ud();return!a.Vd().Id()}function Vp(a,b,c,d){Sd(b);Sd(c);Sd(d);return Up(a,b).Je(c,
d)}function wt(){wt=JZ;bn();vt=(Wy(),Vy);ut=new oz(new DHc(vt))}function fy(a){return new Dy((wx(a.a.a),new gDc),new _x(a.b))}function hy(a){return new Hy((wx(a.a.a),new gDc),new by(a.b))}function jy(a){return new Hy((wx(a.a.a),new gDc),new dy(a.b))}function vF(a){return Math.max(Math.min(a,_Kc),-2147483648)|0}function nm(a,b){var c;return c=Po(a.a,b),!c?(Bn(),Bn(),An):c}function $i(a,b){var c;return c=pF(b,182)?Yi(b):b,Yi(a).Xd(c)}function VZ(a,b,c){if(!a.d)return b;return c.a+b+(b$(),$Z).a}function n1(a){if(Esc(a.a,
a.b))return a.a;return a.b+":"+a.a}function vz(a,b){Td(a,"set1");Td(b,"set2");return new Dz(a,b)}function v7(a,b){Xd(b.n==(Afc(),Xec)||b.n==Jdc);s7(a,b);i7(a)}function $pb(a){Kd(a.n==(Afc(),Vcc));return!!a.c&&a.c.n==adc}function $ob(a,b){var c,d;for(c=b.c;c;){d=c.f;Zob(a,c,b);c=d}}function mfb(a,b,c){var d;d=h3b(b,c);a.d&&r9b(d,c.d);return d}function vob(a,b,c){nob.call(this);this.a=a;this.c=b;this.b=c}function Sz(a,b){oo();Lr.call(this,Kyc(Sd(a),Sd(b)));this.a=b}function lzb(){jsb.call(this,"Es6SplitVariableDeclarations")}
function Bzb(){U7.call(this,"es6RelativizeImportPaths",true)}function Mvb(a,b){this.a=a;this.b=b;this.c=mp(Wt(b.Bf(),Jvb))}function B7b(a,b,c){this.a=a;this.d=b;this.e=c;this.c=new mDc}function ayb(){new fDc;this.a=new fDc;this.b=new cyb(new dyb)}function anc(a,b){var c;c=(Cyc(),new jzc(new xDc));bnc(a,b,c)}function Pkc(a,b,c){return uic(xic(Dic(Bic(new Lic(a),c),b)))}function zOb(a){return mp(Se(Ve(Ye(new nc(44)),(Hc(),Fc)),a))}function Ytc(a,b){return b==null?Hg(EDc(a.d,null)):YDc(a.e,b)}function Bsc(a,
b){return Asc(a.toLowerCase(),b.toLowerCase())}function U4b(a){return(a.a&2)!=0||(a.a&512)!=0||(a.a&bPc)!=0}function RWb(a){while(gXb(xWb(a,a.f)?zsc(a.b,a.f):0))yWb(a)}function EEc(a){var b;b=a.c.b.b;a.b=b;a.a=a.c.b;b.a=a.c.b.b=a}function nq(a){a.i=0;Jxc(a.b);Jxc(a.c);a.a=null;a.e=null;++a.g}function Hn(a){Bn();Sd(a);return pF(a,21)?In(a):Gn(Nw(a.Vd()))}function b5b(a,b){if(!a.d.t)return false;return oEc(a.d.t,b)}function F4b(a){if(!a.d||!a.d.o)return 0;return duc(a.d.o.c)}function l9(a){if(a.hc.Dd())return a.hc.Cd();
return wab(a.Sb)}function KB(b){if(!(fMc in b))try{throw b;}catch(a){}return b}function e_(a){var b;b=(n8b(),new Wbc((Afc(),bfc),a));return b}function rGc(a,b){var c,d;c=b;d=new YGc;tGc(a,c,d);return d.d}function lfb(a,b){var c;c=b.Sh(false);a.d&&r9b(c,b.d);return c}function Elb(a,b,c,d,e,f){return new Ulb(b,Sd(c),Sd(d),a,e,f)}function Arb(a,b,c){if(a.a)throw gZ(new Irc(AQc+b));w7(a.b,c)}function Nrb(a,b,c){if(a.a)throw gZ(new Irc(AQc+b));w7(a.b,c)}function Yd(a,b){if(!a)throw gZ(new Irc(b==null?
jLc:NZ(b)));}function Ld(a,b){if(!a)throw gZ(new qnb(b==null?jLc:NZ(b)));}function IB(a,b){AB(this);this.f=b;this.g=a;BB(this);this.Zf()}function wCb(a,b,c,d){y$();this.b=a;this.c=b;this.d=c;this.a=d}function uXb(a,b,c,d,e){dTb.call(this,a,b,e);this.a=c;this.b=d}function Cr(){Br.call(this,(wx(12),new gDc));Kd(true);this.a=2}function _yb(){jsb.call(this,"Es6RenameVariablesInParamLists")}function dab(){dab=JZ;cab=new eab(GMc,0);bab=new eab("AUTO",1)}function uwb(a){this.e=new tEc;this.c=new kCc(MK);
this.d=Sd(a)}function uyc(a){if(a<0)throw gZ(new Fqc("bitIndex < 0: "+a));}function xwc(a,b){if(nwc(a,b)){Qwc(a);return true}return false}function yWb(a){if(!xWb(a,a.f))return 0;return zsc(a.b,a.f++)}function prc(a,b){var c=a.a=a.a||[];return c[b]||(c[b]=a.kj(b))}function pBc(a,b,c,d){var e;e=a.lf(c,d);return e!=0?e:b.lf(c,d)}function flc(a,b,c){Ld(c.indexOf("<")==-1,CTc);Vp(a.B,a.t,c,b)}function o8b(a,b,c){Ld(!b.f,nTc);Ld(!b.i,oTc);b.i=b;s8b(a,b,c)}function es(a,b,c){Ywc(a.b,(oo(),el(b,c),new Wq(b,
c)));return a}function REc(a){HKc(a.b!=a.c.a.b);a.a=a.b;a.b=a.b.a;return a.a}function Aw(a){Rv(a.e);a.c=a.a=a.e;a.e=a.e.e;--a.d;return a.a.f}function zw(a){Rv(a.c);a.e=a.a=a.c;a.c=a.c.c;++a.d;return a.a.f}function Ww(a,b){var c,d;d=Yw(a,b);c=a.a.ee(d);return new ix(c)}function l$(a,b){Xd(b.d==a);Xd(u$(pEc(a.e,b.b),b));sEc(a.e,b.b)}function clb(a,b){var c;epb(a.a,b,a);y7(a.a,(bn(),c=a.b,mp(c)))}function unb(a,b){if(!a.b){vnb(a,b);p9b(a.b,a.a)}return Sd(a.b)}function O3(a){if(a.s){a.Lg(";");a._g()}a.Ng();
a.Ug();a.s=false}function Q8b(a){return a.n==(Afc(),Jdc)&&E8b(a,(Hbc(),Fac))!=0}function R8b(a){return a.n==(Afc(),Jdc)&&E8b(a,(Hbc(),Gac))!=0}function Gqb(a){ppb();return a.n==(Afc(),rec)&&a.Wh().length!=0}function ve(){se();return CE(xE(VF,1),sLc,142,0,[pe,oe,qe,re])}function E9(){C9();return CE(xE(DL,1),sLc,188,0,[z9,A9,B9,y9])}function Q9(){O9();return CE(xE(FL,1),sLc,187,0,[L9,M9,N9,K9])}function zNb(a,b,c){return!c?null:ANb(a,b,c,T9b(c.k),S9b(c.k))}function Iyb(a,b,c){Ywc(a,nyb);m9(b,(iQb(),
$Pb))&&c&&Ywc(a,kyb)}function ueb(a){reb();this.a=a;this.b=!kQb((iQb(),YPb),l9(a.G))}function Ckb(a,b,c){this.c=(b9(),a9);this.a=a;this.e=b;this.d=c}function xC(a,b,c,d){rC.call(this,a);this.c=b;this.d=c;this.b=d}function Mjc(a,b,c,d,e){Ljc.call(this,a,b,null,c,d,null,e,true)}function _tc(a,b,c){return b==null?FDc(a.d,null,c):ZDc(a.e,b,c)}function rtc(a,b,c){a.a=Vsc(a.a,0,b)+(""+c)+Usc(a.a,b);return a}function D9b(a,b,c,d){var e;e=new stc;C9b(a,e,b,c,d);return e.a}function YIc(a){var b;b=new XIc;
b.a=new $wnd.RegExp(a);return b}function DDc(a,b){var c;c=a.a.get(b);return c==null?new Array:c}function J5b(a,b){var c;c=(Ld(b>=0,lTc),1<<b);return(c&a.p)!=0}function Lf(a,b,c){var d;Sd(c);d=c;return!d.Ud()&&Uf(a,b).Qd(d)}function At(a,b){wt();Sd(a);return Sd(a),Bt(a,new Wzc(b.b.Vd()))}function Mc(a,b,c,d){return Nc(a,(Sd(d),new Guc(new xd(d,b,c))))}function mt(a){ht();return new yGc((pF(a,242)?a:new Vl(a)).mf())}function I3b(a){if(!J3b(a))return a.n==(Afc(),Uec);return true}function B4b(a){if(!a.d||
!a.d.f)return 0;return a.d.f.a.length}function zf(a){if(a.c>=a.d)throw gZ(new jFc);return a.ce(a.c++)}function A5(a,b){if(b||kQb(l9(a),(iQb(),gQb)))return 1;return 0}function ru(a){var b;while(true){b=a.Jd();if(!a.Id())return b}}function D_(a){var b;b0((Afc(),Cdc),a);for(b=a.c;b;b=b.f)C_(b)}function M_(a){var b;b0((Afc(),Xdc),a);for(b=a.c;b;b=b.f)L_(b)}function Z5(a,b){Pd(V8b(a),aOc,a);Pd(V8b(b),aOc,b);I8b(a);I8b(b)}function o9(a,b){Xd(b!=(uab(),qab));Xd(b!=tab);a.Sb=b==rab?sab:b}function Fab(){Dab();
return CE(xE(LL,1),sLc,226,0,[Aab,Cab,Bab])}function Lab(){Jab();return CE(xE(ML,1),sLc,223,0,[Gab,Iab,Hab])}function Rab(){Pab();return CE(xE(NL,1),sLc,222,0,[Mab,Nab,Oab])}function dbb(){bbb();return CE(xE(PL,1),sLc,227,0,[_ab,$ab,abb])}function rgb(){pgb();return CE(xE(OM,1),sLc,255,0,[ogb,mgb,ngb])}function Ycb(){Wcb();return CE(xE(fM,1),sLc,158,0,[Ucb,Tcb,Vcb])}function pqb(a){ppb();return a.n==(Afc(),Vcc)&&!!a.g&&a.g.n==Jdc}function Svb(a){hmb();this.b=a;kmb.call(this,a.a);this.a=new YEc}function Mob(a){var b;
b=Bwc(a.o)+a.n.a.length;Xd(b>0);return b-1}function dtb(a){var b;b=a.b.e>a.a;a.a=a.b.b.b;++a.b.b.b;return b}function fpb(a,b,c,d){var e;e=new dpb(a,b,new Ajb(a));cpb(e,c,d)}function jKb(a,b){return w8b((n8b(),new Wbc((Afc(),bfc),b)),a.s)}function ANb(a,b,c,d,e){return!c?null:w8b(new M9b(b,c,d,e),a.n)}function LNb(){JNb();return CE(xE(xR,1),sLc,252,0,[HNb,INb,GNb])}function oJb(){mJb();return CE(xE(oR,1),sLc,234,0,[lJb,jJb,kJb])}function gDb(){eDb();return CE(xE(rQ,1),sLc,230,0,[dDb,cDb,bDb])}function vWb(a){return wWb(a,
a.d.a.length==0?a.f:DWb(a,0).d.b.c)}function OWb(a){while(pXb(xWb(a,a.f)?zsc(a.b,a.f):0)>=0)yWb(a)}function VWb(a){while(qXb(xWb(a,a.f)?zsc(a.b,a.f):0)>=0)yWb(a)}function h9b(a,b){var c;c=i9b(a,a.j,b.f<<24>>24);c!=a.j&&(a.j=c)}function E8b(a,b){var c;c=Y8b(a,b);if(!c)return 0;return c.bi()}function Tbc(a,b){var c;c=new Vbc(a.n);c.a=a.a;return y8b(a,c,b)}function Ufc(a,b){var c;c=tu(b.ki().c.Vd());return Rnc(a.ki(),c)}function aFb(a,b,c){bFb.call(this,a,b,c,(EFb(),DFb),(wFb(),vFb))}function Vic(a){Ofc();
Xic.call(this,a,null,null,false,null,true)}function EAb(){jsb.call(this,"es6NormalizeShorthandProperties")}function pzb(){jsb.call(this,"es6ConvertSuperConstructorCalls")}function Uzb(){jsb.call(this,"Es6RewriteBlockScopedDeclaration")}function Kqc(a){Iqc.call(this,a==null?jLc:NZ(a),pF(a,36)?a:null)}function ZIc(a){return a.replace(/[.?*+^$[\]\\(){}|-]/g,"\\$&")}function Dwc(a){jwc(this);rKc(this.a,Qrc($wnd.Math.max(8,a))<<1)}function fkc(){dkc();return CE(xE(RU,1),sLc,246,0,[ckc,akc,bkc])}function Jkc(){Hkc();
return CE(xE(ZU,1),sLc,243,0,[Ekc,Fkc,Gkc])}function ucc(){scc();return CE(xE(JU,1),sLc,228,0,[qcc,rcc,pcc])}function Aoc(){yoc();return CE(xE(AV,1),sLc,164,0,[voc,woc,xoc])}function d$(){b$();return CE(xE(KK,1),sLc,174,0,[ZZ,a$,$Z,YZ,_Z])}function WZ(a,b){if(!a.d)return b;return(b$(),YZ).a+(""+b)+_Z.a}function Vg(a,b){var c;c=b.Ve();return new Wq(c,a.b.Ce(c,b.We()))}function dkb(a,b){var c;c=qkb(b);if(c)return mkb(a,c,b);return 0}function xZ(a){var b;if(pZ(a)){b=a;return b==-0?0:b}return aF(a)}function z8(a){var b;
if(!a.n){b=a.b.C;a.n=$Eb(b,a.i.a)}return a.n}function Vpb(a){var b,c;b=a;for(c=Hpb(b);c;c=Hpb(b))b=c;return b}function vnc(a,b,c,d){a.b=false;_tc(a.c,b,new ync(c,d));return a}function mTb(a,b){if(DWb(a.g,0).e==b)return iTb(a,b);return null}function SVb(a,b,c,d){!b?DOb(a.c,vWb(a.g),c,d):DOb(a.c,b.d.b,c,d)}function TVb(a,b,c,d){!b?DOb(a.c,vWb(a.g),c,d):DOb(a.c,b.o.b,c,d)}function aCb(a,b,c){ptc(ptc(ptc(ptc((a.a+="@",a),b)," {"),c),"}")}function Ruc(a,b,c){JKc(b,c,a.Yd());this.c=a;this.a=b;this.b=c-
b}function Lic(a){this.a=(bn(),mz(),lz);this.b=(dkc(),ckc);this.f=a}function wic(a){a.b=(dkc(),bkc);a.d=new J9b((Afc(),Jec));return a}function hmc(a){var b;Xd(a.Xi()!=null);b=Sd(a.Xi());return TKc(b)}function Pnc(a,b){var c;c=Znc(a,aoc(a.d,b));return Xkc(a.a,a.c,c)}function gnc(a,b,c){var d;d=a.b.Ie(b);!!d&&Wmc(c,d.a);a.b.Je(b,c)}function kwc(a,b){IKc(b);a.b=a.b-1&a.a.length-1;a.a[a.b]=b;pwc(a)}function lwc(a,b){IKc(b);a.a[a.c]=b;a.c=a.c+1&a.a.length-1;pwc(a)}function NHc(a,b){if(b==null)throw gZ(new msc);
return Utc(a.a,b)}function OHc(a,b){if(b==null)throw gZ(new msc);return Xtc(a.a,b)}function VIc(a,b){this.b=a;new $wnd.RegExp(a.source,"g");this.a=b}function G7b(){G7b=JZ;F7b=new $wnd.RegExp("^[a-zA-Z_$][\\w$]*$")}function H9(){H9=JZ;F9=new I9("BROWSER",0);G9=new I9("CUSTOM",1)}function a6(){a6=JZ;$5=new b6("INHERITS",0);_5=new b6("MIXIN",1)}function hz(a){Bn();this.a=(Cyc(),pF(a,69)?new gBc(a):new _zc(a))}function lqb(a){ppb();return a.n==(Afc(),Idc)||a.n==Gdc||a.n==Hdc}function V3(a){if(a.s){a.Lg(";");
a._g();a.Ug();a.s=false}a.t=true}function Rd(a,b){if(a<0||a>=b)throw gZ(new Fqc(Hd(a,b)));return a}function Wd(a,b,c){if(a<0||b<a||b>c)throw gZ(new Fqc(Jd(a,b,c)));}function il(a,b,c){!!c&&Kd(true);return new Gl(fJc(a).Ej(),b,1301)}function YJb(a,b){if(!xKb(b))return null;return XJb(a,UJb(a,b.o))}function PMb(a,b,c){a.o=!a.o?mOb(a.j):GMb(a);return a.o==b||a.o==c}function UZb(a,b,c){IZb.call(this,(n1b(),I_b),a);this.b=b;this.a=c}function XZb(a,b,c){IZb.call(this,(n1b(),L_b),a);this.b=b;this.a=c}function WZb(a,
b,c){IZb.call(this,(n1b(),K_b),a);this.a=b;this.b=c}function k$b(a,b,c){IZb.call(this,(n1b(),R_b),a);this.a=b;this.b=c}function u$b(a,b,c){IZb.call(this,(n1b(),__b),a);this.a=b;this.b=c}function t$b(a,b,c){IZb.call(this,(n1b(),$_b),a);this.b=b;this.a=c}function x$b(a,b,c){IZb.call(this,(n1b(),c0b),a);this.b=b;this.a=c}function z$b(a,b,c){IZb.call(this,(n1b(),e0b),a);this.b=b;this.a=c}function f_b(a,b,c){IZb.call(this,(n1b(),t0b),a);this.b=b;this.a=c}function g_b(a,b,c){IZb.call(this,(n1b(),u0b),a);
this.b=b;this.a=c}function i_b(a,b,c){IZb.call(this,(n1b(),w0b),a);this.a=b;this.b=c}function _$b(a,b,c){IZb.call(this,(n1b(),n0b),a);this.a=b;this.b=c}function k_b(a,b,c){IZb.call(this,(n1b(),y0b),a);this.b=b;this.a=c}function l_b(a,b,c){IZb.call(this,(n1b(),z0b),a);this.b=b;this.a=c}function o_b(a,b,c){IZb.call(this,(n1b(),D0b),a);this.b=b;this.a=c}function q_b(a,b,c){IZb.call(this,(n1b(),F0b),a);this.b=b;this.a=c}function w_b(a,b,c){IZb.call(this,(n1b(),L0b),a);this.b=b;this.a=c}function q1b(a,
b,c){IZb.call(this,(n1b(),N0b),a);this.b=b;this.a=c}function y1b(a,b,c){IZb.call(this,(n1b(),V0b),a);this.b=b;this.a=c}function z1b(a,b,c){IZb.call(this,(n1b(),W0b),a);this.b=b;this.a=c}function r1b(a,b,c){IZb.call(this,(n1b(),O0b),a);this.a=b;this.b=c}function F1b(a,b,c){IZb.call(this,(n1b(),b1b),a);this.a=b;this.b=c}function I1b(a,b,c){IZb.call(this,(n1b(),a1b),a);this.a=b;this.b=c}function M1b(a,b,c){IZb.call(this,(n1b(),i1b),a);this.a=b;this.b=c}function J1b(a,b,c){IZb.call(this,(n1b(),e1b),a);
this.b=b;this.a=c}function P1b(a,b,c){IZb.call(this,(n1b(),k1b),a);this.b=b;this.a=c}function Q1b(a,b,c){IZb.call(this,(n1b(),l1b),a);this.b=b;this.a=c}function R1b(a,b,c){IZb.call(this,(n1b(),m1b),a);this.b=b;this.a=c}function F4(a,b){var c;c=H8b(b,(n8b(),Y7b));!!c&&a.fh(c,(_4(),W4))}function kbb(a,b){var c,d;for(d=b.Vd();d.Id();){c=d.Jd();jbb(a,c)}}function Xf(a,b){var c,d;c=Cx(a.c,b);if(c){d=c.Yd();c.Rd();a.d-=d}}function YSb(a,b){var c;c=Cxc(a.a,b);if(c>=0)return c;return-c-2}function z4b(a,b){if(!a.b||
!a.b.e)return null;return pEc(a.b.e,b)}function L4b(a,b){if(!a.b||!a.b.j)return null;return pEc(a.b.j,b)}function H4b(a,b){if(!a.d||!a.d.o)return null;return pEc(a.d.o,b)}function lnc(a,b,c,d,e){if(a.a)return false;return Sic(a,b,c,d,e)}function ykc(a,b,c){!a.a&&(a.a=new ukc(a.c));return Qfc(b,c,0,a.a)}function ujc(a){ae(a.oi()||a.f==(dkc(),bkc),lRc,a);return cgc(a.k)}function ntc(a,b,c,d){a.a+=""+Vsc(b==null?jLc:NZ(b),c,d);return a}function Gsb(a){var b;b=new Esb;q4(new L4(b),a,(_4(),W4));return b}
function vGc(a,b){var c;c=1-b;a.a[c]=wGc(a.a[c],c);return wGc(a,b)}function Uxc(a,b){var c;for(c=0;c<a.length;c++)a[c]=$wc(b.a,c).a}function Rnc(a,b){var c;c=Snc(a,b);return c==-1?_kc(a.a,51):a.b[c]}function Uf(a,b){var c;c=a.c.Ie(b);!c&&(c=a.ze(b));return a.Ce(b,c)}function oj(a){var b;b=new yuc((new puc(a.a)).a);return new Aj(a,b)}function pj(a){var b;b=new yuc((new puc(a.a)).a);return new Fj(a,b)}function Kq(a){if(a.e.g!=a.b)throw gZ(new WBc);return!!a.c&&a.d>0}function e5b(a,b){if(b.d){!a.d&&
(a.d=new L5b);a.d.p|=!b.d?0:b.d.p}}function fGc(a){return!a.a?a.c:a.e.length==0?a.a.a:a.a.a+(""+a.e)}function Rkc(a,b){return Zkc(a,CE(xE(cV,1),xPc,23,0,[b,a.u[32]]))}function $kc(a,b){return oEc(a.f,b)?pEc(a.f,b).Le():(Bn(),Bn(),An)}function u4(a,b){Yd(b.n==(Afc(),Vcc),b);a.c.Pg();s4(a,b.c);a.c.Rg()}function K$(a){var b;b=(Xd(H3b(a)),new L9b((Afc(),Pcc),a));return b}function f_(a){var b;b=(Xd(H3b(a)),new L9b((Afc(),zfc),a));return b}function fsb(a,b,c){var d;d=c.g;Xd(!!d);Xd(M8b(d,b));fpb(a.b,a,
b,c)}function XD(a,b,c){var d;d=VD();try{return UD(a,b,c)}finally{YD(d)}}function Psc(a,b,c){c=dtc(c);return a.replace(new RegExp(b,"g"),c)}function Tjb(a,b,c){Rjb();u7(a,Lmb(b,Pjb,CE(xE(nW,1),uNc,2,6,[c])))}function Ujb(a,b,c){Rjb();u7(a,Lmb(b,Qjb,CE(xE(nW,1),uNc,2,6,[c])))}function wsb(a,b,c){kwc(a.f,new Dsb(b,c));Esc(b,iOc)||(a.d.a=false)}function Swb(a,b){a.a=Esc(b.substr(0,1),cRc)?b.substr(1):b;a.d=null}function oQb(a,b){if(a.a.Sd(b))return a;return new uQb(vQb(a.a,b))}function ZSb(a,b){var c;
c=YSb(a,b);return new X1b(a.b,b,c,b-a.a[c])}function i3b(a,b,c){Yd(H3b(b),b);Yd(H3b(c),c);return new N9b(a,b,c)}function z2b(a){if(a.b>=a.c)throw gZ(G2b(a));return zsc(a.a,a.b++)}function S4b(a,b){if(!a.d||!a.d.o)return false;return oEc(a.d.o,b)}function a5b(a,b){if(!a.d.r)return false;return _wc(a.d.r,b,0)!=-1}function C8(a){if(!a.a||!a.a.sh())return;Twb(a.a.sh(),(scc(),pcc))}function F3b(a){Xd(a.length!=0);return n8b(),new Wbc((Afc(),fec),a)}function YMb(a,b){return b==(fOb(),$Nb)?QMb(a,(Afc(),
Pec)):WMb(a,b)}function Ykc(a,b,c){return new koc(a,b,(Bn(),Sd(c),In(new eyc(c))))}function Jyc(a){Cyc();var b;b=new nDc;b.a.Je(a,b);return new JAc(b)}function H8b(a,b){var c;c=Y8b(a,b);if(!c)return null;return c.ci()}function Unc(a,b){var c;c=Snc(a,b);return c==-1?a.a.u[51]:a.d.ce(c)}function hJc(a,b){if(a.a<=a.b){b.kf(a.a++);return true}return false}function aAb(a){this.a=a;jsb.call(this,"Es6RewriteDestructuring")}function Fvb(a){Avb();Gvb.call(this,a,Nvb(Z2b("js/polyfills.txt")))}function Vnb(){TZ();
XZ.call(this,null);Snb(this);this.a=(Lwb(),Jwb)}function YJc(a,b){QFc.call(this,b.ff(),b.ef()&-6);this.a=a;this.b=b}function vl(a,b,c,d){this.e=d;this.d=null;this.c=a;this.a=b;this.b=c}function KDc(a){this.e=a;this.b=this.e.a.entries();this.a=new Array}function JGc(a){KGc.call(this,a,(oHc(),kHc),null,false,null,false)}function PGc(a){QGc.call(this,a,(oHc(),kHc),null,false,null,false)}function TWb(a){while(Uqc(xWb(a,a.f)?zsc(a.b,a.f):0,16)>=0)yWb(a)}function u_(a,b){var c;b0((Afc(),Vec),b);for(c=b.c;c;c=
c.f)o0(a,c)}function Q_(a,b){var c;b0((Afc(),dec),b);for(c=b.c;c;c=c.f)P_(a,c)}function e0(a,b){var c;b0((Afc(),Eec),b);for(c=b.c;c;c=c.f)f0(a,c)}function __(a,b){switch(b.n.f){case 29:W_(b);break;case 26:I_(a,b)}}function Qhb(a,b,c){if(b){$hb(a,null,b);nib(a.j,b,Ghb(a,b,false,c))}}function Yf(a,b,c,d){return pF(c,69)?new zi(a,b,c,d):new ri(a,b,c,d)}function Ag(a,b){return uF(b)===uF(a)?"(this Map)":b==null?jLc:NZ(b)}function r9(a){return a.cb.Ed(a.Tb).Fd((Nqc(),vab(a.Sb)?true:false))}function UC(a){htc(a.b,
34);bD(new dD(a.j),a);htc(a.b,59);htc(a.b,34)}function E5(a){if(a.o<=0&&a.u!=a.v+1)return;itc(a.j,10);++a.n;a.o=0}function Q3b(a){Xd(a.n==(Afc(),rec)||a.n==Sec);return new L9b(Jec,a)}function Ydb(a){var b;b=E7b(H8b(a,(Hbc(),mbc)));x6b(b);q9b(a,k6b(b))}function Ubb(){Sbb();return CE(xE(YL,1),sLc,193,0,[Obb,Rbb,Qbb,Pbb])}function PFb(){NFb();return CE(xE(XQ,1),sLc,191,0,[JFb,KFb,LFb,MFb])}function rWb(){pWb();return CE(xE(PR,1),sLc,202,0,[oWb,nWb,lWb,mWb])}function $$b(){Y$b();return CE(xE(QS,1),sLc,
206,0,[V$b,W$b,X$b,U$b])}function sHc(){oHc();return CE(xE(lY,1),sLc,148,0,[kHc,lHc,mHc,nHc])}function d9(){b9();return CE(xE(BL,1),sLc,160,0,[a9,Z8,Y8,X8,_8,$8])}function In(a){Bn();var b;if(pF(a,66)){b=a;return b.sf()}return Gn(a)}function tlc(a,b){var c,d;c=b.e;d=c.Ni(a);if(d!=c)return d;return b}function Ffb(a,b){var c;c=K3b(b.a);a.f.d&&r9b(c,pfb(a.f,38));return c}function Z$(a){var b,c,d;b=a_(Se(Ze(),MMc));d=(c=Tqb(b,a),c);return d}function A2b(a){while(I2b(a.b<a.c?zsc(a.a,a.b):-1))z2b(a);return-1}
function Gpb(a,b){ppb();var c;c=a;while(!!c&&!b.Ld(c))c=c.g;return c}function G9b(a,b){var c;F9b(a,b);for(c=a.c;c;c=c.f)G9b(c,b);return a}function I9b(a,b){var c;H9b(a,b);for(c=a.c;c;c=c.f)I9b(c,b);return a}function Vd(a,b){if(a<0||a>b)throw gZ(new Fqc(Id(a,b,qLc)));return a}function g1(a,b){if(!b)throw gZ(new nsc("Null kind"));a.b=b;return a}function d5b(a){if(!a.c)return false;!a.b&&(a.b=new F5b);return true}function J4b(a){if(!a.d||!a.d.r)return Bn(),Bn(),An;return In(a.d.r)}function O4b(a){if(!a.d||
!a.d.t)return oo(),oo(),no;return wo(a.d.t)}function xu(a){var b;Sd(a);if(pF(a,105)){b=a;return b}return new yu(a)}function OCc(a){var b;b=lKc(a.b,a.b.length);return new TCc(a.a,b,a.c)}function Nv(a,b){var c;c=Lyc(Nw(new Bw(a,b)));ou(new Bw(a,b));return c}function uz(a,b){var c;c=false;while(b.Id())c=c|a.Wd(b.Jd());return c}function A6(a,b,c){var d;d=yOb(b,a.G.nc,(FJb(),EJb),a.G.mc,c);return d}function zhc(a,b,c,d){var e;e=a.cj(b,c,false,d);jlc(a.A,b,a);return e}function Lbb(a,b){var c;c=b.b-a.b;
if(c!=0)return c;c=a.c-b.c;return c}function H4(a,b){if(b.n==(Afc(),_cc))return H4(a,b.c);return arb(b.n)}function Jpb(a){ppb();Yd(a.n==(Afc(),Xec),a);return H8b(a,(n8b(),V7b))}function Ht(a){wt();return Nk(),Sd(a),new $Ic(new cl(a),new Qk,new Sk)}function oMb(a,b,c){return!c||c.Ud()?dKb(a.a,(Afc(),tdc)):nMb(a,b,c)}function nGb(a,b,c,d,e){XFb();bGb.call(this,a,b,null,d,e);this.a=wo(c)}function oPb(a,b,c,d,e){this.f=a;this.b=b;this.a=c;this.d=d;this.c=e}function JDb(a,b){if(!b)throw gZ(new nsc("Null type"));
a.c=b;return a}function LTb(a){if(zVb(a,0,(AZb(),aZb)))return jVb(a);return KTb(a,1)}function A4b(a){if(!a.d||!a.d.f)return Bn(),Bn(),An;return Lyc(a.d.f)}function C4b(a){if(!a.d||!a.d.g)return Bn(),Bn(),An;return Lyc(a.d.g)}function K4b(a){if(!a.d||!a.d.s)return Bn(),Bn(),An;return Lyc(a.d.s)}function W1b(a){if(!a.d)return"";return Ut(Se(Ye(new nc(47)),a.d.c))}function PEb(a,b){var c;c=SEb(a,b);if(c)return c;throw gZ(new lGb(b));}function RSb(a,b){OSb();var c;c=Po(oSb,a);return!!c&&(b||!c.a)?c:null}
function P8b(a){var b,c;b=0;for(c=a.c;!!c&&b<=3;c=c.f)++b;return b==3}function qjc(a){var b;b=new mDc;a.oi()?Rc(b,tjc(a)):Rc(b,a.c);return b}function bIc(){bIc=JZ;ZHc=new fIc;$Hc=new iIc;_Hc=new lIc;aIc=new oIc}function CIc(){CIc=JZ;zIc=true;xIc=false;yIc=false;BIc=false;AIc=false}function RIc(a){CIc();if(zIc)return new QIc(null);return tIc(vIc(),a)}function mwc(a){if(a.b==a.c)return;a.a=zE(iW,mLc,1,8,5,1);a.b=0;a.c=0}function mC(a,b){b.a.length==0?Ywc(a.i.c,null):Ywc(a.i.c,b);++a.b;a.c=0}function O$(a,
b){var c;c=x3b(a,(n8b(),new Wbc((Afc(),bfc),b)));return c}function tf(a){Sd(a);if(pF(a,25))throw gZ(a);if(pF(a,80))throw gZ(a);}function YD(a){a&&dE((bE(),aE));--QD;if(a)if(SD!=-1){$D(SD);SD=-1}}function n7(a){if(a.G.ad){H7(a);m9(a.G,wab(a.G.Sb))&&G7(a)}else y6(a)}function xpb(a){ppb();var b,c;c=1;for(b=a.c;b;b=b.f)c+=xpb(b);return c}function _bb(a,b){Wbb();var c;this.a=a;this.b=(bn(),c=new eyc(b),mp(c))}function Bkc(a,b,c){this.d=a;this.b=b;this.c=c;this.a=31*Xfc(b)+Xfc(c)}function PSb(a,b,c,d){he.call(this,
a,b);this.c=c;this.b=d;this.a=VSb(d)}function Lq(a){this.e=a;this.c=this.e.a;this.b=this.e.g;this.d=this.e.i}function rqb(a){switch(a.n.f){case 86:case 87:return true}return false}function n4b(a,b){if(J4b(a).Ud()){x5b(a,b,hMc);return true}return false}function w3b(a,b){Xd(H3b(a));Xd(H3b(b));return new N9b((Afc(),Odc),a,b)}function ekb(a,b,c,d){if(!b||b==c)return;ekb(a,b.f,c,d);fkb(a,b.c,c,d)}function hkc(a,b,c,d){Ofc();Wic.call(this,a,null,null,c,d);this.a=Sd(b)}function ecc(a,b){n8b();J9b.call(this,
(Afc(),jfc));this.a=a;ccc(this,b)}function Dsc(a,b){var c;c=b.length;return Esc(a.substr(a.length-c,c),b)}function xyc(a){var b;b=a.length-1;for(;b>=0&&(a[b]|0)==0;--b);return b}function _Tb(a){var b;iTb(a,(AZb(),HYb));b=KTb(a,1);iTb(a,MXb);return b}function DJc(a,b){var c;return b.b.Od(GJc(a,b.c.Cd(),(c=new iKc(b),c)))}function Hhb(a,b,c){return aib(a,c,PPc,CE(xE(HU,1),IMc,7,0,[mib(b,c)]))}function c5(){_4();return CE(xE(eL,1),sLc,136,0,[$4,U4,Z4,V4,X4,Y4,W4])}function nwb(a){a=ZIc(a);return YIc(Psc(a,
"\\{\\d+\\}","\\\\E.*\\\\Q"))}function lub(){lub=JZ;kub=new mub(GMc,0);jub=new mub("ALL_UNQUOTED",1)}function KJb(){KJb=JZ;JJb=new LJb("STRICT",0);IJb=new LJb("SLOPPY",1)}function E2(){E2=JZ;B2=new F2(zMc,0);D2=new F2(AMc,1);C2=new F2(GMc,2)}function cEc(a){this.d=a;this.b=this.d.a.entries();this.a=this.b.next()}function Kz(a,b){this.c=a;this.d=b;this.a=this.c.Vd();this.b=this.d.Vd()}function Bw(a,b){var c;this.f=a;this.b=b;c=Xtc(a.b,b);this.c=!c?null:c.b}function TJc(a,b){QFc.call(this,b.ff(),b.ef()&
-16449);this.a=a;this.c=b}function tEc(){fDc.call(this);mEc(this);this.b.b=this.b;this.b.a=this.b}function uEc(){fuc.call(this);mEc(this);this.b.b=this.b;this.b.a=this.b}function WD(b){TD();return function(){return XD(b,this,arguments);var a}}function PD(){if(Date.now)return Date.now();return(new Date).getTime()}function Su(a){if(Ru(a)){a.c=a.a;return a.a.Jd()}else throw gZ(new jFc);}function Oy(a,b){if(Zi(b).Ud())return false;qj(b,new Sy(a));return true}function Ldb(a,b){var c;a.a=false;c=new Odb(a);
epb(a.b.a,b,c);return a.a}function gs(a,b){var c,d;for(d=b.Vd();d.Id();){c=d.Jd();a.Mf(c)}return a}function qtb(a,b){var c;ptb(a,b);for(c=b.c;c;c=c.f){Xd(c.g==b);qtb(a,c)}}function t_(a,b,c){var d;b0((Afc(),cdc),b);for(d=b.c;d;d=d.f)s_(a,d,c)}function FWb(a,b,c){EWb(a,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c),b,c)}function zDb(a){wDb();return GDb(JDb(IDb(HDb(new KDb,a),a),(MEb(),IEb)))}function BDb(a){wDb();return GDb(JDb(IDb(HDb(new KDb,a),a),(MEb(),KEb)))}function OEb(){MEb();return CE(xE(KQ,1),
sLc,172,0,[KEb,JEb,LEb,HEb,IEb])}function g$b(){e$b();return CE(xE(nS,1),sLc,179,0,[_Zb,c$b,b$b,d$b,a$b])}function g6b(){e6b();return CE(xE(rU,1),sLc,177,0,[b6b,a6b,c6b,d6b,_5b])}function Zab(){Xab();return CE(xE(OL,1),sLc,169,0,[Sab,Vab,Tab,Wab,Uab])}function Cqb(a){ppb();return!!a&&(a.n==(Afc(),ufc)||a.n==jec||a.n==gdc)}function Gf(a){a.f=3;a.e=Jz(a);if(a.f!=2){a.f=0;return true}return false}function h6b(a,b){if(o4b(a.a,b)){a.e=true;return true}else return false}function j6b(a,b){if(s4b(a.a,b)){a.e=
true;return true}else return false}function K6b(a,b){if(q4b(a.a,b)){a.e=true;return true}else return false}function B6b(a,b){if(i5b(a.a,b)){a.e=true;return true}else return false}function j7b(a,b){if(t4b(a.a,b)){a.e=true;return true}else return false}function o7b(a,b){if(k4b(a.a,b)){a.e=true;return true}else return false}function x7b(a,b){if(v4b(a.a,b)){a.e=true;return true}else return false}function sEc(a,b){var c;c=auc(a.c,b);if(c){FEc(c);return c.e}return null}function Qsc(a,b,c){var d;c=dtc(c);
d=new RegExp(b);return a.replace(d,c)}function Fxc(a,b){var c,d;c=(d=a.slice(0,b),DE(d,a));c.length=b;return c}function Iic(a,b){a.k=Xkc(a.f,(Bn(),Sd(b),In(new eyc(b))),null);return a}function D3b(a){var b;b=Z3b((Afc(),$dc),a);c9b(b,(n8b(),_7b),0);return b}function hB(a,b){var c;if(pF(b,247)){c=b;return Hxc(a.c,c.c)}return false}function pC(a,b){if(EC(a.a)&&GC(a.a)==b){FC(a.a);return true}return false}function t8(a,b){if(_wc(a.d,b,0)==-1){Ywc(a.d,b);return true}return false}function u8(a,b){if(_wc(a.o,
b,0)==-1){Ywc(a.o,b);return true}return false}function Sb(a){a.i=3;a.g=a.Gd();if(a.i!=2){a.i=0;return true}return false}function FE(a){var b,c,d;b=a&sMc;c=a>>22&sMc;d=a<0?tMc:0;return HE(b,c,d)}function Fhb(a,b){var c;c=F9b(new J9b((Afc(),Xcc)),b);Ywc(a.q,c);return c}function nfb(a,b,c){var d;d=i3b((Afc(),edc),b,c);a.d&&r9b(d,c.d);return d}function jjb(a){return a.n==(Afc(),_ec)&&_8b((Xd(!!a.c&&!a.c.f),a.c),BMc)}function Nhb(a,b){return F9b(Yjb(K3b(OPc+(a.r.b==0?"":"$"+a.r.b)),a.g),b)}function Uqb(a){ppb();
return F9b((Yd(H3b(a),a),new L9b((Afc(),Ddc),a)),a)}function wDb(){wDb=JZ;vDb=GDb(JDb(IDb(HDb(new KDb,kNc),kNc),(MEb(),KEb)))}function itb(){itb=JZ;htb=new jtb("LEGACY",0);gtb=new jtb("EXPORT_ALL",1)}function x3b(a,b){Xd(H3b(a));Xd(b.n==(Afc(),bfc));return new N9b(Pdc,a,b)}function B3b(a,b){Xd(H3b(a));Xd(b.n==(Afc(),Vcc));return new N9b(Tdc,a,b)}function agc(a,b){return b==0?Pfc(a,new stc,true).a:a.di(new stc,true).a}function Skc(a,b){return Zkc(a,CE(xE(cV,1),xPc,23,0,[b,a.u[52],a.u[32]]))}function iJc(a,
b){this.c=0;this.b=b;IFc.call(this,a,17493);this.a=this.c}function hGc(a,b,c){this.b=a;this.d=b;this.e=c;this.c=this.d+(""+this.e)}function dA(a){this.d=a;this.c=new TEc(new KEc(this.d.a));this.a=(Zu(),Yu)}function QIc(a){CIc();if(zIc)return;this.c=a;this.e=true;this.a=new fxc}function Nbc(a){var b;if(!a.a)throw gZ(new jFc);b=a.a;a.a=a.a.f;return b}function fJb(a,b){if(!b)throw gZ(new nsc("Null runMode"));a.f=b;return a}function f1(a,b){if(!b)throw gZ(new nsc("Null jsDocInfo"));a.a=b;return a}function Td(a,
b){if(a==null)throw gZ(new nsc(b==null?jLc:NZ(b)));return a}function C1(a,b){var c;nq(a.a);a.c=a.b.b;c=x8b(b,false);A1(a,b,c);return a}function lrc(a,b,c){var d;d=jrc(a);yrc(a,d);d.i=c?8:0;d.f=b;d.e=c;return d}function Dn(a){var b;b=(Sd(a),a?new hxc(a):Nw(a.Vd()));Hyc(b);return Vn(b)}function o_(a,b){var c;b0((Afc(),Ycc),b);U_(b);for(c=b.c;c;c=c.f)E_(a,c)}function a0(a,b){var c;b0((Afc(),xec),b);U_(b);for(c=b.c;c;c=c.f)E_(a,c)}function n_(a,b){var c;b0((Afc(),Vcc),b);for(c=b.c;c;c=c.f)q0(a,c,false)}
function $Bb(a,b,c){M4.call(this,a,b);Sd(c);this.b=c;this.a=new Emb(false)}function Smb(a){this.d=new fxc;this.a=new fxc;this.e=a;this.b=-1;this.c=-1}function nob(){mob(this);this.i=null;this.e=true;this.g=new Fr;this.f=this}function Qzb(){jsb.call(this,"Es6RewriteBlockScopedFunctionDeclaration")}function ugc(a,b){Ofc();var c;return!a?!b:(c=new ukc(false),Qfc(a,b,0,c))}function TSb(a,b){OSb();var c;return c=Po(oSb,a),!!(!!c&&(b||!c.a)?c:null)}function D5b(a,b){if(a)return b?new H7b(x8b(a.a,false),
a.b):a;return null}function yDb(a,b){wDb();return GDb(JDb(IDb(HDb(new KDb,b),a),(MEb(),HEb)))}function ADb(a,b){wDb();return GDb(JDb(IDb(HDb(new KDb,b),a),(MEb(),JEb)))}function GWb(a,b,c){EOb(a.e,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c),b,c)}function DWb(a,b){while(a.d.a.length<=b)Ywc(a.d,MWb(a));return $wc(a.d,b)}function Ajc(a,b){if(Esc(aNc,b)){zjc(a);return a.g}else return fnc(a.t,b)}function pEc(a,b){var c;c=Xtc(a.c,b);if(c){rEc(a,c);return c.e}return null}function n3b(a,b){var c;c=Z3b((Afc(),
_cc),a);d9b(c,(Hbc(),mbc),b);return c}function yLb(a,b){var c;c=dKb(a.a,(Afc(),Ddc));q8b(c,yKb(a.a,b.a));return c}function eGc(a,b){!a.a?a.a=new vtc(a.d):ptc(a.a,a.b);mtc(a.a,b);return a}function pt(a,b){var c,d;for(d=new yuc(b.a);d.b;){c=wuc(d);fs(a,c)}return a}function TB(a){if(a<=0)throw gZ(new qnb("x ("+a+") must be > 0"));return a}function aEb(a,b){if(b==null)throw gZ(new nsc("Null name"));a.d=b;return a}function w8b(a,b){Yd(!a.j,"Node has existing properties.");a.j=b.j;return a}function x7(a,
b){Td(b,"the error manager cannot be null");a.g=new Yxb(b)}function h3b(a,b){Yd(X8b(a),a);Yd(H3b(b),b);return new N9b((Afc(),Ccc),a,b)}function p3b(a,b){Yd(H3b(a),a);Yd(H3b(b),b);return new N9b((Afc(),fdc),a,b)}function Avc(a,b){var c,d;c=b.Ve();d=a.wj(c);return!!d&&kFc(d.We(),b.We())}function blc(a,b){var c;Ld(b.indexOf("<")==-1,CTc);return c=a.t,eq(a.B,c,b)}function dnc(a){var b;if(!a.a)return null;b=a.a.Si();return!b?null:b.Vi()}function oC(a){var b;if(!EC(a.a))return true;b=GC(a.a);return b==
59||b==44}function Qs(a,b){var c;if(pF(b,21)){c=b;a.b.a.length+c.Yd()}Qr(a,b);return a}function oFc(a,b){var c;c=R2b(a.a,b);if(c==null)throw gZ(new iFc);return c}function ne(a,b){var c;c=a[":"+b];FKc(!!c,CE(xE(iW,1),mLc,1,5,[b]));return c}function ae(a,b,c){if(!a)throw gZ(new Irc(rf(b,CE(xE(iW,1),mLc,1,5,[c]))));}function Pd(a,b,c){if(!a)throw gZ(new qnb(rf(b,CE(xE(iW,1),mLc,1,5,[c]))));}function KKc(a,b,c){if(a<0||b>c||b<a)throw gZ(new wtc(STc+a+TTc+b+RTc+c));}function gJb(a,b){if(!b)throw gZ(new nsc("Null strictMode"));
a.g=b;return a}function g7b(a,b,c){if(r4b(a.a,b,c)){a.e=true;return true}else return false}function q7b(a,b,c){if(u4b(a.a,b,c)){a.e=true;return true}else return false}function u7b(a,b,c){if(m4b(a.a,b,c)){a.e=true;return true}else return false}function vab(a){switch(a.f){case 0:case 1:return false;default:return true}}function Xfc(a){var b;if(a.v)return-1;a.v=true;b=a.Ei();a.v=false;return b}function f9b(a){var b,c;c=a.c;for(b=a.c;b;b=b.f)b.g=null;a.c=null;return c}function zE(a,b,c,d,e,f){var g;g=
AE(e,d);e!=10&&CE(xE(a,f),b,c,e,g);return g}function Qnc(a,b){var c;c=Znc(b,b.d);return Xkc(a.a,aoc(b.c,a.c),aoc(c,a.d))}function sGc(a,b){var c;c=new YGc;c.c=true;c.d=b.We();return tGc(a,b.Ve(),c)}function j0(a,b){var c;b.n==(Afc(),tdc)?(c=C8b(b),0!=c&&D0(OMc+c,b)):E_(a,b)}function SC(a,b,c){c||(a.a+=",\n",a);a.a+='"';a.a+=""+b;a.a+='"';a.a+=":"}function Qwc(a){if(ywc(a.d,a.c)<0){a.a=a.a-1&a.d.a.length-1;a.b=a.d.c}a.c=-1}function nJc(a){if(!a){this.c=null;this.b=new fxc}else{this.c=a;this.b=null}}
function ilb(a,b,c){this.f=new fxc;this.g=new fDc;this.a=a;this.c=b;this.i=c}function di(a,b,c,d){this.f=a;this.e=b;this.d=c;this.b=d;this.c=!d?null:d.d}function Hmb(a,b,c,d){Gmb.call(this,a,b,b?T9b(b.k):-1,b?S9b(b.k):-1,c,null,d)}function XGc(a,b){wvc.call(this,a,b);this.a=zE(gY,PLc,198,2,0,1);this.b=true}function aLb(a,b,c){if(c){gLb(a,c,(IRb(),_Qb));d9b(b,(n8b(),Y7b),yKb(a.a,c))}}function s7(a,b){if(E8b(b,(Hbc(),Pac))!=0)return;l9b(b,a.b);++a.b;$xb(a.c,b)}function bhc(a,b,c,d){if(!Qfc(a.b,b.b,
c,d))return false;return chc(a,b,c,d)}function IMb(a,b){if(b==(fOb(),MNb)){a.i=(JNb(),HNb);return b}return HMb(a,b)}function sZ(a){var b;if(pZ(a)){b=0-a;if(!isNaN(b))return b}return jZ(XE(a))}function aJb(a,b){if(!b)throw gZ(new nsc("Null annotations"));a.a=b;return a}function IDb(a,b){if(b==null)throw gZ(new nsc("Null symbol"));a.b=b;return a}function RZb(a,b,c,d){IZb.call(this,(n1b(),F_b),a);this.a=b;this.b=c;this.c=d}function p$b(a,b,c,d){IZb.call(this,(n1b(),W_b),a);this.a=b;this.b=c;this.c=d}
function l$b(a,b,c,d){IZb.call(this,(n1b(),S_b),a);this.c=b;this.b=c;this.a=d}function C$b(a,b,c,d){IZb.call(this,(n1b(),i0b),a);this.c=b;this.b=c;this.a=d}function D$b(a,b,c,d){IZb.call(this,(n1b(),j0b),a);this.c=b;this.b=c;this.a=d}function E$b(a,b,c,d){IZb.call(this,(n1b(),k0b),a);this.c=b;this.b=c;this.a=d}function E1b(a,b,c,d){IZb.call(this,(n1b(),_0b),a);this.a=b;this.b=c;this.c=d}function d_b(a,b,c,d){IZb.call(this,(n1b(),r0b),a);this.a=b;this.c=c;this.b=d}function n$b(a,b,c,d){IZb.call(this,
(n1b(),U_b),a);this.a=b;this.c=c;this.b=d}function L1b(a,b,c,d){IZb.call(this,(n1b(),g1b),a);this.b=b;this.c=c;this.a=d}function N1b(a,b,c,d){IZb.call(this,(n1b(),h1b),a);this.c=b;this.a=c;this.b=d}function exb(a,b){b.length!=0&&H8b(a,(Hbc(),sbc))==null&&d9b(a,(Hbc(),sbc),b)}function Tlb(){Rlb();return CE(xE(zN,1),sLc,163,0,[Llb,Olb,Mlb,Qlb,Nlb,Plb])}function yKc(){yKc=JZ;new CKc;new AKc("ISO-LATIN-1");new AKc("ISO-8859-1")}function y6b(a){if(V4b(a.a))return false;else{h5b(a.a);a.e=true;return true}}
function W6b(a){if(X4b(a.a))return false;else{o5b(a.a);a.e=true;return true}}function X6b(a){if(Y4b(a.a))return false;else{p5b(a.a);a.e=true;return true}}function Z6b(a){if(Z4b(a.a))return false;else{r5b(a.a);a.e=true;return true}}function h7b(a){if($4b(a.a))return false;else{u5b(a.a);a.e=true;return true}}function i7b(a){if(_4b(a.a))return false;else{v5b(a.a);a.e=true;return true}}function z7b(a){if(c5b(a.a))return false;else{z5b(a.a);a.e=true;return true}}function I6b(a,b){if(!!b&&d4b(a.a,b)){a.e=
true;return true}else return false}function O6b(a,b){if(!!b&&e4b(a.a,b)){a.e=true;return true}else return false}function sFc(a,b){rFc(a);if(a.d.Id()){b.jf(a.d.Jd());return true}return false}function M8b(a,b){var c;for(c=a.c;c;c=c.f)if(b==c)return true;return false}function Tg(a,b){var c,d;c=Bx(a.a,b);if(!c)return null;d=b;return a.b.Ce(d,c)}function B8(a){if(!a.a||!a.a.sh())return false;return a.a.sh().c==(scc(),pcc)}function Blb(a,b){var c;!a.o&&(a.o=new fxc);c=new Ilb(b,a);Ywc(a.o,c);return c}function Ad(a,
b,c){var d,e;d=(e=new Fd,a.c=a.c.b=e,e);d.c=c;d.a=Sd(b);return a}function DE(a,b){yE(b)!=10&&CE(Bb(b),b.Gj,b.__elementTypeId$,yE(b),a);return a}function dJb(a,b){if(!b)throw gZ(new nsc("Null languageMode"));a.d=b;return a}function S0(a,b){if(!b)throw gZ(new nsc("Null classNameNode"));a.c=b;return a}function HDb(a,b){if(b==null)throw gZ(new nsc("Null rawText"));a.a=b;return a}function Fpb(a){ppb();while(!!a&&!(a.n==(Afc(),Xec)||a.n==Jdc))a=a.g;return a}function mMb(a,b){var c;c=iKb(a.a,(Afc(),fec),
b.a);vKb(c,b.d.b,b.d.a);return c}function dib(a,b){if(b.c){epb(a.r.f.b,b,new wib(a));while(b.c)eib(a,g9b(b))}}function xJc(a){while(!a.a)if(!sFc(a.b,new BJc(a)))return false;return true}function $fc(a,b,c){var d;d=c?new ukc(true):new ukc(false);return Qfc(a,b,0,d)}function PHc(a,b,c){if(b==null||c==null)throw gZ(new msc);return $tc(a.a,b,c)}function jhb(a,b){if(!b||E8b(b,(Hbc(),gbc))==0)return b;return yhb(a,fhb(a,b))}function g7(a){if(a.G.pd!=(Xab(),Uab)){a.O=new ysb(a.o,a.v,a.G.pd);w6(a,a.O.d)}}
function p7(a){a.G.$==(C9(),B9)&&tCb(new uCb(a),a.o,a.v);a.K=1;!!a.O&&rsb(a.O)}function Qb(a){var b;if(!Pb(a))throw gZ(new jFc);a.i=1;b=a.g;a.g=null;return b}function pXb(a){switch(a){case 48:return 0;case 49:return 1;default:return-1}}function y7b(a,b){if(!a.a.j){a.e=true;y5b(a.a,b);return true}else return false}function Y8b(a,b){var c,d;c=b.f<<24>>24;d=a.j;while(!!d&&c!=d.c)d=d.b;return d}function xgc(a){var b;if(a.Li()){b=a.Li();return Wnc(b.B,alc(b.A))}return false}function Sxc(a,b,c,d){var e;
d=(HBc(),!d?EBc:d);e=a.slice(b,c);Txc(e,a,b,c,-b,d)}function uNb(a,b,c,d,e){var f,g;if(d){g=a.j.g;f=lOb(a.j);q6b(a.f,d,b,c,g,f,e)}}function ce(a,b,c,d){if(!a)throw gZ(new Irc(rf(b,CE(xE(iW,1),mLc,1,5,[c,d]))));}function Ulb(a,b,c,d,e,f){this.c=c;this.b=d;this.a=a;this.g=e;this.e=b;this.d=f}function OPb(a,b,c,d,e,f){he.call(this,a,b);this.d=c;this.c=d;this.b=e;this.a=f}function ID(a){AB(this);this.g=!a?null:FB(a,a.Yf());this.f=a;BB(this);this.Zf()}function y1(a){var b,c;for(c=In(a.c).Vd();c.Id();){b=
c.Jd();a.zg(b.b,b.a)}a.yg()}function m_(a,b){var c;c=C8b(b);2!=c&&D0(PMc+c,b);E_(a,b.c);E_(a,b.c?b.c.i:null)}function kPb(a,b){a.a.Bh(URc+occ(rSc,CE(xE(iW,1),mLc,1,5,[b])),a.b.ug(),a.d,a.c)}function lPb(a,b){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,[b])),a.b.ug(),a.d,a.c)}function mPb(a,b){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[b])),a.b.ug(),a.d,a.c)}function nPb(a,b){a.a.Bh(URc+occ(qSc,CE(xE(iW,1),mLc,1,5,[b])),a.b.ug(),a.d,a.c)}function qDb(){oDb();return CE(xE(sQ,1),sLc,145,0,[jDb,kDb,lDb,hDb,mDb,
nDb,iDb])}function kWb(){iWb();return CE(xE(NR,1),sLc,149,0,[bWb,cWb,dWb,eWb,fWb,hWb,gWb])}function $9b(a,b){n8b();return a<0||b<0?-1:(b&-4096)!=0?a<<12|xMc:a<<12|b&xMc}function Jab(){Jab=JZ;Gab=new Kab(COc,0);Iab=new Kab(qOc,1);Hab=new Kab(DOc,2)}function oHc(){oHc=JZ;kHc=new pHc("All",0);lHc=new tHc;mHc=new vHc;nHc=new yHc}function Ofc(){Ofc=JZ;Nfc=(bn(),pp(CE(xE(iW,1),mLc,1,5,[NMc,"IArrayLike",kPc])))}function gub(){hub.call(this,"REGISTER_BOOLEAN",0,"goog.tweak.registerBoolean")}function yuc(a){this.e=
a;this.d=new cEc(this.e.e);this.a=this.d;this.b=vuc(this)}function tyc(a){var b;b=((a-1)/31|0)+1;this.a=zE(yF,iMc,46,0,15,1);rKc(this.a,b)}function GJc(a,b,c){var d;lJc(a);d=new fKc;d.a=b;a.a.Hd(new jKc(d,c));return d.a}function _wc(a,b,c){for(;c<a.a.length;++c)if(kFc(b,a.a[c]))return c;return-1}function Nd(a,b,c){if(!a)throw gZ(new qnb(rf(b,CE(xE(iW,1),mLc,1,5,[Yrc(c)]))));}function Md(a,b,c){if(!a)throw gZ(new qnb(rf(b,CE(xE(iW,1),mLc,1,5,[_qc(c)]))));}function Zd(a,b,c){if(!a)throw gZ(new Irc(rf(b,
CE(xE(iW,1),mLc,1,5,[Yrc(c)]))));}function Ubc(a,b){if(null==b)throw gZ(new qnb("StringNode: str is null"));a.a=b}function oq(a,b){return!!xq(a,b,yZ(rZ(VLc,Vrc(yZ(rZ(b==null?0:Db(b),WLc)),15))))}function sF(a){return a!=null&&(typeof a===WKc||typeof a===ZKc)&&!(a.Hj===OZ)}function yE(a){return a.__elementTypeCategory$==null?10:a.__elementTypeCategory$}function Ow(a){return pF(a,113)?Dn(a):pF(a,173)?a.a:pF(a,69)?new hx(a):new Zw(a)}function K3b(a){ae(Hsc(a,_sc(46))==-1,HMc,a);return n8b(),new Wbc((Afc(),
rec),a)}function Pqb(a){ppb();return a.n==(Afc(),Jdc)&&!(a.n==Jdc&&E8b(a,(Hbc(),Fac))!=0)}function sTb(a){var b;b=null;AVb(a,(AZb(),NXb))&&(b=(iTb(a,NXb),nVb(a)));return b}function h1(a,b){if(b==null)throw gZ(new nsc("Null propertyKey"));a.c=b;return a}function F9b(a,b){z9b(a,b);d9b(a,(Hbc(),sbc),H8b(b,sbc));a.k=b.k;a.e=b.e;return a}function w6b(a){if((a.a.a&1)!=0)return false;else{a.a.a|=1;a.e=true;return true}}function M6b(a){if((a.a.a&8)!=0)return false;else{a.a.a|=8;a.e=true;return true}}function VB(a){if(iZ(a,
_Kc)>0)return _Kc;if(iZ(a,hMc)<0)return hMc;return yZ(a)}function aF(a){if(UE(a,(iF(),hF))<0)return-QE(XE(a));return a.l+a.m*vMc+a.h*wMc}function Xrc(a,b){var c;if(b==10||b<2||b>36)return""+a;return c=a,c.toString(b)}function HJc(a,b){mJc(a);if(iZ(b,0)==0)return a;return new KJc(a,new aKc(b,a.a))}function NCc(a,b){var c;c=b.f;if(!a.b[c]){a.b[c]=b;++a.c;return true}return false}function JEc(a,b){var c;if(IEc(a,b)){c=b.Ve();sEc(a.a,c);return true}return false}function k$(a,b){var c;c=a;while(c){if(oEc(c.e,
b))return true;c=c.b}return false}function Qr(a,b){var c,d;Sd(b);for(d=b.Vd();d.Id();){c=d.Jd();a.Jf(Sd(c))}return a}function xg(a,b){var c,d;for(d=b.He().Vd();d.Id();){c=d.Jd();a.Je(c.Ve(),c.We())}}function gTb(a,b){var c,d;for(d=b.b.Vd();d.Id();){c=d.Jd();!c.b&&uTb(a,b.a,c.c)}}function mu(a,b){var c;Sd(a);Sd(b);c=false;while(b.Id())c=c|a.Pd(b.Jd());return c}function Wsc(a){var b,c;c=a.length;b=zE(xF,eLc,46,c,15,1);Gsc(a,0,c,b,0);return b}function hac(a){var b;if(!a.a.a)throw gZ(new jFc);b=a.a.a;
a.a.a=a.a.a.g;return b}function W0(a,b){if(!b)throw gZ(new nsc("Null fullClassNameNode"));a.g=b;return a}function cJb(a,b){if(!b)throw gZ(new nsc("Null jsDocParsingMode"));a.c=b;return a}function FKc(a,b){if(!a)throw gZ(new qnb(LKc("Enum constant undefined: %s",b)));}function Nk(){Nk=JZ;Mk=new $Ic(new Ok,new Uk,new Wk);new $Ic(new Yk,new $k,new al)}function eDb(){eDb=JZ;dDb=new fDb(GMc,0);cDb=new fDb("LOCAL",1);bDb=new fDb(COc,2)}function G$(){G$=JZ;E$=new H$(GMc,0);F$=new H$("UNMAPPED",1);D$=new H$("MAPPED",
2)}function iF(){iF=JZ;eF=HE(sMc,sMc,524287);fF=HE(0,0,uMc);gF=FE(1);FE(2);hF=FE(0)}function Leb(){Leb=JZ;Keb=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),SQb),PQb]))}function sjb(){sjb=JZ;rjb=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),EQb),lRb]))}function wUb(a){var b,c;c=DWb(a.g,0).d.b;b=jTb(a);return new c_b(new Z1b(c,a.f),b)}function mp(a){bn();var b;if(pF(a,135)&&!pF(a,248)){b=a;return b}return np(a.Vd())}function p6b(a,b,c,d,e,f){var g;if(a.b){g=new W5b;g.d=b;S5b(g,c,d,e,f);N5b(a.b,g)}}function dE(a){var b,
c;if(a.b){c=null;do{b=a.b;a.b=null;c=gE(b,c)}while(a.b);a.b=c}}function cE(a){var b,c;if(a.a){c=null;do{b=a.a;a.a=null;c=gE(b,c)}while(a.a);a.a=c}}function ZLb(a,b){var c;c=dKb(a.a,(Afc(),Uec));!!b.a&&q8b(c,yKb(a.a,b.a));return c}function D2b(a,b){var c,d;c=z2b(a);b.b=c;if(c==116||c==84){d=z2b(a);b.c=d}return b}function D8b(a,b){var c,d;d=a.c;c=0;while(d){if(b==d)return c;d=d.f;++c}return-1}function _C(a,b){var c,d,e,f;e=a.a.b;f=b.e.b;c=a.a.a;d=b.e.a;return e==f&&c>=d||e>f}function erb(a,b,c){ppb();
var d;b.Ag(a);if(c.Ld(a))for(d=a.c;d;d=d.f)erb(d,b,c)}function mXb(a){switch(a){case 8232:case 8233:return false;default:return jXb(a)}}function Vpc(a){if(!a.j){a.j=Zpc(a);!a.j&&(a.j=new Woc(a.i,In(Wpc(a))))}return a.j}function Z0(a,b){if(!b)throw gZ(new nsc("Null superClassNameNode"));a.k=b;return a}function UMb(a,b,c,d,e,f){var g;f?g=qNb(a,b):g=nNb(a,b);uNb(a,c,d,g,e);return g}function YTb(a,b){var c;c=(Bn(),new Zr);while(DVb(a))Xr(c,XTb(a,b));return In(c.a)}function E3b(a,b){var c;Xd(a.n==(Afc(),
fec));Xd(I3b(b));c=new N9b(eec,a,b);return c}function IWb(a,b){if((xWb(a,a.f)?zsc(a.b,a.f):0)==46){yWb(a);RWb(a)}return HWb(a,b)}function L6b(a){if((a.a.a&32)!=0)return false;else{a.a.a|=32;a.e=true;return true}}function e7b(a){if((a.a.a&64)!=0)return false;else{a.a.a|=64;a.e=true;return true}}function uOb(a){if((a&57296)!=0)return false;return a==10||a==13||a==8232||a==8233}function u9(a){if(a.zb==($9(),X9))return false;return a.Dc||kQb((iQb(),YPb),l9(a))}function qq(a,b){return Ex(wq(a,b,yZ(rZ(VLc,
Vrc(yZ(rZ(b==null?0:Db(b),WLc)),15)))))}function Xsc(a,b){return b==(bFc(),bFc(),aFc)?a.toLocaleLowerCase():a.toLowerCase()}function Pic(a,b){var c;c=(n8b(),new Wbc((Afc(),rec),""));c.d=b;q8b(a.b,c);return c}function ZCc(a){var b;++a.a;for(b=a.c.a.length;a.a<b;++a.a)if(a.c.b[a.a])return}function A8b(a){var b,c;for(b=a.c;b;){c=b.f;b.g=null;b.f=null;b.i=null;b=c}a.c=null}function SCc(a,b){if(!!b&&a.b[b.f]==b){a.b[b.f]=null;--a.c;return true}return false}function wx(a){if(a<3){fl(a,XLc);return a+1}if(a<
$Lc)return vF(a/.75+1);return _Kc}function A$(a){if(!a.c)return false;return E8b(a.c,(n8b(),b8b))!=0||E8b(a.c,a8b)!=0}function iub(){cub();return CE(xE(JO,1),sLc,90,0,[_tb,aub,bub,$tb,Xtb,Wtb,Ytb,Ztb])}function a7(a,b){a.S=new pbb(CE(xE(tQ,1),mLc,167,0,[new Qxb(a,(Hcb(),wo(Gcb))),b]))}function W8(a){this.a=new xGc;this.c=new fxc;this.d=new fxc;this.e=new fxc;this.b=a}function Ilb(a,b){this.p=new YEc;this.q=new fDc;this.b=a;this.n=b;this.t=(Rlb(),Plb)}function vEc(a){fDc.call(this);mEc(this);this.b.b=
this.b;this.b.a=this.b;xg(this,a)}function gc(){this.a=Wsc("0123456789_.");this.a.sort(KZ(kyc.prototype.yj,kyc,[]))}function S$(a){var b,c;b=a_(Se(Ze(),JMc));return c=Tqb(b,CE(xE(HU,1),IMc,7,0,[a])),c}function U$(a){var b,c;b=a_(Se(Ze(),KMc));return c=Tqb(b,CE(xE(HU,1),IMc,7,0,[a])),c}function Vob(a){var b;b=a.g;Sd(b);Yd((ppb(),b.n==(Afc(),Xec)||b.n==Jdc),b);v7(a.c,b)}function kfb(a,b,c){var d;d=c;while(d.g.n==(Afc(),eec))d=d.g;p8b(d.g,b,d);w7(a.a,b)}function nib(a,b,c){Xd(c.n==(Afc(),Vcc));Xd(!a.d);
oib(a,b);t8b(a.a,f9b(c));a.e=false}function Qqb(a,b){ppb();var c;a.n==(Afc(),Jdc)&&b.rg(a);for(c=a.c;c;c=c.f)Qqb(c,b)}function Rqb(a,b){ppb();var c;a.n==(Afc(),Jdc)&&b.qg(a);for(c=a.c;c;c=c.f)Rqb(c,b)}function Bhb(a,b,c){if(c){swc(a.e)||++qwc(a.e).b;kwc(a.k,c)}!!b&&kwc(a.e,new qib(b))}function Web(a,b){while(uF(Sd(a.g))!==uF(b))a=Sd((ppb(),Gpb(a.g,new jrb)));return a}function bxc(a,b){var c;c=_wc(a,b,0);if(c==-1)return false;qKc(a.a,c,1);return true}function $Wb(a){if((xWb(a,a.f)?zsc(a.b,a.f):0)==
92)return WWb(a);yWb(a);return true}function aXb(a){if((xWb(a,a.f)?zsc(a.b,a.f):0)==92)return bXb(a);yWb(a);return true}function Oqb(a){ppb();switch(a.f){case 63:case 64:return true;default:return false}}function Wpb(a){ppb();var b;b=null;while(!b&&!!a){b=H8b(a,(Hbc(),ybc));a=a.g}return b}function Lmb(a,b,c){var d;return new Hmb((d=H8b(a,(Hbc(),ybc)),!d?null:d.ug()),a,b,c)}function gFc(a,b,c){var d;d=a.Ie(b);if(d==null){d=c.Od(b);d!=null&&a.Je(b,d)}return d}function W3b(a,b){var c;Xd(H3b(b));c=(n8b(),
new Wbc((Afc(),cfc),a));r8b(c,b);return c}function brb(a){ppb();var b;b=a.n==(Afc(),Jdc)?a.c?a.c.i:null:a;return wpb(b,lfc,lpb)}function emb(){cmb();return CE(xE(BN,1),sLc,139,0,[_lb,amb,$lb,Wlb,Zlb,Xlb,Ylb,bmb])}function Ktc(){Itc();return CE(xE(qW,1),sLc,141,0,[Htc,Btc,Atc,Ctc,Ftc,Dtc,Etc,Gtc])}function _q(a,b){return zx(xq(a.a,b,yZ(rZ(VLc,Vrc(yZ(rZ(b==null?0:Db(b),WLc)),15)))))}function S8b(a){return a.n==(Afc(),Jdc)&&E8b(a,(Hbc(),Gac))!=0&&E8b(a,(Hbc(),Xac))!=0}function FJb(){FJb=JZ;EJb=new GJb("STOP_AFTER_ERROR",
0);DJb=new GJb("KEEP_GOING",1)}function stb(a){if(a.a)throw gZ(new Irc("normalizeNodeType constraints violated"));}function $6b(a){if((a.a.a&hQc)!=0)return false;else{a.a.a|=hQc;a.e=true;return true}}function H6b(a){if((a.a.a&CQc)!=0)return false;else{a.a.a|=CQc;a.e=true;return true}}function N6b(a){if((a.a.a&uMc)!=0)return false;else{a.a.a|=uMc;a.e=true;return true}}function A7b(a){if((a.a.a&kMc)!=0)return false;else{a.a.a|=kMc;a.e=true;return true}}function A6b(a){if((a.a.a&256)!=0)return false;
else{a.a.a|=256;a.e=true;return true}}function Wfc(a){var b;if(a.w)return false;else{a.w=true;b=a.li();a.w=false;return b}}function gJc(a){var b,c;if(0>a)return new rJc;b=a+1;c=new iJc(b,a);return new oJc(c)}function dkc(){dkc=JZ;ckc=new ekc("ORDINARY",0);akc=new ekc(tRc,1);bkc=new ekc(yRc,2)}function jrc(a){var b;b=new hrc;b.p="Class$"+(a?"S"+a:""+b.k);b.b=b.p;b.n=b.p;return b}function Up(a,b){var c;c=pEc(a.a,b);if(!c){c=(wx(a.b.a),new uEc);qEc(a.a,b,c)}return c}function Rc(a,b){var c,d,e;c=false;
for(e=b.Vd();e.Id();){d=e.Jd();c=c|a.Pd(d)}return c}function KZ(a,b,c){var d=function(){return a.apply(d,arguments)};b.apply(d,c);return d}function yic(a,b,c){a.k=Qnc(a.k,Xkc(a.f,(Bn(),new Wz(Sd(b))),new Wz(Sd(c))));return a}function $_(a,b,c){var d;b0((Afc(),uec),b);for(d=b.c;d;d=d.f)c?j_(a,d):q0(a,d,false)}function A3b(a,b,c){Xd(H3b(a));Xd(H3b(b));Xd(H3b(c));return new O9b((Afc(),Sdc),a,b,c)}function Qe(a){Nd(true,"must be greater than zero: %s",2);return new Xe(a.c,a.b,a.d,2)}function AMb(a,b){BMb(a,
"msg.bad.fileoverview.visibility.annotation",b,a.j.g,lOb(a.j))}function l4b(a,b){!a.d&&(a.d=new L5b);!a.d.s&&(a.d.s=new fxc);Ywc(a.d.s,b);return true}function i5b(a,b){!a.d&&(a.d=new L5b);if(a.d.c!=null)return false;a.d.c=b;return true}function mqb(a){ppb();var b;if(a.n!=(Afc(),Jdc))return false;b=a.g;return!!b&&nqb(b)}function Jf(a,b,c){var d,e;d=(e=a.f,!e?a.f=new Wg(a,a.c):e).Ie(b);return!!d&&d.Sd(c)}function Ms(a,b,c){var d;el(b,c);d=pEc(a.a,b);!d&&qEc(a.a,b,d=new fxc);d.Pd(c);return a}function Kbb(a,
b){var c;for(c=0;c<a.length;c++)if(a[c].a==b)return true;return false}function yrc(a,b){var c;if(!a)return;b.o=a;var d=rrc(b);if(!d){GZ[a]=[b];return}d.Fj=b}function zjb(a,b,c){var d;d=!c?new wwb(b):new vwb(c,b);Gjb(new Ijb(a.a,a.b,d));return d}function ofb(a){var b;b=P3b(CE(xE(HU,1),IMc,7,0,[]));a.d&&r9b(b,U6(a.a).u[38]);return b}function QKb(a){var b;while(a.Id()){b=a.Jd();if(b.b==(e$b(),b$b))return b}return null}function SWb(a){if(Uqc(xWb(a,a.f)?zsc(a.b,a.f):0,16)<0)return false;yWb(a);return true}
function u6b(a,b){if(w4b(a.a)==null){g5b(a.a,b);a.e=true;return true}else return false}function G6b(a){if((a.a.a&1024)!=0)return false;else{a.a.a|=1024;a.e=true;return true}}function P6b(a){if((a.a.a&8192)!=0)return false;else{a.a.a|=8192;a.e=true;return true}}function a7b(a){if((a.a.a&2048)!=0)return false;else{a.a.a|=2048;a.e=true;return true}}function CZ(){DZ();var a=BZ;for(var b=0;b<arguments.length;b++)a.push(arguments[b])}function nyc(a,b){var c;uyc(b);c=b/31|0;return c<a.a.length&&((a.a[c]|
0)>>>b%31&1)==1}function LCc(a){var b,c;c=(b=erc(fe(a)),new TCc(b,nKc(b,b.length),0));NCc(c,a);return c}function Dm(a){var b,c,d,e;for(c=a,d=0,e=c.length;d<e;++d){b=c[d];Sd(b)}return new Jm(a)}function Kyc(a,b){Cyc();var c;c=new gDc;tF(a)?_tc(c,a,b):FDc(c.d,a,b);return new uAc(c)}function Ukc(a,b){return pF(b,212)||b.mi()?b:Zkc(a,CE(xE(cV,1),xPc,23,0,[b,a.u[52]]))}function Knb(){Knb=JZ;Jnb=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),PQb),gRb,CRb]))}function bbb(){bbb=JZ;_ab=new cbb(GMc,0);$ab=new cbb("CHECK",
1);abb=new cbb("STRIP",2)}function Pab(){Pab=JZ;Mab=new Qab(COc,0);Nab=new Qab("LOCAL_ONLY",1);Oab=new Qab(qOc,2)}function obb(a){this.e=new fDc;this.b=new vbb(this.e);this.c=new DHc(this.b);kbb(this,a)}function q1(a,b,c){if(a==null)throw gZ(new nsc("Null name"));this.c=a;this.a=b;this.b=c}function fl(a,b){if(a<0)throw gZ(new qnb(b+" cannot be negative but was: "+a));return a}function JCb(a){if(a.d)return new Ajb(a.a);else{a.b=new XCb(a);return new Bjb(a.a,a.b)}}function cUb(a){var b;b=DWb(a.g,0).d.b;
iTb(a,(AZb(),ZYb));return new w$b(new Z1b(b,a.f))}function dGb(a,b){XFb();var c;c=Lrc(b.length,a.length);if(c!=0)return c;return Asc(a,b)}function R6(a,b,c){var d;if(c<1)return null;d=Q6(a,b);if(d)return Rwb(d,c);return null}function aD(a,b,c){var d,e;e=$C(a,c.a);d=ZC(a,c.a);(a.b<e||a.b==e&&a.a<d)&&cD(a,b,c,e,d)}function G4(a,b){if(H8b(b,(Hbc(),Nac))){L3(a.c,":");a.c.$g();a.fh(H8b(b,Nac),(_4(),W4))}}function uGb(a){sGb();typeof console!==vPc&&typeof console.log!==vPc&&console.log(a)}function FZ(a,
b){typeof window===WKc&&typeof window["$gwt"]===WKc&&(window["$gwt"][a]=b)}function uqb(a){ppb();var b;b=a.g;return b.n==(Afc(),Vdc)||b.n==Wdc&&(b.c?b.c.i:null)==a}function o$b(a,b,c,d,e){IZb.call(this,(n1b(),V_b),a);this.d=b;this.b=c;this.c=d;this.a=e}function F$b(a,b,c,d,e){IZb.call(this,(n1b(),l0b),a);this.d=b;this.b=c;this.c=d;this.a=e}function v1b(a,b,c,d,e){IZb.call(this,(n1b(),S0b),a);this.d=b;this.b=c;this.c=d;this.a=e}function b_b(a,b,c,d,e){IZb.call(this,(n1b(),p0b),a);this.c=b;this.b=c;
this.d=d;this.a=e}function h_b(a,b,c,d,e){IZb.call(this,(n1b(),v0b),a);this.c=b;this.b=c;this.d=d;this.a=e}function e_b(a,b,c,d,e){IZb.call(this,(n1b(),s0b),a);this.a=b;this.b=c;this.d=d;this.c=e}function VZb(a,b,c,d,e){IZb.call(this,(n1b(),J_b),a);this.c=b;this.b=c;this.a=d;this.d=e}function m$b(a,b,c,d,e){IZb.call(this,(n1b(),T_b),a);this.d=b;this.c=c;this.a=d;this.b=e}function cic(a,b,c,d){Ghc.call(this,a);this.d=b;this.c=pF(b,48)?b:null;this.b=c;this.a=d}function a2b(a,b){GD.call(this,"ConvertionType = "+
String.fromCharCode(a)+" class = "+b)}function Oqc(a,b){Nqc();return tF(a)?Asc(a,b):rF(a)?Grc(a,b):qF(a)?a==b?0:a?1:-1:a.ie(b)}function u$(a,b){if(!pF(b,302))return false;return Esc(a.sg(),b.sg())&&zb(a.tg(),b.tg())}function pyc(a){var b,c;b=xyc(a.a);if(b==-1)return 0;c=a.a[b]|0;return b*31+(32-Trc(c))}function lE(a){var b=/function(?:\s+([\w$]+))?\s*\(/;var c=b.exec(a);return c&&c[1]||pMc}function kd(a,b){var c,d;for(c=0,d=a.Yd();c<d;++c)if(kFc(b,a.ce(c)))return c;return-1}function rNb(a,b){var c,
d;d=QMb(a,(Afc(),pfc));xNb(a);c=fNb(a,b);xNb(a);r8b(d,c);return d}function UJb(a,b){var c;c=null;while(!!a.b&&a.b.a.a.c<=b.b.c){c=a.b;a.b=QKb(a.j)}return c}function tNb(a,b){var c;if(a.f.d){c=KMb(a,b,a.g?0:2,false);b=c.b}else b=HMb(a,b);return b}function F2b(a,b,c){var d;b.p=c;d=a.b<a.c?zsc(a.a,a.b):-1;return d==46?E2b(a,b):D2b(a,b)}function qVb(a){var b,c;b=DWb(a.g,0).d.b;c=kTb(a);return new G1b(new Z1b(b,a.f),fTb(a,c))}function BVb(a){switch(DWb(a.g,0).e.f){case 63:case 64:return true;default:return false}}
function PVb(a){switch(DWb(a.g,0).e.f){case 68:case 69:return true;default:return false}}function ukb(a){switch(a.n.f){case 60:case 62:case 61:return true;default:return false}}function Ff(a){Xd(a.f!=3);switch(a.f){case 2:return false;case 0:return true}return Gf(a)}function Pb(a){Xd(a.i!=3);switch(a.i){case 0:return true;case 2:return false}return Sb(a)}function Xoc(a,b){var c;for(c=0;c<b.Yd();c++)if(!b.ce(c).xi())return false;return true}function Jjb(a,b){var c;if(pqb(b.d)){c=h$(b.b,a);return!c||
z$(c)!=(Afc(),Jec)}return true}function gkb(a,b){var c;c=qkb(b);Sd(c);Yd((ppb(),c.n!=(Afc(),pec)&&Jqb(c.g)),c);hkb(a,c,b)}function FMb(a,b){var c;return!b?null:new H7b(b,(c=H8b(a.n,(Hbc(),ybc)),!c?null:c.ug()))}function Sob(a,b){Sd(a.e);Sd(b);Ywc(a.n,b);ppb();QCc(ipb,b.n)&&kwc(a.b,b);!!a.j&&a.j.yh(a)}function rtb(a,b,c){if(a.a)qtb(a,c);else{!!b&&epb(a.b,b,new wtb);!!c&&epb(a.b,c,new wtb)}}function owc(a,b,c){var d,e,f;f=a.a.length-1;for(e=a.b,d=0;d<c;e=e+1&f,++d)b[d]=a.a[e]}function Urc(a){var b,
c;if(a==0)return 32;else{c=0;for(b=1;(b&a)==0;b<<=1)++c;return c}}function Ud(a,b,c){if(a==null)throw gZ(new nsc(rf(b,CE(xE(iW,1),mLc,1,5,[c]))));return a}function _Jb(a,b,c,d){b.p==(n1b(),M0b)&&(c.a&HPc)==WPc&&(d=eKb(a,(Afc(),_cc),d));return d}function ZJb(a,b){if(b.e!=a.g){a.g=b.e;(a.g.a&sQc)!=0&&(a.c=true);return true}return false}function rpb(a){var b;for(b=a.c.f;b;b=b.f)if(!Apb(b,(se(),oe)))return false;return true}function p4b(a,b){if(!d5b(a))return true;if(a.b.b!=null)return false;a.b.b=b;
return true}function t4b(a,b){if(!d5b(a))return true;if(a.b.f!=null)return false;a.b.f=b;return true}function v4b(a,b){if(!d5b(a))return true;if(a.b.k!=null)return false;a.b.k=b;return true}function o4b(a,b){if(!d5b(a))return true;!a.b.a&&(a.b.a=new fxc);Ywc(a.b.a,b);return true}function s4b(a,b){if(!d5b(a))return true;!a.b.g&&(a.b.g=new fxc);Ywc(a.b.g,b);return true}function tkc(a,b,c,d){if(uF(b)===uF(c))return;!a.a&&(a.a=new fDc);$tc(a.a,new vkc(b,c),d)}function sIc(a,b){((CIc(),zIc)?null:b.c).length==
0&&FIc(b,new TIc);_tc(a.a,zIc?null:b.c,b)}function aKc(a,b){QFc.call(this,b.gf(64)?lsc(0,vZ(b.ff(),a)):LLc,b.ef());this.b=a;this.a=b}function uu(a,b){var c;Sd(b);c=false;while(a.Id())if(b.Sd(a.Jd())){a.Kd();c=true}return c}function Gr(a){var b;a=$wnd.Math.max(a,2);b=Qrc(a);if(a>b){b<<=1;return b>0?b:$Lc}return b}function W$(a){var b;b=(ae(Hsc(a,_sc(46))==-1,HMc,a),n8b(),new Wbc((Afc(),rec),a));return b}function X$(a){var b;b=(ae(Hsc(a,_sc(46))==-1,HMc,a),n8b(),new Wbc((Afc(),rec),a));return b}function Y$(a){var b;
b=(ae(Hsc(a,_sc(46))==-1,HMc,a),n8b(),new Wbc((Afc(),rec),a));return b}function x8(a,b){var c;c=Sd(a.a.qh(b));Xd(c.n==(Afc(),Xec));Sd(H8b(c,(Hbc(),cbc)));return c}function hFc(a,b){var c,d;for(d=new yuc((new puc(a)).a);d.b;){c=wuc(d);Wj(b,c.Ve(),c.We())}}function Osb(a,b,c){var d;if(a.j){d="AST hashCode after "+b+": "+TKc(E7(a.b,c));JIc(Lsb,d)}}function q6b(a,b,c,d,e,f,g){var h;if(a.b){h=new Z5b;h.d=b;h.a=g;S5b(h,c,d,e,f);P5b(a.b,h)}}function h4b(a,b){var c;!a.d&&(a.d=new L5b);!!a.d.q&&(b=vz(b,a.d.q));
a.d.q=(bn(),c=b,mp(c))}function xVb(a){var b,c;c=DWb(a.g,0).d.b;b=wVb(a,1);nTb(a);return new O1b(new Z1b(c,a.f),b)}function Dab(){Dab=JZ;Aab=new Eab(qOc,0);Cab=new Eab("SENTINEL",1);Bab=new Eab("NORMAL",2)}function scc(){scc=JZ;qcc=new tcc("STRONG",0);rcc=new tcc("WEAK",1);pcc=new tcc("EXTERN",2)}function U9(){U9=JZ;R9=new V9(GMc,0);S9=new V9("USE_GLOBAL_TEMP",1);T9=new V9("USE_IIFE",2)}function q$(){q$=JZ;n$=new r$("ARGUMENTS",0,BMc);o$=new r$(CMc,1,DMc);p$=new r$(EMc,2,FMc)}function IHb(){IHb=JZ;
HHb=new Mcb("JSC_USELESS_BLOCK",(E2(),C2),new Rtc("Useless block."))}function UB(a){if(!a)throw gZ(new Dqc("mode was UNNECESSARY, but rounding was necessary"));}function U0(a,b){if(!b)throw gZ(new nsc("Null definePropertiesObjForClass"));a.e=b;return a}function $Dc(a,b){var c;c=a.a.get(b);if(c===undefined)++a.c;else{QDc(a.a,b);--a.b}return c}function oOb(a){var b;b=kOb(a);if(b==47)return true;else{a.q[a.r++]=b;--a.b;return false}}function v6b(a){if((a.a.a&262144)!=0)return false;else{a.a.a|=262144;
a.e=true;return true}}function _6b(a){if((a.a.a&131072)!=0)return false;else{a.a.a|=131072;a.e=true;return true}}function JKb(a){if(a>=48&&a<=49)return a-48;throw gZ(new Irc(QRc+String.fromCharCode(a)));}function PKb(a){if(a>=48&&a<=55)return a-48;throw gZ(new Irc(QRc+String.fromCharCode(a)));}function _qb(a){ppb();var b;b=$qb(a);if(b==null)throw gZ(new Hqc("Unknown op "+a));return b}function skb(a,b){var c,d,e;e=a;for(c=a,d=c.g;d!=b;c=d,d=c.g)ukb(d)&&c!=d.c&&(e=d);return e}function vlb(a,b){var c,
d,e;e=H6(a.a.a);d=e.Dg(b);if(d)return true;c=e.Eg(b);return c!=null}function wGc(a,b){var c,d;c=1-b;d=a.a[c];a.a[c]=d.a[b];d.a[b]=a;a.b=true;d.b=false;return d}function zmb(a,b,c){var d;d=new stc;d.a+="@";d.a+=b;d.a+=" {";ymb(a,d,c);d.a+="}";return d.a}function ubb(a,b,c){var d;d=b.vh()-c.vh();if(d!=0)return d;return Xtc(a.a,c).a-Xtc(a.a,b).a}function v3b(a,b,c){Xd(a.n==(Afc(),rec));Xd(b.n==Jec);Xd(c.n==Vcc);return new O9b(Jdc,a,b,c)}function D7b(a){var b;b=i4b(a,false);b.j==(e6b(),_5b)&&(b.j=null);
return new B7b(b,a.c,true)}function vUb(a){var b;b=(Bn(),new Zr);while(!AVb(a,(AZb(),XXb)))Xr(b,dVb(a));return In(b.a)}function rz(a){var b,c,d;b=0;for(d=a.Vd();d.Id();){c=d.Jd();b+=c!=null?Db(c):0;b=~~b}return b}function C_(a){var b,c;b0((Afc(),Bdc),a);c=C8b(a);2!=c&&D0(PMc+c,a);for(b=a.c;b;b=b.f)W_(b)}function L_(a){var b,c;b0((Afc(),Wdc),a);c=C8b(a);2!=c&&D0(PMc+c,a);for(b=a.c;b;b=b.f)W_(b)}function EB(a,b){var c,d,e;e=b.length;c=zE(kW,mLc,143,e,0,1);for(d=0;d<e;++d)c[d]=b[d];a.i=c}function m5(a,
b){this.j=new ttc;Xd(!!b);this.p=a<=0?_Kc:a;this.k=false;this.q=b;this.i=null}function pw(a){this.e=a;this.d=(wx(Kf(this.e).Yd()),new nDc);this.c=this.e.a;this.b=this.e.c}function i7(a){var b,c;for(c=new wxc(a.d);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);b.Jg()}}function B6(a){var b;b=new Tsb(a,a.O);a.G.$==(C9(),y9)&&Rsb(b,a.R);a.G.p&&(b.j=true);return b}function Wnc(a,b){var c,d;for(d=a.c.Vd();d.Id();){c=d.Jd();if(c==b)return true}return false}function G4b(a){var b;if(!a.d||!a.d.o)return bn(),
mz(),lz;return bn(),b=new Wuc(a.d.o),mp(b)}function U_(a){var b;b=false;b=!!a.c;b||D0("Expected at least 1 children, but was "+C8b(a),a)}function Uc(a,b){var c,d;for(d=b.Vd();d.Id();){c=d.Jd();if(!a.Sd(c))return false}return true}function xq(a,b,c){var d;for(d=a.c[c&a.f];d;d=d.d)if(c==d.f&&Gd(b,d.i))return d;return null}function wq(a,b,c){var d;for(d=a.b[c&a.f];d;d=d.b)if(c==d.a&&Gd(b,d.g))return d;return null}function LC(a,b){var c,d;c=pEc(a.g,b);if(c)d=c.a;else{d=duc(a.g.c);qEc(a.g,b,Yrc(d))}return d}
function Pr(a,b){var c,d,e,f;Sd(b);for(d=b,e=0,f=d.length;e<f;++e){c=d[e];Os(a,Sd(c))}return a}function tCb(a,b,c){u_(a.a,b);u_(a.a,c);sCb(a,b,c);SZ(a.b.T)&&KCb(new LCb(a.b),b,c);rCb(a,b)}function Cib(a){this.b=a;this.a=new okb(a.b,new j8(a.b),new mDc,new wwb(new J9b((Afc(),Xec))))}function sGb(){sGb=JZ;rGb=new bcb(CE(xE(bM,1),mLc,5,0,[new Mcb(ZPc,(E2(),B2),new Rtc(""))]))}function GHb(){GHb=JZ;FHb=new Mcb("JSC_UNUSED_LABEL",(E2(),C2),new Rtc("Unused label {0}."))}function U2(){U2=JZ;T2=new Mcb("JSC_USELESS_CODE",
(E2(),D2),new Rtc("Suspicious code. {0}"))}function e3(){e3=JZ;d3=new Mcb("JSC_UNREACHABLE_CODE",(E2(),D2),new Rtc("unreachable code"))}function m3b(a,b){Xd(H3b(a));Xd(b.n==(Afc(),Vcc));c9b(b,(Hbc(),Eac),1);return new N9b($cc,a,b)}function Gyc(a,b){Cyc();var c,d;d=new fxc;for(c=0;c<a;++c)d.a[d.a.length]=b;return new gBc(d)}function QGc(a,b,c,d,e,f){var g;this.c=a;g=new fxc;mGc(a,g,b,a.b,c,d,e,f);this.a=new Muc(g,0)}function Uob(a,b,c,d){var e,f;e=new Hmb((f=H8b(b,(Hbc(),ybc)),!f?null:f.ug()),b,c,
d);u7(a.c,e)}function eB(a,b){var c,d;b=pB(a,b);d=zE(wF,cMc,46,oB(a,btc(b)),15,1);c=xB(a,d,b);return fB(d,c)}function gjb(a,b){var c,d,e;c=l3b(a,b);d=a.d;if(!d||!pF(d,128))return c;e=d.b.b;return c.d=e,c}function VJb(a,b){var c;c=UJb(a,b);return!!c&&c.c.indexOf("@")==-1?pKb(a,b,oKb(a,c)):XJb(a,c)}function vTb(a,b){if(b){RVb(a,(IRb(),DRb));a.b.e&&EOb(a.c,b.d.b,$Qc,CE(xE(iW,1),mLc,1,5,[]))}}function CJb(){zJb();return CE(xE(pR,1),sLc,106,0,[pJb,qJb,rJb,sJb,tJb,uJb,vJb,wJb,yJb,xJb])}function y$(){y$=
JZ;x$=Ur(MCc((Afc(),ufc),CE(xE(KU,1),sLc,10,0,[jec,gdc,Jdc,bdc,adc,Vdc,Jec])))}function jfb(){jfb=JZ;ifb=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),fRb),RQb]));hfb=new zfb}function zpb(a){ppb();return ypb(a)||a.n==(Afc(),Jdc)||a.n==(Afc(),pec)||a.n==(Afc(),Vec)&&!a.g}function oqb(a){ppb();var b;Ld(a.n==(Afc(),Xec),a);b=H8b(a,(Hbc(),mbc));return!!b&&(b.a&16)!=0}function iqb(a){ppb();switch(a.n.f){case 158:case 109:return true;default:return QCc(jpb,a.n)}}function Nqb(a){switch(a.n.f){case 79:return true;
case 29:return Esc(a.Wh(),vPc)}return false}function tkb(a){switch(a.n.f){case 95:case 47:case 121:if(T8b(a.c))return 1;default:return 0}}function Yoc(a,b){Ofc();var c;for(c=0;c<b.Yd();c++)if(a.Nd(b.ce(c)))return true;return false}function fz(a,b){var c,d,e;e=0;for(d=xu(new Wzc(a.b.b.Vd()));d.Id();){c=d.Jd();b[e++]=c}return b}function fB(a,b){var c;if(b==a.length)return a;else{c=zE(wF,cMc,46,b,15,1);xtc(a,c,b);return c}}function l7b(a){if((a.a.a&16777216)!=0)return false;else{a.a.a|=16777216;a.e=
true;return true}}function U6b(a){if((a.a.a&33554432)!=0)return false;else{a.a.a|=33554432;a.e=true;return true}}function mZ(a){if(yMc<a&&a<wMc)return a<0?$wnd.Math.ceil(a):$wnd.Math.floor(a);return jZ(VE(a))}function bTb(a){switch(a){case 10:case 13:case 8232:case 8233:return true;default:return false}}function jXb(a){switch(a){case 10:case 13:case 8232:case 8233:return true;default:return false}}function C6b(a,b){if(b!=null&&y4b(a.a)==null){j5b(a.a,b);a.e=true;return true}else return false}function V6b(a,
b){if(b!=null&&E4b(a.a)==null){n5b(a.a,b);a.e=true;return true}else return false}function bEb(a,b){if(b==null)throw gZ(new nsc("Null pathRelativeToClosureBase"));a.e=b;return a}function V0(a,b){if(!b)throw gZ(new nsc("Null definePropertiesObjForPrototype"));a.f=b;return a}function foc(a,b){this.f=(Cyc(),new jzc(new xDc));this.e=a;this.g=false;this.c=b;this.d=new Cwc}function Ifb(a){this.f=a;this.c=new tEc;this.b=new hv;this.a=new Cr;this.e=new hv;this.d=new tEc}function vIc(){var a;if(!rIc){rIc=new uIc;
a=new QIc("");MIc(a,(bIc(),$Hc));sIc(rIc,a)}return rIc}function jZ(a){var b;b=a.h;if(b==0)return a.l+a.m*vMc;if(b==tMc)return a.l+a.m*vMc-wMc;return a}function _xb(a,b){var c;c=auc(a.a,b);if(c){c.a?c.a.b=c.b:a.b=c.b;c.b.a=c.a;c.a=null;c.b=null}}function JTb(a,b,c){var d;lwc(a.e,c);AVb(a,(AZb(),FYb))?d=qUb(a):d=KTb(a,b);wwc(a.e);return d}function MOb(a){return LOb(a)&&PPb($b(a)).a==2||LOb(a)&&PPb($b(a)).a==3||LOb(a)&&PPb($b(a)).a==4}function m6b(a){return a.e&&((a.a.a&4096)!=0||(a.a.a&sQc)!=0||(a.a.a&
131072)!=0||(a.a.a&16)!=0)}function Lvb(a,b){return b.n==(Afc(),Pdc)?a.c.Sd((b.c?b.c.i:null).Wh()):b.n==rec&&a.c.Sd(b.Wh())}function Bjc(a){var b;Kd(a.oi()||a.f==(dkc(),bkc));b=zjc(a).Si();if(!b)return null;return b.Qi()}function IVb(a){switch(DWb(a.g,0).e.f){case 65:case 94:case 67:return true;default:return false}}function QVb(a){switch(DWb(a.g,0).e.f){case 25:case 30:case 38:return true;default:return false}}function MVb(a){switch(DWb(a.g,0).e.f){case 70:case 71:case 72:return true;default:return false}}
function mdb(a){switch(a.n.f){case 98:case 86:case 87:case 116:return true;default:return false}}function W6(a,b){if(y8(b).a){q8b(a.o,x8(b,a));C8(b);Qmb(b.k,b);Ywc(a.k,b);return true}return false}function RMb(a,b,c,d){var e;e=w8b((n8b(),new Xbc((Afc(),bfc),b,c,d)),a.n);t9b(e,b.length);return e}function seb(a,b){var c;if(!a9b(b,rPc,rPc.length))return false;c=i$(Kob(a),rPc);return!c||!c.d.b}function UUb(a,b){switch(DWb(a.g,0).e.f){case 49:return HTb(a,b);case 45:default:return QUb(a,b)}}function aoc(a,
b){if(a.Ud())return b;if(b.Ud())return a;return In(Yr(Yr((Bn(),new Zr),a),b).a)}function QBb(a,b){if(!b.Ud()){a.a+=" * @template ";Lc(new Pc(","),a,$t(Wt(b,new bCb)));a.a+=gMc}}function CB(b,c){if(c!=null)try{c.__java$exception=b}catch(a){a=fZ(a);if(!pF(a,36))throw gZ(a);}}function Rub(a){Lub();this.a=a.a;this.b=new Cwc;this.e=a.c;this.d=a.b;this.f=(new _ub(this),null)}function V2b(a){var b;for(b=0;b<a.length;b++)if(a.charCodeAt(b)!=32)return a.substr(b);return a}function Lw(a){var b,c,d;b=1;for(d=
a.Vd();d.Id();){c=d.Jd();b=31*b+(c==null?0:Db(c));b=~~b}return b}function Xbb(a,b){var c,d;for(d=b.b.Vd();d.Id();){c=d.Jd();if(!a.b.Sd(c))return false}return true}function tdb(a,b){var c;Ld(V8b(a),a);Ld(b.n==(Afc(),Ycc),b);c=b.c;return c.n==ffc?vdb(a,b):udb(a,b)}function blb(a,b){var c;switch(b.n.f){case 148:alb(a,b);break;default:for(c=b.c;c;c=c.f)blb(a,c)}}function l0(a){var b,c;b0((Afc(),Rec),a);c=C8b(a);(c<1||c>2)&&D0(VMc+c,a);for(b=a.c;b;b=b.f)s0(b)}function xNb(a){while(OMb(a,(fOb(),TNb))){!a.o?
mOb(a.j):GMb(a);OMb(a,dOb)&&(!a.o?mOb(a.j):GMb(a))}}function iib(a,b,c,d){eib(a,aib(a,d,"yieldAll",CE(xE(HU,1),IMc,7,0,[b,mib(c,d)])));a.r.a.j.e=false}function oFb(a,b,c,d,e){var f;f=a.b.c.Lh(a.a,b,c,d,e);if(f!=null)return new qFb(a.b,f);return null}function bnb(a){var b,c,d,e,f;b=0;for(d=a.a,e=0,f=d.length;e<f;++e){c=d[e];b+=c.d.a.length}return b}function wZ(a){var b,c,d,e;e=a;d=0;if(e<0){e+=wMc;d=tMc}c=vF(e/vMc);b=vF(e-c*vMc);return HE(b,c,d)}function AQb(a,b){var c,d;d=a.Ud()?(c=erc(FR),new TCc(c,
nKc(c,c.length),0)):KCc(a);Rc(d,b);return d}function u9b(a,b){var c;c=S9b(a.k);c==-1&&(c=0);a.k=b<0||c<0?-1:(c&-4096)!=0?b<<12|xMc:b<<12|c&xMc}function coc(a,b){var c,d;for(d=new Rwc(a.d);d.a!=d.b;){c=Pwc(d);if(c==b)return true}return false}function t7b(a){if((a.a.a&16)==0&&(a.a.a&sQc)==0){a.a.a|=16;a.e=true;return true}else return false}function UIc(a){var b,c;c=a.b.exec(a.a);if(c!=null){b=c[0];if(Esc(b,a.a))return true}return false}function Ip(a,b){var c;if(pF(b,50)){c=b;return Gd(a.a.Ve(),c.Ve())&&
Gd(a.a.We(),c.We())}return false}function ly(a,b){var c;if(b===a)return true;if(pF(b,100)){c=b;return zb(a.re(),c.re())}return false}function kXb(a){switch(a){case 47:return false;case 92:case 91:return true;default:return!jXb(a)}}function IIc(a){if(zIc)return zE(qY,OTc,277,0,0,1);return exc(a.a,zE(qY,OTc,277,a.a.a.length,0,1))}function dq(a,b,c){var d,e;return!!b&&c!=null&&(e=Bx((d=a.c,!d?a.c=new DA(a):d),b),!!e&&Ax(e,c))}function fZ(a){var b;if(pF(a,36))return a;b=a&&a.__java$exception;if(!b){b=
new MD(a);jE(b)}return b}function Ynb(a,b){var c;c=new stc;if(a!=null){c.a+=""+a;if(b>0){c.a+=":";c.a+=b}c.a+=": "}return c.a}function nMb(a,b,c){var d,e,f;d=dKb(a.a,b);for(f=c.Vd();f.Id();){e=f.Jd();q8b(d,yKb(a.a,e))}return d}function vQb(a,b){var c,d;d=a.Ud()?(c=erc(FR),new TCc(c,nKc(c,c.length),0)):KCc(a);NCc(d,b);return d}function B4(a,b){var c;L3(a.c,"{");for(c=b.c;c;c=c.f){c!=b.c&&a.c.Yg();a.fh(c,(_4(),W4))}L3(a.c,"}")}function tz(a,b){Sd(b);pF(b,182)&&(b=Yi(b));return pF(b,35)&&b.Yd()>a.Yd()?
uu(a.Vd(),b):uz(a,b.Vd())}function CTb(a){if(AVb(a,(AZb(),oYb)))return CUb(a);if(AVb(a,bYb))return hUb(a,true);return ATb(a)}function TUb(a){var b;if(zVb(a,0,(AZb(),GYb))){iTb(a,GYb);b=nVb(a);iTb(a,LXb)}else b=aVb(a);return b}function sVb(a){var b,c;b=DWb(a.g,0).d.b;c=qVb(a);if(!AVb(a,(AZb(),EYb)))return c;return pVb(a,b,c)}function sUb(a,b,c){lwc(a.e,c);M$b(R$b(L$b(O$b(N$b(b,c.b),tTb(a)),pUb(a,0)),sTb(a)),qUb(a));wwc(a.e)}function y$b(a,b,c,d,e,f){IZb.call(this,(n1b(),d0b),a);this.d=b;this.e=c;this.a=
d;this.b=e;this.c=f}function YZb(a,b,c,d,e,f){IZb.call(this,(n1b(),M_b),a);this.d=b;this.b=c;this.e=d;this.c=e;this.a=f}function m_b(a,b,c,d,e,f){IZb.call(this,(n1b(),A0b),a);this.e=b;this.d=c;this.c=d;this.a=e;this.b=f}function gD(a,b,c,d,e,f,g,h){this.i=a;this.c=b;this.b=c;this.d=d;this.g=e;this.e=f;this.f=g;this.a=h}function K9b(a,b,c){n8b();this.n=a;this.g=null;this.k=b<0||c<0?-1:(c&-4096)!=0?b<<12|xMc:b<<12|c&xMc}function M9b(a,b,c,d){n8b();L9b.call(this,a,b);this.k=c<0||d<0?-1:(d&-4096)!=0?
c<<12|xMc:c<<12|d&xMc}function SE(a,b){var c,d,e;c=a.l+b.l;d=a.m+b.m+(c>>22);e=a.h+b.h+(d>>22);return HE(c&sMc,d&sMc,e&tMc)}function _E(a,b){var c,d,e;c=a.l-b.l;d=a.m-b.m+(c>>22);e=a.h-b.h+(d>>22);return HE(c&sMc,d&sMc,e&tMc)}function Vc(a,b){var c,d,e;c=false;for(d=a.Vd();d.Id();){e=d.Jd();if(b.Sd(e)){d.Kd();c=true}}return c}function _kb(a,b){var c,d;for(d=new wxc(N4b(b));d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);blb(a,c)}}function u1(a,b,c){var d;d=new xwb(c,b);AHc(a.c,d)&&(b==(E2(),B2)?c.g.c==
B2?++a.d:++a.e:b==D2&&++a.f)}function RZ(){RZ=JZ;QZ=new Mcb("JSC_READ_ERROR",(E2(),B2),new Rtc("Cannot read file {0}: {1}"))}function $9(){$9=JZ;Y9=new _9(GMc,0);X9=new _9("GENERATE_IJS",1);Z9=new _9("RUN_IJS_CHECKS_LATE",2)}function uD(){uD=JZ;tD=CE(xE(xF,1),eLc,46,15,[48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102])}function zTb(a){var b,c;c=DWb(a.g,0).d.b;iTb(a,(AZb(),SXb));b=ATb(a);return new KZb(new Z1b(c,a.f),b)}function Nob(a){var b,c;b=a.n.a.length;if(b>0)return $wc(a.n,b-1);else{c=twc(a.o);
return c?c.d:null}}function q5b(a,b){var c;!a.d&&(a.d=new L5b);if(a.d.n)return false;a.d.n=(bn(),c=b,mp(c));return true}function q4b(a,b){a.a|=4096;if(!d5b(a))return true;if(a.b.c!=null)return false;a.b.c=b;return true}function f4b(a){var b;if(!d5b(a))return null;!a.b.d&&(a.b.d=new fxc);b=new Q5b;Ywc(a.b.d,b);return b}function j3b(a){var b;ae(I3b(a),"Block node cannot contain %s",a.n);b=new L9b((Afc(),Vcc),a);return b}function _qc(a){var b;if(a<128){b=(brc(),arc)[a];!b&&(b=arc[a]=new Sqc(a));return b}return new Sqc(a)}
function dhc(a){var b,c;if(a.a)for(b=a.a.c;b;b=b.f){c=b.d;if(!!c&&Wfc(c))return true}return false}function nwc(a,b){if(b==null)return false;while(a.a!=a.b)if(zb(b,Pwc(a)))return true;return false}function vuc(a){if(a.a.Id())return true;if(a.a!=a.d)return false;a.a=new KDc(a.e.d);return a.a.Id()}function Zwc(a,b){var c,d;c=b._d();d=c.length;if(d==0)return false;pKc(a.a,a.a.length,c);return true}function ac(a,b){var c;for(c=b.length-1;c>=0;c--)if(!Bc(a,b.charCodeAt(c)))return false;return true}function Ohb(a){var b,
c;for(c=new Rwc(a.e);c.a!=c.b;){b=Pwc(c);if(b.b==0)return b.a;break}return null}function dnb(a){var b,c,d,e,f;f=new fDc;for(c=a.a,d=0,e=c.length;d<e;++d){b=c[d];_tc(f,b.e,b)}return f}function iTb(a,b){var c;c=wTb(a);if(c.e!=b){SVb(a,c,SSc,CE(xE(iW,1),mLc,1,5,[b]));return null}return c}function Y6b(a,b){if(!((a.a.a&JLc)!=0||R4b(a.a))&&q5b(a.a,b)){a.e=true;return true}else return false}function J6b(a){if((a.a.a&sQc)==0&&(a.a.a&16)==0){a.a.a|=sQc;a.e=true;return true}else return false}function Sqb(a){ppb();
switch(a.n.f){case 91:case 86:case 87:case 98:return true;default:return false}}function Ql(b,c){Sd(b);try{return b.Sd(c)}catch(a){a=fZ(a);if(pF(a,42))return false;else throw gZ(a);}}function yg(a,b,c){var d;return d=tF(b)?Ytc(a,b):Hg(EDc(a.d,b)),d!=null?d:tF(b)?_tc(a,b,c):FDc(a.d,b,c)}function Xpc(a){if(a.e)return _kc(a.i,57);else if(a.f)return a.b?_kc(a.i,11):_kc(a.i,51);return null}function xx(a,b){var c;if(a===b)return true;else if(pF(b,51)){c=b;return qz(po(a),c.He())}return false}function vwc(a){var b;
b=a.a[a.b];if(b==null)return null;a.a[a.b]=null;a.b=a.b+1&a.a.length-1;return b}function P0(a){if(!a.g)throw gZ(new Irc('Property "fullClassNameNode" has not been set'));return a.g}function ccc(a,b){if(null==b)throw gZ(new qnb("TemplateLiteralSubstringNode: raw str is null"));a.b=b}function XIb(a,b,c,d,e,f,g,h){this.d=a;this.g=b;this.c=c;this.f=d;this.a=e;this.i=f;this.b=g;this.e=h}function KGc(a,b,c,d,e,f){var g;this.c=a;g=new fxc;mGc(a,g,b,a.b,c,d,e,f);this.a=new Muc(g,g.a.length)}function pib(a){var b;
this.g=a;this.f=new fxc;this.c=a.d++;this.a=F9b((b=new J9b((Afc(),Vcc)),b),a.r.e)}function vKb(a,b,c){var d,e;if(T9b(a.k)==-1){e=b.b+1;u9b(a,e);d=b.a;a.k=$9b(T9b(a.k),d);t9b(a,c.c-b.c)}}function NC(a,b,c,d){var e,f;Xd(b>=0);Xd(c>=0);a.f=new _B(b,c);e=new iC;f=qD(d);eC(e,f);hC(e,new TC(a))}function Wtc(a,b,c){var d,e;for(e=c.Vd();e.Id();){d=e.Jd();if(a.rj(b,d.We()))return true}return false}function Eyc(a){Cyc();var b,c,d;d=0;for(c=a.Vd();c.Id();){b=c.Jd();d=d+(b!=null?Db(b):0);d=d|0}return d}function KCc(a){var b,
c,d,e;!a.Ud();d=a.Vd();c=d.Jd();e=LCc(c);while(d.Id()){b=d.Jd();NCc(e,b)}return e}function CE(a,b,c,d,e){e.Fj=a;e.Gj=b;e.Hj=OZ;e.__elementTypeId$=c;e.__elementTypeCategory$=d;return e}function KMb(a,b,c,d){if(b==(fOb(),RNb)||b==TNb||b==SNb)return new FNb("",b);return JMb(a,b,c,true,d)}function jVb(a){var b,c;c=DWb(a.g,0).d.b;iTb(a,(AZb(),aZb));b=KTb(a,1);return new w1b(new Z1b(c,a.f),b)}function A_(a){var b,c;b0((Afc(),vdc),a);for(b=a.c;b;b=b.f){b0(cfc,b);g0(b);c=C8b(b);0!=c&&D0(OMc+c,b)}}function Te(a,
b){var c,d;Sd(b);c=a.c.je(a,b);d=new fxc;while(Pb(c))Ywc(d,Qb(c));return Cyc(),new gBc(d)}function Ug(a,b){var c,d;c=a.a.Ke(b);if(!c)return null;d=a.b.ye();d.Qd(c);a.b.d-=c.Yd();c.Rd();return d}function lmb(a,b){hmb();var c;if(H6(a).Ig(b))return true;c=b.c;return c.n==(Afc(),rec)&&gmb.Sd(c.Wh())}function Xqb(a,b,c){ppb();var d;d=Wqb(a,b);drb(d,c);Esc(DMc,H8b(d,(Hbc(),sbc)))||d9b(d,sbc,DMc);return d}function xqb(a){ppb();switch(a.n.f){case 29:case 26:case 91:case 27:return yqb(a);default:return false}}
function VSb(a){OSb();switch(a.f){case 109:case 108:case 110:case 111:return true;default:return false}}function X8b(a){switch(a.n.f){case 29:case 26:case 27:case 93:case 94:return true;default:return false}}function Qrc(a){var b;if(a<0)return hMc;else if(a==0)return 0;else{for(b=$Lc;(b&a)==0;b>>=1);return b}}function XE(a){var b,c,d;b=~a.l+1&sMc;c=~a.m+(b==0?1:0)&sMc;d=~a.h+(b==0&&c==0?1:0)&tMc;return HE(b,c,d)}function NE(a){var b,c,d;b=~a.l+1&sMc;c=~a.m+(b==0?1:0)&sMc;d=~a.h+(b==0&&c==0?1:0)&tMc;
a.l=b;a.m=c;a.h=d}function OE(a){var b,c;c=Trc(a.h);if(c==32){b=Trc(a.m);return b==32?Trc(a.l)+32:b+20-10}else return c-12}function Z2b(a){X2b();var b;b=Y2b(W2b,a);if(b!=null)return b;throw gZ(new GD("Resource not found: "+a));}function Wgb(){Wgb=JZ;Ugb=new Xgb("REWRITE_ALL_OBJECT_PATTERNS",0);Vgb=new Xgb("REWRITE_OBJECT_REST",1)}function kvb(){kvb=JZ;jvb=new Mcb("JSC_JSON_UNEXPECTED_TOKEN",(E2(),B2),new Rtc("Unexpected JSON token"))}function P2(){P2=JZ;O2=new Mcb("JSC_MISSING_PROVIDE",(E2(),D2),
new Rtc("missing goog.provide(''{0}'')"))}function t1(a,b){return DJc(FJc(EJc(new KJc(null,new BFc(a.c)),new Fwb(b)),new Hwb),(Bn(),Nk(),Nk(),Mk))}function eq(a,b,c){var d,e;return!b||c==null?null:(e=Bx((d=a.c,!d?a.c=new DA(a):d),b),!e?null:Bx(e,c))}function yMb(a,b,c){var d;a.c.Bh("Missing type declaration.",(d=H8b(a.n,(Hbc(),ybc)),!d?null:d.ug()),b,c)}function Ejb(a,b,c){var d,e;for(e=new wxc(Bpb(c));e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);Fjb(a,b,d)}}function c9b(a,b,c){var d;d=i9b(a,a.j,b.f<<
24>>24);d!=a.j&&(a.j=d);c!=0&&(a.j=new oac(b.f<<24>>24,c,a.j))}function XUb(a,b){var c,d;d=DWb(a.g,0).d.b;iTb(a,(AZb(),aZb));c=cVb(a,b);return new PZb(new Z1b(d,a.f),c)}function NUb(a){var b;b=(Bn(),new Zr);while(!AVb(a,(AZb(),KXb))&&!AVb(a,XXb))Xr(b,dVb(a));return In(b.a)}function XJb(a,b){var c;if(b){c=TJb(a,b);jDc(a.k,b);if(!ZJb(a,c))return pKb(a,b.a,k6b(c.f))}return null}function qGc(a,b,c){var d,e;d=new XGc(b,c);e=new YGc;a.b=oGc(a,a.b,d,e);e.b||++a.c;a.b.b=false;return e.d}function ZDc(a,b,
c){var d;d=a.a.get(b);a.a.set(b,c===undefined?null:c);d===undefined?++a.b:++a.c;return d}function Dyc(a,b){Cyc();var c,d,e,f,g;g=false;for(d=b,e=0,f=d.length;e<f;++e){c=d[e];g=g|a.Pd(c)}return g}function wQb(a,b){iQb();var c,d;d=a.Ud()?(c=erc(FR),new TCc(c,nKc(c,c.length),0)):KCc(a);hh(d,b);return d}function Kc(a,b,c){Sd(b);if(c.Id()){ltc(b,Oc(c.Jd()));while(c.Id()){ltc(b,a.a);ltc(b,Oc(c.Jd()))}}return b}function Sr(a){oo();var b,c;for(c=Sd(a).He().Vd();c.Id();){b=c.Jd();Sd(b.Ve());Sd(b.We())}return new Rr(a)}
function Nj(a){var b,c;b=a.b.We();if(!b||b.a==0){c=Xtc(a.a.a.a,a.b.Ve());if(c)return c.a}return!b?0:b.a}function Ut(a){var b;if(pF(a,54)){b=a;if(b.Ud())throw gZ(new jFc);return b.ce(b.Yd()-1)}return ru(a.Vd())}function dC(a,b){var c;do{if(b==0)return null;--b}while($wc(a.c,b)==null);c=$wc(a.c,b);return cC(a,Ut(c))}function d_(a,b){var c;return q3b((c=(ae(Hsc(a,_sc(46))==-1,HMc,a),n8b(),new Wbc((Afc(),rec),a)),c),b,gdc)}function _db(a){Xdb();var b;this.b=a;b=new mDc;this.c=new okb(a,new j8(a),b,new wwb(new J9b((Afc(),
Xec))))}function f7(a){var b,c,d;d=new gxc;for(c=xu(new Guc(a.a));c.Id();){b=c.Jd();Ywc(d,new I8(b,true))}return d}function KE(a,b,c,d,e){var f;f=ZE(a,b);c&&NE(f);if(e){a=ME(a,b);d?EE=XE(a):EE=HE(a.l,a.m,a.h)}return f}function Gmb(a,b,c,d,e,f,g){this.g=e;this.e=b;this.c=Qtc(e.a,g);this.d=c;this.a=d;this.f=a;this.b=!f?e.c:f}function Awc(a,b){var c,d;c=a.a.length-1;while(b!=a.b){d=b-1&c;a.a[b]=a.a[d];b=d}a.a[a.b]=null;a.b=a.b+1&c}function zwc(a,b){var c,d;c=a.a.length-1;a.c=a.c-1&c;while(b!=a.c){d=
b+1&c;a.a[b]=a.a[d];b=d}a.a[a.c]=null}function Hyc(a){var d;Cyc();var b,c;for(c=0,b=a.a.length-1;c<b;++c,--b){d=a.a[c];cxc(a,c,a.a[b]);a.a[b]=d}}function Fyc(a){Cyc();var b,c,d;d=1;for(c=a.Vd();c.Id();){b=c.Jd();d=31*d+(b!=null?Db(b):0);d=d|0}return d}function XB(){XB=JZ;var a;WB=zE(yF,iMc,46,256,15,1);Ixc(WB);for(a=0;a<64;a++)WB[bMc.charCodeAt(a)]=a}function TZ(){TZ=JZ;bn();pp(CE(xE(iW,1),mLc,1,5,["xterm","xterm-color","xterm-256color","screen-bce"]))}function yab(){uab();return CE(xE(JL,1),sLc,
89,0,[gab,hab,iab,kab,jab,lab,mab,nab,oab,pab,rab,qab,tab])}function Iob(a,b,c){if(!c)return"  "+b+": NULL";return"  "+b+"("+D9b(c,false,false,false)+"): "+Job(a,c)}function Od(a,b){if(!a)throw gZ(new qnb(rf("too many occurrences: %s",CE(xE(iW,1),mLc,1,5,[isc(b)]))));}function qB(a,b){this.b=Sd(a);Pd(!b||!jB(a,b.a),"Padding character %s was already in alphabet",b);this.c=b}function Xkc(a,b,c){!b&&(b=(Bn(),Bn(),An));!c&&(c=(Bn(),Bn(),An));return b.Ud()&&c.Ud()?a.g:new $nc(a,b,c)}function EVb(a){switch(DWb(a.g,
0).e.f){case 59:case 60:case 61:case 62:return true;default:return false}}function WVb(a,b){switch(b.p.f){case 28:case 29:a.f=b.o.b,NWb(a.g,a.f.c);return UUb(a,1);default:return b}}function qLb(a,b){var c,d;d=dKb(a.a,(Afc(),Xcc));if((!b.a?null:b.a.a)!=null){c=mMb(a,b.a);q8b(d,c)}return d}function tLb(a,b){var c,d;d=dKb(a.a,(Afc(),hdc));if((!b.a?null:b.a.a)!=null){c=mMb(a,b.a);q8b(d,c)}return d}function BGb(a){var b;b=new fxc;lQb(l9(a.a),(IRb(),iRb))||(Fyb(),Ywc(b,tyb));Hyb(b,a.a);Gyb(b,a.a);return b}
function cnb(a){var b,c,d,e;for(c=a.a,d=0,e=c.length;d<e;++d){b=c[d];if(Esc(b.e,gOc))return b}return null}function _b(a,b,c){var d,e;e=b.length;Vd(c,e);for(d=c;d<e;d++)if(mc(a,b.charCodeAt(d)))return d;return-1}function kGc(a,b){var c,d,e;e=a.b;while(e){c=a.a.lf(b,e.d);if(c==0)return e;d=c<0?0:1;e=e.a[d]}return null}function Wf(a,b){var c,d;c=a.c.Ke(b);if(!c)return a.Ae();d=a.ye();d.Qd(c);a.d-=c.Yd();c.Rd();return a.Be(d)}function bic(a,b){var c;c=a.d.hi(b);return c.ti()||c.ri()||c.si()||c==c.A.u[64]?
null:new cic(a.A,c,a.b,a.a)}function ZKb(a){var b;if(!a)return false;b=a.n;return b==(Afc(),Ddc)&&a.c.n==bfc&&Yz((RJb(),NJb),a.c.Wh())}function g4b(a){!a.d&&(a.d=new L5b);!a.d.q?a.d.q=(bn(),new Zz(YOc)):a.d.q=Qs(new Rs,a.d.q).Nf(YOc).Pf()}function tfb(a){jfb();this.c=new fq(new tEc,new iq);this.b=new mDc;this.e=new mDc;this.a=a;this.f=new j8(a)}function ODb(a,b,c,d,e,f,g,h){MDb();this.d=a;this.e=b;this.f=c;this.g=d;this.i=e;this.c=f;this.a=g;this.b=h}function vv(a,b,c){var d,e;this.g=a;this.c=b;this.a=
this;this.d=this;e=Gr(c);d=zE(xI,PLc,249,e,0,1);this.b=d}function k_(a,b){var c,d;b0((Afc(),zcc),b);for(c=b.c;c;c=c.f)c.n==tdc?(d=C8b(c),0!=d&&D0(OMc+d,c)):E_(a,c)}function T$(a){var b,c;b=a_(Se(Ze(),"$jscomp.arrayFromIterator"));return c=Tqb(b,CE(xE(HU,1),IMc,7,0,[a])),c}function R$(a){var b,c;b=a_(Se(Ze(),"$jscomp.makeAsyncIterator"));return c=Tqb(b,CE(xE(HU,1),IMc,7,0,[a])),c}function Xjb(a,b){Rjb();return C6(a,APc+Xsc(BPc,(bFc(),_Ec)),false),l3b(Wqb(a,JMc),CE(xE(HU,1),IMc,7,0,[b]))}function imc(a){Ofc();
Mjc.call(this,a,null,new ghc(a,null,null),null,(dkc(),akc));this.b.b=this;this.k=this}function Iib(a){Hib();Ld(a.n==(Afc(),Xec),a);if(E8b(a,(n8b(),Z7b))!=0)return false;return!!a.c&&a.c.n==pec}function Rib(a,b){Xd(b.n==(Afc(),Vdc));if(b.c.f.n==Ydc)return b.c.f.Wh();return Sib(a,(b.c?b.c.i:null).Wh())}function Q6(a,b){var c;if(b!=null){c=OHc(a.u,new _3b(b));if(c)return c.a.sh();return OHc(a.M,b)}return null}function iZ(a,b){var c;if(pZ(a)&&pZ(b)){c=a-b;if(!isNaN(c))return c}return UE(pZ(a)?wZ(a):a,
pZ(b)?wZ(b):b)}function ehc(a){var b,c;if(a.a)for(b=a.a.c;b;b=b.f){c=b.d;if(!c||c.Bi())return true}return!a.b||a.b.Bi()}function z6b(a,b){if(!!b&&!T4b(a.a)&&(a.a.a&4)==0&&s7b(a,b)){a.a.a|=4;a.e=true;return true}else return false}function W8b(a){switch(a.n.f){case 29:return a.Wh().length!=0;case 26:return W8b(a.c);default:return false}}function Fmb(a,b,c){switch(b.f){case 0:return Tnb(c,a,false);case 1:return Tnb(c,a,true);default:return null}}function s$(a){q$();switch(a){case BMc:return n$;case DMc:return o$;
case FMc:return p$;default:return null}}function Mpb(a){ppb();while(!!a&&a.n!=(Afc(),Xec))a=a.g;return!!a&&a.n==(Afc(),Xec)?H8b(a,(Hbc(),cbc)):null}function pLb(a,b){var c,d,e;e=dKb(a.a,(Afc(),Vcc));for(d=b.a.Vd();d.Id();){c=d.Jd();q8b(e,yKb(a.a,c))}return e}function eob(a,b){var c,d,e;for(e=new Rwc(a.b);e.a!=e.b;){d=Pwc(e);c=d.Fh(b);if(c!=null)return c}return null}function P4(a,b){var c,d;d=0;c=a.c;for(;!!c&&d<b;c=c.f)c.n==(Afc(),Vcc)?d+=P4(c,b-d):c.n==tdc||++d;return d}function vjc(a){var b,c;c=
a.b.a;if(c){b=c.c?c.c.i:null;if(!b||E8b(b,(Hbc(),Ebc))==0)return C8b(c)}return _Kc}function eXb(a){var b;b=false;while(xWb(a,a.f)&&nXb(xWb(a,a.f)?zsc(a.b,a.f):0))jXb(yWb(a))&&(b=true);return b}function T_(a){var b;b=false;b=!(!!a.c&&!!a.c.f);b||D0("Expected no more than 1 children, but was "+C8b(a),a)}function g4(a){return a==95||a==36||(Qqc==null&&(Qqc=new RegExp(hLc,"i")),Qqc.test(String.fromCharCode(a)))}function xDb(a){wDb();return DJc(FJc(a?new KJc(null,a.Zd()):new KJc(null,a.Zd()),new FEb),
(Bn(),Nk(),Nk(),Mk))}function $d(a,b,c){if(!a)throw gZ(new Irc(rf("line=%s, lineCount=%s",CE(xE(iW,1),mLc,1,5,[Yrc(b),Yrc(c)]))));}function pKb(a,b,c){if(!!c&&(c.a&HPc)!=0){a.i=true;Esc(nQb(a.e),"ts")&&a.d.Ah(ZQc,a.q,b.b.b+1,b.b.a)}return c}function D5(a,b){var c;if(a.o==0&&a.u!=a.v+1)for(c=0;c<a.a;c++){ptc(a.j,"  ");a.o+=2}ptc(a.j,b);a.o+=b.length}function YA(a,b){var c;if(b===a)return true;else if(pF(b,647)){c=b;return gh(a.af(),c.af())}else return false}function qsb(a){var b;Xd(a.n==(Afc(),Xec));
b=H8b(a,(Hbc(),ybc));if(pF(b,189))return Qwb(b),b.d.length;return 0}function e$(a){var b;b=a;while(b){if(b.d.n==(Afc(),Jdc)||pqb(b.d)||!b.b||b.d.n==pec)return b;b=b.b}return null}function LOb(a){var b,c,d,e;for(c=QPb(),d=0,e=c.length;d<e;++d){b=c[d];if(Esc(b.d,a))return true}return false}function Kfc(a){var b,c;c=a.Vd();b=K3b(c.Jd());while(c.Id())b=x3b(b,V3b(c.Jd()));return new kcc((Afc(),sec),b)}function Xpb(a){ppb();var b,c;c=null;while(c==null&&!!a){c=(b=H8b(a,(Hbc(),ybc)),!b?null:b.ug());a=a.g}return c}
function zMb(a,b,c,d){var e;a.c.Bh(occ(b,CE(xE(iW,1),mLc,1,5,[])),(e=H8b(a.n,(Hbc(),ybc)),!e?null:e.ug()),c,d)}function bGb(a,b,c,d,e){XFb();kEb.call(this,a,b,d,e);this.b=cGb(a,b);!c?this.c=(oo(),oo(),no):this.c=YFb(c)}function hrc(){this.k=crc++;this.p=null;this.n=null;this.j=null;this.d=null;this.b=null;this.o=null;this.a=null}function MD(a){KD();AB(this);BB(this);this.e=a;CB(this,a);this.g=a==null?jLc:NZ(a);this.a="";this.b=a;this.a=""}function Bb(a){return tF(a)?nW:rF(a)?WV:qF(a)?TV:oF(a)?a.Fj:
BE(a)?a.Fj:a.Fj||Array.isArray(a)&&xE(BK,1)||BK}function oTb(a,b){var c;c=jTb(a);if(!c||!Esc(c.a,b)){SVb(a,c,SSc,CE(xE(iW,1),mLc,1,5,[b]));return null}return c}function Qu(a){var b;while(!a.d||!a.d.Id())if(!!a.b&&!swc(a.b))a.d=(b=vwc(a.b),b);else return null;return a.d}function mwb(a,b){var c,d;for(d=po(a.b).Vd();d.Id();){c=d.Jd();if(UIc(WIc(c.Ve(),b)))return c.We()}return null}function u7(a,b){var c,d;c=b.b;if(a.S){d=nbb(a.S,b);!!d&&(c=d)}if(c!=(E2(),C2)){!a.G&&_6(a,new v9);Xxb(a.g,c,b)}}function Kfb(a,
b){var c,d;d=F9b(F3b(a.a),b);c=F9b((Xd(d.n==(Afc(),fec)),new L9b(Xcc,d)),b);j9b(b.g,b,c);a.d=true}function $Lb(a,b){var c;Kd(b.e==(AZb(),gZb));c=iKb(a.a,(Afc(),bfc),nKb(a.a,b,false));vKb(c,b.d.b,b.d.a);return c}function Ibb(a,b){var c,d;d=zE(WL,mLc,326,b.length,0,1);for(c=0;c<b.length;c++)d[c]=Xtc(a.e,_qc(b[c]));return d}function d9b(a,b,c){var d;d=i9b(a,a.j,b.f<<24>>24);d!=a.j&&(a.j=d);c!=null&&(a.j=new yac(b.f<<24>>24,c,a.j))}function STb(a){var b,c;c=DWb(a.g,0).d.b;iTb(a,(AZb(),FYb));b=iVb(a);
iTb(a,KXb);return new SZb(new Z1b(c,a.f),b)}function qUb(a){var b,c;c=DWb(a.g,0).d.b;iTb(a,(AZb(),FYb));b=iVb(a);iTb(a,KXb);return new SZb(new Z1b(c,a.f),b)}function lTb(a){var b;b=DWb(a.g,0);switch(b.e.f){case 101:case 100:return wTb(a);case 2:default:return kTb(a)}}function wD(b,c){uD();var d;try{vD(c,b)}catch(a){a=fZ(a);if(pF(a,104)){d=a;throw gZ(new ID(d));}else throw gZ(a);}}function Zkc(a,b){var c,d,e,f,g;c=new $pc(a,false);for(e=b,f=0,g=e.length;f<g;++f){d=e[f];Upc(c,d)}return Vpc(c)}function Pxc(a){var b,
c,d,e,f;f=1;for(c=a,d=0,e=c.length;d<e;++d){b=c[d];f=31*f+(b!=null?Db(b):0);f=f|0}return f}function je(a){var b,c,d,e,f;b={};for(d=a,e=0,f=d.length;e<f;++e){c=d[e];b[":"+(c.e!=null?c.e:""+c.f)]=c}return b}function fs(a,b){var c;if(pF(b,75)){Sd(b.Ve());Sd(b.We());c=b;Ywc(a.b,c)}else Ywc(a.b,zo(b.Ve(),b.We()));return a}function Xob(a,b){var c;c=b.Yf();!!a.i&&(c=b.Yf()+gMc+Iob(a,"Node",a.e)+(!a.e?"":Iob(a,"Parent",a.e.g)));C7(c,b)}function kCc(a){var b;this.a=(b=a.e&&a.e(),new TCc(b,nKc(b,b.length),
0));this.b=zE(iW,mLc,1,this.a.a.length,5,1)}function hv(){ev.call(this,(wx(16),new uEc));fl(2,aMc);this.b=2;this.a=new pv(null,null,0,null);nv(this.a,this.a)}function cxb(a,b,c){Uwb.call(this,a,c);this.a=b!=null&&Esc(b.substr(0,cRc.length),cRc)?b.substr(1):b;this.d=null}function x_(a,b,c){var d,e;e=Cfc(c.n);e!=-1&&(d=C8b(c),e!=d&&D0(QMc+e+RMc+d,c));R_(a,b,c.c);E_(a,c.c?c.c.i:null)}function ufb(a,b,c){jfb();var d,e;e=H8b(a,(Hbc(),mbc));if(!e){e=H8b(b,mbc);d9b(b,mbc,null)}d=E7b(e);q9b(c,k6b(d))}function uTb(a,
b,c){b==(AZb(),PXb)?VVb(a,TSc,CE(xE(iW,1),mLc,1,5,[])):GZb(c)&&VVb(a,USc,CE(xE(iW,1),mLc,1,5,[]))}function IJc(a){var b,c;mJc(a);b=(HBc(),HBc(),FBc);return mJc(a),c=new OJc(a,a.a.ff(),a.a.ef()|4,b),new KJc(a,c)}function nqb(a){ppb();if(a.n!=(Afc(),mec))return false;return a.g.n==cdc&&E8b(a,(Hbc(),zbc))==0&&Esc(a.Wh(),LMc)}function Ktb(a,b){Itb();if(!a||b!=(NFb(),MFb))return false;if(a.n==(Afc(),Jdc)&&Ntb(a))return true;return false}function wqb(a){ppb();var b,c,d;d=a.length;for(c=0;c<d;c++){b=a.charCodeAt(c);
if(b>127)return false}return true}function CDc(a,b,c){var d,e,f,g;for(e=c,f=0,g=e.length;f<g;++f){d=e[f];if(a.b.rj(b,d.Ve()))return d}return null}function Cx(b,c){Sd(b);try{return b.Ke(c)}catch(a){a=fZ(a);if(pF(a,1038)||pF(a,42))return null;else throw gZ(a);}}function Bx(b,c){Sd(b);try{return b.Ie(c)}catch(a){a=fZ(a);if(pF(a,1038)||pF(a,42))return null;else throw gZ(a);}}function Rl(b,c){Sd(b);try{return b.Wd(c)}catch(a){a=fZ(a);if(pF(a,1038)||pF(a,42))return false;else throw gZ(a);}}function Ax(b,
c){Sd(b);try{return b.se(c)}catch(a){a=fZ(a);if(pF(a,1038)||pF(a,42))return false;else throw gZ(a);}}function cA(a){var b;if(!a.a.Id()){a.b=REc(a.c);a.a=a.b.e.He().Vd()}b=a.a.Jd();return new aB(a.b.d,b.Ve(),b.We())}function iA(a){if(!!(!a.a||a.a.Ud()&&oEc(a.c.a,a.b)?a.a=pEc(a.c.a,a.b):a.a)&&a.a.Ud()){sEc(a.c.a,a.b);a.a=null}}function Ehb(a){Xd(duc(a.n)==0);Xd(swc(a.c));Xd(swc(a.i));Xd(swc(a.e));Xd(swc(a.k));Xd(a.o==0);Xd(a.a.a.length==0)}function vub(a){tub();Sd(a);this.a=a.b;this.b=new Cwc;kwc(this.b,
new Eub(this));this.d=a.d;this.c=Sd(a.c);Sd(a.a)}function ojb(a){fjb();this.c=a;this.a=null;this.b=null;this.d=null;this.f=null;this.g=null;this.i=null;this.e=null}function op(a){bn();Sd(a);switch(a.length){case 0:return mz(),lz;case 1:return new Zz(a[0]);default:return pp(a)}}function NKb(a){switch(a.n.f){case 72:case 73:case 101:case 102:case 70:case 71:return true;default:return false}}function mib(a,b){var c;if(a.d)return mib(a.d,b);c=F9b(Yjb((n8b(),new tac(a.c)),a.g.r.f.e),b);Ywc(a.f,c);return c}
function zLb(a,b){var c;c=gKb(a.a,(Afc(),Fdc),qMb(a,b.d,b),qMb(a,b.b,b),qMb(a,b.c,b));q8b(c,zKb(a.a,b.a));return c}function g_(a){var b;b=g3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc((Afc(),rec),"")),new J9b(Jec),a);return b}function lUb(a,b,c){var d,e;iTb(a,(AZb(),mYb));e=xTb(a,1);iTb(a,LXb);d=hVb(a);return new D$b(new Z1b(b,a.f),c,e,d)}function BMb(a,b,c,d,e){var f;a.c.Bh(occ(b,CE(xE(iW,1),mLc,1,5,[c])),(f=H8b(a.n,(Hbc(),ybc)),!f?null:f.ug()),d,e)}function Rxc(a,b,c,d,e,f,g,h){var i;i=c;while(f<
g)i>=d||b<c&&h.lf(a[b],a[i])<=0?e[f++]=a[b++]:e[f++]=a[i++]}function Pfc(a,b,c){c&&a.xi()&&!a.Bi()&&!a.Ki()&&!a.Ji()&&!a.Ii()&&!a.Mi()&&!_fc(a)&&(b.a+="!",b);return a.di(b,c)}function skc(a,b,c){if(uF(b)===uF(c))return Hkc(),Ekc;return!a.a&&(a.a=new fDc),yg(a.a,new vkc(b,c),(Hkc(),Gkc))}function hZ(a,b){var c;if(pZ(a)&&pZ(b)){c=a+b;if(yMc<c&&c<wMc)return c}return jZ(SE(pZ(a)?wZ(a):a,pZ(b)?wZ(b):b))}function rZ(a,b){var c;if(pZ(a)&&pZ(b)){c=a*b;if(yMc<c&&c<wMc)return c}return jZ(WE(pZ(a)?wZ(a):a,pZ(b)?
wZ(b):b))}function vZ(a,b){var c;if(pZ(a)&&pZ(b)){c=a-b;if(yMc<c&&c<wMc)return c}return jZ(_E(pZ(a)?wZ(a):a,pZ(b)?wZ(b):b))}function y0(a,b){var c,d;F_(a,(IRb(),FRb),b);b0((Afc(),qfc),b);d=Cfc(b.n);d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b))}function t4(a,b){var c,d;c=false;for(d=b;d;d=d.f){d!=b&&a.c.Yg();v4(a,d,1,(_4(),W4));c=d.n==(Afc(),tdc)}c&&a.c.Yg()}function dB(b,c){var d;try{return eB(b,c)}catch(a){a=fZ(a);if(pF(a,204)){d=a;throw gZ(new snb(d));}else throw gZ(a);}}function qMb(a,b,c){var d;if(!b){d=
dKb(a.a,(Afc(),tdc));T9b(d.k)==-1&&vKb(d,c.o.b,c.o.a);return d}return yKb(a.a,b)}function Vsb(a,b,c){var d;if(a.f.q&&a.b){d=100*($wnd.Math.abs(c-b)/b);d<.05?++a.a:a.a=0;return a.a<2}return true}function b7b(a){if(!((a.a.a&JLc)!=0||R4b(a.a))&&(a.a.a&JLc)==0){a.a.a|=JLc;a.e=true;return true}else return false}function HMb(a,b){do{if(b==(fOb(),TNb)||b==RNb||b==SNb){a.i=(JNb(),HNb);return b}b=!a.o?mOb(a.j):GMb(a)}while(true)}function bib(a,b,c){if(!c)return Chb(a,b,ENc,CE(xE(HU,1),IMc,7,0,[]));return Chb(a,
b,ENc,CE(xE(HU,1),IMc,7,0,[c]))}function kUb(a,b,c){var d,e;oTb(a,"of");e=xTb(a,1);iTb(a,(AZb(),LXb));d=hVb(a);return new C$b(new Z1b(b,a.f),c,e,d)}function mUb(a,b,c){var d,e;oTb(a,"of");e=xTb(a,1);iTb(a,(AZb(),LXb));d=hVb(a);return new E$b(new Z1b(b,a.f),c,e,d)}function b9b(a,b,c){var d;d=i9b(a,a.j,b.f<<24>>24);d!=a.j&&(a.j=d);(c?1:0)!=0&&(a.j=new oac(b.f<<24>>24,c?1:0,a.j))}function Vfc(a){var b,c,d;b=(bn(),new Rs);for(d=a.B.c.Vd();d.Id();){c=d.Jd();Ywc(b.b,Sd(c))}return np(new wxc(b.b))}function jlc(a,
b,c){var d;mlc(c)&&(c=(!a.C&&(a.C=(d=new Vic(a),d.s=true,d)),a.C));Vf(a.D,b,c);Lkc(a,b,c);buc(a.j,b)}function Pwc(a){var b;HKc(a.a!=a.b);b=a.d.a[a.a];Gwc(a.b==a.d.c&&b!=null);a.c=a.a;a.a=a.a+1&a.d.a.length-1;return b}function nu(a,b){var c;Sd(a);Ld(b>=0,"numberToAdvance must be nonnegative");for(c=0;c<b&&Pb(a);c++)Qb(a);return c}function H9b(a,b){if(!H8b(a,(Hbc(),ybc))){z9b(a,b);a.k=b.k;a.e=b.e}H8b(a,sbc)==null&&d9b(a,sbc,H8b(b,sbc));return a}function jLb(a,b){var c,d,e,f;f=dKb(a.a,(Afc(),zcc));for(e=
b.a.Vd();e.Id();){d=e.Jd();c=yKb(a.a,d);q8b(f,c)}return f}function _fb(a,b){var c,d,e;e=Ppb(b);d=(ppb(),Gpb(b,new frb((Afc(),Jdc))));if(!d)return;c=new kgb(a,e);epb(a.a,d,c)}function L8b(a){var b,c;b=H8b(a,(Hbc(),ybc));if(!b)return-1;c=T9b(a.k);if(c==-1)return-1;return b.Jh(c)+S9b(a.k)}function i9b(a,b,c){var d;if(!b)return null;else if(b.c==c)return b.b;else{d=i9b(a,b.b,c);return d!=b.b?b.ai(d):b}}function Fqb(a){ppb();var b;if(a.n!=(Afc(),Pdc))return false;b=a.c;return b.n==Pdc&&Esc((b.c?b.c.i:
null).Wh(),aNc)}function D0(a,b){throw gZ(new Irc(a+". Reference node:\n"+E9b(b)+"\n Parent node:\n"+(b.g?E9b(b.g):" no parent ")));}function l2b(a){if(rF(a.a))throw gZ(new GD("Double.toHexString is outside the GWT subset"));else throw gZ(g2b(a));}function r8(b){var c;try{return b.kh()}catch(a){a=fZ(a);if(pF(a,36)){c=a;tf(c);throw gZ(new ID(c));}else throw gZ(a);}}function k6b(a){var b;if(a.e){Xd(!!a.a);b=a.a;a.a=null;!b.j&&y5b(b,(e6b(),_5b));a.e=false;return b}else return null}function P$(a,b){var c,
d,e,f;f=a;for(d=cu(b);Pb(d.b);){c=gu(d);f=(e=x3b(f,(n8b(),new Wbc((Afc(),bfc),c))),e)}return f}function Stc(a,b){var c,d;for(c=0;c<b.length;c++){d="{"+c+"}";while(a.indexOf(d)!=-1)a=Osc(a,d,etc(b[c]))}return a}function F0(a,b){if(!a)throw gZ(new nsc("Null mode"));this.b=a;if(!b)throw gZ(new nsc("Null entryPoints"));this.a=b}function Ur(a){bn();switch(a.c){case 0:return mz(),lz;case 1:return new Zz(tu(new aDc(a)));default:return new Tr(a)}}function vp(a){bn();switch(a.Yd()){case 0:return mz(),lz;case 1:return new Zz(a.Vd().Jd());
default:return new nz(a)}}function g9(){g9=JZ;Wsc("ABCDEFGHIJKLMNOPQRSTUVWXYZ$");Wsc("_$");e9=(Bn(),new Wz(Sd((X2b(),new zbb))));f9=new zab}function C9(){C9=JZ;z9=new D9(GMc,0);A9=new D9("START",1);B9=new D9("START_AND_END",2);y9=new D9("EVERY_PASS",3)}function Hkc(){Hkc=JZ;Ekc=new Ikc("MATCH",0,true);Fkc=new Ikc("NOT_MATCH",1,false);Gkc=new Ikc("PROCESSING",2,true)}function IGb(){IGb=JZ;HGb=new Mcb("JSC_DUPLICATE_CASE",(E2(),D2),new Rtc("Duplicate case in a switch statement."))}function lHb(){lHb=
JZ;kHb=new Mcb("JSC_MISSING_SEMICOLON",(E2(),C2),new Rtc("Missing semicolon (fix with go/fixjs)"))}function p2(){p2=JZ;o2=new Mcb("JSC_USED_GLOBAL_THIS",(E2(),D2),new Rtc("dangerous use of the global 'this' object"))}function g3(){g3=JZ;f3=new Mcb("JSC_UNUSED_PRIVATE_PROPERTY",(E2(),C2),new Rtc("Private property {0} is never read"))}function njc(a,b,c){a.a+=HNc;c&&b.xi()&&!b.Bi()&&!b.Ki()&&!b.Ji()&&!b.Ii()&&!b.Mi()&&!_fc(b)&&(a.a+="!",a);b.di(a,c)}function TEb(a,b){var c,d;if(kDc(a.a,b))return;jDc(a.a,
b);for(d=Uf(a.d,b).Vd();d.Id();){c=d.Jd();TEb(a,c)}Ywc(a.c,b)}function i6b(a,b){var c;if(!jDc(a.c,b))return false;c=D4b(a.a);c==null&&(c="");m5b(a.a,c+(""+b));a.e=true;return true}function Oic(a,b){var c;c=F8b(a.b);if(!!c&&E8b(c,(Hbc(),Ebc))!=0)return false;c9b(Pic(a,b),(Hbc(),Ebc),1);return true}function MC(a,b){var c;if(b!=a.c){a.c=b;c=pEc(a.k,b);if(c)a.d=c.a;else{a.d=duc(a.k.c);qEc(a.k,b,Yrc(a.d))}}return a.d}function q8b(a,b){var c;Qd(!b.g,b,b.g,a);Kd(!b.f);Kd(!b.i);if(!a.c){b.i=b;a.c=b}else{c=
a.c.i;c.f=b;b.i=c;a.c.i=b}b.g=a}function uib(a,b){var c,d;Xd(b.c.n==(Afc(),fec));d=Ytc(a.c.n,b.c.Wh());if(d){c=b.n==Xcc?d.a:d.b;_hb(a.c.r.a,b,c,a.a)}}function ai(a){var b;if(a.b){ai(a.b);if(a.b.d!=a.c)throw gZ(new WBc);}else if(a.d.Ud()){b=a.f.c.Ie(a.e);!!b&&(a.d=b)}}function cD(a,b,c,d,e){Xd(a.b<=d);Xd(a.b<d||a.a<e);if(a.b==d&&a.a==e)throw gZ(new Hrc);b.dg(c,a.b,a.a,d,e);a.b=d;a.a=e}function V$(a){var b,c;Ld(a.c.Wh().length==0,a);b=(Xd(a.n==(Afc(),Jdc)),c=(n8b(),new Wbc(mec,LMc)),q8b(c,a),c);return b}
function N$(a,b){var c,d,e;c=(e=(ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc((Afc(),rec),"")),e);d=v3b(c,a,b);return d}function XLb(a,b){var c,d,e;e=new jcc((Afc(),Qec));for(d=b.a.Vd();d.Id();){c=d.Jd();q8b(e,yKb(a.a,c))}return SJb(a.a,e)}function pMb(a,b,c){var d;if(!b){d=dKb(a.a,(Afc(),tdc));T9b(d.k)==-1&&vKb(d,c.o.b,c.o.a);return d}return LLb(a,b,false)}function Jz(a){var b;if(a.a.Id())return a.a.Jd();while(a.b.Id()){b=a.b.Jd();if(!a.c.Sd(b))return b}return a.f=2,null}function kqb(a){ppb();var b;
if(a.n!=(Afc(),Vcc))return false;for(b=a.c;b;b=b.f)if(b.n!=tdc)return false;return true}function Snc(a,b){var c,d;d=$wnd.Math.min(a.c.Yd(),a.d.Yd());for(c=d-1;c>=0;c--)if(a.c.ce(c)==b)return c;return-1}function Yrc(a){var b,c;if(a>-129&&a<128){b=a+128;c=($rc(),Zrc)[b];!c&&(c=Zrc[b]=new Krc(a));return c}return new Krc(a)}function Z8b(a){var b,c;c9b(a,(Hbc(),pbc),1);for(c=(!a.c?(Cyc(),Cyc(),Byc):new Kbc(a.c)).Vd();c.Id();){b=c.Jd();Z8b(b)}}function CMb(a,b,c,d){var e;a.c.Bh(URc+occ(b,CE(xE(iW,1),mLc,
1,5,[]))+VRc,(e=H8b(a.n,(Hbc(),ybc)),!e?null:e.ug()),c,d)}function tp(a,b,c,d,e,f,g){bn();var h;h=new gxc;Dyc(h,CE(xE(iW,1),mLc,1,5,[a,b,c,d,e,f]));Dyc(h,g);return np(new wxc(h))}function $Vb(a,b,c,d){d=Ysc(d);Esc(d.substr(0,21),"//# sourceMappingURL=")&&(a.b.i=d.substr(21));Xr(a.a,new $Zb(d,c,b))}function Qxc(a,b,c,d){var e,f,g;for(e=b+1;e<c;++e)for(f=e;f>b&&d.lf(a[f-1],a[f])>0;--f){g=a[f];a[f]=a[f-1];a[f-1]=g}}function Oxc(a){var b,c,d,e,f;if(a==null)return 0;f=1;for(c=a,d=0,e=c.length;d<e;++d){b=
c[d];f=31*f+b;f=f|0}return f}function wwc(a){var b;b=a.a[a.c-1&a.a.length-1];if(b==null)return null;a.c=a.c-1&a.a.length-1;a.a[a.c]=null;return b}function gz(a,b){var c,d;c=a.b.b.Yd();b.length<c&&(b=(d=Fxc(b,0),d.length=c,d));fz(a,b);b.length>c&&(b[c]=null);return b}function Lfc(a,b){var c,d,e;if(Vt(b))return a;c=new kcc((Afc(),Iec),a);for(e=b.Vd();e.Id();){d=e.Jd();q8b(c,d)}return c}function Lc(b,c,d){var e;try{Kc(b,c,d)}catch(a){a=fZ(a);if(pF(a,104)){e=a;throw gZ(new Kqc(e));}else throw gZ(a);}return c}
function O2b(a){if(a.b==116||a.b==84)throw gZ(new Q2b(nF(a.b)+""+nF(a.c)));throw gZ(new Q2b(String.fromCharCode(a.b)));}function mJc(a){if(a.c)mJc(a.c);else if(a.d)throw gZ(new Irc("Stream already terminated, can't be modified or used"));}function Grc(a,b){if(a<b)return-1;if(a>b)return 1;if(a==b)return a==0?Grc(1/a,1/b):0;return isNaN(a)?isNaN(b)?0:1:-1}function aWb(a,b){this.d=a==(iWb(),gWb);this.a=!(a==bWb||a==cWb);this.b=a==eWb||a==fWb||a==hWb;this.c=b;this.e=a==bWb}function kmb(a){this.g=hy(Yx((fl(8,
lQc),new $x)));this.e=new Fr;this.f=fy(Xx((fl(8,lQc),new $x)));this.d=new Cwc;this.c=a}function fXb(a,b,c,d,e){this.d=new fxc;this.g=a;this.e=b;this.a=c;this.i=d;this.b=d.a;this.c=d.a.length;this.f=e;this.j=0}function r8b(a,b){var c;Kd(!b.g);Kd(!b.f);Kd(!b.i);b.g=a;b.f=a.c;if(!a.c)b.i=b;else{c=a.c.i;b.i=c;b.f=a.c;a.c.i=b}a.c=b}function ZB(a,b){var c;b=b<0?(-b<<1)+1:b<<1;do{c=b&31;b>>>=5;b>0&&(c|=32);htc(a,(XB(),bMc,bMc.charCodeAt(c)))}while(b>0)}function Wkc(a,b){var c,d,e,f;f=b;c=new xnc(a);for(e=
po(f).Vd();e.Id();){d=e.Jd();vnc(c,d.Ve(),d.We(),null)}return wnc(c)}function Vnc(a){var b,c,d,e;if(a.b!=null)for(c=a.b,d=0,e=c.length;d<e;++d){b=c[d];if(Wfc(b))return true}return false}function GZb(a){var b;b=a;while(b.p==(n1b(),M0b))b=b.a;switch(b.p.f){case 59:case 61:return true;default:return false}}function Aqb(a){ppb();switch(a.n.f){case 72:case 73:case 101:case 102:case 71:case 70:return true;default:return false}}function qXb(a){switch(a){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:return a-
48;default:return-1}}function Vn(a){Bn();var b;switch(a.Yd()){case 0:return An;case 1:return new Wz(Sd(a.ce(0)));default:b=a;return new hz(b)}}function Zqb(a,b){ppb();var c;c=(ae(Hsc(a,_sc(46))==-1,HMc,a),n8b(),new Wbc((Afc(),rec),a));!!b&&F9b(c,b);return Yqb(c,b)}function ohb(a,b){var c,d;d=fhb(a,g9b(b));c=yhb(a,d);if(d.n!=(Afc(),zfc)){r8b(b,khb(a,c));c9b(b,(Hbc(),gbc),0);eib(a.a,b)}}function jmb(a,b){var c;b.n==(Afc(),Vcc)&&(b=b.g);if(b.n==Tdc&&Tf(a.f,b)){c=b.g;(c.n==Vcc||c.n==Xec)&&Lf(a.g,c,Uf(a.f,
b))}}function edb(a){var b,c;Ld(a.n==(Afc(),bdc),a);b=a.d;if(b){Ld(b.oi(),a);c=ujc((Ofc(),!b?null:b.Ii()))}else c=null;return c}function FLb(a,b){var c;c=dKb(a.a,(Afc(),Tdc));q8b(c,yKb(a.a,b.a));q8b(c,zKb(a.a,b.c));!!b.b&&q8b(c,zKb(a.a,b.b));return c}function jMb(a,b){var c,d,e;e=(Bn(),new Zr);for(d=b.a.Vd();d.Id();){c=d.Jd();Xr(e,yKb(a.a,c))}return SJb(a.a,Mfc(In(e.a)))}function $Sb(a,b,c){var d,e;return new Z1b((e=YSb(a,b),new X1b(a.b,b,e,b-a.a[e])),(d=YSb(a,c),new X1b(a.b,c,d,c-a.a[d])))}function Y_(a,
b,c){var d;U_(c);for(d=c.c;d;d=d.f)X_(a,b,d);b==(Afc(),jec)?F_(a,(IRb(),fRb),c):b==gdc&&F_(a,(IRb(),RQb),c)}function KOb(a,b){var c,d;u9b(b,T9b(b.k)+a.d);for(d=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();d.Id();){c=d.Jd();KOb(a,c)}}function vu(a){var b,c;c=itc(new stc,91);b=true;while(a.Id()){b||(c.a+=iLc,c);b=false;otc(c,a.Jd())}return(c.a+="]",c).a}function k5b(a,b){!a.d&&(a.d=new L5b);!a.d.e&&(a.d.e=new mDc);if(kDc(a.d.e,b))return false;else{jDc(a.d.e,b);return true}}function d4b(a,b){!a.d&&(a.d=
new L5b);!a.d.f&&(a.d.f=new gxc);if(_wc(a.d.f,b,0)!=-1)return false;Ywc(a.d.f,b);return true}function e4b(a,b){!a.d&&(a.d=new L5b);!a.d.g&&(a.d.g=new gxc);if(_wc(a.d.g,b,0)!=-1)return false;Ywc(a.d.g,b);return true}function YWb(a){switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 92:return WWb(a);case 91:return ZWb(a);default:yWb(a);return true}}function MKb(a){switch(a.n.f){case 72:case 73:case 101:case 102:case 70:case 71:case 67:return true;default:return false}}function _mb(a,b,c){if(c==b||c!=b&&nyc(a.c[c.c],
b.c))return b;else if(b!=c&&nyc(a.c[b.c],c.c))return c;return $mb(a,b,c)}function NZ(a){var b;if(Array.isArray(a)&&a.Hj===OZ)return frc(Bb(a))+"@"+(b=Db(a)>>>0,b.toString(16));return a.toString()}function wnc(a){var b;if(a.b)return a.d.u[38];b=(ht(),new qt((Wy(),Vy)));pt(b,new puc(a.c));return new onc(a.d,ot(b),a.a)}function Xeb(a,b){var c,d;c9b(b,(Hbc(),pbc),1);for(d=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();d.Id();){c=d.Jd();Xeb(a,c)}}function cMb(a,b){var c,d,e;e=eKb(a.a,(Afc(),gfc),yKb(a.a,b.b));
for(d=b.a.Vd();d.Id();){c=d.Jd();q8b(e,yKb(a.a,c))}return e}function AKb(a,b){var c,d;c=VJb(a,b.o);d=iLb(a.t,b);!!c&&(d9b(d,(Hbc(),mbc),c),d);T9b(d.k)==-1&&vKb(d,b.o.b,b.o.a);return d}function Whb(a,b){var c,d;for(d=new wxc(b);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);Xd(c.n==(Afc(),fec));buc(a.n,c.Wh())}}function iOb(a,b){var c,d;c=a.p;if(c==a.o.length){d=zE(xF,eLc,46,a.o.length*2,15,1);xtc(a.o,d,c);a.o=d}a.o[c]=b&dLc;a.p=c+1}function pB(a,b){var c,d;Sd(b);if(!a.c)return b;d=a.c.a;for(c=btc(b)-
1;c>=0;c--)if(Zsc(b,c)!=d)break;return ctc(b,0,c+1)}function Tib(a,b,c){var d;Xd(c.n==(Afc(),rec));d=i$(b,c.Wh());if(!!d&&!!d.c&&uqb(d.c)&&c!=d.c)return Qib(a,d.c);return null}function lLb(a,b){var c;bKb(a.a,b,(IRb(),FQb));c=eKb(a.a,(Afc(),Sec),AKb(a.a,b.a));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);return c}function eLb(a,b){if(Efc(b.Wh())){a.a.e=oQb(a.a.e,(IRb(),eRb));a.a.a.d==(zJb(),pJb)&&a.a.d.Bh(YQc,a.a.q,T9b(b.k),S9b(b.k))}}function GUb(a){var b,c;c=DWb(a.g,0).d.b;b=wTb(a);b.e==(AZb(),gZb)&&b.a&&RVb(a,
(IRb(),HRb));return new j_b(new Z1b(c,a.f),b)}function Sbb(){Sbb=JZ;Obb=new Tbb(qOc,0);Rbb=new Tbb("SORT_ONLY",1);Qbb=new Tbb("PRUNE_LEGACY",2);Pbb=new Tbb("PRUNE",3)}function e6b(){e6b=JZ;b6b=new f6b(ARc,0);a6b=new f6b(zRc,1);c6b=new f6b(BRc,2);d6b=new f6b(CRc,3);_5b=new f6b("INHERITED",4)}function pgb(){pgb=JZ;ogb=new qgb("QUOTED_PROPERTY",0);mgb=new qgb("COMPUTED_PROPERTY",1);ngb=new qgb("NORMAL_PROPERTY",2)}function K0(a,b,c,d,e,f,g,h,i,j){this.i=a;this.f=b;this.e=c;this.j=d;this.b=e;this.g=f;
this.d=g;this.a=h;this.c=i;this.k=j}function yob(a,b,c,d,e,f){this.b=new fDc;this.a=a;this.f=b;Kd(c.length!=0);this.d=c;this.e=d;e?this.c=this:this.c=f.Eh()}function F8(a,b,c){this.f=new fxc;this.e=new fxc;this.o=new fxc;this.d=new fxc;this.j=(b9(),a9);this.a=a;this.i=b;c&&C8(this)}function dpb(a,b,c){this.o=new Cwc;this.n=new fxc;this.b=new Cwc;this.a=b;pF(b,317)&&(this.j=b);this.c=a;this.k=c;this.q=true}function wwb(a){uwb.call(this,a);Ld(zpb(this.d)||this.d.n==(Afc(),Xec)||this.d.n==(Afc(),Vec),
this.d);this.b=null;this.a=0}function xtc(a,b,c){var d,e;Bb(a);Bb(b);e=a.length;d=b.length;if(c<0||c>e||c>d)throw gZ(new Eqc);c>0&&mKc(a,0,b,0,c,true)}function CLb(a,b){var c,d,e;e=eKb(a.a,(Afc(),Ycc),yKb(a.a,b.b));for(d=b.a.a.Vd();d.Id();){c=d.Jd();q8b(e,yKb(a.a,c))}return e}function M3b(a,b){var c,d,e,f,g;g=new L9b((Afc(),xec),a);for(d=b,e=0,f=d.length;e<f;++e){c=d[e];Xd(H3b(c));q8b(g,c)}return g}function nh(a,b){var c,d,e;if(pF(b,50)){c=b;d=c.Ve();e=Bx(a.Oe(),d);return Gd(e,c.We())&&(e!=null||
a.Oe().se(d))}return false}function hlb(a,b,c){var d,e,f;e=(d=Hsc(b,_sc(46)),d==-1?b:b.substr(0,d));return f=i$(c,e),!f&&!!a.d&&(f=i$(a.d,e)),!!f&&!f.d.b}function JE(a,b){if(a.h==uMc&&a.m==0&&a.l==0){b&&(EE=HE(0,0,0));return GE((iF(),gF))}b&&(EE=HE(a.l,a.m,a.h));return HE(0,0,0)}function t5(a){if(a.o<=0&&a.u!=a.v+1)return;a.e=a.j.a.length;a.g=a.b;itc(a.j,10);a.o=0;++a.n;a.b=a.j.a.length;a.f=a.u==a.v+1}function u4b(a,b,c){if(!d5b(a))return true;!a.b.j&&(a.b.j=new tEc);if(!oEc(a.b.j,b)){qEc(a.b.j,b,
c);return true}return false}function O4(a){var b,c;for(b=a.c;b;b=b.f)if(b.n==(Afc(),Vcc)){c=O4(b);if(c)return c}else if(b.n!=tdc)return b;return null}function yTb(a){var b,c,d,e;e=DWb(a.g,0).d.b;b=LUb(a);while(BVb(a)){c=wTb(a);d=LUb(a);b=new RZb(new Z1b(e,a.f),b,c,d)}return b}function LUb(a){var b,c,d,e;e=DWb(a.g,0).d.b;b=gUb(a);while(IVb(a)){c=wTb(a);d=gUb(a);b=new RZb(new Z1b(e,a.f),b,c,d)}return b}function gVb(a){var b,c,d,e;e=DWb(a.g,0).d.b;b=yTb(a);while(MVb(a)){c=wTb(a);d=yTb(a);b=new RZb(new Z1b(e,
a.f),b,c,d)}return b}function l3b(a,b){var c,d,e,f,g;g=new L9b((Afc(),Ycc),a);for(d=b,e=0,f=d.length;e<f;++e){c=d[e];Yd(H3b(c),c);q8b(g,c)}return g}function Dgb(a,b){var c,d,e,f;f=b.n!=(Afc(),bfc)||b.Yh();c=f?(e=w3b(a,b),e):O$(a,b.Wh());return d=(Xd(H3b(c)),new L9b(ndc,c)),d}function E2b(a,b){var c;z2b(a);c=a.b<a.c?zsc(a.a,a.b):-1;if(c>=48&&c<=57){M2b(b,B2b(a));return D2b(a,b)}else throw gZ(G2b(a));}function Zub(a,b){Sd(a);Sd(b);Kd(b.n==(Afc(),Jdc));this.a=b;b.n==Jdc&&E8b(b,(Hbc(),Fac))!=0?this.b=
a.b:this.b=new $ub(this)}function V8(a,b){var c,d;U8(a,b,null);Kd(b.n==(Afc(),Xec));c=H8b(b,(n8b(),V7b));if(c){d=nQb(c);Esc(d,"es3")||qGc(a.a,"lang",d)}}function i$(a,b){var c,d,e;c=b!=null?s$(b):null;if(c)return g$(a,c);d=a;while(d){e=pEc(d.e,b);if(e)return e;d=d.b}return null}function Ipb(a){ppb();var b,c;Ld(a.n==(Afc(),bdc),a);b=Td(a.c?a.c.i:null,a);for(c=b.c;c;c=c.f)if(nqb(c))return c;return null}function Mqb(a){ppb();switch(a.f){case 24:case 79:case 25:case 21:case 22:case 20:case 19:return true;
default:return false}}function r7b(a,b){if(!!b&&!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)){l4b(a.a,b);a.e=true;return true}return false}function glb(a,b){return a.e||(!!a.c&&epb(a.a,a.c,new zlb(a)),epb(a.a,a.i,new zlb(a)),a.e=true,a.d=null,undefined),Ytc(a.g,b)}function j4b(a,b,c){!a.d&&(a.d=new L5b);!a.d.o&&(a.d.o=new tEc);if(oEc(a.d.o,c))return false;else{qEc(a.d.o,c,b);return true}}function iVb(a){var b;b=(Bn(),new Zr);while(zVb(a,0,(AZb(),gYb))||NVb(a)||AVb(a,sYb)||zVb(a,0,IXb))Xr(b,
hVb(a));return In(b.a)}function kVb(a){var b;b=(Bn(),new Zr);while(zVb(a,0,(AZb(),gYb))||NVb(a)||AVb(a,sYb)||zVb(a,0,IXb))Xr(b,hVb(a));return In(b.a)}function S_(a){var b,c;b0((Afc(),fec),a);c0(a)&&a.Wh().length==0&&D0(WMc,a);c=Cfc(a.n);c!=-1&&(b=C8b(a),c!=b&&D0(QMc+c+RMc+b,a))}function W_(a){var b,c;b0((Afc(),rec),a);c0(a)&&a.Wh().length==0&&D0(WMc,a);c=Cfc(a.n);c!=-1&&(b=C8b(a),c!=b&&D0(QMc+c+RMc+b,a))}function ryc(a,b){var c,d;if(a==b)return;yyc(a.a,b.a.length-1);for(c=0;c<b.a.length;c++){d=b.a[c]|
0;d!=0&&(a.a[c]=a.a[c]|0|d)}}function Zpc(a){var b,c;c=Xpc(a);if(c)return a.c?null:c;b=a.a.a.length;return b>a.g?a.i.u[51]:b>1?null:b==1?a.a.a[0]:a.i.u[58]}function mj(a){var b,c,d,e;for(d=(e=(new fvc(a.a)).a.He().Vd(),new kvc(e));d.a.Id();){c=(b=d.a.Jd(),b.We());c.a=0}Ttc(a.a);a.b=0}function ydb(a){var b,c;Ld(a.n==(Afc(),Jdc),a);c=H8b(a,(Hbc(),Dbc));b=c?c:a.d;if(!b)return null;Xd(!!b.Ii());return Cjc(b.Ii())}function Qn(a){Bn();var b,c,d;for(c=0,d=a.length;c<d;c++)if(a[c]==null)throw gZ(new nsc("at index "+
c));b=a;return new eyc(b)}function j1(a,b){if(a==null)throw gZ(new nsc("Null specifier"));this.a=a;if(b==null)throw gZ(new nsc("Null varName"));this.b=b}function JKc(a,b,c){if(a<0||b>c)throw gZ(new Fqc(STc+a+TTc+b+", size: "+c));if(a>b)throw gZ(new qnb(STc+a+" > toIndex: "+b));}function F1(a,b){if(E8b(b,(Hbc(),Pac))!=0)throw gZ(new Irc(a+"existing scope is improperly marked as deleted:\n"+E9b(b)));}function KVb(a,b){var c;c=DWb(a.g,b).e;switch(c.f){case 2:case 101:case 100:return true;default:return OSb(),
OSb(),!!Po(pSb,c)}}function OVb(a){switch(DWb(a.g,0).e.f){case 9:case 26:case 24:case 63:case 64:case 77:case 76:return true;default:return false}}function Y$b(){Y$b=JZ;V$b=new Z$b("DECLARATION",0);W$b=new Z$b("EXPRESSION",1);X$b=new Z$b("MEMBER",2);U$b=new Z$b("ARROW",3)}function PC(){this.e=new fxc;this.k=new tEc;this.j=new tEc;this.g=new tEc;this.f=new _B(0,0);this.i=new _B(0,0);this.a=new tEc}function VEb(a){this.f=new fxc;this.c=new fxc;this.a=new mDc;this.e=new tEc;this.b=new fDc;this.d=new hv;
Zwc(this.f,a);UEb(this)}function Uwb(a,b){if(!a)throw gZ(new qnb("a source must have a name"));Esc("/",tqc)?this.b=a:this.b=Osc(a,tqc,"/");this.c=b}function Db(a){return tF(a)?TKc(a):rF(a)?vF(a):qF(a)?a?1231:1237:oF(a)?a.Ad():BE(a)?NKc(a):!!a&&!!a.hashCode?a.hashCode():NKc(a)}function z4(a,b,c,d,e){var f,g;for(g=b;g;g=g.f){f=g==b;if(f)v4(a,g,c?1:0,d);else{N3(a.c,e,true);v4(a,g,c?1:0,d.b?d:(_4(),W4))}}}function dac(a,b,c){var d,e;for(e=0;e!=b;++e)c.a+="    ";ltc(c,D9b(a,true,true,true));c.a+=gMc;for(d=
a.c;d;d=d.f)dac(d,b+1,c)}function Sf(a){var b,c,d,e;for(c=(e=(new fvc(a.c)).a.He().Vd(),new kvc(e));c.a.Id();){b=(d=c.a.Jd(),d.We());b.Rd()}a.c.Rd();a.d=0}function k3b(a){var b,c,d,e,f,g;c=(b=new J9b((Afc(),Vcc)),b);for(e=a,f=0,g=e.length;f<g;++f){d=e[f];Xd(I3b(d));q8b(c,d)}return c}function SJb(a,b){var c,d;!!b.j||w8b(b,a.s);for(d=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();d.Id();){c=d.Jd();SJb(a,c)}return b}function y8b(a,b,c){var d;w9b(b,a.k);t9b(b,a.e);r9b(b,a.d);v9b(b,a.j);if(c){d=H8b(a,(Hbc(),
mbc));!!d&&q9b(a,i4b(d,true))}return b}function Sc(a,b,c){var d,e;for(e=a.Vd();e.Id();){d=e.Jd();if(uF(b)===uF(d)||b!=null&&zb(b,d)){c&&e.Kd();return true}}return false}function Dhc(a,b){var c,d;for(c=a;c;c=c.Si()){!!c.Li()&&(c=c.Li().d);d=new ukc(false);if(Qfc(c,b,0,d))return true}return false}function gh(a,b){var c;if(uF(b)===uF(a))return true;if(!pF(b,35))return false;c=b;if(c.Yd()!=a.Yd())return false;return a.Td(c)}function HIc(a){var b,c;if(a.b)return a.b;c=zIc?null:a.d;while(c){b=zIc?null:
c.b;if(b)return b;c=zIc?null:c.d}return bIc(),$Hc}function Rmb(a){var b,c;for(c=new wxc(a.d);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);Kd(true);b.k=null}a.d.a=zE(iW,mLc,1,0,5,1)}function xKc(b){var c=b.e;function d(a){if(!a||a.length==0)return"";return"\t"+a.join("\n\t")}return c&&(c.stack||d(b[qMc]))}function Gn(a){Bn();var b;b=a._d();switch(b.length){case 0:return An;case 1:return new Wz(Sd(b[0]));default:return new hz(Qn(b))}}function Vjb(a,b,c,d){Rjb();var e,f,g;if(!a)return null;e=b.u[c];g=
(f=e.Li(),!f?e:f.d);return new koc(b,g,(Bn(),new Wz(Sd(d))))}function C3b(a,b,c){Yd(a.n==(Afc(),rec)||a.n==tdc,a);Yd(b.n==Wdc||b.n==Ydc||b.n==tdc,b);Yd(c.n==bfc,c);return new O9b(Vdc,a,b,c)}function A1(a,b,c){var d,e;(b.n==(Afc(),Vec)||(ppb(),b.n==Xec||b.n==Jdc))&&tq(a.a,b,c);d=b.c;e=c.c;while(d){A1(a,d,e);d=d.f;e=e.f}}function Kqb(a){var b,c;b=a.c;if(b.n==(Afc(),Pdc)||b.n==Odc){c=b.c?b.c.i:null;return c.n==bfc&&Esc("toString",c.Wh())}return false}function r2b(a){var b;if(a.a==null)b=jLc;else throw gZ(new GD("Integer.toHexString is outside the GWT subset"));
return j2b(a,b,0)}function rDb(a,b){if(a==null)throw gZ(new nsc("Null prefix"));this.a=a;if(b==null)throw gZ(new nsc("Null replacement"));this.b=b}function r4b(a,b,c){if(!d5b(a))return true;!a.b.e&&(a.b.e=new tEc);if(oEc(a.b.e,b))return false;else{qEc(a.b.e,b,c);return true}}function X5b(a,b){if(!a&&!b)return true;if(!a&&!!b||!!a&&!b)return false;return a.d==b.d&&a.f==b.f&&a.e==b.e&&a.c==b.c&&a.b==b.b}function nE(){if(Error.stackTraceLimit>0){$wnd.Error.stackTraceLimit=Error.stackTraceLimit=64;return true}return fMc in
new Error}function H1(a){Xd(a.n==(Afc(),Vec));if(E8b(a,(Hbc(),Hac))!=0)throw gZ(new Irc("Root nodes should never be marked as changed."));}function TKc(a){RKc();var b,c,d;c=":"+a;d=QKc[c];if(d!=null)return vF(d);d=OKc[c];b=d==null?SKc(a):vF(d);UKc();QKc[c]=b;return b}function f3b(a){var b,c,d,e,f;b=new J9b((Afc(),zcc));for(d=a,e=0,f=d.length;e<f;++e){c=d[e];Xd(c.n==tdc||H3b(c));q8b(b,c)}return b}function Lnb(a,b){var c,d;for(d=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();d.Id();){c=d.Jd();if(c.n==(Afc(),
fdc)){Mnb(a,b);return}}}function Djc(a,b){var c,d;if(a.f==(dkc(),bkc)){a.c=In(b);for(d=a.c.Vd();d.Id();){c=d.Jd();Sfc(a.k,c.ki())}}else throw gZ(new ytc);}function bVb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;c=gVb(a);while(LVb(a,b)){d=wTb(a);e=gVb(a);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function oKb(a,b){var c,d,e,f;d=b.c;e=b.a.b.b+1;c=b.a.b.a;f=new BNb(new sOb(d.substr(3),e,c+3),d,b.a.b.c,a.s,a.a,a.d);return dNb(f)}function Kob(a){var b,c;c=twc(a.o);for(b=0;b<a.n.a.length;b++){c=zjb(a.k,$wc(a.n,b),
c);kwc(a.o,c)}a.n.a=zE(iW,mLc,1,0,5,1);return c}function tjc(a){var b,c;c=a.oi()?Bjc(a):null;if(!c)return a.d;b=(Bn(),new Zr);Yr(b,a.d);while(c){Yr(b,c.d);c=Bjc(c)}return In(b.a)}function elc(a,b,c){var d;d=Aic(wic(xic(new Lic(a))),b);c.length>0&&(d.k=Xkc(d.f,(Bn(),Sd(c),In(new eyc(c))),null),d);return uic(d)}function Gjc(a,b,c){if(!b)return false;if(a.oi()&&b==(ae(a.oi()||a.f==(dkc(),bkc),lRc,a),cgc(a.k)))return false;return Ijc(a,b,c)}function hPb(a,b){if(b.n!=(Afc(),rec)){a.a.Bh(URc+occ(jSc,CE(xE(iW,
1),mLc,1,5,["name"])),a.b.ug(),a.d,a.c);return false}return true}function r3b(a,b){Yd(a.n==(Afc(),rec)||a.n==Fec||a.n==Acc||a.n==odc,a);(a.n==Fec||a.n==Acc)&&(a=new L9b(odc,a));return new L9b(b,a)}function K4(a,b,c,d,e,f,g,h){var i,j;j=b.c;while(j.n==c)j=j.c;v4(a,j,g,e);i=j;do{i=i.g;N3(a.c,d,true);v4(a,i.c.f,h,f)}while(i!=b)}function QC(a,b){var c,d,e,f;e=0;for(d=new TEc(new KEc(b));d.b!=d.c.a.b;){c=REc(d);f=c.d;e!=0&&(a.a+=",",a);ltc(a,(uD(),xD(f)));++e}}function Wp(a){var b,c,d,e,f;f=0;for(d=(e=
(new fvc(a.a)).a.He().Vd(),new kvc(e));d.a.Id();){c=(b=d.a.Jd(),b.We());f+=c.Yd()}return f}function Gfb(a,b,c,d){var e,f;f=z3b(Ffb(a,b),d,CE(xE(nW,1),uNc,2,6,[]));if(a.f.d){e=c.d;!e&&(e=pfb(a.f,51));f.d=e}G9b(f,c);return f}function Qy(a,b,c,d){var e;fl(c,"oldCount");fl(d,"newCount");e=Bx(a.a,b);if((!e?0:e.a)==c){sj(a,b,d);return true}else return false}function hMb(a,b){var c,d;d=b.a.uf();c=iKb(a.a,(Afc(),rec),d.Jd());while(d.Id())c=x3b(c,V3b(d.Jd()));return SJb(a.a,new kcc(pfc,c))}function oVb(a){var b,
c,d;d=DWb(a.g,0).d.b;iTb(a,(AZb(),rZb));b=jTb(a);iTb(a,ZXb);c=nVb(a);nTb(a);return new F1b(new Z1b(d,a.f),b,c)}function fUb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;c=bVb(a,b);while(EVb(a)){d=wTb(a);e=bVb(a,b);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function Qob(a,b){var c,d,e;c=Fpb(b);a.g=c;e=Lob(c);e?Wob(a,H8b(e,(Hbc(),cbc)),(d=H8b(e,ybc),!d?null:d.ug())):Wob(a,null,"");a.f=e}function Woc(a,b){Ofc();var c,d,e;dgc.call(this,a);this.b=b;e=new $pc(a,true);for(d=b.Vd();d.Id();){c=d.Jd();Upc(e,c)}this.a=Wpc(e)}
function Ypc(a,b,c){var d,e;e=!!b.Li()&&(b.Li(),true);d=!!c.Li()&&(c.Li(),true);return a.k&&!e&&!d?b.zi(c):b.Ai(c,new Akc(false),0)}function Lgb(a,b,c,d){var e;!!d&&d.n==(Afc(),odc)&&(d=d.g);switch(c.n.f){case 93:case 94:Ngb(a,b,c,d);c==rwc(a.e).b&&(e=wwc(a.e),e)}}function KGb(){KGb=JZ;JGb=new Mcb("JSC_USELESS_EMPTY_STATEMENT",(E2(),C2),new Rtc("Useless empty statement. (fix with go/fixjs)"))}function JNb(){JNb=JZ;HNb=new KNb("SEARCHING_ANNOTATION",0);INb=new KNb("SEARCHING_NEWLINE",1);GNb=new KNb("NEXT_IS_ANNOTATION",
2)}function Fsc(a,b){if(b==null)return false;if(Esc(a,b))return true;return a.length==b.length&&Esc(a.toLowerCase(),b.toLowerCase())}function M4(a,b){p4(this);this.c=a;this.g=b.sc;this.k=b.qd;this.i=b.vc;this.j=u9(b);this.n=false;this.f=l9(b);this.e=new Emb(this.n)}function Txb(){this.a=new _3b(hRc);this.c=new Uwb(hRc,(scc(),qcc));this.b=new J9b((Afc(),Xec));p9b(this.b,this.a);y9b(this.b,this.c)}function R3b(a){var b,c,d,e,f;f=new J9b((Afc(),Jec));for(c=a,d=0,e=c.length;d<e;++d){b=c[d];Xd(b.n==rec||
b.n==Sec);q8b(f,b)}return f}function T3b(a){var b,c,d,e,f;f=new J9b((Afc(),Vec));for(c=a,d=0,e=c.length;d<e;++d){b=c[d];Xd(b.n==Vec||b.n==Xec);q8b(f,b)}return f}function qEc(a,b,c){var d,e,f;e=Xtc(a.c,b);if(!e){d=new HEc(a,b,c);$tc(a.c,b,d);EEc(d);return null}else{f=pvc(e,c);rEc(a,e);return f}}function Tfc(a,b){var c,d,e;c=a.gi(b);if(!c)return null;if(a.ki().c.Ud()||!Wfc(c))return c;e=a.ki();d=new foc(a.A,e);return c.Ni(d)}function u8b(a,b){var c,d,e;if(!b)return;Td(b.i,b);for(c=b;c;c=c.f){Kd(!c.g);
c.g=a}e=b.i;if(a.c){d=a.c.i;b.i=d;e.f=a.c;a.c.i=e}a.c=b}function O_(a){var b,c,d;b0((Afc(),cec),a);for(b=a.c;b;b=b.f){b0(sec,b);c=Cfc(b.n);c!=-1&&(d=C8b(b),c!=d&&D0(QMc+c+RMc+d,b));W_(b.c)}}function WCb(a){var b,c,d;for(c=new wxc(a.a);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);d=b.g;if(d){Sd(b.g);e9b(b.g,b);w7(a.b.a,d)}}}function YB(a){var b,c,d,e,f,g;f=0;g=0;do{b=zsc(a.a,a.b++);d=(XB(),e=WB[b],e);c=(d&32)!=0;d&=31;f=f+(d<<g);g=g+5}while(c);return $B(f)}function Dxc(a,b,c){var d,e,f,g;e=0;d=b-1;
while(e<=d){f=e+(d-e>>1);g=a[f];if(g<c)e=f+1;else if(g>c)d=f-1;else return f}return-e-1}function Exc(a,b,c){var d,e,f,g;e=0;d=b-1;while(e<=d){f=e+(d-e>>1);g=a[f];if(g<c)e=f+1;else if(g>c)d=f-1;else return f}return-e-1}function M$(a,b,c){var d,e,f,g,h,i,j;i=(j=i3b((Afc(),edc),a,b),j);for(e=c,f=0,g=e.length;f<g;++f){d=e[f];i=(h=i3b(edc,i,d),h)}return i}function yKb(a,b){var c,d;c=YJb(a,b);d=iLb(a.t,b);if(c){d=_Jb(a,b,c,d);d9b(d,(Hbc(),mbc),c)}T9b(d.k)==-1&&vKb(d,b.o.b,b.o.a);return d}function xrc(a,
b){var c=0;while(!b[c]||b[c]=="")c++;var d=b[c++];for(;c<b.length;c++){if(!b[c]||b[c]=="")continue;d+=a+b[c]}return d}function imb(a,b){var c;if(nj(a.e,b)>0)return true;c=twc(a.d);if(!c.c)return false;while(!!c&&!!c.a){Vf(a.g,c.a,b);c=c.b}return true}function MLb(a,b){var c,d;c=VJb(a.a,b.d);fLb(a,b);d=iKb(a.a,(Afc(),rec),b.a);!!c&&(d9b(d,(Hbc(),mbc),c),d);vKb(d,b.d.b,b.d.a);return d}function PLb(a,b){var c,d,e;e=eKb(a.a,(Afc(),xec),yKb(a.a,b.b));if(b.a)for(d=b.a.a.Vd();d.Id();){c=d.Jd();q8b(e,yKb(a.a,
c))}return e}function NMb(a,b){var c,d;d=false;while(true){c=jOb(a.j);if(c==32)continue;else if(c==b){d=true;break}else break}pOb(a.j,c);return d}function lGc(a,b,c){var d,e,f;e=null;f=a.b;while(f){d=a.a.lf(b,f.d);if(c&&d==0)return f;if(d>=0)f=f.a[1];else{e=f;f=f.a[0]}}return e}function VD(){var a;if(QD!=0){a=PD();if(a-RD>2E3){RD=a;SD=$wnd.setTimeout(_D,10)}}if(QD++==0){cE((bE(),aE));return true}return false}function Kjb(a){var b;for(b=a.c;b;b=b.f){if(b.n!=(Afc(),jfc))continue;if(b.Th()==null||!Esc(b.Th(),
b.Vh()))return false}return true}function f7b(a,b,c){if(!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&j4b(a.a,c,b)){a.e=true;return true}else return false}function Zpb(a,b,c){var d;if(b.Ld(a))return true;if(!c.Ld(a))return false;for(d=a.c;d;d=d.f)if(Zpb(d,b,c))return true;return false}function svb(a,b,c){var d,e;for(e=(!c.c?(Cyc(),Cyc(),Byc):new Kbc(c.c)).Vd();e.Id();){d=e.Jd();if(d.n==(Afc(),_ec)){tvb(a,b,c);return}}}function vfb(a,b,c,d){jfb();var e;if(a.n==(Afc(),gdc)&&!(b.n==Hdc&&a==
b.c)){ufb(a,c,d);e=E7b(H8b(d,(Hbc(),mbc)));w6b(e);q9b(d,k6b(e))}}function z0(a,b){var c;ppb();if(!!b&&(b.n==(Afc(),ufc)||b.n==jec||b.n==gdc)){c=C8b(b);1!=c&&D0(UMc+c,b);Y_(a,b.n,b)}else R_(a,b.g.n,b)}function aKb(a,b,c){var d;a.e=oQb(a.e,c);lQb(a.a.d.a,c)||a.d.Bh((d=BJb(c),d==(zJb(),yJb)?LRc+c:MRc+BJb(c)+NRc+c),a.q,b.d.b.b+1,b.d.b.a)}function bKb(a,b,c){var d;a.e=oQb(a.e,c);lQb(a.a.d.a,c)||a.d.Bh((d=BJb(c),d==(zJb(),yJb)?LRc+c:MRc+BJb(c)+NRc+c),a.q,b.o.b.b+1,b.o.b.a)}function cKb(a,b,c){var d;a.e=
oQb(a.e,c);lQb(a.a.d.a,c)||a.d.Bh((d=BJb(c),d==(zJb(),yJb)?LRc+c:MRc+BJb(c)+NRc+c),a.q,T9b(b.k),S9b(b.k))}function UZ(a,b){switch(b.f){case 0:return VZ(a,zMc,(b$(),ZZ));case 1:return VZ(a,AMc,(b$(),a$));default:return b.e!=null?b.e:""+b.f}}function LVb(a,b){switch(DWb(a.g,0).e.f){case 54:case 55:case 57:case 56:case 17:return true;case 16:return b==1;default:return false}}function x6b(a){if(!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&!U4b(a.a)){a.a.a|=2;a.e=true;return true}else return false}
function y6(a){a.J=Ssb(B6(a),new ctb(a.K));Nsb(a.J,(!a.I&&(a.I=new CGb(a.a)),new fxc));Qsb(a.J,a.o,a.v);if(a.g.a.d!=0)return;a.J=null}function Onb(a){Knb();this.b=a;this.a=false;this.c=(!a.P&&(a.P=new llc),a.P);this.e=Wjb(this.a,this.c,51);this.d=Wjb(this.a,this.c,45)}function ggb(a){Yfb();var b;this.a=a;this.c=(!a.P&&(a.P=new llc),a.P);b=blc(this.c,"ObjectPropertyDescriptor");this.b=b?b:this.c.u[51]}function LCb(a){ICb();this.e=new YEc;this.a=a;this.c=J6(a,new Gmb("",null,0,0,DCb,null,CE(xE(nW,1),
uNc,2,6,[])))==(E2(),B2);this.d=true}function KHb(){KHb=JZ;JHb=new Mcb("JSC_MISSING_NAMESPACE_IMPORT",(E2(),B2),new Rtc('Imported Closure namespace "{0}" never defined.'))}function I1(a,b,c){var d,e;d=b.length==0?"":b+": ";e=new mDc;ppb();erb(qq(a.a,c),new L1(e),(se(),pe));erb(c,new N1(a,e,d),pe);D1(a,d,e)}function Roc(a,b){var c,d,e;d=new $pc(a.A,false);for(c=0;c<a.b.Yd();c++){e=a.b.ce(c);(e.Bi()||e.si()||!e.zi(b))&&Upc(d,e)}return Vpc(d)}function Wsb(a){var b,c;for(c=new wxc(a.d);c.a<c.c.a.length;){b=
(c.b=c.a++,c.c.a[c.b]);if(Wn((Msb(),Isb),b.b))return true}return false}function isc(a){var b,c;if(iZ(a,-129)>0&&iZ(a,128)<0){b=yZ(a)+128;c=(ksc(),jsc)[b];!c&&(c=jsc[b]=new _rc(a));return c}return new _rc(a)}function $bb(a,b){Wbb();var c,d,e,f,g;g=(bn(),new Rs);for(d=b,e=0,f=d.length;e<f;++e){c=d[e];Qs(g,c.b)}this.a=a;this.b=np(new wxc(g.b))}function hOb(){fOb();return CE(xE(AR,1),sLc,67,0,[SNb,TNb,VNb,_Nb,eOb,YNb,cOb,WNb,aOb,XNb,bOb,PNb,ONb,MNb,ZNb,dOb,RNb,$Nb,QNb,NNb,UNb])}function hmb(){hmb=JZ;
gmb=(bn(),pp(CE(xE(iW,1),mLc,1,5,[oMc,lPc])));fmb=Ur(MCc((Afc(),wcc),CE(xE(KU,1),sLc,10,0,[Hec,Sdc,Tdc,Vcc,Xec])))}function z9b(a,b){var c;if(!!b.j&&(!a.j||a.j.c==14&&!a.j.b)){c=b.j;while(c.b)c=c.b;if(c.c==14){a.j=c;return}}y9b(a,H8b(b,(Hbc(),ybc)))}function TTb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;b&&iTb(a,(AZb(),yYb));c=tTb(a);d=pUb(a,1);e=sTb(a);return new VZb(new Z1b(f,a.f),b,c,d,e)}function dUb(a){var b,c,d;d=DWb(a.g,0).d.b;iTb(a,(AZb(),YXb));c=jTb(a);iTb(a,FYb);b=eUb(a);iTb(a,KXb);return new x$b(new Z1b(d,
a.f),c,b)}function B2b(a){var b;b=0;while(a.b<a.c&&I2b(zsc(a.a,a.b))){b=hZ(rZ(10,b),zsc(a.a,a.b++)-48);if(iZ(b,_Kc)>0)return A2b(a)}return yZ(b)}function Sic(a,b,c,d,e){var f,g;if((cnc(a.t,b)?1:0)!=0&&(g=a.Yi(b),!!g&&!g.b))return false;f=new Xmc(b,c,d,e);gnc(a.t,b,f);return true}function gtc(a,b,c){var d,e,f,g;f=b+c;KKc(b,f,a.length);g="";for(e=b;e<f;){d=$wnd.Math.min(e+1E4,f);g+=$sc(a.slice(e,d));e=d}return g}function GKc(a,b){if(0>a)throw gZ(new qnb("fromIndex: 0 > toIndex: "+a));if(a>b)throw gZ(new Gqc("fromIndex: 0, toIndex: "+
a+RTc+b));}function Upb(a){ppb();var b;for(b=a;true;b=b.c){if(b.n==(Afc(),rec)||b.n==lfc||b.n==ffc)return b;ae(b.n==Pdc,"Not a getprop node: ",b)}}function RGb(){RGb=JZ;QGb=new Mcb("JSC_MUST_COME_BEFORE_IN_ES6_MODULE",(E2(),D2),new Rtc("In ES6 modules, {0} should come before {1}."))}function R5b(a,b){if(!a&&!b)return true;if(!a&&!!b||!!a&&!b)return false;return X5b(a.a,b.a)&&V5b(a.c,b.c)&&X5b(a.b,b.b)&&$5b(a.d,b.d)}function nnc(a,b,c,d){if(Igc(a,b,c,d))return true;if(a.A.u[38].Ai(b,c,d))return true;
if(!b.Ji())return false;return Ehc(a,b.Ji(),c,d)}function exc(a,b){var c,d;d=a.a.length;b.length<d&&(b=sKc(new Array(d),b));for(c=0;c<d;++c)b[c]=a.a[c];b.length>d&&(b[d]=null);return b}function dyc(a,b){var c,d;d=a.a.length;b.length<d&&(b=sKc(new Array(d),b));for(c=0;c<d;++c)b[c]=a.a[c];b.length>d&&(b[d]=null);return b}function SLb(a,b){var c,d,e,f;bKb(a.a,b,(IRb(),lRb));f=dKb(a.a,(Afc(),Fec));for(d=b.a.Vd();d.Id();){c=d.Jd();e=TLb(a,c);q8b(f,e)}return f}function H5b(a,b){var c,d,e;e=null;if(a){e=
new gxc;for(d=new wxc(a);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);Ywc(e,D5b(c,b))}}return e}function Fbb(a){var b,c,d,e,f;a.e=(wx(Dbb.length),new gDc);f=0;for(c=Dbb,d=0,e=c.length;d<e;++d){b=c[d];$tc(a.e,_qc(b),new Mbb(b,f));++f}}function ywc(a,b){var c,d,e,f;d=a.a.length-1;c=b-a.b&d;f=a.c-b&d;e=a.c-a.b&d;Gwc(c<e);if(c>=f){zwc(a,b);return-1}else{Awc(a,b);return 1}}function i4b(a,b){var c;c=new A5b;c.d=!a.d?null:G5b(a.d,b);c.b=a.b;c.j=a.j;c.a=a.a;c.i=D5b(a.i,b);c.g=D5b(a.g,b);c.c=a.c;c.f=a.f;return c}
function Mjb(a,b,c){var d,e;d=Yjb(f3b(CE(xE(HU,1),IMc,7,0,[])),b);for(e=a.c;e;e=e.f)e.n==(Afc(),jfc)&&q8b(d,Yjb(V3b(e.Vh()),c));return d}function A0(a,b){var c;ppb();!!b&&(b.n==(Afc(),ufc)||b.n==jec||b.n==gdc)?Y_(a,b.n,b):b.n==(Afc(),tdc)?(c=C8b(b),0!=c&&D0(OMc+c,b)):E_(a,b)}function qpb(a,b){ppb();var c,d;Yd(a.n==(Afc(),Xec),a);c=(Yd(a.n==Xec,a),H8b(a,(n8b(),V7b)));d=c?oQb(c,b):oQb((iQb(),TPb),b);d9b(a,V7b,d)}function Heb(a,b,c){var d,e;for(e=c.Vd();e.Id();){d=e.Jd();d.n==(Afc(),bfc)&&Geb(a,b,d,
true);Heb(a,b,!d.c?(Cyc(),Cyc(),Byc):new Kbc(d.c))}}function LIc(a,b,c,d){(xIc?b.qj()>=(HIc(a),800):yIc?b.qj()>=(bIc(),800):BIc?b.qj()>=(bIc(),900):AIc&&b.qj()>=(bIc(),1E3))&&DIc(a,b,c,d)}function KIc(a,b,c){(xIc?b.qj()>=(HIc(a),800):yIc?b.qj()>=(bIc(),800):BIc?b.qj()>=(bIc(),900):AIc&&b.qj()>=(bIc(),1E3))&&DIc(a,b,c,null)}function X_(a,b,c){if(c.n==(Afc(),rec)){c0(c)&&c.Wh().length==0&&D0(WMc,c);T_(c);!!c.c&&E_(a,c.c)}else c.n==odc?y_(a,b,c):D0(SMc+b+TMc,c)}function L4(a){p4(this);this.c=a;this.g=
false;this.k=true;this.i=false;this.j=false;this.n=false;this.f=(iQb(),TPb);this.e=new Emb(false)}function Q4(b){var c;if(T4(b))try{c=Drc(b);if(qZ(c,{l:0,m:0,h:512}))return xZ(c)}catch(a){a=fZ(a);if(!pF(a,82))throw gZ(a);}return NaN}function fTb(a,b){var c;c=(Bn(),new Zr);Xr(c,b?b.a:"");while(AVb(a,(AZb(),MYb))){iTb(a,MYb);b=jTb(a);if(!b)break;Xr(c,b.a)}return In(c.a)}function ijb(a,b){var c,d,e;c=z3b(a,b,CE(xE(nW,1),uNc,2,6,[]));e=a.d;if(!e)return c;d=Tfc(e,b);!d&&pF(e,128)&&(d=yjc(e,b));return c.d=
d,c}function Jtb(a,b){Itb();var c;if(b==(NFb(),MFb)){c=C8b(a)>=3?B8b(a,2):a.c.f;return c.n==(Afc(),Cec)?""+vF(c.Uh()):c.Wh()}return a.c.f.Wh()}function zjc(a){var b;if(!a.g){b=a.Xi();b==null?Ijc(a,a.A.u[51],null):Gjc(a,new Wic(a.A,a.Xi()+fQc,a.A.u[38],a.q,null),null)}return a.g.e}function tKc(a,b){(!b&&console.groupCollapsed!=null?console.groupCollapsed:console.group!=null?console.group:console.log).call(console,a)}function E1(a,b,c){var d;d=E8b(c,(Hbc(),Hac));if(d==0||d<a.c)throw gZ(new Irc(b+"new scope not explicitly marked as changed:\n"+
E9b(c)));}function e5(a){if(!a.f)throw gZ(new Irc("Cannot build without root node being specified"));return d5(a.f,A5(a.c,a.d),a.c,a.i,a.g,a.b,a.a)}function I5b(a,b){var c,d,e,f;e=null;if(a){e=new tEc;for(d=new TEc(new KEc(a));d.b!=d.c.a.b;){c=REc(d);f=c.e;qEc(e,c.d,D5b(f,b))}}return e}function fnb(a){var b,c,d,e;e=zE(yF,iMc,46,a.a.length,15,1);for(c=0;c<a.a.length;++c){b=a.c[c];for(d=c;d>=0;d=syc(b,d-1))e[d]+=1}return e}function Soc(a,b,c,d){var e,f,g;f=(Yoc(new Epc,a.b)&&Voc(a),a.b);for(g=0;g<f.Yd();g++){e=
f.ce(g);if(Qfc(e,b,c,d))return true}return false}function Onc(a,b,c,d,e){var f,g;g=skc(d,a,b);if(!g){f=_nc(c,a,b,d,e)&&_nc(c,b,a,d,e);tkc(d,a,b,(Hkc(),f?Ekc:Fkc));return f}else return g.a}function Vqb(a,b){var c;c=(ae(Hsc(b,_sc(46))==-1,HMc,b),n8b(),new Wbc((Afc(),rec),b));t9b(c,b.length);H6(a).Fg(b)&&b9b(c,a8b,true);return c}function VUb(a,b){var c,d,e;e=DWb(a.g,0).d.b;c=WUb(a,b);if(AVb(a,(AZb(),ZXb))){iTb(a,ZXb);d=KTb(a,1);c=new t$b(new Z1b(e,a.f),c,d)}return c}function $7(a,b){var c,d;ptc(a.c,
b);c=-1;d=c;while((c=Isc(b,_sc(10),c+1))>=0){++a.b;d=c}d==-1?a.a+=b.length:a.a=b.length-(d+1);return a}function O9(){O9=JZ;L9=new P9(qOc,0);M9=new P9("RELATIVIZE_IMPORT_PATHS",1);N9=new P9("TO_COMMON_JS_LIKE_MODULES",2);K9=new P9("COMPILE",3)}function Xab(){Xab=JZ;Sab=new Yab(COc,0);Vab=new Yab("RAW_SIZE",1);Tab=new Yab("AST_SIZE",2);Wab=new Yab("TIMING_ONLY",3);Uab=new Yab(GMc,4)}function Cgb(a,b){var c,d,e,f,g;g=Y$((d=vPc,d));c9b(g,(Hbc(),pbc),1);c=r9b(x8b(a,false),a.d);return f=A3b((e=i3b((Afc(),
Zec),a,g),e),b,c),f}function bjb(a,b,c){this.i=a;this.a=b;this.g=c;this.f=null;this.b=new xGc;this.c=new YEc;this.d=new mDc;this.e=z8(L6(b,H8b(c,(Hbc(),cbc))))}function XFb(){XFb=JZ;WFb=CE(xE(nW,1),uNc,2,6,["",fOc,".json",".i.js",".js.i.js"]);VFb=CE(xE(nW,1),uNc,2,6,[VQc,"/index.js","/index.json"])}function hhc(a,b,c,d){Ofc();dgc.call(this,a);this.a=!b?Vkc(a,true,CE(xE(cV,1),xPc,23,0,[this.A.u[51]])):b;this.b=!c?this.A.u[51]:c;this.c=d}function zb(a,b){return tF(a)?Esc(a,b):rF(a)?uF(a)===uF(b):qF(a)?
a===b:oF(a)?a.yd(b):BE(a)?wb(a,b):!!a&&!!a.equals?a.equals(b):uF(a)===uF(b)}function Opb(a){ppb();switch(a.n.f){case 72:case 73:case 101:case 102:case 70:return a.c?a.c.i:null;case 71:return a.c;default:return null}}function USb(a){OSb();switch(a.f){case 36:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:return true;default:return false}}function gXb(a){switch(a){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return true;default:return false}}function tsb(a){var b,
c,d;for(d=v8b(a.n).Vd();d.Id();){b=d.Jd();a.k+=1;a.j+=qsb(b)}for(c=v8b(a.u).Vd();c.Id();){b=c.Jd();a.v+=1;a.t+=qsb(b)}}function VLb(a,b){var c,d,e,f;e=(Bn(),new Zr);for(d=b.a.Vd();d.Id();){c=d.Jd();Xr(e,yKb(a.a,c))}f=yKb(a.a,b.b);return SJb(a.a,Lfc(f,In(e.a)))}function v2b(a,b){b.a=b.a.substr(0,0)+"("+b.a.substr(1);if(a.b.k){N2b(a.b,a.b.p-1);b=j2b(a,b,1);b.a+=")"}else{b.a+=")";b=j2b(a,b,0)}return b}function Vkc(a,b,c){var d,e,f;d=new Qic(a);f=c.length-1;for(e=0;e<=f;e++)b&&e==f?Oic(d,c[e]):Nic(d,
CE(xE(cV,1),xPc,23,0,[c[e]]));return d.b}function Zhb(a,b,c,d){var e,f;for(f=new wxc(b);f.a<f.c.a.length;){e=(f.b=f.a++,f.c.a[f.b]);Xd(e.n==(Afc(),fec));_tc(a.n,e.Wh(),new rib(c,d))}}function be(a,b,c){if(!a)throw gZ(new Irc(rf('Bad binary operator "%s": expected 2 arguments but got %s',CE(xE(iW,1),mLc,1,5,[b,Yrc(c)]))));}function c0(b){try{if(b.Wh()==null){D0(XMc,b);return false}}catch(a){a=fZ(a);if(pF(a,38)){D0(XMc,b);return false}else throw gZ(a);}return true}function o7(a){var b;Xd(s9(a.G));b=
(!a.I&&(a.I=new CGb(a.a)),new fxc);if(b.a.length==0)return;a.J=B6(a);Nsb(a.J,b);Qsb(a.J,a.o,a.v);a.J=null}function Voc(a){var b,c,d,e;e=new $pc(a.A,false);d=new $pc(a.A,true);for(c=a.b.Vd();c.Id();){b=c.Jd();Upc(e,b);Upc(d,b)}a.b=Wpc(e);a.a=Wpc(d)}function Egb(a,b){var c,d;c=b.c?b.c.i:null;if(c.n!=(Afc(),Vcc)){Sd(c.g);e9b(c.g,c);d=I9b(j3b((Xd(H3b(c)),new L9b(Uec,c))),c);q8b(b,d);Vob(a)}}function aVb(a){var b,c;b=DWb(a.g,0).d.b;if(AVb(a,(AZb(),FYb))){iTb(a,FYb);c=new s1b(new Z1b(b,a.f),EUb(a));iTb(a,
KXb)}else c=rVb(a);return c}function lNb(a,b){var c;c=mNb(a,b);if(c)if(OMb(a,(fOb(),ZNb))){!a.o?mOb(a.j):GMb(a);xNb(a);b=!a.o?mOb(a.j):GMb(a);return sNb(a,b,c)}return c}function _Wb(a,b){var c,d,e;d=a.f;while(xWb(a,a.f)&&!jXb(xWb(a,a.f)?zsc(a.b,a.f):0))yWb(a);c=$Sb(a.i.b,d,a.f);e=Vsc(a.b,d,a.f);$Vb(a.a,b,c,e)}function Rob(a,b){var c,d,e,f;!b&&!!a.j&&a.j.zh(a);e=a.n.a.length;e>0?f=axc(a.n,e-1):f=(d=vwc(a.o),d).d;ppb();QCc(ipb,f.n)&&(c=vwc(a.b),c)}function HVb(a){var b;b=DWb(a.g,0);switch(b.e.f){case 18:case 2:case 49:case 65:case 54:case 47:return true;
default:return OSb(),!!QSb(b.e)}}function e$b(){e$b=JZ;_Zb=new f$b("BLOCK",0);c$b=new f$b("LINE",1);b$b=new f$b("JSDOC",2);d$b=new f$b("SHEBANG",3);a$b=new f$b("IMPORTANT",4)}function p7b(a,b){if(!!b&&!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&!a.a.g){w5b(a.a,b);a.e=true;return true}else return false}function jqb(a){ppb();var b;if(!!a&&(a.n==(Afc(),ufc)||a.n==jec||a.n==gdc))for(b=a.c;b;b=b.f)if(b.n==(Afc(),odc))return true;return false}function i0(a,b,c){var d,e;b0((Afc(),cfc),c);g0(c);
e=C8b(c);1!=e&&D0(UMc+e,c);d=c.c;switch(d.n.f){case 121:x_(a,b,d);break;default:R_(a,b,d)}}function N2(){N2=JZ;M2=new Mcb("JSC_MISSING_RETURN_STATEMENT",(E2(),D2),new Rtc("Missing return statement. Function expected to return {0}."))}function MRb(a){var b,c,d,e,f,g;g=(b=erc(FR),new TCc(b,nKc(b,b.length),0));for(d=LRb(),e=0,f=d.length;e<f;++e){c=d[e];c.b==a&&NCc(g,c)}return g}function y2b(a,b,c,d,e){if(b==-2&&!e)throw gZ(new e2b("<"));if(b>=a.length)throw gZ(new e2b(Vsc(c.a,c.d,c.b)));if(b==-2)return d;
return a[b]}function Zqc(a,b,c){EKc(a>=0&&a<=lMc);if(a>=kMc){b[c++]=55296+(a-kMc>>10&mMc)&dLc;b[c]=56320+(a-kMc&mMc)&dLc;return 2}else{b[c]=a&dLc;return 1}}function bpb(a,b,c,d){Sd(c);Qob(a,b);if(Kob(a)!=d){a.e=b;Sd(a.e);kwc(a.o,d);Tob(a,d.d);!!a.j&&a.j.yh(a);Zob(a,b,c);Rob(a,false)}else Zob(a,b,c)}function drb(a,b){var c;if(!H8b(a,(Hbc(),ybc))){z9b(a,b);w9b(a,b.k)}H8b(a,sbc)==null&&d9b(a,(n8b(),g8b),H8b(b,sbc));for(c=a.c;c;c=c.f)drb(c,b)}function NDb(a,b){MDb();return $Db(ZDb(_Db(eEb(dEb(cEb(bEb(aEb(new fEb,
b),a),(Bn(),Bn(),An)),(null,An)),(null,An)),(oo(),oo(),no)),false),false)}function NFb(){NFb=JZ;JFb=new OFb("BROWSER",0);KFb=new OFb("BROWSER_WITH_TRANSFORMED_PREFIXES",1);LFb=new OFb("NODE",2);MFb=new OFb("WEBPACK",3)}function zKb(a,b){var c,d;c=yKb(a,b);if(c.n!=(Afc(),Vcc)){if(c.n==tdc)A9b(c,Vcc);else{d=eKb(a,Vcc,c);wKb(d,c);c=d}c9b(c,(Hbc(),Eac),1)}return c}function g3b(a,b,c){var d;Xd(a.n==(Afc(),rec));Xd(b.n==Jec);Xd(c.n==Vcc||H3b(c));d=new O9b(Jdc,a,b,c);Xd(d.n==Jdc);c9b(d,(Hbc(),Fac),1);return d}
function sqb(a){ppb();var b;if(a.n==(Afc(),Jdc)&&iqb(a.g)&&a.n==Jdc&&Gqb(a.c)){b=a.g;return b.n==Xec||b.n==pec||b.g.n==Jdc||b.n==Adc}return false}function JOb(a,b,c){var d;d=(Pd(b.n==(Afc(),Ycc),iSc,b),C8b(b)-1);if(d<c.c){nPb(a,c.d);return false}if(d>c.b){kPb(a,c.d);return false}return true}function SOb(a,b){if(!JOb(a,b,(NPb(),sPb)))return false;if(!gPb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)))){mPb(a,sPb.d);return false}return true}function ZOb(a,b){if(!JOb(a,b,(NPb(),DPb)))return false;if(!gPb(a,
(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)))){mPb(a,DPb.d);return false}return true}function s6b(a,b){if(!!b&&!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&!P4b(a.a)){f5b(a.a,b);a.e=true;return true}else return false}function cVb(a,b){var c;c=WUb(a,b);AVb(a,(AZb(),ZXb))&&VVb(a,"A default value cannot be specified after '...'",CE(xE(iW,1),mLc,1,5,[]));return c}function V8b(a){switch(a.n.f){case 29:return a.Wh().length!=0;case 33:case 99:return true;case 26:return V8b(a.c);case 98:default:return false}}
function mF(a,b){if(tF(a))return!!lF[b];else if(a.Gj)return!!a.Gj[b];else if(rF(a))return!!kF[b];else if(qF(a))return!!jF[b];return false}function dc(a){var b,c;c=CE(xE(xF,1),eLc,46,15,[92,117,0,0,0,0]);for(b=0;b<4;b++){c[5-b]=fLc.charCodeAt(a&15);a=a>>4&dLc}return gtc(c,0,c.length)}function _d(a,b,c){if(!a)throw gZ(new Irc(rf("Bad GETELEM node: Expected 2 children but got %s. For node: %s",CE(xE(iW,1),mLc,1,5,[Yrc(b),c]))));}function l5(a,b,c,d){var e,f;if(a.k)for(f=new wxc(a.i);f.a<f.c.a.length;){e=
(f.b=f.a++,f.c.a[f.b]);e.c=o5(e.c,b,c,d);!!e.a&&(e.a=o5(e.a,b,c,d))}}function jbb(a,b){var c;if(pF(b,218)){c=b;c.a&&(a.a=c.a);kbb(a,new hxc(new EHc(c.c.a.uj())))}else{++a.d;$tc(a.e,b,Yrc(a.d));BHc(a.c,b);AHc(a.c,b)}}function Rhb(a,b,c){var d;d=new fxc;Ywc(d,mib(b,c));--a.o!=0&&Ywc(d,F9b(O3b(a.o),c));fib(a,Dhb(a,c,"leaveFinallyBlock",exc(d,zE(HU,IMc,7,0,0,1))))}function rkb(a){var b,c,d;b=qkb(a);Sd(b);c=b;d=c.g;while(d.n==(Afc(),eec)){c=d;d=c.g}Yd((ppb(),d.n==Vec||d.n==Xec||d.n==Vcc||d.n==pec),d);
return c}function MDb(){MDb=JZ;LDb=YDb($Db(ZDb(_Db(eEb(dEb(cEb(bEb(aEb(new fEb,""),""),(Bn(),Bn(),An)),(null,An)),(null,An)),(oo(),oo(),no)),false),false))}function WIb(a){var b,c,d;b=(oo(),new hs);gs(b,po((TIb(),SIb)));for(d=a.Vd();d.Id();){c=d.Jd();c.length!=0&&!No(SIb,c)&&es(b,c,pIb)}return Co(b.b)}function Mfc(a){var b,c,d;Ld(!Vt(a),"union must have at least one option");b=new jcc((Afc(),sfc));for(d=a.Vd();d.Id();){c=d.Jd();q8b(b,c)}return b}function HKb(a,b){var c;if(b.n==(Afc(),Uec)){c=b;while(c=
c.g)if(c.n==Jdc)return;a.d.Ah("return must be inside function",a.q,T9b(b.k),S9b(b.k))}}function DKc(a){switch(typeof a){case $Kc:return TKc(a);case YKc:return vF(a);case XKc:return Nqc(),a?1231:1237;default:return a==null?0:NKc(a)}}function el(a,b){if(a==null)throw gZ(new nsc("null key in entry: null="+b));else if(b==null)throw gZ(new nsc("null value in entry: "+a+"=null"));}function i2(){i2=JZ;h2=new Mcb("JSC_MISSING_CONST_PROPERTY",(E2(),C2),new Rtc("Private property {0} is never modified, use the @const annotation"))}
function Ghb(a,b,c,d){var e;Xd(!b.b);e=F9b(k3b(CE(xE(HU,1),IMc,7,0,[Dhb(a,d,PPc,CE(xE(HU,1),IMc,7,0,[mib(b,d)])),Fhb(a,d)])),d);c&&(b.b=e);return e}function pkb(a,b,c){var d;if(b){d=a.d;return G9b(Yjb(h3b(Yjb((ae(Hsc(c,_sc(46))==-1,HMc,c),n8b(),new Wbc((Afc(),rec),c)),d),a),d),a)}else return a}function $hb(a,b,c){var d,e,f,g;if(b){f=(d=vwc(a.e),d);Xd(f.b==0);Xd(f.a==b)}if(c){if(!swc(a.e)){e=--qwc(a.e).b;Xd(e>=0)}g=(d=vwc(a.k),d);Xd(g==c)}}function QPb(){NPb();return CE(xE(DR,1),sLc,59,0,[pPb,qPb,
rPb,tPb,uPb,vPb,wPb,xPb,sPb,zPb,yPb,APb,BPb,CPb,DPb,GPb,FPb,EPb,HPb,IPb,JPb,KPb,LPb,MPb])}function n2b(a,b){var c,d,e;d=a.b.n;e=NZ(a.a);if(e.indexOf(".")!=-1){c=Hsc(e,_sc(46));c+d<e.length&&(e=e.substr(0,c+d+1));b.a+=""+e}else b.a+=""+e}function Y3b(a,b){var c,d,e,f,g;Xd(H3b(a));g=new L9b((Afc(),gfc),a);for(d=b,e=0,f=d.length;e<f;++e){c=d[e];Xd(c.n==$cc||c.n==ldc);q8b(g,c)}return g}function yq(){var a;fl(16,XLc);a=Gr(16);this.b=zE(uH,PLc,151,a,0,1);this.c=zE(uH,PLc,151,a,0,1);this.a=null;this.e=null;
this.i=0;this.f=a-1;this.g=0}function ot(a){var b,c,d;b=mt(a.a);for(d=new wxc(a.b);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);nt(b,c)}return ht(),new it((Cyc(),new hBc(b)),a.a)}function LMb(a){var b,c,d;qOb(a.j);d=a.j.g;b=lOb(a.j)+1;c=Ysc(MMb(a));c.length>0&&p6b(a.f,c,d,b,d,b+c.length);return new FNb(c,!a.o?mOb(a.j):GMb(a))}function N_(a,b){switch(b.n.f){case 29:case 26:case 27:E_(a,b);break;case 92:q_(b.c,1);N_(a,b.c);break;default:D0("Invalid INC/DEC target "+b.n,b)}}function PTb(a,b){var c,d,
e,f;f=DWb(a.g,0).d.b;c=fUb(a,b);while(AVb(a,(AZb(),wXb))){d=iTb(a,wXb);e=fUb(a,b);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function QTb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;c=RTb(a,b);while(AVb(a,(AZb(),BXb))){d=iTb(a,BXb);e=RTb(a,b);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function RTb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;c=PTb(a,b);while(AVb(a,(AZb(),EXb))){d=iTb(a,EXb);e=PTb(a,b);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function HUb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;c=QTb(a,b);while(AVb(a,(AZb(),yXb))){d=
iTb(a,yXb);e=QTb(a,b);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function IUb(a,b){var c,d,e,f;f=DWb(a.g,0).d.b;c=HUb(a,b);while(AVb(a,(AZb(),IYb))){d=iTb(a,IYb);e=HUb(a,b);c=new RZb(new Z1b(f,a.f),c,d,e)}return c}function k7b(a,b){if(!!b&&!I4b(a.a)&&!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)){x5b(a.a,b,$Lc);a.e=true;return true}else return false}function qu(a,b){var c,d;while(a.Id()){if(!b.Id())return false;c=a.Jd();d=b.Jd();if(!(uF(c)===uF(d)||c!=null&&zb(c,d)))return false}return!b.Id()}
function $Kb(a){var b,c;Kd(a.n==(Afc(),Xec));if(!a.c)return false;c=a.c;if(c.n!=Ddc)return false;b=c.c;if(b.n!=Ycc)return false;return _8b(b.c,cQc)}function DNb(a){var b,c;c=0;while(c<a.length){b=zsc(a,a.length-c-1);Gfc();if(Ffc.test(b))++c;else break}if(c==0)return a;return Vsc(a,0,a.length-c)}function Yob(b,c){var d;try{Qob(b,c);b.e=c;Sob(b,c);Zob(b,c,null);Rob(b,false)}catch(a){a=fZ(a);if(pF(a,80)||pF(a,38)){d=a;Xob(b,d)}else throw gZ(a);}}function sj(a,b,c){var d,e;fl(c,"count");if(c==0){d=auc(a.a,
b);e=wj(d,c)}else{d=Xtc(a.a,b);e=wj(d,c);!d&&$tc(a.a,b,new _l(c))}a.b=hZ(a.b,c-e);return e}function byb(a,b,c){var d;d=Hg(EDc(b.d,a));if(c==d)return d;if(d){d.b.a=d.a;d.a.b=d.b;d.a=null}else{d=new cyb(a);FDc(b.d,a,d)}d.b=c;c.a=d;c=d;return d}function Z_(a,b,c){var d,e;F_(a,(IRb(),jRb),b);b0((Afc(),tec),b);e=Cfc(b.n);e!=-1&&(d=C8b(b),e!=d&&D0(QMc+e+RMc+d,b));__(a,b.c);$_(a,b.c?b.c.i:null,c)}function b9(){b9=JZ;a9=new c9(qOc,0);Z8=new c9("GOOG",1);Y8=new c9("ES6",2);X8=new c9("COMMONJS",3);_8=new c9("JSON",
4);$8=new c9("IMPORTED_SCRIPT",5)}function AGb(){AGb=JZ;new Mcb("JSC_CANNOT_USE_PROTOTYPE_AND_VAR",(E2(),B2),new Rtc("Rename prototypes and inline variables cannot be used together."))}function SMb(a,b,c,d){var e,f;if(c!=-1&&d==0){f=lOb(a.j)-c;for(e=0;e<f;e++)b.a+=" "}else b.a.length>0&&(uqc(b,b.a.length-1)!=10||d==0)&&(b.a+=" ",b)}function ijc(a,b,c,d){var e,f;e=(!c.b&&(c.b=new fDc),yg(c.b,new Bkc(c,a,b),(Hkc(),Gkc)));if(e)return e.a;f=Xhc(a,b,c,d,1);return zkc(c,a,b,f?Ekc:Fkc)}function xob(a,b){if(b.length==
0)return b;b.indexOf(_Pc)!=-1&&(b=Vsc(b,0,b.lastIndexOf(_Pc)));a.a.Hg(b)&&(b="JSCompiler_"+b);return b+_Pc+a.d+a.f.Cd()}function DMb(a,b,c,d){var e;a.c.Bh(URc+occ("msg.jsdoc.type.record.duplicate",CE(xE(iW,1),mLc,1,5,[b]))+VRc,(e=H8b(a.n,(Hbc(),ybc)),!e?null:e.ug()),c,d)}function sOb(a,b,c){this.o=zE(xF,eLc,46,128,15,1);this.q=zE(yF,iMc,46,3,15,1);Sd(a);this.g=b;this.k=a;this.j=a.length;this.i=this.b=0;this.d=b;this.c=c}function DVb(a){var b;b=DWb(a.g,0);switch(b.e.f){case 2:case 100:case 65:case 43:case 101:case 49:case 52:return true;
default:return OSb(),!!QSb(b.e)}}function HZb(a){var b;b=a;while(b.p==(n1b(),M0b))b=b.a;switch(b.p.f){case 26:case 46:case 55:case 59:case 61:case 74:return true;default:return false}}function mGc(a,b,c,d,e,f,g,h){var i,j;if(!d)return;i=d.a[0];!!i&&mGc(a,b,c,i,e,f,g,h);nGc(a,c,d.d,e,f,g,h)&&b.Pd(d);j=d.a[1];!!j&&mGc(a,b,c,j,e,f,g,h)}function uJc(a,b){var c,d,e;e=new tFc(new eyc(CE(xE(ZY,1),mLc,1113,0,[a,b])),16);d=new zJc(e);c=new KJc(null,d);return kJc(c,new vJc(a)).Dj(new wJc(b))}function ME(a,
b){var c,d,e;if(b<=22){c=a.l&(1<<b)-1;d=e=0}else if(b<=44){c=a.l;d=a.m&(1<<b-22)-1;e=0}else{c=a.l;d=a.m;e=a.h&(1<<b-44)-1}return HE(c,d,e)}function Y6(a,b,c,d){var e,f,g,h;e=new Smb("$strong$");for(h=xu(new Guc(c.a));h.Id();){g=h.Jd();Omb(e,new H8(g))}f=new gxc;f.a[f.a.length]=e;$6(a,b,f,d)}function fqb(a,b){ppb();var c;if(E8b(a,(n8b(),a8b))!=0)return true;if(a.n!=(Afc(),rec)||!b)return false;c=i$(b,a.Wh());return!!c&&(A$(c)||z$(c)==gdc)}function FKb(a,b){var c;if(b.n==(Afc(),yec)){c=b;while(c=c.g)if(c.n==
Jdc)return;a.d.Ah("new.target must be inside a function",a.q,T9b(b.k),S9b(b.k))}}function m4b(a,b,c){!a.d&&(a.d=new L5b);if(a5b(a,b))return false;if(!a.d.t)a.d.t=new tEc;else if(oEc(a.d.t,b))return false;qEc(a.d.t,b,c);return true}function E6b(a,b){var c,d;for(d=new Wzc(b.b.Vd());d.b.Id();){c=d.b.Jd();if((S4b(a.a,c)||Esc(c,"*"))&&k5b(a.a,c))a.e=true;else return false}return true}function ug(a,b){var c,d,e;c=b.Ve();e=b.We();d=a.Ie(c);if(!(uF(e)===uF(d)||e!=null&&zb(e,d)))return false;if(d==null&&!a.se(c))return false;
return true}function xjc(a){var b,c,d,e;e=new fxc;for(c=(d=a.b.a,d?!d.c?(Cyc(),Cyc(),Byc):new Kbc(d.c):(Cyc(),Cyc(),Byc)).Vd();c.Id();){b=c.Jd();Ywc(e,b.d)}return e}function Nsc(a,b,c){var d,e,f,g;d=(e=b>>>0,e.toString(16));f="\\u"+Usc("0000",d.length)+d;g=String.fromCharCode(c);return a.replace(new RegExp(f,"g"),g)}function Ysc(a){var b,c,d;c=a.length;d=0;while(d<c&&a.charCodeAt(d)<=32)++d;b=c;while(b>d&&a.charCodeAt(b-1)<=32)--b;return d>0||b<c?a.substr(d,b-d):a}function de(a,b,c,d,e){if(!a)throw gZ(new Irc(rf("Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)",
CE(xE(iW,1),mLc,1,5,[b,c,d,e]))));}function Ze(){Ld(".".length!=0,"The separator may not be the empty string.");if(".".length==1)return Ye(new nc(".".charCodeAt(0)));return new We(new gf)}function Rlb(){Rlb=JZ;Llb=new Slb(iQc,0);Olb=new Slb("OBJECTLIT",1);Mlb=new Slb(jQc,2);Qlb=new Slb(kQc,3);Nlb=new Slb("GET_SET",4);Plb=new Slb("OTHER",5)}function SKb(a){RJb();switch(a.f){case 98:return Afc(),nfc;case 99:return Afc(),Edc;default:throw gZ(new Irc(!a?jLc:a.a==null?(OSb(),Po(pSb,a)).c:a.a));}}function VKb(a){RJb();
switch(a.f){case 68:return Afc(),$dc;case 69:return Afc(),jdc;default:throw gZ(new Irc(!a?jLc:a.a==null?(OSb(),Po(pSb,a)).c:a.a));}}function bnc(a,b,c){var d,e,f,g;if(!c.Pd(a))return;b.Qd(a.b.we());g=dnc(a);!!g&&bnc(g,b,c);for(e=enc(a).Vd();e.Id();){d=e.Jd();f=d.Vi();!!f&&bnc(f,b,c)}}function Yqc(a){return String.fromCharCode(a).toUpperCase().charCodeAt(0)==a&&(Rqc==null&&(Rqc=new RegExp("[A-Z]","i")),Rqc.test(String.fromCharCode(a)))}function pu(a,b){if(b==null)while(a.a.Id()){if(a.a.Jd().We()==
null)return true}else while(a.a.Id())if(zb(b,a.a.Jd().We()))return true;return false}function AE(a,b){var c=new Array(b);var d;switch(a){case 14:case 15:d=0;break;case 16:d=false;break;default:return c}for(var e=0;e<b;++e)c[e]=d;return c}function T4(a){var b,c,d;d=a.length;if(d==0)return false;for(c=0;c<d;c++){b=a.charCodeAt(c);if(b<48||b>57)return false}return d==1||a.charCodeAt(0)!=48}function ahb(a){_gb();Sd(a);this.b=a;this.f=(!a.P&&(a.P=new llc),a.P);this.g=false;this.i=null;this.e=null;this.a=
null;this.c=null;this.d=null;this.j=null}function Tsb(a,b){Msb();var c;this.b=a;this.d=a.v;this.p=b;this.i=new fxc;this.c=false;this.e=0;this.q=a.G.td;c=a.G.dc;c>0&&c<=100?this.g=c:this.g=100}function Xic(a,b,c,d,e,f){Hhc.call(this,a,e);this.t=new inc;hnc(this.t,this);this.o=b;this.q=d;this.n=f;d||!!c?(Xd(!this.$i()),this.p=c):Tic(this,a.u[38])}function khb(a,b){var c;if(!b)return null;c=I3b(b)?j3b(b):(Yd(H3b(b),b),new L9b((Afc(),Ddc),b));epb(a.f.b,c,new wib(a.a));Xd(!!c.c&&!c.c.f);return g9b(c)}
function $ib(a,b){var c,d,e,f;e=Bpb(b);for(d=new wxc(e);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);Xd(c.n==(Afc(),rec));f=c.Wh();qGc(a.b,f,new Mib(f,c))}}function WLb(a,b){var c,d;c=QLb(a,b.a);A9b(c,(Afc(),cfc));if(b.b)r8b(c,yKb(a.a,b.b));else{d=c.Sh(false);c9b(c,(Hbc(),kbc),1);A9b(d,rec);r8b(c,d)}return c}function tUb(a){var b,c,d,e;d=DWb(a.g,0).d.b;e=null;if(GVb(a)){b=pUb(a,0);iTb(a,(AZb(),zXb));c=nVb(a);e=new _$b(new Z1b(d,a.f),b,c)}else e=ITb(a);return e}function K8b(a){var b,c,d,e;b=0;for(e=
a.j;e;e=e.b)++b;c=zE(wF,cMc,46,b,15,1);for(d=a.j;d;d=d.b){--b;c[b]=d.c}c.sort(KZ(kyc.prototype.yj,kyc,[]));return c}function E9b(b){var c,d;try{d=new stc;dac(b,0,d);return d.a}catch(a){a=fZ(a);if(pF(a,104)){c=a;throw gZ(new GD("Should not happen\n"+c));}else throw gZ(a);}}function vB(a){var b;qB.call(this,a,null);this.a=zE(xF,eLc,46,512,15,1);Kd(a.c.length==16);for(b=0;b<256;++b){this.a[b]=a.c[b>>>4];this.a[b|256]=a.c[b&15]}}function jib(a,b){return F9b(Yjb(x3b(F9b(Yjb(K3b(OPc+(a.r.b==0?"":"$"+a.r.b)),
a.g),b),F9b((n8b(),new Wbc((Afc(),bfc),RPc)),b)),a.r.f.g?a.g.Wi(RPc):null),b)}function mJb(){mJb=JZ;lJb=new nJb("TYPES_ONLY",0);jJb=new nJb("INCLUDE_DESCRIPTIONS_NO_WHITESPACE",1);kJb=new nJb("INCLUDE_DESCRIPTIONS_WITH_WHITESPACE",2)}function hTb(a,b){var c,d,e;d=b.b;c=b.a;if(d.o.a.b<c.o.b.b){a.f=d.o.a;NWb(a.g,a.f.c);e=d}else{VVb(a,"'=>' unexpected",CE(xE(iW,1),mLc,1,5,[]));e=b}return e}function dtc(a){var b;b=0;while(0<=(b=a.indexOf("\\",b)))a.charCodeAt(b+1)==36?a=a.substr(0,b)+"$"+Usc(a,++b):a=
a.substr(0,b)+(""+Usc(a,++b));return a}function $$(a){var b,c,d,e,f,g;d=Y$((b=NMc,b));c=(f=x3b(d,(n8b(),new Wbc((Afc(),bfc),"getPrototypeOf"))),f);g=(e=Tqb(c,CE(xE(HU,1),IMc,7,0,[a])),e);return g}function apb(a,b){var c,d;for(c=b.c;c;){d=c.f;if(c.n==(Afc(),fdc)){a.e=b;if(a.a.Bg(a,c,b)){Zob(a,c.c?c.c.i:null,c);a.e=b;a.a.Cg(a,c,b)}}else Zob(a,c,b);c=d}}function lwb(a,b,c,d,e,f){var g;g=mwb(a,b);if(g)return new Gmb(c,null,d,e,g,null,CE(xE(nW,1),uNc,2,6,[b]));return Mmb(c,d,e,f,bwb,CE(xE(nW,1),uNc,2,
6,[b]))}function zHb(){zHb=JZ;yHb=new Mcb("JSC_ILLEGAL_PROTOTYPE_MEMBER",(E2(),C2),new Rtc("Prototype property {0} should be a primitive, not an Array or Object."))}function ZMb(a,b){var c,d;switch(b.f){case 4:d=a.j.n;c=w8b((n8b(),new Xbc((Afc(),cfc),d,a.j.g,lOb(a.j))),a.n);t9b(c,d.length);return c;default:return null}}function mjc(a,b,c,d){!!c.Mi()&&(c=Roc(c.Mi(),a.A.u[52]));ptc((d&&c.xi()&&!c.Bi()&&!c.Ki()&&!c.Ji()&&!c.Ii()&&!c.Mi()&&!_fc(c)&&(b.a+="!",b),c.di(b,d)),"=")}function Osc(a,b,c){var d,
e;d=Psc(b,"([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])","\\\\$1");e=Psc(Psc(c,"\\\\","\\\\\\\\"),"\\$","\\\\$");return Psc(a,d,e)}function pwc(a){var b,c,d;if(a.b!=a.c)return;d=a.a.length;c=Qrc($wnd.Math.max(8,d))<<1;if(a.b!=0){b=nKc(a.a,c);owc(a,b,d);a.a=b;a.b=0}else rKc(a.a,c);a.c=d}function RE(a,b){var c,d,e;e=a.h-b.h;if(e<0)return false;c=a.l-b.l;d=a.m-b.m+(c>>22);e+=d>>22;if(e<0)return false;a.l=c&sMc;a.m=d&sMc;a.h=e&tMc;return true}function y4(a,b){var c,d,e;d=b.Wh();e=E8b(b,(n8b(),j8b))!=
0;if(e)r4(a,E4(a,b.Wh(),e));else{c=Ytc(a.d,d);if(c==null){c=E4(a,b.Wh(),e);_tc(a.d,d,c)}L3(a.c,c)}}function Shb(a,b,c,d){var e,f;$hb(a,b,null);e=new fxc;Ywc(e,mib(c,d));f=Ohb(a);!!f&&Ywc(e,mib(f,d));fib(a,Dhb(a,d,"leaveTryBlock",exc(e,zE(HU,IMc,7,0,0,1))))}function xsb(a,b,c){var d,e;e=(d=vwc(a.f),d);Xd(Esc(b,e.j));Ywc(a.w,e);e.n=c;e.a=0;e.k=1;a.d.a&&(e.d=1);Esc(b,jOc)?vsb(a,e):a.d.a&&a.D!=(Xab(),Wab)&&usb(a,e)}function R6b(a){if((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc||(a.a.a&2)!=0||
W4b(a.a)||(a.a.a&tQc)!=0)return false;a.a.a|=512;a.e=true;return true}function nGc(a,b,c,d,e,f,g){var h,i;if(b.Bj()&&(i=a.a.lf(c,d),i<0||!e&&i==0))return false;if(b.Cj()&&(h=a.a.lf(c,f),h>0||!g&&h==0))return false;return true}function jC(a,b,c,d){var e,f;while(true){f=((d-c)/2|0)+c;e=a.a[f].$f()-b;if(e==0)return f;else if(e<0){c=f+1;if(c>d)return d}else{d=f-1;if(d<c)return d}}}function g0(b){if(b.Yh())try{b.Wh()}catch(a){a=fZ(a);if(pF(a,28))D0("getString failed for"+b.n,b);else throw gZ(a);}else c0(b)&&
b.Wh().length==0&&D0(WMc,b)}function o1(a){var b,c;c=(RFb(),UFb((b=Osc(Osc(Osc(Osc(Osc(Nsc(Nsc(a,58,45),92,47)," ",cNc),"[",dNc),"]",eNc),"<",fNc),">",gNc),SFb(b))));return new q1(a,c,c)}function cqb(a){ppb();if(a.n==(Afc(),rec))switch(a.g.n.f){case 100:case 88:case 78:return true;case 96:return a.g.c==a;case 65:return dqb(a.g)}return false}function Eqb(a){ppb();var b,c,d;if(a.n==(Afc(),Ycc)){b=a.c;if(b.n==Pdc||b.n==Odc){c=b.c?b.c.i:null;if(!!c&&c.n==bfc){d=c.Wh();return Esc(d,ePc)}}}return false}
function olb(a){var b,c,d;b=a.g;Xd(b.n==(Afc(),Fec));c=b.g;if(c.n==Ccc||c.n==odc){d=c.c.f;if(!d||!V8b(d))return null;return I8b(d)+"."+a.Wh()}else return null}function Uib(a,b,c){var d,e;Xd(c.n==(Afc(),rec));d=c.g;if(d.n==Adc||d.n==Bdc||d.n==Vdc||d.n==Wdc)return;e=Tib(a,Kob(b),c);if(e!=null){k9b(c,Wqb(a.a,e));Vob(b)}}function nXb(a){switch(a){case 9:case 11:case 12:case 32:case 160:case 65279:case 10:case 13:case 8232:case 8233:case 12288:return true;default:return false}}function n6b(a,b,c,d){var e,
f;e=f4b(a.a);if(e){f=new Y5b;Ld(b.charCodeAt(0)!=32&&zsc(b,b.length-1)!=32,mTc);f.d=b;S5b(f,c,d,c,d+b.length);e.a=f;a.e=true}a.b=e}function doc(a,b,c){var d,e,f,g;g=c.Fi().Li();if(!g)return false;f=g.c;for(e=f.Vd();e.Id();){d=e.Jd();if(!!d.Ki()&&eoc(a,b,d.Ki()))return true}return false}function Fhc(a){var b,c,d;if(a.u){b=a.Si();if(!b||b._i()){a.u=false;for(d=a.Ri().Vd();d.Id();){c=d.Jd();if(c.Bi()){a.u=true;break}}}else a.u=b.Bi()}return a.u}function hh(a,b){var c,d,e,f;f=a.Yd();if(f<b.Yd())for(c=
a.Vd();c.Id();){d=c.Jd();b.Sd(d)&&c.Kd()}else for(e=b.Vd();e.Id();){d=e.Jd();a.Wd(d)}return f!=a.Yd()}function tv(a){var b,c,d,e,f;if(Hr(a.f,a.b.length)){d=zE(xI,PLc,249,a.b.length*2,0,1);a.b=d;e=d.length-1;for(c=a.a;c!=a;c=c.Sf()){f=c;b=f.d&e;f.a=d[b];d[b]=f}}}function R4(a){var b,c,d;if(wqb(a))return a;d=new stc;for(c=0;c<a.length;c++){b=a.charCodeAt(c);b>31&&b<127?(d.a+=String.fromCharCode(b),d):wD(d,b)}return d.a}function kZ(a,b){var c;if(pZ(a)&&pZ(b)){c=a/b;if(yMc<c&&c<wMc)return c<0?$wnd.Math.ceil(c):
$wnd.Math.floor(c)}return jZ(IE(pZ(a)?wZ(a):a,pZ(b)?wZ(b):b,false))}function vwb(a,b){uwb.call(this,b);Sd(a);Ld(zpb(this.d),this.d);Pd(this.d!=a.d,"rootNode should not be the parent's root node: %s",this.d);this.b=a;this.a=a.a+1}function WBb(a,b,c,d,e){var f,g;g=b.ce(c);if(c<d)return Pfc(g,new stc,true).a;f=e==_Kc&&c==b.Yd()-1;if(f)return HNc+agc(ZBb(a,g),0);return agc(ZBb(a,g),0)+"="}function bLb(a,b,c){var d;if(c){pKb(a.a,c.o,H8b(b,(Hbc(),mbc)));d=(gLb(a,c,(IRb(),GRb)),yKb(a.a,c));d.n==(Afc(),bfc)&&
(d=SJb(a.a,new lcc(bfc,d.Wh())));n9b(b,d)}}function Wpc(a){var b,c;b=Zpc(a);if(b)return Bn(),new Wz(Sd(b));c=Xpc(a);if(!!c&&a.c)return Bn(),new hz(Qn(CE(xE(iW,1),mLc,1,5,[c,a.i.u[52]])));return In(a.a)}function g$(a,b){var c,d,e;e=a;while(e){if(Pqb(e.d)){d=fCc(e.c,b);!d&&hCc(e.c,b,d=new wCb(b.a,null,e,null));return d}c=h$(e,b.a);if(c)return c;e=e.b}return null}function BKb(a,b){var c,d,e;e=lKb(a,b);c=w8b((n8b(),new Wbc((Afc(),bfc),""+e)),a.s);d=XJb(a,UJb(a,b.d));!!d&&(d9b(c,(Hbc(),mbc),d),c);vKb(c,
b.d.b,b.d.a);return c}function kMb(a,b){var c,d,e;e=AKb(a.a,b.c);d=e.n==(Afc(),Fec)||e.n==Acc?eKb(a.a,odc,e):e;if(b.b){c=yKb(a.a,b.b);q8b(d,c);sKb(d,b.o.b,b.o.a)}bLb(a,d,b.a);return d}function iXb(a){if(a<=127)return a>=65&a<=90|a>=97&a<=122|a==95|a==36;return a==629||(Rqc==null&&(Rqc=new RegExp("[A-Z]","i")),Rqc.test(String.fromCharCode(a)))}function qyc(a,b){var c,d,e;uyc(b);c=b/31|0;d=a.a.length;if(c>=d)return-1;e=(a.a[c]|0)&_Kc<<b%31;while(e==0){if(++c>=d)return-1;e=a.a[c]|0}return c*31+Urc(e)}
function Mw(a,b){var c,d;d=a.a.b.b.Yd();if(b==null)for(c=0;c<d;c++){if(Yn(a.b,c)==null)return c}else for(c=0;c<d;c++)if(zb(b,Yn(a.b,c)))return c;return-1}function d6(a){var b,c,d;b=a.c;if((a9b(b,bOc,bOc.length)||a9b(b,cOc,cOc.length))&&C8b(a)==3){c=b.f;d=c.f;if(V8b(c)&&V8b(d))return new Z5((a6(),c),d)}return null}function Ebb(){Ebb=JZ;Cbb=Wsc("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$");Dbb=Wsc("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$")}function Kib(a){var b,c;
b=a.indexOf("://");if(b>-1){a=a.substr(b+3);c=Hsc(a,_sc(47));c>-1&&(a=a.substr(c+1))}else Esc(a.substr(0,1),"/")&&(a=a.substr(1));return a}function Lqb(a,b){var c,d,e;if(a.n==(Afc(),bfc))return true;if(b.kg().ud){e=a.d;if(e){d=b.mg().u[45];c=new ukc(false);if(Qfc(e,d,0,c))return true}}return false}function gEb(a,b,c){var d,e,f;f=a.g.Ph(c);ZEb();if(Esc(c.substr(0,2),rOc)||Esc(c.substr(0,3),nRc)){e=b;d=e.lastIndexOf("/");f=SFb(e.substr(0,d+1)+(""+f))}return f}function Q6b(a){if(!((a.a.a&HPc)==WPc||
(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&!W4b(a.a)&&(a.a.a&2)==0){a.a.a|=512;a.a.a|=bPc;a.e=true;return true}else return false}function np(a){bn();var b,c;if(!a.Id())return mz(),lz;c=a.Jd();if(!a.Id())return new Zz(c);b=new YEc;jDc(b,Sd(c));do jDc(b,Sd(a.Jd()));while(a.Id());return vp(b)}function UE(a,b){var c,d,e,f,g,h,i,j;i=a.h>>19;j=b.h>>19;if(i!=j)return j-i;e=a.h;h=b.h;if(e!=h)return e-h;d=a.m;g=b.m;if(d!=g)return d-g;c=a.l;f=b.l;return c-f}function Rdb(){Rdb=JZ;Qdb=new Mcb("JSC_MISSING_ES6_EXTERNS",
(E2(),B2),new Rtc("Missing externs definition for Symbol. Did you forget to include the ES6 externs?"))}function sCb(a,b,c){var d,e;d=new Jkb;w6(a.b,d);rtb(new utb(a.b,true),null,c);if(SZ(a.b.T)){zrb(new Brb(a.b),b,c);if(a.b.T==1){e=new gsb(a.b);fsb(e,b,c)}}t7(a.b,d)}function iUb(a){var b,c,d;d=DWb(a.g,0).d.b;c=kTb(a);b=null;if(zVb(a,0,(AZb(),iYb))&&Esc(DWb(a.g,0).a,"as")){oTb(a,"as");b=kTb(a)}return new z$b(new Z1b(d,a.f),c,b)}function u3b(a,b,c,d){Xd(a.n==(Afc(),ufc)||a.n==jec||a.n==gdc||a.n==tdc||
H3b(a));Xd(b.n==tdc||H3b(b));Xd(c.n==tdc||H3b(c));Xd(d.n==Vcc);return new P9b(Fdc,a,b,c,d)}function q3b(a,b,c){if(a.n==(Afc(),rec))Xd(!a.c);else{Xd(a.n==Acc||a.n==Fec);a=new L9b(odc,a)}ae(H3b(b),"%s can't be an expression",b);q8b(a,b);return new L9b(c,a)}function Yqb(a,b){if(a.n==(Afc(),Fec)||a.n==Acc){Sd(b);return F9b(r3b(F9b(new N9b(odc,a,b),a),ufc),a)}else{Xd(a.n==rec&&!a.c);!!b&&q8b(a,b);return F9b(r3b(a,ufc),a)}}function Nic(a,b){var c,d,e,f,g;c=F8b(a.b);if(!!c&&(E8b(c,(Hbc(),qbc))!=0||E8b(c,
Ebc)!=0))return false;for(e=b,f=0,g=e.length;f<g;++f){d=e[f];Pic(a,d)}return true}function y3b(a,b,c){var d,e,f,g,h;Xd(H3b(a));Xd(b.n==(Afc(),bfc));h=new N9b(Pdc,a,b);for(e=c,f=0,g=e.length;f<g;++f){d=e[f];Xd(d.n==bfc);h=new N9b(Pdc,h,d)}return h}function vq(a){var b,c,d;d=a.b;if(Hr(a.i,d.length)){c=d.length*2;a.b=zE(uH,PLc,151,c,0,1);a.c=zE(uH,PLc,151,c,0,1);a.f=c-1;a.i=0;for(b=a.a;b;b=b.c)rq(a,b,b);++a.g}}function JVb(a,b){var c;c=DWb(a.g,0).e;if((AZb(),iYb)==c||a.b.d&&VSb(c)||!a.b.c&&USb(c)||AVb(a,
aZb))return true;if(b!=2)return AVb(a,HYb)||AVb(a,FYb);return false}function Ahc(a){var b,c,d,e;c=a.Xi();if(c!=null){e=Hsc(c,_sc(40));if(e!=-1){b=Jsc(c,_sc(41));d=c.substr(0,e);return b+1%c.length==0?d:d+(""+c.substr(b+1))}}return c}function Bgb(){Bgb=JZ;new Mcb("JSC_UNEXPECTED_DESTRUCTURING_REST_PARAMETER",(E2(),B2),new Rtc("Es6RewriteDestructuring not expecting object pattern rest parameter"))}function fkb(a,b,c,d){if(!b||b==c)return;Yd(!Sqb(b),b);fkb(a,b.f,c,d);if(b.n==(Afc(),kfc))b=b.c;else if(!H3b(b))return;
if(kkb(a,b,d.b)){d.b=true;d.a=jkb(a,b,d.a)}}function aqb(a){ppb();switch(a.n.f){case 47:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 59:case 57:case 58:return true}return false}function XKb(a,b){var c,d;if(b.a.p==(n1b(),N_b)){c=b.a.a;d=Ut(c);d.p==Q0b&&a.a.d.Ah("A rest parameter must be in a parameter list.",a.a.q,(RJb(),d.o.b.b+1),d.o.b.a)}}function D6b(a){if((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc||(a.a.a&JPc)!=0||(a.a.a&vMc)!=0||(a.a.a&IPc)!=0)return false;
a.a.a|=JPc;a.e=true;return true}function m7b(a){if((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc||(a.a.a&JPc)!=0||(a.a.a&vMc)!=0||(a.a.a&IPc)!=0)return false;a.a.a|=vMc;a.e=true;return true}function x8b(a,b){var c,d,e,f,g;g=a.Sh(b);c=null;d=null;if(a.c){for(e=a.c;e;e=e.f){f=x8b(e,b);f.g=g;if(!c){c=f;d=c}else{d.f=f;f.i=d;d=f}}c.i=d;d.f=null;g.c=c}return g}function glc(a,b,c){var d,e,f;d=false;for(f=b.t.b.we().Vd();f.Id();){e=f.Jd();if((c==c.A.u[64]||Fhc(c)||!!fnc(c.t,e)?1:0)==0){d=true;jDc(a.e,
e)}}d&&Rc(a.A,c.t.b.we())}function Qd(a,b,c,d){if(!a)throw gZ(new qnb(rf("Cannot add already-owned child node.\nChild: %s\nExisting parent: %s\nNew parent: %s",CE(xE(iW,1),mLc,1,5,[b,c,d]))));}function cC(a,b){var c;if(b.bg()==-1)return null;else{c=AD(CD(DD(new ED,a.e[b.bg()]),b.cg()+1),b.ag()+1);b._f()!=-1&&BD(c,a.d[b._f()]);return new yD(c.d,c.c,c.a,c.b)}}function e1(a){var b;b="";a.c==null&&(b+=" propertyKey");!a.b&&(b+=" kind");!a.a&&(b+=" jsDocInfo");if(b.length!=0)throw gZ(new Irc(bNc+b));return new a1(a.c,
a.b,a.a)}function GDb(a){var b;b="";a.b==null&&(b+=" symbol");a.a==null&&(b+=" rawText");!a.c&&(b+=" type");if(b.length!=0)throw gZ(new Irc(bNc+b));return new CDb(a.b,a.a,a.c)}function Bbb(){Bbb=JZ;Abb=new Mcb("JSC_CONSTANT_REASSIGNED_VALUE_ERROR",(E2(),D2),new Rtc("constant {0} assigned a value more than once.\nOriginal definition at {1}"))}function qfb(a,b,c){var d,e;while(!!b.c&&!!b.c.f){d=b.c?b.c.i:null;e=F9b(r3b(z8b(d),(Afc(),ufc)),b);vfb(b,c,d,e);o8b(c,e,b);w7(a.a,c)}vfb(b,c,b.c,b);A9b(b,(Afc(),
ufc))}function zkb(a,b,c){var d,e;if(Iib(b))return true;if(!c){d=new Hkb;epb(a.a,b,d);if(d.a)return false}e=F9b(new J9b((Afc(),pec)),b);t8b(e,f9b(b));q8b(b,e);return true}function Pob(a,b,c){var d,e;a.g=b;Wob(a,H8b(b,(Hbc(),cbc)),(e=(d=H8b(b,ybc),!d?null:d.ug()),e||""));a.e=b;a.f=b;if(a.a.Bg(a,b,c)){$ob(a,b);a.e=b;a.a.Cg(a,b,c)}a.g=null}function HLb(a,b){var c,d;d=LLb(a,b.b,true);A9b(d,(Afc(),rec));c=eKb(a.a,Wdc,d);if(!b.a){c9b(c,(Hbc(),kbc),1);q8b(c,x8b(d,false))}else q8b(c,LLb(a,b.a,false));return c}
function eMb(a,b){var c;Kd(b.e==(AZb(),BYb)||b.e==jZb||b.e==kZb||b.e==lZb);b.a!=null?c=kKb(a.a,null,b.c):c=kKb(a.a,nKb(a.a,b,true),b.c);vKb(c,b.d.b,b.d.a);return c}function hXb(a){if(a<=127)return a>=65&a<=90|a>=97&a<=122|a>=48&a<=57|a==95|a==36;return iXb(a)||(Pqc==null&&(Pqc=new RegExp("\\d")),Pqc.test(String.fromCharCode(a)))}function Chc(a,b){var c;c=a.Yi(b);if(!c){if(a.si()||a.ni())return a.A.u[11];else if(a.ti()||a.ri()||a.si()||a==a.A.u[64])return a.A.u[58];return a.A.u[51]}return c.e}function EZ(b,
c,d,e){DZ();var f=BZ;$moduleName=c;$moduleBase=d;eZ=e;function g(){for(var a=0;a<f.length;a++)f[a]()}if(b)try{VKc(g)()}catch(a){b(c,a)}else VKc(g)()}function kE(a){var b,c,d,e;b="jE";c="MB";e=$wnd.Math.min(a.length,5);for(d=e-1;d>=0;d--)if(Esc(a[d].d,b)||Esc(a[d].d,c)){a.length>=d+1&&a.splice(0,d+1);break}return a}function Jbb(){Ebb();var a;Fbb(this);a=(wx(0),new nDc);this.f=a;this.d="";this.b=0;this.a=Ibb(this,Cbb);this.c=Ibb(this,Dbb);Wxc(this.a,null);Wxc(this.c,null);Gbb(this)}function nLb(a,b){if($Jb(a.a,
b.c.o)){(b.b.e==(AZb(),dZb)||b.b.e==eZb)&&bKb(a.a,b,(IRb(),WQb));return fKb(a.a,RKb(b.b.e),yKb(a.a,b.a),yKb(a.a,b.c))}else return oLb(a,b)}function Lkc(a,b,c){var d,e,f,g;if(pF(c,48)&&c.Xi()!=null){g=gFc(a.f,b,new plc);f=c;g.Je(f.Xi(),f)}else if(c.Mi())for(e=Ooc(c.Mi()).Vd();e.Id();){d=e.Jd();Lkc(a,b,d)}}function wg(a,b,c){var d,e,f;for(e=a.He().Vd();e.Id();){d=e.Jd();f=d.Ve();if(uF(b)===uF(f)||b!=null&&zb(b,f)){if(c){d=new wvc(d.Ve(),d.We());e.Kd()}return d}}return null}function I_(a,b){var c,d,
e;b0((Afc(),Pdc),b);d=Cfc(b.n);d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b));E_(a,b.c);e=b.c?b.c.i:null;b0(bfc,e);c0(e)&&e.Wh().length==0&&D0(WMc,e)}function gLb(a,b,c){a.a.a.d!=(zJb(),xJb)&&a.a.d.Bh("type syntax is only supported in ES6 typed mode: "+c,a.a.q,(RJb(),b.o.b.b+1),b.o.b.a);a.a.e=oQb(a.a.e,c);qKb(a.a,b.o)}function xdb(a){var b,c,d,e;b=I8b(Ppb(a));c=Sd((ppb(),Gpb(a,new jrb)));e=null;for(d=c.f;d;d=d.f){e=wdb(d,b);if(e)break}return Td(e,"$jscomp.inherits() call not found.")}function aUb(a,b){var c,
d,e,f;f=DWb(a.g,0).d.b;c=IUb(a,b);if(AVb(a,(AZb(),UYb))){iTb(a,UYb);d=KTb(a,b);iTb(a,NXb);e=KTb(a,b);return new p$b(new Z1b(f,a.f),c,d,e)}return c}function kLb(a,b){var c,d,e,f;bKb(a.a,b,(IRb(),EQb));f=dKb(a.a,(Afc(),Acc));for(d=b.a.Vd();d.Id();){c=d.Jd();c.p==(n1b(),$_b)?e=uLb(a,c):e=AKb(a.a,c);q8b(f,e)}return f}function k4b(a,b){!a.d&&(a.d=new L5b);if(b5b(a,b)||(a.a&HPc)==hMc)return false;if(!a.d.r)a.d.r=new fxc;else if(_wc(a.d.r,b,0)!=-1)return false;Ywc(a.d.r,b);return true}function oyc(a){var b,
c,d,e;d=xyc(a.a);b=-2128831035^d;for(c=0;c<=d;c++){e=a.a[c]|0;b=b*LTc&-1^e&255;b=b*LTc&-1^e>>>8&255;b=b*LTc&-1^e>>>16&255;b=b*LTc&-1^e>>>24}return b}function zg(a){var b,c,d;d=new hGc(iLc,"{","}");for(c=a.He().Vd();c.Id();){b=c.Jd();eGc(d,Ag(a,b.Ve())+"="+Ag(a,b.We()))}return!d.a?d.c:d.e.length==0?d.a.a:d.a.a+(""+d.e)}function spb(a){var b,c,d,e;c=a.c;e=new stc;for(d=c;d;d=d.f){b=d.n==(Afc(),Aec)||Nqb(d)||d.n==tdc?"":Ypb(d);if(b==null)return null;d!=c&&(e.a+=",",e);e.a+=""+b}return e.a}function Uqc(a,
b){if(b<2||b>36)return-1;if(a>=48&&a<48+$wnd.Math.min(b,10))return a-48;if(a>=97&&a<b+97-10)return a-97+10;if(a>=65&&a<b+65-10)return a-65+10;return-1}function b$(){b$=JZ;ZZ=new c$(zMc,0,"\u001b[31m");a$=new c$(AMc,1,"\u001b[35m");$Z=new c$("NO_COLOR",2,"\u001b[39m");YZ=new c$("BOLD",3,"\u001b[1m");_Z=new c$("UNBOLD",4,"\u001b[0m")}function tib(a,b){var c,d;c=F9b(Phb(a.c.r.a,"$jscomp$generator$arguments"),b);j9b(b.g,b,c);if(!a.c.b){d=F9b(q3b(c.Sh(false),b,(Afc(),ufc)),a.c.r.c);ghb(a.c.r,d);a.c.b=
true}}function Clb(a,b,c,d,e,f){var g,h;h=Xtc(a.q,d);ae(!h,"Refs already exist for node: %s",h);g=new Ulb(b,Sd(c),Sd(d),a,e,f);jDc(a.p,g);$tc(a.q,d,(Bn(),new Wz(Sd(g))));Hlb(a,g)}function LLb(a,b,c){var d,e;if(c)e=iKb(a.a,(Afc(),bfc),b.a);else{d=WJb(a.a,b);fLb(a,b);e=iKb(a.a,(Afc(),rec),b.a);!!d&&(d9b(e,(Hbc(),mbc),d),e)}vKb(e,b.d.b,b.d.a);return e}function ETb(a){var b,c,d;b=wVb(a,0);for(d=b.b.Vd();d.Id();){c=d.Jd();!!c.b&&VVb(a,"Ambient variable declaration may not have initializer",CE(xE(iW,1),
mLc,1,5,[]))}return b}function z3b(a,b,c){var d,e,f,g,h;Xd(H3b(a));h=new N9b((Afc(),Pdc),a,(n8b(),new Wbc(bfc,b)));for(e=c,f=0,g=e.length;f<g;++f){d=e[f];h=new N9b(Pdc,h,new Wbc(bfc,d))}return h}function Mic(a,b){var c,d,e,f,g;c=F8b(a.b);if(!!c&&E8b(c,(Hbc(),Ebc))!=0)return false;for(e=b,f=0,g=e.length;f<g;++f){d=e[f];c9b(Pic(a,Ukc(a.a,d)),(Hbc(),qbc),1)}return true}function M6(a){var b;if(!a.B||Vt(Tt(Wt(new eyc(a.B.a),new lnb))))throw gZ(new Irc("No inputs"));b=su(new Tu(wu($t(Tt(Wt(new eyc(a.B.a),
new lnb)).a),new Xt)));return x8(b,a)}function F7(a,b,c){var d,e;d=new j5(b);i5(d,(!a.P&&(a.P=new llc),a.P));f5(d,a.G);h5(d,(e=H8b(b,(Hbc(),ybc)),!(!!e&&e.Kh())&&a.G.zb==($9(),X9)));g5(d,c&&r9(a.G));return e5(d)}function kTb(a){var b;b=wTb(a);if(b.e==(AZb(),iYb))return b;else{OSb();if(QSb(b.e))return new PRb(b.d,QSb(b.e).c);else SVb(a,b,SSc,CE(xE(iW,1),mLc,1,5,[iYb]))}return null}function WWb(a){yWb(a);if(jXb(xWb(a,a.f)?zsc(a.b,a.f):0)){FWb(a,"New line not allowed in regular expression literal",CE(xE(iW,
1),mLc,1,5,[]));return false}yWb(a);return true}function UDc(){function b(){try{return(new Map).entries().next().done}catch(a){return false}}if(typeof Map===ZKc&&Map.prototype.entries&&b())return Map;else return VDc()}function z$(a){var b,c;for(b=a.c;b;b=b.g)if(x$.Sd(b.n))return b.n;ce((c=s$(a.b),!!c&&Pqb(a.d.d)),"The nameNode for %s must be a descendant of one of: %s",a,x$);return null}function C7(a,b){var c,d,e;d="INTERNAL COMPILER ERROR.\nPlease report this problem.\n\n"+a;c=new HD(d,b);!!b&&EB(c,
(b.i==null&&(b.i=(iE(),e=hE.gg(b),kE(e))),b.i));throw gZ(c);}function ELb(a,b){var c,d,e,f,g;f=dKb(a.a,(Afc(),Ndc));for(e=new TEc(new KEc(b.a));e.b!=e.c.a.b;){d=REc(e);g=iKb(a.a,Mdc,d.d.a);c=d.e;!!c&&q8b(g,yKb(a.a,c));q8b(f,g)}return f}function s8b(a,b,c){var d,e,f;if(!b)return;Kd(!c||c.g==a);Td(b.i,b);if(!c){u8b(a,b);return}for(d=b;d;d=d.f){Kd(!d.g);d.g=a}e=b.i;f=c.f;e.f=f;!f?a.c.i=e:f.i=e;c.f=b;b.i=c}function Zb(a){var b,c,d,e;e=a.length;for(d=0;d<e;d++)if(Yb(a.charCodeAt(d))){c=Wsc(a);for(;d<e;d++){b=
c[d];b>=65&&b<=90&&(c[d]=(b^32)&dLc)}return gtc(c,0,c.length)}return a}function $b(a){var b,c,d,e;e=a.length;for(d=0;d<e;d++)if(Xb(a.charCodeAt(d))){c=Wsc(a);for(;d<e;d++){b=c[d];b>=97&&b<=122&&(c[d]=(b^32)&dLc)}return gtc(c,0,c.length)}return a}function Bt(a,b){wt();var c,d;Sd(a);if(!b.Id())return Sd(a),vt==a?ut:new oz(new DHc(a));c=new DHc(a);while(b.Id()){d=b.Jd();Sd(d);c.a.Je(d,(Nqc(),Lqc))==null}return new oz(c)}function ulb(a,b,c,d,e,f){var g;if(ylb(a,b,c,d,e,f))return;g=plb(a,f);E8b(d,(n8b(),
e8b))!=0;e.n==(Afc(),Ccc)&&e.g.n!=Ddc?klb(a,g,d,(cmb(),amb),b,c):jlb(a,g,d,(cmb(),amb),b,c)}function w7b(a){if((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc||W4b(a.a)||(a.a.a&JPc)!=0||(a.a.a&vMc)!=0||(a.a.a&IPc)!=0)return false;a.a.a|=IPc;a.e=true;return true}function Ync(a,b){var c,d,e;e=(Bn(),new Zr);Yr(e,a.c.wf(0,a.d.Yd()));for(c=a.d.Yd();c<a.c.Yd();c++){d=a.c.ce(c);!!d&&Azc(b.b,d)||(Ywc(e.a,Sd(d)),e)}return Xkc(a.a,In(e.a),a.d)}function vib(a,b){var c,d;c=Yjb(Phb(a.c.r.a,"$jscomp$generator$this"),
b.d);j9b(b.g,b,c);if(!a.c.s){d=F9b(q3b(F9b(c.Sh(false),b),b,(Afc(),ufc)),a.c.r.c);ghb(a.c.r,d);a.c.s=true}}function xtb(a){var b;Yd(a.n==(Afc(),Ycc),a);b=a.c;while(b.n==_cc)b=b.c;ppb();b.n==Pdc||b.n==Odc||b9b(a,(n8b(),W7b),true);b.n==rec&&Esc("eval",b.Wh())&&b9b(b,(n8b(),R7b),true)}function jUb(a){var b,c;b=(Bn(),new Zr);iTb(a,(AZb(),FYb));while(c=DWb(a.g,0).e,iYb==c||(OSb(),OSb(),!!Po(pSb,c))){Xr(b,iUb(a));AVb(a,KXb)||iTb(a,OXb)}iTb(a,KXb);return In(b.a)}function AUb(a){var b,c;b=(Bn(),new Zr);iTb(a,
(AZb(),FYb));while(c=DWb(a.g,0).e,iYb==c||(OSb(),OSb(),!!Po(pSb,c))){Xr(b,zUb(a));AVb(a,KXb)||iTb(a,OXb)}iTb(a,KXb);return In(b.a)}function OC(a){var b,c,d,e,f;bD(new dD(a),new eD);c=0;f=0;for(e=new wxc(a.e);e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);if(d.f){++c;b=d.a.b;f=$wnd.Math.max(f,b)}}return f+a.i.b}function meb(a){ieb();this.c=a;this.a=false;this.e=(!a.P&&(a.P=new llc),a.P);this.g=Wjb(this.a,this.e,51);this.f=Wjb(this.a,this.e,45);this.b=Wjb(this.a,this.e,8);this.d=new Jbb}function Qib(a,
b){var c,d;c=b;while(c.n!=(Afc(),Vdc))c=c.g;d=Rib(a,c);if(b.g.n==Wdc)return d+"."+b.g.c.Wh();else if(b.n==Ydc)return d;else{Xd(b.g.n==Vdc);return d+".default"}}function xMb(){xMb=JZ;vMb=(bn(),pp(CE(xE(iW,1),mLc,1,5,[FMc,BMc])));uMb=pp(CE(xE(iW,1),mLc,1,5,[SRc,TRc,"stable","mapped","xid"]));wMb=pp(CE(xE(iW,1),mLc,1,5,[YKc,$Kc,XKc,sRc]))}function CVb(a){switch(DWb(a.g,0).e.f){case 82:case 85:case 86:case 95:case 87:case 83:case 84:case 88:case 89:case 90:case 91:case 93:case 92:return true;default:return false}}
function I8b(a){var b,c;switch(a.n.f){case 29:c=a.Wh();return c.length==0?null:c;case 26:b=J8b(a,0);return b?b.a:null;case 33:return FMc;case 99:return DMc;default:return null}}function Xxc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];eGc(f,""+b)}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function byc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];eGc(f,""+b)}return!f.a?f.c:f.e.length==
0?f.a.a:f.a.a+(""+f.e)}function qz(b,c){var d;if(uF(b)===uF(c))return true;if(pF(c,35)){d=c;try{return b.Yd()==d.Yd()&&b.Td(d)}catch(a){a=fZ(a);if(pF(a,42))return false;else throw gZ(a);}}return false}function m0(a,b,c){var d,e;b0((Afc(),Sec),c);e=Cfc(c.n);e!=-1&&(d=C8b(c),e!=d&&D0(QMc+e+RMc+d,c));R_(a,b,c.c);!!c.f&&D0("Rest parameters must come after all other parameters.",c)}function d0(b){var c,d;b0((Afc(),Cec),b);d=Cfc(b.n);d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b));try{b.Uh()}catch(a){a=fZ(a);
if(pF(a,28))D0("Invalid NUMBER node.",b);else throw gZ(a);}}function s0(b){var c,d;b0((Afc(),bfc),b);d=Cfc(b.n);d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b));try{b.Wh()}catch(a){a=fZ(a);if(pF(a,28))D0("Invalid STRING node.",b);else throw gZ(a);}}function v4(a,b,c,d){var e;if(d.b&&b.n==(Afc(),Zdc)||(ppb(),Mqb(b.n)&&(e=b.g,!!e&&e.n==(Afc(),zdc)&&e.c==b)||H4(a,b)<c)){L3(a.c,"(");a.fh(b,(_4(),W4));L3(a.c,")")}else a.fh(b,d)}function rj(a,b,c){var d,e,f,g;if(c==0)return e=Bx(a.a,b),!e?0:e.a;Nd(c>0,HLc,c);
d=Xtc(a.a,b);if(!d)return 0;g=d.a;if(g>c)f=c;else{f=g;auc(a.a,b)}d.a+=-f;a.b=vZ(a.b,f);return g}function tEb(){tEb=JZ;sEb=new Mcb("JSC_INVALID_AMBIGUOUS_PATH",(E2(),B2),new Rtc('The path "{0}" is invalid. Expected any of the following prefixes for non-relative paths: {1}.'))}function rKb(a,b){var c,d;d=k6b(a.f);!!d&&(d9b(b,(Hbc(),mbc),d),b);if(a.g){if(!!H8b(b,(Hbc(),mbc))&&D4b(H8b(b,mbc))!=null){c=D7b(a.g);T6b(c,D4b(H8b(b,mbc)));a.g=k6b(c)}q9b(b,a.g)}}function hLb(a){var b,c,d;c=null;while(ZKb(a.c)){b=
g9b(a).c.Wh();!c&&(c=new Rs);Ywc(c.b,Sd(b))}if(c){d=np(new wxc(c.b));d.Yd()==1&&d.Sd(ANc)&&(d=(RJb(),QJb));d9b(a,(Hbc(),Qac),d)}}function H$b(a){IZb.call(this,(n1b(),m0b),a.k);this.k=a.n;this.d=a.d;this.i=a.i;this.f=a.f;this.g=a.g;this.a=a.a;this.j=Sd(a.j);this.b=Sd(a.b);this.n=a.o;this.c=Sd(a.c);this.e=a.e}function e9b(a,b){var c,d,e;ce(b.g==a,qTc,a,b);Sd(b.i);c=a.c.i;e=b.i;d=b.f;if(a.c==b){a.c=d;!!d&&(d.i=c)}else if(b==c){a.c.i=e;e.f=null}else{e.f=d;d.i=e}b.f=null;b.i=null;b.g=null}function MEb(){MEb=
JZ;KEb=new NEb("GOOG_REQUIRE_SYMBOL",0);JEb=new NEb("ES6_IMPORT",1);LEb=new NEb("PARSED_FROM_DEPS",2);HEb=new NEb("COMMON_JS",3);IEb=new NEb("COMPILER_MODULE",4)}function P3b(a){var b,c,d,e,f;b=new J9b((Afc(),Eec));for(d=a,e=0,f=d.length;e<f;++e){c=d[e];Xd(c.n==cfc||c.n==mec||c.n==Qdc||c.n==Yec);c.n==cfc||Xd(!!c.c&&!c.c.f);q8b(b,c)}return b}function t0(a,b){var c,d;b0((Afc(),gfc),b);U_(b);E_(a,b.c);d=0;for(c=b.c.f;c;c=c.f){u0(a,b.c?b.c.i:null);c.n==ldc&&++d}d>1&&D0("Expected at most 1 'default' in switch but was "+
d,b)}function G6(a){var b;if(a.n==(Afc(),Xec))return a;b=Fpb(a.g);if(!b)throw gZ(new Irc("An enclosing scope is required for change reports but node "+a+" doesn't have one."));return b}function OBb(a,b,c,d){var e,f,g,h,i;h=wjc(c);g=vjc(c);e=Hn(xjc(c));for(f=0;f<e.Yd();f++){b.a+=mRc;aCb(b,"param",WBb(a,e,f,h,g));i=VBb(d,f);ptc(ptc((b.a+=" ",b),i),gMc);!!d&&(d=d.f)}}function QOb(a,b){var c;b.n==(Afc(),zec)?c=POb(a,b.c):c=POb(a,b.c)&&POb(a,b.c.f);if(!c){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[XKc])),
a.b.ug(),a.d,a.c);return false}return true}function mbb(a,b){var c,d,e,f;for(f=(d=(new Yvc(a.c.a)).a.He().b.vj(),new ewc(d));f.a.Id();){e=(c=f.a.Jd(),c.Ve());if(e.uh(b))return true;else if(e.th(b))return false}return false}function rfb(a){var b,c,d,e;if(a.b.a.Yd()!=0)for(d=(e=(new Wuc(a.b.a)).a.He().Vd(),new avc(e));d.a.Id();){c=(b=d.a.Jd(),b.Ve());c.n==(Afc(),gdc)&&qfb(a,c,c.g);A9b(c,ufc);w7(a.a,c)}}function Tqb(a,b){ppb();var c,d,e,f,g,h;d=!(a.n==(Afc(),Pdc)||a.n==Odc);c=l3b(a,CE(xE(HU,1),IMc,7,
0,[]));b9b(c,(n8b(),W7b),d);for(f=b,g=0,h=f.length;g<h;++g){e=f[g];q8b(c,e)}return c}function vsb(a,b){var c,d;tsb(a);if(a.D==(Xab(),Wab))return;b.c=a.q=a.b=xpb(a.u);if(!(a.D==Vab||a.D==Sab))return;c=Gsb((d=a.u,a.D==Sab,d));b.o=a.r=a.e=c.b;a.D==Sab&&(b.g=a.s=a.o=0)}function Lub(){Lub=JZ;Kub=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),IQb),YQb]));Jub=new Mcb("JSC_CANNOT_CONVERT_ASYNCGEN",(E2(),B2),new Rtc("Cannot convert async generator. {0}"))}function x5b(a,b,c){if((a.a&HPc)!=0)throw gZ(new Irc("API tried to add two incompatible type tags. This should have been blocked and emitted a warning."));
a.a=a.a&1073741823|c;a.i=b}function r6b(a){if(!((a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&!W4b(a.a)&&(a.a.a&tQc)==0&&(a.a.a&32)==0&&a.a.j!=(e6b(),b6b)){a.a.a|=tQc;a.e=true;return true}return false}function gl(a,b,c,d){Ld((c&JLc)==0,"flatMap does not support SUBSIZED characteristic");Ld((c&4)==0,"flatMap does not support SORTED characteristic");Sd(a);Sd(b);return new vl(a,c,d,b)}function Co(a){oo();var b,c,d;d=a.a.length;switch(d){case 0:return no;case 1:b=tu(new wxc(a));return Ho(b.Ve(),
b.We());default:c=exc(a,zE(QX,PLc,50,a.a.length,0,1));return new kz(c)}}function w_(a,b){var c;F_(a,(IRb(),PQb),b);b0((Afc(),fdc),b);E_(a,b.c);if(E8b(b,(n8b(),P7b))!=0){c=C8b(b);1!=c&&D0(UMc+c,b)}else{c=C8b(b);2!=c&&D0(PMc+c,b);G_(a,b.c?b.c.i:null,false)}}function uLb(a,b){var c,d,e;bKb(a.a,b,(IRb(),SQb));e=b.b;e.p==(n1b(),q0b)?d=MLb(a,e.a):d=AKb(a.a,e);c=fKb(a.a,(Afc(),mdc),d,yKb(a.a,b.a));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);return c}function xLb(a,b){var c,d,e;e=LLb(a,b.b,true);A9b(e,(Afc(),rec));
d=eKb(a.a,Bdc,e);if(!b.a){c9b(d,(Hbc(),kbc),1);q8b(d,x8b(e,false))}else{c=LLb(a,b.a,true);A9b(c,rec);q8b(d,c)}return d}function Msc(a,b,c,d,e,f){var g,h;if(c<0||e<0)return false;if(c+f>a.length||e+f>d.length)return false;if(f<=0)return true;g=a.substr(c,f);h=d.substr(e,f);return b?Fsc(g,h):Esc(g,h)}function v0(a,b){var c,d,e;F_(a,(IRb(),CRb),b);b0((Afc(),ifc),b);for(c=b.c;c;c=c.f)c.n==jfc?w0(c):(b0(kfc,c),d=Cfc(c.n),d!=-1&&(e=C8b(c),d!=e&&D0(QMc+d+RMc+e,c)),E_(a,c.c),undefined)}function wdb(a,b){var c,
d,e;if(a.n!=(Afc(),Ddc))return null;c=a.c;if(c.n!=Ycc)return null;e=c.c;if(!a9b(e,bOc,bOc.length))return null;d=Sd(e.f);return a9b(d,b,b.length)?Sd(d.f):null}function agb(a,b){var c,d,e;c=E8b(a,(Hbc(),zbc))!=0?x8b(b.g,false):x8b(b.d,false);Z8b(c);if(a.n==(Afc(),fdc))return I9b((e=w3b(c,g9b(a)),e),a);else{d=a.c.c;return G9b(O$(c,a.Wh()),d)}}function Jgb(a,b,c,d,e,f){Ld((ppb(),f.n!=(Afc(),pec)&&Jqb(f.g)),f);switch(c.n.f){case 93:Hgb(a,b,c,d,e,f);break;case 94:Igb(a,b,c,d,e,f);break;default:throw gZ(new Irc("unexpected"));
}}function cpb(b,c,d){var e,f;try{e=c.g;Sd(e);Qob(b,e);b.e=e;Sob(b,e);Zob(b,c,e);Xd(d.g==e);Zob(b,d,e);Rob(b,false)}catch(a){a=fZ(a);if(pF(a,80)||pF(a,38)){f=a;Xob(b,f)}else throw gZ(a);}}function eqb(a,b){ppb();var c;c=b.g;if(c.n==(Afc(),Pdc)&&b==(c.c?c.c.i:null))return a.Gg(b.Wh());else if(Sqb(b))return a.Gg(b.Wh());else if(b.n==rec)return a.Fg(b.Wh());return false}function gqb(a){ppb();switch(a.n.f){case 72:case 73:case 101:case 102:case 71:case 70:case 77:case 66:case 83:case 44:case 78:case 67:case 68:case 69:return true;
default:return false}}function Evb(a,b,c){var d,e,f,g,h;h=b.c;while(!!h&&h!=c){g=h.f;ppb();if(h.n==(Afc(),Ddc)&&h.c.n==Ycc){d=h.c;e=d.c;if(a9b(e,WQc,WQc.length)){f=BQb(e.f.f.f.Wh());Dvb(a,f)&&crb(b,h)}}h=g}}function bFb(a,b,c,d,e){ZEb();Sd(a);Sd(b);Sd(d);Sd(e);this.f=d;this.e=e;this.a=new sFb;this.d=cFb(a,e);this.b=eFb(Wt(Wt(b,new fFb),d),this.d,e);this.c=c.Nh(this.b,this.d,this.a,this.e)}function xUb(a){var b,c,d,e;e=DWb(a.g,0).d.b;iTb(a,(AZb(),jYb));iTb(a,GYb);b=xTb(a,1);iTb(a,LXb);d=hVb(a);c=null;
if(AVb(a,WXb)){iTb(a,WXb);c=hVb(a)}return new d_b(new Z1b(e,a.f),b,d,c)}function rUb(a){var b,c,d;d=DWb(a.g,0).d.b;iTb(a,(OSb(),hSb).b);c=!!mTb(a,(AZb(),bZb));b=P$b(new T$b((Y$b(),V$b)),jTb(a));sUb(a,b,c?(pWb(),nWb):(pWb(),oWb));return I$b(b,new Z1b(d,a.f))}function _sc(a){var b,c;if(a>=kMc){b=55296+(a-kMc>>10&mMc)&dLc;c=56320+(a-kMc&mMc)&dLc;return String.fromCharCode(b)+(""+String.fromCharCode(c))}else return String.fromCharCode(a&dLc)}function lkb(a,b,c){var d;if(b.n==(Afc(),Ccc)){d=b.c;switch(d.n.f){case 29:return true;
case 26:return!kkb(a,d.c,c);case 27:return!kkb(a,d.c,c)&&!kkb(a,d.c?d.c.i:null,c)}}return false}function ykb(a,b){var c;c=Akb(a,b);Esc(c.substr(0,5),"goog.")&&u8((!a.d&&!!a.i&&(a.d=L6(a.c,a.i)),a.d),(wDb(),vDb));u8((!a.d&&!!a.i&&(a.d=L6(a.c,a.i)),a.d),ADb(c,(b.c?b.c.i:null).Wh()))}function ysb(a,b,c){this.d=new oub;this.f=new Cwc;this.w=new fxc;Ld(c!=(Xab(),Uab),"PerformanceTracker can't work without tracer data.");this.H=mZ(Date.now());this.n=a;this.u=b;this.D=c}function SEb(a,b){var c;if(Ztc(a.b,
b))return Ytc(a.b,b);return pEc(a.e,(RFb(),UFb((c=Osc(Osc(Osc(Osc(Osc(Nsc(Nsc(b,58,45),92,47)," ",cNc),"[",dNc),"]",eNc),"<",fNc),">",gNc),SFb(c)))))}function aPb(a,b,c){var d;for(d=0;d<c;d++)if(!NOb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,d+1)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[XKc])),a.b.ug(),a.d,a.c);return false}return true}function fPb(a,b,c){var d;for(d=0;d<c;d++)if(!gPb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,d+1)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[XKc])),a.b.ug(),a.d,a.c);return false}return true}
function iPb(a,b,c){var d;for(d=0;d<c;d++)if(!hPb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,d+1)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[XKc])),a.b.ug(),a.d,a.c);return false}return true}function h7(a){var b,c;b=new Txb;if(NHc(a.u,b.a))throw gZ(new qnb("Conflicting externs name: {SyntheticVarsDeclar}"));c=new G8(b,true);r7(a,c.i,c);r8b(a.o,Sd(b.b));Xwc(a.k,0,c);return c}function shb(a,b){var c,d,e;e=new fxc;while(b.n==(Afc(),eec)){Ywc(e,g9b(b));b=g9b(b)}d=Aqb(b)?new pib(a.a):null;c=new pib(a.a);Zhb(a.a,
e,c,d);thb(a,b,c,d);Whb(a.a,e);c!=a.a.j&&cib(a.a,c)}function ZVb(a,b,c,d,e){this.a=new _Vb(this);this.e=new Cwc;this.d=(iQb(),TPb);this.b=a;this.c=b;this.g=new fXb(a.d,b,this.a,c,d);lwc(this.e,e?(pWb(),nWb):(pWb(),oWb));this.f=vWb(this.g)}function iWb(){iWb=JZ;bWb=new jWb("ES3",0);cWb=new jWb("ES5",1);dWb=new jWb("ES6_OR_ES7",2);eWb=new jWb("ES8_OR_GREATER",3);fWb=new jWb("ES_NEXT",4);hWb=new jWb(BOc,5);gWb=new jWb(JRc,6)}function pWb(){pWb=JZ;oWb=new qWb("NORMAL",0,false,false);nWb=new qWb("GENERATOR",
1,true,false);lWb=new qWb("ASYNCHRONOUS",2,false,true);mWb=new qWb("ASYNCHRONOUS_GENERATOR",3,true,true)}function Dx(a){var b,c,d,e;e=itc((fl(a.Yd(),"size"),new ttc),123);d=true;for(c=po(a).Vd();c.Id();){b=c.Jd();d||(e.a+=iLc,e);d=false;otc(itc(otc(e,b.Ve()),61),b.We())}return(e.a+="}",e).a}function k2(){k2=JZ;j2=new Mcb("JSC_DEBUGGER_STATEMENT_PRESENT",(E2(),C2),new Rtc("Using the debugger statement can halt your application if the user has a JavaScript debugger running."))}function d7(a,b){var c,
d,e,f,g;e=b.d;f=e.a.length;if(f==0)return"";c=new _7;for(d=0;d<f;d++){g=x8(e.a[d],a);if(!g)throw gZ(new qnb("Bad module: "+b.e));r8(new p8(a,c,g,d))}return c.c.a}function plb(a,b){var c,d,e,f;d=Ytc(a.a.g,b);if(!d){c=Jsc(b,_sc(46));if(c>=0){f=b.substr(0,c);e=plb(a,f);d=Blb(e,b.substr(c+1))}else{d=new Ilb(b,null);Ywc(a.a.f,d)}_tc(a.a.g,b,d)}return d}function Qsb(a,b,c){var d,e;a.k=0;a.o=0;if(a.n){a.o=(a.n.b-a.n.a)/a.i.a.length;a.k=a.n.a}for(e=new wxc(a.i);e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);
d.wg(b,c);if(a.b.g.a.d!=0)return}}function TFb(a){RFb();var b,c;c=fOc.length;if(Esc(a.substr(a.length-c,c),fOc)){a=Vsc(a,0,a.length-3);b=".js.i".length;Esc(a.substr(a.length-b,b),".js.i")&&(a=Vsc(a,0,a.length-5))}return a}function UFb(a){RFb();Esc(a.substr(0,1),"/")&&(a=a.substr(1));return hOc+Osc(Nsc(Nsc(Nsc(Nsc(Nsc(Nsc(Osc(Qsc(TFb(a),"^\\./",""),"/","$"),92,36),64,36),43,36),45,95),58,95),46,95),cNc,"_")}function uGc(a,b,c,d){var e,f;f=b;e=f.d==null||a.a.lf(c.d,f.d)>0?1:0;while(f.a[e]!=c){f=f.a[e];
e=a.a.lf(c.d,f.d)>0?1:0}f.a[e]=d;d.b=c.b;d.a[0]=c.a[0];d.a[1]=c.a[1];c.a[0]=null;c.a[1]=null}function Wc(a){var b,c,d;d=new hGc(iLc,"[","]");for(c=a.Vd();c.Id();){b=c.Jd();eGc(d,uF(b)===uF(a)?"(this Collection)":b==null?jLc:NZ(b))}return!d.a?d.c:d.e.length==0?d.a.a:d.a.a+(""+d.e)}function qNb(a,b){var c;if(b==(fOb(),WNb)){xNb(a);c=pNb(a,!a.o?mOb(a.j):GMb(a));if(c){xNb(a);OMb(a,aOb)?!a.o?mOb(a.j):GMb(a):(CMb(a,YRc,a.j.g,lOb(a.j)),null)}return c}else return pNb(a,b)}function k0(a,b){var c;b0((Afc(),
Jec),b);for(c=b.c;c;c=c.f)if(c.n==Sec)n0(a,Jec,c);else if(c.n==mdc){F_(a,(IRb(),SQb),c);x_(a,Jec,c)}else c.n==rec?W_(c):c.n==Acc?l_(a,Jec,c):h0(a,Jec,c)}function usb(a,b){var c,d,e;e=xpb(a.u);b.b=a.b-e;a.b=b.c=e;if(!(a.D==(Xab(),Vab)||a.D==Sab))return;c=Gsb((d=a.u,a.D==Sab,d));e=c.b;b.e=a.e-e;a.e=b.o=e;if(a.D==Sab){e=0;b.f=a.o-e;a.o=b.g=e}}function Psb(b,c,d,e){var f;if(!b.r)return;try{tCb(W7(b.b),d,e);I1(b.a,c,b.d)}catch(a){a=fZ(a);if(pF(a,38)){f=a;throw gZ(new Jrc("Validity checks failed for pass: "+
c,f));}else throw gZ(a);}}function KUb(a,b,c,d,e,f){var g;g=M$b(R$b(L$b(O$b(J$b(Q$b(N$b(S$b(P$b(new T$b((Y$b(),X$b)),c),d),e),false),f),tTb(a)),pUb(a,1)),sTb(a)),new w$b(new Z1b(b,a.f)));return I$b(g,new Z1b(b,a.f))}function wjc(a){var b,c,d,e,f;b=0;c=0;for(e=(f=a.b.a,f?!f.c?(Cyc(),Cyc(),Byc):new Kbc(f.c):(Cyc(),Cyc(),Byc)).Vd();e.Id();){d=e.Jd();++b;E8b(d,(Hbc(),qbc))==0&&E8b(d,Ebc)==0&&(c=b)}return c}function Hxc(a,b){var c;if(uF(a)===uF(b))return true;if(a==null||b==null)return false;if(a.length!=
b.length)return false;for(c=0;c<a.length;++c)if(a[c]!==b[c])return false;return true}function dCc(){dCc=JZ;bCc=CE(xE(nW,1),uNc,2,6,["Sun","Mon","Tue","Wed","Thu","Fri","Sat"]);cCc=CE(xE(nW,1),uNc,2,6,["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"])}function HZ(){GZ={};!Array.isArray&&(Array.isArray=function(a){return Object.prototype.toString.call(a)==="[object Array]"});function b(){return(new Date).getTime()}!Date.now&&(Date.now=b)}function H7(a){var b,c;c=(a.G.pd!=(Xab(),
Uab)&&!!a.O&&wsb(a.O,mOc,true),new hyb);try{!a.I&&(a.I=new CGb(a.a));Cyc();Tyc()}finally{b=vZ(mZ(Date.now()),c.a);a.G.pd!=Uab&&!!a.O&&xsb(a.O,mOc,b)}}function xkb(a,b){var c,d;for(c=b.e;c;c=c.g)if(c.n==(Afc(),Xec))return c;if(b.f==null)return null;d=P6(a.b,b.f);if(d){if(d.n!=(Afc(),Xec))return null;Yd(d.n==Xec,d);return d}return null}function MCb(a,b){ICb();var c,d;c=(ae(Hsc(b,_sc(46))==-1,HMc,b),n8b(),new Wbc((Afc(),rec),b));H6(a).Fg(b)&&b9b(c,a8b,true);d=r3b(c,ufc);q8b(x8((!a.N&&(a.N=h7(a)),a.N),
a),d);s7(a,G6(d));i7(a)}function EMb(a,b){var c,d;for(d=new wxc(b);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);W4b(a.f.a)?I6b(a.f,c.c)||zMb(a,"msg.jsdoc.extends.duplicate",c.b,c.a):s6b(a.f,c.c)||CMb(a,WRc,c.b,c.a)}}function EUb(a){var b,c;c=(Bn(),new Zr);while(HVb(a)){Xr(c,DUb(a));AVb(a,(AZb(),KXb))||(b=DWb(a.g,0).d.b.b>a.f.b,b||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb)?nTb(a):iTb(a,OXb))}return In(c.a)}function s5(a){if(a.o<=a.p)return;if(a.d>a.b&&a.d<a.b+a.o){rtc(a.j,a.d,String.fromCharCode(10));
a.e=a.d;l5(a,a.n,a.d-a.b,true);++a.n;a.o-=a.d-a.b;a.g=a.b;a.b=a.d+1;a.f=a.u==a.v+1}else t5(a)}function nbb(a,b){var c,d,e,f,g;for(f=(d=(new Yvc(a.c.a)).a.He().b.vj(),new ewc(d));f.a.Id();){e=(c=f.a.Jd(),c.Ve());g=e.wh(b);if(g){if(a.a&&g==(E2(),B2))return E2(),D2;return g}}return null}function AOb(){var a;if(vOb)return;a=qFc(hSc);vOb=zOb(oFc(a,"jsdoc.annotations"));xOb=zOb(oFc(a,"jsdoc.suppressions"));wOb=zOb(oFc(a,"jsdoc.primitives"));zOb(oFc(a,"compiler.reserved.vars"))}function fnc(a,b){var c,d,
e,f,g;g=a.b.Ie(b);if(g)return g;f=dnc(a);if(f){g=fnc(f,b);if(g)return g}for(d=enc(a).Vd();d.Id();){c=d.Jd();e=c.Vi();if(e){g=fnc(e,b);if(g)return g}}return null}function Yeb(a,b,c,d){var e,f;Xd(c.n==(Afc(),Jdc));c9b(c,(Hbc(),Fac),0);e=c.c?c.c.i:null;if(e.n!=Vcc){z8b(e);e=I9b(j3b((Xd(H3b(e)),new L9b(Uec,e))),e);q8b(c,e)}f=new efb(d);epb(a.a,e,f);Vob(b)}function hhb(a,b){Xd(b.n==(Afc(),Vcc));if(!b.c)return false;switch((b.c?b.c.i:null).n.f){case 82:return hhb(a,b.c?b.c.i:null);case 0:case 39:case 75:case 74:return true;
default:return false}}function whb(a,b){var c;Xd(E8b(b,(Hbc(),gbc))==0);if(b.n==(Afc(),Jdc)){c=b.c.Wh();Xd(c.length!=0&&!Esc(c.substr(0,26),MPc));p8b(a.c,b,F8b(a.c));return}dib(a.a,b.n==Vcc||E8b(b,Eac)!=0?b:j3b(b))}function Xib(a,b,c,d){var e,f;e=c.c;ppb();if(!!e&&(e.n==(Afc(),ufc)||e.n==jec||e.n==gdc))$ib(a,e);else{Xd(e.n==(Afc(),Jdc)||e.n==bdc);f=e.c.Wh();qGc(a.b,f,new Mib(f,c))}j9b(d,c,z8b(e));Vob(b)}function w0(b){var c,d;b0((Afc(),jfc),b);d=Cfc(b.n);d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b));
try{b.Vh()}catch(a){a=fZ(a);if(pF(a,28))D0("Invalid TEMPLATELIT_STRING node.",b);else throw gZ(a);}}function ceb(a,b,c,d){var e,f,g,h;for(f=new Rwc(a.a);f.a!=f.b;){e=Pwc(f);if(c!=e.a&&$8b(c,e.a)){h=i$(Kob(b),c.Wh());if(!!h&&h.c==e.a){g=F9b(r9b(K3b(e.b),c.d),c);j9b(d,c,g);w7(a.b.b,g);return}}}}function Lpb(a,b){ppb();var c,d;Xd(a.n==(Afc(),Eec)||a.n==cdc);for(d=(!a.c?(Cyc(),Cyc(),Byc):new Kbc(a.c)).Vd();d.Id();){c=d.Jd();if((c.n==cfc||c.n==mec)&&Esc(c.Wh(),b))return c.c}return null}function Brc(a){Arc==
null&&(Arc=new RegExp("^\\s*[+-]?(NaN|Infinity|((\\d+\\.?\\d*)|(\\.\\d+))([eE][+-]?\\d+)?[dDfF]?)\\s*$"));if(!Arc.test(a))throw gZ(new usc(ITc+a+'"'));return parseFloat(a)}function syc(a,b){var c,d;if(b==-1)return-1;uyc(b);c=b/31|0;if(c>=a.a.length)return pyc(a)-1;d=(a.a[c]|0)&_Kc>>>31-b%31-1;while(d==0){if(--c<0)return-1;d=a.a[c]|0}return c*31+(32-Trc(d))-1}function EIc(a,b){var c,d,e,f,g,h,i;for(d=IIc(a),f=0,h=d.length;f<h;++f)SIc(b);i=!zIc&&a.e?zIc?null:a.d:null;while(i){for(c=IIc(i),e=0,g=c.length;e<
g;++e)SIc(b);i=!zIc&&i.e?zIc?null:i.d:null}}function vg(a,b){var c,d,e;if(uF(b)===uF(a))return true;if(!pF(b,51))return false;e=b;if(a.Yd()!=e.Yd())return false;for(d=e.He().Vd();d.Id();){c=d.Jd();if(!a.Fe(c))return false}return true}function Ro(a){var b,c,d,e,f,g,h;b=new tEc;for(d=a,e=0,f=d.length;e<f;++e){c=d[e];g=Sd(c.Ve());h=qEc(b,g,Sd(c.We()));if(h!=null)throw gZ(new qnb("duplicate key: "+g));}this.d=(Cyc(),new uAc(b))}function gE(b,c){var d,e,f,g;for(e=0,f=b.length;e<f;e++){g=b[e];try{g[1]?
g[0].Ij()&&(c=fE(c,g)):g[0].Ij()}catch(a){a=fZ(a);if(pF(a,36)){d=a;TD();ZD(pF(d,265)?d.eg():d)}else throw gZ(a);}}return c}function YE(a,b){var c,d,e;b&=63;if(b<22){c=a.l<<b;d=a.m<<b|a.l>>22-b;e=a.h<<b|a.m>>22-b}else if(b<44){c=0;d=a.l<<b-22;e=a.m<<b-22|a.l>>44-b}else{c=0;d=0;e=a.l<<b-44}return HE(c&sMc,d&sMc,e&tMc)}function Ppb(a){ppb();var b,c,d;Yd(a.n==(Afc(),Jdc)||a.n==bdc,a);d=a.g;switch(d.n.f){case 29:return d;case 47:{b=d.c;return V8b(b)?b:null}default:c=a.c;return c.n==tdc||c.Wh().length==
0?null:c}}function Cxb(a,b){var c,d,e;if(Esc(b.substr(0,29),"data:application/json;base64,")){c=dB((cB(),cB(),bB),b.substr(29));e=Csc((d=c,Ptc(),d));return Vwb(a.b+".inline.map",e,(scc(),qcc))}return null}function NLb(a,b){var c,d,e,f;gLb(a,b,(IRb(),jRb));f=OLb(a,b.b);c=dKb(a.a,(Afc(),uec));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);for(e=b.a.Vd();e.Id();){d=e.Jd();q8b(c,yKb(a.a,d))}return fKb(a.a,tec,f,c)}function atc(a){var b,c,d;d=new gGc;for(c=new wxc(a);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);!d.a?
d.a=new vtc(d.d):ptc(d.a,d.b);mtc(d.a,b)}return!d.a?d.c:d.e.length==0?d.a.a:d.a.a+(""+d.e)}function Yxc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];eGc(f,String.fromCharCode(b))}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function lj(a,b,c){var d,e,f,g;if(c==0)return e=Bx(a.a,b),!e?0:e.a;Nd(c>0,HLc,c);d=Xtc(a.a,b);if(!d){g=0;$tc(a.a,b,new _l(c))}else{g=d.a;f=hZ(g,c);Od(iZ(f,_Kc)<=0,f);d.a+=c}a.b=hZ(a.b,c);return g}function VC(a,b,c){var d,
e,f,g;ZB(a.b,c-a.c);a.c=c;if(b){e=MC(a.j,b.d);ZB(a.b,e-a.g);a.g=e;g=b.c.b;f=b.c.a;ZB(a.b,g-a.i);a.i=g;ZB(a.b,f-a.f);a.f=f;if(b.b!=null){d=LC(a.j,b.b);ZB(a.b,d-a.e);a.e=d}}}function LD(a){var b;if(a.c==null){b=uF(a.b)===uF(JD)?null:a.b;a.d=b==null?jLc:sF(b)?b==null?null:b.name:tF(b)?oMc:frc(Bb(b));a.a=a.a+": "+(sF(b)?b==null?null:b.message:b+"");a.c="("+a.d+") "+a.a}}function a_(a){var b,c,d,e;b=Sd(su(Ue(a.a,a.b)));d=(Sd(a),Ld(true,"number to skip cannot be negative"),new du(a));c=(e=(ae(Hsc(b,_sc(46))==
-1,HMc,b),n8b(),new Wbc((Afc(),rec),b)),e);return P$(c,d)}function PCb(a,b,c){ICb();var d,e;if(b.g.n==(Afc(),ufc)&&(d=H8b(b,(Hbc(),ybc)),!!d&&d.Kh())&&Dqb(b))return true;return MBb(),e=J6(a,Lmb(c,BBb,CE(xE(nW,1),uNc,2,6,["dummy","dummy"]))),e==(E2(),C2)}function p2b(a){var b,c;if(a.a==null)return a.b.k=false,j2b(a,jLc,0);b=null;if(pF(a.a,156))b=new XBc(a.a.a);else if(pF(a.a,294))b=a.a;else throw gZ(g2b(a));c=new stc;c.a+=""+b;return j2b(a,c,0)}function Znc(a,b){var c,d;if(b.Yd()==a.c.Yd())return b;
else if(b.Yd()>a.c.Yd())return b.wf(0,a.c.Yd());else{c=(Bn(),new Zr);Qr(c,b);for(d=b.Yd();d<a.c.Yd();d++)Xr(c,_kc(a.a,51));return In(c.a)}}function S4(a){var b;if(a.n==(Afc(),eec)){b=a.c?a.c.i:null;return b.n==Vcc?P4(a,2)==1&&S4(O4(a)):S4(b)}else switch(a.n.f){case 100:case 88:case 65:case 96:case 71:return true;default:return false}}function _Ob(a,b){var c;if(!JOb(a,b,(NPb(),EPb)))return false;for(c=0;c<(Pd(b.n==(Afc(),Ycc),iSc,b),C8b(b)-1);c++)if(!$Ob(a,(Pd(b.n==Ycc,iSc,b),B8b(b,c+1)))){mPb(a,EPb.d);
return false}return true}function _0(a,b){var c,d,e;c=null;switch(a.b.f){case 0:c=(e=w3b(b,e_(a.c)),e);break;case 1:c=(d=w3b(b,b_(a.c)),d);break;case 2:c=O$(b,a.c)}q9b(c,a.a);c=(Yd(H3b(c),c),new L9b((Afc(),Ddc),c));return c}function bMb(a,b){var c,d,e,f;f=dKb(a.a,(Afc(),ldc));c=dKb(a.a,Vcc);c9b(c,(Hbc(),Eac),1);T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);if(b.a)for(e=b.a.Vd();e.Id();){d=e.Jd();q8b(c,yKb(a.a,d))}q8b(f,c);return f}function Ihb(a){var b,c,d;for(c=new wxc(a.q);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);
d=b==b.g.c?null:b.i;Xd(!!d);Xd(d.n==(Afc(),Ddc));k9b(d,S3b(g9b(d)));Sd(b.g);e9b(b.g,b)}a.q.a=zE(iW,mLc,1,0,5,1)}function anb(a,b,c,d){var e,f,g,h;h=new fxc;if(!c.Wd(b))return h;for(g=xDb(A8(b)).Vd();g.Id();){f=g.Jd();e=null;d.se(f)&&c.Sd(d.Ie(f))&&(e=d.Ie(f));!!e&&Zwc(h,anb(a,e,c,d))}h.a[h.a.length]=b;return h}function ypb(a){ppb();var b;switch(a.n.f){case 82:b=a.g;return!!b&&!(b.n==(Afc(),$cc)||b.n==ldc)&&b.n!=(Afc(),adc);case 72:case 73:case 101:case 102:case 67:case 96:return true;default:return false}}
function SBb(a){var b,c,d;Yd(!!a.Ii(),a);if(!a||a.Bi())return"";b=a.Ii();d=new stc;if(b.f==(dkc(),bkc))PBb(d,b);else{Yd(b.oi(),b);NBb(d,b)}QBb(d,Vfc(b));c=d.a;return c.length==0?c:"/**\n"+c+" */\n"}function Ejc(a,b){var c,d;if(a.f==(dkc(),akc)){for(d=xu(new Guc(b.a));d.Id();){c=d.Jd();klc(a.A,a,c);Sfc(a.k,c.ki())}a.d=In(b)}else throw gZ(new ztc("An interface cannot implement other inferfaces"));}function myc(a,b){var c,d,e;if(uF(a)===uF(b))return true;if(!pF(b,281))return false;e=b;d=xyc(a.a);if(d!=
xyc(e.a))return false;for(c=0;c<=d;c++)if((a.a[c]|0)!=(e.a[c]|0))return false;return true}function Cw(a,b,c){var d,e;this.f=a;d=Xtc(a.b,b);e=!d?0:d.a;Vd(c,e);if(c>=(e/2|0)){this.e=!d?null:d.c;this.d=e;while(c++<e)Aw(this)}else{this.c=!d?null:d.b;while(c-- >0)zw(this)}this.b=b;this.a=null}function $E(a,b){var c,d,e,f;b&=63;c=a.h&tMc;if(b<22){f=c>>>b;e=a.m>>b|c<<22-b;d=a.l>>b|a.m<<22-b}else if(b<44){f=0;e=c>>>b-22;d=a.m>>b-22|a.h<<44-b}else{f=0;e=0;d=c>>>b-44}return HE(d&sMc,e&sMc,f&tMc)}function _ib(a,
b,c,d){var e,f,g,h;for(f=v8b(c.c).Vd();f.Id();){e=f.Jd();g=e.c.Wh();h=i$(Kob(b),g);if(!!h&&uqb(h.c)){g=Tib(a,Kob(b),e.c);Sd(g)}qGc(a.b,(e.c?e.c.i:null).Wh(),new Mib(g,e))}e9b(d,c);Vob(b)}function fjb(){fjb=JZ;djb=new Mcb("BAD_REST_PARAMETER_ANNOTATION",(E2(),D2),new Rtc('Missing "..." in type annotation for rest parameter.'));ejb=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),xRb),zRb]))}function Ljb(a,b,c,d,e){var f,g;f=Yjb(f3b(CE(xE(HU,1),IMc,7,0,[])),b);for(g=a.c;g;g=g.f)g.n==(Afc(),jfc)&&(g.Th()!=
null?q8b(f,Yjb(V3b(g.Th()),c)):q8b(f,Yjb($3b(Yjb((n8b(),new tac(0)),e)),d)));return f}function Kpb(a,b){ppb();var c,d;Xd(a.n==(Afc(),Eec));for(d=(!a.c?(Cyc(),Cyc(),Byc):new Kbc(a.c)).Vd();d.Id();){c=d.Jd();if(c.n==fdc&&c.c.Xh(b,false,true,false,false))return c.c?c.c.i:null}return null}function u2b(a,b){var c,d;d=a.b.n;d=0==d?1:d;M2b(a.b,d);c=Erc(a.a);if(c==0){--d;M2b(a.b,d);n2b(a,b);return}c=$wnd.Math.abs(c);if(!isNaN(c)&&!isFinite(c)){d=a.b.n;--d;M2b(a.b,d);m2b(a,b);return}n2b(a,b)}function Ov(a,
b){var c;b.d?b.d.b=b.b:a.a=b.b;b.b?b.b.d=b.d:a.e=b.d;if(!b.e&&!b.c){c=auc(a.b,b.a);c.a=0;++a.c}else{c=Xtc(a.b,b.a);--c.a;!b.e?c.b=b.c:b.e.c=b.c;!b.c?c.c=b.e:b.c.e=b.e}--a.d}function AWb(a){var b;b=(DWb(a,0),axc(a.d,0));(!xWb(a,a.f)||b.e!=(AZb(),KXb))&&EWb(a,wWb(a,a.f),"Expected '}' after expression in template literal",CE(xE(iW,1),mLc,1,5,[]));return BWb(a,(AZb(),lZb),kZb)}function FDc(a,b,c){var d,e,f,g;g=b==null?0:a.b.sj(b);e=(d=a.a.get(g),d==null?new Array:d);if(e.length==0)a.a.set(g,e);else{f=
CDc(a,b,e);if(f)return f.Xe(c)}e[e.length]=new wvc(b,c);++a.c;return null}function Lrb(a,b){var c,d,e,f;if(b.c.n==(Afc(),rec)){e=b.c;A9b(b,Rpb(b));f=b.g;d=new J9b(tdc);j9b(f,b,d);c=F9b(h3b(F9b(e.Sh(false),e),b),b);q9b(c,H8b(b,(Hbc(),mbc)));d9b(b,mbc,null);j9b(f,d,c);w7(a.b,c)}}function $Fb(a,b,c){var d,e,f,g,h,i,j;for(f=WFb,g=0,h=f.length;g<h;++g){e=f[g];j=c+(""+e);d=gEb(a,b,j);if(No(a.c,d)){j=Po(a.c,d);if(Esc(UQc,j))return null}i=hEb(a,b,j);if(i!=null)return i}return null}function NTb(a){var b,c,
d;d=DWb(a.g,0).d.b;oTb(a,GNc);iTb(a,(AZb(),gYb));c=AVb(a,bZb);c&&iTb(a,bZb);b=K$b(P$b(new T$b((Y$b(),V$b)),jTb(a)));sUb(a,b,c?(pWb(),mWb):(pWb(),lWb));return I$b(b,new Z1b(d,a.f))}function Jd(a,b,c){if(a<0||a>c)return Id(a,c,"start index");if(b<0||b>c)return Id(b,c,"end index");return rf("end index (%s) must not be less than start index (%s)",CE(xE(iW,1),mLc,1,5,[Yrc(b),Yrc(a)]))}function R_(a,b,c){switch(c.n.f){case 29:W_(c);break;case 93:l_(a,b,c);break;case 94:h0(a,b,c);break;case 26:case 27:J_(a,
b,c);break;case 92:R_(a,b,(Xd(!!c.c&&!c.c.f),c.c));break;default:D0(SMc+b+TMc,c)}}function okb(a,b,c,d){Sd(a);Sd(b);Sd(c);this.b=a;this.d=b;this.c=c;this.e=d;this.a=true;this.i=(!a.P&&(a.P=new llc),a.P).u[51];this.j=(!a.P&&(a.P=new llc),a.P).u[52];this.f=(!a.P&&(a.P=new llc),a.P).u[45]}function vpb(a){var b;Pd(a.n==(Afc(),xec),"Expected NEW node, got %s",a.n);if(Q9b(E8b(a,(Hbc(),wbc)),15))return false;if(Q9b(E8b(a,wbc)&15,11)&&rpb(a))return false;b=a.c;return b.n!=rec||!hpb.Sd(b.Wh())}function xKb(a){var b;
switch(a.p.f){case 6:case 20:case 67:case 77:return false;case 49:case 43:case 42:case 46:case 55:case 45:b=KKb(a);if(b.p==(n1b(),M0b))return false;return true;default:return true}}function nOb(a){var b,c;for(;;){b=jOb(a);switch(b){case 42:if((c=jOb(a),a.q[a.r++]=c,--a.b,c)!=47){iOb(a,b);break}case -1:case 10:a.q[a.r++]=b;--a.b;a.n=gtc(a.o,0,a.p);a.p=0;return a.n;default:iOb(a,b)}}}function v_(a,b){var c,d,e,f;e=Cfc(b.n);e!=-1&&(d=C8b(b),e!=d&&D0(QMc+e+RMc+d,b));c=b.n;f=b.c;switch(f.n.f){case 29:W_(f);
break;case 26:case 27:J_(a,c,f);break;default:D0(SMc+c+TMc,f)}E_(a,b.c?b.c.i:null)}function Lhb(a,b,c,d){var e,f;Bhb(a,b,c);e=new fxc;if(!b){f="setFinallyBlock";Ywc(e,mib(c,d))}else{f="setCatchFinallyBlocks";Ywc(e,mib(b,d));!!c&&Ywc(e,mib(c,d))}eib(a,Dhb(a,d,f,exc(e,zE(HU,IMc,7,0,0,1))))}function Avb(){Avb=JZ;zvb=new Mcb("JSC_INSUFFICIENT_OUTPUT_VERSION",(E2(),C2),new Rtc("Built-in ''{0}'' not supported in output version {1}"));yvb=(bn(),pp(CE(xE(iW,1),mLc,1,5,["goog.global.","window."])))}function dMb(a,
b){var c,d,e,f;bKb(a.a,b,(IRb(),CRb));f=dKb(a.a,(Afc(),ifc));T9b(f.k)==-1&&vKb(f,b.o.b,b.o.a);e=!b.b?f:fKb(a.a,hfc,yKb(a.a,b.b),f);for(d=b.a.Vd();d.Id();){c=d.Jd();q8b(f,yKb(a.a,c))}return e}function Qoc(a,b){var c,d,e,f;if(!b.Bi()&&!b.Mi())for(f=0;f<a.b.Yd();f++){c=a.b.ce(f);if(!c.Bi()&&b.zi(c))return a}return d=(e=new ukc(false),Qfc(a,b,0,e)),d?a:igc(Zkc(a.A,CE(xE(cV,1),xPc,23,0,[a,b])))}function V6(a){var b,c,d;d=false;a.G.cc>1&&(new otb,Tt(Wt(new eyc(a.B.a),new lnb)));for(c=Hn(Tt(Wt(new eyc(a.B.a),
new lnb))).Vd();c.Id();){b=c.Jd();W6(a,b)&&(d=true)}d&&(D6(a,a.B?new eyc(a.B.a):null),Z6(a))}function ULb(a,b){var c,d,e,f;c=QLb(a,b.a);A9b(c,(Afc(),cfc));d=b.b;if(!d){f=MLb(a,b.a);c9b(c,(Hbc(),kbc),1)}else f=(d.p==(n1b(),$_b)?e=uLb(a,d):d.p==q0b?e=MLb(a,d.a):e=AKb(a.a,d),e);r8b(c,f);return c}function gsc(a,b){var c,d,e,f,g;g=1<<b;if(iZ(hMc,a)<=0&&iZ(a,_Kc)<=0)return Xrc(yZ(a),g);e=g-1;d=(64/b|0)+1;c=zE(xF,eLc,46,d,15,1);f=d;do{c[--f]=Wqc(yZ(a)&e);a=uZ(a,b)}while(iZ(a,0)!=0);return gtc(c,f,d-f)}function Hd(a,
b){if(a<0)return rf(pLc,CE(xE(iW,1),mLc,1,5,[qLc,Yrc(a)]));else if(b<0)throw gZ(new qnb(rLc+b));else return rf("%s (%s) must be less than size (%s)",CE(xE(iW,1),mLc,1,5,[qLc,Yrc(a),Yrc(b)]))}function BUb(a){var b,c,d,e,f;f=DWb(a.g,0).d.b;iTb(a,(AZb(),HYb));d=kTb(a);iTb(a,NXb);c=qVb(a);iTb(a,MXb);iTb(a,NXb);b=nVb(a);e=new m_b(new Z1b(f,a.f),d,false,false,null,c);return new g_b(new Z1b(f,a.f),e,b)}function p8b(a,b,c){var d;Ld(c.g==a,"The existing child node of the parent should not be null.");Ld(!b.f,
nTc);Ld(!b.i,oTc);Ld(!b.g,pTc);if(a.c==c){d=a.c.i;b.g=a;b.f=a.c;b.i=d;a.c.i=b;a.c=b}else o8b(a,b,c.i)}function ulc(a,b){var c,d,e,f,g,h,i;i=false;e=b.d;c=Ihc(e.Ni(a));e!=c&&(i=true);h=(Bn(),new Zr);for(g=b.c.Vd();g.Id();){f=g.Jd();d=f.Ni(a);f!=d&&(i=true);Ywc(h.a,Sd(d))}i&&(b=new koc(a.e,c,In(h.a)));return b}function Noc(a,b,c,d){var e,f,g;g=(Yoc(new Epc,b.b)&&Voc(b),b.b);if(c==0&&(Yoc(new Epc,a.b)&&Voc(a),a.b).Yd()!=g.Yd())return false;for(e=0;e<g.Yd();e++){f=g.ce(e);if(!Soc(a,f,c,d))return false}return true}
function Rjb(){Rjb=JZ;Pjb=new Mcb(ZPc,(E2(),B2),new Rtc("This code cannot be converted from ES6. {0}"));Qjb=new Mcb("JSC_CANNOT_CONVERT_YET",B2,new Rtc("ES6 transpilation of ''{0}'' is not yet implemented."))}function wlb(a){var b,c,d;Ld(a.n==(Afc(),Ycc),a);if(!(!!a.c&&!!a.c.f&&a.c.f==(a.c?a.c.i:null)))return false;c=a.c;if(c.n!=Pdc)return false;b=c.c;d=c.c.f;return d.n==bfc&&Esc("hasOwnProperty",d.Wh())&&V8b(b)}function $mb(a,b,c){var d,e,f,g,h,i;g=b.b;h=c.b;for(d=$wnd.Math.min(g,h)-1;d>=0;d--){i=
$wc(a.b,d);for(e=i.Yd()-1;e>=0;e--){f=i.ce(e);if(b!=f&&nyc(a.c[b.c],f.c)&&c!=f&&nyc(a.c[c.c],f.c))return f}}return null}function RJb(){RJb=JZ;QJb=(bn(),new Zz(ANc));NJb=QJb;OJb=tp(MNc,XOc,ZNc,INc,NNc,LNc,CE(xE(nW,1),uNc,2,6,[DMc]));PJb=tp(MNc,XOc,ZNc,INc,NNc,LNc,CE(xE(nW,1),uNc,2,6,[DMc,ONc,YNc,"let",FRc,GRc,HRc,IRc,KRc,RNc]))}function Toc(a,b,c,d){var e,f;if(b.Bi()||Yoc(new spc,a.b))return true;if(b.mi())return true;for(f=0;f<a.b.Yd();f++){e=a.b.ce(f);if(d==1&&(e.vi()||e.Ci()))continue;if(!e.Ai(b,
c,d))return false}return true}function mKc(a,b,c,d,e,f){var g,h,i,j,k;if(a===c){a=a.slice(b,b+e);b=0}i=c;for(h=b,j=b+e;h<j;){g=$wnd.Math.min(h+1E4,j);e=g-h;k=a.slice(h,g);k.splice(0,0,d,f?e:0);Array.prototype.splice.apply(i,k);h=g;d+=e}}function TMb(a){var b,c;a.i=(JNb(),HNb);xNb(a);c=!a.o?mOb(a.j):GMb(a);if(a.f.d){b=JMb(a,c,a.g?0:1,false,false);c=b.b;b.a.length==0||t6b(a.f,b.a)}else c!=(fOb(),MNb)&&c!=RNb&&t6b(a.f,"");return bNb(a,c,new fxc)}function o5(a,b,c,d){var e,f;f=a.b;e=a.a;if(d)return f==
b&&e>=c?new _B(f+1,e-c):a;else if(f==b)return new _B(f-1,e+c);else if(f>b)throw gZ(new Irc("Cannot undo line cut on a previous line."));else return a}function iNb(a,b){var c,d;d=QMb(a,(Afc(),hec));c=_Mb(a,b);if(!c)return CMb(a,_Rc,a.j.g,lOb(a.j)),null;xNb(a);if(!OMb(a,(fOb(),aOb)))return CMb(a,YRc,a.j.g,lOb(a.j)),null;!a.o?mOb(a.j):GMb(a);q8b(d,c);return d}function J8b(a,b){var c,d,e;e=(a.c?a.c.i:null).Wh();b+=1+e.length;if(a.c.n==(Afc(),Pdc)){c=J8b(a.c,b);if(!c)return null}else{d=I8b(a.c);if(d==
null)return null;c=new ttc;c.a+=""+d}ptc((c.a+=".",c),e);return c}function Txc(a,b,c,d,e,f){var g,h,i,j;g=d-c;if(g<7){Qxc(b,c,d,f);return}i=c+e;h=d+e;j=i+(h-i>>1);Txc(b,a,i,j,-e,f);Txc(b,a,j,h,-e,f);if(f.lf(a[j-1],a[j])<=0){while(c<d)b[c++]=a[i++];return}Rxc(a,i,j,h,b,c,d,f)}function SKc(a){var b,c,d,e;b=0;d=a.length;e=d-4;c=0;while(c<e){b=a.charCodeAt(c+3)+31*(a.charCodeAt(c+2)+31*(a.charCodeAt(c+1)+31*(a.charCodeAt(c)+31*b)));b=b|0;c+=4}while(c<d)b=b*31+zsc(a,c++);b=b|0;return b}function ihb(a){var b;
if(a.g.n==(Afc(),Ycc)&&!!(a==a.g.c?null:a.i)){b=a.g.c;if((a==a.g.c?null:a.i)==b&&!a.f&&a9b(b,KMc,KMc.length)){Xd((!a.g?null:a.g.g).n==Uec);Xd(!(!a.g?null:a.g.g).f);return true}}return false}function ePb(a,b){if(!JOb(a,b,(NPb(),KPb)))return false;if((Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)).n!=bfc){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,["name"])),a.b.ug(),a.d,a.c);mPb(a,KPb.d);return false}return true}function Id(a,b,c){if(a<0)return rf(pLc,CE(xE(iW,1),mLc,1,5,[c,Yrc(a)]));else if(b<0)throw gZ(new qnb(rLc+
b));else return rf("%s (%s) must not be greater than size (%s)",CE(xE(iW,1),mLc,1,5,[c,Yrc(a),Yrc(b)]))}function Adb(a,b){var c;switch(b){case iPc:case "EvalError":case jPc:case "ReferenceError":case "SyntaxError":case "TypeError":case "URIError":return c=i$(Kob(a),b),!(!!c&&!(!c.a||B8(c.a)));default:return false}}function ZBb(a,b){var c,d;if(!b.Di())return b;d=b.Fi();if(b.wi()){c=a.b.u[32];return Zkc(a.b,(Bn(),Zn(new hz(Qn(CE(xE(iW,1),mLc,1,5,[d,c]))),zE(cV,xPc,23,0,0,1))))}return d.ti()||d.ri()||
d.si()||d==d.A.u[64]?b:d}function _Lb(a,b){var c,d,e,f,g;f=b.a;d=$Lb(a,f);g=d.Wh();if(Hsc(g,_sc(11))!=-1){e=f.d.b.c;c=f.d.a.c;e<a.a.r.length&&Vsc(a.a.r,e,$wnd.Math.min(a.a.r.length,c)).indexOf("\\v")!=-1&&b9b(d,(n8b(),j8b),true)}return d}function ojc(a,b,c,d){if(a==b)return true;if(a.f!=b.f)return false;switch(a.f.f){case 1:return false;case 2:return Esc(a.Xi(),b.Xi());case 0:return Qfc(a.k,b.k,c,d)&&bhc(a.b,b.b,c,d);default:throw gZ(new Jqc);}}function Geb(a,b,c,d){var e,f,g,h,i,j;f=c.Wh();j=Te(Eeb,
f);h=j.a.ce(0);e=Kob(b);while(e){g=eq(a.a,e.d,h);if(g!=null){i=j.b.Yd()==2?"."+j.a.ce(1):"";c._h(g+i);d||Vob(b);return}else if(oEc(e.e,h))return;else e=e.b}}function Qpb(a){ppb();var b,c,d;if(a.n!=(Afc(),Jdc))return null;b=(c=Ppb(a),!c?null:I8b(c));if(b!=null)return b;d=a.g;switch(d.n.f){case 98:case 87:case 86:case 91:return d.Wh();case 30:return Ypb(d)}return null}function O9b(a,b,c,d){n8b();Kd(!b.g);Kd(!b.f);Kd(!b.i);Kd(!c.g);Kd(!c.f);Kd(!c.i);Kd(!d.g);Kd(!d.f);Kd(!d.i);this.n=a;this.g=null;this.c=
b;b.f=c;b.i=d;b.g=this;c.f=d;c.i=b;c.g=this;d.f=null;d.i=c;d.g=this;this.k=-1}function EKb(a,b){var c,d;if(b.n==(Afc(),eec)){c=b.c;for(d=b.g;!!d&&d.n!=Jdc;d=d.g)if(d.n==eec&&Esc(d.c.Wh(),c.Wh())){a.d.Ah(x2b('Duplicate label "%s"',CE(xE(iW,1),mLc,1,5,[c.Wh()])),a.q,T9b(b.k),S9b(b.k));break}}}function Xhc(a,b,c,d,e){var f,g,h,i,j;j=b.Ji()?b.Ti():Bhc(b);for(i=j.Vd();i.Id();){h=i.Jd();g=b.Wi(h);if(a.ji(h,false)==0){if(!(e==0&&g.pi()))return false}else{f=a.Wi(h);if(!f.Ai(g,c,d))return false}}return true}
function pVb(a,b,c){var d,e;iTb(a,(AZb(),EYb));++a.g.j;e=(Bn(),new Zr);d=nVb(a);Ywc(e.a,Sd(d));while(AVb(a,OXb)){iTb(a,OXb);d=nVb(a);!!d&&(Ywc(e.a,Sd(d)),e)}iTb(a,JXb);--a.g.j;return new w_b(new Z1b(b,a.f),c,In(e.a))}function occ(b,c){var d,e,f;bFc();f=(nFc(),qFc(xTc));try{d=oFc(f,b)}catch(a){a=fZ(a);if(pF(a,372))throw gZ(new GD("no message resource found for message property "+b));else throw gZ(a);}e=new Rtc(d);return Stc(e.a,c)}function Zxc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[",
"]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];!f.a?f.a=new vtc(f.d):ptc(f.a,f.b);mtc(f.a,""+b)}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function $xc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];!f.a?f.a=new vtc(f.d):ptc(f.a,f.b);mtc(f.a,""+b)}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function _xc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];!f.a?f.a=new vtc(f.d):ptc(f.a,f.b);
mtc(f.a,""+b)}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function cyc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];!f.a?f.a=new vtc(f.d):ptc(f.a,f.b);mtc(f.a,""+b)}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function tu(a){var b,c,d;b=a.Jd();if(!a.Id())return b;d=otc(ptc(new stc,"expected one element but was: <"),b);for(c=0;c<4&&a.Id();c++)otc((d.a+=iLc,d),a.Jd());a.Id()&&(d.a+=", ...",d);d.a+=">";throw gZ(new qnb(d.a));}function hib(a,
b,c,d){var e;e=new fxc;Ywc(e,!b?F9b(Yjb((ae(Hsc(vPc,_sc(46))==-1,HMc,vPc),n8b(),new Wbc((Afc(),rec),vPc)),a.r.f.j),d):b);Ywc(e,mib(c,d));eib(a.r.a,aib(a,d,RNc,exc(e,zE(HU,IMc,7,0,0,1))));a.r.a.j.e=false}function Job(a,b){var c,d,e,f,g;f=!b?a.p:(d=H8b(b,(Hbc(),ybc)),!d?null:d.ug());if(f==null)return"[source unknown]\n";e=T9b(b.k);c=S9b(b.k);g=R6(a.c,f,e);g==null&&(g="[source unknown]");return f+":"+e+":"+c+gMc+g+gMc}function ALb(a,b){var c,d,e,f;f=dKb(a.a,(Afc(),Jec));if(WKb(a,b.a))for(d=b.a.Vd();d.Id();){c=
d.Jd();c.p==(n1b(),$_b)?e=uLb(a,c):e=AKb(a.a,c);Xd(e.n==rec||e.n==Sec||e.n==Acc||e.n==Fec||e.n==mdc);q8b(f,e)}return f}function rq(a,b,c){var d,e;d=b.a&a.f;b.b=a.b[d];a.b[d]=b;e=b.f&a.f;b.d=a.c[e];a.c[e]=b;if(!c){b.e=a.e;b.c=null;!a.e?a.a=b:a.e.c=b;a.e=b}else{b.e=c.e;!b.e?a.a=b:b.e.c=b;b.c=c.c;!b.c?a.e=b:b.c.e=b}++a.i;++a.g}function ajb(a,b,c){(c.c?c.c.i:null).Wh().indexOf("://")!=-1&&u7(a.a,Lmb(c,(Rjb(),Pjb),CE(xE(nW,1),uNc,2,6,["Module requests with protocols."])));jDc(a.c,new j1(Kib(pFb(b,(c.c?
c.c.i:null).Wh()).a),Rib(a,c)));jDc(a.d,c)}function aMb(a,b){var c,d,e,f,g;f=b.a;g=eKb(a.a,(Afc(),$cc),yKb(a.a,f));c=dKb(a.a,Vcc);c9b(c,(Hbc(),Eac),1);T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);if(b.b)for(e=b.b.Vd();e.Id();){d=e.Jd();q8b(c,yKb(a.a,d))}q8b(g,c);return g}function MUb(a,b){var c,d,e,f,g;e=DWb(a.g,0).d.b;!mTb(a,(AZb(),wYb))&&iTb(a,xYb);d=(f=DWb(a.g,0).d.b,g=jTb(a),new p_b(new Z1b(f,a.f),fTb(a,g)));iTb(a,FYb);c=b?DTb(a):NUb(a);iTb(a,KXb);return new o_b(new Z1b(e,a.f),d,c)}function pjc(a){var b,
c;a.u=true;if(a.j)for(c=new wxc(a.j);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);pjc(b)}if(!a.q){(a.oi()||a.f==(dkc(),bkc))&&(ae(a.oi()||a.f==(dkc(),bkc),lRc,a),cgc(a.k)).Pi();!!a.g&&a.g.e.Pi()}}function SIc(a){var b,c,d;b=Esc(typeof b,vPc)?null:new wKc;if(!b)return;bIc();if(hMc>a.a.qj())return;c=(d=a.a.qj(),d>=1E3?"error":d>=900?"warn":d>=800?"info":"log");uKc(c,a.b);!!a.c&&vKc(b,c,a.c,"Exception: ",true)}function X6(a){var b,c,d;d=false;a.G.cc>1&&(new otb,Tt(Wt(new eyc(a.B.a),new lnb)));for(c=Hn(Tt(Wt(new eyc(a.B.a),
new lnb))).Vd();c.Id();){b=c.Jd();if(y8(b).b){Qmb(b.k,b);d=true}}d&&(D6(a,a.B?new eyc(a.B.a):null),Z6(a))}function Fub(a,b,c){this.f=a;Cub(this);this.b=Sd(c);c.n==(Afc(),Jdc)&&E8b(c,(Hbc(),Gac))!=0?c.n==Jdc&&E8b(c,(Hbc(),Fac))!=0?this.a=!b.a?this:b.a:this.a=this:c.n==Jdc&&E8b(c,(Hbc(),Fac))!=0?this.a=b.a:this.a=null}function jNb(a){xNb(a);if(!OMb(a,(fOb(),ONb)))return QMb(a,(Afc(),tdc));!a.o?mOb(a.j):GMb(a);xNb(a);if(OMb(a,eOb)&&Esc(XNc,a.j.n)){!a.o?mOb(a.j):GMb(a);return QMb(a,(Afc(),vfc))}else return mNb(a,
!a.o?mOb(a.j):GMb(a))}function DTb(a){var b;b=(Bn(),new Zr);while(zVb(a,0,(AZb(),vZb))||zVb(a,0,sYb)||zVb(a,0,PXb)||zVb(a,0,gYb)||zVb(a,0,IXb)||zVb(a,0,oYb)||zVb(a,0,YXb)||zVb(a,0,wYb)||zVb(a,0,xYb)||zVb(a,0,bYb))Xr(b,CTb(a));return In(b.a)}function Itc(){Itc=JZ;Htc=new Jtc("UP",0);Btc=new Jtc("DOWN",1);Atc=new Jtc("CEILING",2);Ctc=new Jtc("FLOOR",3);Ftc=new Jtc("HALF_UP",4);Dtc=new Jtc("HALF_DOWN",5);Etc=new Jtc("HALF_EVEN",6);Gtc=new Jtc("UNNECESSARY",7)}function Vf(a,b,c){var d;d=a.c.Ie(b);if(!d){d=
a.ze(b);if(d.Pd(c)){++a.d;a.c.Je(b,d);return true}else throw gZ(new Kqc("New Collection violated the Collection spec"));}else if(d.Pd(c)){++a.d;return true}else return false}function nt(a,b){ht();var c,d,e,f;d=Sd(b.Ve());f=Sd(b.We());c=d;if(kGc(a,c)){e=(new Tvc(new aHc(a,(oHc(),nHc),d))).b.vj().Jd();throw gZ(new qnb("Duplicate keys in mappings "+e.Ve()+"="+e.We()+" and "+d+"="+f));}qGc(a,d,f)}function nhb(a,b,c,d){var e,f,g;g=new pib(a.a);c=Thb(a.a,c);d=Thb(a.a,d);cib(a.a,g);e=g9b(b);Yhb(a.a,c,d);
thb(a,e,null,null);Vhb(a.a);cib(a.a,d);f=khb(a,jhb(a,g9b(b)));eib(a.a,F9b(B3b(f,Ghb(a.a,g,false,b)),b));cib(a.a,c)}function ayc(a){var b,c,d,e,f;if(a==null)return jLc;f=new hGc(iLc,"[","]");for(c=a,d=0,e=c.length;d<e;++d){b=c[d];!f.a?f.a=new vtc(f.d):ptc(f.a,f.b);mtc(f.a,""+zZ(b))}return!f.a?f.c:f.e.length==0?f.a.a:f.a.a+(""+f.e)}function Ru(a){var b,c;while(!Sd(a.a).Id()){a.d=Qu(a);if(!a.d)return false;a.a=a.d.Jd();if(pF(a.a,85)){c=a.a;a.a=c.a;!a.b&&(a.b=new Cwc);kwc(a.b,a.d);if(c.b)while(!swc(c.b))kwc(a.b,
(b=wwc(c.b),b));a.d=c.d}}return true}function l_(a,b,c){var d,e;F_(a,(IRb(),EQb),c);b0((Afc(),Acc),c);for(d=c.c;d;d=d.f)switch(d.n.f){case 121:x_(a,b,d);break;case 114:F_(a,FQb,d);m0(a,b,d);break;case 80:e=C8b(d);0!=e&&D0(OMc+e,d);break;default:R_(a,b,d)}}function B1(a){var b,c;c=Xpb(a);switch(a.n.f){case 85:return"SCRIPT: "+c;case 65:b=Qpb(a);b==null&&(b="anonymous@"+T9b(a.k)+":"+S9b(a.k));return"FUNCTION: "+b+" in "+c;default:throw gZ(new Irc("unexpected Node type"));}}function jlb(a,b,c,d,e,f){var g,
h,i;h=(i=Xtc(b.q,Sd(c)),!i?(Bn(),Bn(),An):i);if(h.Ud())Clb(b,e,f,c,d,a.a.b++);else{ae(h.Yd()==1,"unexpected twin refs: %s",h);g=h.ce(0).g;ce(g==d,"existing ref type: %s expected: %s",g,d)}}function KKb(a){while(true)switch(a.p.f){case 6:a=a.a;continue;case 49:a=a.b;continue;case 42:a=a.a;continue;case 43:a=a.a;continue;case 46:a=a.b;continue;case 55:a=a.b;continue;case 45:a=a.a;continue;default:return a}}function Xsb(a){var b,c,d,e,f;d=new fxc;for(f=xu(new Wzc((Msb(),Ksb).a.b.Vd()));f.Id();){e=f.Jd();
for(c=new wxc(a.d);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);if(Esc(b.b,e)){d.a[d.a.length]=b;break}}}Vc(a.d,d);Zwc(a.d,d)}function zxb(){zxb=JZ;yxb=new Mcb("SOURCEMAP_RESOLVE_FAILED",(E2(),D2),new Rtc("Failed to resolve sourcemap at {0}: {1}"));xxb=new Mcb("SOURCEMAP_PARSE_FAILED",D2,new Rtc("Failed to parse malformed sourcemap in {0}: {1}"))}function $Mb(a,b){var c,d,e;c=ZMb(a,b);if(!c)return null;xNb(a);if(!OMb(a,(fOb(),ONb)))return c;!a.o?mOb(a.j):GMb(a);xNb(a);e=mNb(a,!a.o?mOb(a.j):GMb(a));
if(!e)return null;d=QMb(a,(Afc(),ddc));q8b(d,c);q8b(d,e);return d}function BNb(a,b,c,d,e,f){xMb();var g,h;this.j=a;h=e.c!=(mJb(),lJb);this.f=new C7b(h);if(b!=null){d7b(this.f,b);c7b(this.f,c)}this.a=e.a;this.k=e.i;this.b=e.b;this.g=e.c==kJb;this.c=f;this.n=!d?(g=new J9b((Afc(),Xec)),g):d}function nTb(a){var b;if(zVb(a,0,(AZb(),ZYb))&&DWb(a.g,0).d.b.b==a.f.b){iTb(a,ZYb);return}b=DWb(a.g,0).d.b.b>a.f.b;if(b||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb))return;VVb(a,"Semi-colon expected",CE(xE(iW,1),mLc,
1,5,[]))}function T2b(a){if(a.indexOf(":")!=-1||a.indexOf("=")!=-1){if(Hsc(a,_sc(58))==-1)return Hsc(a,_sc(61));if(Hsc(a,_sc(61))==-1)return Hsc(a,_sc(58));return $wnd.Math.min(Hsc(a,_sc(61)),Hsc(a,_sc(58)))}return Hsc(a,_sc(32))}function QLb(a,b){var c;if(!b)return iKb(a.a,(Afc(),rec),RRc);else if(b.e==(AZb(),iYb))c=LLb(a,b,true);else if(b.e==DYb){c=BKb(a.a,b);c9b(c,(n8b(),i8b),1)}else{c=$Lb(a,b);c9b(c,(n8b(),i8b),1)}Xd(c.n==(Afc(),bfc));return c}function Py(a,b){var c,d,e;if(b===a)return true;if(pF(b,
182)){e=b;if(VB(a.b)!=VB(e.b)||Zi(a).Yd()!=Zi(e).Yd())return false;for(d=Zi(e).Vd();d.Id();){c=d.Jd();if(nj(a,c.b.Ve())!=Nj(c))return false}return true}return false}function Hbb(a){var b,c,d;do{c=a.d;b=a.b;if(c.length==0){d=b%a.a.length;c=String.fromCharCode(a.a[d].a);b=b/a.a.length|0}while(b>0){--b;d=b%a.c.length;c+=nF(a.c[d].a);b=b/a.c.length|0}++a.b}while(Efc(c)||kDc(a.f,c));return c}function Bvb(a,b){var c,d,e,f,g,h,i;i=new Svb(a);epb(a.a,b,i);if(i.a.a.Yd()!=0){d=null;for(f=(g=(new Wuc(i.a.a)).a.He().Vd(),
new avc(g));f.a.Id();){e=(c=f.a.Jd(),c.Ve());d=C6(a.a,e,false)}if(d){h=d.g;Evb(a,h,d.f);w7(a.a,h)}}}function GLb(a,b){var c,d,e;bKb(a.a,b,(IRb(),iRb));c=pMb(a,b.a,b);if(!b.d){d=oMb(a,(Afc(),Xdc),b.b);T9b(d.k)==-1&&vKb(d,b.o.b,b.o.a)}else{d=iKb(a.a,(Afc(),Ydc),b.d.a);tKb(d,b.d)}e=$Lb(a,b.c);return gKb(a.a,(Afc(),Vdc),c,d,e)}function zUb(a){var b,c,d;d=DWb(a.g,0).d.b;c=kTb(a);b=null;if(zVb(a,0,(AZb(),iYb))&&Esc(DWb(a.g,0).a,"as")){oTb(a,"as");b=jTb(a)}else qTb(a,c.a)&&SVb(a,null,SSc,CE(xE(iW,1),mLc,
1,5,["as"]));return new f_b(new Z1b(d,a.f),c,b)}function H_(a,b){b.n==(Afc(),Jdc)&&E8b(b,(Hbc(),Fac))!=0&&F_(a,(IRb(),GQb),b);E8b(b,(Hbc(),Xac))!=0&&F_(a,(IRb(),$Qb),b);b.n==Jdc&&E8b(b,Gac)!=0&&F_(a,(IRb(),HQb),b);b.n==Jdc&&E8b(b,Gac)!=0&&E8b(b,Xac)!=0&&F_(a,(IRb(),IQb),b)}function Dlb(a,b,c,d,e,f){var g,h;Ld(e==(cmb(),_lb)||e==amb,e);h=new Ulb(b,Sd(c),Sd(d),a,e,f);g=Elb(a,b,c,d,Wlb,f+1);h.f=g;g.f=h;$tc(a.q,d,(Bn(),new hz(Qn(CE(xE(iW,1),mLc,1,5,[h,g])))));jDc(a.p,h);Hlb(a,h);jDc(a.p,g);Hlb(a,g)}function ptb(a,
b){var c,d,e;if(gqb(b)&&b.n!=(Afc(),eec)&&b.n!=(Afc(),gfc))for(d=b.c;d;d=d.f)if(hqb(b,d)&&d.n!=(Afc(),Vcc)){e=F9b((c=new J9b((Afc(),Vcc)),c),b);j9b(b,d,e);c9b(e,(Hbc(),Eac),1);d.n==tdc||u8b(e,d);d=e;stb(a)}}function BJb(a){zJb();var b,c,d,e;for(c=CE(xE(pR,1),sLc,106,0,[pJb,qJb,rJb,sJb,tJb,uJb,vJb,wJb,yJb,xJb]),d=0,e=c.length;d<e;++d){b=c[d];if(lQb(b.a,a))return b}throw gZ(new Irc("No input language mode supports feature: "+a));}function fNb(a,b){var c,d,e;if(b!=(fOb(),eOb))return CMb(a,_Rc,a.j.g,
lOb(a.j)),null;e=a.j.n;d=a.j.g;c=lOb(a.j);while(OMb(a,TNb)&&zsc(e,e.length-1)==46){xNb(a);if(OMb(a,eOb)){!a.o?mOb(a.j):GMb(a);e+=a.j.n}}return RMb(a,e,d,c)}function jTb(a){var b,c;c=DWb(a.g,0).e;if((AZb(),iYb)==c||a.b.d&&VSb(c)||!a.b.c&&USb(c))return kTb(a);else{SVb(a,DWb(a.g,0),SSc,CE(xE(iW,1),mLc,1,5,[iYb]));return b=DWb(a.g,0).e,iYb==b||(OSb(),OSb(),!!Po(pSb,b))?kTb(a):null}}function RBb(a,b){var c,d,e,f;if(!b)return null;d=b.g;c=null;if(d.n==(Afc(),Ccc)){e=d.c;if(Fqb(e)){f=blc(a.b,I8b(e.c.c));
c=f?f.Qi():null}}else d.n==bdc&&(c=d.d.Ii());return c?(ae(c.oi()||c.f==(dkc(),bkc),lRc,c),cgc(c.k)):null}function J_(a,b,c){if(b==(Afc(),gdc)||b==jec||b==ufc||b==Jec){D0(SMc+b+TMc,c);return}switch(c.n.f){case 26:I_(a,c);break;case 27:m_(a,c);break;default:throw gZ(new Irc("Expected GETPROP or GETELEM but instead got node "+c.n));}}function D6(a,b){var c,d,e;for(e=new Guc(b);e.b<e.d.Yd();){d=(e.b<e.d.Yd(),e.d.ce(e.c=e.b++));if(!Esc(d.e,gOc)&&d.d.a.length==0){c=new H8(Vwb((RZ(),d.e+"$fillFile"),"",
(scc(),qcc)));c.b=a;Ywc(d.d,c);Kd(!d||!c.k||c.k==d);c.k=d}}}function ATb(a){var b;switch(DWb(a.g,0).e.f){case 14:b=BTb(a);nTb(a);break;case 29:b=WTb(a,false,true);break;case 31:b=dUb(a);break;case 110:case 111:b=MUb(a,true);break;case 25:case 38:case 30:default:b=ETb(a);nTb(a)}return b}function aHc(a,b,c){this.c=a;switch(b.f){case 2:if(a.a.lf(null,c)<0)throw gZ(new qnb("subMap: null less than "+c));break;case 1:a.a.lf(null,null);break;case 3:a.a.lf(c,c)}this.f=b;this.b=c;this.a=true;this.e=null;this.d=
false}function tIc(a,b){var c,d,e,f;c=Ytc(a.a,b);if(!c){d=new QIc(b);e=(CIc(),zIc)?null:d.c;f=Vsc(e,0,$wnd.Math.max(0,Jsc(e,_sc(46))));NIc(d,tIc(a,f));(zIc?null:d.c).length==0&&FIc(d,new TIc);_tc(a.a,zIc?null:d.c,d);return d}return c}function MZ(a,b){var c=$wnd;if(a==="")return c;var d=a.split(".");!(d[0]in c)&&c.execScript&&c.execScript("var "+d[0]);if(b){var e=b.prototype.Fj;e.g=b}for(var f;d.length&&(f=d.shift());)c=c[f]=c[f]||!d.length&&b||{};return c}function oDb(){oDb=JZ;jDb=new pDb("MAX",0,
1);kDb=new pDb("MIN",1,100);lDb=new pDb("STRICT",2,100);hDb=new pDb(gRc,3,50);mDb=new pDb("SUPPRESS_BY_WHITELIST",4,40);nDb=new pDb("SUPPRESS_DOC",5,20);iDb=new pDb("FILTER_BY_PATH",6,1)}function iEb(a,b,c){var d,e,f,g;g=fOc.length;Esc(c.substr(c.length-g,g),fOc)||(c+=fOc);f=a.g.Ph(c);ZEb();if(Esc(c.substr(0,2),rOc)||Esc(c.substr(0,3),nRc)){e=b;d=e.lastIndexOf("/");f=SFb(e.substr(0,d+1)+(""+f))}return dFb(f,a.f)}function eUb(a){var b,c,d,e,f;d=pTb(a,DWb(a.g,0).d.b);b=null;e=(Bn(),new Zr);while(f=
DWb(a.g,0).e,(AZb(),iYb)==f||a.b.d&&VSb(f)||!a.b.c&&USb(f)){c=wUb(a).a;b=new r1b(d,c,null);Ywc(e.a,Sd(b));AVb(a,KXb)||iTb(a,OXb)}return In(e.a)}function koc(a,b,c){Ofc();var d,e,f,g,h;Alc.call(this,a,b,Pnc(b.ki(),c));d=(Bn(),new Zr);e=true;for(g=Tnc(b.ki()).Vd();g.Id();){f=g.Jd();h=Rnc(this.B,f);Ywc(d.a,Sd(h));e=e&&h.Bi()}this.c=In(d.a);this.a=e;this.b=new foc(a,this.B)}function jd(a,b){var c,d,e,f,g;if(b===a)return true;if(!pF(b,54))return false;g=b;if(a.Yd()!=g.Yd())return false;f=g.Vd();for(d=
a.Vd();d.Id();){c=d.Jd();e=f.Jd();if(!(uF(c)===uF(e)||c!=null&&zb(c,e)))return false}return true}function D1(a,b,c){var d,e,f,g,h;for(h=(f=(new Wuc(c.a)).a.He().Vd(),new avc(f));h.a.Id();){g=(e=h.a.Jd(),e.Ve());d=_q(sq(a.a),g);if(E8b(d,(Hbc(),Pac))!=0)continue;throw gZ(new Irc(b+"deleted scope was not reported:\n"+E9b(d)));}}function T8(a,b,c){var d,e;Kd(b.n==(Afc(),bfc));Kd(c.n==Adc||c.n==Vdc);e=b.Wh();if(Esc(e.substr(0,5),"goog:")){Ywc(a.d,BDb(e.substr(5)));return}d=oFb(a.b,e,a.b.a,T9b(b.k),S9b(b.k));
!d&&(d=pFb(a.b,e));Ywc(a.d,ADb(UFb(d.a),b.Wh()))}function sLb(a,b){var c,d,e,f,g,h;g=dKb(a.a,(Afc(),edc));h=b.a.ce(0).o.b;d=b.a.ce(1).o.a;vKb(g,h,d);for(f=b.a.Vd();f.Id();){e=f.Jd();c=C8b(g);if(c<2)q8b(g,yKb(a.a,e));else{d=e.o.a;g=fKb(a.a,edc,g,yKb(a.a,e));vKb(g,h,d)}}return g}function Trc(a){var b,c,d;if(a<0)return 0;else if(a==0)return 32;else{d=-(a>>16);b=d>>16&16;c=16-b;a=a>>b;d=a-256;b=d>>16&8;c+=b;a<<=b;d=a-4096;b=d>>16&4;c+=b;a<<=b;d=a-JLc;b=d>>16&2;c+=b;a<<=b;d=a>>14;b=d&~(d>>1);return c+
2-b}}function xhb(a,b){var c,d;c9b(b,(Hbc(),gbc),0);c=b.Sh(false);while(b.c){while(!!(d=g9b(b))&&E8b(d,gbc)==0)q8b(c,d);if(c.c){whb(a,c);c=b.Sh(false)}if(d){Xd(E8b(d,gbc)!=0);r8b(d,jhb(a,g9b(d)));c9b(d,gbc,0);q8b(c,d)}}!!c.c&&whb(a,c)}function BTb(a){var b,c,d,e;e=DWb(a.g,0).d.b;iTb(a,(OSb(),hSb).b);c=!!mTb(a,(AZb(),bZb));d=jTb(a);return b=M$b(R$b(L$b(O$b(N$b(P$b(new T$b((Y$b(),V$b)),d),c),tTb(a)),pUb(a,1)),sTb(a)),new w$b(new Z1b(e,a.f))),I$b(b,new Z1b(e,a.f))}function j_(a,b){switch(b.n.f){case 76:case 100:case 88:Y_(a,
b.n,b);break;case 65:G_(a,b,true);break;case 96:r_(a,b,true),W_(b.c);break;case 154:z_(b);break;case 162:Z_(a,b,true);break;case 157:y0(a,b);break;case 109:B_(a,b,true)}}function Sdb(a){var b,c,d;Xd(a.n==(Afc(),Vec));for(d=(!a.c?(Cyc(),Cyc(),Byc):new Kbc(a.c)).Vd();d.Id();){c=d.Jd();Xd(c.n==Xec);Fyb();b=(ppb(),Yd(c.n==Xec,c),H8b(c,(n8b(),V7b)));if(!!b&&!kQb((iQb(),ZPb),b))return true}return false}function Chb(a,b,c,d){var e,f;f=F9b(Yjb(x3b(F9b(Yjb(K3b(OPc+(a.r.b==0?"":"$"+a.r.b)),a.g),b),F9b((n8b(),
new Wbc((Afc(),bfc),c)),b)),a.r.f.g?a.g.Wi(c):null),b);e=F9b(l3b(f,d),b);a.r.f.g&&r9b(e,f.d.Ii()?f.d.Ii().b.b:a.r.f.i);return e}function Fnb(a,b){var c;c=a.ei().ki();if(Wnc(c,Sd(b.r)))return Rnc(c,Sd(b.r));else if(Wnc(c,Sd(b.s)))return Rnc(c,Sd(b.s));else if(Wnc(c,Sd(b.c)))return Rnc(c,Sd(b.c));else if(Wnc(c,Sd(b.d)))return Rnc(c,Sd(b.d));return b.u[51]}function xTb(a,b){var c,d,e;e=DWb(a.g,0).d.b;d=KTb(a,b);if(AVb(a,(AZb(),OXb))&&!zVb(a,1,aZb)){c=(Bn(),new Zr);Ywc(c.a,Sd(d));while(AVb(a,OXb)&&!zVb(a,
1,aZb)){iTb(a,OXb);Xr(c,KTb(a,b))}return new ZZb(new Z1b(e,a.f),In(c.a))}return d}function L9b(a,b){n8b();Ld(!b.g,"new child has existing parent");Ld(!b.f,"new child has existing next sibling");Ld(!b.i,"new child has existing previous sibling");this.n=a;this.g=null;this.c=b;b.f=null;b.i=this.c;b.g=this;this.k=-1}function Pmb(a){var b,c,d,e,f,g,h;b=(Cyc(),new jzc(new xDc));Rc(b,a.a);h=new Ewc(a.a);while(h.b!=h.c){f=(e=vwc(h),e);g=f.a;for(d=new wxc(g);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);$tc(b.a,
c,(Nqc(),Mqc))==null&&kwc(h,c)}}return b}function twb(a,b,c,d){var e,f;Kd(b.length!=0);Xd(!pEc(a.e,b));f=new wCb(b,c,a,(duc(a.e.c),d));ae(oEc(a.e,b)||!oEc(a.e,b)&&(!pqb(a.d)||!j$(a.b,b)||(e=i$(a,b),!!e&&e.c.g.n==(Afc(),Jdc))),"Illegal shadow: %s",f.c);qEc(a.e,b,f);return f}function KCb(a,b,c){var d,e,f,g,h,i,j;f=JCb(a);if(!a.d){h=new dpb(a.a,new TCb(a),f);Yob(h,b)}g=new dpb(a.a,a,f);cpb(g,b,c);for(j=(e=(new Wuc(a.e.a)).a.He().Vd(),new avc(e));j.a.Id();){i=(d=j.a.Jd(),d.Ve());MCb(a.a,i)}!!a.b&&WCb(a.b)}
function GDc(a,b){var c,d,e,f,g;f=b==null?0:a.b.sj(b);d=(c=a.a.get(f),c==null?new Array:c);for(g=0;g<d.length;g++){e=d[g];if(a.b.rj(b,e.Ve())){if(d.length==1){d.length=0;PDc(a.a,f)}else d.splice(g,1);--a.c;return e.We()}}return null}function F_(a,b,c){var d,e;d=H8b(c,(Hbc(),ybc));!(!!d&&d.Kh())&&!lQb(a.a.p,b)&&D0("AST should not contain "+b,c);if(!a.c||!a.b)return;e=Jpb(a.b);(!e||!lQb(Jpb(a.b),b))&&D0("SCRIPT node should be marked as containing feature "+b,a.b)}function klb(a,b,c,d,e,f){var g,h,i;
g=(h=Xtc(b.q,Sd(c)),!h?(Bn(),Bn(),An):h);if(g.Ud()){Dlb(b,e,f,c,d,a.a.b);a.a.b+=2}else{ae(g.Yd()==2,"unexpected existing refs: %s",g);i=g.ce(0);ae(i.g==d,"unexpected existing set Ref type: %s",i.g)}}function tlb(a,b,c,d,e,f,g){var h,i;if(ylb(a,b,c,d,e,f))return;h=plb(a,f);h.t==(Rlb(),Nlb)||(h.t=g);E8b(d,(n8b(),e8b))!=0;if(e.n==(Afc(),Ccc)&&e.g.n!=Ddc){i=(cmb(),_lb);klb(a,h,d,i,b,c)}else{jlb(a,h,d,(cmb(),_lb),b,c);xlb(d)&&Glb(h)}}function gnb(a){var b,c,d,e,f,g,h;b=zE(VW,mLc,281,a.a.length,0,1);for(f=
0;f<a.a.length;++f){e=a.a[f];g=new tyc(f+1);b[f]=g;uyc(f);h=f/31|0;yyc(g.a,h);g.a[h]=g.a[h]|0|1<<f%31;for(d=In(e.a).Vd();d.Id();){c=d.Jd();ryc(g,b[c.c])}}return b}function VBb(a,b){var c;c=null;if(a){Ld(a.g.n==(Afc(),Jec),a);a.n==Sec?a=(Xd(!!a.c&&!a.c.f),a.c):a.n==mdc&&(a=a.c);if(a.n==rec)c=a;else{Yd(a.n==Fec||a.n==Acc,a);c=null}}if(!c)return"p"+b;else{Yd(c.n==(Afc(),rec),c);return c.Wh()}}function _Kb(a,b,c,d){var e;if(d){switch(d.f){case 42:e=(e6b(),d6b);break;case 41:e=(e6b(),c6b);break;case 40:e=
(e6b(),b6b);break;default:throw gZ(new Irc("Unexpected access modifier type"));}gLb(a,b,(IRb(),CQb));d9b(c,(n8b(),L7b),e)}}function ILb(a,b){var c,d,e,f,g;gLb(a,b,(IRb(),dRb));f=LLb(a,b.c,false);aLb(a,f,b.b);g=oMb(a,(Afc(),cec),b.d);c=dKb(a.a,dec);T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);for(e=b.a.Vd();e.Id();){d=e.Jd();q8b(c,yKb(a.a,d))}return gKb(a.a,bec,f,g,c)}function sm(a){var b,c,d,e,f,g,h;if(duc(a.a.c)==0)return Am(),zm;b=new is(duc(a.a.c));g=0;for(d=new TEc(a);d.b!=d.c.a.b;){c=REc(d);e=c.d;h=c.e;
f=In(h);if(!f.Ud()){Ywc(b.b,(oo(),el(e,f),new Wq(e,f)));g+=f.Yd()}}return new pm(Co(b.b),g)}function P6(a,b){var c,d,e,f;Sd(b);if(!a.v)return null;for(d=Im(Dm(CE(xE(cW,1),mLc,15,0,[v8b(a.o),v8b(a.v)])));Ru(d);){e=Su(d);f=H8b(e,(Hbc(),ybc));if((!f?null:f.ug())!=null&&Dsc((c=H8b(e,ybc),!c?null:c.ug()),b))return e}return null}function Fjb(a,b,c){var d,e,f;ae(c.n==(Afc(),rec)||c.n==Ydc,"Invalid node for declareVar: %s",c);e=c.Wh();f=pEc(b.e,e);if(!!f&&f.c==c)return;d=L6(a.a,a.b);!!f||!Jjb(e,b)||(b.d.n==
Jdc||pqb(b.d))&&Esc(e,BMc)?a.c.xh(b,e,c,d):twb(b,e,c,d)}function j9b(a,b,c){var d,e,f;Ld(!c.f,nTc);Ld(!c.i,oTc);Ld(!c.g,pTc);ce(b.g==a,qTc,a,b);H9b(c,b);c.g=a;e=b.f;f=b.i;d=a.c.i;if(b==f){a.c=c;a.c.i=c}else{b==a.c?a.c=c:f.f=c;b==d?a.c.i=c:e.i=c;c.i=f}c.f=e;b.f=null;b.i=null;b.g=null}function IZ(a,b,c){var d=GZ,h;var e=d[a];var f=e instanceof Array?e[0]:null;if(e&&!f)_=e;else{_=(h=b&&b.prototype,!h&&(h=GZ[b]),LZ(h));_.Gj=c;!b&&(_.Hj=OZ);d[a]=_}for(var g=3;g<arguments.length;++g)arguments[g].prototype=
_;f&&(_.Fj=f)}function alb(a,b){var c,d,e,f;Yd(b.n==(Afc(),gec),b);for(e=b.c;e;e=e.f){if(e.n==ddc){d=e.c;f=d.f}else{d=e;f=null}Yd(d.n==cfc,d);c=d.Wh();(Esc(c.substr(0,1),"'")||Esc(c.substr(0,1),'"'))&&(c=Vsc(c,1,c.length-1));jDc(a.b,c);!!f&&blb(a,f)}}function YFb(a){var b,c,d,e;b=(oo(),new hs);for(e=po(a).Vd();e.Id();){d=e.Jd();c=d.Ve();ZEb();!Esc(c.substr(0,"/".length),"/")&&!(Esc(c.substr(0,rOc.length),rOc)||Esc(c.substr(0,nRc.length),nRc))&&(c="/"+c);es(b,c,d.We())}return Co(b.b)}function rVb(a){var b,
c,d;c=DWb(a.g,0).d.b;if(AVb(a,(AZb(),sZb))){iTb(a,sZb);d=jTb(a);b=(Bn(),new Zr);!!d&&Xr(b,d.a);while(AVb(a,MYb)){iTb(a,MYb);d=jTb(a);if(!d)break;Xr(b,d.a)}return new H1b(new Z1b(c,a.f),In(b.a))}else return sVb(a)}function S6b(a,b){if((a.a.a&2)!=0||W4b(a.a)||(a.a.a&tQc)!=0||F4b(a.a)>0||(a.a.a&HPc)==$Lc||P4b(a.a)||B4b(a.a)>0||Q4b(a.a)||!!a.a.g||(a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)return false;else{l5b(a.a,b);a.e=true;return true}}function fhb(a,b){var c,d,e;Xd(E8b(b,(Hbc(),gbc))!=0);
if(b.n==(Afc(),zfc))return b;e=H3b(b);c=j3b(e?(Xd(H3b(b)),new L9b(Uec,b)):b);epb(a.f.b,b,new Cib(a.f));epb(a.f.b,c,new Eib);d=z8b(c.c?c.c.i:null);thb(a,c,null,null);return e?g9b(d):d}function Bqb(a){ppb();var b;if(a.n==(Afc(),Jdc)){b=a.g;switch(b.n.f){case 86:case 87:case 98:return true;case 116:return(b.c?b.c.i:null)==a&&(E8b(b,(n8b(),N7b))!=0||E8b(b,M7b)!=0||E8b(b,O7b)!=0);default:return false}}else return false}function nNb(a,b){var c;if(b==(fOb(),WNb)){xNb(a);c=lNb(a,!a.o?mOb(a.j):GMb(a));if(c){xNb(a);
OMb(a,aOb)?!a.o?mOb(a.j):GMb(a):(CMb(a,YRc,a.j.g,lOb(a.j)),null)}return c}else{CMb(a,"msg.jsdoc.missing.braces",a.j.g,lOb(a.j));return mNb(a,b)}}function uv(a,b){var c,d,e,f;f=yZ(rZ(VLc,Vrc(yZ(rZ(b==null?0:Db(b),WLc)),15)));c=f&a.b.length-1;e=null;for(d=a.b[c];d;e=d,d=d.a)if(d.d==f&&Gd(d.i,b)){!e?a.b[c]=d.a:e.a=d.a;ov(d.c,d.f);nv(d.b,d.e);--a.f;++a.e;return true}return false}function y8(a){!a.c&&(a.c=w8(a));if(a.f.a.length!=0||a.e.a.length!=0){a.c=YDb($Db(ZDb(_Db(eEb(dEb(cEb(NDb(a.i.a,a.i.a),J8(a.c.f,
a.e)),J8(a.c.g,a.f)),a.c.i),a.c.c),a.c.a),a.c.b));a.f.a=zE(iW,mLc,1,0,5,1);a.e.a=zE(iW,mLc,1,0,5,1)}return a.c}function Kgb(a,b,c,d){var e,f,g,h;f=(h=(ae(Hsc(d,_sc(46))==-1,HMc,d),n8b(),new Wbc((Afc(),rec),d)),h);q9b(f,H8b(c,(Hbc(),mbc)));j9b(c.g,c,f);e=q3b(c,(g=(ae(Hsc(d,_sc(46))==-1,HMc,d),new Wbc(rec,d)),g),ufc);o8b(a.c?a.c.i:null,e,b);return e}function Qwb(b){var c,d;if(b.d!=null)return;try{d=Rsc(b.a,gMc,-1);b.d=zE(yF,iMc,46,d.length,15,1);for(c=1;c<d.length;++c)b.d[c]=b.d[c-1]+d[c-1].length+
1}catch(a){a=fZ(a);if(pF(a,104)){b.d=zE(yF,iMc,46,1,15,1);b.d[0]=0}else throw gZ(a);}}function GKb(a,b){var c,d;if(b.n==(Afc(),Jec)){c=b.c;for(;c;c=c.f){if(c.n!=rec)continue;d=c.f;for(;d;d=d.f)d.n==rec&&Esc(c.Wh(),d.Wh())&&a.d.Bh(x2b('Duplicate parameter name "%s"',CE(xE(iW,1),mLc,1,5,[c.Wh()])),a.q,T9b(b.k),S9b(b.k))}}}function YLb(a,b){var c,d,e,f,g,h,i;i=b.a;f=jKb(a.a,mKb(i));vKb(f,i.d.b,i.d.a);g=eKb(a.a,(Afc(),Rec),f);h=i.c;e=Jsc(h,_sc(47));c="";e<h.length&&(c=h.substr(e+1));sMb(a,b,c);if(c.length!=
0){d=jKb(a.a,c);vKb(d,i.d.b,i.d.a);q8b(g,d)}return g}function dNb(a){var b,c,d,e,f,g;xNb(a);f=!a.o?mOb(a.j):GMb(a);c=a.j.g;e=lOb(a.j);g=gNb(a,f);uNb(a,c,e,g,f==(fOb(),WNb));b=!g?null:new H7b(g,(d=H8b(a.n,(Hbc(),ybc)),!d?null:d.ug()));if(b){s7b(a.f,b);a.f.a.e=true;return k6b(a.f)}return null}function $8b(a,b){if(b.n!=a.n)return false;switch(a.n.f){case 29:return a.Wh().length!=0&&a.Wh()==b.Wh();case 33:case 99:return true;case 26:return(a.c?a.c.i:null).Wh()==(b.c?b.c.i:null).Wh()&&$8b(a.c,b.c);case 98:default:return false}}
function Kw(a,b){var c,d,e;if(uF(b)===uF(Sd(a)))return true;if(!pF(b,54))return false;d=b;e=a.Yd();if(e!=d.Yd())return false;if(pF(d,69)){for(c=0;c<e;c++)if(!Gd(a.ce(c),d.ce(c)))return false;return true}else return qu(a.Vd(),d.Vd())}function knb(a,b){var c,d,e,f;Sd(a);c=(Bn(),Sd(b),pF(b,21)?In(b):Gn(Nw(b.Vd())));for(f=c.Vd();f.Id();){e=f.Jd();if(e.a.sh().c==(scc(),rcc)){d=e.k;if(d==a)continue;!!d&&(Kd(true),e.k=null,bxc(d.d,e));Ywc(a.d,e);Kd(!a||!e.k||e.k==a);e.k=a}}}function _ob(a,b){var c,d,e,f,
g,h;e=b.c;f=e.f;c=f.f;g=(ppb(),b.n==(Afc(),bdc)&&(!(b.n==bdc&&Gqb(b.c))||!iqb(b.g)));Zob(a,f,b);for(d=c.c;d;){h=d.f;d.n==fdc&&Zob(a,d.c,d);d=h}g||Zob(a,e,b);a.e=b;Sob(a,b);g&&Zob(a,e,b);Zob(a,c,b);Rob(a,false)}function v7b(a,b){if(!!b&&!((a.a.a&2)!=0||W4b(a.a)||(a.a.a&tQc)!=0||F4b(a.a)>0||(a.a.a&HPc)==$Lc||P4b(a.a)||B4b(a.a)>0||Q4b(a.a)||!!a.a.g||(a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)&&n4b(a.a,b)){a.e=true;return true}return false}function vdb(a,b){var c,d,e,f,g;Ld(V8b(a),a);Ld(b.n==
(Afc(),Ycc),b);c=g9b(b);g=G9b(O$(x8b(a,false),ePc),c);d=F9b((f=Tqb(g,CE(xE(HU,1),IMc,7,0,[])),f),b);q8b(d,F9b((e=new J9b(lfc),e),c));c9b(d,(n8b(),W7b),0);while(b.c)q8b(d,g9b(b));return d}function dob(a,b,c){var d,e,f,g;Yd((ppb(),ypb(c)||c.n==(Afc(),Jdc)||c.n==(Afc(),pec)||c.n==(Afc(),Vec)&&!c.g||c.n==(Afc(),Xec)),c);for(g=(e=(new fvc(Kob(b).e)).a.He().Vd(),new kvc(e));g.a.Id();){f=(d=g.a.Jd(),d.We());twc(a.b).Ch(f.b,false)}}function V5b(a,b){if(!a&&!b)return true;if(!a&&!!b||!!a&&!b)return false;
if(a.d==null&&b.d!=null||a.d!=null&&b.d==null)return false;return(a.d==null&&b.d==null||a.d.Xh(b.d,false,true,false,false))&&a.f==b.f&&a.e==b.e&&a.c==b.c&&a.b==b.b}function SB(a,b){var c,d,e;TB(a);switch(b.f){case 7:UB(a>0&(a&a-1)==0);case 1:case 3:return 31-Trc(a);case 0:case 2:return 32-Trc(a-1);case 5:case 4:case 6:d=Trc(a);c=-1257966797>>>d;e=31-d;return e+(~~(c-a)>>>31);default:throw gZ(new Jqc);}}function x0(a,b){var c,d,e;b0((Afc(),ofc),b);d=C8b(b);(d<2||d>3)&&D0(ZMc+d,b);n_(a,b.c);e=false;
c=b.c.f;b0(Vcc,c);T_(c);if(c.c){p_(a,c.c);e=true}if(C8b(b)==3){n_(a,b.c?b.c.i:null);e=true}e||D0("Missing catch or finally for try statement.",b)}function Rwb(b,c){var d,e;Qwb(b);if(c>b.d.length)return null;c<1&&(c=1);e=b.d[c-1];d="";try{d=b.a}catch(a){a=fZ(a);if(pF(a,104))return null;else throw gZ(a);}return Isc(d,_sc(10),e)==-1?e>=d.length?null:d.substr(e):Vsc(d,e,Isc(d,_sc(10),e))}function CKb(a,b){var c,d,e;e=new Cwc;while(b){GKb(a,b);DKb(a,b);HKb(a,b);FKb(a,b);EKb(a,b);b.n==(Afc(),Jdc)&&b.g.n==
Vcc&&(!b.g?null:b.g.g).n!=Jdc&&cKb(a,b,(IRb(),KQb));d=b.f;c=b.c;if(c){!!d&&kwc(e,d);b=c}else d?b=d:b=vwc(e)}Xd(e.b==e.c)}function ZE(a,b){var c,d,e,f,g;b&=63;c=a.h;d=(c&uMc)!=0;d&&(c|=-1048576);if(b<22){g=c>>b;f=a.m>>b|c<<22-b;e=a.l>>b|a.m<<22-b}else if(b<44){g=d?tMc:0;f=c>>b-22;e=a.m>>b-22|c<<44-b}else{g=d?tMc:0;f=d?sMc:0;e=c>>b-44}return HE(e&sMc,f&sMc,g&tMc)}function oob(a,b,c,d){mob(this);Yd((ppb(),ypb(a)||a.n==(Afc(),Jdc)||a.n==(Afc(),pec)||a.n==(Afc(),Vec)&&!a.g),a);a.n==(Afc(),Jdc)&&Yd(!c,
a);this.i=a;this.e=false;this.g=b;if(c){Yd(!ypb(a),a);this.f=this}else{Yd(ypb(a)||a.n==Jdc,a);this.f=d.f}}function dqb(a){var b;if(!(a.n==(Afc(),Jdc)&&iqb(a.g)&&a.n==Jdc&&Gqb(a.c)))return false;b=a.g;while(b)switch(b.n.f){case 82:return b.g.n!=Jdc;case 65:case 85:case 158:case 109:case 112:return false;default:Yd(b.n==eec,b);b=b.g}return false}function ITb(a){var b,c,d;c=DWb(a.g,0).d.b;d=TUb(a);while(b=DWb(a.g,0).d.b.b>a.f.b,!(b||zVb(a,0,(AZb(),ZYb))||zVb(a,0,(AZb(),KXb))||zVb(a,0,(AZb(),XXb)))&&
zVb(a,0,(AZb(),HYb))){iTb(a,(AZb(),HYb));iTb(a,MXb);d=new OZb(new Z1b(c,a.f),d)}return d}function aTb(a){var b,c,d,e;d=new fxc;Ywc(d,Yrc(0));for(c=0;c<a.length;c++){b=a.charCodeAt(c);if(bTb(b)){c+1<a.length&&b==13&&a.charCodeAt(c+1)==10&&++c;Ywc(d,Yrc(c+1))}}Ywc(d,Yrc(_Kc));return e=zE(yF,iMc,46,d.a.length,15,1),Uxc(e,new cTb(d)),e}function G1(a,b,c){if(b.n==(Afc(),Vec))return;if(E8b(b,(Hbc(),Hac))>E8b(c,Hac)){if(K1(b,c))throw gZ(new Irc(a+"unchanged scope marked as changed: "+B1(b)));}else if(!K1(b,
c))throw gZ(new Irc(a+"changed scope not marked as changed: "+B1(b)));}function bgb(a){var b,c,d,e;c=H8b(a,(Hbc(),mbc));if(c){b=a.n==(Afc(),Qdc)||E8b(a,(n8b(),M7b))!=0;if(b&&!!((HPc&c.a)==$Lc?c.i:null))return(HPc&c.a)==$Lc?c.i:null;else{d=G4b(c);if(d.Yd()==1){e=H4b(c,tu(G4b(c).Vd()));if(e)return e}}}return null}function JLb(a,b){var c;c=yKb(a.a,b.b);if(c.n==(Afc(),Jdc)||c.n==bdc||c.n==jec||c.n==gdc){a.a.d.Ah("Lexical declarations are only allowed at top level or inside a block.",a.a.q,(RJb(),b.o.b.b+
1),b.o.b.a);return c}return fKb(a.a,eec,mMb(a,b.a),c)}function y_(a,b,c){var d,e;e=C8b(c);(e<1||e>2)&&D0(VMc+e,c);d=c.c;switch(d.n.f){case 93:l_(a,b,d);break;case 94:h0(a,b,d);break;default:D0("Invalid destructuring lhs first child for "+b+TMc,c)}!!c.c&&!!c.c.f&&c.c.f==(c.c?c.c.i:null)&&E_(a,c.c.f)}function E3(a){var b,c,d;c=null;if(a.n==(Afc(),Pdc))c=(a.c?a.c.i:null).Wh();else if(a.n==rec){d=a.Wh();b=Jsc(d,_sc(36));b!=-1&&(c=d.substr(b+1))}if(c!=null)if(Esc(c,"inherits"))return a6(),$5;else if(Esc(c,
"mixin"))return a6(),_5;return null}function Hob(){Hob=JZ;Gob=new Mcb("JSC_UNTRANSPILABLE",(E2(),B2),new Rtc('Cannot convert {0} feature "{1}" to targeted output language.'));Eob=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),rRb),uRb,vRb,wRb]));Fob=oQb(TPb,HRb);mQb(mQb(TPb,Eob),Fob)}function YKb(a,b,c,d){var e,f;e=d.n==(Afc(),_cc)?d.c:d;X8b(e)||a.a.d.Ah(x2b("Invalid %s %s operand.",CE(xE(iW,1),mLc,1,5,[c?"postfix":"prefix",b==$dc?"increment":"decrement"])),a.a.q,T9b(d.k),S9b(d.k));f=eKb(a.a,b,d);b9b(f,
(n8b(),_7b),c);return f}function ZWb(a){yWb(a);while(xWb(a,a.f)&&(xWb(a,a.f)?zsc(a.b,a.f):0)!=93&&!jXb(xWb(a,a.f)?zsc(a.b,a.f):0))if(!$Wb(a))return false;if((xWb(a,a.f)?zsc(a.b,a.f):0)!=93){FWb(a,"']' expected",CE(xE(iW,1),mLc,1,5,[]));return false}yWb(a);return true}function kkb(a,b,c){var d,e;if(b.n==(Afc(),_ec)){e=(Xd(!!b.c&&!b.c.f),b.c);if(e.n==rec&&nkb(a,e.Wh()))return false}if(c){d=b.g;if(Eqb(d)&&b==d.c&&b.c.n==rec&&nkb(a,b.c.Wh()))return false;return tpb(b,a.c,a.e)}else return ppb(),upb(b,
false,a.b)}function XSb(){OSb();return CE(xE(IR,1),sLc,37,0,[RRb,SRb,TRb,WRb,XRb,ZRb,$Rb,_Rb,aSb,fSb,gSb,hSb,iSb,lSb,mSb,tSb,zSb,CSb,DSb,ESb,GSb,ISb,JSb,KSb,LSb,MSb,URb,VRb,bSb,cSb,dSb,kSb,BSb,jSb,nSb,qSb,vSb,wSb,xSb,ySb,ASb,NSb,uSb,FSb,eSb,YRb,HSb,rSb,sSb])}function gB(a,b){var c,d;if(b>127)throw gZ(new QB((c=b>>>0,dMc+c.toString(16))));d=a.e[b];if(d==-1)if(b<=32||b==127)throw gZ(new QB((c=b>>>0,dMc+c.toString(16))));else throw gZ(new QB("Unrecognized character: "+String.fromCharCode(b)));return d}
function kib(a,b){this.r=a;this.n=new fDc;this.c=new Cwc;this.i=new Cwc;this.e=new Cwc;this.k=new Cwc;this.f=new mDc;this.a=new fxc;this.q=new fxc;this.p=new pib(this);Xd(this.p.c==0);this.j=new pib(this);Xd(this.j.c==1);Ywc(this.a,this.j);this.g=b}function lvb(a,b,c){var d,e,f,g,h;for(e=(!c.c?(Cyc(),Cyc(),Byc):new Kbc(c.c)).Vd();e.Id();){d=e.Jd();h=d.c;Xd(d.n==(Afc(),cfc)&&(h.n==bfc||h.n==Edc));f=d.Wh();Esc(f.substr(0,2),rOc)&&(f=f.substr(2));g=h.n==bfc?b+(""+h.Wh()):UQc;_tc(a.b,b+(""+f),g)}}function F6b(a,
b){if(!!b&&!((a.a.a&2)!=0||W4b(a.a)||(a.a.a&tQc)!=0||F4b(a.a)>0||(a.a.a&HPc)==$Lc||P4b(a.a)||B4b(a.a)>0||Q4b(a.a)||!!a.a.g||(a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)){x5b(a.a,b,eQc);a.e=true;return true}else return false}function s7b(a,b){if(!!b&&!((a.a.a&2)!=0||W4b(a.a)||(a.a.a&tQc)!=0||F4b(a.a)>0||(a.a.a&HPc)==$Lc||P4b(a.a)||B4b(a.a)>0||Q4b(a.a)||!!a.a.g||(a.a.a&HPc)==WPc||(a.a.a&HPc)==hMc||(a.a.a&HPc)==eQc)){x5b(a.a,b,WPc);a.e=true;return true}else return false}function cmb(){cmb=JZ;
_lb=new dmb("SET_FROM_GLOBAL",0);amb=new dmb("SET_FROM_LOCAL",1);$lb=new dmb("PROTOTYPE_GET",2);Wlb=new dmb("ALIASING_GET",3);Zlb=new dmb("DIRECT_GET",4);Xlb=new dmb("CALL_GET",5);Ylb=new dmb("DELETE_PROP",6);bmb=new dmb(kQc,7)}function fMb(a,b){var c,d,e,f,g;g=eKb(a.a,(Afc(),ofc),zKb(a.a,b.a));c=dKb(a.a,Vcc);f=false;d=b.b;if(d){T9b(c.k)==-1&&vKb(c,d.o.b,d.o.a);f=true;q8b(c,yKb(a.a,d))}q8b(g,c);e=b.c;!!e&&q8b(g,zKb(a.a,e));!f&&!!e&&T9b(c.k)==-1&&vKb(c,e.o.b,e.o.a);return g}function XWb(a){if(!lXb(xWb(a,
a.f)?zsc(a.b,a.f):0)){FWb(a,"Expected regular expression first char",CE(xE(iW,1),mLc,1,5,[]));return false}if(!YWb(a))return false;while(xWb(a,a.f)&&kXb(xWb(a,a.f)?zsc(a.b,a.f):0))if(!YWb(a))return false;return true}function Mrb(a,b){var c,d,e;Kd(b.n==(Afc(),eec));e=b.c?b.c.i:null;switch(e.n.f){case 83:case 82:case 72:case 73:case 101:case 102:case 70:case 71:return;default:d=(c=new J9b(Vcc),c);H9b(d,e);j9b(b,e,d);r8b(d,e);Nrb(a,"LABEL normalization",b);return}}function pNb(a,b){var c,d;d=fNb(a,b);
if(OMb(a,(fOb(),VNb))){!a.o?mOb(a.j):GMb(a);xNb(a);c=oNb(a,d.Wh(),!a.o?mOb(a.j):GMb(a));if(c){r8b(d,c);xNb(a);if(!OMb(a,_Nb))return CMb(a,"msg.jsdoc.missing.gt",a.j.g,lOb(a.j)),null;!a.o?mOb(a.j):GMb(a)}}return d}function CNb(a){xMb();var b,c;b=_Ib(gJb(dJb(eJb(bJb(hJb(aJb(fJb(cJb(gJb(dJb(new iJb,(zJb(),xJb)),(KJb(),JJb)),(mJb(),lJb)),(FJb(),EJb)),WIb((bn(),mz(),lz))),(null,lz)),(null,lz)),false),pJb),IJb));c=new BNb(new rOb(a),a,0,null,b,(a3b(),_2b));return c}function $5b(a,b){if(!a&&!b)return true;
if(!a&&!!b||!!a&&!b)return false;if(a.d==null&&b.d!=null||a.d!=null&&b.d==null)return false;return(a.d==null&&b.d==null||a.d.Xh(b.d,false,true,false,false))&&a.f==b.f&&a.e==b.e&&a.c==b.c&&a.b==b.b&&a.a==b.a}function b3(){b3=JZ;a3=new Mcb("JSC_TYPE_IMPORT_CODE_REFERENCE",(E2(),B2),new Rtc("Cannot reference goog.requireType()''d name {0} outside of a type annotation."));x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),n8b(),new Wbc((Afc(),rec),kNc)),new Wbc(bfc,pNc))}function _hb(a,b,c,d){var e;if(swc(a.k)||qwc(a.k).c<
c.c)e=PPc;else{Xd(qwc(a.k).c!=c.c);e="jumpThroughFinallyBlocks"}if(d==0){p8b(b.g,Dhb(a,b,e,CE(xE(HU,1),IMc,7,0,[mib(c,b)])),b);k9b(b,Fhb(a,b))}else k9b(b,aib(a,b,e,CE(xE(HU,1),IMc,7,0,[mib(c,b)])))}function Sjb(a,b){Rjb();var c,d,e;e=(!a.P&&(a.P=new llc),a.P);c=e.u[0];d=r9b((C6(a,APc+Xsc("arrayFromIterable",(bFc(),_Ec)),false),l3b(Wqb(a,"$jscomp.arrayFromIterable"),CE(xE(HU,1),IMc,7,0,[b]))),c);r9b(d.c,Okc(e,c,CE(xE(cV,1),xPc,23,0,[])));return d}function bqb(a){ppb();switch(a.f){case 61:case 62:case 1:case 2:case 3:case 4:case 5:case 36:case 37:case 6:case 8:case 7:case 9:case 41:case 40:case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:return true;
default:return false}}function Dub(a,b){var c,d,e,f,g,h;g=x8b(b.a,false);if(a.f.d){h=(f=new J9b((Afc(),lfc)),f);d=$$(h);c=g.c;E8b(a.a.b.g,(Hbc(),zbc))!=0?j9b(c.g,c,d):k9b(c,$$(d))}return e=g3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc((Afc(),rec),"")),new J9b(Jec),g),e}function aGb(a,b,c){var d,e,f;f="/".length;Esc(c.substr(c.length-f,f),"/")&&(c=Vsc(c,0,c.length-1));for(d=0;d<VFb.length;d++){e=hEb(a,b,c+(""+VFb[d]));if(e!=null)if(Esc(VFb[d],VQc)){if(No(a.c,e))return $Fb(a,b,Po(a.c,e))}else return e}return null}
function tOb(a){switch(a){case 64:case 42:case 44:case 60:case 62:case 58:case 40:case 41:case 123:case 125:case 91:case 93:case 63:case 33:case 124:case 61:case -1:case 10:return false;default:return Gfc(),!(a<=127?a==32||a==9||a==12||a==11:a==160)}}function o6b(a,b,c,d,e){var f,g,h;if(a.b){h=new Y5b;Ld(b.charCodeAt(0)!=32&&zsc(b,b.length-1)!=32,mTc);h.d=b;S5b(h,d,e,d,e+b.length);g=new U5b;f=(n8b(),new Xbc((Afc(),rec),b,d,e));t9b(f,b.length);!!c&&z9b(f,c);g.d=f;S5b(g,d,e,d,e+b.length);O5b(a.b,g)}}
function urc(a){if(a.nj()){var b=a.c;b.oj()?a.p="["+b.o:!b.nj()?a.p="[L"+b.ug()+";":a.p="["+b.ug();a.b=b.lj()+"[]";a.n=b.mj()+"[]";return}var c=a.j;var d=a.d;d=d.split("/");a.p=xrc(".",[c,xrc("$",d)]);a.b=xrc(".",[c,xrc(".",d)]);a.n=d[d.length-1]}function _jb(a){$jb();this.a=a;this.e=null;this.f=null;this.d=null;this.c=null;this.b=r9b(l3b(r9b(x3b(r9b((ae(Hsc($Pc,_sc(46))==-1,HMc,$Pc),n8b(),new Wbc((Afc(),rec),$Pc)),this.d),r9b(new Wbc(bfc,"pow"),this.f)),this.c),CE(xE(HU,1),IMc,7,0,[])),this.e)}function umb(){umb=
JZ;tmb=new Mcb("JSC_IMPLICITLY_NULLABLE_JSDOC",(E2(),C2),new Rtc("Name {0} in JSDoc is implicitly nullable, and is discouraged by the style guide.\nPlease add a '!' to make it non-nullable, or a '?' to make it explicitly nullable."))}function NOb(a,b){if(b.n!=(Afc(),rec)&&b.n!=bfc){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,[$Kc])),a.b.ug(),a.d,a.c);return false}if(b.Wh().length==0){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,["string parameter"])),a.b.ug(),a.d,a.c);return false}return true}function Bkb(a,
b){var c;Kd(b.n==(Afc(),Xec));Iib(b)&&(a.c=(b9(),Y8));c=L6(a.a,H8b(b,(Hbc(),cbc)));A8(c).Sd((wDb(),vDb))&&u8(c,vDb);epb(a.a,b,a);a.c==(b9(),Y8)?zkb(a,b,true):a.c==a9&&false&&null.Ij(z8(c).a)&&(a.c=$8);v8(c,UFb(z8(c).a));D8(c,a.c);c.g=true}function Oob(a,b,c){var d,e,f,g,h;d=a.g;a.g=b;a.e=b;if(a.a.Bg(a,b,c)){e=b.c;f=!!c&&(ppb(),b.n==(Afc(),Jdc)&&iqb(b.g)&&b.n==Jdc&&Gqb(b.c));f&&Zob(a,e,b);a.e=b;Sob(a,b);f||Zob(a,e,b);g=e.f;h=g.f;Zob(a,g,b);Zob(a,h,b);Rob(a,false);a.e=b;a.a.Cg(a,b,c)}a.g=d}function gUb(a){var b,
c,d,e;e=DWb(a.g,0).d.b;b=tVb(a);if(AVb(a,(AZb(),dZb))){b.p==(n1b(),e1b)&&VVb(a,"Unary operator '%s' requires parentheses before '**'",CE(xE(iW,1),mLc,1,5,[b.b]));c=wTb(a);d=gUb(a);return new RZb(new Z1b(e,a.f),b,c,d)}else return b}function m2b(a,b){var c,d,e,f;e=new stc;e.a+="0";if(a.b.n>0){e.a+=".";f=zE(xF,eLc,46,a.b.n,15,1);Lxc(f,f.length,48);e.a+=gtc(f,0,f.length)}e.a+="E+00";c=NZ(a.a);ptc(b,Nsc(c,69,101));if(a.b.i&&a.b.n==0){d=b.a.indexOf("e");b.a=Vsc(b.a,0,d)+"."+Usc(b.a,d)}}function n2(){n2=
JZ;m2=new Mcb("JSC_UNDEFINED_NAME",(E2(),D2),new Rtc("{0} is never defined"));new Mcb("JSC_NAME_DEFINED_LATE",D2,new Rtc("{0} defined before its owner. {1} is defined at {2}:{3}"));l2=new Mcb("JSC_STRICT_MODULE_DEP_QNAME",C2,new Rtc(sNc))}function m7(a,b){var c,d,e,f;c=new fxc;for(f=new Tu(wu($t(b.a),new Xt));Ru(f);){d=Su(f);(!E0(a.G.Z)||true||Esc(kOc,y8(d).c.Ie(mNc)))&&(c.a[c.a.length]=d,true)}for(e=new wxc(c);e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);d.b=a;A8(d);D8(d,(b9(),Y8))}return c}function fLb(a,
b){var c,d;c=b.a;d=false;if(Efc(c)){a.a.e=oQb(a.a.e,(IRb(),VQb));d=a.a.a.d==(zJb(),pJb)}if(!!a.a.n&&a.a.n.Sd(c)){a.a.e=oQb(a.a.e,(IRb(),eRb));d=a.a.a.d==(zJb(),pJb)}d&&a.a.d.Ah("identifier is a reserved word",a.a.q,(RJb(),b.d.b.b+1),b.d.b.a)}function Bpb(a){ppb();var b;Ld(!!a&&(a.n==(Afc(),ufc)||a.n==jec||a.n==gdc)||a.n==(Afc(),Jec)||aqb(a)||a.n==(Afc(),adc)||a.n==(Afc(),odc)||a.n==(Afc(),mdc)||a.n==(Afc(),Vdc)||a.n==(Afc(),Idc)||a.n==(Afc(),Gdc)||a.n==(Afc(),Hdc),a);b=new fxc;Npb(a,b);return b}function iMb(a,
b){var c,d;d=UKb(b.b.e);c=yKb(a.a,b.a);if(d==(Afc(),wec)&&c.n==Cec){c.Zh(-c.Uh());return c}else{d==ndc&&!(c.n==Pdc||c.n==Odc||c.n==rec)&&a.a.d.Ah("Invalid delete operand. Only properties can be deleted.",a.a.q,T9b(c.k),0);return eKb(a.a,d,c)}}function WUb(a,b){var c;if(zVb(a,0,(AZb(),HYb))||zVb(a,0,FYb))c=UUb(a,b);else{c=FUb(a);HZb(c)||VVb(a,WSc,CE(xE(iW,1),mLc,1,5,[]));b==0&&c.p!=(n1b(),q0b)&&VVb(a,"Only an identifier or destructuring pattern is allowed here.",CE(xE(iW,1),mLc,1,5,[]))}return c}function Jlb(a){var b;
if(a.c){b=a.c.g;if(!b)return null;switch(b.n.f){case 65:case 47:case 96:return H8b(b,(Hbc(),mbc));case 76:case 100:case 88:return a.c==b.c?H8b(b,(Hbc(),mbc)):H8b(a.c,(Hbc(),mbc));case 43:case 97:return H8b(a.c,(Hbc(),mbc))}}return null}function qFc(a){nFc();var b,c,d;if(Esc(xTc,a))d="rhino/Messages.properties";else if(Esc(hSc,a))d="parsing/ParserConfig.properties";else throw gZ(new GD("ResourceBundle not available: "+a));b=Ytc(mFc,d);if(!b){c=Z2b(d);b=new pFc(U2b(c));_tc(mFc,d,b)}return b}function B7(a){var b,
c,d;Yd(!!a.B,dOc);Xd(a.g.a.d==0);Xd(true);d=cnb(a.B);if(d)for(c=new Tu(wu($t(Tt(Wt(new eyc(a.B.a),new lnb)).a),new Xt));Ru(c);){b=Su(c);b.a.sh().c==(scc(),rcc)&&Yd(b.k==d,"Expected all weak files to be in the weak module.")}r8(new d8(a))}function cFb(a,b){var c,d,e,f;c=new DHc(new SBc(new sBc(new ABc(new iFb),new kFb)));for(e=xu(a.xf().Vd());e.Id();){d=e.Jd();f=b.Ph(d);!Esc(f.substr(0,1),"/")&&!(Esc(f.substr(0,2),rOc)||Esc(f.substr(0,3),nRc))&&(f="/"+f);c.a.Je(f,(Nqc(),Lqc))==null}return In(c)}function yOb(a,
b,c,d,e){var f;AOb();f=vOb;return _Ib(gJb(eJb(dJb(bJb(hJb(fJb(cJb(aJb(eJb(bJb(hJb(aJb(fJb(cJb(gJb(dJb(new iJb,(zJb(),xJb)),(KJb(),JJb)),(mJb(),lJb)),(FJb(),EJb)),WIb((bn(),mz(),lz))),(null,lz)),(null,lz)),false),WIb(f)),b),c),xOb),wOb),a),d),e))}function bC(a,b,c){var d,e;--b;--c;if(b<0||b>=a.c.a.length)return null;Xd(b>=0);Xd(c>=0);if($wc(a.c,b)==null)return dC(a,b);d=$wc(a.c,b);Xd(d.a.length!=0);if(d.a[0].$f()>c)return dC(a,b);e=jC(d,c,0,d.a.length-1);Zd(e>=0,"unexpected:%s",e);return cC(a,d.a[e])}
function O6(a){var b,c,d,e,f;f=new mDc;if(a.v)for(e=v8b(a.v).Vd();e.Id();){d=e.Jd();E8b(d,(n8b(),l8b))!=0&&jDc(f,Q6(a,(b=H8b(d,(Hbc(),ybc)),!b?null:b.ug())))}return new qub((c=!a.g?(Bn(),Bn(),An):t1(a.g.a,(E2(),B2)),!a.g?(Bn(),Bn(),An):t1(a.g.a,(E2(),D2)),c))}function EGb(){EGb=JZ;new Mcb("JSC_BAD_IJS_FILE_NAME",(E2(),B2),new Rtc("--ijs file name must end in .i.js: {0}"));DGb=new Mcb("JSC_CONFLICTING_IJS_FILE",D2,new Rtc("Found --ijs file with the same basename as --js or --weakdep file.\nFile 1: {0}\nFile 2: {1}"))}
function ioc(a,b){var c;Sd(b);if(!(!!b.Li()&&Zfc(a.e,b.Li().e))){if(!b.Li())if(Igc(a,b,new Akc(true),0))return a;else if(b.zi(a))return igc(b);if(b.xi())return a.A.u[59];return a.A.u[58]}c=b.Li();Sd(c);if(Onc(a.B,c.B,2,new ukc(true),0))return a;return a.d}function E4(a,b,c){var d,e,f,g,h,i;h=0;d=0;for(f=0;f<b.length;f++)switch(b.charCodeAt(f)){case 34:++d;break;case 39:++h}if(a.g?h<=d:h<d){g=39;e='"';i="\\'"}else{g=34;e='\\"';i="'"}return String.fromCharCode(g)+J4(a,b,e,i,"\\\\",c,false)+String.fromCharCode(g)}
function Nib(a,b,c,d){var e,f,g;e=Wqb(a.a,d.b);f=v3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc((Afc(),rec),"")),new J9b(Jec),j3b((Xd(H3b(e)),new L9b(Uec,e))));G9b(f,d.a);g=P3b(CE(xE(HU,1),IMc,7,0,[W3b(GPc,new J9b(nfc)),W3b(nNc,f)]));q8b(b,W3b(c,g));v7(a.a,f)}function rCb(a,b){var c;c=a.b.j;if(!c)return;clb(new dlb(a.b),b);if(!qz(a.b.j,c)){u7(a.b,new Gmb(null,null,-1,-1,pCb,null,CE(xE(nW,1),uNc,2,6,[c.Bd(),a.b.j.Bd()])));throw gZ(new Irc("Validity Check failed: Extern properties changed from:\n"+
c+"\nto:\n"+a.b.j));}}function ZFb(a,b,c,d,e,f){var g,h;ZEb();Esc(c.substr(0,1),"/")||(Esc(c.substr(0,2),rOc)||Esc(c.substr(0,3),nRc))?g=(h=$Fb(a,b,c),h==null&&(h=aGb(a,b,c)),h):g=_Fb(a,b,c);g==null&&a.d.xg((E2(),D2),new Gmb(d,null,e,f,YEb,null,CE(xE(nW,1),uNc,2,6,[c])));return g}function Ehc(a,b,c,d){var e,f;Kd(!a.Mi());Kd(!b.Mi());Pd(b.yi(),"isStructuralSubtype should be called with structural supertype. Found %s",b);e=(!c.b&&(c.b=new fDc),yg(c.b,new Bkc(c,a,b),(Hkc(),Gkc)));if(e)return e.a;f=Xhc(a,
b,c,d,0);return zkc(c,a,b,f?Ekc:Fkc)}function eC(a,b){var c;if(b.i!=3)throw gZ(new rD("Unknown version: "+b.i));c=b.b;if(c!=null&&c.length==0)throw gZ(new rD("File entry is empty"));if(b.f){gC(a,b,null);return}a.b=b.c;a.e=b.g;a.d=b.e;a.b>=0?a.c=new gxc:a.c=new fxc;xg(a.a,b.a);lC(new qC(a,b.d))}function y3(){y3=JZ;new Mcb("JSC_REFLECT_OBJECTLIT_EXPECTED",(E2(),D2),new Rtc("Object literal expected as second argument"));y3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),n8b(),new Wbc((Afc(),rec),kNc)),new Wbc(bfc,
"reflect"),CE(xE(HU,1),IMc,7,0,[new Wbc(bfc,"cache")]))}function xlb(a){var b,c,d;d=Tpb(a);if(!d)return false;else if(d.n==(Afc(),bdc))return true;b=(ppb(),c=Dpb(a),!c?null:H8b(c,(Hbc(),mbc)));return!!b&&((b.a&2)!=0&&d.n==(Afc(),Jdc)||((b.a&512)!=0||(b.a&bPc)!=0)&&d.n==(Afc(),Jdc)||(b.a&HPc)==eQc&&d.n==(Afc(),Eec))}function VTb(a){var b,c,d,e;e=DWb(a.g,0).d.b;iTb(a,(AZb(),HXb));d=new w$b(pTb(a,DWb(a.g,0).d.b));if(DWb(a.g,0).e==GYb){iTb(a,GYb);zVb(a,0,HYb)||zVb(a,0,FYb)?d=UUb(a,0):d=wUb(a);iTb(a,LXb)}else RVb(a,
(IRb(),pRb));c=STb(a);b=new XZb(new Z1b(e,a.f),d,c);return b}function J3b(a){switch(a.n.f){case 80:case 65:return true;case 82:case 74:case 96:case 88:case 75:case 89:case 71:case 84:case 72:case 73:case 101:case 102:case 66:case 83:case 100:case 67:case 39:case 44:case 76:case 70:case 77:return true;default:return false}}function oNb(a,b,c){var d,e,f,g;f=lNb(a,c);if(!f)return null;g=(d=new J9b((Afc(),Vcc)),d);e=1;q8b(g,f);while(OMb(a,(fOb(),PNb))){!a.o?mOb(a.j):GMb(a);xNb(a);f=lNb(a,!a.o?mOb(a.j):
GMb(a));if(!f)return null;++e;q8b(g,f)}Esc(b,NMc)&&e==1&&r8b(g,QMb(a,Pec));return g}function QUb(a,b){var c,d;d=DWb(a.g,0).d.b;c=(Bn(),new Zr);iTb(a,(AZb(),FYb));while(KVb(a,0)||DWb(a.g,0).e==HYb){Xr(c,RUb(a,b));if(AVb(a,OXb))iTb(a,OXb);else break}if(AVb(a,aZb)){RVb(a,(IRb(),nRb));Xr(c,XUb(a,b))}iTb(a,KXb);return new u_b(new Z1b(d,a.f),In(c.a))}function P9b(a,b,c,d,e){n8b();Kd(!b.g);Kd(!b.f);Kd(!b.i);Kd(!c.g);Kd(!c.f);Kd(!c.i);Kd(!d.g);Kd(!d.f);Kd(!d.i);Kd(!e.g);Kd(!e.f);Kd(!e.i);this.n=a;this.g=
null;this.c=b;b.f=c;b.i=e;b.g=this;c.f=d;c.i=b;c.g=this;d.f=e;d.i=c;d.g=this;e.f=null;e.i=d;e.g=this;this.k=-1}function Kjc(a,b,c){var d,e,f,g,h;e=null;if(chc(a.b,b.b,0,new ukc(true)))e=a.b.a;else return null;f=c?a.b.b.ii(b.b.b):a.b.b.hi(b.b.b);h=null;if(ugc(a.k,b.k))h=a.k;else{d=c?a.k.ii(b.k):a.k.hi(b.k);h=d}g=a.b.c||b.b.c;return uic(Kic(Eic(Bic(new Lic(a.A),e),f,g),h))}function Zib(a,b,c,d){var e,f,g,h,i;h=c.c?c.c.i:null;g=C3b(new J9b((Afc(),tdc)),new J9b(tdc),h.Sh(false));F9b(g,c);p8b(d,g,c);Wib(a,
b,g,d);i=Sib(a,h.Wh());for(f=v8b(c.c).Vd();f.Id();){e=f.Jd();qGc(a.b,(e.c?e.c.i:null).Wh(),new Mib(i+"."+e.c.Wh(),e))}e9b(d,c);Vob(b)}function jPb(a,b){var c,d;if(!JOb(a,b,(NPb(),LPb)))return false;d=(Pd(b.n==(Afc(),Ycc),iSc,b),C8b(b)-1);for(c=0;c<d;c++)if(!gPb(a,(Pd(b.n==Ycc,iSc,b),B8b(b,c+1)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,["union type"])),a.b.ug(),a.d,a.c);return false}return true}function $nc(a,b,c){var d,e,f,g,h,i,j;Sd(b);Sd(c);Kd(c.Yd()<=b.Yd());this.a=a;this.c=b;this.d=c;g=new goc(a,
this);f=this.d.Yd();e=this.c.Yd();h=zE(cV,xPc,23,e,0,1);for(d=0;d<e;d++)if(d<f){i=this.c.ce(d);g.a=i;j=this.d.ce(d);h[d]=j.Ni(g)}else h[d]=a.u[51];this.b=h}function Hjc(a,b,c){var d;if(!!a.i&&a.i.n==(Afc(),bdc)){d=b.Qi();!!d&&(Xd(!(!!a.g||!a.u)),a.p=d)}if(b.Xi()!=null||a.q||!!b.Ui()){if(!!a.g&&(a.oi()||a.f==(dkc(),bkc))&&Rfc(b,(ae(a.oi()||a.f==(dkc(),bkc),lRc,a),cgc(a.k))))return;b=new Uic(a.A,a.Xi()+fQc,b)}Gjc(a,b,c)}function vLb(a,b){var c,d,e,f,g;gLb(a,b,(IRb(),UQb));g=LLb(a,b.b,false);c=dKb(a.a,
(Afc(),vdc));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);for(e=b.a.Vd();e.Id();){d=e.Jd();f=yKb(a.a,d);if(E8b(f,(Hbc(),kbc))!=0){e9b(f,f.c?f.c.i:null);c9b(f,kbc,0)}q8b(c,f)}return fKb(a.a,udc,g,c)}function n8b(){n8b=JZ;Hbc();_7b=abc;i8b=ubc;g8b=sbc;a8b=dbc;R7b=Rac;W7b=Wac;j8b=xbc;k8b=zbc;X7b=Xac;m8b=Gbc;U7b=Uac;T7b=Tac;b8b=ebc;N7b=Jac;M7b=Iac;O7b=Kac;P7b=Lac;f8b=rbc;Y7b=Yac;$7b=_ac;Q7b=Mac;L7b=Dac;h8b=tbc;Z7b=Zac;V7b=Vac;c8b=fbc;l8b=Bbc;e8b=obc;d8b=kbc;S7b=Sac}function LKc(a,b){var c,d,e,f;a=a;c=new ttc;f=0;
d=0;while(d<b.length){e=a.indexOf("%s",f);if(e==-1)break;ptc(c,a.substr(f,e-f));otc(c,b[d++]);f=e+2}ptc(c,a.substr(f));if(d<b.length){c.a+=" [";otc(c,b[d++]);while(d<b.length){c.a+=iLc;otc(c,b[d++])}c.a+="]"}return c.a}function Jhb(a,b,c){var d,e,f;Xd(c.n==(Afc(),rec));Bhb(a,null,b);f=Ohb(a);jDc(a.f,c.Wh())&&ghb(a.r,F9b(r3b(c.Sh(false),ufc),c));d=new fxc;!!f&&Ywc(d,mib(f,c));e=Chb(a,c,"enterCatchBlock",exc(d,zE(HU,IMc,7,0,0,1)));r9b(c,e.d);eib(a,F9b(t3b(F9b(Yjb(h3b(c,e),e.d),c)),c))}function PE(a){var b,
c,d;c=a.l;if((c&c-1)!=0)return-1;d=a.m;if((d&d-1)!=0)return-1;b=a.h;if((b&b-1)!=0)return-1;if(b==0&&d==0&&c==0)return-1;if(b==0&&d==0&&c!=0)return Urc(c);if(b==0&&d!=0&&c==0)return Urc(d)+22;if(b!=0&&d==0&&c==0)return Urc(b)+44;return-1}function r_(a,b,c){var d,e,f,g,h,i;F_(a,(IRb(),MQb),b);b0((Afc(),bdc),b);g=Cfc(b.n);g!=-1&&(e=C8b(b),g!=e&&D0(QMc+g+RMc+e,b));h=b.c;h.n==tdc?(f=C8b(h),0!=f&&D0(OMc+f,h)):W_(h);i=h.f;if(i.n==tdc){d=C8b(i);0!=d&&D0(OMc+d,i)}else{F_(a,NQb,b);E_(a,i)}t_(a,b.c?b.c.i:null,
c)}function o0(a,b){var c,d,e,f;b0((Afc(),Xec),b);f=(d=H8b(b,(Hbc(),ybc)),!d?null:d.ug());!f&&D0("Missing 'source name' annotation.",b);e=H8b(b,cbc);!e&&D0("Missing 'input id' annotation.",b);a.b=b;if(!!b.c&&b.c.n==pec){c=C8b(b);1!=c&&D0(UMc+c,b);V_(a,b.c)}else r0(a,b.c)}function pq(a,b){var c,d,e,f,g;e=b.a&a.f;f=null;for(d=a.b[e];true;d=d.b){if(d==b){!f?a.b[e]=b.b:f.b=b.b;break}f=d}g=b.f&a.f;f=null;for(c=a.c[g];true;c=c.d){if(c==b){!f?a.c[g]=b.d:f.d=b.d;break}f=c}!b.e?a.a=b.c:b.e.c=b.c;!b.c?a.e=
b.e:b.c.e=b.e;--a.i;++a.g}function fVb(a){var b,c;c=pUb(a,0);c.a.Yd()!=1&&TVb(a,c,"Setter must have exactly 1 parameter, found %d",CE(xE(iW,1),mLc,1,5,[Yrc(c.a.Yd())]));if(c.a.Yd()>=1){b=c.a.ce(0);b.p==(n1b(),Q0b)&&TVb(a,b,"Setter must not have a rest parameter",CE(xE(iW,1),mLc,1,5,[]))}return c}function S5b(a,b,c,d,e){if(b>d)throw gZ(new Irc("Recorded bad position information\nstart-line: "+b+gMc+"end-line: "+d));else if(b==d&&c>=e)throw gZ(new Irc("Recorded bad position information\nline: "+b+gMc+
"start-char: "+c+gMc+"end-char: "+e));a.f=b;a.e=c;a.c=d;a.b=e}function Kkc(){return CE(xE($U,1),iMc,46,15,[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77])}function UGb(){UGb=JZ;SGb=new Mcb("JSC_DUPLICATE_IMPORT",(E2(),D2),new Rtc('The module "{0}" has already been imported at {1}, {2}.'));TGb=new Mcb("JSC_DEFAULT_EXPORT",
D2,new Rtc("Do not use the default export. There is no way to force consistent naming when imported."))}function d5(a,b,c,d,e,f,g){var h,i,j;Xd(!!c.cd);j=b==0?new u5(f,c.rc,c.Vb,c.cd):new F5(c.Vb,c.cd);h=b==2?new $Bb(j,g.a.c,g.a.e):new M4(j,g.a.c);d&&L3(h.c,"/** @fileoverview @typeSummary */\n");e&&(L3(h.c,"'use strict';"),h.c.Ug());h.fh(a,(_4(),W4));j.Sg();i=j.j.a;return i}function qlb(a,b){var c,d,e;if(!b)return Rlb(),Plb;switch(b.n.f){case 96:return Rlb(),Llb;case 43:return Rlb(),Olb;case 65:return Rlb(),
Mlb;case 61:return qlb(a,b.c?b.c.i:null);case 60:c=b.c.f;d=qlb(a,c);if(d!=(Rlb(),Plb))return d;e=c.f;return qlb(a,e)}return Rlb(),Plb}function hEb(a,b,c){var d,e,f,g,h;d=gEb(a,b,c);f=d;ZEb();!Esc(d.substr(0,"/".length),"/")&&!(Esc(d.substr(0,rOc.length),rOc)||Esc(d.substr(0,nRc.length),nRc))&&(f="/"+d);if(a.e.Sd(f))return d;for(h=a.f.Vd();h.Id();){g=h.Jd();e=g+(""+f);if(a.e.Sd(e))return d}return null}function xHb(){xHb=JZ;vHb=new Mcb("JSC_PRIMITIVE_OBJECT",(E2(),D2),new Rtc("Explicit creation of a {0} object."));
wHb=new Mcb("JSC_PRIMITIVE_OBJECT_DECLARATION",D2,new Rtc("Declaration of {0} object instead of primitive type."));bn();pp(CE(xE(iW,1),mLc,1,5,[lPc,oPc,oMc]))}function gNb(a,b){var c,d;c=false;if(b==(fOb(),QNb)){b=!a.o?mOb(a.j):GMb(a);if(b==aOb){a.o=b;return zNb(a,(Afc(),sdc),new J9b(tdc))}c=true}d=lNb(a,b);if(d){xNb(a);if(c)d=zNb(a,(Afc(),sdc),d);else if(OMb(a,UNb)){!a.o?mOb(a.j):GMb(a);xNb(a);d=zNb(a,(Afc(),ydc),d)}}return d}function K_(a,b){var c,d,e;F_(a,(IRb(),iRb),b);b0((Afc(),Vdc),b);d=Cfc(b.n);
d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b));b.c.n==rec?W_(b.c):b0(tdc,b.c);e=b.c.f;switch(e.n.f){case 106:M_(e);break;case 108:c0(e)&&e.Wh().length==0&&D0(WMc,e);break;default:b0(tdc,e)}s0(B8b(b,2))}function lMb(a,b){var c,d,e,f;switch(b.a.f){case 30:bKb(a.a,b,(IRb(),RQb));e=(Afc(),gdc);break;case 38:bKb(a.a,b,(IRb(),fRb));e=(Afc(),jec);break;case 25:e=(Afc(),ufc);break;default:throw gZ(new Hrc);}f=dKb(a.a,e);for(d=b.b.Vd();d.Id();){c=d.Jd();q8b(f,AKb(a.a,c))}return f}function GVb(b){var c;if(b.b.d&&
AVb(b,(AZb(),GYb))||AVb(b,(AZb(),EYb))){c=new ZVb(b.b,new S1b,b.g.i,uWb(b.g),uwc(b.e).b);try{tTb(c);pUb(c,2);AVb(c,(AZb(),NXb))&&(iTb(c,NXb),nVb(c));return AVb(c,zXb)}catch(a){a=fZ(a);if(pF(a,425))return false;else throw gZ(a);}}return false}function chc(a,b,c,d){var e,f,g,h;g=a.a.c;e=b.a.c;while(!!g&&!!e){h=g.d;f=e.d;if(h){if(!!f&&!Qfc(h,f,c,d))return false}else if(f)return false;if(E8b(g,(Hbc(),qbc))!=0!=(E8b(e,qbc)!=0))return false;if(E8b(g,Ebc)!=0!=(E8b(e,Ebc)!=0))return false;g=g.f;e=e.f}return g==
e}function sjc(a){var b,c,d,e,f,g,h;e=a.B;g=(ae(a.oi()||a.f==(dkc(),bkc),lRc,a),cgc(a.k)).ki();if(e==g)return Bn(),Bn(),An;d=(Bn(),new Zr);f=(h=g.c.wf(g.d.Yd(),g.c.Yd()),mp(h));for(c=e.c.wf(e.d.Yd(),e.c.Yd()).Vd();c.Id();){b=c.Jd();f.Sd(b)||(Ywc(d.a,Sd(b)),d)}return In(d.a)}function lbb(a,b){var c,d,e,f,g,h,i;j:for(i=b.b.Vd();i.Id();){h=i.Jd();g=(Wbb(),gFc(Vbb,h,new ecb),Xtc(Vbb,h));for(f=(d=(new Yvc(a.c.a)).a.He().b.vj(),new ewc(d));f.a.Id();){e=(c=f.a.Jd(),c.Ve());if(e.th(g))continue j;else if(e.uh(g))return false}return false}return true}
function oUb(a,b,c){var d,e,f;!c&&(c=new s_b(pTb(a,DWb(a.g,0).d.b)));iTb(a,(AZb(),ZYb));AVb(a,ZYb)?e=new s_b(pTb(a,DWb(a.g,0).d.b)):e=xTb(a,1);iTb(a,ZYb);AVb(a,LXb)?f=new s_b(pTb(a,DWb(a.g,0).d.b)):f=xTb(a,1);iTb(a,LXb);d=hVb(a);return new F$b(new Z1b(b,a.f),c,e,f,d)}function wmb(){wmb=JZ;vmb=new Mcb("JSC_J2CL_REFERENCE_EQUALITY",(E2(),D2),new Rtc("Reference equality may not be used with the specified type: {0}"));oo();new kz(CE(xE(QX,1),PLc,50,0,[(el(mQc,nQc),new Wq(mQc,nQc)),(el(oQc,pQc),new Wq(oQc,
pQc)),(el(qQc,rQc),new Wq(qQc,rQc))]))}function XOb(a,b){if(!JOb(a,b,(NPb(),BPb)))return false;if((Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)).n!=bfc){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,[tPc])),a.b.ug(),a.d,a.c);mPb(a,BPb.d);return false}if(!gPb(a,(Pd(b.n==Ycc,iSc,b),B8b(b,2)))){mPb(a,BPb.d);return false}return true}function Prb(a,b){var c,d,e,f;for(c=b.c;c;c=f){f=c.f;ppb();if(!!c&&(c.n==(Afc(),ufc)||c.n==jec||c.n==gdc)){if(a.a&&!c.c)throw gZ(new Irc("Empty VAR node."));while(c.c!=(c.c?c.c.i:null)){d=
c.c;e9b(c,d);e=F9b(new L9b(c.n,d),b);p8b(b,e,c);Nrb(a,"VAR with multiple children",b)}}}}function TKb(a,b,c,d,e){var j;RJb();var f,g,h,i;h=new IKb(c,b,d,e,a.a);i=iLb(h.t,a);T9b(i.k)==-1&&vKb(i,a.o.b,a.o.a);if(a.a)for(g=a.a.Vd();g.Id();){f=g.Jd();(f.b==(e$b(),b$b)||f.b==a$b)&&!kDc(h.k,f)&&(j=TJb(h,f),jDc(h.k,f),ZJb(h,j),undefined)}rKb(h,i);CKb(h,i);h.o=i;return h}function UKb(a){RJb();switch(a.f){case 76:return Afc(),zec;case 77:return Afc(),Scc;case 63:return Afc(),Oec;case 64:return Afc(),wec;case 9:return Afc(),
ndc;case 24:return Afc(),pfc;case 26:return Afc(),vfc;default:throw gZ(new Irc(!a?jLc:a.a==null?(OSb(),Po(pSb,a)).c:a.a));}}function VE(a){var b,c,d,e,f;if(isNaN(a))return iF(),hF;if(a<-9223372036854775808)return iF(),fF;if(a>=0x7fffffffffffffff)return iF(),eF;e=false;if(a<0){e=true;a=-a}d=0;if(a>=wMc){d=vF(a/wMc);a-=d*wMc}c=0;if(a>=vMc){c=vF(a/vMc);a-=c*vMc}b=vF(a);f=HE(b,c,d);e&&NE(f);return f}function kjb(a,b){var c,d,e,f;Kd(b.n==(Afc(),zcc));e=hjb(a,b);e.a[0].n==zcc?c=axc(e,0):c=r9b(f3b(CE(xE(HU,
1),IMc,7,0,[])),a.a);if(e.a.length==0)f=c;else{d=r9b(x3b(c,(n8b(),new Wbc(bfc,VPc))),a.d);f=l3b(d,exc(e,zE(HU,IMc,7,0,0,1)))}I9b(f,b);r9b(f,a.a);j9b(b.g,b,f);w7(a.c,f)}function oLb(a,b){var c,d,e,f;f=null;c=null;e=null;while(b){(b.b.e==(AZb(),dZb)||b.b.e==eZb)&&bKb(a.a,b,(IRb(),WQb));e=c;c=eKb(a.a,RKb(b.b.e),yKb(a.a,b.c));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);!!e&&r8b(e,c);if(pF(b.a,98))b=b.a;else{d=yKb(a.a,b.a);r8b(c,d);b=null}!f&&(f=c)}return f}function vlc(a,b){var c,d,e,f,g,h,i,j;h=false;j=new fxc;
for(f=(Yoc(new opc,b.b)&&Voc(b),b.a).Vd();f.Id();){e=f.Jd();i=e.Ni(a);i!=e&&(h=true);j.a[j.a.length]=i}if(h){g=new $pc(a.e,false);for(d=new wxc(j);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);Upc(g,c)}return Vpc(g)}return b}function _4(){_4=JZ;$4=new a5("STATEMENT",0);U4=new a5("BEFORE_DANGLING_ELSE",1);Z4=new a5("START_OF_EXPR",2);V4=new b5("IN_FOR_INIT_CLAUSE",3,true,false);X4=new b5("START_OF_ARROW_FN_BODY",4,false,true);Y4=new b5("START_OF_ARROW_FN_IN_FOR_INIT",5,true,true);W4=new a5("OTHER",6)}
function c7(a){var b,c,d,e,f,g;g=(a.G.pd!=(Xab(),Uab)&&!!a.O&&wsb(a.O,iOc,true),new hyb);try{b=new _7;if(a.v){c=0;if(t9(a.G))for(f=a.o.c;f;f=f.f)D7(a,b,c++,f);for(e=a.v.c;e;e=e.f)D7(a,b,c++,e)}return b.c.a}finally{d=vZ(mZ(Date.now()),g.a);a.G.pd!=Uab&&!!a.O&&xsb(a.O,iOc,d)}}function cXb(a){var b,c;c=new rXb(null,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));while(xWb(a,a.f))switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 96:return c;case 92:b=dXb(a);!!b&&c.a==null&&(c=b);break;case 36:if((xWb(a,a.f+1)?zsc(a.b,
a.f+1):0)==123)return c;default:yWb(a)}return c}function XVb(a,b){var c;switch(b.p.f){case 62:c=b;break;case 26:c=new G$b(b.o,(Bn(),new Wz(Sd(b))));break;case 48:case 56:a.f=b.o.b;NWb(a.g,a.f.c);c=pUb(a,0);break;default:TVb(a,b,"invalid arrow function parameters",CE(xE(iW,1),mLc,1,5,[]));c=new G$b(b.o,(Bn(),Bn(),An))}return c}function mLb(a,b){var c,d,e,f,g;g=dKb(a.a,(Afc(),Xec));for(d=b.b.Vd();d.Id();){c=d.Jd();q8b(g,yKb(a.a,c))}hLb(g);e=$Kb(g);if(e||lQb(a.a.e,(IRb(),iRb))){f=dKb(a.a,pec);T9b(f.k)==
-1&&vKb(f,b.o.b,b.o.a);t8b(f,f9b(g));q8b(g,f);e?b9b(g,(n8b(),Z7b),true):b9b(g,(n8b(),S7b),true)}return g}function uUb(a,b){var c,d,e,f;oTb(a,nNc);if(KVb(a,0)){e=lTb(a);iTb(a,(AZb(),GYb));iTb(a,LXb);f=sTb(a);c=qUb(a);RVb(a,(IRb(),aRb));return new b_b(pTb(a,b.d),e,b.c,f,c)}else{d=_Tb(a);iTb(a,(AZb(),GYb));iTb(a,LXb);sTb(a);c=qUb(a);RVb(a,(IRb(),aRb));return new l$b(pTb(a,b.d),d,b.c,c)}}function OUb(a){var b,c,d,e;if(AVb(a,(AZb(),yYb)))if(zVb(a,1,MYb))return e=DWb(a.g,0).d.b,iTb(a,yYb),iTb(a,MYb),oTb(a,
"target"),new r_b(new Z1b(e,a.f));else{d=DWb(a.g,0).d.b;iTb(a,yYb);c=OUb(a);b=null;AVb(a,GYb)&&(b=FTb(a));return new q_b(new Z1b(d,a.f),c,b)}else return JUb(a)}function vKc(a,b,c,d,e){var f,g,h,i,j;tKc(d+FB(c,c.Yf()),e);uKc(b,xKc(c));f=c.f;!!f&&vKc(a,b,f,"Caused by: ",false);for(h=(c.j==null&&(c.j=zE(oW,mLc,36,0,0,1)),c.j),i=0,j=h.length;i<j;++i){g=h[i];vKc(a,b,g,"Suppressed: ",false)}console.groupEnd!=null&&console.groupEnd.call(console)}function Jbc(){Hbc();return CE(xE(BU,1),sLc,33,0,[mbc,Ebc,
abc,ubc,qbc,Abc,Eac,sbc,wbc,dbc,jbc,Qac,Rac,Wac,ybc,cbc,xbc,bbc,Hac,vbc,zbc,Xac,Fac,Gac,Gbc,Uac,Tac,ebc,gbc,hbc,Jac,Iac,Kac,Lac,Nac,Dbc,rbc,Yac,_ac,Mac,Dac,pbc,tbc,Zac,$ac,Vac,ibc,Fbc,fbc,Bbc,Pac,nbc,lbc,obc,kbc,Sac,Cbc,Oac])}function cB(){cB=JZ;bB=new zB("base64()",bMc,_qc(61));new zB("base64Url()","ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_",_qc(61));new rB("base32()","ABCDEFGHIJKLMNOPQRSTUVWXYZ234567",_qc(61));new rB("base32Hex()","0123456789ABCDEFGHIJKLMNOPQRSTUV",_qc(61));
new wB}function yhb(a,b){var c,d,e,f,g;if(E8b(b,(Hbc(),gbc))==0)return b;c=new pib(a.a);e=(g=new zib,epb(a.f.b,b,g),Sd(g.a),g.a);d=khb(a,jhb(a,g9b(e)));E8b(e,Gbc)!=0?iib(a.a,d,c,e):hib(a.a,d,c,e);cib(a.a,c);f=jib(a.a,e);if(e==b)return f;j9b(e.g,e,f);while(f!=b){f=f.g;c9b(f,gbc,0)}return b}function uEb(a,b,c,d,e){tEb();var f,g;kEb.call(this,a,b,c,d);g=DJc(FJc(new KJc(null,po(e).Zd()),new BEb),Ht(new sBc(new SBc(new ABc(new DEb)),new wBc((HBc(),HBc(),FBc)))));this.b=(bn(),f=g,mp(f));this.a=DJc(IJc(FJc(new KJc(null,
this.b.Zd()),new xEb)),new $Ic(new dJc,new bJc,new _Ic))}function cLb(a,b){a.a.e=oQb(a.a.e,(IRb(),aRb));if(a.a.a.d==(zJb(),pJb)){a.a.d.Ah("getters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.",a.a.q,(RJb(),b.o.b.b+1),0);return true}return false}function dLb(a,b){a.a.e=oQb(a.a.e,(IRb(),yRb));if(a.a.a.d==(zJb(),pJb)){a.a.d.Ah("setters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.",
a.a.q,(RJb(),b.o.b.b+1),0);return true}return false}function Uoc(a,b){var c,d,e,f,g,h,i;d=new $pc(a.A,false);for(f=0;f<a.b.Yd();f++){c=a.b.ce(f);c.zi(b)&&Upc(d,c)}if(b.Mi()){i=b.Mi().b;for(e=0;e<i.Yd();e++){g=i.ce(e);g.zi(a)&&Upc(d,g)}}else b.zi(a)&&Upc(d,b);h=Vpc(d);return h.ti()?Xoc(new wpc,a.b)&&b.xi()&&!b.ti()?a.A.u[59]:a.A.u[58]:h}function sf(b){var c,d,e;try{return b==null?jLc:NZ(b)}catch(a){a=fZ(a);if(pF(a,38)){c=a;e=frc(Bb(b))+"@"+(d=DKc(b)>>>0,d.toString(16));LIc(RIc("com.google.common.base.Strings"),
(bIc(),aIc),"Exception during lenientFormat for "+e,c);return"<"+e+" threw "+frc(c.Fj)+">"}else throw gZ(a);}}function vD(a,b){var c;if(a>=kMc&&a<=lMc){c=(EKc(a>=0&&a<=lMc),a>=kMc?CE(xE(xF,1),eLc,46,15,[55296+(a-kMc>>10&mMc)&dLc,56320+(a-kMc&mMc)&dLc]):CE(xE(xF,1),eLc,46,15,[a&dLc]));vD(c[0],b);vD(c[1],b);return}htc(htc(htc(htc((b.a+="\\u",b),tD[a>>>12&15]),tD[a>>>8&15]),tD[a>>>4&15]),tD[a&15])}function yqb(a){var b,c;c=a.g;b=!a.g?null:a.g.g;switch(c.n.f){case 93:return true;case 91:return b.n==(Afc(),
Fec);case 94:return a.n!=(Afc(),cfc);case 116:if(a==c.c.f)return yqb(c);return false;case 114:return yqb(c);case 121:if(a==c.c)return yqb(c);return false;default:return false}}function zrb(a,b,c){var d,e,f,g,h;epb(a.b,c,new Yrb(a));fpb(a.b,new Qrb(a.b,a.a),b,c);f=new asb;g=new Bjb(a.b,new Erb(a));h=new dpb(a.b,f,g);cpb(h,b,c);e=new gob;fpb(a.b,e,b,c);Urb(new Vrb(a.b,a.a),b,c);d=new Grb;epb(a.b,c,d);d.a.a.Yd()==0||epb(a.b,c,new $rb(a,d.a));SZ(a.b.T)||(a.b.T=1)}function t2b(a){var b,c,d;if(!pF(a.a,
221))return null;c=a.a;b=Erc(c);d=null;if(isNaN(b))d="NaN";else if(b==Infinity)a.b.d?d="+Infinity":a.b.j?d=" Infinity":d=xQc;else if(b==-Infinity)a.b.g?d="(Infinity)":d="-Infinity";else return null;a.b.n=-1;a.b.k=false;return j2b(a,d,0)}function w4(a,b,c,d,e){var f,g;f=e==(_4(),Z4);f&&L3(a.c,"(");r4(a,b.n==(Afc(),Jdc)&&E8b(b,(Hbc(),Gac))!=0?_Nc:ZKc);if(E8b(b,(Hbc(),Xac))!=0){L3(a.c,"*");c.Wh().length==0||a.c.$g()}a.fh(c,W4);g=H8b(c,(n8b(),Y7b));!!g&&a.fh(g,W4);a.fh(c.f,W4);G4(a,b);a.fh(d,W4);a.c.Tg(e==
$4);f&&L3(a.c,")")}function tpb(a,b,c){ppb();var d;switch(a.n.f){case 103:case 28:case 23:return true;case 29:return!fqb(a,c)&&!b.Sd(a.Wh());case 26:case 27:return true;case 65:Yd(!(a.n==(Afc(),Jdc)&&iqb(a.g)&&a.n==Jdc&&Gqb(a.c)),a);return false}for(d=a.c;d;d=d.f)if(tpb(d,b,c))return true;return false}function YOb(a,b){if(!JOb(a,b,(NPb(),CPb)))return false;if((Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)).n!=bfc){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,["property name"])),a.b.ug(),a.d,a.c);mPb(a,CPb.d);return false}if(!gPb(a,
(Pd(b.n==Ycc,iSc,b),B8b(b,2)))){mPb(a,CPb.d);return false}return true}function pp(a){bn();var b,c,d,e,f,g;g=new YEc;Dyc(g,a);for(c=(f=(new Wuc(g.a)).a.He().Vd(),new avc(f));c.a.Id();){b=(d=c.a.Jd(),d.Ve());Sd(b)}switch(g.a.Yd()){case 0:return mz(),lz;case 1:return new Zz((e=(new Wuc(g.a)).a.He().Vd(),d=(new avc(e)).a.Jd(),d.Ve()));default:return new nz(g)}}function w9(a){var b,c,d,e,f;d=(oo(),new hs);for(c=new yuc((new puc(a)).a);c.b;){b=wuc(c);e=b.Ve();f=b.We();if(qF(f))es(d,e,(ppb(),f?new J9b((Afc(),
nfc)):new J9b((Afc(),Edc))));else if(pF(f,132))es(d,e,O3b(f.a));else if(rF(f))es(d,e,O3b(f));else{Xd(tF(f));es(d,e,V3b(f))}}return Co(d.b)}function hqb(a,b){ppb();switch(a.n.f){case 71:return a.c==b;case 44:return a.c==b||(a.c?a.c.i:null)==b;case 72:case 73:case 101:case 102:case 70:case 83:case 77:case 78:return(a.c?a.c.i:null)==b;case 66:case 67:case 68:return a.c!=b;case 69:return true;default:Yd(gqb(a),a);return false}}function wGb(a){v6();this.a=a;new fDc;this.s=new tEc;this.u=new RHc;this.M=
new RHc;this.t=new RHc;new RHc;this.e=new z3;this.q=new mDc;this.F=(kwb(),new qwb(this));oo();this.c=new ayb;this.f=new ayb;this.R=new X7;this.L=new oub;this.d=new fxc;new tEc;new YEc;w6(this,this.L);this.D=new fDc}function Cd(a){var b,c,d,e,f,g,h;f=a.d;d="";c=itc(ptc(new ttc,a.a),123);for(h=a.b.b;h;h=h.b){g=h.c;if(!f||g!=null){c.a+=d;d=iLc;h.a!=null&&itc(ptc(c,h.a),61);if(g!=null&&(Bb(g).i&4)!=0){e=CE(xE(iW,1),mLc,1,5,[g]);b=Gxc(e,new mDc);ntc(c,b,1,b.length-1)}else c.a+=""+g}}return(c.a+="}",c).a}
function Ltb(a,b){Itb();var c;if(a9b(b,IQc,IQc.length)||b.n==(Afc(),Odc)&&_8b(b.c,mNc)&&b.c.f.n==bfc&&Esc(b.c.f.Wh(),"exports")){c=i$(Kob(a),mNc);if(!c||!c.a||B8(c.a))return true}else if(b.n==(Afc(),rec)&&Esc("exports",b.Wh())){c=i$(Kob(a),b.Wh());if(!c||!c.d.b)return true}return false}function dFb(a,b){ZEb();var c,d,e,f;e=a;!Esc(e.substr(0,"/".length),"/")&&!(Esc(e.substr(0,rOc.length),rOc)||Esc(e.substr(0,nRc.length),nRc))&&(e="/"+e);for(d=b.Vd();d.Id();){c=d.Jd();if(Esc(e.substr(0,c.length),c)){f=
Usc(e,c.length);if(Esc(f.substr(0,1),"/"))return f.substr(1)}}return a}function CUb(a){var b,c,d,e,f,g;e=DWb(a.g,0).d.b;iTb(a,(AZb(),oYb));d=jTb(a);c=tTb(a);f=(Bn(),new Zr);if(AVb(a,cYb)){iTb(a,cYb);g=nVb(a);Ywc(f.a,Sd(g));while(AVb(a,OXb)){iTb(a,OXb);g=nVb(a);!!g&&(Ywc(f.a,Sd(g)),f)}}iTb(a,FYb);b=EUb(a);iTb(a,KXb);return new h_b(new Z1b(e,a.f),d,c,In(f.a),b)}function D4(a){var b,c,d;d=new stc;for(c=0;c<a.length;c++){b=a.charCodeAt(c);switch(b){case 8:case 12:case 10:case 13:case 9:case 92:case 34:case 39:case 36:case 96:case 8232:case 8233:d.a+=
String.fromCharCode(b);break;default:b>31&&b<127?(d.a+=String.fromCharCode(b),d):wD(d,b)}}return d.a}function Akb(a,b){var c,d,e,f;d=(b.c?b.c.i:null).Wh();e=Esc(d.substr(0,5),"goog:");if(e)return d.substr(5);else{f=oFb(z8((!a.d&&!!a.i&&(a.d=L6(a.c,a.i)),a.d)),d,(c=H8b(b,(Hbc(),ybc)),!c?null:c.ug()),T9b(b.k),S9b(b.k));!f&&(f=pFb(z8((!a.d&&!!a.i&&(a.d=L6(a.c,a.i)),a.d)),d));return UFb(f.a)}}function LRb(){IRb();return CE(xE(FR,1),sLc,24,0,[VQb,aRb,eRb,yRb,ARb,DRb,FQb,GQb,JQb,KQb,MQb,NQb,OQb,PQb,RQb,
SQb,EQb,lRb,XQb,ZQb,$Qb,fRb,gRb,kRb,oRb,sRb,tRb,xRb,zRb,BRb,CRb,iRb,WQb,HQb,ERb,mRb,nRb,IQb,YQb,rRb,uRb,vRb,wRb,HRb,pRb,TQb,CQb,DQb,LQb,QQb,UQb,_Qb,bRb,cRb,dRb,hRb,jRb,qRb,FRb,GRb])}function Ijc(a,b,c){var d,e,f,g,h;f=!a.g?null:a.g.e;g=!!f;a.g=new Xmc(aNc,b,true,!c?a.i:c);b.aj(a);!!f&&f.aj(null);if(a.oi()||a.f==(dkc(),bkc)){h=Bjc(a);if(h){!h.j&&(h.j=new fxc);Ywc(h.j,a)}if(a.f==(dkc(),bkc))for(e=a.c.Vd();e.Id();){d=e.Jd();!!d.Qi()&&ljc(d.Qi(),a)}}g&&pjc(a);return true}function yVb(a,b){var c,d,e,f;
f=DWb(a.g,0).d.b;iTb(a,(AZb(),zZb));d=false;c=null;e=DWb(a.g,0).d.b.b>a.f.b;if(!(e||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb))){d=!!mTb(a,bZb);FVb(a)?c=KTb(a,b):d&&VVb(a,"yield* requires an expression",CE(xE(iW,1),mLc,1,5,[]))}return new R1b(new Z1b(f,a.f),d,c)}function m6(){m6=JZ;new Mcb("JSC_UNSAFE_NAMESPACE",(E2(),D2),new Rtc("incomplete alias created for namespace {0}"));l6=new Mcb("JSC_NAMESPACE_REDEFINED",D2,new Rtc("namespace {0} should not be redefined"));new Mcb("JSC_UNSAFE_THIS",D2,new Rtc("dangerous use of ''this'' in static method {0}"))}
function Oib(a){var b,c,d;if(a.b.c!=0){b=P3b(CE(xE(HU,1),IMc,7,0,[]));for(d=(new VGc(a.b)).b.vj();d.Id();){c=d.Jd();Nib(a,b,c.Ve(),c.We())}r8b(a.g,I9b(t3b(l3b(Wqb(a.a,"Object.defineProperties"),CE(xE(HU,1),IMc,7,0,[(ae(Hsc(SPc,_sc(46))==-1,HMc,SPc),n8b(),new Wbc((Afc(),rec),SPc)),b]))),a.g))}}function uic(a){var b,c,d,e,f;d=(a.e&4)!=0;e=(a.e&2)!=0;f=(a.e&8)!=0;c=!a.a.b.b.Ud();c&&(a.n=a.f.u[51]);b=new Ljc(a.f,a.c,a.j,new hhc(a.f,a.d,a.g,d),a.n,a.k,a.b,e);!!a.i&&Hjc(b,a.i,null);f&&(b.b.b=(ae(b.f==(dkc(),
akc)||b.f==bkc,lRc,b),cgc(b.k)));c&&Fjc(b,new hkc(a.f,b,e,Ync(a.k,a.a)));return b}function G7(a){var b,c,d,e;e=(a.G.pd!=(Xab(),Uab)&&!!a.O&&wsb(a.O,lOc,true),new hyb);try{for(c=(!a.I&&(a.I=new CGb(a.a)),new wxc(BGb(a.I)));c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);if(a.g.a.d!=0)return;b.ih(a).wg(a.o,a.v)}}finally{d=vZ(mZ(Date.now()),e.a);a.G.pd!=Uab&&!!a.O&&xsb(a.O,lOc,d)}}function VIb(){TIb();return CE(xE(kR,1),sLc,31,0,[oIb,LHb,MHb,NHb,OHb,PHb,QHb,RHb,DIb,SHb,THb,UHb,VHb,WHb,XHb,$Hb,_Hb,YHb,ZHb,
aIb,bIb,cIb,dIb,eIb,fIb,gIb,hIb,iIb,jIb,kIb,lIb,mIb,nIb,qIb,rIb,sIb,tIb,pIb,uIb,vIb,wIb,xIb,yIb,zIb,AIb,BIb,CIb,EIb,FIb,GIb,HIb,IIb,JIb,KIb,LIb,MIb,NIb,OIb,PIb,QIb,RIb])}function zJb(){zJb=JZ;pJb=new AJb(xOc,0,(iQb(),YPb));qJb=new AJb(yOc,1,ZPb);rJb=new AJb("ECMASCRIPT6",2,_Pb);sJb=new AJb("ECMASCRIPT7",3,bQb);tJb=new AJb("ECMASCRIPT8",4,dQb);uJb=new AJb(zOc,5,VPb);vJb=new AJb(AOc,6,XPb);wJb=new AJb("ES_NEXT",7,eQb);yJb=new AJb(BOc,8,fQb);xJb=new AJb(JRc,9,gQb)}function $Ub(a){var b,c,d,e,f;e=DWb(a.g,
1).e;if(e==(AZb(),gZb)||e==DYb||e==iYb||(OSb(),OSb(),!!Po(pSb,e)))return ZTb(a,new sWb(DWb(a.g,0).d.b));else{d=DWb(a.g,0).d.b;iTb(a,bZb);c=_Tb(a);b=new T$b((Y$b(),W$b));sUb(a,b,(pWb(),nWb));f=I$b(b,new Z1b(d,a.f));return new n$b(new Z1b(d,a.f),null,c,f)}}function S6(a,b,c,d){var e,f,g,h,i,j,k;if(b==null)return null;j=OHc(a.t,b);if(!j)return null;e=Axb(j,a.g);if(!e)return null;g=bC(e,c,d+1);if(!g)return null;k=j.c.b;h=g.d;f=T7(k,h);i=Q6(a,f);if(!i&&!!h){i=null;!!i&&QHc(a.M,f,i)}return zD(AD(DD(BD(AD(CD(DD(new ED,
g.d),g.c),g.a),g.b),f),g.a-1))}function fob(a,b,c,d){var e,f,g;ppb();f=c.g;if(!!f&&c.n==(Afc(),rec)&&(f.n==(Afc(),Bdc)&&c!=f.c||f.n==Wdc&&c!=(f.c?f.c.i:null)))return;e=eob(a,c.Wh());if(e!=null){g=twc(a.b);g.Gh()&&h9b(c,(n8b(),a8b));c._h(e);if(a.a){Vob(b);d.n==(Afc(),Jdc)&&(d.n==Jdc&&iqb(d.g)&&d.n==Jdc&&Gqb(d.c))&&w7(b.c,d)}}}function Tpb(a){ppb();var b;b=a.g;switch(b.n.f){case 47:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 59:case 57:case 58:return a.f;case 76:case 100:case 88:return a.c?
a.c.i:null;case 95:return b.c?b.c.i:null;case 43:return a.c;case 65:case 96:return b}return null}function BOb(a){var b,c,d;c=a.d;b=a.g==(KJb(),JJb);d=null;switch(c.f){case 9:d=(iWb(),gWb);break;case 0:d=(iWb(),bWb);break;case 1:d=(iWb(),cWb);break;case 2:case 3:d=(iWb(),dWb);break;case 4:case 5:case 6:d=(iWb(),eWb);break;case 7:d=(iWb(),fWb);break;case 8:d=(iWb(),hWb)}return new aWb(Sd(d),b)}function uVb(a){var b,c,d,e,f;f=DWb(a.g,0).d.b;if(PVb(a)){e=wTb(a);d=tVb(a);return new L1b(new Z1b(f,a.f),
e,0,d)}else{b=FUb(a);if(PVb(a)&&(c=DWb(a.g,0).d.b.b>a.f.b,!(c||zVb(a,0,(AZb(),ZYb))||zVb(a,0,(AZb(),KXb))||zVb(a,0,(AZb(),XXb))))){e=wTb(a);return new L1b(new Z1b(f,a.f),e,1,b)}else return b}}function $db(a,b){var c,d;d=b.g;c=b.c.n==(Afc(),tdc);ppb();if(b.n==bdc&&iqb(b.g)&&b.n==bdc&&Gqb(b.c)||c&&d.n==rec||c&&d.n==Ccc&&V8b(d.c)&&d.g.n==Ddc)return false;if(dkb(a.c,b)==0){u7(a.b,Lmb(b,(Rjb(),Pjb),CE(xE(nW,1),uNc,2,6,["class expression that cannot be extracted"])));return false}return true}function Krb(a,
b){var c,d,e;Xd(b.g.n==(Afc(),Jdc));d=null;c=b.c;while(!!c&&(ppb(),c.n==Jdc&&iqb(c.g)&&c.n==Jdc&&Gqb(c.c))){d=c;c=c.f}while(c){e=c.f;ppb();if(c.n==Jdc&&iqb(c.g)&&c.n==Jdc&&Gqb(c.c)){e9b(b,c);d=(!d?r8b(b,c):o8b(b,c,d),c);Nrb(a,"Move function declaration not at top of function",b)}c=e}}function $fb(a,b){var c,d,e,f,g,h,i;for(i=(f=(new fvc(a.j)).a.He().Vd(),new kvc(f));i.a.Id();){g=(d=i.a.Jd(),d.We());c=_0(g,x8b(a.d,false));I9b(c,a.c);o8b(b.g,c,b);b=c}for(h=(e=(new fvc(a.b)).a.He().Vd(),new kvc(e));h.a.Id();){g=
(d=h.a.Jd(),d.We());c=_0(g,x8b(a.g,false));I9b(c,a.c);o8b(b.g,c,b);b=c}}function Zob(a,b,c){var d;d=b.n;if(d==(Afc(),Xec)){Pob(a,b,c);return}else if(d==Jdc){Oob(a,b,c);return}a.e=b;if(!a.a.Bg(a,b,c))return;d==bdc?_ob(a,b):d==cdc?apb(a,b):d==pec?(Sob(a,b),$ob(a,b),Rob(a,false),undefined):a.q&&ypb(b)?(Sob(a,b),$ob(a,b),Rob(a,false),undefined):$ob(a,b);a.e=b;a.a.Cg(a,b,c)}function VOb(a,b){var c,d,e;if(!JOb(a,b,(NPb(),JPb)))return false;e=(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1));if(e.n!=bfc){a.a.Bh(URc+
occ(kSc,CE(xE(iW,1),mLc,1,5,["native type"])),a.b.ug(),a.d,a.c);mPb(a,JPb.d);return false}d=(xMb(),c=CNb(e.Wh()),lNb(c,!c.o?mOb(c.j):GMb(c)));z8b(e);q8b(b,d);return true}function hVb(a){var b;if(zVb(a,0,(AZb(),iYb))&&Esc(DWb(a.g,0).a,GNc)&&(b=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(b||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&zVb(a,1,gYb))return NTb(a);if(zVb(a,0,gYb))return rUb(a);if(zVb(a,0,IXb))return WTb(a,false,false);if(AVb(a,sYb))return xVb(a);return lVb(a)}function C4(a,b){var c,d,e,f;e=b.Wh();
f=b.Yh()||a.j&&Efc(e)||(G7b(),!F7b.test(e))||!wqb(e);if(f){d=Q4(e);isNaN(d)?y4(a,b):a.c.Kg(d,b)}else{if(E8b(b,(Hbc(),kbc))!=0){c=b.c;if(a9b(c,e,e.length)||c.n==(Afc(),mdc)&&_8b(c.c,e)){a.fh(c,(_4(),W4));return}}L3(a.c,e)}if(b.c){L3(a.c,":");v4(a,b.c,1,(_4(),W4))}}function Hqb(a){switch(a.f){case 13:case 3:case 20:case 1:case 2:case 46:case 16:case 4:case 18:case 9:case 27:case 26:case 8:case 40:case 41:case 7:case 10:case 6:case 17:case 15:case 5:case 19:case 11:case 36:case 37:case 14:case 25:case 79:case 21:case 22:case 12:return true;
default:return false}}function igc(a){var b,c,d,e,f,g,h;if(a.si())return a.A.u[60];else if(a.Mi()){h=a.Mi();g=false;c=(Yoc(new opc,h.b)&&Voc(h),h.a);for(f=0;f<c.Yd();f++){b=c.ce(f);if(b.si()){g=true;break}}if(g){d=new $pc(a.A,false);Upc(d,a.A.u[60]);for(e=0;e<c.Yd();e++){b=c.ce(e);b.si()||Upc(d,b)}return Vpc(d)}}return a}function oGc(a,b,c,d){var e,f;if(!b)return c;else{e=a.a.lf(c.d,b.d);if(e==0){d.d=pvc(b,c.e);d.b=true;return b}f=e<0?0:1;b.a[f]=oGc(a,b.a[f],c,d);if(pGc(b.a[f]))if(pGc(b.a[1-f])){b.b=
true;b.a[0].b=false;b.a[1].b=false}else pGc(b.a[f].a[f])?b=wGc(b,1-f):pGc(b.a[f].a[1-f])&&(b=vGc(b,1-f))}return b}function Itb(){Itb=JZ;Htb=new Mcb("JSC_COMMONJS_UNKNOWN_REQUIRE_ENSURE_ERROR",(E2(),D2),new Rtc("Unrecognized require.ensure call: {0}"));Gtb=new Mcb("JSC_COMMONJS_SUSPICIOUS_EXPORTS_ASSIGNMENT",D2,new Rtc('Suspicious re-assignment of "exports" variable. Did you actually intend to export something?'))}function zhb(a,b,c){var d,e,f;this.f=a;this.b=c;this.e=b.c?b.c.i:null;d=null;if(a.g){this.g=
a.i;if(!!b.d&&!!b.d.Ii()){e=b.d.Ii();this.d=e.b.b;this.g=Fnb(this.d,a.f)}f=blc(a.f,"$jscomp.generator.Context");!f?d=a.f.u[38]:d=Ykc(a.f,pF(f,48)?f:null,CE(xE(cV,1),xPc,23,0,[this.g]))}this.a=new kib(this,d)}function ssb(a){var b,c,d,e,f;f=new fDc;for(d=new wxc(a.w);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);e=c.j;b=e==null?Hg(EDc(f.d,null)):YDc(f.e,e);if(!b){b=new Dsb(e,c.i);e==null?FDc(f.d,null,b):ZDc(f.e,e,b)}b.n=hZ(b.n,c.n);b.a=$wnd.Math.max(b.a,c.a);++b.k;b.d+=c.d;b.b+=c.b;b.e+=c.e;b.f+=c.f}a.I=
wo(f)}function Irb(a,b,c){var d,e,f,g;Xd(b.n==(Afc(),rec)||b.n==bfc||b.n==cfc||b.n==Qdc||b.n==Yec);if(a.b.T==2)return;e=Sqb(b);f=e||c.n==Pdc&&(c.c?c.c.i:null)==b;if(b.n==rec||f){d=E8b(b,(n8b(),a8b))!=0;if(!d&&eqb(H6(a.b),b)){if(a.a){g=b.Wh();throw gZ(new Irc(DQc+g+gMc+"  parent:"+E9b(b.g)));}b9b(b,a8b,true)}}}function kOb(a){var b;if(a.r!=0){++a.b;--a.r;a.a==-1&&(a.a=a.i-a.f-a.r-1);return a.q[a.r]}for(;;){if(a.i==a.j){a.a==-1&&(a.a=a.i-a.f-a.r-1);return-1}++a.b;b=zsc(a.k,a.i++);if(b<=127){if(b==10||
b==13){a.e=b;b=10}}else{Gfc();if(b>127)continue;if(uOb(b)){a.e=b;b=10}}a.a==-1&&(a.a=a.i-a.f-a.r-1);return b}}function Lyb(a,b,c,d){Fyb();var e,f,g,h,i,j,k,l,m;if(m9(a.G,c)){j=l9(a.G);for(l=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();l.Id();){k=l.Jd();i=(ppb(),Yd(k.n==(Afc(),Xec),k),H8b(k,(n8b(),V7b)));if(!!i&&!j.a.Td(i.a))for(f=d,g=0,h=f.length;g<h;++g){e=f[g];c9b(k,l8b,1);m=new dpb(a,e,new Ajb(a));Yob(m,k)}}}}function p_(a,b){var c,d,e,f,g;b0((Afc(),adc),b);g=Cfc(b.n);g!=-1&&(e=C8b(b),g!=e&&D0(QMc+
g+RMc+e,b));c=b.c;c.n==rec?W_(c):c.n==Acc?l_(a,adc,c):c.n==Fec?h0(a,adc,c):c.n==tdc?(F_(a,(IRb(),pRb),c),f=Cfc(c.n),f!=-1&&(d=C8b(c),f!=d&&D0(QMc+f+RMc+d,c))):D0("Unexpected catch binding: "+c,b);n_(a,b.c?b.c.i:null)}function S5(b){var c,d,e,f,g;if(b.n!=(Afc(),Cec))return null;g=Wpb(b);if(!pF(g,189))return null;e=g;try{f=e.a}catch(a){a=fZ(a);if(pF(a,104))return null;else throw gZ(a);}try{d=L8b(b)}catch(a$0){a$0=fZ(a$0);if(pF(a$0,40))return null;else throw gZ(a$0);}c=d+b.e;if(d<0||c>f.length)return null;
return f.substr(d,c-d)}function q7(b,c){var d,e,f,g;f=new nvb(b);for(e=new Tu(wu($t(c.a),new Xt));Ru(e);){d=Su(e);if(!Dsc(d.a.sh().b,".json"))continue;d.b=b;try{Swb(d.a.sh(),"("+d.a.sh().a+")")}catch(a){a=fZ(a);if(pF(a,104))continue;else throw gZ(a);}g=Sd(x8(d,b));D8(d,(b9(),_8));Xd(g.n==(Afc(),Xec));epb(f.a,g,f)}return wo(f.b)}function udb(a,b){var c,d,e,f,g,h,i;Ld(V8b(a),a);Ld(b.n==(Afc(),Ycc),b);d=g9b(b);Yd(d.n==Pdc,d);c=Sd(d.c.f);Yd(Esc(c.Wh(),hPc),c);i=d.c;j9b(d,i,G9b(x8b(a,false),i));f=b.c;
Yd(f.n==Aec,f);e9b(b,f);e=F9b((h=Tqb(d,CE(xE(HU,1),IMc,7,0,[])),h),b);q8b(e,F9b((g=new J9b(lfc),g),f));while(b.c)q8b(e,g9b(b));return e}function Yib(a,b,c,d){var e,f,g,h,i;e=c.c;g=null;(e.n==(Afc(),Jdc)||e.n==bdc)&&(g=(ppb(),h=Ppb(e),!h?null:I8b(h)));if(g!=null){f=z8b(e);j9b(d,c,f)}else{g="$$default";i=q3b((ae(Hsc(g,_sc(46))==-1,HMc,g),n8b(),new Wbc(rec,g)),g9b(c),gdc);j9b(d,c,I9b(i,c));qpb(b.f,(IRb(),RQb))}qGc(a.b,JNc,new Mib(g,c));Vob(b)}function _Mb(a,b){var c,d,e,f,g;d=QMb(a,(Afc(),gec));f=new mDc;
do{c=$Mb(a,b);if(!c)return null;e=c.n==cfc?c.Wh():c.c.Wh();g=f.a.Je(e,f);g==null?q8b(d,c):DMb(a,e,a.j.g,lOb(a.j));xNb(a);if(!OMb(a,(fOb(),PNb)))break;!a.o?mOb(a.j):GMb(a);xNb(a);if(OMb(a,aOb))break;b=!a.o?mOb(a.j):GMb(a)}while(true);return d}function yjc(a,b){var c,d,e;if((cnc(a.t,b)?1:0)==0){e=Esc(ePc,b);d=Esc("bind",b);if(e||d)zhc(a,b,rjc(a,e),a.i);else if(Esc(hPc,b)){c=new Qic(a.A);Mic(c,CE(xE(cV,1),xPc,23,0,[Rkc(a.A,Yfc(a.k)?a.A.u[51]:a.k),Rkc(a.A,a.A.u[38])]));zhc(a,b,uic(Hic(Dic(Bic(new Lic(a.A),
c.b),a.b.b),a.B.c)),a.i)}}return Chc(a,b)}function rf(a,b){var c,d,e,f,g;a=a;for(e=0;e<b.length;e++)b[e]=sf(b[e]);c=new ttc;g=0;d=0;while(d<b.length){f=a.indexOf("%s",g);if(f==-1)break;c.a+=""+a.substr(g,f-g);otc(c,b[d++]);g=f+2}ntc(c,a,g,a.length);if(d<b.length){c.a+=" [";otc(c,b[d++]);while(d<b.length){c.a+=iLc;otc(c,b[d++])}c.a+="]"}return c.a}function PUb(a){var b,c,d;d=DWb(a.g,0).d.b;c=(Bn(),new Zr);iTb(a,(AZb(),FYb));b=null;while(AVb(a,aZb)||KVb(a,0)||DWb(a.g,0).e==HYb||AVb(a,bZb)||QCc(MCc(TYb,
CE(xE(XR,1),sLc,14,0,[SYb,RYb])),DWb(a.g,0).e)){b=null;Xr(c,ZUb(a));b=mTb(a,OXb);if(!b)break}iTb(a,KXb);vTb(a,b);return new t_b(new Z1b(d,a.f),In(c.a))}function bD(a,b){var c,d,e,f,g,h,i,j;h=new Cwc;for(e=new wxc(a.c.e);e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);while(h.b!=h.c&&!_C(h.a[h.b],d)){g=(c=vwc(h),c);aD(a,b,g)}f=h.a[h.b];i=$C(a,d.e);j=ZC(a,d.e);Xd(a.b<i||a.a<=j);(a.b<i||a.b==i&&a.a<j)&&cD(a,b,f,i,j);kwc(h,d)}while(h.b!=h.c){d=(c=vwc(h),c);aD(a,b,d)}}function wLb(a,b){var c,d,e;bKb(a.a,b,
(IRb(),iRb));c=null;if(b.e)Xd(!b.a&&!b.b);else if(b.a){Xd(!b.b);c=yKb(a.a,b.a)}else c=nMb(a,(Afc(),Cdc),b.b);!c&&(c=dKb(a.a,(Afc(),tdc)));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);d=eKb(a.a,(Afc(),Adc),c);if(b.c){e=$Lb(a,b.c);q8b(d,e)}b9b(d,(n8b(),T7b),b.e);b9b(d,U7b,b.d);return d}function tTb(a){var b,c,d,e,f;if(!AVb(a,(AZb(),EYb)))return null;d=DWb(a.g,0).d.b;iTb(a,EYb);++a.g.j;f=new tEc;do{c=jTb(a);b=null;if(AVb(a,cYb)){iTb(a,cYb);b=nVb(a)}qEc(f,c,b);AVb(a,OXb)&&iTb(a,OXb)}while(e=DWb(a.g,0).e,iYb==e||
a.b.d&&VSb(e)||!a.b.c&&USb(e));iTb(a,JXb);--a.g.j;return new a_b(new Z1b(d,a.f),f)}function HWb(a,b){switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 101:case 69:yWb(a);switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 43:case 45:yWb(a)}gXb(xWb(a,a.f)?zsc(a.b,a.f):0)||FWb(a,"Exponent part must contain at least one digit",CE(xE(iW,1),mLc,1,5,[]));RWb(a)}return new dTb((AZb(),DYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f))}function slc(a,b){var c,d,e,f,g,h,i,j;if(!a.g||b.ui()||pF(b,138)||!b.Ji())return b;if(gzc(a.f,b))return b;fzc(a.f,
b);f=false;e=new xnc(a.e);for(i=b.Ti().Vd();i.Id();){h=i.Jd();j=(g=b.Yi(h),!g?null:g.d);d=b.Wi(h);c=d.Ni(a);d!=c&&(f=true);e.b=false;_tc(e.c,h,new ync(c,j))}hzc(a.f,b);if(f)return wnc(e);return b}function Fyb(){Fyb=JZ;tyb=new Myb;new Bzb;xyb=new kAb;yyb=new oAb;Eyb=new sAb;Byb=new wAb;Cyb=new AAb;oyb=new EAb;kyb=new IAb;syb=new Pyb;lyb=new Tyb;ryb=new Xyb;pyb=new _yb;qyb=new dzb;new hzb;vyb=new lzb;jyb=new pzb;iyb=new tzb;nyb=new xzb;uyb=new Ezb;wyb=new Izb;myb=new Mzb;Ayb=new Qzb;zyb=new Uzb;Dyb=
new Yzb}function Qxb(a,b){var c,d;this.b=a;this.a=new fDc;for(d=po(b).Vd();d.Id();){c=d.Jd();_tc(this.a,c.Ve(),new gcb(c.We(),(E2(),C2)))}_tc(this.a,ZOc,new gcb((Hcb(),zcb),(E2(),C2)));_tc(this.a,UOc,new gcb(new acb(CE(xE(aM,1),mLc,53,0,[ucb,ycb])),C2));_tc(this.a,sOc,new gcb(new acb(CE(xE(aM,1),mLc,53,0,[mcb,xcb])),C2))}function Nsb(a,b){var c,d,e,f;c=new Ysb(a);for(e=new wxc(b);e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);if(d.c){if(c.d.a.length!=0){Ywc(a.i,c);c=new Ysb(a)}Ywc(a.i,new _sb(a,d))}else{f=
d.d;Pd(!kDc(c.c,f),"Already a pass with name '%s' in this loop",f);jDc(c.c,f);Ywc(c.d,new _sb(c.f,d))}}c.d.a.length!=0&&Ywc(a.i,c)}function pUb(a,b){var c,d,e;d=DWb(a.g,0).d.b;iTb(a,(AZb(),GYb));e=(Bn(),new Zr);while(JVb(a,b)){Xr(e,SUb(a,b));if(!AVb(a,LXb)){c=iTb(a,OXb);if(AVb(a,LXb)){RVb(a,(IRb(),ERb));a.b.b||SVb(a,c,"Invalid trailing comma in formal parameter list",CE(xE(iW,1),mLc,1,5,[]))}}}iTb(a,LXb);return new G$b(new Z1b(d,a.f),In(e.a))}function FTb(a){var b,c,d;d=DWb(a.g,0).d.b;b=(Bn(),new Zr);
iTb(a,(AZb(),GYb));while(zVb(a,0,aZb)||FVb(a)){Xr(b,LTb(a));if(!AVb(a,LXb)){c=iTb(a,OXb);if(AVb(a,LXb)){RVb(a,(IRb(),ERb));a.b.b||SVb(a,c,"Invalid trailing comma in arguments list",CE(xE(iW,1),mLc,1,5,[]))}}}iTb(a,LXb);return new LZb(new Z1b(d,a.f),In(b.a))}function T7(a,b){var c,d;if(Esc(b.substr(0,1),"/"))return b;c=new hxc(new eyc(Rsc(a,"/",0)));d=new hxc(new eyc(Rsc(b,"/",0)));c.a.length==0||axc(c,c.a.length-1);while(c.a.length!=0&&d.a.length!=0)if(Esc(d.a[0],"."))axc(d,0);else if(Esc(d.a[0],
"..")){axc(d,0);axc(c,c.a.length-1)}else break;Zwc(c,d);return atc(c)}function sib(a){var b,c,d,e,f,g,h,i;e=new fxc;for(i=(!a.c?(Cyc(),Cyc(),Byc):new Kbc(a.c)).Vd();i.Id();){h=i.Jd();if(h.c){g=q9b(h.Sh(false),null);b=F9b(Yjb(h3b(g,g9b(h)),h.d),h);e.a[e.a.length]=b}}f=null;for(d=new wxc(e);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);f=!f?c:F9b(Yjb(i3b((Afc(),edc),f,c),c.d),c)}return f}function jnb(a){var b,c;new xDc;Xd(!a.Ud());a=hnb(a);this.a=zE(NN,mLc,257,a.Yd(),0,1);for(c=0;c<this.a.length;++c){b=
a.ce(c);ae(b.c==-1,"Module index already set: %s",b);Nd(c>=0,"Invalid module index: %s",c);b.c=c;this.a[c]=b}this.b=enb(this);this.c=gnb(this);fnb(this);knb(cnb(this),Tt(Wt(new eyc(this.a),new lnb)))}function B_(a,b,c){var d;F_(a,(IRb(),iRb),b);b0((Afc(),Adc),b);if(E8b(b,(n8b(),T7b))!=0){d=C8b(b);2!=d&&D0(PMc+d,b);b0(tdc,b.c);s0(b.c.f)}else if(E8b(b,U7b)!=0){d=C8b(b);1!=d&&D0(UMc+d,b);E_(a,b.c)}else{d=C8b(b);(d<1||d>2)&&D0(VMc+d,b);b.c.n==Cdc?D_(b.c):q0(a,b.c,c);!!b.c&&!!b.c.f&&b.c.f==(b.c?b.c.i:
null)&&s0(b.c.f)}}function $Ob(a,b){var c,d;if(b.n==(Afc(),Eec))for(d=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();d.Id();){c=d.Jd();if(E8b(c,(Hbc(),kbc))!=0){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,["property, missing type"])),a.b.ug(),a.d,a.c);return false}else if(!gPb(a,c.c))return false}else if(!gPb(a,b))return false;return true}function JC(a,b){var c,d,e,f,g,h,i,j;f=false;i=duc(a.k.c);c=new gxc;Zwc(c,Gyc(i,""));for(e=new TEc(new KEc(a.j));e.b!=e.c.a.b;){d=REc(e);h=pEc(a.k,d.d);if(!!h&&h.a<i){cxc(c,
h.a,d.e);f=true}}if(!f)return;SC(b,"sourcesContent",false);b.a+="[";for(g=0;g<i;g++){g!=0&&(b.a+=",",b);j=c.a[g];ltc(b,(uD(),xD(j||"")))}b.a+="]"}function yx(a){var b,c,d,e,f,g,h,i,j;e=new BCc((new vCc(a)).a);if(!$Cc(e.a))return oo(),oo(),no;d=(e.b=_Cc(e.a),new GCc(e.c,e.b));h=d.a;j=d.b.b[d.a.f];el(h,j);b=fe(h);f=new kCc(b);NCc(f.a,h);jCc(f,h.f,j);while($Cc(e.a)){c=(e.b=_Cc(e.a),new GCc(e.c,e.b));g=c.a;i=c.b.b[c.a.f];el(g,i);NCc(f.a,g);jCc(f,g.f,i)}return Sr(f)}function u0(a,b){var c,d,e,f;switch(b.n.f){case 68:b0((Afc(),
$cc),b);c=Cfc(b.n);c!=-1&&(d=C8b(b),c!=d&&D0(QMc+c+RMc+d,b));E_(a,b.c);n_(a,b.c?b.c.i:null);return;case 69:b0((Afc(),ldc),b);e=Cfc(b.n);e!=-1&&(f=C8b(b),e!=f&&D0(QMc+e+RMc+f,b));n_(a,b.c?b.c.i:null);return;default:D0("Expected switch member but was "+b.n,b)}}function tjb(a,b,c){var d,e;if(!!b.c&&!!b.c.f&&(ppb(),!(c.n==(Afc(),Vec)||c.n==Xec||c.n==Vcc||c.n==pec))){Uob(a,b,(Rjb(),Qjb),CE(xE(nW,1),uNc,2,6,["declaration with multiple destructuring children not in statement block"]));return}while(b.c!=
(b.c?b.c.i:null)){d=z8b(b.c?b.c.i:null);e=F9b(r3b(d,b.n),b);o8b(c,e,b);Vob(a)}}function eVb(a,b){var c,d,e,f,g;oTb(a,"set");if(KVb(a,0)){f=lTb(a);d=fVb(a);g=sTb(a);!!g&&SVb(a,DWb(a.g,0),"setter should not have any returns",CE(xE(iW,1),mLc,1,5,[]));c=qUb(a);RVb(a,(IRb(),yRb));return new v1b(pTb(a,b.d),f,b.c,d,c)}else{e=_Tb(a);d=fVb(a);c=qUb(a);RVb(a,(IRb(),yRb));return new o$b(pTb(a,b.d),e,b.c,d,c)}}function TDc(){if(!Object.create||!Object.getOwnPropertyNames)return false;var a="__proto__";var b=
Object.create(null);if(b[a]!==undefined)return false;var c=Object.getOwnPropertyNames(b);if(c.length!=0)return false;b[a]=42;if(b[a]!==42)return false;if(Object.getOwnPropertyNames(b).length==0)return false;return true}function OLb(a,b){var c,d,e,f,g;e=b.a;if(e.Yd()==1){c=iKb(a.a,(Afc(),rec),e.ce(0));T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);return c}else{f=e.uf();d=K3b(f.Jd());T9b(d.k)==-1&&vKb(d,b.o.b,b.o.a);while(f.Id()){g=iKb(a.a,(Afc(),bfc),f.Jd());T9b(g.k)==-1&&vKb(g,b.o.b,b.o.a);d=fKb(a.a,Pdc,d,g);
T9b(d.k)==-1&&vKb(d,b.o.b,b.o.a)}return d}}function WOb(a,b){var c,d;d=(Pd(b.n==(Afc(),Ycc),iSc,b),b.c.Wh());c=PPb($b(d));switch(c.f){case 1:return ROb(a,b);case 9:return UOb(a,b);case 10:return TOb(a,b);case 21:return ePb(a,b);case 8:return SOb(a,b);case 12:return XOb(a,b);case 13:return YOb(a,b);default:throw gZ(new Irc("Invalid type transformation operation"));}}function wVb(a,b){var c,d,e;d=DWb(a.g,0).d.b;e=DWb(a.g,0).e;switch(e.f){case 30:case 38:case 25:iTb(a,e);break;default:SVb(a,DWb(a.g,
0),"expected declaration",CE(xE(iW,1),mLc,1,5,[]));return null}c=(Bn(),new Zr);Xr(c,vVb(a,e,b));while(AVb(a,(AZb(),OXb))){iTb(a,OXb);Xr(c,vVb(a,e,b))}return new M1b(new Z1b(d,a.f),e,In(c.a))}function N3(a,b,c){var d,e;V3(a);d=b.charCodeAt(0);e=a.Xg();(d==43||d==45)&&e==d?a.Lg(" "):(Rqc==null&&(Rqc=new RegExp("[A-Z]","i")),Rqc.test(String.fromCharCode(d))&&(e==95||e==36||(Qqc==null&&(Qqc=new RegExp(hLc,"i")),Qqc.test(String.fromCharCode(e))))?a.Lg(" "):(e==45&&d==62||e==60&&d==33)&&a.Lg(" "));a.Og(b,
c);c&&a.Zg()}function hjb(a,b){var c,d,e,f;Kd(b.n==(Afc(),Ycc)||b.n==zcc||b.n==xec);e=new fxc;d=null;for(c=g9b(b);c;c=g9b(b))if(c.n==_ec){f=g9b(c);if(f.n==zcc)!d?d=f:t8b(d,f9b(f));else{if(d){e.a[e.a.length]=d;d=null}Ywc(e,Sjb(a.c,f))}}else{!d&&(d=r9b(f3b(CE(xE(HU,1),IMc,7,0,[])),a.a));q8b(d,c)}!!d&&(e.a[e.a.length]=d,true);return e}function REb(a,b,c){var d,e,f,g,h,i,j,k,l,m;g=new mDc;m=new Ewc(b);while(m.b!=m.c){h=(e=vwc(m),e);j=g.a.Je(h,g);if(j==null)for(l=h.nh().Vd();l.Id();){k=l.Jd();f=Ytc(a.b,
k);!!f&&(lwc(m,f),true)}}d=(Bn(),new Zr);for(i=new wxc(c?a.c:a.f);i.a<i.c.a.length;){h=(i.b=i.a++,i.c.a[i.b]);g.a.se(h)&&(Ywc(d.a,Sd(h)),d)}return In(d.a)}function gdb(a,b,c,d){var e,f,g,h,i,j,k;Yd(c.n==(Afc(),Ycc),c);Yd(b.n==ffc,b);f=(ppb(),Gpb(b,new frb(bdc)));k=f.c.f;if(!V8b(k))return;if(nqb(d)){i=H8b(b,(Hbc(),ybc));if(!!i&&i.Kh()||(e=(j=Dpb(f),!j?null:H8b(j,mbc)),!!e&&((e.a&512)!=0||(e.a&bPc)!=0))){g=Gpb(b,new jrb);h=g.g;z8b(g);w7(a.a,h)}return}else throw gZ(new Irc(dPc));}function Dvb(a,b){switch(nQb(b)){case "ts":return Cvb(a,
(uab(),jab));case "es9":return Cvb(a,(uab(),nab));case "es8":return Cvb(a,(uab(),mab));case "es7":return Cvb(a,(uab(),lab));case kOc:case "es6-impl":return Cvb(a,(uab(),kab));case "es5":return Cvb(a,(uab(),hab));case "es3":return Cvb(a,(uab(),gab));default:return false}}function cF(a){var b,c,d,e,f;if(a.l==0&&a.m==0&&a.h==0)return"0";if(a.h==uMc&&a.m==0&&a.l==0)return"-9223372036854775808";if(a.h>>19!=0)return"-"+cF(XE(a));c=a;d="";while(!(c.l==0&&c.m==0&&c.h==0)){e=FE(1E9);c=IE(c,e,true);b=""+bF(EE);
if(!(c.l==0&&c.m==0&&c.h==0)){f=9-b.length;for(;f>0;f--)b="0"+b}d=b+d}return d}function z6(a,b,c,d){var e,f;Xd(!a.v);try{Y6(a,b,c,d);a.g.a.d!=0||r8(new h8(a));if(a.g.a.d==0){Yd(!!a.B,dOc);Xd(a.g.a.d==0);Xd(true);r8(new b8(a));a.g.a.d!=0||B7(a);r8(new f8(a))}}finally{e=(a.G.pd!=(Xab(),Uab)&&!!a.O&&wsb(a.O,eOc,true),new hyb);y1(a.g.a);f=vZ(mZ(Date.now()),e.a);a.G.pd!=Uab&&!!a.O&&xsb(a.O,eOc,f)}return O6(a)}function eFb(a,b,c){var d,e,f,g,h;h=(bn(),new Rs);e=new mDc;for(g=wu(a.a.Vd(),a.b);g.b.Id();){f=
Ju(g,g.b.Jd());d=c.Ph(f);if(!jDc(e,dFb(d,b)))throw gZ(new qnb("Duplicate module path after resolving: "+f));!Esc(d.substr(0,1),"/")&&!(Esc(d.substr(0,2),rOc)||Esc(d.substr(0,3),nRc))&&(d="/"+d);Ywc(h.b,Sd(d))}return np(new wxc(h.b))}function _Fb(a,b,c){var d,e,f,g,h;h=(ZEb(),(!Esc(b.substr(0,"/".length),"/")&&!(Esc(b.substr(0,rOc.length),rOc)||Esc(b.substr(0,nRc.length),nRc))?"/":"")+b);for(g=xu(new Wzc(a.b.b.b.Vd()));g.Id();){f=g.Jd();if(!Esc(h.substr(0,f.length),f))continue;d=f+qRc+c;e=$Fb(a,b,
d);e==null&&(e=aGb(a,b,d));if(e!=null)return e}return null}function nHb(){nHb=JZ;mHb=new Mcb("JSC_MUTATED_EXPORT",(E2(),D2),new Rtc('The name "{0}" is exported and should not be mutated outside of module initialization. Mutable exports are generally difficult to reason about. You can work around this by exporting getter/setter functions, or an object with mutable properties instead.'))}function KLb(a,b){var c,d;switch(b.a.e.f){case 100:return c=lKb(a.a,b.a),d=hKb(a.a,c),T9b(d.k)==-1&&vKb(d,b.o.b,
b.o.a),d;case 101:return _Lb(a,b);case 99:case 98:return dKb(a.a,SKb(b.a.e));case 97:return dKb(a.a,(Afc(),Aec));case 102:return YLb(a,b);default:throw gZ(new Irc("Unexpected literal type: "+b.a.Fj+" type: "+b.a.e));}}function vVb(a,b,c){var d,e,f,g;f=DWb(a.g,0).d.b;g=null;if(zVb(a,0,(AZb(),HYb))||zVb(a,0,FYb))e=UUb(a,0);else{e=wUb(a);AVb(a,NXb)&&(g=(iTb(a,NXb),nVb(a)))}d=null;AVb(a,ZXb)?d=(iTb(a,ZXb),KTb(a,c)):c!=0&&(b==PXb?VVb(a,TSc,CE(xE(iW,1),mLc,1,5,[])):GZb(e)&&VVb(a,USc,CE(xE(iW,1),mLc,1,5,
[])));return new N1b(new Z1b(f,a.f),e,g,d)}function lC(a){var b,c,d,e;e=zE(yF,iMc,46,5,15,1);b=new fxc;while(EC(a.a))if(pC(a,59)){mC(a,b);b.a.length==0||(b=new fxc)}else{d=0;while(!oC(a)){e[d]=YB(a.a);++d}c=nC(a,e,d);$d(a.i.b<0||a.b<a.i.b,a.b,a.i.b);Xd(c.bg()==-1||c.bg()<a.i.e.length);Xd(c._f()==-1||c._f()<a.i.d.length);b.a[b.a.length]=c;pC(a,44)}b.a.length==0||mC(a,b)}function Fgb(a,b,c,d){var e,f,g,h,i,j;Kd((a.c?a.c.i:null)==b);g=(i=(ae(Hsc(c,_sc(46))==-1,HMc,c),n8b(),new Wbc((Afc(),rec),c)),i);
j=Tbc(g,false);if(d.a.length!=0){f=new wxc(d);e=Dgb(Tbc(g,false),(f.b=f.a++,f.c.a[f.b]));while(f.a<f.c.a.length)e=L$(e,Dgb(Tbc(g,false),(f.b=f.a++,f.c.a[f.b])));j=(h=i3b(edc,e,j),h)}I9b(j,b);return j}function IKb(a,b,c,d,e){var f;this.k=new mDc;this.e=(iQb(),TPb);this.r=a;this.j=e.uf();this.b=QKb(this.j);this.p=b;this.s=(f=new J9b((Afc(),Xec)),y9b(f,this.p),f);this.f=new C7b(c.c!=(mJb(),lJb));this.q=!b?null:b.ug();this.a=c;this.d=d;this.t=new tMb(this);c.g==(KJb(),JJb)?this.n=PJb:c.d==(zJb(),pJb)?
this.n=null:this.n=OJb}function sMb(a,b,c){var d,e,f;for(f=Cn(new qx(Sd(c)),0);f.c<f.d;){e=zf(f).a;switch(e){case 103:case 105:case 109:break;case 117:case 121:d=e==117?(IRb(),sRb):(IRb(),tRb);bKb(a.a,b,d);break;case 115:bKb(a.a,b,(IRb(),rRb));break;default:a.a.d.Ah("Invalid RegExp flag '"+String.fromCharCode(e)+"'",a.a.q,(RJb(),b.o.b.b+1),b.o.b.a)}}}function h2b(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p;f=new H2b(b);e=0;j=null;g=false;k=b.length;h=0;while(h<k){n=h;l=Isc(b,_sc(37),h);m=l==-1?k:l;m>n&&
ntc(a.c,b,n,m);h=m;if(h<k){p=(f.d=h+1,f.b=h+1,C2b(f,new P2b));d=null;if(p.b!=37&&p.b!=110){i=p.a==-1?e++:p.a;d=y2b(c,i,f,j,g);j=d;g=true}o=k2b(a,p,d);o!=null&&i2b(a,o,btc(o));h=f.b}}}function G5b(a,b){var c,d,e;e=new L5b;e.a=D5b(a.a,b);e.f=H5b(a.f,b);e.g=H5b(a.g,b);e.o=I5b(a.o,b);e.s=H5b(a.s,b);e.r=!a.r?null:new hxc(a.r);e.e=!a.e?null:new oDc(a.e);e.t=!a.t?null:new vEc(a.t);e.d=a.d;e.k=a.k;e.c=a.c;e.j=a.j;e.q=!a.q?null:(bn(),d=a.q,mp(d));e.n=!a.n?null:(bn(),c=a.n,mp(c));e.i=D5b(a.i,b);e.b=a.b;e.p=
a.p;return e}function psb(a){var b,c,d;if(a.I)return;a.i=mZ(Date.now());ssb(a);for(c=po(a.I).Vd();c.Id();){b=c.Jd();d=b.We();a.F=yZ(hZ(a.F,d.n));a.C=$wnd.Math.max(a.C,d.a);a.G+=d.k;a.c+=d.d;if(!d.i){a.B+=d.k;a.A+=d.d}a.a+=d.b;a.g+=d.e;a.p+=d.f}Xd(a.D==(Xab(),Wab)||a.q==a.a+a.b);Xd(!(a.D==Vab||a.D==Sab)||a.r==a.g+a.e);Xd(a.D!=Sab||a.s==a.p+a.o)}function nQb(a){if(kQb(YPb,a))return"es3";if(kQb(ZPb,a))return"es5";if(kQb(_Pb,a))return kOc;if(kQb(bQb,a))return"es7";if(kQb(dQb,a))return"es8";if(kQb(VPb,
a))return"es9";if(kQb(XPb,a))return"es_2019";if(kQb(eQb,a))return rRc;if(kQb(fQb,a))return"es_unsupported";if(kQb(gQb,a))return"ts";throw gZ(new Irc(a.a.Bd()));}function hC(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;j=false;k=null;n=null;l=null;m=null;i=a.c.a.length;for(f=0;f<i;f++){h=$wc(a.c,f);if(h){e=h.a.length;for(g=0;g<e;g++){d=h.a[g];if(j){c=new _B(f,d.$f());IC(b.a,k,n,l,m,c);j=false}if(d.bg()!=-1){j=true;k=a.e[d.bg()];n=d._f()!=-1?a.d[d._f()]:null;l=new _B(d.cg(),d.ag());m=new _B(f,d.$f())}}}}}function ylb(a,
b,c,d,e,f){var g,h,i,j,k;k=fQc.length;if(Esc(f.substr(f.length-k,k),fQc)){i=1;j=Vsc(f,0,f.length-10)}else{h=f.indexOf(gQc);if(h==-1)return false;j=f.substr(0,h);i=2;h=Isc(f,_sc(46),h+11);while(h>=0){++i;h=Isc(f,_sc(46),h+1)}}if(!!e&&Sqb(d))return true;for(g=0;g<i;g++){e=d;d=d.c}slb(a,b,c,d,j,(cmb(),$lb));return true}function TJb(a,b){var c,d,e,f,g,h,i,j;d=b.c;f=b.a.b.b+1;c=b.a.b.a;g=b.a.b.c;e=new BNb(new sOb(d.substr(3),f,c+3),d,g,a.s,a.a,a.d);vNb(e,a.f);wNb(e,a.g);b.b==(e$b(),a$b)&&b.c.length>0?
(e.i=(JNb(),HNb),xNb(e),h=!e.o?mOb(e.j):GMb(e),i=JMb(e,h,0,false,true),j=" "+i.a,e.d?i6b(e.d,j):e.f.d?t6b(e.f,j):t6b(e.f,""),undefined):TMb(e);return e}function tqb(a){ppb();var b,c;switch(a.n.f){case 31:case 30:case 32:case 35:case 34:return true;case 92:case 19:case 79:case 22:return tqb(a.c);case 29:c=a.Wh();return Esc(vPc,c)||Esc(xQc,c)||Esc("NaN",c);case 118:for(b=a.c;b;b=b.f)if(b.n==(Afc(),kfc))if(!tqb(b.c))return false;return true;default:Kd(a.n!=(Afc(),jfc))}return false}function egb(a,b){var c,
d,e,f,g,h,i,j;i=agb(a,b);g=z8b(a.c?a.c.i:null);c=H9b((j=h3b(i,g),j),g);e=H8b(a,(Hbc(),mbc));if(E8b(a,zbc)!=0&&brb(c.c?c.c.i:null)){f=E7b(e);p7b(f,new H7b(new L9b((Afc(),Qcc),new J9b(Pec)),(d=H8b(a,ybc),!d?null:d.ug())));e=k6b(f)}!!e&&(d9b(c,mbc,e),c);h=(ppb(),F9b((Yd(H3b(c),c),new L9b((Afc(),Ddc),c)),c));sgb(b.i,h)}function GTb(a){var b,c,d;c=DWb(a.g,0).d.b;b=(Bn(),new Zr);iTb(a,(AZb(),HYb));d=null;while(AVb(a,OXb)||AVb(a,aZb)||FVb(a)){d=null;if(AVb(a,OXb))Xr(b,new s_b(pTb(a,DWb(a.g,0).d.b)));else if(AVb(a,
aZb)){RVb(a,(IRb(),zRb));Xr(b,jVb(a))}else Xr(b,KTb(a,1));AVb(a,MXb)||(d=iTb(a,OXb))}iTb(a,MXb);vTb(a,d);return new MZb(new Z1b(c,a.f),In(b.a))}function N6(a,b){switch(b.f){case 0:return zJb(),pJb;case 1:case 2:return zJb(),qJb;case 3:return zJb(),rJb;case 4:return zJb(),xJb;case 5:return zJb(),sJb;case 6:return zJb(),tJb;case 7:return zJb(),uJb;case 8:return zJb(),vJb;case 12:return zJb(),yJb;case 9:return zJb(),wJb;default:throw gZ(new Irc("Unexpected language mode: "+a.G.Sb));}}function tVb(a){var b,
c,d,e,f;d=DWb(a.g,0).d.b;if(OVb(a)){c=wTb(a);b=tVb(a);return new J1b(new Z1b(d,a.f),c,b)}else return zVb(a,0,(AZb(),iYb))&&Esc(DWb(a.g,0).a,ZSc)?(e=DWb(a.g,0).d.b,(swc(a.e)||!uwc(a.e).a)&&VVb(a,"'await' used in a non-async function context",CE(xE(iW,1),mLc,1,5,[])),oTb(a,ZSc),f=tVb(a),new QZb(new Z1b(e,a.f),f)):uVb(a)}function Ljc(a,b,c,d,e,f,g,h){Ofc();Wic.call(this,a,b,a.u[17],h,f);this.d=(Bn(),Bn(),An);this.c=(null,An);this.j=null;this.s=true;Kd(!c||c.n==(Afc(),Jdc)||c.n==(Afc(),bdc));Sd(d);this.i=
c;this.f=g;switch(g.f){case 1:this.k=e?e:new gkc(a,this,h);break;case 0:this.k=e?e:a.u[51];break;case 2:this.k=e?e:new gkc(a,this,h)}this.b=d;this.e=false}function L2b(a,b){var c;c=false;switch(b){case 43:c=a.d;a.d=true;break;case 44:c=a.e;a.e=true;break;case 45:c=a.f;a.f=true;break;case 40:c=a.g;a.g=true;break;case 35:c=a.i;a.i=true;break;case 32:c=a.j;a.j=true;break;case 48:c=a.k;a.k=true;break;default:return false}if(c)throw gZ(new GD(""+b));!a.o&&(a.o=new ttc);itc(a.o,b&dLc);return true}function Lv(a,
b,c,d){var e,f,g;g=new vw(b,c);if(!a.a){a.a=a.e=g;$tc(a.b,b,new uw(g));++a.c}else if(!d){a.e.b=g;g.d=a.e;a.e=g;e=Xtc(a.b,b);if(!e){$tc(a.b,b,e=new uw(g));++a.c}else{++e.a;f=e.c;f.c=g;g.e=f;e.c=g}}else{e=Xtc(a.b,b);++e.a;g.d=d.d;g.e=d.e;g.b=d;g.c=d;!d.e?Xtc(a.b,b).b=g:d.e.c=g;!d.d?a.a=g:d.d.b=g;d.d=g;d.e=g}++a.d;return g}function xB(a,b,c){var d,e,f;Sd(b);c=pB(a,c);if(!iB(a.b,btc(c)))throw gZ(new QB("Invalid input length "+btc(c)));d=0;for(f=0;f<btc(c);){e=gB(a.b,Zsc(c,f++))<<18;e|=gB(a.b,Zsc(c,f++))<<
12;b[d++]=e>>>16<<24>>24;if(f<btc(c)){e|=gB(a.b,Zsc(c,f++))<<6;b[d++]=(e>>>8&255)<<24>>24;if(f<btc(c)){e|=gB(a.b,Zsc(c,f++));b[d++]=(e&255)<<24>>24}}}return d}function BWb(a,b,c){var d,e,f;d=a.f;e=cXb(a);!xWb(a,a.f)&&EWb(a,ZSb(a.i.b,d),$Sc,CE(xE(iW,1),mLc,1,5,[]));f=Vsc(a.b,d,a.f);switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 96:yWb(a);return new uXb(b,f,e.a,e.b,$Sb(a.i.b,d-1,a.f));case 36:yWb(a);yWb(a);return new uXb(c,f,e.a,e.b,$Sb(a.i.b,d-1,a.f));default:return new uXb(b,f,e.a,e.b,$Sb(a.i.b,d-1,a.f))}}
function llc(){this.B=new fq(new tEc,new iq);this.t=new J9b((Afc(),Vec));this.v=new YEc;this.D=jy(Zx((fl(8,lQc),new $x)));this.A=new mDc;this.e=new mDc;this.f=new tEc;this.j=new fDc;this.q=new hv;new fxc;this.g=new $nc(this,(Bn(),Bn(),An),(null,An));this.u=zE(cV,xPc,23,Kkc().length,0,1);Sf(this.D);nEc(this.f);clc(this);nEc(this.B.a);dlc(this)}function Drb(a,b,c,d){var e,f,g;if(b.c){e9b(c,b);g=b.c;e9b(b,g);e=h3b(b,g);q9b(e,H8b(c,(Hbc(),mbc)));H9b(e,c);f=(ppb(),F9b((Yd(H3b(e),e),new L9b((Afc(),Ddc),
e)),e));j9b(d,c,f);Arb(a.b,BQc,f)}else{ppb();if(d.n==(Afc(),Vec)||d.n==Xec||d.n==Vcc||d.n==pec)e9b(d,c);else if(d.n==Hdc||d.n==Idc){e9b(c,b);j9b(d,c,b)}else Yd(d.n==eec,d);Arb(a.b,BQc,d)}}function Axb(b,c){var d,e,f,g,h,i;if(!b.a){b.a=true;i=b.c.b;try{g=b.c.a;d=new iC;h=qD(g);eC(d,h);b.b=d}catch(a){a=fZ(a);if(pF(a,104)){e=a;f=new Gmb(null,null,-1,-1,yxb,null,CE(xE(nW,1),uNc,2,6,[i,e.g]));Xxb(c,f.b,f)}else if(pF(a,127)){e=a;f=new Gmb(null,null,-1,-1,xxb,null,CE(xE(nW,1),uNc,2,6,[i,e.g]));Xxb(c,f.b,
f)}else throw gZ(a);}}return b.b}function UBb(a,b){var c,d,e,f,g;Yd(b.n==(Afc(),Jdc)&&b.g.n==mec,b);g=b.d;if(!g||g.Bi())return"";c=g.Ii();f=new vtc("/**\n");d=(ppb(),Kd(b.n==Jdc),b.c.f).c;OBb(a,f,c,d);if(mqb(b))QBb(f,sjc(c));else{QBb(f,Vfc(c));e=c.b.b;if(!!e&&!(e.ti()||e.ri()||e.si()||e==e.A.u[64])){f.a+=mRc;aCb(f,ENc,Pfc(e,new stc,true).a);f.a+=gMc}}f.a+=" */\n";return f.a}function onc(a,b,c){Ofc();var d,e,f,g;Uic.call(this,a,null,null);this.a=false;this.s=true;for(g=xu(new Wzc((d=b.b,!d?b.b=At(b.a,
sAc(b.c)):d).b.b.Vd()));g.Id();){f=g.Jd();e=f==null?null:Bx(b.d,f);if(!e)throw gZ(new Irc("RecordProperty associated with a property should not be null!"));c?zhc(this,f,e.b,e.a):lnc(this,f,e.b,false,e.a)}this.a=true}function IC(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p;if(b==null||d.b<0)return;h=e;g=f;if(a.f.b!=0||a.f.a!=0){o=a.f.b;p=a.f.a;i=a.f.a;e.b>0&&(p=0);f.b>0&&(i=0);h=new _B(e.b+o,e.a+p);g=new _B(f.b+o,f.a+i)}l=new YC;l.d=b;l.c=d;l.b=c;l.e=h;l.a=g;if(a.b){k=a.b.e.b;j=a.b.e.a;n=l.e.b;m=l.e.a;de(n>
k||n==k&&m>=j,Yrc(k),Yrc(j),Yrc(n),Yrc(m))}a.b=l;Ywc(a.e,l)}function SFb(a){RFb();var b,c,d,e,f,g,h,i,j;i=Rsc(a,"/",0);d=zE(nW,uNc,2,i.length,6,1);j=0;c=0;b=i.length>1&&i[0].length==0;b&&--c;for(f=i,g=0,h=f.length;g<h;++g){e=f[g];if(Esc(e,"."))continue;if(Esc(e,"..")){if(c>0){--j;--c;d[j]=null}else if(!b){d[j]=e;++j}continue}d[j]=e;++j;++c}if(b&&j==1)return"/";return Nc(QFb,new Guc(new eyc(Fxc(d,j))))}function pD(a){var b,c;c=a.offset.line;b=a.offset.column;if(a.map!=null&&a.url!=null)throw gZ(new rD("Invalid map format: section may not have both 'map' and 'url'"));
else if(a.url!=null)return new sD(0,a.url,c,b);else if(a.map!=null)return new sD(1,etc(a.map),c,b);throw gZ(new rD("Invalid map format: section must have either 'map' or 'url'"));}function tvb(a,b,c){var d,e,f,g,h,i,j;Kd(c.n==(Afc(),Eec));g=Z$((Kob(b),CE(xE(HU,1),IMc,7,0,[(h=P3b(CE(xE(HU,1),IMc,7,0,[])),h)])));j=null;for(e=(!c.c?(Cyc(),Cyc(),Byc):new Kbc(c.c)).Vd();e.Id();){d=e.Jd();if(d.n==_ec){i=g9b(d);q8b(g,i);j=null}else{if(!j){j=(f=P3b(CE(xE(HU,1),IMc,7,0,[])),f);q8b(g,j)}q8b(j,z8b(d))}}I9b(g,
c);j9b(c.g,c,g);w7(a.a,g)}function BQb(a){iQb();switch(a){case "es3":return YPb;case "es5":return ZPb;case "es6-impl":case kOc:return $Pb;case "typeCheckSupported":return hQb;case "es7":return aQb;case "es8":return cQb;case "es2018":case "es9":return UPb;case "es_2019":return WPb;case rRc:return eQb;case "ts":return gQb;default:throw gZ(new qnb("No such FeatureSet: "+a));}}function tq(a,b,c){var d,e,f,g,h;d=yZ(rZ(VLc,Vrc(yZ(rZ(b==null?0:Db(b),WLc)),15)));h=yZ(rZ(VLc,Vrc(yZ(rZ(c==null?0:Db(c),WLc)),
15)));f=wq(a,b,d);if(!!f&&h==f.f&&Gd(c,f.i))return c;g=xq(a,c,h);if(g)throw gZ(new qnb("value already present: "+c));e=new $q(b,d,c,h);if(f){pq(a,f);rq(a,e,f);f.e=null;f.c=null;return f.i}else{rq(a,e,null);vq(a);return null}}function A3(a){var b;this.b=a;this.a=tp("goog.isDef","goog.isNull","goog.isDefAndNotNull","goog.isString","goog.isNumber","goog.isBoolean",CE(xE(nW,1),uNc,2,6,["goog.isFunction","goog.isArray","goog.isArrayLike","goog.isObject"]));b=(bn(),new Rs);Ps(b,CE(xE(nW,1),uNc,2,6,["superClass_",
"instance_","getInstance"]));Qs(b,(Bn(),Bn(),An));np(new wxc(b.b))}function Ogb(a){Bgb();this.e=new Cwc;this.a=a.a;this.f=a.b;switch(this.f.f){case 0:this.d=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),SQb),EQb,FQb,lRb]));this.c=oQb(this.d,nRb);break;case 1:this.d=oQb((iQb(),TPb),(IRb(),nRb));this.c=this.d;break;default:throw gZ(new Kqc("Es6RewriteDestructuring cannot handle ObjectDestructuringRewriteMode "+this.f));}}function _Ib(a){var b;b="";!a.d&&(b+=" languageMode");!a.g&&(b+=" strictMode");
!a.c&&(b+=" jsDocParsingMode");!a.f&&(b+=" runMode");!a.a&&(b+=" annotations");!a.i&&(b+=" suppressionNames");!a.b&&(b+=" closurePrimitiveNames");a.e==null&&(b+=" parseInlineSourceMaps");if(b.length!=0)throw gZ(new Irc(bNc+b));return new XIb(a.d,a.g,a.c,a.f,a.a,a.i,a.b,a.e)}function Epb(a){ppb();var b,c;c=Vpb(a);b=c.g;if(b.n==(Afc(),Sec)||b.n==mdc){b=b.g;Yd(b.n==Jec,b)}else if(b.n==odc){b=b.g;Yd(!!b&&(b.n==ufc||b.n==jec||b.n==gdc),b)}else if(b.n==bdc||b.n==Jdc)Yd(a==b.c,a);else if(b.n==Wdc){Yd(a==
b.c.f,a);b=!b.g?null:b.g.g;Yd(b.n==Vdc,b)}else Yd(b.n==Jec||!!b&&(b.n==ufc||b.n==jec||b.n==gdc)||b.n==Vdc||b.n==adc,b);return b}function Bib(a,b){if(b.g.n==(Afc(),Ddc))return;dkb(a.a,b)!=0?gkb(a.a,b):u7(a.b.b,Lmb(b,(Rjb(),Pjb),CE(xE(nW,1),uNc,2,6,["Undecomposable expression: Please rewrite the yield or await as a separate statement.\nSee https://github.com/google/closure-compiler/wiki/FAQ#i-get-an-undecomposable-expression-error-for-my-yield-or-await-expression-what-do-i-do"])))}function p0(a,b){var c,
d,e;b0((Afc(),_ec),b);d=Cfc(b.n);d!=-1&&(c=C8b(b),d!=c&&D0(QMc+d+RMc+c,b));e=b.g;switch(e.n.f){case 28:case 23:b==e.c&&D0("SPREAD node is not callable.",b);F_(a,(IRb(),zRb),b);break;case 43:F_(a,(IRb(),mRb),b);F_(a,zRb,b);break;case 42:F_(a,(IRb(),zRb),b);break;default:D0("SPREAD node should not be the child of a "+e.n+" node.",b)}}function _nc(a,b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q;o=b.c;l=c.c;for(f=0;f<o.Yd();f++){n=o.ce(f);q=(h=Snc(b,n),h==-1?b.a.u[51]:b.b[h]);p=0;for(i=0;i<l.Yd();i++){k=l.ce(i);
m=(g=Snc(c,k),g==-1?c.a.u[51]:c.b[g]);if(n==k){j=1;(Qfc(q,m,a,d)||e==1&&q.Ai(m,new Akc(true),e)&&m.Ai(m,new Akc(true),e))&&(j=2);p!=2&&(p=j)}}if(p==1||p==0&&a!=2)return false}return true}function UWb(a){var b,c,d,e;c=a.f;yWb(a);yWb(a);while(xWb(a,a.f)&&((xWb(a,a.f)?zsc(a.b,a.f):0)!=42||(xWb(a,a.f+1)?zsc(a.b,a.f+1):0)!=47))yWb(a);if(xWb(a,a.f)){yWb(a);yWb(a);d=(e$b(),_Zb);a.f-c>4&&(zsc(a.b,c+2)==42?d=b$b:zsc(a.b,c+2)==33&&(d=a$b));b=$Sb(a.i.b,c,a.f);e=Vsc(a.b,c,a.f);$Vb(a.a,d,b,e)}else FWb(a,"unterminated comment",
CE(xE(iW,1),mLc,1,5,[]))}function YDb(a){var b;b="";a.d==null&&(b+=" name");a.e==null&&(b+=" pathRelativeToClosureBase");!a.f&&(b+=" provides");!a.g&&(b+=" requires");!a.i&&(b+=" typeRequires");!a.c&&(b+=" loadFlags");a.a==null&&(b+=" hasExternsAnnotation");a.b==null&&(b+=" hasNoCompileAnnotation");if(b.length!=0)throw gZ(new Irc(bNc+b));return new ODb(a.d,a.e,a.f,a.g,a.i,a.c,a.a,a.b)}function sNb(a,b,c){var d,e,f;f=QMb(a,(Afc(),Kec));!!c&&q8b(f,c);d=null;do{if(d){xNb(a);b=!a.o?mOb(a.j):GMb(a);Xd(b==
(fOb(),ZNb));xNb(a);b=!a.o?mOb(a.j):GMb(a)}d=mNb(a,b);if(!d)return null;q8b(f,d)}while(OMb(a,(fOb(),ZNb)));if(!c){xNb(a);if(!OMb(a,bOb))return CMb(a,aSc,a.j.g,lOb(a.j)),null;!a.o?mOb(a.j):GMb(a)}if(!!f.c&&!f.c.f){e=f.c;e9b(f,e);return e}return f}function Tnb(a,b,c){var d,e,f,g,h,i,j,k,l;j=a.e;l=b.f;g=b.d;f=b.a;d=new stc;e=new stc;i=Ynb(l,g);if(a.c){h=!j?null:S6(j,b.f,b.d,b.a);if(!h)e.a+=""+i;else{l=h.d;g=h.c;f=h.a;d.a+=""+i;d.a+="\nOriginally at:\n";ptc(e,Ynb(l,g))}}if(a.b){ptc(e,UZ(a,c?(E2(),D2):
(E2(),B2)));e.a+=" - "}ptc(e,b.c);ptc(d,WZ(a,e.a));d.a+=gMc;k=Unb(a,b,l,g,f);k!=null&&(d.a+=""+k,d);return d.a}function Unb(a,b,c,d,e){var f,g,h,i,j,k,l;f=new stc;k=a.e;l=!k?null:R6(k,c,d);if(l!=null){f.a+=""+l;f.a+=gMc;if(a.a==(Lwb(),Jwb)&&0<=e&&e<=l.length){for(i=0;i<e;i++){g=l.charCodeAt(i);Gfc();Ffc.test(g)?(f.a+=String.fromCharCode(g),f):(f.a+=" ",f)}if(!b.e)f.a+="^";else{j=$wnd.Math.max(1,$wnd.Math.min(b.e.e,l.length-e));for(h=0;h<j;h++)f.a+="^"}f.a+=gMc}}return f.a}function A4(a,b,c,d){var e,
f,g,h;h=b;if(!d&&b.n!=(Afc(),Vcc))throw gZ(new Hqc("Missing BLOCK child."));if(b.n==(Afc(),Vcc)){f=P4(b,2);if(f==0){if(a.c.bh()){O3(a.c);R3(a.c,a.c.Qg(b,c==(_4(),$4)))}else a.c.Wg(true);return}if(f==1){g=O4(b);e=a.c.bh();if(e||S4(g)){O3(a.c);a.fh(g,(_4(),$4));a.c._g();R3(a.c,a.c.Qg(b,c==$4));return}else h=g}}h.n==tdc?a.c.Wg(true):a.fh(h,c)}function w8(a){var b,c;Ud(a.b,"Expected setCompiler to be called first: %s",a);Ud(K6(a.b),"Expected compiler to call an error manager: %s",a);b=new W8(z8(a));c=
x8(a,a.b);if(!c)return MDb(),LDb;V8(b,c);return MDb(),YDb(_Db(eEb(dEb(cEb($Db(ZDb(_Db(eEb(dEb(cEb(bEb(aEb(new fEb,""),""),(Bn(),Bn(),An)),(null,An)),(null,An)),(oo(),oo(),no)),false),false),b.c),b.d),b.e),b.a))}function jOb(a){var b;if(a.r!=0){++a.b;--a.r;a.a==-1&&(a.a=a.i-a.f-a.r-1);return a.q[a.r]}for(;;){if(a.i==a.j){a.a==-1&&(a.a=a.i-a.f-a.r-1);return-1}++a.b;b=zsc(a.k,a.i++);if(a.e>=0){if(a.e==13&&b==10){a.e=10;continue}a.e=-1;a.f=a.i-1;++a.g}if(b<=127){if(b==10||b==13){a.e=b;b=10}}else{Gfc();
if(b>127)continue;if(uOb(b)){a.e=b;b=10}}a.a==-1&&(a.a=a.i-a.f-a.r-1);return b}}function nC(a,b,c){var d;switch(c){case 1:d=new rC(b[0]+a.c);a.c=d.e;return d;case 4:d=new xC(b[0]+a.c,b[1]+a.f,b[2]+a.g,b[3]+a.e);a.c=d.e;a.f=d.bg();a.g=d.cg();a.e=d.ag();return d;case 5:d=new CC(b[0]+a.c,b[1]+a.f,b[2]+a.g,b[3]+a.e,b[4]+a.d);a.c=d.e;a.f=d.bg();a.g=d.cg();a.e=d.ag();a.d=d._f();return d;default:throw gZ(new rD("Unexpected number of values for entry:"+c));}}function Scb(){Scb=JZ;Qcb=new Mcb("JSC_INVALIDATION",
(E2(),C2),new Rtc("Property disambiguator skipping all instances of property {0} because of type {1} node {2}. {3}"));Rcb=new Mcb("JSC_INVALIDATION_TYPE",C2,new Rtc("Property disambiguator skipping instances of property {0} on type {1}. {2}"));new Mcb("JSC_INVALID_RENAME_FUNCTION",B2,new Rtc("{0} call is invalid: {1}"))}function L3(a,b){var c,d,e;V3(a);if(b.length==0)return;c=b.charCodeAt(0);(c==95||c==36||(Qqc==null&&(Qqc=new RegExp(hLc,"i")),Qqc.test(String.fromCharCode(c)))||c==92)&&g4(a.Xg())?
a.Lg(" "):c==47&&a.Xg()==47?a.Lg(" "):(c==34||c==39)&&g4(a.Xg())&&a.$g();e=0;d=Hsc(b,_sc(10));while(d>=0){d>e&&a.Lg(b.substr(e,d-e));a.dh();e=d+1;d=Isc(b,_sc(10),e)}b.length>e&&a.Lg(b.substr(e))}function Gnb(a,b){var c,d,e,f,g,h,i;i=new fxc;if(a.Mi())for(d=Poc(a.Mi()).Vd();d.Id();){c=d.Jd();c=c.fi()?c.fi():c;g=c.zi(b.u[24]);f=c.zi(b.u[3]);if(!g&&!f)return new Inb(null);h=f?3:24;Ywc(i,Ufc(c,b.u[h]))}else{e=a.fi()?a.fi():a;g=e.zi(b.u[24]);f=e.zi(b.u[3]);if(!g&&!f)return new Inb(null);h=f?3:24;Ywc(i,
Ufc(e,b.u[h]))}return new Inb(Zkc(b,exc(i,zE(cV,xPc,23,0,0,1))))}function XBb(a,b){var c,d,e;if(b.n==(Afc(),mec))return UBb(a,(Xd(!!b.c&&!b.c.f),b.c));else if(b.n==bdc)return SBb(b.d);else if(b.n==Jdc)return TBb(a,b);else{d=(ppb(),c=Dpb(b),!!(!c?null:H8b(c,(Hbc(),mbc))));if(!d)return"";e=b.d;return!e?"":e.Ii()?TBb(a,b):(e.Hi(),!e.Bi()&&!(e.ti()||e.ri()||e.si()||e==e.A.u[64])&&!e.Ci()&&!e.qi()?"/** @type {"+agc(b.d,0)+"} */\n":"")}}function nlb(a,b){var c,d,e,f,g,h;h=b.g;Xd(h.n==(Afc(),Eec));c=h.g;
if(!c)return null;d=c.g;switch(c.n.f){case 29:if(!d||(ppb(),!(!!d&&(d.n==ufc||d.n==jec||d.n==gdc))))return null;g=c.Wh();break;case 47:f=c.c;g=I8b(f);break;case 91:if(!!d&&d.n==Eec)g=nlb(a,c);else return null;break;default:return null}if(g!=null){e=b.Wh();G7b();if(F7b.test(e))return g+"."+e}return null}function HTb(a,b){var c,d,e;e=DWb(a.g,0).d.b;c=(Bn(),new Zr);iTb(a,(AZb(),HYb));while(AVb(a,OXb)||FVb(a))if(AVb(a,OXb)){d=DWb(a.g,0).d.b;iTb(a,OXb);Xr(c,new s_b(new Z1b(d,a.f)))}else{Xr(c,VUb(a,b));
if(AVb(a,OXb))iTb(a,OXb);else break}if(AVb(a,aZb)){RVb(a,(IRb(),FQb));Xr(c,XUb(a,b))}if(!iTb(a,MXb))return new n_b(pTb(a,DWb(a.g,0).d.b));return new NZb(new Z1b(e,a.f),In(c.a))}function a9b(a,b,c){var d,e,f;f=Ksc(b,_sc(46),c-1)+1;switch(a.n.f){case 29:d=a.Wh();return f==0&&d.length!=0&&d.length==c&&Esc(b.substr(0,d.length),d);case 33:return f==0&&4==c&&Esc(b.substr(0,4),FMc);case 99:return f==0&&5==c&&Esc(b.substr(0,5),DMc);case 26:e=(a.c?a.c.i:null).Wh();return f>1&&e.length==c-f&&Msc(e,false,0,
b,f,c-f)&&a9b(a.c,b,f-1);case 98:default:return false}}function wgb(a,b){var c,d,e,f;d=Td((ppb(),Gpb(b,new jrb)),b);if(d==b)return true;else{c=b.g;if(!!d&&(d.n==(Afc(),ufc)||d.n==jec||d.n==gdc)&&c.n==(Afc(),rec)&&d==c.g&&!(c==c.g.c?null:c.i))return true;else if(d.n==(Afc(),Ddc)&&d==c.g&&!(c==c.g.c?null:c.i)&&!c.f&&c.n==Ccc&&(f=b==b.g.c?null:b.i,!!f&&c==f.g&&!(f==f.g.c?null:f.i))){e=c.c;return!upb(e,false,a.b)}else return false}}function YBb(a,b){var c,d,e;d=b.g;if(!d)return;if(d.n==(Afc(),Vcc)||d.n==
Xec||d.n==cdc)if(b.n==bdc||b.n==Jdc||b.n==mec)r4(a,XBb(a,b));else if(b.n==Ddc&&b.c.n==Ccc){c=b.c;if(Dqb(c.c))r4(a,Bmb(a.a,H8b(c,(Hbc(),mbc))));else{e=c.c?c.c.i:null;r4(a,XBb(a,e))}}else{ppb();!!b&&(b.n==ufc||b.n==jec||b.n==gdc)&&!!b.c.c&&(Dqb(b.c)?r4(a,Bmb(a.a,H8b(b,(Hbc(),mbc)))):r4(a,XBb(a,b.c.c)))}}function teb(a,b,c){var d,e,f,g;f=c.c;e=f.f.Wh();if(seb(b,f)){C6(a.a,zPc,false);g=(ppb(),Gpb(c,new jrb));switch(e){case "iterator":{d=G9b(t3b(l3b(Wqb(a.a,"$jscomp.initSymbolIterator"),CE(xE(HU,1),IMc,
7,0,[]))),g);p8b(g.g,d,g);w7(a.a,d);break}case "asyncIterator":{d=G9b(t3b(l3b(Wqb(a.a,"$jscomp.initSymbolAsyncIterator"),CE(xE(HU,1),IMc,7,0,[]))),g);p8b(g.g,d,g);w7(a.a,d);break}}}}function Rpb(a){ppb();switch(a.n.f){case 48:return Afc(),Tcc;case 49:return Afc(),Ucc;case 50:return Afc(),Rcc;case 51:return Afc(),kec;case 52:return Afc(),Wec;case 53:return Afc(),tfc;case 54:return Afc(),vcc;case 55:return Afc(),efc;case 56:return Afc(),qec;case 59:return Afc(),zdc;case 57:return Afc(),pdc;case 58:return Afc(),
oec}throw gZ(new qnb("Not an assignment op:"+a));}function yhc(a,b,c,d){var e,f,g,h,i,j,k;if(!!a.Li()&&joc(a.Li(),b))return Onc(a.ki(),b.ki(),c,d,0);k=skc(d,a,b);if(k)return k.a;i=Bhc(a);j=Bhc(b);if(!gh(j,i)){tkc(d,a,b,(Hkc(),Fkc));return false}for(h=(f=(new Yvc(i.a)).a.He().b.vj(),new ewc(f));h.a.Id();){g=(e=h.a.Jd(),e.Ve());if(!Qfc(b.Wi(g),a.Wi(g),c,d)){tkc(d,a,b,(Hkc(),Fkc));return false}}tkc(d,a,b,(Hkc(),Ekc));return true}function vhb(a,b,c){var d,e,f,g,h,i,j,k;k=g9b(b);d=g9b(b);i=g9b(b);f=d.c?
new pib(a.a):null;j=!i?null:new pib(a.a);g=Thb(a.a,c);Lhb(a.a,f,j,k);thb(a,k,null,null);if(!i)Shb(a.a,f,g,k);else{cib(a.a,j);Khb(a.a,f,j,i);thb(a,i,null,null);Rhb(a.a,g,i)}if(d.c){Xd(d.c.n==(Afc(),adc));cib(a.a,f);h=z8b(d.c.c);Jhb(a.a,j,h);e=z8b(d.c.c);Xd(e.n==Vcc);thb(a,e,null,null);Qhb(a.a,j,e)}cib(a.a,g)}function uq(a,b,c,d){var e,f,g,h,i;i=yZ(rZ(VLc,Vrc(yZ(rZ(b==null?0:Db(b),WLc)),15)));e=yZ(rZ(VLc,Vrc(yZ(rZ(c==null?0:Db(c),WLc)),15)));h=xq(a,b,i);g=wq(a,c,e);if(!!h&&e==h.a&&Gd(c,h.g))return c;
else if(!!g&&!d)throw gZ(new qnb("key already present: "+c));!!h&&pq(a,h);!!g&&pq(a,g);f=new $q(c,e,b,i);rq(a,f,g);if(g){g.e=null;g.c=null}if(h){h.e=null;h.c=null}vq(a);return!h?null:h.g}function LE(a,b,c,d,e,f){var g,h,i,j,k,l,m;j=OE(b)-OE(a);g=YE(b,j);i=HE(0,0,0);while(j>=0){h=RE(a,g);if(h){j<22?(i.l|=1<<j,undefined):j<44?(i.m|=1<<j-22,undefined):(i.h|=1<<j-44,undefined);if(a.l==0&&a.m==0&&a.h==0)break}k=g.m;l=g.h;m=g.l;g.h=l>>>1;g.m=k>>>1|(l&1)<<21;g.l=m>>>1|(k&1)<<21;--j}c&&NE(i);if(f)if(d){EE=
XE(a);e&&(EE=_E(EE,(iF(),gF)))}else EE=HE(a.l,a.m,a.h);return i}function Wqb(a,b){ppb();var c,d,e,f,g,h,i;c=Hsc(b,_sc(46));if(c==-1)return Vqb(a,b);f=b.substr(0,c);Esc(FMc,f)?e=new J9b((Afc(),lfc)):Esc(DMc,f)?e=new J9b((Afc(),ffc)):e=Vqb(a,f);do{i=c+1;c=Isc(b,_sc(46),i);g=c==-1?b.substr(i):b.substr(i,c-i);h=(n8b(),new Wbc((Afc(),bfc),g));t9b(h,g.length);H6(a).Gg(g)&&b9b(h,a8b,true);d=e.e+1+g.length;e=x3b(e,h);e.e=d}while(c!=-1);return e}function PBb(a,b){var c,d,e,f,g,h,i,j;g=new CHc;for(f=(j=(new Wuc(qjc(b).a)).a.He().Vd(),
new avc(j));f.a.Id();){e=(c=f.a.Jd(),c.Ve());AHc(g,e.di(new stc,true).a)}for(i=(d=(new Yvc(g.a)).a.He().b.vj(),new ewc(d));i.a.Id();){h=(c=i.a.Jd(),c.Ve());a.a+=mRc;ptc(ptc(ptc(ptc((a.a+="@",a),NNc)," {"),h),"}");a.a+=gMc}b.f==(dkc(),bkc)&&b.e?(a.a+=" * @record\n",a):(a.a+=" * @interface\n",a)}function FVb(a){switch(DWb(a.g,0).e.f){case 76:case 29:case 9:case 99:case 14:case 2:case 108:case 109:case 110:case 111:case 64:case 69:case 18:case 97:case 100:case 45:case 47:case 49:case 63:case 68:case 94:case 95:case 101:case 107:case 104:case 35:case 21:case 77:case 98:case 24:case 26:case 44:return true;
case 34:return AVb(a,(AZb(),lYb))&&zVb(a,1,GYb);default:return false}}function o2b(a){var b,c;if(a.a==null)return j2b(a,jLc,0);if(pF(a.a,186))return j2b(a,etc(a.a),0);else if(pF(a.a,132)){b=Frc(a.a);if(!(b>=0&&b<=lMc))throw gZ(new _1b(b));c=b<kMc?String.fromCharCode(b&dLc):ftc((EKc(b>=0&&b<=lMc),b>=kMc?CE(xE(xF,1),eLc,46,15,[55296+(b-kMc>>10&mMc)&dLc,56320+(b-kMc&mMc)&dLc]):CE(xE(xF,1),eLc,46,15,[b&dLc])));return j2b(a,c,0)}else throw gZ(g2b(a));}function Ifc(a,b,c,d,e){var f,g,h,i,j,k;g=new kcc((Afc(),
Kdc),a);Sd(b);Sd(c);for(j=new TEc(new KEc(b));j.b!=j.c.a.b;){h=REc(j);f=K3b(h.d);q8b(g,Jfc(f,h.e))}for(i=new TEc(new KEc(c));i.b!=i.c.a.b;){h=REc(i);f=K3b(h.d);b9b(f,(n8b(),f8b),true);q8b(g,Jfc(f,h.e))}if(d!=null){k=new L9b(Sec,(ae(Hsc(d,_sc(46))==-1,HMc,d),n8b(),new Wbc(rec,d)));q8b(g,(!!e&&d9b(k,(Hbc(),Nac),e),k))}return g}function af(a){var b,c,d,e;c=a.c;while(a.c!=-1){e=c;d=a.le(a.c);if(d==-1){b=a.e.length;a.c=-1}else{b=d;a.c=a.ke(d)}if(a.c==c){++a.c;a.c>a.e.length&&(a.c=-1);continue}while(e<
b&&a.f.Md(zsc(a.e,e)))++e;while(b>e&&a.f.Md(zsc(a.e,b-1)))--b;if(a.d&&e==b){c=a.c;continue}if(a.b==1){b=a.e.length;a.c=-1;while(b>e&&a.f.Md(zsc(a.e,b-1)))--b}else--a.b;return Tsc(a.e,e,b)}return a.i=2,null}function P_(a,b){var c,d,e,f,g,h,i;switch(b.n.f){case 98:h=Cfc(b.n),h!=-1&&(d=C8b(b),h!=d&&D0(QMc+h+RMc+d,b));G_(a,b.c,true);break;case 159:e=C8b(b),0!=e&&D0(OMc+e,b);break;case 160:i=Cfc(b.n),i!=-1&&(f=C8b(b),i!=f&&D0(QMc+i+RMc+f,b));q_(b.c,0);break;case 161:g=Cfc(b.n),g!=-1&&(c=C8b(b),g!=c&&D0(QMc+
g+RMc+c,b));break;default:D0("Interface contained member of invalid type "+b.n,b)}}function uab(){uab=JZ;gab=new xab(xOc,0);hab=new xab(yOc,1);iab=new xab("ECMASCRIPT5_STRICT",2);kab=new xab("ECMASCRIPT_2015",3);jab=new xab("ECMASCRIPT6_TYPED",4);lab=new xab("ECMASCRIPT_2016",5);mab=new xab("ECMASCRIPT_2017",6);nab=new xab(zOc,7);oab=new xab(AOc,8);pab=new xab("ECMASCRIPT_NEXT",9);rab=new xab("STABLE",10);qab=new xab("NO_TRANSPILE",11);tab=new xab(BOc,12);sab=nab}function cGb(a,b){var c,d,e,f,g,h,
i,j,k,l;j=new DHc(new hGb);for(e=a.Vd();e.Id();){d=e.Jd();for(g=b.Vd();g.Id();){f=g.Jd();if(Esc(d.substr(0,f.length),f)){d=Usc(d,f.length);break}}h=Rsc(d,"/node_modules/",0);i="";for(c=0;c<h.length-1;c++){c+1<h.length&&(i+=h[c]+"/");j.a.Je(i,(Nqc(),Lqc))==null;i+=qRc}}return wt(),k=j.a.Pe(),!k&&(k=vt),Bt(k,(l=(new Yvc(j.a)).a.He().b.vj(),new ewc(l)))}function Rsc(a,b,c){var d,e,f,g,h,i,j,k;d=new RegExp(b,"g");j=zE(nW,uNc,2,0,6,1);e=0;k=a;g=null;while(true){i=d.exec(k);if(i==null||k==""||e==c-1&&c>
0){j[e]=k;break}else{h=i.index;j[e]=k.substr(0,h);k=Vsc(k,h+i[0].length,k.length);d.lastIndex=0;if(g==k){j[e]=k.substr(0,1);k=k.substr(1)}g=k;++e}}if(c==0&&a.length>0){f=j.length;while(f>0&&j[f-1]=="")--f;f<j.length&&(j.length=f)}return j}function XGb(){XGb=JZ;new Mcb("JSC_NON_DECLARATION_STATEMENT_IN_RECORD",(E2(),C2),new Rtc("@record functions should not contain statements other than field declarations"));VGb=new Mcb("JSC_INTERFACE_FUNCTION_NOT_EMPTY",C2,new Rtc("interface functions must have an empty body"));
WGb=new Mcb("JSC_INTERFACE_SHOULD_NOT_TAKE_ARGS",C2,new Rtc("Interface functions should not take any arguments"))}function Crc(a,b){var c,d,e,f,g;if(a==null)throw gZ(new usc(jLc));if(b<2||b>36)throw gZ(new usc("radix "+b+" out of range"));e=a.length;f=e>0&&(a.charCodeAt(0)==45||a.charCodeAt(0)==43)?1:0;for(c=f;c<e;c++)if(Uqc(a.charCodeAt(c),b)==-1)throw gZ(new usc(ITc+a+'"'));g=parseInt(a,b);d=g<hMc;if(isNaN(g))throw gZ(new usc(ITc+a+'"'));else if(d||g>_Kc)throw gZ(new usc(ITc+a+'"'));return g}function rMb(a,
b){var c,d,e,f,g,h;switch(b.p.f){case 33:c=b;f=c.c;e=c.b;d=true;break;case 34:h=b;f=h.d;e=h.b;d=true;break;case 1:g=b;f=g.k;e=g.i;d=g.f||g.e;break;default:return false}if(e)return false;if(f.e!=(AZb(),iYb)||!Esc(f.a,LMc))return false;if(d){a.a.d.Ah("Class constructor may not be getter, setter, async, or generator.",a.a.q,(RJb(),b.o.b.b+1),b.o.b.a);return false}return true}function Jjc(a,b,c){var d,e,f,g,h,i,j,k,l;Sd(b);e=new ukc(false);if(Qfc(a,b,0,e))return a;if(a.f==(dkc(),ckc)&&b.f==ckc&&!ehc(a.b)&&
!ehc(b.b)){i=a.zi(b);j=b.zi(a);if(i&&!j)return c?b:a;else if(j&&!i)return c?a:b;l=Kjc(a,b,c);if(l)return l}g=a.A.u[17];f=new ukc(false);if(Qfc(g,b,0,f))return c?b:a;else{d=new ukc(false);if(Qfc(g,a,0,d))return c?a:b}h=a.A.u[62];k=a.A.u[64];return c?h:k}function LWb(a,b,c){var d,e;e=false;while(xWb(a,a.f)&&(xWb(a,a.f)?zsc(a.b,a.f):0)!=c&&!mXb(xWb(a,a.f)?zsc(a.b,a.f):0)){d=xWb(a,a.f)?zsc(a.b,a.f):0;e=e||d==8232||d==8233;if(!aXb(a))return new tXb(Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f),e)}(xWb(a,a.f)?zsc(a.b,
a.f):0)!=c?EWb(a,ZSb(a.i.b,b),"Unterminated string literal",CE(xE(iW,1),mLc,1,5,[])):yWb(a);return new tXb(Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f),e)}function ZEb(){ZEb=JZ;new Mcb("JSC_MODULE_CONFLICT",(E2(),D2),new Rtc("File cannot be a combination of goog.provide, goog.module, and/or ES6 module: {0}"));YEb=new Mcb("JSC_JS_MODULE_LOAD_WARNING",B2,new Rtc('Failed to load module "{0}"'));XEb=new Mcb("JSC_INVALID_MODULE_PATH",B2,new Rtc('Invalid module path "{0}" for resolution mode "{1}"'));WEb=new aFb((Bn(),
Bn(),An),(null,An),(nEb(),mEb))}function OOb(a){var b,c,d,e;c=_Ib(gJb(dJb(eJb(bJb(hJb(aJb(fJb(cJb(gJb(dJb(new iJb,(zJb(),xJb)),(KJb(),JJb)),(mJb(),lJb)),(FJb(),EJb)),WIb((bn(),mz(),lz))),(null,lz)),(null,lz)),false),rJb),IJb));e=COb(a.b,a.f,c,a.a);b=e.a;if(b.n!=(Afc(),Xec)||b.c.n!=Ddc){a.a.Bh(URc+occ(kSc,CE(xE(iW,1),mLc,1,5,[lSc])),a.b.ug(),a.d,a.c);return false}d=b.c.c;if(!gPb(a,d))return false;KOb(a,d);a.e=d;return true}function gC(b,c,d){var e,f,g,h,i,j;!d&&(d=new kC);try{if(c.c>=0||c.d!=null||
c.g!=null||c.e!=null)throw gZ(new rD("Invalid map format"));f=new PC;for(j=c.f.Vd();j.Id();){i=j.Jd();g=i.d;i.c==0&&(g=null);if(g==null)throw gZ(new rD("Unable to retrieve: "+i.d));NC(f,i.b,i.a,g)}h=new stc;KC(f,h,c.b);fC(b,h.a)}catch(a){a=fZ(a);if(pF(a,104)){e=a;throw gZ(new rD("IO exception: "+e));}else throw gZ(a);}}function dPb(a,b){var c,d;d=(Pd(b.n==(Afc(),Ycc),iSc,b),b.c.Wh());c=PPb($b(d));switch(c.f){case 19:return bPb(a,b);case 22:return jPb(a,b);case 11:return JOb(a,b,(NPb(),APb));case 0:return JOb(a,
b,(NPb(),pPb));case 23:return JOb(a,b,(NPb(),MPb));case 14:return ZOb(a,b);case 18:return cPb(a,b);case 17:return _Ob(a,b);case 20:return VOb(a,b);default:throw gZ(new Irc("Invalid type expression"));}}function RB(a,b,c){var d,e,f,g,h,i;Sd(c);if(b==0)throw gZ(new Dqc("/ by zero"));f=a/b|0;h=a-b*f;if(h==0)return f;i=1|(a^b)>>31;switch(c.f){case 7:UB(h==0);case 1:g=false;break;case 0:g=true;break;case 2:g=i>0;break;case 3:g=i<0;break;case 6:case 5:case 4:d=$wnd.Math.abs(h);e=d-($wnd.Math.abs(b)-d);
e==0?g=c==(Itc(),Ftc)||c==Etc&(f&1)!=0:g=e>0;break;default:throw gZ(new Jqc);}return g?f+i:f}function Z6(a){var b,c,d,e,f;(new puc(a.u.a)).a.Rd();for(e=new wxc(a.k);e.a<e.c.a.length;){c=(e.b=e.a++,e.c.a[e.b]);b=c.i;f=(c.b=a,PHc(a.u,b,c));!!f&&u7(a,new Gmb(null,null,-1,-1,n6,null,CE(xE(nW,1),uNc,2,6,[c.i.a])))}for(d=new Tu(wu($t(Tt(Wt(new eyc(a.B.a),new lnb)).a),new Xt));Ru(d);){c=Su(d);b=c.i;f=(c.b=a,PHc(a.u,b,c));!!f&&u7(a,new Gmb(null,null,-1,-1,o6,null,CE(xE(nW,1),uNc,2,6,[c.i.a])))}}function enb(a){var b,
c,d,e,f,g,h;h=new fxc;for(g=0;g<a.a.length;++g){f=a.a[g];ae(f.b==-1,"Module depth already set: %s",f);e=0;for(c=In(f.a).Vd();c.Id();){b=c.Jd();d=b.b;if(d<0)throw gZ(new tnb(x2b("Modules not in dependency order: %s preceded %s",CE(xE(iW,1),mLc,1,5,[f.e,b.e])),f,b));e=$wnd.Math.max(e,d+1)}Nd(e>=0,"invalid depth: %s",e);f.b=e;e==h.a.length&&Ywc(h,new fxc);h.a[e].Pd(f)}return h}function vqb(a){ppb();var b;switch(a.n.f){case 29:case 26:case 27:break;default:return false}b=a.g;if(!b)return false;switch(b.n.f){case 107:return(b.c?
b.c.i:null)==a;case 76:case 100:case 88:case 114:case 45:case 105:case 63:case 64:case 78:return true;case 96:case 65:case 121:case 72:case 73:case 101:case 102:return b.c==a;case 93:case 91:case 116:return xqb(a);default:return aqb(b)&&b.c==a}}function uHb(){uHb=JZ;sHb=new Mcb("JSC_NULLABLE_RETURN",(E2(),C2),new Rtc("This function''s return type is nullable, but it always returns a non-null value. Consider making the return type non-nullable."));tHb=new Mcb("JSC_NULLABLE_RETURN_WITH_NAME",C2,new Rtc('The return type of the function "{0}" is nullable, but it always returns a non-null value. Consider making the return type non-nullable.'))}
function Khb(a,b,c,d){var e,f,g;$hb(a,b,c);f=Ohb(a);g=swc(a.k)?null:qwc(a.k);e=new fxc;if(a.o==0){if(!!f||!!g){Ywc(e,!f?F9b(Yjb((n8b(),new tac(0)),a.r.f.e),d):mib(f,d));!!g&&Ywc(e,mib(g,d))}}else{Ywc(e,!f?F9b(Yjb((n8b(),new tac(0)),a.r.f.e),d):mib(f,d));Ywc(e,!g?F9b(Yjb((n8b(),new tac(0)),a.r.f.e),d):mib(g,d));Ywc(e,F9b(O3b(a.o),d))}eib(a,Dhb(a,d,"enterFinallyBlock",exc(e,zE(HU,IMc,7,0,0,1))));++a.o}function Msb(){Msb=JZ;Jsb=new Mcb("JSC_FEATURES_NOT_SUPPORTED_BY_PASS",(E2(),B2),new Rtc('Attempted to run pass "{0}" on input with features it does not support. {1}\nUnsupported features: {2}'));
Lsb=RIc((drc(EO),EO.p));Ksb=(Bn(),new hz(Qn(CE(xE(iW,1),mLc,1,5,["inlineFunctions",uOc,"deadAssignmentsElimination",tOc,"removeUnusedCode",wOc,vOc,FQc,GQc]))));Isb=new hz(Qn(CE(xE(iW,1),mLc,1,5,[FQc,GQc])))}function DLb(a,b){var c,d,e,f,g,h,i,j;f=new tEc;c=new tEc;g=null;h=null;if(WKb(a,b.a.a))for(e=b.a.a.Vd();e.Id();){d=e.Jd();i=null;if(d.p==(n1b(),a1b)){j=d;i=yKb(a.a,j.b);d=j.a}switch(d.p.f){case 26:qEc(f,d.a.a,i);break;case 81:gLb(a,d,(IRb(),qRb));qEc(c,d.a.a.a,i);break;case 65:g=d.a.a.a;h=i;break;
default:throw gZ(new Irc("Illegal parameter type: "+d.p));}}return SJb(a.a,Ifc(yKb(a.a,b.b),f,c,g,h))}function F6(a,b,c,d,e,f,g,h){var i,j,k,l,m,n;if(!d.Wd(b)){c&&b.j==(b9(),a9)&&D8(b,(b9(),$8));return}j=new Ckb(a,g,h);Bkb(j,Sd(x8(b,a)));c&&b.j==(b9(),a9)&&D8(b,(b9(),$8));_tc(a.D,UFb(z8(b).a),b.j);i=Dm(CE(xE(cW,1),mLc,15,0,[xDb(A8(b)),In(b.d),y8(b).i]));for(n=new Tu(new Lm(i.a.length,i.a));Ru(n);){m=Su(n);l=null;k=false;if(f.se(m))l=f.Ie(m);else if(e.se(m)){k=true;l=e.Ie(m)}!!l&&F6(a,l,k,d,e,f,g,
h)}}function rjc(a,b){var c,d,e,f,g,h,i,j;g=!b;d=Hic(Dic(new Lic(a.A),b?a.b.b:(c=Hic(Dic(new Lic(a.A),a.b.b),a.B.c),uic(c))),a.B.c);h=a.b.a;if(h){i=x8b(h,false);j=(n8b(),new Wbc((Afc(),rec),"thisType"));r9b(j,Skc(a.A,Yfc(a.k)?a.A.u[51]:a.k));r8b(i,j);if(g)for(e=j.f;e;e=e.f)c9b(e,(Hbc(),qbc),1);else if(b){f=j.f;(!f||E8b(f,(Hbc(),qbc))!=0||E8b(f,(Hbc(),Ebc))!=0)&&c9b(j,(Hbc(),qbc),1)}d.d=i}return uic(d)}function Trb(a,b){var c,d,e,f,g,h;Yd(a.n==(Afc(),Jdc),a);ppb();if(a.n==Jdc&&iqb(a.g)&&a.n==Jdc&&
Gqb(a.c)&&!sqb(a)){e=a.c;f=e.Sh(false);g=F9b(r3b(f,ufc),a);e._h("");s7(b,G6(e));i7(b);h=a.g;e9b(h,a);r8b(h,g);s7(b,G6(g));i7(b);r8b(f,a);return true}else if(a.n==Jdc&&(Ld(a.n==Jdc,a),a.c?a.c.i:null).n!=Vcc){d=(Ld(a.n==Jdc,a),a.c?a.c.i:null);c=j3b(S3b(z8b(d)));I9b(c,d);q8b(a,c);s7(b,G6(c));i7(b)}return false}function h0(a,b,c){var d,e,f;F_(a,(IRb(),lRb),c);b0((Afc(),Fec),c);for(d=c.c;d;d=d.f)switch(d.n.f){case 91:i0(a,b,d);break;case 114:F_(a,nRb,d);m0(a,b,d);break;case 116:F_(a,PQb,d);b0(fdc,d);e=
Cfc(d.n);e!=-1&&(f=C8b(d),e!=f&&D0(QMc+e+RMc+f,d));E_(a,d.c);(d.c?d.c.i:null).n==mdc?x_(a,b,d.c?d.c.i:null):R_(a,(d.c?d.c.i:null).n,d.c?d.c.i:null);break;default:D0("Invalid object pattern child for "+b+TMc,c)}}function UTb(a){var b,c,d,e,f;c=false;d=(Bn(),new Zr);while(true){e=DWb(a.g,0).d.b;switch(DWb(a.g,0).e.f){case 4:iTb(a,(AZb(),GXb));b=xTb(a,1);iTb(a,NXb);f=kVb(a);Xr(d,new WZb(new Z1b(e,a.f),b,f));break;case 8:c?VVb(a,"Switch statements may have at most one default clause",CE(xE(iW,1),mLc,
1,5,[])):c=true;iTb(a,(AZb(),TXb));iTb(a,NXb);Xr(d,new s$b(new Z1b(e,a.f),kVb(a)));break;default:return In(d.a)}}}function C2b(a,b){var c,d,e;e=a.b;c=a.b<a.c?zsc(a.a,a.b):-1;if(c>=48&&c<=57){d=B2b(a);if((a.b<a.c?zsc(a.a,a.b):-1)==36){z2b(a);if(d==-1)throw gZ(new e2b(Vsc(a.a,a.d,a.b)));K2b(b,$wnd.Math.max(0,d-1))}else if(c==48)a.b=e;else return F2b(a,b,d)}else if(c==60){b.a=-2;z2b(a)}while(L2b(b,a.b<a.c?zsc(a.a,a.b):-1))z2b(a);c=a.b<a.c?zsc(a.a,a.b):-1;return c>=48&&c<=57?F2b(a,b,B2b(a)):c==46?E2b(a,
b):D2b(a,b)}function Gbb(a){var b,c,d;if("".length>0){if(!Kbb(a.a,"".charCodeAt(0))){b=zE(xF,eLc,46,a.a.length,15,1);for(c=0;c<b.length;c++)b[c]=a.a[c].a;throw gZ(new qnb("prefix must start with one of: "+Yxc(b)));}for(d=1;d<"".length;++d){b=zE(xF,eLc,46,a.c.length,15,1);for(c=0;c<b.length;c++)b[c]=a.c[c].a;if(!Kbb(a.c,"".charCodeAt(d)))throw gZ(new qnb("prefix has invalid characters, must be one of: "+Yxc(b)));}}}function PGb(){PGb=JZ;MGb=new Mcb("JSC_DUPLICATE_ENUM_VALUE",(E2(),C2),new Rtc("The value {0} is duplicated in this enum."));
LGb=new Mcb("JSC_COMPUTED_PROP_NAME_IN_ENUM",C2,new Rtc("Computed property name used in enum."));OGb=new Mcb("JSC_SHORTHAND_ASSIGNMENT_IN_ENUM",C2,new Rtc("Shorthand assignment used in enum."));NGb=new Mcb("JSC_ENUM_PROP_NOT_CONSTANT",C2,new Rtc("enum key {0} must be in ALL_CAPS."))}function LKb(a){switch(a){case 48:return 0;case 49:return 1;case 50:return 2;case 51:return 3;case 52:return 4;case 53:return 5;case 54:return 6;case 55:return 7;case 56:return 8;case 57:return 9;case 97:case 65:return 10;
case 98:case 66:return 11;case 99:case 67:return 12;case 100:case 68:return 13;case 101:case 69:return 14;case 102:case 70:return 15;default:throw gZ(new Irc(QRc+String.fromCharCode(a)));}}function _Ub(a){var b,c,d,e,f,g;f=DWb(a.g,0).d.b;e=lTb(a);b=mTb(a,(AZb(),NXb));if(!b)if(e.e!=iYb)SVb(a,DWb(a.g,0),SSc,CE(xE(iW,1),mLc,1,5,[NXb]));else if(TSb(e.a,false))SVb(a,e,"Cannot use keyword in short object literal",CE(xE(iW,1),mLc,1,5,[]));else if(zVb(a,0,ZXb)){d=new c_b(new Z1b(f,a.f),e);iTb(a,ZXb);c=KTb(a,
1);return new t$b(new Z1b(f,a.f),d,c)}g=!b?null:KTb(a,1);return new r1b(new Z1b(f,a.f),e,g)}function osb(){osb=JZ;new Mcb("JSC_INVALID_GETELEM_INDEX_ERROR",(E2(),D2),new Rtc("Array index not integer: {0}"));msb=new Mcb("JSC_INDEX_OUT_OF_BOUNDS_ERROR",D2,new Rtc("Array index out of bounds: {0}"));nsb=new Mcb("JSC_NEGATING_A_NON_NUMBER_ERROR",D2,new Rtc("Can''t negate non-numeric value: {0}"));lsb=new Mcb("JSC_FRACTIONAL_BITWISE_OPERAND",D2,new Rtc("Fractional bitwise operand: {0}"));$wnd.Math.pow(2,
53)}function tsc(){tsc=JZ;var a;psc=CE(xE(yF,1),iMc,46,15,[-1,-1,30,19,15,13,11,11,10,9,9,8,8,8,8,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5]);qsc=zE(yF,iMc,46,37,15,1);rsc=CE(xE(yF,1),iMc,46,15,[-1,-1,63,40,32,28,25,23,21,20,19,19,18,18,17,17,16,16,16,15,15,15,15,14,14,14,14,14,14,13,13,13,13,13,13,13,13]);ssc=zE(zF,{3:1,646:1},46,37,14,1);for(a=2;a<=36;a++){qsc[a]=vF($wnd.Math.pow(a,psc[a]));ssc[a]=kZ(LLc,qsc[a])}}function wo(a){oo();var b,c,d,e,f,g,h,i,j;if(pF(a,134)&&!pF(a,364)){g=a;return g}else if(pF(a,
201)){f=a;for(e=new BCc((new vCc(f)).a);$Cc(e.a);){d=(e.b=_Cc(e.a),new GCc(e.c,e.b));Sd(d.a);Sd(d.b.b[d.a.f])}i=Sr(new lCc(f));return i}j=a.Yd();switch(j){case 0:return no;case 1:d=tu(a.He().Vd());return Ho(d.Ve(),d.We());default:h=new tEc;for(c=a.He().Vd();c.Id();){b=c.Jd();qEc(h,Sd(b.Ve()),Sd(b.We()))}return new jz(h)}}function fdb(a,b,c){var d,e,f;Xd(b.n==(Afc(),ffc));e=b;(e.g.n==Odc||e.g.n==Pdc)&&(e=e.g);d=Gpb(e,new ndb);if(c.n==Ycc)gdb(a,b,c,d);else if(c.n==Pdc||c.n==Odc)c.c==b?c.g.n==Ycc&&(ppb(),
f=c.g,!!f&&(f.n==Ycc||f.n==xec||f.n==hfc)&&f.c==c)?idb(a,b,c,d):hdb(a,b,c,d):u7(a.a,Lmb(b,(Rjb(),Qjb),CE(xE(nW,1),uNc,2,6,[cPc])));else if(c.n==xec)throw gZ(new Irc(dPc));else u7(a.a,Lmb(b,(Rjb(),Qjb),CE(xE(nW,1),uNc,2,6,[cPc])))}function wab(a){switch(a.f){case 0:return iQb(),YPb;case 1:case 2:return iQb(),ZPb;case 3:return iQb(),_Pb;case 5:return iQb(),bQb;case 6:return iQb(),dQb;case 7:return iQb(),VPb;case 8:return iQb(),XPb;case 9:case 11:return iQb(),eQb;case 12:return iQb(),fQb;case 4:return iQb(),
gQb;case 10:throw gZ(new ztc("STABLE has different feature sets for language in and out. Use STABLE_IN or STABLE_OUT."));}throw gZ(new Hrc);}function yNb(a,b){switch(b.f){case 13:return"@"+a.j.n;case 19:return"!";case 11:return",";case 12:return":";case 3:return">";case 5:return"[";case 7:return"{";case 9:return"(";case 2:return"<";case 17:return"?";case 14:return"|";case 6:return"]";case 8:return"}";case 10:return")";case 15:return"*";case 18:return HNc;case 20:return"=";case 4:return a.j.n;default:throw gZ(new Irc(b.e!=
null?b.e:""+b.f));}}function Hlb(a,b){var c,d,e;switch(b.g.f){case 0:!a.d&&(a.d=b);!a.f&&(a.f=Jlb(b));++a.i;break;case 1:++a.j;c=!b.c?null:(ppb(),d=Dpb(b.c),!d?null:H8b(d,(Hbc(),mbc)));!!c&&(c.a&hQc)!=0&&++a.k;break;case 2:case 4:e=b.c;!a.g&&!!e&&e.n==(Afc(),Pdc)&&e.g.n==(Afc(),Ddc)&&(a.g=H8b(e,(Hbc(),mbc)));++a.s;break;case 3:++a.a;++a.s;break;case 5:++a.c;++a.s;break;case 6:++a.e;break;case 7:++a.r;++a.s;break;default:throw gZ(new Hrc);}}function WTb(a,b,c){var d,e,f,g,h,i,j,k;h=DWb(a.g,0).d.b;
iTb(a,(AZb(),IXb));g=null;(!b||(k=DWb(a.g,0).e,iYb==k||a.b.d&&VSb(k)||!a.b.c&&USb(k)))&&(g=jTb(a));e=tTb(a);i=null;if(AVb(a,cYb)){iTb(a,cYb);i=xTb(a,1)}f=(Bn(),new Zr);if(a.b.d&&AVb(a,kYb)){iTb(a,kYb);j=nVb(a);Ywc(f.a,Sd(j));while(AVb(a,OXb)){iTb(a,OXb);j=nVb(a);!!j&&(Ywc(f.a,Sd(j)),f)}}iTb(a,FYb);d=YTb(a,c);iTb(a,KXb);return new YZb(new Z1b(h,a.f),g,e,i,In(f.a),d)}function G_(a,b,c){var d,e,f,g,h,i,j,k;b0((Afc(),Jdc),b);f=Cfc(b.n);f!=-1&&(e=C8b(b),f!=e&&D0(QMc+f+RMc+e,b));k0(a,b.c.f);g=b.c;d=b.c?
b.c.i:null;if(b.n==Jdc&&E8b(b,(Hbc(),Fac))!=0){b0(rec,g);c0(g)&&g.Wh().length!=0&&D0("Expected empty string.",g);h=Cfc(g.n);h!=-1&&(i=C8b(g),h!=i&&D0(QMc+h+RMc+i,g));d.n==Vcc?n_(a,d):E_(a,d)}else{b0(rec,g);c0(g);j=Cfc(g.n);j!=-1&&(k=C8b(g),j!=k&&D0(QMc+j+RMc+k,g));c?b0(tdc,d):n_(a,d)}H_(a,b)}function cPb(a,b){var c;if(!JOb(a,b,(NPb(),HPb)))return false;if(!gPb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)))){mPb(a,HPb.d);return false}if((Pd(b.n==Ycc,iSc,b),B8b(b,2)).n!=Cec){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),
mLc,1,5,[qLc])),a.b.ug(),a.d,a.c);mPb(a,HPb.d);return false}c=(Pd(b.n==Ycc,iSc,b),B8b(b,2)).Uh();if(c<0||c%1!=0){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,[qLc])),a.b.ug(),a.d,a.c);mPb(a,HPb.d);return false}return true}function N9b(a,b,c){n8b();Ld(!b.g,"first new child has existing parent");Ld(!b.f,"first new child has existing next sibling");Ld(!b.i,"first new child has existing previous sibling");Ld(!c.g,"second new child has existing parent");Ld(!c.f,"second new child has existing next sibling");
Ld(!c.i,"second new child has existing previous sibling");this.n=a;this.g=null;this.c=b;b.f=c;b.i=c;b.g=this;c.f=null;c.i=b;c.g=this;this.k=-1}function Dpb(a){ppb();var b,c;if(a.n==(Afc(),Ddc))return Dpb(a.c);b=H8b(a,(Hbc(),mbc));if(!b){c=a.g;if(!c||a.n==Ddc)return null;if(c.n==rec)return Dpb(c);else if(c.n==Ccc)return Dpb(c);else if(Sqb(c)||c.n==fdc)return c;else if((c.n==Jdc||c.n==bdc)&&a==c.c)return Dpb(c);else if(!!c&&(c.n==ufc||c.n==jec||c.n==gdc)&&!!c.c&&!c.c.f)return c;else if(c.n==Sdc&&c.c!=
a||c.n==Hec||c.n==wcc||c.n==edc&&c.c!=a)return Dpb(c)}return a}function Mub(a,b,c){var d,e,f,g;Sd(c);Xd(c.n==(Afc(),zfc));Xd(!!b&&!!b.a);Xd(S8b(b.a));d=g9b(c);e=(g=M3b(b_((Kob(a),NQc)),CE(xE(HU,1),IMc,7,0,[])),g);if(E8b(c,(Hbc(),Gbc))!=0){Sd(d);q8b(e,b_((Kob(a),"$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR")));q8b(e,d)}else{!d&&(d=(ppb(),f=$3b((n8b(),new tac(0))),f));q8b(e,b_((Kob(a),"$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE")));q8b(e,d)}I9b(e,c);r8b(c,e);h9b(c,(n8b(),m8b))}function Mtb(a,
b){Itb();if(a.n==(Afc(),Ycc)&&!!a.c&&!!a.c.f&&a.c.f==(a.c?a.c.i:null))if(b==(NFb(),MFb)&&(_8b(a.c,"__webpack_require__")||_8b(a.c,"__webpack_require__.t"))&&(a.c.f.n==Cec||a.c.f.n==bfc))return true;else{if(_8b(a.c,lNc)&&a.c.f.n==bfc)return true}else if(a.n==Ycc&&C8b(a)==3&&b==(NFb(),MFb)&&_8b(a.c,"__webpack_require__.bind")&&a.c.f.n==Aec&&((a.c?a.c.i:null).n==Cec||(a.c?a.c.i:null).n==bfc))return true;return false}function Ntb(a){var b,c,d,e;Kd(a.n==(Afc(),Jdc));if(!a.g)return false;d=a.g;if(d.n!=
Ycc)return false;if(!(!!d.c&&d.c.n==Pdc&&d.c.c.n==Ycc))return false;e=d.c.c.c;if(a9b(e,JQc,JQc.length)&&d.c.c.f.n==bfc&&Esc(d.c.c.f.Wh(),"then"))return true;else if(a9b(e,KQc,KQc.length)&&!!e.f&&e.f.n==zcc){b=false;for(c=e.f.c;c;c=c.f){if(!(c.n==Ycc&&!!c.c&&!!c.c.f&&c.c.f==(c.c?c.c.i:null)&&_8b(c.c,JQc)))return false;b=true}return b}return false}function Awb(a,b){var c,d,e,f,g,h,i;if(!b)return!a?0:1;if(a.b!=b.b)return ee(b.b,a.b);g=a.a.f;h=b.a.f;if(g!=null&&h!=null){i=Asc(g,h);if(i!=0)return i}else if(g==
null&&h!=null)return-1;else if(g!=null&&h==null)return 1;e=a.a.d;f=b.a.d;if(e!=f)return e-f;else if(e<0&&0<=f)return-1;else if(0<=e&&f<0)return 1;c=a.a.a;d=b.a.a;if(c!=d)return c-d;else if(c<0&&0<=d)return-1;else if(0<=c&&d<0)return 1;return Asc(a.a.c,b.a.c)}function ROb(a,b){if(!JOb(a,b,(NPb(),qPb)))return false;if(!POb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[nSc])),a.b.ug(),a.d,a.c);return false}if(!gPb(a,(Pd(b.n==Ycc,iSc,b),B8b(b,2)))){a.a.Bh(URc+occ(mSc,
CE(xE(iW,1),mLc,1,5,[nSc])),a.b.ug(),a.d,a.c);return false}if(!gPb(a,(Pd(b.n==Ycc,iSc,b),B8b(b,3)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[nSc])),a.b.ug(),a.d,a.c);return false}return true}function hdb(a,b,c,d){var e,f,g,h,i;Yd(c.n==(Afc(),Pdc)||c.n==Odc,c);Yd(b.n==ffc,b);g=c.g;if(vqb(c)){u7(a.a,Lmb(c,(Rjb(),Qjb),CE(xE(nW,1),uNc,2,6,["assigning to a super property"])));return}e=(ppb(),Gpb(b,new frb(bdc)));i=e.c.f;if(!V8b(i))return;if(E8b(d,(Hbc(),zbc))!=0){f=G9b(x8b(i,false),b);d9b(f,sbc,DMc);j9b(b.g,
b,f)}else{h=Mc(new Pc(String.fromCharCode(46)),I8b(i),aNc,CE(xE(iW,1),mLc,1,5,[]));k9b(b,G9b(Xqb(a.a,h,b),b))}w7(a.a,g)}function WMb(a,b){var c;if(b==(fOb(),dOb))return QMb(a,(Afc(),afc));else if(b==WNb){xNb(a);return iNb(a,!a.o?mOb(a.j):GMb(a))}else if(b==XNb){xNb(a);return sNb(a,!a.o?mOb(a.j):GMb(a),null)}else if(b==eOb){c=a.j.n;switch(c){case ZKc:xNb(a);return aNb(a,!a.o?mOb(a.j):GMb(a));case jLc:case vPc:return RMb(a,c,a.j.g,lOb(a.j));case yQc:return rNb(a,!a.o?mOb(a.j):GMb(a));default:return pNb(a,
b)}}a.o=b;return CMb(a,_Rc,a.j.g,lOb(a.j)),null}function eNb(a,b){var c,d;if(b==(fOb(),WNb)){c=new mDc;while(true){if(OMb(a,eOb)){d=a.j.n;!vMb.Sd(d)&&!l6b(a.f,d)&&BMb(a,"msg.jsdoc.modifies.unknown",d,a.j.g,lOb(a.j));jDc(c,a.j.n);b=!a.o?mOb(a.j):GMb(a)}else{zMb(a,dSc,a.j.g,lOb(a.j));return b}if(OMb(a,ZNb))b=!a.o?mOb(a.j):GMb(a);else break}if(OMb(a,aOb)){b=!a.o?mOb(a.j):GMb(a);Y6b(a.f,c)||zMb(a,"msg.jsdoc.modifies.duplicate",a.j.g,lOb(a.j))}else zMb(a,dSc,a.j.g,lOb(a.j))}return b}function fhc(a,b,c,
d){var e,f,g,h,i,j,k,l,m,n;if(!pF(b,213))return false;f=b;if(!a.b.Ai(f.b,c,d))return false;m=a.a.c;i=f.a.c;while(!!m&&!!i){n=m.d;j=i.d;if(n)if(!j||!j.Ai(n,c,d))return false;l=E8b(m,(Hbc(),Ebc))!=0;h=E8b(i,Ebc)!=0;k=l||E8b(m,qbc)!=0;g=h||E8b(i,qbc)!=0;if(!k&&g){e=h&&(!j||j.Bi()||j.ti());if(!e)return false}l||(m=m.f);h||(i=i.f);if(l&&h){m=null;i=null}}return!m||E8b(m,(Hbc(),qbc))!=0||E8b(m,(Hbc(),Ebc))!=0||!!i}function kNb(a,b){var c,d;if(b!=(fOb(),WNb)){zMb(a,eSc,a.j.g,lOb(a.j));return b}else{d=new mDc;
while(true){if(OMb(a,eOb)){c=a.j.n;a.k.Sd(c)||BMb(a,"msg.jsdoc.suppress.unknown",c,a.j.g,lOb(a.j));jDc(d,a.j.n);b=!a.o?mOb(a.j):GMb(a)}else{zMb(a,eSc,a.j.g,lOb(a.j));return b}if(PMb(a,ZNb,PNb))b=!a.o?mOb(a.j):GMb(a);else break}if(OMb(a,aOb)){b=!a.o?mOb(a.j):GMb(a);n7b(a.f,d)}else zMb(a,eSc,a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a))}}function p1b(){n1b();return CE(xE(pT,1),sLc,19,0,[N0b,m0b,G_b,j1b,h1b,b0b,f0b,r0b,__b,k1b,j0b,l0b,i1b,X_b,H_b,R0b,l1b,K_b,Z_b,V0b,w0b,$0b,L_b,_0b,Y_b,Z0b,q0b,
x0b,A_b,I0b,O_b,Q_b,P_b,p0b,S0b,O0b,R_b,S_b,U_b,V_b,B0b,N_b,F_b,W_b,e1b,g1b,y0b,F0b,z_b,I_b,M_b,v0b,D0b,E0b,c0b,z0b,M0b,g0b,U0b,B_b,D_b,J0b,h0b,T0b,H0b,Q0b,C0b,d0b,e0b,s0b,t0b,k0b,i0b,m1b,$_b,W0b,X0b,Y0b,c1b,d1b,a1b,K0b,L0b,C_b,P0b,f1b,n0b,o0b,A0b,T_b,b1b,y_b,u0b,J_b,G0b,E_b,a0b])}function S2(){S2=JZ;R2=new Mcb("JSC_REGEXP_REFERENCE",(E2(),D2),new Rtc("References to the global RegExp object prevents optimization of regular expressions."));Q2=new Mcb("JSC_MALFORMED_REGEXP",D2,new Rtc("Malformed Regular Expression: {0}"));
tp("$1","$2","$3","$4","$5","$6",CE(xE(nW,1),uNc,2,6,["$7","$8","$9","$_","$input","input","lastMatch","lastParen","leftContext","rightContext",vNc,"ignoreCase","lastIndex","multiline","source"]))}function _6(a,b){var c,d;a.G=b;z7(a,wab(b.Sb));!a.g&&x7(a,new Znb((c=a.G.K,d=new Wnb(a),d.d=c,d),u6));a.C=(ZEb(),WEb);j9(a.G,(Hcb(),mcb))?a.G.w=true:i9(a.G,mcb)?a.G.w=false:a.G.w||h9(a.G,new gcb(ccb((kwb(),gwb)),(E2(),C2)));a.G.r!=(E2(),C2)&&!i9(a.G,scb)&&h9(a.G,new gcb(scb,a.G.r));k9(a.G)&&h9(a.G,new gcb(pcb,
B2));!a.G.v&&!j9(a.G,ncb)&&h9(a.G,new gcb(ncb,C2));a.G.ad&&!j9(a.G,ncb)&&h9(a.G,new gcb(ncb,C2));b.w||(b.ud=false);a7(a,b.wd)}function sfb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n;k=Kob(b);j=c.g;if((c.n==(Afc(),jec)||c.n==gdc)&&!d.c&&(!j||j.n!=Hdc)&&(e=Gpb(c,hfb),!!e&&e.n!=Jdc)){m=F9b((n=(ae(Hsc(vPc,_sc(46))==-1,HMc,vPc),n8b(),new Wbc(rec,vPc)),a.d&&r9b(n,U6(a.a).u[52]),n),d);r8b(d,m);w7(a.a,m)}h=d.Wh();f=e$(k);if(k!=f){g=h;if(k$(f,h)||kDc(a.e,h)){do g=h+"$"+(""+(new j8(a.a)).a.Q++);while(k$(f,g));d._h(g);
w7(a.a,d);l=k.d;Vp(a.c,l,h,g)}i=i$(k,h);l$(k,i);twb(f,g,d,i.a)}}function gMb(a,b){var c,d;if(b.a.Yd()==1){c=b.a.ce(0);switch(c){case "any":d=SJb(a.a,new jcc((Afc(),ycc)));break;case YKc:d=SJb(a.a,new jcc((Afc(),Dec)));break;case XKc:d=SJb(a.a,new jcc((Afc(),Wcc)));break;case $Kc:d=SJb(a.a,new jcc((Afc(),dfc)));break;case XNc:d=SJb(a.a,new jcc((Afc(),wfc)));break;case vPc:d=SJb(a.a,new jcc((Afc(),rfc)));break;default:d=SJb(a.a,Kfc(b.a))}}else d=SJb(a.a,Kfc(b.a));T9b(d.k)==-1&&vKb(d,b.o.b,b.o.a);return d}
function NVb(a){switch(DWb(a.g,0).e.f){case 45:case 25:case 30:case 52:case 15:case 10:case 27:case 13:case 6:case 3:case 19:case 28:case 20:case 22:case 23:case 7:case 44:case 2:case 108:case 109:case 110:case 111:case 21:case 29:case 35:case 100:case 101:case 107:case 104:case 97:case 98:case 94:case 95:case 99:case 49:case 47:case 18:case 9:case 26:case 24:case 68:case 69:case 63:case 64:case 77:case 76:return true;default:return false}}function gPb(a,b){var c,d;if(!(b.n==(Afc(),rec)||b.n==bfc||
b.n==Ycc)){a.a.Bh(URc+occ(kSc,CE(xE(iW,1),mLc,1,5,[lSc])),a.b.ug(),a.d,a.c);return false}if(b.n==rec||b.n==bfc)return true;d=(Pd(b.n==Ycc,iSc,b),b.c.Wh());if(!LOb(d)){a.a.Bh(URc+occ(kSc,CE(xE(iW,1),mLc,1,5,[lSc])),a.b.ug(),a.d,a.c);return false}c=PPb($b(d));switch(c.a){case 0:return dPb(a,b);case 1:return WOb(a,b);default:throw gZ(new Irc("Invalid type transformation expression"));}}function j2b(a,b,c){var d,e,f,g,h,i,j,k,l;j=c;k=a.b.p;h=a.b.n;d=btc(b);if(h>=0){d=$wnd.Math.min(d,h);pF(b,30)?(l=b.a.length,
d<l?b.a=Vsc(b.a,0,d):d>l&&(b.a+=ftc(zE(xF,eLc,46,d-l,15,1))),undefined):b=ctc(b,0,d)}k>0&&(k=$wnd.Math.max(btc(b),k));if(d>=k)return b;e=32;a.b.k?a.b.b==100?e=48:e=48:j=0;f=zE(xF,eLc,46,k-d,15,1);Lxc(f,f.length,e);g=a.b.f;i=pF(b,30)?b:new utc(b);g?(i.a+=gtc(f,0,f.length),i):rtc(i,j,gtc(f,0,f.length));return i}function U2b(a){var b,c,d,e,f,g,h,i;h=Rsc(a,"\r?\n",0);b=(oo(),new hs);for(e=0;e<h.length;++e){g=h[e];if(g.length==0||Esc(g.substr(0,1),"#")||Esc(g.substr(0,1),"!"))continue;c="";d=T2b(g);if(d==
-1)continue;f=Ysc(g.substr(0,d));g=V2b(g.substr(d+1));while(true){i="\\".length;if(Esc(g.substr(g.length-i,i),"\\")){c+=Vsc(g,0,g.length-1);if(e+1==h.length)break;g=V2b(h[++e])}else{c+=g;break}}Ywc(b.b,(el(f,c),new Wq(f,c)))}return new S2b(Co(b.b))}function Yfb(){Yfb=JZ;Xfb=rQb((iQb(),TPb),CE(xE(FR,1),sLc,24,0,[(IRb(),MQb),NQb,OQb,kRb]));Wfb=new Mcb("JSC_DYNAMIC_EXTENDS_TYPE",(E2(),B2),new Rtc("The class in an extends clause must be a qualified name."));Ufb=new Mcb("CLASS_REASSIGNMENT",B2,new Rtc("Class names defined inside a function cannot be reassigned."));
Vfb=new Mcb("CONFLICTING_GETTER_SETTER_TYPE",B2,new Rtc("The types of the getter and setter for property ''{0}'' do not match."))}function Hpb(a){var b,c,d;Yd(X8b(Sd(a)),a);c=Td(a.g,a);d=c.c==a;if(c.n==(Afc(),mdc)||c.n==Sec){Yd(d,c);a=c;c=Sd(a.g);d=a==c.c}switch(c.n.f){case 94:case 93:return c;case 116:Yd(!d,c);case 91:b=Td(c.g,c);Yd(b.n==Fec,b);return b;case 45:case 100:case 88:case 105:case 78:case 76:return null;case 65:case 96:Yd(d,a);return null;case 73:case 101:case 95:case 102:Yd(d,a);return null;
case 107:Yd(!d,c);return null;default:Yd(aqb(c)&&d,c);return null}}function QEb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;k=new oDc(REb(a,b,true));n=new mDc;o=new Ewc(k);while(o.b!=o.c){g=(d=vwc(o),d);i=k.a.se(g);e=i?g.ph():Dm(CE(xE(cW,1),mLc,15,0,[g.nh(),g.ph()]));if(!i&&(j=n.a.Je(g,n),j!=null))continue;for(m=e.Vd();m.Id();){l=m.Jd();f=Ytc(a.b,l);!!f&&!k.a.se(f)&&!n.a.se(f)&&(lwc(o,f),true)}}c=(Bn(),new Zr);for(h=new wxc(a.c);h.a<h.c.a.length;){g=(h.b=h.a++,h.c.a[h.b]);n.a.se(g)&&(Ywc(c.a,Sd(g)),c)}return In(c.a)}
function Hub(a,b){var c,d,e,f,g,h,i,j,k,l;Ld(b.n==(Afc(),Pdc),b);h=b.c;Ld(h.n==ffc,h);f=b.c?b.c.i:null;Ld(f.n==bfc,f);e=f.Wh();g=b.d;if(oEc(a.a,e)){i=pEc(a.a,e);d=i.a.d;ce(d==g||!!d&&!!g&&(c=new ukc(false),Qfc(d,g,0,c)),"Previous reference type: %s differs from current reference type: %s",d,g)}else{i=(Ld(b.n==Pdc,b),j=(b.c?b.c.i:null).Wh(),k=b.d,l="$jscomp$async$super$get$"+j,!k?null:uic(Dic(new Lic(a.b.c),k)),new Gub(b,l));qEc(a.a,e,i)}return i}function M3(a,b){var c,d,e,f,g,h;f=a.Xg();e=b==0&&1/
b<0;(b<0||e)&&f==45&&L3(a," ");if(e)L3(a,"-0");else if(xZ(mZ(b))==b){g=mZ(b);d=g;c=0;if($wnd.Math.abs(b)>=100)while(lZ(rZ(kZ(d,10),mZ($wnd.Math.pow(10,c+1))),g)){d=kZ(d,10);++c}if(c>2)L3(a,zZ(d)+"E"+c);else{h=iZ(g,0)<0?sZ(g):g;iZ(h,1E12)>0&&gsc(h,4).length+2<(""+zZ(h)).length?L3(a,(iZ(g,0)<0?"-":"")+"0x"+gsc(h,4)):L3(a,""+zZ(g))}}else L3(a,Qsc(Osc(""+b,".0E","E"),"^(-?)0\\.","$1."))}function TLb(a,b){var c,d,e,f,g,h,i,j,k;switch(b.p.f){case 74:return d=uLb(a,b),e=d.c,f=iKb(a.a,(Afc(),cfc),e.Wh()),
wKb(f,e),c9b(f,(Hbc(),kbc),1),q8b(f,d),f;case 35:return ULb(a,b);case 36:c=b;return bKb(a.a,c,(IRb(),PQb)),g=yKb(a.a,c.a),h=c.b,i=(h.p==(n1b(),$_b)?j=uLb(a,h):h.p==q0b?j=MLb(a,h.a):j=AKb(a.a,h),j),k=fKb(a.a,(Afc(),fdc),g,i),T9b(k.k)==-1&&vKb(k,c.o.b,c.o.a),k;default:Yd(b.p==(n1b(),D_b),b);bKb(a.a,b,(IRb(),nRb));return lLb(a,b)}}function $Tb(a,b,c){var d,e,f,g,h,i;f=DWb(a.g,0).d.b;iTb(a,b);d=(Bn(),new Zr);while(AVb(a,(AZb(),fYb))||AVb(a,jYb))AVb(a,fYb)?Xr(d,(g=DWb(a.g,0).d.b,iTb(a,fYb),iTb(a,GYb),
h=DWb(a.g,0).e,iYb==h||a.b.d&&VSb(h)||!a.b.c&&USb(h)?wUb(a):UUb(a,1),oTb(a,"of"),KTb(a,1),iTb(a,LXb),new h$b(new Z1b(g,a.f)))):Xr(d,(i=DWb(a.g,0).d.b,iTb(a,jYb),iTb(a,GYb),KTb(a,1),iTb(a,LXb),new i$b(new Z1b(i,a.f))));KTb(a,1);iTb(a,c);return new j$b((e=new Z1b(f,a.f),In(d.a),e))}function zWb(a){var b;a.f=a.d.a.length==0?a.f:DWb(a,0).d.b.c;a.d.a=zE(iW,mLc,1,0,5,1);b=a.f;yWb(a);if(!XWb(a))return new dTb((AZb(),VYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f));if((xWb(a,a.f)?zsc(a.b,a.f):0)!=47){FWb(a,"Expected '/' in regular expression literal",
CE(xE(iW,1),mLc,1,5,[]));return new dTb((AZb(),VYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f))}yWb(a);while(hXb(xWb(a,a.f)?zsc(a.b,a.f):0))yWb(a);return new dTb((AZb(),VYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f))}function oXb(b){var c,d,e,f;while(b.indexOf("\\")!=-1){e=Hsc(b,_sc(92));try{if(b.charCodeAt(e+1)!=117)return null;if(b.charCodeAt(e+2)!=123){d=e+6;f=b.substr(e+2,d-(e+2))}else{d=e+3;while(Uqc(b.charCodeAt(d),16)>=0)++d;if(b.charCodeAt(d)!=125)return null;f=b.substr(e+3,d-(e+3));++d}c=Crc(f,16)&dLc;if(!hXb(c))return null;
b=b.substr(0,e)+String.fromCharCode(c)+b.substr(d)}catch(a){a=fZ(a);if(pF(a,82)||pF(a,327))return null;else throw gZ(a);}}return b}function I4(a,b,c){switch(b.n.f){case 96:case 151:case 154:case 162:S3(a.c,c==(_4(),$4));break;case 65:(b.c?b.c.i:null).n==(Afc(),tdc)?a.c.Wg(true):a.c.Tg(c==(_4(),$4));break;case 158:b.g.n!=(Afc(),uec)&&I4(a,b.c,c);break;case 109:b.g.n!=(Afc(),uec)&&b.c.n!=kdc&&I4(a,b.c,c);break;case 116:!!b.c&&!b.c.f&&a.c.Wg(true);break;case 98:case 86:case 87:F8b(b.c).n==(Afc(),tdc)&&
a.c.Wg(true);break;case 159:a.c.Wg(true);break;default:c==(_4(),$4)&&a.c.Wg(false)}}function XMb(a,b){var c;if(b!=(fOb(),WNb)){zMb(a,"msg.jsdoc.missing.lc",a.j.g,lOb(a.j));return b}else if(OMb(a,eOb)){c=a.j.n;a.b.Sd(c)?u6b(a.f,c)||zMb(a,"msg.jsdoc.closurePrimitive.extra",a.j.g,lOb(a.j)):BMb(a,"msg.jsdoc.closurePrimitive.invalid",c,a.j.g,lOb(a.j));b=!a.o?mOb(a.j):GMb(a)}else{zMb(a,"msg.jsdoc.closurePrimitive.missing",a.j.g,lOb(a.j));return b}OMb(a,aOb)?b=!a.o?mOb(a.j):GMb(a):zMb(a,YRc,a.j.g,lOb(a.j));
return IMb(a,!a.o?mOb(a.j):GMb(a))}function KC(a,b,c){var d,e,f,g,h,i,j;g=OC(a)+1;b.a+="{\n";SC(b,"version",true);b.a+="3";c!=null&&RC(b,(uD(),xD(c)));SC(b,"lineCount",false);b.a+=""+g;SC(b,"mappings",false);UC(new WC(a,b,g));SC(b,"sources",false);b.a+="[";QC(b,a.k);b.a+="]";JC(a,b);SC(b,"names",false);b.a+="[";QC(b,a.g);b.a+="]";for(f=(i=(new Wuc(a.a)).a.He().Vd(),new avc(i));f.a.Id();){e=(d=f.a.Jd(),d.Ve());h=pEc(a.a,e);tF(h)?j=(uD(),xD(h)):j=NZ(h);SC(b,e,false);b.a+=""+j}b.a+="\n}\n"}function mlb(a,
b){var c,d,e;e=a;for(d=new iac(new eac(Sd(a.g)));d.a.a;){c=hac(d);switch(c.n.f){case 41:case 84:case 76:case 100:case 88:case 66:case 70:case 72:case 73:case 25:case 79:case 19:case 20:case 21:case 22:return cmb(),Zlb;case 60:if(c.c==e)return cmb(),Zlb;break;case 47:if(!_8b(c.c,b))return cmb(),Wlb;break;case 29:if(!Esc(b,c.Wh()))return cmb(),Wlb;break;case 28:if(c.c!=e)return cmb(),Wlb;break;case 24:return cmb(),Ylb}e=c}return cmb(),Wlb}function Ojb(a,b,c){var d,e,f,g,h,i,j,k;j=U6(a.c);k=Wjb(c,j,
45);i=C8b(b);if(i==0)k9b(b,Yjb((n8b(),new Wbc((Afc(),bfc),'""')),k));else{f=g9b(b);Xd(f.n==(Afc(),jfc)&&f.Th()!=null);g=Yjb(V3b(f.Th()),k);if(i==1)j9b(b.g,b,g);else{d=Yjb(e3b(g,g9b(g9b(b))),b.d);for(h=2;h<i;h++){e=g9b(b);if(e.n==jfc){Xd(e.Th()!=null);if(e.Th().length==0)continue;else h==2&&f.Th().length==0&&(d=z8b(d.c.f))}d=Yjb(e3b(d,e.n==jfc?Yjb(V3b(e.Th()),k):g9b(e)),b.d)}k9b(b,I9b(d,b))}}Vob(a)}function COb(b,c,d,e){var f,g,h,i,j,k,l,m,n,o,p,q,r;n=b.ug();try{j=new sXb(n,c);k=d.f==(FJb(),DJb);f=
new FOb(e,k);g=BOb(d);l=new YVb(g,f,j);p=(q=DWb(l.g,0).d.b,r=vUb(l),iTb(l,(AZb(),XXb)),new q1b(new Z1b(q,l.f),r,In(l.a.a.a)));m=null;Bn();i=l.d;if(!f.d||k){h=TKb(p,b,c,d,e);m=h.o;i=mQb(i,h.e);d9b(m,(n8b(),V7b),i);d.c!=(mJb(),lJb)&&In(l.a.a.a)}return new IOb(m,l.i)}catch(a){a=fZ(a);if(pF(a,36)){o=a;throw gZ(new HD('Exception parsing "'+n+'"',o));}else throw gZ(a);}}function RLb(a,b){var c,d,e,f,g;g=dKb(a.a,(Afc(),Eec));f=false;for(d=b.a.Vd();d.Id();){c=d.Jd();if(c.p==(n1b(),$_b)){a.a.d.Ah("Default value cannot appear at top level of an object literal.",
a.a.q,(RJb(),c.o.b.b+1),0);continue}else if(c.p==p0b&&cLb(a,c))continue;else if(c.p==S0b&&dLb(a,c))continue;e=yKb(a.a,c);e.n!=fdc&&!e.Yh()&&e.n!=_ec&&!a.a.c&&eLb(a,e);e.n==_ec&&bKb(a.a,c,(IRb(),mRb));E8b(e,(Hbc(),kbc))!=0&&(f=true);q8b(g,e)}f&&bKb(a.a,b,(IRb(),XQb));return g}function O0(a){var b;b="";!a.i&&(b+=" insertionPoint");!a.f&&(b+=" definePropertiesObjForPrototype");!a.e&&(b+=" definePropertiesObjForClass");!a.j&&(b+=" prototypeMembersToDeclare");!a.b&&(b+=" classMembersToDeclare");!a.g&&
(b+=" fullClassNameNode");!a.d&&(b+=" classPrototypeNode");a.a==null&&(b+=" anonymous");!a.c&&(b+=" classNameNode");!a.k&&(b+=" superClassNameNode");if(b.length!=0)throw gZ(new Irc(bNc+b));return new K0(a.i,a.f,a.e,a.j,a.b,a.g,a.d,a.a,a.c,a.k)}function nVb(a){var b,c,d,e;b=DWb(a.g,0).d.b;c=DWb(a.g,0).e;if(!((AZb(),iYb)==c||a.b.d&&VSb(c)||!a.b.c&&USb(c))&&!QCc(MCc(wZb,CE(xE(XR,1),sLc,14,0,[GYb,FYb,sZb])),DWb(a.g,0).e)){VVb(a,"Unexpected token '%s' in type expression",CE(xE(iW,1),mLc,1,5,[DWb(a.g,0).e]));
return new G1b(new Z1b(b,a.f),(Bn(),new Wz(Sd("error"))))}d=tUb(a);if(!AVb(a,BXb))return d;e=(Bn(),new Zr);Ywc(e.a,Sd(d));do{iTb(a,BXb);Xr(e,ITb(a))}while(AVb(a,BXb));return new K1b(new Z1b(b,a.f),In(e.a))}function vnb(b,c){var d,e,f,g,h;f=new Bnb(c.jg());try{g=COb(b.c,b.c.a,c.lg(b.c.c==(scc(),pcc)?1:0),f);b.b=g.a;c.kg();if(g.b!=null&&c.kg().Xc){c.kg();h=Cxb(b.c,g.b);!!h&&c.ig(b.c.b,new Bxb(h))}}catch(a){a=fZ(a);if(pF(a,104)){e=a;c.pg(new Gmb(null,null,-1,-1,(RZ(),QZ),null,CE(xE(nW,1),uNc,2,6,[b.c.b,
e.g])))}else throw gZ(a);}!b.b?b.b=(d=new J9b((Afc(),Xec)),d):c.og(b.b);if(f.b.a.length!=0||f.c.a.length!=0){g=(In(f.b),In(f.c),new Anb);d9b(b.b,(n8b(),h8b),g)}y9b(b.b,b.c)}function Zmb(b,c,d,e){var f,g,h,i,j,k,l,m,n;k=new YEc;m=dnb(b);if(c.b==(Sbb(),Qbb)||c.b==Pbb){f=SEb(e,kNc);!!f&&(n=k.a.Je(f,k),n==null);c.b==Pbb||Rc(k,In(new fvc(e.e)));for(i=xu(new Wzc(c.a.a.b.Vd()));i.Id();){h=i.Jd();j=null;try{if(Esc(h.a,h.b)){j=SEb(e,h.a);!j&&(j=PEb(e,h.c))}else{l=Ytc(m,h.b);if(!l)throw gZ(new onb(h.b));else{j=
PEb(e,h.a);j.k=l}}}catch(a){a=fZ(a);if(pF(a,219)){g=a;throw gZ(new mGb(h.c,g));}else throw gZ(a);}k.a.Je(j,k)}}else mu(k,Sd(d).Vd());return k}function xmb(a,b,c){var d,e,f,g,h,i,j;f=false;b.a+="function(";d=c.c;if(d.n==(Afc(),xec)){b.a+="new:";ymb(a,b,d.c);f=true}else if(d.n==lfc){b.a+="this:";ymb(a,b,d.c);f=true}else if(d.n==tdc){b.a+=")";return}else if(d.n!=Jec){b.a+="):";ymb(a,b,d);return}i=null;d.n==Jec?i=d:d.f.n==Jec&&(i=d.f);if(i){e=true;for(h=(!i.c?(Cyc(),Cyc(),Byc):new Kbc(i.c)).Vd();h.Id();){g=
h.Jd();(!e||f)&&(b.a+=",",b);ymb(a,b,g);e=false}}b.a+=")";j=c.c?c.c.i:null;if(j.n!=tdc){b.a+=":";ymb(a,b,j)}}function Qub(a,b,c,d,e){var f,g,h,i,j,k;if(e.n!=(Afc(),Pdc)){u7(a.a,Lmb(e,Jub,CE(xE(nW,1),uNc,2,6,["super only allowed with getprop (like super.foo(), not super['foo']())"])));return}Kd(d.n==ffc);Kd(!!c&&!!c.b&&S8b(c.b.a.a));Ld(!!c.a,OQc);Sd(c.b);h=d.f;i=RQc+h.Wh();f=(k=Tqb(W$((Kob(b),i)),CE(xE(HU,1),IMc,7,0,[])),k);g=e.g;if(g.n==Ycc&&g.c==e){f=(j=x3b(f,(n8b(),new Wbc(bfc,ePc))),j);o8b(g,F9b(W$((Kob(b),
PQc)),e),e);c.b.d=true}G9b(f,e);j9b(g,e,f);jDc(c.b.c,h.Wh());v7(a.a,c.a)}function hNb(a,b){var c,d,e;e=QMb(a,(Afc(),Jec));c=false;d=null;if(b!=(fOb(),bOb)){do{if(d){!a.o?mOb(a.j):GMb(a);xNb(a);b=!a.o?mOb(a.j):GMb(a)}if(b==QNb){xNb(a);if(OMb(a,bOb))d=QMb(a,sdc);else{xNb(a);d=zNb(a,sdc,mNb(a,!a.o?mOb(a.j):GMb(a)));xNb(a)}c=true}else{d=mNb(a,b);if(OMb(a,UNb)){xNb(a);!a.o?mOb(a.j):GMb(a);d=zNb(a,ydc,d)}}if(!d)return null;q8b(e,d);if(c)break}while(OMb(a,PNb))}if(c&&OMb(a,PNb))return CMb(a,"msg.jsdoc.function.varargs",
a.j.g,lOb(a.j)),null;return e}function qCb(){qCb=JZ;new Mcb("JSC_CANNOT_PARSE_GENERATED_CODE",(E2(),B2),new Rtc("Internal compiler error. Cannot parse generated code: {0}"));new Mcb("JSC_GENERATED_BAD_CODE",B2,new Rtc("Internal compiler error. Generated bad code.----------------------------------------\nExpected:\n{0}\n----------------------------------------\nActual:\n{1}"));pCb=new Mcb("JSC_EXTERN_PROPERTIES_CHANGED",B2,new Rtc("Internal compiler error. Extern properties modified from:\n{0}\nto:\n{1}"))}
function bPb(a,b){var c,d,e;if(!JOb(a,b,(NPb(),IPb)))return false;e=(Pd(b.n==(Afc(),Ycc),iSc,b),C8b(b)-1);c=(Pd(b.n==Ycc,iSc,b),B8b(b,1));if(c.n!=rec&&c.n!=bfc){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,["type name or type variable"])),a.b.ug(),a.d,a.c);a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[tSc])),a.b.ug(),a.d,a.c);return false}for(d=1;d<e;d++)if(!gPb(a,(Pd(b.n==Ycc,iSc,b),B8b(b,d+1)))){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[tSc])),a.b.ug(),a.d,a.c);return false}return true}function L2(){L2=JZ;Ye(new nc(46));
new Pc(String.fromCharCode(46));K2=new Mcb("JSC_MISSING_REQUIRE_WARNING",(E2(),C2),new Rtc(tNc));I2=new Mcb("JSC_MISSING_REQUIRE_FOR_GOOG_SCOPE",C2,new Rtc(tNc));J2=new Mcb("JSC_MISSING_REQUIRE_STRICT_WARNING",C2,new Rtc(tNc));H2=new Mcb("JSC_EXTRA_REQUIRE_WARNING",C2,new Rtc("extra require: ''{0}'' is never referenced in this file"));bn();pp(CE(xE(iW,1),mLc,1,5,["goog.testing.asserts","goog.testing.jsunit","goog.testing.JsTdTestCaseAdapter"]))}function qkb(a){var b,c,d,e;b=a;for(d=new iac(new eac(Sd(b.g)));d.a.a;){c=
hac(d);e=c.g;switch(c.n.f){case 84:case 66:case 67:case 0:case 39:Xd(c==b.g&&!(b==b.g.c?null:b.i));return c;case 76:case 100:case 88:{ppb();if(e.n==(Afc(),Fdc)||e.n==Hdc||e.n==Idc||e.n==Gdc)break}return c;case 72:if(c==b.g&&!(b==b.g.c?null:b.i))return c;case 73:case 101:case 102:case 71:case 70:case 85:case 82:case 83:case 68:case 69:case 45:return null}b=c}throw gZ(new Irc("Unexpected AST structure."));}function FUb(a){var b,c,d,e,f;f=DWb(a.g,0).d.b;e=OUb(a);if(!pF(e,399)||!!e.a)while(zVb(a,0,(AZb(),
GYb))||zVb(a,0,HYb)||zVb(a,0,MYb)||zVb(a,0,BYb)||zVb(a,0,jZb))switch(DWb(a.g,0).e.f){case 47:b=FTb(a);e=new UZb(new Z1b(f,a.f),e,b);break;case 49:iTb(a,HYb);d=xTb(a,1);iTb(a,MXb);e=new l_b(new Z1b(f,a.f),e,d);break;case 51:iTb(a,MYb);c=kTb(a);e=new k_b(new Z1b(f,a.f),e,c);break;case 107:case 104:e=mVb(a,e);break;default:throw gZ(new Kqc("unexpected case: "+DWb(a.g,0).e));}return e}function cub(){cub=JZ;var a,b;_tb=(Afc(),new gub);aub=new fub("REGISTER_NUMBER",1,(b="goog.tweak.registerNumber",b));
bub=new fub("REGISTER_STRING",2,(a="goog.tweak.registerString",a));$tb=new dub("OVERRIDE_DEFAULT_VALUE",3,"goog.tweak.overrideDefaultValue");Xtb=new dub("GET_COMPILER_OVERRIDES",4,"goog.tweak.getCompilerOverrides_");Wtb=new eub("GET_BOOLEAN",5,"goog.tweak.getBoolean");Ytb=new eub("GET_NUMBER",6,"goog.tweak.getNumber");Ztb=new eub("GET_STRING",7,"goog.tweak.getString")}function Npb(a,b){var c;switch(a.n.f){case 105:Npb(a.c,b);Npb(a.c.f,b);return;case 76:case 88:case 100:case 94:case 93:case 45:case 106:for(c=
a.c;c;c=c.f)Npb(c,b);return;case 95:case 121:case 78:case 114:case 92:Npb(a.c,b);return;case 107:case 116:case 91:Npb(a.c?a.c.i:null,b);return;case 29:case 108:b.Pd(a);return;case 26:case 27:b.Pd(a);return;case 80:return;case 73:case 101:case 102:Npb(a.c,b);return;default:if(aqb(a))Npb(a.c,b);else throw gZ(new Irc("Invalid node in lhs: "+a));}}function Ric(a,b,c){var d,e,f,g,h,i,j,k;if(a.Xi()!=null)return ptc(b,c?Ahc(a):a.Xi());if(!a.s)return b.a+=c?"?":"{...}",b;a.s=false;j=new CHc;for(d=a;!!d&&
!d._i()&&j.a.Yd()<=10;d=d.Si())Rc(j,d.Ti());b.a+="{";k=!c&&j.a.Yd()>2;g=0;for(i=(f=(new Yvc(j.a)).a.He().b.vj(),new ewc(f));i.a.Id();){h=(e=i.a.Jd(),e.Ve());g>0&&(b.a+=",",b);k?(b.a+="\n  ",b):g>0&&(b.a+=" ",b);ptc((b.a+=""+h,b),": ");Pfc(a.Wi(h),b,c);++g;if(!c&&g==10){b.a+=", ...";break}}k&&(b.a+=gMc,b);b.a+="}";a.s=true;return b}function Nvb(a){Kvb();var b,c,d,e,f,g,h,i;e=new Ns;g=(oo(),new hs);for(c=mf(Se(Re(Ye(new nc(10))),a));Pb(c);){b=Qb(c);i=Te(Re(Ye(new nc(32))),Ysc(b));if(i.b.Yd()==1&&i.a.ce(0).length==
0)continue;else if(i.b.Yd()<3)throw gZ(new qnb("Invalid table: too few tokens on line: "+b));h=i.a.ce(0);f=new Ivb(BQb(i.a.ce(1)),BQb(i.a.ce(2)),i.b.Yd()>3?i.a.ce(3):"");h.indexOf(gQc)!=-1?Ms(e,Psc(h,".*\\.prototype\\.",""),f):(Ywc(g.b,(el(h,f),new Wq(h,f))),g)}return new Mvb((d=new KEc(e.a),sm(d)),Co(g.b))}function RUb(a,b){var c,d,e,f,g,h,i,j,k;h=DWb(a.g,0).d.b;if(DWb(a.g,0).e==(AZb(),HYb)){f=_Tb(a);iTb(a,NXb);k=VUb(a,b);return new k$b(new Z1b(h,a.f),f,k)}i=DWb(a.g,0).e;if(iYb==i||(OSb(),OSb(),
!!Po(pSb,i))){g=kTb(a);if(!AVb(a,NXb)){d=g;TSb(d.a,false)&&VVb(a,YSc,CE(xE(iW,1),mLc,1,5,[g]));if(AVb(a,ZXb)){e=new c_b(new Z1b(h,a.f),d);iTb(a,ZXb);c=KTb(a,1);return new t$b(new Z1b(h,a.f),e,c)}return new r1b(new Z1b(h,a.f),g,null)}}else g=GUb(a).a;iTb(a,NXb);j=VUb(a,b);return new r1b(new Z1b(h,a.f),g,j)}function FZb(){AZb();return CE(xE(XR,1),sLc,14,0,[XXb,aYb,iYb,DXb,GXb,HXb,QXb,RXb,TXb,UXb,VXb,WXb,eYb,fYb,gYb,jYb,mYb,nYb,yYb,WYb,iZb,mZb,nZb,qZb,sZb,vZb,wZb,xZb,yZb,IXb,PXb,YXb,bYb,cYb,lYb,hZb,
kYb,oYb,sYb,JYb,RYb,SYb,TYb,fZb,zZb,FYb,KXb,GYb,LXb,HYb,MXb,MYb,ZYb,OXb,EYb,JXb,rYb,hYb,zXb,$Xb,zYb,_Xb,AYb,NYb,tYb,bZb,dZb,KYb,PYb,vYb,pYb,XYb,tZb,wXb,BXb,EXb,AXb,oZb,yXb,IYb,UYb,NXb,ZXb,OYb,uYb,cZb,eZb,LYb,qYb,YYb,uZb,xXb,CXb,FXb,$Yb,_Yb,QYb,CYb,pZb,dYb,DYb,gZb,VYb,aZb,jZb,kZb,lZb,BYb,rZb,SXb,wYb,xYb])}function Pib(a){var b,c,d,e,f,g,h,i,j,k,l,m;if(a.c.a.Yd()!=0){for(d=(h=(new Wuc(a.d.a)).a.He().Vd(),new avc(h));d.a.Id();){c=(b=d.a.Jd(),b.Ve());Sd(c.g);e9b(c.g,c)}e=new mDc;for(j=(g=(new Wuc(a.c.a)).a.He().Vd(),
new avc(g));j.a.Id();){i=(b=j.a.Jd(),b.Ve());m=i.b;f=e.a.Je(m,e);if(f==null){k=l3b((ae(Hsc(TPc,_sc(46))==-1,HMc,TPc),n8b(),new Wbc((Afc(),rec),TPc)),CE(xE(HU,1),IMc,7,0,[V3b(i.a)]));b9b(k,W7b,true);l=q3b((ae(Hsc(m,_sc(46))==-1,HMc,m),new Wbc(rec,m)),k,ufc);I9b(l,a.g);o8b(a.g,l,a.f);a.f=l}}}}function j7(b){var c,d,e,f,g,h;V6(b);h=false;if(b.G.Z.b!=(Sbb(),Obb)){for(e=new Tu(wu($t(Tt(Wt(new eyc(b.B.a),new lnb)).a),new Xt));Ru(e);){d=Su(e);for(g=y8(d).f.Vd();g.Id();){f=g.Jd();jDc(b.q,f)}}try{inb(b.B,
b.G.Z);h=true}catch(a){a=fZ(a);if(pF(a,219)){c=a;u7(b,new Gmb(null,null,-1,-1,r6,null,CE(xE(nW,1),uNc,2,6,[c.g])))}else if(pF(a,321)){c=a;u7(b,new Gmb(null,null,-1,-1,s6,null,CE(xE(nW,1),uNc,2,6,[c.g])))}else throw gZ(a);}}D6(b,b.B?new eyc(b.B.a):null);X6(b);h&&(D6(b,b.B?new eyc(b.B.a):null),Z6(b))}function NBb(a,b){var c,d,e,f,g,h,i,j,k;j=(ae(b.oi()||b.f==(dkc(),bkc),lRc,b),cgc(b.k)).Zi();if(j){k=(ae(j.oi()||j.f==(dkc(),bkc),lRc,j),cgc(j.k));if(!Esc(k.di(new stc,false).a,NMc)){a.a+=mRc;aCb(a,NNc,
k.di(new stc,true).a);a.a+=gMc}}e=new CHc;for(h=(i=(new Wuc(qjc(b).a)).a.He().Vd(),new avc(i));h.a.Id();){f=(c=h.a.Jd(),c.Ve());AHc(e,f.di(new stc,true).a)}for(g=(d=(new Yvc(e.a)).a.He().b.vj(),new ewc(d));g.a.Id();){f=(c=g.a.Jd(),c.Ve());a.a+=mRc;ptc(ptc(ptc(ptc((a.a+="@",a),ONc)," {"),f),"}");a.a+=gMc}}function iQb(){iQb=JZ;var a;TPb=new uQb((a=erc(FR),new TCc(a,nKc(a,a.length),0)));YPb=qQb(TPb,MRb(0));ZPb=qQb(YPb,MRb(1));_Pb=qQb(ZPb,MRb(2));$Pb=sQb(_Pb,(IRb(),iRb),CE(xE(FR,1),sLc,24,0,[]));bQb=
qQb(_Pb,MRb(3));aQb=sQb(bQb,iRb,CE(xE(FR,1),sLc,24,0,[]));dQb=qQb(bQb,MRb(4));cQb=sQb(dQb,iRb,CE(xE(FR,1),sLc,24,0,[]));VPb=qQb(dQb,MRb(5));UPb=sQb(VPb,iRb,CE(xE(FR,1),sLc,24,0,[]));XPb=qQb(VPb,MRb(6));WPb=sQb(XPb,iRb,CE(xE(FR,1),sLc,24,0,[]));eQb=qQb(XPb,MRb(7));fQb=qQb(eQb,MRb(8));gQb=qQb(eQb,MRb(9));hQb=WPb}function yUb(a){var b,c,d,e,f,g,h,i,j,k;j=DWb(a.g,0).d.b;iTb(a,(AZb(),lYb));if(AVb(a,gZb)){f=iTb(a,gZb);nTb(a);return new e_b(new Z1b(j,a.f),null,null,null,f)}b=null;h=null;c=null;i=true;k=
DWb(a.g,0).e;if(iYb==k||a.b.d&&VSb(k)||!a.b.c&&USb(k)){b=jTb(a);AVb(a,OXb)?iTb(a,OXb):i=false}else if(SSb(DWb(a.g,0).e)){d=wTb(a);SVb(a,d,YSc,CE(xE(iW,1),mLc,1,5,[d]))}if(i)if(AVb(a,bZb)){iTb(a,bZb);oTb(a,"as");h=jTb(a)}else c=AUb(a);oTb(a,KNc);g=iTb(a,gZb);e=!g?null:g;nTb(a);return new e_b(new Z1b(j,a.f),b,c,h,e)}function s2b(a){var b,c,d,e;d=0;c=new stc;b=a.b.b;if(pF(a.a,156))e=a.a.a;else if(pF(a.a,132))e=a.a.a;else throw gZ(g2b(a));if(a.b.i)if(b==111){c.a+="0";d+=1}else{c.a+="0x";d+=2}if(100==
b){a.b.e?otc(c,a.a):(c.a+=zZ(e),c);if(iZ(e,0)<0)if(a.b.g)return v2b(a,c);else a.b.k&&++d;else if(a.b.d){rtc(c,0,String.fromCharCode(43));d+=1}else if(a.b.j){rtc(c,0,String.fromCharCode(32));d+=1}}else{pF(a.a,132)&&(e=jZ(TE(pZ(e)?wZ(e):e,pZ(kTc)?wZ(kTc):kTc)));111==b?ptc(c,gsc(e,3)):ptc(c,gsc(e,4))}return j2b(a,c,d)}function mNb(a,b){var c,d,e;e=a.j.g;d=lOb(a.j);if(b==(fOb(),$Nb)){b=!a.o?mOb(a.j):GMb(a);if(b==PNb||b==UNb||b==cOb||b==aOb||b==bOb||b==ZNb||b==_Nb||b==RNb||b==TNb||b==SNb){a.o=b;return QMb(a,
(Afc(),Pec))}return ANb(a,(Afc(),Pec),WMb(a,b),e,d)}else if(b==NNb)return ANb(a,(Afc(),Qcc),WMb(a,!a.o?mOb(a.j):GMb(a)),e,d);else{c=WMb(a,b);e=a.j.g;d=lOb(a.j);if(c)if(OMb(a,$Nb)){!a.o?mOb(a.j):GMb(a);return ANb(a,(Afc(),Pec),c,e,d)}else if(OMb(a,NNb)){!a.o?mOb(a.j):GMb(a);return ANb(a,(Afc(),Qcc),c,e,d)}return c}}function Bdb(a,b){var c;switch(b){case kPc:case "ArrayBuffer":case lPc:case "DataView":case "Date":case mPc:case nPc:case "Generator":case "GeneratorFunction":case "Int16Array":case "Int32Array":case "Int8Array":case "InternalError":case "Map":case oPc:case pPc:case "Proxy":case qPc:case "Set":case oMc:case rPc:case "TypedArray":case "Uint16Array":case "Uint32Array":case "Uint8Array":case "Uint8ClampedArray":case "WeakMap":case "WeakSet":return c=
i$(Kob(a),b),!(!!c&&!(!c.a||B8(c.a)));default:return false}}function cgb(a,b){var c,d,e,f,g,h,i,j,k;(b.a.a&IPc)==0&&(b.a.a&JPc)==0&&(b.a.a&vMc)==0&&m7b(b);if(a){(f=!a.d?null:a.d.q,!f?(Cyc(),Cyc(),Byc):f).Ud()||n7b(b,(e=!a.d?null:a.d.q,!e?(Cyc(),Cyc(),Byc):e));for(d=G4b(a).Vd();d.Id();){c=d.Jd();f7b(b,c,H4b(a,c));g7b(b,c,z4b(a,c))}for(j=K4b(a).Vd();j.Id();){i=j.Jd();r7b(b,i);q7b(b,i,L4b(a,i))}k=a.j;!!k&&k!=(e6b(),_5b)&&y7b(b,k);(a.a&256)!=0&&A6b(b);(!a.d?null:a.d.c)!=null&&x4b(b.a)==null&&B6b(b,!a.d?
null:a.d.c);e5b(b.a,a);for(h=J4b(a).Vd();h.Id();){g=h.Jd();o7b(b,g)}}}function dlc(a){hlc(a,a.u[0]);hlc(a,a.u[3]);hlc(a,a.u[5]);hlc(a,a.u[7]);hlc(a,a.u[9]);hlc(a,a.u[8]);hlc(a,a.u[24]);hlc(a,a.u[26]);hlc(a,a.u[20]);hlc(a,a.u[12]);hlc(a,a.u[29]);hlc(a,a.u[22]);hlc(a,a.u[27]);hlc(a,a.u[31]);hlc(a,a.u[32]);flc(a,a.u[32],"Null");hlc(a,a.u[34]);hlc(a,a.u[33]);hlc(a,a.u[38]);hlc(a,a.u[36]);hlc(a,a.u[41]);hlc(a,a.u[43]);hlc(a,a.u[45]);hlc(a,a.u[46]);hlc(a,a.u[48]);flc(a,a.u[49],ETc);hlc(a,a.u[52]);flc(a,
a.u[52],"Undefined");flc(a,a.u[52],XNc);flc(a,a.u[17],nPc);flc(a,a.u[61],"Global")}function Ypb(a){var b,c,d,e,f,g;switch(a.n.f){case 31:case 91:return a.Wh();case 118:g="";for(c=a.c;c;c=c.f){d=c;c.n==(Afc(),kfc)&&(d=c.c);e=Ypb(d);if(e==null)return null;g=g+e}return g;case 120:return a.Th();case 29:f=a.Wh();if(Esc(vPc,f)||Esc(xQc,f)||Esc("NaN",f))return f;break;case 30:return""+a.Uh();case 34:return SNc;case 35:return TNc;case 32:return jLc;case 79:return vPc;case 19:b=Spb(a.c);if(b!=(yoc(),xoc))return b.gj(true)?
SNc:TNc;break;case 42:return spb(a);case 43:return"[object Object]"}return null}function mkb(a,b,c){var d,e,f,g,h,i,j,k;j=false;k=(ppb(),upb(c,false,a.b));d=c;for(i=new iac(new eac(Sd(d.g)));i.a.a;){h=hac(i);if(!!h&&(h.n==(Afc(),ufc)||h.n==jec||h.n==gdc)&&!(h==d.g&&!(d==d.g.c?null:d.i)))return 0;if(h==b)return j?2:1;if(ukb(h))d!=h.c&&(j=true);else if(lkb(a,h,k));else{e=tkb(h);for(g=e==0?h.c:h.c?h.c.i:null;g;g=e==0?g.f:g==g.g.c?null:g.i){if(g==d)break;if(kkb(a,g,k)){k=true;j=true}}f=h.c;if(j&&h.n==
(Afc(),Ycc)&&(f.n==(Afc(),Pdc)||f.n==Odc))return a.a?2:0}d=h}throw gZ(new Irc("Unexpected."));}function C9b(a,b,c,d,e){var f,g,h,i,j,k;otc(b,a.n);if(pF(a,9)){b.a+=" ";ptc(b,a.Wh())}else if(a.n==(Afc(),Jdc)){b.a+=" ";!a.c||a.c.n!=rec?(b.a+="<invalid>",b):ptc(b,a.c.Wh())}else if(a.n==Cec){b.a+=" ";jtc(b,a.Uh())}if(c){h=T9b(a.k);if(h!=-1){b.a+=" ";b.a+=h}if(a.e!=0){b.a+=" [length: ";ktc(b,a.e);b.a+="]"}}if(d){g=K8b(a);for(f=0;f<g.length;f++){i=Jbc()[g[f]];k=Y8b(a,i);b.a+=" [";ptc(b,Zb(!i?jLc:i.e!=null?
i.e:""+i.f));b.a+=": ";b.a+=""+k;b.a+="]"}}if(e&&!!a.d){j=a.d.di(new stc,false).a;if(j!=null){b.a+=" : ";b.a+=""+j}}}function xgb(a,b,c){var d,e,f,g,h;f=(RFb(),Osc(Nsc(Nsc(Nsc(Nsc(Nsc(Nsc(Osc(Qsc(TFb((d=Osc(Osc(Osc(Osc(Osc(Nsc(Nsc(H8b(c,(Hbc(),ybc)).ug(),58,45),92,47)," ",cNc),"[",dNc),"]",eNc),"<",fNc),">",gNc),SFb(d))),"^\\./",""),"/","$"),92,36),64,36),43,36),45,95),58,95),46,95),cNc,"_")+"$classextends$var"+a.a++);h=(ppb(),Gpb(c,new jrb));g=c.c.f;k9b(g,F9b((ae(Hsc(f,_sc(46))==-1,HMc,f),n8b(),
new Wbc((Afc(),rec),f)),g));e=I9b(q3b((ae(Hsc(f,_sc(46))==-1,HMc,f),new Wbc(rec,f)),g,gdc),g);p8b(h.g,e,h);qpb(Gpb(c,new frb(Xec)),(IRb(),RQb));w7(b.c,c)}function bNb(a,b,c){var d,e;while(true)switch(b.f){case 13:if(a.i==(JNb(),HNb)){a.i=INb;b=VMb(a,b,c)}else b=!a.o?mOb(a.j):GMb(a);break;case 16:d=true;EMb(a,c);if(m6b(a.f)){a.e=k6b(a.f);e=a.e.j;switch(e.f){case 0:case 2:AMb(a,Zb(e.e!=null?e.e:""+e.f));d=false}}return d;case 0:k6b(a.f);zMb(a,"msg.unexpected.eof",a.j.g,lOb(a.j));EMb(a,c);return false;
case 1:a.i==(JNb(),INb)&&(a.i=HNb);b=!a.o?mOb(a.j):GMb(a);break;default:if(b==(fOb(),dOb)&&a.i==(JNb(),HNb))b=!a.o?mOb(a.j):GMb(a);else{a.i=(JNb(),INb);b=HMb(a,!a.o?mOb(a.j):GMb(a))}}}function N4b(a){var b,c,d,e,f,g,h,i,j;e=new fxc;!!a.i&&Ywc(e,a.i.a);!!a.g&&Ywc(e,a.g.a);if(a.d){!!a.d.a&&Ywc(e,a.d.a.a);if(a.d.f)for(d=new wxc(a.d.f);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);!!c&&Ywc(e,c.a)}if(a.d.g)for(d=new wxc(a.d.g);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);!!c&&Ywc(e,c.a)}if(a.d.o)for(h=(f=
(new fvc(a.d.o)).a.He().Vd(),new kvc(f));h.a.Id();){g=(b=h.a.Jd(),b.We());!!g&&Ywc(e,g.a)}if(a.d.s)for(j=new wxc(a.d.s);j.a<j.c.a.length;){i=(j.b=j.a++,j.c.a[j.b]);!!i&&Ywc(e,i.a)}!!a.d.i&&Ywc(e,a.d.i.a)}return e}function J0(a,b){var c,d,e,f,g;d=a.c;g=d.f;c=S0(Z0(R0(Y0(new $0,new tEc),new tEc),g),d);ppb();if(a.n==(Afc(),bdc)&&iqb(a.g)&&a.n==bdc&&Gqb(a.c))Q0(W0(X0(c,new tgb(a)),d),false);else if(b.n==Ccc&&b.g.n==Ddc){f=b.c;if(!V8b(f))return null;Q0(W0(X0(c,new tgb(b.g)),f),true)}else if(b.n==Adc)Q0(W0(X0(c,
new tgb(a)),d),false);else if(b.n==rec)Q0(W0(X0(c,new tgb(b.g)),b.Sh(false)),true);else return null;e=P0(c).d;T0(c,O$(x8b(P0(c),false),aNc));U0(c,r9b(P3b(CE(xE(HU,1),IMc,7,0,[])),e));V0(c,r9b(P3b(CE(xE(HU,1),IMc,7,0,[])),e));return O0(c)}function idb(a,b,c,d){var e,f,g,h,i,j,k,l;Yd(c.n==(Afc(),Pdc)||c.n==Odc,c);Yd(b.n==ffc,b);i=c.g;Xd(i.n==Ycc);g=(ppb(),Gpb(b,new frb(bdc)));k=g.c.f;if(!V8b(k))return;f=c;e=(n8b(),new Wbc(bfc,ePc));c9b(e,(Hbc(),pbc),1);if(E8b(d,zbc)!=0){h=G9b(x8b(k,false),b);d9b(h,
sbc,DMc);j9b(f,b,h);f=O$(z8b(f),ePc);r8b(i,f);l=(j=new J9b(lfc),j);c9b(l,pbc,1);o8b(i,l,f);I9b(i,c)}else{h=G9b(O$(x8b(k,false),aNc),b);d9b(h,sbc,DMc);j9b(b.g,b,h);f=O$(z8b(f),ePc);r8b(i,f);edb(g);l=(j=new J9b(lfc),j);c9b(l,pbc,1);o8b(i,l,f);b9b(i,W7b,false);I9b(i,c)}w7(a.a,i)}function rlc(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;if(b.q)return b;if(b.f!=(dkc(),ckc)&&!b.oi())return b;i=false;h=Yfc(b.k)?b.A.u[51]:b.k;e=wlc(a,h.Ni(a));h!=e&&(i=true);g=b.b.b;d=g.Ni(a);g!=d&&(i=true);l=new Qic(a.e);for(n=(k=b.b.a,
k?!k.c?(Cyc(),Cyc(),Byc):new Kbc(k.c):(Cyc(),Cyc(),Byc)).Vd();n.Id();){m=n.Jd();f=m.d;c=f.Ni(a);f!=c&&(i=true);E8b(m,(Hbc(),qbc))!=0?Mic(l,CE(xE(cV,1),xPc,23,0,[c])):E8b(m,Ebc)!=0?Oic(l,c):Nic(l,CE(xE(cV,1),xPc,23,0,[c]))}if(i){j=uic(Hic(Kic(Dic(Bic(zic(new Lic(a.e),b.f),l.b),d),e),Tnc(b.B)));return j}return b}function ppb(){ppb=JZ;hpb=tp(kPc,"Date",iPc,NMc,qPc,"XMLHttpRequest",CE(xE(nW,1),uNc,2,6,[]));gpb=tp(NMc,kPc,oMc,oPc,lPc,qPc,CE(xE(nW,1),uNc,2,6,[iPc]));mpb=(bn(),pp(CE(xE(iW,1),mLc,1,5,["toString",
"valueOf"])));npb=pp(CE(xE(iW,1),mLc,1,5,["test","exec"]));opb=pp(CE(xE(iW,1),mLc,1,5,["match","replace","search","split"]));ipb=MCc((Afc(),Jdc),CE(xE(KU,1),sLc,10,0,[Xec,pec,Vec]));jpb=MCc(Xec,CE(xE(KU,1),sLc,10,0,[pec,Vcc,eec,uec,dec]));kpb=new rrb;lpb=new vrb;x3b((ae(Hsc(oPc,_sc(46))==-1,HMc,oPc),n8b(),new Wbc(rec,oPc)),new Wbc(bfc,"NaN"))}function fOb(){fOb=JZ;SNb=new gOb("EOF",0);TNb=new gOb("EOL",1);VNb=new gOb("LEFT_ANGLE",2);_Nb=new gOb("RIGHT_ANGLE",3);eOb=new gOb(fSc,4);YNb=new gOb("LEFT_SQUARE",
5);cOb=new gOb("RIGHT_SQUARE",6);WNb=new gOb("LEFT_CURLY",7);aOb=new gOb("RIGHT_CURLY",8);XNb=new gOb("LEFT_PAREN",9);bOb=new gOb("RIGHT_PAREN",10);PNb=new gOb("COMMA",11);ONb=new gOb("COLON",12);MNb=new gOb(gSc,13);ZNb=new gOb("PIPE",14);dOb=new gOb("STAR",15);RNb=new gOb("EOC",16);$Nb=new gOb("QMARK",17);QNb=new gOb("ELLIPSIS",18);NNb=new gOb("BANG",19);UNb=new gOb("EQUALS",20)}function qmb(a,b,c,d){var e;e=d==c.c;switch(c.n.f){case 92:return a;case 46:return d==(c.c?c.c.i:null)?a:a.c?a:new smb(a.a,
true,a.b);case 60:case 62:return e?new smb(c,true,a.a?a:null):a;case 61:return e?new smb(c,false,a.a?a:null):a;case 66:return e?new smb(c,true,a.a?a:null):omb;case 41:case 47:return e==a.c?a:new smb(a.a,e,a.b);case 25:case 19:case 4:case 5:case 36:case 37:return a.c?a:new smb(a.a,true,a.b);case 28:return rmb(a,!e&&lmb(b,c));case 81:return omb;default:return ppb(),c.n!=(Afc(),pec)&&Jqb(c.g)?omb:a.c?new smb(a.a,false,a.b):a}}function DUb(a){var b,c,d,e,f,g,h,i;h=DWb(a.g,0).d.b;e=!!mTb(a,(AZb(),bZb));
g=null;i=DWb(a.g,0).e;if(i==yYb)return TTb(a,true);else if(i==iYb||(OSb(),OSb(),!!Po(pSb,i)))g=kTb(a);else if(i==HYb)return BUb(a);else if(i==EYb||i==GYb)return TTb(a,false);f=false;if(AVb(a,UYb)){iTb(a,UYb);f=true}if(AVb(a,GYb)||AVb(a,EYb)){d=(b=M$b(R$b(L$b(O$b(J$b(Q$b(N$b(S$b(P$b(new T$b((Y$b(),X$b)),g),false),e),f),null),tTb(a)),pUb(a,1)),sTb(a)),new w$b(new Z1b(h,a.f))),I$b(b,new Z1b(h,a.f)));return d}else{c=sTb(a);return new m_b(new Z1b(h,a.f),g,false,f,null,c)}}function $6(b,c,d,e){var f;_6(b,
e);d.a.length==0?u7(b,new Gmb(null,null,-1,-1,p6,null,CE(xE(nW,1),uNc,2,6,[]))):d.a[0].d.a.length==0&&d.a.length>1&&u7(b,new Gmb(null,null,-1,-1,q6,null,CE(xE(nW,1),uNc,2,6,[d.a[0].e])));b.k=f7(c);try{b.B=new jnb(d)}catch(a){a=fZ(a);if(pF(a,319)){f=a;u7(b,new Gmb(null,null,-1,-1,t6,null,CE(xE(nW,1),uNc,2,6,[f.b.e,f.a.e])));return}else throw gZ(a);}D6(b,b.B?new eyc(b.B.a):null);bnb(b.B);new SHc;xg(b.t,b.G.Lb);Z6(b);b.v=T3b(CE(xE(HU,1),IMc,7,0,[]));b.o=T3b(CE(xE(HU,1),IMc,7,0,[]));b.i=T3b(CE(xE(HU,
1),IMc,7,0,[b.o,b.v]))}function phb(a,b,c,d){var e,f,g,h,i,j,k;j=jhb(a,g9b(b));f=b.c;h=f.f;e=h.f;if(E8b(f,(Hbc(),gbc))==0&&E8b(h,gbc)==0&&E8b(e,gbc)==0){r8b(b,j);c9b(b,gbc,0);whb(a,b);return}if(j.n!=(Afc(),tdc)){H3b(j)&&(j=F9b((Yd(H3b(j),j),new L9b(Ddc,j)),j));whb(a,j)}k=new pib(a.a);i=Thb(a.a,d);g=Thb(a.a,c);cib(a.a,k);if(f.n!=tdc){f=khb(a,jhb(a,z8b(f)));eib(a.a,F9b(B3b(F9b(Yjb(Z3b(zec,f),a.f.a),f),Ghb(a.a,g,true,b)),b))}Yhb(a.a,g,i);thb(a,z8b(e),null,null);Vhb(a.a);cib(a.a,i);if(h.n!=tdc){h=jhb(a,
z8b(h));whb(a,F9b((Yd(H3b(h),h),new L9b(Ddc,h)),h))}gib(a.a,k,b);cib(a.a,g)}function Dqb(a){ppb();var b,c,d,e,f,g,h,i;f=(g=Dpb(a),!g?null:H8b(g,(Hbc(),mbc)));if(!!f&&N4b(f).a.length!=0)return false;e=a.g.n==(Afc(),gdc)||!!f&&((f.a&37)!=0||(!f.d?null:f.d.d)!=null);c=H8b(a,(Hbc(),ybc));if(!(!!c&&c.Kh())&&!e)return false;if(Cqb(a.g)){i=a;d=a.c}else if(a.n==Ddc){b=a.c;if(b.n!=Ccc||b.c.n!=Pdc)return false;i=b.c;d=b.c?b.c.i:null}else if(a.n==Pdc){h=a.g;if(h.n!=Ccc||h.g.n!=Ddc)return false;i=a;d=h.c?h.c.i:
null}else return false;if(!d||!i)return false;if(d.n==Eec)return true;return d.n==Hec&&$8b(i,d.c)&&(d.c?d.c.i:null).n==Eec}function Veb(a,b,c){var d,e,f,g,h;g=c.f;if(c.e){f=r9b((ae(Hsc(EPc,_sc(46))==-1,HMc,EPc),n8b(),new Wbc((Afc(),rec),EPc)),c.g);h=q3b(f,r9b(new J9b(lfc),c.g),gdc);qpb(b.f,(IRb(),RQb));I9b(h,g);Xeb(a,h);!c.c?r8b(g,h):o8b(g,h,c.c);w7(a.a,h)}if(c.d){f=r9b((ae(Hsc(FPc,_sc(46))==-1,HMc,FPc),n8b(),new Wbc((Afc(),rec),FPc)),c.a);d=q3b(f,r9b((ae(Hsc(BMc,_sc(46))==-1,HMc,BMc),new Wbc(rec,
BMc)),c.a),gdc);qpb(b.f,(IRb(),RQb));r8b(g,d);e=new C7b(false);s7b(e,new H7b(new L9b(Qcc,new Wbc(bfc,"Arguments")),"<Es6RewriteArrowFunction>"));q9b(d,k6b(e));I9b(d,g);w7(a.a,d)}}function WKb(a,b){var c,d,e,f,g,h;f=false;c=true;for(d=0;d<b.Yd();d++){e=b.ce(d);g=null;if(e.p==(n1b(),a1b)){h=e;g=yKb(a.a,h.b);e=h.a}switch(e.p.f){case 26:if(f){a.a.d.Ah("A required parameter cannot follow an optional parameter.",a.a.q,(RJb(),e.o.b.b+1),e.o.b.a);c=false}break;case 81:f=true;break;case 65:if(d!=b.Yd()-1){a.a.d.Ah("A rest parameter must be last in a parameter list.",
a.a.q,(RJb(),e.o.b.b+1),e.o.b.a);c=false}if(!!g&&g.n!=(Afc(),Bcc)){a.a.d.Ah("A rest parameter must be of an array type.",a.a.q,(RJb(),e.o.b.b+1),e.o.b.a);c=false}}}return c}function cNb(a,b){var c,d;c=SRc;if(b==(fOb(),WNb)){if(OMb(a,eOb)){d=a.j.n;!uMb.Sd(d)&&!l6b(a.f,d)&&BMb(a,"msg.jsdoc.idgen.unknown",d,a.j.g,lOb(a.j));c=d;b=!a.o?mOb(a.j):GMb(a)}else{zMb(a,bSc,a.j.g,lOb(a.j));return b}OMb(a,aOb)?b=!a.o?mOb(a.j):GMb(a):zMb(a,bSc,a.j.g,lOb(a.j))}switch(c){case SRc:N6b(a.f)||zMb(a,cSc,a.j.g,lOb(a.j));
break;case TRc:v6b(a.f)||zMb(a,cSc,a.j.g,lOb(a.j));break;case "stable":l7b(a.f)||zMb(a,cSc,a.j.g,lOb(a.j));break;case "xid":A7b(a.f)||zMb(a,cSc,a.j.g,lOb(a.j));break;case "mapped":U6b(a.f)||zMb(a,cSc,a.j.g,lOb(a.j))}return b}function WE(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G;c=a.l&8191;d=a.l>>13|(a.m&15)<<9;e=a.m>>4&8191;f=a.m>>17|(a.h&255)<<5;g=(a.h&1048320)>>8;h=b.l&8191;i=b.l>>13|(b.m&15)<<9;j=b.m>>4&8191;k=b.m>>17|(b.h&255)<<5;l=(b.h&1048320)>>8;B=c*h;C=d*h;D=e*h;F=f*h;
G=g*h;if(i!=0){C+=c*i;D+=d*i;F+=e*i;G+=f*i}if(j!=0){D+=c*j;F+=d*j;G+=e*j}if(k!=0){F+=c*k;G+=d*k}l!=0&&(G+=c*l);n=B&sMc;o=(C&511)<<13;m=n+o;q=B>>22;r=C>>9;s=(D&262143)<<4;t=(F&31)<<17;p=q+r+s+t;v=D>>18;w=F>>5;A=(G&xMc)<<8;u=v+w+A;p+=m>>22;m&=sMc;u+=p>>22;p&=sMc;u&=tMc;return HE(m,p,u)}function MTb(a,b){var c,d,e,f,g,h,i;i=DWb(a.g,0).d.b;oTb(a,GNc);g=DWb(a.g,0).d.b.b>a.f.b;(g||zVb(a,0,(AZb(),ZYb))||zVb(a,0,(AZb(),KXb))||zVb(a,0,(AZb(),XXb)))&&VVb(a,"No newline allowed between `async` and arrow function parameter list",
CE(xE(iW,1),mLc,1,5,[]));d=null;if(AVb(a,(AZb(),GYb)))d=pUb(a,0);else{h=wUb(a);d=new G$b(h.o,(Bn(),new Wz(Sd(h))))}f=DWb(a.g,0).d.b.b>a.f.b;(f||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb))&&VVb(a,VSc,CE(xE(iW,1),mLc,1,5,[]));iTb(a,zXb);c=JTb(a,b,(pWb(),lWb));e=M$b(L$b(K$b(new T$b((Y$b(),U$b))),d),c);return I$b(e,new Z1b(i,a.f))}function rLb(a,b){var c,d,e,f,g,h,i,j,k;bKb(a.a,b,(IRb(),MQb));j=pMb(a,b.d,b);aLb(a,j,b.b);k=qMb(a,b.e,b);k.n==(Afc(),tdc)||(a.a.e=oQb(a.a.e,NQb));i=oMb(a,Udc,b.c);c=dKb(a.a,
cdc);T9b(c.k)==-1&&vKb(c,b.o.b,b.o.a);h=false;for(e=b.a.Vd();e.Id();){d=e.Jd();switch(d.p.f){case 88:case 89:gLb(a,d,hRb)}switch(d.p.f){case 37:case 39:case 33:case 34:a.a.e=oQb(a.a.e,OQb)}f=rMb(a,d);if(f){h&&a.a.d.Ah("Class may have only one constructor.",a.a.q,(RJb(),d.o.b.b+1),d.o.b.a);h=true}q8b(c,yKb(a.a,d))}g=gKb(a.a,bdc,j,k,c);if(i.n!=tdc){gLb(a,b,bRb);d9b(g,(n8b(),$7b),i)}return g}function Orb(a,b){var c,d,e,f,g,h,i,j,k;if(E8b(b,(n8b(),U7b))!=0)return;c=b.c;ppb();if(!!c&&(c.n==(Afc(),ufc)||
c.n==jec||c.n==gdc)||c.n==(Afc(),Jdc)&&iqb(c.g)&&(c.n==Jdc&&Gqb(c.c))||c.n==(Afc(),bdc)&&iqb(c.g)&&(c.n==bdc&&Gqb(c.c))){e9b(b,c);g=F9b(new J9b((Afc(),Cdc)),b);r8b(b,g);if(c.n==bdc||c.n==Jdc){j=Jyc(c.c);p8b(b.g,c,b)}else{j=Bpb(c);for(e=(!c.c?(Cyc(),Cyc(),Byc):new Kbc(c.c)).Vd();e.Id();){d=e.Jd();e9b(c,d);k=F9b(new L9b(c.n,d),b);p8b(b.g,k,b)}}for(i=j.Vd();i.Id();){h=i.Jd();f=F9b(new J9b(Bdc),h);r8b(f,h.Sh(false));r8b(f,h.Sh(false));q8b(g,f)}w7(a.b,b.g)}}function e7(a,b,c,d){var e,f,g,h,i,j,k,l,m,n;
if(a.G.yc){b.c.a.length>0&&!(b.c.a.length>gMc.length&&Esc(gMc,xqc(b.c,b.c.a.length-gMc.length)))&&$7(b,gMc);Xd(c.n==(Afc(),Xec));f=a.G.Jb;i=H8b(c,(Hbc(),cbc)).a;n=(g=H8b(c,ybc),!g?null:g.ug());Xd(n!=null);Xd(n.length!=0);f=Osc(Osc(Osc(f,"%name%",ZIc(i)),"%num%",""+d),"%n%",gMc);$7($7(b,f),gMc)}if(H8b(c,(Hbc(),mbc))){l=D4b(H8b(c,mbc));l!=null&&jDc(b.d,l)&&$7($7($7(b,"/*\n"),l),"*/\n")}e=F7(a,c,d==0);if(e.length!=0){$7(b,e);k=e.length;j=e.charCodeAt(k-1);m=k>=2?e.charCodeAt(k-2):0;h=j==59||j==10&&m==
59;h||$7(b,";")}return null}function EHb(){EHb=JZ;DHb=new Mcb("JSC_REQUIRES_NOT_SORTED",(E2(),D2),new Rtc("goog.require() and goog.requireType() statements are not sorted. (Fix with go/fixjs) The correct order is:\n\n{0}\n"));CHb=new Mcb("JSC_PROVIDES_NOT_SORTED",D2,new Rtc("goog.provide() statements are not sorted. (Fix with go/fixjs) The correct order is:\n\n{0}\n"));BHb=new Mcb("JSC_PROVIDES_AFTER_REQUIRES",D2,new Rtc("goog.provide() statements should be before goog.require() and goog.requireType() statements."));
AHb=new Mcb("JSC_DUPLICATE_REQUIRE",D2,new Rtc("''{0}'' required more than once."))}function XTb(a,b){var c,d;if(AVb(a,(AZb(),ZYb)))return cUb(a);else{d=new sWb(DWb(a.g,0).d.b);d.b=b;d.a=a.b.d&&QCc(MCc(TYb,CE(xE(XR,1),sLc,14,0,[SYb,RYb])),DWb(a.g,0).e)?wTb(a).e:null;d.c=!!mTb(a,fZb);return zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,nNc)&&(KVb(a,1)||DWb(a.g,1).e==HYb)?uUb(a,d):zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,"set")&&(KVb(a,1)||DWb(a.g,1).e==HYb)?eVb(a,d):zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,GNc)&&(c=DWb(a.g,1).d.b.b>
DWb(a.g,0).d.a.b,!(c||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&(KVb(a,1)||DWb(a.g,1).e==HYb||zVb(a,1,bZb)&&(KVb(a,2)||DWb(a.g,2).e==HYb))?OTb(a,d):ZTb(a,d)}}function qD(b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q;c=new oD;f=null;try{f=$wnd.JSON.parse(b)}catch(a){a=fZ(a);if(pF(a,38)){d=a;throw gZ(new rD("JSON parse exception: "+d));}else throw gZ(a);}q=f;nD(c,q.version);iD(c,q.file);c.c=-1;jD(c,q.mappings);if(q.sections!=null){l=(Bn(),new Zr);for(n=q.sections,o=0,p=n.length;o<p;++o){m=n[o];Xr(l,pD(m))}lD(c,
In(l.a))}else c.f=null;mD(c,q.sources);kD(c,q.names);e=new tEc;k=$wnd.Object.keys(q);for(h=k,i=0,j=h.length;i<j;++i){g=h[i];Esc(g.substr(0,2),"x_")&&qEc(e,g,q[g])}hD(c,(Cyc(),new uAc(e)));return new gD(c.i,c.c,c.b,c.d,c.g,c.e,c.f,c.a)}function $sb(b,c,d){var e,f,g,h,i;f=b.c.b.p;g=b.a.jh();if(!g.a.Td(f.a)){i=new uQb(wQb(f.a,g.a));u7(b.c.b,Kmb((E2(),B2),(Msb(),Jsb),CE(xE(nW,1),uNc,2,6,[b.b,"Running pass anyway.",i.a.Bd()])))}GIc((Msb(),Lsb),"Running pass "+b.b);!!b.c.r&&(b.c.a=C1(new J1(b.c.b),b.c.d));
!!b.c.p&&wsb(b.c.p,b.b,b.a.c);b.d=new hyb;b.a.ih(b.c.b).wg(c,d);x6(b.c.b);try{if(!b.c.n)A7(b.c.b,-1);else{b.c.k+=b.c.o;A7(b.c.b,b.c.k)}h=gyb(b.d);!!b.c.p&&xsb(b.c.p,b.b,h);Osb(b.c,b.b,d);Psb(b.c,b.b,c,d)}catch(a){a=fZ(a);if(pF(a,18)){e=a;throw gZ(new HD("Validity check failed for "+b.b,e));}else throw gZ(a);}}function Mgb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;Kd(b.n==(Afc(),Fec)||b.n==Acc);n=LPc+a.b++;if(lqb(b.g)){i=b.g;c=i.c?i.c.i:null;d=r3b((l=(ae(Hsc(n,_sc(46))==-1,HMc,n),n8b(),new Wbc(rec,n)),l),ufc);
I9b(d,b);j9b(i,b,d);h=t3b((m=h3b(b,(k=(ae(Hsc(n,_sc(46))==-1,HMc,n),new Wbc(rec,n)),k)),m));I9b(h,b);r8b(c,h)}else{g=b.g;Xd(g.n==odc);e=g.g;i=e.g;Xd((ppb(),i.n==Idc||i.n==Gdc||i.n==Hdc));c=i.c?i.c.i:null;j9b(e,g,F9b((l=(ae(Hsc(n,_sc(46))==-1,HMc,n),n8b(),new Wbc(rec,n)),l),b));f=e.n;d=q3b(z8b(b),(k=(ae(Hsc(n,_sc(46))==-1,HMc,n),new Wbc(rec,n)),k),f);I9b(d,b);j=j3b(d);j9b(c.g,c,j);q8b(j,c)}}function mVb(a,b){var c,d,e,f,g,h,i;f=!b?DWb(a.g,0).d.b:b.o.b;h=wTb(a);pF(h,253)||SVb(a,h,"Unexpected template literal token %s.",
CE(xE(iW,1),mLc,1,5,[BZb(h.e)]));e=!!b;g=h;e||g.a!=null&&UVb(a,g.b,CE(xE(iW,1),mLc,1,5,[g.a]));c=(Bn(),new Zr);Xr(c,new A1b(g.d,g));if(g.e==(AZb(),BYb))return new z1b(new Z1b(f,a.f),b,In(c.a));d=xTb(a,1);Xr(c,new B1b(d.o,d));while(!a.c.d){g=(i=AWb(a.g),a.f=i.d.a,i);if(g.e==aYb||g.e==XXb)break;e||g.a!=null&&UVb(a,g.b,CE(xE(iW,1),mLc,1,5,[g.a]));Xr(c,new A1b(g.d,g));if(g.e==lZb)break;d=xTb(a,1);Xr(c,new B1b(d.o,d))}return new z1b(new Z1b(f,a.f),b,In(c.a))}function Ggb(a,b,c){var d,e,f,g,h,i,j,k,l,m,
n,o,p,q;g=null;d=c.c?c.c.i:null;f=0;n=null;for(o=b.c;o;o=n,f++){n=o.f;if(o.n==(Afc(),mdc)){k=g9b(o);i=H8b(k,(Hbc(),mbc));d9b(k,mbc,null);e=g9b(o);h=false;k.n==rec&&(e.n==rec?h=Esc(vPc,e.Wh()):e.n==vfc&&(h=tqb(e.c)));if(h)l=x8b(k,false);else{l=k.n==rec?k:X$(LPc+a.b++);j=x8b(k,false);q=Cgb(x8b(l,false),e);m=k.n==rec?t3b((p=h3b(j,q),p)):q3b(j,q,ufc);I9b(m,o);o8b(d,m,g);g=m}j9b(b,o,l);c9b(l,qbc,1);d9b(l,mbc,i);v7(a.a,c)}else if(o.n==Fec||o.n==Acc){g=Kgb(c,g,o,LPc+a.b++);v7(a.a,c)}else if(o.n==Sec&&T8b(o.c)){g=
Kgb(c,g,o.c,LPc+a.b++);v7(a.a,c)}}}function IE(a,b,c){var d,e,f,g,h,i;if(b.l==0&&b.m==0&&b.h==0)throw gZ(new Dqc("divide by zero"));if(a.l==0&&a.m==0&&a.h==0){c&&(EE=HE(0,0,0));return HE(0,0,0)}if(b.h==uMc&&b.m==0&&b.l==0)return JE(a,c);i=false;if(b.h>>19!=0){b=XE(b);i=!i}g=PE(b);f=false;e=false;d=false;if(a.h==uMc&&a.m==0&&a.l==0){e=true;f=true;if(g==-1){a=GE((iF(),eF));d=true;i=!i}else{h=ZE(a,g);i&&NE(h);c&&(EE=HE(0,0,0));return h}}else if(a.h>>19!=0){f=true;a=XE(a);d=true;i=!i}if(g!=-1)return KE(a,
g,i,f,c);if(UE(a,b)<0){c&&(f?EE=XE(a):EE=HE(a.l,a.m,a.h));return HE(0,0,0)}return LE(d?a:HE(a.l,a.m,a.h),b,i,f,e,c)}function rE(a,b){var c,d,e,f,g,h,i,j,k;j="";if(b.length==0)return a.hg(rMc,pMc,-1,-1);k=Ysc(b);Esc(k.substr(0,3),"at ")&&(k=k.substr(3));k=k.replace(/\[.*?\]/g,"");g=k.indexOf("(");if(g==-1){g=k.indexOf("@");if(g==-1){j=k;k=""}else{j=Ysc(k.substr(g+1));k=Ysc(k.substr(0,g))}}else{c=k.indexOf(")",g);j=k.substr(g+1,c-(g+1));k=Ysc(k.substr(0,g))}g=Hsc(k,_sc(46));g!=-1&&(k=k.substr(g+1));
(k.length==0||Esc(k,"Anonymous function"))&&(k=pMc);h=Jsc(j,_sc(58));e=Ksc(j,_sc(58),h-1);i=-1;d=-1;f=rMc;if(h!=-1&&e!=-1){f=j.substr(0,e);i=mE(j.substr(e+1,h-(e+1)));d=mE(j.substr(h+1))}return a.hg(f,k,i,d)}function K1(a,b){var c,d,e,f;if(!a||!b)return!a&&!b;if(!a.Xh(b,false,false,false,true))return false;if(C8b(a)!=C8b(b))return false;if(a.n==(Afc(),Jdc)&&b.n==Jdc){ppb();if((a.n==Jdc&&iqb(a.g)&&a.n==Jdc&&Gqb(a.c))!=(b.n==Jdc&&iqb(b.g)&&b.n==Jdc&&Gqb(b.c)))return false}if(!!a.g&&a.g.n==Jec)if(E8b(a,
(Hbc(),lbc))!=0!=(E8b(b,lbc)!=0))return false;e=a.c;c=b.c;while(!!e&&!!c){if(e.n==Jdc||e.n==Xec){if(c.n!=e.n)return false;if(e.n==Jdc&&(ppb(),e.n==Jdc&&iqb(e.g)&&e.n==Jdc&&Gqb(e.c))){f=e.c.Wh();d=c.c.Wh();if(!Esc(f,d))return false}}else if(!K1(e,c))return false;e=e.f;c=c.f}return true}function Spb(a){var b;switch(a.n.f){case 118:if(!!a.c&&!a.c.f)return Spb(a.c);break;case 120:return yoc(),null!=a.Th()&&a.Th().length!=0?woc:voc;case 31:return yoc(),a.Wh().length>0?woc:voc;case 30:return yoc(),a.Uh()!=
0?woc:voc;case 19:return Spb(a.c?a.c.i:null).fj();case 32:case 34:return yoc(),voc;case 79:if(!upb(a.c,false,null))return yoc(),voc;break;case 29:b=a.Wh();if(Esc(vPc,b)||Esc("NaN",b))return yoc(),voc;else if(Esc(xQc,b))return yoc(),woc;break;case 35:case 38:return yoc(),woc;case 65:case 96:case 23:case 42:case 43:if(!upb(a,false,null))return yoc(),woc}return yoc(),xoc}function Zfb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;h=E8b(c,(Hbc(),zbc))!=0?b.e:b.f;i=c.n==(Afc(),fdc)?Kpb(h,c.c):Lpb(h,c.Wh());if(!i){i=
r9b(P3b(CE(xE(HU,1),IMc,7,0,[(k=W3b("configurable",(l=new J9b(nfc),l)),k),(m=W3b(GPc,(n=new J9b(nfc),n)),m)])),a.b);if(c.n==fdc)q8b(h,(o=p3b(x8b(c.c,false),i),o));else{q=(o=W3b(c.Wh(),i),o);c.Yh()&&b9b(q,(n8b(),i8b),true);q8b(h,q)}}e=c.c?c.c.i:null;f=E7b((ppb(),g=Dpb(e),!g?null:H8b(g,mbc)));p7b(f,new H7b(new L9b(Qcc,V3b(I8b(b.g))),(d=H8b(c,ybc),!d?null:d.ug())));p=(j=W3b(c.n==Qdc||E8b(c,(n8b(),M7b))!=0?nNc:"set",z8b(e)),j);q9b(p,k6b(f));q8b(i,p);I9b(i,c)}function rlb(a,b,c,d,e,f){var g,h,i;if(ylb(a,
b,c,d,e,f))return;switch(e.n.f){case 84:case 66:case 41:case 25:case 79:case 19:case 20:case 21:case 22:i=(cmb(),Zlb);break;case 28:d==e.c?i=(cmb(),Xlb):vlb(a,e)?i=(cmb(),Zlb):i=(cmb(),Wlb);break;case 23:i=d==e.c?(cmb(),Zlb):(cmb(),Wlb);break;case 61:case 62:i=mlb(e,f);break;case 60:d!=e.c?i=mlb(e,f):i=(cmb(),Zlb);break;case 24:i=(cmb(),Ylb);break;case 96:i=(cmb(),bmb);break;case 94:i=(cmb(),Wlb);break;case 95:case 47:g=d==d.g.c?null:d.i;i=g.n==(Afc(),Fec)?(cmb(),Zlb):(cmb(),Wlb);break;default:i=
(cmb(),Wlb)}h=plb(a,f);jlb(a,h,d,i,b,c)}function rTb(a,b){var c,d,e,f,g,h,i;if(b.p==(n1b(),q0b)){f=b.a;return Esc(f.a,GNc)&&(h=DWb(a.g,0).d.b.b>a.f.b,!(h||zVb(a,0,(AZb(),ZYb))||zVb(a,0,(AZb(),KXb))||zVb(a,0,(AZb(),XXb))))&&(i=DWb(a.g,0).e,(AZb(),iYb)==i||a.b.d&&VSb(i)||!a.b.c&&USb(i))&&(g=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(g||zVb(a,1,(AZb(),ZYb))||zVb(a,1,(AZb(),KXb))||zVb(a,1,(AZb(),XXb))))&&zVb(a,1,(AZb(),zXb))}else if(b.p==I_b){d=b;e=d.b;c=d.a;return e.p==q0b&&Esc(e.a.a,GNc)&&e.o.a.b==c.o.b.b&&
(g=DWb(a.g,0).d.b.b>a.f.b,!(g||zVb(a,0,(AZb(),ZYb))||zVb(a,0,(AZb(),KXb))||zVb(a,0,(AZb(),XXb))))&&AVb(a,(AZb(),zXb))}else return false}function UEb(a){var b,c,d,e,f,g,h,i,j,k,l,m;for(l=new wxc(a.f);l.a<l.c.a.length;){j=(l.b=l.a++,l.c.a[l.b]);g=j.mh();c=su(g.Vd());(c==null||g.Yd()==1&&Esc(c.substr(0,7),hOc)&&!Esc(kOc,j.lh().Ie(mNc)))&&qEc(a.e,(RFb(),UFb((b=Osc(Osc(Osc(Osc(Osc(Nsc(Nsc(j.ug(),58,45),92,47)," ",cNc),"[",dNc),"]",eNc),"<",fNc),">",gNc),SFb(b)))),j);for(f=j.mh().Vd();f.Id();){e=f.Jd();
_tc(a.b,e,j)}}for(m=new wxc(a.f);m.a<m.c.a.length;){j=(m.b=m.a++,m.c.a[m.b]);for(i=j.nh().Vd();i.Id();){h=i.Jd();d=Ytc(a.b,h);!!d&&Vf(a.d,j,d)}}for(k=new wxc(a.f);k.a<k.c.a.length;){j=(k.b=k.a++,k.c.a[k.b]);TEb(a,j)}a.a.a.Rd();fv(a.d)}function bUb(a){var b,c,d;if(DWb(a.g,1).e==(AZb(),fYb))return $Tb(a,GYb,LXb);d=DWb(a.g,0).d.b;iTb(a,GYb);if(AVb(a,LXb)){iTb(a,LXb);if(AVb(a,zXb))return new G$b(new Z1b(d,a.f),(Bn(),Bn(),An));else{VVb(a,XSc,CE(xE(iW,1),mLc,1,5,[]));return new n_b(new Z1b(d,a.f))}}if(AVb(a,
aZb)){b=(Bn(),new Wz(Sd(SUb(a,0))));iTb(a,LXb);if(AVb(a,zXb))return new G$b(new Z1b(d,a.f),b);else{VVb(a,XSc,CE(xE(iW,1),mLc,1,5,[]));return new n_b(new Z1b(d,a.f))}}c=xTb(a,1);if(AVb(a,OXb)){iTb(a,OXb);c=new ZZb(new Z1b(d,a.f),(Bn(),new hz(Qn(CE(xE(iW,1),mLc,1,5,[c,SUb(a,0)])))))}iTb(a,LXb);return new x_b(new Z1b(d,a.f),c)}function GGb(){GGb=JZ;tp("goog.object.forEach","goog.object.filter","goog.object.map","goog.object.some","goog.object.every","goog.object.getCount",CE(xE(nW,1),uNc,2,6,["goog.object.getAnyKey",
"goog.object.getAnyValue","goog.object.contains","goog.object.getValues","goog.object.getKeys","goog.object.findKey","goog.object.findValue","goog.object.isEmpty","goog.object.clear","goog.object.remove","goog.object.equals","goog.object.clone","goog.object.transpose"]));FGb=new Mcb("JSC_ARRAY_PASSED_TO_GOOG_OBJECT",(E2(),D2),new Rtc("{0} expects an object, not an array. Did you mean to use goog.array?"))}function POb(a,b){var c;if(b.n==(Afc(),wcc)||b.n==Hec||b.n==zec)return QOb(a,b);if(b.n!=Ycc){a.a.Bh(URc+
occ(kSc,CE(xE(iW,1),mLc,1,5,[XKc])),a.b.ug(),a.d,a.c);return false}if(!MOb((Pd(b.n==Ycc,iSc,b),b.c.Wh()))){a.a.Bh(URc+occ(jSc,CE(xE(iW,1),mLc,1,5,["boolean predicate"])),a.b.ug(),a.d,a.c);return false}c=PPb($b((Pd(b.n==Ycc,iSc,b),b.c.Wh())));if(!JOb(a,b,c))return false;switch(c.a){case 3:return fPb(a,b,(Pd(b.n==Ycc,iSc,b),C8b(b)-1));case 2:return aPb(a,b,(Pd(b.n==Ycc,iSc,b),C8b(b)-1));case 4:return iPb(a,b,(Pd(b.n==Ycc,iSc,b),C8b(b)-1));default:throw gZ(new Irc("Invalid boolean expression"));}}function Rvb(a,
b,c){var d,e,f,g,h,i,j,k;if(V8b(c)&&Lvb(a.b.b,c)){h=I8b(c);f=false;for(e=(Avb(),yvb).Vd();e.Id();){d=e.Jd();if(Esc(h.substr(0,d.length),d)){h=Usc(h,d.length);f=true;break}}i=Po(a.b.b.b,h);!!i&&!f&&(k=Upb(c),k.n!=(Afc(),rec)||!!i$(Kob(b),k.Wh()))&&(i=null);if(!!i&&!imb(a,h)){Dvb(a.b,i.c)||Uob(b,c,zvb,CE(xE(nW,1),uNc,2,6,[h,nQb(l9(a.b.a.G))]));!Dvb(a.b,i.b)&&i.a.length!=0&&jDc(a.a,i.a);return}}if(c.n==(Afc(),Pdc)&&(c.c?c.c.i:null).n==bfc){h=(c.c?c.c.i:null).Wh();g=nm(a.b.b.a,h);if(!g.Ud()&&!imb(a,"."+
h))for(j=g.Vd();j.Id();){i=j.Jd();!Dvb(a.b,i.b)&&i.a.length!=0&&jDc(a.a,i.a)}}return}function KTb(a,b){var c,d,e,f,g,h,i,j;if(zVb(a,0,(AZb(),zZb))&&uwc(a.e).b)return yVb(a,b);f=DWb(a.g,0).d.b;c=aUb(a,b);if(rTb(a,c)){a.f=c.o.b;NWb(a.g,a.f.c);return MTb(a,b)}if(zVb(a,0,zXb))return c.p==(n1b(),I_b)?hTb(a,c):(g=XVb(a,c),h=DWb(a.g,0).d.b.b>a.f.b,(h||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb))&&VVb(a,VSc,CE(xE(iW,1),mLc,1,5,[])),iTb(a,zXb),i=JTb(a,b,(pWb(),oWb)),j=M$b(L$b(new T$b((Y$b(),U$b)),g),i),I$b(j,
pTb(a,g.o.b)));if(CVb(a)){c=WVb(a,c);if(!HZb(c)){VVb(a,WSc,CE(xE(iW,1),mLc,1,5,[]));return new n_b(pTb(a,DWb(a.g,0).d.b))}d=wTb(a);e=KTb(a,b);return new RZb(new Z1b(f,a.f),c,d,e)}return c}function s_(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;switch(b.n.f){case 98:F_(a,(IRb(),gRb),b);g0(b);j=Cfc(b.n);j!=-1&&(e=C8b(b),j!=e&&D0(QMc+j+RMc+e,b));n=b.c;c?G_(a,n,true):G_(a,n,false);break;case 86:case 87:F_(a,(IRb(),OQb),b);g0(b);k=Cfc(b.n);k!=-1&&(f=C8b(b),k!=f&&D0(QMc+k+RMc+f,b));m=b.c;c?G_(a,m,true):G_(a,m,false);
break;case 159:g=C8b(b);0!=g&&D0(OMc+g,b);break;case 116:w_(a,b);break;case 160:l=Cfc(b.n);l!=-1&&(h=C8b(b),l!=h&&D0(QMc+l+RMc+h,b));q_(b.c,0);break;case 161:i=Cfc(b.n);i!=-1&&(d=C8b(b),i!=d&&D0(QMc+i+RMc+d,b));break;case 80:break;default:D0("Class contained member of invalid type "+b.n,b)}}function q2b(a){var b,c,d,e,f;if(a.a==null)return a.b.k=false,j2b(a,jLc,0);if(!rF(a.a))throw gZ(g2b(a));e=t2b(a);if(e!=null)return e;b=a.b.b;b!=97&&b!=65&&a.b.n==-1&&(a.b.n=6,undefined);d=new stc;switch(b){case 97:case 65:l2b(a);
break;case 101:case 69:m2b(a,d);break;case 102:n2b(a,d);break;case 103:case 71:u2b(a,d);break;default:throw gZ(O2b(a.b));}a.b.n=-1;f=0;if(45==d.a.charCodeAt(0)){if(a.b.g)return v2b(a,d)}else{if(a.b.j){rtc(d,0,String.fromCharCode(32));++f}if(a.b.d){rtc(d,0,String.fromCharCode(43));++f}}c=d.a.charCodeAt(0);a.b.k&&(c==43||c==45)&&(f=1);(b==97||b==65)&&(f+=2);return j2b(a,d,f)}function rhb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;e=jhb(a,g9b(b));i=b.c;f=i.f;if(E8b(i,(Hbc(),gbc))==0&&(!f||E8b(f,gbc)==0)){r8b(b,
e);c9b(b,gbc,0);whb(a,b);return}z8b(i);!f?f=F9b((d=new J9b((Afc(),Vcc)),d),b):z8b(f);if(E8b(i,gbc)!=0&&E8b(f,gbc)==0){e=F9b(Yjb(Z3b((Afc(),zec),e),a.f.a),e);n=i;i=f;f=n}if(E8b(i,gbc)==0){h=Thb(a.a,c);k=Ghb(a.a,h,false,i);while(k.c){l=g9b(k);c9b(l,hbc,1);q8b(i,l)}whb(a,F9b(B3b(e,i),b));thb(a,f,null,null);cib(a.a,h);return}j=new pib(a.a);g=Thb(a.a,c);e=khb(a,e);m=Ghb(a.a,j,true,b);eib(a.a,F9b(B3b(khb(a,e),m),b));thb(a,f,null,null);gib(a.a,g,f);cib(a.a,j);thb(a,i,null,null);cib(a.a,g)}function E6(a,
b){var c,d,e,f,g,h,i,j,k,l,m,n;V6(a);e=new fxc;i=new fDc;h=new fDc;for(g=new Tu(wu($t(Tt(Wt(new eyc(a.B.a),new lnb)).a),new Xt));Ru(g);){f=Su(g);a.G.Z.b!=(Sbb(),Pbb)&&y8(f).f.Ud()&&(e.a[e.a.length]=f,true);_tc(h,n1(o1(z8(f).a)),f);for(m=y8(f).f.Vd();m.Id();){l=m.Jd();Esc(l.substr(0,7),hOc)||(l==null?FDc(i.d,null,f):ZDc(i.e,l,f))}}for(k=xu(new Wzc(a.G.Z.a.a.b.Vd()));k.Id();){j=k.Jd();f=Ytc(i,n1(j));!f&&(f=Ytc(h,n1(j)));!!f&&(e.a[e.a.length]=f,true)}n=sz(new Tu(wu($t(Tt(Wt(new eyc(a.B.a),new lnb)).a),
new Xt)));for(d=new wxc(e);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);F6(a,c,false,n,h,i,b,false)}}function lgc(a,b){var c,d,e;if(!!a.Ii()&&!!b.Ii())return Jjc(a.Ii(),b.Ii(),false);else{d=new ukc(false);if(Qfc(a,b,0,d))return a;else if(a.Bi()||b.Bi())return c=new ukc(false),Qfc(a,b,0,c)?a:a.A.u[51];else if(a.Mi())return Uoc(a.Mi(),b);else if(b.Mi())return Uoc(b.Mi(),a);else if(a.Li())return ioc(a.Li(),b);else if(b.Li())return ioc(b.Li(),a);else if(a.zi(b))return igc(a);else if(b.zi(a))return igc(b);
else if(a.Ji())return mnc(a.Ji(),b);else if(b.Ji())return mnc(b.Ji(),a)}if(a.Gi()){e=bic(a.Gi(),b);if(e)return e}else if(b.Gi()){e=bic(b.Gi(),a);if(e)return e}if(a.xi()&&b.xi())return a.A.u[59];return a.A.u[58]}function Gyb(a,b){Fyb();m9(b,(iQb(),eQb))&&Ywc(a,Byb);if(m9(b,UPb)){Ywc(a,yyb);Ywc(a,Eyb)}if(m9(b,cQb)){Ywc(a,new eAb("markTrailingCommasInParameterListsRemoved",(IRb(),ERb),CE(xE(FR,1),sLc,24,0,[])));Ywc(a,xyb)}m9(b,aQb)&&Ywc(a,Cyb);if(m9(b,$Pb)){Ywc(a,new eAb("markEs6FeaturesNotRequiringTranspilationAsRemoved",
(IRb(),JQb),CE(xE(FR,1),sLc,24,0,[oRb,sRb,tRb])));Ywc(a,oyb);Ywc(a,syb);Ywc(a,iyb);Ywc(a,pyb);Ywc(a,vyb);Ywc(a,new aAb((Wgb(),Ugb)));Ywc(a,qyb);Ywc(a,lyb);Ywc(a,ryb);Ywc(a,uyb);Ywc(a,wyb);Ywc(a,myb);Ywc(a,Ayb);Ywc(a,zyb);Ywc(a,Dyb);Ywc(a,jyb)}else if(n9(b,(IRb(),nRb))){Ywc(a,pyb);Ywc(a,vyb);Ywc(a,new aAb((Wgb(),Vgb)))}}function xD(a){uD();var b,c,d;d=new ttc;d.a+='"';for(c=0;c<a.length;c++){b=a.charCodeAt(c);switch(b){case 10:d.a+="\\n";break;case 13:d.a+="\\r";break;case 9:d.a+="\\t";break;case 92:d.a+=
"\\\\";break;case 34:d.a+='\\"';break;case 39:d.a+="'";break;case 62:c>=2&&(a.charCodeAt(c-1)==45&&a.charCodeAt(c-2)==45||a.charCodeAt(c-1)==93&&a.charCodeAt(c-2)==93)?(d.a+="\\u003e",d):(d.a+=String.fromCharCode(b),d);break;case 60:Msc(a,true,c+1,"/script",0,7)?(d.a+="\\u003c",d):Msc(a,false,c+1,"!--",0,3)?(d.a+="\\u003c",d):(d.a+=String.fromCharCode(b),d);break;default:b>31&&b<=127?(d.a+=String.fromCharCode(b),d):wD(d,b)}}d.a+='"';return d.a}function Gjb(a){var b,c,d,e,f;f=a.d.d;a.b=Mpb(f);switch(f.n.f){case 65:{e=
f.c;b=e.f;Xd(b.n==(Afc(),Jec));Ejb(a,a.d,b);d=e.Wh();d.length!=0&&(ppb(),f.n==Jdc&&!(f.n==Jdc&&iqb(f.g)&&f.n==Jdc&&Gqb(f.c))&&!Bqb(f))&&Fjb(a,a.d,e);return}case 96:{c=f.c;c.n!=(Afc(),tdc)&&(ppb(),f.n==bdc&&(!(f.n==bdc&&Gqb(f.c))||!iqb(f.g)))&&Fjb(a,a.d,c);return}case 81:case 85:Yd(!a.d.b,a.d);Hjb(a,f,a.d,a.d);return;case 112:Hjb(a,f,a.d,a.d);return;case 72:case 101:case 102:case 73:case 67:Hjb(a,f,null,a.d);return;case 82:ppb();f.n==(Afc(),Vcc)&&!!f.g&&f.g.n==Jdc?Hjb(a,f,a.d,a.d):Hjb(a,f,null,a.d);
return;default:throw gZ(new GD("Illegal scope root: "+f));}}function BKc(a,b){var c,d,e,f,g,h,i,j,k;e=0;for(i=0;i<b;){++e;d=a[i];if((d&192)==128)throw gZ(new qnb(QTc));else if((d&128)==0)++i;else if((d&224)==192)i+=2;else if((d&240)==224)i+=3;else if((d&248)==240)i+=4;else throw gZ(new qnb(QTc));if(i>b)throw gZ(new Fqc(QTc));}f=zE(xF,eLc,46,e,15,1);k=0;g=0;for(h=0;h<b;){d=a[h++];if((d&128)==0){g=1;d&=127}else if((d&224)==192){g=2;d&=31}else if((d&240)==224){g=3;d&=15}else if((d&248)==240){g=4;d&=
7}else if((d&252)==248){g=5;d&=3}while(--g>0){c=a[h++];if((c&192)!=128)throw gZ(new qnb("Invalid UTF8 sequence at "+(h-1)+", byte="+(j=c>>>0,j.toString(16))));d=d<<6|c&63}k+=Zqc(d,f,k)}return f}function TBb(a,b){var c,d,e,f,g,h;h=b.d;Xd(b.n==(Afc(),Jdc)||!!h.Ii());if(!h||h.Bi())return"";c=h.Ii();if(Rfc(h,a.b.u[17]))return"/** @type {!Function} */\n";f=new vtc("/**\n");d=null;!!b&&b.n==Jdc&&(d=(ppb(),Kd(b.n==Jdc),b.c.f).c);OBb(a,f,c,d);e=c.b.b;if(!!e&&!(e.ti()||e.ri()||e.si()||e==e.A.u[64])&&c.f!=
(dkc(),bkc)&&!(c.oi()&&e.Ci())){f.a+=mRc;aCb(f,ENc,Pfc(e,new stc,true).a);f.a+=gMc}if(c.oi()){NBb(f,c);f.a+=" * @constructor\n"}else if(c.f==(dkc(),bkc))PBb(f,c);else{g=Yfc(c.k)?c.A.u[51]:c.k;if(!!g&&!g.Bi()&&!g.Ci())if(!b||!Rfc(g,RBb(a,b))){f.a+=mRc;aCb(f,FMc,Pfc(g,new stc,true).a);f.a+=gMc}}QBb(f,Vfc(c));f.a+=" */\n";return f.a}function H3b(a){switch(a.n.f){case 65:case 96:return true;case 13:case 62:case 42:case 47:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 59:case 57:case 58:case 104:case 3:case 1:case 20:case 2:case 28:case 92:case 46:case 64:case 24:case 16:case 4:case 18:case 34:case 9:case 26:case 27:case 8:case 60:case 40:case 63:case 41:case 7:case 10:case 6:case 17:case 15:case 29:case 5:case 22:case 23:case 122:case 19:case 30:case 32:case 43:case 61:case 21:case 38:case 11:case 36:case 37:case 115:case 31:case 14:case 99:case 118:case 117:case 33:case 25:case 35:case 12:case 79:case 103:return true;
default:return false}}function PWb(a){var b;b=eXb(a);if(xWb(a,a.f))switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 47:switch(xWb(a,a.f+1)?zsc(a.b,a.f+1):0){case 47:_Wb(a,(e$b(),c$b));return true;case 42:UWb(a);return true}break;case 60:if((xWb(a,a.f+1)?zsc(a.b,a.f+1):0)==33&&(xWb(a,a.f+2)?zsc(a.b,a.f+2):0)==45&&(xWb(a,a.f+3)?zsc(a.b,a.f+3):0)==45){GWb(a,aTc,CE(xE(iW,1),mLc,1,5,[]));_Wb(a,(e$b(),c$b));return true}break;case 45:if(b&&(xWb(a,a.f+1)?zsc(a.b,a.f+1):0)==45&&(xWb(a,a.f+2)?zsc(a.b,a.f+2):0)==62){GWb(a,
aTc,CE(xE(iW,1),mLc,1,5,[]));_Wb(a,(e$b(),c$b));return true}break;case 35:if(a.f==0&&(xWb(a,a.f+1)?zsc(a.b,a.f+1):0)==33){_Wb(a,(e$b(),d$b));return true}}return false}function SUb(a,b){var c,d,e,f,g,h,i;e=DWb(a.g,0).d.b;d=null;if(AVb(a,(AZb(),aZb)))d=(i=DWb(a.g,0).d.b,iTb(a,aZb),new t1b(new Z1b(i,a.f),cVb(a,0)));else{f=DWb(a.g,0).e;if(iYb==f||a.b.d&&VSb(f)||!a.b.c&&USb(f)){d=wUb(a);if(AVb(a,UYb)){iTb(a,UYb);d=new v_b(new Z1b(e,a.f),d)}}else if(b!=2&&(zVb(a,0,HYb)||zVb(a,0,FYb)))d=UUb(a,0);else throw gZ(new Irc("parseParameterCalled() without confirming a parameter exists."));
}g=null;h=null;if(AVb(a,NXb)){if(zVb(a,1,gZb)){iTb(a,NXb);g=GUb(a)}else g=(iTb(a,NXb),nVb(a));h=pTb(a,DWb(a.g,0).d.b)}if(b==0&&d.p!=(n1b(),Q0b)&&AVb(a,ZXb)){iTb(a,ZXb);c=KTb(a,1);d=new t$b(new Z1b(e,a.f),d,c)}!!g&&(d=new I1b(h,d,g));return d}function zdb(a,b){var c,d,e,f,g,h,i,j,k;if(!a.c)return false;i=glb(a.c,b);if(!i)return false;d=i.d;if(!d)for(k=(Cyc(),new Wzc((new Fzc(i.p)).b.Vd()));k.b.Id();){j=k.b.Jd();(j.g==(cmb(),_lb)||j.g==amb)&&(d=j)}if(!d)return false;f=d.c;g=H8b(f,(Hbc(),ybc));if(!!g&&
g.Kh())return false;c=f.g;e=null;if(c.n==(Afc(),Jdc))e=c;else{ppb();if(!!c&&(c.n==ufc||c.n==jec||c.n==gdc)&&f.n==rec)if(f.c)e=Sd(f.c);else return false;else if(c.n==Ccc&&c.c==f)e=Sd(c.c.f);else if(c.n==Eec&&!!f.c&&!f.c.f)e=Sd(f.c);else throw gZ(new Irc("Unexpected declaration format:\n"+E9b(c)));}if(e.n==Jdc){h=Sd(B8b(e,2));return!Ldb(new Mdb(a),h)}else return V8b(e)&&zdb(a,I8b(e))}function kB(b,c){var d,e,f,g,h,i,j;this.f=Sd(b);this.c=Sd(c);try{this.a=SB(c.length,(Itc(),Gtc))}catch(a){a=fZ(a);if(pF(a,
197)){f=a;throw gZ(new rnb("Illegal alphabet length "+c.length,f));}else throw gZ(a);}g=$wnd.Math.min(8,Src(this.a));try{this.d=8/g|0;this.b=this.a/g|0}catch(a$1){a$1=fZ(a$1);if(pF(a$1,197)){f=a$1;throw gZ(new rnb("Illegal alphabet "+gtc(c,0,c.length),f));}else throw gZ(a$1);}e=zE(wF,cMc,46,128,15,1);Kxc(e,e.length);for(i=0;i<c.length;i++){d=c[i];Md(d<e.length,"Non-ASCII character: %s",d);Md(e[d]==-1,"Duplicate character: %s",d);e[d]=i<<24>>24}this.e=e;j=zE(dZ,{1109:1,3:1},46,this.d,16,1);for(h=0;h<
this.b;h++)j[RB(h*8,this.a,(Itc(),Atc))]=true;this.g=j}function DKb(a,b){var c,d;if(b.n==(Afc(),Xcc)||b.n==hdc){c=b.c;if(c){d=b.g;while(d.n!=eec||!Esc(d.c.Wh(),c.Wh())){if(d.n==Jdc||d.n==Xec){a.d.Ah(x2b('undefined label "%s"',CE(xE(iW,1),mLc,1,5,[c.Wh()])),a.q,T9b(b.k),S9b(b.k));break}d=d.g}d.n==eec&&Esc(d.c.Wh(),c.Wh())&&b.n==hdc&&!NKb(d.c?d.c.i:null)&&a.d.Ah("continue can only use labeles of iteration statements",a.q,T9b(b.k),S9b(b.k))}else if(b.n==hdc){d=b.g;while(!NKb(d)){if(d.n==Jdc||d.n==Xec){a.d.Ah("continue must be inside loop",
a.q,T9b(b.k),S9b(b.k));break}d=d.g}}else{d=b.g;while(!MKb(d)){if(d.n==Jdc||d.n==Xec){a.d.Ah("unlabelled break must be inside loop or switch",a.q,T9b(b.k),S9b(b.k));break}d=d.g}}}}function vGb(a,b,c){sGb();var d,e,f,g,h,i,j,k;k=tGb();g=new v9;o9(g,(uab(),mab));g.Pb=new Ie(Sd((Nqc(),true)));switch(c){case rRc:case "es9":h=(iQb(),eQb);break;case "es8":h=(iQb(),cQb);break;case "es7":h=(iQb(),aQb);break;case kOc:h=(iQb(),$Pb);break;case "es5":h=(iQb(),ZPb);break;default:h=(iQb(),YPb)}p9(g,sQb(h,(IRb(),
iRb),CE(xE(FR,1),sLc,24,0,[])));g.cb=new Ie(Sd(false));g.ad=true;f=Vwb("externs.js","var window;",(scc(),qcc));j=Vwb(b,a,qcc);g.wc=true;g.Dc=true;h9(g,new gcb(rGb,(E2(),C2)));q9(g,(wFb(),uFb));d=new wGb(g);x7(d,new xGb);z6(d,(Bn(),new Wz(Sd(f))),new Wz(Sd(j)),g);i=r8(new l8(d));e=tGb();uGb("Transpiled "+b+" in "+(e-k)/1E3+" seconds");return i}function Qtb(){Qtb=JZ;RIc("com.google.javascript.jscomp.ProcessDefines");bn();pp(CE(xE(iW,1),mLc,1,5,["COMPILED","goog.DEBUG"]));Ptb=new Mcb("JSC_UNKNOWN_DEFINE_WARNING",
(E2(),D2),new Rtc("unknown @define variable {0}"));new Mcb("JSC_INVALID_DEFINE_TYPE_ERROR",B2,new Rtc("@define tag only permits literal types"));Otb=new Mcb("JSC_INVALID_DEFINE_INIT_ERROR",B2,new Rtc("illegal initialization of @define variable {0}"));new Mcb("JSC_NON_GLOBAL_DEFINE_INIT_ERROR",B2,new Rtc("@define variable {0} assignment must be global"));new Mcb("JSC_DEFINE_NOT_ASSIGNABLE_ERROR",B2,new Rtc("@define variable {0} cannot be reassigned due to code at {1}."));new Rtc("line {0} of {1}")}
function JWb(a,b,c){var d,e,f,g,h,i,j;j=new stc;j.a+=String.fromCharCode(c);e=c==92;d=false;h=e?1:0;c=xWb(a,a.f)?zsc(a.b,a.f):0;while(hXb(c)||c==92||c==123&&h==2||c==125&&d){c==92&&(e=true);(c==92||h>0)&&++h;c==123&&(d=true);if(c==125||h>=6&&!d){d=false;h=0}itc(j,yWb(a));c=xWb(a,a.f)?zsc(a.b,a.f):0}i=j.a;if(e){i=oXb(i);if(i==null){EWb(a,wWb(a,a.f),_Sc,CE(xE(iW,1),mLc,1,5,[]));return tWb(a,(AZb(),aYb),b)}}g=i.charCodeAt(0);if(!iXb(g)){EWb(a,ZSb(a.i.b,b),"Character '%c' (U+%04X) is not a valid identifier start char",
CE(xE(iW,1),mLc,1,5,[_qc(g),Yrc(g)]));return tWb(a,(AZb(),aYb),b)}f=RSb(i,a.g);if(f)return new NRb(f.b,$Sb(a.i.b,b,a.f));return new PRb($Sb(a.i.b,b,a.f),i)}function ljb(a,b){var c,d,e,f,g,h;if(b.n==(Afc(),zcc))kjb(a,b);else if(b.n==Ycc)mjb(a,b);else{Ld(b.n==xec,b);Kd(b.n==xec);c=g9b(b);d=hjb(a,b);d.a[0].n==zcc?e=axc(d,0):e=r9b(f3b(CE(xE(HU,1),IMc,7,0,[])),a.a);r8b(e,r9b(new J9b(Aec),a.f));f=d.a.length==0?e:r9b(l3b(r9b(x3b(e,(n8b(),new Wbc(bfc,VPc))),a.d),exc(d,zE(HU,IMc,7,0,0,1))),a.a);kQb((iQb(),
YPb),l9(a.c.G))&&Tjb(a.c,b,'"..." passed to a constructor (consider using --language_out=ES5)');g=ijb(r9b(z3b(ijb(r9b((ae(Hsc(nPc,_sc(46))==-1,HMc,nPc),n8b(),new Wbc(rec,nPc)),a.e),aNc),"bind",CE(xE(nW,1),uNc,2,6,[])),a.i),hPc);h=r9b(M3b(gjb(g,CE(xE(HU,1),IMc,7,0,[c,f])),CE(xE(HU,1),IMc,7,0,[])),b.d);I9b(h,b);j9b(b.g,b,h);w7(a.c,h)}}function Oub(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;Kd(!!b);Ld(!!b.a,OQc);Sd(b.b);r=b.b;g=b.a;e=g.c?g.c.i:null;Td(e,g);i=k3b(CE(xE(HU,1),IMc,7,0,[]));r.d&&q8b(i,G9b(d_(PQc,
(m=new J9b((Afc(),lfc)),m)),e));r.b&&q8b(i,G9b(d_(QQc,W$((Kob(c),BMc))),e));for(k=(h=(new Wuc(r.c.a)).a.He().Vd(),new avc(h));k.a.Id();){j=(f=k.a.Jd(),f.Ve());if(a.e){p=$$((n=new J9b((Afc(),lfc)),n));E8b(b.a.g,(Hbc(),zbc))!=0||(p=$$(p))}else p=(n=new J9b((Afc(),ffc)),n);d=g_((o=x3b(p,(n8b(),new Wbc((Afc(),bfc),j))),o));v7(a.a,d);qpb(c.f,(IRb(),GQb));q=RQc+j;q8b(i,q3b((l=(ae(Hsc(q,_sc(46))==-1,HMc,q),new Wbc(rec,q)),l),d,gdc))}I9b(i,e);u8b(e,f9b(i));if(r.d||r.b||r.c.a.Yd()!=0){v7(a.a,g);qpb(c.f,(IRb(),
RQb))}}function mKb(a){var b,c,d,e,f,g;g=a.c;d=Jsc(g,_sc(47));c=Hsc(g,_sc(92));if(c==-1)return g.substr(1,d-1);e=new stc;f=1;while(c!=-1){e.a+=""+(g==null?jLc:g).substr(f,c-f);++c;b=g.charCodeAt(c);switch(b){case 94:case 36:case 92:case 47:case 46:case 42:case 43:case 63:case 40:case 41:case 91:case 93:case 123:case 125:case 124:case 45:case 98:case 66:case 99:case 100:case 68:case 102:case 110:case 112:case 80:case 114:case 115:case 83:case 116:case 117:case 118:case 119:case 87:case 120:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:e.a+=
"\\";default:e.a+=String.fromCharCode(b)}f=c+1;c=Isc(g,_sc(92),f)}e.a+=""+(g==null?jLc:g).substr(f,d-f);return e.a}function Gxc(a,b){var c,d,e,f,g,h,i,j,k,l;if(a==null)return jLc;i=b.a.Je(a,b);if(i!=null)return"[...]";c=new hGc(iLc,"[","]");for(e=a,f=0,g=e.length;f<g;++f){d=e[f];if(d!=null&&(Bb(d).i&4)!=0)if(Array.isArray(d)&&(k=yE(d),!(k>=14&&k<=16)))if(b.a.se(d)){!c.a?c.a=new vtc(c.d):ptc(c.a,c.b);mtc(c.a,"[...]")}else{h=(d==null||Array.isArray(d)&&(l=yE(d),!(l>=14&&l<=16)),d);j=new oDc(b);eGc(c,
Gxc(h,j))}else pF(d,1109)?eGc(c,cyc(d)):pF(d,430)?eGc(c,Xxc(d)):pF(d,77)?eGc(c,Yxc(d)):pF(d,1119)?eGc(c,byc(d)):pF(d,129)?eGc(c,_xc(d)):pF(d,646)?eGc(c,ayc(d)):pF(d,1120)?eGc(c,$xc(d)):pF(d,1121)&&eGc(c,Zxc(d));else eGc(c,d==null?jLc:NZ(d))}return!c.a?c.c:c.e.length==0?c.a.a:c.a.a+(""+c.e)}function tGc(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;if(!a.b)return false;g=null;m=null;i=new XGc(null,null);e=1;i.a[1]=a.b;l=i;while(l.a[e]){j=e;h=m;m=l;l=l.a[e];d=a.a.lf(b,l.d);e=d<0?0:1;d==0&&(!c.c||kFc(l.e,c.d))&&
(g=l);if(!(!!l&&l.b)&&!pGc(l.a[e]))if(pGc(l.a[1-e]))m=m.a[j]=wGc(l,e);else if(!pGc(l.a[1-e])){n=m.a[1-j];if(n)if(!pGc(n.a[1-j])&&!pGc(n.a[j])){m.b=false;n.b=true;l.b=true}else{f=h.a[1]==m?1:0;pGc(n.a[j])?h.a[f]=vGc(m,j):pGc(n.a[1-j])&&(h.a[f]=wGc(m,j));l.b=h.a[f].b=true;h.a[f].a[0].b=false;h.a[f].a[1].b=false}}}if(g){c.b=true;c.d=g.e;if(l!=g){k=new XGc(l.d,l.e);uGc(a,i,g,k);m==g&&(m=k)}m.a[m.a[1]==l?1:0]=l.a[!l.a[0]?1:0];--a.c}a.b=i.a[1];!!a.b&&(a.b.b=false);return c.b}function Qfc(a,b,c,d){var e,
f,g,h;if(!b)return false;else if(a==b)return true;if(a.si()&&b.si())return true;h=a.Bi();g=b.Bi();if(h||g)if(c==2)return true;else if(c==1)return h&&g;else if(h&&g&&a.ui()^b.ui())return false;if(!!a.Mi()&&!!b.Mi())return Noc(a.Mi(),b.Mi(),c,d);if(!!a.Ii()&&!!b.Ii())return ojc(a.Ii(),b.Ii(),c,d);if(!Onc(a.ki(),b.ki(),c,d,0))return false;if(d.c?a.yi()&&b.yi():!!a.Ji()&&!!b.Ji())return yhc(pF(a,48)?a:null,pF(b,48)?b:null,c,d);if(a.ui()&&b.ui()){f=(pF(a,48)?a:null).Xi();e=(pF(b,48)?b:null).Xi();if(f==
null&&e==null);else return f==e}if(!!a.Ki()&&!!b.Ki())return false;if(pF(a,138))return Qfc(a.e,b,c,d);if(pF(b,138))return Qfc(a,b.e,c,d);return false}function C6(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;l=c||!a.G.ad;if(oEc(a.s,b)||!l)return a.w;j=Z2b("js/"+b+fOc);d=(!a.G&&_6(a,new v9),n=Vwb(" [synthetic:"+b+"] ",j,(scc(),qcc)),Bn(),new Wz(Sd(n)),o=new H8(n),r7(a,o.i,o),Sd(x8(o,a)));for(i=d.c;!!i&&i.n==(Afc(),Ddc)&&i.c.n==(Afc(),bfc);i=d.c){f=i.c.Wh();m=Te(Qe(Ye(new nc(32))),f);switch(m.a.ce(0)){case "use":break;
case lNc:C6(a,m.a.ce(1),c);break;default:throw gZ(new GD("Bad directive: "+f));}e9b(d,i)}SZ(a.T)&&(epb(a,d,new Qrb(a,false)),epb(a,d,new hob(new vob(H6(a),new j8(a),"jscomp_"+b+"_"))));h=d.c?d.c.i:null;for(e=d.c;e;e=e.f)Rqb(e,a);g=f9b(d);if(!g)return a.w;k=M6(a);!a.w?u8b(k,g):s8b(k,g,a.w);a.w=h;qEc(a.s,b,h);s7(a,G6(k));i7(a);return h}function ikb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;n=b.g;q=a.g+_Pc+(""+a.d.a.Q++);i=b.c;p=i.f;m=b.c?b.c.i:null;A8b(b);g=null;s=F9b((f=new J9b((Afc(),Vcc)),f),b);
h=F9b((e=new J9b(Vcc),e),b);switch(b.n.f){case 60:g=i;r8b(s,Uqb(pkb(p,d,q)));r8b(h,Uqb(pkb(m,d,q)));break;case 62:g=pkb(i,d,q);r8b(s,Uqb(pkb(m,d,q)));break;case 61:g=pkb(i,d,q);r8b(h,Uqb(pkb(m,d,q)));break;default:throw gZ(new Irc("Unexpected expression: "+b));}h.c?k=(Xd(H3b(g)),Xd(s.n==Vcc),Xd(h.n==Vcc),new O9b(Tdc,g,s,h)):k=B3b(g,s);H9b(k,b);if(d){r=I9b(Zqb(q,null),b);r9b(r.c,a.j);l=c.g;p8b(l,r,c);o8b(l,k,r);o=Yjb((ae(Hsc(q,_sc(46))==-1,HMc,q),n8b(),new Wbc(rec,q)),b.d);j9b(n,b,o)}else{Kd(n.n==
Ddc);j=n.g;j9b(j,n,k)}return k}function k2b(a,b,c){var d,e,f;a.b=b;a.a=c;if(!b.d&&!b.e&&!b.f&&!b.g&&!b.i&&!b.j&&!b.k&&b.p==-1&&b.n==-1)switch(b.b){case 115:if(a.a==null)return jLc;case 100:if(pF(a.a,132)||pF(a.a,156)){e=NZ(a.a);return e}}J2b(a.b,a.a);switch(b.b){case 66:case 98:f=(qF(a.a)?e=NZ(a.a):a.a==null?e=SNc:e=TNc,j2b(a,e,0));break;case 72:case 104:f=r2b(a);break;case 83:case 115:f=(d=etc(a.a),j2b(a,d,0));break;case 67:case 99:f=o2b(a);break;case 100:case 111:case 120:case 88:f=s2b(a);break;
case 65:case 97:case 69:case 101:case 102:case 71:case 103:f=q2b(a);break;case 37:f=j2b(a,"%",0);break;case 110:f=gMc;break;case 116:case 84:f=p2b(a);break;default:throw gZ(O2b(b));}Yqc(b.b)&&f!=null&&(f=$b(NZ(f)));return f}function zqb(a,b){var c,d,e,f;switch(a.n.f){case 92:return zqb(a.c,b);case 42:for(d=a.c;d;d=d.f)if(d.n!=(Afc(),tdc)&&!zqb(d,b))return false;return true;case 38:for(e=a.c;e;e=e.f)if(!zqb(e,b))return false;return true;case 43:for(f=a.c;f;f=f.f)if(f.n==(Afc(),mec)||rqb(f)){if(!b)return false}else if(f.n==
fdc){if(!zqb(f.c,b)||!zqb(f.c?f.c.i:null,b))return false}else if(f.n==_ec){if(!zqb((Xd(!!f.c&&!f.c.f),f.c),b))return false}else{Yd(f.n==cfc,f);if(!zqb((Xd(!!f.c&&!f.c.f),f.c),b))return false}return true;case 65:return b&&!(a.n==(Afc(),Jdc)&&iqb(a.g)&&a.n==Jdc&&Gqb(a.c));case 118:for(c=a.c;c;c=c.f)if(c.n==(Afc(),kfc))if(!zqb(c.c,b))return false;return true;default:return tqb(a)}}function aNb(a,b){var c,d,e,f,g,h,i,j;if(b!=(fOb(),XNb)){a.o=b;return CMb(a,"msg.jsdoc.missing.lp",a.j.g,lOb(a.j)),null}d=
QMb(a,(Afc(),Jdc));h=null;xNb(a);if(!OMb(a,bOb)){b=!a.o?mOb(a.j):GMb(a);e=true;if(b==eOb){j=a.j.n;g=Esc(FMc,j);f=Esc("new",j);if(g||f){if(OMb(a,ONb)){!a.o?mOb(a.j):GMb(a);xNb(a);c=zNb(a,g?lfc:xec,YMb(a,!a.o?mOb(a.j):GMb(a)));if(!c)return null;r8b(d,c)}else return CMb(a,"msg.jsdoc.missing.colon",a.j.g,lOb(a.j)),null;if(OMb(a,PNb)){!a.o?mOb(a.j):GMb(a);xNb(a);b=!a.o?mOb(a.j):GMb(a)}else e=false}}if(e){h=hNb(a,b);if(!h)return null}}!!h&&q8b(d,h);xNb(a);if(!OMb(a,bOb))return CMb(a,aSc,a.j.g,lOb(a.j)),
null;xNb(a);!a.o?mOb(a.j):GMb(a);i=jNb(a);if(!i)return null;else q8b(d,i);return d}function Vib(a,b){var c,d,e,f,g,h,i,j,k;d=(c=new J9b((Afc(),Vcc)),c);u8b(d,f9b(a.g));r8b(d,t3b(V3b(a.i.b)));g=v3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc(rec,"")),R3b(CE(xE(HU,1),IMc,7,0,[(ae(Hsc(TPc,_sc(46))==-1,HMc,TPc),new Wbc(rec,TPc)),(ae(Hsc(SPc,_sc(46))==-1,HMc,SPc),new Wbc(rec,SPc)),(ae(Hsc(UPc,_sc(46))==-1,HMc,UPc),new Wbc(rec,UPc))])),d);k=new J9b(zcc);for(j=(h=(new Wuc(a.c.a)).a.He().Vd(),new avc(h));j.a.Id();){i=
(e=j.a.Jd(),e.Ve());q8b(k,V3b(i.a))}f=t3b(l3b(x3b((ae(Hsc(NPc,_sc(46))==-1,HMc,NPc),new Wbc(rec,NPc)),new Wbc(bfc,"registerAndLoadModule")),CE(xE(HU,1),IMc,7,0,[g,V3b(Kib($Eb(a.a.C,(!b.d&&!!b.i&&(b.d=L6(b.c,b.i)),b.d).i.a).a)),k])));q8b(a.g,I9b(f,a.g));v7(a.a,a.g);v7(a.a,g);Vob(b)}function Dfc(){Afc();return CE(xE(KU,1),sLc,10,0,[Uec,Tcc,Ucc,Rcc,xdc,vec,lec,iec,Rdc,Ldc,kec,Wec,tfc,vcc,efc,qec,pdc,oec,zdc,zec,Scc,Oec,wec,xec,ndc,pfc,Pdc,Odc,Ycc,rec,Cec,bfc,Aec,lfc,Edc,nfc,Zec,$ec,Rec,mfc,Zdc,aec,zcc,
Eec,ofc,Jec,edc,Ccc,Fcc,Gcc,Ecc,Jcc,Mcc,Occ,Dcc,Ncc,Lcc,Hcc,Kcc,Icc,Sdc,Hec,wcc,$dc,jdc,Jdc,Tdc,gfc,$cc,ldc,xfc,qdc,Fdc,Hdc,Xcc,hdc,ufc,yfc,adc,vfc,tdc,Vec,Vcc,eec,Ddc,Xec,Qdc,Yec,gdc,idc,fec,cfc,_cc,Acc,Fec,odc,bdc,cdc,mec,ffc,jec,Idc,Gdc,zfc,Pcc,Vdc,Xdc,Wdc,Ydc,Adc,Cdc,Bdc,pec,rdc,Sec,_ec,fdc,hfc,ifc,kfc,jfc,mdc,yec,dfc,Wcc,Dec,Kdc,Iec,sfc,ycc,Bec,wfc,Tec,sec,Gec,Qec,rfc,Bcc,Mdc,Ndc,xcc,Kec,afc,wdc,Pec,sdc,Qcc,ydc,gec,hec,ddc,bec,cec,dec,udc,vdc,Udc,qfc,kdc,nec,_dc,Zcc,tec,uec,Lec,Mec,Nec])}function Wib(a,
b,c,d){var e,f,g,h;switch(c.n.f){case 105:ajb(a,z8((!b.d&&!!b.i&&(b.d=L6(b.c,b.i)),b.d)),c);break;case 109:E8b(c,(n8b(),U7b))!=0?Yib(a,b,c,d):E8b(c,T7b)!=0?(e=c.c?c.c.i:null,f=C3b(new J9b((Afc(),tdc)),new J9b(tdc),e.Sh(false)),F9b(f,c),p8b(d,f,c),Wib(a,b,f,d),g=Sib(a,e.Wh()),k9b(c,G9b(t3b(l3b(x3b((ae(Hsc(UPc,_sc(46))==-1,HMc,UPc),new Wbc(rec,UPc)),new Wbc(bfc,"exportAllFrom")),CE(xE(HU,1),IMc,7,0,[(ae(Hsc(g,_sc(46))==-1,HMc,g),new Wbc(rec,g))]))),c)),Vob(b),undefined):!!c.c&&!!c.c.f&&c.c.f==(c.c?
c.c.i:null)?Zib(a,b,c,d):c.c.n==(Afc(),Cdc)?_ib(a,b,c,d):Xib(a,b,c,d);break;case 85:Xd(a.g==c);h=c.c;Xd(h.n==(Afc(),pec));Sd(h.g);e9b(h.g,h);u8b(c,f9b(h));Pib(a);Oib(a);Vib(a,b);break;case 29:Uib(a,b,c)}}function dVb(a){var b,c,d;if(zVb(a,0,(AZb(),lYb))&&!zVb(a,1,GYb))return yUb(a);if(zVb(a,0,bYb))return hUb(a,false);if(zVb(a,0,oYb))return CUb(a);if(zVb(a,0,YXb))return dUb(a);if(zVb(a,0,rZb)&&(c=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(c||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&zVb(a,1,iYb)&&zVb(a,
2,ZXb))return oVb(a);if(zVb(a,0,SXb)&&(d=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(d||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&(zVb(a,1,vZb)||zVb(a,1,sYb)||zVb(a,1,PXb)||zVb(a,1,gYb)||zVb(a,1,IXb)||zVb(a,1,YXb)||zVb(a,1,wYb)||zVb(a,1,xYb)))return zTb(a);if((zVb(a,0,wYb)||zVb(a,0,xYb))&&(b=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(b||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&zVb(a,1,iYb))return MUb(a,false);return hVb(a)}function _2(){_2=JZ;$2=new Mcb("JSC_SUSPICIOUS_SEMICOLON",(E2(),D2),new Rtc("If this if/for/while really shouldn''t have a body, use '{}'"));
V2=new Mcb("JSC_SUSPICIOUS_NAN",D2,new Rtc("Comparison against NaN is always false. Did you mean isNaN()?"));X2=new Mcb("JSC_SUSPICIOUS_IN",D2,new Rtc('Use of the "in" keyword on non-object types throws an exception.'));W2=new Mcb("JSC_SUSPICIOUS_INSTANCEOF_LEFT",D2,new Rtc('"instanceof" with left non-object operand is always false.'));Y2=new Mcb("JSC_SUSPICIOUS_LEFT_OPERAND_OF_LOGICAL_OPERATOR",D2,new Rtc("Left operand of {0} operator is always {1}."));Z2=new Mcb("JSC_SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR",
D2,new Rtc("Suspicious negated left operand of 'in' operator."))}function qhb(a,b,c,d){var e,f,g,h,i,j,k,l,m;f=jhb(a,z8b(b.c.f));m=b.c;e=b.c.f;if(E8b(m,(Hbc(),gbc))==0&&E8b(e,gbc)==0){o8b(b,f,m);c9b(b,gbc,0);whb(a,b);return}if(z8b(m).n==(Afc(),ufc)){Xd(E8b(m,gbc)==0);k=m;Xd(!k.c.c);m=k.c.Sh(false)}else k=F9b(new J9b(ufc),m);h=F9b(Phb(a.a,"$jscomp$generator$forin$"+(""+(new j8(a.f.b)).a.Q++)),m);r8b(h,Chb(a.a,m,"forIn",CE(xE(HU,1),IMc,7,0,[f])));l=a.f.g?bgc(h.c.d):null;h.d=l;q8b(k,h);i=F9b(Yjb(x3b(h.Sh(false),
F9b((n8b(),new Wbc(bfc,"getNext")),f)),a.f.g?l.Wi("getNext"):null),f);g=F9b(Yjb(L3b(F9b(Yjb(h3b(Yjb(m,a.f.d),F9b(Yjb(l3b(i,CE(xE(HU,1),IMc,7,0,[])),a.f.d),f)),a.f.d),f),F9b(Yjb(new J9b(Aec),a.f.c),h)),a.f.a),f);o9b(g,E8b(m,gbc)!=0);j=F9b(u3b(k,g,F9b(new J9b(tdc),b),z8b(e)),b);phb(a,j,c,d)}function Jrb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;for(e=b.c;e;e=s){s=e.f;j=!c?e:c;k=!c?b:d;switch(e.n.f){case 83:Jrb(a,e,j,k);break;case 73:case 101:case 102:h=e.c;if(h.n==(Afc(),ufc)){l=h.c;if(l.n==odc){m=
Bpb(l);for(o=new wxc(m);o.a<o.c.a.length;){n=(o.b=o.a++,o.c.a[o.b]);ae(n.n==rec,"lhs in destructuring declaration should be a simple name.",n);p=F9b(K3b(n.Wh()),n);r=F9b(r3b(p,ufc),n);p8b(k,r,j)}f=g9b(l);j9b(e,h,f)}else{q=h;n=q.c.Sh(false);j9b(h.g,h,n);p8b(k,q,j)}Nrb(a,"FOR-IN var declaration",b)}break;case 72:if(e.c.n!=(Afc(),tdc)){i=e.c;if(i.n==jec||i.n==gdc||i.n==bdc||i.n==Jdc)return;g=new J9b(tdc);H9b(g,e);j9b(e,i,g);i.n==ufc?q=i:q=(ppb(),F9b((Yd(H3b(i),i),new L9b(Ddc,i)),i));p8b(k,q,j);Nrb(a,
"FOR initializer",b)}}}}function rHb(){rHb=JZ;oHb=new Mcb("JSC_MISSING_NULLABILITY_MODIFIER_JSDOC",(E2(),C2),new Rtc("{0} is a reference type with no nullability modifier, which is disallowed by the style guide.\nPlease add a '!' to make it explicitly non-nullable, or a '?' to make it explicitly nullable."));pHb=new Mcb("JSC_NULL_MISSING_NULLABILITY_MODIFIER_JSDOC",C2,new Rtc("{0} is a reference type with no nullability modifier that is explicitly set to null.\nAdd a '?' to make it explicitly nullable."));
qHb=new Mcb("JSC_REDUNDANT_NULLABILITY_MODIFIER_JSDOC",C2,new Rtc("{0} is a non-reference type which is already non-nullable.\nPlease remove the redundant '!', which is disallowed by the style guide."));tp(XKc,YKc,$Kc,sRc,vPc,XNc,CE(xE(nW,1),uNc,2,6,[jLc]))}function uhb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;r8b(b,jhb(a,g9b(b)));m=false;for(g=b.c.f;g;g=g.f)if(E8b(g,(Hbc(),gbc))!=0){m=true;break}if(!m){c9b(b,(Hbc(),gbc),0);whb(a,b);return}j=new fxc;e=true;for(f=b.c.f;f;f=f.f){if(f.n!=(Afc(),ldc)&&E8b(f.c,
(Hbc(),gbc))!=0){u7(a.f.b,Lmb(b,(Rjb(),Qjb),CE(xE(nW,1),uNc,2,6,["Case statements that contain yields"])));return}d=f.c?f.c.i:null;if(!d.c||e&&E8b(d,(Hbc(),gbc))==0)continue;e=hhb(a,d);l=new pib(a.a);F9b(l.a,d);n=j3b(Hhb(a.a,l,d));c9b(n,(Hbc(),Eac),1);c9b(n,hbc,1);j9b(d.g,d,n);Ywc(j,new Ahb(l,d));c9b(f,gbc,0)}k=Thb(a.a,c);c9b(b,(Hbc(),gbc),0);whb(a,b);gib(a.a,k,b);Xhb(a.a,k);for(i=new wxc(j);i.a<i.c.a.length;){h=(i.b=i.a++,i.c.a[i.b]);l=h.b;cib(a.a,l);thb(a,h.a,null,null)}vwc(a.a.c);cib(a.a,k)}function JMb(a,
b,c,d,e){var f,g,h,i,j,k,l,m,n,o;f=new stc;o=-1;n=-1;if(d){qOb(a.j);o=a.j.g;n=lOb(a.j)+1;k=MMb(a);c!=0&&(k=Ysc(k));f.a+=""+k;a.i=(JNb(),HNb);b=!a.o?mOb(a.j):GMb(a)}i=false;l=-1;do switch(b.f){case 15:if(i){l=lOb(a.j)+1;i=false}else{SMb(a,f,l,c);l=-1;f.a+="*"}b=!a.o?mOb(a.j):GMb(a);while(b==(fOb(),dOb)){if(l!=-1){SMb(a,f,l,c);l=-1}f.a+="*";b=!a.o?mOb(a.j):GMb(a)}continue;case 1:c!=2&&(f.a+=gMc,f);i=true;l=0;b=!a.o?mOb(a.j):GMb(a);continue;default:i=false;a.i=(JNb(),HNb);j=b==(fOb(),RNb);if(!j){SMb(a,
f,l,c);l=-1}if(b==RNb||b==SNb||b==MNb&&!e){m=f.a;c!=0&&(m=Ysc(m));if(d&&m.length!=0){h=a.j.g;g=lOb(a.j);p6b(a.f,m,o,n,h,g)}return new FNb(m,b)}ptc(f,yNb(a,b));k=MMb(a);c!=0&&(k=DNb(k));f.a+=""+k;b=!a.o?mOb(a.j):GMb(a)}while(true)}function OTb(a,b){var c,d,e,f,g,h,i;oTb(a,GNc);e=AVb(a,(AZb(),bZb));e&&iTb(a,bZb);if(KVb(a,0)){i=DWb(a.g,0).e;if(iYb==i||(OSb(),OSb(),!!Po(pSb,i))){g=kTb(a);c=J$b(P$b(S$b(N$b(K$b(new T$b((Y$b(),X$b))),e),b.c),g),b.a);if(b.b){M$b(R$b(L$b(O$b(c,tTb(a)),pUb(a,1)),sTb(a)),new w$b(pTb(a,
b.d)));nTb(a)}else sUb(a,c,e?(pWb(),mWb):(pWb(),lWb));return I$b(c,pTb(a,g.d.b))}else{h=GUb(a);c=S$b(N$b(K$b(new T$b((Y$b(),W$b))),e),b.c);sUb(a,c,e?(pWb(),mWb):(pWb(),lWb));d=I$b(c,pTb(a,h.o.b));return new n$b(pTb(a,h.o.b),b.a,h,d)}}else if(a.b.d&&zVb(a,0,HYb)&&zVb(a,1,iYb)&&zVb(a,2,NXb)){f=BUb(a);nTb(a);return f}else{h=_Tb(a);c=S$b(N$b(K$b(new T$b((Y$b(),W$b))),e),b.c);sUb(a,c,e?(pWb(),mWb):(pWb(),lWb));d=I$b(c,pTb(a,h.o.b));return new n$b(pTb(a,h.o.b),b.a,h,d)}}function hnb(a){var b,c,d,e,f,g,
h,i;c=false;for(h=a.Vd();h.Id();){f=h.Jd();if(Esc(f.e,gOc)){c=true;b=new oDc(a);b.a.Ke(f)!=null;Yd(Uc(Pmb(f),b),"A weak module already exists but it does not depend on every other module.");Yd(izc(Pmb(f))==b.a.Yd(),"The weak module cannot have extra dependencies.");break}}if(c)for(g=a.Vd();g.Id();){f=g.Jd();for(e=new wxc(f.d);e.a<e.c.a.length;){d=(e.b=e.a++,e.c.a[e.b]);Esc(f.e,gOc)?Yd(d.a.sh().c==(scc(),rcc),"A weak module already exists but strong sources were found in it."):Yd(d.a.sh().c!=(scc(),
rcc),"A weak module already exists but weak sources were found in other modules.")}}else{i=new Smb(gOc);for(g=a.Vd();g.Id();){f=g.Jd();Sd(f);ae(f!=i,"Cannot add dependency on self",i);Ywc(i.a,f)}a=new hxc(a);a.Pd(i)}return a}function mnc(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;if(b.Ji()){r=b.Ji();f=new xnc(a.A);f.a=false;i=a.A.u[58];for(p=a.t.b.we().Vd();p.Id();){n=p.Jd();t=Chc(a,n);m=null;if((r==r.A.u[64]||Fhc(r)||!!fnc(r.t,n)?1:0)==0)m=t;else{q=Chc(r,n);m=t.hi(q);g=new ukc(false);if(Qfc(m,
i,0,g))return i}vnc(f,n,m,(j=fnc(a.t,n),!j?null:j.d))}for(o=r.t.b.we().Vd();o.Id();){n=o.Jd();(a==a.A.u[64]||Fhc(a)||!!fnc(a.t,n)?1:0)!=0||vnc(f,n,Chc(r,n),(j=fnc(r.t,n),!j?null:j.d))}return wnc(f)}h=a.A.u[59];s=a.A.u[38].hi(b);if(!(s.ti()||s.ri()||s.si()||s==s.A.u[64]))for(l=a.t.b.we().Vd();l.Id();){k=l.Jd();m=Chc(a,k);f=new $pc(a.A,false);for(d=$kc(a.A,k).Vd();d.Id();){c=d.Jd();e=c.Wi(k);!!e&&(g=new ukc(false),!Qfc(c,a,0,g))&&c.zi(b)&&e.zi(m)&&Upc(f,c)}h=h.ii(Vpc(f))}return h}function Drc(a){var b,
c,d,e,f,g,h,i,j,k,l;if(a==null)throw gZ(new usc(jLc));j=a;f=a.length;i=false;if(f>0){b=a.charCodeAt(0);if(b==45||b==43){a=a.substr(1);--f;i=b==45}}if(f==0)throw gZ(new usc(ITc+j+'"'));while(a.length>0&&a.charCodeAt(0)==48){a=a.substr(1);--f}if(f>(tsc(),rsc)[10])throw gZ(new usc(ITc+j+'"'));for(e=0;e<f;e++)if(Uqc(a.charCodeAt(e),10)==-1)throw gZ(new usc(ITc+j+'"'));l=0;g=psc[10];k=qsc[10];h=sZ(ssc[10]);c=true;d=f%g;if(d>0){l=-parseInt(a.substr(0,d),10);a=a.substr(d);f-=d;c=false}while(f>=g){d=parseInt(a.substr(0,
g),10);a=a.substr(g);f-=g;if(c)c=false;else{if(iZ(l,h)<0)throw gZ(new usc(ITc+j+'"'));l=rZ(l,k)}l=vZ(l,d)}if(iZ(l,0)>0)throw gZ(new usc(ITc+j+'"'));if(!i){l=sZ(l);if(iZ(l,0)<0)throw gZ(new usc(ITc+j+'"'));}return l}function Zdb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n;dkb(a.c,c)==2&&gkb(a.c,c);m=c.g;l=(RFb(),Osc(Nsc(Nsc(Nsc(Nsc(Nsc(Nsc(Osc(Qsc(TFb((h=Osc(Osc(Osc(Osc(Osc(Nsc(Nsc(H8b(c,(Hbc(),ybc)).ug(),58,45),92,47)," ",cNc),"[",dNc),"]",eNc),"<",fNc),">",gNc),SFb(h))),"^\\./",""),"/","$"),92,36),64,36),43,
36),45,95),58,95),46,95),cNc,"_")+"$classdecl$var"+a.a++);j=(ppb(),k=Dpb(c),!k?null:H8b(k,mbc));n=Gpb(m,new jrb);g=c.d;Xd(true);e=r9b((ae(Hsc(l,_sc(46))==-1,HMc,l),n8b(),new Wbc((Afc(),rec),l)),g);f=x8b(e,false);j9b(m,c,f);d=I9b(q3b(e,c,gdc),c);qpb(b.f,(IRb(),RQb));q9b(d,k6b(E7b(j)));p8b(n.g,d,n);if(!!n&&(n.n==ufc||n.n==jec||n.n==gdc)&&!!n.c&&!n.c.f&&(Xd(!!n.c&&!n.c.f),n.c==m))Ydb(n);else if(n.n==Ddc){i=(Xd(!!n.c&&!n.c.f),n.c);i.n==Ccc&&V8b(i.c)&&i.c.f==f&&Ydb(i)}w7(a.b,d)}function aDb(){aDb=JZ;ZCb=
new Mcb("JSC_REFERENCE_BEFORE_DECLARE",(E2(),D2),new Rtc("Variable referenced before declaration: {0}"));$Cb=new Mcb("JSC_REDECLARED_VARIABLE",D2,new Rtc("Redeclared variable: {0}"));new Mcb("JSC_REFERENCE_BEFORE_DECLARE_ERROR",B2,new Rtc("Illegal variable reference before declaration: {0}"));new Mcb("JSC_REASSIGNED_CONSTANT",B2,new Rtc("Constant reassigned: {0}"));new Mcb("JSC_REDECLARED_VARIABLE_ERROR",B2,new Rtc("Illegal redeclared variable: {0}"));new Mcb("JSC_DECLARATION_NOT_DIRECTLY_IN_BLOCK",
B2,new Rtc("Block-scoped declaration not directly within block: {0}"));_Cb=new Mcb("JSC_UNUSED_LOCAL_ASSIGNMENT",C2,new Rtc("Value assigned to local variable {0} is never read"));Ur(MCc((Afc(),Tdc),CE(xE(KU,1),sLc,10,0,[Fdc,Hdc,Idc,Gdc,xfc])))}function thb(a,b,c,d){var e,f,g,h;Xd(I3b(b));Xd(!b.g);if(E8b(b,(Hbc(),gbc))==0){whb(a,b);return}switch(b.n.f){case 83:shb(a,b);break;case 82:mhb(a,b);break;case 84:ohb(a,b);break;case 76:xhb(a,b);break;case 0:r8b(b,bib(a.a,b,khb(a,jhb(a,g9b(b)))));eib(a.a,b);
a.a.j.e=false;break;case 39:r8b(b,khb(a,jhb(a,g9b(b))));eib(a.a,b);a.a.j.e=false;break;case 66:rhb(a,b,c);break;case 72:phb(a,b,c,d);break;case 73:qhb(a,b,c,d);break;case 70:e=Thb(a.a,d);f=Thb(a.a,c);cib(a.a,e);g=khb(a,jhb(a,g9b(b)));h=g9b(b);eib(a.a,F9b(B3b(F9b(Yjb(Z3b((Afc(),zec),g),a.f.a),g),Ghb(a.a,f,true,b)),b));Yhb(a.a,f,e);thb(a,h,null,null);Vhb(a.a);gib(a.a,e,b);cib(a.a,f);break;case 71:nhb(a,b,c,d);break;case 44:vhb(a,b,c);break;case 67:uhb(a,b,c);break;default:ae(false,"Unsupported token: %s ",
b.n)}}function mvb(a,b,c){var d,e,f,g,h,i,j,k,l,m;if(!(!!c.c&&!c.c.f)||c.c.n!=(Afc(),Ddc)){u7(a.a,Lmb(c,jvb,CE(xE(nW,1),uNc,2,6,[])));return}j=z8b(c.c.c);d=c.c;!!d&&e9b(c,d);k=UFb(z8((!b.d&&!!b.i&&(b.d=L6(b.c,b.i)),b.d)).a);r8b(c,F9b(q3b(F9b((ae(Hsc(k,_sc(46))==-1,HMc,k),n8b(),new Wbc((Afc(),rec),k)),j),j,ufc),j));r8b(c,I9b(t3b(l3b(x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,CNc)),CE(xE(HU,1),IMc,7,0,[new Wbc(bfc,k)]))),c));i=(!b.d&&!!b.i&&(b.d=L6(b.c,b.i)),b.d).a.sh().b;m=
VQc.length;if(Esc(i.substr(i.length-m,m),VQc)&&j.n==Eec){l=a.a.G.kc;for(h=xu(new Wzc(l.a.b.Vd()));h.Id();){g=h.Jd();f=Lpb(j,g);if(!!f&&(f.n==bfc||f.n==Eec)){e=Vsc(i,0,i.length-12);if(f.n==bfc){_tc(a.b,i,e+(""+f.Wh()));break}else if(f.n==Eec){Yd(Esc(g,"browser"),g);lvb(a,e,f)}}}}Vob(b)}function I6(a){var b,c,d,e,f,g,h,i,j,k,l,m;e=a.G.pb;j=a.G.B;b=new stc;if(e.a.a.Ud()&&j.a.a.Ud())return r8(new l8(a));if(!e.a.a.Ud()){Sd(a.o);Sd(a.v);for(g=Im(Dm(CE(xE(cW,1),mLc,15,0,[v8b(a.o),v8b(a.v)])));Ru(g);){f=
Su(g);d=(c=H8b(f,(Hbc(),ybc)),!c?null:c.ug());for(l=xu(new Wzc(e.a.b.Vd()));l.Id();){k=l.Jd();if((new RegExp("^("+k+")$")).test(d)){m="// "+d+gMc+(!a.G&&_6(a,new v9),F7(a,f,true));b.a+=m;break}}}if(b.a.length==0)throw gZ(new GD("No files matched any of: "+e));}if(!j.a.a.Ud()){for(i=new Guc(a.B?new eyc(a.B.a):null);i.b<i.d.Yd();){h=(i.b<i.d.Yd(),i.d.ce(i.c=i.b++));for(l=xu(new Wzc(j.a.b.Vd()));l.Id();){k=l.Jd();if(Lsc(h.e,k)){m="// module '"+h.e+"'\n"+r8(new n8(a,h));b.a+=m;break}}}if(b.a.length==
0)throw gZ(new GD("No modules matched any of: "+j));}return b.a}function uub(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q;l=Sd(c.b);Xd(l.n==(Afc(),Jdc));c9b(l,(Hbc(),Gac),0);k=l.c?l.c.i:null;h=H8b(l,ybc);if(!!h&&h.Kh()){if(!kqb(k)){k9b(k,k3b(CE(xE(HU,1),IMc,7,0,[])));Qqb(k,a.a)}return}j=k3b(CE(xE(HU,1),IMc,7,0,[]));j9b(l,k,j);if(c.d){q8b(j,d_(LQc,(n=new J9b(lfc),n)));qpb(b.f,(IRb(),RQb))}if(c.c){q8b(j,d_(MQc,(n=(ae(Hsc(BMc,_sc(46))==-1,HMc,BMc),n8b(),new Wbc(rec,BMc)),n)));qpb(b.f,(IRb(),RQb))}for(p=(m=
(new fvc(c.e.a)).a.He().Vd(),new kvc(m));p.a.Id();){o=(g=p.a.Jd(),g.We());d=Dub(c,o);e=d_(o.b,d);q8b(j,e);v7(a.a,d);f=b.f;qpb(f,(IRb(),GQb));qpb(f,RQb)}k.n==Vcc||(k=I9b(k3b(CE(xE(HU,1),IMc,7,0,[(Xd(H3b(k)),new L9b(Uec,k))])),k));i=(q=N$(new J9b(Jec),k),c9b(q,Xac,1),q);v7(a.a,i);qpb(b.f,(IRb(),$Qb));q8b(j,c_(U$((Kob(b),i))));I9b(j,k);w7(a.a,j)}function Hjb(a,b,c,d){var e,f,g,h,i,j,k;switch(b.n.f){case 76:!!c&&Ejb(a,c,b);return;case 100:case 88:!!d&&Ejb(a,d,b);return;case 105:Ejb(a,c,b);return;case 109:Hjb(a,
b.c,c,d);return;case 65:{ppb();if(b.n==(Afc(),Jdc)&&!(b.n==Jdc&&iqb(b.g)&&b.n==Jdc&&Gqb(b.c))&&!Bqb(b)||!d)return}i=b.c.Wh();if(i.length==0)return;Fjb(a,d,b.c);return;case 96:{ppb();if(b.n==(Afc(),bdc)&&(!(b.n==bdc&&Gqb(b.c))||!iqb(b.g))||!d)return}g=b.c.Wh();if(g.length==0)return;Fjb(a,d,b.c);return;case 78:Yd(!!b.c&&!!b.c.f&&b.c.f==(b.c?b.c.i:null),b);!!d&&Ejb(a,d,b);e=b.c.f;Hjb(a,e,c,d);return;case 85:a.b=H8b(b,(Hbc(),cbc));break;case 112:if(!c.b)return}j=!!d&&b==d.d;h=!j&&ypb(b);if(h&&!c)return;
if(gqb(b)||(ppb(),b.n==(Afc(),Vec)||b.n==Xec||b.n==Vcc||b.n==pec))for(f=b.c;f;){k=f.f;Hjb(a,f,c,h?null:d);f=k}}function Uhb(a){var b,c,d,e,f,g;Yd(a.a.a.length!=0,a.a);for(c=new wxc(a.a);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);if(b.d){while(b.d.d)b.d=b.d.d;!!b.b&&b.f.a.length==1&&(b.d.b=b.b);b.b=null;for(g=new wxc(b.f);g.a<g.c.a.length;){f=(g.b=g.a++,g.c.a[g.b]);f.Zh(b.d.c)}Zwc(b.d.f,b.f);b.f.a=zE(iW,mLc,1,0,5,1)}}d=new wxc(a.a);e=(d.b=d.a++,d.c.a[d.b]);Xd(e.c==1);while(d.a<d.c.a.length){b=(d.b=
d.a++,d.c.a[d.b]);if(b.f.a.length==0){Xd(!b.b);if(e.e){t8b(e.a,f9b(b.a));e.e=b.e}axc(d.c,d.a=d.b);d.b=-1;continue}if(b.b){Xd(!b.d);if(b.f.a.length==1&&!b.e){k9b(b.b,b.a);axc(d.c,d.a=d.b);d.b=-1;continue}}if(e.d==b){Xd(e.e);Xd(!e.a.c);Xd(!b.d);t8b(e.a,f9b(b.a));e.e=b.e;for(g=new wxc(b.f);g.a<g.c.a.length;){f=(g.b=g.a++,g.c.a[g.b]);f.Zh(e.c)}e.d=b.d;Zwc(e.f,b.f);axc(d.c,d.a=d.b);d.b=-1;continue}e=b}}function mjb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n;Kd(b.n==(Afc(),Ycc));e=b.c;f=(ppb(),upb(e,false,a.c));
e9b(b,e);if(!!b.c&&!b.c.f&&jjb((Xd(!!b.c&&!b.c.f),b.c)))l=g9b(g9b(b));else{k=hjb(a,b);Xd(k.a.length!=0);if(k.a.length==1)l=axc(k,0);else{c=k.a[0].n==zcc?axc(k,0):r9b(f3b(CE(xE(HU,1),IMc,7,0,[])),a.a);g=r9b(x3b(c,(n8b(),new Wbc(bfc,VPc))),a.d);l=r9b(l3b(g,exc(k,zE(HU,IMc,7,0,0,1))),a.a)}r9b(l,a.a)}if(f&&e.n==Pdc){m=e.c.d;i=r9b(K3b("$jscomp$spread$args"+(""+(new j8(a.c)).a.Q++)),m);j=r3b(x8b(i,false),ufc);n=Gpb(b,new jrb);I9b(j,n);p8b(n.g,j,n);r8b(e,r9b(h3b(x8b(i,false),g9b(e)),m));d=l3b(ijb(e,hPc),
CE(xE(HU,1),IMc,7,0,[x8b(i,false),l]))}else{h=e.n==Pdc||e.n==Odc?x8b(e.c,false):r9b(new J9b(Aec),a.f);d=l3b(ijb(e,hPc),CE(xE(HU,1),IMc,7,0,[h,l]))}r9b(d,b.d);I9b(d,b);j9b(b.g,b,d);w7(a.c,d)}function TOb(a,b){var c,d,e,f,g;if(!JOb(a,b,(NPb(),yPb)))return false;if(!gPb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)))){mPb(a,(c=yPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,1),c));return false}if((Pd(b.n==Ycc,iSc,b),B8b(b,2)).n!=Jdc){lPb(a,(d=oSc,Pd(b.n==Ycc,iSc,b),B8b(b,2),d));mPb(a,(c=yPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,2),c));
return false}e=(Pd(b.n==Ycc,iSc,b),B8b(b,2));g=(Pd(e.n==Jdc,pSc,e),C8b(e.c.f));if(g<2){a.a.Bh(URc+occ(qSc,CE(xE(iW,1),mLc,1,5,[oSc])),a.b.ug(),a.d,a.c);mPb(a,(c=yPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,2),c));return false}if(g>2){a.a.Bh(URc+occ(rSc,CE(xE(iW,1),mLc,1,5,[oSc])),a.b.ug(),a.d,a.c);mPb(a,(c=yPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,2),c));return false}f=(Pd(e.n==Jdc,pSc,e),B8b(e,2));if(!gPb(a,f)){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[sSc])),a.b.ug(),a.d,a.c);return false}return true}function UOb(a,b){var c,
d,e,f,g;if(!JOb(a,b,(NPb(),zPb)))return false;if(!gPb(a,(Pd(b.n==(Afc(),Ycc),iSc,b),B8b(b,1)))){mPb(a,(c=zPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,1),c));return false}if((Pd(b.n==Ycc,iSc,b),B8b(b,2)).n!=Jdc){lPb(a,(d=oSc,Pd(b.n==Ycc,iSc,b),B8b(b,2),d));mPb(a,(c=zPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,2),c));return false}e=(Pd(b.n==Ycc,iSc,b),B8b(b,2));g=(Pd(e.n==Jdc,pSc,e),C8b(e.c.f));if(g<1){a.a.Bh(URc+occ(qSc,CE(xE(iW,1),mLc,1,5,[oSc])),a.b.ug(),a.d,a.c);mPb(a,(c=zPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,2),c));return false}if(g>
1){a.a.Bh(URc+occ(rSc,CE(xE(iW,1),mLc,1,5,[oSc])),a.b.ug(),a.d,a.c);mPb(a,(c=zPb.d,Pd(b.n==Ycc,iSc,b),B8b(b,2),c));return false}f=(Pd(e.n==Jdc,pSc,e),B8b(e,2));if(!gPb(a,f)){a.a.Bh(URc+occ(mSc,CE(xE(iW,1),mLc,1,5,[sSc])),a.b.ug(),a.d,a.c);return false}return true}function Igc(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q;Sd(a);if(b.Bi())return true;if(b.mi())return true;if($fc(a,b,c.c))return true;if(b.Mi()){q=b.Mi();e=(Yoc(new Epc,q.b)&&Voc(q),q.b);for(g=0;g<e.Yd();g++){f=e.ce(g);if(a.Ai(f,c,d))return true}return false}if(d==
1&&(a.vi()||a.Ci()))return true;p=a.ki();n=b.ki();l=true;k=pF(b,48)?b:null;if(!!k&&Nfc.Sd(k.Xi())){j=a.A.k;o=(i=Snc(p,j),i==-1?p.a.u[51]:p.b[i]);m=(h=Snc(n,j),h==-1?n.a.u[51]:n.b[h]);l=o.Ai(m,c,d)||m.Ai(o,c,d)}else if(xgc(b)){j=alc(a.A);o=(i=Snc(p,j),i==-1?p.a.u[51]:p.b[i]);m=(h=Snc(n,j),h==-1?n.a.u[51]:n.b[h]);l=o.Ai(m,c,d)}else l=Onc(p,n,2,new ukc(true),d);if(!l)return false;if(c.c&&a.xi()&&b.yi())return Ehc(pF(a,48)?a:null,pF(b,48)?b:null,c,d);if(a.Li())return a.Li().d.Ai(b,c,d);if(pF(b,138))return a.Ai(b.e,
c,d);return false}function Hib(){Hib=JZ;new Mcb("JSC_LHS_OF_GOOG_REQUIRE_MUST_BE_CONST",(E2(),B2),new Rtc("The left side of a goog.require() or goog.requireType() must use ''const'' (not ''let'' or ''var'')"));new Mcb("JSC_NAMESPACE_IMPORT_CANNOT_USE_STAR",B2,new Rtc("Namespace imports ('goog:some.Namespace') cannot use import * as. Did you mean to import {0} from ''{1}'';?"));new Mcb("JSC_DUPLICATE_EXPORT",B2,new Rtc("Duplicate export ''{0}''."));new Mcb("JSC_REQUIRE_TYPE_FOR_ES6_SHOULD_BE_CONST",
B2,new Rtc("goog.requireType alias for ES6 module should be const."));new Mcb("JSC_FORWARD_DECLARE_FOR_ES6_SHOULD_BE_CONST",B2,new Rtc("goog.forwardDeclare alias for ES6 module should be const."));new Mcb("JSC_SHOULD_IMPORT_ES6_MODULE",D2,new Rtc("ES6 modules should import other ES6 modules rather than goog.require them."))}function ddb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;r=c.c.f;g=c.c?c.c.i:null;if(r.n==(Afc(),tdc)){k=(H8b(c,(Hbc(),Dbc)),p=(ppb(),v3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc(rec,
"")),new J9b(Jec),(d=new J9b(Vcc),d))),p);v7(a.a,k);o=V$(k)}else{if(!V8b(r))return;e=(d=new J9b(Vcc),d);j=H8b(c,(Hbc(),ybc));if(!(!!j&&j.Kh())&&(f=(ppb(),m=Dpb(c),!m?null:H8b(m,mbc)),!(!!f&&((f.a&512)!=0||(f.a&bPc)!=0)))){i=t3b((q=Tqb(r9b(new J9b(ffc),r.d),CE(xE(HU,1),IMc,7,0,[U3b((p=(ae(Hsc(BMc,_sc(46))==-1,HMc,BMc),n8b(),new Wbc(rec,BMc)),p))])),q));r8b(e,i);qpb(b.f,(IRb(),BRb));qpb(b.f,zRb)}h=N$(Q3b(Y$((n="var_args",n))),e);o=V$(h);l=new C7b(false);f7b(l,"var_args",new H7b(new L9b(sdc,new J9b(Pec)),
"<Es6ConvertSuper>"));q9b(o,k6b(l))}I9b(o,c);Z8b(o);r8b(g,o);qpb(b.f,(IRb(),gRb));v7(a.a,(Xd(!!o.c&&!o.c.f),o.c));w7(a.a,o)}function jkb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r;k=b.g;g=aqb(k)&&k.n!=(Afc(),Ccc)&&k.c==b;e=null;if(g&&(ppb(),b.n==(Afc(),Pdc)||b.n==Odc))for(i=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();i.Id();){h=i.Jd();if(h.n!=(Afc(),bfc)&&!(h.n==rec&&(fqb(h,a.e)||kDc(a.c,h.Wh())))){d=jkb(a,h,c);!e&&(e=d)}}o=(r=a.g+"_const"+_Pc+(""+a.d.a.Q++),jDc(a.c,r),r);l=F9b((ae(Hsc(o,_sc(46))==-1,
HMc,o),n8b(),new Wbc((Afc(),rec),o)),b);r9b(l,b.d);if(g){Yd(b.n==rec||(ppb(),b.n==Pdc||b.n==Odc),b);j=H9b(Yjb(new J9b(Rpb(k)),k.d),k);n=k.c?k.c.i:null;A9b(k,Ccc);j9b(k,n,j);r8b(j,l);q8b(j,n);p=x8b(b,false)}else if(b.n==_ec){j9b(k,b,r9b(F9b((Xd(H3b(l)),new L9b(_ec,l)),b),b.d));p=F9b((m=f3b(CE(xE(HU,1),IMc,7,0,[b])),m),(Xd(!!b.c&&!b.c.f),b.c))}else{j9b(k,b,l);p=b}q=Zqb(o,p);r9b(q.c,p.d);f=c.g;p8b(f,q,c);!e&&(e=q);Xd(e.n==ufc);return e}function Njb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,
A;o=U6(a.c);t=Wjb(c,o,45);d=Vjb(c,o,0,t);u=Wjb(c,o,27);A=Wjb(c,o,52);l=Wjb(c,o,33);v=b.c?b.c.i:null;h=Ljb(v,u,t,A,l);k=new H7b((xMb(),m=CNb("!ITemplateArray"),lNb(m,!m.o?mOb(m.j):GMb(m))),"<Es6TemplateLiterals.java>");j=new C7b(false);s7b(j,k);s=Yjb(n3b(h,k6b(j)),u);f=Yjb(K3b("$jscomp$templatelit$"+(""+(new j8(a.c)).a.Q++)),u);w=I9b(q3b(f,s,(Afc(),ufc)),b);r=(ppb(),Gpb(b,new frb(Xec)));r8b(r,w);w7(a.c,w);if(Kjb(v))i=I9b(t3b((q=h3b(O$(f.Sh(false),"raw"),(p=Tqb(O$(f.Sh(false),"slice"),CE(xE(HU,1),IMc,
7,0,[])),p)),q)),b);else{n=Mjb(v,d,t);i=I9b(t3b((p=h3b(O$(f.Sh(false),"raw"),n),p)),b)}o8b(r,i,w);e=Yjb(l3b(g9b(b),CE(xE(HU,1),IMc,7,0,[f.Sh(false)])),b.d);for(g=v.c;g;g=g.f)g.n==jfc||q8b(e,g9b(g));I9b(e,v);b9b(e,(n8b(),W7b),e.c.n!=Pdc);j9b(b.g,b,e);Vob(a)}function ymb(a,b,c){var d,e,f,g,h,i,j;if(a.a&&H8b(c,(Hbc(),sbc))!=null){ptc(b,H8b(c,(Hbc(),sbc)));return}if(c.n==(Afc(),Qcc)){b.a+="!";ymb(a,b,c.c)}else if(c.n==ydc){ymb(a,b,c.c);b.a+="="}else if(c.n==Kec){b.a+="(";g=c.c?c.c.i:null;for(d=c.c;d;d=
d.f){ymb(a,b,d);d!=g&&(b.a+="|",b)}b.a+=")"}else if(c.n==sdc){b.a+=HNc;!!c.c&&c.c.n!=tdc&&ymb(a,b,c.c)}else if(c.n==afc)b.a+="*";else if(c.n==Pec){b.a+="?";!!c.c&&ymb(a,b,c.c)}else if(c.n==Jdc)xmb(a,b,c);else if(c.n==hec){b.a+="{";i=c.c;h=i.c?i.c.i:null;for(e=i.c;e;e=e.f){if(e.c){ptc(ptc(b,e.c.Wh()),":");ymb(a,b,e.c?e.c.i:null)}else ptc(b,e.Wh());e!=h&&(b.a+=",",b)}b.a+="}"}else if(c.n==vfc)b.a+=XNc;else if(c.n==pfc){b.a+="typeof ";ymb(a,b,c.c)}else if(c.c){ptc(ptc(b,c.Wh()),"<");d=c.c;f=d.c?d.c.i:
null;for(j=d.c;j;j=j.f){ymb(a,b,j);j!=f&&(b.a+=",",b)}b.a+=">"}else ptc(b,c.Wh())}function YUb(a){var b,c,d,e,f,g,h,i;switch(DWb(a.g,0).e.f){case 29:return WTb(a,true,false);case 35:return b=DWb(a.g,0).d.b,iTb(a,(AZb(),hZb)),new x1b(new Z1b(b,a.f));case 21:return c=DWb(a.g,0).d.b,iTb(a,(AZb(),mZb)),new C1b(new Z1b(c,a.f));case 34:return d=DWb(a.g,0).d.b,iTb(a,(AZb(),lYb)),iTb(a,GYb),e=KTb(a,1),iTb(a,LXb),RVb(a,(IRb(),TQb)),new v$b(new Z1b(d,a.f),e);case 2:case 108:case 109:case 110:case 111:return wUb(a);
case 100:case 101:case 98:case 99:case 97:return GUb(a);case 107:case 104:return mVb(a,null);case 49:return DWb(a.g,1).e==(AZb(),fYb)?$Tb(a,HYb,MXb):GTb(a);case 45:return PUb(a);case 47:return bUb(a);case 94:case 95:return f=DWb(a.g,0).d.b,g=(i=zWb(a.g),a.f=i.d.a,i),new j_b(new Z1b(f,a.f),g);default:return h=DWb(a.g,0).d.b,wTb(a),VVb(a,"primary expression expected",CE(xE(iW,1),mLc,1,5,[])),new n_b(new Z1b(h,a.f))}}function fgb(a,b,c){var d,e,f,g,h,i,j,k;if(b.n==(Afc(),fdc)&&E8b(b,(Hbc(),zbc))!=0){Ujb(a.a,
b,"Static computed property");return}if(b.n==fdc&&!V8b(b.c)){Tjb(a.a,b.c,"Computed property with non-qualified-name key");return}k=bgb(b);Zfb(a,c,b);j=E8b(b,(Hbc(),zbc))!=0?c.b:c.j;d=new i1;if(b.n==fdc){Xd(E8b(b,zbc)==0);i=I8b(b.c);g1(d,(pgb(),mgb))}else if(b.Yh()){i=b.Wh();g1(d,(pgb(),ogb))}else{i=b.Wh();g1(d,(pgb(),ngb))}h1(d,i);e=pEc(j,i);f=!e?null:M4b(e.a);if(!!e&&!!k&&!(!!k&&k.a.Xh(f.a,false,true,false,false)))u7(a.a,Lmb(b,Vfb,CE(xE(nW,1),uNc,2,6,[i])));else{h=new C7b(false);if(!!H8b(b,mbc)&&
(H8b(b,mbc).a&1024)!=0){G6b(h);y7b(h,(e6b(),d6b))}!!H8b(b,mbc)&&(H8b(b,mbc).a&64)!=0?e7b(h):!k&&(k=new H7b(new J9b(Pec),(g=H8b(b,ybc),!g?null:g.ug())));!!k&&s7b(h,new H7b(x8b(k.a,false),k.b));E8b(b,zbc)!=0&&b.n!=fdc&&$6b(h);f1(d,k6b(h));qEc(j,i,e1(d))}}function VDc(){function e(){this.obj=this.createObject()}e.prototype.createObject=function(a){return Object.create(null)};e.prototype.get=function(a){return this.obj[a]};e.prototype.set=function(a,b){this.obj[a]=b};e.prototype[ISc]=function(a){delete this.obj[a]};
e.prototype.keys=function(){return Object.getOwnPropertyNames(this.obj)};e.prototype.entries=function(){var b=this.keys();var c=this;var d=0;return{next:function(){if(d>=b.length)return{done:true};var a=b[d++];return{value:[a,c.get(a)],done:false}}}};if(!TDc()){e.prototype.createObject=function(){return{}};e.prototype.get=function(a){return this.obj[":"+a]};e.prototype.set=function(a,b){this.obj[":"+a]=b};e.prototype[ISc]=function(a){delete this.obj[":"+a]};e.prototype.keys=function(){var a=[];for(var b in this.obj)b.charCodeAt(0)==
58&&a.push(b.substring(1));return a}}return e}function Apb(a,b){switch(a.n.f){case 47:return tqb(a.c?a.c.i:null)||b.Ld(a)&&Apb(a.c?a.c.i:null,b);case 46:return Apb(a.c?a.c.i:null,b);case 62:case 61:return Apb(a.c,b)&&Apb(a.c?a.c.i:null,b);case 60:return Apb(a.c.f,b)&&Apb(a.c?a.c.i:null,b);case 33:case 99:return b.Ld(a);case 29:return tqb(a)||b.Ld(a);case 27:case 26:return b.Ld(a);case 28:return Yd(a.n==(Afc(),Ycc)||a.n==hfc,a),(E8b(a,(Hbc(),wbc))&16)>0||Kqb(a)||b.Ld(a);case 117:return Yd(a.n==(Afc(),
Ycc)||a.n==hfc,a),(E8b(a,(Hbc(),wbc))&16)>0||b.Ld(a);case 23:return Yd(a.n==(Afc(),xec),a),Q9b(E8b(a,(Hbc(),wbc))&15,13)||b.Ld(a);case 24:case 63:case 64:case 96:case 65:case 38:case 80:case 42:case 43:case 118:return true;case 92:return Apb(a.c,b);case 115:case 103:case 104:return false;default:if(aqb(a)||Hqb(a.n)||tqb(a))return true;throw gZ(new Irc("Unexpected expression node: "+a+"\n parent:"+a.g));}}function $qb(a){ppb();switch(a.f){case 1:return"|";case 61:return"||";case 2:return"^";case 62:return"&&";
case 3:return"&";case 36:return"===";case 4:return"==";case 19:return"!";case 5:return"!=";case 37:return"!==";case 10:return"<<";case 40:return"in";case 7:return"<=";case 6:return"<";case 12:return">>>";case 11:return">>";case 9:return">=";case 8:return">";case 15:return"*";case 16:return"/";case 17:return"%";case 18:return"**";case 20:return"~";case 13:case 21:return"+";case 14:case 22:return"-";case 47:return"=";case 48:return"|=";case 49:return"^=";case 50:return"&=";case 51:return"<<=";case 52:return">>=";
case 53:return">>>=";case 54:return"+=";case 55:return"-=";case 56:return"*=";case 59:return"**=";case 57:return"/=";case 58:return"%=";case 79:return XNc;case 25:return yQc;case 41:return zQc;default:return null}}function ZTb(a,b){var c,d,e,f,g,h,i,j,k,l;h=!!mTb(a,(AZb(),bZb));if(KVb(a,0)){l=DWb(a.g,0).e;if(iYb==l||(OSb(),OSb(),!!Po(pSb,l))){k=null;j=kTb(a);TSb(j.a,false)&&RVb(a,(IRb(),eRb))}else{j=null;k=GUb(a)}}else{if(a.b.d&&zVb(a,0,HYb)&&zVb(a,1,iYb)&&zVb(a,2,NXb)){g=BUb(a);nTb(a);return g}k=
_Tb(a);j=null}if(!a.b.d||AVb(a,GYb)||AVb(a,EYb)){if(!k){i=(Y$b(),X$b);c=b.a}else{i=(Y$b(),W$b);c=null}if(b.b){f=KUb(a,b.d,j,b.c,h,b.a);nTb(a)}else{d=J$b(S$b(P$b(new T$b(i),j),b.c),c);sUb(a,d,h?(pWb(),nWb):(pWb(),oWb));f=I$b(d,pTb(a,b.d))}return i==(Y$b(),X$b)?f:new n$b(pTb(a,b.d),b.a,k,f)}else{h&&VVb(a,"Member variable cannot be prefixed by '*' (generator function)",CE(xE(iW,1),mLc,1,5,[]));e=sTb(a);AVb(a,ZXb)&&VVb(a,"Member variable initializers ('=') are not supported",CE(xE(iW,1),mLc,1,5,[]));
nTb(a);return!k?new m_b(pTb(a,b.d),j,b.c,false,b.a,e):new m$b(pTb(a,b.d),k,b.c,b.a,e)}}function Mhb(a,b){var c,d,e;Uhb(a);(a.a.a.length==2||a.a.a.length==3)&&q8b(b,I9b(B3b(Yjb(s3b(F9b(Yjb(x3b(F9b(Yjb(K3b(OPc+(a.r.b==0?"":"$"+a.r.b)),a.g),b),F9b((n8b(),new Wbc((Afc(),bfc),QPc)),b)),a.r.f.g?a.g.Wi(QPc):null),b),Yjb(new tac(1),a.r.f.e)),a.r.f.a),axc(a.a,0).a),b));a.a.a.length==2&&q8b(b,I9b(B3b(Yjb(L3b(F9b(Yjb(x3b(F9b(Yjb(K3b(OPc+(a.r.b==0?"":"$"+a.r.b)),a.g),b),F9b((n8b(),new Wbc((Afc(),bfc),QPc)),b)),
a.r.f.g?a.g.Wi(QPc):null),b),Yjb(O3b(a.a.a[1].c),a.r.f.e)),a.r.f.a),axc(a.a,0).a),b));if(a.a.a.length==1){t8b(b,f9b(axc(a.a,0).a));Ihb(a);return}e=F9b(Y3b(F9b(Yjb(x3b(F9b(Yjb(K3b(OPc+(a.r.b==0?"":"$"+a.r.b)),a.g),b),F9b((n8b(),new Wbc((Afc(),bfc),QPc)),b)),a.r.f.g?a.g.Wi(QPc):null),b),CE(xE(HU,1),IMc,7,0,[])),b);q8b(b,e);for(d=new wxc(a.a);d.a<d.c.a.length;){c=(d.b=d.a++,d.c.a[d.b]);q8b(e,F9b(m3b(F9b(Yjb(new tac(c.c),c.g.r.f.e),c.a),c.a),c.a))}a.a.a=zE(iW,mLc,1,0,5,1)}function hUb(a,b){var c,d,e,
f,g,h,i,j,k,l,m,n,o,p;l=DWb(a.g,0).d.b;f=false;g=false;h=false;k=true;iTb(a,(AZb(),bYb));c=null;d=null;switch(DWb(a.g,0).e.f){case 65:g=true;n=CWb(a.g);a.f=n.d.a;break;case 2:c=NTb(a);break;case 14:c=b?BTb(a):rUb(a);k=b;break;case 29:c=WTb(a,false,b);k=false;break;case 37:c=CUb(a);k=false;break;case 31:c=dUb(a);k=false;break;case 110:case 111:c=MUb(a,b);k=false;break;case 109:c=zTb(a);k=false;break;case 8:f=true;m=CWb(a.g);a.f=m.d.a;c=xTb(a,1);k=false;break;case 45:h=true;d=jUb(a);break;case 108:c=
oVb(a);break;case 25:case 38:case 30:default:c=b?ETb(a):wVb(a,1)}j=null;if(g||h&&zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,KNc)){oTb(a,KNc);j=iTb(a,gZb)}else if(h)for(p=d.Vd();p.Id();){o=p.Jd();e=o.b;qTb(a,e.a)&&SVb(a,e,YSc,CE(xE(iW,1),mLc,1,5,[e.a]))}(k||(i=DWb(a.g,0).d.b.b>a.f.b,i||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb)))&&nTb(a);return new y$b(new Z1b(l,a.f),f,g,c,d,j)}function bXb(a){var b,c,d,e,f;yWb(a);if(!xWb(a,a.f)){FWb(a,"Unterminated string literal escape sequence",CE(xE(iW,1),mLc,1,5,[]));return false}if(mXb(xWb(a,
a.f)?zsc(a.b,a.f):0)){d=yWb(a);d==13&&(xWb(a,a.f)?zsc(a.b,a.f):0)==10&&yWb(a);return true}e=yWb(a);switch(e){case 39:case 34:case 96:case 92:case 98:case 102:case 110:case 114:case 116:case 118:case 48:return true;break;case 120:c=SWb(a)&&SWb(a);c||FWb(a,bTc,CE(xE(iW,1),mLc,1,5,[]));return c;case 117:if((xWb(a,a.f)?zsc(a.b,a.f):0)==123){yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==125){FWb(a,cTc,CE(xE(iW,1),mLc,1,5,[]));return false}b=true;while((xWb(a,a.f)?zsc(a.b,a.f):0)!=125&&b)b=b&&SWb(a);b||FWb(a,
bTc,CE(xE(iW,1),mLc,1,5,[]));yWb(a);return b}else{f=SWb(a)&&SWb(a)&&SWb(a)&&SWb(a);f||FWb(a,bTc,CE(xE(iW,1),mLc,1,5,[]));return f}}if(e==47);else GWb(a,"Unnecessary escape: '\\%s' is equivalent to just '%s'",CE(xE(iW,1),mLc,1,5,[_qc(e),_qc(e)]));return true}function BLb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;g=b.j==(Y$b(),V$b);i=b.j==X$b;e=b.j==U$b;f=b.e;h=b.f;j=b.c.p==(n1b(),b0b);h&&bKb(a.a,b,(IRb(),$Qb));i&&bKb(a.a,b,(IRb(),gRb));e&&bKb(a.a,b,(IRb(),GQb));f&&bKb(a.a,b,(IRb(),HQb));h&&f&&bKb(a.a,b,(IRb(),
IQb));l=b.k;if(l)m=MLb(a,l);else{if(g||i){a.a.d.Ah("unnamed function statement",a.a.q,(RJb(),b.o.b.b+1),b.o.b.a);m=iKb(a.a,(Afc(),rec),"__missing_name__")}else m=iKb(a.a,(Afc(),rec),"");T9b(m.k)==-1&&vKb(m,b.o.b,b.o.a)}n=dKb(a.a,(Afc(),Jdc));i&&m._h("");q8b(n,m);aLb(a,n.c,b.d);q8b(n,yKb(a.a,b.b));bLb(a,n,b.n);d=yKb(a.a,b.c);if(!e&&!j&&d.n!=Vcc){Xd(a.a.a.f==(FJb(),DJb));d=(c=new J9b(Vcc),c)}hLb(d);q8b(n,d);c9b(n,(Hbc(),Xac),h?1:0);Xd(n.n==Jdc);c9b(n,Fac,e?1:0);Xd(n.n==Jdc);c9b(n,Gac,f?1:0);b9b(n,(n8b(),
f8b),b.g);if(i){T9b(n.k)==-1&&vKb(n,b.o.b,b.o.a);k=iKb(a.a,mec,l.a);q8b(k,n);x9b(k,b.i);_Kb(a,b,k,b.a);n9b(n,H8b(n,Nac));vKb(k,l.d.b,l.d.a);o=k}else o=n;return o}function hkb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B;k=skb(c,b);h=(ppb(),upb(k,false,a.b));e=rkb(k);o=new vkb;o.b=h;o.a=e;for(g=null,d=k,m=d.g;m!=b;g=d,d=m,m=d.g){Xd(!ukb(m)||d==m.c);if(m.n==(Afc(),Ccc))if(lkb(a,m,o.b));else{i=m.c;p=i.n;if(i!=d){Xd(i.n==Pdc||i.n==Odc);p==Odc&&fkb(a,i.c?i.c.i:null,null,o);fkb(a,i.c,null,o)}}else if(m.n==
Ycc&&qqb(m.c)){f=m.c;fkb(a,f.f,d,o);if(kkb(a,f,o.b)&&f.c!=g){Yd(a.a,"Object method calls can not be decomposed.");o.b=true;n=(Ld(m.n==Ycc,m),q=m.c,Ld(q.n==Pdc||q.n==Odc,q),r=q.d,s=null,!!r&&(s=r.Ii()?yjc(r.Ii(),ePc):a.i),t=jkb(a,q,o.a),o.a=t,u=t.c.c,Ld(u.n==Pdc||u.n==Odc,u),v=jkb(a,u.c,o.a),o.a=v,w=v.c,A=t.c,B=I9b(l3b(Yjb(x3b(A.Sh(false),Yjb((n8b(),new Wbc(bfc,ePc)),a.f)),s),CE(xE(HU,1),IMc,7,0,[w.Sh(false)])),m),r9b(B,m.d),g9b(m),!!m.c&&t8b(B,f9b(m)),j9b(m.g,m,B),B);m=n}}else m.n==Eec?ekb(a,m.c,
d,o):fkb(a,m.c,d,o)}if(k==c);else{l=k.g;j=l.n!=(Afc(),Ddc);ikb(a,k,e,j)}}function qwb(a){kwb();this.a=a;this.b=(oo(),es(new hs,YIc($Qc),fwb)).Lf(nwb('Duplicate parameter name "{0}"'),Uvb).Lf(YIc("Unnecessary escape:.*"),hwb).Lf(YIc("^invalid param name.*"),Yvb).Lf(nwb(occ(_Qc,CE(xE(iW,1),mLc,1,5,[]))),Tvb).Lf(YIc("^Keywords and reserved words are not allowed as unquoted property.*"),Wvb).Lf(YIc("^Too many template parameters"),ewb).Lf(YIc(".*Type annotations should have curly braces.*"),Zvb).Lf(YIc("Missing type declaration\\."),
$vb).Lf(YIc(".*Unknown type.*"),iwb).Lf(YIc("^Bad type annotation.*"),gwb).Lf(YIc("Too deep recursion while parsing"),cwb).Lf(YIc("^Octal .*literal.*"),Xvb).Lf(YIc("^String continuations.*"),dwb).Lf(YIc("^This language feature is only supported for .*"),_vb).Lf(YIc("^This language feature is not currently supported by the compiler: .*"),jwb).Lf(YIc("^type syntax is only supported in ES6 typed mode.*"),Vvb).Lf(YIc("^Can only have JSDoc or inline type.*"),awb).Kf()}function ZUb(a){var b,c,d,e,f,g;f=
DWb(a.g,0).e;if(f==(AZb(),bZb))return $Ub(a);else if(AVb(a,aZb)){RVb(a,(IRb(),mRb));return jVb(a)}else if(f==gZb||f==DYb||f==iYb||(OSb(),!!Po(pSb,f)))return zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,nNc)&&(KVb(a,1)||DWb(a.g,1).e==HYb)?uUb(a,new sWb(DWb(a.g,0).d.b)):zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,"set")&&(KVb(a,1)||DWb(a.g,1).e==HYb)?eVb(a,new sWb(DWb(a.g,0).d.b)):zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,GNc)&&(c=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(c||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&(KVb(a,1)||DWb(a.g,1).e==
HYb||zVb(a,1,bZb)&&(KVb(a,2)||DWb(a.g,2).e==HYb))?OTb(a,new sWb(DWb(a.g,0).d.b)):DWb(a.g,1).e==GYb?ZTb(a,new sWb(DWb(a.g,0).d.b)):_Ub(a);else if(f==HYb){e=DWb(a.g,0).d.b;d=_Tb(a);if(AVb(a,NXb)){iTb(a,NXb);g=KTb(a,1);return new k$b(new Z1b(e,a.f),d,g)}else{b=new T$b((Y$b(),W$b));sUb(a,b,(pWb(),oWb));g=I$b(b,new Z1b(e,a.f));return new n$b(new Z1b(e,a.f),null,d,g)}}else throw gZ(new GD(MLc));}function Hgb(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C;if(a.f==(Wgb(),Vgb))if(swc(a.e)||!uwc(a.e).a)return;
B=LPc+a.b++;k=S$((j=z8b(d),Kob(b),j));A=(t=(ae(Hsc(B,_sc(46))==-1,HMc,B),n8b(),new Wbc((Afc(),rec),B)),t);w=q3b(Tbc(A,false),k,ufc);I9b(w,c);p8b(f.g,w,f);for(h=c.c;h;h=o){o=h.f;if(h.n==tdc){p=t3b((s=Tqb(O$(Tbc(A,false),wPc),CE(xE(HU,1),IMc,7,0,[])),s));I9b(p,h);p8b(f.g,p,f);continue}if(h.n==mdc){r=LPc+a.b++;q=O$((u=Tqb(O$(Tbc(A,false),wPc),CE(xE(HU,1),IMc,7,0,[])),u),yPc);C=q3b((v=(ae(Hsc(r,_sc(46))==-1,HMc,r),new Wbc(rec,r)),v),q,ufc);I9b(C,h);p8b(f.g,C,f);l=z8b(h.c);n=Cgb((s=(ae(Hsc(r,_sc(46))==
-1,HMc,r),new Wbc(rec,r)),s),z8b(h.c?h.c.i:null))}else if(h.n==Sec){l=z8b(h.c);n=T$((i=Tbc(A,false),Kob(b),i))}else{l=z8b(h);n=O$((s=Tqb(O$(Tbc(A,false),wPc),CE(xE(HU,1),IMc,7,0,[])),s),yPc)}if(e.n==Ccc){g=(s=h3b(l,n),s);m=(Yd(H3b(g),g),new L9b(Ddc,g))}else m=q3b(l,n,e.n);I9b(m,c);p8b(f.g,m,f);Lgb(a,b,l,l.g)}z8b(f);Vob(b)}function lKb(a,b){var c,d,e,f,g,h,i,j;j=b.c;g=b.d;f=j.length;Xd(f>0);Xd(j.charCodeAt(0)!=45&&j.charCodeAt(0)!=43);if(j.charCodeAt(0)==46)return Brc("0"+j);else if(j.charCodeAt(0)==
48&&f>1)switch(j.charCodeAt(1)){case 46:case 101:case 69:return Brc(j);case 98:case 66:{aKb(a,b,(IRb(),JQb));i=0;d=1;while(++d<f)i=i*2+JKb(j.charCodeAt(d));return i}case 111:case 79:{aKb(a,b,(IRb(),oRb));i=0;d=1;while(++d<f)i=i*8+PKb(j.charCodeAt(d));return i}case 120:case 88:{i=0;d=1;while(++d<f)i=i*16+LKb(j.charCodeAt(d));return i}case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:h=0;c=0;while(++c<f){e=j.charCodeAt(c);if(e>=48&&e<=55)h=h*8+PKb(e);else{a.d.Ah(ORc,a.q,g.b.b+1,g.b.a);
return 0}}a.a.g==(KJb(),JJb)?a.d.Ah(PRc,a.q,g.b.b+1,g.b.a):a.d.Bh(PRc,a.q,g.b.b+1,g.b.a);return h;case 56:case 57:a.d.Ah(ORc,a.q,g.b.b+1,g.b.a);return 0;default:throw gZ(new Irc("Unexpected character in number literal: "+nF(j.charCodeAt(1))));}else return Brc(j)}function U8b(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p;if(a.n!=b.n||C8b(a)!=C8b(b)||a.Fj!=b.Fj)return false;if(c&&!ugc(a.d,b.d))return false;if(e&&!C5b(H8b(a,(Hbc(),mbc)),H8b(b,mbc)))return false;p=H8b(a,(Hbc(),Nac));o=H8b(b,Nac);if((!!p||!!o)&&
(!p||!o||!U8b(p,o,c,d,e,false)))return false;if(a.n==(Afc(),$dc)||a.n==jdc){i=E8b(a,abc);j=E8b(b,abc);if(i!=j)return false}else if(a.n==bfc||a.n==cfc){if(a.n==cfc){k=E8b(a,ubc);l=E8b(b,ubc);if(k!=l)return false}m=E8b(a,xbc);n=E8b(b,xbc);if(m!=n)return false}else if(a.n==Ycc){if(E8b(a,Wac)!=0!=(E8b(b,Wac)!=0))return false}else if(a.n==Jdc){if((a.n==Jdc&&E8b(a,Fac)!=0)!=(b.n==Jdc&&E8b(b,Fac)!=0))return false;if(E8b(a,Xac)!=0!=(E8b(b,Xac)!=0))return false;if((a.n==Jdc&&E8b(a,Gac)!=0)!=(b.n==Jdc&&E8b(b,
Gac)!=0))return false}if(f){if(E8b(a,wbc)!=E8b(b,wbc))return false;if(E8b(a,lbc)!=0!=(E8b(b,lbc)!=0))return false}if(d)for(g=a.c,h=b.c;g;g=g.f,h=h.f)if(!g.Xh(h,c,d,e,f))return false;return true}function crb(a,b){ppb();var c,d;if(a.n==(Afc(),ofc)&&P8b(a)&&b==(a.c?a.c.i:null))$pb((Kd(a.n==ofc),a.c.f))?e9b(a,b):A8b(b);else if(b.n==adc){d=!b.g?null:b.g.g;Xd((Kd(d.n==ofc),P8b(d)));z8b(b)}else{c=b.g;if(c.n==ofc&&c.c.f==b){d=b.g;Xd((Kd(d.n==ofc),P8b(d)));A8b(b)}else if(b.n==Vcc)A8b(b);else if(a.n==Vec||
a.n==Xec||a.n==Vcc||a.n==pec||b.n==$cc||b.n==ldc||b.n==mec)e9b(a,b);else if(!!a&&(a.n==ufc||a.n==jec||a.n==gdc)||a.n==Ddc)if(!!a.c&&!!a.c.f)e9b(a,b);else{e9b(a,b);crb(a.g,a)}else if(a.n==eec&&b==(a.c?a.c.i:null)){e9b(a,b);crb(a.g,a)}else if(a.n==Fdc)j9b(a,b,new J9b(tdc));else if(a.n==Fec)e9b(a,b);else if(a.n==Acc)b==(a.c?a.c.i:null)?e9b(a,b):j9b(a,b,new J9b(tdc));else if(a.n==odc){e9b(a,b);!!a.g.c&&crb(a.g,a)}else if(a.n==Sec)z8b(a);else if(a.n==Jec)e9b(a,b);else if(a.n==Vdc)if(b==a.c)j9b(a,b,new J9b(tdc));
else throw gZ(new Irc("Invalid attempt to remove: "+b+" from "+a));else throw gZ(new Irc("Invalid attempt to remove node: "+b+" of "+a));}}function JUb(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;f=DWb(a.g,0).d.b;zVb(a,0,(AZb(),iYb))&&Esc(DWb(a.g,0).a,GNc)&&(c=DWb(a.g,1).d.b.b>DWb(a.g,0).d.a.b,!(c||zVb(a,1,ZYb)||zVb(a,1,KXb)||zVb(a,1,XXb)))&&zVb(a,1,gYb)?e=(g=DWb(a.g,0).d.b,oTb(a,GNc),iTb(a,gYb),h=AVb(a,bZb),h&&iTb(a,bZb),i=K$b(P$b(new T$b((Y$b(),W$b)),(j=DWb(a.g,0).e,iYb==j||a.b.d&&VSb(j)||!a.b.c&&USb(j)?kTb(a):
null))),sUb(a,i,h?(pWb(),mWb):(pWb(),lWb)),I$b(i,new Z1b(g,a.f))):zVb(a,0,gYb)?e=(k=DWb(a.g,0).d.b,iTb(a,(OSb(),hSb).b),l=!!mTb(a,bZb),m=P$b(new T$b((Y$b(),W$b)),(n=DWb(a.g,0).e,iYb==n||a.b.d&&VSb(n)||!a.b.c&&USb(n)?kTb(a):null)),sUb(a,m,l?(pWb(),nWb):(pWb(),oWb)),I$b(m,new Z1b(k,a.f))):e=YUb(a);while(zVb(a,0,HYb)||zVb(a,0,MYb)||zVb(a,0,BYb)||zVb(a,0,jZb))switch(DWb(a.g,0).e.f){case 49:iTb(a,HYb);d=xTb(a,1);iTb(a,MXb);e=new l_b(new Z1b(f,a.f),e,d);break;case 51:iTb(a,MYb);b=kTb(a);e=new k_b(new Z1b(f,
a.f),e,b);break;case 107:case 104:e=mVb(a,e);break;default:throw gZ(new GD(MLc));}return e}function f0(a,b){var c,d,e,f,g,h,i,j,k,l,m;switch(b.n.f){case 86:F_(a,(IRb(),aRb),b);b0((Afc(),Qdc),b);c=Cfc(b.n);c!=-1&&(d=C8b(b),c!=d&&D0(QMc+c+RMc+d,b));g0(b);e=b.c;G_(a,e,false);e.c.Wh().length==0||D0(YMc,b);f=e.c.f;!!f.c&&D0("get methods must not have parameters.",b);return;case 87:F_(a,(IRb(),yRb),b);b0((Afc(),Yec),b);g=Cfc(b.n);g!=-1&&(h=C8b(b),g!=h&&D0(QMc+g+RMc+h,b));g0(b);i=b.c;G_(a,i,false);i.c.Wh().length==
0||D0(YMc,b);j=i.c.f;!!j.c&&!j.c.f||D0("set methods must have exactly one parameter.",b);return;case 91:b0((Afc(),cfc),b);g0(b);k=C8b(b);1!=k&&D0(UMc+k,b);E_(a,b.c);E8b(b,(n8b(),d8b))!=0&&F_(a,(IRb(),XQb),b);return;case 98:s_(a,b,false);E8b(b,(Hbc(),zbc))!=0&&D0("Keys in an object literal should not be static.",b);return;case 116:F_(a,(IRb(),PQb),b);b0((Afc(),fdc),b);l=Cfc(b.n);l!=-1&&(m=C8b(b),l!=m&&D0(QMc+l+RMc+m,b));E_(a,b.c);E_(a,b.c?b.c.i:null);return;case 115:p0(a,b);return;default:D0("Expected object literal key expression but was "+
b.n,b)}}function Ngb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p;ppb();if(!!d&&(d.n==(Afc(),ufc)||d.n==jec||d.n==gdc)&&!lqb(d.g))Jgb(a,b,c,c.f,d,d);else if(d.n==(Afc(),Ccc))d.g.n==Ddc?Jgb(a,b,c,c.f,d,d.g):(e=LPc+a.b++,f=(ae(Hsc(e,_sc(46))==-1,HMc,e),n8b(),new Wbc(rec,e)),g=z8b(d.c?d.c.i:null),h=q3b(Tbc(f,false),g,jec),qpb(b.f,(IRb(),fRb)),i=h3b(z8b(d.c),Tbc(f,false)),j=(Yd(H3b(i),i),new L9b(Ddc,i)),k=S3b(Tbc(f,false)),l=k3b(CE(xE(HU,1),IMc,7,0,[h,j,k])),m=N$(new J9b(Jec),l),Xd(m.n==Jdc),c9b(m,(Hbc(),Fac),
1),n=Tqb(m,CE(xE(HU,1),IMc,7,0,[])),qpb(b.f,GQb),I9b(n,d),b9b(n,W7b,true),j9b(d.g,d,n),Rqb(n,a.a),Jgb(a,b,i.c,i.c?i.c.i:null,i,j),undefined);else if(d.n==Sec||d.n==cfc||d.n==Acc||d.n==mdc||d.n==fdc);else if(d.n==Idc||d.n==Gdc||d.n==Hdc||lqb(d.g))Mgb(a,c);else if(d.n==adc){o=LPc+a.b++;p=c.f;k9b(c,(ae(Hsc(o,_sc(46))==-1,HMc,o),n8b(),new Wbc(rec,o)));r8b(p,q3b(c,(ae(Hsc(o,_sc(46))==-1,HMc,o),new Wbc(rec,o)),jec));qpb(b.f,(IRb(),fRb))}else throw gZ(new Irc("unexpected parent"));}function ebb(a){if(a.t!=
(E2(),C2)&&!a.s)throw gZ(new fbb("Cannot check use of goog.getCssName because of empty blacklist.",CE(xE(iW,1),mLc,1,5,[])));if(a.Mc&&!a.Lc)throw gZ(new fbb("remove_unused_prototype_props_in_externs requires remove_unused_prototype_props to be turned on.",CE(xE(iW,1),mLc,1,5,[])));if(a.Db==(Pab(),Oab)&&a.Zb!=-1)throw gZ(new fbb("max_function_size_after_inlining has no effect if inlining is disabled.",CE(xE(iW,1),mLc,1,5,[])));if(a.V){if(!kQb(l9(a),(iQb(),ZPb)))throw gZ(new fbb("Dart requires --language_out=ES5 or higher.",
CE(xE(iW,1),mLc,1,5,[])));a.f=false;a.bb=false}if(a.Mc&&a.ib)throw gZ(new fbb("remove_unused_prototype_props_in_externs and export_local_property_definitions cannot be used together.",CE(xE(iW,1),mLc,1,5,[])));if((uab(),jab)==a.Sb){X2b();if(Y2b(W2b,"/javascript/tools/jscompiler/allow-type-syntax.txt")==null)throw gZ(new fbb("type syntax is not yet generally available, please contact jscomp-team@",CE(xE(iW,1),mLc,1,5,[])));}}function Mnb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s;Kd(b.n==(Afc(),Eec));
k=new fxc;d=b.c;g=b.d;while(d)if(E8b(d,(n8b(),M7b))!=0||E8b(d,O7b)!=0){Ujb(a.b,d,"computed getter/setter in an object literal");return}else if(d.n==Qdc||d.n==Yec)d=d.f;else{e=d.f;e9b(b,d);k.Pd(d);d=e}f="$jscomp$compprop"+(""+(new j8(a.b)).a.Q++);k=pF(k,113)?Dn(k):pF(k,173)?k.a:pF(k,69)?new hx(k):new Zw(k);l=Yjb((ae(Hsc(f,_sc(46))==-1,HMc,f),n8b(),new Wbc(rec,f)),g);for(i=k.Vd();i.Id();){h=i.Jd();if(h.n==fdc){j=g9b(h);q=g9b(h);r=q.d;l=Yjb(o3b(Yjb(h3b(Nnb(a,w3b(Yjb((ae(Hsc(f,_sc(46))==-1,HMc,f),new Wbc(rec,
f)),g),j)),q),r),l),g)}else{p=g9b(h);r=p.d;A9b(h,bfc);r9b(h,a.d);o=h.Yh()?Odc:Pdc;c=Yjb(new N9b(o,Yjb((ae(Hsc(f,_sc(46))==-1,HMc,f),new Wbc(rec,f)),g),h),r);l=Yjb(o3b(Yjb(h3b(c,p),r),l),g)}}n=b;while(ppb(),!(n.n!=pec&&Jqb(n.g)))n=n.g;I9b(l,b);j9b(b.g,b,l);m=Wjb(a.a,a.c,14);s=q3b(Yjb((ae(Hsc(f,_sc(46))==-1,HMc,f),new Wbc(rec,f)),g),(Rjb(),!!m&&(b.d=m,b),b),ufc);I9b(s,n);p8b(n.g,s,n);w7(a.b,s)}function U8(a,b,c){var d,e,f;switch(b.n.f){case 28:if(!!b.c&&!!b.c.f&&b.c.f==(b.c?b.c.i:null)&&b.c.n==(Afc(),
Pdc)&&_8b(b.c.c,kNc)){_wc(a.d,(wDb(),vDb),0)!=-1||Ywc(a.d,vDb);e=b.c;d=b.c?b.c.i:null;switch((e.c?e.c.i:null).Wh()){case mNc:qGc(a.a,mNc,kNc);case CNc:if(d.n!=(Afc(),bfc))return;Ywc(a.c,d.Wh());return;case lNc:if(d.n!=(Afc(),bfc))return;Ywc(a.d,BDb(d.Wh()));return;case pNc:if(d.n!=(Afc(),bfc))return;Ywc(a.e,d.Wh());return;case BNc:b=d.c?d.c.i:null;break;default:return}}else if(c.n==(Afc(),Pdc)&&(a9b(c,oOc,oOc.length)||a9b(c,pOc,pOc.length))&&c.g.n==Ycc){d=c.g.c.f;if(d.n!=bfc)return;Ywc(a.c,d.Wh())}break;
case 112:if(E8b(c,(n8b(),Z7b))==0){Ywc(a.c,UFb(a.b.a));qGc(a.a,mNc,kOc)}break;case 105:T8(a,b.c?b.c.i:null,b);return;case 109:ppb();Kd(b.n==(Afc(),Adc));!!b.c&&!!b.c.f&&b.c.f==(b.c?b.c.i:null)&&T8(a,b.c?b.c.i:null,b);return;case 76:_8b(b.c,kNc)&&Dqb(b.c)&&Ywc(a.c,kNc);break;case 84:case 88:case 82:case 85:case 29:case 95:case 100:break;default:return}for(f=b.c;f;f=f.f)U8(a,f,b)}function NPb(){NPb=JZ;pPb=new OPb(COc,0,"all",0,0,0);qPb=new OPb("COND",1,"cond",3,3,1);rPb=new OPb("EQ",2,"eq",2,2,3);tPb=
new OPb("ISCTOR",3,"isCtor",1,1,3);uPb=new OPb("ISDEFINED",4,"isDefined",1,1,4);vPb=new OPb("ISRECORD",5,"isRecord",1,1,3);wPb=new OPb("ISTEMPLATIZED",6,"isTemplatized",1,1,3);xPb=new OPb("ISUNKNOWN",7,"isUnknown",1,1,3);sPb=new OPb(uSc,8,"instanceOf",1,1,1);zPb=new OPb("MAPUNION",9,"mapunion",2,2,1);yPb=new OPb("MAPRECORD",10,"maprecord",2,2,1);APb=new OPb(qOc,11,"none",0,0,0);BPb=new OPb("PRINTTYPE",12,"printType",2,2,1);CPb=new OPb("PROPTYPE",13,"propType",2,2,1);DPb=new OPb("RAWTYPEOF",14,"rawTypeOf",
1,1,0);GPb=new OPb("SUB",15,"sub",2,2,3);FPb=new OPb("STREQ",16,"streq",2,2,2);EPb=new OPb("RECORD",17,"record",1,_Kc,0);HPb=new OPb("TEMPLATETYPEOF",18,"templateTypeOf",2,2,0);IPb=new OPb(ERc,19,$Nc,2,_Kc,0);JPb=new OPb("TYPEEXPR",20,"typeExpr",1,1,0);KPb=new OPb("TYPEOFVAR",21,"typeOfVar",1,1,1);LPb=new OPb("UNION",22,"union",2,_Kc,0);MPb=new OPb("UNKNOWN",23,vSc,0,0,0)}function f2(){f2=JZ;new Mcb("JSC_INVALID_CLOSURE_IMPORT_DESTRUCTURING",(E2(),B2),new Rtc("Destructuring {0} must be a simple object pattern."));
new Mcb("JSC_ONE_CLOSURE_IMPORT_PER_DECLARATION",B2,new Rtc("There may only be one {0} per var/let/const declaration."));new Mcb("JSC_INVALID_CLOSURE_IMPORT_CALL",B2,new Rtc("{0} parameter must be a string literal."));new Mcb(hNc,B2,new Rtc(iNc));e2=new Mcb("JSC_LET_CLOSURE_IMPORT",C2,new Rtc(jNc));new Mcb("JSC_NO_CLOSURE_IMPORT_DESTRUCTURING",B2,new Rtc("Cannot destructure the return value of {0}"));new Mcb("JSC_LHS_OF_CLOUSRE_IMPORT_MUST_BE_CONST_IN_ES_MODULE",B2,new Rtc("The left side of a {0} must use ''const'' (not ''let'' or ''var'') in an ES module."));
x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),n8b(),new Wbc((Afc(),rec),kNc)),new Wbc(bfc,lNc));x3b(x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,mNc)),new Wbc(bfc,nNc));x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,oNc));x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,pNc))}function J4(a,b,c,d,e,f,g){var h,i,j;j=new ttc;for(i=0;i<b.length;i++){h=b.charCodeAt(i);switch(h){case 0:j.a+="\\x00";break;case 11:f?(j.a+="\\v",j):(j.a+="\\x0B",j);break;
case 8:j.a+="\\b";break;case 12:j.a+="\\f";break;case 10:j.a+="\\n";break;case 13:j.a+="\\r";break;case 9:j.a+="\\t";break;case 92:j.a+=e;break;case 34:j.a+=c;break;case 39:j.a+=d;break;case 36:j.a+="$";break;case 96:j.a+="`";break;case 61:a.k||g?(j.a+=String.fromCharCode(h),j):(j.a+="\\x3d",j);break;case 38:a.k||g?(j.a+=String.fromCharCode(h),j):(j.a+="\\x26",j);break;case 62:if(!a.k&&!g){j.a+="\\x3e";break}i>=2&&(b.charCodeAt(i-1)==45&&b.charCodeAt(i-2)==45||b.charCodeAt(i-1)==93&&b.charCodeAt(i-
2)==93)?(j.a+="\\x3e",j):(j.a+=String.fromCharCode(h),j);break;case 60:if(!a.k&&!g){j.a+="\\x3c";break}Msc(b,true,i+1,"/script",0,7)?(j.a+="\\x3c",j):Msc(b,false,i+1,"!--",0,3)?(j.a+="\\x3c",j):(j.a+=String.fromCharCode(h),j);break;default:if(g){if(h==8232){j.a+="\\u2028";break}if(h==8233){j.a+="\\u2029";break}}h>31&&h<127?(j.a+=String.fromCharCode(h),j):wD(j,h)}}return j.a}function RKb(a){RJb();switch(a.f){case 74:return Afc(),Tcc;case 75:return Afc(),Ucc;case 73:return Afc(),Rcc;case 59:return Afc(),
xdc;case 60:return Afc(),vec;case 54:return Afc(),lec;case 56:return Afc(),iec;case 55:return Afc(),Rdc;case 57:return Afc(),Ldc;case 70:return Afc(),kec;case 71:return Afc(),Wec;case 72:return Afc(),tfc;case 63:return Afc(),vcc;case 64:return Afc(),efc;case 65:return Afc(),qec;case 94:return Afc(),pdc;case 67:return Afc(),oec;case 66:return Afc(),zdc;case 61:return Afc(),Zec;case 62:return Afc(),$ec;case 16:return Afc(),Zdc;case 17:return Afc(),aec;case 53:return Afc(),edc;case 82:return Afc(),Ccc;
case 92:return Afc(),Fcc;case 93:return Afc(),Gcc;case 91:return Afc(),Ecc;case 88:return Afc(),Jcc;case 89:return Afc(),Mcc;case 90:return Afc(),Occ;case 83:return Afc(),Dcc;case 84:return Afc(),Ncc;case 85:return Afc(),Lcc;case 86:return Afc(),Icc;case 95:return Afc(),Hcc;case 87:return Afc(),Kcc;case 79:return Afc(),Hec;case 78:return Afc(),wcc;default:throw gZ(new Irc(!a?jLc:a.a==null?(OSb(),Po(pSb,a)).c:a.a));}}function dXb(a){var b,c,d,e,f;yWb(a);if(!xWb(a,a.f)){FWb(a,"Unterminated template literal escape sequence",
CE(xE(iW,1),mLc,1,5,[]));return null}if(jXb(xWb(a,a.f)?zsc(a.b,a.f):0)){d=yWb(a);d==13&&(xWb(a,a.f)?zsc(a.b,a.f):0)==10&&yWb(a);return null}e=yWb(a);switch(e){case 48:if(qXb(xWb(a,a.f)?zsc(a.b,a.f):0)>=0)return new rXb(_Sc,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));return null;case 49:case 50:case 51:case 52:case 53:case 54:case 55:return new rXb(_Sc,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));case 120:c=SWb(a)&&SWb(a);if(!c)return new rXb(bTc,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));return null;
case 117:if((xWb(a,a.f)?zsc(a.b,a.f):0)==123){yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==125)return new rXb(cTc,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));b=true;while((xWb(a,a.f)?zsc(a.b,a.f):0)!=125&&b)b=b&&SWb(a);if(!b)return new rXb(bTc,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));yWb(a);return null}else{f=SWb(a)&&SWb(a)&&SWb(a)&&SWb(a);if(!f)return new rXb(bTc,wWb(a,a.d.a.length==0?a.f:DWb(a,0).d.b.c));return null}default:return null}}function Pub(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;f=
a.c++;h="$jscomp$forAwait$tempIterator"+f;r="$jscomp$forAwait$tempResult"+f;Yd(!!d.g,"Cannot replace parentless for-await-of");j=g9b(d);s=g9b(d);m=g9b(d);t=(new bvb(a,s),null);g=I9b(d_(h,R$((i=s,Kob(b),i))),s);Vjb(false,a.d,22,t);q=d_(r,(Sd(c.a),u=(ae(Hsc(h,_sc(46))==-1,HMc,h),n8b(),new Wbc((Afc(),rec),h)),S8b(c.a)?v=f_(M3b(b_((Kob(b),NQc)),CE(xE(HU,1),IMc,7,0,[b_((Kob(b),SQc)),Tqb(x3b(u,new Wbc(bfc,wPc)),CE(xE(HU,1),IMc,7,0,[]))]))):v=K$(Tqb(x3b(u,new Wbc(bfc,wPc)),CE(xE(HU,1),IMc,7,0,[]))),v));
e=B3b(O$((o=(ae(Hsc(r,_sc(46))==-1,HMc,r),new Wbc(rec,r)),o),"done"),k3b(CE(xE(HU,1),IMc,7,0,[new J9b(Xcc)])));if(X8b(j))k=h_((p=h3b(j,O$((n=(ae(Hsc(r,_sc(46))==-1,HMc,r),new Wbc(rec,r)),n),yPc)),p));else{ppb();if(!!j&&(j.n==ufc||j.n==jec||j.n==gdc)){q8b(j.c,O$((n=(ae(Hsc(r,_sc(46))==-1,HMc,r),new Wbc(rec,r)),n),yPc));k=j}else throw gZ(new Kqc("unexpected for-await-of lhs"));}I9b(k,j);l=u3b(g,new J9b(tdc),new J9b(tdc),k3b(CE(xE(HU,1),IMc,7,0,[q,e,k,m.n==Vcc?m:F9b(k3b(CE(xE(HU,1),IMc,7,0,[m])),m)])));
j9b(d.g,d,l);I9b(l,d);w7(a.a,l)}function arb(a){ppb();switch(a.f){case 46:return 0;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 59:case 57:case 58:case 47:return 1;case 103:return 2;case 60:return 3;case 61:return 4;case 62:return 5;case 1:return 6;case 2:return 7;case 3:return 8;case 4:case 5:case 36:case 37:return 9;case 6:case 8:case 7:case 9:case 41:case 40:return 10;case 10:case 11:case 12:return 11;case 14:case 13:return 12;case 15:case 17:case 16:return 13;case 18:return 14;
case 104:case 23:case 24:case 25:case 79:case 19:case 20:case 21:case 22:return 15;case 63:case 64:return 16;case 28:case 27:case 26:case 122:case 42:case 93:case 121:case 95:case 80:case 34:case 65:case 96:case 151:case 29:case 32:case 30:case 43:case 94:case 38:case 114:case 115:case 31:case 91:case 159:case 160:case 161:case 33:case 99:case 35:case 117:case 118:case 113:case 128:return 17;case 126:return 18;case 137:case 127:return 19;case 123:case 125:case 124:case 129:case 135:case 130:case 133:case 136:case 138:return 20;
case 92:return 21;default:Kd(a!=(Afc(),jfc));throw gZ(new Irc("Unknown precedence for "+a));}}function Upc(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p;if(b.ti())return a;a.e=a.e||b.mi();a.c=a.c||b.Ci();g=pF(b,212);a.f=a.f||g;g&&(a.b=a.b&&b.ni());if(!a.e&&!a.f)if(b.Mi()){o=b.Mi();c=(Yoc(new Epc,o.b)&&Voc(o),o.b);for(f=0;f<c.Yd();f++){p=c.ce(f);Upc(a,p)}}else{if(a.a.a.length>a.g)return a;if(!!b.Ii()&&a.d!=-1){i=$wc(a.a,a.d).Ii();l=Jjc(b.Ii(),i,true);cxc(a.a,a.d,l);a.j=null;return a}e=0;h=new wxc(a.a);while(h.a<
h.c.a.length){k=false;d=(h.b=h.a++,h.c.a[h.b]);if(b.Bi()||d.Bi()||b.si()||d.si()||Wfc(b)||Wfc(d)){if($fc(b,d,a.k))return a}else if(!!b.Li()||!!d.Li())if(d.Li())if(b.Li()){Xd(!!d.Li()&&!!b.Li());m=b.Li();n=d.Li();if(Zfc(n.e,m.e))if(Onc(b.ki(),d.ki(),0,new ukc(true),0))return a;else{j=n.d;b=new koc(a.i,j,(Bn(),Bn(),An));k=true}}else Ypc(a,d,b)&&(k=true);else{if(Ypc(a,b,d))return a}else if(Ypc(a,b,d)){!!b.Ji()&&!!d.Ji()&&glc(a.i,b.Ji(),d.Ji());return a}else if(Ypc(a,d,b)){!!d.Ji()&&!!b.Ji()&&glc(a.i,
d.Ji(),b.Ji());k=true}if(k){axc(h.c,h.a=h.b);h.b=-1;if(e==a.d)a.d=-1;else if(e<a.d){--a.d;--e}}++e}if(b.Ii()){Xd(a.d==-1);a.d=a.a.a.length}Ywc(a.a,b);a.j=null}else a.j=null;return a}function KWb(a,b){switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 98:case 66:yWb(a);pXb(xWb(a,a.f)?zsc(a.b,a.f):0)>=0||FWb(a,"Binary Integer Literal must contain at least one digit",CE(xE(iW,1),mLc,1,5,[]));OWb(a);return new dTb((AZb(),DYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f));case 111:case 79:yWb(a);qXb(xWb(a,a.f)?zsc(a.b,a.f):0)>=
0||FWb(a,"Octal Integer Literal must contain at least one digit",CE(xE(iW,1),mLc,1,5,[]));VWb(a);((xWb(a,a.f)?zsc(a.b,a.f):0)==56||(xWb(a,a.f)?zsc(a.b,a.f):0)==57)&&FWb(a,ORc,CE(xE(iW,1),mLc,1,5,[]));return new dTb((AZb(),DYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f));case 120:case 88:yWb(a);Uqc(xWb(a,a.f)?zsc(a.b,a.f):0,16)>=0||FWb(a,"Hex Integer Literal must contain at least one digit",CE(xE(iW,1),mLc,1,5,[]));TWb(a);return new dTb((AZb(),DYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f));case 101:case 69:return HWb(a,
b);case 46:return IWb(a,b);case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:RWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==46){yWb(a);RWb(a)}return new dTb((AZb(),DYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f));default:return new dTb((AZb(),DYb),Vsc(a.b,b,a.f),$Sb(a.i.b,b,a.f))}}function Cpb(a,b){var c,d,e,f;Yd(a.n==(Afc(),Ycc)||a.n==hfc,a);if(Q9b(E8b(a,(Hbc(),wbc)),15))return false;if(Q9b(E8b(a,wbc)&15,11)&&rpb(a))return false;c=a.c;if(c.n==rec){e=c.Wh();if(gpb.Sd(e))return false}else if(c.n==
Pdc){if(!!a.c&&!a.c.f&&mpb.Sd((c.c?c.c.i:null).Wh()))return false;if(Q9b(E8b(a,wbc)&15,13)&&Apb(c.c,(se(),oe)))return false;if(c.c.n==rec&&V8b(c)&&Esc(c.c.Wh(),$Pc))switch((c.c?c.c.i:null).Wh()){case "abs":case "acos":case "acosh":case "asin":case "asinh":case "atan":case "atanh":case "atan2":case "cbrt":case "ceil":case "cos":case "cosh":case "exp":case "expm1":case "floor":case "hypot":case "log":case "log10":case "log1p":case "log2":case "max":case "min":case "pow":case "round":case "sign":case "sin":case "sinh":case "sqrt":case "tan":case "tanh":case "trunc":return false;
case "random":return!(!!a.c&&!a.c.f)}if(!!b&&!b.ng())if(c.c.n==Rec&&npb.Sd((c.c?c.c.i:null).Wh()))return false;else if(Lqb(c.c,b)){d=(c.c?c.c.i:null).Wh();f=c.f;if(f)if(f.n==bfc){if(opb.Sd(d))return false}else if(f.n==Rec)if(Esc("replace",d))return f.f.n!=bfc;else if(opb.Sd(d))return false}}return true}function v6(){v6=JZ;RZ();t6=new Mcb("JSC_MODULE_DEPENDENCY_ERROR",(E2(),B2),new Rtc("Bad dependency: {0} -> {1}. Modules must be listed in dependency order."));r6=new Mcb("JSC_MISSING_ENTRY_ERROR",
B2,new Rtc('required entry point "{0}" never provided'));s6=new Mcb("JSC_MISSING_MODULE_ERROR",B2,new Rtc('unknown module "{0}" specified in entry point spec'));new Mcb("JSC_INCONSISTENT_MODULE_DEFINITIONS",B2,new Rtc("Serialized module definitions are not consistent with the module definitions supplied in the command line"));new Mcb("JSC_OPTIMIZE_LOOP_ERROR",B2,new Rtc("Exceeded max number of optimization iterations: {0}"));new Mcb("JSC_MOTION_ITERATIONS_ERROR",B2,new Rtc("Exceeded max number of code motion iterations: {0}"));
u6=RIc("com.google.javascript.jscomp");new Pc(tqc);p6=new Mcb("JSC_EMPTY_MODULE_LIST_ERROR",B2,new Rtc("At least one module must be provided"));q6=new Mcb("JSC_EMPTY_ROOT_MODULE_ERROR",B2,new Rtc("Root module ''{0}'' must contain at least one source code input"));o6=new Mcb("JSC_DUPLICATE_INPUT",B2,new Rtc("Duplicate input: {0}"));n6=new Mcb("JSC_DUPLICATE_EXTERN_INPUT",B2,new Rtc("Duplicate extern input: {0}"))}function H3(){H3=JZ;new Mcb("JSC_INVALID_DESTRUCTURING_FORWARD_DECLARE",(E2(),B2),new Rtc("Cannot destructure a forward-declared type"));
new Mcb("JSC_MODULE_USES_GOOG_MODULE_GET",B2,new Rtc("It's illegal to use a 'goog.module.get' at the module top-level. Did you mean to use goog.require instead?"));new Mcb("JSC_GOOG_MODULE_INVALID_FORWARD_DECLARE_NAMESPACE",B2,new Rtc("goog.forwardDeclare parameter must be a string literal."));new Mcb("JSC_GOOG_MODULE_INVALID_GET_NAMESPACE",B2,new Rtc("goog.module.get parameter must be a string literal."));new Mcb("JSC_GOOG_MODULE_INVALID_REQUIRE_NAMESPACE",B2,new Rtc("goog.require parameter must be a string literal."));
new Mcb("JSC_GOOG_MODULE_INVALID_REQUIRE_TYPE_NAMESPACE",B2,new Rtc("goog.requireType parameter must be a string literal."));G3=new Mcb("JSC_MISSING_MODULE_OR_PROVIDE",B2,new Rtc('Required namespace "{0}" never defined.'));new Mcb("JSC_GOOG_MODULE_INVALID_GET_CALL_SCOPE",B2,new Rtc("goog.module.get can not be called in global scope."));F3=new Mcb("JSC_INVALID_CLOSURE_CALL_ERROR",B2,new Rtc("Closure primitive methods (goog.provide, goog.require, goog.define, etc) must be called  at file scope."))}
function Vtb(){Vtb=JZ;var a,b,c,d;new Cc(new Cc(new jc(97,122),new jc(65,90)),new gc);Utb=new Mcb("JSC_UNKNOWN_TWEAK_WARNING",(E2(),D2),new Rtc("no tweak registered with ID {0}"));new Mcb("JSC_TWEAK_MULTIPLY_REGISTERED_ERROR",B2,new Rtc("Tweak {0} has already been registered."));new Mcb("JSC_NON_LITERAL_TWEAK_ID_ERROR",B2,new Rtc("tweak ID must be a string literal"));Rtb=new Mcb("JSC_INVALID_TWEAK_DEFAULT_VALUE_WARNING",D2,new Rtc("tweak {0} registered with {1} must have a default value that is a literal of type {2}"));
new Mcb("JSC_NON_GLOBAL_TWEAK_INIT_ERROR",B2,new Rtc("tweak declaration {0} must occur in the global scope"));new Mcb("JSC_TWEAK_OVERRIDE_AFTER_REGISTERED_ERROR",B2,new Rtc("Cannot override the default value of tweak {0} after it has been registered"));Ttb=new Mcb("JSC_TWEAK_WRONG_GETTER_TYPE_WARNING",D2,new Rtc("tweak getter function {0} used for tweak registered using {1}"));new Mcb("JSC_INVALID_TWEAK_ID_ERROR",B2,new Rtc("tweak ID contains illegal characters. Only letters, numbers, _ and . are allowed"));
Stb=new fDc;for(b=(cub(),CE(xE(JO,1),sLc,90,0,[_tb,aub,bub,$tb,Xtb,Wtb,Ytb,Ztb])),c=0,d=b.length;c<d;++c){a=b[c];_tc(Stb,a.a,a)}}function Cfc(a){Afc();switch(a.f){case 140:case 42:case 146:case 82:case 81:case 74:case 28:case 150:case 88:case 75:case 89:case 145:case 143:case 147:case 72:case 66:case 148:case 149:case 23:case 43:case 45:case 141:case 144:case 38:case 0:case 85:case 142:case 91:case 67:case 118:case 44:case 76:case 103:return-1;case 80:case 34:case 108:case 90:case 159:case 29:case 32:case 30:case 31:case 120:case 33:case 35:return 0;
case 20:case 161:case 92:case 64:case 69:case 24:case 84:case 86:case 63:case 160:case 98:case 133:case 22:case 19:case 21:case 114:case 87:case 115:case 119:case 39:case 25:case 157:case 79:return 1;case 13:case 62:case 47:case 54:case 50:case 48:case 49:case 57:case 51:case 58:case 56:case 59:case 52:case 55:case 53:case 3:case 1:case 2:case 68:case 78:case 46:case 116:case 121:case 16:case 71:case 154:case 4:case 18:case 9:case 27:case 26:case 8:case 40:case 41:case 83:case 7:case 10:case 6:case 17:case 15:case 162:case 5:case 61:case 11:case 36:case 37:case 14:case 117:case 12:case 70:case 77:return 2;
case 96:case 73:case 101:case 102:case 65:case 60:case 105:case 151:return 3;default:throw gZ(new Irc("No arity defined for "+a));}}function njb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v;j=d.f;v=D8b(d,c);p=(Xd(!!c.c&&!c.c.f),c.c);t=p.Wh();c9b(p,(Hbc(),Ebc),1);q9b(p,H8b(c,mbc));j9b(d,c,z8b(p));l=H8b(c,mbc);k=(ppb(),m=Dpb(d.g),!m?null:H8b(m,mbc));l?u=(HPc&l.a)==WPc?l.i:null:k?u=H4b(k,t):u=null;!!u&&u.a.n!=(Afc(),sdc)&&u7(a.c,Lmb(c,djb,CE(xE(nW,1),uNc,2,6,[])));if(!j.c){Vob(b);return}r=r9b((ae(Hsc(XPc,
_sc(46))==-1,HMc,XPc),n8b(),new Wbc((Afc(),rec),XPc)),a.a);i=r9b((ae(Hsc(YPc,_sc(46))==-1,HMc,YPc),new Wbc(rec,YPc)),a.g);s=F9b((e=new J9b(Vcc),e),j);o=(ae(Hsc(t,_sc(46))==-1,HMc,t),new Wbc(rec,t));n=I9b(q3b(o,r,jec),j);r8b(s,n);qpb(b.f,(IRb(),fRb));for(g=(!j.c?(Cyc(),Cyc(),Byc):new Kbc(j.c)).Vd();g.Id();){f=g.Jd();q8b(s,z8b(f))}q=q3b(x8b(r,false),r9b(f3b(CE(xE(HU,1),IMc,7,0,[])),a.a),ufc);r8b(j,I9b(q,c));h=I9b(u3b(q3b(x8b(i,false),r9b(new tac(v),a.g),ufc),r9b(G3b(x8b(i,false),r9b(x3b((ae(Hsc(BMc,
_sc(46))==-1,HMc,BMc),new Wbc(rec,BMc)),new Wbc(bfc,"length")),a.g)),a.b),r9b(D3b(x8b(i,false)),a.g),j3b(t3b(r9b(h3b(w3b(x8b(r,false),r9b(X3b(x8b(i,false),r9b(new tac(v),a.g)),a.g)),r9b(w3b((ae(Hsc(BMc,_sc(46))==-1,HMc,BMc),new Wbc(rec,BMc)),x8b(i,false)),a.g)),a.g)))),c);o8b(j,h,q);q8b(j,s);w7(a.c,s)}function mOb(a){var b,c,d;a.p=0;for(;;){for(;;){a.a=-1;b=jOb(a);if(b==-1)return fOb(),SNb;else if(b==10)return fOb(),TNb;else{Gfc();if(!(b<=127?b==32||b==9||b==12||b==11:b==160))break}}switch(b){case 64:do{b=
jOb(a);if(b<=90?65<=b:97<=b&&b<=122)iOb(a,b);else{a.q[a.r++]=b;--a.b;a.n=gtc(a.o,0,a.p);a.p=0;return fOb(),MNb}}while(true);case 42:return oOb(a)?(fOb(),RNb):(fOb(),dOb);case 44:return fOb(),PNb;case 62:return fOb(),_Nb;case 40:return fOb(),XNb;case 41:return fOb(),bOb;case 123:return fOb(),WNb;case 125:return fOb(),aOb;case 91:return fOb(),YNb;case 93:return fOb(),cOb;case 63:return fOb(),$Nb;case 33:return fOb(),NNb;case 58:return fOb(),ONb;case 61:return fOb(),UNb;case 124:return fOb(),ZNb;case 60:return fOb(),
VNb;case 46:b=jOb(a);if(b==60)return fOb(),VNb;else{if(b==46){b=jOb(a);if(b==46)return fOb(),QNb;else iOb(a,46)}a.q[a.r++]=b;b=46}default:{c=b;iOb(a,b);d=jOb(a);if(tOb(d)){do{c=d;d=jOb(a);if(c==46&&d==60){a.q[a.r++]=d;--a.b;a.q[a.r++]=c;--a.b;a.n=gtc(a.o,0,a.p);a.p=0;return fOb(),eOb}else if(tOb(d))iOb(a,c);else{a.q[a.r++]=d;--a.b;iOb(a,c);a.n=gtc(a.o,0,a.p);a.p=0;return fOb(),eOb}}while(true)}else{a.q[a.r++]=d;--a.b;a.n=gtc(a.o,0,a.p);a.p=0;return fOb(),eOb}}}}}function J2b(a,b){var c,d,e,f,g,h,
i,j,k,l,m;c=false;e=false;f=true;g=false;i=false;j=false;l=false;h=true;k=true;d=true;switch(a.b){case 99:case 67:case 116:case 84:h=false;break;case 103:case 71:c=e=g=j=l=true;break;case 102:c=e=g=i=j=true;l=true;break;case 101:case 69:c=g=i=j=l=true;break;case 97:case 65:c=i=j=l=true;break;case 100:c=e=g=j=l=true;h=false;break;case 111:case 120:case 88:i=l=true;b==null&&(c=g=j=true);h=false;break;case 110:f=false;d=h=k=false;break;case 37:d=false;h=false;break;case 115:case 83:case 98:case 66:case 104:case 72:break;
default:throw gZ(new GD("unknownFormatConversionException"));}m=null;!c&&a.d?m="+":!e&&a.e?m=",":!f&&a.f?m="-":!g&&a.g?m="(":!i&&a.i?m="#":!j&&a.j?m=" ":!l&&a.k&&(m="0");if(m!=null)if(a.b==110)throw gZ(new GD("IllegalFormatFlagsException:"+m));else throw gZ(new GD("FormatFlagsConversionMismatchException:"+m+","+nF(a.b)));if((a.f||a.k)&&a.p==-1)throw gZ(new f2b("-"+nF(a.b)));if(!d&&a.a!=-1)throw gZ(new b2b(a.o?a.o.a:""));if(!h&&a.n!=-1)throw gZ(new c2b(a.n));if(!k&&a.p!=-1)throw gZ(new d2b(a.p));if(a.d&&
a.j)throw gZ(new b2b("the '+' and ' ' flags are incompatible"));if(a.f&&a.k)throw gZ(new b2b("the '-' and '0' flags are incompatible"));}function lhb(a){var b,c,d,e,f,g,h,i,j,k,l,m,n;j=a.e.g;Xd(E8b(j,(Hbc(),Xac))!=0);b9b(j,(n8b(),X7b),false);m=a.f.g?Nkc(a.f.f,Zkc(a.f.f,CE(xE(cV,1),xPc,23,0,[a.f.j,Wkc(a.f.f,Ho(yPc,a.g))])),CE(xE(cV,1),xPc,23,0,[a.a.g])):null;i=(c=new J9b((Afc(),Vcc)),c);if(ihb(j)){d=j==j.g.c?null:j.i;Xd(d.n==Pdc);a.c=(!j.g?null:j.g.g).g;Yd(a.c.n==Vcc,a.c);e=(ppb(),Gpb(a.c,new frb(Jdc)));
Yd(e.n==Jdc,e);d.c.f._h("asyncExecutePromiseGeneratorProgram");k=d.d;!!k&&!!k.Ii()&&r9b(d,Nkc(a.f.f,k.Ii().b.b,CE(xE(cV,1),xPc,23,0,[m])));l=a.e.g;q8b(G8b(a.e),Nhb(a.a,a.e));k9b(a.e,i)}else{e=j;h=j.c;Xd(h.n==rec);h.Wh().length==0&&h._h(Phb(a.a,MPc).a);l=v3b((ae(Hsc("",_sc(46))==-1,HMc,""),new Wbc(rec,"")),Q3b(Nhb(a.a,a.e)),i);f=z3b(Yjb(z3b(Yjb((ae(Hsc(NPc,_sc(46))==-1,HMc,NPc),new Wbc(rec,NPc)),a.f.i),"generator",CE(xE(nW,1),uNc,2,6,[])),a.f.i),"createGenerator",CE(xE(nW,1),uNc,2,6,[]));a.f.g&&r9b(f,
Nkc(a.f.f,a.d,CE(xE(cV,1),xPc,23,0,[m])));a.c=j3b(G9b(S3b(Yjb(l3b(f,CE(xE(HU,1),IMc,7,0,[Yjb(h.Sh(false),j.d),l])),a.d)),a.e));k9b(a.e,a.c)}l.d=m;v7(a.f.b,l);epb(a.f.b,a.e,new Eib);n=!hhb(a,a.e);while(a.e.c)thb(a,g9b(a.e),null,null);g=(b=new J9b(Vcc),b);n&&q8b(g,Dhb(a.a,a.e,"jumpToEnd",CE(xE(HU,1),IMc,7,0,[])));nib(a.a.j,a.a.p,g);a.a.j.e=true;Mhb(a.a,i);Ehb(a.a);v7(a.f.b,e)}function ICb(){ICb=JZ;ECb=new Mcb("JSC_UNDEFINED_VARIABLE",(E2(),B2),new Rtc("variable {0} is undeclared"));HCb=new Mcb("JSC_VIOLATED_MODULE_DEPENDENCY",
B2,new Rtc("module {0} cannot reference {2}, defined in module {1}, since {1} loads after {0}"));zCb=new Mcb("JSC_MISSING_MODULE_DEPENDENCY",D2,new Rtc("missing module dependency; module {0} should depend on module {1} because it references {2}"));CCb=new Mcb("JSC_STRICT_MODULE_DEPENDENCY",C2,new Rtc(sNc));ACb=new Mcb("JSC_NAME_REFERENCE_IN_EXTERNS",D2,new Rtc("accessing name {0} in externs has no effect. Perhaps you forgot to add a var keyword?"));DCb=new Mcb("JSC_UNDEFINED_EXTERN_VAR_ERROR",D2,
new Rtc("name {0} is not defined in the externs."));GCb=new Mcb("JSC_VAR_MULTIPLY_DECLARED_ERROR",B2,new Rtc("Variable {0} declared more than once. First occurrence: {1}"));FCb=new Mcb("JSC_VAR_ARGUMENTS_SHADOWED_ERROR",B2,new Rtc('Shadowing "arguments" is not allowed'));yCb=new Mcb("JSC_BLOCK_SCOPED_DECL_MULTIPLY_DECLARED_ERROR",B2,new Rtc("Duplicate let / const / class / function declaration in the same scope is not allowed."));BCb=tp(kPc,iPc,mPc,nPc,xQc,"Map",CE(xE(nW,1),uNc,2,6,[$Pc,oPc,NMc,pPc,
jPc,"Reflect",qPc,"Set",oMc,rPc,"TypeError","WeakMap",vNc,"isNaN","parseFloat","parseInt",vPc,"window"]))}function upb(a,b,c){ppb();var d,e,f,g,h,i,j;switch(a.n.f){case 39:case 103:case 109:case 76:case 100:case 88:return true;case 43:if(b)return true;for(i=a.c;i;i=i.f)for(f=i.c;f;f=f.f)if(upb(f,b,c))return true;return false;case 42:case 38:if(b)return true;break;case 115:h=(Xd(!!a.c&&!a.c.f),a.c);if(h.n!=(Afc(),zcc))return true;break;case 29:if(a.c)return true;break;case 65:return b||a.n==(Afc(),
Jdc)&&iqb(a.g)&&a.n==Jdc&&Gqb(a.c);case 96:return b||a.n==(Afc(),bdc)&&iqb(a.g)&&a.n==bdc&&Gqb(a.c)||upb(a.c.f,b,c)||upb(a.c?a.c.i:null,b,c);case 97:for(j=a.c;j;j=j.f)if(j.n==(Afc(),fdc)&&upb(j.c,b,c))return true;return false;case 23:if(b)return true;if(!vpb(a))break;return true;case 28:if(!Cpb(a,c))break;return true;case 117:return Cpb(a,c);case 92:case 62:case 82:case 81:case 84:case 60:case 66:case 45:case 30:case 61:case 33:case 35:case 34:case 32:case 31:case 91:case 67:case 119:case 44:case 80:case 118:case 120:case 116:break;
default:if(Hqb(a.n))break;if(aqb(a)){d=a.c;if(d.n==(Afc(),rec))return true;if(upb(a.c,b,c)||upb(a.c?a.c.i:null,b,c))return true;if(d.n==Pdc||d.n==Odc){g=d.c;if(Apb(g,(se(),oe)))return false;while(g.n==Pdc||g.n==Odc)g=g.c;return!zqb(g,true)}else return!zqb(d,true)}return true}for(e=a.c;e;e=e.f)if(upb(e,b,c))return true;return false}function rsb(a){var b,c,d,e,f,g;psb(a);e=new fxc;Zwc(e,po(a.I));Cyc();dxc(e,new zsb);Mc(new Pc(gMc),"\nTOTAL:","Start time(ms): "+zZ(a.H),CE(xE(iW,1),mLc,1,5,["End time(ms): "+
zZ(a.i),"Wall time(ms): "+zZ(vZ(a.i,a.H)),"Passes runtime(ms): "+a.F,"Max mem usage (measured after each pass)(MB): "+a.C,"#Runs: "+a.G,"#Changing runs: "+a.c,"#Loopable runs: "+a.B,"#Changing loopable runs: "+a.A,"Estimated AST reduction(#nodes): "+a.a,"Estimated Reduction(bytes): "+a.g,"Estimated GzReduction(bytes): "+a.p,"Estimated AST size(#nodes): "+a.b,"Estimated Size(bytes): "+a.e,"Estimated GzSize(bytes): "+a.o]));Mc(new Pc(gMc),"\n\nInputs:","JS lines:   "+a.t,CE(xE(iW,1),mLc,1,5,["JS sources: "+
a.v,"Extern lines:   "+a.j,"Extern sources: "+a.k+"\n\n"]));for(c=new wxc(e);c.a<c.c.a.length;){b=(c.b=c.a++,c.c.a[c.b]);d=b.Ve();f=b.We();x2b("%s,%d,%d,%d,%d,%d,%d,%d\n",CE(xE(iW,1),mLc,1,5,[d,isc(f.n),Yrc(f.a),Yrc(f.k),Yrc(f.d),Yrc(f.b),Yrc(f.e),Yrc(f.f)]))}Mc(new Pc(gMc),"Log:","pass,runtime,allocMem,codeChanged,astReduction,reduction,gzReduction,astSize,size,gzSize\n",CE(xE(iW,1),mLc,1,5,[]));for(g=new wxc(a.w);g.a<g.c.a.length;){f=(g.b=g.a++,g.c.a[g.b]);x2b("%s,%d,%d,%b,%d,%d,%d,%d,%d,%d\n",
CE(xE(iW,1),mLc,1,5,[f.j,isc(f.n),Yrc(f.a),(Nqc(),f.d==1?true:false),Yrc(f.b),Yrc(f.e),Yrc(f.f),Yrc(f.c),Yrc(f.o),Yrc(f.g)]))}}function llb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o;i=d.g;g=false;l=(Rlb(),Plb);switch(d.n.f){case 86:case 87:case 91:case 98:h=null;if(i.n==(Afc(),Eec)){h=nlb(a,d);g=true}else if(i.n==cdc){h=(m=d.g,Xd(m.n==cdc),n=(ppb(),o=Ppb(m.g),!o?null:I8b(o)),n==null?null:n+"."+d.Wh());g=true}else i.n==Fec&&(h=olb(d));if(h==null)return;switch(d.n.f){case 98:l=qlb(a,d.c);if(d.g.n==cdc&&E8b(d,
(Hbc(),zbc))==0)return;break;case 91:l=qlb(a,d.c);break;case 86:case 87:l=Nlb;break;default:throw gZ(new Irc("unexpected:"+d));}break;case 29:switch(i.n.f){case 76:case 100:case 88:g=true;k=d.c;l=!k?Plb:qlb(a,k);break;case 47:if(i.c==d){g=true;l=qlb(a,d.f)}break;case 26:return;case 65:e=i.g;if(!e||(ppb(),i.n==(Afc(),Jdc)&&!(i.n==Jdc&&iqb(i.g)&&i.n==Jdc&&Gqb(i.c))&&!Bqb(i)))return;g=true;l=Mlb;break;case 78:case 63:case 64:g=true;l=Plb;break;case 96:if(i.c==d){g=true;l=Llb}break;case 91:case 93:case 121:case 116:case 114:if(xqb(d)){g=
true;l=Plb}break;default:if(aqb(i)&&i.c==d){g=true;l=Plb}}h=d.Wh();break;case 26:if(i)switch(i.n.f){case 47:if(i.c==d){g=true;l=qlb(a,d.f)}break;case 63:case 64:g=true;l=Plb;break;case 26:return;default:if(aqb(i)&&i.c==d){g=true;l=Plb}}if(!V8b(d))return;h=I8b(d);break;case 28:if(wlb(d)){j=I8b(d.c.c);plb(a,j)}return;default:return}if(!hlb(a.a,h,c))return;if(g){f=e$(c);!f.b?tlb(a,b,c,d,i,h,l):ulb(a,b,c,d,i,h)}else rlb(a,b,c,d,i,h)}function nUb(a){var b,c,d,e,f;e=DWb(a.g,0).d.b;iTb(a,(AZb(),fYb));b=
zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,ZSc);b&&oTb(a,ZSc);iTb(a,GYb);if(QVb(a)){f=wVb(a,0);if(AVb(a,mYb)){b&&VVb(a,"for-await-of is the only allowed asynchronous iteration",CE(xE(iW,1),mLc,1,5,[]));f.b.Yd()>1&&VVb(a,"for-in statement may not have more than one variable declaration",CE(xE(iW,1),mLc,1,5,[]));c=f.b.ce(0);!!c.b&&(a.b.a?VVb(a,"for-in statement may not have initializer",CE(xE(iW,1),mLc,1,5,[])):EOb(a.c,c.o.b,"for-in statement should not have initializer",CE(xE(iW,1),mLc,1,5,[])));return lUb(a,
e,f)}else if(zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,"of")){f.b.Yd()>1&&(b?VVb(a,"for-await-of statement may not have more than one variable declaration",CE(xE(iW,1),mLc,1,5,[])):VVb(a,"for-of statement may not have more than one variable declaration",CE(xE(iW,1),mLc,1,5,[])));c=f.b.ce(0);!!c.b&&(b?VVb(a,"for-await-of statement may not have initializer",CE(xE(iW,1),mLc,1,5,[])):VVb(a,"for-of statement may not have initializer",CE(xE(iW,1),mLc,1,5,[])));return b?kUb(a,e,f):mUb(a,e,f)}else{gTb(a,f);return oUb(a,
e,f)}}if(AVb(a,ZYb))return oUb(a,e,null);d=xTb(a,0);if(AVb(a,mYb)||AVb(a,ZXb)||zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,"of")){d=WVb(a,d);HZb(d)||VVb(a,WSc,CE(xE(iW,1),mLc,1,5,[]))}if(AVb(a,mYb)||zVb(a,0,iYb)&&Esc(DWb(a.g,0).a,"of"))if(d.p!=(n1b(),F_b)&&d.p!=N_b)return AVb(a,mYb)?lUb(a,e,d):b?kUb(a,e,d):mUb(a,e,d);return oUb(a,e,d)}function kwb(){kwb=JZ;bwb=new Mcb("JSC_PARSE_ERROR",(E2(),B2),new Rtc(XQc));gwb=new Mcb("JSC_TYPE_PARSE_ERROR",D2,new Rtc(GOc));iwb=new Mcb("JSC_UNRECOGNIZED_TYPE_ERROR",D2,new Rtc(GOc));
Zvb=new Mcb("JSC_JSDOC_MISSING_BRACES_WARNING",C2,new Rtc(GOc));$vb=new Mcb("JSC_JSDOC_MISSING_TYPE_WARNING",C2,new Rtc(GOc));ewb=new Mcb("JSC_TOO_MANY_TEMPLATE_PARAMS",C2,new Rtc(GOc));fwb=new Mcb("JSC_TRAILING_COMMA",B2,new Rtc("Parse error. IE8 (and below) will parse trailing commas in array and object literals incorrectly. If you are targeting newer versions of JS, set the appropriate language_in option."));Uvb=new Mcb("JSC_DUPLICATE_PARAM",B2,new Rtc(XQc));hwb=new Mcb("JSC_UNNECESSARY_ESCAPE",
C2,new Rtc(XQc));Yvb=new Mcb("JSC_INVALID_PARAM",D2,new Rtc(XQc));Tvb=new Mcb("JSC_BAD_JSDOC_ANNOTATION",D2,new Rtc(XQc));Wvb=new Mcb("JSC_INVALID_ES3_PROP_NAME",D2,new Rtc(YQc));cwb=new Mcb("JSC_PARSE_TREE_TOO_DEEP",B2,new Rtc("Parse tree too deep."));Xvb=new Mcb("JSC_INVALID_OCTAL_LITERAL",D2,new Rtc("This style of octal literal is not supported in strict mode."));dwb=new Mcb("JSC_STRING_CONTINUATION",D2,new Rtc(GOc));_vb=new Mcb("JSC_LANGUAGE_FEATURE",B2,new Rtc("{0}."));jwb=new Mcb("JSC_UNSUPPORTED_LANGUAGE_FEATURE",
B2,new Rtc("{0}."));Vvb=new Mcb("JSC_ES6_TYPED",B2,new Rtc("{0}. Use --language_in=ECMASCRIPT6_TYPED to enable ES6 typed features."));awb=new Mcb("JSC_MISPLACED_TYPE_SYNTAX",B2,new Rtc(ZQc))}function C5b(a,b){var c,d,e,f,g,h,i,j;if(!a&&!b)return true;if(!a||!b)return false;if(!kFc(G4b(a),G4b(b)))return false;for(h=G4b(a).Vd();h.Id();){g=h.Jd();if(!kFc(H4b(a,g),H4b(b,g)))return false}if((!a.b||!a.b.d?(Bn(),Bn(),An):a.b.d).Yd()!=(!b.b||!b.b.d?(Bn(),Bn(),An):b.b.d).Yd())return false;c=(!a.b||!a.b.d?
(Bn(),Bn(),An):a.b.d).Vd();d=(!b.b||!b.b.d?(Bn(),Bn(),An):b.b.d).Vd();while(c.Id())if(!R5b(c.Jd(),d.Jd()))return false;return kFc(!a.b?null:a.b.a,!b.b?null:b.b.a)&&kFc(!a.d?null:a.d.a,!b.d?null:b.d.a)&&(!a.b?null:a.b.b)==(!b.b?null:b.b.b)&&(!a.b?null:a.b.c)==(!b.b?null:b.b.c)&&kFc(C4b(a),C4b(b))&&kFc((HPc&a.a)==eQc?a.i:null,(HPc&b.a)==eQc?b.i:null)&&kFc(A4b(a),A4b(b))&&kFc(!a.d?null:a.d.i,!b.d?null:b.d.i)&&(!a.d?null:a.d.j)==(!b.d?null:b.d.j)&&(!a.d?null:a.d.k)==(!b.d?null:b.d.k)&&kFc((f=!a.d?null:
a.d.n,!f?(Cyc(),Cyc(),Byc):f),(e=!b.d?null:b.d.n,!e?(Cyc(),Cyc(),Byc):e))&&(!a.b?null:a.b.i)==(!b.b?null:b.b.i)&&(!a.d?0:a.d.p)==(!b.d?0:b.d.p)&&kFc(!a.b?null:a.b.g,!b.b?null:b.b.g)&&(!a.b?null:a.b.f)==(!b.b?null:b.b.f)&&kFc((HPc&a.a)==$Lc?a.i:null,(HPc&b.a)==$Lc?b.i:null)&&kFc((j=!a.d?null:a.d.q,!j?(Cyc(),Cyc(),Byc):j),(i=!b.d?null:b.d.q,!i?(Cyc(),Cyc(),Byc):i))&&kFc(J4b(a),J4b(b))&&kFc(a.g,b.g)&&kFc(K4b(a),K4b(b))&&kFc((HPc&a.a)==hMc?a.i:null,(HPc&b.a)==hMc?b.i:null)&&kFc((HPc&a.a)==WPc?a.i:null,
(HPc&b.a)==WPc?b.i:null)&&(!a.b?null:a.b.k)==(!b.b?null:b.b.k)&&kFc(a.j,b.j)&&a.a==b.a}function jHb(){jHb=JZ;ZGb=new Mcb("JSC_CLASS_DISALLOWED_JSDOC",(E2(),C2),new Rtc("@constructor annotations are redundant on classes."));aHb=new Mcb("JSC_MISSING_JSDOC",C2,new Rtc("Function must have JSDoc."));bHb=new Mcb("JSC_MISSING_PARAMETER_JSDOC",C2,new Rtc("Parameter must have JSDoc."));dHb=new Mcb("JSC_MIXED_PARAM_JSDOC_STYLES",C2,new Rtc("Functions may not use both @param annotations and inline JSDoc"));
cHb=new Mcb("JSC_MISSING_RETURN_JSDOC",C2,new Rtc("Function with non-trivial return must have JSDoc indicating the return type."));eHb=new Mcb("JSC_MUST_BE_PRIVATE",C2,new Rtc("Property {0} must be marked @private"));fHb=new Mcb("JSC_MUST_HAVE_TRAILING_UNDERSCORE",C2,new Rtc("Private property {0} should end with ''_''"));gHb=new Mcb("JSC_OPTIONAL_PARAM_NOT_MARKED_OPTIONAL",C2,new Rtc("Parameter {0} is optional so its type must end with ="));iHb=new Mcb("JSC_WRONG_NUMBER_OF_PARAMS",C2,new Rtc("Wrong number of @param annotations"));
_Gb=new Mcb("JSC_INCORRECT_PARAM_NAME",C2,new Rtc("Incorrect param name. Are your @param annotations in the wrong order?"));$Gb=new Mcb("JSC_EXTERNS_FILES_SHOULD_BE_ANNOTATED",C2,new Rtc("Externs files should be annotated with @externs in the @fileoverview block."));hHb=new Mcb("JSC_PREFER_BACKTICKS_TO_AT_SIGN_CODE",C2,new Rtc("Use `some_code` instead of '{'@code some_code'}'."));YGb=new bcb(CE(xE(bM,1),mLc,5,0,[ZGb,aHb,bHb,dHb,cHb,eHb,fHb,gHb,iHb,_Gb,$Gb,hHb]))}function oCb(){oCb=JZ;gCb=(Ofc(),"(Proxy)");
mCb=new Mcb("JSC_MALFORMED_TYPEDEF",(E2(),D2),new Rtc("Typedef for {0} does not have any type information"));iCb=new Mcb("JSC_ENUM_INITIALIZER_NOT_ENUM",D2,new Rtc("enum initializer must be an object literal or an enum"));new Mcb("JSC_INVALID_ENUM_KEY",D2,new Rtc("enum key must be a string or numeric literal"));fCb=new Mcb("JSC_CTOR_INITIALIZER_NOT_CTOR",D2,new Rtc("Constructor {0} must be initialized at declaration"));jCb=new Mcb("JSC_IFACE_INITIALIZER_NOT_IFACE",D2,new Rtc("Interface {0} must be initialized at declaration"));
eCb=new Mcb("JSC_REFLECT_CONSTRUCTOR_EXPECTED",D2,new Rtc("Constructor expected as first argument"));nCb=new Mcb("JSC_UNKNOWN_LENDS",D2,new Rtc("Variable {0} not declared before @lends annotation."));lCb=new Mcb("JSC_LENDS_ON_NON_OBJECT",D2,new Rtc("May only lend properties to object types. {0} has type {1}."));kCb=new Mcb("JSC_INCOMPATIBLE_ALIAS_ANNOTATION",D2,new Rtc("Annotation {0} on {1} incompatible with aliased type."));hCb=new Mcb("JSC_DYNAMIC_EXTENDS_WITHOUT_JSDOC",D2,new Rtc("The right-hand side of an extends clause must be a qualified name, or else @extends must be specified in JSDoc"));
new Mcb("JSC_CONFLICTING_GETTER_SETTER_TYPE",D2,new Rtc("The types of the getter and setter for property ''{0}'' do not match.\ngetter type is: {1}\nsetter type is: {2}"));new _bb(gCb,CE(xE(bM,1),mLc,5,0,[mCb,iCb,fCb,jCb,eCb,nCb,lCb,kCb,hCb]))}function MBb(){MBb=JZ;HBb=new Mcb("JSC_INVALID_CAST",(E2(),D2),new Rtc("invalid cast - must be a subtype or supertype\nfrom: {0}\nto  : {1}"));KBb=new Mcb("JSC_TYPE_MISMATCH",D2,new Rtc(GOc));GBb=new Mcb("JSC_INVALID_ASYNC_RETURN_TYPE",D2,new Rtc("The return type of an async function must be a supertype of Promise\nfound: {0}"));
IBb=new Mcb("JSC_INVALID_OPERAND_TYPE",C2,new Rtc(GOc));JBb=new Mcb("JSC_MISSING_EXTENDS_TAG",D2,new Rtc("Missing @extends tag on type {0}"));BBb=new Mcb("JSC_DUP_VAR_DECLARATION",D2,new Rtc("variable {0} redefined, original definition at {1}:{2}"));CBb=new Mcb("JSC_DUP_VAR_DECLARATION_TYPE_MISMATCH",D2,new Rtc("variable {0} redefined with type {1}, original definition at {2}:{3} with type {4}"));FBb=new Mcb("JSC_INTERFACE_METHOD_NOT_IMPLEMENTED",D2,new Rtc("property {0} on interface {1} is not implemented by type {2}"));
DBb=new Mcb("JSC_HIDDEN_INTERFACE_PROPERTY_MISMATCH",D2,new Rtc("mismatch of the {0} property on type {1} and the type of the property it overrides from interface {2}\noriginal: {3}\noverride: {4}"));zBb=new Mcb("JSC_ABSTRACT_METHOD_NOT_IMPLEMENTED",D2,new Rtc("property {0} on abstract class {1} is not implemented by type {2}"));LBb=new Mcb("JSC_UNKNOWN_TYPEOF_VALUE",D2,new Rtc("unknown type: {0}"));EBb=new Mcb("JSC_ILLEGAL_PROPERTY_ACCESS",D2,new Rtc("Cannot do {0} access on a {1}"));ABb=new bcb(CE(xE(bM,
1),mLc,5,0,[zBb,BBb,CBb,DBb,EBb,FBb,GBb,HBb,JBb,KBb,LBb]))}function jeb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H;H=g9b(b);r=g9b(b);e=g9b(b);F=a.g;if(a.a){s=bgc(r.d.ei());!!s&&(F=Ufc(s,a.e.u[24]))}v=Vjb(a.a,a.e,26,F);t=a.a?(D=Chc(v?v:null,wPc),!D?null:D.Ni((v?v:null).b)).Ii():null;l=a.a?t.b.b:null;G=H8b(H,(Hbc(),mbc));p=Yjb(K3b("$jscomp$iter$"+(""+(new j8(a.c)).a.Q++)),v);c9b(p,pbc,1);j=Yjb(l3b(Yjb(x3b(x8b(p,false),leb(a,(n8b(),new Wbc((Afc(),bfc),wPc)))),t),CE(xE(HU,1),IMc,
7,0,[])),l);u="$jscomp$key$";ppb();!!H&&(H.n==ufc||H.n==jec||H.n==gdc)?u+=H.c.Wh():H.n==rec?u+=H.Wh():u+=Hbb(a.d);q=Yjb((ae(Hsc(u,_sc(46))==-1,HMc,u),new Wbc(rec,u)),l);c9b(q,pbc,1);f=Xjb(a.c,r);if(a.a){C=Upc(Upc(Upc(new $pc(a.e,false),a.e.u[45]),a.e.u[26]),a.e.u[24]);d=blc(a.e,"Arguments");!!d&&Upc(C,d);w=Nkc(a.e,v,CE(xE(cV,1),xPc,23,0,[Vpc(C)]));k=f.c;k.d=w;r9b(k.c,a.e.u[51]);r9b(k.c.f,a.e.u[45]);f.d=v}n=q3b(Yjb(x8b(p,false),p.d),f,ufc);o=x8b(q,false);r8b(o,x8b(j,false));q8b(n,o);g=keb(a,N3b(keb(a,
x3b(x8b(q,false),leb(a,new Wbc(bfc,"done"))))));m=Yjb(h3b(x8b(q,false),x8b(j,false)),l);if(!!H&&(H.n==ufc||H.n==jec||H.n==gdc)){i=H.n;h=r9b(new L9b(i,F9b(K3b(H.c.Wh()),H.c)),F);q8b(h.c,Yjb(x3b(x8b(q,false),leb(a,new Wbc(bfc,yPc))),F));d9b(h,mbc,G)}else{h=Yjb(h3b(Yjb(q9b(x8b(H,false),null),F),Yjb(x3b(x8b(q,false),leb(a,new Wbc(bfc,yPc))),F)),F);d9b(h,mbc,G);h=(Yd(H3b(h),h),new L9b(Ddc,h))}A=F9b(k3b(CE(xE(HU,1),IMc,7,0,[h,e])),e);B=u3b(n,g,m,A);I9b(B,b);j9b(c,b,B);w7(a.c,B)}function A2(){A2=JZ;var a;
y2=new Mcb("JSC_MISPLACED_MSG_ANNOTATION",(E2(),C2),new Rtc("Misplaced message annotation. @desc, @hidden, and @meaning annotations should only be on message nodes.\nMessage constants must be prefixed with 'MSG_'."));x2=new Mcb("JSC_MISPLACED_ANNOTATION",D2,new Rtc("Misplaced {0} annotation. {1}"));q2=new Mcb("JSC_ANNOTATION_DEPRECATED",D2,new Rtc("The {0} annotation is deprecated. {1}"));t2=new Mcb("JSC_DISALLOWED_MEMBER_JSDOC",D2,new Rtc("Class level JSDocs (@interface, @extends, etc.) are not allowed on class members"));
r2=new Mcb("JSC_ARROW_FUNCTION_AS_CONSTRUCTOR",B2,new Rtc("Arrow functions cannot be used as constructors"));s2=new Mcb("JSC_DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL",B2,new Rtc("Inline JSDoc on default parameters must be marked as optional"));v2=new Mcb("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION",B2,new Rtc("@nosideeffects may only appear in externs files."));u2=new Mcb("JSC_INVALID_MODIFIES_ANNOTATION",B2,new Rtc("@modifies may only appear in externs files."));new Mcb("JSC_INVALID_DEFINE_ON_LET",B2,new Rtc("variables annotated with @define may only be declared with VARs, ASSIGNs, or CONSTs"));
z2=new Mcb("JSC_MISPLACED_SUPPRESS",D2,new Rtc("@suppress annotation not allowed here. See https://github.com/google/closure-compiler/wiki/@suppress-annotations"));w2=new Mcb("JSC_JSDOC_IN_BLOCK_COMMENT",D2,new Rtc("Non-JSDoc comment has annotations. Did you mean to start it with '/**'?"));a=new XIc;a.a=new $wnd.RegExp("(/|(\n[ \t]*))\\*[ \t]*@[a-zA-Z]+[ \t\n{]")}function Pxb(){Pxb=JZ;Oxb=new Mcb("JSC_USE_OF_WITH",(E2(),D2),new Rtc("The 'with' statement cannot be used in strict mode."));Lxb=new Mcb("JSC_EVAL_DECLARATION",
D2,new Rtc('"eval" cannot be redeclared in strict mode'));Kxb=new Mcb("JSC_EVAL_ASSIGNMENT",D2,new Rtc('the "eval" object cannot be reassigned in strict mode'));Gxb=new Mcb("JSC_ARGUMENTS_DECLARATION",D2,new Rtc('"arguments" cannot be redeclared in strict mode'));Dxb=new Mcb("JSC_ARGUMENTS_ASSIGNMENT",D2,new Rtc('the "arguments" object cannot be reassigned in strict mode'));Exb=new Mcb("JSC_ARGUMENTS_CALLEE_FORBIDDEN",D2,new Rtc('"arguments.callee" cannot be used in strict mode'));Fxb=new Mcb("JSC_ARGUMENTS_CALLER_FORBIDDEN",
D2,new Rtc('"arguments.caller" cannot be used in strict mode'));Nxb=new Mcb("JSC_FUNCTION_CALLER_FORBIDDEN",D2,new Rtc("A function''s \"caller\" property cannot be used in strict mode"));Mxb=new Mcb("JSC_FUNCTION_ARGUMENTS_PROP_FORBIDDEN",D2,new Rtc("A function''s \"arguments\" property cannot be used in strict mode"));Hxb=new Mcb("JSC_BAD_FUNCTION_DECLARATION",D2,new Rtc("functions can only be declared at top level or immediately within another function in ES5 strict mode"));Ixb=new Mcb("JSC_DELETE_VARIABLE",
D2,new Rtc("variables, functions, and arguments cannot be deleted in strict mode"));Jxb=new Mcb("JSC_DUPLICATE_OBJECT_KEY",B2,new Rtc('Object literal contains illegal duplicate key "{0}", disallowed in strict mode'));new Mcb("JSC_DUPLICATE_CLASS_METHODS",B2,new Rtc('Class contains duplicate method name "{0}"'))}function nKb(a,b,c){var d,e,f,g,h,i,j,k,l;l=b.c;l=Psc(l,"\r\n?",gMc);k=c?0:1;f=Hsc(l,_sc(92));if(f==-1)return c?l:Vsc(l,1,l.length-1);j=new stc;while(f!=-1){j.a+=""+(l==null?jLc:l).substr(k,
f-k);f+=1;d=l.charCodeAt(f);switch(d){case 98:j.a+="\b";break;case 102:j.a+="\f";break;case 110:j.a+=gMc;break;case 114:j.a+="\r";break;case 116:j.a+="\t";break;case 118:j.a+="\x0B";break;case 10:aKb(a,b,(IRb(),ARb));a.d.Bh("String continuations are not recommended. See https://google.github.io/styleguide/jsguide.html#features-strings-no-line-continuations",a.q,b.d.b.b+1,b.d.b.a);break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:f+1<l.length&&OKb(l.charCodeAt(f+1))?f+2<l.length&&
OKb(l.charCodeAt(f+2))?i=3:i=2:i=1;if(a.a.g==(KJb(),JJb)||c)if(d==48&&i==1);else a.d.Bh("Octal literals in strings are not supported in this language mode.",a.q,b.d.b.b+1,b.d.b.a);itc(j,Crc(l.substr(f,f+i-f),8)&dLc);f+=i-1;break;case 120:itc(j,LKb(l.charCodeAt(f+1))*16+LKb(l.charCodeAt(f+2))&dLc);f+=2;break;case 117:{if(l.charCodeAt(f+1)!=123){g=f+5;h=l.substr(f+1,g-(f+1))}else{g=f+2;while(Uqc(l.charCodeAt(g),16)>=0)++g;h=l.substr(f+2,g-(f+2));++g}}e=Crc(h,16);if(e>lMc){a.d.Ah("Undefined Unicode code-point",
a.q,b.d.b.b+1,b.d.b.a);j.a+="\\u{";j.a+=""+h;j.a+="}"}else qtc(j,(EKc(e>=0&&e<=lMc),e>=kMc?CE(xE(xF,1),eLc,46,15,[55296+(e-kMc>>10&mMc)&dLc,56320+(e-kMc&mMc)&dLc]):CE(xE(xF,1),eLc,46,15,[e&dLc])));f=g-1;break;case 39:case 34:case 92:default:j.a+=String.fromCharCode(d)}k=f+1;f=Isc(l,_sc(92),k)}ntc(j,l,k,c?l.length:l.length-1);return j.a}function $kb(){$kb=JZ;Okb=new Mcb("JSC_EXTENDS_WITHOUT_TYPEDEF",(E2(),D2),new Rtc("@extends used without @constructor or @interface for {0}"));Nkb=new Mcb("JSC_EXTENDS_NON_OBJECT",
D2,new Rtc("{0} @extends non-object type {1}"));Skb=new Mcb("JSC_RESOLVED_TAG_EMPTY",D2,new Rtc("Could not resolve type in {0} tag of {1}"));Pkb=new Mcb("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR",D2,new Rtc("@implements used without @constructor or @interface for {0}"));Mkb=new Mcb("JSC_CONSTRUCTOR_REQUIRED",D2,new Rtc("{0} used without @constructor for {1}"));Zkb=new Mcb("JSC_VAR_ARGS_MUST_BE_LAST",D2,new Rtc("variable length argument must be last"));Rkb=new Mcb("JSC_OPTIONAL_ARG_AT_END",D2,new Rtc("optional arguments must be at the end"));
Qkb=new Mcb("JSC_INEXISTENT_PARAM",D2,new Rtc("parameter {0} does not appear in {1}''s parameter list"));Ykb=new Mcb("JSC_TYPE_REDEFINITION",D2,new Rtc("attempted re-definition of type {0}\nfound   : {1}\nexpected: {2}"));Ukb=new Mcb("JSC_TEMPLATE_TRANSFORMATION_ON_CLASS",D2,new Rtc("Template type transformation {0} not allowed on classes or interfaces"));Vkb=new Mcb("JSC_TEMPLATE_TYPE_DUPLICATED",D2,new Rtc("Only one parameter type must be the template type"));Wkb=new Mcb("JSC_TEMPLATE_TYPE_EXPECTED",
D2,new Rtc("The template type must be a parameter type"));Xkb=new Mcb("JSC_THIS_TYPE_NON_OBJECT",D2,new Rtc("@this type of a function must be an object\nActual type: {0}"));Tkb=new Mcb("JSC_SAME_INTERFACE_MULTIPLE_IMPLEMENTS",D2,new Rtc("Cannot @implement the same interface more than once\nRepeated interface: {0}"));Lkb=new bcb(CE(xE(bM,1),mLc,5,0,[Okb,Nkb,Skb,Pkb,Mkb,Zkb,Rkb,Qkb,Ykb,Ukb,Vkb,Wkb,Xkb,Tkb]))}function OSb(){OSb=JZ;var a,b,c,d,e,f;RRb=new PSb("BREAK",0,"break",(AZb(),DXb));SRb=new PSb("CASE",
1,"case",GXb);TRb=new PSb(FSc,2,"catch",HXb);WRb=new PSb(GSc,3,UNc,QXb);XRb=new PSb(HSc,4,WNc,RXb);ZRb=new PSb(gRc,5,JNc,TXb);$Rb=new PSb("DELETE",6,ISc,UXb);_Rb=new PSb("DO",7,"do",VXb);aSb=new PSb("ELSE",8,"else",WXb);fSb=new PSb(JSc,9,DNc,eYb);gSb=new PSb("FOR",10,"for",fYb);hSb=new PSb(jQc,11,ZKc,gYb);iSb=new PSb("IF",12,"if",jYb);lSb=new PSb("IN",13,"in",mYb);mSb=new PSb(uSc,14,zQc,nYb);tSb=new PSb("NEW",15,"new",yYb);zSb=new PSb(DRc,16,ENc,WYb);CSb=new PSb(KSc,17,"switch",iZb);DSb=new PSb(EMc,
18,FMc,mZb);ESb=new PSb("THROW",19,"throw",nZb);GSb=new PSb("TRY",20,"try",qZb);ISb=new PSb(LSc,21,yQc,sZb);JSb=new PSb("VAR",22,"var",vZb);KSb=new PSb("VOID",23,XNc,wZb);LSb=new PSb("WHILE",24,PNc,xZb);MSb=new PSb("WITH",25,"with",yZb);URb=new PSb(iQc,26,MNc,IXb);VRb=new PSb("CONST",27,XOc,PXb);bSb=new PSb(uRc,28,ZNc,YXb);cSb=new PSb(wRc,29,INc,bYb);dSb=new PSb(vRc,30,NNc,cYb);kSb=new PSb(MSc,31,LNc,lYb);BSb=new PSb(CMc,32,DMc,hZb);jSb=new PSb(xRc,33,ONc,kYb);nSb=new PSb(yRc,34,YNc,oYb);qSb=new PSb("LET",
35,"let",sYb);vSb=new PSb(zRc,36,FRc,JYb);wSb=new PSb(ARc,37,GRc,RYb);xSb=new PSb(BRc,38,HRc,SYb);ySb=new PSb(CRc,39,IRc,TYb);ASb=new PSb("STATIC",40,KRc,fZb);NSb=new PSb("YIELD",41,RNc,zZb);uSb=new PSb(NSc,42,jLc,CYb);FSb=new PSb(OSc,43,TNc,pZb);eSb=new PSb(PSc,44,SNc,dYb);YRb=new PSb(QSc,45,"declare",SXb);HSb=new PSb(ERc,46,$Nc,rZb);rSb=new PSb("MODULE",47,mNc,wYb);sSb=new PSb(RSc,48,"namespace",xYb);a=(oo(),new hs);b=new kCc(XR);for(d=XSb(),e=0,f=d.length;e<f;++e){c=d[e];es(a,c.c,c);gCc(b,c.b,
c)}oSb=Co(a.b);pSb=yx(b)}function inb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T;H=Hn(Tt(Wt(new eyc(a.a),new lnb)));Q=new VEb(H);h=Zmb(a,b,Tt(Wt(new eyc(a.a),new lnb)),Q);r=new fDc;for(n=H.Vd();n.Id();){l=n.Jd();for(K=J8(l.c?l.c.f:(Bn(),Bn(),An),l.e).Vd();K.Id();){J=K.Jd();J==null?FDc(r.d,null,l):ZDc(r.e,J,l)}A=UFb(z8(l).a);d=YDc(r.e,A);d!=null?d:ZDc(r.e,A,l)}for(o=H.Vd();o.Id();){l=o.Jd();for(N=In(l.d).Vd();N.Id();){M=N.Jd();(M==null?!!EDc(r.d,null):
XDc(r.e,M))&&jDc(h,M==null?Hg(EDc(r.d,null)):YDc(r.e,M))}}c=REb(Q,H,b.b!=(Sbb(),Obb));i=new Pv;for(p=(I=(new Wuc(h.a)).a.He().Vd(),new avc(I));p.a.Id();){l=(e=p.a.Jd(),e.Ve());t=l.k;Sd(t);Lv(i,t,l,null)}for(v=new Guc(new eyc(a.a));v.b<v.d.Yd();){t=(v.b<v.d.Yd(),v.d.ce(v.c=v.b++));Rmb(t)}G=new fxc;L=new mDc;for(w=(P=i.g,!P?i.g=new jw(i):P).Vd();w.Id();){t=w.Jd();if(b.b!=Obb&&(b.b==Qbb||b.b==Pbb)){R=new fxc;s=new oDc(H);for(g=fw(new gw(i,t),0);g.c;){f=zw(g);R.Qd(anb(a,f,s,r))}for(F=R.Vd();F.Id();){D=
F.Jd();B=L.a.Je(D,L);B==null&&G.Pd(D)}}else R=REb(Q,new gw(i,t),b.b!=Obb);for(q=R.Vd();q.Id();){l=q.Jd();if((b.b==Qbb||b.b==Pbb)&&l.a.sh().c==(scc(),rcc))throw gZ(new Irc("A file that is reachable via an entry point cannot be marked as weak."));C=l.k;if(!C){Kd(!t||!l.k||l.k==t);l.k=t}else{Kd(true);l.k=null;E8(l,_mb(a,C,t))}}}(!(b.b!=Obb&&(b.b==Qbb||b.b==Pbb))||!i.a)&&(G=c);T=cnb(a);Sd(T);if(b.b==Qbb||b.b==Pbb){S=QEb(Q,G);for(k=S.Vd();k.Id();){j=k.Jd();Xd(!j.k);Twb(j.a.sh(),(scc(),rcc));Kd(!T||!j.k||
j.k==T);j.k=T;Ywc(T.d,j);Kd(!T||!j.k||j.k==T);j.k=T}}else knb(T,H);for(m=G.Vd();m.Id();){l=m.Jd();t=l.k;!!t&&_wc(t.d,l,0)==-1&&(Ywc(t.d,l),Kd(!t||!l.k||l.k==t),l.k=t)}O=(Bn(),new Zr);for(u=new Guc(new eyc(a.a));u.b<u.d.Yd();){t=(u.b<u.d.Yd(),u.d.ce(u.c=u.b++));Yr(O,t.d)}return In(O.a)}function l7(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u;b=a.G.$!=(C9(),z9);A8b(a.o);A8b(a.v);u=(a.G.pd!=(Xab(),Uab)&&!!a.O&&wsb(a.O,jOc,true),new hyb);try{for(f=new wxc(a.k);f.a<f.c.a.length;){d=(f.b=f.a++,f.c.a[f.b]);
n=Sd(x8(d,a));if(a.g.a.d!=0)return null;q8b(a.o,n)}if(lQb(wab(a.G.Sb),(IRb(),iRb))){m=null;switch(a.G.$b.f){case 0:m=(nEb(),mEb);break;case 2:m=new fGb(q7(a,Tt(Wt(new eyc(a.B.a),new lnb))));break;case 3:m=new pGb;break;case 1:m=new zEb(a.G.o)}a.C=new bFb(a.G._b,Tt(Wt(new eyc(a.B.a),new lnb)),m,(EFb(),DFb),a.G.oc)}else a.C=(ZEb(),WEb);if(a.G.Z.b!=(Sbb(),Obb))E6(a,lQb(wab(a.G.Sb),iRb));else if(m9(a.G,(iQb(),_Pb))){lQb(wab(a.G.Sb),iRb)&&m7(a,Tt(Wt(new eyc(a.B.a),new lnb)));j=new fDc;for(g=new Tu(wu($t(Tt(Wt(new eyc(a.B.a),
new lnb)).a),new Xt));Ru(g);){d=Su(g);if(J8(d.c?d.c.f:(Bn(),Bn(),An),d.e).Ud()){l=$Eb(a.C,d.a.sh().b);_tc(j,UFb(l.a),d)}}k=new fDc;for(h=new Tu(wu($t(Tt(Wt(new eyc(a.B.a),new lnb)).a),new Xt));Ru(h);){d=Su(h);for(q=(wDb(),DJc(FJc(XA(J8(d.c?d.c.g:(Bn(),Bn(),An),d.f)),new FEb),(Bn(),Nk(),Nk(),Mk))).Vd();q.Id();){p=q.Jd();(p==null?!!EDc(j.d,null):XDc(j.e,p))&&!(p==null?!!EDc(k.d,null):XDc(k.e,p))&&_tc(k,p,p==null?Hg(EDc(j.d,null)):YDc(j.e,p))}}for(i=(o=(new fvc(k)).a.He().Vd(),new kvc(o));i.a.Id();){d=
(c=i.a.Jd(),c.We());D8(d,(b9(),$8))}}!!a.C&&_Eb(a.C,a);j7(a);if(a.g.a.d!=0)return null;a.G.cc>1&&Tt(Wt(new eyc(a.B.a),new lnb));for(e=new Tu(wu($t(Tt(Wt(new eyc(a.B.a),new lnb)).a),new Xt));Ru(e);){d=Su(e);n=Sd(x8(d,a));if(b){tCb(new uCb(a),a.o,a.v);if(a.g.a.d!=0)return null}if(a.G.kb||!a.G.Sc.a.a.Ud()){s=new dxb(d.i.a,a.G.$!=z9);t=new dpb(a,s,new Ajb(a));Yob(t,n)}if(oqb(n)){C8(d);q8b(a.o,n)}else q8b(a.v,n)}if(a.g.a.d!=0)return null;return a.i}finally{x6(a);r=vZ(mZ(Date.now()),u.a);a.G.pd!=Uab&&!!a.O&&
xsb(a.O,jOc,r)}}function Hbc(){Hbc=JZ;mbc=new Ibc("JSDOC_INFO",0);Ebc=new Ibc("VAR_ARGS",1);abc=new Ibc("INCRDECR",2);ubc=new Ibc("QUOTED",3);qbc=new Ibc("OPT_ARG",4);Abc=new Ibc("SYNTHETIC",5);Eac=new Ibc("ADDED_BLOCK",6);sbc=new Ibc("ORIGINALNAME",7);wbc=new Ibc("SIDE_EFFECT_FLAGS",8);dbc=new Ibc("IS_CONSTANT_NAME",9);jbc=new Ibc("IS_NAMESPACE",10);Qac=new Ibc("DIRECTIVES",11);Rac=new Ibc("DIRECT_EVAL",12);Wac=new Ibc("FREE_CALL",13);ybc=new Ibc("SOURCE_FILE",14);cbc=new Ibc("INPUT_ID",15);xbc=
new Ibc("SLASH_V",16);bbc=new Ibc("INFERRED",17);Hac=new Ibc("CHANGE_TIME",18);vbc=new Ibc("REFLECTED_OBJECT",19);zbc=new Ibc("STATIC_MEMBER",20);Xac=new Ibc("GENERATOR_FN",21);Fac=new Ibc("ARROW_FN",22);Gac=new Ibc("ASYNC_FN",23);Gbc=new Ibc("YIELD_ALL",24);Uac=new Ibc("EXPORT_DEFAULT",25);Tac=new Ibc("EXPORT_ALL_FROM",26);ebc=new Ibc("IS_CONSTANT_VAR",27);gbc=new Ibc("IS_GENERATOR_MARKER",28);hbc=new Ibc("IS_GENERATOR_SAFE",29);Jac=new Ibc("COMPUTED_PROP_METHOD",30);Iac=new Ibc("COMPUTED_PROP_GETTER",
31);Kac=new Ibc("COMPUTED_PROP_SETTER",32);Lac=new Ibc("COMPUTED_PROP_VARIABLE",33);Nac=new Ibc("DECLARED_TYPE_EXPR",34);Dbc=new Ibc("TYPE_BEFORE_CAST",35);rbc=new Ibc("OPT_ES6_TYPED",36);Yac=new Ibc(wTc,37);_ac=new Ibc(xRc,38);Mac=new Ibc("CONSTRUCT_SIGNATURE",39);Dac=new Ibc("ACCESS_MODIFIER",40);pbc=new Ibc("NON_INDEXABLE",41);tbc=new Ibc("PARSE_RESULTS",42);Zac=new Ibc("GOOG_MODULE",43);$ac=new Ibc("GOOG_MODULE_REQUIRE",44);Vac=new Ibc("FEATURE_SET",45);ibc=new Ibc("IS_MODULE_NAME",46);Fbc=new Ibc("WAS_PREVIOUSLY_PROVIDED",
47);fbc=new Ibc("IS_ES6_CLASS",48);Bbc=new Ibc("TRANSPILED",49);Pac=new Ibc("DELETED",50);nbc=new Ibc("MODULE_ALIAS",51);lbc=new Ibc("IS_UNUSED_PARAMETER",52);obc=new Ibc(DOc,53);kbc=new Ibc("IS_SHORTHAND_PROPERTY",54);Sac=new Ibc("ES6_MODULE",55);Cbc=new Ibc("TYPEDEF_TYPE",56);Oac=new Ibc("DEFINE_NAME",57)}function E_(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o;switch(b.n.f){case 122:F_(a,(IRb(),kRb),b);d=C8b(b);0!=d&&D0(OMc+d,b);return;case 99:F_(a,(IRb(),BRb),b);e=C8b(b);0!=e&&D0(OMc+e,b);return;case 34:case 32:case 33:case 35:f=
C8b(b);0!=f&&D0(OMc+f,b);return;case 24:case 21:case 22:case 19:case 25:case 79:case 20:case 92:g=C8b(b);1!=g&&D0(UMc+g,b);E_(a,b.c);return;case 63:case 64:c=C8b(b);1!=c&&D0(UMc+c,b);N_(a,b.c);return;case 47:h=Cfc(b.n);h!=-1&&(i=C8b(b),h!=i&&D0(QMc+h+RMc+i,b));R_(a,b.n,b.c);E_(a,b.c?b.c.i:null);return;case 59:F_(a,(IRb(),WQb),b);v_(a,b);return;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:v_(a,b);return;case 60:j=C8b(b);3!=j&&D0("Expected 3 children, but was "+
j,b);k=b.c;E_(a,k);E_(a,k.f);E_(a,b.c?b.c.i:null);return;case 31:s0(b);return;case 30:d0(b);return;case 29:W_(b);return;case 18:F_(a,(IRb(),WQb),b);m_(a,b);return;case 27:case 46:case 61:case 62:case 1:case 2:case 3:case 4:case 5:case 36:case 37:case 6:case 8:case 7:case 9:case 41:case 40:case 10:case 11:case 12:case 14:case 13:case 15:case 17:case 16:m_(a,b);return;case 26:I_(a,b);return;case 42:k_(a,b);return;case 43:e0(a,b);return;case 38:l0(b);return;case 28:o_(a,b);return;case 115:p0(a,b);return;
case 23:a0(a,b);return;case 65:G_(a,b,false);return;case 96:r_(a,b,false);return;case 118:v0(a,b);return;case 117:F_(a,(IRb(),CRb),b);b0((Afc(),hfc),b);l=Cfc(b.n);l!=-1&&(m=C8b(b),l!=m&&D0(QMc+l+RMc+m,b));E_(a,b.c);v0(a,b.c?b.c.i:null);return;case 103:F_(a,(IRb(),$Qb),b);b0((Afc(),zfc),b);n=C8b(b);(n<0||n>1)&&D0("Expected child count in [0, 1], but was "+n,b);!!b.c&&E_(a,b.c);return;case 104:F_(a,(IRb(),HQb),b);b0((Afc(),Pcc),b);o=(ppb(),Gpb(b,new frb(Jdc)));(!o||!(o.n==Jdc&&E8b(o,(Hbc(),Gac))!=0))&&
D0("'await' expression is not within an async function",b);return;default:D0("Expected expression but was "+b.n,b)}}function d2(){d2=JZ;Y1=new Mcb("JSC_DEPRECATED_VAR",(E2(),C2),new Rtc("Variable {0} has been deprecated."));Z1=new Mcb("JSC_DEPRECATED_VAR_REASON",C2,new Rtc("Variable {0} has been deprecated: {1}"));$1=new Mcb("JSC_DEPRECATED_PROP",C2,new Rtc("Property {0} of type {1} has been deprecated."));_1=new Mcb("JSC_DEPRECATED_PROP_REASON",C2,new Rtc("Property {0} of type {1} has been deprecated: {2}"));
W1=new Mcb("JSC_DEPRECATED_CLASS",C2,new Rtc("Class {0} has been deprecated."));X1=new Mcb("JSC_DEPRECATED_CLASS_REASON",C2,new Rtc("Class {0} has been deprecated: {1}"));P1=new Mcb("JSC_BAD_PACKAGE_PROPERTY_ACCESS",B2,new Rtc("Access to package-private property {0} of {1} not allowed here."));Q1=new Mcb("JSC_BAD_PRIVATE_GLOBAL_ACCESS",B2,new Rtc("Access to private variable {0} not allowed outside file {1}."));R1=new Mcb("JSC_BAD_PRIVATE_PROPERTY_ACCESS",D2,new Rtc("Access to private property {0} of {1} not allowed here."));
S1=new Mcb("JSC_BAD_PROTECTED_PROPERTY_ACCESS",D2,new Rtc("Access to protected property {0} of {1} not allowed here."));new Mcb("JSC_BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY",B2,new Rtc("Overridden property {0} in file with fileoverview visibility {1} must explicitly redeclare superclass visibility"));b2=new Mcb("JSC_PRIVATE_OVERRIDE",D2,new Rtc("Overriding private property of {0}."));a2=new Mcb("JSC_EXTEND_FINAL_CLASS",B2,new Rtc("{0} is not allowed to extend final class {1}."));
c2=new Mcb("JSC_VISIBILITY_MISMATCH",D2,new Rtc("Overriding {0} property of {1} with {2} property."));U1=new Mcb("JSC_CONSTANT_PROPERTY_REASSIGNED_VALUE",D2,new Rtc("constant property {0} assigned a value more than once"));T1=new Mcb("JSC_CONSTANT_PROPERTY_DELETED",D2,new Rtc("constant property {0} cannot be deleted"));V1=new Mcb("JSC_CONVENTION_MISMATCH",D2,new Rtc("Declared access conflicts with access convention."))}function Igb(a,b,c,d,e,f){var g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,
I,J,K,L,M,N,O,P;Kob(b);N=LPc+a.b++;G=null;C=null;if(!!c.c&&(c.c?c.c.i:null).n==(Afc(),Sec)){C=new fxc;G=LPc+a.b++}else if(a.f==(Wgb(),Vgb))if(!uwc(a.e).a){--a.b;return}M=I9b(q3b((I=(ae(Hsc(N,_sc(46))==-1,HMc,N),n8b(),new Wbc((Afc(),rec),N)),I),z8b(d),ufc),c);if(e.n==gdc){s=new C7b(false);w6b(s);q9b(M,k6b(s))}p8b(f.g,M,f);for(h=c.c;h;h=w){w=h.f;if(h.n==cfc){O=(J=(ae(Hsc(N,_sc(46))==-1,HMc,N),new Wbc(rec,N)),J);o=h.Yh()?(H=w3b(O,e_(h.Wh())),H):O$(O,h.Wh());P=g9b(h);if(P.n==mdc){t=g9b(P);j=g9b(P);v=
Cgb(o,j)}else{t=P;v=o}if(C){B=e_(h.Wh());h.Yh()&&c9b(B,(Hbc(),ubc),1);C.a[C.a.length]=B}}else if(h.n==fdc){p=(h.c?h.c.i:null).n==mdc;A=g9b(h);if(p){i=h.c?h.c.i:null;t=g9b(i);j=g9b(i)}else{t=g9b(h);j=null}if(C){m=LPc+a.b++;l=(H=(ae(Hsc(m,_sc(46))==-1,HMc,m),new Wbc(rec,m)),H);k=q3b(Tbc(l,false),A,ufc);I9b(k,h);p8b(f.g,k,f);A=Tbc(l,false);Ywc(C,Tbc(l,false))}if(p){n=(J=w3b((K=(ae(Hsc(N,_sc(46))==-1,HMc,N),new Wbc(rec,N)),K),A),J);r=LPc+a.b++;q=q3b((L=(ae(Hsc(r,_sc(46))==-1,HMc,r),new Wbc(rec,r)),L),
n,ufc);I9b(q,h);p8b(f.g,q,f);v=Cgb((H=(ae(Hsc(r,_sc(46))==-1,HMc,r),new Wbc(rec,r)),H),j)}else v=(J=w3b((H=(ae(Hsc(N,_sc(46))==-1,HMc,N),new Wbc(rec,N)),H),A),J)}else if(h.n==Sec){if(w)throw gZ(new Irc("object rest may not be followed by any properties"));g=(J=Tqb(a_(Se(Ze(),MMc)),CE(xE(HU,1),IMc,7,0,[])),J);q8b(g,(K=P3b(CE(xE(HU,1),IMc,7,0,[])),K));q8b(g,(L=(ae(Hsc(N,_sc(46))==-1,HMc,N),new Wbc(rec,N)),L));F=q3b((H=(ae(Hsc(G,_sc(46))==-1,HMc,G),new Wbc(rec,G)),H),g,ufc);I9b(F,c);o8b(f.g,F,M);D=(Xd(!!h.c&&
!h.c.f),h.c);t=X$(D.Wh());v=Fgb(c,h,G,C)}else throw gZ(new Irc("unexpected child"));ppb();if(!!e&&(e.n==ufc||e.n==jec||e.n==gdc))u=q3b(t,v,e.n);else if(e.n==Ccc)u=t3b((H=h3b(t,v),H));else throw gZ(new Irc("not reached"));I9b(u,h);p8b(f.g,u,f);Lgb(a,b,t,t.g)}z8b(f);Vob(b)}function K3(){K3=JZ;new Mcb("JSC_GOOG_MODULE_INVALID_MODULE_NAMESPACE",(E2(),B2),new Rtc("goog.module parameter must be string literals"));new Mcb("JSC_GOOG_MODULE_INVALID_PROVIDE_NAMESPACE",B2,new Rtc("goog.provide parameter must be a string literal."));
new Mcb("JSC_GOOG_MODULE_INVALID_PROVIDE_CALL",B2,new Rtc("goog.provide can not be called in goog.module."));new Mcb("JSC_GOOG_MODULE_INVALID_GET_ALIAS",B2,new Rtc("goog.module.get should not be aliased."));new Mcb("JSC_GOOG_MODULE_INVALID_EXPORT_COMPUTED_PROPERTY",B2,new Rtc("Computed properties are not yet supported in goog.module exports."));J3=new Mcb("JSC_USELESS_USE_STRICT_DIRECTIVE",C2,new Rtc("'use strict' is unnecessary in goog.module files."));new Mcb("JSC_DUPLICATE_MODULE",B2,new Rtc("Duplicate module: {0}"));
new Mcb("JSC_DUPLICATE_NAMESPACE",B2,new Rtc("Duplicate namespace: {0}"));new Mcb(hNc,B2,new Rtc(iNc));new Mcb("JSC_IMPORT_INLINING_SHADOWS_VAR",B2,new Rtc('Inlining of reference to import "{1}" shadows var "{0}".'));new Mcb("JSC_ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT",B2,new Rtc("Destructuring import only allowed for importing module with named exports.\nSee https://github.com/google/closure-compiler/wiki/goog.module-style"));new Mcb("JSC_ILLEGAL_DESTRUCTURING_NOT_EXPORTED",B2,new Rtc('Destructuring import reference to name "{0}" was not exported in module {1}'));
bn();new Zz(ANc);x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),n8b(),new Wbc((Afc(),rec),kNc)),new Wbc(bfc,oNc));x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,BNc));I3=x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,mNc));x3b(I3,new Wbc(bfc,"declareLegacyNamespace"));x3b(x8b(I3,false),new Wbc(bfc,nNc));x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,CNc));x3b((ae(Hsc(kNc,_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,lNc));x3b((ae(Hsc(kNc,
_sc(46))==-1,HMc,kNc),new Wbc(rec,kNc)),new Wbc(bfc,pNc))}function Cdb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L;d=c.a;A=c.b;if(A.a.length==0)return;h=H8b(d,(Hbc(),ybc));if(!!h&&h.Kh())for(v=new wxc(A);v.a<v.c.a.length;){u=(v.b=v.a++,v.c.a[v.b]);g=(ppb(),Gpb(u,new jrb));f=g.g;z8b(g);w7(a.a,f)}else{B=xdb(d);C=I8b(B);ydb(c.a);if(Esc(C,NMc)&&(n=i$(Kob(b),C),!(!!n&&!(!n.a||B8(n.a)))))for(v=new wxc(A);v.a<v.c.a.length;){u=(v.b=v.a++,v.c.a[v.b]);D=F9b((p=new J9b((Afc(),lfc)),
p),u);j9b(u.g,u,D);w7(a.a,D)}else if(Bdb(b,C))u7(a.a,Lmb(d,(Rjb(),Pjb),CE(xE(nW,1),uNc,2,6,["extending native class: "+C])));else if(Adb(b,C))for(v=new wxc(A);v.a<v.c.a.length;){u=(v.b=v.a++,v.c.a[v.b]);m=tdb(B,u);F=(ppb(),Gpb(u,new jrb));G=F.g;Yd(G.n==(Afc(),Vcc),G);H=I9b(r3b((ae(Hsc(sPc,_sc(46))==-1,HMc,sPc),n8b(),new Wbc(rec,sPc)),ufc),u);p8b(G,H,F);I=h3b((ae(Hsc(sPc,_sc(46))==-1,HMc,sPc),new Wbc(rec,sPc)),m);J=h3b(O$(new J9b(lfc),tPc),O$((ae(Hsc(sPc,_sc(46))==-1,HMc,sPc),new Wbc(rec,sPc)),tPc));
K=J$(Q$(new Wbc(bfc,fMc),(ae(Hsc(sPc,_sc(46))==-1,HMc,sPc),new Wbc(rec,sPc))),h3b(O$(new J9b(lfc),fMc),O$((ae(Hsc(sPc,_sc(46))==-1,HMc,sPc),new Wbc(rec,sPc)),fMc)));L=I9b(M$(I,J,CE(xE(HU,1),IMc,7,0,[K,new J9b(lfc)])),u);j9b(u.g,u,L);w7(a.a,L)}else if(zdb(a,C))for(v=new wxc(A);v.a<v.c.a.length;){u=(v.b=v.a++,v.c.a[v.b]);m=tdb(B,u);w=u.g;!!w.c&&!w.c.f&&(ppb(),w.n!=(Afc(),pec)&&Jqb(w.g))?j9b(w,u,m):j9b(w,u,I9b(L$(m,(p=new J9b((Afc(),lfc)),p)),u));w7(a.a,w)}else{e=Sd(B8b(d,2));i=e.c;j=A.a[0];if(!!e.c&&
!e.c.f&&i.n==(Afc(),Ddc)&&!!i.c&&!i.c.f&&i.c==j){Yd(A.a.length==1,d);l=_$(tdb(B,(k=A.a[0],A.a[0],k)),(p=new J9b((Afc(),lfc)),p));j9b(e,i,I9b((Xd(H3b(l)),new L9b(Uec,l)),i))}else{ydb(d);o=new Hdb(A);epb(a.a,e,o);r8b(e,G9b(r3b((q=(ae(Hsc(uPc,_sc(46))==-1,HMc,uPc),n8b(),new Wbc((Afc(),rec),uPc)),q),ufc),e));q8b(e,G9b(S3b((r=(ae(Hsc(uPc,_sc(46))==-1,HMc,uPc),new Wbc(rec,uPc)),r)),e));for(v=new wxc(A);v.a<v.c.a.length;){u=(v.b=v.a++,v.c.a[v.b]);m=tdb(B,u);k9b(u,I9b((s=h3b((t=(ae(Hsc(uPc,_sc(46))==-1,HMc,
uPc),new Wbc(rec,uPc)),t),_$(m,(p=new J9b(lfc),p))),s),u))}}w7(a.a,e)}}}function dgb(a,b,c,d){var e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A;_fb(a,c);t=J0(c,d);if(!t)throw gZ(new Irc("Can only convert classes that are declarations or the right hand side of a simple assignment: "+c));if(t.k.n!=(Afc(),tdc)&&!V8b(t.k)){u7(a.a,Lmb(t.k,Wfb,CE(xE(nW,1),uNc,2,6,[])));return}ae(Iqb(t.i.a),"insertion point must be a statement: %s",t.i.a);h=null;i=null;f=c.c?c.c.i:null;for(s=(!f.c?(Cyc(),Cyc(),Byc):new Kbc(f.c)).Vd();s.Id();){r=
s.Jd();if(r.n==fdc&&(E8b(r,(n8b(),M7b))!=0||E8b(r,O7b)!=0)||r.n==Qdc||r.n==Yec)fgb(a,r,t);else if(nqb(r)){i=H8b(r,(Hbc(),mbc));h=r9b(z8b(r.c),c.d);s9b(h,H8b(c,Dbc));t.a||j9b(h,h.c,t.c.Sh(false))}else if(r.n==tdc);else{ae(r.n==mec||r.n==fdc,"Unexpected class member:",r);ae(E8b(r,(n8b(),P7b))==0,"Member variables should have been transpiled earlier:",r);egb(r,t)}}Td(h,"Es6RewriteClasses expects all classes to have (possibly synthetic) constructors");if(t.f.c){C6(a.a,CPc,false);k=t3b((v=Tqb((Kob(b),
a_(Se(Ze(),KPc))),CE(xE(HU,1),IMc,7,0,[x8b(t.d,false),t.f])),v));I9b(k,c);sgb(t.i,k)}if(t.e.c){C6(a.a,CPc,false);k=t3b((v=Tqb((Kob(b),a_(Se(Ze(),KPc))),CE(xE(HU,1),IMc,7,0,[x8b(t.g,false),t.e])),v));I9b(k,c);sgb(t.i,k)}e=(ppb(),q=Dpb(c),!q?null:H8b(q,(Hbc(),mbc)));u=E7b(e);x6b(u);l=Gpb(c,new jrb);if(t.k.n!=tdc){w=I8b(t.k);W4b(u.a)?I6b(u,new H7b(new L9b(Qcc,(n8b(),new Wbc(bfc,w))),(n=H8b(t.k,(Hbc(),ybc)),!n?null:n.ug()))):s6b(u,new H7b(new L9b(Qcc,(n8b(),new Wbc(bfc,w))),(o=H8b(t.k,(Hbc(),ybc)),!o?
null:o.ug())));m=H8b(c,(Hbc(),ybc));if(!(!!m&&m.Kh())){C6(a.a,"es6/util/inherits",false);p=I9b(t3b((v=Tqb(b_((Kob(b),bOc)),CE(xE(HU,1),IMc,7,0,[x8b(t.g,false),x8b(t.k,false)])),v)),t.k);o8b(l.g,p,l)}}$fb((Kob(b),t),l);cgb(i,u);if(c.n!=pec&&Jqb(c.g)){h.c._h("");j=q3b(t.c.Sh(false),h,jec);I9b(j,c);j9b(d,c,j);qpb(b.f,(IRb(),fRb))}else j9b(d,c,h);Qqb(c,a.a);if(h.n!=pec&&Jqb(h.g))q9b(h,k6b(u));else if(d.n==rec){A=d.g;q9b(A,k6b(u))}else if(h.g.n==rec){A=!h.g?null:h.g.g;q9b(A,k6b(u))}else if(d.n==Ccc)q9b(d,
k6b(u));else throw gZ(new Irc("Unexpected parent node "+d));g=Qgc(c.d);!!g&&(!!g.g&&(!h||!g.g.d)&&(g.g=new Xmc(g.g.c,g.g.e,g.g.b,h)),g.i=h);b9b(h,(n8b(),c8b),true);Vob(b)}function v9(){g9();this.cb=(Gb(),Gb(),Fb);this.hc=(null,Fb);this.Tb=(null,Fb);this.zb=($9(),Y9);this.nc=(mJb(),lJb);this.Z=new F0((Sbb(),Obb),(Bn(),Bn(),An));this._b=new Wz(Sd(rOc));this.sb=(null,An);this.pb=(null,An);this.B=(null,An);this.wd=new pbb(CE(xE(tQ,1),mLc,167,0,[]));new fxc;this.cd=(ixb(),gxb);this.dd=(sxb(),qxb);this.ed=
(null,An);this.M=e9;this.N=YIc(".*?google3/");this.Pb=(null,Fb);this.hb=(O9(),K9);this.Sb=(uab(),mab);this.eb=(H9(),F9);this.o=(oo(),oo(),no);this.$b=(NFb(),JFb);this.kc=new hz(Qn(CE(xE(iW,1),mLc,1,5,["browser",mNc,"main"])));this.oc=(wFb(),vFb);this.ad=false;this.$=(C9(),z9);this.p=false;this.v=false;this.u=false;this.w=false;this.q=(E2(),C2);this.n=B2;this.r=C2;this.t=C2;this.s=null;this.L=false;this.mb=null;this.rb=false;this.D=false;this.W=false;this.Cb=false;this.Db=(Pab(),Oab);this.Zb=-1;this.k=
false;this.j=false;this.Gb=false;this.P=false;this.lc=false;this.R=false;this.Eb=false;this.Hb=false;this.Fb=false;this.bd=false;this.nb=false;this.Gc=false;this.ob=(U9(),R9);this.Lc=false;this.Mc=false;this.Ic=false;this.Jc=false;this.Nc=false;this.Kc=false;this.J=false;this.G=false;this.e=(mz(),lz);this.d="";this.b=false;this.jc=false;this.O=false;this.Yc=false;this.vd=(eDb(),dDb);this.Bc=(lub(),kub);this.Rb=false;this.wb=false;this._c=false;this.tc=false;this.Oc=null;this.I=(Jab(),Iab);this.H=
false;this._=false;this.bb=false;this.f=false;this.i=(G$(),E$);this.jb=false;this.X=true;this.bc=new Jbb;this.Zc=false;this.$c=null;this.nd=null;this.md=null;this.Wb=null;this.Xb=false;this.C=false;this.uc=false;this.g=false;this.qc=null;this.pc=(itb(),htb);this.V=false;this.Qb=(dab(),bab);this.Ec=false;this.Fc=false;this.kd=(null,lz);this.hd=(null,lz);this.gd=(null,lz);this.jd=(null,lz);this.U=null;this.Yb=false;this.Y=new fDc;this.rd=(bbb(),_ab);this.sd=new fDc;this.ac=false;this.A=false;this.ic=
(Dab(),Bab);this.ub=false;this.vb=true;this.ib=false;this.S=null;this.T=null;this.xb=(null,no);this.Sc=(null,An);this.Uc="";this.Vc=(null,lz);this.Ac=new fDc;this.Lb=(null,no);this.Ob=false;this.Nb=false;this.vc=false;this.yc=false;this.wc=false;this.Ub=false;this.rc=false;this.pd=(Xab(),Uab);this.K=false;this.fb=(Wcb(),Ucb);this.kb=false;this.c=f9;this.gb=null;this.zc=false}function ntb(){ntb=JZ;ltb=new Mcb("JSC_POLYMER_DESCRIPTOR_NOT_VALID",(E2(),D2),new Rtc("The argument to Polymer() is not an obj lit or the Polymer 2 class does not have a static getter named 'config'. Ignoring this definition."));
new Mcb("JSC_POLYMER_INVALID_DECLARATION",B2,new Rtc("A Polymer() declaration cannot use ''const''."));new Mcb("JSC_POLYMER_INVALID_BEHAVIOR",B2,new Rtc("A Polymer behavior may not include an ''is'' property."));new Mcb("JSC_POLYMER_MISSING_IS",B2,new Rtc("The class descriptor must include an ''is'' property."));new Mcb("JSC_POLYMER_UNEXPECTED_PARAMS",B2,new Rtc("The class definition has too many arguments."));new Mcb("JSC_POLYMER_MISSING_EXTERNS",B2,new Rtc("Missing Polymer externs."));new Mcb("JSC_POLYMER_INVALID_PROPERTY",
B2,new Rtc("Polymer property has an invalid or missing type."));new Mcb("JSC_POLYMER_INVALID_EXTENDS",B2,new Rtc("Cannot extend HTML element ''{0}''. The element is probably either misspelled, or needs to be added to the list of known elements."));new Mcb("JSC_POLYMER_INVALID_BEHAVIOR_ARRAY",B2,new Rtc("The behaviors property must be an array literal."));mtb=new Mcb("JSC_POLYMER_UNQUALIFIED_BEHAVIOR",B2,new Rtc("Behaviors must be global names or qualified names that are declared as object literals or array literals of other valid Behaviors."));
new Mcb("JSC_POLYMER_UNANNOTATED_BEHAVIOR",B2,new Rtc("Behavior declarations must be annotated with @polymerBehavior."));new Mcb("JSC_POLYMER_CLASS_PROPERTIES_INVALID",B2,new Rtc("The Polymer element class 'properties' getter does not return an object literal. Ignoring this definition."));new Mcb("JSC_POLYMER_CLASS_PROPERTIES_NOT_STATIC",B2,new Rtc("The Polymer element class 'properties' getter is not declared static. Ignoring this definition."));new Mcb("JSC_POLYMER2_UNNAMED",D2,new Rtc("Unable to locate a valid name for the Polymer element class.Ignoring this definition."));
new Mcb("JSC_POLYMER_MISPLACED_PROPERTY_JSDOC",D2,new Rtc("When a Polymer property is declared in the constructor, its JSDoc should only be in the constructor, not on the Polymer properties configuration."));new Mcb("JSC_POLYMER_UNPARSABLE_STRING",B2,new Rtc("The Polymer computed property or complex observer string could not be parsed."))}function Hfb(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab;if(duc(a.c.c)==0)return;for(u=(M=(new Wuc(a.c)).a.He().Vd(),
new avc(M));u.a.Id();){t=(h=u.a.Jd(),h.Ve());v=pEc(a.c,t);G=ofb(a.f);for(Y=(N=(new Wuc(v.b.a)).a.He().Vd(),new avc(N));Y.a.Id();){W=(g=Y.a.Jd(),g.Ve());A=pEc(a.d,W);q8b(G,W3b(A,Gfb(a,v,W.c,A)))}V=mfb(a.f,Ffb(a,v),G);F=G9b(q3b(Ffb(a,v),ofb(a.f),(Afc(),ufc)),t);kfb(a.f,F,t);if(t.n==Fdc){p=t.c;j9b(t,p,new J9b(tdc));if(p.n!=tdc){ppb();!!p&&(p.n==ufc||p.n==jec||p.n==gdc)||(p=F9b((Yd(H3b(p),p),new L9b(Ddc,p)),p));kfb(a.f,p,t)}o=B8b(t,2);if(o.n==tdc)j9b(t,o,I9b(V,t));else{P=new J9b(tdc);j9b(t,o,P);j9b(t,
P,I9b(nfb(a.f,V,o),t))}}else{r=v.a;s=Opb(t);if(Z=t.g,$=Z.n==eec?Z.c.Wh():null,ab=new Lfb(r,$),epb(a.f.a,Opb(t),ab),ab.d){q=F9b((c=new J9b(Vcc),c),s);u8b(q,f9b(s));r8b(s,F9b(E3b(F9b((Xd(r.length!=0),n8b(),new Wbc(fec,r)),s),q),s))}q8b(s,I9b((Yd(H3b(V),V),new L9b(Ddc,V)),t))}w7(a.f.a,t);for(X=(L=(new Wuc(v.b.a)).a.He().Vd(),new avc(L));X.a.Id();){W=(g=X.a.Jd(),g.Ve());A=pEc(a.d,W);for(R=Uf(a.e,W).Vd();R.Id();){Q=R.Jd();Yd(t.n!=Idc,t);if(t.n==Hdc&&t.c==Q.g){Yd(Q==W.c,Q);S=Q.g;Yd((ppb(),!!S&&(S.n==ufc||
S.n==jec||S.n==gdc)),S);Yd(Q.n==rec,Q);w=Q.Sh(false);a.f.d&&r9b(w,pfb(a.f,45));r8b(t.c?t.c.i:null,I9b(t3b(mfb(a.f,Gfb(a,v,Q,A),w)),Q))}else{if(Cqb(Q.g)){f=Q.g;l=f.g;qfb(a.f,f,l);f=Q.g;if(Q.c){B=lfb(a.f,Q);b=mfb(a.f,B,g9b(Q));ufb(f,Q,f);vfb(f,l,Q,f);q9b(b,H8b(f,(Hbc(),mbc)));T=I9b((Yd(H3b(b),b),new L9b(Ddc,b)),f);j9b(l,f,T);Q=B}else e9b(l,f);lDc(a.f.b,f);w7(a.f.a,l)}Q.g.n==Ycc&&Q.g.c==Q&&b9b(Q.g,(n8b(),W7b),false);e=Fpb(Q);k9b(Q,Gfb(a,v,Q,A));!!e&&v7(a.f.a,e)}}}}for(j=gv(a.b).Vd();j.Id();){i=j.Jd();
U=new J9b((Afc(),Uec));K=Uf(a.b,i);H=zE(HU,IMc,7,K.Yd(),0,1);I=zE(HU,IMc,7,K.Yd(),0,1);m=0;J=zE(cV,xPc,23,K.Yd(),0,1);for(D=K.Vd();D.Id();){C=D.Jd();O=Ffb(a,C);H[m]=O;a.f.d&&(J[m]=Sd(O.d));I[m]=Ffb(a,C);++m}n=v3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc(rec,"")),R3b(H),j3b(U));if(a.f.d){k=new Lic(U6(a.f.a));Dic(Bic(Gic((k.c="",k),n),Vkc(U6(a.f.a),false,J)),i.d);r9b(n,uic(k))}v7(a.f.a,n);d=l3b(n,I);a.f.d&&r9b(d,i.d);b9b(d,W7b,true);ppb();i.n==Jdc&&iqb(i.g)&&i.n==Jdc&&Gqb(i.c)?T=I9b(q3b(K3b(i.c.Wh()),
d,ufc),i):T=I9b(d,i);j9b(i.g,i,T);r8b(U,i);w7(a.f.a,T)}}function lVb(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q;switch(DWb(a.g,0).e.f){case 45:return STb(a);case 30:case 25:return xVb(a);case 52:return cUb(a);case 15:return xUb(a);case 10:return c=DWb(a.g,0).d.b,iTb(a,(AZb(),VXb)),d=hVb(a),iTb(a,xZb),iTb(a,GYb),e=xTb(a,1),iTb(a,LXb),AVb(a,ZYb)&&iTb(a,ZYb),new u$b(new Z1b(c,a.f),d,e);case 27:return f=DWb(a.g,0).d.b,iTb(a,(AZb(),xZb)),iTb(a,GYb),g=xTb(a,1),iTb(a,
LXb),h=hVb(a),new P1b(new Z1b(f,a.f),g,h);case 13:return nUb(a);case 6:return i=DWb(a.g,0).d.b,iTb(a,(AZb(),QXb)),j=null,k=DWb(a.g,0).d.b.b>a.f.b,k||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb)||(j=(l=DWb(a.g,0).e,iYb==l||a.b.d&&VSb(l)||!a.b.c&&USb(l)?kTb(a):null)),nTb(a),new q$b(new Z1b(i,a.f),j);case 3:return m=DWb(a.g,0).d.b,iTb(a,(AZb(),DXb)),n=null,o=DWb(a.g,0).d.b.b>a.f.b,o||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb)||(n=(p=DWb(a.g,0).e,iYb==p||a.b.d&&VSb(p)||!a.b.c&&USb(p)?kTb(a):null)),nTb(a),new TZb(new Z1b(m,
a.f),n);case 19:return q=DWb(a.g,0).d.b,iTb(a,(AZb(),WYb)),r=null,s=DWb(a.g,0).d.b.b>a.f.b,s||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb)||(r=xTb(a,1)),nTb(a),new u1b(new Z1b(q,a.f),r);case 28:return t=DWb(a.g,0).d.b,iTb(a,(AZb(),yZb)),iTb(a,GYb),u=xTb(a,1),iTb(a,LXb),v=hVb(a),new Q1b(new Z1b(t,a.f),u,v);case 20:return w=DWb(a.g,0).d.b,iTb(a,(AZb(),iZb)),iTb(a,GYb),A=xTb(a,1),iTb(a,LXb),iTb(a,FYb),B=UTb(a),iTb(a,KXb),new y1b(new Z1b(w,a.f),A,B);case 22:return C=DWb(a.g,0).d.b,iTb(a,(AZb(),nZb)),D=null,
F=DWb(a.g,0).d.b.b>a.f.b,F||zVb(a,0,ZYb)||zVb(a,0,KXb)||zVb(a,0,XXb)?VVb(a,"semicolon/newline not allowed after 'throw'",CE(xE(iW,1),mLc,1,5,[])):D=xTb(a,1),nTb(a),new D1b(new Z1b(C,a.f),D);case 23:return G=DWb(a.g,0).d.b,iTb(a,(AZb(),qZb)),H=STb(a),I=null,AVb(a,HXb)&&(I=VTb(a)),J=null,AVb(a,eYb)&&(J=(P=DWb(a.g,0).d.b,iTb(a,eYb),Q=STb(a),new B$b(new Z1b(P,a.f),Q))),!I&&!J&&VVb(a,"'catch' or 'finally' expected.",CE(xE(iW,1),mLc,1,5,[])),new E1b(new Z1b(G,a.f),H,I,J);case 7:return K=DWb(a.g,0).d.b,
iTb(a,(AZb(),RXb)),nTb(a),new r$b(new Z1b(K,a.f));default:{b=DWb(a.g,0).e;if(((AZb(),iYb)==b||a.b.d&&VSb(b)||!a.b.c&&USb(b))&&zVb(a,1,NXb))return L=DWb(a.g,0).d.b,M=jTb(a),iTb(a,NXb),new i_b(new Z1b(L,a.f),M,hVb(a))}return N=DWb(a.g,0).d.b,O=xTb(a,1),nTb(a),new A$b(new Z1b(N,a.f),O)}}function q0(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M;switch(b.n.f){case 83:b0((Afc(),eec),b);i=Cfc(b.n);i!=-1&&(j=C8b(b),i!=j&&D0(QMc+i+RMc+j,b));S_(b.c);q0(a,b.c?b.c.i:null,false);return;
case 82:n_(a,b);return;case 65:c?G_(a,b,true):(b0((Afc(),Jdc),b),k=Cfc(b.n),k!=-1&&(l=C8b(b),k!=l&&D0(QMc+k+RMc+l,b)),W_(b.c),k0(a,b.c.f),n_(a,b.c?b.c.i:null),H_(a,b),b.g.n==Vcc&&(!b.g?null:b.g.g).n!=Jdc&&F_(a,(IRb(),KQb),b),undefined);return;case 77:b0((Afc(),yfc),b);m=Cfc(b.n);m!=-1&&(n=C8b(b),m!=n&&D0(QMc+m+RMc+n,b));E_(a,b.c);n_(a,b.c?b.c.i:null);return;case 72:b0((Afc(),Fdc),b);o=C8b(b);4!=o&&D0("Expected 4 children, but was "+o,b);A0(a,b.c);j0(a,b.c.f);j0(a,B8b(b,2));n_(a,b.c?b.c.i:null);return;
case 73:b0((Afc(),Hdc),b);p=Cfc(b.n);p!=-1&&(q=C8b(b),p!=q&&D0(QMc+p+RMc+q,b));z0(a,b.c);E_(a,b.c.f);n_(a,b.c?b.c.i:null);return;case 101:F_(a,(IRb(),ZQb),b);b0((Afc(),Idc),b);r=Cfc(b.n);r!=-1&&(s=C8b(b),r!=s&&D0(QMc+r+RMc+s,b));z0(a,b.c);E_(a,b.c.f);n_(a,b.c?b.c.i:null);return;case 102:F_(a,(IRb(),YQb),b);F_(a,HQb,b);b0((Afc(),Gdc),b);t=Cfc(b.n);t!=-1&&(u=C8b(b),t!=u&&D0(QMc+t+RMc+u,b));z0(a,b.c);E_(a,b.c.f);n_(a,b.c?b.c.i:null);return;case 70:b0((Afc(),xfc),b);v=Cfc(b.n);v!=-1&&(w=C8b(b),v!=w&&
D0(QMc+v+RMc+w,b));E_(a,b.c);n_(a,b.c?b.c.i:null);return;case 71:b0((Afc(),qdc),b);A=Cfc(b.n);A!=-1&&(B=C8b(b),A!=B&&D0(QMc+A+RMc+B,b));n_(a,b.c);E_(a,b.c?b.c.i:null);return;case 67:t0(a,b);return;case 66:b0((Afc(),Tdc),b);C=C8b(b);(C<2||C>3)&&D0(ZMc+C,b);E_(a,b.c);n_(a,b.c.f);C8b(b)==3&&n_(a,b.c?b.c.i:null);return;case 88:for(e=(!b.c?(Cyc(),Cyc(),Byc):new Kbc(b.c)).Vd();e.Id();){d=e.Jd();d.n==(Afc(),odc)?(g=C8b(d),2!=g&&D0(PMc+g,d)):(h=C8b(d),1!=h&&D0(UMc+h,d))}case 76:case 100:Y_(a,b.n,b);return;
case 84:b0((Afc(),Ddc),b);D=Cfc(b.n);D!=-1&&(F=C8b(b),D!=F&&D0(QMc+D+RMc+F,b));E_(a,b.c);return;case 0:b0((Afc(),Uec),b);T_(b);!!b.c&&E_(a,b.c);return;case 39:b0((Afc(),mfc),b);G=Cfc(b.n);G!=-1&&(H=C8b(b),G!=H&&D0(QMc+G+RMc+H,b));E_(a,b.c);return;case 44:x0(a,b);return;case 74:b0((Afc(),Xcc),b);T_(b);!!b.c&&S_(b.c);return;case 75:b0((Afc(),hdc),b);T_(b);!!b.c&&S_(b.c);return;case 80:case 89:f=C8b(b);0!=f&&D0(OMc+f,b);return;case 96:r_(a,b,c);W_(b.c);return;case 105:K_(a,b);return;case 109:B_(a,b,
c);return;case 151:F_(a,(IRb(),dRb),b);b0((Afc(),bec),b);I=Cfc(b.n);I!=-1&&(J=C8b(b),I!=J&&D0(QMc+I+RMc+J,b));K=b.c;W_(K);L=K.f;L.n==tdc?(M=C8b(L),0!=M&&D0(OMc+M,L)):O_(L);Q_(a,b.c?b.c.i:null);return;case 154:z_(b);return;case 157:y0(a,b);return;case 158:F_(a,(IRb(),DQb),b);b0((Afc(),kdc),b);j_(a,b.c);return;case 162:Z_(a,b,c);return;default:D0("Expected statement but was "+b.n+".",b)}}function Bmb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t;g=false;k=new fxc;k.a[k.a.length]="/**";(b.a&sQc)!=0?(k.a[k.a.length]=
"@externs",true):(b.a&16)!=0&&(k.a[k.a.length]="@typeSummary",true);(b.a&1024)!=0?(k.a[k.a.length]="@export",true):!!b.j&&b.j!=(e6b(),_5b)&&Ywc(k,"@"+ge(b.j).toLowerCase());(b.a&tQc)!=0&&(k.a[k.a.length]="@abstract",true);!!(!b.d?null:b.d.i)&&Ywc(k,zmb(a,"lends",(!b.d?null:b.d.i).a));(b.a&1)!=0&&(b.a&4)==0&&(k.a[k.a.length]="@const",true);(b.a&32)!=0&&(k.a[k.a.length]="@final",true);d=!b.d?null:b.d.d;d!=null&&(k.a[k.a.length]="@desc "+d+gMc,true);(b.a&JPc)!=0&&(k.a[k.a.length]="@dict",true);(b.a&
vMc)!=0&&(k.a[k.a.length]="@struct",true);(b.a&IPc)!=0&&(k.a[k.a.length]="@unrestricted ",true);(b.a&2)!=0&&(k.a[k.a.length]="@constructor",true);((b.a&512)!=0||(b.a&bPc)!=0)&&(b.a&bPc)==0&&(k.a[k.a.length]="@interface",true);((b.a&512)!=0||(b.a&bPc)!=0)&&(b.a&bPc)!=0&&(k.a[k.a.length]="@record",true);if(!b.d?null:b.d.a){g=true;s=Cmb((!b.d?null:b.d.a).a);Ywc(k,zmb(a,NNc,s))}for(r=A4b(b).Vd();r.Id();){p=r.Jd();g=true;s=Cmb(p.a);Ywc(k,zmb(a,NNc,s))}for(q=C4b(b).Vd();q.Id();){p=q.Jd();g=true;s=Cmb(p.a);
Ywc(k,zmb(a,ONc,s))}if(b.g){g=true;s=Cmb(b.g.a);Ywc(k,zmb(a,FMc,s))}if(F4b(b)>0){g=true;for(i=G4b(b).Vd();i.Id();){h=i.Jd();Ywc(k,"@param "+Amb(a,h,H4b(b,h)))}}if((b.a&HPc)==$Lc){g=true;Ywc(k,zmb(a,ENc,((HPc&b.a)==$Lc?b.i:null).a))}K4b(b).Ud()||Ywc(k,zmb(a,uQc,K4b(b).ce(0).a));j=J4b(b);if(!j.Ud()){Ywc(k,vQc+Nc(new Pc(String.fromCharCode(44)),j.Vd()));g=true}t=O4b(b);if(!t.Ud()){g=true;for(f=po(t).Vd();f.Id();){e=f.Jd();h=e.Ve();o=e5(new j5(e.We()));k.a[k.a.length]=vQc+h+" := "+o+" =:"}}(b.a&64)!=
0&&(k.a[k.a.length]="@override",true);(b.a&HPc)==WPc&&(b.a&4)==0&&(b.e?Ywc(k,Dmb(a,((HPc&b.a)==WPc?b.i:null).a)):Ywc(k,zmb(a,$Nc,((HPc&b.a)==WPc?b.i:null).a)));(b.a&4)!=0&&Ywc(k,zmb(a,"define",((HPc&b.a)==WPc?b.i:null).a));(b.a&HPc)==hMc&&Ywc(k,zmb(a,"typedef",((HPc&b.a)==hMc?b.i:null).a));(b.a&HPc)==eQc&&Ywc(k,zmb(a,ZNc,((HPc&b.a)==eQc?b.i:null).a));(b.a&8192)!=0&&(k.a[k.a.length]="@implicitCast",true);(b.a&hQc)!=0&&(k.a[k.a.length]="@nocollapse",true);n=(m=!b.d?null:b.d.q,!m?(Cyc(),Cyc(),Byc):m);
if(!n.Ud()){c=n.ae(zE(nW,uNc,2,0,6,1));Wxc(c,(Wy(),Vy));Ywc(k,"@suppress {"+Nc(new Pc(String.fromCharCode(44)),new Guc(new eyc(c)))+"}");g=true}if((b.a&256)!=0){Ywc(k,"@deprecated "+(!b.d?null:b.d.c));g=true}if(!!b.d&&J5b(b.d,3)){g=true;k.a[k.a.length]="@polymer"}if(!!b.d&&J5b(b.d,2)){g=true;k.a[k.a.length]="@polymerBehavior"}if(!!b.d&&J5b(b.d,6)){g=true;k.a[k.a.length]="@mixinFunction"}if(!!b.d&&J5b(b.d,5)){g=true;k.a[k.a.length]="@mixinClass"}if(!!b.d&&J5b(b.d,4)){g=true;k.a[k.a.length]="@customElement"}k.a[k.a.length]=
"*/";l=new stc;g?Lc(new Pc("\n "),l,new wxc(k)):Lc(new Pc(" "),l,new wxc(k));l.a+=g?gMc:" ";return l.a}function TIb(){TIb=JZ;oIb=new UIb("NG_INJECT",0);LHb=new UIb("ABSTRACT",1);MHb=new UIb("AUTHOR",2);NHb=new UIb("CLOSURE_PRIMITIVE",3);OHb=new UIb("CONSISTENTIDGENERATOR",4);PHb=new UIb("CONSTANT",5);QHb=new UIb(tRc,6);RHb=new UIb("CUSTOM_ELEMENT",7);DIb=new UIb("RECORD",8);SHb=new UIb("DEFINE",9);THb=new UIb("DEPRECATED",10);UHb=new UIb("DESC",11);VHb=new UIb("DICT",12);WHb=new UIb("DISPOSES",13);
XHb=new UIb(uRc,14);$Hb=new UIb(vRc,15);_Hb=new UIb("EXTERNS",16);YHb=new UIb(wRc,17);ZHb=new UIb("EXPOSE",18);aIb=new UIb("FILE_OVERVIEW",19);bIb=new UIb("FINAL",20);cIb=new UIb("HIDDEN",21);dIb=new UIb("IDGENERATOR",22);eIb=new UIb(xRc,23);fIb=new UIb("IMPLICIT_CAST",24);gIb=new UIb("INHERIT_DOC",25);hIb=new UIb(yRc,26);iIb=new UIb("LENDS",27);jIb=new UIb("LICENSE",28);kIb=new UIb("MEANING",29);lIb=new UIb("MIXIN_CLASS",30);mIb=new UIb("MIXIN_FUNCTION",31);nIb=new UIb("MODIFIES",32);qIb=new UIb("NO_COLLAPSE",
33);rIb=new UIb("NO_COMPILE",34);sIb=new UIb("NO_INLINE",35);tIb=new UIb("NO_SIDE_EFFECTS",36);pIb=new UIb("NOT_IMPLEMENTED",37);uIb=new UIb("OVERRIDE",38);vIb=new UIb(zRc,39);wIb=new UIb("PARAM",40);xIb=new UIb("POLYMER",41);yIb=new UIb("POLYMER_BEHAVIOR",42);zIb=new UIb("PRESERVE",43);AIb=new UIb(ARc,44);BIb=new UIb(BRc,45);CIb=new UIb(CRc,46);EIb=new UIb(DRc,47);FIb=new UIb("SEE",48);GIb=new UIb("STABLEIDGENERATOR",49);HIb=new UIb("STRUCT",50);IIb=new UIb("SUPPRESS",51);JIb=new UIb("TEMPLATE",
52);KIb=new UIb(EMc,53);LIb=new UIb("THROWS",54);MIb=new UIb(ERc,55);NIb=new UIb("TYPEDEF",56);OIb=new UIb("TYPE_SUMMARY",57);PIb=new UIb("UNRESTRICTED",58);QIb=new UIb("VERSION",59);RIb=new UIb("WIZACTION",60);SIb=es(new hs,"ngInject",oIb).Lf("abstract",LHb).Lf("argument",wIb).Lf("author",MHb).Lf("closurePrimitive",NHb).Lf("consistentIdGenerator",OHb).Lf(XOc,PHb).Lf("constant",PHb).Lf(LMc,QHb).Lf("customElement",RHb).Lf("copyright",jIb).Lf("define",SHb).Lf(SOc,THb).Lf("desc",UHb).Lf("dict",VHb).Lf("disposes",
WHb).Lf(ZNc,XHb).Lf(INc,YHb).Lf("expose",ZHb).Lf(NNc,$Hb).Lf("externs",_Hb).Lf("fileoverview",aIb).Lf("final",bIb).Lf("hidden",cIb).Lf("idGenerator",dIb).Lf(ONc,eIb).Lf("implicitCast",fIb).Lf("inheritDoc",gIb).Lf(YNc,hIb).Lf("record",DIb).Lf("lends",iIb).Lf("license",jIb).Lf("meaning",kIb).Lf("mixinClass",lIb).Lf("mixinFunction",mIb).Lf("modifies",nIb).Lf("nocollapse",qIb).Lf("nocompile",rIb).Lf("noinline",sIb).Lf("nosideeffects",tIb).Lf("override",uIb).Lf("owner",MHb).Lf(FRc,vIb).Lf("param",wIb).Lf("polymer",
xIb).Lf($Oc,yIb).Lf("preserve",zIb).Lf(GRc,AIb).Lf(HRc,BIb).Lf(IRc,CIb).Lf(ENc,EIb).Lf("returns",EIb).Lf("see",FIb).Lf("stableIdGenerator",GIb).Lf("struct",HIb).Lf("suppress",IIb).Lf("template",JIb).Lf(FMc,KIb).Lf(uQc,LIb).Lf($Nc,MIb).Lf("typedef",NIb).Lf("typeSummary",OIb).Lf("unrestricted",PIb).Lf("version",QIb).Lf("wizaction",RIb).Kf()}function Ftb(){Ftb=JZ;new Mcb("JSC_NULL_ARGUMENT_ERROR",(E2(),B2),new Rtc('method "{0}" called without an argument'));new Mcb("JSC_EXPECTED_OBJECTLIT_ERROR",B2,
new Rtc('method "{0}" expected an object literal argument'));new Mcb("JSC_EXPECTED_STRING_ERROR",B2,new Rtc('method "{0}" expected a string argument'));new Mcb("JSC_INVALID_ARGUMENT_ERROR",B2,new Rtc('method "{0}" called with invalid argument'));new Mcb("JSC_INVALID_CSS_NAME_MAP_STYLE_ERROR",B2,new Rtc("Invalid CSS name map style {0}"));new Mcb("JSC_TOO_MANY_ARGUMENTS_ERROR",B2,new Rtc('method "{0}" called with more than one argument'));new Mcb("JSC_DUPLICATE_NAMESPACE_ERROR",B2,new Rtc('namespace "{0}" cannot be provided twice\nOriginally provided at {1}'));
new Mcb("JSC_WEAK_NAMESPACE_TYPE",D2,new Rtc("Provided symbol declared with type Object. This is rarely useful. For more information see https://github.com/google/closure-compiler/wiki/A-word-about-the-type-Object"));new Mcb("JSC_CLASS_NAMESPACE_ERROR",B2,new Rtc("\"{0}\" cannot be both provided and declared as a class. Try var {0} = class '{'...'}'"));new Mcb("JSC_FUNCTION_NAMESPACE_ERROR",B2,new Rtc('"{0}" cannot be both provided and declared as a function'));Dtb=new Mcb("JSC_MISSING_PROVIDE_ERROR",
B2,new Rtc('required "{0}" namespace never provided'));Ctb=new Mcb(hNc,B2,new Rtc('required "{0}" namespace not provided yet'));Btb=new Mcb("JSC_INVALID_PROVIDE_ERROR",B2,new Rtc('"{0}" is not a valid {1} qualified name'));new Mcb("JSC_INVALID_DEFINE_NAME_ERROR",B2,new Rtc('"{0}" is not a valid JS identifier name'));new Mcb("JSC_INVALID_MISSING_DEFINE_ANNOTATION",B2,new Rtc("Missing @define annotation"));new Mcb("JSC_XMODULE_REQUIRE_ERROR",D2,new Rtc('namespace "{0}" is required in module {2} but provided in module {1}. Is module {2} missing a dependency on module {1}?'));
new Mcb("JSC_NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR",B2,new Rtc("goog.setCssNameMapping only takes an object literal with string values"));new Mcb("INVALID_CSS_RENAMING_MAP",D2,new Rtc("Invalid entries in css renaming map: {0}"));new Mcb("JSC_GOOG_BASE_CLASS_ERROR",B2,new Rtc("incorrect use of goog.base: {0}"));new Mcb("JSC_BASE_CLASS_ERROR",B2,new Rtc("incorrect use of {0}.base: {1}"));new Mcb("JSC_CLOSURE_DEFINES_ERROR",B2,new Rtc("Invalid CLOSURE_DEFINES definition"));new Mcb("JSC_INVALID_FORWARD_DECLARE",
B2,new Rtc("Malformed goog.forwardDeclaration"));Etb=new Mcb("JSC_USE_OF_GOOG_BASE",C2,new Rtc("goog.base is not compatible with ES5 strict mode.\nPlease use an alternative.\nFor EcmaScript classes use the super keyword. For traditional Closure classes,\nuse the class specific base method instead. For example, for the constructor MyClass:\n   MyClass.base(this, ''constructor'')"));ztb=new Mcb(HQc,B2,new Rtc("Closure primitive method {0} may not be aliased"));Atb=new Mcb(HQc,B2,new Rtc("Closure primitive method {0} may not be aliased  outside a module (ES module, CommonJS module, or goog.module)"))}
function r3(){r3=JZ;new Mcb("JSC_AT_EXPORT_IN_GOOG_MODULE",(E2(),B2),new Rtc("@export has no effect on top-level names in a goog.module. See http://go/js-practices/exports#export-annotations-in-googmodule Consider using goog.exportSymbol instead."));h3=new Mcb("JSC_AT_EXPORT_IN_NON_LEGACY_GOOG_MODULE",B2,new Rtc("@export is not allowed here in a non-legacy goog.module. Consider using goog.exportSymbol instead."));k3=new Mcb("JSC_GOOG_MODULE_IN_NON_MODULE",B2,new Rtc("goog.module() call must be the first statement in a module."));
i3=new Mcb("JSC_DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE",B2,new Rtc("goog.module.declareLegacyNamespace may only be called in a goog.module."));new Mcb("JSC_GOOG_MODULE_REFERENCES_THIS",B2,new Rtc("The body of a goog.module cannot reference 'this'."));new Mcb("JSC_GOOG_MODULE_USES_THROW",B2,new Rtc("The body of a goog.module cannot use 'throw'."));new Mcb("JSC_DUPLICATE_NAME_SHORT_REQUIRE",B2,new Rtc("Found multiple goog.require statements importing identifier ''{0}''."));new Mcb("JSC_INVALID_DESTRUCTURING_REQUIRE",
B2,new Rtc("Destructuring goog.require must be a simple object pattern."));o3=new Mcb("JSC_LET_GOOG_REQUIRE",C2,new Rtc(jNc));new Mcb("JSC_MULTIPLE_MODULES_IN_FILE",B2,new Rtc("There should only be a single goog.module() statement per file."));new Mcb("JSC_ONE_REQUIRE_PER_DECLARATION",B2,new Rtc("There may only be one goog.require() per var/let/const declaration."));l3=new Mcb("JSC_INCORRECT_SHORTNAME_CAPITALIZATION",C2,new Rtc("The capitalization of short name {0} is incorrect; it should be {1}."));
new Mcb("JSC_EXPORT_NOT_AT_MODULE_SCOPE",B2,new Rtc("Exports must be at the top-level of a module"));j3=new Mcb("JSC_EXPORT_NOT_A_STATEMENT",B2,new Rtc("Exports should be a statement."));new Mcb("JSC_EXPORT_REPEATED_ERROR",B2,new Rtc("Name cannot be exported multiple times. Previous export on line {0}."));new Mcb("JSC_REFERENCE_TO_MODULE_GLOBAL_NAME",B2,new Rtc("References to the global name of a module are not allowed. Perhaps you meant exports?"));p3=new Mcb("JSC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME",
C2,new Rtc("Reference to fully qualified import name ''{0}''. Imports in goog.module should use the return value of goog.require / goog.forwardDeclare instead."));q3=new Mcb("JSC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME",C2,new Rtc("Reference to fully qualified import name ''{0}''. Please use the short name ''{1}'' instead."));m3=new Mcb("JSC_JSDOC_REFERENCE_TO_FULLY_QUALIFIED_IMPORT_NAME",C2,new Rtc("Reference to fully qualified import name ''{0}'' in JSDoc. Imports in goog.module should use the return value of goog.require / goog.forwardDeclare instead."));
n3=new Mcb("JSC_JSDOC_REFERENCE_TO_SHORT_IMPORT_BY_LONG_NAME_INCLUDING_SHORT_NAME",C2,new Rtc("Reference to fully qualified import name ''{0}'' in JSDoc. Please use the short name ''{1}'' instead."));new Mcb("JSC_REQUIRE_NOT_AT_TOP_LEVEL",B2,new Rtc("goog.require() must be called at file scope."))}function Efc(a){var b,c,d,e;d=false;e=a;f:{b=null;g:switch(e.length){case 2:c=e.charCodeAt(1);if(c==102){if(e.charCodeAt(0)==105){d=true;break f}}else if(c==110){if(e.charCodeAt(0)==105){d=true;break f}}else if(c==
111)if(e.charCodeAt(0)==100){d=true;break f}break g;case 3:switch(e.charCodeAt(0)){case 102:{if(e.charCodeAt(2)==114&&e.charCodeAt(1)==111){d=true;break f}}break g;case 105:{if(e.charCodeAt(2)==116&&e.charCodeAt(1)==110){d=true;break f}}break g;case 110:{if(e.charCodeAt(2)==119&&e.charCodeAt(1)==101){d=true;break f}}break g;case 116:{if(e.charCodeAt(2)==121&&e.charCodeAt(1)==114){d=true;break f}}break g;case 118:{if(e.charCodeAt(2)==114&&e.charCodeAt(1)==97){d=true;break f}}break g}break g;case 4:switch(e.charCodeAt(0)){case 98:b=
"byte";d=true;break g;case 99:c=e.charCodeAt(3);if(c==101){if(e.charCodeAt(2)==115&&e.charCodeAt(1)==97){d=true;break f}}else if(c==114)if(e.charCodeAt(2)==97&&e.charCodeAt(1)==104){d=true;break f}break g;case 101:c=e.charCodeAt(3);if(c==101){if(e.charCodeAt(2)==115&&e.charCodeAt(1)==108){d=true;break f}}else if(c==109)if(e.charCodeAt(2)==117&&e.charCodeAt(1)==110){d=true;break f}break g;case 103:b="goto";d=true;break g;case 108:b="long";d=true;break g;case 110:b=jLc;d=true;break g;case 116:c=e.charCodeAt(3);
if(c==101){if(e.charCodeAt(2)==117&&e.charCodeAt(1)==114){d=true;break f}}else if(c==115)if(e.charCodeAt(2)==105&&e.charCodeAt(1)==104){d=true;break f}break g;case 118:b=XNc;d=true;break g;case 119:b="with";d=true;break g}break g;case 5:switch(e.charCodeAt(2)){case 97:b=MNc;d=true;break g;case 101:b="break";d=true;break g;case 105:b=PNc;d=true;break g;case 108:b=SNc;d=true;break g;case 110:c=e.charCodeAt(0);if(c==99){b=XOc;d=true}else if(c==102){b="final";d=true}break g;case 111:c=e.charCodeAt(0);
if(c==102){b="float";d=true}else if(c==115){b="short";d=true}break g;case 112:b=DMc;d=true;break g;case 114:b="throw";d=true;break g;case 116:b="catch";d=true;break g}break g;case 6:switch(e.charCodeAt(1)){case 97:b="native";d=true;break g;case 101:c=e.charCodeAt(0);if(c==100){b=ISc;d=true}else if(c==114){b=ENc;d=true}break g;case 104:b=uQc;d=true;break g;case 109:b=LNc;d=true;break g;case 111:b="double";d=true;break g;case 116:b=KRc;d=true;break g;case 117:b=IRc;d=true;break g;case 119:b="switch";
d=true;break g;case 120:b=INc;d=true;break g;case 121:b=yQc;d=true;break g}break g;case 7:switch(e.charCodeAt(1)){case 97:b=FRc;d=true;break g;case 101:b=JNc;d=true;break g;case 105:b=DNc;d=true;break g;case 111:b=XKc;d=true;break g;case 114:b=GRc;d=true;break g;case 120:b=NNc;d=true;break g}break g;case 8:switch(e.charCodeAt(0)){case 97:b="abstract";d=true;break g;case 99:b=UNc;d=true;break g;case 100:b=WNc;d=true;break g;case 102:b=ZKc;d=true;break g;case 118:b="volatile";d=true;break g}break g;
case 9:c=e.charCodeAt(0);if(c==105){b=YNc;d=true}else if(c==112){b=HRc;d=true}else if(c==116){b="transient";d=true}break g;case 10:c=e.charCodeAt(1);if(c==109){b=ONc;d=true}else if(c==110){b=zQc;d=true}break g;case 12:b="synchronized";d=true;break g}if(b!=null&&b!=e&&!Esc(b,e))return false}return d}function IRb(){IRb=JZ;VQb=new JRb("ES3_KEYWORDS_AS_IDENTIFIERS",0,"ES3 keywords as identifiers",1);aRb=new JRb("GETTER",1,"getters",1);eRb=new JRb("KEYWORDS_AS_PROPERTIES",2,"reserved words as properties",
1);yRb=new JRb("SETTER",3,"setters",1);ARb=new JRb("STRING_CONTINUATION",4,"string continuation",1);DRb=new JRb("TRAILING_COMMA",5,"trailing comma",1);FQb=new JRb("ARRAY_PATTERN_REST",6,"array pattern rest",2);GQb=new JRb("ARROW_FUNCTIONS",7,"arrow function",2);JQb=new JRb("BINARY_LITERALS",8,"binary literal",2);KQb=new JRb("BLOCK_SCOPED_FUNCTION_DECLARATION",9,"block-scoped function declaration",2);MQb=new JRb("CLASSES",10,MNc,2);NQb=new JRb("CLASS_EXTENDS",11,"class extends",2);OQb=new JRb("CLASS_GETTER_SETTER",
12,"class getters/setters",2);PQb=new JRb("COMPUTED_PROPERTIES",13,"computed property",2);RQb=new JRb("CONST_DECLARATIONS",14,"const declaration",2);SQb=new JRb("DEFAULT_PARAMETERS",15,"default parameter",2);EQb=new JRb("ARRAY_DESTRUCTURING",16,"array destructuring",2);lRb=new JRb("OBJECT_DESTRUCTURING",17,"object destructuring",2);XQb=new JRb("EXTENDED_OBJECT_LITERALS",18,"extended object literal",2);ZQb=new JRb("FOR_OF",19,"for-of loop",2);$Qb=new JRb("GENERATORS",20,"generator",2);fRb=new JRb("LET_DECLARATIONS",
21,"let declaration",2);gRb=new JRb("MEMBER_DECLARATIONS",22,"member declaration",2);kRb=new JRb(wSc,23,QNc,2);oRb=new JRb("OCTAL_LITERALS",24,"octal literal",2);sRb=new JRb("REGEXP_FLAG_U",25,"RegExp flag 'u'",2);tRb=new JRb("REGEXP_FLAG_Y",26,"RegExp flag 'y'",2);xRb=new JRb("REST_PARAMETERS",27,"rest parameter",2);zRb=new JRb("SPREAD_EXPRESSIONS",28,"spread expression",2);BRb=new JRb(CMc,29,DMc,2);CRb=new JRb("TEMPLATE_LITERALS",30,"template literal",2);iRb=new JRb("MODULES",31,"modules",2);WQb=
new JRb("EXPONENT_OP",32,"exponent operator (**)",3);HQb=new JRb("ASYNC_FUNCTIONS",33,_Nc,4);ERb=new JRb("TRAILING_COMMA_IN_PARAM_LIST",34,"trailing comma in param list",4);mRb=new JRb("OBJECT_LITERALS_WITH_SPREAD",35,"object literals with spread",5);nRb=new JRb("OBJECT_PATTERN_REST",36,"object pattern rest",5);IQb=new JRb("ASYNC_GENERATORS",37,"async generator functions",5);YQb=new JRb(xSc,38,"for-await-of loop",5);rRb=new JRb("REGEXP_FLAG_S",39,"RegExp flag 's'",5);uRb=new JRb("REGEXP_LOOKBEHIND",
40,"RegExp Lookbehind",5);vRb=new JRb("REGEXP_NAMED_GROUPS",41,"RegExp named groups",5);wRb=new JRb("REGEXP_UNICODE_PROPERTY_ESCAPE",42,"RegExp unicode property escape",5);HRb=new JRb("UNESCAPED_UNICODE_LINE_OR_PARAGRAPH_SEP",43,"Unescaped unicode line or paragraph separator",6);pRb=new JRb("OPTIONAL_CATCH_BINDING",44,"Optional catch binding",6);TQb=new JRb(ySc,45,"Dynamic module import",8);CQb=new JRb("ACCESSIBILITY_MODIFIER",46,"accessibility modifier",9);DQb=new JRb(zSc,47,"ambient declaration",
9);LQb=new JRb(ASc,48,"call signature",9);QQb=new JRb("CONSTRUCTOR_SIGNATURE",49,"constructor signature",9);UQb=new JRb(uRc,50,ZNc,9);_Qb=new JRb("GENERICS",51,"generics",9);bRb=new JRb(xRc,52,ONc,9);cRb=new JRb(BSc,53,"index signature",9);dRb=new JRb(yRc,54,YNc,9);hRb=new JRb("MEMBER_VARIABLE_IN_CLASS",55,"member variable in class",9);jRb=new JRb(CSc,56,"namespace declaration",9);qRb=new JRb(DSc,57,"optional parameter",9);FRb=new JRb(ESc,58,"type alias",9);GRb=new JRb("TYPE_ANNOTATION",59,"type annotation",
9)}function AZb(){AZb=JZ;XXb=new DZb("END_OF_FILE",0,"End of File");aYb=new DZb(zMc,1,"error");iYb=new DZb("IDENTIFIER",2,"identifier");DXb=new CZb("BREAK",3);GXb=new CZb("CASE",4);HXb=new CZb(FSc,5);QXb=new CZb(GSc,6);RXb=new CZb(HSc,7);TXb=new CZb(gRc,8);UXb=new CZb("DELETE",9);VXb=new CZb("DO",10);WXb=new CZb("ELSE",11);eYb=new CZb(JSc,12);fYb=new CZb("FOR",13);gYb=new CZb(jQc,14);jYb=new CZb("IF",15);mYb=new CZb("IN",16);nYb=new CZb(uSc,17);yYb=new CZb("NEW",18);WYb=new CZb(DRc,19);iZb=new CZb(KSc,
20);mZb=new CZb(EMc,21);nZb=new CZb("THROW",22);qZb=new CZb("TRY",23);sZb=new CZb(LSc,24);vZb=new CZb("VAR",25);wZb=new CZb("VOID",26);xZb=new CZb("WHILE",27);yZb=new CZb("WITH",28);IXb=new CZb(iQc,29);PXb=new CZb("CONST",30);YXb=new CZb(uRc,31);bYb=new CZb(wRc,32);cYb=new CZb(vRc,33);lYb=new CZb(MSc,34);hZb=new CZb(CMc,35);kYb=new CZb(xRc,36);oYb=new CZb(yRc,37);sYb=new CZb("LET",38);JYb=new CZb(zRc,39);RYb=new CZb(ARc,40);SYb=new CZb(BRc,41);TYb=new CZb(CRc,42);fZb=new CZb("STATIC",43);zZb=new CZb("YIELD",
44);FYb=new DZb("OPEN_CURLY",45,"{");KXb=new DZb("CLOSE_CURLY",46,"}");GYb=new DZb("OPEN_PAREN",47,"(");LXb=new DZb("CLOSE_PAREN",48,")");HYb=new DZb("OPEN_SQUARE",49,"[");MXb=new DZb("CLOSE_SQUARE",50,"]");MYb=new DZb("PERIOD",51,".");ZYb=new DZb("SEMI_COLON",52,";");OXb=new DZb("COMMA",53,",");EYb=new DZb("OPEN_ANGLE",54,"<");JXb=new DZb("CLOSE_ANGLE",55,">");rYb=new DZb("LESS_EQUAL",56,"<=");hYb=new DZb("GREATER_EQUAL",57,">=");zXb=new DZb("ARROW",58,"=>");$Xb=new DZb("EQUAL_EQUAL",59,"==");zYb=
new DZb("NOT_EQUAL",60,"!=");_Xb=new DZb("EQUAL_EQUAL_EQUAL",61,"===");AYb=new DZb("NOT_EQUAL_EQUAL",62,"!==");NYb=new DZb("PLUS",63,"+");tYb=new DZb("MINUS",64,"-");bZb=new DZb("STAR",65,"*");dZb=new DZb("STAR_STAR",66,"**");KYb=new DZb("PERCENT",67,"%");PYb=new DZb("PLUS_PLUS",68,"++");vYb=new DZb("MINUS_MINUS",69,"--");pYb=new DZb("LEFT_SHIFT",70,"<<");XYb=new DZb("RIGHT_SHIFT",71,">>");tZb=new DZb("UNSIGNED_RIGHT_SHIFT",72,">>>");wXb=new DZb("AMPERSAND",73,"&");BXb=new DZb("BAR",74,"|");EXb=new DZb("CARET",
75,"^");AXb=new DZb("BANG",76,"!");oZb=new DZb("TILDE",77,"~");yXb=new DZb("AND",78,"&&");IYb=new DZb("OR",79,"||");UYb=new DZb("QUESTION",80,"?");NXb=new DZb("COLON",81,":");ZXb=new DZb("EQUAL",82,"=");OYb=new DZb("PLUS_EQUAL",83,"+=");uYb=new DZb("MINUS_EQUAL",84,"-=");cZb=new DZb("STAR_EQUAL",85,"*=");eZb=new DZb("STAR_STAR_EQUAL",86,"**=");LYb=new DZb("PERCENT_EQUAL",87,"%=");qYb=new DZb("LEFT_SHIFT_EQUAL",88,"<<=");YYb=new DZb("RIGHT_SHIFT_EQUAL",89,">>=");uZb=new DZb("UNSIGNED_RIGHT_SHIFT_EQUAL",
90,">>>=");xXb=new DZb("AMPERSAND_EQUAL",91,"&=");CXb=new DZb("BAR_EQUAL",92,"|=");FXb=new DZb("CARET_EQUAL",93,"^=");$Yb=new DZb("SLASH",94,"/");_Yb=new DZb("SLASH_EQUAL",95,"/=");QYb=new DZb("POUND",96,"#");CYb=new CZb(NSc,97);pZb=new CZb(OSc,98);dYb=new CZb(PSc,99);DYb=new DZb("NUMBER",100,"number literal");gZb=new DZb(fSc,101,"string literal");VYb=new DZb("REGULAR_EXPRESSION",102,"regular expression literal");aZb=new DZb("SPREAD",103,HNc);jZb=new DZb("TEMPLATE_HEAD",104,"template head");kZb=new DZb("TEMPLATE_MIDDLE",
105,"template middle");lZb=new DZb("TEMPLATE_TAIL",106,"template tail");BYb=new DZb("NO_SUBSTITUTION_TEMPLATE",107,"no substitution template");rZb=new CZb(ERc,108);SXb=new CZb(QSc,109);wYb=new CZb("MODULE",110);xYb=new CZb(RSc,111)}function n1b(){n1b=JZ;N0b=new o1b("PROGRAM",0);m0b=new o1b("FUNCTION_DECLARATION",1);G_b=new o1b("BLOCK",2);j1b=new o1b("VARIABLE_STATEMENT",3);h1b=new o1b("VARIABLE_DECLARATION",4);b0b=new o1b("EMPTY_STATEMENT",5);f0b=new o1b("EXPRESSION_STATEMENT",6);r0b=new o1b("IF_STATEMENT",
7);__b=new o1b("DO_WHILE_STATEMENT",8);k1b=new o1b("WHILE_STATEMENT",9);j0b=new o1b("FOR_IN_STATEMENT",10);l0b=new o1b("FOR_STATEMENT",11);i1b=new o1b("VARIABLE_DECLARATION_LIST",12);X_b=new o1b("CONTINUE_STATEMENT",13);H_b=new o1b("BREAK_STATEMENT",14);R0b=new o1b("RETURN_STATEMENT",15);l1b=new o1b("WITH_STATEMENT",16);K_b=new o1b("CASE_CLAUSE",17);Z_b=new o1b("DEFAULT_CLAUSE",18);V0b=new o1b("SWITCH_STATEMENT",19);w0b=new o1b("LABELLED_STATEMENT",20);$0b=new o1b("THROW_STATEMENT",21);L_b=new o1b(FSc,
22);_0b=new o1b("TRY_STATEMENT",23);Y_b=new o1b("DEBUGGER_STATEMENT",24);Z0b=new o1b("THIS_EXPRESSION",25);q0b=new o1b("IDENTIFIER_EXPRESSION",26);x0b=new o1b("LITERAL_EXPRESSION",27);A_b=new o1b("ARRAY_LITERAL_EXPRESSION",28);I0b=new o1b("OBJECT_LITERAL_EXPRESSION",29);O_b=new o1b("COMPREHENSION",30);Q_b=new o1b("COMPREHENSION_IF",31);P_b=new o1b("COMPREHENSION_FOR",32);p0b=new o1b("GET_ACCESSOR",33);S0b=new o1b("SET_ACCESSOR",34);O0b=new o1b("PROPERTY_NAME_ASSIGNMENT",35);R_b=new o1b("COMPUTED_PROPERTY_DEFINITION",
36);S_b=new o1b("COMPUTED_PROPERTY_GETTER",37);U_b=new o1b("COMPUTED_PROPERTY_METHOD",38);V_b=new o1b("COMPUTED_PROPERTY_SETTER",39);B0b=new o1b("MISSING_PRIMARY_EXPRESSION",40);N_b=new o1b("COMMA_EXPRESSION",41);F_b=new o1b("BINARY_OPERATOR",42);W_b=new o1b("CONDITIONAL_EXPRESSION",43);e1b=new o1b("UNARY_EXPRESSION",44);g1b=new o1b("UPDATE_EXPRESSION",45);y0b=new o1b("MEMBER_EXPRESSION",46);F0b=new o1b("NEW_EXPRESSION",47);z_b=new o1b("ARGUMENT_LIST",48);I_b=new o1b("CALL_EXPRESSION",49);M_b=new o1b("CLASS_DECLARATION",
50);v0b=new o1b("INTERFACE_DECLARATION",51);D0b=new o1b(CSc,52);E0b=new o1b("NAMESPACE_NAME",53);c0b=new o1b("ENUM_DECLARATION",54);z0b=new o1b("MEMBER_LOOKUP_EXPRESSION",55);M0b=new o1b("PAREN_EXPRESSION",56);g0b=new o1b(JSc,57);U0b=new o1b("SUPER_EXPRESSION",58);B_b=new o1b(dTc,59);D_b=new o1b("ASSIGNMENT_REST_ELEMENT",60);J0b=new o1b(eTc,61);h0b=new o1b("FORMAL_PARAMETER_LIST",62);T0b=new o1b("SPREAD_EXPRESSION",63);H0b=new o1b(NSc,64);Q0b=new o1b("REST_PARAMETER",65);C0b=new o1b("MODULE_IMPORT",
66);d0b=new o1b("EXPORT_DECLARATION",67);e0b=new o1b("EXPORT_SPECIFIER",68);s0b=new o1b("IMPORT_DECLARATION",69);t0b=new o1b("IMPORT_SPECIFIER",70);k0b=new o1b("FOR_OF_STATEMENT",71);i0b=new o1b("FOR_AWAIT_OF_STATEMENT",72);m1b=new o1b("YIELD_EXPRESSION",73);$_b=new o1b("DEFAULT_PARAMETER",74);W0b=new o1b("TEMPLATE_LITERAL_EXPRESSION",75);X0b=new o1b("TEMPLATE_LITERAL_PORTION",76);Y0b=new o1b("TEMPLATE_SUBSTITUTION",77);c1b=new o1b("TYPE_NAME",78);d1b=new o1b("TYPE_QUERY",79);a1b=new o1b("TYPED_PARAMETER",
80);K0b=new o1b(DSc,81);L0b=new o1b("PARAMETERIZED_TYPE_TREE",82);C_b=new o1b(fTc,83);P0b=new o1b(gTc,84);f1b=new o1b(hTc,85);n0b=new o1b(iTc,86);o0b=new o1b(jTc,87);A0b=new o1b("MEMBER_VARIABLE",88);T_b=new o1b("COMPUTED_PROPERTY_MEMBER_VARIABLE",89);b1b=new o1b(ESc,90);y_b=new o1b(zSc,91);u0b=new o1b(BSc,92);J_b=new o1b(ASc,93);G0b=new o1b("NEW_TARGET_EXPRESSION",94);E_b=new o1b("AWAIT_EXPRESSION",95);a0b=new o1b("DYNAMIC_IMPORT_EXPRESSION",96)}function MWb(a){var b,c;QWb(a);b=a.f;if(!xWb(a,a.f))return tWb(a,
(AZb(),XXb),b);c=yWb(a);switch(c){case 123:return tWb(a,(AZb(),FYb),b);case 125:return tWb(a,(AZb(),KXb),b);case 40:return tWb(a,(AZb(),GYb),b);case 41:return tWb(a,(AZb(),LXb),b);case 91:return tWb(a,(AZb(),HYb),b);case 93:return tWb(a,(AZb(),MXb),b);case 46:if(gXb(xWb(a,a.f)?zsc(a.b,a.f):0))return RWb(a),HWb(a,b);if((xWb(a,a.f)?zsc(a.b,a.f):0)==46&&(xWb(a,a.f+1)?zsc(a.b,a.f+1):0)==46){yWb(a);yWb(a);return tWb(a,(AZb(),aZb),b)}return tWb(a,(AZb(),MYb),b);case 59:return tWb(a,(AZb(),ZYb),b);case 44:return tWb(a,
(AZb(),OXb),b);case 126:return tWb(a,(AZb(),oZb),b);case 63:return tWb(a,(AZb(),UYb),b);case 58:return tWb(a,(AZb(),NXb),b);case 60:switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 60:yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),qYb),b)}return tWb(a,(AZb(),pYb),b);case 61:yWb(a);return tWb(a,(AZb(),rYb),b);default:return tWb(a,(AZb(),EYb),b)}case 62:if(a.j>0)return tWb(a,(AZb(),JXb),b);switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 62:yWb(a);switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 61:yWb(a);
return tWb(a,(AZb(),YYb),b);case 62:yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),uZb),b)}return tWb(a,(AZb(),tZb),b);default:return tWb(a,(AZb(),XYb),b)}case 61:yWb(a);return tWb(a,(AZb(),hYb),b);default:return tWb(a,(AZb(),JXb),b)}case 61:switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 61:yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),_Xb),b)}return tWb(a,(AZb(),$Xb),b);case 62:yWb(a);return tWb(a,(AZb(),zXb),b);default:return tWb(a,(AZb(),ZXb),b)}case 33:if((xWb(a,
a.f)?zsc(a.b,a.f):0)==61){yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),AYb),b)}return tWb(a,(AZb(),zYb),b)}return tWb(a,(AZb(),AXb),b);case 42:if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),cZb),b)}else if((xWb(a,a.f)?zsc(a.b,a.f):0)==42){yWb(a);if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),eZb),b)}else return tWb(a,(AZb(),dZb),b)}return tWb(a,(AZb(),bZb),b);case 37:if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),LYb),b)}return tWb(a,
(AZb(),KYb),b);case 94:if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),FXb),b)}return tWb(a,(AZb(),EXb),b);case 47:if((xWb(a,a.f)?zsc(a.b,a.f):0)==61){yWb(a);return tWb(a,(AZb(),_Yb),b)}return tWb(a,(AZb(),$Yb),b);case 43:switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 43:yWb(a);return tWb(a,(AZb(),PYb),b);case 61:yWb(a);return tWb(a,(AZb(),OYb),b);default:return tWb(a,(AZb(),NYb),b)}case 45:switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 45:yWb(a);return tWb(a,(AZb(),vYb),b);case 61:yWb(a);return tWb(a,
(AZb(),uYb),b);default:return tWb(a,(AZb(),tYb),b)}case 38:switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 38:yWb(a);return tWb(a,(AZb(),yXb),b);case 61:yWb(a);return tWb(a,(AZb(),xXb),b);default:return tWb(a,(AZb(),wXb),b)}case 124:switch(xWb(a,a.f)?zsc(a.b,a.f):0){case 124:yWb(a);return tWb(a,(AZb(),IYb),b);case 61:yWb(a);return tWb(a,(AZb(),CXb),b);default:return tWb(a,(AZb(),BXb),b)}case 35:return tWb(a,(AZb(),QYb),b);case 48:return KWb(a,b);case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return RWb(a),
IWb(a,b);case 34:case 39:return LWb(a,b,c);case 96:return!xWb(a,a.f)&&EWb(a,ZSb(a.i.b,b),$Sc,CE(xE(iW,1),mLc,1,5,[])),BWb(a,(AZb(),BYb),jZb);default:return JWb(a,b,c)}}function Afc(){Afc=JZ;Uec=new Bfc(DRc,0);Tcc=new Bfc("BITOR",1);Ucc=new Bfc("BITXOR",2);Rcc=new Bfc("BITAND",3);xdc=new Bfc("EQ",4);vec=new Bfc("NE",5);lec=new Bfc("LT",6);iec=new Bfc("LE",7);Rdc=new Bfc("GT",8);Ldc=new Bfc("GE",9);kec=new Bfc("LSH",10);Wec=new Bfc("RSH",11);tfc=new Bfc("URSH",12);vcc=new Bfc("ADD",13);efc=new Bfc("SUB",
14);qec=new Bfc("MUL",15);pdc=new Bfc("DIV",16);oec=new Bfc("MOD",17);zdc=new Bfc("EXPONENT",18);zec=new Bfc("NOT",19);Scc=new Bfc("BITNOT",20);Oec=new Bfc("POS",21);wec=new Bfc("NEG",22);xec=new Bfc("NEW",23);ndc=new Bfc("DELPROP",24);pfc=new Bfc(LSc,25);Pdc=new Bfc("GETPROP",26);Odc=new Bfc("GETELEM",27);Ycc=new Bfc("CALL",28);rec=new Bfc("NAME",29);Cec=new Bfc("NUMBER",30);bfc=new Bfc(fSc,31);Aec=new Bfc(NSc,32);lfc=new Bfc(EMc,33);Edc=new Bfc(PSc,34);nfc=new Bfc(OSc,35);Zec=new Bfc("SHEQ",36);
$ec=new Bfc("SHNE",37);Rec=new Bfc("REGEXP",38);mfc=new Bfc("THROW",39);Zdc=new Bfc("IN",40);aec=new Bfc(uSc,41);zcc=new Bfc("ARRAYLIT",42);Eec=new Bfc("OBJECTLIT",43);ofc=new Bfc("TRY",44);Jec=new Bfc("PARAM_LIST",45);edc=new Bfc("COMMA",46);Ccc=new Bfc("ASSIGN",47);Fcc=new Bfc("ASSIGN_BITOR",48);Gcc=new Bfc("ASSIGN_BITXOR",49);Ecc=new Bfc("ASSIGN_BITAND",50);Jcc=new Bfc("ASSIGN_LSH",51);Mcc=new Bfc("ASSIGN_RSH",52);Occ=new Bfc("ASSIGN_URSH",53);Dcc=new Bfc("ASSIGN_ADD",54);Ncc=new Bfc("ASSIGN_SUB",
55);Lcc=new Bfc("ASSIGN_MUL",56);Hcc=new Bfc("ASSIGN_DIV",57);Kcc=new Bfc("ASSIGN_MOD",58);Icc=new Bfc("ASSIGN_EXPONENT",59);Sdc=new Bfc("HOOK",60);Hec=new Bfc("OR",61);wcc=new Bfc("AND",62);$dc=new Bfc("INC",63);jdc=new Bfc("DEC",64);Jdc=new Bfc(jQc,65);Tdc=new Bfc("IF",66);gfc=new Bfc(KSc,67);$cc=new Bfc("CASE",68);ldc=new Bfc("DEFAULT_CASE",69);xfc=new Bfc("WHILE",70);qdc=new Bfc("DO",71);Fdc=new Bfc("FOR",72);Hdc=new Bfc("FOR_IN",73);Xcc=new Bfc("BREAK",74);hdc=new Bfc(GSc,75);ufc=new Bfc("VAR",
76);yfc=new Bfc("WITH",77);adc=new Bfc(FSc,78);vfc=new Bfc("VOID",79);tdc=new Bfc("EMPTY",80);Vec=new Bfc("ROOT",81);Vcc=new Bfc("BLOCK",82);eec=new Bfc("LABEL",83);Ddc=new Bfc("EXPR_RESULT",84);Xec=new Bfc("SCRIPT",85);Qdc=new Bfc("GETTER_DEF",86);Yec=new Bfc("SETTER_DEF",87);gdc=new Bfc("CONST",88);idc=new Bfc(HSc,89);fec=new Bfc("LABEL_NAME",90);cfc=new Bfc("STRING_KEY",91);_cc=new Bfc("CAST",92);Acc=new Bfc(dTc,93);Fec=new Bfc(eTc,94);odc=new Bfc("DESTRUCTURING_LHS",95);bdc=new Bfc(iQc,96);cdc=
new Bfc("CLASS_MEMBERS",97);mec=new Bfc("MEMBER_FUNCTION_DEF",98);ffc=new Bfc(CMc,99);jec=new Bfc("LET",100);Idc=new Bfc("FOR_OF",101);Gdc=new Bfc(xSc,102);zfc=new Bfc("YIELD",103);Pcc=new Bfc("AWAIT",104);Vdc=new Bfc(MSc,105);Xdc=new Bfc("IMPORT_SPECS",106);Wdc=new Bfc("IMPORT_SPEC",107);Ydc=new Bfc("IMPORT_STAR",108);Adc=new Bfc(wRc,109);Cdc=new Bfc("EXPORT_SPECS",110);Bdc=new Bfc("EXPORT_SPEC",111);pec=new Bfc("MODULE_BODY",112);rdc=new Bfc(ySc,113);Sec=new Bfc("REST",114);_ec=new Bfc("SPREAD",
115);fdc=new Bfc("COMPUTED_PROP",116);hfc=new Bfc("TAGGED_TEMPLATELIT",117);ifc=new Bfc("TEMPLATELIT",118);kfc=new Bfc("TEMPLATELIT_SUB",119);jfc=new Bfc("TEMPLATELIT_STRING",120);mdc=new Bfc("DEFAULT_VALUE",121);yec=new Bfc(wSc,122);dfc=new Bfc("STRING_TYPE",123);Wcc=new Bfc("BOOLEAN_TYPE",124);Dec=new Bfc("NUMBER_TYPE",125);Kdc=new Bfc(iTc,126);Iec=new Bfc("PARAMETERIZED_TYPE",127);sfc=new Bfc(hTc,128);ycc=new Bfc("ANY_TYPE",129);Bec=new Bfc("NULLABLE_TYPE",130);wfc=new Bfc("VOID_TYPE",131);Tec=
new Bfc("REST_PARAMETER_TYPE",132);sec=new Bfc("NAMED_TYPE",133);Gec=new Bfc(DSc,134);Qec=new Bfc(gTc,135);rfc=new Bfc("UNDEFINED_TYPE",136);Bcc=new Bfc(fTc,137);Mdc=new Bfc(wTc,138);Ndc=new Bfc(jTc,139);xcc=new Bfc(gSc,140);Kec=new Bfc("PIPE",141);afc=new Bfc("STAR",142);wdc=new Bfc("EOC",143);Pec=new Bfc("QMARK",144);sdc=new Bfc("ELLIPSIS",145);Qcc=new Bfc("BANG",146);ydc=new Bfc("EQUALS",147);gec=new Bfc("LB",148);hec=new Bfc("LC",149);ddc=new Bfc("COLON",150);bec=new Bfc(yRc,151);cec=new Bfc("INTERFACE_EXTENDS",
152);dec=new Bfc("INTERFACE_MEMBERS",153);udc=new Bfc(uRc,154);vdc=new Bfc("ENUM_MEMBERS",155);Udc=new Bfc(xRc,156);qfc=new Bfc(ESc,157);kdc=new Bfc(QSc,158);nec=new Bfc("MEMBER_VARIABLE_DEF",159);_dc=new Bfc(BSc,160);Zcc=new Bfc(ASc,161);tec=new Bfc(RSc,162);uec=new Bfc("NAMESPACE_ELEMENTS",163);Lec=new Bfc("PLACEHOLDER1",164);Mec=new Bfc("PLACEHOLDER2",165);Nec=new Bfc("PLACEHOLDER3",166)}function yBb(){yBb=JZ;new Mcb("JSC_INTERNAL_ERROR_UNEXPECTED_TOKEN",(E2(),B2),new Rtc("Internal Error: TypeCheck doesn''t know how to handle {0}"));
TAb=new Mcb("JSC_DETERMINISTIC_TEST",D2,new Rtc("condition always evaluates to {2}\nleft : {0}\nright: {1}"));eBb=new Mcb("JSC_INEXISTENT_ENUM_ELEMENT",D2,new Rtc("element {0} does not exist on this enum"));fBb=new Mcb("JSC_INEXISTENT_PROPERTY",D2,new Rtc(jRc));qBb=new Mcb("JSC_POSSIBLE_INEXISTENT_PROPERTY",C2,new Rtc(jRc));gBb=new Mcb("JSC_INEXISTENT_PROPERTY_WITH_SUGGESTION",D2,new Rtc(kRc));rBb=new Mcb("JSC_STRICT_INEXISTENT_PROPERTY",C2,new Rtc(jRc));tBb=new Mcb("JSC_STRICT_INEXISTENT_UNION_PROPERTY",
C2,new Rtc("Property {0} not defined on all member types of {1}"));sBb=new Mcb("JSC_STRICT_INEXISTENT_PROPERTY_WITH_SUGGESTION",C2,new Rtc(kRc));oBb=new Mcb("JSC_NOT_A_CONSTRUCTOR",D2,new Rtc("cannot instantiate non-constructor"));hBb=new Mcb("JSC_INSTANTIATE_ABSTRACT_CLASS",D2,new Rtc("cannot instantiate abstract class"));PAb=new Mcb("JSC_BAD_TYPE_FOR_BIT_OPERATION",D2,new Rtc("operator {0} cannot be applied to {1}"));pBb=new Mcb("JSC_NOT_FUNCTION_TYPE",D2,new Rtc("{0} expressions are not callable"));
SAb=new Mcb("JSC_CONSTRUCTOR_NOT_CALLABLE",D2,new Rtc('Constructor {0} should be called with the "new" keyword'));MAb=new Mcb("JSC_ABSTRACT_SUPER_METHOD_NOT_USABLE",D2,new Rtc("Abstract super method {0} cannot be dereferenced"));XAb=new Mcb("JSC_FUNCTION_MASKS_VARIABLE",D2,new Rtc("function {0} masks variable (IE bug)"));mBb=new Mcb("JSC_MULTIPLE_VAR_DEF",D2,new Rtc("declaration of multiple variables with shared type information"));UAb=new Mcb("JSC_ENUM_DUP",B2,new Rtc("enum element {0} already defined"));
kBb=new Mcb("JSC_INVALID_INTERFACE_MEMBER_DECLARATION",D2,new Rtc("interface members can only be empty property declarations, empty functions{0}"));iBb=new Mcb("JSC_INTERFACE_METHOD_NOT_EMPTY",D2,new Rtc("interface member functions must have an empty body"));QAb=new Mcb("JSC_CONFLICTING_EXTENDED_TYPE",D2,new Rtc("{1} cannot extend this type; {0}s can only extend {0}s"));VAb=new Mcb("JSC_ES5_CLASS_EXTENDING_ES6_CLASS",D2,new Rtc("ES5 class {0} cannot extend ES6 class {1}"));new Mcb("JSC_INTERFACE_EXTENDS_LOOP",
D2,new Rtc("extends loop involving {0}, loop: {1}"));RAb=new Mcb("JSC_CONFLICTING_IMPLEMENTED_TYPE",D2,new Rtc("{0} cannot implement this type; an interface can only extend, but not implement interfaces"));OAb=new Mcb("JSC_IMPLEMENTS_NON_INTERFACE",D2,new Rtc("can only implement interfaces"));ZAb=new Mcb("JSC_HIDDEN_SUPERCLASS_PROPERTY",C2,new Rtc("property {0} already defined on superclass {1}; use @override to override it"));YAb=new Mcb("JSC_HIDDEN_INTERFACE_PROPERTY",C2,new Rtc("property {0} already defined on interface {1}; use @override to override it"));
$Ab=new Mcb("JSC_HIDDEN_SUPERCLASS_PROPERTY_MISMATCH",D2,new Rtc("mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}"));vBb=new Mcb("JSC_UNKNOWN_OVERRIDE",D2,new Rtc("property {0} not defined on any superclass of {1}"));jBb=new Mcb("JSC_INTERFACE_METHOD_OVERRIDE",D2,new Rtc("property {0} is already defined by the {1} extended interface"));uBb=new Mcb("JSC_UNKNOWN_EXPR_TYPE",D2,new Rtc("could not determine the type of this expression"));
wBb=new Mcb("JSC_UNRESOLVED_TYPE",D2,new Rtc("could not resolve the name {0} to a type"));xBb=new Mcb("JSC_WRONG_ARGUMENT_COUNT",D2,new Rtc("Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}."));aBb=new Mcb("JSC_ILLEGAL_IMPLICIT_CAST",D2,new Rtc("Illegal annotation on {0}. @implicitCast may only be used in externs."));dBb=new Mcb("JSC_INCOMPATIBLE_EXTENDED_PROPERTY_TYPE",D2,new Rtc("Interface {0} has a property {1} with incompatible types in its super interfaces {2} and {3}"));
WAb=new Mcb("JSC_EXPECTED_THIS_TYPE",D2,new Rtc('"{0}" must be called with a "this" type'));lBb=new Mcb("JSC_IN_USED_WITH_STRUCT",D2,new Rtc("Cannot use the IN operator with structs"));cBb=new Mcb("JSC_ILLEGAL_PROPERTY_CREATION",D2,new Rtc("Cannot add a property to a struct instance after it is constructed. (If you already declared the property, make sure to give it a type.)"));bBb=new Mcb("JSC_ILLEGAL_OBJLIT_KEY",D2,new Rtc("Illegal key, the object literal is a {0}"));_Ab=new Mcb("JSC_ILLEGAL_CLASS_KEY",
D2,new Rtc("Illegal key, the class is a {0}"));nBb=new Mcb("JSC_NON_STRINGIFIABLE_OBJECT_KEY",D2,new Rtc('Object type "{0}" contains non-stringifiable key and it may lead to an error. Please use ES6 Map instead or implement your own Map structure.'));LAb=new Mcb("JSC_ABSTRACT_METHOD_IN_CONCRETE_CLASS",D2,new Rtc("Abstract methods can only appear in abstract classes. Please declare the class as @abstract"));NAb=new bcb(CE(xE(bM,1),mLc,5,0,[TAb,eBb,fBb,qBb,gBb,oBb,hBb,PAb,pBb,SAb,XAb,mBb,UAb,kBb,iBb,
QAb,RAb,OAb,$Ab,vBb,jBb,wBb,xBb,aBb,dBb,WAb,lBb,_Ab,cBb,bBb,nBb,LAb,MAb,VAb,(kwb(),gwb),iwb,(oCb(),nCb),lCb,fCb,jCb,($kb(),Xkb)]))}function Hcb(){Hcb=JZ;Dcb=new Mcb("JSC_UNUSED",(E2(),D2),new Rtc(GOc));tp(HOc,IOc,JOc,KOc,LOc,MOc,CE(xE(nW,1),uNc,2,6,[NOc,OOc,POc,QOc,ROc]));Gcb=new fDc;Kcb("untranspilableFeatures",CE(xE(bM,1),mLc,5,0,[(Hob(),Gob)]));Kcb("featuresNotSupportedByPass",CE(xE(bM,1),mLc,5,0,[(Msb(),Jsb)]));Kcb("moduleLoad",CE(xE(bM,1),mLc,5,0,[(ZEb(),YEb),(KHb(),JHb),(Itb(),Gtb),Htb]));scb=
Kcb("globalThis",CE(xE(bM,1),mLc,5,0,[(p2(),o2)]));Kcb(SOc,CE(xE(bM,1),mLc,5,0,[(d2(),Y1),Z1,$1,_1,W1,X1]));Kcb("underscore",CE(xE(bM,1),mLc,5,0,[(jHb(),eHb),fHb]));Fcb=Kcb("visibility",CE(xE(bM,1),mLc,5,0,[Q1,R1,P1,S1,a2,b2,c2,V1]));Icb("accessControls",Fcb);Kcb("nonStandardJsDocs",CE(xE(bM,1),mLc,5,0,[(kwb(),Tvb),Yvb,(A2(),w2)]));Kcb("invalidCasts",CE(xE(bM,1),mLc,5,0,[(MBb(),HBb)]));Icb(TOc,new _bb(TOc,CE(xE(bM,1),mLc,5,0,[Dcb])));Kcb("strictModuleDepCheck",CE(xE(bM,1),mLc,5,0,[(ICb(),CCb),(n2(),
l2)]));Kcb("violatedModuleDep",CE(xE(bM,1),mLc,5,0,[HCb]));Kcb("externsValidation",CE(xE(bM,1),mLc,5,0,[ACb,DCb]));Kcb("ambiguousFunctionDecl",CE(xE(bM,1),mLc,5,0,[(Pxb(),Hxb)]));Kcb("unknownDefines",CE(xE(bM,1),mLc,5,0,[(Qtb(),Ptb)]));Kcb("tweakValidation",CE(xE(bM,1),mLc,5,0,[(Vtb(),Rtb),Ttb,Utb]));Kcb("missingOverride",CE(xE(bM,1),mLc,5,0,[(yBb(),YAb),ZAb]));ucb=Kcb(UOc,CE(xE(bM,1),mLc,5,0,[fBb,gBb,qBb]));Kcb("globallyMissingProperties",CE(xE(bM,1),mLc,5,0,[qBb]));Kcb("j2clChecks",CE(xE(bM,1),
mLc,5,0,[(wmb(),vmb)]));Kcb("missingReturn",CE(xE(bM,1),mLc,5,0,[(N2(),M2)]));Kcb("internetExplorerChecks",CE(xE(bM,1),mLc,5,0,[fwb]));Ccb=Kcb("undefinedVars",CE(xE(bM,1),mLc,5,0,[ECb]));Bcb=Kcb("undefinedNames",CE(xE(bM,1),mLc,5,0,[m2]));Kcb("checkDebuggerStatement",CE(xE(bM,1),mLc,5,0,[(k2(),j2)]));Kcb("checkRegExp",CE(xE(bM,1),mLc,5,0,[(S2(),R2),Q2]));mcb=Jcb(sOc,CE(xE(aM,1),mLc,53,0,[ABb,NAb,($kb(),Lkb),scb]));Icb(MOc,new _bb(MOc,CE(xE(bM,1),mLc,5,0,[Dcb])));Icb(NOc,new _bb(NOc,CE(xE(bM,1),mLc,
5,0,[Dcb])));Icb(LOc,new _bb(LOc,CE(xE(bM,1),mLc,5,0,[Dcb])));Icb(VOc,new _bb(VOc,CE(xE(bM,1),mLc,5,0,[Dcb])));Kcb("tooManyTypeParams",CE(xE(bM,1),mLc,5,0,[ewb]));Icb(WOc,new _bb(WOc,CE(xE(bM,1),mLc,5,0,[Dcb])));Kcb(KOc,CE(xE(bM,1),mLc,5,0,[uBb]));ycb=Kcb(POc,CE(xE(bM,1),mLc,5,0,[rBb,sBb,tBb]));Acb=Kcb(QOc,CE(xE(bM,1),mLc,5,0,[IBb]));xcb=Jcb(ROc,CE(xE(aM,1),mLc,53,0,[ycb,Acb]));wcb=Kcb(HOc,CE(xE(bM,1),mLc,5,0,[uBb]));ncb=Kcb("checkVars",CE(xE(bM,1),mLc,5,0,[ECb,GCb,(aDb(),ZCb),$Cb]));Kcb("uselessCode",
CE(xE(bM,1),mLc,5,0,[(U2(),T2),(e3(),d3)]));Kcb(XOc,CE(xE(bM,1),mLc,5,0,[T1,U1,(Bbb(),Abb)]));Kcb("accessControlsConst",CE(xE(bM,1),mLc,5,0,[T1,U1]));Kcb("constantProperty",CE(xE(bM,1),mLc,5,0,[T1,U1]));Kcb("typeInvalidation",CE(xE(bM,1),mLc,5,0,[(Scb(),Qcb),Rcb]));ocb=Kcb(YOc,CE(xE(bM,1),mLc,5,0,[(m6(),l6),GCb,BBb,CBb,XAb,$Cb]));Kcb("es3",CE(xE(bM,1),mLc,5,0,[Wvb,fwb]));rcb=Kcb("es5StrictUncommon",CE(xE(bM,1),mLc,5,0,[Xvb,Uvb,Oxb,Lxb,Kxb,Gxb,Dxb,Ixb,Jxb]));qcb=Kcb("es5StrictReflection",CE(xE(bM,
1),mLc,5,0,[Exb,Fxb,Nxb,Mxb]));pcb=Jcb("es5Strict",CE(xE(aM,1),mLc,53,0,[rcb,qcb]));vcb=Kcb("missingProvide",CE(xE(bM,1),mLc,5,0,[(P2(),O2),(H3(),G3)]));Kcb("unrecognizedTypeError",CE(xE(bM,1),mLc,5,0,[iwb]));Kcb(ZOc,CE(xE(bM,1),mLc,5,0,[(L2(),K2)]));Jcb(OOc,CE(xE(aM,1),mLc,53,0,[wcb,Bcb,Ccb,vcb,ccb(Skb),ccb((Ftb(),Dtb)),ucb,ocb,ccb(Otb),ccb((Rdb(),Qdb)),ccb(YEb)]));zcb=Kcb("strictMissingRequire",CE(xE(bM,1),mLc,5,0,[K2,I2,J2]));Kcb("legacyGoogScopeRequire",CE(xE(bM,1),mLc,5,0,[I2,H2]));Kcb("extraRequire",
CE(xE(bM,1),mLc,5,0,[H2]));Kcb("misplacedTypeAnnotation",CE(xE(bM,1),mLc,5,0,[r2,s2,t2,v2,u2,x2,y2]));Kcb("misplacedMsgAnnotation",CE(xE(bM,1),mLc,5,0,[y2]));Kcb("misplacedSuppress",CE(xE(bM,1),mLc,5,0,[z2]));Kcb("suspiciousCode",CE(xE(bM,1),mLc,5,0,[(IGb(),HGb),(_2(),$2),V2,X2,W2,Y2,Z2,TAb,Gtb]));Kcb("functionParams",CE(xE(bM,1),mLc,5,0,[Qkb,Rkb]));Kcb("deprecatedAnnotations",CE(xE(bM,1),mLc,5,0,[q2]));Ecb=Kcb("unusedPrivateMembers",CE(xE(bM,1),mLc,5,0,[(g3(),f3)]));Kcb("unusedLocalVariables",CE(xE(bM,
1),mLc,5,0,[_Cb]));tcb=Kcb("jsdocMissingConst",CE(xE(bM,1),mLc,5,0,[(i2(),h2)]));Kcb("jsdocMissingType",CE(xE(bM,1),mLc,5,0,[$vb]));Kcb("unnecessaryEscape",CE(xE(bM,1),mLc,5,0,[hwb]));Kcb("typeImportCodeReferences",CE(xE(bM,1),mLc,5,0,[(b3(),a3)]));Jcb("lintChecks",CE(xE(aM,1),mLc,53,0,[YGb,new bcb(CE(xE(bM,1),mLc,5,0,[(f2(),e2),(KGb(),JGb),(PGb(),LGb),MGb,NGb,OGb,(RGb(),QGb),(UGb(),SGb),TGb,(nHb(),mHb),(XGb(),VGb),WGb,(lHb(),kHb),(rHb(),oHb),pHb,qHb,(xHb(),vHb),wHb,(zHb(),yHb),(EHb(),AHb),DHb,CHb,
BHb,(GHb(),FHb),(IHb(),HHb),(r3(),i3),k3,l3,o3,m3,n3,p3,q3,(K3(),J3),Zvb]))]));Kcb("strictModuleChecks",CE(xE(bM,1),mLc,5,0,[h3,o3,m3,n3,p3,q3]));lcb=Kcb(JOc,CE(xE(bM,1),mLc,5,0,[(GGb(),FGb),(uHb(),sHb),tHb,(umb(),tmb)]));Jcb(IOc,CE(xE(aM,1),mLc,53,0,[lcb,Ecb,tcb]));Kcb("useOfGoogBase",CE(xE(bM,1),mLc,5,0,[Etb]));Kcb("closureDepMethodUsageChecks",CE(xE(bM,1),mLc,5,0,[F3,ztb,Atb]));Kcb("transitionalSuspiciousCodeWarnings",CE(xE(bM,1),mLc,5,0,[(osb(),msb),nsb,lsb]));Kcb("lateProvide",CE(xE(bM,1),mLc,
5,0,[Ctb]));Kcb("missingPolyfill",CE(xE(bM,1),mLc,5,0,[(Avb(),zvb)]));Kcb("polymer",CE(xE(bM,1),mLc,5,0,[(ntb(),ltb)]));Kcb($Oc,CE(xE(bM,1),mLc,5,0,[mtb]));Kcb("invalidProvide",CE(xE(bM,1),mLc,5,0,[Btb]));Kcb("es6Typed",CE(xE(bM,1),mLc,5,0,[awb]));Icb(_Oc,new _bb(_Oc,CE(xE(bM,1),mLc,5,0,[Dcb])));Kcb("conflictingIjsFile",CE(xE(bM,1),mLc,5,0,[(EGb(),DGb)]));Kcb("googModuleExportNotAStatement",CE(xE(bM,1),mLc,5,0,[j3]))}function clc(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,
J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub;j=new thc(a);a.u[8]=j;L=new Mmc(a);a.u[32]=L;U=new Smc(a);a.u[33]=U;jb=new Anc(a);a.u[45]=jb;nb=new Enc(a);a.u[48]=nb;tb=new _pc(a,false);a.u[51]=tb;k=new _pc(a,true);a.u[11]=k;ub=new mqc(a);a.u[52]=ub;b=new Wgc(a);a.u[57]=b;a.n=new Inc(a,"IObject#KEY1");a.k=new Inc(a,"IObject#VALUE");a.a=new Inc(a,"T");a.s=new Inc(a,DTc);a.p=new Inc(a,DTc);a.d=new Inc(a,DTc);a.i=new Inc(a,DTc);a.b=new Inc(a,DTc);a.r=
new Inc(a,DTc);a.c=new Inc(a,DTc);a.o=new Inc(a,ERc);a.w=new Inc(a,ERc);qb=new Wic(a,null,null,true,null);a.u[53]=qb;t=elc(a,"IObject",CE(xE(vV,1),xPc,62,0,[a.n,a.k]));a.u[28]=t;ilc(a,29,(ae(t.f==(dkc(),akc)||t.f==bkc,lRc,t),cgc(t.k)));W=uic(Iic(Fic(Bic(Aic(vic(xic(new Lic(a))),NMc),Tkc(a,CE(xE(cV,1),xPc,23,0,[b])))),CE(xE(vV,1),xPc,62,0,[a.n,a.k])));Gjc(W,qb,null);a.u[39]=W;ilc(a,40,zjc(W));ab=(ae(W.f==akc||W.f==bkc,lRc,W),cgc(W.k));a.u[38]=ab;n=uic(Cic(Dic(Bic(Aic(vic(xic(new Lic(a))),nPc),Vkc(a,
true,CE(xE(cV,1),xPc,23,0,[b]))),tb),ab));Hjc(n,ab,null);a.u[16]=n;o=zjc(n);a.u[18]=o;K=new vmc(a);a.u[58]=K;I=new imc(a);a.u[59]=I;J=new Fmc(a);a.u[60]=J;A=elc(a,"Iterable",CE(xE(vV,1),xPc,62,0,[a.r]));a.u[23]=A;B=(ae(A.f==akc||A.f==bkc,lRc,A),cgc(A.k));a.u[24]=B;C=elc(a,"Iterator",CE(xE(vV,1),xPc,62,0,[a.s]));a.u[25]=C;D=(ae(C.f==akc||C.f==bkc,lRc,C),cgc(C.k));a.u[26]=D;v=elc(a,"IIterableResult",CE(xE(vV,1),xPc,62,0,[a.p]));a.u[21]=v;w=(ae(v.f==akc||v.f==bkc,lRc,v),cgc(v.k));a.u[22]=w;c=uic(Jic(Fic(Bic(Aic(vic(xic(new Lic(a))),
kPc),Vkc(a,true,CE(xE(cV,1),xPc,23,0,[b])))),new $nc(a,(Bn(),new hz(Qn(CE(xE(iW,1),mLc,1,5,[a.k,a.a])))),new Wz(Sd(a.a)))));zjc(c);Ejc(c,new Wz(Sd(Ykc(a,B,CE(xE(cV,1),xPc,23,0,[a.a])))));a.u[1]=c;d=(ae(c.f==akc||c.f==bkc,lRc,c),cgc(c.k));a.u[0]=d;u=uic(Bic(Aic(vic(xic(new Lic(a))),"ITemplateArray"),new J9b((Afc(),Jec))));ilc(a,27,(ae(u.f==akc||u.f==bkc,lRc,u),cgc(u.k)));p=elc(a,"Generator",CE(xE(vV,1),xPc,62,0,[a.i]));Djc(p,new hz(Qn(CE(xE(iW,1),mLc,1,5,[Ykc(a,B,CE(xE(cV,1),xPc,23,0,[a.i])),Ykc(a,
D,CE(xE(cV,1),xPc,23,0,[a.i]))]))));a.u[19]=p;ilc(a,20,(ae(p.f==akc||p.f==bkc,lRc,p),cgc(p.k)));g=elc(a,"AsyncIterator",CE(xE(vV,1),xPc,62,0,[a.d]));a.u[4]=g;ilc(a,5,(ae(g.f==akc||g.f==bkc,lRc,g),cgc(g.k)));f=elc(a,"AsyncIterable",CE(xE(vV,1),xPc,62,0,[a.c]));a.u[2]=f;ilc(a,3,(ae(f.f==akc||f.f==bkc,lRc,f),cgc(f.k)));e=elc(a,"AsyncGenerator",CE(xE(vV,1),xPc,62,0,[a.b]));a.u[6]=e;ilc(a,7,(ae(e.f==akc||e.f==bkc,lRc,e),cgc(e.k)));F=elc(a,"IThenable",CE(xE(vV,1),xPc,62,0,[a.o]));a.u[30]=F;G=(ae(F.f==akc||
F.f==bkc,lRc,F),cgc(F.k));a.u[31]=G;pb=Wkc(a,(oo(),oo(),el("then",tb),new Sz("then",tb)));Sd(ETc);jDc(a.v,ETc);a.u[49]=pb;db=Nkc(a,tb,CE(xE(cV,1),xPc,23,0,[Mkc(a,tb,Tkc(a,CE(xE(cV,1),xPc,23,0,[Zkc(a,CE(xE(cV,1),xPc,23,0,[a.w,Ykc(a,G,CE(xE(cV,1),xPc,23,0,[a.w])),pb,L]))]))),Mkc(a,tb,Tkc(a,CE(xE(cV,1),xPc,23,0,[b])))]));cb=(ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc(rec,""));cb.d=db;bb=uic(yic(Iic(Bic(Aic(vic(xic(new Lic(a))),pPc),(Xd(cb.n==rec||cb.n==Sec),new L9b(Jec,cb))),CE(xE(vV,1),xPc,62,0,[a.w])),
a.o,a.w));Ejc(bb,new Wz(Sd(Ykc(a,G,CE(xE(cV,1),xPc,23,0,[a.w])))));a.u[37]=bb;ilc(a,36,(ae(bb.f==akc||bb.f==bkc,lRc,bb),cgc(bb.k)));h=uic(Dic(Bic(Aic(vic(xic(new Lic(a))),lPc),Tkc(a,CE(xE(cV,1),xPc,23,0,[b]))),j));zjc(h);a.u[10]=h;i=(ae(h.f==akc||h.f==bkc,lRc,h),cgc(h.k));a.u[9]=i;l=uic(Dic(Bic(Aic(vic(xic(new Lic(a))),"Date"),Tkc(a,CE(xE(cV,1),xPc,23,0,[tb,tb,tb,tb,tb,tb,tb]))),jb));zjc(l);a.u[13]=l;m=(ae(l.f==akc||l.f==bkc,lRc,l),cgc(l.k));a.u[12]=m;N=uic(Dic(Bic(Aic(vic(xic(new Lic(a))),oPc),Tkc(a,
CE(xE(cV,1),xPc,23,0,[b]))),U));zjc(N);a.u[35]=N;O=(ae(N.f==akc||N.f==bkc,lRc,N),cgc(N.k));a.u[34]=O;eb=uic(Fic(Bic(Aic(vic(xic(new Lic(a))),qPc),Tkc(a,CE(xE(cV,1),xPc,23,0,[b,b])))));zjc(eb);a.u[42]=eb;fb=(ae(eb.f==akc||eb.f==bkc,lRc,eb),cgc(eb.k));a.u[41]=fb;gb=uic(Dic(Bic(Aic(vic(xic(new Lic(a))),oMc),Tkc(a,CE(xE(cV,1),xPc,23,0,[b]))),jb));zjc(gb);a.u[44]=gb;hb=(ae(gb.f==akc||gb.f==bkc,lRc,gb),cgc(gb.k));a.u[43]=hb;lb=uic(Dic(Bic(Aic(vic(xic(new Lic(a))),rPc),Tkc(a,CE(xE(cV,1),xPc,23,0,[b]))),
nb));zjc(lb);a.u[47]=lb;mb=(ae(lb.f==akc||lb.f==bkc,lRc,lb),cgc(lb.k));a.u[46]=mb;M=Zkc(a,CE(xE(cV,1),xPc,23,0,[L,ub]));a.u[66]=M;$=Zkc(a,CE(xE(cV,1),xPc,23,0,[ab,nb]));a.u[67]=$;X=Zkc(a,CE(xE(cV,1),xPc,23,0,[ab,U,jb]));a.u[68]=X;Y=Zkc(a,CE(xE(cV,1),xPc,23,0,[ab,U,jb,j]));a.u[69]=Y;Z=Zkc(a,CE(xE(cV,1),xPc,23,0,[ab,U,jb,j,nb]));a.u[70]=Z;Q=Zkc(a,CE(xE(cV,1),xPc,23,0,[U,jb,j]));a.u[71]=Q;R=Zkc(a,CE(xE(cV,1),xPc,23,0,[U,jb,j,nb]));a.u[72]=R;T=Zkc(a,CE(xE(cV,1),xPc,23,0,[U,nb]));a.u[73]=T;ib=Zkc(a,CE(xE(cV,
1),xPc,23,0,[jb,nb]));a.u[74]=ib;P=Zkc(a,CE(xE(cV,1),xPc,23,0,[U,jb]));a.u[75]=P;S=Zkc(a,CE(xE(cV,1),xPc,23,0,[U,jb,nb]));a.u[76]=S;kb=Zkc(a,CE(xE(cV,1),xPc,23,0,[hb,jb]));a.u[54]=kb;V=Zkc(a,CE(xE(cV,1),xPc,23,0,[O,U]));a.u[55]=V;ob=Zkc(a,CE(xE(cV,1),xPc,23,0,[mb,nb]));a.u[56]=ob;sb=Okc(a,tb,CE(xE(cV,1),xPc,23,0,[tb]));a.u[63]=sb;rb=new nlc(a,new ghc(a,Vkc(a,true,CE(xE(cV,1),xPc,23,0,[tb])),tb),tb,akc);n.k=rb;Xd(!(!!rb.g||!rb.u));rb.p=o;a.u[62]=rb;a.u[17]=rb;H=Qkc(a,K,CE(xE(cV,1),xPc,23,0,[b]));a.u[64]=
H;r=uic(Dic(Bic(Aic(vic(xic(new Lic(a))),"global this"),Vkc(a,false,CE(xE(cV,1),xPc,23,0,[b]))),U));q=(ae(r.f==akc||r.f==bkc,lRc,r),cgc(r.k));a.u[61]=q;s=Qkc(a,b,CE(xE(cV,1),xPc,23,0,[K]));a.u[65]=s;jlc(a,aNc,W)}function iLb(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z;switch(b.p.f){case 42:return nLb(a,b);case 28:return jLb(a,b);case 75:return dMb(a,b);case 76:return eMb(a,b.a);case 77:return eKb(a.a,(Afc(),kfc),yKb(a.a,b.a));case 44:return iMb(a,
b);case 2:return pLb(a,b);case 14:return qLb(a,b);case 49:return CLb(a,b);case 17:return aMb(a,b);case 18:return bMb(a,b);case 22:return b.b.p==(n1b(),b0b)&&bKb(a.a,b,(IRb(),pRb)),fKb(a.a,(Afc(),adc),yKb(a.a,b.b),zKb(a.a,b.a));case 13:return tLb(a,b);case 8:return fKb(a.a,(Afc(),qdc),zKb(a.a,b.a),yKb(a.a,b.b));case 5:return dKb((d=a,b,d).a,(Afc(),tdc));case 6:return yLb(a,b);case 24:return dKb((e=a,b,e).a,(Afc(),idc));case 25:return dKb((f=a,b,f).a,(Afc(),lfc));case 11:return zLb(a,b);case 10:return h=
yKb(a.a,b.c),gKb(a.a,(Afc(),Hdc),h,yKb(a.a,b.b),zKb(a.a,b.a));case 1:return BLb(a,b);case 55:return fKb(a.a,(Afc(),Odc),yKb(a.a,b.b),yKb(a.a,b.a));case 46:return i=yKb(a.a,b.b),j=b.a,k=QLb(a,j),!k.Yh()&&!a.a.c&&eLb(a,k),fKb(a.a,(Afc(),Pdc),i,k);case 43:return gKb(a.a,(Afc(),Sdc),yKb(a.a,b.a),yKb(a.a,b.b),yKb(a.a,b.c));case 7:return FLb(a,b);case 20:return JLb(a,b);case 56:return XKb(a,b),yKb(a.a,b.a);case 26:return LLb(a,b.a,false);case 47:return PLb(a,b);case 29:return RLb(a,b);case 36:return bKb(a.a,
b,(IRb(),PQb)),fKb(a.a,(Afc(),fdc),yKb(a.a,b.a),yKb(a.a,b.b));case 37:return bKb(a.a,b,(IRb(),PQb)),l=yKb(a.a,b.c),m=yKb(a.a,b.a),n=v3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc((Afc(),rec),"")),new J9b(Jec),m),I9b(n,m),o=fKb(a.a,fdc,l,n),c9b(o,M7b,1),c9b(o,k8b,b.b?1:0),o;case 89:return bKb(a.a,b,(IRb(),PQb)),gLb(a,b,hRb),p=eKb(a.a,(Afc(),fdc),yKb(a.a,b.d)),bLb(a,p,b.b),c9b(p,(n8b(),P7b),1),d9b(p,L7b,b.a),x9b(p,b.c),_Kb(a,b,p,b.a),p;case 38:return bKb(a.a,b,(IRb(),PQb)),q=fKb(a.a,(Afc(),fdc),
yKb(a.a,b.c),yKb(a.a,b.b)),b9b(q,(n8b(),N7b),true),b.b.i&&c9b(q,(Hbc(),zbc),1),_Kb(a,b,q,b.a),q;case 39:return bKb(a.a,b,(IRb(),PQb)),r=yKb(a.a,b.d),s=ALb(a,b.c),uKb(s,b.c),t=yKb(a.a,b.a),u=v3b((ae(Hsc("",_sc(46))==-1,HMc,""),n8b(),new Wbc((Afc(),rec),"")),s,t),I9b(u,t),v=fKb(a.a,fdc,r,u),c9b(v,O7b,1),c9b(v,k8b,b.b?1:0),v;case 15:return ZLb(a,b);case 45:return w=VKb(b.b.e),A=yKb(a.a,b.a),YKb(a,w,b.c==1,A);case 0:return mLb(a,b);case 27:return KLb(a,b);case 19:return cMb(a,b);case 21:return eKb(a.a,
(Afc(),mfc),yKb(a.a,b.a));case 23:return fMb(a,b);case 3:return iLb(a.a.t,b.a);case 12:return lMb(a,b);case 4:return kMb(a,b);case 9:return fKb(a.a,(Afc(),xfc),yKb(a.a,b.b),zKb(a.a,b.a));case 16:return fKb(a.a,(Afc(),yfc),yKb(a.a,b.b),zKb(a.a,b.a));case 41:return sLb(a,b);case 64:return dKb((g=a,b,g).a,(Afc(),tdc));case 57:return zKb(a.a,b.a);case 40:return iKb((c=a,b,c).a,(Afc(),rec),RRc);case 35:return WLb(a,b);case 33:return B=QLb(a,b.c),A9b(B,(Afc(),Qdc)),C=yKb(a.a,b.a),D=iKb(a.a,rec,""),uKb(D,
b.a),F=dKb(a.a,Jec),uKb(F,b.a),G=gKb(a.a,Jdc,D,F,C),uKb(G,b.a),r8b(B,G),bLb(a,G,b.d),x9b(B,b.b),B;case 34:return H=QLb(a,b.d),A9b(H,(Afc(),Yec)),I=ALb(a,b.c),uKb(I,b.c),J=yKb(a.a,b.a),K=iKb(a.a,rec,""),tKb(K,b.d),L=gKb(a.a,Jdc,K,I,J),uKb(L,b.a),r8b(H,L),x9b(H,b.b),H;case 62:return ALb(a,b);case 50:return rLb(a,b);case 58:return bKb(a.a,b,(IRb(),BRb)),dKb(a.a,(Afc(),ffc));case 94:return bKb(a.a,b,(IRb(),kRb)),dKb(a.a,(Afc(),yec));case 73:return M=dKb(a.a,(Afc(),zfc)),!!b.a&&q8b(M,yKb(a.a,b.a)),B9b(M,
b.b),M;case 95:return bKb(a.a,b,(IRb(),HQb)),N=dKb(a.a,(Afc(),Pcc)),q8b(N,yKb(a.a,b.a)),N;case 71:return bKb(a.a,b,(IRb(),ZQb)),O=yKb(a.a,b.c),gKb(a.a,(Afc(),Idc),O,yKb(a.a,b.b),zKb(a.a,b.a));case 72:return bKb(a.a,b,(IRb(),YQb)),P=yKb(a.a,b.c),gKb(a.a,(Afc(),Gdc),P,yKb(a.a,b.b),zKb(a.a,b.a));case 67:return wLb(a,b);case 68:return xLb(a,b);case 69:return GLb(a,b);case 70:return HLb(a,b);case 96:return bKb(a.a,b,(IRb(),TQb)),Q=yKb(a.a,b.a),eKb(a.a,(Afc(),rdc),Q);case 59:return kLb(a,b);case 61:return SLb(a,
b);case 60:return lLb(a,b);case 32:case 31:case 30:return a.a.d.Ah("unsupported language feature: array/generator comprehensions",a.a.q,(RJb(),b.o.b.b+1),b.o.b.a),iKb(a.a,(Afc(),rec),RRc);case 74:return uLb(a,b);case 65:return bKb(a.a,b,(IRb(),xRb)),R=AKb(a.a,b.a),R.n==(Afc(),Fec)?bKb(a.a,b.a,lRb):R.n==Acc&&bKb(a.a,b.a,EQb),eKb(a.a,Sec,R);case 63:return bKb(a.a,b,(IRb(),zRb)),eKb(a.a,(Afc(),_ec),yKb(a.a,b.a));case 78:return gMb(a,b);case 80:return S=yKb(a.a,b.a),bLb(a,S,b.b),S;case 81:return gLb(a,
b,(IRb(),qRb)),T=yKb(a.a,b.a),c9b(T,(n8b(),f8b),1),T;case 82:return VLb(a,b);case 83:return SJb(a.a,Hfc(yKb(a.a,b.a)));case 84:return XLb(a,b);case 85:return jMb(a,b);case 86:return DLb(a,b);case 79:return hMb(a,b);case 87:return ELb(a,b);case 88:return U=iKb(a.a,(Afc(),nec),b.e.a),bLb(a,U,b.b),x9b(U,b.d),c9b(U,(n8b(),f8b),b.c?1:0),_Kb(a,b,U,b.a),U;case 51:return ILb(a,b);case 54:return vLb(a,b);case 90:return gLb(a,b,(IRb(),FRb)),V=iKb(a.a,(Afc(),qfc),b.a.a),r8b(V,yKb(a.a,b.b)),V;case 91:return gLb(a,
b,(IRb(),DQb)),eKb(a.a,(Afc(),kdc),yKb(a.a,b.a));case 52:return NLb(a,b);case 92:return gLb(a,b,(IRb(),cRb)),W=yKb(a.a,b.b),X=H8b(W,(Hbc(),Nac)),X.n!=(Afc(),Dec)&&X.n!=dfc&&a.a.d.Ah("Index signature parameter type must be 'string' or 'number'",a.a.q,(RJb(),b.b.o.b.b+1),b.b.o.b.a),Y=eKb(a.a,_dc,W),bLb(a,Y,b.a),Y;case 93:return gLb(a,b,b.c?(IRb(),QQb):(IRb(),LQb)),Z=eKb(a.a,(Afc(),Zcc),yKb(a.a,b.a)),bLb(a,Z,b.d),aLb(a,Z,b.b),c9b(Z,(n8b(),Q7b),b.c?1:0),Z}return a.a.d.Ah("Unsupported syntax: "+b.p,a.a.q,
(RJb(),b.o.b.b+1),0),dKb(a.a,(Afc(),tdc))}function VMb(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb,hb,ib,jb,kb,lb,mb,nb,ob,pb,qb,rb,sb,tb,ub,vb;u=a.j.g;i=lOb(a.j);e=a.j.n;d=Po(a.a,e);if(!d||e.length==0)BMb(a,_Qc,e,a.j.g,lOb(a.j));else{n6b(a.f,e,u,i);switch(d.f){case 0:Z4b(a.f.a)?zMb(a,"msg.jsdoc.nginject.extra",a.j.g,lOb(a.j)):Z6b(a.f);return IMb(a,!a.o?mOb(a.j):GMb(a));case 1:r6b(a.f)||CMb(a,WRc,a.j.g,lOb(a.j));return IMb(a,
!a.o?mOb(a.j):GMb(a));case 2:if(a.f.d){g=LMb(a);f=g.a;f.length==0?zMb(a,"msg.jsdoc.authormissing",a.j.g,lOb(a.j)):h6b(a.f,f);b=g.b}else b=IMb(a,!a.o?mOb(a.j):GMb(a));return b;case 4:v6b(a.f)||zMb(a,"msg.jsdoc.consistidgen",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 58:w7b(a.f)||CMb(a,WRc,a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 50:m7b(a.f)||CMb(a,WRc,a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 12:D6b(a.f)||CMb(a,WRc,a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):
GMb(a));case 6:x6b(a.f)||(W4b(a.f.a)?CMb(a,XRc,a.j.g,lOb(a.j)):CMb(a,WRc,a.j.g,lOb(a.j)));return IMb(a,!a.o?mOb(a.j):GMb(a));case 8:Q6b(a.f)||CMb(a,"msg.jsdoc.record",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 10:A6b(a.f)||zMb(a,"msg.jsdoc.deprecated",a.j.g,lOb(a.j));J=KMb(a,b,a.g?0:2,false);I=J.a;I.length>0&&B6b(a.f,I);b=J.b;return b;case 26:R6b(a.f)||((a.f.a.a&2)!=0?CMb(a,XRc,a.j.g,lOb(a.j)):CMb(a,WRc,a.j.g,lOb(a.j)));return IMb(a,!a.o?mOb(a.j):GMb(a));case 11:if(y4b(a.f.a)!=null){zMb(a,
"msg.jsdoc.desc.extra",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a))}else{k=KMb(a,b,a.g?0:2,false);j=k.a;C6b(a.f,j);b=k.b;return b}case 19:l="";if(a.f.d&&!NMb(a,64)){m=KMb(a,b,a.g?0:1,false);l=m.a;b=m.b}else b=IMb(a,!a.o?mOb(a.j):GMb(a));K6b(a.f,l)||zMb(a,"msg.jsdoc.fileoverview.extra",a.j.g,lOb(a.j));return b;case 28:case 43:H=KMb(a,b,0,true);G=H.a;G.length>0&&!!a.d&&i6b(a.d,G);b=H.b;return b;case 14:b=!a.o?mOb(a.j):GMb(a);u=a.j.g;i=lOb(a.j);jb=null;if(b!=(fOb(),TNb)&&b!=RNb){nb=UMb(a,b,a.j.g,
lOb(a.j),b==WNb,false);if(!!nb&&nb.n==(Afc(),bfc)){kb=nb.Wh();wMb.Sd(kb)||(nb=zNb(a,(Afc(),Qcc),nb))}jb=!nb?null:new H7b(nb,(P=H8b(a.n,(Hbc(),ybc)),!P?null:P.ug()))}else a.o=b;!jb&&(jb=FMb(a,RMb(a,YKc,a.j.g,lOb(a.j))));F6b(a.f,jb)||a.c.Bh(URc+occ(WRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(Q=H8b(a.n,(Hbc(),ybc)),!Q?null:Q.ug()),u,i);return IMb(a,!a.o?mOb(a.j):GMb(a));case 18:H6b(a.f)||zMb(a,"msg.jsdoc.expose",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 16:J6b(a.f)||zMb(a,"msg.jsdoc.externs",a.j.g,
lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 57:t7b(a.f)||zMb(a,"msg.jsdoc.typesummary",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 15:case 23:xNb(a);b=!a.o?mOb(a.j):GMb(a);u=a.j.g;i=lOb(a.j);v=false;if(b==(fOb(),WNb)){b=!a.o?mOb(a.j):GMb(a);v=true}if(b==eOb){nb=UMb(a,b,u,i,v,true);u=a.j.g;i=lOb(a.j);nb=zNb(a,(Afc(),Qcc),nb);jb=!nb?null:new H7b(nb,(P=H8b(a.n,(Hbc(),ybc)),!P?null:P.ug()));if(d==(TIb(),$Hb))Ywc(c,new ENb(jb,a.j.g,lOb(a.j)));else{Xd(d==eIb);O6b(a.f,jb)||a.c.Bh(URc+occ("msg.jsdoc.implements.duplicate",
CE(xE(iW,1),mLc,1,5,[]))+VRc,(U=H8b(a.n,(Hbc(),ybc)),!U?null:U.ug()),u,i)}b=!a.o?mOb(a.j):GMb(a);v?b!=aOb?CMb(a,YRc,a.j.g,lOb(a.j)):b=!a.o?mOb(a.j):GMb(a):b!=TNb&&b!=SNb&&b!=RNb&&CMb(a,"msg.end.annotation.expected",a.j.g,lOb(a.j))}else b==NNb||b==$Nb?a.c.Bh(URc+occ("msg.jsdoc.implements.extraqualifier",CE(xE(iW,1),mLc,1,5,[]))+VRc,(V=H8b(a.n,(Hbc(),ybc)),!V?null:V.ug()),u,i):a.c.Bh(URc+occ("msg.no.type.name",CE(xE(iW,1),mLc,1,5,[]))+VRc,(W=H8b(a.n,(Hbc(),ybc)),!W?null:W.ug()),u,i);b=IMb(a,b);return b;
case 21:M6b(a.f)||zMb(a,"msg.jsdoc.hidden",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 27:xNb(a);v=false;if(OMb(a,(fOb(),WNb))){b=!a.o?mOb(a.j):GMb(a);v=true}if(OMb(a,eOb)){b=!a.o?mOb(a.j):GMb(a);S6b(a.f,FMb(a,V3b(a.j.n)))||CMb(a,"msg.jsdoc.lends.incompatible",a.j.g,lOb(a.j))}else CMb(a,"msg.jsdoc.lends.missing",a.j.g,lOb(a.j));v&&!OMb(a,aOb)&&CMb(a,YRc,a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 29:A=KMb(a,b,a.g?0:2,false);w=A.a;b=A.b;V6b(a.f,w)||zMb(a,"msg.jsdoc.meaning.extra",
a.j.g,lOb(a.j));return b;case 3:xNb(a);return XMb(a,!a.o?mOb(a.j):GMb(a));case 34:_6b(a.f)||zMb(a,"msg.jsdoc.nocompile",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 33:$6b(a.f)||zMb(a,"msg.jsdoc.nocollapse",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 35:a7b(a.f)||zMb(a,"msg.jsdoc.noinline",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 37:return IMb(a,!a.o?mOb(a.j):GMb(a));case 25:case 38:e7b(a.f)||CMb(a,"msg.jsdoc.override",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):
GMb(a));case 41:$4b(a.f.a)?zMb(a,"msg.jsdoc.polymer.extra",a.j.g,lOb(a.j)):h7b(a.f);return IMb(a,!a.o?mOb(a.j):GMb(a));case 42:_4b(a.f.a)?zMb(a,"msg.jsdoc.polymerBehavior.extra",a.j.g,lOb(a.j)):i7b(a.f);return IMb(a,!a.o?mOb(a.j):GMb(a));case 7:V4b(a.f.a)?zMb(a,"msg.jsdoc.customElement.extra",a.j.g,lOb(a.j)):y6b(a.f);return IMb(a,!a.o?mOb(a.j):GMb(a));case 30:X4b(a.f.a)?zMb(a,"msg.jsdoc.mixinClass.extra",a.j.g,lOb(a.j)):W6b(a.f);return IMb(a,!a.o?mOb(a.j):GMb(a));case 31:Y4b(a.f.a)?zMb(a,"msg.jsdoc.mixinFunction.extra",
a.j.g,lOb(a.j)):X6b(a.f);return IMb(a,!a.o?mOb(a.j):GMb(a));case 54:{xNb(a);b=!a.o?mOb(a.j):GMb(a);u=a.j.g;i=lOb(a.j);jb=null;if(b==(fOb(),WNb)){jb=FMb(a,UMb(a,b,a.j.g,lOb(a.j),b==WNb,false));if(!jb)return IMb(a,!a.o?mOb(a.j):GMb(a))}b=GMb(a);r7b(a.f,jb);r=NMb(a,64);if(a.f.d&&!r){k=KMb(a,b,a.g?0:2,false);j=k.a;j.length>0&&q7b(a.f,jb,j);b=k.b}else b=IMb(a,!a.o?mOb(a.j):GMb(a));return b}case 40:xNb(a);b=!a.o?mOb(a.j):GMb(a);u=a.j.g;i=lOb(a.j);jb=null;o=false;if(b==(fOb(),WNb)){jb=FMb(a,(Kd(b==WNb),
sb=a.j.g,tb=lOb(a.j),ub=(Kd(b==WNb),xNb(a),vb=gNb(a,!a.o?mOb(a.j):GMb(a)),!!vb&&(OMb(a,aOb)?!a.o?mOb(a.j):GMb(a):(CMb(a,YRc,a.j.g,lOb(a.j)),null)),vb),uNb(a,sb,tb,ub,true),ub));if(!jb)return IMb(a,!a.o?mOb(a.j):GMb(a));xNb(a);b=!a.o?mOb(a.j):GMb(a);u=a.j.g;i=lOb(a.j);o=true}B=null;s=YNb==b;s&&(b=!a.o?mOb(a.j):GMb(a));if(eOb!=b)a.c.Bh(URc+occ("msg.missing.variable.name",CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),u,i);else{o||yMb(a,a.j.g,lOb(a.j));B=a.j.n;if(s){b=!a.o?mOb(a.j):
GMb(a);if(UNb==b){b=!a.o?mOb(a.j):GMb(a);eOb==b&&(b=!a.o?mOb(a.j):GMb(a))}cOb!=b?(CMb(a,"msg.jsdoc.missing.rb",a.j.g,lOb(a.j)),null):!!jb&&(jb=jb.a.n==(Afc(),ydc)||jb.a.n==sdc?jb:new H7b(new L9b(ydc,jb.a),jb.b))}G7b();if(F7b.test(B))f7b(a.f,B,jb)||(l6b(a.f,B)?a.c.Bh(URc+occ("msg.dup.variable.name",CE(xE(iW,1),mLc,1,5,[B]))+VRc,(P=H8b(a.n,(Hbc(),ybc)),!P?null:P.ug()),u,i):a.c.Bh(URc+occ(WRc,CE(xE(iW,1),mLc,1,5,[B]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),u,i));else{a.c.Bh(occ("msg.invalid.variable.name",
CE(xE(iW,1),mLc,1,5,[B])),(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),u,i);B=null}}if(B==null){b=IMb(a,b);return b}o6b(a.f,B,a.n,u,i);if(a.f.d&&b!=MNb){F=KMb(a,b,a.g?0:2,false);D=F.a;D.length>0&&g7b(a.f,B,D);b=F.b}else b!=RNb&&b!=SNb&&(b=IMb(a,!a.o?mOb(a.j):GMb(a)));return b;case 36:b7b(a.f)||zMb(a,"msg.jsdoc.nosideeffects",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 32:b=eNb(a,!a.o?mOb(a.j):GMb(a));return b;case 24:P6b(a.f)||CMb(a,"msg.jsdoc.implicitcast",a.j.g,lOb(a.j));return IMb(a,!a.o?
mOb(a.j):GMb(a));case 48:if(a.f.d){L=LMb(a);K=L.a;K.length==0?zMb(a,"msg.jsdoc.seemissing",a.j.g,lOb(a.j)):j6b(a.f,K);b=L.b}else b=IMb(a,!a.o?mOb(a.j):GMb(a));return b;case 49:l7b(a.f)||zMb(a,"msg.jsdoc.stableidgen",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 51:b=kNb(a,!a.o?mOb(a.j):GMb(a));return b;case 52:{db=a.j.g;bb=lOb(a.j);cb=KMb(a,b,1,false);fb=cb.a;ob="";t=false;pb=true;if(fb.indexOf(":=")!=-1){ib=fb.indexOf(":=");eb=fb.substr(0,ib);if(fb.indexOf("=:")!=-1){t=true;gb=fb.indexOf("=:");
ob=Ysc(fb.substr(ib+2,gb-(ib+2)))}else{pb=false;a.c.Bh(URc+occ("msg.jsdoc.typetransformation.missing.delimiter",CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),db,bb)}}else fb.indexOf(gMc)!=-1?eb=Vsc(fb,0,Hsc(fb,_sc(10))):eb=fb;C=Te(Ve(Ye(new nc(44)),(Hc(),Fc)),eb);if(C.b.Yd()==1&&C.a.ce(0).length==0)a.c.Bh(URc+occ("msg.jsdoc.templatemissing",CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),db,bb);else for(lb=new Wzc(C.b.Vd());lb.b.Id();){kb=lb.b.Jd();kb.length!=
0&&ac(new Cc((rc(),qc),new nc(95)),kb)?t||o7b(a.f,kb)||a.c.Bh(URc+occ(ZRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(P=H8b(a.n,(Hbc(),ybc)),!P?null:P.ug()),db,bb):a.c.Bh(URc+occ("msg.jsdoc.template.invalid.type.name",CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),db,bb)}if(t){C.b.Yd()>1&&a.c.Bh(URc+occ("msg.jsdoc.typetransformation.with.multiple.names",CE(xE(iW,1),mLc,1,5,[]))+VRc,(P=H8b(a.n,(Hbc(),ybc)),!P?null:P.ug()),db,bb);if(ob.length==0){pb=false;a.c.Bh(URc+occ("msg.jsdoc.typetransformation.expression.missing",
CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),db,bb)}if(pb){hb=new oPb(ob,H8b(a.n,(Hbc(),ybc)),a.c,db,bb);OOb(hb)&&!u7b(a.f,C.a.ce(0),hb.e)&&a.c.Bh(URc+occ(ZRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,ybc),!O?null:O.ug()),db,bb)}}b=cb.b;return b}case 22:b=cNb(a,!a.o?mOb(a.j):GMb(a));return b;case 60:z7b(a.f)||zMb(a,"msg.jsdoc.wizaction",a.j.g,lOb(a.j));return IMb(a,!a.o?mOb(a.j):GMb(a));case 13:{cb=LMb(a);C=Te(Ve(Ye(new nc(44)),(Hc(),Fc)),cb.a);C.a.Ud()||C.a.ce(0).length==0?
CMb(a,"msg.jsdoc.disposeparameter.missing",a.j.g,lOb(a.j)):E6b(a.f,C)||CMb(a,"msg.jsdoc.disposeparameter.error",a.j.g,lOb(a.j));b=cb.b;return b}case 59:rb=LMb(a);qb=rb.a;qb.length==0?zMb(a,"msg.jsdoc.versionmissing",a.j.g,lOb(a.j)):x7b(a.f,qb)||zMb(a,"msg.jsdoc.extraversion",a.j.g,lOb(a.j));b=rb.b;return b;case 5:case 20:case 9:case 17:case 47:case 39:case 44:case 45:case 46:case 53:case 55:case 56:u=a.j.g;i=lOb(a.j);mb=null;p=NMb(a,123);q=d==(TIb(),vIb)||d==AIb||d==BIb||d==CIb||d==PHb||d==bIb||d==
YHb;h=q||d==EIb;jb=null;d==EIb&&!p&&yMb(a,a.j.g,lOb(a.j));if(p||!h){xNb(a);b=!a.o?mOb(a.j):GMb(a);mb=UMb(a,b,a.j.g,lOb(a.j),b==(fOb(),WNb),false);d==KIb&&(mb=zNb(a,(Afc(),Qcc),mb));jb=!mb?null:new H7b(mb,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()))}n=!jb&&!h;if(!n){(!!jb&&q||d==MIb)&&!s7b(a.f,jb)&&a.c.Bh(URc+occ(WRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(P=H8b(a.n,(Hbc(),ybc)),!P?null:P.ug()),u,i);r=NMb(a,64);switch(d.f){case 5:w6b(a.f)||zMb(a,"msg.jsdoc.const",a.j.g,lOb(a.j));break;case 20:L6b(a.f)||CMb(a,"msg.jsdoc.final",
a.j.g,lOb(a.j));break;case 9:z6b(a.f,jb)||a.c.Bh(occ("msg.jsdoc.define",CE(xE(iW,1),mLc,1,5,[])),(U=H8b(a.n,(Hbc(),ybc)),!U?null:U.ug()),u,i);if(!r)return tNb(a,b);break;case 17:G6b(a.f)?y7b(a.f,(e6b(),d6b))||a.c.Bh(occ($Rc,CE(xE(iW,1),mLc,1,5,[])),(X=H8b(a.n,(Hbc(),ybc)),!X?null:X.ug()),u,i):a.c.Bh(occ("msg.jsdoc.export",CE(xE(iW,1),mLc,1,5,[])),(Y=H8b(a.n,(Hbc(),ybc)),!Y?null:Y.ug()),u,i);if(!r)return tNb(a,b);break;case 44:y7b(a.f,(e6b(),b6b))||a.c.Bh(occ($Rc,CE(xE(iW,1),mLc,1,5,[])),(Z=H8b(a.n,
(Hbc(),ybc)),!Z?null:Z.ug()),u,i);if(!r)return tNb(a,b);break;case 39:y7b(a.f,(e6b(),a6b))||a.c.Bh(occ($Rc,CE(xE(iW,1),mLc,1,5,[])),($=H8b(a.n,(Hbc(),ybc)),!$?null:$.ug()),u,i);if(!r)return tNb(a,b);break;case 45:y7b(a.f,(e6b(),c6b))||a.c.Bh(occ($Rc,CE(xE(iW,1),mLc,1,5,[])),(ab=H8b(a.n,(Hbc(),ybc)),!ab?null:ab.ug()),u,i);if(!r)return tNb(a,b);break;case 46:y7b(a.f,(e6b(),d6b))||a.c.Bh(occ($Rc,CE(xE(iW,1),mLc,1,5,[])),(R=H8b(a.n,(Hbc(),ybc)),!R?null:R.ug()),u,i);if(!r)return tNb(a,b);break;case 47:!jb&&
(jb=FMb(a,QMb(a,(Afc(),Pec))));if(!k7b(a.f,jb)){a.c.Bh(URc+occ(WRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(S=H8b(a.n,(Hbc(),ybc)),!S?null:S.ug()),u,i);break}if(a.f.d&&!r){N=KMb(a,b,a.g?0:2,false);M=N.a;M.length>0&&j7b(a.f,M);b=N.b}else b=IMb(a,!a.o?mOb(a.j):GMb(a));return b;case 53:p7b(a.f,jb)||a.c.Bh(URc+occ(WRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(T=H8b(a.n,(Hbc(),ybc)),!T?null:T.ug()),u,i);break;case 56:v7b(a.f,jb)||a.c.Bh(URc+occ(WRc,CE(xE(iW,1),mLc,1,5,[]))+VRc,(O=H8b(a.n,(Hbc(),ybc)),!O?null:O.ug()),u,i)}}return IMb(a,
!a.o?mOb(a.j):GMb(a))}}return!a.o?mOb(a.j):GMb(a)}function q4(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,A,B,C,D,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,$,ab,bb,cb,db,eb,fb,gb;if(a.i&&!!H8b(b,(Hbc(),mbc))){G=Bmb(a.e,H8b(b,(Hbc(),mbc)));Esc(G,"/** */ ")||L3(a.c,G)}cb=b.n;N=$qb(cb);p=C8b(b);t=b.c;H=b.c?b.c.i:null;if(N!=null&&t!=H){be(p==2,N,p);O=H4(a,b);Y=c.b?c:(_4(),W4);K=(c==(_4(),Z4)||c.a)&&t.n==(Afc(),Fec);b.n==(Afc(),Ccc)&&K&&L3(a.c,"(");if(aqb(b)||cb==zdc){v4(a,t,O+1,c);N3(a.c,N,true);
v4(a,H,O,Y)}else K4(a,b,cb,N,c,Y,O,O+1);b.n==Ccc&&K&&L3(a.c,")");return}a.c.eh(b);switch(cb.f){case 44:{Xd(t.f.n==(Afc(),Vcc)&&!N8b(t.f));Xd(p>=2&&p<=3);L3(a.c,"try");a.fh(t,(_4(),W4));n=t.f.c;!!n&&a.fh(n,W4);if(p==3){a.c.$g();L3(a.c,DNc);a.fh(H,W4)}break}case 78:Yd(p==2,b);a.c.$g();L3(a.c,"catch");a.c.$g();if(t.n!=(Afc(),tdc)){L3(a.c,"(");a.fh(t,(_4(),W4));L3(a.c,")")}a.fh(H,(_4(),W4));break;case 39:Yd(p==1,b);L3(a.c,"throw");a.c.$g();a.fh(t,(_4(),W4));a.c.Wg(true);break;case 0:L3(a.c,ENc);if(p==
1){a.c.$g();if(a.i&&!!H8b(t,(Hbc(),mbc))){L3(a.c,"(");a.fh(t,(_4(),W4));L3(a.c,")")}else a.fh(t,(_4(),W4))}else Yd(p==0,b);a.c.Wg(false);break;case 76:L3(a.c,"var ");z4(a,t,false,c.b?c:(_4(),W4),",");(!b.g||(ppb(),b.n!=(Afc(),pec)&&Jqb(b.g)))&&a.c.Wg(false);break;case 88:L3(a.c,"const ");z4(a,t,false,c.b?c:(_4(),W4),",");(!b.g||(ppb(),b.n!=(Afc(),pec)&&Jqb(b.g)))&&a.c.Wg(false);break;case 100:L3(a.c,"let ");z4(a,t,false,c.b?c:(_4(),W4),",");(!b.g||(ppb(),b.n!=(Afc(),pec)&&Jqb(b.g)))&&a.c.Wg(false);
break;case 90:Yd(b.Wh().length!=0,b);x4(a,b.Wh());break;case 95:a.fh(t,(_4(),W4));if(t!=H){Yd(p==2,b);N3(a.c,"=",true);a.fh(H,W4)}break;case 29:a.n&&H8b(b,(Hbc(),sbc))!=null?x4(a,H8b(b,(Hbc(),sbc))):x4(a,b.Wh());E8b(b,(n8b(),f8b))!=0&&L3(a.c,"?");G4(a,b);if(!!t&&t.n!=(Afc(),tdc)){Yd(p==1,b);N3(a.c,"=",true);t.n==(Afc(),edc)||t.n==_cc&&t.c.n==edc?v4(a,t,arb(Ccc),(_4(),W4)):v4(a,t,0,c.b?c:(_4(),W4))}break;case 42:L3(a.c,"[");t4(a,t);L3(a.c,"]");break;case 93:L3(a.c,"[");t4(a,t);L3(a.c,"]");G4(a,b);
break;case 45:if(Q8b(b.g)&&!!b.c&&!b.c.f&&t.n==(Afc(),rec)&&!lQb(a.f,(IRb(),GRb)))a.fh(t,(_4(),W4));else{L3(a.c,"(");z4(a,t,true,(_4(),W4),",");L3(a.c,")")}break;case 121:a.fh(t,(_4(),W4));G4(a,b);N3(a.c,"=",true);v4(a,t.f,1,W4);break;case 46:Yd(p==2,b);K4(a,b,(Afc(),edc),",",c,c.b?c:(_4(),W4),0,0);break;case 30:Yd(p==0,b);a.c.Kg(b.Uh(),b);break;case 25:case 79:case 19:case 20:case 21:{Yd(p==1,b);N3(a.c,_qb(cb),false);v4(a,t,arb(cb),(_4(),W4));break}case 22:{Yd(p==1,b);if(b.c.n==(Afc(),Cec))a.c.Kg(-b.c.Uh(),
b.c);else{N3(a.c,_qb(cb),false);v4(a,t,arb(cb),(_4(),W4))}break}case 60:{Yd(p==3,b);O=arb(cb);Y=c.b?c:(_4(),W4);v4(a,t,O+1,c);N3(a.c,"?",true);v4(a,t.f,1,Y);N3(a.c,":",true);v4(a,H,1,Y);break}case 38:if(t.n!=(Afc(),bfc)||H.n!=bfc)throw gZ(new Hqc("Expected children to be strings"));W="/"+J4(a,t.Wh(),'"',"'","\\",false,true)+"/";if(p==2)r4(a,W+H.Wh());else{Yd(p==1,b);L3(a.c,W)}break;case 65:{if(b.Fj!=HU)throw gZ(new Hqc(FNc));Yd(p==3,b);b.n==(Afc(),Jdc)&&E8b(b,(Hbc(),Fac))!=0?(Yd(t.Wh().length==0,
t),db=(eb=b.g,!!eb&&(ppb(),bqb(eb.n)||Mqb(eb.n)||Oqb(eb.n)||eb.n==hfc||eb.n==Pdc||(eb.n==Odc||eb.n==Ycc||eb.n==Sdc)&&(fb=b.g,!!fb&&b==fb.c))),db&&L3(a.c,"("),gb=H8b(t,(n8b(),Y7b)),!!gb&&a.fh(gb,(_4(),W4)),b.n==Jdc&&E8b(b,(Hbc(),Gac))!=0&&L3(a.c,GNc),a.fh(t.f,(_4(),W4)),G4(a,b),N3(a.c,"=>",true),H.n==Vcc?a.fh(H,W4):v4(a,H,arb(edc)+1,c.b?Y4:X4),a.c.Tg(c==$4),db&&L3(a.c,")"),undefined):w4(a,b,t,H,c);break}case 114:L3(a.c,HNc);a.fh(t,(_4(),W4));G4(a,b);break;case 115:L3(a.c,HNc);a.fh(b.c,(_4(),W4));break;
case 109:L3(a.c,INc);E8b(b,(n8b(),U7b))!=0&&L3(a.c,JNc);if(E8b(b,T7b)!=0){L3(a.c,"*");Yd(!!t&&t.n==(Afc(),tdc),b)}else a.fh(t,(_4(),W4));if(p==2){L3(a.c,KNc);a.fh(H,(_4(),W4))}I4(a,t,c);break;case 105:L3(a.c,LNc);Z=t.f;if(t.n!=(Afc(),tdc)){a.fh(t,(_4(),W4));Z.n==tdc||a.c.Yg()}Z.n==tdc||a.fh(Z,(_4(),W4));(t.n!=tdc||Z.n!=tdc)&&L3(a.c,KNc);a.fh(H,(_4(),W4));a.c.Wg(false);break;case 110:case 106:L3(a.c,"{");for(j=t;j;j=j.f){j!=t&&a.c.Yg();a.fh(j,(_4(),W4))}L3(a.c,"}");break;case 111:case 107:a.fh(t,(_4(),
W4));if(E8b(b,(Hbc(),kbc))!=0&&Esc(t.Wh(),H.Wh()))break;L3(a.c,"as");a.fh(H,W4);break;case 108:L3(a.c,"*");L3(a.c,"as");r4(a,b.Wh());break;case 113:L3(a.c,"import(");v4(a,t,arb(cb),c);L3(a.c,")");break;case 96:{Yd(p==3,b);q=c==(_4(),Z4);q&&L3(a.c,"(");J=t;$=t.f;I=H;L3(a.c,MNc);J.n==(Afc(),tdc)||a.fh(J,W4);A=H8b(t,(n8b(),Y7b));!!A&&a.fh(A,W4);if($.n!=tdc){L3(a.c,NNc);a.fh($,W4)}D=H8b(b,$7b);if(D){L3(a.c,ONc);o=D.c;a.fh(o,W4);while(o=o.f){L3(a.c,",");a.c.$g();a.fh(o,W4)}}a.fh(I,W4);S3(a.c,c==$4);q&&
L3(a.c,")")}break;case 97:case 153:case 163:O3(a.c);for(k=t;k;k=k.f){a.fh(k,(_4(),W4));I4(a,k,c);a.c.Ug()}R3(a.c,false);break;case 155:O3(a.c);for(l=t;l;l=l.f){a.fh(l,(_4(),W4));!!l.f&&L3(a.c,",");a.c.Ug()}R3(a.c,false);break;case 86:case 87:case 98:case 159:{Xd(b.g.n==(Afc(),Eec)||b.g.n==cdc||b.g.n==dec||b.g.n==Qec||b.g.n==_dc);e=H8b(b,(n8b(),L7b));!!e&&r4(a,(e.e!=null?e.e:""+e.f).toLowerCase()+" ");E8b(b,(Hbc(),zbc))!=0&&L3(a.c,"static ");b.n==mec&&R8b(b.c)&&L3(a.c,"async ");if(b.n!=nec&&E8b(b.c,
Xac)!=0){Yd(cb==mec,b);L3(a.c,"*")}switch(cb.f){case 86:Yd(!t.c.f.c,b);L3(a.c,"get ");break;case 87:Yd(O8b(t.c.f),b);L3(a.c,"set ")}J=b.Wh();if(b.n==nec){r4(a,b.Wh());E8b(b,f8b)!=0&&L3(a.c,"?");G4(a,b)}else{Yd(p==1,b);Yd(t.n==Jdc,t);Yd(t.c.Wh().length==0,t);u=t;P=u.c.f;h=u.c?u.c.i:null;if(!b.Yh()&&(G7b(),F7b.test(J))&&wqb(J)){L3(a.c,J);F4(a,u.c)}else{r=Q4(J);isNaN(r)?y4(a,b):a.c.Kg(r,b)}E8b(u,f8b)!=0&&L3(a.c,"?");a.fh(P,(_4(),W4));G4(a,u);a.fh(h,W4)}break}case 85:case 112:case 82:case 81:{if(b.Fj!=
HU)throw gZ(new Hqc(FNc));V=b.n==(Afc(),Vcc)&&E8b(b,(Hbc(),Abc))==0;V&&O3(a.c);U=cb==Xec||cb==Vcc&&!V&&b.g.n==Xec;for(m=t;m;m=m.f){a.fh(m,(_4(),$4));(m.n==Jdc||m.n==bdc)&&a.c._g();U&&a.c.ah()}V&&R3(a.c,a.c.Qg(b,c==(_4(),$4)));break}case 72:Yd(p==4,b);L3(a.c,"for");a.c.$g();L3(a.c,"(");ppb();!!t&&(t.n==(Afc(),ufc)||t.n==jec||t.n==gdc)?a.fh(t,(_4(),V4)):v4(a,t,0,(_4(),V4));L3(a.c,";");t.f.n==(Afc(),tdc)||a.c.$g();a.fh(t.f,(_4(),W4));L3(a.c,";");t.f.f.n==tdc||a.c.$g();a.fh(t.f.f,W4);L3(a.c,")");A4(a,
H,c==U4?U4:W4,false);break;case 73:Yd(p==3,b);L3(a.c,"for");a.c.$g();L3(a.c,"(");a.fh(t,(_4(),W4));L3(a.c,"in");a.fh(t.f,W4);L3(a.c,")");A4(a,H,c==U4?U4:W4,false);break;case 101:Yd(p==3,b);L3(a.c,"for");a.c.$g();L3(a.c,"(");a.fh(t,(_4(),W4));a.c.$g();L3(a.c,"of");a.c.$g();a.fh(t.f,W4);L3(a.c,")");A4(a,H,c==U4?U4:W4,false);break;case 102:Yd(p==3,b);L3(a.c,"for await");a.c.$g();L3(a.c,"(");a.fh(t,(_4(),W4));a.c.$g();L3(a.c,"of");a.c.$g();a.fh(t.f,W4);L3(a.c,")");A4(a,H,c==U4?U4:W4,false);break;case 71:Yd(p==
2,b);L3(a.c,"do");A4(a,t,(_4(),W4),false);a.c.$g();L3(a.c,PNc);a.c.$g();L3(a.c,"(");a.fh(H,W4);L3(a.c,")");a.c.Wg(false);break;case 70:Yd(p==2,b);L3(a.c,PNc);a.c.$g();L3(a.c,"(");a.fh(t,(_4(),W4));L3(a.c,")");A4(a,H,c==U4?U4:W4,false);break;case 80:Yd(p==0,b);break;case 26:{if(a.n&&H8b(b,(Hbc(),sbc))!=null){_8b(b.c,"$jscomp.scope")&&b.g.n==(Afc(),Ccc)&&L3(a.c,"var ");x4(a,H8b(b,(Hbc(),sbc)));break}Zd(p==2,"Bad GETPROP: expected 2 children, but got %s",p);Yd(H.n==(Afc(),bfc),"Bad GETPROP: RHS should be STRING");
K=t.n==Cec;K&&L3(a.c,"(");v4(a,t,arb(cb),c);K&&L3(a.c,")");if(a.j&&Efc(H.Wh())){L3(a.c,"[");a.fh(H,(_4(),W4));L3(a.c,"]")}else{L3(a.c,".");x4(a,H.Wh())}break}case 27:_d(p==2,p,b);v4(a,t,arb(cb),c);L3(a.c,"[");a.fh(t.f,(_4(),W4));L3(a.c,"]");break;case 77:Yd(p==2,b);L3(a.c,"with(");a.fh(t,(_4(),W4));L3(a.c,")");A4(a,H,c==U4?U4:W4,false);break;case 63:case 64:{Yd(p==1,b);M=cb==(Afc(),$dc)?"++":"--";R=E8b(b,(n8b(),_7b))!=0;if(R){v4(a,t,arb(cb),c);N3(a.c,M,false)}else{N3(a.c,M,false);a.fh(t,(_4(),W4))}break}case 28:if(t.n==
(Afc(),rec)&&Esc("eval",t.Wh())&&E8b(t,(n8b(),R7b))==0||E8b(b,(n8b(),W7b))!=0&&(ppb(),t.n==Pdc||t.n==Odc)){L3(a.c,"(0,");v4(a,t,arb(edc),(_4(),W4));L3(a.c,")")}else v4(a,t,arb(cb),c);g=t.f;L3(a.c,"(");z4(a,g,true,(_4(),W4),",");L3(a.c,")");break;case 66:Yd(p==2||p==3,b);B=p==3;f=c==(_4(),U4)&&!B;f&&O3(a.c);L3(a.c,"if");a.c.$g();L3(a.c,"(");a.fh(t,W4);L3(a.c,")");if(B){A4(a,t.f,U4,false);a.c.$g();L3(a.c,"else");A4(a,H,c==U4?U4:W4,false)}else A4(a,t.f,W4,false);f&&R3(a.c,false);break;case 32:Yd(p==
0,b);L3(a.c,jLc);break;case 33:Yd(p==0,b);L3(a.c,FMc);break;case 99:Yd(p==0,b);L3(a.c,DMc);break;case 122:Yd(p==0,b);L3(a.c,QNc);break;case 103:L3(a.c,RNc);if(E8b(b,(Hbc(),Gbc))!=0){Sd(t);L3(a.c,"*")}if(t){a.c.$g();v4(a,t,arb(cb),(_4(),W4))}break;case 104:L3(a.c,"await ");v4(a,t,arb(cb),(_4(),W4));break;case 34:Yd(p==0,b);L3(a.c,SNc);break;case 35:Yd(p==0,b);L3(a.c,TNc);break;case 75:Yd(p<=1,b);L3(a.c,UNc);if(p==1){if(t.n!=(Afc(),fec))throw gZ(new Hqc(VNc));L3(a.c," ");a.fh(t,(_4(),W4))}a.c.Wg(false);
break;case 89:Yd(p==0,b);L3(a.c,WNc);a.c.Wg(false);break;case 74:Yd(p<=1,b);L3(a.c,"break");if(p==1){if(t.n!=(Afc(),fec))throw gZ(new Hqc(VNc));L3(a.c," ");a.fh(t,(_4(),W4))}a.c.Wg(false);break;case 84:Yd(p==1,b);a.fh(t,(_4(),Z4));a.c.Wg(false);break;case 23:L3(a.c,"new ");S=arb(cb);T=arb(t.n);T==S&&(S=S+1);wpb(t,(Afc(),Ycc),(ppb(),kpb))&&(S=arb(t.n)+1);v4(a,t,S,(_4(),W4));L=t.f;if(L){L3(a.c,"(");z4(a,L,true,W4,",");L3(a.c,")")}break;case 91:C4(a,b);break;case 31:ae(p==0,"String node %s may not have children",
b);y4(a,b);break;case 24:Yd(p==1,b);L3(a.c,"delete ");a.fh(t,(_4(),W4));break;case 43:{K=c==(_4(),Z4)||c.a;K&&L3(a.c,"(");L3(a.c,"{");for(m=t;m;m=m.f){m!=t&&a.c.Yg();Yd((ppb(),m.n==(Afc(),cfc)||m.n==Qdc||m.n==Yec||m.n==mec||m.n==fdc||m.n==_ec),m);a.fh(m,W4)}L3(a.c,"}");K&&L3(a.c,")");break}case 116:d=H8b(b,(n8b(),L7b));!!d&&r4(a,(d.e!=null?d.e:""+d.f).toLowerCase()+" ");E8b(b,k8b)!=0&&L3(a.c,"static ");if(E8b(b,M7b)!=0)L3(a.c,"get ");else if(E8b(b,O7b)!=0)L3(a.c,"set ");else{H.n==(Afc(),Jdc)&&E8b(H,
(Hbc(),Gac))!=0&&L3(a.c,GNc);E8b(H,X7b)!=0&&L3(a.c,"*")}L3(a.c,"[");a.fh(t,(_4(),W4));L3(a.c,"]");G4(a,b);if(E8b(b,N7b)!=0||E8b(b,M7b)!=0||E8b(b,O7b)!=0){v=t.f;Q=v.c.f;h=v.c?v.c.i:null;a.fh(Q,W4);a.fh(h,W4)}else{F=b.g.n==(Afc(),cdc);C=t.f;if(C){Yd(!F,"initializers should only exist in object literals, not classes");N3(a.c,":",false);a.fh(C,W4)}else Yd(E8b(b,P7b)!=0,b)}break;case 94:B4(a,b);G4(a,b);break;case 67:L3(a.c,"switch(");a.fh(t,(_4(),W4));L3(a.c,")");O3(a.c);s4(a,t.f);R3(a.c,c==$4);break;
case 68:Yd(p==2,b);L3(a.c,"case ");a.fh(t,(_4(),W4));u4(a,H);break;case 69:Yd(p==1,b);L3(a.c,JNc);u4(a,t);break;case 83:Yd(p==2,b);if(t.n!=(Afc(),fec))throw gZ(new Hqc(VNc));a.fh(t,(_4(),W4));L3(a.c,":");H.n==Vcc||a.c.$g();A4(a,H,c==U4?U4:W4,true);break;case 92:if(a.i){L3(a.c,"(");a.fh(t,(_4(),W4));L3(a.c,")")}else a.fh(t,c);break;case 117:a.fh(t,(_4(),Z4));a.fh(t.f,W4);break;case 118:P3(a.c);for(i=t;i;i=i.f)if(i.n==(Afc(),jfc))r4(a,D4(i.Vh()));else{Q3(a.c);a.fh(i.c,(_4(),Z4));U3(a.c)}T3(a.c);break;
case 123:L3(a.c,$Kc);break;case 124:L3(a.c,XKc);break;case 125:L3(a.c,YKc);break;case 129:L3(a.c,"any");break;case 131:L3(a.c,XNc);break;case 133:a.fh(t,(_4(),W4));break;case 137:v4(a,t,arb((Afc(),Bcc)),c);L3(a.c,"[]");break;case 126:X=t;L3(a.c,"(");z4(a,t.f,true,(_4(),W4),",");L3(a.c,")");N3(a.c,"=>",true);a.fh(X,W4);break;case 128:z4(a,t,true,(_4(),W4),"|");break;case 135:L3(a.c,"{");z4(a,t,false,(_4(),W4),",");L3(a.c,"}");break;case 127:a.fh(t,(_4(),W4));L3(a.c,"<");z4(a,t.f,true,W4,",");L3(a.c,
">");break;case 139:L3(a.c,"<");z4(a,t,false,(_4(),$4),",");L3(a.c,">");break;case 138:x4(a,b.Wh());if(b.c){L3(a.c,NNc);a.c.$g();a.fh(b.c,(_4(),W4))}break;case 151:{Yd(p==3,b);J=t;bb=t.f;I=H;L3(a.c,YNc);a.fh(J,(_4(),W4));A=H8b(J,(n8b(),Y7b));!!A&&a.fh(A,W4);if(bb.n!=(Afc(),tdc)){L3(a.c,NNc);ab=bb.c;a.fh(ab,W4);while(ab=ab.f){L3(a.c,",");a.c.$g();a.fh(ab,W4)}}a.fh(I,W4)}break;case 154:{Yd(p==2,b);J=t;I=H;L3(a.c,ZNc);a.fh(J,(_4(),W4));a.fh(I,W4);break}case 162:{Yd(p==2,b);J=t;s=H;L3(a.c,"namespace");
a.fh(J,(_4(),W4));a.fh(s,W4);break}case 157:L3(a.c,$Nc);r4(a,b.Wh());N3(a.c,"=",true);a.fh(H,(_4(),W4));a.c.Wg(true);break;case 158:L3(a.c,"declare");a.fh(t,(_4(),W4));I4(a,b,c);break;case 160:L3(a.c,"[");a.fh(t,(_4(),W4));L3(a.c,"]");G4(a,b);a.c.Wg(true);break;case 161:E8b(b,(n8b(),Q7b))!=0&&L3(a.c,"new ");w=H8b(b,Y7b);!!w&&a.fh(w,(_4(),W4));a.fh(t,(_4(),W4));G4(a,b);a.c.Wg(true);break;default:throw gZ(new GD("Unknown token "+cb+gMc+E9b(b)));}a.c.Vg(b)}function $2b(){var a;a=new stc;a.a+='{"externs/es3.js":"/*\\n * Copyright 2008 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview ECMAScript 3 Built-Ins. This include common extensions so this\\n * is actually ES3+Reality.\\n * @externs\\n * @author acleung@google.com (Alan Leung)\\n * @author stevey@google.com (Steve Yegge)\\n * @author nicksantos@google.com (Nick Santos)\\n * @author arv@google.com (Erik Arvidsson)\\n * @author johnlenz@google.com (John Lenz)\\n */\\n\\n\\n// START ES6 RETROFIT CODE\\n// symbol, Symbol and Symbol.iterator are actually ES6 types but some\\n// base types require them to be part of their definition (such as Array).\\n\\n\\n/**\\n * @constructor\\n * @param {*=} opt_description\\n * @return {symbol}\\n */\\nfunction Symbol(opt_description) {}\\n\\n\\n/**\\n * @const {string|undefined}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/description\\n */\\nSymbol.prototype.description;\\n\\n\\n/**\\n * @param {string} sym\\n * @return {symbol|undefined}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/for\\n */\\nSymbol.for;\\n\\n\\n/**\\n * @param {symbol} sym\\n * @return {string|undefined}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/keyFor\\n */\\nSymbol.keyFor;\\n\\n\\n// Well known symbols\\n\\n/** @const {symbol} */\\nSymbol.iterator;\\n\\n/** @const {symbol} */\\nSymbol.toStringTag;\\n\\n/** @const {symbol} */\\nSymbol.unscopables;\\n\\n\\n/**\\n * @record\\n * @template VALUE\\n */\\nfunction IIterableResult() {};\\n\\n/** @type {boolean} */\\nIIterableResult.prototype.done;\\n\\n/** @type {VALUE} */\\nIIterableResult.prototype.value;\\n\\n\\n\\n/**\\n * @interface\\n * @template VALUE\\n */\\nfunction Iterable() {}\\n\\n// TODO(johnlenz): remove the suppression when the compiler understands\\n// \\"symbol\\" natively\\n/**\\n * @return {!Iterator<VALUE>}\\n * @suppress {externsValidation}\\n */\\nIterable.prototype[Symbol.iterator] = function() {};\\n\\n\\n\\n/**\\n * @interface\\n * @template VALUE\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/The_Iterator_protocol\\n */\\nfunction Iterator() {}\\n\\n/**\\n * @param {?=} opt_value\\n * @return {!IIterableResult<VALUE>}\\n */\\nIterator.prototype.next;\\n\\n\\n/**\\n * Use this to indicate a type is both an Iterator and an Iterable.\\n * @interface\\n * @extends {Iterator<T>}\\n * @extends {Iterable<T>}\\n * @template T\\n */\\nfunction IteratorIterable() {}\\n\\n// END ES6 RETROFIT CODE\\n\\n\\n/**\\n * @interface\\n * @template KEY1, VALUE1\\n */\\nfunction IObject() {}\\n\\n/**\\n * @record\\n * @extends {IObject<number, VALUE2>}\\n * @template VALUE2\\n */\\nfunction IArrayLike() {}\\n\\n/** @type {number} */\\nIArrayLike.prototype.length;\\n\\n/**\\n * @constructor\\n * @implements {IArrayLike<T>}\\n * @implements {Iterable<?>}\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions_and_function_scope/arguments\\n */\\nfunction Arguments() {}\\n\\n/**\\n * @type {Function}\\n * @see http://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Functions_and_function_scope/arguments/callee\\n */\\nArguments.prototype.callee;\\n\\n/**\\n * Use the non-standard {@see Function.prototype.caller} property of a function\\n * object instead.\\n * @type {Function}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments/caller\\n * @deprecated\\n */\\nArguments.prototype.caller;\\n\\n/**\\n * @type {number}\\n * @see http://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Functions_and_function_scope/arguments/length\\n */\\nArguments.prototype.length;\\n\\n/**\\n * Not actually a global variable, when running in a browser environment. But\\n * we need it in order for the type checker to typecheck the \\"arguments\\"\\n * variable in a function correctly.\\n *\\n * TODO(tbreisacher): There should be a separate \'arguments\' variable of type\\n * `Array<string>`, in the d8 externs.\\n *\\n * @type {!Arguments}\\n * @see http://developer.mozilla.org/en/Core_JavaScript_1.5_Reference/Functions_and_function_scope/arguments\\n */\\nvar arguments;\\n\\n/**\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Infinity\\n * @const\\n */\\nvar Infinity;\\n\\n/**\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/NaN\\n * @const\\n */\\nvar NaN;\\n\\n/**\\n * @type {undefined}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined\\n * @const\\n */\\nvar undefined;\\n\\n/**\\n * @param {string} uri\\n * @return {string}\\n * @throws {URIError} when used wrongly.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURI\\n */\\nfunction decodeURI(uri) {}\\n\\n/**\\n * @param {string} uri\\n * @return {string}\\n * @throws {URIError} when used wrongly.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/decodeURIComponent\\n */\\nfunction decodeURIComponent(uri) {}\\n\\n/**\\n * @param {string} uri\\n * @return {string}\\n * @throws {URIError} if one attempts to encode a surrogate which is not part of\\n * a high-low pair.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURI\\n */\\nfunction encodeURI(uri) {}\\n\\n/**\\n * @param {string} uri\\n * @return {string}\\n * @throws {URIError} if one attempts to encode a surrogate which is not part of\\n * a high-low pair.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent\\n */\\nfunction encodeURIComponent(uri) {}\\n\\n/**\\n * Should only be used in browsers where encode/decodeURIComponent\\n * are not present, as the latter handle fancy Unicode characters.\\n * @param {string} str\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/Core_JavaScript_1.5_Guide/Predefined_Functions/escape_and_unescape_Functions\\n */\\nfunction escape(str) {}\\n\\n/**\\n * Should only be used in browsers where encode/decodeURIComponent\\n * are not present, as the latter handle fancy Unicode characters.\\n * @param {string} str\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/Core_JavaScript_1.5_Guide/Predefined_Functions/escape_and_unescape_Functions\\n */\\nfunction unescape(str) {}\\n\\n/**\\n * @param {*} num\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isFinite\\n */\\nfunction isFinite(num) {}\\n\\n/**\\n * @param {*} num\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/isNaN\\n */\\nfunction isNaN(num) {}\\n\\n/**\\n * @param {*} num\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseFloat\\n */\\nfunction parseFloat(num) {}\\n\\n/**\\n * Parse an integer. Use of `parseInt` without `base` is strictly\\n * banned in Google. If you really want to parse octal or hex based on the\\n * leader, then pass `undefined` as the base.\\n *\\n * @param {*} num\\n * @param {number|undefined} base\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/parseInt\\n */\\nfunction parseInt(num, base) {}\\n\\n/**\\n * @param {string} code\\n * @return {*}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/eval\\n */\\nfunction eval(code) {}\\n\\n\\n\\n/**\\n * @constructor\\n * @param {*=} opt_value\\n * @return {!Object}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object\\n */\\nfunction Object(opt_value) {}\\n\\n/**\\n * The constructor of the current object.\\n * @type {Function}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/constructor\\n */\\nObject.prototype.constructor = function() {};\\n\\n/**\\n * Binds an object\'s property to a function to be called when that property is\\n * looked up.\\n * Mozilla-only.\\n *\\n * @param {string} sprop\\n * @param {Function} fun\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineGetter\\n * @return {undefined}\\n */\\nObject.prototype.__defineGetter__ = function(sprop, fun) {};\\n\\n/**\\n * Binds an object\'s property to a function to be called when an attempt is made\\n * to set that property.\\n * Mozilla-only.\\n *\\n * @param {string} sprop\\n * @param {Function} fun\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/defineSetter\\n * @return {undefined}\\n */\\nObject.prototype.__defineSetter__ = function(sprop, fun) {};\\n\\n/**\\n * Returns whether the object has a property with the specified name.\\n *\\n * @param {*} propertyName Implicitly cast to a string.\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/hasOwnProperty\\n */\\nObject.prototype.hasOwnProperty = function(propertyName) {};\\n\\n/**\\n * Returns whether an object exists in another object\'s prototype chain.\\n *\\n * @param {Object} other\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/isPrototypeOf\\n */\\nObject.prototype.isPrototypeOf = function(other) {};\\n\\n/**\\n * Return the function bound as a getter to the specified property.\\n * Mozilla-only.\\n *\\n * @param {string} sprop a string containing the name of the property whose\\n * getter should be returned\\n * @return {Function}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/lookupGetter\\n */\\nObject.prototype.__lookupGetter__ = function(sprop) {};\\n\\n/**\\n * Return the function bound as a setter to the specified property.\\n * Mozilla-only.\\n *\\n * @param {string} sprop a string containing the name of the property whose\\n *     setter should be returned.\\n * @return {Function}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/lookupSetter\\n */\\nObject.prototype.__lookupSetter__ = function(sprop) {};\\n\\n/**\\n * Executes a function when a non-existent method is called on an object.\\n * Mozilla-only.\\n *\\n * @param {Function} fun\\n * @return {*}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/noSuchMethod\\n */\\nObject.prototype.__noSuchMethod__ = function(fun) {};\\n\\n/**\\n * Points to an object\'s context.  For top-level objects, this is the e.g. window.\\n * Mozilla-only.\\n *\\n * @type {Object}\\n * @deprecated\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/parent\\n */\\nObject.prototype.__parent__;\\n\\n/**\\n * Points to the object which was used as prototype when the object was instantiated.\\n * Mozilla-only.\\n *\\n * Will be null on Object.prototype.\\n *\\n * @type {Object}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/proto\\n */\\nObject.prototype.__proto__;\\n\\n/**\\n * Determine whether the specified property in an object can be enumerated by a\\n * for..in loop, with the exception of properties inherited through the\\n * prototype chain.\\n *\\n * @param {string} propertyName\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/propertyIsEnumerable\\n */\\nObject.prototype.propertyIsEnumerable = function(propertyName) {};\\n\\n/**\\n * Returns a localized string representing the object.\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toLocaleString\\n */\\nObject.prototype.toLocaleString = function() {};\\n\\n/**\\n * Returns a string representing the source code of the object.\\n * Mozilla-only.\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toSource\\n */\\nObject.prototype.toSource = function() {};\\n\\n/**\\n * Returns a string representing the object.\\n * @this {*}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/toString\\n */\\nObject.prototype.toString = function() {};\\n\\n/**\\n * Returns the object\'s `this` value.\\n * @return {*}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/valueOf\\n */\\nObject.prototype.valueOf = function() {};\\n\\n/**\\n * @constructor\\n * @param {...*} var_args\\n * @throws {Error}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function\\n */\\nfunction Function(var_args) {}\\n\\n/**\\n * @param {...*} var_args\\n * @return {*}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/call\\n */\\nFunction.prototype.call = function(var_args) {};\\n\\n/**\\n * @param {...*} var_args\\n * @return {*}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/apply\\n */\\nFunction.prototype.apply = function(var_args) {};\\n\\nFunction.prototype.arguments;\\n\\n/**\\n * @type {number}\\n * @deprecated\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/arity\\n */\\nFunction.prototype.arity;\\n\\n/**\\n * Nonstandard; Mozilla and JScript only.\\n * @type {Function}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/caller\\n */\\nFunction.prototype.caller;\\n\\n/**\\n * Nonstandard.\\n * @type {?}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/displayName\\n */\\nFunction.prototype.displayName;\\n\\n/**\\n * Expected number of arguments.\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/length\\n */\\nFunction.prototype.length;\\n\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/name\\n */\\nFunction.prototype.name;\\n\\n/**\\n * @this {Function}\\n * @return {string}\\n * @nosideeffects\\n * @override\\n */\\nFunction.prototype.toString = function() {};\\n\\n\\n/**\\n * @constructor\\n * @implements {IArrayLike<T>}\\n * @implements {Iterable<T>}\\n * @param {...*} var_args\\n * @return {!Array<?>}\\n * @nosideeffects\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array\\n */\\nfunction Array(var_args) {}\\n\\n/**\\n * @return {Iterator<T>}\\n * @suppress {externsValidation}\\n */\\nArray.prototype[Symbol.iterator] = function() {};\\n\\n// Functions:\\n\\n/**\\n * Returns a new array comprised of this array joined with other array(s)\\n * and/or value(s).\\n *\\n * @param {...*} var_args\\n * @return {!Array<?>}\\n * @this {*}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/concat\\n */\\nArray.prototype.concat = function(var_args) {};\\n\\n/**\\n * Joins all elements of an array into a string.\\n *\\n * @param {*=} opt_separator Specifies a string to separate each element of the\\n *     array. The separator is converted to a string if necessary. If omitted,\\n *     the array elements are separated with a comma.\\n * @return {string}\\n * @this {IArrayLike<?>|string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/join\\n */\\nArray.prototype.join = function(opt_separator) {};\\n\\n/**\\n * Removes the last element from an array and returns that element.\\n *\\n * @return {T}\\n * @this {IArra';
a.a+='yLike<T>}\\n * @modifies {this}\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/pop\\n */\\nArray.prototype.pop = function() {};\\n\\n// TODO(bradfordcsmith): remove \\"undefined\\" from the var_args of push\\n/**\\n * Mutates an array by appending the given elements and returning the new\\n * length of the array.\\n *\\n * @param {...(T|undefined)} var_args\\n * @return {number} The new length of the array.\\n * @this {IArrayLike<T>}\\n * @template T\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/push\\n */\\nArray.prototype.push = function(var_args) {};\\n\\n/**\\n * Transposes the elements of an array in place: the first array element becomes the\\n * last and the last becomes the first. The mutated array is also returned.\\n *\\n * @return {THIS} A reference to the original modified array.\\n * @this {THIS}\\n * @template THIS\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reverse\\n */\\nArray.prototype.reverse = function() {};\\n\\n/**\\n * Removes the first element from an array and returns that element. This\\n * method changes the length of the array.\\n *\\n * @this {IArrayLike<T>}\\n * @modifies {this}\\n * @return {T}\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/shift\\n */\\nArray.prototype.shift = function() {};\\n\\n/**\\n * Extracts a section of an array and returns a new array.\\n *\\n * @param {*=} opt_begin Zero-based index at which to begin extraction.  A\\n *     non-number type will be auto-cast by the browser to a number.\\n * @param {*=} opt_end Zero-based index at which to end extraction.  slice\\n *     extracts up to but not including end.\\n * @return {!Array<T>}\\n * @this {IArrayLike<T>|string}\\n * @template T\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/slice\\n */\\nArray.prototype.slice = function(opt_begin, opt_end) {};\\n\\n/**\\n * Sorts the elements of an array in place.\\n *\\n * @param {function(T,T):number=} opt_compareFn Specifies a function that\\n *     defines the sort order.\\n * @this {IArrayLike<T>}\\n * @template T\\n * @modifies {this}\\n * @return {!Array<T>}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort\\n */\\nArray.prototype.sort = function(opt_compareFn) {};\\n\\n/**\\n * Changes the content of an array, adding new elements while removing old\\n * elements.\\n *\\n * @param {*=} opt_index Index at which to start changing the array. If negative,\\n *     will begin that many elements from the end.  A non-number type will be\\n *     auto-cast by the browser to a number.\\n * @param {*=} opt_howMany An integer indicating the number of old array elements\\n *     to remove.\\n * @param {...T} var_args\\n * @return {!Array<T>}\\n * @this {IArrayLike<T>}\\n * @modifies {this}\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/splice\\n */\\nArray.prototype.splice = function(opt_index, opt_howMany, var_args) {};\\n\\n/**\\n * @return {string}\\n * @this {Object}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/toSource\\n */\\nArray.prototype.toSource;\\n\\n/**\\n * @this {Array<?>}\\n * @return {string}\\n * @nosideeffects\\n * @override\\n */\\nArray.prototype.toString = function() {};\\n\\n/**\\n * Adds one or more elements to the beginning of an array and returns the new\\n * length of the array.\\n *\\n * @param {...*} var_args\\n * @return {number} The new length of the array\\n * @this {IArrayLike<?>}\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/unshift\\n */\\nArray.prototype.unshift = function(var_args) {};\\n\\n/**\\n * Apply a function simultaneously against two values of the array (from\\n * left-to-right) as to reduce it to a single value.\\n *\\n * @param {?function(?, T, number, !Array<T>) : R} callback\\n * @param {*=} opt_initialValue\\n * @return {R}\\n * @this {IArrayLike<T>|string}\\n * @template T,R\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce\\n */\\nArray.prototype.reduce = function(callback, opt_initialValue) {};\\n\\n/**\\n * Apply a function simultaneously against two values of the array (from\\n * right-to-left) as to reduce it to a single value.\\n *\\n * @param {?function(?, T, number, !Array<T>) : R} callback\\n * @param {*=} opt_initialValue\\n * @return {R}\\n * @this {IArrayLike<T>|string}\\n * @template T,R\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduceRight\\n */\\nArray.prototype.reduceRight = function(callback, opt_initialValue) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\\n * @param {S=} opt_thisobj\\n * @return {boolean}\\n * @this {IArrayLike<T>|string}\\n * @template T,S\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/every\\n */\\nArray.prototype.every = function(callback, opt_thisobj) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\\n * @param {S=} opt_thisobj\\n * @return {!Array<T>}\\n * @this {IArrayLike<T>|string}\\n * @template T,S\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter\\n */\\nArray.prototype.filter = function(callback, opt_thisobj) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\\n * @param {S=} opt_thisobj\\n * @this {IArrayLike<T>|string}\\n * @template T,S\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach\\n * @return {undefined}\\n */\\nArray.prototype.forEach = function(callback, opt_thisobj) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {T} obj\\n * @param {number=} opt_fromIndex\\n * @return {number}\\n * @this {IArrayLike<T>|string}\\n * @nosideeffects\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf\\n */\\nArray.prototype.indexOf = function(obj, opt_fromIndex) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {T} obj\\n * @param {number=} opt_fromIndex\\n * @return {number}\\n * @this {IArrayLike<T>|string}\\n * @nosideeffects\\n * @template T\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/lastIndexOf\\n */\\nArray.prototype.lastIndexOf = function(obj, opt_fromIndex) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {?function(this:S, T, number, !Array<T>): R} callback\\n * @param {S=} opt_thisobj\\n * @return {!Array<R>}\\n * @this {IArrayLike<T>|string}\\n * @template T,S,R\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map\\n */\\nArray.prototype.map = function(callback, opt_thisobj) {};\\n\\n/**\\n * Available in ECMAScript 5, Mozilla 1.6+.\\n * @param {?function(this:S, T, number, !Array<T>): ?} callback\\n * @param {S=} opt_thisobj\\n * @return {boolean}\\n * @this {IArrayLike<T>|string}\\n * @template T,S\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some\\n */\\nArray.prototype.some = function(callback, opt_thisobj) {};\\n\\n/**\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/index\\n */\\nArray.prototype.index;\\n\\n/**\\n * @type {?string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/input\\n */\\nArray.prototype.input;\\n\\n/**\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/length\\n */\\nArray.prototype.length;\\n\\n/**\\n * @param {IArrayLike<T>} arr\\n * @param {?function(this:S, T, number, ?) : ?} callback\\n * @param {S=} opt_context\\n * @return {boolean}\\n * @template T,S\\n */\\nArray.every = function(arr, callback, opt_context) {};\\n\\n/**\\n * @param {IArrayLike<T>} arr\\n * @param {?function(this:S, T, number, ?) : ?} callback\\n * @param {S=} opt_context\\n * @return {!Array<T>}\\n * @template T,S\\n */\\nArray.filter = function(arr, callback, opt_context) {};\\n\\n/**\\n * @param {IArrayLike<T>} arr\\n * @param {?function(this:S, T, number, ?) : ?} callback\\n * @param {S=} opt_context\\n * @template T,S\\n * @return {undefined}\\n */\\nArray.forEach = function(arr, callback, opt_context) {};\\n\\n/**\\n * Mozilla 1.6+ only.\\n * @param {IArrayLike<T>} arr\\n * @param {T} obj\\n * @param {number=} opt_fromIndex\\n * @return {number}\\n * @template T\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf\\n */\\nArray.indexOf = function(arr, obj, opt_fromIndex) {};\\n\\n/**\\n * Mozilla 1.6+ only.\\n * @param {IArrayLike<T>} arr\\n * @param {T} obj\\n * @param {number=} opt_fromIndex\\n * @return {number}\\n * @template T\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/lastIndexOf\\n */\\nArray.lastIndexOf = function(arr, obj, opt_fromIndex) {};\\n\\n/**\\n * @param {IArrayLike<T>} arr\\n * @param {?function(this:S, T, number, !Array<T>): R} callback\\n * @param {S=} opt_context\\n * @return {!Array<R>}\\n * @template T,S,R\\n */\\nArray.map = function(arr, callback, opt_context) {};\\n\\n/**\\n * @param {IArrayLike<T>} arr\\n * @param {?function(this:S, T, number, ?) : ?} callback\\n * @param {S=} opt_context\\n * @return {boolean}\\n * @template T,S\\n */\\nArray.some = function(arr, callback, opt_context) {};\\n\\n/**\\n * Introduced in 1.8.5.\\n * @param {*} arr\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Array/isArray\\n */\\nArray.isArray = function(arr) {};\\n\\n/**\\n * @constructor\\n * @param {*=} opt_value\\n * @return {boolean}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean\\n */\\nfunction Boolean(opt_value) {}\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean/toSource\\n * @override\\n */\\nBoolean.prototype.toSource = function() {};\\n\\n/**\\n * @this {boolean|Boolean}\\n * @return {string}\\n * @nosideeffects\\n * @override\\n */\\nBoolean.prototype.toString = function() {};\\n\\n/**\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean/valueOf\\n * @override\\n */\\nBoolean.prototype.valueOf = function() {};\\n\\n/**\\n * @constructor\\n * @param {*=} opt_value\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number\\n */\\nfunction Number(opt_value) {}\\n\\n/**\\n * @this {Number|number}\\n * @param {number=} opt_fractionDigits\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toExponential\\n */\\nNumber.prototype.toExponential = function(opt_fractionDigits) {};\\n\\n/**\\n * @this {Number|number}\\n * @param {*=} opt_digits\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toFixed\\n */\\nNumber.prototype.toFixed = function(opt_digits) {};\\n\\n/**\\n * @this {Number|number}\\n * @param {number=} opt_precision\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toPrecision\\n */\\nNumber.prototype.toPrecision = function(opt_precision) {};\\n\\n/**\\n * Returns a string representing the number.\\n * @this {Number|number}\\n * @param {(number|Number)=} opt_radix An optional radix.\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/toString\\n * @override\\n */\\nNumber.prototype.toString = function(opt_radix) {};\\n\\n// Properties.\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MAX_VALUE\\n */\\nNumber.MAX_VALUE;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MIN_VALUE\\n */\\nNumber.MIN_VALUE;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/NaN\\n */\\nNumber.NaN;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/NEGATIVE_INFINITY\\n */\\nNumber.NEGATIVE_INFINITY;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/POSITIVE_INFINITY\\n */\\nNumber.POSITIVE_INFINITY;\\n\\n\\n/**\\n * @const\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math\\n */\\nvar Math = {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/abs\\n */\\nMath.abs = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/acos\\n */\\nMath.acos = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/asin\\n */\\nMath.asin = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/atan\\n */\\nMath.atan = function(x) {};\\n\\n/**\\n * @param {?} y\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/atan2\\n */\\nMath.atan2 = function(y, x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/ceil\\n */\\nMath.ceil = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/cos\\n */\\nMath.cos = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/exp\\n */\\nMath.exp = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/floor\\n */\\nMath.floor = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/log\\n */\\nMath.log = function(x) {};\\n\\n/**\\n * @param {...?} var_args\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/max\\n */\\nMath.max = function(var_args) {};\\n\\n/**\\n * @param {...?} var_args\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/min\\n */\\nMath.min = function(var_args) {};\\n\\n/**\\n * @param {?} x\\n * @param {?} y\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/pow\\n */\\nMath.pow = function(x, y) {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random\\n */\\nMath.random = function() {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round\\n */\\nMath.round = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/sin';
a.a+="\\n */\\nMath.sin = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/sqrt\\n */\\nMath.sqrt = function(x) {};\\n\\n/**\\n * @param {?} x\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/tan\\n */\\nMath.tan = function(x) {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/toSource\\n */\\nMath.toSource = function() {};\\n\\n// Properties:\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/E\\n */\\nMath.E;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LN2\\n */\\nMath.LN2;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LN10\\n */\\nMath.LN10;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LOG2E\\n */\\nMath.LOG2E;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/LOG10E\\n */\\nMath.LOG10E;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/PI\\n */\\nMath.PI;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/SQRT1_2\\n */\\nMath.SQRT1_2;\\n\\n/**\\n * @const {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/SQRT2\\n */\\nMath.SQRT2;\\n\\n\\n/**\\n * @param {?=} opt_yr_num\\n * @param {?=} opt_mo_num\\n * @param {?=} opt_day_num\\n * @param {?=} opt_hr_num\\n * @param {?=} opt_min_num\\n * @param {?=} opt_sec_num\\n * @param {?=} opt_ms_num\\n * @constructor\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date\\n */\\nfunction Date(opt_yr_num, opt_mo_num, opt_day_num, opt_hr_num, opt_min_num,\\n    opt_sec_num, opt_ms_num) {}\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/now\\n */\\nDate.now = function() {};\\n\\n/**\\n * Parses a string representation of a date, and returns the number\\n * of milliseconds since January 1, 1970, 00:00:00, local time.\\n * @param {*} date\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/parse\\n */\\nDate.parse = function(date) {};\\n\\n/**\\n * @param {number} year\\n * @param {number} month\\n * @param {number=} opt_date\\n * @param {number=} opt_hours\\n * @param {number=} opt_minute\\n * @param {number=} opt_second\\n * @param {number=} opt_ms\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/UTC\\n */\\nDate.UTC = function(year, month,\\n                    opt_date, opt_hours, opt_minute, opt_second, opt_ms) {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getDate\\n */\\nDate.prototype.getDate = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getDay\\n */\\nDate.prototype.getDay = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getMonth\\n */\\nDate.prototype.getMonth = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getFullYear\\n */\\nDate.prototype.getFullYear = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getYear\\n */\\nDate.prototype.getYear = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getHours\\n */\\nDate.prototype.getHours = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getMinutes\\n */\\nDate.prototype.getMinutes = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getSeconds\\n */\\nDate.prototype.getSeconds = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getMilliseconds\\n */\\nDate.prototype.getMilliseconds = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTime\\n */\\nDate.prototype.getTime = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTimezoneOffset\\n */\\nDate.prototype.getTimezoneOffset = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCDate\\n */\\nDate.prototype.getUTCDate = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCDay\\n */\\nDate.prototype.getUTCDay = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCMonth\\n */\\nDate.prototype.getUTCMonth = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCFullYear\\n */\\nDate.prototype.getUTCFullYear = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCHours\\n */\\nDate.prototype.getUTCHours = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCMinutes\\n */\\nDate.prototype.getUTCMinutes = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCSeconds\\n */\\nDate.prototype.getUTCSeconds = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getUTCMilliseconds\\n */\\nDate.prototype.getUTCMilliseconds = function() {};\\n\\n/**\\n * Sets the day of the month for a specified date according to local time.\\n *\\n * @param {number} dayValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setDate\\n * @return {number}\\n */\\nDate.prototype.setDate = function(dayValue) {};\\n\\n/**\\n * Set the month for a specified date according to local time.\\n *\\n * @param {number} monthValue\\n * @param {number=} opt_dayValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setMonth\\n * @return {number}\\n */\\nDate.prototype.setMonth = function(monthValue, opt_dayValue) {};\\n\\n/**\\n * Sets the full year for a specified date according to local time.\\n *\\n * @param {number} yearValue\\n * @param {number=} opt_monthValue\\n * @param {number=} opt_dayValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setFullYear\\n * @return {number}\\n */\\nDate.prototype.setFullYear =\\n    function(yearValue, opt_monthValue, opt_dayValue) {};\\n\\n/**\\n * Sets the year for a specified date according to local time.\\n *\\n * @param {number} yearValue\\n * @deprecated\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setYear\\n * @return {number}\\n */\\nDate.prototype.setYear = function(yearValue) {};\\n\\n/**\\n * Sets the hours for a specified date according to local time.\\n *\\n * @param {number} hoursValue\\n * @param {number=} opt_minutesValue\\n * @param {number=} opt_secondsValue\\n * @param {number=} opt_msValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setHours\\n * @return {number}\\n */\\nDate.prototype.setHours = function(hoursValue, opt_minutesValue,\\n                                   opt_secondsValue, opt_msValue) {};\\n\\n/**\\n * Sets the minutes for a specified date according to local time.\\n *\\n * @param {number} minutesValue\\n * @param {number=} opt_secondsValue\\n * @param {number=} opt_msValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setMinutes\\n * @return {number}\\n */\\nDate.prototype.setMinutes =\\n    function(minutesValue, opt_secondsValue, opt_msValue) {};\\n\\n/**\\n * Sets the seconds for a specified date according to local time.\\n *\\n * @param {number} secondsValue\\n * @param {number=} opt_msValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setSeconds\\n * @return {number}\\n */\\nDate.prototype.setSeconds = function(secondsValue, opt_msValue) {};\\n\\n/**\\n * Sets the milliseconds for a specified date according to local time.\\n *\\n * @param {number} millisecondsValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setMilliseconds\\n * @return {number}\\n */\\nDate.prototype.setMilliseconds = function(millisecondsValue) {};\\n\\n/**\\n * Sets the Date object to the time represented by a number of milliseconds\\n * since January 1, 1970, 00:00:00 UTC.\\n *\\n * @param {number} timeValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setTime\\n * @return {number}\\n */\\nDate.prototype.setTime = function(timeValue) {};\\n\\n/**\\n * Sets the day of the month for a specified date according to universal time.\\n *\\n * @param {number} dayValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCDate\\n * @return {number}\\n */\\nDate.prototype.setUTCDate = function(dayValue) {};\\n\\n/**\\n * Sets the month for a specified date according to universal time.\\n *\\n * @param {number} monthValue\\n * @param {number=} opt_dayValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCMonth\\n * @return {number}\\n */\\nDate.prototype.setUTCMonth = function(monthValue, opt_dayValue) {};\\n\\n/**\\n * Sets the full year for a specified date according to universal time.\\n *\\n * @param {number} yearValue\\n * @param {number=} opt_monthValue\\n * @param {number=} opt_dayValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCFullYear\\n * @return {number}\\n */\\nDate.prototype.setUTCFullYear = function(yearValue, opt_monthValue,\\n                                         opt_dayValue) {};\\n\\n/**\\n * Sets the hour for a specified date according to universal time.\\n *\\n * @param {number} hoursValue\\n * @param {number=} opt_minutesValue\\n * @param {number=} opt_secondsValue\\n * @param {number=} opt_msValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCHours\\n * @return {number}\\n */\\nDate.prototype.setUTCHours = function(hoursValue, opt_minutesValue,\\n                                      opt_secondsValue, opt_msValue) {};\\n\\n/**\\n * Sets the minutes for a specified date according to universal time.\\n *\\n * @param {number} minutesValue\\n * @param {number=} opt_secondsValue\\n * @param {number=} opt_msValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCMinutes\\n * @return {number}\\n */\\nDate.prototype.setUTCMinutes = function(minutesValue, opt_secondsValue,\\n                                        opt_msValue) {};\\n\\n\\n/**\\n * Sets the seconds for a specified date according to universal time.\\n *\\n * @param {number} secondsValue\\n * @param {number=} opt_msValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCSeconds\\n * @return {number}\\n */\\nDate.prototype.setUTCSeconds = function(secondsValue, opt_msValue) {};\\n\\n/**\\n * Sets the milliseconds for a specified date according to universal time.\\n *\\n * @param {number} millisecondsValue\\n * @modifies {this}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/setUTCMilliseconds\\n * @return {number}\\n */\\nDate.prototype.setUTCMilliseconds = function(millisecondsValue) {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toSource\\n * @override\\n */\\nDate.prototype.toSource = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Date/toDateString\\n */\\nDate.prototype.toDateString = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toGMTString\\n */\\nDate.prototype.toGMTString = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toTimeString\\n */\\nDate.prototype.toTimeString = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toUTCString\\n */\\nDate.prototype.toUTCString = function() {};\\n\\n/**\\n * @param {(string|Array<string>)=} opt_locales\\n * @param {Object=} opt_options\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleDateString\\n */\\nDate.prototype.toLocaleDateString = function(opt_locales, opt_options) {};\\n\\n/**\\n * @param {string} formatString\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleFormat\\n */\\nDate.prototype.toLocaleFormat = function(formatString) {};\\n\\n/**\\n * @param {string|Array<string>=} opt_locales\\n * @param {Object=} opt_options\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleString\\n * @see http://www.ecma-international.org/ecma-402/1.0/#sec-13.3.1\\n * @override\\n */\\nDate.prototype.toLocaleString = function(opt_locales, opt_options) {};\\n\\n/**\\n * @param {(string|Array<string>)=} opt_locales\\n * @param {Object=} opt_options\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleTimeString\\n */\\nDate.prototype.toLocaleTimeString = function(opt_locales, opt_options) {};\\n\\n/**\\n * @this {Date}\\n * @return {string}\\n * @nosideeffects\\n * @override\\n */\\nDate.prototype.toString = function() {};\\n\\n/**\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/valueOf\\n */\\nDate.prototype.valueOf;\\n\\n/**\\n * @constructor\\n * @implements {Iterable<string>}\\n * @param {*=} opt_str\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String\\n */\\nfunction String(opt_str) {}\\n\\n/**\\n * @param {...number} var_args\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Gl";
a.a+="obal_Objects/String/fromCharCode\\n */\\nString.fromCharCode = function(var_args) {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/anchor\\n */\\nString.prototype.anchor = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/big\\n */\\nString.prototype.big = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/blink\\n */\\nString.prototype.blink = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/bold\\n */\\nString.prototype.bold = function() {};\\n\\n/**\\n * Returns the specified character from a string.\\n *\\n * @this {String|string}\\n * @param {number} index\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/charAt\\n */\\nString.prototype.charAt = function(index) {};\\n\\n/**\\n * Returns a number indicating the Unicode value of the character at the given\\n * index.\\n *\\n * @this {String|string}\\n * @param {number=} opt_index\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/charCodeAt\\n */\\nString.prototype.charCodeAt = function(opt_index) {};\\n\\n/**\\n * Combines the text of two or more strings and returns a new string.\\n *\\n * @this {String|string}\\n * @param {...*} var_args\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/concat\\n */\\nString.prototype.concat = function(var_args) {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fixed\\n */\\nString.prototype.fixed = function() {};\\n\\n/**\\n * @this {String|string}\\n * @param {string} color\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fontcolor\\n */\\nString.prototype.fontcolor = function(color) {};\\n\\n/**\\n * @this {String|string}\\n * @param {number} size\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/fontsize\\n */\\nString.prototype.fontsize = function(size) {};\\n\\n/**\\n * Returns the index within the calling String object of the first occurrence\\n * of the specified value, starting the search at fromIndex, returns -1 if the\\n * value is not found.\\n *\\n * @this {String|string}\\n * @param {string|null} searchValue\\n * @param {(number|null)=} opt_fromIndex\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/indexOf\\n */\\nString.prototype.indexOf = function(searchValue, opt_fromIndex) {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/italics\\n */\\nString.prototype.italics = function() {};\\n\\n/**\\n * Returns the index within the calling String object of the last occurrence of\\n * the specified value, or -1 if not found. The calling string is searched\\n * backward, starting at fromIndex.\\n *\\n * @this {String|string}\\n * @param {string|null} searchValue\\n * @param {(number|null)=} opt_fromIndex\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/lastIndexOf\\n */\\nString.prototype.lastIndexOf = function(searchValue, opt_fromIndex) {};\\n\\n/**\\n * @this {String|string}\\n * @param {string} hrefAttribute\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/link\\n */\\nString.prototype.link = function(hrefAttribute) {};\\n\\n/**\\n * Returns a number indicating whether a reference string comes before or after\\n * or is the same as the given string in sort order.\\n *\\n * @this {*}\\n * @param {?string} compareString\\n * @param {string|Array<string>=} locales\\n * @param {Object=} options\\n * @return {number}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Objects/String/localeCompare\\n * @see http://www.ecma-international.org/ecma-402/1.0/#sec-13.1.1\\n */\\nString.prototype.localeCompare = function(compareString, locales, options) {};\\n\\n/**\\n * Used to retrieve the matches when matching a string against a regular\\n * expression.\\n *\\n * @this {String|string}\\n * @param {*} regexp\\n * @return {Array<string>} This should really return an Array with a few\\n *     special properties, but we do not have a good way to model this in\\n *     our type system. Also see Regexp.prototype.exec.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/match\\n */\\nString.prototype.match = function(regexp) {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/quote\\n */\\nString.prototype.quote = function() {};\\n\\n/**\\n * Finds a match between a regular expression and a string, and replaces the\\n * matched substring with a new substring.\\n *\\n * This may have side-effects if the replacement function has side-effects.\\n *\\n * @this {String|string}\\n * @param {RegExp|string} pattern\\n * @param {string|Function} replacement\\n * @return {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replace\\n */\\nString.prototype.replace = function(pattern, replacement) {};\\n\\n/**\\n * Executes the search for a match between a regular expression and this String\\n * object.\\n *\\n * @this {String|string}\\n * @param {RegExp|string} pattern\\n * @return {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/search\\n */\\nString.prototype.search = function(pattern) {};\\n\\n/**\\n * @this {String|string}\\n * @param {number} begin\\n * @param {number=} opt_end\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/slice\\n */\\nString.prototype.slice = function(begin, opt_end) {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/small\\n */\\nString.prototype.small = function() {};\\n\\n/**\\n * @this {String|string}\\n * @param {*=} opt_separator\\n * @param {number=} opt_limit\\n * @return {!Array<string>}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/split\\n */\\nString.prototype.split = function(opt_separator, opt_limit) {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/strike\\n */\\nString.prototype.strike = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/sub\\n */\\nString.prototype.sub = function() {};\\n\\n/**\\n * @this {String|string}\\n * @param {number} start\\n * @param {number=} opt_length\\n * @return {string} The specified substring.\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/substr\\n */\\nString.prototype.substr = function(start, opt_length) {};\\n\\n/**\\n * @this {String|string}\\n * @param {number} start\\n * @param {number=} opt_end\\n * @return {string} The specified substring.\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/substring\\n */\\nString.prototype.substring = function(start, opt_end) {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/sup\\n */\\nString.prototype.sup = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toLocaleUpperCase\\n */\\nString.prototype.toLocaleUpperCase = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toLocaleLowerCase\\n */\\nString.prototype.toLocaleLowerCase = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toLowerCase\\n */\\nString.prototype.toLowerCase = function() {};\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toUpperCase\\n */\\nString.prototype.toUpperCase = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/toSource\\n * @override\\n */\\nString.prototype.toSource = function() {};\\n\\n/**\\n * @this {string|String}\\n * @return {string}\\n * @nosideeffects\\n * @override\\n */\\nString.prototype.toString = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/valueOf\\n */\\nString.prototype.valueOf;\\n\\n/**\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/length\\n */\\nString.prototype.length;\\n\\n/**\\n * @constructor\\n * @param {*=} opt_pattern\\n * @param {*=} opt_flags\\n * @return {!RegExp}\\n * @throws {SyntaxError} if opt_pattern is an invalid pattern.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nfunction RegExp(opt_pattern, opt_flags) {}\\n\\n/**\\n * @param {*} pattern\\n * @param {*=} opt_flags\\n * @return {void}\\n * @modifies {this}\\n * @deprecated\\n * @see http://msdn.microsoft.com/en-us/library/x9cswe0z(v=VS.85).aspx\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/compile\\n */\\nRegExp.prototype.compile = function(pattern, opt_flags) {};\\n\\n/**\\n * @param {*} str The string to search.\\n * @return {?RegExpResult}\\n * @see http://msdn.microsoft.com/en-us/library/z908hy33(VS.85).aspx\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/exec\\n */\\nRegExp.prototype.exec = function(str) {};\\n\\n/**\\n * @param {*} str The string to search.\\n * @return {boolean} Whether the string was matched.\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/test\\n */\\nRegExp.prototype.test = function(str) {};\\n\\n/**\\n * @this {RegExp}\\n * @return {string}\\n * @nosideeffects\\n * @override\\n */\\nRegExp.prototype.toString = function() {};\\n\\n/**\\n * @constructor\\n * @extends {Array<string>}\\n */\\nvar RegExpResult = function() {};\\n\\n\\n/** @type {number} */\\nRegExpResult.prototype.index;\\n\\n\\n/** @type {string} */\\nRegExpResult.prototype.input;\\n\\n\\n/** @type {number} */\\nRegExpResult.prototype.length;\\n\\n\\n/**\\n * Not actually part of ES3; was added in 2018.\\n * https://github.com/tc39/proposal-regexp-named-groups\\n *\\n * @type {!Object<string, string>}\\n */\\nRegExpResult.prototype.groups;\\n\\n\\n// Constructor properties:\\n\\n/**\\n * The string against which the last regexp was matched.\\n * @type {string}\\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_input.html\\n */\\nRegExp.input;\\n\\n/**\\n * The last matched characters.\\n * @type {string}\\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_lastMatch.html\\n */\\nRegExp.lastMatch;\\n\\n/**\\n * The last matched parenthesized substring, if any.\\n * @type {string}\\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_lastParen.html\\n */\\nRegExp.lastParen;\\n\\n/**\\n * The substring of the input up to the characters most recently matched.\\n * @type {string}\\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_leftContext.html\\n */\\nRegExp.leftContext;\\n\\n/**\\n * The substring of the input after the characters most recently matched.\\n * @type {string}\\n * @see http://www.devguru.com/Technologies/Ecmascript/Quickref/regexp_rightContext.html\\n */\\nRegExp.rightContext;\\n\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$1;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$2;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$3;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$4;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$5;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$6;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$7;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$8;\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp\\n */\\nRegExp.$9;\\n\\n// Prototype properties:\\n\\n/**\\n * Whether to test the regular expression against all possible matches\\n * in a string, or only against the first.\\n * @type {boolean}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/global\\n */\\nRegExp.prototype.global;\\n\\n/**\\n * Whether to ignore case while attempting a match in a string.\\n * @type {boolean}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/ignoreCase\\n */\\nRegExp.prototype.ignoreCase;\\n\\n/**\\n * The index at which to start the next match.\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/lastIndex\\n */\\nRegExp.prototype.lastIndex;\\n\\n/**\\n * Whether or not the regular expression uses lastIndex.\\n * @type {boolean}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/sticky\\n */\\nRegExp.prototype.sticky;\\n\\n/**\\n * Whether or not to search in strings across multiple lines.\\n * @type {boolean}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/multiline\\n */\\nRegExp.prototype.multiline;\\n\\n/**\\n * The text of the pattern.\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/source\\n */\\nRegExp.prototype.source;\\n\\n/**\\n * The flags the regex was created with.\\n * @type {string}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp/flags\\n */\\nRegExp.prototype.flags;\\n\\n/**\\n * @constructor\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!Error}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error\\n */\\nfunction Error(opt_message, opt_file, opt_line) {}\\n\\n\\n/**\\n * Chrome/v8 specific, altering the maximum depth of the stack trace\\n * (10 by default).\\n * @type {number}\\n * @see http://code.google.com/p/v8/wiki/JavaScriptStackTraceApi\\n */\\nError.stackTraceLimit;\\n\\n\\n/**\\n * Chrome/v8 specific, adds a stack trace to the error object. The optional\\n *";
a.a+=' constructorOpt parameter allows you to pass in a function value. When\\n * collecting the stack trace all frames above the topmost call to this\\n * function, including that call, will be left out of the stack trace.\\n * @param {Object} error The object to add the stack trace to.\\n * @param {Function=} opt_constructor A function in the stack trace\\n * @see http://code.google.com/p/v8/wiki/JavaScriptStackTraceApi\\n * @return {undefined}\\n */\\nError.captureStackTrace = function(error, opt_constructor){};\\n\\n\\n/**\\n * IE-only.\\n * @type {string}\\n * @see http://msdn.microsoft.com/en-us/library/2w6a45b5.aspx\\n */\\nError.prototype.description;\\n\\n\\n/**\\n * Mozilla-only.\\n * @type {number}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/lineNumber\\n */\\nError.prototype.lineNumber;\\n\\n/**\\n * Mozilla-only\\n * @type {string}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/fileName\\n */\\nError.prototype.fileName;\\n\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/name\\n */\\nError.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error/message\\n */\\nError.prototype.message;\\n\\n/**\\n * Doesn\'t seem to exist, but closure/debug.js references it.\\n */\\nError.prototype.sourceURL;\\n\\n/** @type {string} */\\nError.prototype.stack;\\n\\n\\n/**\\n * @constructor\\n * @extends {Error}\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!EvalError}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/EvalError\\n */\\nfunction EvalError(opt_message, opt_file, opt_line) {}\\n\\n/**\\n * @constructor\\n * @extends {Error}\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!RangeError}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RangeError\\n */\\nfunction RangeError(opt_message, opt_file, opt_line) {}\\n\\n/**\\n * @constructor\\n * @extends {Error}\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!ReferenceError}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ReferenceError\\n */\\nfunction ReferenceError(opt_message, opt_file, opt_line) {}\\n\\n/**\\n * @constructor\\n * @extends {Error}\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!SyntaxError}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SyntaxError\\n */\\nfunction SyntaxError(opt_message, opt_file, opt_line) {}\\n\\n/**\\n * @constructor\\n * @extends {Error}\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!TypeError}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypeError\\n */\\nfunction TypeError(opt_message, opt_file, opt_line) {}\\n\\n/**\\n * @constructor\\n * @extends {Error}\\n * @param {*=} opt_message\\n * @param {*=} opt_file\\n * @param {*=} opt_line\\n * @return {!URIError}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/URIError\\n */\\nfunction URIError(opt_message, opt_file, opt_line) {}\\n\\n\\n// JScript extensions.\\n// @see http://msdn.microsoft.com/en-us/library/894hfyb4(VS.80).aspx\\n\\n/**\\n * @see http://msdn.microsoft.com/en-us/library/7sw4ddf8.aspx\\n * @type {function(new:?, string, string=)}\\n */\\nfunction ActiveXObject(progId, opt_location) {}\\n","externs/es5.js":"/*\\n * Copyright 2009 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for ECMAScript 5.\\n * @see https://es5.github.io/\\n * @externs\\n * @author djlee@google.com (DJ Lee)\\n */\\n\\n\\n/**\\n * @param {Object|undefined} selfObj Specifies the object to which |this| should\\n *     point when the function is run. If the value is null or undefined, it\\n *     will default to the global object.\\n * @param {...*} var_args Additional arguments that are partially\\n *     applied to fn.\\n * @return {!Function} A partially-applied form of the Function on which\\n *     bind() was invoked as a method.\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Function/bind\\n */\\nFunction.prototype.bind = function(selfObj, var_args) {};\\n\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/Trim\\n */\\nString.prototype.trim = function() {};\\n\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/TrimLeft\\n */\\nString.prototype.trimLeft = function() {};\\n\\n\\n/**\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see http://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/String/TrimRight\\n */\\nString.prototype.trimRight = function() {};\\n\\n\\n/**\\n * A object property descriptor used by Object.create, Object.defineProperty,\\n * Object.defineProperties, Object.getOwnPropertyDescriptor.\\n *\\n * @record\\n * @template THIS\\n */\\nfunction ObjectPropertyDescriptor() {}\\n\\n/** @type {(*|undefined)} */\\nObjectPropertyDescriptor.prototype.value;\\n\\n/** @type {(function(this: THIS):?)|undefined} */\\nObjectPropertyDescriptor.prototype.get;\\n\\n/** @type {(function(this: THIS, ?):void)|undefined} */\\nObjectPropertyDescriptor.prototype.set;\\n\\n/** @type {boolean|undefined} */\\nObjectPropertyDescriptor.prototype.writable;\\n\\n/** @type {boolean|undefined} */\\nObjectPropertyDescriptor.prototype.enumerable;\\n\\n/** @type {boolean|undefined} */\\nObjectPropertyDescriptor.prototype.configurable;\\n\\n\\n/**\\n * @param {?Object} proto\\n * @param {?Object=} opt_properties  A map of ObjectPropertyDescriptors.\\n * @return {!Object}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/create\\n */\\nObject.create = function(proto, opt_properties) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @param {string|symbol} prop\\n * @param {!Object} descriptor A ObjectPropertyDescriptor.\\n * @return {!Object}\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/defineProperty\\n */\\nObject.defineProperty = function(obj, prop, descriptor) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @param {!Object} props A map of ObjectPropertyDescriptors.\\n * @return {!Object}\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/defineProperties\\n */\\nObject.defineProperties = function(obj, props) {};\\n\\n\\n/**\\n * @param {T} obj\\n * @param {string|symbol} prop\\n * @return {!ObjectPropertyDescriptor<T>|undefined}\\n * @nosideeffects\\n * @template T\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/getOwnPropertyDescriptor\\n */\\nObject.getOwnPropertyDescriptor = function(obj, prop) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @return {!Array<string>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/keys\\n */\\nObject.keys = function(obj) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @return {!Array<string>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/getOwnPropertyNames\\n */\\nObject.getOwnPropertyNames = function(obj) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @return {Object}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/GetPrototypeOf\\n */\\nObject.getPrototypeOf = function(obj) {};\\n\\n\\n/**\\n * @param {T} obj\\n * @return {T}\\n * @template T\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/preventExtensions\\n */\\nObject.preventExtensions = function(obj) {};\\n\\n\\n/**\\n * @param {T} obj\\n * @return {T}\\n * @template T\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/seal\\n */\\nObject.seal = function(obj) {};\\n\\n\\n/**\\n * @param {T} obj\\n * @return {T}\\n * @template T\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/freeze\\n */\\nObject.freeze = function(obj) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/isExtensible\\n */\\nObject.isExtensible = function(obj) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/isSealed\\n */\\nObject.isSealed = function(obj) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Object/isFrozen\\n */\\nObject.isFrozen = function(obj) {};\\n\\n\\n/**\\n * @param {string=} opt_key The JSON key for this object.\\n * @return {*} The serializable representation of this object. Note that this\\n *     need not be a string. See http://goo.gl/PEUvs.\\n * @see https://es5.github.io/#x15.12.3\\n */\\nObject.prototype.toJSON = function(opt_key) {};\\n\\n\\n/**\\n * @see https://developer.mozilla.org/en/JavaScript/Reference/Global_Objects/Date/toISOString\\n * @return {string}\\n */\\nDate.prototype.toISOString = function() {};\\n\\n\\n/**\\n * @param {*=} opt_ignoredKey\\n * @return {string}\\n * @override\\n */\\nDate.prototype.toJSON = function(opt_ignoredKey) {};\\n\\n\\n/**\\n * A fake type to model the JSON object.\\n * @constructor\\n */\\nfunction JSONType() {}\\n\\n\\n/**\\n * @param {string} jsonStr The string to parse.\\n * @param {(function(this:?, string, *) : *)=} opt_reviver\\n * @return {*} The JSON object.\\n * @throws {Error}\\n */\\nJSONType.prototype.parse = function(jsonStr, opt_reviver) {};\\n\\n\\n/**\\n * @param {*} jsonObj Input object.\\n * @param {(Array<string>|(function(this:?, string, *) : *)|null)=} opt_replacer\\n * @param {(number|string)=} opt_space\\n * @return {string} JSON string which represents jsonObj.\\n * @throws {Error}\\n */\\nJSONType.prototype.stringify = function(jsonObj, opt_replacer, opt_space) {};\\n\\n\\n/**\\n * @type {!JSONType}\\n * @suppress {duplicate}\\n */\\nvar JSON;\\n","externs/es6.js":"/*\\n * Copyright 2014 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for ECMAScript 6 and later.\\n * @see https://tc39.github.io/ecma262/\\n * @see https://www.khronos.org/registry/typedarray/specs/latest/\\n * @externs\\n */\\n\\n\\n\\n/**\\n * @interface\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Generator\\n * @extends {IteratorIterable<VALUE>}\\n * @template VALUE\\n */\\nfunction Generator() {}\\n\\n/**\\n * @param {?=} opt_value\\n * @return {!IIterableResult<VALUE>}\\n * @override\\n */\\nGenerator.prototype.next = function(opt_value) {};\\n\\n/**\\n * @param {VALUE} value\\n * @return {!IIterableResult<VALUE>}\\n */\\nGenerator.prototype.return = function(value) {};\\n\\n/**\\n * @param {?} exception\\n * @return {!IIterableResult<VALUE>}\\n */\\nGenerator.prototype.throw = function(exception) {};\\n\\n\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.log10 = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.log2 = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.log1p = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.expm1 = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.cosh = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.sinh = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.tanh = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.acosh = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.asinh = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.atanh = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.trunc = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.sign = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n */\\nMath.cbrt = function(value) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/hypot\\n */\\nMath.hypot = function(var_args) {};\\n\\n/**\\n * @param {number} value1\\n * @param {number} value2\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul\\n */\\nMath.imul = function(value1, value2) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/clz32\\n */\\nMath.clz32 = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/fround\\n */\\nMath.fround = function(value) {};\\n\\n\\n/**\\n * @param {*} a\\n * @param {*} b\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is\\n */\\nObject.is;\\n\\n\\n/**\\n * Returns a language-sensitive string representation of this number.\\n * @param {(string|!Array<string>)=} opt_locales\\n * @param {Object=} opt_options\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number/toLocaleString\\n * @see http://www.ecma-international.org/ecma-402/1.0/#sec-13.2.1\\n * @override\\n */\\nNumber.prototype.toLocaleString = function(opt_locales, opt_options) {};\\n\\n/**\\n * Returns the wrapped primitive value of this Number object.\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/valueOf\\n * @override\\n */\\nNumber.prototype.valueOf = function() {};\\n\\n\\n/**\\n * Pads the end of the string so that it reaches the given length.\\n * NOTE: this is an ES2017 (ES8) extern.\\n *\\n * @param {number} targetLength The target length.\\n * @param {string=} opt_padString The string to pad with.\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/padEnd\\n */\\nString.prototype.padEnd = function(targetLength, opt_padString) {};\\n\\n/**\\n * Pads the start of the string so that it reaches the given length.\\n * NOTE: this is an ES2017 (ES8) extern.\\n *\\n * @param {number} targetLength The target length.';
a.a+="\\n * @param {string=} opt_padString The string to pad with.\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/padStart\\n */\\nString.prototype.padStart = function(targetLength, opt_padString) {};\\n\\n/**\\n * Repeats the string the given number of times.\\n *\\n * @param {number} count The number of times the string is repeated.\\n * @this {String|string}\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/repeat\\n */\\nString.prototype.repeat = function(count) {};\\n\\n/**\\n * @constructor\\n * @extends {Array<string>}\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-gettemplateobject\\n */\\nvar ITemplateArray = function() {};\\n\\n/**\\n * @type {!Array<string>}\\n */\\nITemplateArray.prototype.raw;\\n\\n/**\\n * @param {!ITemplateArray} template\\n * @param {...*} var_args Substitution values.\\n * @return {string}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/raw\\n */\\nString.raw = function(template, var_args) {};\\n\\n\\n/**\\n * @param {number} codePoint\\n * @param {...number} var_args Additional codepoints\\n * @return {string}\\n */\\nString.fromCodePoint = function(codePoint, var_args) {};\\n\\n\\n/**\\n * @param {number} index\\n * @return {number}\\n * @nosideeffects\\n */\\nString.prototype.codePointAt = function(index) {};\\n\\n\\n/**\\n * @param {string=} opt_form\\n * @return {string}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/normalize\\n */\\nString.prototype.normalize = function(opt_form) {};\\n\\n\\n/**\\n * @param {string} searchString\\n * @param {number=} opt_position\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith\\n */\\nString.prototype.startsWith = function(searchString, opt_position) {};\\n\\n/**\\n * @param {string} searchString\\n * @param {number=} opt_position\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith\\n */\\nString.prototype.endsWith = function(searchString, opt_position) {};\\n\\n/**\\n * @param {string} searchString\\n * @param {number=} opt_position\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes\\n */\\nString.prototype.includes = function(searchString, opt_position) {};\\n\\n\\n/**\\n * @see http://dev.w3.org/html5/postmsg/\\n * @interface\\n */\\nfunction Transferable() {}\\n\\n/**\\n * @param {number} length The length in bytes\\n * @constructor\\n * @throws {Error}\\n * @implements {Transferable}\\n */\\nfunction ArrayBuffer(length) {}\\n\\n/** @type {number} */\\nArrayBuffer.prototype.byteLength;\\n\\n/**\\n * @param {number} begin\\n * @param {number=} opt_end\\n * @return {!ArrayBuffer}\\n * @nosideeffects\\n */\\nArrayBuffer.prototype.slice = function(begin, opt_end) {};\\n\\n/**\\n * @param {*} arg\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/ArrayBuffer/isView\\n */\\nArrayBuffer.isView = function(arg) {};\\n\\n\\n/**\\n * @constructor\\n */\\nfunction ArrayBufferView() {}\\n\\n/** @type {!ArrayBuffer} */\\nArrayBufferView.prototype.buffer;\\n\\n/** @type {number} */\\nArrayBufferView.prototype.byteOffset;\\n\\n/** @type {number} */\\nArrayBufferView.prototype.byteLength;\\n\\n\\n/**\\n * @param {number} length The length in bytes\\n * @constructor\\n * @throws {Error}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer\\n */\\nfunction SharedArrayBuffer(length) {}\\n\\n/** @type {number} */\\nSharedArrayBuffer.prototype.byteLength;\\n\\n/**\\n * @param {number} begin\\n * @param {number=} opt_end\\n * @return {!SharedArrayBuffer}\\n * @nosideeffects\\n */\\nSharedArrayBuffer.prototype.slice = function(begin, opt_end) {};\\n\\n\\n/**\\n * @typedef {!ArrayBuffer|!ArrayBufferView}\\n */\\nvar BufferSource;\\n\\n\\n/**\\n * @constructor\\n * @implements {IArrayLike<number>}\\n * @implements {Iterable<number>}\\n * @extends {ArrayBufferView}\\n */\\nfunction TypedArray() {};\\n\\n/** @const {number} */\\nTypedArray.prototype.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {number} target\\n * @param {number} start\\n * @param {number=} opt_end\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/copyWithin\\n */\\nTypedArray.prototype.copyWithin = function(target, start, opt_end) {};\\n\\n/**\\n * @return {!IteratorIterable<!Array<number>>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/entries\\n */\\nTypedArray.prototype.entries = function() {};\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : ?} callback\\n * @param {S=} opt_thisArg\\n * @return {boolean}\\n * @template S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/every\\n */\\nTypedArray.prototype.every = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {number} value\\n * @param {number=} opt_begin\\n * @param {number=} opt_end\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/fill\\n */\\nTypedArray.prototype.fill = function(value, opt_begin, opt_end) {};\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\\n * @param {S=} opt_thisArg\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS,S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/filter\\n */\\nTypedArray.prototype.filter = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\\n * @param {S=} opt_thisArg\\n * @return {(number|undefined)}\\n * @template S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/find\\n */\\nTypedArray.prototype.find = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\\n * @param {S=} opt_thisArg\\n * @return {number}\\n * @template S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/findIndex\\n */\\nTypedArray.prototype.findIndex = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : ?} callback\\n * @param {S=} opt_thisArg\\n * @return {undefined}\\n * @template S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/forEach\\n */\\nTypedArray.prototype.forEach = function(callback, opt_thisArg) {};\\n\\n/**\\n * NOTE: this is an ES2016 (ES7) extern.\\n * @param {number} searchElement\\n * @param {number=} opt_fromIndex\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/includes\\n */\\nTypedArray.prototype.includes = function(searchElement, opt_fromIndex) {};\\n\\n/**\\n * @param {number} searchElement\\n * @param {number=} opt_fromIndex\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/indexOf\\n */\\nTypedArray.prototype.indexOf = function(searchElement, opt_fromIndex) {};\\n\\n/**\\n * @param {string=} opt_separator\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/join\\n */\\nTypedArray.prototype.join = function(opt_separator) {};\\n\\n/**\\n * @return {!IteratorIterable<number>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/keys\\n */\\nTypedArray.prototype.keys = function() {};\\n\\n/**\\n * @param {number} searchElement\\n * @param {number=} opt_fromIndex\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/lastIndexOf\\n */\\nTypedArray.prototype.lastIndexOf = function(searchElement, opt_fromIndex) {};\\n\\n/** @type {number} */\\nTypedArray.prototype.length;\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : number} callback\\n * @param {S=} opt_thisArg\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS,S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/map\\n */\\nTypedArray.prototype.map = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {function((number|INIT|RET), number, number, !TypedArray) : RET} callback\\n * @param {INIT=} opt_initialValue\\n * @return {RET}\\n * @template INIT,RET\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/reduce\\n */\\nTypedArray.prototype.reduce = function(callback, opt_initialValue) {};\\n\\n/**\\n * @param {function((number|INIT|RET), number, number, !TypedArray) : RET} callback\\n * @param {INIT=} opt_initialValue\\n * @return {RET}\\n * @template INIT,RET\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/reduceRight\\n */\\nTypedArray.prototype.reduceRight = function(callback, opt_initialValue) {};\\n\\n/**\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/reverse\\n */\\nTypedArray.prototype.reverse = function() {};\\n\\n/**\\n * @param {!ArrayBufferView|!Array<number>} array\\n * @param {number=} opt_offset\\n * @return {undefined}\\n * @throws {!RangeError}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/set\\n */\\nTypedArray.prototype.set = function(array, opt_offset) {};\\n\\n/**\\n * @param {number=} opt_begin\\n * @param {number=} opt_end\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/slice\\n */\\nTypedArray.prototype.slice = function(opt_begin, opt_end) {};\\n\\n/**\\n * @param {function(this:S, number, number, !TypedArray) : boolean} callback\\n * @param {S=} opt_thisArg\\n * @return {boolean}\\n * @template S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/some\\n */\\nTypedArray.prototype.some = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {(function(number, number) : number)=} opt_compareFunction\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/sort\\n */\\nTypedArray.prototype.sort = function(opt_compareFunction) {};\\n\\n/**\\n * @param {number} begin\\n * @param {number=} opt_end\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/subarray\\n */\\nTypedArray.prototype.subarray = function(begin, opt_end) {};\\n\\n/**\\n * @return {!IteratorIterable<number>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/values\\n */\\nTypedArray.prototype.values = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/toLocaleString\\n * @override\\n */\\nTypedArray.prototype.toLocaleString = function() {};\\n\\n/**\\n * @return {string}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/toString\\n * @override\\n */\\nTypedArray.prototype.toString = function() {};\\n\\n/** @override */\\nTypedArray.prototype[Symbol.iterator] = function() {};\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments} If the user passes a backing array, then indexed\\n *     accesses will modify the backing array. JSCompiler does not model\\n *     this well. In other words, if you have:\\n *     <code>\\n *     var x = new ArrayBuffer(1);\\n *     var y = new Int8Array(x);\\n *     y[0] = 2;\\n *     </code>\\n *     JSCompiler will not recognize that the last assignment modifies x.\\n *     We workaround this by marking all these arrays as @modifies {arguments},\\n *     to introduce the possibility that x aliases y.\\n */\\nfunction Int8Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nInt8Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Int8Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nInt8Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Int8Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nInt8Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Uint8Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nUint8Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Uint8Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nUint8Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Uint8Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nUint8Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Uint8ClampedArray(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nUint8ClampedArray.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Uint8ClampedArray}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nUint8ClampedArray.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Uint8ClampedArray}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nUint8ClampedArray.of = function(var_args) {};\\n\\n\\n/**\\n * @typedef {Uint8ClampedArray}\\n * @deprecated CanvasPixelArray has been replaced by Uint8ClampedArray\\n *     in the latest spec.\\n * @see http://www.w3.org/TR/2dcontext/#imagedata\\n */\\nvar CanvasPixelArray;\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Int16Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nInt16Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return";
a.a+=" {!Int16Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nInt16Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Int16Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nInt16Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Uint16Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nUint16Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Uint16Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nUint16Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Uint16Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nUint16Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Int32Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nInt32Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Int32Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nInt32Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Int32Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nInt32Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Uint32Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nUint32Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Uint32Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nUint32Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Uint32Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nUint32Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Float32Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nFloat32Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Float32Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nFloat32Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Float32Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nFloat32Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {number|ArrayBufferView|Array<number>|ArrayBuffer|SharedArrayBuffer}\\n *     length or array or buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_length\\n * @constructor\\n * @extends {TypedArray}\\n * @throws {Error}\\n * @modifies {arguments}\\n */\\nfunction Float64Array(length, opt_byteOffset, opt_length) {}\\n\\n/** @const {number} */\\nFloat64Array.BYTES_PER_ELEMENT;\\n\\n/**\\n * @param {string|!IArrayLike<number>|!Iterable<number>} source\\n * @param {function(this:S, number): number=} opt_mapFn\\n * @param {S=} opt_this\\n * @template S\\n * @return {!Float64Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/from\\n */\\nFloat64Array.from = function(source, opt_mapFn, opt_this) {};\\n\\n/**\\n * @param {...number} var_args\\n * @return {!Float64Array}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/of\\n */\\nFloat64Array.of = function(var_args) {};\\n\\n\\n/**\\n * @param {ArrayBuffer|SharedArrayBuffer} buffer\\n * @param {number=} opt_byteOffset\\n * @param {number=} opt_byteLength\\n * @constructor\\n * @extends {ArrayBufferView}\\n * @throws {Error}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Typed_arrays/DataView\\n */\\nfunction DataView(buffer, opt_byteOffset, opt_byteLength) {}\\n\\n/**\\n * @param {number} byteOffset\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getInt8 = function(byteOffset) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getUint8 = function(byteOffset) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {boolean=} opt_littleEndian\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getInt16 = function(byteOffset, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {boolean=} opt_littleEndian\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getUint16 = function(byteOffset, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {boolean=} opt_littleEndian\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getInt32 = function(byteOffset, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {boolean=} opt_littleEndian\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getUint32 = function(byteOffset, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {boolean=} opt_littleEndian\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getFloat32 = function(byteOffset, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {boolean=} opt_littleEndian\\n * @return {number}\\n * @throws {Error}\\n */\\nDataView.prototype.getFloat64 = function(byteOffset, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setInt8 = function(byteOffset, value) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setUint8 = function(byteOffset, value) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @param {boolean=} opt_littleEndian\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setInt16 = function(byteOffset, value, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @param {boolean=} opt_littleEndian\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setUint16 = function(byteOffset, value, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @param {boolean=} opt_littleEndian\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setInt32 = function(byteOffset, value, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @param {boolean=} opt_littleEndian\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setUint32 = function(byteOffset, value, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @param {boolean=} opt_littleEndian\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setFloat32 = function(\\n    byteOffset, value, opt_littleEndian) {};\\n\\n/**\\n * @param {number} byteOffset\\n * @param {number} value\\n * @param {boolean=} opt_littleEndian\\n * @throws {Error}\\n * @return {undefined}\\n */\\nDataView.prototype.setFloat64 = function(\\n    byteOffset, value, opt_littleEndian) {};\\n\\n\\n/**\\n * @see https://github.com/promises-aplus/promises-spec\\n * @typedef {{then: ?}}\\n */\\nvar Thenable;\\n\\n\\n/**\\n * This is not an official DOM interface. It is used to add generic typing\\n * and respective type inference where available.\\n * {@see goog.Thenable} inherits from this making all promises\\n * interoperate.\\n * @interface\\n * @template TYPE\\n */\\nfunction IThenable() {}\\n\\n\\n/**\\n * @param {?(function(TYPE):VALUE)=} opt_onFulfilled\\n * @param {?(function(*): *)=} opt_onRejected\\n * @return {RESULT}\\n * @template VALUE\\n *\\n * When a `Thenable` is fulfilled or rejected with another `Thenable`, the\\n * payload of the second is used as the payload of the first.\\n *\\n * @template RESULT := type('IThenable',\\n *     cond(isUnknown(VALUE), unknown(),\\n *       mapunion(VALUE, (V) =>\\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\\n *           templateTypeOf(V, 0),\\n *           cond(sub(V, 'Thenable'),\\n *              unknown(),\\n *              V)))))\\n * =:\\n */\\nIThenable.prototype.then = function(opt_onFulfilled, opt_onRejected) {};\\n\\n\\n/**\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise\\n * @param {function(\\n *             function((TYPE|IThenable<TYPE>|Thenable|null)=),\\n *             function(*=))} resolver\\n * @constructor\\n * @implements {IThenable<TYPE>}\\n * @template TYPE\\n */\\nfunction Promise(resolver) {}\\n\\n\\n/**\\n * @param {VALUE=} opt_value\\n * @return {RESULT}\\n * @template VALUE\\n * @template RESULT := type('Promise',\\n *     cond(isUnknown(VALUE), unknown(),\\n *       mapunion(VALUE, (V) =>\\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\\n *           templateTypeOf(V, 0),\\n *           cond(sub(V, 'Thenable'),\\n *              unknown(),\\n *              V)))))\\n * =:\\n */\\nPromise.resolve = function(opt_value) {};\\n\\n\\n/**\\n * @param {*=} opt_error\\n * @return {!Promise<?>}\\n */\\nPromise.reject = function(opt_error) {};\\n\\n\\n/**\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise\\n * @param {!Iterable<VALUE>} iterable\\n * @return {!Promise<!Array<RESULT>>}\\n * @template VALUE\\n * @template RESULT := mapunion(VALUE, (V) =>\\n *     cond(isUnknown(V),\\n *         unknown(),\\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\\n *             templateTypeOf(V, 0),\\n *             cond(sub(V, 'Thenable'), unknown(), V))))\\n * =:\\n */\\nPromise.all = function(iterable) {};\\n\\n\\n/**\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise\\n * @param {!Iterable<VALUE>} iterable\\n * @return {!Promise<RESULT>}\\n * @template VALUE\\n * @template RESULT := mapunion(VALUE, (V) =>\\n *     cond(isUnknown(V),\\n *         unknown(),\\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\\n *             templateTypeOf(V, 0),\\n *             cond(sub(V, 'Thenable'), unknown(), V))))\\n * =:\\n */\\nPromise.race = function(iterable) {};\\n\\n\\n/**\\n * @param {?(function(this:void, TYPE):VALUE)=} opt_onFulfilled\\n * @param {?(function(this:void, *): *)=} opt_onRejected\\n * @return {RESULT}\\n * @template VALUE\\n *\\n * When a `Thenable` is fulfilled or rejected with another `Thenable`, the\\n * payload of the second is used as the payload of the first.\\n *\\n * @template RESULT := type('Promise',\\n *     cond(isUnknown(VALUE), unknown(),\\n *       mapunion(VALUE, (V) =>\\n *         cond(isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\\n *           templateTypeOf(V, 0),\\n *           cond(sub(V, 'Thenable'),\\n *              unknown(),\\n *              V)))))\\n * =:\\n * @override\\n */\\nPromise.prototype.then = function(opt_onFulfilled, opt_onRejected) {};\\n\\n\\n/**\\n * @param {function(*):VALUE} onRejected\\n * @return {!Promise<TYPE|RESULT>} A Promise of the original type or a possibly\\n *     a different type depending on whether the parent promise was rejected.\\n *\\n * @template VALUE\\n *\\n * When a `Thenable` is rejected with another `Thenable`, the payload of the\\n * second is used as the payload of the first.\\n *\\n * @template RESULT := cond(\\n *     isUnknown(VALUE),\\n *     unknown(),\\n *     mapunion(VALUE, (V) =>\\n *         cond(\\n *             isTemplatized(V) && sub(rawTypeOf(V), 'IThenable'),\\n *             templateTypeOf(V, 0),\\n *             cond(\\n *                 sub(V, 'Thenable'),\\n *                 unknown(),\\n *                 V))))\\n * =:\\n */\\nPromise.prototype.catch = function(onRejected) {};\\n\\n\\n/**\\n * @param {function()} callback\\n * @return {!Promise<TYPE>}\\n */\\nPromise.prototype.finally = function(callback) {};\\n\\n\\n/**\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/of\\n * @param {...T} var_args\\n * @return {!Array<T>}\\n * @template T\\n */\\nArray.of = function(var_args) {};\\n\\n\\n/**\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from\\n * @param {string|!IArrayLike<T>|!Iterable<T>} arrayLike\\n * @param {function(this:S, (string|T), number): R=} opt_mapFn\\n * @param {S=} opt_this\\n * @return {!Array<R>}\\n * @template T,S,R\\n */\\nArray.from = function(arrayLike, opt_mapFn, opt_this) {};\\n\\n\\n/** @return {!IteratorIterable<number>} */\\nArray.prototype.keys;\\n\\n\\n/**\\n * @return {!IteratorIterable<T>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/values\\n */\\nArray.prototype.values;\\n\\n\\n/**\\n * @return {!IteratorIterable<!Array<number|T>>} Iterator of [key, value] pairs.\\n */\\nArray.prototype.entries;\\n\\n\\n/**\\n * @param {!function(this:S, T, number, !Array<T>): boolean} predicateFn\\n * @param {S=} opt_this\\n * @return {T|undefined}\\n * @this {IArrayLike<T>|string}\\n * @template T,S\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.find\\n */\\nArray.prototype.find = function(predicateFn, opt_this) {};\\n\\n\\n/**\\n * @param {!function(this:S, T, number, !Array<T>): boolean} predicateFn\\n * @param {S=} opt_this\\n * @return {number}\\n * @this {IArrayLike<T>|string}\\n * @template T,S\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.findindex\\n */\\nArray.prototype.findIndex = function(predicateFn, opt_this) {};\\n\\n\\n/**\\n * @param {T} value\\n * @param {number=} opt_begin\\n * @param {number=} opt_end\\n * @return {!Array<T>}\\n * @this {!IArrayLike<T>|string}\\n * @template T\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.fill\\n */\\nArray.prototype.fill = function(value, opt_begin, opt_end) {};\\n\\n\\n/**\\n * @param {number} target\\n * @param {number} start\\n * @param {number=} opt_end\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-array.prototype.copywithin\\n * @template T\\n * @return {!Array<T>}\\n */\\nArray.prototype.copyWithin = function(target, start, opt_end) {};\\n\\n\\n/**\\n * NOTE: this is an ES2016 (ES7) extern.\\n * @param {T} searchElement\\n * @param {number=} opt_fromIndex\\n * @return {boolean}\\n * @this {!IArrayLike<T>|string}\\n * @template T\\n * @nosideeffects\\n * @see https://tc39.github.io/ecma262/#sec-array.prototype.includes\\n */\\nArray.prototype.includes = function(searchElement, opt_fromIndex) {};\\n\\n/**\\n * NOTE: this is a stage 3 proposal extern.\\n * @param {function(this: THIS, T, number, !IArrayLike<T>): S|!Array<S>}\\n *     callback\\n * @param {THIS=} thisArg\\n * @return {!Array<S>}";
a.a+='\\n * @this {!IArrayLike<T>}\\n * @template T, THIS, S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flatMap\\n */\\nArray.prototype.flatMap = function(callback, thisArg) {};\\n\\n/**\\n * NOTE: this is a stage 3 proposal extern.\\n * @param {*=} depth\\n * @return {!Array<S>}\\n * @this {!IArrayLike<T>}\\n * @template T, S\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flat\\n */\\nArray.prototype.flat = function(depth) {};\\n\\n/**\\n * @param {!Object} obj\\n * @return {!Array<symbol>}\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-object.getownpropertysymbols\\n */\\nObject.getOwnPropertySymbols = function(obj) {};\\n\\n\\n/**\\n * @param {!Object} obj\\n * @param {?} proto\\n * @return {!Object}\\n * @see http://www.ecma-international.org/ecma-262/6.0/#sec-object.setprototypeof\\n */\\nObject.setPrototypeOf = function(obj, proto) {};\\n\\n\\n/**\\n * @const {number}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/EPSILON\\n */\\nNumber.EPSILON;\\n\\n/**\\n * @const {number}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MIN_SAFE_INTEGER\\n */\\nNumber.MIN_SAFE_INTEGER;\\n\\n/**\\n * @const {number}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/MAX_SAFE_INTEGER\\n */\\nNumber.MAX_SAFE_INTEGER;\\n\\n\\n\\n/**\\n * Parse an integer. Use of `parseInt` without `base` is strictly\\n * banned in Google. If you really want to parse octal or hex based on the\\n * leader, then pass `undefined` as the base.\\n *\\n * @param {string} string\\n * @param {number|undefined} radix\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/parseInt\\n */\\nNumber.parseInt = function(string, radix) {};\\n\\n/**\\n * @param {string} string\\n * @return {number}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/parseFloat\\n */\\nNumber.parseFloat = function(string) {};\\n\\n/**\\n * @param {number} value\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isNaN\\n */\\nNumber.isNaN = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isFinite\\n */\\nNumber.isFinite = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isInteger\\n */\\nNumber.isInteger = function(value) {};\\n\\n/**\\n * @param {number} value\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isSafeInteger\\n */\\nNumber.isSafeInteger = function(value) {};\\n\\n\\n\\n/**\\n * @param {!Object} target\\n * @param {...(Object|null|undefined)} var_args\\n * @return {!Object}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign\\n */\\nObject.assign = function(target, var_args) {};\\n\\n/**\\n * TODO(dbeam): find a better place for ES2017 externs like this one.\\n * NOTE: this is an ES2017 (ES8) extern.\\n * @param {!Object<T>} obj\\n * @return {!Array<T>} values\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/values\\n * @throws {Error}\\n * @template T\\n */\\nObject.values = function(obj) {};\\n\\n/**\\n * NOTE: this is an ES2017 (ES8) extern.\\n * @param {!Object<T>} obj\\n * @return {!Array<!Array<(string|T)>>} entries\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/entries\\n * @throws {Error}\\n * @template T\\n */\\nObject.entries = function(obj) {};\\n\\n/**\\n * NOTE: this is an ES2017 (ES8) extern.\\n * @param {!Object} obj\\n * @return {!Object<!ObjectPropertyDescriptor>} descriptors\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/getOwnPropertyDescriptors\\n * @throws {Error}\\n * @template T\\n */\\nObject.getOwnPropertyDescriptors = function(obj) {};\\n\\n\\n\\n/**\\n * @const\\n * @see http://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect\\n */\\nvar Reflect = {};\\n\\n/**\\n * @param {function(this: THIS, ...?): RESULT} targetFn\\n * @param {THIS} thisArg\\n * @param {!Array<?>} argList\\n * @return {RESULT}\\n * @template THIS, RESULT\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/apply\\n */\\nReflect.apply = function(targetFn, thisArg, argList) {};\\n\\n/**\\n * @param {function(new: ?, ...?)} targetConstructorFn\\n * @param {!Array<?>} argList\\n * @param {function(new: TARGET, ...?)=} opt_newTargetConstructorFn\\n * @return {TARGET}\\n * @template TARGET\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/construct\\n */\\nReflect.construct = function(targetConstructorFn, argList, opt_newTargetConstructorFn) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {string} propertyKey\\n * @param {!ObjectPropertyDescriptor} attributes\\n * @return {boolean}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/defineProperty\\n */\\nReflect.defineProperty = function(target, propertyKey, attributes) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {string} propertyKey\\n * @return {boolean}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/deleteProperty\\n */\\nReflect.deleteProperty = function(target, propertyKey) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {string} propertyKey\\n * @param {!Object=} opt_receiver\\n * @return {*}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/get\\n */\\nReflect.get = function(target, propertyKey, opt_receiver) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {string} propertyKey\\n * @return {?ObjectPropertyDescriptor}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/getOwnPropertyDescriptor\\n */\\nReflect.getOwnPropertyDescriptor = function(target, propertyKey) {};\\n\\n/**\\n * @param {!Object} target\\n * @return {?Object}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/getPrototypeOf\\n */\\nReflect.getPrototypeOf = function(target) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {string} propertyKey\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/has\\n */\\nReflect.has = function(target, propertyKey) {};\\n\\n/**\\n * @param {!Object} target\\n * @return {boolean}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/isExtensible\\n */\\nReflect.isExtensible = function(target) {};\\n\\n/**\\n * @param {!Object} target\\n * @return {!Array<(string|symbol)>}\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/ownKeys\\n */\\nReflect.ownKeys = function(target) {};\\n\\n/**\\n * @param {!Object} target\\n * @return {boolean}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/preventExtensions\\n */\\nReflect.preventExtensions = function(target) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {string} propertyKey\\n * @param {*} value\\n * @param {!Object=} opt_receiver\\n * @return {boolean}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/set\\n */\\nReflect.set = function(target, propertyKey, value, opt_receiver) {};\\n\\n/**\\n * @param {!Object} target\\n * @param {?Object} proto\\n * @return {boolean}\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/setPrototypeOf\\n */\\nReflect.setPrototypeOf = function(target, proto) {};\\n\\n\\n/**\\n * @const\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Atomics\\n */\\nvar Atomics = {};\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.add = function(typedArray, index, value) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.and = function(typedArray, index, value) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} expectedValue\\n * @param {number} replacementValue\\n * @return {number}\\n */\\nAtomics.compareExchange = function(typedArray, index, expectedValue,\\n    replacementValue) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.exchange = function(typedArray, index, value) {}\\n\\n/**\\n * @param {number} size\\n * @return {boolean}\\n */\\nAtomics.isLockFree = function(size) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @return {number}\\n */\\nAtomics.load = function(typedArray, index) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.or = function(typedArray, index, value) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.store = function(typedArray, index, value) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.sub = function(typedArray, index, value) {}\\n\\n/**\\n * @param {!Int32Array} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @param {number=} timeout\\n * @return {String}\\n */\\nAtomics.wait = function(typedArray, index, value, timeout) {}\\n\\n/**\\n * @param {!Int32Array} typedArray\\n * @param {number} index\\n * @param {number} count\\n * @return {number}\\n */\\nAtomics.wake = function(typedArray, index, count) {}\\n\\n/**\\n * @param {!TypedArray} typedArray\\n * @param {number} index\\n * @param {number} value\\n * @return {number}\\n */\\nAtomics.xor = function(typedArray, index, value) {}\\n\\n\\n/**\\n * @see https://tc39.github.io/proposal-async-iteration/\\n * @const {symbol}\\n */\\nSymbol.asyncIterator;\\n\\n\\n/**\\n * @interface\\n * @template VALUE\\n * @see https://tc39.github.io/proposal-async-iteration/\\n */\\nfunction AsyncIterator() {}\\n\\n/**\\n * @param {?=} opt_value\\n * @return {!Promise<!IIterableResult<VALUE>>}\\n */\\nAsyncIterator.prototype.next;\\n\\n\\n/**\\n * @interface\\n * @template VALUE\\n */\\nfunction AsyncIterable() {}\\n\\n\\n/**\\n * @return {!AsyncIterator<VALUE>}\\n */\\nAsyncIterable.prototype[Symbol.asyncIterator] = function() {};\\n\\n\\n/**\\n * @interface\\n * @extends {AsyncIterator<VALUE>}\\n * @extends {AsyncIterable<VALUE>}\\n * @template VALUE\\n * @see https://tc39.github.io/proposal-async-iteration/\\n */\\nfunction AsyncIteratorIterable() {}\\n\\n/**\\n * @interface\\n * @see https://tc39.github.io/proposal-async-iteration/\\n * @extends {AsyncIteratorIterable<VALUE>}\\n * @template VALUE\\n */\\nfunction AsyncGenerator() {}\\n\\n/**\\n * @param {?=} opt_value\\n * @return {!Promise<!IIterableResult<VALUE>>}\\n * @override\\n */\\nAsyncGenerator.prototype.next = function(opt_value) {};\\n\\n/**\\n * @param {VALUE} value\\n * @return {!Promise<!IIterableResult<VALUE>>}\\n */\\nAsyncGenerator.prototype.return = function(value) {};\\n\\n/**\\n * @param {?} exception\\n * @return {!Promise<!IIterableResult<VALUE>>}\\n */\\nAsyncGenerator.prototype.throw = function(exception) {};\\n","externs/es6_collections.js":"/*\\n * Copyright 2014 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for ECMAScript 6.\\n * @see http://wiki.ecmascript.org/doku.php?id=harmony:specification_drafts\\n * @externs\\n */\\n\\n// TODO(johnlenz): Use Tuples for the Map and Set iterators where appropriate.\\n\\n/**\\n * @constructor @struct\\n * @param {Iterable<!Array<KEY|VALUE>>|!Array<!Array<KEY|VALUE>>=} opt_iterable\\n * @implements {Iterable<!Array<KEY|VALUE>>}\\n * @template KEY, VALUE\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map\\n */\\nfunction Map(opt_iterable) {}\\n\\n/** @return {void} */\\nMap.prototype.clear = function() {};\\n\\n/**\\n * @param {KEY} key\\n * @return {boolean}\\n */\\nMap.prototype.delete = function(key) {};\\n\\n/**\\n * @return {!IteratorIterable<!Array<KEY|VALUE>>}\\n * @nosideeffects\\n */\\nMap.prototype.entries = function() {};\\n\\n/**\\n * @param {function(this:THIS, VALUE, KEY, MAP)} callback\\n * @param {THIS=} opt_thisArg\\n * @this {MAP}\\n * @template MAP,THIS\\n */\\nMap.prototype.forEach = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {KEY} key\\n * @return {VALUE}\\n * @nosideeffects\\n */\\nMap.prototype.get = function(key) {};\\n\\n/**\\n * @param {KEY} key\\n * @return {boolean}\\n * @nosideeffects\\n */\\nMap.prototype.has = function(key) {};\\n\\n/**\\n * @return {!IteratorIterable<KEY>}\\n * @nosideeffects\\n */\\nMap.prototype.keys = function() {};\\n\\n/**\\n * @param {KEY} key\\n * @param {VALUE} value\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n */\\nMap.prototype.set = function(key, value) {};\\n\\n/**\\n * @type {number}\\n * (readonly)\\n */\\nMap.prototype.size;\\n\\n/**\\n * @return {!IteratorIterable<VALUE>}\\n * @nosideeffects\\n */\\nMap.prototype.values = function() {};\\n\\n/**\\n * @return {!Iterator<!Array<KEY|VALUE>>}\\n */\\nMap.prototype[Symbol.iterator] = function() {};\\n\\n\\n/**\\n * @constructor @struct\\n * @param {Iterable<!Array<KEY|VALUE>>|!Array<!Array<KEY|VALUE>>=} opt_iterable\\n * @template KEY, VALUE\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap\\n */\\nfunction WeakMap(opt_iterable) {}\\n\\n/** @return {void} */\\nWeakMap.prototype.clear = function() {};\\n\\n/**\\n * @param {KEY} key\\n * @return {boolean}\\n */\\nWeakMap.prototype.delete = function(key) {};\\n\\n/**\\n * @param {KEY} key\\n * @return {VALUE}\\n * @nosideeffects\\n */\\nWeakMap.prototype.get = function(key) {};\\n\\n/**\\n * @param {KEY} key\\n * @return {boolean}\\n * @nosideeffects\\n */\\nWeakMap.prototype.has = function(key) {};\\n\\n/**\\n * @param {KEY} key\\n * @param {VALUE} value\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n */\\nWeakMap.prototype.set = function(key, value) {};\\n\\n/**\\n * @constructor @struct\\n * @param {Iterable<VALUE>|Array<VALUE>=} opt_iterable\\n * @implements {Iterable<VALUE>}\\n * @template VALUE\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set\\n */\\nfunction Set(opt_iterable) {}\\n\\n/**\\n * @param {VALUE} value\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n */\\nSet.prototype.add = function(value) {};\\n\\n/**\\n * @return {void}\\n */\\nSet.prototype.clear = function() {};\\n\\n/**\\n * @param {VALUE} value\\n * @return {boolean}\\n */\\nSet.prototype.delete = function(value) {};\\n\\n/**\\n * @return {!IteratorIterable<!Array<VALUE>>} Where each array has two entries:\\n *     [value, value]\\n * @nosideeffects\\n */\\nSet.prototype.entries = function() {};\\n\\n/**\\n * @param {function(this: THIS, VALUE, VALUE, SET)} callback\\n * @param {THIS=} opt_thisArg\\n * @this {SET}\\n * @template SET,THIS\\n */\\nSet.prototype.forEach = function(callback, opt_thisArg) {};\\n\\n/**\\n * @param {VALUE} value\\n * @return {boolean}\\n * @nosideeffects\\n */\\nSet.prototype.has = function(value) {};\\n\\n/**\\n * @type {number} (readonly)\\n */\\nSet.prototype.size;\\n\\n/**';
a.a+='\\n * @return {!IteratorIterable<VALUE>}\\n * @nosideeffects\\n */\\nSet.prototype.keys = function() {};\\n\\n/**\\n * @return {!IteratorIterable<VALUE>}\\n * @nosideeffects\\n */\\nSet.prototype.values = function() {};\\n\\n/**\\n * @return {!Iterator<VALUE>}\\n */\\nSet.prototype[Symbol.iterator] = function() {};\\n\\n\\n\\n/**\\n * @constructor @struct\\n * @param {Iterable<VALUE>|Array<VALUE>=} opt_iterable\\n * @template VALUE\\n * @nosideeffects\\n * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set\\n */\\nfunction WeakSet(opt_iterable) {}\\n\\n/**\\n * @param {VALUE} value\\n * @return {THIS}\\n * @this {THIS}\\n * @template THIS\\n */\\nWeakSet.prototype.add = function(value) {};\\n\\n/**\\n * @return {void}\\n */\\nWeakSet.prototype.clear = function() {};\\n\\n/**\\n * @param {VALUE} value\\n * @return {boolean}\\n */\\nWeakSet.prototype.delete = function(value) {};\\n\\n/**\\n * @param {VALUE} value\\n * @return {boolean}\\n * @nosideeffects\\n */\\nWeakSet.prototype.has = function(value) {};\\n","externs/intl.js":"/*\\n * Copyright 2013 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for the JS Internationalization API as defined in\\n * http://www.ecma-international.org/ecma-402/1.0/\\n *\\n * @externs\\n */\\n\\n/** @const */\\nvar Intl = {};\\n\\n/**\\n * NOTE: this API is not from ecma402 and is subject to change.\\n * @param {string|Array<string>=} opt_locales\\n * @param {{type: (string|undefined)}=}\\n *         opt_options\\n * @constructor\\n */\\nIntl.v8BreakIterator = function(opt_locales, opt_options) {};\\n\\n/**\\n * @param {string} text\\n * @return {undefined}\\n */\\nIntl.v8BreakIterator.prototype.adoptText = function(text) {};\\n\\n/**\\n * @return {string}\\n */\\nIntl.v8BreakIterator.prototype.breakType = function() {};\\n\\n/**\\n * @return {number}\\n */\\nIntl.v8BreakIterator.prototype.current = function() {};\\n\\n/**\\n * @return {number}\\n */\\nIntl.v8BreakIterator.prototype.first = function() {};\\n\\n/**\\n * @return {number}\\n */\\nIntl.v8BreakIterator.prototype.next = function() {};\\n\\n/**\\n * @constructor\\n * @param {string|Array<string>=} opt_locales\\n * @param {{usage: (string|undefined), localeMatcher: (string|undefined),\\n *     sensitivity: (string|undefined), ignorePunctuation: (boolean|undefined),\\n *     numeric: (boolean|undefined), caseFirst: (string|undefined)}=}\\n *         opt_options\\n */\\nIntl.Collator = function(opt_locales, opt_options) {};\\n\\n/**\\n * @param {Array<string>} locales\\n * @param {{localeMatcher: (string|undefined)}=} opt_options\\n * @return {Array<string>}\\n */\\nIntl.Collator.supportedLocalesOf = function(locales, opt_options) {};\\n\\n/**\\n * @param {string} arg1\\n * @param {string} arg2\\n * @return {number}\\n */\\nIntl.Collator.prototype.compare = function(arg1, arg2) {};\\n\\n/**\\n * @return {{locale: string, usage: string, sensitivity: string,\\n *     ignorePunctuation: boolean, collation: string, numeric: boolean,\\n *     caseFirst: string}}\\n */\\nIntl.Collator.prototype.resolvedOptions = function() {};\\n\\n/**\\n * @constructor\\n * @param {string|Array<string>=} opt_locales\\n * @param {{localeMatcher: (string|undefined), useGrouping: (boolean|undefined),\\n *     numberingSystem: (string|undefined), style: (string|undefined),\\n *     currency: (string|undefined), currencyDisplay: (string|undefined),\\n *     minimumIntegerDigits: (number|undefined),\\n *     minimumFractionDigits: (number|undefined),\\n *     maximumFractionDigits: (number|undefined),\\n *     minimumSignificantDigits: (number|undefined),\\n *     maximumSignificantDigits: (number|undefined)}=}\\n *         opt_options\\n */\\nIntl.NumberFormat = function(opt_locales, opt_options) {};\\n\\n/**\\n * @param {Array<string>} locales\\n * @param {{localeMatcher: (string|undefined)}=} opt_options\\n * @return {Array<string>}\\n */\\nIntl.NumberFormat.supportedLocalesOf = function(locales, opt_options) {};\\n\\n/**\\n * @param {number} num\\n * @return {string}\\n */\\nIntl.NumberFormat.prototype.format = function(num) {};\\n\\n/**\\n * @return {{locale: string, numberingSystem: string, style: string,\\n *     currency: (string|undefined), currencyDisplay: (string|undefined),\\n *     minimumIntegerDigits: number, minimumFractionDigits: number,\\n *     maximumFractionDigits: number, minimumSignificantDigits: number,\\n *     maximumSignificantDigits: number, useGrouping: boolean}}\\n */\\nIntl.NumberFormat.prototype.resolvedOptions = function() {};\\n\\n/**\\n * @constructor\\n * @param {string|Array<string>=} opt_locales\\n * @param {{localeMatcher: (string|undefined),\\n *    formatMatcher: (string|undefined), calendar: (string|undefined),\\n *    numberingSystem: (string|undefined), tz: (string|undefined),\\n *    weekday: (string|undefined), era: (string|undefined),\\n *    year: (string|undefined), month: (string|undefined),\\n *    day: (string|undefined), hour: (string|undefined),\\n *    minute: (string|undefined), second: (string|undefined),\\n *    timeZoneName: (string|undefined), hour12: (boolean|undefined)}=}\\n *        opt_options\\n */\\nIntl.DateTimeFormat = function(opt_locales, opt_options) {};\\n\\n/**\\n * @param {Array<string>} locales\\n * @param {{localeMatcher: string}=} opt_options\\n * @return {Array<string>}\\n */\\nIntl.DateTimeFormat.supportedLocalesOf = function(locales, opt_options) {};\\n\\n/**\\n * @param {(!Date|number)=} date\\n * @return {string}\\n */\\nIntl.DateTimeFormat.prototype.format = function(date) {};\\n\\n/**\\n * @param {(!Date|number)=} date\\n * @return {Array<{type: string, value: string}>}\\n */\\nIntl.DateTimeFormat.prototype.formatToParts = function(date) {};\\n\\n/**\\n * @return {{locale: string, calendar: string, numberingSystem: string,\\n *    timeZone: (string|undefined), weekday: (string|undefined),\\n *    era: (string|undefined), year: (string|undefined),\\n *    month: (string|undefined), day: (string|undefined),\\n *    hour: (string|undefined), minute: (string|undefined),\\n *    second: (string|undefined), timeZoneName: (string|undefined),\\n *    hour12: (boolean|undefined)}}\\n */\\nIntl.DateTimeFormat.prototype.resolvedOptions = function() {};\\n","externs/w3c_event.js":"/*\\n * Copyright 2008 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for W3C\'s event specification.\\n *  The whole file has been fully type annotated.\\n *  Created from\\n *   http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\\n *\\n * @externs\\n * @author acleung@google.com (Alan Leung)\\n */\\n\\n\\n/**\\n * @interface\\n * @see https://dom.spec.whatwg.org/#interface-eventtarget\\n */\\nfunction EventTarget() {}\\n\\n/**\\n * @param {string} type\\n * @param {EventListener|function(!Event):*} listener\\n * @param {(boolean|!AddEventListenerOptions)=} opt_options\\n * @return {undefined}\\n * @see https://dom.spec.whatwg.org/#dom-eventtarget-addeventlistener\\n */\\nEventTarget.prototype.addEventListener = function(type, listener, opt_options) {\\n};\\n\\n/**\\n * @param {string} type\\n * @param {EventListener|function(!Event):*} listener\\n * @param {(boolean|!EventListenerOptions)=} opt_options\\n * @return {undefined}\\n * @see https://dom.spec.whatwg.org/#dom-eventtarget-removeeventlistener\\n */\\nEventTarget.prototype.removeEventListener = function(\\n    type, listener, opt_options) {};\\n\\n/**\\n * @param {!Event} evt\\n * @return {boolean}\\n * @see https://dom.spec.whatwg.org/#dom-eventtarget-dispatchevent\\n */\\nEventTarget.prototype.dispatchEvent = function(evt) {};\\n\\n/**\\n * @interface\\n */\\nfunction EventListener() {}\\n\\n/**\\n * @param {!Event} evt\\n * @return {undefined}\\n */\\nEventListener.prototype.handleEvent = function(evt) {};\\n\\n// The EventInit interface and the parameters to the Event constructor are part\\n// of DOM Level 3 (suggested) and the DOM \\"Living Standard\\" (mandated). They are\\n// included here as externs cannot be redefined. The same applies to other\\n// *EventInit interfaces and *Event constructors throughout this file. See:\\n// http://www.w3.org/TR/DOM-Level-3-Events/#event-initializers\\n// http://dom.spec.whatwg.org/#constructing-events\\n// https://dvcs.w3.org/hg/d4e/raw-file/tip/source_respec.htm#event-constructors\\n\\n/**\\n * @record\\n * @see https://dom.spec.whatwg.org/#dictdef-eventinit\\n */\\nfunction EventInit() {}\\n\\n/** @type {(undefined|boolean)} */\\nEventInit.prototype.bubbles;\\n\\n/** @type {(undefined|boolean)} */\\nEventInit.prototype.cancelable;\\n\\n/** @type {(undefined|boolean)} */\\nEventInit.prototype.composed;\\n\\n\\n/**\\n * @constructor\\n * @param {string} type\\n * @param {EventInit=} opt_eventInitDict\\n */\\nfunction Event(type, opt_eventInitDict) {}\\n\\n/**\\n * @const {number}\\n * @see http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\\n */\\nEvent.CAPTURING_PHASE;\\n\\n/**\\n * @const {number}\\n * @see http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\\n */\\nEvent.AT_TARGET;\\n\\n/**\\n * @const {number}\\n * @see http://www.w3.org/TR/DOM-Level-2-Events/ecma-script-binding.html\\n */\\nEvent.BUBBLING_PHASE;\\n\\n/** @type {string} */\\nEvent.prototype.type;\\n\\n/** @type {EventTarget} */\\nEvent.prototype.target;\\n\\n/** @type {EventTarget} */\\nEvent.prototype.currentTarget;\\n\\n/** @type {number} */\\nEvent.prototype.eventPhase;\\n\\n/** @type {boolean} */\\nEvent.prototype.bubbles;\\n\\n/** @type {boolean} */\\nEvent.prototype.cancelable;\\n\\n/** @type {number} */\\nEvent.prototype.timeStamp;\\n\\n/**\\n * Present for events spawned in browsers that support shadow dom.\\n * @type {Array<!Element>|undefined}\\n */\\nEvent.prototype.path;\\n\\n/**\\n * Present for events spawned in browsers that support shadow dom.\\n * @type {function():Array<!EventTarget>|undefined}\\n * @see https://www.w3.org/TR/shadow-dom/#widl-Event-deepPath\\n */\\nEvent.prototype.deepPath;\\n\\n/**\\n * @return {undefined}\\n */\\nEvent.prototype.stopPropagation = function() {};\\n\\n/**\\n * @return {undefined}\\n */\\nEvent.prototype.preventDefault = function() {};\\n\\n/**\\n * @param {string} eventTypeArg\\n * @param {boolean=} canBubbleArg\\n * @param {boolean=} cancelableArg\\n * @return {undefined}\\n */\\nEvent.prototype.initEvent = function(eventTypeArg, canBubbleArg, cancelableArg) {};\\n\\n/**\\n * @record\\n * @extends {EventInit}\\n * @template T\\n * @see https://dom.spec.whatwg.org/#dictdef-customeventinit\\n */\\nfunction CustomEventInit() {}\\n\\n/** @type {(T|undefined)} */\\nCustomEventInit.prototype.detail;\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n * @param {string} type\\n * @param {CustomEventInit<T>=} opt_eventInitDict\\n * @template T\\n * @see http://www.w3.org/TR/DOM-Level-3-Events/#interface-CustomEvent\\n */\\nfunction CustomEvent(type, opt_eventInitDict) {}\\n\\n/**\\n * @param {string} eventType\\n * @param {boolean} bubbles\\n * @param {boolean} cancelable\\n * @param {T} detail\\n * @return {undefined}\\n */\\nCustomEvent.prototype.initCustomEvent = function(\\n    eventType, bubbles, cancelable, detail) {};\\n\\n/**\\n * @type {T}\\n */\\nCustomEvent.prototype.detail;\\n\\n/**\\n * @interface\\n */\\nfunction DocumentEvent() {}\\n\\n/**\\n * @param {string} eventType\\n * @return {!Event}\\n */\\nDocumentEvent.prototype.createEvent = function(eventType) {};\\n\\n/**\\n * @record\\n * @extends {EventInit}\\n * @see https://w3c.github.io/uievents/#idl-uieventinit\\n */\\nfunction UIEventInit() {}\\n\\n/** @type {undefined|?Window} */\\nUIEventInit.prototype.view;\\n\\n/** @type {undefined|number} */\\nUIEventInit.prototype.detail;\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n * @param {string} type\\n * @param {UIEventInit=} opt_eventInitDict\\n */\\nfunction UIEvent(type, opt_eventInitDict) {}\\n\\n/** @type {number} */\\nUIEvent.prototype.detail;\\n\\n/**\\n * @param {string} typeArg\\n * @param {boolean} canBubbleArg\\n * @param {boolean} cancelableArg\\n * @param {Window} viewArg\\n * @param {number} detailArg\\n * @return {undefined}\\n */\\nUIEvent.prototype.initUIEvent = function(typeArg, canBubbleArg, cancelableArg,\\n    viewArg, detailArg) {};\\n\\n/**\\n * @record\\n * @extends {UIEventInit}\\n * @see https://w3c.github.io/uievents/#dictdef-eventmodifierinit\\n */\\nfunction EventModifierInit() {}\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.ctrlKey;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.shiftKey;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.altKey;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.metaKey;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierAltGraph;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierCapsLock;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierFn;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierFnLock;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierHyper;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierNumLock;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierScrollLock;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierSuper;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierSymbol;\\n\\n/** @type {undefined|boolean} */\\nEventModifierInit.prototype.modifierSymbolLock;\\n\\n/**\\n * @record\\n * @extends {EventModifierInit}\\n * @see https://w3c.github.io/uievents/#idl-mouseeventinit\\n */\\nfunction MouseEventInit() {}\\n\\n/** @type {undefined|number} */\\nMouseEventInit.prototype.screenX;\\n\\n/** @type {undefined|number} */\\nMouseEventInit.prototype.screenY;\\n\\n/** @type {undefined|number} */\\nMouseEventInit.prototype.clientX;\\n\\n/** @type {undefined|number} */\\nMouseEventInit.prototype.clientY;\\n\\n/** @type {undefined|number} */\\nMouseEventInit.prototype.button;\\n\\n/** @type {undefined|number} */\\nMouseEventInit.prototype.buttons;\\n\\n/** @type {undefined|?EventTarget} */\\nMouseEventInit.prototype.relatedTarget;\\n\\n/**\\n * @constructor\\n * @extends {UIEvent}\\n * @param {string} type\\n * @param {MouseEventInit=} opt_eventInitDict\\n */\\nfunction MouseEvent(type, opt_eventInitDict) {}\\n\\n/** @type {number} */\\nMouseEvent.prototype.screenX;\\n\\n/** @type {number} */\\nMouseEvent.prototype.screenY;\\n\\n/** @type {number} */\\nMouseEvent.prototype.clientX;\\n\\n/** @type {number} */\\nMouseEvent.prototype.clientY;\\n\\n/** @type {boolean} */\\nMouseEvent.prototype.ctrlKey;\\n\\n/** @type {boolean} */\\nMouseEvent.prototype.shiftKey;\\n\\n/** @type {boolean} */\\nMouseEvent.prototype.altKey;\\n\\n/** @type {boolean} */\\nMouseEvent.prototype.metaKey;\\n\\n/** @type {number} */\\nMouseEvent.prototype.button;\\n\\n/** @type {EventTarget} */\\nMouseEvent.prototype.relatedTarget;\\n\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n */\\nfunction MutationEvent() {}\\n\\n/** @type {Node} */\\nMutationEvent.prototype.relatedNode;\\n\\n/** @type {string} */\\nMutationEvent.prototype.prevValue;\\n\\n/** @type {string} */\\nMutationEvent.prototype.newValue;\\n\\n/** @type {string} */\\nMutationEvent.prototype.attrName;\\n\\n/** @type {number} */\\nMutationEvent.prototype.attrChange;\\n\\n/**\\n * @param {string} typeArg\\n * @param {boolean} canBubbleArg\\n * @param {boolean} cancelableArg\\n * @param {Node} relatedNodeArg\\n * @param {string} prevValueArg\\n * @param {string} newValueArg\\n * @param {string} attrNameArg\\n * @param {number} attrChangeArg\\n * @return {undefined}\\n */\\nMutationEvent.prototype.initMutationEvent = function(typeArg, canBubbleArg, cancel';
a.a+='ableArg, relatedNodeArg, prevValueArg, newValueArg, attrNameArg, attrChangeArg) {};\\n\\n\\n// DOM3\\n/**\\n * @record\\n * @extends {EventModifierInit}\\n * @see https://w3c.github.io/uievents/#idl-keyboardeventinit\\n */\\nfunction KeyboardEventInit() {}\\n\\n/** @type {undefined|string} */\\nKeyboardEventInit.prototype.key;\\n\\n/** @type {undefined|string} */\\nKeyboardEventInit.prototype.code;\\n\\n/** @type {undefined|number} */\\nKeyboardEventInit.prototype.location;\\n\\n/** @type {undefined|boolean} */\\nKeyboardEventInit.prototype.repeat;\\n\\n/** @type {undefined|boolean} */\\nKeyboardEventInit.prototype.isComposing;\\n\\n/** @type {undefined|string} */\\nKeyboardEventInit.prototype.char;\\n\\n/** @type {undefined|string} */\\nKeyboardEventInit.prototype.locale;\\n\\n/**\\n * @constructor\\n * @extends {UIEvent}\\n * @param {string} type\\n * @param {KeyboardEventInit=} opt_eventInitDict\\n */\\nfunction KeyboardEvent(type, opt_eventInitDict) {}\\n\\n/** @type {string} */\\nKeyboardEvent.prototype.keyIdentifier;\\n\\n/** @type {boolean} */\\nKeyboardEvent.prototype.ctrlKey;\\n\\n/** @type {boolean} */\\nKeyboardEvent.prototype.shiftKey;\\n\\n/** @type {boolean} */\\nKeyboardEvent.prototype.altKey;\\n\\n/** @type {boolean} */\\nKeyboardEvent.prototype.metaKey;\\n\\n/**\\n * @param {string} keyIdentifierArg\\n * @return {boolean}\\n */\\nKeyboardEvent.prototype.getModifierState = function(keyIdentifierArg) {};\\n\\n/**\\n * @record\\n * @extends {UIEventInit}\\n * @see https://w3c.github.io/uievents/#idl-focuseventinit\\n */\\nfunction FocusEventInit() {}\\n\\n/** @type {undefined|?EventTarget} */\\nFocusEventInit.prototype.relatedTarget;\\n\\n\\n/**\\n * The FocusEvent interface provides specific contextual information associated\\n * with Focus events.\\n * http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent\\n *\\n * @constructor\\n * @extends {UIEvent}\\n * @param {string} type\\n * @param {FocusEventInit=} opt_eventInitDict\\n */\\nfunction FocusEvent(type, opt_eventInitDict) {}\\n\\n/** @type {EventTarget} */\\nFocusEvent.prototype.relatedTarget;\\n\\n\\n/**\\n * See https://dom.spec.whatwg.org/#dictdef-eventlisteneroptions\\n * @record\\n */\\nvar EventListenerOptions = function() {};\\n\\n/** @type {boolean|undefined} */\\nEventListenerOptions.prototype.capture;\\n\\n/**\\n * See https://dom.spec.whatwg.org/#dictdef-addeventlisteneroptions\\n * @record\\n * @extends {EventListenerOptions}\\n */\\nvar AddEventListenerOptions = function() {};\\n\\n/** @type {boolean|undefined} */\\nAddEventListenerOptions.prototype.passive;\\n\\n/** @type {boolean|undefined} */\\nAddEventListenerOptions.prototype.once;\\n\\n/**\\n * @record\\n * @extends {UIEventInit}\\n * @see https://w3c.github.io/uievents/#idl-inputeventinit\\n * @see https://w3c.github.io/input-events/#interface-InputEvent\\n */\\nfunction InputEventInit() {}\\n\\n/** @type {undefined|?string} */\\nInputEventInit.prototype.data;\\n\\n/** @type {undefined|boolean} */\\nInputEventInit.prototype.isComposing;\\n\\n/** @type {undefined|string} */\\nInputEventInit.prototype.inputType;\\n\\n/** @type {undefined|?DataTransfer} */\\nInputEventInit.prototype.dataTransfer;\\n\\n\\n// TODO(charleyroy): Add getTargetRanges() once a consensus has been made\\n// regarding how to structure these values. See\\n// https://github.com/w3c/input-events/issues/38.\\n/**\\n * @constructor\\n * @extends {UIEvent}\\n * @param {string} type\\n * @param {InputEventInit=} opt_eventInitDict\\n * @see https://www.w3.org/TR/uievents/#interface-inputevent\\n * @see https://w3c.github.io/input-events/#interface-InputEvent\\n */\\nfunction InputEvent(type, opt_eventInitDict) {}\\n\\n/** @type {string} */\\nInputEvent.prototype.data;\\n\\n/** @type {boolean} */\\nInputEvent.prototype.isComposed;\\n\\n/** @type {string} */\\nInputEvent.prototype.inputType;\\n\\n/** @type {?DataTransfer} */\\nInputEvent.prototype.dataTransfer;\\n","externs/w3c_event3.js":"/*\\n * Copyright 2010 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for W3C\'s event Level 3 specification.\\n *  This file depends on w3c_event.js.\\n *  The whole file has been partially type annotated.\\n *  Created from\\n *   http://www.w3.org/TR/DOM-Level-3-Events/#ecma-script-binding-ecma-binding\\n *\\n * @externs\\n * @author ericdingle@google.com (Eric Dingle)\\n */\\n\\n/**\\n * @param {string} typeArg\\n * @param {boolean} canBubbleArg\\n * @param {boolean} cancelableArg\\n * @param {Window} viewArg\\n * @param {string} keyIdentifierArg\\n * @param {number} keyLocationArg\\n * @param {string} modifiersList\\n * @return {undefined}\\n */\\nKeyboardEvent.prototype.initKeyboardEvent = function(typeArg, canBubbleArg, cancelableArg, viewArg, keyIdentifierArg, keyLocationArg, modifiersList) {};\\n\\n/** @type {string} */\\nKeyboardEvent.prototype.char;\\n\\n/** @type {string} */\\nKeyboardEvent.prototype.code;\\n\\n/** @type {string} */\\nKeyboardEvent.prototype.key;\\n\\n/** @type {number} */\\nKeyboardEvent.prototype.location;\\n\\n/** @type {boolean} */\\nKeyboardEvent.prototype.repeat;\\n\\n/** @type {string} */\\nKeyboardEvent.prototype.locale;\\n\\n/** @type {number} */\\nMouseEvent.prototype.buttons;\\n\\n/**\\n * @param {string} keyIdentifierArg\\n * @return {boolean}\\n */\\nMouseEvent.prototype.getModifierState = function(keyIdentifierArg) {};\\n\\n/** @type {boolean} */\\nEvent.prototype.defaultPrevented;\\n\\n/** @type {string} */\\nEvent.prototype.namespaceURI;\\n\\n/** @return {undefined} */\\nEvent.prototype.stopImmediatePropagation = function() {};\\n","externs/gecko_event.js":"/*\\n * Copyright 2008 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for all the extensions over\\n *  W3C\'s event specification by Gecko. This file depends on\\n *  w3c_event.js.\\n *\\n * @externs\\n * @author acleung@google.com (Alan Leung)\\n */\\n\\n// TODO: Almost all of it has not been annotated with types.\\n\\n/** @type {number} */ Event.prototype.HORIZONTAL_AXIS;\\n/** @type {number} */ Event.prototype.VERTICAL_AXIS;\\n/** @type {boolean} */ Event.prototype.altKey;\\n/** @type {number} */ Event.prototype.axis;\\n/** @type {number} */ Event.prototype.button;\\n/** @type {boolean} */ Event.prototype.cancelBubble;\\n/** @type {number} */ Event.prototype.charCode;\\n/** @type {number} */ Event.prototype.clientX;\\n/** @type {number} */ Event.prototype.clientY;\\n/** @type {boolean} */ Event.prototype.ctrlKey;\\n/** @type {EventTarget} */ Event.prototype.explicitOriginalTarget;\\n/** @type {boolean} */ Event.prototype.isChar;\\n/** @type {boolean} */ Event.prototype.isTrusted;\\n/** @type {number} */ Event.prototype.keyCode;\\n/** @type {number} */ Event.prototype.layerX;\\n/** @type {number} */ Event.prototype.layerY;\\n/** @type {boolean} */ Event.prototype.metaKey;\\n/** @type {EventTarget} */ Event.prototype.originalTarget;\\n/** @type {number} */ Event.prototype.pageX;\\n/** @type {number} */ Event.prototype.pageY;\\n/** @type {EventTarget|undefined} */ Event.prototype.relatedTarget;\\n/** @type {number} */ Event.prototype.screenX;\\n/** @type {number} */ Event.prototype.screenY;\\n/** @type {boolean} */ Event.prototype.shiftKey;\\n/** @type {Window} */ Event.prototype.view;\\n/** @type {number} */ Event.prototype.which;\\n\\n/** @constructor */ function nsIDOMPageTransitionEvent() {}\\n/** @type {boolean} */ nsIDOMPageTransitionEvent.prototype.persisted;\\n\\n//Methods\\nEvent.prototype.initKeyEvent;\\n/**\\n * @param {string} typeArg\\n * @param {boolean=} canBubbleArg\\n * @param {boolean=} cancelableArg\\n * @param {?Window=} viewArg\\n * @param {?number=} detailArg\\n * @param {number=} screenXArg\\n * @param {number=} screenYArg\\n * @param {number=} clientXArg\\n * @param {number=} clientYArg\\n * @param {boolean=} ctrlKeyArg\\n * @param {boolean=} altKeyArg\\n * @param {boolean=} shiftKeyArg\\n * @param {boolean=} metaKeyArg\\n * @param {?number=} buttonArg\\n * @param {?EventTarget=} relatedTargetArg\\n */\\nEvent.prototype.initMouseEvent = function(typeArg, canBubbleArg, cancelableArg, viewArg, detailArg, screenXArg, screenYArg, clientXArg, clientYArg, ctrlKeyArg, altKeyArg, shiftKeyArg, metaKeyArg, buttonArg, relatedTargetArg) {};\\nEvent.prototype.initUIEvent;\\nEvent.prototype.initMessageEvent;\\nEvent.prototype.preventBubble;\\nEvent.prototype.preventCapture;\\n","externs/ie_event.js":"/*\\n * Copyright 2008 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for all the extensions over the\\n *  W3C\'s event specification by IE in JScript. This file depends on\\n *  w3c_event.js.\\n *\\n * @see http://msdn.microsoft.com/en-us/library/ms535863.aspx\\n * @externs\\n * @author acleung@google.com (Alan Leung)\\n */\\n\\n/** @type {string} */\\nEvent.prototype.Abstract;\\n\\n/** @type {boolean} */\\nEvent.prototype.altLeft;\\n\\n/** @type {string} */\\nEvent.prototype.Banner;\\n\\n/**\\n * A ClipboardData on IE, but a DataTransfer on WebKit.\\n * @see http://msdn.microsoft.com/en-us/library/ms535220.aspx\\n * @type {(ClipboardData|undefined)}\\n */\\nEvent.prototype.clipboardData;\\n\\n/** @type {boolean} */\\nEvent.prototype.contentOverflow;\\n\\n/** @type {boolean} */\\nEvent.prototype.ctrlLeft;\\n\\n/** @type {string} */\\nEvent.prototype.dataFld;\\n\\nEvent.prototype.domain;\\n\\n/** @type {Element} */\\nEvent.prototype.fromElement;\\n\\n/** @type {string} */\\nEvent.prototype.MoreInfo;\\n\\n/** @type {string} */\\nEvent.prototype.nextPage;\\n\\n/** @type {number} */\\nEvent.prototype.offsetX;\\n\\n/** @type {number} */\\nEvent.prototype.offsetY;\\n\\n/** @type {string} */\\nEvent.prototype.propertyName;\\n\\n/** @type {string} */\\nEvent.prototype.qualifier;\\n\\n/** @type {number} */\\nEvent.prototype.reason;\\n\\n/** @type {Object<*>} */\\nEvent.prototype.recordset;\\n\\n/** @type {boolean} */\\nEvent.prototype.repeat;\\n\\n/** @type {(boolean|string|undefined)} */\\nEvent.prototype.returnValue;\\n\\n/** @type {string} */\\nEvent.prototype.saveType;\\n\\nEvent.prototype.scheme;\\n\\n/** @type {boolean} */\\nEvent.prototype.shiftLeft;\\n\\n/** @type {Window} */\\nEvent.prototype.source;\\n\\n/** @type {Element} */\\nEvent.prototype.srcElement;\\n\\nEvent.prototype.srcFilter;\\n\\n/** @type {string} */\\nEvent.prototype.srcUrn;\\n\\n/** @type {Element} */\\nEvent.prototype.toElement;\\n\\nEvent.prototype.userName;\\n\\n/** @type {number} */\\nEvent.prototype.wheelDelta;\\n\\n/** @type {number} */\\nEvent.prototype.x;\\n\\n/** @type {number} */\\nEvent.prototype.y;\\n\\n/**\\n * @constructor\\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441257.aspx\\n */\\nfunction MSPointerPoint() {}\\n\\n/** @type {number} */\\nMSPointerPoint.prototype.pointerId;\\n\\n/** @type {number} */\\nMSPointerPoint.prototype.pointerType;\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441233.aspx\\n */\\nfunction MSPointerEvent() {}\\n\\n/** @type {number} */\\nMSPointerEvent.MSPOINTER_TYPE_MOUSE;\\n\\n/** @type {number} */\\nMSPointerEvent.MSPOINTER_TYPE_PEN;\\n\\n/** @type {number} */\\nMSPointerEvent.MSPOINTER_TYPE_TOUCH;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.height;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.hwTimestamp;\\n\\n/** @type {boolean} */\\nMSPointerEvent.prototype.isPrimary;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.pointerId;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.pointerType;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.pressure;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.rotation;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.tiltX;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.tiltY;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.timeStamp;\\n\\n/** @type {number} */\\nMSPointerEvent.prototype.width;\\n\\n/**\\n * @param {number} pointerId\\n * @return {undefined}\\n */\\nMSPointerEvent.prototype.msReleasePointerCapture;\\n\\n/**\\n * @param {number} pointerId\\n * @return {undefined}\\n */\\nMSPointerEvent.prototype.msSetPointerCapture;\\n\\n/**\\n * @param {string} typeArg\\n * @param {boolean} canBubbleArg\\n * @param {boolean} cancelableArg\\n * @param {Window} viewArg\\n * @param {number} detailArg\\n * @param {number} screenXArg\\n * @param {number} screenYArg\\n * @param {number} clientXArg\\n * @param {number} clientYArg\\n * @param {boolean} ctrlKeyArg\\n * @param {boolean} altKeyArg\\n * @param {boolean} shiftKeyArg\\n * @param {boolean} metaKeyArg\\n * @param {number} buttonArg\\n * @param {Element} relatedTargetArg\\n * @param {number} offsetXArg\\n * @param {number} offsetYArg\\n * @param {number} widthArg\\n * @param {number} heightArg\\n * @param {number} pressure\\n * @param {number} rotation\\n * @param {number} tiltX\\n * @param {number} tiltY\\n * @param {number} pointerIdArg\\n * @param {number} pointerType\\n * @param {number} hwTimestampArg\\n * @param {boolean} isPrimary\\n * @return {undefined}\\n * @see http://msdn.microsoft.com/en-us/library/windows/apps/hh441246.aspx\\n */\\nMSPointerEvent.prototype.initPointerEvent;\\n\\n/**\\n * @constructor\\n * @see http://msdn.microsoft.com/en-us/library/ie/hh968249(v=vs.85).aspx\\n */\\nfunction MSGesture() {}\\n\\n/**\\n * @type {Element}\\n */\\nMSGesture.prototype.target;\\n\\n/**\\n * @param {number} pointerId\\n * @return {undefined}\\n */\\nMSGesture.prototype.addPointer = function(pointerId) {};\\n\\nMSGesture.prototype.stop = function() {};\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n * @see http://msdn.microsoft.com/en-us/library/ie/hh772076(v=vs.85).aspx\\n */\\nfunction MSGestureEvent() {}\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.expansion;\\n\\n/** @type {!MSGesture} */\\nMSGestureEvent.prototype.gestureObject;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.hwTimestamp;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.rotation;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.scale;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.translationX;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.translationY;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.velocityAngular;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.velocityExpansion;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.velocityX;\\n\\n/** @type {number} */\\nMSGestureEvent.prototype.velocityY;\\n\\n/**\\n * @param {string} typeArg\\n * @param {boolean} canBubbleArg\\n * @param {boolean} cancelableArg\\n * @param {Window} viewArg\\n * @param {number} detailArg\\n * @param {number} screenXArg\\n * @param {number} screenYArg\\n * @param {number} clientXArg\\n * @param {number} clientYArg\\n * @param {number} offsetXArg\\n * @param {number} offsetYArg\\n * @param {number} translationXArg\\n * @param {number} translationYArg\\n * @param {number} scaleArg\\n * @param {number} expansionArg\\n * @param {number} rotationArg\\n * @param {number} velocityXArg\\n * @param {number} velocityYArg\\n * @param {number} velocityExpansionArg\\n * @param {number} velocityAngularArg\\n * @param {number} hwTimestampArg\\n * @param {EventTarget} relatedTargetArg\\n * @return {undefined}\\n * @see http://ms';
a.a+='dn.microsoft.com/en-us/library/windows/apps/hh441187.aspx\\n */\\nMSGestureEvent.prototype.initGestureEvent;\\n","externs/webkit_event.js":"/*\\n * Copyright 2009 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for all the extensions over W3C\'s\\n *  event specification by WebKit. This file depends on w3c_event.js.\\n *  All the provided definitions have been type annotated\\n *\\n * @externs\\n * @author djlee@google.com (DJ Lee)\\n */\\n\\n/** @type {number} */\\nEvent.prototype.wheelDeltaX;\\n\\n/** @type {number} */\\nEvent.prototype.wheelDeltaY;\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n * @see http://developer.apple.com/library/safari/documentation/AudioVideo/Reference/WebKitAnimationEventClassReference/WebKitAnimationEvent/WebKitAnimationEvent.html\\n */\\nfunction WebKitAnimationEvent() {}\\n\\n/**\\n * @type {string}\\n * @const\\n */\\nWebKitAnimationEvent.prototype.animationName;\\n\\n/**\\n * @type {number}\\n * @const\\n */\\nWebKitAnimationEvent.prototype.elapsedTime;","externs/w3c_device_sensor_event.js":"/*\\n * Copyright 2013 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for W3C\'s device orientation and device motion\\n *  events specification.\\n *  This file depends on w3c_event.js.\\n *  The whole file has been partially type annotated.\\n *  Created from http://dev.w3.org/geo/api/spec-source-orientation.\\n *\\n * @externs\\n * @author lukaszbk@google.com (Lukasz Bieniasz-Krzywiec)\\n */\\n\\n/**\\n * @record\\n * @extends {EventInit}\\n * @see https://w3c.github.io/deviceorientation/spec-source-orientation.html#deviceorientation\\n */\\nfunction DeviceOrientationEventInit() {}\\n\\n/** @type {number|undefined} */\\nDeviceOrientationEventInit.prototype.alpha;\\n\\n/** @type {number|undefined} */\\nDeviceOrientationEventInit.prototype.beta;\\n\\n/** @type {number|undefined} */\\nDeviceOrientationEventInit.prototype.gamma;\\n\\n/** @type {boolean|undefined} */\\nDeviceOrientationEventInit.prototype.absolute;\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n * @param {string} type\\n * @param {!DeviceOrientationEventInit=} opt_eventInitDict\\n */\\nfunction DeviceOrientationEvent(type, opt_eventInitDict) {}\\n\\n/** @type {?number} */\\nDeviceOrientationEvent.prototype.alpha;\\n\\n/** @type {?number} */\\nDeviceOrientationEvent.prototype.beta;\\n\\n/** @type {?number} */\\nDeviceOrientationEvent.prototype.gamma;\\n\\n/** @type {boolean} */\\nDeviceOrientationEvent.prototype.absolute;\\n\\n/**\\n * @type {?number}\\n * @see https://developer.apple.com/library/safari/documentation/SafariDOMAdditions/Reference/DeviceOrientationEventClassRef/DeviceOrientationEvent/DeviceOrientationEvent.html#//apple_ref/javascript/instp/DeviceOrientationEvent/webkitCompassAccuracy\\n */\\nDeviceOrientationEvent.prototype.webkitCompassAccuracy;\\n\\n/**\\n * @type {?number}\\n * @see https://developer.apple.com/library/safari/documentation/SafariDOMAdditions/Reference/DeviceOrientationEventClassRef/DeviceOrientationEvent/DeviceOrientationEvent.html#//apple_ref/javascript/instp/DeviceOrientationEvent/webkitCompassHeading\\n */\\nDeviceOrientationEvent.prototype.webkitCompassHeading;\\n\\n/**\\n * @constructor\\n */\\nfunction DeviceAcceleration() {}\\n\\n/** @type {?number} */\\nDeviceAcceleration.prototype.x;\\n\\n/** @type {?number} */\\nDeviceAcceleration.prototype.y;\\n\\n/** @type {?number} */\\nDeviceAcceleration.prototype.z;\\n\\n/**\\n * @constructor\\n */\\nfunction DeviceRotationRate() {}\\n\\n/** @type {?number} */\\nDeviceRotationRate.prototype.alpha;\\n\\n/** @type {?number} */\\nDeviceRotationRate.prototype.beta;\\n\\n/** @type {?number} */\\nDeviceRotationRate.prototype.gamma;\\n\\n/**\\n * @constructor\\n * @extends {Event}\\n */\\nfunction DeviceMotionEvent() {}\\n\\n/** @type {?DeviceAcceleration} */\\nDeviceMotionEvent.prototype.acceleration;\\n\\n/** @type {?DeviceAcceleration} */\\nDeviceMotionEvent.prototype.accelerationIncludingGravity;\\n\\n/** @type {?DeviceRotationRate} */\\nDeviceMotionEvent.prototype.rotationRate;\\n\\n/** @type {?number} */\\nDeviceMotionEvent.prototype.interval;\\n","externs/web_app_manifest.js":"/*\\n * Copyright 2017 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n/**\\n * @fileoverview Externs for web app manifest APIs.\\n *\\n * @see https://www.w3.org/TR/appmanifest/\\n * @externs\\n */\\n\\n/**\\n * @see https://www.w3.org/TR/appmanifest/#beforeinstallpromptevent-interface\\n * @constructor\\n * @extends {Event}\\n */\\nfunction BeforeInstallPromptEvent() {}\\n\\n/** @type {!Promise<{outcome: !AppBannerPromptOutcome}>} */\\nBeforeInstallPromptEvent.prototype.userChoice;\\n\\n/** @return {!Promise<!PromptResponseObject>} */\\nBeforeInstallPromptEvent.prototype.prompt = function() {};\\n\\n/**\\n * @typedef {string}\\n * @see https://www.w3.org/TR/appmanifest/#appbannerpromptoutcome-enum\\n * Possible values: \'accepted\', \'dismissed\'\\n */\\nvar AppBannerPromptOutcome;\\n\\n/** @typedef {{userChoice: !AppBannerPromptOutcome}} */\\nvar PromptResponseObject;\\n\\n/** @type {?function(!BeforeInstallPromptEvent)} */\\nWindow.prototype.onbeforeinstallprompt;\\n\\n/** @type {?function(!Event)} */\\nWindow.prototype.onappinstalled;\\n","externs/w3c_trusted_types.js":"/*\\n * Copyright 2018 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for W3C\'s Trusted Types specification.\\n * @see https://github.com/WICG/trusted-types\\n * @externs\\n */\\n\\n\\n/** @constructor */\\nfunction TrustedHTML() {}\\n\\n/** @constructor */\\nfunction TrustedScript() {}\\n\\n/** @constructor */\\nfunction TrustedScriptURL() {}\\n\\n/** @constructor */\\nfunction TrustedURL() {}\\n\\n\\n/** @constructor */\\nfunction TrustedTypePolicy() {}\\n\\n/**\\n * @param {string} s\\n * @return {!TrustedHTML}\\n */\\nTrustedTypePolicy.prototype.createHTML = function(s) {};\\n\\n/**\\n * @param {string} s\\n * @return {!TrustedScript}\\n */\\nTrustedTypePolicy.prototype.createScript = function(s) {};\\n\\n/**\\n * @param {string} s\\n * @return {!TrustedScriptURL}\\n */\\nTrustedTypePolicy.prototype.createScriptURL = function(s) {};\\n\\n/**\\n * @param {string} s\\n * @return {!TrustedURL}\\n */\\nTrustedTypePolicy.prototype.createURL = function(s) {};\\n\\n\\n/** @constructor */\\nfunction TrustedTypePolicyFactory() {}\\n\\n/**\\n * @param {string} name\\n * @param {{\\n *     createHTML: function(string): string,\\n *     createScript: function(string): string,\\n *     createScriptURL: function(string): string,\\n *     createURL: function(string): string}} policy\\n * @param {boolean=} opt_expose\\n * @return {!TrustedTypePolicy}\\n */\\nTrustedTypePolicyFactory.prototype.createPolicy = function(\\n    name, policy, opt_expose) {};\\n\\n/**\\n * @param {string} name\\n * @return {!TrustedTypePolicy}\\n */\\nTrustedTypePolicyFactory.prototype.getExposedPolicy = function(name) {};\\n\\n/** @return {!Array<string>} */\\nTrustedTypePolicyFactory.prototype.getPolicyNames = function() {};\\n\\n\\n/** @type {!TrustedTypePolicyFactory} */\\nvar TrustedTypes;\\n","externs/w3c_dom1.js":"/*\\n * Copyright 2008 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for W3C\'s DOM Level 1 specification.\\n *  The whole file has been fully type annotated. Created from\\n *  http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html\\n *\\n * @externs\\n * @author acleung@google.com (Alan Leung)\\n * @author stevey@google.com (Steve Yegge)\\n */\\n\\n/**\\n * @constructor\\n * @param {string=} message\\n * @param {string=} name\\n * @see https://heycam.github.io/webidl/#idl-DOMException\\n */\\nfunction DOMException(message, name) {}\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.INDEX_SIZE_ERR = 1;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.DOMSTRING_SIZE_ERR = 2;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.HIERARCHY_REQUEST_ERR = 3;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.WRONG_DOCUMENT_ERR = 4;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.INVALID_CHARACTER_ERR = 5;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.NO_DATA_ALLOWED_ERR = 6;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.NO_MODIFICATION_ALLOWED_ERR = 7;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.NOT_FOUND_ERR = 8;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.NOT_SUPPORTED_ERR = 9;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nDOMException.INUSE_ATTRIBUTE_ERR = 10;\\n\\n/**\\n * @constructor\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-258A00AF\\n */\\nfunction ExceptionCode() {}\\n\\n/**\\n * @constructor\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-102161490\\n */\\nfunction DOMImplementation() {}\\n\\n/**\\n * @param {string} feature\\n * @param {string} version\\n * @return {boolean}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-5CED94D7\\n * @nosideeffects\\n */\\nDOMImplementation.prototype.hasFeature = function(feature, version) {};\\n\\n/**\\n * @constructor\\n * @implements {EventTarget}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nfunction Node() {}\\n\\n/** @override */\\nNode.prototype.addEventListener = function(type, listener, opt_options) {};\\n\\n/** @override */\\nNode.prototype.removeEventListener = function(type, listener, opt_options) {};\\n\\n/** @override */\\nNode.prototype.dispatchEvent = function(evt) {};\\n\\n/**\\n * @type {NamedNodeMap<!Attr>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-attributes\\n */\\nNode.prototype.attributes;\\n\\n/**\\n * @type {!NodeList<!Node>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-childNodes\\n */\\nNode.prototype.childNodes;\\n\\n/**\\n * @type {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-firstChild\\n */\\nNode.prototype.firstChild;\\n\\n/**\\n * @type {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-lastChild\\n */\\nNode.prototype.lastChild;\\n\\n/**\\n * @type {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nextSibling\\n */\\nNode.prototype.nextSibling;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nodeName\\n */\\nNode.prototype.nodeName;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nodeValue\\n */\\nNode.prototype.nodeValue;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-nodeType\\n */\\nNode.prototype.nodeType;\\n\\n/**\\n * @type {Document}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-ownerDocument\\n */\\nNode.prototype.ownerDocument;\\n\\n/**\\n * @type {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-parentNode\\n */\\nNode.prototype.parentNode;\\n\\n/**\\n * @type {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-previousSibling\\n */\\nNode.prototype.previousSibling;\\n\\n/**\\n * @param {Node} newChild\\n * @return {!Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-appendChild\\n */\\nNode.prototype.appendChild = function(newChild) {};\\n\\n/**\\n * @param {boolean} deep\\n * @return {!Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-cloneNode\\n * @nosideeffects\\n */\\nNode.prototype.cloneNode = function(deep) {};\\n\\n/**\\n * @return {boolean}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-hasChildNodes\\n * @nosideeffects\\n */\\nNode.prototype.hasChildNodes = function() {};\\n\\n/**\\n * @param {Node} newChild\\n * @param {Node} refChild\\n * @return {!Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-insertBefore\\n */\\nNode.prototype.insertBefore = function(newChild, refChild) {};\\n\\n/**\\n * @param {Node} oldChild\\n * @return {!Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-removeChild\\n */\\nNode.prototype.removeChild = function(oldChild) {};\\n\\n/**\\n * @param {Node} newChild\\n * @param {Node} oldChild\\n * @return {!Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-replaceChild\\n */\\nNode.prototype.replaceChild = function(newChild, oldChild) {};\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.ATTRIBUTE_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.CDATA_SECTION_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/T';
a.a+="R/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.COMMENT_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.DOCUMENT_FRAGMENT_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.DOCUMENT_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.DOCUMENT_TYPE_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.ELEMENT_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.ENTITY_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.ENTITY_REFERENCE_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.PROCESSING_INSTRUCTION_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.TEXT_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.XPATH_NAMESPACE_NODE;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1950641247\\n */\\nNode.NOTATION_NODE;\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-B63ED1A3\\n */\\nfunction DocumentFragment() {}\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#i-Document\\n */\\nfunction Document() {}\\n\\n/**\\n * @type {DocumentType}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-doctype\\n */\\nDocument.prototype.doctype;\\n\\n/**\\n * @type {!HTMLHtmlElement}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-documentElement\\n */\\nDocument.prototype.documentElement;\\n\\n/**\\n * @type {DOMImplementation}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-implementation\\n */\\nDocument.prototype.implementation;\\n\\n/**\\n * @param {string} name\\n * @return {!Attr}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createAttribute\\n * @nosideeffects\\n */\\nDocument.prototype.createAttribute = function(name) {};\\n\\n/**\\n * @param {string} data\\n * @return {!Comment}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createComment\\n * @nosideeffects\\n */\\nDocument.prototype.createComment = function(data) {};\\n\\n/**\\n * @param {string} data\\n * @return {!CDATASection}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createCDATASection\\n * @nosideeffects\\n */\\nDocument.prototype.createCDATASection = function(data) {};\\n\\n/**\\n * @return {!DocumentFragment}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createDocumentFragment\\n * @nosideeffects\\n */\\nDocument.prototype.createDocumentFragment = function() {};\\n\\n/**\\n * Create a DOM element.\\n *\\n * Web components introduced the second parameter as a way of extending existing\\n * tags (e.g. document.createElement('button', 'fancy-button')).\\n *\\n * @param {string} tagName\\n * @param {string=} opt_typeExtension\\n * @return {!Element}\\n * @nosideeffects\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createElement\\n * @see http://w3c.github.io/webcomponents/spec/custom/#extensions-to-document-interface-to-instantiate\\n */\\nDocument.prototype.createElement = function(tagName, opt_typeExtension) {};\\n\\n/**\\n * @param {string} name\\n * @return {!EntityReference}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createEntityReference\\n * @nosideeffects\\n */\\nDocument.prototype.createEntityReference = function(name) {};\\n\\n/**\\n * @param {string} target\\n * @param {string} data\\n * @return {!ProcessingInstruction}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createProcessingInstruction\\n * @nosideeffects\\n */\\nDocument.prototype.createProcessingInstruction = function(target, data) {};\\n\\n/**\\n * @param {number|string} data\\n * @return {!Text}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-createTextNode\\n * @nosideeffects\\n */\\nDocument.prototype.createTextNode = function(data) {};\\n\\n/**\\n * @param {string} tagname\\n * @return {!NodeList<!Element>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-A6C9094\\n * @nosideeffects\\n */\\nDocument.prototype.getElementsByTagName = function(tagname) {};\\n\\n/**\\n * @constructor\\n * @implements {IArrayLike<T>}\\n * @implements {Iterable<T>}\\n * @template T\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-536297177\\n */\\nfunction NodeList() {}\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-203510337\\n */\\nNodeList.prototype.length;\\n\\n/**\\n * @param {number} index\\n * @return {T|null}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-844377136\\n */\\nNodeList.prototype.item = function(index) {};\\n\\n/**\\n * @param {?function(this:S, T, number, !NodeList<T>): ?} callback\\n * @param {S=} opt_thisobj\\n * @this {NodeList<T>}\\n * @template T,S\\n * @return {undefined}\\n * @see https://developer.mozilla.org/en-US/docs/Web/API/NodeList/forEach\\n */\\nNodeList.prototype.forEach = function(callback, opt_thisobj) {};\\n\\n/**\\n * @constructor\\n * @implements {IObject<(string|number), T>}\\n * @implements {IArrayLike<T>}\\n * @implements {Iterable<T>}\\n * @template T\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1780488922\\n */\\nfunction NamedNodeMap() {}\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-6D0FB19E\\n */\\nNamedNodeMap.prototype.length;\\n\\n/**\\n * @param {string} name\\n * @return {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1074577549\\n * @nosideeffects\\n */\\nNamedNodeMap.prototype.getNamedItem = function(name) {};\\n\\n/**\\n * @param {number} index\\n * @return {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-349467F9\\n * @nosideeffects\\n */\\nNamedNodeMap.prototype.item = function(index) {};\\n\\n/**\\n * @param {string} name\\n * @return {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-D58B193\\n */\\nNamedNodeMap.prototype.removeNamedItem = function(name) {};\\n\\n/**\\n * @param {Node} arg\\n * @return {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1025163788\\n */\\nNamedNodeMap.prototype.setNamedItem = function(arg) {};\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-FF21A306\\n */\\nfunction CharacterData() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-72AB8359\\n */\\nCharacterData.prototype.data;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-7D61178C\\n */\\nCharacterData.prototype.length;\\n\\n/**\\n * @param {string} arg\\n * @return {undefined}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-32791A2F\\n */\\nCharacterData.prototype.appendData = function(arg) {};\\n\\n/**\\n * @param {number} offset\\n * @param {number} count\\n * @return {undefined}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-7C603781\\n */\\nCharacterData.prototype.deleteData = function(offset, count) {};\\n\\n/**\\n * @param {number} offset\\n * @param {string} arg\\n * @return {undefined}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-3EDB695F\\n */\\nCharacterData.prototype.insertData = function(offset, arg) {};\\n\\n/**\\n * @param {number} offset\\n * @param {number} count\\n * @param {string} arg\\n * @return {undefined}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-E5CBA7FB\\n */\\nCharacterData.prototype.replaceData = function(offset, count, arg) {};\\n\\n/**\\n * @param {number} offset\\n * @param {number} count\\n * @return {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-6531BCCF\\n * @nosideeffects\\n */\\nCharacterData.prototype.substringData = function(offset, count) {};\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-637646024\\n */\\nfunction Attr() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1112119403\\n */\\nAttr.prototype.name;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-862529273\\n */\\nAttr.prototype.specified;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-221662474\\n */\\nAttr.prototype.value;\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-745549614\\n */\\nfunction Element() {}\\n\\n/**\\n * An Element always contains a non-null NamedNodeMap containing the attributes\\n * of this node.\\n * @type {!NamedNodeMap<!Attr>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-attributes\\n */\\nElement.prototype.attributes;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#attribute-tagName\\n */\\nElement.prototype.tagName;\\n\\n/**\\n * @implicitCast\\n * @type {?}\\n * @see https://developer.mozilla.org/en-US/docs/Web/API/Element/className\\n *    We type it as ? even though it is a string, because some SVG elements have\\n *    className that is an object, which isn't a subtype of string.\\n *    Alternative: TypeScript types this as string and types className on\\n *    SVGElement as ?.\\n */\\nElement.prototype.className;\\n\\n/**\\n * @param {string} name\\n * @param {number?=} opt_flags\\n * @return {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-getAttribute\\n * @see http://msdn.microsoft.com/en-us/library/ms536429(VS.85).aspx\\n * @nosideeffects\\n */\\nElement.prototype.getAttribute = function(name, opt_flags) {};\\n\\n/**\\n * @param {string} name\\n * @return {Attr}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-getAttributeNode\\n * @nosideeffects\\n */\\nElement.prototype.getAttributeNode = function(name) {};\\n\\n/**\\n * @param {string} tagname\\n * @return {!NodeList<!Element>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1938918D\\n * @nosideeffects\\n */\\nElement.prototype.getElementsByTagName = function(tagname) {};\\n\\n/**\\n * @param {string} name\\n * @return {undefined}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-removeAttribute\\n */\\nElement.prototype.removeAttribute = function(name) {};\\n\\n/**\\n * @param {Attr} oldAttr\\n * @return {?Attr}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-removeAttributeNode\\n */\\nElement.prototype.removeAttributeNode = function(oldAttr) {};\\n\\n/**\\n * @param {string} name\\n * @param {string|number|boolean} value Values are converted to strings with\\n *     ToString, so we accept number and boolean since both convert easily to\\n *     strings.\\n * @return {undefined}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-setAttribute\\n */\\nElement.prototype.setAttribute = function(name, value) {};\\n\\n/**\\n * @param {Attr} newAttr\\n * @return {?Attr}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#method-setAttributeNode\\n */\\nElement.prototype.setAttributeNode = function(newAttr) {};\\n\\n// Event handlers\\n// The DOM level 3 spec has a good index of these\\n// http://www.w3.org/TR/DOM-Level-3-Events/#event-types\\n\\n/** @type {?function (Event)} */ Element.prototype.onabort;\\n/** @type {?function (Event)} */ Element.prototype.onbeforeinput;\\n/** @type {?function (Event)} */ Element.prototype.onbeforeunload;\\n/** @type {?function (Event)} */ Element.prototype.onblur;\\n/** @type {?function (Event)} */ Element.prototype.onchange;\\n/** @type {?function (Event)} */ Element.prototype.onclick;\\n/** @type {?function (Event)} */ Element.prototype.oncompositionstart;\\n/** @type {?function (Event)} */ Element.prototype.oncompositionupdate;\\n/** @type {?function (Event)} */ Element.prototype.oncompositionend;\\n/** @type {?function (Event)} */ Element.prototype.oncontextmenu;\\n/** @type {?function (Event)} */ Element.prototype.oncopy;\\n/** @type {?function (Event)} */ Element.prototype.oncut;\\n/** @type {?function (Event)} */ Element.prototype.ondblclick;\\n/** @type {?function (Event)} */ Element.prototype.onerror;\\n/** @type {?function (Event)} */ Element.prototype.onfocus;\\n/** @type {?function (Event)} */ Element.prototype.onfocusin;\\n/** @type {?function (Event)} */ Element.prototype.onfocusout;\\n/** @type {?function (Event)} */ Element.prototype.oninput;\\n/** @type {?function (Event)} */ Element.prototype.onkeydown;\\n/** @type {?function (Event)} */ Element.prototype.onkeypress;\\n/** @type {?function (Event)} */ Element.prototype.onkeyup;\\n/** @type {?function (Event)} */ Element.prototype.onload;\\n/** @type {?function (Event)} */ Element.prototype.onunload;\\n/** @type {?function (Event)} */ Element.prototype.onmousedown;\\n/** @type {?function (Event)} */ Element.prototype.onmousemove;\\n/** @type {?function (Event)} */ Element.prototype.onmouseout;\\n/** @type {?function (Event)} */ Element.prototype.onmouseover;\\n/** @type {?function (Event)} */ Element.prototype.onmouseup;\\n/** @type {?function (Event)} */ Element.prototype.onmousewheel;\\n/** @type {?function (Event)} */ Element.prototype.onpaste;\\n/** @type {?function (Event)} */ Element.prototype.onreset;\\n/** @type {?function (Event)} */ Element.prototype.onresize;\\n/** @type {?function (Event)} */ Element.prototype.onscroll;\\n/** @type {?function (Event)} */ Element.prototype.onselect;\\n/** @type {?function (Event=)} */ Element.prototype.onsubmit;\\n/** @type {?function (Event)} */ Element.prototype.ontextinput;\\n/** @type {?function (Event)} */ Element.prototype.onwheel;\\n\\n/**\\n * @constructor\\n * @extends {CharacterData}\\n * @param {string=} contents Optional textual content.\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1312295772\\n */\\nfunction Text(contents) {}\\n\\n/**\\n * @param {number} offset\\n * @return {Text}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-38853C1D\\n */\\nText.prototype.splitText = function(offset) {};\\n\\n/**\\n * @constructor\\n * @extends {CharacterData}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1728279322\\n */\\nfunction Comment() {}\\n\\n/**\\n * @constructor\\n * @extends {Text}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-667469212\\n */\\nfunction CDATASection() {}\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-412266927\\n */\\nfunction DocumentType() {}\\n\\n/**\\n * @type {NamedNodeMap<!Entity>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1788794630\\n */\\nDocumentType.prototype.entities;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1844763134\\n */\\nDocumentType.prototype.name;\\n\\n/**\\n * @type {NamedNodeMap<!Notation>}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-D46829EF\\n */\\nDocumentType.prototype.notati";
a.a+='ons;\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-5431D1B9\\n */\\nfunction Notation() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-54F2B4D0\\n */\\nNotation.prototype.publicId;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-E8AAB1D0\\n */\\nNotation.prototype.systemId;\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-527DCFF2\\n */\\nfunction Entity() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-D7303025\\n */\\nEntity.prototype.publicId;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-D7C29F3E\\n */\\nEntity.prototype.systemId;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-6ABAEB38\\n */\\nEntity.prototype.notationName;\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-11C98490\\n */\\nfunction EntityReference() {}\\n\\n/**\\n * @constructor\\n * @extends {Node}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1004215813\\n */\\nfunction ProcessingInstruction() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-837822393\\n */\\nProcessingInstruction.prototype.data;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core.html#ID-1478689192\\n */\\nProcessingInstruction.prototype.target;\\n\\n\\n/**\\n * @constructor\\n * @implements {EventTarget}\\n */\\nfunction Window() {}\\nWindow.prototype.Window;\\n\\n/** @override */\\nWindow.prototype.addEventListener = function(type, listener, opt_options) {};\\n\\n/** @override */\\nWindow.prototype.removeEventListener = function(type, listener, opt_options) {};\\n\\n/** @override */\\nWindow.prototype.dispatchEvent = function(evt) {};\\n\\n/** @type {?function (Event)} */ Window.prototype.onabort;\\n/** @type {?function (Event)} */ Window.prototype.onbeforeunload;\\n/** @type {?function (Event)} */ Window.prototype.onblur;\\n/** @type {?function (Event)} */ Window.prototype.onchange;\\n/** @type {?function (Event)} */ Window.prototype.onclick;\\n/** @type {?function (Event)} */ Window.prototype.onclose;\\n/** @type {?function (Event)} */ Window.prototype.oncontextmenu;\\n/** @type {?function (Event)} */ Window.prototype.ondblclick;\\n/** @type {?function (Event)} */ Window.prototype.ondragdrop;\\n// onerror has a special signature.\\n// See\\n//  https://developer.mozilla.org/en-US/docs/Web/API/GlobalEventHandlers/onerror\\n/**\\n * @type {?function (string, string, number, number, !Error):?}\\n */\\nWindow.prototype.onerror;\\n/** @type {?function (Event)} */ Window.prototype.onfocus;\\n/** @type {?function (Event)} */ Window.prototype.onhashchange;\\n/** @type {?function (Event)} */ Window.prototype.onkeydown;\\n/** @type {?function (Event)} */ Window.prototype.onkeypress;\\n/** @type {?function (Event)} */ Window.prototype.onkeyup;\\n/** @type {?function (Event)} */ Window.prototype.onload;\\n/** @type {?function (Event)} */ Window.prototype.onmousedown;\\n/** @type {?function (Event)} */ Window.prototype.onmousemove;\\n/** @type {?function (Event)} */ Window.prototype.onmouseout;\\n/** @type {?function (Event)} */ Window.prototype.onmouseover;\\n/** @type {?function (Event)} */ Window.prototype.onmouseup;\\n/** @type {?function (Event)} */ Window.prototype.onmousewheel;\\n/** @type {?function (Event)} */ Window.prototype.onpaint;\\n/** @type {?function (Event)} */ Window.prototype.onpopstate;\\n/** @type {?function (Event)} */ Window.prototype.onreset;\\n/** @type {?function (Event)} */ Window.prototype.onresize;\\n/** @type {?function (Event)} */ Window.prototype.onscroll;\\n/** @type {?function (Event)} */ Window.prototype.onselect;\\n/** @type {?function (Event=)} */ Window.prototype.onsubmit;\\n/** @type {?function (Event)} */ Window.prototype.onunload;\\n/** @type {?function (Event)} */ Window.prototype.onwheel;\\n","externs/w3c_dom2.js":"/*\\n * Copyright 2008 The Closure Compiler Authors\\n *\\n * Licensed under the Apache License, Version 2.0 (the \\"License\\");\\n * you may not use this file except in compliance with the License.\\n * You may obtain a copy of the License at\\n *\\n *     http://www.apache.org/licenses/LICENSE-2.0\\n *\\n * Unless required by applicable law or agreed to in writing, software\\n * distributed under the License is distributed on an \\"AS IS\\" BASIS,\\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\\n * See the License for the specific language governing permissions and\\n * limitations under the License.\\n */\\n\\n/**\\n * @fileoverview Definitions for W3C\'s DOM Level 2 specification.\\n *  This file depends on w3c_dom1.js.\\n *  The whole file has been fully type annotated.\\n *  Created from\\n *  http://www.w3.org/TR/REC-DOM-Level-1/ecma-script-language-binding.html\\n *\\n * @externs\\n */\\n\\n/**\\n * @param {string} s id.\\n * @return {Element}\\n * @nosideeffects\\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-getElBId\\n */\\nDocument.prototype.getElementById = function(s) {};\\n\\n/**\\n * @param {?string} namespaceURI\\n * @param {string} qualifiedName\\n * @param {string=} opt_typeExtension\\n * @return {!Element}\\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-DocCrElNS\\n */\\nDocument.prototype.createElementNS =\\n    function(namespaceURI, qualifiedName, opt_typeExtension) {};\\n\\n/**\\n * @param {?string} namespaceURI\\n * @param {string} qualifiedName\\n * @return {!Attr}\\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-DocCrElNS\\n */\\nDocument.prototype.createAttributeNS =\\n    function(namespaceURI, qualifiedName) {};\\n\\n/**\\n * @param {Node} root\\n * @param {number=} whatToShow\\n * @param {NodeFilter=} filter\\n * @param {boolean=} entityReferenceExpansion\\n * @return {!NodeIterator}\\n * @see https://www.w3.org/TR/2000/REC-DOM-Level-2-Traversal-Range-20001113/traversal.html#Traversal-Document\\n * @see https://dom.spec.whatwg.org/#interface-document\\n * @nosideeffects\\n */\\nDocument.prototype.createNodeIterator = function(\\n    root, whatToShow, filter, entityReferenceExpansion) {};\\n\\n/**\\n * @param {Node} root\\n * @param {number=} whatToShow\\n * @param {NodeFilter=} filter\\n * @param {boolean=} entityReferenceExpansion\\n * @return {!TreeWalker}\\n * @see https://www.w3.org/TR/2000/REC-DOM-Level-2-Traversal-Range-20001113/traversal.html#Traversal-Document\\n * @see https://dom.spec.whatwg.org/#interface-document\\n * @nosideeffects\\n */\\nDocument.prototype.createTreeWalker = function(\\n    root, whatToShow, filter, entityReferenceExpansion) {};\\n\\n/**\\n * @param {string} namespace\\n * @param {string} name\\n * @return {!NodeList<!Element>}\\n * @nosideeffects\\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#ID-getElBTNNS\\n */\\nDocument.prototype.getElementsByTagNameNS = function(namespace, name) {};\\n\\n/**\\n * @param {Node} externalNode\\n * @param {boolean} deep\\n * @return {Node}\\n * @see https://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/core.html#Core-Document-importNode\\n */\\nDocument.prototype.importNode = function(externalNode, deep) {};\\n\\n/**\\n * @constructor\\n * @implements {IObject<(string|number),T>}\\n * @implements {IArrayLike<T>}\\n * @implements {Iterable<T>}\\n * @template T\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75708506\\n */\\nfunction HTMLCollection() {}\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40057551\\n */\\nHTMLCollection.prototype.length;\\n\\n/**\\n * @param {number} index\\n * @return {T|null}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33262535\\n * @nosideeffects\\n */\\nHTMLCollection.prototype.item = function(index) {};\\n\\n/**\\n * @param {string} name\\n * @return {T|null}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-21069976\\n * @nosideeffects\\n */\\nHTMLCollection.prototype.namedItem = function(name) {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLCollection<HTMLOptionElement>}\\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#htmloptionscollection\\n */\\nfunction HTMLOptionsCollection() {}\\n\\n/**\\n * @type {number}\\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#dom-htmloptionscollection-length\\n * @nosideeffects\\n */\\nHTMLOptionsCollection.prototype.length;\\n\\n/**\\n * @param {HTMLOptionElement|HTMLOptGroupElement} element\\n * @param {HTMLElement|number=} before\\n * @return {undefined}\\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#dom-htmloptionscollection-add\\n */\\nHTMLOptionsCollection.prototype.add = function(element, before) {};\\n\\n/**\\n * NOTE(tjgq): The HTMLOptionsCollection#item method is inherited from\\n * HTMLCollection, but it must be declared explicitly to work around an error\\n * when building a jsinterop library for GWT.\\n * @param {number} index\\n * @return {HTMLOptionElement}\\n * @override\\n * @nosideeffects\\n */\\nHTMLOptionsCollection.prototype.item = function(index) {};\\n\\n/**\\n * @param {number} index\\n * @return {undefined}\\n * @see https://html.spec.whatwg.org/multipage/common-dom-interfaces.html#dom-htmloptionscollection-remove\\n */\\nHTMLOptionsCollection.prototype.remove = function(index) {};\\n\\n/**\\n * @constructor\\n * @extends {Document}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26809268\\n */\\nfunction HTMLDocument() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18446827\\n */\\nHTMLDocument.prototype.title;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95229140\\n */\\nHTMLDocument.prototype.referrer;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-2250147\\n */\\nHTMLDocument.prototype.domain;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46183437\\n */\\nHTMLDocument.prototype.URL;\\n\\n/**\\n * @type {!HTMLBodyElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-56360201\\n */\\nHTMLDocument.prototype.body;\\n\\n/**\\n * @type {!HTMLCollection<!HTMLImageElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90379117\\n */\\nHTMLDocument.prototype.images;\\n\\n/**\\n * @type {!HTMLCollection<!HTMLAppletElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85113862\\n */\\nHTMLDocument.prototype.applets;\\n\\n/**\\n * @type {!HTMLCollection<(!HTMLAnchorElement|!HTMLAreaElement)>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7068919\\n */\\nHTMLDocument.prototype.links;\\n\\n/**\\n * @type {!HTMLCollection<!HTMLFormElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-1689064\\n */\\nHTMLDocument.prototype.forms;\\n\\n/**\\n * @type {!HTMLCollection<!HTMLAnchorElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7577272\\n */\\nHTMLDocument.prototype.anchors;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8747038\\n */\\nHTMLDocument.prototype.cookie;\\n\\n/**\\n * @param {string=} opt_mimeType\\n * @param {string=} opt_replace\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-72161170\\n * Even though official spec says \\"no parameters\\" some old browsers might take\\n * optional parameters: https://msdn.microsoft.com/en-us/library/ms536652(v=vs.85).aspx\\n * @override\\n */\\nHTMLDocument.prototype.open = function(opt_mimeType, opt_replace) {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-98948567\\n * @override\\n */\\nHTMLDocument.prototype.close = function() {};\\n\\n/**\\n * @param {!TrustedHTML|string} text\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75233634\\n * @override\\n */\\nHTMLDocument.prototype.write = function(text) {};\\n\\n/**\\n * @param {!TrustedHTML|string} text\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35318390\\n * @override\\n */\\nHTMLDocument.prototype.writeln = function(text) {};\\n\\n/**\\n * @param {string} elementName\\n * @return {!NodeList<!Element>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71555259\\n * @nosideeffects\\n */\\nHTMLDocument.prototype.getElementsByName = function(elementName) {};\\n\\n\\n/** @typedef {{\\n  createNodeIterator: function(Node, number=, NodeFilter=, boolean=) : NodeIterator,\\n  createTreeWalker: function(Node, number=, NodeFilter=, boolean=) : TreeWalker\\n}} */\\nvar TraversalDocument;\\n\\n/**\\n * @record\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeFilter\\n*/\\nfunction NodeFilter() {}\\n\\n/* Constants for whatToShow */\\n/** @const {number} */ NodeFilter.SHOW_ALL;\\n/** @const {number} */ NodeFilter.SHOW_ATTRIBUTE;\\n/** @const {number} */ NodeFilter.SHOW_CDATA_SECTION;\\n/** @const {number} */ NodeFilter.SHOW_COMMENT;\\n/** @const {number} */ NodeFilter.SHOW_DOCUMENT;\\n/** @const {number} */ NodeFilter.SHOW_DOCUMENT_FRAGMENT;\\n/** @const {number} */ NodeFilter.SHOW_DOCUMENT_TYPE;\\n/** @const {number} */ NodeFilter.SHOW_ELEMENT;\\n/** @const {number} */ NodeFilter.SHOW_ENTITY;\\n/** @const {number} */ NodeFilter.SHOW_ENTITY_REFERENCE;\\n/** @const {number} */ NodeFilter.SHOW_NOTATION;\\n/** @const {number} */ NodeFilter.SHOW_PROCESSING_INSTRUCTION;\\n/** @const {number} */ NodeFilter.SHOW_TEXT;\\n\\n/* Consants for acceptNode */\\n/** @const {number} */ NodeFilter.FILTER_ACCEPT;\\n/** @const {number} */ NodeFilter.FILTER_REJECT;\\n/** @const {number} */ NodeFilter.FILTER_SKIP;\\n\\n/**\\n * @param {Node} n\\n * @return {number} Any of NodeFilter.FILTER_* constants.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeFilter-acceptNode\\n*/\\nNodeFilter.prototype.acceptNode = function(n) {};\\n\\n/**\\n * @interface\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator\\n*/\\nfunction NodeIterator() {}\\n\\n/**\\n * Detach and invalidate the NodeIterator.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-detach\\n * @return {undefined}\\n */\\nNodeIterator.prototype.detach = function() {};\\n\\n/**\\n * @return {Node} Next node in the set.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-nextNode\\n */\\nNodeIterator.prototype.nextNode = function() {};\\n\\n/**\\n * @return {Node} Previous node in the set.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-previousNode\\n */\\nNodeIterator.prototype.previousNode = function() {};\\n\\n/**\\n * @interface\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker\\n*/\\nfunction TreeWalker() {}\\n\\n/**\\n * @return {?Node} The new Node or null.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-firstChild\\n */\\nTreeWalker.prototype.firstChild = function() {};\\n\\n/**\\n * @return {?Node} The new Node or null..\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-lastChild\\n */\\nTreeWalker.prototype.lastChild = function() {};\\n\\n/**\\n * @return {?Node} The new Node or null.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-nextNode\\n */\\nTreeWalker.prototype.nextNode = function() {};\\n\\n/**\\n * @return {?Node} The new Node or null.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-nextSibling\\n */\\nTreeWalker.prototype.nextSibling = function() {};\\n\\n/**\\n * @return {?Node} The new Node or null.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-parentNode\\n */\\nTreeWalker.prototype.parentNode = function() {};\\n\\n/**\\n * @return {?Node} The new Node or null.\\n ';
a.a+="* @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-previousNode\\n */\\nTreeWalker.prototype.previousNode = function() {};\\n\\n/**\\n * @return {?Node} The new Node or null.\\n * @see http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-previousSibling\\n */\\nTreeWalker.prototype.previousSibling = function() {};\\n\\n/**\\n * @type {Node}\\n */\\nTreeWalker.prototype.root;\\n\\n/**\\n * @type {number}\\n */\\nTreeWalker.prototype.whatToShow;\\n\\n/**\\n * @type {NodeFilter}\\n */\\nTreeWalker.prototype.filter;\\n\\n/**\\n * @type {boolean}\\n */\\nTreeWalker.prototype.expandEntityReference;\\n\\n/**\\n * @type {Node}\\n */\\nTreeWalker.prototype.currentNode;\\n\\n/**\\n * @constructor\\n * @extends {Element}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58190037\\n */\\nfunction HTMLElement() {}\\n\\n/**\\n * @implicitCast\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63534901\\n */\\nHTMLElement.prototype.id;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-78276800\\n */\\nHTMLElement.prototype.title;\\n\\n/**\\n * @type {!CSSStyleDeclaration}\\n * @see http://www.w3.org/TR/DOM-Level-2-Style/css.html#CSS-ElementCSSInlineStyle\\n */\\nHTMLElement.prototype.style;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59132807\\n */\\nHTMLElement.prototype.lang;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52460740\\n */\\nHTMLElement.prototype.dir;\\n\\n/**\\n * @implicitCast\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95362176\\n */\\nHTMLElement.prototype.className;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40676705\\n */\\nHTMLElement.prototype.tabIndex;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33759296\\n */\\nfunction HTMLHtmlElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9383775\\n */\\nHTMLHtmlElement.prototype.version;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77253168\\n */\\nfunction HTMLHeadElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96921909\\n */\\nHTMLHeadElement.prototype.profile;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @implements {LinkStyle}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35143001\\n */\\nfunction HTMLLinkElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87355129\\n */\\nHTMLLinkElement.prototype.disabled;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63954491\\n */\\nHTMLLinkElement.prototype.charset;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33532588\\n */\\nHTMLLinkElement.prototype.href;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85145682\\n */\\nHTMLLinkElement.prototype.hreflang;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75813125\\n */\\nHTMLLinkElement.prototype.media;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-41369587\\n */\\nHTMLLinkElement.prototype.rel;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40715461\\n */\\nHTMLLinkElement.prototype.rev;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84183095\\n */\\nHTMLLinkElement.prototype.target;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32498296\\n */\\nHTMLLinkElement.prototype.type;\\n\\n/** @type {StyleSheet} */\\nHTMLLinkElement.prototype.sheet;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79243169\\n */\\nfunction HTMLTitleElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77500413\\n */\\nHTMLTitleElement.prototype.text;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-37041454\\n */\\nfunction HTMLMetaElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87670826\\n */\\nHTMLMetaElement.prototype.content;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77289449\\n */\\nHTMLMetaElement.prototype.httpEquiv;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-31037081\\n */\\nHTMLMetaElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35993789\\n */\\nHTMLMetaElement.prototype.scheme;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73629039\\n */\\nfunction HTMLBaseElement() {}\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-65382887\\n */\\nHTMLBaseElement.prototype.href;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73844298\\n */\\nHTMLBaseElement.prototype.target;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85283003\\n */\\nfunction HTMLIsIndexElement() {}\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87069980\\n */\\nHTMLIsIndexElement.prototype.form;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33589862\\n */\\nHTMLIsIndexElement.prototype.prompt;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @implements {LinkStyle}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16428977\\n */\\nfunction HTMLStyleElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-51162010\\n */\\nHTMLStyleElement.prototype.disabled;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76412738\\n */\\nHTMLStyleElement.prototype.media;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22472002\\n */\\nHTMLStyleElement.prototype.type;\\n\\n/** @type {StyleSheet} */\\nHTMLStyleElement.prototype.sheet;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62018039\\n */\\nfunction HTMLBodyElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59424581\\n */\\nHTMLBodyElement.prototype.aLink;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-37574810\\n */\\nHTMLBodyElement.prototype.background;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-24940084\\n */\\nHTMLBodyElement.prototype.bgColor;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7662206\\n */\\nHTMLBodyElement.prototype.link;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73714763\\n */\\nHTMLBodyElement.prototype.text;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83224305\\n */\\nHTMLBodyElement.prototype.vLink;\\n\\n/**\\n * @constructor\\n * @extends {HTMLCollection<T>}\\n * @implements {IObject<string, (T|RadioNodeList<T>)>}\\n * @implements {IArrayLike<T>}\\n * @template T\\n * @see https://html.spec.whatwg.org/multipage/infrastructure.html#the-htmlformcontrolscollection-interface\\n */\\nfunction HTMLFormControlsCollection() {}\\n\\n/**\\n * @param {string} name\\n * @return {T|RadioNodeList<T>|null}\\n * @see https://html.spec.whatwg.org/multipage/infrastructure.html#dom-htmlformcontrolscollection-nameditem\\n * @nosideeffects\\n * @override\\n * @suppress {newCheckTypes}\\n */\\nHTMLFormControlsCollection.prototype.namedItem = function(name) {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40002357\\n */\\nfunction HTMLFormElement() {}\\n\\n/**\\n * @type {!HTMLFormControlsCollection<!HTMLElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76728479\\n */\\nHTMLFormElement.prototype.elements;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#HTML-HTMLFormElement-length\\n */\\nHTMLFormElement.prototype.length;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22051454\\n */\\nHTMLFormElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-19661795\\n */\\nHTMLFormElement.prototype.acceptCharset;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74049184\\n */\\nHTMLFormElement.prototype.action;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84227810\\n */\\nHTMLFormElement.prototype.enctype;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82545539\\n */\\nHTMLFormElement.prototype.method;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6512890\\n */\\nHTMLFormElement.prototype.target;\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76767676\\n */\\nHTMLFormElement.prototype.submit = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76767677\\n */\\nHTMLFormElement.prototype.reset = function() {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-94282980\\n */\\nfunction HTMLSelectElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58783172\\n */\\nHTMLSelectElement.prototype.type;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85676760\\n */\\nHTMLSelectElement.prototype.selectedIndex;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59351919\\n */\\nHTMLSelectElement.prototype.value;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-5933486\\n */\\nHTMLSelectElement.prototype.length;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20489458\\n */\\nHTMLSelectElement.prototype.form;\\n\\n/**\\n * @type {!HTMLOptionsCollection}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30606413\\n */\\nHTMLSelectElement.prototype.options;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79102918\\n */\\nHTMLSelectElement.prototype.disabled;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13246613\\n */\\nHTMLSelectElement.prototype.multiple;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-41636323\\n */\\nHTMLSelectElement.prototype.name;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18293826\\n */\\nHTMLSelectElement.prototype.size;\\n\\n/**\\n * @param {HTMLElement} element\\n * @param {HTMLElement=} opt_before\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14493106\\n */\\nHTMLSelectElement.prototype.add = function(element, opt_before) {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-28216144\\n * @override\\n */\\nHTMLSelectElement.prototype.blur = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32130014\\n * @override\\n */\\nHTMLSelectElement.prototype.focus = function() {};\\n\\n/**\\n * @param {number=} opt_index\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-33404570\\n * @override\\n */\\nHTMLSelectElement.prototype.remove = function(opt_index) {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38450247\\n */\\nfunction HTMLOptGroupElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-15518803\\n */\\nHTMLOptGroupElement.prototype.disabled;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95806054\\n */\\nHTMLOptGroupElement.prototype.label;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70901257\\n */\\nfunction HTMLOptionElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-37770574\\n */\\nHTMLOptionElement.prototype.defaultSelected;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-23482473\\n */\\nHTMLOptionElement.prototype.disabled;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-17116503\\n */\\nHTMLOptionElement.prototype.form;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14038413\\n */\\nHTMLOptionElement.prototype.index;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40736115\\n */\\nHTMLOptionElement.prototype.label;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70874476\\n */\\nHTMLOptionElement.prototype.selected;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48154426\\n */\\nHTMLOptionElement.prototype.text;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6185554\\n */\\nHTMLOptionElement.prototype.value;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6043025\\n */\\nfunction HTMLInputElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-15328520\\n */\\nHTMLInputElement.prototype.accept;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59914154\\n */\\nHTMLInputElement.prototype.accessKey;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96991182\\n */\\nHTMLInputElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-92701314\\n */\\nHTMLInputElement.prototype.alt;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30233917\\n */\\nHTMLInputElement.prototype.checked;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20509171\\n */\\nHTMLInputElement.prototype.defaultChecked;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26091157\\n */\\nHTMLInputElement.prototype.defaultValue;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-50886781\\n */\\nHTMLInputElement.prototype.disabled;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63239895\\n */\\nHTMLInputElement.prototype.form;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-54719353\\n */\\nHTMLInp";
a.a+="utElement.prototype.maxLength;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-89658498\\n */\\nHTMLInputElement.prototype.name;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88461592\\n */\\nHTMLInputElement.prototype.readOnly;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79659438\\n */\\nHTMLInputElement.prototype.size;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-97320704\\n */\\nHTMLInputElement.prototype.src;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62176355\\n */\\nHTMLInputElement.prototype.tabIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-62883744\\n */\\nHTMLInputElement.prototype.type;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32463706\\n */\\nHTMLInputElement.prototype.useMap;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-49531485\\n */\\nHTMLInputElement.prototype.value;\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26838235\\n * @override\\n */\\nHTMLInputElement.prototype.blur = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-2651361\\n * @override\\n */\\nHTMLInputElement.prototype.click = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-65996295\\n * @override\\n */\\nHTMLInputElement.prototype.focus = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-34677168\\n */\\nHTMLInputElement.prototype.select = function() {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-24874179\\n */\\nfunction HTMLTextAreaElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-93102991\\n */\\nHTMLTextAreaElement.prototype.accessKey;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-51387225\\n */\\nHTMLTextAreaElement.prototype.cols;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-36152213\\n */\\nHTMLTextAreaElement.prototype.defaultValue;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-98725443\\n */\\nHTMLTextAreaElement.prototype.disabled;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18911464\\n */\\nHTMLTextAreaElement.prototype.form;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70715578\\n */\\nHTMLTextAreaElement.prototype.name;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39131423\\n */\\nHTMLTextAreaElement.prototype.readOnly;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46975887\\n */\\nHTMLTextAreaElement.prototype.rows;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-60363303\\n */\\nHTMLTextAreaElement.prototype.tabIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#HTML-HTMLTextAreaElement-type\\n */\\nHTMLTextAreaElement.prototype.type;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70715579\\n */\\nHTMLTextAreaElement.prototype.value;\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6750689\\n * @override\\n */\\nHTMLTextAreaElement.prototype.blur = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39055426\\n * @override\\n */\\nHTMLTextAreaElement.prototype.focus = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48880622\\n */\\nHTMLTextAreaElement.prototype.select = function() {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-34812697\\n */\\nfunction HTMLButtonElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-73169431\\n */\\nHTMLButtonElement.prototype.accessKey;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-92757155\\n */\\nHTMLButtonElement.prototype.disabled;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71254493\\n */\\nHTMLButtonElement.prototype.form;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11029910\\n */\\nHTMLButtonElement.prototype.name;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39190908\\n */\\nHTMLButtonElement.prototype.tabIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-27430092\\n */\\nHTMLButtonElement.prototype.type;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-72856782\\n */\\nHTMLButtonElement.prototype.value;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13691394\\n */\\nfunction HTMLLabelElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43589892\\n */\\nHTMLLabelElement.prototype.accessKey;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32480901\\n */\\nHTMLLabelElement.prototype.form;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96509813\\n */\\nHTMLLabelElement.prototype.htmlFor;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-7365882\\n */\\nfunction HTMLFieldSetElement() {}\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75392630\\n */\\nHTMLFieldSetElement.prototype.form;\\n\\n/**\\n * @type {boolean}\\n * @see https://www.w3.org/TR/html5/forms.html#attr-fieldset-disabled\\n */\\nHTMLFieldSetElement.prototype.disabled;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-21482039\\n */\\nfunction HTMLLegendElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11297832\\n */\\nHTMLLegendElement.prototype.accessKey;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79538067\\n */\\nHTMLLegendElement.prototype.align;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-29594519\\n */\\nHTMLLegendElement.prototype.form;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-86834457\\n */\\nfunction HTMLUListElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39864178\\n */\\nHTMLUListElement.prototype.compact;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96874670\\n */\\nHTMLUListElement.prototype.type;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58056027\\n */\\nfunction HTMLOListElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-76448506\\n */\\nHTMLOListElement.prototype.compact;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14793325\\n */\\nHTMLOListElement.prototype.start;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40971103\\n */\\nHTMLOListElement.prototype.type;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52368974\\n */\\nfunction HTMLDListElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-21738539\\n */\\nHTMLDListElement.prototype.compact;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71600284\\n */\\nfunction HTMLDirectoryElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75317739\\n */\\nHTMLDirectoryElement.prototype.compact;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-72509186\\n * @see http://www.w3.org/html/wg/drafts/html/master/interactive-elements.html#the-menu-element\\n */\\nfunction HTMLMenuElement() {}\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68436464\\n */\\nHTMLMenuElement.prototype.compact;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74680021\\n */\\nfunction HTMLLIElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52387668\\n */\\nHTMLLIElement.prototype.type;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-45496263\\n */\\nHTMLLIElement.prototype.value;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22445964\\n */\\nfunction HTMLDivElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70908791\\n */\\nHTMLDivElement.prototype.align;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84675076\\n */\\nfunction HTMLParagraphElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53465507\\n */\\nHTMLParagraphElement.prototype.align;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43345119\\n */\\nfunction HTMLHeadingElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6796462\\n */\\nHTMLHeadingElement.prototype.align;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70319763\\n */\\nfunction HTMLQuoteElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53895598\\n */\\nHTMLQuoteElement.prototype.cite;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11383425\\n */\\nfunction HTMLPreElement() {}\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13894083\\n */\\nHTMLPreElement.prototype.width;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-56836063\\n */\\nfunction HTMLBRElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82703081\\n */\\nHTMLBRElement.prototype.clear;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32774408\\n */\\nfunction HTMLBaseFontElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87502302\\n */\\nHTMLBaseFontElement.prototype.color;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88128969\\n */\\nHTMLBaseFontElement.prototype.face;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38930424\\n */\\nHTMLBaseFontElement.prototype.size;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-43943847\\n */\\nfunction HTMLFontElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53532975\\n */\\nHTMLFontElement.prototype.color;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-55715655\\n */\\nHTMLFontElement.prototype.face;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90127284\\n */\\nHTMLFontElement.prototype.size;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68228811\\n */\\nfunction HTMLHRElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-15235012\\n */\\nHTMLHRElement.prototype.align;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79813978\\n */\\nHTMLHRElement.prototype.noShade;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77612587\\n */\\nHTMLHRElement.prototype.size;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87744198\\n */\\nHTMLHRElement.prototype.width;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79359609\\n */\\nfunction HTMLModElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75101708\\n */\\nHTMLModElement.prototype.cite;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88432678\\n */\\nHTMLModElement.prototype.dateTime;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-48250443\\n */\\nfunction HTMLAnchorElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-89647724\\n */\\nHTMLAnchorElement.prototype.accessKey;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67619266\\n */\\nHTMLAnchorElement.prototype.charset;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-92079539\\n */\\nHTMLAnchorElement.prototype.coords;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88517319\\n */\\nHTMLAnchorElement.prototype.href;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87358513\\n */\\nHTMLAnchorElement.prototype.hreflang;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-32783304\\n */\\nHTMLAnchorElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-3815891\\n */\\nHTMLAnchorElement.prototype.rel;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58259771\\n */\\nHTMLAnchorElement.prototype.rev;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-49899808\\n */\\nHTMLAnchorElement.prototype.shape;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-41586466\\n */\\nHTMLAnchorElement.prototype.tabIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6414197\\n */\\nHTMLAnchorElement.prototype.target;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63938221\\n */\\nHTMLAnchorElement.prototype.type;\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-65068939\\n * @override\\n */\\nHTMLAnchorElement.prototyp";
a.a+="e.blur = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-47150313\\n * @override\\n */\\nHTMLAnchorElement.prototype.focus = function() {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-17701901\\n */\\nfunction HTMLImageElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-3211094\\n */\\nHTMLImageElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-95636861\\n */\\nHTMLImageElement.prototype.alt;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-136671\\n */\\nHTMLImageElement.prototype.border;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91561496\\n */\\nHTMLImageElement.prototype.height;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53675471\\n */\\nHTMLImageElement.prototype.hspace;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58983880\\n */\\nHTMLImageElement.prototype.isMap;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77376969\\n */\\nHTMLImageElement.prototype.longDesc;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91256910\\n */\\nHTMLImageElement.prototype.lowSrc;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-47534097\\n */\\nHTMLImageElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-87762984\\n */\\nHTMLImageElement.prototype.src;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35981181\\n */\\nHTMLImageElement.prototype.useMap;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85374897\\n */\\nHTMLImageElement.prototype.vspace;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13839076\\n */\\nHTMLImageElement.prototype.width;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9893177\\n */\\nfunction HTMLObjectElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16962097\\n */\\nHTMLObjectElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-47783837\\n */\\nHTMLObjectElement.prototype.archive;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82818419\\n */\\nHTMLObjectElement.prototype.border;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75241146\\n */\\nHTMLObjectElement.prototype.code;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-25709136\\n */\\nHTMLObjectElement.prototype.codeBase;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-19945008\\n */\\nHTMLObjectElement.prototype.codeType;\\n\\n/**\\n * @type {Document}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38538621\\n */\\nHTMLObjectElement.prototype.contentDocument;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-81766986\\n */\\nHTMLObjectElement.prototype.data;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-942770\\n */\\nHTMLObjectElement.prototype.declare;\\n\\n/**\\n * @type {HTMLFormElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46094773\\n */\\nHTMLObjectElement.prototype.form;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-88925838\\n */\\nHTMLObjectElement.prototype.height;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-17085376\\n */\\nHTMLObjectElement.prototype.hspace;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-20110362\\n */\\nHTMLObjectElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-25039673\\n */\\nHTMLObjectElement.prototype.standby;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-27083787\\n */\\nHTMLObjectElement.prototype.tabIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-91665621\\n */\\nHTMLObjectElement.prototype.type;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6649772\\n */\\nHTMLObjectElement.prototype.useMap;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8682483\\n */\\nHTMLObjectElement.prototype.vspace;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38538620\\n */\\nHTMLObjectElement.prototype.width;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64077273\\n */\\nfunction HTMLParamElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59871447\\n */\\nHTMLParamElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18179888\\n */\\nHTMLParamElement.prototype.type;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77971357\\n */\\nHTMLParamElement.prototype.value;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-23931872\\n */\\nHTMLParamElement.prototype.valueType;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-31006348\\n */\\nfunction HTMLAppletElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8049912\\n */\\nHTMLAppletElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-58610064\\n */\\nHTMLAppletElement.prototype.alt;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14476360\\n */\\nHTMLAppletElement.prototype.archive;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-61509645\\n */\\nHTMLAppletElement.prototype.code;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6581160\\n */\\nHTMLAppletElement.prototype.codeBase;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90184867\\n */\\nHTMLAppletElement.prototype.height;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-1567197\\n */\\nHTMLAppletElement.prototype.hspace;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39843695\\n */\\nHTMLAppletElement.prototype.name;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-93681523\\n */\\nHTMLAppletElement.prototype.object;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22637173\\n */\\nHTMLAppletElement.prototype.vspace;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16526327\\n */\\nHTMLAppletElement.prototype.width;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-94109203\\n */\\nfunction HTMLMapElement() {}\\n\\n/**\\n * @type {HTMLCollection<!HTMLAreaElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-71838730\\n */\\nHTMLMapElement.prototype.areas;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52696514\\n */\\nHTMLMapElement.prototype.name;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26019118\\n */\\nfunction HTMLAreaElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-57944457\\n */\\nHTMLAreaElement.prototype.accessKey;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-39775416\\n */\\nHTMLAreaElement.prototype.alt;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-66021476\\n */\\nHTMLAreaElement.prototype.coords;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-34672936\\n */\\nHTMLAreaElement.prototype.href;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-61826871\\n */\\nHTMLAreaElement.prototype.noHref;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-85683271\\n */\\nHTMLAreaElement.prototype.shape;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8722121\\n */\\nHTMLAreaElement.prototype.tabIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46054682\\n */\\nHTMLAreaElement.prototype.target;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-81598695\\n */\\nfunction HTMLScriptElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-35305677\\n */\\nHTMLScriptElement.prototype.charset;\\n\\n/**\\n * @type {boolean}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-93788534\\n */\\nHTMLScriptElement.prototype.defer;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-56700403\\n */\\nHTMLScriptElement.prototype.event;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-66979266\\n */\\nHTMLScriptElement.prototype.htmlFor;\\n\\n/**\\n * @type {?function(!Event)}\\n */\\nHTMLScriptElement.prototype.onreadystatechange;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-75147231\\n */\\nHTMLScriptElement.prototype.src;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-46872999\\n */\\nHTMLScriptElement.prototype.text;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-30534818\\n */\\nHTMLScriptElement.prototype.type;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64060425\\n */\\nfunction HTMLTableElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-23180977\\n */\\nHTMLTableElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83532985\\n */\\nHTMLTableElement.prototype.bgColor;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-50969400\\n */\\nHTMLTableElement.prototype.border;\\n\\n/**\\n * @type {HTMLTableCaptionElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-14594520\\n */\\nHTMLTableElement.prototype.caption;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-59162158\\n */\\nHTMLTableElement.prototype.cellPadding;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68907883\\n */\\nHTMLTableElement.prototype.cellSpacing;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64808476\\n */\\nHTMLTableElement.prototype.frame;\\n\\n/**\\n * @type {HTMLCollection<!HTMLTableRowElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6156016\\n */\\nHTMLTableElement.prototype.rows;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-26347553\\n */\\nHTMLTableElement.prototype.rules;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-44998528\\n */\\nHTMLTableElement.prototype.summary;\\n\\n/**\\n * @type {HTMLCollection<!HTMLTableSectionElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-63206416\\n */\\nHTMLTableElement.prototype.tBodies;\\n\\n/**\\n * @type {HTMLTableSectionElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-64197097\\n */\\nHTMLTableElement.prototype.tFoot;\\n\\n/**\\n * @type {HTMLTableSectionElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9530944\\n */\\nHTMLTableElement.prototype.tHead;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-77447361\\n */\\nHTMLTableElement.prototype.width;\\n\\n/**\\n * @return {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96920263\\n */\\nHTMLTableElement.prototype.createCaption = function() {};\\n\\n/**\\n * @return {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-8453710\\n */\\nHTMLTableElement.prototype.createTFoot = function() {};\\n\\n/**\\n * @return {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-70313345\\n */\\nHTMLTableElement.prototype.createTHead = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-22930071\\n */\\nHTMLTableElement.prototype.deleteCaption = function() {};\\n\\n/**\\n * @param {number} index\\n * @return {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-13114938\\n */\\nHTMLTableElement.prototype.deleteRow = function(index) {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-78363258\\n */\\nHTMLTableElement.prototype.deleteTFoot = function() {};\\n\\n/**\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-38310198\\n */\\nHTMLTableElement.prototype.deleteTHead = function() {};\\n\\n/**\\n * @param {number=} opt_index\\n * @return {HTMLElement}\\n * @see https://www.w3.org/TR/html5/tabular-data.html#htmltableelement\\n */\\nHTMLTableElement.prototype.insertRow = function(opt_index) {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-12035137\\n */\\nfunction HTMLTableCaptionElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79875068\\n */\\nHTMLTableCaptionElement.prototype.align;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-84150186\\n */\\nfunction HTMLTableColElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-31128447\\n */\\nHTMLTableColElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-9447412\\n */\\nHTMLTableColElement.prototype.ch;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-57779225\\n */\\nHTMLTableColElement.prototype.chOff;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-96511335\\n */\\nHTMLTableColElement.prototype.span;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83291710\\n */\\nHTMLTableColElement.prototype.vAlign;\\n\\n/**\\n * @type {string}\\n * @implicitCast\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-25196799\\n */";
a.a+='\\nHTMLTableColElement.prototype.width;\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67417573\\n */\\nfunction HTMLTableSectionElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-40530119\\n */\\nHTMLTableSectionElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-83470012\\n */\\nHTMLTableSectionElement.prototype.ch;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-53459732\\n */\\nHTMLTableSectionElement.prototype.chOff;\\n\\n/**\\n * @type {HTMLCollection<!HTMLTableRowElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-52092650\\n */\\nHTMLTableSectionElement.prototype.rows;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-4379116\\n */\\nHTMLTableSectionElement.prototype.vAlign;\\n\\n/**\\n * @param {number} index\\n * @return {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-5625626\\n */\\nHTMLTableSectionElement.prototype.deleteRow = function(index) {};\\n\\n/**\\n * @param {number=} opt_index\\n * @return {HTMLElement}\\n * @see https://www.w3.org/TR/html5/tabular-data.html#htmltablesectionelement\\n */\\nHTMLTableSectionElement.prototype.insertRow = function(opt_index) {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-6986576\\n */\\nfunction HTMLTableRowElement() {}\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-74098257\\n */\\nHTMLTableRowElement.prototype.align;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-18161327\\n */\\nHTMLTableRowElement.prototype.bgColor;\\n\\n/**\\n * @type {HTMLCollection<!HTMLTableCellElement>}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67349879\\n */\\nHTMLTableRowElement.prototype.cells;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-16230502\\n */\\nHTMLTableRowElement.prototype.ch;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68207461\\n */\\nHTMLTableRowElement.prototype.chOff;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-67347567\\n */\\nHTMLTableRowElement.prototype.rowIndex;\\n\\n/**\\n * @type {number}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-79105901\\n */\\nHTMLTableRowElement.prototype.sectionRowIndex;\\n\\n/**\\n * @type {string}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-90000058\\n */\\nHTMLTableRowElement.prototype.vAlign;\\n\\n/**\\n * @param {number} index\\n * @return {undefined}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-11738598\\n */\\nHTMLTableRowElement.prototype.deleteCell = function(index) {};\\n\\n/**\\n * @param {number} index\\n * @return {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-68927016\\n */\\nHTMLTableRowElement.prototype.insertCell = function(index) {};\\n\\n/**\\n * @constructor\\n * @extends {HTMLElement}\\n * @see http://www.w3.org/TR/2000/CR-DOM-Level-2-20000510/html.html#ID-82915075\\n */\\nfunction HTMLTableCellElement() {}\\n\\n/*