/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */

// AUTOGENERATED. DO NOT EDIT.
// clang-format off

goog.provide('goog.html.safeUrlTestVectors');
goog.setTestOnly('goog.html.safeUrlTestVectors');

goog.html.safeUrlTestVectors.BASE_VECTORS = [
      {input: '', expected: '', safe: true},
      {input: 'http://example.com/', expected: 'http://example.com/', safe: true},
      {input: 'https://example.com', expected: 'https://example.com', safe: true},
      {input: 'mailto:foo@example.com', expected: 'mailto:foo@example.com', safe: true},
      {input: 'ftp://example.com', expected: 'ftp://example.com', safe: true},
      {input: 'ftp://username@example.com', expected: 'ftp://username@example.com', safe: true},
      {input: 'ftp://username:password@example.com', expected: 'ftp://username:password@example.com', safe: true},
      {input: 'HTtp://example.com/', expected: 'HTtp://example.com/', safe: true},
      {input: 'https://example.com/path?foo\u003Dbar#baz', expected: 'https://example.com/path?foo\u003Dbar#baz', safe: true},
      {input: 'https://example.com:123/path?foo\u003Dbar\u0026abc\u003Ddef#baz', expected: 'https://example.com:123/path?foo\u003Dbar\u0026abc\u003Ddef#baz', safe: true},
      {input: '//example.com/path', expected: '//example.com/path', safe: true},
      {input: '/path', expected: '/path', safe: true},
      {input: '/path?foo\u003Dbar#baz', expected: '/path?foo\u003Dbar#baz', safe: true},
      {input: 'path', expected: 'path', safe: true},
      {input: 'path?foo\u003Dbar#baz', expected: 'path?foo\u003Dbar#baz', safe: true},
      {input: 'p//ath', expected: 'p//ath', safe: true},
      {input: 'p//ath?foo\u003Dbar#baz', expected: 'p//ath?foo\u003Dbar#baz', safe: true},
      {input: '#baz', expected: '#baz', safe: true},
      {input: '?:', expected: '?:', safe: true},
      {input: 'javascript:evil();', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'javascript:evil();//\u000Ahttp://good.com/', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'not-data:image/png;base64,z\u003D', expected: 'about:invalid#zClosurez', safe: false},
      {input: ' data:image/png;base64,z\u003D', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'tel:+1234567890', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'sms:+1234567890', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'callto:+1234567890', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'wtai://wp/mc;+1234567890', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'rtsp://example.org/', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'market://details?id\u003Dapp', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'itms://itunes.apple.com/us', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'itms-apps://itunes.apple.com/us', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'itms-appss://itunes.apple.com/us', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'itms-services://?action\u003Ddownload-manifest\u0026url\u003Dfoo', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'geo:37.7,42.0', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'skype:chat?jid\u003Dfoo', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'whatsapp://send?text\u003DHello', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'ssh://cloud.google.com', expected: 'about:invalid#zClosurez', safe: false},
      {input: ':', expected: 'about:invalid#zClosurez', safe: false},
      {input: '\\:', expected: 'about:invalid#zClosurez', safe: false},
      {input: ':/:', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'path\u000A:', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'java\u0000script:evil();', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'http://www.f\u0000\u0000.com', expected: 'http://www.f\u0000\u0000.com', safe: true},
      {input: 'data:image/png;base64,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/\u003D', expected: 'data:image/png;base64,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/\u003D', safe: true},
      {input: 'dATa:iMage/pNg;bASe64,abc\u003D\u003D\u003D', expected: 'dATa:iMage/pNg;bASe64,abc\u003D\u003D\u003D', safe: true},
      {input: 'data:image/webp;base64,abc\u003D\u003D\u003D', expected: 'data:image/webp;base64,abc\u003D\u003D\u003D', safe: true},
      {input: 'data:audio/ogg;base64,abc', expected: 'data:audio/ogg;base64,abc', safe: true},
      {input: 'data:audio/L16;base64,abc', expected: 'data:audio/L16;base64,abc', safe: true},
      {input: 'data:audio/x-matroska;base64,z\u003D', expected: 'data:audio/x-matroska;base64,z\u003D', safe: true},
      {input: 'data:video/mpeg;base64,abc', expected: 'data:video/mpeg;base64,abc', safe: true},
      {input: 'data:video/ogg;base64,z\u003D', expected: 'data:video/ogg;base64,z\u003D', safe: true},
      {input: 'data:video/mp4;base64,z\u003D', expected: 'data:video/mp4;base64,z\u003D', safe: true},
      {input: 'data:video/webm;base64,z\u003D', expected: 'data:video/webm;base64,z\u003D', safe: true},
      {input: 'data:video/x-matroska;base64,z\u003D', expected: 'data:video/x-matroska;base64,z\u003D', safe: true},
      {input: 'data:video/quicktime;base64,z\u003D', expected: 'data:video/quicktime;base64,z\u003D', safe: true},
      {input: 'data:video/webm;foo\u003Dbar;base64,z\u003D', expected: 'data:video/webm;foo\u003Dbar;base64,z\u003D', safe: true},
      {input: 'data:video/webm;foo\u003D\"bar\";base64,z\u003D', expected: 'data:video/webm;foo\u003D\"bar\";base64,z\u003D', safe: true},
      {input: 'data:video/webm;codecs\u003D\"vp8,opus\";base64,z\u003D', expected: 'data:video/webm;codecs\u003D\"vp8,opus\";base64,z\u003D', safe: true},
      {input: 'data:video/webm;codecs\u003D\"vp8, opus\";base64,z\u003D', expected: 'data:video/webm;codecs\u003D\"vp8, opus\";base64,z\u003D', safe: true}
];

goog.html.safeUrlTestVectors.TEL_VECTORS = [
    {input: 'tEl:+1(23)129-29192A.ABC#;eXt\u003D29', expected: 'tEl:+1(23)129-29192A.ABC#;eXt\u003D29', safe: true},
    {input: 'tEL:123;randmomparam\u003D123', expected: 'tEL:123;randmomparam\u003D123', safe: true},
    {input: ':', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'tell:', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'not-tel:+1', expected: 'about:invalid#zClosurez', safe: false},
    {input: ' tel:+1', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'javascript:evil()', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'tel:+1234567890', expected: 'tel:+1234567890', safe: true}
];

goog.html.safeUrlTestVectors.SMS_VECTORS = [
    {input: 'sms:+1234567890', expected: 'sms:+1234567890', safe: true},
    {input: 'sms:?body\u003Dmessage', expected: 'sms:?body\u003Dmessage', safe: true},
    {input: 'sms:?body\u003DHello, World!', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'sms:?body\u003Da\u0026body\u003Db', expected: 'about:invalid#zClosurez', safe: false}
];

goog.html.safeUrlTestVectors.SSH_VECTORS = [
    {input: 'ssh://cloud.google.com', expected: 'ssh://cloud.google.com', safe: true},
    {input: '', expected: 'about:invalid#zClosurez', safe: false},
    {input: ':', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'ssh:cloud.google.com', expected: 'about:invalid#zClosurez', safe: false},
    {input: ' ssh://cloud.google.com', expected: 'about:invalid#zClosurez', safe: false},
    {input: 'javascript:evil()', expected: 'about:invalid#zClosurez', safe: false}
];
