/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @fileoverview List of native country and language names.
 *
 * File generated from CLDR ver. 39
 */

// clang-format off

/**
 * Namespace for native country and language names
 */
goog.provide('goog.locale.nativeNameConstants');

/**
 * Native country and language names
 * @const {!Object<string, !Object<string, string>>}
 */
goog.locale.nativeNameConstants = {
  'COUNTRY': {
    'AC': 'Ascension Island',
    'AD': 'Andorra',
    'AE': 'الإمارات العربية المتحدة',
    'AF': 'افغانستان',
    'AG': 'Antigua & Barbuda',
    'AI': 'Anguilla',
    'AL': 'Shqipëri',
    'AM': 'Հայաստան',
    'AO': 'Angola',
    'AQ': 'Antarctica',
    'AR': 'Argentina',
    'AS': 'American Samoa',
    'AT': 'Österreich',
    'AU': 'Australia',
    'AW': 'Aruba',
    'AX': 'Åland',
    'AZ': 'Azərbaycan',
    'BA': 'Bosna i Hercegovina',
    'BB': 'Barbados',
    'BD': 'বাংলাদেশ',
    'BE': 'België',
    'BF': 'Burkina Faso',
    'BG': 'България',
    'BH': 'البحرين',
    'BI': 'Uburundi',
    'BJ': 'Bénin',
    'BL': 'Saint-Barthélemy',
    'BM': 'Bermuda',
    'BN': 'Brunei',
    'BO': 'Bolivia',
    'BQ': 'Caribbean Netherlands',
    'BR': 'Brasil',
    'BS': 'Bahamas',
    'BT': 'འབྲུག',
    'BV': 'Bouvet Island',
    'BW': 'Botswana',
    'BY': 'Беларусь',
    'BZ': 'Belize',
    'CA': 'Canada',
    'CC': 'Cocos (Keeling) Islands',
    'CD': 'Jamhuri ya Kidemokrasia ya Kongo',
    'CF': 'République centrafricaine',
    'CG': 'Congo-Brazzaville',
    'CH': 'Schweiz',
    'CI': 'Côte d’Ivoire',
    'CK': 'Cook Islands',
    'CL': 'Chile',
    'CM': 'Cameroun',
    'CN': '中国',
    'CO': 'Colombia',
    'CP': 'Clipperton Island',
    'CR': 'Costa Rica',
    'CU': 'Cuba',
    'CV': 'Cabo Verde',
    'CW': 'Curaçao',
    'CX': 'Christmas Island',
    'CY': 'Κύπρος',
    'CZ': 'Česko',
    'DE': 'Deutschland',
    'DG': 'Diego Garcia',
    'DJ': 'Djibouti',
    'DK': 'Danmark',
    'DM': 'Dominica',
    'DO': 'República Dominicana',
    'DZ': 'الجزائر',
    'EA': 'Ceuta y Melilla',
    'EC': 'Ecuador',
    'EE': 'Eesti',
    'EG': 'مصر',
    'EH': 'الصحراء الغربية',
    'ER': 'ኤርትራ',
    'ES': 'España',
    'ET': 'ኢትዮጵያ',
    'FI': 'Suomi',
    'FJ': 'Fiji',
    'FK': 'Falkland Islands (Islas Malvinas)',
    'FM': 'Micronesia',
    'FO': 'Føroyar',
    'FR': 'France',
    'GA': 'Gabon',
    'GB': 'United Kingdom',
    'GD': 'Grenada',
    'GE': 'საქართველო',
    'GF': 'Guyane française',
    'GG': 'Guernsey',
    'GH': 'Gaana',
    'GI': 'Gibraltar',
    'GL': 'Kalaallit Nunaat',
    'GM': 'Gambia',
    'GN': 'Guinée',
    'GP': 'Guadeloupe',
    'GQ': 'Guinea Ecuatorial',
    'GR': 'Ελλάδα',
    'GS': 'South Georgia & South Sandwich Islands',
    'GT': 'Guatemala',
    'GU': 'Guam',
    'GW': 'Guiné-Bissau',
    'GY': 'Guyana',
    'HK': '香港',
    'HM': 'Heard & McDonald Islands',
    'HN': 'Honduras',
    'HR': 'Hrvatska',
    'HT': 'Haiti',
    'HU': 'Magyarország',
    'IC': 'Canarias',
    'ID': 'Indonesia',
    'IE': 'Ireland',
    'IL': 'ישראל',
    'IM': 'Isle of Man',
    'IN': 'भारत',
    'IO': 'British Indian Ocean Territory',
    'IQ': 'العراق',
    'IR': 'ایران',
    'IS': 'Ísland',
    'IT': 'Italia',
    'JE': 'Jersey',
    'JM': 'Jamaica',
    'JO': 'الأردن',
    'JP': '日本',
    'KE': 'Kenya',
    'KG': 'Кыргызстан',
    'KH': 'កម្ពុជា',
    'KI': 'Kiribati',
    'KM': 'جزر القمر',
    'KN': 'St. Kitts & Nevis',
    'KP': '북한',
    'KR': '대한민국',
    'KW': 'الكويت',
    'KY': 'Cayman Islands',
    'KZ': 'Казахстан',
    'LA': 'ລາວ',
    'LB': 'لبنان',
    'LC': 'St. Lucia',
    'LI': 'Liechtenstein',
    'LK': 'ශ්‍රී ලංකාව',
    'LR': 'Liberia',
    'LS': 'Lesotho',
    'LT': 'Lietuva',
    'LU': 'Luxembourg',
    'LV': 'Latvija',
    'LY': 'ليبيا',
    'MA': 'المغرب',
    'MC': 'Monaco',
    'MD': 'Republica Moldova',
    'ME': 'Crna Gora',
    'MF': 'Saint-Martin',
    'MG': 'Madagasikara',
    'MH': 'Marshall Islands',
    'MK': 'Северна Македонија',
    'ML': 'Mali',
    'MM': 'မြန်မာ',
    'MN': 'Монгол',
    'MO': '澳門',
    'MP': 'Northern Mariana Islands',
    'MQ': 'Martinique',
    'MR': 'موريتانيا',
    'MS': 'Montserrat',
    'MT': 'Malta',
    'MU': 'Moris',
    'MV': 'Maldives',
    'MW': 'Malawi',
    'MX': 'México',
    'MY': 'Malaysia',
    'MZ': 'Moçambique',
    'NA': 'Namibië',
    'NC': 'Nouvelle-Calédonie',
    'NE': 'Nijar',
    'NF': 'Norfolk Island',
    'NG': 'Nigeria',
    'NI': 'Nicaragua',
    'NL': 'Nederland',
    'NO': 'Norge',
    'NP': 'नेपाल',
    'NR': 'Nauru',
    'NU': 'Niue',
    'NZ': 'New Zealand',
    'OM': 'عُمان',
    'PA': 'Panamá',
    'PE': 'Perú',
    'PF': 'Polynésie française',
    'PG': 'Papua New Guinea',
    'PH': 'Pilipinas',
    'PK': 'پاکستان',
    'PL': 'Polska',
    'PM': 'Saint-Pierre-et-Miquelon',
    'PN': 'Pitcairn Islands',
    'PR': 'Puerto Rico',
    'PS': 'فلسطين',
    'PT': 'Portugal',
    'PW': 'Palau',
    'PY': 'Paraguay',
    'QA': 'قطر',
    'RE': 'La Réunion',
    'RO': 'România',
    'RS': 'Србија',
    'RU': 'Россия',
    'RW': 'U Rwanda',
    'SA': 'المملكة العربية السعودية',
    'SB': 'Solomon Islands',
    'SC': 'Seychelles',
    'SD': 'السودان',
    'SE': 'Sverige',
    'SG': 'Singapore',
    'SH': 'St. Helena',
    'SI': 'Slovenija',
    'SJ': 'Svalbard og Jan Mayen',
    'SK': 'Slovensko',
    'SL': 'Sierra Leone',
    'SM': 'San Marino',
    'SN': 'Sénégal',
    'SO': 'Soomaaliya',
    'SR': 'Suriname',
    'SS': 'South Sudan',
    'ST': 'São Tomé e Príncipe',
    'SV': 'El Salvador',
    'SX': 'Sint Maarten',
    'SY': 'سوريا',
    'SZ': 'Eswatini',
    'TA': 'Tristan da Cunha',
    'TC': 'Turks & Caicos Islands',
    'TD': 'Tchad',
    'TF': 'Terres australes françaises',
    'TG': 'Togo',
    'TH': 'ไทย',
    'TJ': 'Тоҷикистон',
    'TK': 'Tokelau',
    'TL': 'Timor-Leste',
    'TM': 'Türkmenistan',
    'TN': 'تونس',
    'TO': 'Tonga',
    'TR': 'Türkiye',
    'TT': 'Trinidad & Tobago',
    'TV': 'Tuvalu',
    'TW': '台灣',
    'TZ': 'Tanzania',
    'UA': 'Україна',
    'UG': 'Uganda',
    'UM': 'U.S. Outlying Islands',
    'US': 'United States',
    'UY': 'Uruguay',
    'UZ': 'Oʻzbekiston',
    'VA': 'Città del Vaticano',
    'VC': 'St. Vincent & Grenadines',
    'VE': 'Venezuela',
    'VG': 'British Virgin Islands',
    'VI': 'U.S. Virgin Islands',
    'VN': 'Việt Nam',
    'VU': 'Vanuatu',
    'WF': 'Wallis-et-Futuna',
    'WS': 'Samoa',
    'XK': 'Kosovë',
    'YE': 'اليمن',
    'YT': 'Mayotte',
    'ZA': 'South Africa',
    'ZM': 'Zambia',
    'ZW': 'Zimbabwe',
    'af_NA': 'Namibië',
    'af_ZA': 'Suid-Afrika',
    'agq_CM': 'Kàmàlûŋ',
    'ak_GH': 'Gaana',
    'am_ET': 'ኢትዮጵያ',
    'ar_001': 'العالم',
    'ar_AE': 'الإمارات العربية المتحدة',
    'ar_BH': 'البحرين',
    'ar_DJ': 'جيبوتي',
    'ar_DZ': 'الجزائر',
    'ar_EG': 'مصر',
    'ar_EH': 'الصحراء الغربية',
    'ar_ER': 'إريتريا',
    'ar_IL': 'إسرائيل',
    'ar_IQ': 'العراق',
    'ar_JO': 'الأردن',
    'ar_KM': 'جزر القمر',
    'ar_KW': 'الكويت',
    'ar_LB': 'لبنان',
    'ar_LY': 'ليبيا',
    'ar_MA': 'المغرب',
    'ar_MR': 'موريتانيا',
    'ar_OM': 'عُمان',
    'ar_PS': 'فلسطين',
    'ar_QA': 'قطر',
    'ar_SA': 'المملكة العربية السعودية',
    'ar_SD': 'السودان',
    'ar_SO': 'الصومال',
    'ar_SS': 'جنوب السودان',
    'ar_SY': 'سوريا',
    'ar_TD': 'تشاد',
    'ar_TN': 'تونس',
    'ar_XB': '؜‮Pseudo‬؜-؜‮Bidi‬؜',
    'ar_YE': 'اليمن',
    'as_IN': 'ভাৰত',
    'asa_TZ': 'Tadhania',
    'ast_ES': 'España',
    'az_Cyrl_AZ': 'Азәрбајҹан',
    'az_Latn_AZ': 'Azərbaycan',
    'bas_CM': 'Kàmɛ̀rûn',
    'be_BY': 'Беларусь',
    'bem_ZM': 'Zambia',
    'bez_TZ': 'Hutanzania',
    'bg_BG': 'България',
    'bm_ML': 'Mali',
    'bn_BD': 'বাংলাদেশ',
    'bn_IN': 'ভারত',
    'bo_CN': 'རྒྱ་ནག',
    'bo_IN': 'རྒྱ་གར་',
    'br_FR': 'Frañs',
    'brx_IN': 'भारत',
    'bs_Cyrl_BA': 'Босна и Херцеговина',
    'bs_Latn_BA': 'Bosna i Hercegovina',
    'ca_AD': 'Andorra',
    'ca_ES': 'Espanya',
    'ca_FR': 'França',
    'ca_IT': 'Itàlia',
    'ccp_BD': '𑄝𑄁𑄣𑄘𑄬𑄌𑄴',
    'ccp_IN': '𑄞𑄢𑄧𑄖𑄴',
    'ce_RU': 'Росси',
    'ceb_PH': 'Pilipinas',
    'cgg_UG': 'Uganda',
    'chr_US': 'ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ',
    'ckb_Arab_IQ': 'عێراق',
    'ckb_Arab_IR': 'ئێران',
    'ckb_IQ': 'عێراق',
    'ckb_IR': 'ئێران',
    'cs_CZ': 'Česko',
    'cy_GB': 'Y Deyrnas Unedig',
    'da_DK': 'Danmark',
    'da_GL': 'Grønland',
    'dav_KE': 'Kenya',
    'de_AT': 'Österreich',
    'de_BE': 'Belgien',
    'de_CH': 'Schweiz',
    'de_DE': 'Deutschland',
    'de_IT': 'Italien',
    'de_LI': 'Liechtenstein',
    'de_LU': 'Luxemburg',
    'dje_NE': 'Nižer',
    'doi_IN': 'भारत',
    'dsb_DE': 'Nimska',
    'dua_CM': 'Cameroun',
    'dyo_SN': 'Senegal',
    'dz_BT': 'འབྲུག',
    'ebu_KE': 'Kenya',
    'ee_GH': 'Ghana nutome',
    'ee_TG': 'Togo nutome',
    'el_CY': 'Κύπρος',
    'el_GR': 'Ελλάδα',
    'en_001': 'world',
    'en_150': 'Europe',
    'en_AE': 'United Arab Emirates',
    'en_AG': 'Antigua & Barbuda',
    'en_AI': 'Anguilla',
    'en_AS': 'American Samoa',
    'en_AT': 'Austria',
    'en_AU': 'Australia',
    'en_BB': 'Barbados',
    'en_BE': 'Belgium',
    'en_BI': 'Burundi',
    'en_BM': 'Bermuda',
    'en_BS': 'Bahamas',
    'en_BW': 'Botswana',
    'en_BZ': 'Belize',
    'en_CA': 'Canada',
    'en_CC': 'Cocos (Keeling) Islands',
    'en_CH': 'Switzerland',
    'en_CK': 'Cook Islands',
    'en_CM': 'Cameroon',
    'en_CX': 'Christmas Island',
    'en_CY': 'Cyprus',
    'en_DE': 'Germany',
    'en_DG': 'Diego Garcia',
    'en_DK': 'Denmark',
    'en_DM': 'Dominica',
    'en_ER': 'Eritrea',
    'en_FI': 'Finland',
    'en_FJ': 'Fiji',
    'en_FK': 'Falkland Islands (Islas Malvinas)',
    'en_FM': 'Micronesia',
    'en_GB': 'United Kingdom',
    'en_GD': 'Grenada',
    'en_GG': 'Guernsey',
    'en_GH': 'Ghana',
    'en_GI': 'Gibraltar',
    'en_GM': 'Gambia',
    'en_GU': 'Guam',
    'en_GY': 'Guyana',
    'en_HK': 'Hong Kong',
    'en_IE': 'Ireland',
    'en_IL': 'Israel',
    'en_IM': 'Isle of Man',
    'en_IN': 'India',
    'en_IO': 'British Indian Ocean Territory',
    'en_JE': 'Jersey',
    'en_JM': 'Jamaica',
    'en_KE': 'Kenya',
    'en_KI': 'Kiribati',
    'en_KN': 'St. Kitts & Nevis',
    'en_KY': 'Cayman Islands',
    'en_LC': 'St. Lucia',
    'en_LR': 'Liberia',
    'en_LS': 'Lesotho',
    'en_MG': 'Madagascar',
    'en_MH': 'Marshall Islands',
    'en_MO': 'Macao',
    'en_MP': 'Northern Mariana Islands',
    'en_MS': 'Montserrat',
    'en_MT': 'Malta',
    'en_MU': 'Mauritius',
    'en_MW': 'Malawi',
    'en_MY': 'Malaysia',
    'en_NA': 'Namibia',
    'en_NF': 'Norfolk Island',
    'en_NG': 'Nigeria',
    'en_NL': 'Netherlands',
    'en_NR': 'Nauru',
    'en_NU': 'Niue',
    'en_NZ': 'New Zealand',
    'en_PG': 'Papua New Guinea',
    'en_PH': 'Philippines',
    'en_PK': 'Pakistan',
    'en_PN': 'Pitcairn Islands',
    'en_PR': 'Puerto Rico',
    'en_PW': 'Palau',
    'en_RW': 'Rwanda',
    'en_SB': 'Solomon Islands',
    'en_SC': 'Seychelles',
    'en_SD': 'Sudan',
    'en_SE': 'Sweden',
    'en_SG': 'Singapore',
    'en_SH': 'St. Helena',
    'en_SI': 'Slovenia',
    'en_SL': 'Sierra Leone',
    'en_SS': 'South Sudan',
    'en_SX': 'Sint Maarten',
    'en_SZ': 'Eswatini',
    'en_TC': 'Turks & Caicos Islands',
    'en_TK': 'Tokelau',
    'en_TO': 'Tonga',
    'en_TT': 'Trinidad & Tobago',
    'en_TV': 'Tuvalu',
    'en_TZ': 'Tanzania',
    'en_UG': 'Uganda',
    'en_UM': 'U.S. Outlying Islands',
    'en_US': 'United States',
    'en_US_POSIX': 'United States',
    'en_VC': 'St. Vincent & Grenadines',
    'en_VG': 'British Virgin Islands',
    'en_VI': 'U.S. Virgin Islands',
    'en_VU': 'Vanuatu',
    'en_WS': 'Samoa',
    'en_XA': '[Þšéûðö‐Åççéñţš one two]',
    'en_ZA': 'South Africa',
    'en_ZM': 'Zambia',
    'en_ZW': 'Zimbabwe',
    'eo_001': 'Mondo',
    'es_419': 'Latinoamérica',
    'es_AR': 'Argentina',
    'es_BO': 'Bolivia',
    'es_BR': 'Brasil',
    'es_BZ': 'Belice',
    'es_CL': 'Chile',
    'es_CO': 'Colombia',
    'es_CR': 'Costa Rica',
    'es_CU': 'Cuba',
    'es_DO': 'República Dominicana',
    'es_EA': 'Ceuta y Melilla',
    'es_EC': 'Ecuador',
    'es_ES': 'España',
    'es_GQ': 'Guinea Ecuatorial',
    'es_GT': 'Guatemala',
    'es_HN': 'Honduras',
    'es_IC': 'Canarias',
    'es_MX': 'México',
    'es_NI': 'Nicaragua',
    'es_PA': 'Panamá',
    'es_PE': 'Perú',
    'es_PH': 'Filipinas',
    'es_PR': 'Puerto Rico',
    'es_PY': 'Paraguay',
    'es_SV': 'El Salvador',
    'es_US': 'Estados Unidos',
    'es_UY': 'Uruguay',
    'es_VE': 'Venezuela',
    'et_EE': 'Eesti',
    'eu_ES': 'Espainia',
    'ewo_CM': 'Kamərún',
    'fa_AF': 'افغانستان',
    'fa_IR': 'ایران',
    'ff_Adlm_BF': '𞤄𞤵𞤪𞤳𞤭𞤲𞤢 𞤊𞤢𞤧𞤮𞥅',
    'ff_Adlm_CM': '𞤑𞤢𞤥𞤢𞤪𞤵𞥅𞤲',
    'ff_Adlm_GH': '𞤘𞤢𞤲𞤢',
    'ff_Adlm_GM': '𞤘𞤢𞤥𞤦𞤭𞤴𞤢',
    'ff_Adlm_GN': '𞤘𞤭𞤲𞤫',
    'ff_Adlm_GW': '𞤘𞤭𞤲𞤫-𞤄𞤭𞤧𞤢𞤱𞤮𞥅',
    'ff_Adlm_LR': '𞤂𞤢𞤦𞤭𞤪𞤭𞤴𞤢𞥄',
    'ff_Adlm_MR': '𞤃𞤮𞤪𞤼𞤢𞤲𞤭𞥅',
    'ff_Adlm_NE': '𞤐𞤭𞥅𞤶𞤫𞤪',
    'ff_Adlm_NG': '𞤐𞤢𞤶𞤫𞤪𞤭𞤴𞤢𞥄',
    'ff_Adlm_SL': '𞤅𞤢𞤪𞤢𞤤𞤮𞤲',
    'ff_Adlm_SN': '𞤅𞤫𞤲𞤫𞤺𞤢𞥄𞤤',
    'ff_Latn_BF': 'Burkibaa Faaso',
    'ff_Latn_CM': 'Kameruun',
    'ff_Latn_GH': 'Ganaa',
    'ff_Latn_GM': 'Gammbi',
    'ff_Latn_GN': 'Gine',
    'ff_Latn_GW': 'Gine-Bisaawo',
    'ff_Latn_LR': 'Liberiyaa',
    'ff_Latn_MR': 'Muritani',
    'ff_Latn_NE': 'Nijeer',
    'ff_Latn_NG': 'Nijeriyaa',
    'ff_Latn_SL': 'Seraa liyon',
    'ff_Latn_SN': 'Senegaal',
    'fi_FI': 'Suomi',
    'fil_PH': 'Pilipinas',
    'fo_DK': 'Danmark',
    'fo_FO': 'Føroyar',
    'fr_BE': 'Belgique',
    'fr_BF': 'Burkina Faso',
    'fr_BI': 'Burundi',
    'fr_BJ': 'Bénin',
    'fr_BL': 'Saint-Barthélemy',
    'fr_CA': 'Canada',
    'fr_CD': 'Congo-Kinshasa',
    'fr_CF': 'République centrafricaine',
    'fr_CG': 'Congo-Brazzaville',
    'fr_CH': 'Suisse',
    'fr_CI': 'Côte d’Ivoire',
    'fr_CM': 'Cameroun',
    'fr_DJ': 'Djibouti',
    'fr_DZ': 'Algérie',
    'fr_FR': 'France',
    'fr_GA': 'Gabon',
    'fr_GF': 'Guyane française',
    'fr_GN': 'Guinée',
    'fr_GP': 'Guadeloupe',
    'fr_GQ': 'Guinée équatoriale',
    'fr_HT': 'Haïti',
    'fr_KM': 'Comores',
    'fr_LU': 'Luxembourg',
    'fr_MA': 'Maroc',
    'fr_MC': 'Monaco',
    'fr_MF': 'Saint-Martin',
    'fr_MG': 'Madagascar',
    'fr_ML': 'Mali',
    'fr_MQ': 'Martinique',
    'fr_MR': 'Mauritanie',
    'fr_MU': 'Maurice',
    'fr_NC': 'Nouvelle-Calédonie',
    'fr_NE': 'Niger',
    'fr_PF': 'Polynésie française',
    'fr_PM': 'Saint-Pierre-et-Miquelon',
    'fr_RE': 'La Réunion',
    'fr_RW': 'Rwanda',
    'fr_SC': 'Seychelles',
    'fr_SN': 'Sénégal',
    'fr_SY': 'Syrie',
    'fr_TD': 'Tchad',
    'fr_TG': 'Togo',
    'fr_TN': 'Tunisie',
    'fr_VU': 'Vanuatu',
    'fr_WF': 'Wallis-et-Futuna',
    'fr_YT': 'Mayotte',
    'fur_IT': 'Italie',
    'fy_NL': 'Nederlân',
    'ga_GB': 'an Ríocht Aontaithe',
    'ga_IE': 'Éire',
    'gd_GB': 'An Rìoghachd Aonaichte',
    'gl_ES': 'España',
    'gsw_CH': 'Schwiiz',
    'gsw_FR': 'Frankriich',
    'gsw_LI': 'Liächteschtäi',
    'gu_IN': 'ભારત',
    'guz_KE': 'Kenya',
    'gv_IM': 'Ellan Vannin',
    'ha_GH': 'Gana',
    'ha_NE': 'Nijar',
    'ha_NG': 'Najeriya',
    'haw_US': 'ʻAmelika Hui Pū ʻIa',
    'he_IL': 'ישראל',
    'hi_IN': 'भारत',
    'hr_BA': 'Bosna i Hercegovina',
    'hr_HR': 'Hrvatska',
    'hsb_DE': 'Němska',
    'hu_HU': 'Magyarország',
    'hy_AM': 'Հայաստան',
    'ia_001': 'Mundo',
    'id_ID': 'Indonesia',
    'ig_NG': 'Naịjịrịa',
    'ii_CN': 'ꍏꇩ',
    'is_IS': 'Ísland',
    'it_CH': 'Svizzera',
    'it_IT': 'Italia',
    'it_SM': 'San Marino',
    'it_VA': 'Città del Vaticano',
    'ja_JP': '日本',
    'jgo_CM': 'Kamɛlûn',
    'jmc_TZ': 'Tanzania',
    'jv_ID': 'Indonésia',
    'ka_GE': 'საქართველო',
    'kab_DZ': 'Lezzayer',
    'kam_KE': 'Kenya',
    'kde_TZ': 'Tanzania',
    'kea_CV': 'Kabu Verdi',
    'khq_ML': 'Maali',
    'ki_KE': 'Kenya',
    'kk_KZ': 'Қазақстан',
    'kkj_CM': 'Kamɛrun',
    'kl_GL': 'Kalaallit Nunaat',
    'kln_KE': 'Emetab Kenya',
    'km_KH': 'កម្ពុជា',
    'kn_IN': 'ಭಾರತ',
    'ko_KP': '조선민주주의인민공화국',
    'ko_KR': '대한민국',
    'kok_IN': 'भारत',
    'ks_Arab_IN': 'ہِندوستان',
    'ksb_TZ': 'Tanzania',
    'ksf_CM': 'kamɛrún',
    'ksh_DE': 'Doütschland',
    'ku_TR': 'Tirkiye',
    'kw_GB': 'Rywvaneth Unys',
    'ky_KG': 'Кыргызстан',
    'lag_TZ': 'Taansanía',
    'lb_LU': 'Lëtzebuerg',
    'lg_UG': 'Yuganda',
    'lkt_US': 'Mílahaŋska Tȟamákȟočhe',
    'ln_AO': 'Angóla',
    'ln_CD': 'Republíki ya Kongó Demokratíki',
    'ln_CF': 'Repibiki ya Afríka ya Káti',
    'ln_CG': 'Kongo',
    'lo_LA': 'ລາວ',
    'lrc_IQ': 'Iraq',
    'lrc_IR': 'Iran',
    'lt_LT': 'Lietuva',
    'lu_CD': 'Ditunga wa Kongu',
    'luo_KE': 'Kenya',
    'luy_KE': 'Kenya',
    'lv_LV': 'Latvija',
    'mai_IN': 'भारत',
    'mas_KE': 'Kenya',
    'mas_TZ': 'Tansania',
    'mer_KE': 'Kenya',
    'mfe_MU': 'Moris',
    'mg_MG': 'Madagasikara',
    'mgh_MZ': 'Umozambiki',
    'mgo_CM': 'Kamalun',
    'mi_NZ': 'Aotearoa',
    'mk_MK': 'Северна Македонија',
    'ml_IN': 'ഇന്ത്യ',
    'mn_MN': 'Монгол',
    'mni_Beng_IN': 'ইন্দিয়া',
    'mr_IN': 'भारत',
    'ms_BN': 'Brunei',
    'ms_ID': 'Indonesia',
    'ms_MY': 'Malaysia',
    'ms_SG': 'Singapura',
    'mt_MT': 'Malta',
    'mua_CM': 'kameruŋ',
    'my_MM': 'မြန်မာ',
    'mzn_IR': 'ایران',
    'naq_NA': 'Namibiab',
    'nb_NO': 'Norge',
    'nb_SJ': 'Svalbard og Jan Mayen',
    'nd_ZW': 'Zimbabwe',
    'nds_NL': 'Netherlands',
    'ne_IN': 'भारत',
    'ne_NP': 'नेपाल',
    'nl_AW': 'Aruba',
    'nl_BE': 'België',
    'nl_BQ': 'Caribisch Nederland',
    'nl_CW': 'Curaçao',
    'nl_NL': 'Nederland',
    'nl_SR': 'Suriname',
    'nl_SX': 'Sint-Maarten',
    'nmg_CM': 'Kamerun',
    'nn_NO': 'Noreg',
    'nnh_CM': 'Kàmalûm',
    'no_NO': 'Norge',
    'nus_SS': 'South Sudan',
    'nyn_UG': 'Uganda',
    'om_ET': 'Itoophiyaa',
    'om_KE': 'Keeniyaa',
    'or_IN': 'ଭାରତ',
    'os_GE': 'Гуырдзыстон',
    'os_RU': 'Уӕрӕсе',
    'pa_Arab_PK': 'پاکستان',
    'pa_Guru_IN': 'ਭਾਰਤ',
    'pcm_NG': 'Naijíria',
    'pl_PL': 'Polska',
    'ps_AF': 'افغانستان',
    'ps_PK': 'پاکستان',
    'pt_AO': 'Angola',
    'pt_BR': 'Brasil',
    'pt_CH': 'Suíça',
    'pt_CV': 'Cabo Verde',
    'pt_GQ': 'Guiné Equatorial',
    'pt_GW': 'Guiné-Bissau',
    'pt_LU': 'Luxemburgo',
    'pt_MO': 'Macau',
    'pt_MZ': 'Moçambique',
    'pt_PT': 'Portugal',
    'pt_ST': 'São Tomé e Príncipe',
    'pt_TL': 'Timor-Leste',
    'qu_BO': 'Bolivia',
    'qu_EC': 'Ecuador',
    'qu_PE': 'Perú',
    'rm_CH': 'Svizra',
    'rn_BI': 'Uburundi',
    'ro_MD': 'Republica Moldova',
    'ro_RO': 'România',
    'rof_TZ': 'Tanzania',
    'ru_BY': 'Беларусь',
    'ru_KG': 'Киргизия',
    'ru_KZ': 'Казахстан',
    'ru_MD': 'Молдова',
    'ru_RU': 'Россия',
    'ru_UA': 'Украина',
    'rw_RW': 'U Rwanda',
    'rwk_TZ': 'Tanzania',
    'sa_IN': 'भारतः',
    'sah_RU': 'Арассыыйа',
    'saq_KE': 'Kenya',
    'sat_Olck_IN': 'ᱤᱱᱰᱤᱭᱟ',
    'sbp_TZ': 'Tansaniya',
    'sd_Arab_PK': 'پاڪستان',
    'sd_Deva_IN': 'भारत',
    'se_FI': 'Suopma',
    'se_NO': 'Norga',
    'se_SE': 'Ruoŧŧa',
    'seh_MZ': 'Moçambique',
    'ses_ML': 'Maali',
    'sg_CF': 'Ködörösêse tî Bêafrîka',
    'shi_Latn_MA': 'lmɣrib',
    'shi_Tfng_MA': 'ⵍⵎⵖⵔⵉⴱ',
    'si_LK': 'ශ්‍රී ලංකාව',
    'sk_SK': 'Slovensko',
    'sl_SI': 'Slovenija',
    'smn_FI': 'Suomâ',
    'sn_ZW': 'Zimbabwe',
    'so_DJ': 'Jabuuti',
    'so_ET': 'Itoobiya',
    'so_KE': 'Kenya',
    'so_SO': 'Soomaaliya',
    'sq_AL': 'Shqipëri',
    'sq_MK': 'Maqedonia e Veriut',
    'sq_XK': 'Kosovë',
    'sr_Cyrl_BA': 'Босна и Херцеговина',
    'sr_Cyrl_ME': 'Црна Гора',
    'sr_Cyrl_RS': 'Србија',
    'sr_Cyrl_XK': 'Косово',
    'sr_Latn_BA': 'Bosna i Hercegovina',
    'sr_Latn_ME': 'Crna Gora',
    'sr_Latn_RS': 'Srbija',
    'sr_Latn_XK': 'Kosovo',
    'su_Latn_ID': 'Indonesia',
    'sv_AX': 'Åland',
    'sv_FI': 'Finland',
    'sv_SE': 'Sverige',
    'sw_CD': 'Jamhuri ya Kidemokrasia ya Kongo',
    'sw_KE': 'Kenya',
    'sw_TZ': 'Tanzania',
    'sw_UG': 'Uganda',
    'ta_IN': 'இந்தியா',
    'ta_LK': 'இலங்கை',
    'ta_MY': 'மலேசியா',
    'ta_SG': 'சிங்கப்பூர்',
    'te_IN': 'భారతదేశం',
    'teo_KE': 'Kenia',
    'teo_UG': 'Uganda',
    'tg_TJ': 'Тоҷикистон',
    'th_TH': 'ไทย',
    'ti_ER': 'ኤርትራ',
    'ti_ET': 'ኢትዮጵያ',
    'tk_TM': 'Türkmenistan',
    'to_TO': 'Tonga',
    'tr_CY': 'Kıbrıs',
    'tr_TR': 'Türkiye',
    'tt_RU': 'Россия',
    'twq_NE': 'Nižer',
    'tzm_MA': 'Meṛṛuk',
    'ug_CN': 'جۇڭگو',
    'uk_UA': 'Україна',
    'ur_IN': 'بھارت',
    'ur_PK': 'پاکستان',
    'uz_Arab_AF': 'افغانستان',
    'uz_Cyrl_UZ': 'Ўзбекистон',
    'uz_Latn_UZ': 'Oʻzbekiston',
    'vai_Latn_LR': 'Laibhiya',
    'vai_Vaii_LR': 'ꕞꔤꔫꕩ',
    'vi_VN': 'Việt Nam',
    'vun_TZ': 'Tanzania',
    'wae_CH': 'Schwiz',
    'wo_SN': 'Senegaal',
    'xh_ZA': 'eMzantsi Afrika',
    'xog_UG': 'Yuganda',
    'yav_CM': 'Kemelún',
    'yi_001': 'וועלט',
    'yo_BJ': 'Bɛ̀nɛ̀',
    'yo_NG': 'Nàìjíríà',
    'yue_Hans_CN': '中华人民共和国',
    'yue_Hant_HK': '香港',
    'zgh_MA': 'ⵍⵎⵖⵔⵉⴱ',
    'zh_CN': '中国',
    'zh_HK': '香港',
    'zh_Hans_CN': '中国',
    'zh_Hans_HK': '香港',
    'zh_Hans_MO': '澳门',
    'zh_Hans_SG': '新加坡',
    'zh_Hant_HK': '香港',
    'zh_Hant_MO': '澳門',
    'zh_Hant_TW': '台灣',
    'zh_TW': '台灣',
    'zu_ZA': 'iNingizimu Afrika'
  },
  'LANGUAGE': {
    'aa': 'Afar',
    'ab': 'Abkhazian',
    'ace': 'Achinese',
    'ach': 'Acoli',
    'ada': 'Adangme',
    'ady': 'Adyghe',
    'ae': 'Avestan',
    'af': 'Afrikaans',
    'afh': 'Afrihili',
    'agq': 'Aghem',
    'ain': 'Ainu',
    'ak': 'Akan',
    'akk': 'Akkadian',
    'ale': 'Aleut',
    'alt': 'Southern Altai',
    'am': 'አማርኛ',
    'an': 'Aragonese',
    'ang': 'Old English',
    'anp': 'Angika',
    'ar': 'العربية',
    'ar_001': 'العربية (العالم)',
    'arc': 'Aramaic',
    'arn': 'Mapuche',
    'arp': 'Arapaho',
    'ars': 'اللهجة النجدية',
    'arw': 'Arawak',
    'as': 'অসমীয়া',
    'asa': 'Kipare',
    'ast': 'asturianu',
    'av': 'Avaric',
    'awa': 'Awadhi',
    'ay': 'Aymara',
    'az': 'azərbaycan',
    'az_Cyrl': 'азәрбајҹан (Кирил)',
    'az_Latn': 'azərbaycan (latın)',
    'ba': 'Bashkir',
    'bal': 'Baluchi',
    'ban': 'Balinese',
    'bas': 'Ɓàsàa',
    'bax': 'Bamun',
    'bbj': 'Ghomala',
    'be': 'беларуская',
    'bej': 'Beja',
    'bem': 'Ichibemba',
    'bez': 'Hibena',
    'bfd': 'Bafut',
    'bg': 'български',
    'bho': 'Bhojpuri',
    'bi': 'Bislama',
    'bik': 'Bikol',
    'bin': 'Bini',
    'bkm': 'Kom',
    'bla': 'Siksika',
    'bm': 'bamanakan',
    'bn': 'বাংলা',
    'bo': 'བོད་སྐད་',
    'br': 'brezhoneg',
    'bra': 'Braj',
    'brx': 'बड़ो',
    'bs': 'bosanski',
    'bs_Cyrl': 'босански (ћирилица)',
    'bs_Latn': 'bosanski (latinica)',
    'bss': 'Akoose',
    'bua': 'Buriat',
    'bug': 'Buginese',
    'bum': 'Bulu',
    'byn': 'Blin',
    'byv': 'Medumba',
    'ca': 'català',
    'cad': 'Caddo',
    'car': 'Carib',
    'cay': 'Cayuga',
    'cch': 'Atsam',
    'ccp': '𑄌𑄋𑄴𑄟𑄳𑄦',
    'ce': 'нохчийн',
    'ceb': 'Binisaya',
    'cgg': 'Rukiga',
    'ch': 'Chamorro',
    'chb': 'Chibcha',
    'chg': 'Chagatai',
    'chk': 'Chuukese',
    'chm': 'Mari',
    'chn': 'Chinook Jargon',
    'cho': 'Choctaw',
    'chp': 'Chipewyan',
    'chr': 'ᏣᎳᎩ',
    'chy': 'Cheyenne',
    'ckb': 'کوردیی ناوەندی',
    'ckb_Arab': 'کوردیی ناوەندی (عەرەبی)',
    'co': 'Corsican',
    'cop': 'Coptic',
    'cr': 'Cree',
    'crh': 'Crimean Turkish',
    'cs': 'čeština',
    'csb': 'Kashubian',
    'cu': 'Church Slavic',
    'cv': 'Chuvash',
    'cy': 'Cymraeg',
    'da': 'dansk',
    'dak': 'Dakota',
    'dar': 'Dargwa',
    'dav': 'Kitaita',
    'de': 'Deutsch',
    'de_AT': 'Deutsch (Österreich)',
    'de_CH': 'Deutsch (Schweiz)',
    'del': 'Delaware',
    'den': 'Slave',
    'dgr': 'Dogrib',
    'din': 'Dinka',
    'dje': 'Zarmaciine',
    'doi': 'डोगरी',
    'dsb': 'dolnoserbšćina',
    'dua': 'duálá',
    'dum': 'Middle Dutch',
    'dv': 'Divehi',
    'dyo': 'joola',
    'dyu': 'Dyula',
    'dz': 'རྫོང་ཁ',
    'dzg': 'Dazaga',
    'ebu': 'Kĩembu',
    'ee': 'Eʋegbe',
    'efi': 'Efik',
    'egy': 'Ancient Egyptian',
    'eka': 'Ekajuk',
    'el': 'Ελληνικά',
    'elx': 'Elamite',
    'en': 'English',
    'en_AU': 'English (Australia)',
    'en_CA': 'English (Canada)',
    'en_GB': 'English (United Kingdom)',
    'en_US': 'English (United States)',
    'enm': 'Middle English',
    'eo': 'esperanto',
    'es': 'español',
    'es_419': 'español (Latinoamérica)',
    'es_ES': 'español (España)',
    'es_MX': 'español (México)',
    'et': 'eesti',
    'eu': 'euskara',
    'ewo': 'ewondo',
    'fa': 'فارسی',
    'fa_AF': 'فارسی (افغانستان)',
    'fan': 'Fang',
    'fat': 'Fanti',
    'ff': 'Pulaar',
    'ff_Adlm': '𞤆𞤵𞤤𞤢𞤪 (𞤀𞤁𞤂𞤢𞤃)',
    'ff_Latn': 'Fulah (Latin)',
    'fi': 'suomi',
    'fil': 'Filipino',
    'fj': 'Fijian',
    'fo': 'føroyskt',
    'fon': 'Fon',
    'fr': 'français',
    'fr_CA': 'français (Canada)',
    'fr_CH': 'français (Suisse)',
    'frm': 'Middle French',
    'fro': 'Old French',
    'frr': 'Northern Frisian',
    'frs': 'Eastern Frisian',
    'fur': 'furlan',
    'fy': 'Frysk',
    'ga': 'Gaeilge',
    'gaa': 'Ga',
    'gay': 'Gayo',
    'gba': 'Gbaya',
    'gd': 'Gàidhlig',
    'gez': 'Geez',
    'gil': 'Gilbertese',
    'gl': 'galego',
    'gmh': 'Middle High German',
    'gn': 'Guarani',
    'goh': 'Old High German',
    'gon': 'Gondi',
    'gor': 'Gorontalo',
    'got': 'Gothic',
    'grb': 'Grebo',
    'grc': 'Ancient Greek',
    'gsw': 'Schwiizertüütsch',
    'gu': 'ગુજરાતી',
    'guz': 'Ekegusii',
    'gv': 'Gaelg',
    'gwi': 'Gwichʼin',
    'ha': 'Hausa',
    'hai': 'Haida',
    'haw': 'ʻŌlelo Hawaiʻi',
    'he': 'עברית',
    'hi': 'हिन्दी',
    'hil': 'Hiligaynon',
    'hit': 'Hittite',
    'hmn': 'Hmong',
    'ho': 'Hiri Motu',
    'hr': 'hrvatski',
    'hsb': 'hornjoserbšćina',
    'ht': 'Haitian Creole',
    'hu': 'magyar',
    'hup': 'Hupa',
    'hy': 'հայերեն',
    'hz': 'Herero',
    'ia': 'interlingua',
    'iba': 'Iban',
    'ibb': 'Ibibio',
    'id': 'Indonesia',
    'ie': 'Interlingue',
    'ig': 'Igbo',
    'ii': 'ꆈꌠꉙ',
    'ik': 'Inupiaq',
    'ilo': 'Iloko',
    'in': 'Indonesia',
    'inh': 'Ingush',
    'io': 'Ido',
    'is': 'íslenska',
    'it': 'italiano',
    'iu': 'Inuktitut',
    'iw': 'עברית',
    'ja': '日本語',
    'jbo': 'Lojban',
    'jgo': 'Ndaꞌa',
    'jmc': 'Kimachame',
    'jpr': 'Judeo-Persian',
    'jrb': 'Judeo-Arabic',
    'jv': 'Jawa',
    'ka': 'ქართული',
    'kaa': 'Kara-Kalpak',
    'kab': 'Taqbaylit',
    'kac': 'Kachin',
    'kaj': 'Jju',
    'kam': 'Kikamba',
    'kaw': 'Kawi',
    'kbd': 'Kabardian',
    'kbl': 'Kanembu',
    'kcg': 'Tyap',
    'kde': 'Chimakonde',
    'kea': 'kabuverdianu',
    'kfo': 'Koro',
    'kg': 'Kongo',
    'kha': 'Khasi',
    'kho': 'Khotanese',
    'khq': 'Koyra ciini',
    'ki': 'Gikuyu',
    'kj': 'Kuanyama',
    'kk': 'қазақ тілі',
    'kkj': 'kakɔ',
    'kl': 'kalaallisut',
    'kln': 'Kalenjin',
    'km': 'ខ្មែរ',
    'kmb': 'Kimbundu',
    'kn': 'ಕನ್ನಡ',
    'ko': '한국어',
    'kok': 'कोंकणी',
    'kos': 'Kosraean',
    'kpe': 'Kpelle',
    'kr': 'Kanuri',
    'krc': 'Karachay-Balkar',
    'krl': 'Karelian',
    'kru': 'Kurukh',
    'ks': 'کٲشُر',
    'ks_Arab': 'کٲشُر (اَربی)',
    'ksb': 'Kishambaa',
    'ksf': 'rikpa',
    'ksh': 'Kölsch',
    'ku': 'kurdî',
    'kum': 'Kumyk',
    'kut': 'Kutenai',
    'kv': 'Komi',
    'kw': 'kernewek',
    'ky': 'кыргызча',
    'la': 'Latin',
    'lad': 'Ladino',
    'lag': 'Kɨlaangi',
    'lah': 'Lahnda',
    'lam': 'Lamba',
    'lb': 'Lëtzebuergesch',
    'lez': 'Lezghian',
    'lg': 'Luganda',
    'li': 'Limburgish',
    'lkt': 'Lakȟólʼiyapi',
    'ln': 'lingála',
    'lo': 'ລາວ',
    'lol': 'Mongo',
    'loz': 'Lozi',
    'lrc': 'لۊری شومالی',
    'lt': 'lietuvių',
    'lu': 'Tshiluba',
    'lua': 'Luba-Lulua',
    'lui': 'Luiseno',
    'lun': 'Lunda',
    'luo': 'Dholuo',
    'lus': 'Mizo',
    'luy': 'Luluhia',
    'lv': 'latviešu',
    'mad': 'Madurese',
    'maf': 'Mafa',
    'mag': 'Magahi',
    'mai': 'मैथिली',
    'mak': 'Makasar',
    'man': 'Mandingo',
    'mas': 'Maa',
    'mde': 'Maba',
    'mdf': 'Moksha',
    'mdr': 'Mandar',
    'men': 'Mende',
    'mer': 'Kĩmĩrũ',
    'mfe': 'kreol morisien',
    'mg': 'Malagasy',
    'mga': 'Middle Irish',
    'mgh': 'Makua',
    'mgo': 'metaʼ',
    'mh': 'Marshallese',
    'mi': 'te reo Māori',
    'mic': 'Mi\'kmaq',
    'min': 'Minangkabau',
    'mk': 'македонски',
    'ml': 'മലയാളം',
    'mn': 'монгол',
    'mnc': 'Manchu',
    'mni': 'মৈতৈলোন্',
    'mni_Beng': 'মৈতৈলোন্ (বাংলা)',
    'moh': 'Mohawk',
    'mos': 'Mossi',
    'mr': 'मराठी',
    'ms': 'Melayu',
    'mt': 'Malti',
    'mua': 'MUNDAŊ',
    'mul': 'Multiple languages',
    'mus': 'Muscogee',
    'mwl': 'Mirandese',
    'mwr': 'Marwari',
    'my': 'မြန်မာ',
    'mye': 'Myene',
    'myv': 'Erzya',
    'mzn': 'مازرونی',
    'na': 'Nauru',
    'nap': 'Neapolitan',
    'naq': 'Khoekhoegowab',
    'nb': 'norsk bokmål',
    'nd': 'isiNdebele',
    'nds': 'Low German',
    'nds_NL': 'Low German (Netherlands)',
    'ne': 'नेपाली',
    'new': 'Newari',
    'ng': 'Ndonga',
    'nia': 'Nias',
    'niu': 'Niuean',
    'nl': 'Nederlands',
    'nl_BE': 'Nederlands (België)',
    'nmg': 'Kwasio',
    'nn': 'norsk nynorsk',
    'nnh': 'Shwóŋò ngiembɔɔn',
    'no': 'norsk',
    'nog': 'Nogai',
    'non': 'Old Norse',
    'nqo': 'N’Ko',
    'nr': 'South Ndebele',
    'nso': 'Northern Sotho',
    'nus': 'Thok Nath',
    'nv': 'Navajo',
    'nwc': 'Classical Newari',
    'ny': 'Nyanja',
    'nym': 'Nyamwezi',
    'nyn': 'Runyankore',
    'nyo': 'Nyoro',
    'nzi': 'Nzima',
    'oc': 'Occitan',
    'oj': 'Ojibwa',
    'om': 'Oromoo',
    'or': 'ଓଡ଼ିଆ',
    'os': 'ирон',
    'osa': 'Osage',
    'ota': 'Ottoman Turkish',
    'pa': 'ਪੰਜਾਬੀ',
    'pa_Arab': 'پنجابی (عربی)',
    'pa_Guru': 'ਪੰਜਾਬੀ (ਗੁਰਮੁਖੀ)',
    'pag': 'Pangasinan',
    'pal': 'Pahlavi',
    'pam': 'Pampanga',
    'pap': 'Papiamento',
    'pau': 'Palauan',
    'pcm': 'Naijíriá Píjin',
    'peo': 'Old Persian',
    'phn': 'Phoenician',
    'pi': 'Pali',
    'pl': 'polski',
    'pon': 'Pohnpeian',
    'pro': 'Old Provençal',
    'ps': 'پښتو',
    'pt': 'português',
    'pt_BR': 'português (Brasil)',
    'pt_PT': 'português (Portugal)',
    'qu': 'Runasimi',
    'raj': 'Rajasthani',
    'rap': 'Rapanui',
    'rar': 'Rarotongan',
    'rm': 'rumantsch',
    'rn': 'Ikirundi',
    'ro': 'română',
    'ro_MD': 'română (Republica Moldova)',
    'rof': 'Kihorombo',
    'rom': 'Romany',
    'ru': 'русский',
    'rup': 'Aromanian',
    'rw': 'Kinyarwanda',
    'rwk': 'Kiruwa',
    'sa': 'संस्कृत भाषा',
    'sad': 'Sandawe',
    'sah': 'саха тыла',
    'sam': 'Samaritan Aramaic',
    'saq': 'Kisampur',
    'sas': 'Sasak',
    'sat': 'ᱥᱟᱱᱛᱟᱲᱤ',
    'sat_Olck': 'ᱥᱟᱱᱛᱟᱲᱤ (ᱚᱞ ᱪᱤᱠᱤ)',
    'sba': 'Ngambay',
    'sbp': 'Ishisangu',
    'sc': 'Sardinian',
    'scn': 'Sicilian',
    'sco': 'Scots',
    'sd': 'سنڌي',
    'sd_Arab': 'سنڌي (عربي)',
    'sd_Deva': 'सिन्धी (देवनागिरी)',
    'se': 'davvisámegiella',
    'see': 'Seneca',
    'seh': 'sena',
    'sel': 'Selkup',
    'ses': 'Koyraboro senni',
    'sg': 'Sängö',
    'sga': 'Old Irish',
    'sh': 'srpskohrvatski',
    'shi': 'ⵜⴰⵛⵍⵃⵉⵜ',
    'shi_Latn': 'Tachelhit (Latin)',
    'shi_Tfng': 'Tachelhit (Tifinagh)',
    'shn': 'Shan',
    'shu': 'Chadian Arabic',
    'si': 'සිංහල',
    'sid': 'Sidamo',
    'sk': 'slovenčina',
    'sl': 'slovenščina',
    'sm': 'Samoan',
    'sma': 'Southern Sami',
    'smj': 'Lule Sami',
    'smn': 'anarâškielâ',
    'sms': 'Skolt Sami',
    'sn': 'chiShona',
    'snk': 'Soninke',
    'so': 'Soomaali',
    'sog': 'Sogdien',
    'sq': 'shqip',
    'sr': 'српски',
    'sr_Cyrl': 'српски (ћирилица)',
    'sr_Latn': 'srpski (latinica)',
    'srn': 'Sranan Tongo',
    'srr': 'Serer',
    'ss': 'Swati',
    'ssy': 'Saho',
    'st': 'Southern Sotho',
    'su': 'Basa Sunda',
    'su_Latn': 'Basa Sunda (Latin)',
    'suk': 'Sukuma',
    'sus': 'Susu',
    'sux': 'Sumerian',
    'sv': 'svenska',
    'sw': 'Kiswahili',
    'sw_CD': 'Kiswahili (Jamhuri ya Kidemokrasia ya Kongo)',
    'swb': 'Comorian',
    'syc': 'Classical Syriac',
    'syr': 'Syriac',
    'ta': 'தமிழ்',
    'te': 'తెలుగు',
    'tem': 'Timne',
    'teo': 'Kiteso',
    'ter': 'Tereno',
    'tet': 'Tetum',
    'tg': 'тоҷикӣ',
    'th': 'ไทย',
    'ti': 'ትግር',
    'tig': 'Tigre',
    'tiv': 'Tiv',
    'tk': 'türkmen dili',
    'tkl': 'Tokelau',
    'tl': 'Tagalog',
    'tlh': 'Klingon',
    'tli': 'Tlingit',
    'tmh': 'Tamashek',
    'tn': 'Tswana',
    'to': 'lea fakatonga',
    'tog': 'Nyasa Tonga',
    'tpi': 'Tok Pisin',
    'tr': 'Türkçe',
    'trv': 'Taroko',
    'ts': 'Tsonga',
    'tsi': 'Tsimshian',
    'tt': 'татар',
    'tum': 'Tumbuka',
    'tvl': 'Tuvalu',
    'tw': 'Twi',
    'twq': 'Tasawaq senni',
    'ty': 'Tahitian',
    'tyv': 'Tuvinian',
    'tzm': 'Tamaziɣt n laṭlaṣ',
    'udm': 'Udmurt',
    'ug': 'ئۇيغۇرچە',
    'uga': 'Ugaritic',
    'uk': 'українська',
    'umb': 'Umbundu',
    'ur': 'اردو',
    'uz': 'o‘zbek',
    'uz_Arab': 'اوزبیک (عربی)',
    'uz_Cyrl': 'ўзбекча (Кирил)',
    'uz_Latn': 'o‘zbek (lotin)',
    'vai': 'ꕙꔤ',
    'vai_Latn': 'Vai (Latin)',
    'vai_Vaii': 'Vai (Vai)',
    've': 'Venda',
    'vi': 'Tiếng Việt',
    'vo': 'Volapük',
    'vot': 'Votic',
    'vun': 'Kyivunjo',
    'wa': 'Walloon',
    'wae': 'Walser',
    'wal': 'Wolaytta',
    'war': 'Waray',
    'was': 'Washo',
    'wo': 'Wolof',
    'xal': 'Kalmyk',
    'xh': 'isiXhosa',
    'xog': 'Olusoga',
    'yao': 'Yao',
    'yap': 'Yapese',
    'yav': 'nuasue',
    'ybb': 'Yemba',
    'yi': 'ייִדיש',
    'yo': 'Èdè Yorùbá',
    'yue': '粵語',
    'yue_Hans': '粤语 (简体)',
    'yue_Hant': '粵語 (繁體)',
    'za': 'Zhuang',
    'zap': 'Zapotec',
    'zbl': 'Blissymbols',
    'zen': 'Zenaga',
    'zgh': 'ⵜⴰⵎⴰⵣⵉⵖⵜ',
    'zh': '中文',
    'zh_Hans': '中文（简体）',
    'zh_Hant': '中文（繁體）',
    'zh_TW': '中文（台灣）',
    'zu': 'isiZulu',
    'zun': 'Zuni',
    'zxx': 'No linguistic content',
    'zza': 'Zaza'
  }
};
