"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var querystring_1 = require("querystring");
var axios_1 = __importDefault(require("axios"));
var sM_1 = __importDefault(require("./sM"));
var languages_1 = require("./languages");
function token(text) {
    return new Promise(function (resolve) {
        resolve({ name: "tk", value: sM_1.default(text) });
    });
}
var CORSService = "";
// setup your own cors-anywhere server
exports.setCORS = function (CORSURL) {
    CORSService = CORSURL;
    return translate;
};
// function translate(text: string, to: string, from?: string) {
function translate(text, opts_) {
    if (opts_ === void 0) { opts_ = {}; }
    var opts = {
        from: opts_.from || "auto",
        to: opts_.to || "en",
        raw: opts_.raw || false
    };
    var e = null;
    [opts.from, opts.to].forEach(function (lang) {
        if (lang && !languages_1.isSupported(lang)) {
            e = new Error();
            e.message = "The language '" + lang + "' is not supported";
        }
    });
    if (e) {
        return new Promise(function (resolve, reject) {
            reject(e);
        });
    }
    return token(text)
        .then(function (token) {
        var url = "https://translate.google.com/translate_a/single";
        var data = {
            client: "gtx",
            sl: languages_1.getCode(opts.from),
            tl: languages_1.getCode(opts.to),
            hl: languages_1.getCode(opts.to),
            dt: ["at", "bd", "ex", "ld", "md", "qca", "rw", "rm", "ss", "t"],
            ie: "UTF-8",
            oe: "UTF-8",
            otf: 1,
            ssel: 0,
            tsel: 0,
            kc: 7,
            q: text
        };
        data[token.name] = token.value;
        return url + "?" + querystring_1.stringify(data);
    })
        .then(function (url) {
        return axios_1.default
            .get(CORSService + url)
            .then(function (res_) {
            var res = {
                body: JSON.stringify(res_.data)
            };
            var result = {
                text: "",
                from: {
                    language: {
                        didYouMean: false,
                        iso: ""
                    },
                    text: {
                        autoCorrected: false,
                        value: "",
                        didYouMean: false
                    }
                },
                raw: ""
            };
            if (opts.raw) {
                result.raw = res.body;
            }
            var body = JSON.parse(res.body);
            body[0].forEach(function (obj) {
                if (obj[0]) {
                    result.text += obj[0];
                }
            });
            if (body[2] === body[8][0][0]) {
                result.from.language.iso = body[2];
            }
            else {
                result.from.language.didYouMean = true;
                result.from.language.iso = body[8][0][0];
            }
            if (body[7] && body[7][0]) {
                var str = body[7][0];
                str = str.replace(/<b><i>/g, "[");
                str = str.replace(/<\/i><\/b>/g, "]");
                result.from.text.value = str;
                if (body[7][5] === true) {
                    result.from.text.autoCorrected = true;
                }
                else {
                    result.from.text.didYouMean = true;
                }
            }
            return result;
        })
            .catch(function (err) {
            var e = new Error();
            if (err.statusCode !== undefined && err.statusCode !== 200) {
                e.message = "BAD_REQUEST";
            }
            else {
                e.message = "BAD_NETWORK";
            }
            throw e;
        });
    });
}
exports.translate = translate;
exports.default = translate;
