/**
 * @license
 * Copyright 2014-2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import '../google-chart.js';
import { customElement, property } from '@polymer/decorators';
import { PolymerElement, html } from '@polymer/polymer';
import { ready } from './helpers.js';
const assert = chai.assert;
suite('<google-chart> use in Polymer element', () => {
    let element;
    setup(async () => {
        element = new GoogleChartTestElement();
        document.body.append(element);
        await ready(element);
    });
    teardown(() => {
        element === null || element === void 0 ? void 0 : element.remove();
    });
    test('passes properties', () => {
        const chartDiv = element.$['chart'].shadowRoot.getElementById('chartdiv');
        assert.include(chartDiv.innerText, 'Value');
        assert.include(chartDiv.innerText, 'Something');
    });
    test('deep options change via binding', async () => {
        element.set('options.title', 'New title');
        const chartDiv = element.$['chart'].shadowRoot.getElementById('chartdiv');
        await ready(element);
        assert.include(chartDiv.innerText, 'New title');
    });
    test('two-way binding', async () => {
        // chart-selection-changed fires because the propery has {notify: true}.
        const chartSelectionChanged = new Promise(resolve => {
            element.addEventListener('chart-selection-changed', resolve, { once: true });
        });
        // Get chartWrapper and simulate user selection:
        // https://developers.google.com/chart/interactive/docs/dev/events#firing-an-event
        const chartWrapper = element.$['chart']['chartWrapper'];
        chartWrapper.getChart().setSelection([{ row: 1 }]);
        google.visualization.events.trigger(chartWrapper.getChart(), 'select', {});
        await chartSelectionChanged;
        assert.sameDeepMembers(element.chartSelection, [{ row: 1, column: null }]);
    });
});
let GoogleChartTestElement = class GoogleChartTestElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.options = {};
        this.data = [
            ['Data', 'Value'],
            ['Something', 1],
            ['Thing', 2],
            ['Entry', 3],
        ];
    }
    static get template() {
        return html `
      <google-chart
          id="chart"
          options="[[options]]"
          data="[[data]]"
          selection="{{chartSelection::google-chart-select}}">
      </google-chart>
    `;
    }
};
__decorate([
    property({ type: Object })
], GoogleChartTestElement.prototype, "options", void 0);
__decorate([
    property({ type: Object })
], GoogleChartTestElement.prototype, "data", void 0);
__decorate([
    property({ type: Array, notify: true })
], GoogleChartTestElement.prototype, "chartSelection", void 0);
GoogleChartTestElement = __decorate([
    customElement('google-chart-polymer-test')
], GoogleChartTestElement);
//# sourceMappingURL=polymer-use-test.js.map