"use strict";
/**
 * Copyright 2015 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const src_1 = require("../../shared/src");
// tslint:disable: no-any
// tslint:disable: class-name
// tslint:disable: variable-name
// tslint:disable: jsdoc-format
// tslint:disable: no-namespace
var androiddeviceprovisioning_v1;
(function (androiddeviceprovisioning_v1) {
    /**
     * Android Device Provisioning Partner API
     *
     * Automates Android zero-touch enrollment for device resellers, customers,
     * and EMMs.
     *
     * @example
     * const {google} = require('googleapis');
     * const androiddeviceprovisioning = google.androiddeviceprovisioning('v1');
     *
     * @namespace androiddeviceprovisioning
     * @type {Function}
     * @version v1
     * @variation v1
     * @param {object=} options Options for Androiddeviceprovisioning
     */
    class Androiddeviceprovisioning {
        constructor(options, google) {
            this.root = this;
            this._options = options || {};
            this.google = google;
            this.getRoot.bind(this);
            this.customers = new Resource$Customers(this);
            this.operations = new Resource$Operations(this);
            this.partners = new Resource$Partners(this);
        }
        getRoot() {
            return this.root;
        }
    }
    androiddeviceprovisioning_v1.Androiddeviceprovisioning = Androiddeviceprovisioning;
    class Resource$Customers {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
            this.configurations = new Resource$Customers$Configurations(root);
            this.devices = new Resource$Customers$Devices(root);
            this.dpcs = new Resource$Customers$Dpcs(root);
        }
        getRoot() {
            return this.root;
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/customers').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: [],
                pathParams: [],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Customers = Resource$Customers;
    class Resource$Customers$Configurations {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        create(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/configurations')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        delete(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'DELETE'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/configurations')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        patch(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'PATCH'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Customers$Configurations = Resource$Customers$Configurations;
    class Resource$Customers$Devices {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        applyConfiguration(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/devices:applyConfiguration')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/devices')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        removeConfiguration(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/devices:removeConfiguration')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        unclaim(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/devices:unclaim')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Customers$Devices = Resource$Customers$Devices;
    class Resource$Customers$Dpcs {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/dpcs')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Customers$Dpcs = Resource$Customers$Dpcs;
    class Resource$Operations {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Operations = Resource$Operations;
    class Resource$Partners {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
            this.customers = new Resource$Partners$Customers(root);
            this.devices = new Resource$Partners$Devices(root);
        }
        getRoot() {
            return this.root;
        }
    }
    androiddeviceprovisioning_v1.Resource$Partners = Resource$Partners;
    class Resource$Partners$Customers {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        create(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+parent}/customers')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['parent'],
                pathParams: ['parent'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/partners/{+partnerId}/customers')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Partners$Customers = Resource$Partners$Customers;
    class Resource$Partners$Devices {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        claim(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/partners/{+partnerId}/devices:claim')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        claimAsync(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/partners/{+partnerId}/devices:claimAsync')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        findByIdentifier(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl +
                        '/v1/partners/{+partnerId}/devices:findByIdentifier')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        findByOwner(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/partners/{+partnerId}/devices:findByOwner')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        metadata(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl +
                        '/v1/partners/{+metadataOwnerId}/devices/{+deviceId}/metadata')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['metadataOwnerId', 'deviceId'],
                pathParams: ['deviceId', 'metadataOwnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        unclaim(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/partners/{+partnerId}/devices:unclaim')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        unclaimAsync(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/partners/{+partnerId}/devices:unclaimAsync')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        updateMetadataAsync(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl ||
                'https://androiddeviceprovisioning.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl +
                        '/v1/partners/{+partnerId}/devices:updateMetadataAsync')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params,
                requiredParams: ['partnerId'],
                pathParams: ['partnerId'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    androiddeviceprovisioning_v1.Resource$Partners$Devices = Resource$Partners$Devices;
})(androiddeviceprovisioning_v1 = exports.androiddeviceprovisioning_v1 || (exports.androiddeviceprovisioning_v1 = {}));
//# sourceMappingURL=v1.js.map