/**
 * Copyright 2015 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { AxiosPromise } from 'axios';
import { Compute, JWT, OAuth2Client, UserRefreshClient } from 'google-auth-library';
import { BodyResponseCallback, GlobalOptions, GoogleConfigurable, MethodOptions } from '../../shared/src';
export declare namespace androidpublisher_v2 {
    interface Options extends GlobalOptions {
        version: 'v2';
    }
    /**
     * Google Play Developer API
     *
     * Lets Android application developers access their Google Play accounts.
     *
     * @example
     * const {google} = require('googleapis');
     * const androidpublisher = google.androidpublisher('v2');
     *
     * @namespace androidpublisher
     * @type {Function}
     * @version v2
     * @variation v2
     * @param {object=} options Options for Androidpublisher
     */
    class Androidpublisher {
        _options: GlobalOptions;
        google?: GoogleConfigurable;
        root: this;
        edits: Resource$Edits;
        inappproducts: Resource$Inappproducts;
        orders: Resource$Orders;
        purchases: Resource$Purchases;
        reviews: Resource$Reviews;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
        getRoot(): this;
    }
    interface Schema$Apk {
        /**
         * Information about the binary payload of this APK.
         */
        binary?: Schema$ApkBinary;
        /**
         * The version code of the APK, as specified in the APK&#39;s manifest file.
         */
        versionCode?: number;
    }
    /**
     * Represents the binary payload of an APK.
     */
    interface Schema$ApkBinary {
        /**
         * A sha1 hash of the APK payload, encoded as a hex string and matching the
         * output of the sha1sum command.
         */
        sha1?: string;
        /**
         * A sha256 hash of the APK payload, encoded as a hex string and matching
         * the output of the sha256sum command.
         */
        sha256?: string;
    }
    interface Schema$ApkListing {
        /**
         * The language code, in BCP 47 format (eg &quot;en-US&quot;).
         */
        language?: string;
        /**
         * Describe what&#39;s new in your APK.
         */
        recentChanges?: string;
    }
    interface Schema$ApkListingsListResponse {
        /**
         * Identifies what kind of resource this is. Value: the fixed string
         * &quot;androidpublisher#apkListingsListResponse&quot;.
         */
        kind?: string;
        listings?: Schema$ApkListing[];
    }
    interface Schema$ApksAddExternallyHostedRequest {
        /**
         * The definition of the externally-hosted APK and where it is located.
         */
        externallyHostedApk?: Schema$ExternallyHostedApk;
    }
    interface Schema$ApksAddExternallyHostedResponse {
        /**
         * The definition of the externally-hosted APK and where it is located.
         */
        externallyHostedApk?: Schema$ExternallyHostedApk;
    }
    interface Schema$ApksListResponse {
        apks?: Schema$Apk[];
        /**
         * Identifies what kind of resource this is. Value: the fixed string
         * &quot;androidpublisher#apksListResponse&quot;.
         */
        kind?: string;
    }
    interface Schema$AppDetails {
        /**
         * The user-visible support email for this app.
         */
        contactEmail?: string;
        /**
         * The user-visible support telephone number for this app.
         */
        contactPhone?: string;
        /**
         * The user-visible website for this app.
         */
        contactWebsite?: string;
        /**
         * Default language code, in BCP 47 format (eg &quot;en-US&quot;).
         */
        defaultLanguage?: string;
    }
    /**
     * Represents an edit of an app. An edit allows clients to make multiple
     * changes before committing them in one operation.
     */
    interface Schema$AppEdit {
        /**
         * The time at which the edit will expire and will be no longer valid for
         * use in any subsequent API calls (encoded as seconds since the Epoch).
         */
        expiryTimeSeconds?: string;
        /**
         * The ID of the edit that can be used in subsequent API calls.
         */
        id?: string;
    }
    interface Schema$Bundle {
        /**
         * A sha1 hash of the upload payload, encoded as a hex string and matching
         * the output of the sha1sum command.
         */
        sha1?: string;
        /**
         * A sha256 hash of the upload payload, encoded as a hex string and matching
         * the output of the sha256sum command.
         */
        sha256?: string;
        /**
         * The version code of the Android App Bundle. As specified in the Android
         * App Bundle&#39;s base module APK manifest file.
         */
        versionCode?: number;
    }
    interface Schema$BundlesListResponse {
        bundles?: Schema$Bundle[];
        /**
         * Identifies what kind of resource this is. Value: the fixed string
         * &quot;androidpublisher#bundlesListResponse&quot;.
         */
        kind?: string;
    }
    interface Schema$Comment {
        /**
         * A comment from a developer.
         */
        developerComment?: Schema$DeveloperComment;
        /**
         * A comment from a user.
         */
        userComment?: Schema$UserComment;
    }
    /**
     * Represents a deobfuscation file.
     */
    interface Schema$DeobfuscationFile {
        /**
         * The type of the deobfuscation file.
         */
        symbolType?: string;
    }
    interface Schema$DeobfuscationFilesUploadResponse {
        deobfuscationFile?: Schema$DeobfuscationFile;
    }
    interface Schema$DeveloperComment {
        /**
         * The last time at which this comment was updated.
         */
        lastModified?: Schema$Timestamp;
        /**
         * The content of the comment, i.e. reply body.
         */
        text?: string;
    }
    interface Schema$DeviceMetadata {
        /**
         * Device CPU make e.g. &quot;Qualcomm&quot;
         */
        cpuMake?: string;
        /**
         * Device CPU model e.g. &quot;MSM8974&quot;
         */
        cpuModel?: string;
        /**
         * Device class (e.g. tablet)
         */
        deviceClass?: string;
        /**
         * OpenGL version
         */
        glEsVersion?: number;
        /**
         * Device manufacturer (e.g. Motorola)
         */
        manufacturer?: string;
        /**
         * Comma separated list of native platforms (e.g. &quot;arm&quot;,
         * &quot;arm7&quot;)
         */
        nativePlatform?: string;
        /**
         * Device model name (e.g. Droid)
         */
        productName?: string;
        /**
         * Device RAM in Megabytes e.g. &quot;2048&quot;
         */
        ramMb?: number;
        /**
         * Screen density in DPI
         */
        screenDensityDpi?: number;
        /**
         * Screen height in pixels
         */
        screenHeightPx?: number;
        /**
         * Screen width in pixels
         */
        screenWidthPx?: number;
    }
    interface Schema$ExpansionFile {
        /**
         * If set this field indicates that this APK has an Expansion File uploaded
         * to it: this APK does not reference another APK&#39;s Expansion File. The
         * field&#39;s value is the size of the uploaded Expansion File in bytes.
         */
        fileSize?: string;
        /**
         * If set this APK&#39;s Expansion File references another APK&#39;s
         * Expansion File. The file_size field will not be set.
         */
        referencesVersion?: number;
    }
    interface Schema$ExpansionFilesUploadResponse {
        expansionFile?: Schema$ExpansionFile;
    }
    /**
     * Defines an APK available for this application that is hosted externally and
     * not uploaded to Google Play. This function is only available to enterprises
     * who are using Google Play for Work, and whos application is restricted to
     * the enterprise private channel
     */
    interface Schema$ExternallyHostedApk {
        /**
         * The application label.
         */
        applicationLabel?: string;
        /**
         * A certificate (or array of certificates if a certificate-chain is used)
         * used to signed this APK, represented as a base64 encoded byte array.
         */
        certificateBase64s?: string[];
        /**
         * The URL at which the APK is hosted. This must be an https URL.
         */
        externallyHostedUrl?: string;
        /**
         * The SHA1 checksum of this APK, represented as a base64 encoded byte
         * array.
         */
        fileSha1Base64?: string;
        /**
         * The SHA256 checksum of this APK, represented as a base64 encoded byte
         * array.
         */
        fileSha256Base64?: string;
        /**
         * The file size in bytes of this APK.
         */
        fileSize?: string;
        /**
         * The icon image from the APK, as a base64 encoded byte array.
         */
        iconBase64?: string;
        /**
         * The maximum SDK supported by this APK (optional).
         */
        maximumSdk?: number;
        /**
         * The minimum SDK targeted by this APK.
         */
        minimumSdk?: number;
        /**
         * The native code environments supported by this APK (optional).
         */
        nativeCodes?: string[];
        /**
         * The package name.
         */
        packageName?: string;
        /**
         * The features required by this APK (optional).
         */
        usesFeatures?: string[];
        /**
         * The permissions requested by this APK.
         */
        usesPermissions?: Schema$ExternallyHostedApkUsesPermission[];
        /**
         * The version code of this APK.
         */
        versionCode?: number;
        /**
         * The version name of this APK.
         */
        versionName?: string;
    }
    /**
     * A permission used by this APK.
     */
    interface Schema$ExternallyHostedApkUsesPermission {
        /**
         * Optionally, the maximum SDK version for which the permission is required.
         */
        maxSdkVersion?: number;
        /**
         * The name of the permission requested.
         */
        name?: string;
    }
    interface Schema$Image {
        /**
         * A unique id representing this image.
         */
        id?: string;
        /**
         * A sha1 hash of the image that was uploaded.
         */
        sha1?: string;
        /**
         * A URL that will serve a preview of the image.
         */
        url?: string;
    }
    interface Schema$ImagesDeleteAllResponse {
        deleted?: Schema$Image[];
    }
    interface Schema$ImagesListResponse {
        images?: Schema$Image[];
    }
    interface Schema$ImagesUploadResponse {
        image?: Schema$Image;
    }
    interface Schema$InAppProduct {
        /**
         * The default language of the localized data, as defined by BCP 47. e.g.
         * &quot;en-US&quot;, &quot;en-GB&quot;.
         */
        defaultLanguage?: string;
        /**
         * Default price cannot be zero. In-app products can never be free. Default
         * price is always in the developer&#39;s Checkout merchant currency.
         */
        defaultPrice?: Schema$Price;
        /**
         * List of localized title and description data.
         */
        listings?: any;
        /**
         * The package name of the parent app.
         */
        packageName?: string;
        /**
         * Prices per buyer region. None of these prices should be zero. In-app
         * products can never be free.
         */
        prices?: any;
        /**
         * Purchase type enum value. Unmodifiable after creation.
         */
        purchaseType?: string;
        /**
         * Definition of a season for a seasonal subscription. Can be defined only
         * for yearly subscriptions.
         */
        season?: Schema$Season;
        /**
         * The stock-keeping-unit (SKU) of the product, unique within an app.
         */
        sku?: string;
        status?: string;
        /**
         * Subscription period, specified in ISO 8601 format. Acceptable values are
         * &quot;P1W&quot; (one week), &quot;P1M&quot; (one month), &quot;P3M&quot;
         * (three months), &quot;P6M&quot; (six months), and &quot;P1Y&quot; (one
         * year).
         */
        subscriptionPeriod?: string;
        /**
         * Trial period, specified in ISO 8601 format. Acceptable values are
         * anything between &quot;P7D&quot; (seven days) and &quot;P999D&quot; (999
         * days). Seasonal subscriptions cannot have a trial period.
         */
        trialPeriod?: string;
    }
    interface Schema$InAppProductListing {
        description?: string;
        title?: string;
    }
    interface Schema$InappproductsListResponse {
        inappproduct?: Schema$InAppProduct[];
        /**
         * Identifies what kind of resource this is. Value: the fixed string
         * &quot;androidpublisher#inappproductsListResponse&quot;.
         */
        kind?: string;
        pageInfo?: Schema$PageInfo;
        tokenPagination?: Schema$TokenPagination;
    }
    interface Schema$Listing {
        /**
         * Full description of the app; this may be up to 4000 characters in length.
         */
        fullDescription?: string;
        /**
         * Language localization code (for example, &quot;de-AT&quot; for Austrian
         * German).
         */
        language?: string;
        /**
         * Short description of the app (previously known as promo text); this may
         * be up to 80 characters in length.
         */
        shortDescription?: string;
        /**
         * App&#39;s localized title.
         */
        title?: string;
        /**
         * URL of a promotional YouTube video for the app.
         */
        video?: string;
    }
    interface Schema$ListingsListResponse {
        /**
         * Identifies what kind of resource this is. Value: the fixed string
         * &quot;androidpublisher#listingsListResponse&quot;.
         */
        kind?: string;
        listings?: Schema$Listing[];
    }
    interface Schema$MonthDay {
        /**
         * Day of a month, value in [1, 31] range. Valid range depends on the
         * specified month.
         */
        day?: number;
        /**
         * Month of a year. e.g. 1 = JAN, 2 = FEB etc.
         */
        month?: number;
    }
    interface Schema$PageInfo {
        resultPerPage?: number;
        startIndex?: number;
        totalResults?: number;
    }
    interface Schema$Price {
        /**
         * 3 letter Currency code, as defined by ISO 4217.
         */
        currency?: string;
        /**
         * The price in millionths of the currency base unit represented as a
         * string.
         */
        priceMicros?: string;
    }
    /**
     * A ProductPurchase resource indicates the status of a user&#39;s inapp
     * product purchase.
     */
    interface Schema$ProductPurchase {
        /**
         * The consumption state of the inapp product. Possible values are:   - Yet
         * to be consumed  - Consumed
         */
        consumptionState?: number;
        /**
         * A developer-specified string that contains supplemental information about
         * an order.
         */
        developerPayload?: string;
        /**
         * This kind represents an inappPurchase object in the androidpublisher
         * service.
         */
        kind?: string;
        /**
         * The order id associated with the purchase of the inapp product.
         */
        orderId?: string;
        /**
         * The purchase state of the order. Possible values are:   - Purchased  -
         * Canceled
         */
        purchaseState?: number;
        /**
         * The time the product was purchased, in milliseconds since the epoch (Jan
         * 1, 1970).
         */
        purchaseTimeMillis?: string;
        /**
         * The type of purchase of the inapp product. This field is only set if this
         * purchase was not made using the standard in-app billing flow. Possible
         * values are:   - Test (i.e. purchased from a license testing account)  -
         * Promo (i.e. purchased using a promo code)
         */
        purchaseType?: number;
    }
    interface Schema$Prorate {
        /**
         * Default price cannot be zero and must be less than the full subscription
         * price. Default price is always in the developer&#39;s Checkout merchant
         * currency. Targeted countries have their prices set automatically based on
         * the default_price.
         */
        defaultPrice?: Schema$Price;
        /**
         * Defines the first day on which the price takes effect.
         */
        start?: Schema$MonthDay;
    }
    interface Schema$Review {
        /**
         * The name of the user who wrote the review.
         */
        authorName?: string;
        /**
         * A repeated field containing comments for the review.
         */
        comments?: Schema$Comment[];
        /**
         * Unique identifier for this review.
         */
        reviewId?: string;
    }
    interface Schema$ReviewReplyResult {
        /**
         * The time at which the reply took effect.
         */
        lastEdited?: Schema$Timestamp;
        /**
         * The reply text that was applied.
         */
        replyText?: string;
    }
    interface Schema$ReviewsListResponse {
        pageInfo?: Schema$PageInfo;
        reviews?: Schema$Review[];
        tokenPagination?: Schema$TokenPagination;
    }
    interface Schema$ReviewsReplyRequest {
        /**
         * The text to set as the reply. Replies of more than approximately 350
         * characters will be rejected. HTML tags will be stripped.
         */
        replyText?: string;
    }
    interface Schema$ReviewsReplyResponse {
        result?: Schema$ReviewReplyResult;
    }
    interface Schema$Season {
        /**
         * Inclusive end date of the recurrence period.
         */
        end?: Schema$MonthDay;
        /**
         * Optionally present list of prorations for the season. Each proration is a
         * one-off discounted entry into a subscription. Each proration contains the
         * first date on which the discount is available and the new pricing
         * information.
         */
        prorations?: Schema$Prorate[];
        /**
         * Inclusive start date of the recurrence period.
         */
        start?: Schema$MonthDay;
    }
    /**
     * Information provided by the user when they complete the subscription
     * cancellation flow (cancellation reason survey).
     */
    interface Schema$SubscriptionCancelSurveyResult {
        /**
         * The cancellation reason the user chose in the survey. Possible values
         * are:   - Other  - I don&#39;t use this service enough  - Technical issues
         * - Cost-related reasons  - I found a better app
         */
        cancelSurveyReason?: number;
        /**
         * The customized input cancel reason from the user. Only present when
         * cancelReason is 0.
         */
        userInputCancelReason?: string;
    }
    /**
     * A SubscriptionDeferralInfo contains the data needed to defer a subscription
     * purchase to a future expiry time.
     */
    interface Schema$SubscriptionDeferralInfo {
        /**
         * The desired next expiry time to assign to the subscription, in
         * milliseconds since the Epoch. The given time must be later/greater than
         * the current expiry time for the subscription.
         */
        desiredExpiryTimeMillis?: string;
        /**
         * The expected expiry time for the subscription. If the current expiry time
         * for the subscription is not the value specified here, the deferral will
         * not occur.
         */
        expectedExpiryTimeMillis?: string;
    }
    /**
     * A SubscriptionPurchase resource indicates the status of a user&#39;s
     * subscription purchase.
     */
    interface Schema$SubscriptionPurchase {
        /**
         * Whether the subscription will automatically be renewed when it reaches
         * its current expiry time.
         */
        autoRenewing?: boolean;
        /**
         * The reason why a subscription was canceled or is not auto-renewing.
         * Possible values are:   - User canceled the subscription  - Subscription
         * was canceled by the system, for example because of a billing problem  -
         * Subscription was replaced with a new subscription  - Subscription was
         * canceled by the developer
         */
        cancelReason?: number;
        /**
         * Information provided by the user when they complete the subscription
         * cancellation flow (cancellation reason survey).
         */
        cancelSurveyResult?: Schema$SubscriptionCancelSurveyResult;
        /**
         * ISO 3166-1 alpha-2 billing country/region code of the user at the time
         * the subscription was granted.
         */
        countryCode?: string;
        /**
         * A developer-specified string that contains supplemental information about
         * an order.
         */
        developerPayload?: string;
        /**
         * The email address of the user when the subscription was purchased. Only
         * present for purchases made with &#39;Subscribe with Google&#39;.
         */
        emailAddress?: string;
        /**
         * Time at which the subscription will expire, in milliseconds since the
         * Epoch.
         */
        expiryTimeMillis?: string;
        /**
         * The family name of the user when the subscription was purchased. Only
         * present for purchases made with &#39;Subscribe with Google&#39;.
         */
        familyName?: string;
        /**
         * The given name of the user when the subscription was purchased. Only
         * present for purchases made with &#39;Subscribe with Google&#39;.
         */
        givenName?: string;
        /**
         * This kind represents a subscriptionPurchase object in the
         * androidpublisher service.
         */
        kind?: string;
        /**
         * The purchase token of the originating purchase if this subscription is
         * one of the following:   - Re-signup of a canceled but non-lapsed
         * subscription  - Upgrade/downgrade from a previous subscription  For
         * example, suppose a user originally signs up and you receive purchase
         * token X, then the user cancels and goes through the resignup flow (before
         * their subscription lapses) and you receive purchase token Y, and finally
         * the user upgrades their subscription and you receive purchase token Z. If
         * you call this API with purchase token Z, this field will be set to Y. If
         * you call this API with purchase token Y, this field will be set to X. If
         * you call this API with purchase token X, this field will not be set.
         */
        linkedPurchaseToken?: string;
        /**
         * The order id of the latest recurring order associated with the purchase
         * of the subscription.
         */
        orderId?: string;
        /**
         * The payment state of the subscription. Possible values are:   - Payment
         * pending  - Payment received  - Free trial
         */
        paymentState?: number;
        /**
         * Price of the subscription, not including tax. Price is expressed in
         * micro-units, where 1,000,000 micro-units represents one unit of the
         * currency. For example, if the subscription price is €1.99,
         * price_amount_micros is 1990000.
         */
        priceAmountMicros?: string;
        /**
         * ISO 4217 currency code for the subscription price. For example, if the
         * price is specified in British pounds sterling, price_currency_code is
         * &quot;GBP&quot;.
         */
        priceCurrencyCode?: string;
        /**
         * The profile id of the user when the subscription was purchased. Only
         * present for purchases made with &#39;Subscribe with Google&#39;.
         */
        profileId?: string;
        /**
         * The profile name of the user when the subscription was purchased. Only
         * present for purchases made with &#39;Subscribe with Google&#39;.
         */
        profileName?: string;
        /**
         * The type of purchase of the subscription. This field is only set if this
         * purchase was not made using the standard in-app billing flow. Possible
         * values are:   - Test (i.e. purchased from a license testing account)
         */
        purchaseType?: number;
        /**
         * Time at which the subscription was granted, in milliseconds since the
         * Epoch.
         */
        startTimeMillis?: string;
        /**
         * The time at which the subscription was canceled by the user, in
         * milliseconds since the epoch. Only present if cancelReason is 0.
         */
        userCancellationTimeMillis?: string;
    }
    interface Schema$SubscriptionPurchasesDeferRequest {
        /**
         * The information about the new desired expiry time for the subscription.
         */
        deferralInfo?: Schema$SubscriptionDeferralInfo;
    }
    interface Schema$SubscriptionPurchasesDeferResponse {
        /**
         * The new expiry time for the subscription in milliseconds since the Epoch.
         */
        newExpiryTimeMillis?: string;
    }
    interface Schema$Testers {
        googleGroups?: string[];
        googlePlusCommunities?: string[];
    }
    interface Schema$Timestamp {
        nanos?: number;
        seconds?: string;
    }
    interface Schema$TokenPagination {
        nextPageToken?: string;
        previousPageToken?: string;
    }
    interface Schema$Track {
        /**
         * Identifier for this track.
         */
        track?: string;
        userFraction?: number;
        /**
         * Version codes to make active on this track. Note that this list should
         * contain all versions you wish to be active, including those you wish to
         * retain from previous releases.
         */
        versionCodes?: number[];
    }
    interface Schema$TracksListResponse {
        /**
         * Identifies what kind of resource this is. Value: the fixed string
         * &quot;androidpublisher#tracksListResponse&quot;.
         */
        kind?: string;
        tracks?: Schema$Track[];
    }
    interface Schema$UserComment {
        /**
         * Integer Android SDK version of the user&#39;s device at the time the
         * review was written, e.g. 23 is Marshmallow. May be absent.
         */
        androidOsVersion?: number;
        /**
         * Integer version code of the app as installed at the time the review was
         * written. May be absent.
         */
        appVersionCode?: number;
        /**
         * String version name of the app as installed at the time the review was
         * written. May be absent.
         */
        appVersionName?: string;
        /**
         * Codename for the reviewer&#39;s device, e.g. klte, flounder. May be
         * absent.
         */
        device?: string;
        /**
         * Some information about the characteristics of the user&#39;s device
         */
        deviceMetadata?: Schema$DeviceMetadata;
        /**
         * The last time at which this comment was updated.
         */
        lastModified?: Schema$Timestamp;
        /**
         * Untranslated text of the review, in the case where the review has been
         * translated. If the review has not been translated this is left blank.
         */
        originalText?: string;
        /**
         * Language code for the reviewer. This is taken from the device settings so
         * is not guaranteed to match the language the review is written in. May be
         * absent.
         */
        reviewerLanguage?: string;
        /**
         * The star rating associated with the review, from 1 to 5.
         */
        starRating?: number;
        /**
         * The content of the comment, i.e. review body. In some cases users have
         * been able to write a review with separate title and body; in those cases
         * the title and body are concatenated and separated by a tab character.
         */
        text?: string;
        /**
         * Number of users who have given this review a thumbs down
         */
        thumbsDownCount?: number;
        /**
         * Number of users who have given this review a thumbs up
         */
        thumbsUpCount?: number;
    }
    /**
     * A VoidedPurchase resource indicates a purchase that was either
     * canceled/refunded/charged-back.
     */
    interface Schema$VoidedPurchase {
        /**
         * This kind represents a voided purchase object in the androidpublisher
         * service.
         */
        kind?: string;
        /**
         * The time at which the purchase was made, in milliseconds since the epoch
         * (Jan 1, 1970).
         */
        purchaseTimeMillis?: string;
        /**
         * The token that was generated when a purchase was made. This uniquely
         * identifies a purchase.
         */
        purchaseToken?: string;
        /**
         * The time at which the purchase was canceled/refunded/charged-back, in
         * milliseconds since the epoch (Jan 1, 1970).
         */
        voidedTimeMillis?: string;
    }
    interface Schema$VoidedPurchasesListResponse {
        pageInfo?: Schema$PageInfo;
        tokenPagination?: Schema$TokenPagination;
        voidedPurchases?: Schema$VoidedPurchase[];
    }
    class Resource$Edits {
        root: Androidpublisher;
        apklistings: Resource$Edits$Apklistings;
        apks: Resource$Edits$Apks;
        bundles: Resource$Edits$Bundles;
        deobfuscationfiles: Resource$Edits$Deobfuscationfiles;
        details: Resource$Edits$Details;
        expansionfiles: Resource$Edits$Expansionfiles;
        images: Resource$Edits$Images;
        listings: Resource$Edits$Listings;
        testers: Resource$Edits$Testers;
        tracks: Resource$Edits$Tracks;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.commit
         * @desc Commits/applies the changes made in this edit back to the app.
         * @alias androidpublisher.edits.commit
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        commit(params?: Params$Resource$Edits$Commit, options?: MethodOptions): AxiosPromise<Schema$AppEdit>;
        commit(params: Params$Resource$Edits$Commit, options: MethodOptions | BodyResponseCallback<Schema$AppEdit>, callback: BodyResponseCallback<Schema$AppEdit>): void;
        commit(params: Params$Resource$Edits$Commit, callback: BodyResponseCallback<Schema$AppEdit>): void;
        commit(callback: BodyResponseCallback<Schema$AppEdit>): void;
        /**
         * androidpublisher.edits.delete
         * @desc Deletes an edit for an app. Creating a new edit will automatically
         * delete any of your previous edits so this method need only be called if
         * you want to preemptively abandon an edit.
         * @alias androidpublisher.edits.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Edits$Delete, options?: MethodOptions): AxiosPromise<void>;
        delete(params: Params$Resource$Edits$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$Edits$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.edits.get
         * @desc Returns information about the edit specified. Calls will fail if
         * the edit is no long active (e.g. has been deleted, superseded or
         * expired).
         * @alias androidpublisher.edits.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Get, options?: MethodOptions): AxiosPromise<Schema$AppEdit>;
        get(params: Params$Resource$Edits$Get, options: MethodOptions | BodyResponseCallback<Schema$AppEdit>, callback: BodyResponseCallback<Schema$AppEdit>): void;
        get(params: Params$Resource$Edits$Get, callback: BodyResponseCallback<Schema$AppEdit>): void;
        get(callback: BodyResponseCallback<Schema$AppEdit>): void;
        /**
         * androidpublisher.edits.insert
         * @desc Creates a new edit for an app, populated with the app's current
         * state.
         * @alias androidpublisher.edits.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().AppEdit} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Edits$Insert, options?: MethodOptions): AxiosPromise<Schema$AppEdit>;
        insert(params: Params$Resource$Edits$Insert, options: MethodOptions | BodyResponseCallback<Schema$AppEdit>, callback: BodyResponseCallback<Schema$AppEdit>): void;
        insert(params: Params$Resource$Edits$Insert, callback: BodyResponseCallback<Schema$AppEdit>): void;
        insert(callback: BodyResponseCallback<Schema$AppEdit>): void;
        /**
         * androidpublisher.edits.validate
         * @desc Checks that the edit can be successfully committed. The edit's
         * changes are not applied to the live app.
         * @alias androidpublisher.edits.validate
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        validate(params?: Params$Resource$Edits$Validate, options?: MethodOptions): AxiosPromise<Schema$AppEdit>;
        validate(params: Params$Resource$Edits$Validate, options: MethodOptions | BodyResponseCallback<Schema$AppEdit>, callback: BodyResponseCallback<Schema$AppEdit>): void;
        validate(params: Params$Resource$Edits$Validate, callback: BodyResponseCallback<Schema$AppEdit>): void;
        validate(callback: BodyResponseCallback<Schema$AppEdit>): void;
    }
    interface Params$Resource$Edits$Commit {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Delete {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Insert {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AppEdit;
    }
    interface Params$Resource$Edits$Validate {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    class Resource$Edits$Apklistings {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.apklistings.delete
         * @desc Deletes the APK-specific localized listing for a specified APK and
         * language code.
         * @alias androidpublisher.edits.apklistings.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The APK version code whose APK-specific listings should be read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the APK-specific localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Edits$Apklistings$Delete, options?: MethodOptions): AxiosPromise<void>;
        delete(params: Params$Resource$Edits$Apklistings$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$Edits$Apklistings$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.edits.apklistings.deleteall
         * @desc Deletes all the APK-specific localized listings for a specified
         * APK.
         * @alias androidpublisher.edits.apklistings.deleteall
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The APK version code whose APK-specific listings should be read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        deleteall(params?: Params$Resource$Edits$Apklistings$Deleteall, options?: MethodOptions): AxiosPromise<void>;
        deleteall(params: Params$Resource$Edits$Apklistings$Deleteall, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        deleteall(params: Params$Resource$Edits$Apklistings$Deleteall, callback: BodyResponseCallback<void>): void;
        deleteall(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.edits.apklistings.get
         * @desc Fetches the APK-specific localized listing for a specified APK and
         * language code.
         * @alias androidpublisher.edits.apklistings.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The APK version code whose APK-specific listings should be read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the APK-specific localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Apklistings$Get, options?: MethodOptions): AxiosPromise<Schema$ApkListing>;
        get(params: Params$Resource$Edits$Apklistings$Get, options: MethodOptions | BodyResponseCallback<Schema$ApkListing>, callback: BodyResponseCallback<Schema$ApkListing>): void;
        get(params: Params$Resource$Edits$Apklistings$Get, callback: BodyResponseCallback<Schema$ApkListing>): void;
        get(callback: BodyResponseCallback<Schema$ApkListing>): void;
        /**
         * androidpublisher.edits.apklistings.list
         * @desc Lists all the APK-specific localized listings for a specified APK.
         * @alias androidpublisher.edits.apklistings.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The APK version code whose APK-specific listings should be read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Edits$Apklistings$List, options?: MethodOptions): AxiosPromise<Schema$ApkListingsListResponse>;
        list(params: Params$Resource$Edits$Apklistings$List, options: MethodOptions | BodyResponseCallback<Schema$ApkListingsListResponse>, callback: BodyResponseCallback<Schema$ApkListingsListResponse>): void;
        list(params: Params$Resource$Edits$Apklistings$List, callback: BodyResponseCallback<Schema$ApkListingsListResponse>): void;
        list(callback: BodyResponseCallback<Schema$ApkListingsListResponse>): void;
        /**
         * androidpublisher.edits.apklistings.patch
         * @desc Updates or creates the APK-specific localized listing for a
         * specified APK and language code. This method supports patch semantics.
         * @alias androidpublisher.edits.apklistings.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The APK version code whose APK-specific listings should be read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the APK-specific localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().ApkListing} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Edits$Apklistings$Patch, options?: MethodOptions): AxiosPromise<Schema$ApkListing>;
        patch(params: Params$Resource$Edits$Apklistings$Patch, options: MethodOptions | BodyResponseCallback<Schema$ApkListing>, callback: BodyResponseCallback<Schema$ApkListing>): void;
        patch(params: Params$Resource$Edits$Apklistings$Patch, callback: BodyResponseCallback<Schema$ApkListing>): void;
        patch(callback: BodyResponseCallback<Schema$ApkListing>): void;
        /**
         * androidpublisher.edits.apklistings.update
         * @desc Updates or creates the APK-specific localized listing for a
         * specified APK and language code.
         * @alias androidpublisher.edits.apklistings.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The APK version code whose APK-specific listings should be read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the APK-specific localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().ApkListing} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Edits$Apklistings$Update, options?: MethodOptions): AxiosPromise<Schema$ApkListing>;
        update(params: Params$Resource$Edits$Apklistings$Update, options: MethodOptions | BodyResponseCallback<Schema$ApkListing>, callback: BodyResponseCallback<Schema$ApkListing>): void;
        update(params: Params$Resource$Edits$Apklistings$Update, callback: BodyResponseCallback<Schema$ApkListing>): void;
        update(callback: BodyResponseCallback<Schema$ApkListing>): void;
    }
    interface Params$Resource$Edits$Apklistings$Delete {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The APK version code whose APK-specific listings should be read or
         * modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the APK-specific localized
         * listing to read or modify. For example, to select Austrian German, pass
         * "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Apklistings$Deleteall {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The APK version code whose APK-specific listings should be read or
         * modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Apklistings$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The APK version code whose APK-specific listings should be read or
         * modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the APK-specific localized
         * listing to read or modify. For example, to select Austrian German, pass
         * "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Apklistings$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The APK version code whose APK-specific listings should be read or
         * modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Apklistings$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The APK version code whose APK-specific listings should be read or
         * modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the APK-specific localized
         * listing to read or modify. For example, to select Austrian German, pass
         * "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ApkListing;
    }
    interface Params$Resource$Edits$Apklistings$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The APK version code whose APK-specific listings should be read or
         * modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the APK-specific localized
         * listing to read or modify. For example, to select Austrian German, pass
         * "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ApkListing;
    }
    class Resource$Edits$Apks {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.apks.addexternallyhosted
         * @desc Creates a new APK without uploading the APK itself to Google Play,
         * instead hosting the APK at a specified URL. This function is only
         * available to enterprises using Google Play for Work whose application is
         * configured to restrict distribution to the enterprise domain.
         * @alias androidpublisher.edits.apks.addexternallyhosted
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().ApksAddExternallyHostedRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        addexternallyhosted(params?: Params$Resource$Edits$Apks$Addexternallyhosted, options?: MethodOptions): AxiosPromise<Schema$ApksAddExternallyHostedResponse>;
        addexternallyhosted(params: Params$Resource$Edits$Apks$Addexternallyhosted, options: MethodOptions | BodyResponseCallback<Schema$ApksAddExternallyHostedResponse>, callback: BodyResponseCallback<Schema$ApksAddExternallyHostedResponse>): void;
        addexternallyhosted(params: Params$Resource$Edits$Apks$Addexternallyhosted, callback: BodyResponseCallback<Schema$ApksAddExternallyHostedResponse>): void;
        addexternallyhosted(callback: BodyResponseCallback<Schema$ApksAddExternallyHostedResponse>): void;
        /**
         * androidpublisher.edits.apks.list
         * @alias androidpublisher.edits.apks.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Edits$Apks$List, options?: MethodOptions): AxiosPromise<Schema$ApksListResponse>;
        list(params: Params$Resource$Edits$Apks$List, options: MethodOptions | BodyResponseCallback<Schema$ApksListResponse>, callback: BodyResponseCallback<Schema$ApksListResponse>): void;
        list(params: Params$Resource$Edits$Apks$List, callback: BodyResponseCallback<Schema$ApksListResponse>): void;
        list(callback: BodyResponseCallback<Schema$ApksListResponse>): void;
        /**
         * androidpublisher.edits.apks.upload
         * @alias androidpublisher.edits.apks.upload
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} params.media Media object
         * @param {string} params.media.mimeType Media mime-type
         * @param {string|object} params.media.body Media body contents
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        upload(params?: Params$Resource$Edits$Apks$Upload, options?: MethodOptions): AxiosPromise<Schema$Apk>;
        upload(params: Params$Resource$Edits$Apks$Upload, options: MethodOptions | BodyResponseCallback<Schema$Apk>, callback: BodyResponseCallback<Schema$Apk>): void;
        upload(params: Params$Resource$Edits$Apks$Upload, callback: BodyResponseCallback<Schema$Apk>): void;
        upload(callback: BodyResponseCallback<Schema$Apk>): void;
    }
    interface Params$Resource$Edits$Apks$Addexternallyhosted {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ApksAddExternallyHostedRequest;
    }
    interface Params$Resource$Edits$Apks$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Apks$Upload {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mediaType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    class Resource$Edits$Bundles {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.bundles.list
         * @alias androidpublisher.edits.bundles.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Edits$Bundles$List, options?: MethodOptions): AxiosPromise<Schema$BundlesListResponse>;
        list(params: Params$Resource$Edits$Bundles$List, options: MethodOptions | BodyResponseCallback<Schema$BundlesListResponse>, callback: BodyResponseCallback<Schema$BundlesListResponse>): void;
        list(params: Params$Resource$Edits$Bundles$List, callback: BodyResponseCallback<Schema$BundlesListResponse>): void;
        list(callback: BodyResponseCallback<Schema$BundlesListResponse>): void;
        /**
         * androidpublisher.edits.bundles.upload
         * @alias androidpublisher.edits.bundles.upload
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} params.media Media object
         * @param {string} params.media.mimeType Media mime-type
         * @param {string|object} params.media.body Media body contents
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        upload(params?: Params$Resource$Edits$Bundles$Upload, options?: MethodOptions): AxiosPromise<Schema$Bundle>;
        upload(params: Params$Resource$Edits$Bundles$Upload, options: MethodOptions | BodyResponseCallback<Schema$Bundle>, callback: BodyResponseCallback<Schema$Bundle>): void;
        upload(params: Params$Resource$Edits$Bundles$Upload, callback: BodyResponseCallback<Schema$Bundle>): void;
        upload(callback: BodyResponseCallback<Schema$Bundle>): void;
    }
    interface Params$Resource$Edits$Bundles$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Bundles$Upload {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mediaType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    class Resource$Edits$Deobfuscationfiles {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.deobfuscationfiles.upload
         * @desc Uploads the deobfuscation file of the specified APK. If a
         * deobfuscation file already exists, it will be replaced.
         * @alias androidpublisher.edits.deobfuscationfiles.upload
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The version code of the APK whose deobfuscation file is being uploaded.
         * @param {string} params.deobfuscationFileType
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier of the Android app for which the deobfuscatiuon files are being uploaded; for example, "com.spiffygame".
         * @param {object} params.media Media object
         * @param {string} params.media.mimeType Media mime-type
         * @param {string|object} params.media.body Media body contents
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        upload(params?: Params$Resource$Edits$Deobfuscationfiles$Upload, options?: MethodOptions): AxiosPromise<Schema$DeobfuscationFilesUploadResponse>;
        upload(params: Params$Resource$Edits$Deobfuscationfiles$Upload, options: MethodOptions | BodyResponseCallback<Schema$DeobfuscationFilesUploadResponse>, callback: BodyResponseCallback<Schema$DeobfuscationFilesUploadResponse>): void;
        upload(params: Params$Resource$Edits$Deobfuscationfiles$Upload, callback: BodyResponseCallback<Schema$DeobfuscationFilesUploadResponse>): void;
        upload(callback: BodyResponseCallback<Schema$DeobfuscationFilesUploadResponse>): void;
    }
    interface Params$Resource$Edits$Deobfuscationfiles$Upload {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version code of the APK whose deobfuscation file is being uploaded.
         */
        apkVersionCode?: number;
        /**
         *
         */
        deobfuscationFileType?: string;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier of the Android app for which the deobfuscatiuon files
         * are being uploaded; for example, "com.spiffygame".
         */
        packageName?: string;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mediaType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    class Resource$Edits$Details {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.details.get
         * @desc Fetches app details for this edit. This includes the default
         * language and developer support contact information.
         * @alias androidpublisher.edits.details.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Details$Get, options?: MethodOptions): AxiosPromise<Schema$AppDetails>;
        get(params: Params$Resource$Edits$Details$Get, options: MethodOptions | BodyResponseCallback<Schema$AppDetails>, callback: BodyResponseCallback<Schema$AppDetails>): void;
        get(params: Params$Resource$Edits$Details$Get, callback: BodyResponseCallback<Schema$AppDetails>): void;
        get(callback: BodyResponseCallback<Schema$AppDetails>): void;
        /**
         * androidpublisher.edits.details.patch
         * @desc Updates app details for this edit. This method supports patch
         * semantics.
         * @alias androidpublisher.edits.details.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().AppDetails} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Edits$Details$Patch, options?: MethodOptions): AxiosPromise<Schema$AppDetails>;
        patch(params: Params$Resource$Edits$Details$Patch, options: MethodOptions | BodyResponseCallback<Schema$AppDetails>, callback: BodyResponseCallback<Schema$AppDetails>): void;
        patch(params: Params$Resource$Edits$Details$Patch, callback: BodyResponseCallback<Schema$AppDetails>): void;
        patch(callback: BodyResponseCallback<Schema$AppDetails>): void;
        /**
         * androidpublisher.edits.details.update
         * @desc Updates app details for this edit.
         * @alias androidpublisher.edits.details.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().AppDetails} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Edits$Details$Update, options?: MethodOptions): AxiosPromise<Schema$AppDetails>;
        update(params: Params$Resource$Edits$Details$Update, options: MethodOptions | BodyResponseCallback<Schema$AppDetails>, callback: BodyResponseCallback<Schema$AppDetails>): void;
        update(params: Params$Resource$Edits$Details$Update, callback: BodyResponseCallback<Schema$AppDetails>): void;
        update(callback: BodyResponseCallback<Schema$AppDetails>): void;
    }
    interface Params$Resource$Edits$Details$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Details$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AppDetails;
    }
    interface Params$Resource$Edits$Details$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$AppDetails;
    }
    class Resource$Edits$Expansionfiles {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.expansionfiles.get
         * @desc Fetches the Expansion File configuration for the APK specified.
         * @alias androidpublisher.edits.expansionfiles.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The version code of the APK whose Expansion File configuration is being read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.expansionFileType
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Expansionfiles$Get, options?: MethodOptions): AxiosPromise<Schema$ExpansionFile>;
        get(params: Params$Resource$Edits$Expansionfiles$Get, options: MethodOptions | BodyResponseCallback<Schema$ExpansionFile>, callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        get(params: Params$Resource$Edits$Expansionfiles$Get, callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        get(callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        /**
         * androidpublisher.edits.expansionfiles.patch
         * @desc Updates the APK's Expansion File configuration to reference another
         * APK's Expansion Files. To add a new Expansion File use the Upload method.
         * This method supports patch semantics.
         * @alias androidpublisher.edits.expansionfiles.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The version code of the APK whose Expansion File configuration is being read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.expansionFileType
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().ExpansionFile} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Edits$Expansionfiles$Patch, options?: MethodOptions): AxiosPromise<Schema$ExpansionFile>;
        patch(params: Params$Resource$Edits$Expansionfiles$Patch, options: MethodOptions | BodyResponseCallback<Schema$ExpansionFile>, callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        patch(params: Params$Resource$Edits$Expansionfiles$Patch, callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        patch(callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        /**
         * androidpublisher.edits.expansionfiles.update
         * @desc Updates the APK's Expansion File configuration to reference another
         * APK's Expansion Files. To add a new Expansion File use the Upload method.
         * @alias androidpublisher.edits.expansionfiles.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The version code of the APK whose Expansion File configuration is being read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.expansionFileType
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().ExpansionFile} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Edits$Expansionfiles$Update, options?: MethodOptions): AxiosPromise<Schema$ExpansionFile>;
        update(params: Params$Resource$Edits$Expansionfiles$Update, options: MethodOptions | BodyResponseCallback<Schema$ExpansionFile>, callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        update(params: Params$Resource$Edits$Expansionfiles$Update, callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        update(callback: BodyResponseCallback<Schema$ExpansionFile>): void;
        /**
         * androidpublisher.edits.expansionfiles.upload
         * @desc Uploads and attaches a new Expansion File to the APK specified.
         * @alias androidpublisher.edits.expansionfiles.upload
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer} params.apkVersionCode The version code of the APK whose Expansion File configuration is being read or modified.
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.expansionFileType
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} params.media Media object
         * @param {string} params.media.mimeType Media mime-type
         * @param {string|object} params.media.body Media body contents
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        upload(params?: Params$Resource$Edits$Expansionfiles$Upload, options?: MethodOptions): AxiosPromise<Schema$ExpansionFilesUploadResponse>;
        upload(params: Params$Resource$Edits$Expansionfiles$Upload, options: MethodOptions | BodyResponseCallback<Schema$ExpansionFilesUploadResponse>, callback: BodyResponseCallback<Schema$ExpansionFilesUploadResponse>): void;
        upload(params: Params$Resource$Edits$Expansionfiles$Upload, callback: BodyResponseCallback<Schema$ExpansionFilesUploadResponse>): void;
        upload(callback: BodyResponseCallback<Schema$ExpansionFilesUploadResponse>): void;
    }
    interface Params$Resource$Edits$Expansionfiles$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version code of the APK whose Expansion File configuration is being
         * read or modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        expansionFileType?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Expansionfiles$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version code of the APK whose Expansion File configuration is being
         * read or modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        expansionFileType?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ExpansionFile;
    }
    interface Params$Resource$Edits$Expansionfiles$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version code of the APK whose Expansion File configuration is being
         * read or modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        expansionFileType?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ExpansionFile;
    }
    interface Params$Resource$Edits$Expansionfiles$Upload {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The version code of the APK whose Expansion File configuration is being
         * read or modified.
         */
        apkVersionCode?: number;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        expansionFileType?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mediaType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    class Resource$Edits$Images {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.images.delete
         * @desc Deletes the image (specified by id) from the edit.
         * @alias androidpublisher.edits.images.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.imageId Unique identifier an image within the set of images attached to this edit.
         * @param {string} params.imageType
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing whose images are to read or modified. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Edits$Images$Delete, options?: MethodOptions): AxiosPromise<void>;
        delete(params: Params$Resource$Edits$Images$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$Edits$Images$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.edits.images.deleteall
         * @desc Deletes all images for the specified language and image type.
         * @alias androidpublisher.edits.images.deleteall
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.imageType
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing whose images are to read or modified. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        deleteall(params?: Params$Resource$Edits$Images$Deleteall, options?: MethodOptions): AxiosPromise<Schema$ImagesDeleteAllResponse>;
        deleteall(params: Params$Resource$Edits$Images$Deleteall, options: MethodOptions | BodyResponseCallback<Schema$ImagesDeleteAllResponse>, callback: BodyResponseCallback<Schema$ImagesDeleteAllResponse>): void;
        deleteall(params: Params$Resource$Edits$Images$Deleteall, callback: BodyResponseCallback<Schema$ImagesDeleteAllResponse>): void;
        deleteall(callback: BodyResponseCallback<Schema$ImagesDeleteAllResponse>): void;
        /**
         * androidpublisher.edits.images.list
         * @desc Lists all images for the specified language and image type.
         * @alias androidpublisher.edits.images.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.imageType
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing whose images are to read or modified. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Edits$Images$List, options?: MethodOptions): AxiosPromise<Schema$ImagesListResponse>;
        list(params: Params$Resource$Edits$Images$List, options: MethodOptions | BodyResponseCallback<Schema$ImagesListResponse>, callback: BodyResponseCallback<Schema$ImagesListResponse>): void;
        list(params: Params$Resource$Edits$Images$List, callback: BodyResponseCallback<Schema$ImagesListResponse>): void;
        list(callback: BodyResponseCallback<Schema$ImagesListResponse>): void;
        /**
         * androidpublisher.edits.images.upload
         * @desc Uploads a new image and adds it to the list of images for the
         * specified language and image type.
         * @alias androidpublisher.edits.images.upload
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.imageType
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing whose images are to read or modified. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} params.media Media object
         * @param {string} params.media.mimeType Media mime-type
         * @param {string|object} params.media.body Media body contents
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        upload(params?: Params$Resource$Edits$Images$Upload, options?: MethodOptions): AxiosPromise<Schema$ImagesUploadResponse>;
        upload(params: Params$Resource$Edits$Images$Upload, options: MethodOptions | BodyResponseCallback<Schema$ImagesUploadResponse>, callback: BodyResponseCallback<Schema$ImagesUploadResponse>): void;
        upload(params: Params$Resource$Edits$Images$Upload, callback: BodyResponseCallback<Schema$ImagesUploadResponse>): void;
        upload(callback: BodyResponseCallback<Schema$ImagesUploadResponse>): void;
    }
    interface Params$Resource$Edits$Images$Delete {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier an image within the set of images attached to this
         * edit.
         */
        imageId?: string;
        /**
         *
         */
        imageType?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing whose
         * images are to read or modified. For example, to select Austrian German,
         * pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Images$Deleteall {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        imageType?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing whose
         * images are to read or modified. For example, to select Austrian German,
         * pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Images$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        imageType?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing whose
         * images are to read or modified. For example, to select Austrian German,
         * pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Images$Upload {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         *
         */
        imageType?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing whose
         * images are to read or modified. For example, to select Austrian German,
         * pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mediaType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    class Resource$Edits$Listings {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.listings.delete
         * @desc Deletes the specified localized store listing from an edit.
         * @alias androidpublisher.edits.listings.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Edits$Listings$Delete, options?: MethodOptions): AxiosPromise<void>;
        delete(params: Params$Resource$Edits$Listings$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$Edits$Listings$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.edits.listings.deleteall
         * @desc Deletes all localized listings from an edit.
         * @alias androidpublisher.edits.listings.deleteall
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        deleteall(params?: Params$Resource$Edits$Listings$Deleteall, options?: MethodOptions): AxiosPromise<void>;
        deleteall(params: Params$Resource$Edits$Listings$Deleteall, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        deleteall(params: Params$Resource$Edits$Listings$Deleteall, callback: BodyResponseCallback<void>): void;
        deleteall(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.edits.listings.get
         * @desc Fetches information about a localized store listing.
         * @alias androidpublisher.edits.listings.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Listings$Get, options?: MethodOptions): AxiosPromise<Schema$Listing>;
        get(params: Params$Resource$Edits$Listings$Get, options: MethodOptions | BodyResponseCallback<Schema$Listing>, callback: BodyResponseCallback<Schema$Listing>): void;
        get(params: Params$Resource$Edits$Listings$Get, callback: BodyResponseCallback<Schema$Listing>): void;
        get(callback: BodyResponseCallback<Schema$Listing>): void;
        /**
         * androidpublisher.edits.listings.list
         * @desc Returns all of the localized store listings attached to this edit.
         * @alias androidpublisher.edits.listings.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Edits$Listings$List, options?: MethodOptions): AxiosPromise<Schema$ListingsListResponse>;
        list(params: Params$Resource$Edits$Listings$List, options: MethodOptions | BodyResponseCallback<Schema$ListingsListResponse>, callback: BodyResponseCallback<Schema$ListingsListResponse>): void;
        list(params: Params$Resource$Edits$Listings$List, callback: BodyResponseCallback<Schema$ListingsListResponse>): void;
        list(callback: BodyResponseCallback<Schema$ListingsListResponse>): void;
        /**
         * androidpublisher.edits.listings.patch
         * @desc Creates or updates a localized store listing. This method supports
         * patch semantics.
         * @alias androidpublisher.edits.listings.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().Listing} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Edits$Listings$Patch, options?: MethodOptions): AxiosPromise<Schema$Listing>;
        patch(params: Params$Resource$Edits$Listings$Patch, options: MethodOptions | BodyResponseCallback<Schema$Listing>, callback: BodyResponseCallback<Schema$Listing>): void;
        patch(params: Params$Resource$Edits$Listings$Patch, callback: BodyResponseCallback<Schema$Listing>): void;
        patch(callback: BodyResponseCallback<Schema$Listing>): void;
        /**
         * androidpublisher.edits.listings.update
         * @desc Creates or updates a localized store listing.
         * @alias androidpublisher.edits.listings.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.language The language code (a BCP-47 language tag) of the localized listing to read or modify. For example, to select Austrian German, pass "de-AT".
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {().Listing} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Edits$Listings$Update, options?: MethodOptions): AxiosPromise<Schema$Listing>;
        update(params: Params$Resource$Edits$Listings$Update, options: MethodOptions | BodyResponseCallback<Schema$Listing>, callback: BodyResponseCallback<Schema$Listing>): void;
        update(params: Params$Resource$Edits$Listings$Update, callback: BodyResponseCallback<Schema$Listing>): void;
        update(callback: BodyResponseCallback<Schema$Listing>): void;
    }
    interface Params$Resource$Edits$Listings$Delete {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing to
         * read or modify. For example, to select Austrian German, pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Listings$Deleteall {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Listings$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing to
         * read or modify. For example, to select Austrian German, pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Listings$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Listings$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing to
         * read or modify. For example, to select Austrian German, pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Listing;
    }
    interface Params$Resource$Edits$Listings$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * The language code (a BCP-47 language tag) of the localized listing to
         * read or modify. For example, to select Austrian German, pass "de-AT".
         */
        language?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Listing;
    }
    class Resource$Edits$Testers {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.testers.get
         * @alias androidpublisher.edits.testers.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {string} params.track The track to read or modify. Acceptable values are: "alpha", "beta", "production", "rollout" or "internal".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Testers$Get, options?: MethodOptions): AxiosPromise<Schema$Testers>;
        get(params: Params$Resource$Edits$Testers$Get, options: MethodOptions | BodyResponseCallback<Schema$Testers>, callback: BodyResponseCallback<Schema$Testers>): void;
        get(params: Params$Resource$Edits$Testers$Get, callback: BodyResponseCallback<Schema$Testers>): void;
        get(callback: BodyResponseCallback<Schema$Testers>): void;
        /**
         * androidpublisher.edits.testers.patch
         * @alias androidpublisher.edits.testers.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {string} params.track The track to read or modify. Acceptable values are: "alpha", "beta", "production", "rollout" or "internal".
         * @param {().Testers} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Edits$Testers$Patch, options?: MethodOptions): AxiosPromise<Schema$Testers>;
        patch(params: Params$Resource$Edits$Testers$Patch, options: MethodOptions | BodyResponseCallback<Schema$Testers>, callback: BodyResponseCallback<Schema$Testers>): void;
        patch(params: Params$Resource$Edits$Testers$Patch, callback: BodyResponseCallback<Schema$Testers>): void;
        patch(callback: BodyResponseCallback<Schema$Testers>): void;
        /**
         * androidpublisher.edits.testers.update
         * @alias androidpublisher.edits.testers.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {string} params.track The track to read or modify. Acceptable values are: "alpha", "beta", "production", "rollout" or "internal".
         * @param {().Testers} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Edits$Testers$Update, options?: MethodOptions): AxiosPromise<Schema$Testers>;
        update(params: Params$Resource$Edits$Testers$Update, options: MethodOptions | BodyResponseCallback<Schema$Testers>, callback: BodyResponseCallback<Schema$Testers>): void;
        update(params: Params$Resource$Edits$Testers$Update, callback: BodyResponseCallback<Schema$Testers>): void;
        update(callback: BodyResponseCallback<Schema$Testers>): void;
    }
    interface Params$Resource$Edits$Testers$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * The track to read or modify. Acceptable values are: "alpha", "beta",
         * "production", "rollout" or "internal".
         */
        track?: string;
    }
    interface Params$Resource$Edits$Testers$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * The track to read or modify. Acceptable values are: "alpha", "beta",
         * "production", "rollout" or "internal".
         */
        track?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Testers;
    }
    interface Params$Resource$Edits$Testers$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * The track to read or modify. Acceptable values are: "alpha", "beta",
         * "production", "rollout" or "internal".
         */
        track?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Testers;
    }
    class Resource$Edits$Tracks {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.edits.tracks.get
         * @desc Fetches the track configuration for the specified track type.
         * Includes the APK version codes that are in this track.
         * @alias androidpublisher.edits.tracks.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {string} params.track The track to read or modify.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Edits$Tracks$Get, options?: MethodOptions): AxiosPromise<Schema$Track>;
        get(params: Params$Resource$Edits$Tracks$Get, options: MethodOptions | BodyResponseCallback<Schema$Track>, callback: BodyResponseCallback<Schema$Track>): void;
        get(params: Params$Resource$Edits$Tracks$Get, callback: BodyResponseCallback<Schema$Track>): void;
        get(callback: BodyResponseCallback<Schema$Track>): void;
        /**
         * androidpublisher.edits.tracks.list
         * @desc Lists all the track configurations for this edit.
         * @alias androidpublisher.edits.tracks.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Edits$Tracks$List, options?: MethodOptions): AxiosPromise<Schema$TracksListResponse>;
        list(params: Params$Resource$Edits$Tracks$List, options: MethodOptions | BodyResponseCallback<Schema$TracksListResponse>, callback: BodyResponseCallback<Schema$TracksListResponse>): void;
        list(params: Params$Resource$Edits$Tracks$List, callback: BodyResponseCallback<Schema$TracksListResponse>): void;
        list(callback: BodyResponseCallback<Schema$TracksListResponse>): void;
        /**
         * androidpublisher.edits.tracks.patch
         * @desc Updates the track configuration for the specified track type. When
         * halted, the rollout track cannot be updated without adding new APKs, and
         * adding new APKs will cause it to resume. This method supports patch
         * semantics.
         * @alias androidpublisher.edits.tracks.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {string} params.track The track to read or modify.
         * @param {().Track} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Edits$Tracks$Patch, options?: MethodOptions): AxiosPromise<Schema$Track>;
        patch(params: Params$Resource$Edits$Tracks$Patch, options: MethodOptions | BodyResponseCallback<Schema$Track>, callback: BodyResponseCallback<Schema$Track>): void;
        patch(params: Params$Resource$Edits$Tracks$Patch, callback: BodyResponseCallback<Schema$Track>): void;
        patch(callback: BodyResponseCallback<Schema$Track>): void;
        /**
         * androidpublisher.edits.tracks.update
         * @desc Updates the track configuration for the specified track type. When
         * halted, the rollout track cannot be updated without adding new APKs, and
         * adding new APKs will cause it to resume.
         * @alias androidpublisher.edits.tracks.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.editId Unique identifier for this edit.
         * @param {string} params.packageName Unique identifier for the Android app that is being updated; for example, "com.spiffygame".
         * @param {string} params.track The track to read or modify.
         * @param {().Track} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Edits$Tracks$Update, options?: MethodOptions): AxiosPromise<Schema$Track>;
        update(params: Params$Resource$Edits$Tracks$Update, options: MethodOptions | BodyResponseCallback<Schema$Track>, callback: BodyResponseCallback<Schema$Track>): void;
        update(params: Params$Resource$Edits$Tracks$Update, callback: BodyResponseCallback<Schema$Track>): void;
        update(callback: BodyResponseCallback<Schema$Track>): void;
    }
    interface Params$Resource$Edits$Tracks$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * The track to read or modify.
         */
        track?: string;
    }
    interface Params$Resource$Edits$Tracks$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
    }
    interface Params$Resource$Edits$Tracks$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * The track to read or modify.
         */
        track?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Track;
    }
    interface Params$Resource$Edits$Tracks$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for this edit.
         */
        editId?: string;
        /**
         * Unique identifier for the Android app that is being updated; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         * The track to read or modify.
         */
        track?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$Track;
    }
    class Resource$Inappproducts {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.inappproducts.delete
         * @desc Delete an in-app product for an app.
         * @alias androidpublisher.inappproducts.delete
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName Unique identifier for the Android app with the in-app product; for example, "com.spiffygame".
         * @param {string} params.sku Unique identifier for the in-app product.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete(params?: Params$Resource$Inappproducts$Delete, options?: MethodOptions): AxiosPromise<void>;
        delete(params: Params$Resource$Inappproducts$Delete, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        delete(params: Params$Resource$Inappproducts$Delete, callback: BodyResponseCallback<void>): void;
        delete(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.inappproducts.get
         * @desc Returns information about the in-app product specified.
         * @alias androidpublisher.inappproducts.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName
         * @param {string} params.sku Unique identifier for the in-app product.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Inappproducts$Get, options?: MethodOptions): AxiosPromise<Schema$InAppProduct>;
        get(params: Params$Resource$Inappproducts$Get, options: MethodOptions | BodyResponseCallback<Schema$InAppProduct>, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        get(params: Params$Resource$Inappproducts$Get, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        get(callback: BodyResponseCallback<Schema$InAppProduct>): void;
        /**
         * androidpublisher.inappproducts.insert
         * @desc Creates a new in-app product for an app.
         * @alias androidpublisher.inappproducts.insert
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {boolean=} params.autoConvertMissingPrices If true the prices for all regions targeted by the parent app that don't have a price specified for this in-app product will be auto converted to the target currency based on the default price. Defaults to false.
         * @param {string} params.packageName Unique identifier for the Android app; for example, "com.spiffygame".
         * @param {().InAppProduct} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert(params?: Params$Resource$Inappproducts$Insert, options?: MethodOptions): AxiosPromise<Schema$InAppProduct>;
        insert(params: Params$Resource$Inappproducts$Insert, options: MethodOptions | BodyResponseCallback<Schema$InAppProduct>, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        insert(params: Params$Resource$Inappproducts$Insert, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        insert(callback: BodyResponseCallback<Schema$InAppProduct>): void;
        /**
         * androidpublisher.inappproducts.list
         * @desc List all the in-app products for an Android app, both subscriptions
         * and managed in-app products..
         * @alias androidpublisher.inappproducts.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.maxResults
         * @param {string} params.packageName Unique identifier for the Android app with in-app products; for example, "com.spiffygame".
         * @param {integer=} params.startIndex
         * @param {string=} params.token
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Inappproducts$List, options?: MethodOptions): AxiosPromise<Schema$InappproductsListResponse>;
        list(params: Params$Resource$Inappproducts$List, options: MethodOptions | BodyResponseCallback<Schema$InappproductsListResponse>, callback: BodyResponseCallback<Schema$InappproductsListResponse>): void;
        list(params: Params$Resource$Inappproducts$List, callback: BodyResponseCallback<Schema$InappproductsListResponse>): void;
        list(callback: BodyResponseCallback<Schema$InappproductsListResponse>): void;
        /**
         * androidpublisher.inappproducts.patch
         * @desc Updates the details of an in-app product. This method supports
         * patch semantics.
         * @alias androidpublisher.inappproducts.patch
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {boolean=} params.autoConvertMissingPrices If true the prices for all regions targeted by the parent app that don't have a price specified for this in-app product will be auto converted to the target currency based on the default price. Defaults to false.
         * @param {string} params.packageName Unique identifier for the Android app with the in-app product; for example, "com.spiffygame".
         * @param {string} params.sku Unique identifier for the in-app product.
         * @param {().InAppProduct} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        patch(params?: Params$Resource$Inappproducts$Patch, options?: MethodOptions): AxiosPromise<Schema$InAppProduct>;
        patch(params: Params$Resource$Inappproducts$Patch, options: MethodOptions | BodyResponseCallback<Schema$InAppProduct>, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        patch(params: Params$Resource$Inappproducts$Patch, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        patch(callback: BodyResponseCallback<Schema$InAppProduct>): void;
        /**
         * androidpublisher.inappproducts.update
         * @desc Updates the details of an in-app product.
         * @alias androidpublisher.inappproducts.update
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {boolean=} params.autoConvertMissingPrices If true the prices for all regions targeted by the parent app that don't have a price specified for this in-app product will be auto converted to the target currency based on the default price. Defaults to false.
         * @param {string} params.packageName Unique identifier for the Android app with the in-app product; for example, "com.spiffygame".
         * @param {string} params.sku Unique identifier for the in-app product.
         * @param {().InAppProduct} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        update(params?: Params$Resource$Inappproducts$Update, options?: MethodOptions): AxiosPromise<Schema$InAppProduct>;
        update(params: Params$Resource$Inappproducts$Update, options: MethodOptions | BodyResponseCallback<Schema$InAppProduct>, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        update(params: Params$Resource$Inappproducts$Update, callback: BodyResponseCallback<Schema$InAppProduct>): void;
        update(callback: BodyResponseCallback<Schema$InAppProduct>): void;
    }
    interface Params$Resource$Inappproducts$Delete {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for the Android app with the in-app product; for
         * example, "com.spiffygame".
         */
        packageName?: string;
        /**
         * Unique identifier for the in-app product.
         */
        sku?: string;
    }
    interface Params$Resource$Inappproducts$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         *
         */
        packageName?: string;
        /**
         * Unique identifier for the in-app product.
         */
        sku?: string;
    }
    interface Params$Resource$Inappproducts$Insert {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * If true the prices for all regions targeted by the parent app that don't
         * have a price specified for this in-app product will be auto converted to
         * the target currency based on the default price. Defaults to false.
         */
        autoConvertMissingPrices?: boolean;
        /**
         * Unique identifier for the Android app; for example, "com.spiffygame".
         */
        packageName?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$InAppProduct;
    }
    interface Params$Resource$Inappproducts$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         *
         */
        maxResults?: number;
        /**
         * Unique identifier for the Android app with in-app products; for example,
         * "com.spiffygame".
         */
        packageName?: string;
        /**
         *
         */
        startIndex?: number;
        /**
         *
         */
        token?: string;
    }
    interface Params$Resource$Inappproducts$Patch {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * If true the prices for all regions targeted by the parent app that don't
         * have a price specified for this in-app product will be auto converted to
         * the target currency based on the default price. Defaults to false.
         */
        autoConvertMissingPrices?: boolean;
        /**
         * Unique identifier for the Android app with the in-app product; for
         * example, "com.spiffygame".
         */
        packageName?: string;
        /**
         * Unique identifier for the in-app product.
         */
        sku?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$InAppProduct;
    }
    interface Params$Resource$Inappproducts$Update {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * If true the prices for all regions targeted by the parent app that don't
         * have a price specified for this in-app product will be auto converted to
         * the target currency based on the default price. Defaults to false.
         */
        autoConvertMissingPrices?: boolean;
        /**
         * Unique identifier for the Android app with the in-app product; for
         * example, "com.spiffygame".
         */
        packageName?: string;
        /**
         * Unique identifier for the in-app product.
         */
        sku?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$InAppProduct;
    }
    class Resource$Orders {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.orders.refund
         * @desc Refund a user's subscription or in-app purchase order.
         * @alias androidpublisher.orders.refund
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.orderId The order ID provided to the user when the subscription or in-app order was purchased.
         * @param {string} params.packageName The package name of the application for which this subscription or in-app item was purchased (for example, 'com.some.thing').
         * @param {boolean=} params.revoke Whether to revoke the purchased item. If set to true, access to the subscription or in-app item will be terminated immediately. If the item is a recurring subscription, all future payments will also be terminated. Consumed in-app items need to be handled by developer's app. (optional)
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        refund(params?: Params$Resource$Orders$Refund, options?: MethodOptions): AxiosPromise<void>;
        refund(params: Params$Resource$Orders$Refund, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        refund(params: Params$Resource$Orders$Refund, callback: BodyResponseCallback<void>): void;
        refund(callback: BodyResponseCallback<void>): void;
    }
    interface Params$Resource$Orders$Refund {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The order ID provided to the user when the subscription or in-app order
         * was purchased.
         */
        orderId?: string;
        /**
         * The package name of the application for which this subscription or in-app
         * item was purchased (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * Whether to revoke the purchased item. If set to true, access to the
         * subscription or in-app item will be terminated immediately. If the item
         * is a recurring subscription, all future payments will also be terminated.
         * Consumed in-app items need to be handled by developer's app. (optional)
         */
        revoke?: boolean;
    }
    class Resource$Purchases {
        root: Androidpublisher;
        products: Resource$Purchases$Products;
        subscriptions: Resource$Purchases$Subscriptions;
        voidedpurchases: Resource$Purchases$Voidedpurchases;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
    }
    class Resource$Purchases$Products {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.purchases.products.get
         * @desc Checks the purchase and consumption status of an inapp item.
         * @alias androidpublisher.purchases.products.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName The package name of the application the inapp product was sold in (for example, 'com.some.thing').
         * @param {string} params.productId The inapp product SKU (for example, 'com.some.thing.inapp1').
         * @param {string} params.token The token provided to the user's device when the inapp product was purchased.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Purchases$Products$Get, options?: MethodOptions): AxiosPromise<Schema$ProductPurchase>;
        get(params: Params$Resource$Purchases$Products$Get, options: MethodOptions | BodyResponseCallback<Schema$ProductPurchase>, callback: BodyResponseCallback<Schema$ProductPurchase>): void;
        get(params: Params$Resource$Purchases$Products$Get, callback: BodyResponseCallback<Schema$ProductPurchase>): void;
        get(callback: BodyResponseCallback<Schema$ProductPurchase>): void;
    }
    interface Params$Resource$Purchases$Products$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The package name of the application the inapp product was sold in (for
         * example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * The inapp product SKU (for example, 'com.some.thing.inapp1').
         */
        productId?: string;
        /**
         * The token provided to the user's device when the inapp product was
         * purchased.
         */
        token?: string;
    }
    class Resource$Purchases$Subscriptions {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.purchases.subscriptions.cancel
         * @desc Cancels a user's subscription purchase. The subscription remains
         * valid until its expiration time.
         * @alias androidpublisher.purchases.subscriptions.cancel
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName The package name of the application for which this subscription was purchased (for example, 'com.some.thing').
         * @param {string} params.subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param {string} params.token The token provided to the user's device when the subscription was purchased.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        cancel(params?: Params$Resource$Purchases$Subscriptions$Cancel, options?: MethodOptions): AxiosPromise<void>;
        cancel(params: Params$Resource$Purchases$Subscriptions$Cancel, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        cancel(params: Params$Resource$Purchases$Subscriptions$Cancel, callback: BodyResponseCallback<void>): void;
        cancel(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.purchases.subscriptions.defer
         * @desc Defers a user's subscription purchase until a specified future
         * expiration time.
         * @alias androidpublisher.purchases.subscriptions.defer
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName The package name of the application for which this subscription was purchased (for example, 'com.some.thing').
         * @param {string} params.subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param {string} params.token The token provided to the user's device when the subscription was purchased.
         * @param {().SubscriptionPurchasesDeferRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        defer(params?: Params$Resource$Purchases$Subscriptions$Defer, options?: MethodOptions): AxiosPromise<Schema$SubscriptionPurchasesDeferResponse>;
        defer(params: Params$Resource$Purchases$Subscriptions$Defer, options: MethodOptions | BodyResponseCallback<Schema$SubscriptionPurchasesDeferResponse>, callback: BodyResponseCallback<Schema$SubscriptionPurchasesDeferResponse>): void;
        defer(params: Params$Resource$Purchases$Subscriptions$Defer, callback: BodyResponseCallback<Schema$SubscriptionPurchasesDeferResponse>): void;
        defer(callback: BodyResponseCallback<Schema$SubscriptionPurchasesDeferResponse>): void;
        /**
         * androidpublisher.purchases.subscriptions.get
         * @desc Checks whether a user's subscription purchase is valid and returns
         * its expiry time.
         * @alias androidpublisher.purchases.subscriptions.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName The package name of the application for which this subscription was purchased (for example, 'com.some.thing').
         * @param {string} params.subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param {string} params.token The token provided to the user's device when the subscription was purchased.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Purchases$Subscriptions$Get, options?: MethodOptions): AxiosPromise<Schema$SubscriptionPurchase>;
        get(params: Params$Resource$Purchases$Subscriptions$Get, options: MethodOptions | BodyResponseCallback<Schema$SubscriptionPurchase>, callback: BodyResponseCallback<Schema$SubscriptionPurchase>): void;
        get(params: Params$Resource$Purchases$Subscriptions$Get, callback: BodyResponseCallback<Schema$SubscriptionPurchase>): void;
        get(callback: BodyResponseCallback<Schema$SubscriptionPurchase>): void;
        /**
         * androidpublisher.purchases.subscriptions.refund
         * @desc Refunds a user's subscription purchase, but the subscription
         * remains valid until its expiration time and it will continue to recur.
         * @alias androidpublisher.purchases.subscriptions.refund
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName The package name of the application for which this subscription was purchased (for example, 'com.some.thing').
         * @param {string} params.subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param {string} params.token The token provided to the user's device when the subscription was purchased.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        refund(params?: Params$Resource$Purchases$Subscriptions$Refund, options?: MethodOptions): AxiosPromise<void>;
        refund(params: Params$Resource$Purchases$Subscriptions$Refund, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        refund(params: Params$Resource$Purchases$Subscriptions$Refund, callback: BodyResponseCallback<void>): void;
        refund(callback: BodyResponseCallback<void>): void;
        /**
         * androidpublisher.purchases.subscriptions.revoke
         * @desc Refunds and immediately revokes a user's subscription purchase.
         * Access to the subscription will be terminated immediately and it will
         * stop recurring.
         * @alias androidpublisher.purchases.subscriptions.revoke
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName The package name of the application for which this subscription was purchased (for example, 'com.some.thing').
         * @param {string} params.subscriptionId The purchased subscription ID (for example, 'monthly001').
         * @param {string} params.token The token provided to the user's device when the subscription was purchased.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        revoke(params?: Params$Resource$Purchases$Subscriptions$Revoke, options?: MethodOptions): AxiosPromise<void>;
        revoke(params: Params$Resource$Purchases$Subscriptions$Revoke, options: MethodOptions | BodyResponseCallback<void>, callback: BodyResponseCallback<void>): void;
        revoke(params: Params$Resource$Purchases$Subscriptions$Revoke, callback: BodyResponseCallback<void>): void;
        revoke(callback: BodyResponseCallback<void>): void;
    }
    interface Params$Resource$Purchases$Subscriptions$Cancel {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The package name of the application for which this subscription was
         * purchased (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * The purchased subscription ID (for example, 'monthly001').
         */
        subscriptionId?: string;
        /**
         * The token provided to the user's device when the subscription was
         * purchased.
         */
        token?: string;
    }
    interface Params$Resource$Purchases$Subscriptions$Defer {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The package name of the application for which this subscription was
         * purchased (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * The purchased subscription ID (for example, 'monthly001').
         */
        subscriptionId?: string;
        /**
         * The token provided to the user's device when the subscription was
         * purchased.
         */
        token?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SubscriptionPurchasesDeferRequest;
    }
    interface Params$Resource$Purchases$Subscriptions$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The package name of the application for which this subscription was
         * purchased (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * The purchased subscription ID (for example, 'monthly001').
         */
        subscriptionId?: string;
        /**
         * The token provided to the user's device when the subscription was
         * purchased.
         */
        token?: string;
    }
    interface Params$Resource$Purchases$Subscriptions$Refund {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The package name of the application for which this subscription was
         * purchased (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * The purchased subscription ID (for example, 'monthly001').
         */
        subscriptionId?: string;
        /**
         * The token provided to the user's device when the subscription was
         * purchased.
         */
        token?: string;
    }
    interface Params$Resource$Purchases$Subscriptions$Revoke {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The package name of the application for which this subscription was
         * purchased (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         * The purchased subscription ID (for example, 'monthly001').
         */
        subscriptionId?: string;
        /**
         * The token provided to the user's device when the subscription was
         * purchased.
         */
        token?: string;
    }
    class Resource$Purchases$Voidedpurchases {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.purchases.voidedpurchases.list
         * @desc Lists the purchases that were canceled, refunded or charged-back.
         * @alias androidpublisher.purchases.voidedpurchases.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string=} params.endTime The time, in milliseconds since the Epoch, of the newest voided in-app product purchase that you want to see in the response. The value of this parameter cannot be greater than the current time and is ignored if a pagination token is set. Default value is current time. Note: This filter is applied on the time at which the record is seen as voided by our systems and not the actual voided time returned in the response.
         * @param {integer=} params.maxResults
         * @param {string} params.packageName The package name of the application for which voided purchases need to be returned (for example, 'com.some.thing').
         * @param {integer=} params.startIndex
         * @param {string=} params.startTime The time, in milliseconds since the Epoch, of the oldest voided in-app product purchase that you want to see in the response. The value of this parameter cannot be older than 30 days and is ignored if a pagination token is set. Default value is current time minus 30 days. Note: This filter is applied on the time at which the record is seen as voided by our systems and not the actual voided time returned in the response.
         * @param {string=} params.token
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Purchases$Voidedpurchases$List, options?: MethodOptions): AxiosPromise<Schema$VoidedPurchasesListResponse>;
        list(params: Params$Resource$Purchases$Voidedpurchases$List, options: MethodOptions | BodyResponseCallback<Schema$VoidedPurchasesListResponse>, callback: BodyResponseCallback<Schema$VoidedPurchasesListResponse>): void;
        list(params: Params$Resource$Purchases$Voidedpurchases$List, callback: BodyResponseCallback<Schema$VoidedPurchasesListResponse>): void;
        list(callback: BodyResponseCallback<Schema$VoidedPurchasesListResponse>): void;
    }
    interface Params$Resource$Purchases$Voidedpurchases$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * The time, in milliseconds since the Epoch, of the newest voided in-app
         * product purchase that you want to see in the response. The value of this
         * parameter cannot be greater than the current time and is ignored if a
         * pagination token is set. Default value is current time. Note: This filter
         * is applied on the time at which the record is seen as voided by our
         * systems and not the actual voided time returned in the response.
         */
        endTime?: string;
        /**
         *
         */
        maxResults?: number;
        /**
         * The package name of the application for which voided purchases need to be
         * returned (for example, 'com.some.thing').
         */
        packageName?: string;
        /**
         *
         */
        startIndex?: number;
        /**
         * The time, in milliseconds since the Epoch, of the oldest voided in-app
         * product purchase that you want to see in the response. The value of this
         * parameter cannot be older than 30 days and is ignored if a pagination
         * token is set. Default value is current time minus 30 days. Note: This
         * filter is applied on the time at which the record is seen as voided by
         * our systems and not the actual voided time returned in the response.
         */
        startTime?: string;
        /**
         *
         */
        token?: string;
    }
    class Resource$Reviews {
        root: Androidpublisher;
        constructor(root: Androidpublisher);
        getRoot(): Androidpublisher;
        /**
         * androidpublisher.reviews.get
         * @desc Returns a single review.
         * @alias androidpublisher.reviews.get
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName Unique identifier for the Android app for which we want reviews; for example, "com.spiffygame".
         * @param {string} params.reviewId
         * @param {string=} params.translationLanguage
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get(params?: Params$Resource$Reviews$Get, options?: MethodOptions): AxiosPromise<Schema$Review>;
        get(params: Params$Resource$Reviews$Get, options: MethodOptions | BodyResponseCallback<Schema$Review>, callback: BodyResponseCallback<Schema$Review>): void;
        get(params: Params$Resource$Reviews$Get, callback: BodyResponseCallback<Schema$Review>): void;
        get(callback: BodyResponseCallback<Schema$Review>): void;
        /**
         * androidpublisher.reviews.list
         * @desc Returns a list of reviews. Only reviews from last week will be
         * returned.
         * @alias androidpublisher.reviews.list
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.maxResults
         * @param {string} params.packageName Unique identifier for the Android app for which we want reviews; for example, "com.spiffygame".
         * @param {integer=} params.startIndex
         * @param {string=} params.token
         * @param {string=} params.translationLanguage
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list(params?: Params$Resource$Reviews$List, options?: MethodOptions): AxiosPromise<Schema$ReviewsListResponse>;
        list(params: Params$Resource$Reviews$List, options: MethodOptions | BodyResponseCallback<Schema$ReviewsListResponse>, callback: BodyResponseCallback<Schema$ReviewsListResponse>): void;
        list(params: Params$Resource$Reviews$List, callback: BodyResponseCallback<Schema$ReviewsListResponse>): void;
        list(callback: BodyResponseCallback<Schema$ReviewsListResponse>): void;
        /**
         * androidpublisher.reviews.reply
         * @desc Reply to a single review, or update an existing reply.
         * @alias androidpublisher.reviews.reply
         * @memberOf! ()
         *
         * @param {object} params Parameters for request
         * @param {string} params.packageName Unique identifier for the Android app for which we want reviews; for example, "com.spiffygame".
         * @param {string} params.reviewId
         * @param {().ReviewsReplyRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        reply(params?: Params$Resource$Reviews$Reply, options?: MethodOptions): AxiosPromise<Schema$ReviewsReplyResponse>;
        reply(params: Params$Resource$Reviews$Reply, options: MethodOptions | BodyResponseCallback<Schema$ReviewsReplyResponse>, callback: BodyResponseCallback<Schema$ReviewsReplyResponse>): void;
        reply(params: Params$Resource$Reviews$Reply, callback: BodyResponseCallback<Schema$ReviewsReplyResponse>): void;
        reply(callback: BodyResponseCallback<Schema$ReviewsReplyResponse>): void;
    }
    interface Params$Resource$Reviews$Get {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for the Android app for which we want reviews; for
         * example, "com.spiffygame".
         */
        packageName?: string;
        /**
         *
         */
        reviewId?: string;
        /**
         *
         */
        translationLanguage?: string;
    }
    interface Params$Resource$Reviews$List {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         *
         */
        maxResults?: number;
        /**
         * Unique identifier for the Android app for which we want reviews; for
         * example, "com.spiffygame".
         */
        packageName?: string;
        /**
         *
         */
        startIndex?: number;
        /**
         *
         */
        token?: string;
        /**
         *
         */
        translationLanguage?: string;
    }
    interface Params$Resource$Reviews$Reply {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient;
        /**
         * Unique identifier for the Android app for which we want reviews; for
         * example, "com.spiffygame".
         */
        packageName?: string;
        /**
         *
         */
        reviewId?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$ReviewsReplyRequest;
    }
}
