"use strict";
/**
 * Copyright 2015 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const src_1 = require("../../shared/src");
// tslint:disable: no-any
// tslint:disable: class-name
// tslint:disable: variable-name
// tslint:disable: jsdoc-format
// tslint:disable: no-namespace
var poly_v1;
(function (poly_v1) {
    /**
     * Poly API
     *
     * The Poly API provides read-only access to assets hosted on &lt;a
     * href=&quot;https://poly.google.com&quot;&gt;poly.google.com&lt;/a&gt;.
     *
     * @example
     * const {google} = require('googleapis');
     * const poly = google.poly('v1');
     *
     * @namespace poly
     * @type {Function}
     * @version v1
     * @variation v1
     * @param {object=} options Options for Poly
     */
    class Poly {
        constructor(options, google) {
            this.root = this;
            this._options = options || {};
            this.google = google;
            this.getRoot.bind(this);
            this.assets = new Resource$Assets(this);
            this.users = new Resource$Users(this);
        }
        getRoot() {
            return this.root;
        }
    }
    poly_v1.Poly = Poly;
    class Resource$Assets {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        get(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://poly.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://poly.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/assets').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: [],
                pathParams: [],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    poly_v1.Resource$Assets = Resource$Assets;
    class Resource$Users {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
            this.assets = new Resource$Users$Assets(root);
            this.likedassets = new Resource$Users$Likedassets(root);
        }
        getRoot() {
            return this.root;
        }
    }
    poly_v1.Resource$Users = Resource$Users;
    class Resource$Users$Assets {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://poly.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}/assets')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    poly_v1.Resource$Users$Assets = Resource$Users$Assets;
    class Resource$Users$Likedassets {
        constructor(root) {
            this.root = root;
            this.getRoot.bind(this);
        }
        getRoot() {
            return this.root;
        }
        list(paramsOrCallback, optionsOrCallback, callback) {
            let params = (paramsOrCallback || {});
            let options = (optionsOrCallback || {});
            if (typeof paramsOrCallback === 'function') {
                callback = paramsOrCallback;
                params = {};
                options = {};
            }
            if (typeof optionsOrCallback === 'function') {
                callback = optionsOrCallback;
                options = {};
            }
            const rootUrl = options.rootUrl || 'https://poly.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/v1/{+name}/likedassets')
                        .replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params,
                requiredParams: ['name'],
                pathParams: ['name'],
                context: this.getRoot()
            };
            if (callback) {
                src_1.createAPIRequest(parameters, callback);
            }
            else {
                return src_1.createAPIRequest(parameters);
            }
        }
    }
    poly_v1.Resource$Users$Likedassets = Resource$Users$Likedassets;
})(poly_v1 = exports.poly_v1 || (exports.poly_v1 = {}));
//# sourceMappingURL=v1.js.map