/// <reference types="node" />
import EventEmitter = require('events');
import { ProxyStream } from './as-stream';
import { GotError } from './errors';
import { NormalizedOptions } from './utils/types';
export interface RequestAsEventEmitter extends EventEmitter {
    retry: <T extends GotError>(error: T) => boolean;
    abort: () => void;
}
declare const _default: (options: NormalizedOptions) => RequestAsEventEmitter;
export default _default;
export declare const proxyEvents: (proxy: EventEmitter | ProxyStream<unknown>, emitter: RequestAsEventEmitter) => void;
