/// <reference types="node" />
import PCancelable from 'p-cancelable';
import { RequestError } from '../core/errors.js';
import type Request from '../core/index.js';
import type { RequestEvents } from '../core/index.js';
import type { Response } from '../core/response.js';
/**
An error to be thrown when the request is aborted with `.cancel()`.
*/
export declare class CancelError extends RequestError {
    readonly response: Response;
    constructor(request: Request);
    get isCanceled(): boolean;
}
export interface CancelableRequest<T extends Response | Response['body'] = Response['body']> extends PCancelable<T>, RequestEvents<CancelableRequest<T>> {
    json: <ReturnType>() => CancelableRequest<ReturnType>;
    buffer: () => CancelableRequest<Buffer>;
    text: () => CancelableRequest<string>;
}
