(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define('GOVUKFrontend', ['exports'], factory) :
	(factory((global.GOVUKFrontend = {})));
}(this, (function (exports) { 'use strict';

	(function(undefined) {

	// Detection from https://github.com/Financial-Times/polyfill-service/blob/master/packages/polyfill-library/polyfills/Object/defineProperty/detect.js
	var detect = (
	  // In IE8, defineProperty could only act on DOM elements, so full support
	  // for the feature requires the ability to set a property on an arbitrary object
	  'defineProperty' in Object && (function() {
	  	try {
	  		var a = {};
	  		Object.defineProperty(a, 'test', {value:42});
	  		return true;
	  	} catch(e) {
	  		return false
	  	}
	  }())
	);

	if (detect) return

	// Polyfill from https://cdn.polyfill.io/v2/polyfill.js?features=Object.defineProperty&flags=always
	(function (nativeDefineProperty) {

		var supportsAccessors = Object.prototype.hasOwnProperty('__defineGetter__');
		var ERR_ACCESSORS_NOT_SUPPORTED = 'Getters & setters cannot be defined on this javascript engine';
		var ERR_VALUE_ACCESSORS = 'A property cannot both have accessors and be writable or have a value';

		Object.defineProperty = function defineProperty(object, property, descriptor) {

			// Where native support exists, assume it
			if (nativeDefineProperty && (object === window || object === document || object === Element.prototype || object instanceof Element)) {
				return nativeDefineProperty(object, property, descriptor);
			}

			if (object === null || !(object instanceof Object || typeof object === 'object')) {
				throw new TypeError('Object.defineProperty called on non-object');
			}

			if (!(descriptor instanceof Object)) {
				throw new TypeError('Property description must be an object');
			}

			var propertyString = String(property);
			var hasValueOrWritable = 'value' in descriptor || 'writable' in descriptor;
			var getterType = 'get' in descriptor && typeof descriptor.get;
			var setterType = 'set' in descriptor && typeof descriptor.set;

			// handle descriptor.get
			if (getterType) {
				if (getterType !== 'function') {
					throw new TypeError('Getter must be a function');
				}
				if (!supportsAccessors) {
					throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);
				}
				if (hasValueOrWritable) {
					throw new TypeError(ERR_VALUE_ACCESSORS);
				}
				Object.__defineGetter__.call(object, propertyString, descriptor.get);
			} else {
				object[propertyString] = descriptor.value;
			}

			// handle descriptor.set
			if (setterType) {
				if (setterType !== 'function') {
					throw new TypeError('Setter must be a function');
				}
				if (!supportsAccessors) {
					throw new TypeError(ERR_ACCESSORS_NOT_SUPPORTED);
				}
				if (hasValueOrWritable) {
					throw new TypeError(ERR_VALUE_ACCESSORS);
				}
				Object.__defineSetter__.call(object, propertyString, descriptor.set);
			}

			// OK to define value unconditionally - if a getter has been specified as well, an error would be thrown above
			if ('value' in descriptor) {
				object[propertyString] = descriptor.value;
			}

			return object;
		};
	}(Object.defineProperty));
	})
	.call('object' === typeof window && window || 'object' === typeof self && self || 'object' === typeof global && global || {});

	(function(undefined) {

	// Detection from https://github.com/Financial-Times/polyfill-service/blob/master/packages/polyfill-library/polyfills/Document/detect.js
	var detect = ("Document" in this);

	if (detect) return

	// Polyfill from https://cdn.polyfill.io/v2/polyfill.js?features=Document&flags=always
	if ((typeof WorkerGlobalScope === "undefined") && (typeof importScripts !== "function")) {

		if (this.HTMLDocument) { // IE8

			// HTMLDocument is an extension of Document.  If the browser has HTMLDocument but not Document, the former will suffice as an alias for the latter.
			this.Document = this.HTMLDocument;

		} else {

			// Create an empty function to act as the missing constructor for the document object, attach the document object as its prototype.  The function needs to be anonymous else it is hoisted and causes the feature detect to prematurely pass, preventing the assignments below being made.
			this.Document = this.HTMLDocument = document.constructor = (new Function('return function Document() {}')());
			this.Document.prototype = document;
		}
	}


	})
	.call('object' === typeof window && window || 'object' === typeof self && self || 'object' === typeof global && global || {});

	(function(undefined) {

	// Detection from https://github.com/Financial-Times/polyfill-service/blob/master/packages/polyfill-library/polyfills/Element/detect.js
	var detect = ('Element' in this && 'HTMLElement' in this);

	if (detect) return

	// Polyfill from https://cdn.polyfill.io/v2/polyfill.js?features=Element&flags=always
	(function () {

		// IE8
		if (window.Element && !window.HTMLElement) {
			window.HTMLElement = window.Element;
			return;
		}

		// create Element constructor
		window.Element = window.HTMLElement = new Function('return function Element() {}')();

		// generate sandboxed iframe
		var vbody = document.appendChild(document.createElement('body'));
		var frame = vbody.appendChild(document.createElement('iframe'));

		// use sandboxed iframe to replicate Element functionality
		var frameDocument = frame.contentWindow.document;
		var prototype = Element.prototype = frameDocument.appendChild(frameDocument.createElement('*'));
		var cache = {};

		// polyfill Element.prototype on an element
		var shiv = function (element, deep) {
			var
			childNodes = element.childNodes || [],
			index = -1,
			key, value, childNode;

			if (element.nodeType === 1 && element.constructor !== Element) {
				element.constructor = Element;

				for (key in cache) {
					value = cache[key];
					element[key] = value;
				}
			}

			while (childNode = deep && childNodes[++index]) {
				shiv(childNode, deep);
			}

			return element;
		};

		var elements = document.getElementsByTagName('*');
		var nativeCreateElement = document.createElement;
		var interval;
		var loopLimit = 100;

		prototype.attachEvent('onpropertychange', function (event) {
			var
			propertyName = event.propertyName,
			nonValue = !cache.hasOwnProperty(propertyName),
			newValue = prototype[propertyName],
			oldValue = cache[propertyName],
			index = -1,
			element;

			while (element = elements[++index]) {
				if (element.nodeType === 1) {
					if (nonValue || element[propertyName] === oldValue) {
						element[propertyName] = newValue;
					}
				}
			}

			cache[propertyName] = newValue;
		});

		prototype.constructor = Element;

		if (!prototype.hasAttribute) {
			// <Element>.hasAttribute
			prototype.hasAttribute = function hasAttribute(name) {
				return this.getAttribute(name) !== null;
			};
		}

		// Apply Element prototype to the pre-existing DOM as soon as the body element appears.
		function bodyCheck() {
			if (!(loopLimit--)) clearTimeout(interval);
			if (document.body && !document.body.prototype && /(complete|interactive)/.test(document.readyState)) {
				shiv(document, true);
				if (interval && document.body.prototype) clearTimeout(interval);
				return (!!document.body.prototype);
			}
			return false;
		}
		if (!bodyCheck()) {
			document.onreadystatechange = bodyCheck;
			interval = setInterval(bodyCheck, 25);
		}

		// Apply to any new elements created after load
		document.createElement = function createElement(nodeName) {
			var element = nativeCreateElement(String(nodeName).toLowerCase());
			return shiv(element);
		};

		// remove sandboxed iframe
		document.removeChild(vbody);
	}());

	})
	.call('object' === typeof window && window || 'object' === typeof self && self || 'object' === typeof global && global || {});

	(function(undefined) {

	  // Detection from https://raw.githubusercontent.com/Financial-Times/polyfill-library/13cf7c340974d128d557580b5e2dafcd1b1192d1/polyfills/Element/prototype/dataset/detect.js
	  var detect = (function(){
	    if (!document.documentElement.dataset) {
	      return false;
	    }
	    var el = document.createElement('div');
	    el.setAttribute("data-a-b", "c");
	    return el.dataset && el.dataset.aB == "c";
	  }());

	  if (detect) return

	  // Polyfill derived from  https://raw.githubusercontent.com/Financial-Times/polyfill-library/13cf7c340974d128d557580b5e2dafcd1b1192d1/polyfills/Element/prototype/dataset/polyfill.js
	  Object.defineProperty(Element.prototype, 'dataset', {
	    get: function() {
	      var element = this;
	      var attributes = this.attributes;
	      var map = {};
	  
	      for (var i = 0; i < attributes.length; i++) {
	        var attribute = attributes[i];
	  
	        // This regex has been edited from the original polyfill, to add
	        // support for period (.) separators in data-* attribute names. These
	        // are allowed in the HTML spec, but were not covered by the original
	        // polyfill's regex. We use periods in our i18n implementation.
	        if (attribute && attribute.name && (/^data-\w[.\w-]*$/).test(attribute.name)) {
	          var name = attribute.name;
	          var value = attribute.value;
	  
	          var propName = name.substr(5).replace(/-./g, function (prop) {
	            return prop.charAt(1).toUpperCase();
	          });
	          
	          // If this browser supports __defineGetter__ and __defineSetter__,
	          // continue using defineProperty. If not (like IE 8 and below), we use
	          // a hacky fallback which at least gives an object in the right format
	          if ('__defineGetter__' in Object.prototype && '__defineSetter__' in Object.prototype) {
	            Object.defineProperty(map, propName, {
	              enumerable: true,
	              get: function() {
	                return this.value;
	              }.bind({value: value || ''}),
	              set: function setter(name, value) {
	                if (typeof value !== 'undefined') {
	                  this.setAttribute(name, value);
	                } else {
	                  this.removeAttribute(name);
	                }
	              }.bind(element, name)
	            });
	          } else {
	            map[propName] = value;
	          }

	        }
	      }
	  
	      return map;
	    }
	  });

	}).call('object' === typeof window && window || 'object' === typeof self && self || 'object' === typeof global && global || {});

	(function(undefined) {

	    // Detection from https://github.com/mdn/content/blob/cf607d68522cd35ee7670782d3ee3a361eaef2e4/files/en-us/web/javascript/reference/global_objects/string/trim/index.md#polyfill
	    var detect = ('trim' in String.prototype);
	    
	    if (detect) return

	    // Polyfill from https://github.com/mdn/content/blob/cf607d68522cd35ee7670782d3ee3a361eaef2e4/files/en-us/web/javascript/reference/global_objects/string/trim/index.md#polyfill
	    String.prototype.trim = function () {
	        return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
	    };

	}).call('object' === typeof window && window || 'object' === typeof self && self || 'object' === typeof global && global || {});

	/* eslint-disable es-x/no-string-prototype-trim -- Polyfill imported */

	/**
	 * Normalise string
	 *
	 * 'If it looks like a duck, and it quacks like a duck…' 🦆
	 *
	 * If the passed value looks like a boolean or a number, convert it to a boolean
	 * or number.
	 *
	 * Designed to be used to convert config passed via data attributes (which are
	 * always strings) into something sensible.
	 *
	 * @param {string} value - The value to normalise
	 * @returns {string | boolean | number | undefined} Normalised data
	 */
	function normaliseString (value) {
	  if (typeof value !== 'string') {
	    return value
	  }

	  var trimmedValue = value.trim();

	  if (trimmedValue === 'true') {
	    return true
	  }

	  if (trimmedValue === 'false') {
	    return false
	  }

	  // Empty / whitespace-only strings are considered finite so we need to check
	  // the length of the trimmed string as well
	  if (trimmedValue.length > 0 && isFinite(trimmedValue)) {
	    return Number(trimmedValue)
	  }

	  return value
	}

	/**
	 * Normalise dataset
	 *
	 * Loop over an object and normalise each value using normaliseData function
	 *
	 * @param {DOMStringMap} dataset - HTML element dataset
	 * @returns {Object<string, unknown>} Normalised dataset
	 */
	function normaliseDataset (dataset) {
	  var out = {};

	  for (var key in dataset) {
	    out[key] = normaliseString(dataset[key]);
	  }

	  return out
	}

	exports.normaliseString = normaliseString;
	exports.normaliseDataset = normaliseDataset;

})));
//# sourceMappingURL=normalise-dataset.js.map
