const version="5.11.2";function getBreakpoint(t){const e=`--govuk-breakpoint-${t}`;return{property:e,value:window.getComputedStyle(document.documentElement).getPropertyValue(e)||void 0}}function setFocus(t,e={}){var i;const n=t.getAttribute("tabindex");function onBlur(){var i;null==(i=e.onBlur)||i.call(t),n||t.removeAttribute("tabindex")}n||t.setAttribute("tabindex","-1"),t.addEventListener("focus",(function(){t.addEventListener("blur",onBlur,{once:!0})}),{once:!0}),null==(i=e.onBeforeFocus)||i.call(t),t.focus()}function isSupported(t=document.body){return!!t&&t.classList.contains("govuk-frontend-supported")}function isObject(t){return!!t&&"object"==typeof t&&!function(t){return Array.isArray(t)}(t)}function isScope(t){return!!t&&(t instanceof Element||t instanceof Document)}function formatErrorMessage(Component,t){return`${Component.moduleName}: ${t}`}class GOVUKFrontendError extends Error{constructor(...t){super(...t),this.name="GOVUKFrontendError"}}class SupportError extends GOVUKFrontendError{constructor(t=document.body){const e="noModule"in HTMLScriptElement.prototype?'GOV.UK Frontend initialised without `<body class="govuk-frontend-supported">` from template `<script>` snippet':"GOV.UK Frontend is not supported in this browser";super(t?e:'GOV.UK Frontend initialised without `<script type="module">`'),this.name="SupportError"}}class ConfigError extends GOVUKFrontendError{constructor(...t){super(...t),this.name="ConfigError"}}class ElementError extends GOVUKFrontendError{constructor(t){let e="string"==typeof t?t:"";if(isObject(t)){const{component:i,identifier:n,element:s,expectedType:o}=t;e=n,e+=s?` is not of type ${null!=o?o:"HTMLElement"}`:" not found",i&&(e=formatErrorMessage(i,e))}super(e),this.name="ElementError"}}class InitError extends GOVUKFrontendError{constructor(t){super("string"==typeof t?t:formatErrorMessage(t,"Root element (`$root`) already initialised")),this.name="InitError"}}class Component{get $root(){return this._$root}constructor(t){this._$root=void 0;const e=this.constructor;if("string"!=typeof e.moduleName)throw new InitError("`moduleName` not defined in component");if(!(t instanceof e.elementType))throw new ElementError({element:t,component:e,identifier:"Root element (`$root`)",expectedType:e.elementType.name});this._$root=t,e.checkSupport(),this.checkInitialised();const i=e.moduleName;this.$root.setAttribute(`data-${i}-init`,"")}checkInitialised(){const t=this.constructor,e=t.moduleName;if(e&&function(t,e){return t instanceof HTMLElement&&t.hasAttribute(`data-${e}-init`)}(this.$root,e))throw new InitError(t)}static checkSupport(){if(!isSupported())throw new SupportError}}Component.elementType=HTMLElement;const t=Symbol.for("configOverride");class ConfigurableComponent extends Component{[t](t){return{}}get config(){return this._config}constructor(e,i){super(e),this._config=void 0;const n=this.constructor;if(!isObject(n.defaults))throw new ConfigError(formatErrorMessage(n,"Config passed as parameter into constructor but no defaults defined"));const s=function(Component,t){if(!isObject(Component.schema))throw new ConfigError(formatErrorMessage(Component,"Config passed as parameter into constructor but no schema defined"));const e={},i=Object.entries(Component.schema.properties);for(const n of i){const[i,s]=n,o=i.toString();o in t&&(e[o]=normaliseString(t[o],s)),"object"===(null==s?void 0:s.type)&&(e[o]=extractConfigByNamespace(Component.schema,t,i))}return e}(n,this._$root.dataset);this._config=mergeConfigs(n.defaults,null!=i?i:{},this[t](s),s)}}function normaliseString(t,e){const i=t?t.trim():"";let n,s=null==e?void 0:e.type;switch(s||(["true","false"].includes(i)&&(s="boolean"),i.length>0&&isFinite(Number(i))&&(s="number")),s){case"boolean":n="true"===i;break;case"number":n=Number(i);break;default:n=t}return n}function normaliseOptions(t){let e,i=document;if(isObject(t)){const n=t;(isScope(n.scope)||null===n.scope)&&(i=n.scope),"function"==typeof n.onError&&(e=n.onError)}return isScope(t)?i=t:null===t?i=null:"function"==typeof t&&(e=t),{scope:i,onError:e}}function mergeConfigs(...t){const e={};for(const i of t)for(const t of Object.keys(i)){const n=e[t],s=i[t];isObject(n)&&isObject(s)?e[t]=mergeConfigs(n,s):e[t]=s}return e}function extractConfigByNamespace(t,e,i){const n=t.properties[i];if("object"!==(null==n?void 0:n.type))return;const s={[i]:{}};for(const[o,r]of Object.entries(e)){let t=s;const e=o.split(".");for(const[n,s]of e.entries())isObject(t)&&(n<e.length-1?(isObject(t[s])||(t[s]={}),t=t[s]):o!==i&&(t[s]=normaliseString(r)))}return s[i]}class I18n{constructor(t={},e={}){var i;this.translations=void 0,this.locale=void 0,this.translations=t,this.locale=null!=(i=e.locale)?i:document.documentElement.lang||"en"}t(t,e){if(!t)throw new Error("i18n: lookup key missing");let i=this.translations[t];if("number"==typeof(null==e?void 0:e.count)&&isObject(i)){const n=i[this.getPluralSuffix(t,e.count)];n&&(i=n)}if("string"==typeof i){if(i.match(/%{(.\S+)}/)){if(!e)throw new Error("i18n: cannot replace placeholders in string if no option data provided");return this.replacePlaceholders(i,e)}return i}return t}replacePlaceholders(t,e){const i=Intl.NumberFormat.supportedLocalesOf(this.locale).length?new Intl.NumberFormat(this.locale):void 0;return t.replace(/%{(.\S+)}/g,(function(t,n){if(Object.prototype.hasOwnProperty.call(e,n)){const t=e[n];return!1===t||"number"!=typeof t&&"string"!=typeof t?"":"number"==typeof t?i?i.format(t):`${t}`:t}throw new Error(`i18n: no data found to replace ${t} placeholder in string`)}))}hasIntlPluralRulesSupport(){return Boolean("PluralRules"in window.Intl&&Intl.PluralRules.supportedLocalesOf(this.locale).length)}getPluralSuffix(t,e){if(e=Number(e),!isFinite(e))return"other";const i=this.translations[t],n=this.hasIntlPluralRulesSupport()?new Intl.PluralRules(this.locale).select(e):this.selectPluralFormUsingFallbackRules(e);if(isObject(i)){if(n in i)return n;if("other"in i)return console.warn(`i18n: Missing plural form ".${n}" for "${this.locale}" locale. Falling back to ".other".`),"other"}throw new Error(`i18n: Plural form ".other" is required for "${this.locale}" locale`)}selectPluralFormUsingFallbackRules(t){t=Math.abs(Math.floor(t));const e=this.getPluralRulesForLocale();return e?I18n.pluralRules[e](t):"other"}getPluralRulesForLocale(){const t=this.locale.split("-")[0];for(const e in I18n.pluralRulesMap){const i=I18n.pluralRulesMap[e];if(i.includes(this.locale)||i.includes(t))return e}}}I18n.pluralRulesMap={arabic:["ar"],chinese:["my","zh","id","ja","jv","ko","ms","th","vi"],french:["hy","bn","fr","gu","hi","fa","pa","zu"],german:["af","sq","az","eu","bg","ca","da","nl","en","et","fi","ka","de","el","hu","lb","no","so","sw","sv","ta","te","tr","ur"],irish:["ga"],russian:["ru","uk"],scottish:["gd"],spanish:["pt-PT","it","es"],welsh:["cy"]},I18n.pluralRules={arabic:t=>0===t?"zero":1===t?"one":2===t?"two":t%100>=3&&t%100<=10?"few":t%100>=11&&t%100<=99?"many":"other",chinese:()=>"other",french:t=>0===t||1===t?"one":"other",german:t=>1===t?"one":"other",irish:t=>1===t?"one":2===t?"two":t>=3&&t<=6?"few":t>=7&&t<=10?"many":"other",russian(t){const e=t%100,i=e%10;return 1===i&&11!==e?"one":i>=2&&i<=4&&!(e>=12&&e<=14)?"few":0===i||i>=5&&i<=9||e>=11&&e<=14?"many":"other"},scottish:t=>1===t||11===t?"one":2===t||12===t?"two":t>=3&&t<=10||t>=13&&t<=19?"few":"other",spanish:t=>1===t?"one":t%1e6==0&&0!==t?"many":"other",welsh:t=>0===t?"zero":1===t?"one":2===t?"two":3===t?"few":6===t?"many":"other"};class Accordion extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.i18n=void 0,this.controlsClass="govuk-accordion__controls",this.showAllClass="govuk-accordion__show-all",this.showAllTextClass="govuk-accordion__show-all-text",this.sectionClass="govuk-accordion__section",this.sectionExpandedClass="govuk-accordion__section--expanded",this.sectionButtonClass="govuk-accordion__section-button",this.sectionHeaderClass="govuk-accordion__section-header",this.sectionHeadingClass="govuk-accordion__section-heading",this.sectionHeadingDividerClass="govuk-accordion__section-heading-divider",this.sectionHeadingTextClass="govuk-accordion__section-heading-text",this.sectionHeadingTextFocusClass="govuk-accordion__section-heading-text-focus",this.sectionShowHideToggleClass="govuk-accordion__section-toggle",this.sectionShowHideToggleFocusClass="govuk-accordion__section-toggle-focus",this.sectionShowHideTextClass="govuk-accordion__section-toggle-text",this.upChevronIconClass="govuk-accordion-nav__chevron",this.downChevronIconClass="govuk-accordion-nav__chevron--down",this.sectionSummaryClass="govuk-accordion__section-summary",this.sectionSummaryFocusClass="govuk-accordion__section-summary-focus",this.sectionContentClass="govuk-accordion__section-content",this.$sections=void 0,this.$showAllButton=null,this.$showAllIcon=null,this.$showAllText=null,this.i18n=new I18n(this.config.i18n);const i=this.$root.querySelectorAll(`.${this.sectionClass}`);if(!i.length)throw new ElementError({component:Accordion,identifier:`Sections (\`<div class="${this.sectionClass}">\`)`});this.$sections=i,this.initControls(),this.initSectionHeaders(),this.updateShowAllButton(this.areAllSectionsOpen())}initControls(){this.$showAllButton=document.createElement("button"),this.$showAllButton.setAttribute("type","button"),this.$showAllButton.setAttribute("class",this.showAllClass),this.$showAllButton.setAttribute("aria-expanded","false"),this.$showAllIcon=document.createElement("span"),this.$showAllIcon.classList.add(this.upChevronIconClass),this.$showAllButton.appendChild(this.$showAllIcon);const t=document.createElement("div");t.setAttribute("class",this.controlsClass),t.appendChild(this.$showAllButton),this.$root.insertBefore(t,this.$root.firstChild),this.$showAllText=document.createElement("span"),this.$showAllText.classList.add(this.showAllTextClass),this.$showAllButton.appendChild(this.$showAllText),this.$showAllButton.addEventListener("click",(()=>this.onShowOrHideAllToggle())),"onbeforematch"in document&&document.addEventListener("beforematch",(t=>this.onBeforeMatch(t)))}initSectionHeaders(){this.$sections.forEach(((t,e)=>{const i=t.querySelector(`.${this.sectionHeaderClass}`);if(!i)throw new ElementError({component:Accordion,identifier:`Section headers (\`<div class="${this.sectionHeaderClass}">\`)`});this.constructHeaderMarkup(i,e),this.setExpanded(this.isExpanded(t),t),i.addEventListener("click",(()=>this.onSectionToggle(t))),this.setInitialState(t)}))}constructHeaderMarkup(t,e){const i=t.querySelector(`.${this.sectionButtonClass}`),n=t.querySelector(`.${this.sectionHeadingClass}`),s=t.querySelector(`.${this.sectionSummaryClass}`);if(!n)throw new ElementError({component:Accordion,identifier:`Section heading (\`.${this.sectionHeadingClass}\`)`});if(!i)throw new ElementError({component:Accordion,identifier:`Section button placeholder (\`<span class="${this.sectionButtonClass}">\`)`});const o=document.createElement("button");o.setAttribute("type","button"),o.setAttribute("aria-controls",`${this.$root.id}-content-${e+1}`);for(const d of Array.from(i.attributes))"id"!==d.name&&o.setAttribute(d.name,d.value);const r=document.createElement("span");r.classList.add(this.sectionHeadingTextClass),r.id=i.id;const a=document.createElement("span");a.classList.add(this.sectionHeadingTextFocusClass),r.appendChild(a),Array.from(i.childNodes).forEach((t=>a.appendChild(t)));const l=document.createElement("span");l.classList.add(this.sectionShowHideToggleClass),l.setAttribute("data-nosnippet","");const c=document.createElement("span");c.classList.add(this.sectionShowHideToggleFocusClass),l.appendChild(c);const u=document.createElement("span"),h=document.createElement("span");if(h.classList.add(this.upChevronIconClass),c.appendChild(h),u.classList.add(this.sectionShowHideTextClass),c.appendChild(u),o.appendChild(r),o.appendChild(this.getButtonPunctuationEl()),s){const t=document.createElement("span"),e=document.createElement("span");e.classList.add(this.sectionSummaryFocusClass),t.appendChild(e);for(const i of Array.from(s.attributes))t.setAttribute(i.name,i.value);Array.from(s.childNodes).forEach((t=>e.appendChild(t))),s.remove(),o.appendChild(t),o.appendChild(this.getButtonPunctuationEl())}o.appendChild(l),n.removeChild(i),n.appendChild(o)}onBeforeMatch(t){const e=t.target;if(!(e instanceof Element))return;const i=e.closest(`.${this.sectionClass}`);i&&this.setExpanded(!0,i)}onSectionToggle(t){const e=!this.isExpanded(t);this.setExpanded(e,t),this.storeState(t,e)}onShowOrHideAllToggle(){const t=!this.areAllSectionsOpen();this.$sections.forEach((e=>{this.setExpanded(t,e),this.storeState(e,t)})),this.updateShowAllButton(t)}setExpanded(t,e){const i=e.querySelector(`.${this.upChevronIconClass}`),n=e.querySelector(`.${this.sectionShowHideTextClass}`),s=e.querySelector(`.${this.sectionButtonClass}`),o=e.querySelector(`.${this.sectionContentClass}`);if(!o)throw new ElementError({component:Accordion,identifier:`Section content (\`<div class="${this.sectionContentClass}">\`)`});if(!i||!n||!s)return;const r=t?this.i18n.t("hideSection"):this.i18n.t("showSection");n.textContent=r,s.setAttribute("aria-expanded",`${t}`);const a=[],l=e.querySelector(`.${this.sectionHeadingTextClass}`);l&&a.push(l.textContent.trim());const c=e.querySelector(`.${this.sectionSummaryClass}`);c&&a.push(c.textContent.trim());const u=t?this.i18n.t("hideSectionAriaLabel"):this.i18n.t("showSectionAriaLabel");a.push(u),s.setAttribute("aria-label",a.join(" , ")),t?(o.removeAttribute("hidden"),e.classList.add(this.sectionExpandedClass),i.classList.remove(this.downChevronIconClass)):(o.setAttribute("hidden","until-found"),e.classList.remove(this.sectionExpandedClass),i.classList.add(this.downChevronIconClass)),this.updateShowAllButton(this.areAllSectionsOpen())}isExpanded(t){return t.classList.contains(this.sectionExpandedClass)}areAllSectionsOpen(){return Array.from(this.$sections).every((t=>this.isExpanded(t)))}updateShowAllButton(t){this.$showAllButton&&this.$showAllText&&this.$showAllIcon&&(this.$showAllButton.setAttribute("aria-expanded",t.toString()),this.$showAllText.textContent=t?this.i18n.t("hideAllSections"):this.i18n.t("showAllSections"),this.$showAllIcon.classList.toggle(this.downChevronIconClass,!t))}getIdentifier(t){const e=t.querySelector(`.${this.sectionButtonClass}`);return null==e?void 0:e.getAttribute("aria-controls")}storeState(t,e){if(!this.config.rememberExpanded)return;const i=this.getIdentifier(t);if(i)try{window.sessionStorage.setItem(i,e.toString())}catch(n){}}setInitialState(t){if(!this.config.rememberExpanded)return;const e=this.getIdentifier(t);if(e)try{const i=window.sessionStorage.getItem(e);null!==i&&this.setExpanded("true"===i,t)}catch(i){}}getButtonPunctuationEl(){const t=document.createElement("span");return t.classList.add("govuk-visually-hidden",this.sectionHeadingDividerClass),t.textContent=", ",t}}Accordion.moduleName="govuk-accordion",Accordion.defaults=Object.freeze({i18n:{hideAllSections:"Hide all sections",hideSection:"Hide",hideSectionAriaLabel:"Hide this section",showAllSections:"Show all sections",showSection:"Show",showSectionAriaLabel:"Show this section"},rememberExpanded:!0}),Accordion.schema=Object.freeze({properties:{i18n:{type:"object"},rememberExpanded:{type:"boolean"}}});class Button extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.debounceFormSubmitTimer=null,this.$root.addEventListener("keydown",(t=>this.handleKeyDown(t))),this.$root.addEventListener("click",(t=>this.debounce(t)))}handleKeyDown(t){const e=t.target;" "===t.key&&e instanceof HTMLElement&&"button"===e.getAttribute("role")&&(t.preventDefault(),e.click())}debounce(t){if(this.config.preventDoubleClick)return this.debounceFormSubmitTimer?(t.preventDefault(),!1):void(this.debounceFormSubmitTimer=window.setTimeout((()=>{this.debounceFormSubmitTimer=null}),1e3))}}function closestAttributeValue(t,e){const i=t.closest(`[${e}]`);return i?i.getAttribute(e):null}Button.moduleName="govuk-button",Button.defaults=Object.freeze({preventDoubleClick:!1}),Button.schema=Object.freeze({properties:{preventDoubleClick:{type:"boolean"}}});class CharacterCount extends ConfigurableComponent{[t](t){let e={};return("maxwords"in t||"maxlength"in t)&&(e={maxlength:void 0,maxwords:void 0}),e}constructor(t,e={}){var i,n;super(t,e),this.$textarea=void 0,this.$visibleCountMessage=void 0,this.$screenReaderCountMessage=void 0,this.lastInputTimestamp=null,this.lastInputValue="",this.valueChecker=null,this.i18n=void 0,this.maxLength=void 0;const s=this.$root.querySelector(".govuk-js-character-count");if(!(s instanceof HTMLTextAreaElement||s instanceof HTMLInputElement))throw new ElementError({component:CharacterCount,element:s,expectedType:"HTMLTextareaElement or HTMLInputElement",identifier:"Form field (`.govuk-js-character-count`)"});const o=function(t,e){const i=[];for(const[n,s]of Object.entries(t)){const t=[];if(Array.isArray(s)){for(const{required:i,errorMessage:n}of s)i.every((t=>!!e[t]))||t.push(n);"anyOf"!==n||s.length-t.length>=1||i.push(...t)}}return i}(CharacterCount.schema,this.config);if(o[0])throw new ConfigError(formatErrorMessage(CharacterCount,o[0]));this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(this.$root,"lang")}),this.maxLength=null!=(i=null!=(n=this.config.maxwords)?n:this.config.maxlength)?i:1/0,this.$textarea=s;const r=`${this.$textarea.id}-info`,a=document.getElementById(r);if(!a)throw new ElementError({component:CharacterCount,element:a,identifier:`Count message (\`id="${r}"\`)`});this.$errorMessage=this.$root.querySelector(".govuk-error-message"),a.textContent.match(/^\s*$/)&&(a.textContent=this.i18n.t("textareaDescription",{count:this.maxLength})),this.$textarea.insertAdjacentElement("afterend",a);const l=document.createElement("div");l.className="govuk-character-count__sr-status govuk-visually-hidden",l.setAttribute("aria-live","polite"),this.$screenReaderCountMessage=l,a.insertAdjacentElement("afterend",l);const c=document.createElement("div");c.className=a.className,c.classList.add("govuk-character-count__status"),c.setAttribute("aria-hidden","true"),this.$visibleCountMessage=c,a.insertAdjacentElement("afterend",c),a.classList.add("govuk-visually-hidden"),this.$textarea.removeAttribute("maxlength"),this.bindChangeEvents(),window.addEventListener("pageshow",(()=>this.updateCountMessage())),this.updateCountMessage()}bindChangeEvents(){this.$textarea.addEventListener("keyup",(()=>this.handleKeyUp())),this.$textarea.addEventListener("focus",(()=>this.handleFocus())),this.$textarea.addEventListener("blur",(()=>this.handleBlur()))}handleKeyUp(){this.updateVisibleCountMessage(),this.lastInputTimestamp=Date.now()}handleFocus(){this.valueChecker=window.setInterval((()=>{(!this.lastInputTimestamp||Date.now()-500>=this.lastInputTimestamp)&&this.updateIfValueChanged()}),1e3)}handleBlur(){this.valueChecker&&window.clearInterval(this.valueChecker)}updateIfValueChanged(){this.$textarea.value!==this.lastInputValue&&(this.lastInputValue=this.$textarea.value,this.updateCountMessage())}updateCountMessage(){this.updateVisibleCountMessage(),this.updateScreenReaderCountMessage()}updateVisibleCountMessage(){const t=this.maxLength-this.count(this.$textarea.value)<0;this.$visibleCountMessage.classList.toggle("govuk-character-count__message--disabled",!this.isOverThreshold()),this.$errorMessage||this.$textarea.classList.toggle("govuk-textarea--error",t),this.$visibleCountMessage.classList.toggle("govuk-error-message",t),this.$visibleCountMessage.classList.toggle("govuk-hint",!t),this.$visibleCountMessage.textContent=this.getCountMessage()}updateScreenReaderCountMessage(){this.isOverThreshold()?this.$screenReaderCountMessage.removeAttribute("aria-hidden"):this.$screenReaderCountMessage.setAttribute("aria-hidden","true"),this.$screenReaderCountMessage.textContent=this.getCountMessage()}count(t){if(this.config.maxwords){var e;return(null!=(e=t.match(/\S+/g))?e:[]).length}return t.length}getCountMessage(){const t=this.maxLength-this.count(this.$textarea.value),e=this.config.maxwords?"words":"characters";return this.formatCountMessage(t,e)}formatCountMessage(t,e){if(0===t)return this.i18n.t(`${e}AtLimit`);const i=t<0?"OverLimit":"UnderLimit";return this.i18n.t(`${e}${i}`,{count:Math.abs(t)})}isOverThreshold(){if(!this.config.threshold)return!0;const t=this.count(this.$textarea.value);return this.maxLength*this.config.threshold/100<=t}}CharacterCount.moduleName="govuk-character-count",CharacterCount.defaults=Object.freeze({threshold:0,i18n:{charactersUnderLimit:{one:"You have %{count} character remaining",other:"You have %{count} characters remaining"},charactersAtLimit:"You have 0 characters remaining",charactersOverLimit:{one:"You have %{count} character too many",other:"You have %{count} characters too many"},wordsUnderLimit:{one:"You have %{count} word remaining",other:"You have %{count} words remaining"},wordsAtLimit:"You have 0 words remaining",wordsOverLimit:{one:"You have %{count} word too many",other:"You have %{count} words too many"},textareaDescription:{other:""}}}),CharacterCount.schema=Object.freeze({properties:{i18n:{type:"object"},maxwords:{type:"number"},maxlength:{type:"number"},threshold:{type:"number"}},anyOf:[{required:["maxwords"],errorMessage:'Either "maxlength" or "maxwords" must be provided'},{required:["maxlength"],errorMessage:'Either "maxlength" or "maxwords" must be provided'}]});class Checkboxes extends Component{constructor(t){super(t),this.$inputs=void 0;const e=this.$root.querySelectorAll('input[type="checkbox"]');if(!e.length)throw new ElementError({component:Checkboxes,identifier:'Form inputs (`<input type="checkbox">`)'});this.$inputs=e,this.$inputs.forEach((t=>{const e=t.getAttribute("data-aria-controls");if(e){if(!document.getElementById(e))throw new ElementError({component:Checkboxes,identifier:`Conditional reveal (\`id="${e}"\`)`});t.setAttribute("aria-controls",e),t.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$root.addEventListener("click",(t=>this.handleClick(t)))}syncAllConditionalReveals(){this.$inputs.forEach((t=>this.syncConditionalRevealWithInputState(t)))}syncConditionalRevealWithInputState(t){const e=t.getAttribute("aria-controls");if(!e)return;const i=document.getElementById(e);if(null!=i&&i.classList.contains("govuk-checkboxes__conditional")){const e=t.checked;t.setAttribute("aria-expanded",e.toString()),i.classList.toggle("govuk-checkboxes__conditional--hidden",!e)}}unCheckAllInputsExcept(t){document.querySelectorAll(`input[type="checkbox"][name="${t.name}"]`).forEach((e=>{t.form===e.form&&e!==t&&(e.checked=!1,this.syncConditionalRevealWithInputState(e))}))}unCheckExclusiveInputs(t){document.querySelectorAll(`input[data-behaviour="exclusive"][type="checkbox"][name="${t.name}"]`).forEach((e=>{t.form===e.form&&(e.checked=!1,this.syncConditionalRevealWithInputState(e))}))}handleClick(t){const e=t.target;if(!(e instanceof HTMLInputElement)||"checkbox"!==e.type)return;if(e.getAttribute("aria-controls")&&this.syncConditionalRevealWithInputState(e),!e.checked)return;"exclusive"===e.getAttribute("data-behaviour")?this.unCheckAllInputsExcept(e):this.unCheckExclusiveInputs(e)}}Checkboxes.moduleName="govuk-checkboxes";class ErrorSummary extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.config.disableAutoFocus||setFocus(this.$root),this.$root.addEventListener("click",(t=>this.handleClick(t)))}handleClick(t){const e=t.target;e&&this.focusTarget(e)&&t.preventDefault()}focusTarget(t){if(!(t instanceof HTMLAnchorElement))return!1;const e=t.hash.replace("#","");if(!e)return!1;const i=document.getElementById(e);if(!i)return!1;const n=this.getAssociatedLegendOrLabel(i);return!!n&&(n.scrollIntoView(),i.focus({preventScroll:!0}),!0)}getAssociatedLegendOrLabel(t){var e;const i=t.closest("fieldset");if(i){const e=i.getElementsByTagName("legend");if(e.length){const i=e[0];if(t instanceof HTMLInputElement&&("checkbox"===t.type||"radio"===t.type))return i;const n=i.getBoundingClientRect().top,s=t.getBoundingClientRect();if(s.height&&window.innerHeight){if(s.top+s.height-n<window.innerHeight/2)return i}}}return null!=(e=document.querySelector(`label[for='${t.getAttribute("id")}']`))?e:t.closest("label")}}ErrorSummary.moduleName="govuk-error-summary",ErrorSummary.defaults=Object.freeze({disableAutoFocus:!1}),ErrorSummary.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class ExitThisPage extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.i18n=void 0,this.$button=void 0,this.$skiplinkButton=null,this.$updateSpan=null,this.$indicatorContainer=null,this.$overlay=null,this.keypressCounter=0,this.lastKeyWasModified=!1,this.timeoutTime=5e3,this.keypressTimeoutId=null,this.timeoutMessageId=null;const i=this.$root.querySelector(".govuk-exit-this-page__button");if(!(i instanceof HTMLAnchorElement))throw new ElementError({component:ExitThisPage,element:i,expectedType:"HTMLAnchorElement",identifier:"Button (`.govuk-exit-this-page__button`)"});this.i18n=new I18n(this.config.i18n),this.$button=i;const n=document.querySelector(".govuk-js-exit-this-page-skiplink");n instanceof HTMLAnchorElement&&(this.$skiplinkButton=n),this.buildIndicator(),this.initUpdateSpan(),this.initButtonClickHandler(),"govukFrontendExitThisPageKeypress"in document.body.dataset||(document.addEventListener("keyup",this.handleKeypress.bind(this),!0),document.body.dataset.govukFrontendExitThisPageKeypress="true"),window.addEventListener("pageshow",this.resetPage.bind(this))}initUpdateSpan(){this.$updateSpan=document.createElement("span"),this.$updateSpan.setAttribute("role","status"),this.$updateSpan.className="govuk-visually-hidden",this.$root.appendChild(this.$updateSpan)}initButtonClickHandler(){this.$button.addEventListener("click",this.handleClick.bind(this)),this.$skiplinkButton&&this.$skiplinkButton.addEventListener("click",this.handleClick.bind(this))}buildIndicator(){this.$indicatorContainer=document.createElement("div"),this.$indicatorContainer.className="govuk-exit-this-page__indicator",this.$indicatorContainer.setAttribute("aria-hidden","true");for(let t=0;t<3;t++){const t=document.createElement("div");t.className="govuk-exit-this-page__indicator-light",this.$indicatorContainer.appendChild(t)}this.$button.appendChild(this.$indicatorContainer)}updateIndicator(){if(!this.$indicatorContainer)return;this.$indicatorContainer.classList.toggle("govuk-exit-this-page__indicator--visible",this.keypressCounter>0);this.$indicatorContainer.querySelectorAll(".govuk-exit-this-page__indicator-light").forEach(((t,e)=>{t.classList.toggle("govuk-exit-this-page__indicator-light--on",e<this.keypressCounter)}))}exitPage(){this.$updateSpan&&(this.$updateSpan.textContent="",document.body.classList.add("govuk-exit-this-page-hide-content"),this.$overlay=document.createElement("div"),this.$overlay.className="govuk-exit-this-page-overlay",this.$overlay.setAttribute("role","alert"),document.body.appendChild(this.$overlay),this.$overlay.textContent=this.i18n.t("activated"),window.location.href=this.$button.href)}handleClick(t){t.preventDefault(),this.exitPage()}handleKeypress(t){this.$updateSpan&&("Shift"!==t.key||this.lastKeyWasModified?this.keypressTimeoutId&&this.resetKeypressTimer():(this.keypressCounter+=1,this.updateIndicator(),this.timeoutMessageId&&(window.clearTimeout(this.timeoutMessageId),this.timeoutMessageId=null),this.keypressCounter>=3?(this.keypressCounter=0,this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null),this.exitPage()):1===this.keypressCounter?this.$updateSpan.textContent=this.i18n.t("pressTwoMoreTimes"):this.$updateSpan.textContent=this.i18n.t("pressOneMoreTime"),this.setKeypressTimer()),this.lastKeyWasModified=t.shiftKey)}setKeypressTimer(){this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=window.setTimeout(this.resetKeypressTimer.bind(this),this.timeoutTime)}resetKeypressTimer(){if(!this.$updateSpan)return;this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null);const t=this.$updateSpan;this.keypressCounter=0,t.textContent=this.i18n.t("timedOut"),this.timeoutMessageId=window.setTimeout((()=>{t.textContent=""}),this.timeoutTime),this.updateIndicator()}resetPage(){document.body.classList.remove("govuk-exit-this-page-hide-content"),this.$overlay&&(this.$overlay.remove(),this.$overlay=null),this.$updateSpan&&(this.$updateSpan.setAttribute("role","status"),this.$updateSpan.textContent=""),this.updateIndicator(),this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.timeoutMessageId&&window.clearTimeout(this.timeoutMessageId)}}ExitThisPage.moduleName="govuk-exit-this-page",ExitThisPage.defaults=Object.freeze({i18n:{activated:"Loading.",timedOut:"Exit this page expired.",pressTwoMoreTimes:"Shift, press 2 more times to exit.",pressOneMoreTime:"Shift, press 1 more time to exit."}}),ExitThisPage.schema=Object.freeze({properties:{i18n:{type:"object"}}});class FileUpload extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.$input=void 0,this.$button=void 0,this.$status=void 0,this.i18n=void 0,this.id=void 0,this.$announcements=void 0,this.enteredAnotherElement=void 0;const i=this.$root.querySelector("input");if(null===i)throw new ElementError({component:FileUpload,identifier:'File inputs (`<input type="file">`)'});if("file"!==i.type)throw new ElementError(formatErrorMessage(FileUpload,'File input (`<input type="file">`) attribute (`type`) is not `file`'));if(this.$input=i,!this.$input.id)throw new ElementError({component:FileUpload,identifier:'File input (`<input type="file">`) attribute (`id`)'});this.id=this.$input.id,this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(this.$root,"lang")});const n=this.findLabel();n.id||(n.id=`${this.id}-label`),this.$input.id=`${this.id}-input`,this.$input.setAttribute("hidden","true");const s=document.createElement("button");s.classList.add("govuk-file-upload-button"),s.type="button",s.id=this.id,s.classList.add("govuk-file-upload-button--empty");const o=this.$input.getAttribute("aria-describedby");o&&s.setAttribute("aria-describedby",o);const r=document.createElement("span");r.className="govuk-body govuk-file-upload-button__status",r.setAttribute("aria-live","polite"),r.innerText=this.i18n.t("noFileChosen"),s.appendChild(r);const a=document.createElement("span");a.className="govuk-visually-hidden",a.innerText=", ",a.id=`${this.id}-comma`,s.appendChild(a);const l=document.createElement("span");l.className="govuk-file-upload-button__pseudo-button-container";const c=document.createElement("span");c.className="govuk-button govuk-button--secondary govuk-file-upload-button__pseudo-button",c.innerText=this.i18n.t("chooseFilesButton"),l.appendChild(c),l.insertAdjacentText("beforeend"," ");const u=document.createElement("span");u.className="govuk-body govuk-file-upload-button__instruction",u.innerText=this.i18n.t("dropInstruction"),l.appendChild(u),s.appendChild(l),s.setAttribute("aria-labelledby",`${n.id} ${a.id} ${s.id}`),s.addEventListener("click",this.onClick.bind(this)),s.addEventListener("dragover",(t=>{t.preventDefault()})),this.$root.insertAdjacentElement("afterbegin",s),this.$input.setAttribute("tabindex","-1"),this.$input.setAttribute("aria-hidden","true"),this.$button=s,this.$status=r,this.$input.addEventListener("change",this.onChange.bind(this)),this.updateDisabledState(),this.observeDisabledState(),this.$announcements=document.createElement("span"),this.$announcements.classList.add("govuk-file-upload-announcements"),this.$announcements.classList.add("govuk-visually-hidden"),this.$announcements.setAttribute("aria-live","assertive"),this.$root.insertAdjacentElement("afterend",this.$announcements),this.$button.addEventListener("drop",this.onDrop.bind(this)),document.addEventListener("dragenter",this.updateDropzoneVisibility.bind(this)),document.addEventListener("dragenter",(()=>{this.enteredAnotherElement=!0})),document.addEventListener("dragleave",(()=>{this.enteredAnotherElement||this.$button.disabled||(this.hideDraggingState(),this.$announcements.innerText=this.i18n.t("leftDropZone")),this.enteredAnotherElement=!1}))}updateDropzoneVisibility(t){this.$button.disabled||t.target instanceof Node&&(this.$root.contains(t.target)?t.dataTransfer&&isContainingFiles(t.dataTransfer)&&(this.$button.classList.contains("govuk-file-upload-button--dragging")||(this.showDraggingState(),this.$announcements.innerText=this.i18n.t("enteredDropZone"))):this.$button.classList.contains("govuk-file-upload-button--dragging")&&(this.hideDraggingState(),this.$announcements.innerText=this.i18n.t("leftDropZone")))}showDraggingState(){this.$button.classList.add("govuk-file-upload-button--dragging")}hideDraggingState(){this.$button.classList.remove("govuk-file-upload-button--dragging")}onDrop(t){t.preventDefault(),t.dataTransfer&&isContainingFiles(t.dataTransfer)&&(this.$input.files=t.dataTransfer.files,this.$input.dispatchEvent(new CustomEvent("change")),this.hideDraggingState())}onChange(){const t=this.$input.files.length;0===t?(this.$status.innerText=this.i18n.t("noFileChosen"),this.$button.classList.add("govuk-file-upload-button--empty")):(this.$status.innerText=1===t?this.$input.files[0].name:this.i18n.t("multipleFilesChosen",{count:t}),this.$button.classList.remove("govuk-file-upload-button--empty"))}findLabel(){const t=document.querySelector(`label[for="${this.$input.id}"]`);if(!t)throw new ElementError({component:FileUpload,identifier:`Field label (\`<label for=${this.$input.id}>\`)`});return t}onClick(){this.$input.click()}observeDisabledState(){new MutationObserver((t=>{for(const e of t)"attributes"===e.type&&"disabled"===e.attributeName&&this.updateDisabledState()})).observe(this.$input,{attributes:!0})}updateDisabledState(){this.$button.disabled=this.$input.disabled,this.$root.classList.toggle("govuk-drop-zone--disabled",this.$button.disabled)}}function isContainingFiles(t){const e=0===t.types.length,i=t.types.some((t=>"Files"===t));return e||i}FileUpload.moduleName="govuk-file-upload",FileUpload.defaults=Object.freeze({i18n:{chooseFilesButton:"Choose file",dropInstruction:"or drop file",noFileChosen:"No file chosen",multipleFilesChosen:{one:"%{count} file chosen",other:"%{count} files chosen"},enteredDropZone:"Entered drop zone",leftDropZone:"Left drop zone"}}),FileUpload.schema=Object.freeze({properties:{i18n:{type:"object"}}});class Header extends Component{constructor(t){super(t),this.$menuButton=void 0,this.$menu=void 0,this.menuIsOpen=!1,this.mql=null;const e=this.$root.querySelector(".govuk-js-header-toggle");if(!e)return this;this.$root.classList.add("govuk-header--with-js-navigation");const i=e.getAttribute("aria-controls");if(!i)throw new ElementError({component:Header,identifier:'Navigation button (`<button class="govuk-js-header-toggle">`) attribute (`aria-controls`)'});const n=document.getElementById(i);if(!n)throw new ElementError({component:Header,element:n,identifier:`Navigation (\`<ul id="${i}">\`)`});this.$menu=n,this.$menuButton=e,this.setupResponsiveChecks(),this.$menuButton.addEventListener("click",(()=>this.handleMenuButtonClick()))}setupResponsiveChecks(){const t=getBreakpoint("desktop");if(!t.value)throw new ElementError({component:Header,identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){this.mql&&this.$menu&&this.$menuButton&&(this.mql.matches?(this.$menu.removeAttribute("hidden"),this.$menuButton.setAttribute("hidden","")):(this.$menuButton.removeAttribute("hidden"),this.$menuButton.setAttribute("aria-expanded",this.menuIsOpen.toString()),this.menuIsOpen?this.$menu.removeAttribute("hidden"):this.$menu.setAttribute("hidden","")))}handleMenuButtonClick(){this.menuIsOpen=!this.menuIsOpen,this.checkMode()}}Header.moduleName="govuk-header";class NotificationBanner extends ConfigurableComponent{constructor(t,e={}){super(t,e),"alert"!==this.$root.getAttribute("role")||this.config.disableAutoFocus||setFocus(this.$root)}}NotificationBanner.moduleName="govuk-notification-banner",NotificationBanner.defaults=Object.freeze({disableAutoFocus:!1}),NotificationBanner.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class PasswordInput extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.i18n=void 0,this.$input=void 0,this.$showHideButton=void 0,this.$screenReaderStatusMessage=void 0;const i=this.$root.querySelector(".govuk-js-password-input-input");if(!(i instanceof HTMLInputElement))throw new ElementError({component:PasswordInput,element:i,expectedType:"HTMLInputElement",identifier:"Form field (`.govuk-js-password-input-input`)"});if("password"!==i.type)throw new ElementError("Password input: Form field (`.govuk-js-password-input-input`) must be of type `password`.");const n=this.$root.querySelector(".govuk-js-password-input-toggle");if(!(n instanceof HTMLButtonElement))throw new ElementError({component:PasswordInput,element:n,expectedType:"HTMLButtonElement",identifier:"Button (`.govuk-js-password-input-toggle`)"});if("button"!==n.type)throw new ElementError("Password input: Button (`.govuk-js-password-input-toggle`) must be of type `button`.");this.$input=i,this.$showHideButton=n,this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(this.$root,"lang")}),this.$showHideButton.removeAttribute("hidden");const s=document.createElement("div");s.className="govuk-password-input__sr-status govuk-visually-hidden",s.setAttribute("aria-live","polite"),this.$screenReaderStatusMessage=s,this.$input.insertAdjacentElement("afterend",s),this.$showHideButton.addEventListener("click",this.toggle.bind(this)),this.$input.form&&this.$input.form.addEventListener("submit",(()=>this.hide())),window.addEventListener("pageshow",(t=>{t.persisted&&"password"!==this.$input.type&&this.hide()})),this.hide()}toggle(t){t.preventDefault(),"password"!==this.$input.type?this.hide():this.show()}show(){this.setType("text")}hide(){this.setType("password")}setType(t){if(t===this.$input.type)return;this.$input.setAttribute("type",t);const e="password"===t,i=e?"show":"hide",n=e?"passwordHidden":"passwordShown";this.$showHideButton.innerText=this.i18n.t(`${i}Password`),this.$showHideButton.setAttribute("aria-label",this.i18n.t(`${i}PasswordAriaLabel`)),this.$screenReaderStatusMessage.innerText=this.i18n.t(`${n}Announcement`)}}PasswordInput.moduleName="govuk-password-input",PasswordInput.defaults=Object.freeze({i18n:{showPassword:"Show",hidePassword:"Hide",showPasswordAriaLabel:"Show password",hidePasswordAriaLabel:"Hide password",passwordShownAnnouncement:"Your password is visible",passwordHiddenAnnouncement:"Your password is hidden"}}),PasswordInput.schema=Object.freeze({properties:{i18n:{type:"object"}}});class Radios extends Component{constructor(t){super(t),this.$inputs=void 0;const e=this.$root.querySelectorAll('input[type="radio"]');if(!e.length)throw new ElementError({component:Radios,identifier:'Form inputs (`<input type="radio">`)'});this.$inputs=e,this.$inputs.forEach((t=>{const e=t.getAttribute("data-aria-controls");if(e){if(!document.getElementById(e))throw new ElementError({component:Radios,identifier:`Conditional reveal (\`id="${e}"\`)`});t.setAttribute("aria-controls",e),t.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$root.addEventListener("click",(t=>this.handleClick(t)))}syncAllConditionalReveals(){this.$inputs.forEach((t=>this.syncConditionalRevealWithInputState(t)))}syncConditionalRevealWithInputState(t){const e=t.getAttribute("aria-controls");if(!e)return;const i=document.getElementById(e);if(null!=i&&i.classList.contains("govuk-radios__conditional")){const e=t.checked;t.setAttribute("aria-expanded",e.toString()),i.classList.toggle("govuk-radios__conditional--hidden",!e)}}handleClick(t){const e=t.target;if(!(e instanceof HTMLInputElement)||"radio"!==e.type)return;const i=document.querySelectorAll('input[type="radio"][aria-controls]'),n=e.form,s=e.name;i.forEach((t=>{const e=t.form===n;t.name===s&&e&&this.syncConditionalRevealWithInputState(t)}))}}Radios.moduleName="govuk-radios";class ServiceNavigation extends Component{constructor(t){super(t),this.$menuButton=void 0,this.$menu=void 0,this.menuIsOpen=!1,this.mql=null;const e=this.$root.querySelector(".govuk-js-service-navigation-toggle");if(!e)return this;const i=e.getAttribute("aria-controls");if(!i)throw new ElementError({component:ServiceNavigation,identifier:'Navigation button (`<button class="govuk-js-service-navigation-toggle">`) attribute (`aria-controls`)'});const n=document.getElementById(i);if(!n)throw new ElementError({component:ServiceNavigation,element:n,identifier:`Navigation (\`<ul id="${i}">\`)`});this.$menu=n,this.$menuButton=e,this.setupResponsiveChecks(),this.$menuButton.addEventListener("click",(()=>this.handleMenuButtonClick()))}setupResponsiveChecks(){const t=getBreakpoint("tablet");if(!t.value)throw new ElementError({component:ServiceNavigation,identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){this.mql&&this.$menu&&this.$menuButton&&(this.mql.matches?(this.$menu.removeAttribute("hidden"),this.$menuButton.setAttribute("hidden","")):(this.$menuButton.removeAttribute("hidden"),this.$menuButton.setAttribute("aria-expanded",this.menuIsOpen.toString()),this.menuIsOpen?this.$menu.removeAttribute("hidden"):this.$menu.setAttribute("hidden","")))}handleMenuButtonClick(){this.menuIsOpen=!this.menuIsOpen,this.checkMode()}}ServiceNavigation.moduleName="govuk-service-navigation";class SkipLink extends Component{constructor(t){var e;super(t);const i=this.$root.hash,n=null!=(e=this.$root.getAttribute("href"))?e:"";if(this.$root.origin!==window.location.origin||this.$root.pathname!==window.location.pathname)return;const s=i.replace("#","");if(!s)throw new ElementError(`Skip link: Target link (\`href="${n}"\`) has no hash fragment`);const o=document.getElementById(s);if(!o)throw new ElementError({component:SkipLink,element:o,identifier:`Target content (\`id="${s}"\`)`});this.$root.addEventListener("click",(()=>setFocus(o,{onBeforeFocus(){o.classList.add("govuk-skip-link-focused-element")},onBlur(){o.classList.remove("govuk-skip-link-focused-element")}})))}}SkipLink.elementType=HTMLAnchorElement,SkipLink.moduleName="govuk-skip-link";class Tabs extends Component{constructor(t){super(t),this.$tabs=void 0,this.$tabList=void 0,this.$tabListItems=void 0,this.jsHiddenClass="govuk-tabs__panel--hidden",this.changingHash=!1,this.boundTabClick=void 0,this.boundTabKeydown=void 0,this.boundOnHashChange=void 0,this.mql=null;const e=this.$root.querySelectorAll("a.govuk-tabs__tab");if(!e.length)throw new ElementError({component:Tabs,identifier:'Links (`<a class="govuk-tabs__tab">`)'});this.$tabs=e,this.boundTabClick=this.onTabClick.bind(this),this.boundTabKeydown=this.onTabKeydown.bind(this),this.boundOnHashChange=this.onHashChange.bind(this);const i=this.$root.querySelector(".govuk-tabs__list"),n=this.$root.querySelectorAll("li.govuk-tabs__list-item");if(!i)throw new ElementError({component:Tabs,identifier:'List (`<ul class="govuk-tabs__list">`)'});if(!n.length)throw new ElementError({component:Tabs,identifier:'List items (`<li class="govuk-tabs__list-item">`)'});this.$tabList=i,this.$tabListItems=n,this.setupResponsiveChecks()}setupResponsiveChecks(){const t=getBreakpoint("tablet");if(!t.value)throw new ElementError({component:Tabs,identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){var t;null!=(t=this.mql)&&t.matches?this.setup():this.teardown()}setup(){var t;this.$tabList.setAttribute("role","tablist"),this.$tabListItems.forEach((t=>{t.setAttribute("role","presentation")})),this.$tabs.forEach((t=>{this.setAttributes(t),t.addEventListener("click",this.boundTabClick,!0),t.addEventListener("keydown",this.boundTabKeydown,!0),this.hideTab(t)}));const e=null!=(t=this.getTab(window.location.hash))?t:this.$tabs[0];this.showTab(e),window.addEventListener("hashchange",this.boundOnHashChange,!0)}teardown(){this.$tabList.removeAttribute("role"),this.$tabListItems.forEach((t=>{t.removeAttribute("role")})),this.$tabs.forEach((t=>{t.removeEventListener("click",this.boundTabClick,!0),t.removeEventListener("keydown",this.boundTabKeydown,!0),this.unsetAttributes(t)})),window.removeEventListener("hashchange",this.boundOnHashChange,!0)}onHashChange(){const t=window.location.hash,e=this.getTab(t);if(!e)return;if(this.changingHash)return void(this.changingHash=!1);const i=this.getCurrentTab();i&&(this.hideTab(i),this.showTab(e),e.focus())}hideTab(t){this.unhighlightTab(t),this.hidePanel(t)}showTab(t){this.highlightTab(t),this.showPanel(t)}getTab(t){return this.$root.querySelector(`a.govuk-tabs__tab[href="${t}"]`)}setAttributes(t){const e=t.hash.replace("#","");if(!e)return;t.setAttribute("id",`tab_${e}`),t.setAttribute("role","tab"),t.setAttribute("aria-controls",e),t.setAttribute("aria-selected","false"),t.setAttribute("tabindex","-1");const i=this.getPanel(t);i&&(i.setAttribute("role","tabpanel"),i.setAttribute("aria-labelledby",t.id),i.classList.add(this.jsHiddenClass))}unsetAttributes(t){t.removeAttribute("id"),t.removeAttribute("role"),t.removeAttribute("aria-controls"),t.removeAttribute("aria-selected"),t.removeAttribute("tabindex");const e=this.getPanel(t);e&&(e.removeAttribute("role"),e.removeAttribute("aria-labelledby"),e.classList.remove(this.jsHiddenClass))}onTabClick(t){const e=this.getCurrentTab(),i=t.currentTarget;e&&i instanceof HTMLAnchorElement&&(t.preventDefault(),this.hideTab(e),this.showTab(i),this.createHistoryEntry(i))}createHistoryEntry(t){const e=this.getPanel(t);if(!e)return;const i=e.id;e.id="",this.changingHash=!0,window.location.hash=i,e.id=i}onTabKeydown(t){switch(t.key){case"ArrowLeft":case"Left":this.activatePreviousTab(),t.preventDefault();break;case"ArrowRight":case"Right":this.activateNextTab(),t.preventDefault()}}activateNextTab(){const t=this.getCurrentTab();if(null==t||!t.parentElement)return;const e=t.parentElement.nextElementSibling;if(!e)return;const i=e.querySelector("a.govuk-tabs__tab");i&&(this.hideTab(t),this.showTab(i),i.focus(),this.createHistoryEntry(i))}activatePreviousTab(){const t=this.getCurrentTab();if(null==t||!t.parentElement)return;const e=t.parentElement.previousElementSibling;if(!e)return;const i=e.querySelector("a.govuk-tabs__tab");i&&(this.hideTab(t),this.showTab(i),i.focus(),this.createHistoryEntry(i))}getPanel(t){const e=t.hash.replace("#","");return e?this.$root.querySelector(`#${e}`):null}showPanel(t){const e=this.getPanel(t);e&&e.classList.remove(this.jsHiddenClass)}hidePanel(t){const e=this.getPanel(t);e&&e.classList.add(this.jsHiddenClass)}unhighlightTab(t){t.parentElement&&(t.setAttribute("aria-selected","false"),t.parentElement.classList.remove("govuk-tabs__list-item--selected"),t.setAttribute("tabindex","-1"))}highlightTab(t){t.parentElement&&(t.setAttribute("aria-selected","true"),t.parentElement.classList.add("govuk-tabs__list-item--selected"),t.setAttribute("tabindex","0"))}getCurrentTab(){return this.$root.querySelector(".govuk-tabs__list-item--selected a.govuk-tabs__tab")}}function initAll(t={}){const e=isObject(t)?t:{},i=normaliseOptions(t);try{if(!isSupported())throw new SupportError;if(null===i.scope)throw new ElementError({element:i.scope,identifier:"GOV.UK Frontend scope element (`$scope`)"})}catch(n){return void(i.onError?i.onError(n,{config:e}):console.log(n))}[[Accordion,e.accordion],[Button,e.button],[CharacterCount,e.characterCount],[Checkboxes],[ErrorSummary,e.errorSummary],[ExitThisPage,e.exitThisPage],[FileUpload,e.fileUpload],[Header],[NotificationBanner,e.notificationBanner],[PasswordInput,e.passwordInput],[Radios],[ServiceNavigation],[SkipLink],[Tabs]].forEach((([Component,t])=>{createAll(Component,t,i)}))}function createAll(Component,t,e){let i;const n=normaliseOptions(e);try{var s;if(!isSupported())throw new SupportError;if(null===n.scope)throw new ElementError({element:n.scope,component:Component,identifier:"Scope element (`$scope`)"});i=null==(s=n.scope)?void 0:s.querySelectorAll(`[data-module="${Component.moduleName}"]`)}catch(o){return n.onError?n.onError(o,{component:Component,config:t}):console.log(o),[]}return Array.from(null!=i?i:[]).map((e=>{try{return void 0!==t?new Component(e,t):new Component(e)}catch(o){return n.onError?n.onError(o,{element:e,component:Component,config:t}):console.log(o),null}})).filter(Boolean)}Tabs.moduleName="govuk-tabs";export{Accordion,Button,CharacterCount,Checkboxes,Component,ConfigurableComponent,ErrorSummary,ExitThisPage,FileUpload,Header,NotificationBanner,PasswordInput,Radios,ServiceNavigation,SkipLink,Tabs,createAll,initAll,isSupported,version};//# sourceMappingURL=govuk-frontend.min.js.map
