const version="5.2.0";function mergeConfigs(...t){function flattenObject(t){const e={};return function flattenLoop(t,n){for(const[i,s]of Object.entries(t)){const t=n?`${n}.${i}`:i;s&&"object"==typeof s?flattenLoop(s,t):e[t]=s}}(t),e}const e={};for(const n of t){const t=flattenObject(n);for(const[n,i]of Object.entries(t))e[n]=i}return e}function extractConfigByNamespace(t,e){const n={};for(const[i,s]of Object.entries(t)){const t=i.split(".");if(t[0]===e){t.length>1&&t.shift();n[t.join(".")]=s}}return n}function getFragmentFromUrl(t){if(t.includes("#"))return t.split("#").pop()}function getBreakpoint(t){const e=`--govuk-frontend-breakpoint-${t}`;return{property:e,value:window.getComputedStyle(document.documentElement).getPropertyValue(e)||void 0}}function setFocus(t,e={}){var n;const i=t.getAttribute("tabindex");function onBlur(){var n;null==(n=e.onBlur)||n.call(t),i||t.removeAttribute("tabindex")}i||t.setAttribute("tabindex","-1"),t.addEventListener("focus",(function(){t.addEventListener("blur",onBlur,{once:!0})}),{once:!0}),null==(n=e.onBeforeFocus)||n.call(t),t.focus()}function isSupported(t=document.body){return!!t&&t.classList.contains("govuk-frontend-supported")}function normaliseString(t){if("string"!=typeof t)return t;const e=t.trim();return"true"===e||"false"!==e&&(e.length>0&&isFinite(Number(e))?Number(e):t)}function normaliseDataset(t){const e={};for(const[n,i]of Object.entries(t))e[n]=normaliseString(i);return e}class GOVUKFrontendError extends Error{constructor(...t){super(...t),this.name="GOVUKFrontendError"}}class SupportError extends GOVUKFrontendError{constructor(t=document.body){const e="noModule"in HTMLScriptElement.prototype?'GOV.UK Frontend initialised without `<body class="govuk-frontend-supported">` from template `<script>` snippet':"GOV.UK Frontend is not supported in this browser";super(t?e:'GOV.UK Frontend initialised without `<script type="module">`'),this.name="SupportError"}}class ConfigError extends GOVUKFrontendError{constructor(...t){super(...t),this.name="ConfigError"}}class ElementError extends GOVUKFrontendError{constructor(t){let e="string"==typeof t?t:"";if("object"==typeof t){const{componentName:n,identifier:i,element:s,expectedType:o}=t;e=`${n}: ${i}`,e+=s?` is not of type ${null!=o?o:"HTMLElement"}`:" not found"}super(e),this.name="ElementError"}}class GOVUKFrontendComponent{constructor(){this.checkSupport()}checkSupport(){if(!isSupported())throw new SupportError}}class I18n{constructor(t={},e={}){var n;this.translations=void 0,this.locale=void 0,this.translations=t,this.locale=null!=(n=e.locale)?n:document.documentElement.lang||"en"}t(t,e){if(!t)throw new Error("i18n: lookup key missing");"number"==typeof(null==e?void 0:e.count)&&(t=`${t}.${this.getPluralSuffix(t,e.count)}`);const n=this.translations[t];if("string"==typeof n){if(n.match(/%{(.\S+)}/)){if(!e)throw new Error("i18n: cannot replace placeholders in string if no option data provided");return this.replacePlaceholders(n,e)}return n}return t}replacePlaceholders(t,e){const n=Intl.NumberFormat.supportedLocalesOf(this.locale).length?new Intl.NumberFormat(this.locale):void 0;return t.replace(/%{(.\S+)}/g,(function(t,i){if(Object.prototype.hasOwnProperty.call(e,i)){const t=e[i];return!1===t||"number"!=typeof t&&"string"!=typeof t?"":"number"==typeof t?n?n.format(t):`${t}`:t}throw new Error(`i18n: no data found to replace ${t} placeholder in string`)}))}hasIntlPluralRulesSupport(){return Boolean("PluralRules"in window.Intl&&Intl.PluralRules.supportedLocalesOf(this.locale).length)}getPluralSuffix(t,e){if(e=Number(e),!isFinite(e))return"other";const n=this.hasIntlPluralRulesSupport()?new Intl.PluralRules(this.locale).select(e):this.selectPluralFormUsingFallbackRules(e);if(`${t}.${n}`in this.translations)return n;if(`${t}.other`in this.translations)return console.warn(`i18n: Missing plural form ".${n}" for "${this.locale}" locale. Falling back to ".other".`),"other";throw new Error(`i18n: Plural form ".other" is required for "${this.locale}" locale`)}selectPluralFormUsingFallbackRules(t){t=Math.abs(Math.floor(t));const e=this.getPluralRulesForLocale();return e?I18n.pluralRules[e](t):"other"}getPluralRulesForLocale(){const t=this.locale.split("-")[0];for(const e in I18n.pluralRulesMap){const n=I18n.pluralRulesMap[e];if(n.includes(this.locale)||n.includes(t))return e}}}I18n.pluralRulesMap={arabic:["ar"],chinese:["my","zh","id","ja","jv","ko","ms","th","vi"],french:["hy","bn","fr","gu","hi","fa","pa","zu"],german:["af","sq","az","eu","bg","ca","da","nl","en","et","fi","ka","de","el","hu","lb","no","so","sw","sv","ta","te","tr","ur"],irish:["ga"],russian:["ru","uk"],scottish:["gd"],spanish:["pt-PT","it","es"],welsh:["cy"]},I18n.pluralRules={arabic:t=>0===t?"zero":1===t?"one":2===t?"two":t%100>=3&&t%100<=10?"few":t%100>=11&&t%100<=99?"many":"other",chinese:()=>"other",french:t=>0===t||1===t?"one":"other",german:t=>1===t?"one":"other",irish:t=>1===t?"one":2===t?"two":t>=3&&t<=6?"few":t>=7&&t<=10?"many":"other",russian(t){const e=t%100,n=e%10;return 1===n&&11!==e?"one":n>=2&&n<=4&&!(e>=12&&e<=14)?"few":0===n||n>=5&&n<=9||e>=11&&e<=14?"many":"other"},scottish:t=>1===t||11===t?"one":2===t||12===t?"two":t>=3&&t<=10||t>=13&&t<=19?"few":"other",spanish:t=>1===t?"one":t%1e6==0&&0!==t?"many":"other",welsh:t=>0===t?"zero":1===t?"one":2===t?"two":3===t?"few":6===t?"many":"other"};class Accordion extends GOVUKFrontendComponent{constructor(e,n={}){if(super(),this.$module=void 0,this.config=void 0,this.i18n=void 0,this.controlsClass="govuk-accordion__controls",this.showAllClass="govuk-accordion__show-all",this.showAllTextClass="govuk-accordion__show-all-text",this.sectionClass="govuk-accordion__section",this.sectionExpandedClass="govuk-accordion__section--expanded",this.sectionButtonClass="govuk-accordion__section-button",this.sectionHeaderClass="govuk-accordion__section-header",this.sectionHeadingClass="govuk-accordion__section-heading",this.sectionHeadingDividerClass="govuk-accordion__section-heading-divider",this.sectionHeadingTextClass="govuk-accordion__section-heading-text",this.sectionHeadingTextFocusClass="govuk-accordion__section-heading-text-focus",this.sectionShowHideToggleClass="govuk-accordion__section-toggle",this.sectionShowHideToggleFocusClass="govuk-accordion__section-toggle-focus",this.sectionShowHideTextClass="govuk-accordion__section-toggle-text",this.upChevronIconClass="govuk-accordion-nav__chevron",this.downChevronIconClass="govuk-accordion-nav__chevron--down",this.sectionSummaryClass="govuk-accordion__section-summary",this.sectionSummaryFocusClass="govuk-accordion__section-summary-focus",this.sectionContentClass="govuk-accordion__section-content",this.$sections=void 0,this.browserSupportsSessionStorage=!1,this.$showAllButton=null,this.$showAllIcon=null,this.$showAllText=null,!(e instanceof HTMLElement))throw new ElementError({componentName:"Accordion",element:e,identifier:"Root element (`$module`)"});this.$module=e,this.config=mergeConfigs(Accordion.defaults,n,normaliseDataset(e.dataset)),this.i18n=new I18n(extractConfigByNamespace(this.config,"i18n"));const i=this.$module.querySelectorAll(`.${this.sectionClass}`);if(!i.length)throw new ElementError({componentName:"Accordion",identifier:`Sections (\`<div class="${this.sectionClass}">\`)`});this.$sections=i,this.browserSupportsSessionStorage=t.checkForSessionStorage(),this.initControls(),this.initSectionHeaders();const s=this.checkIfAllSectionsOpen();this.updateShowAllButton(s)}initControls(){this.$showAllButton=document.createElement("button"),this.$showAllButton.setAttribute("type","button"),this.$showAllButton.setAttribute("class",this.showAllClass),this.$showAllButton.setAttribute("aria-expanded","false"),this.$showAllIcon=document.createElement("span"),this.$showAllIcon.classList.add(this.upChevronIconClass),this.$showAllButton.appendChild(this.$showAllIcon);const t=document.createElement("div");t.setAttribute("class",this.controlsClass),t.appendChild(this.$showAllButton),this.$module.insertBefore(t,this.$module.firstChild),this.$showAllText=document.createElement("span"),this.$showAllText.classList.add(this.showAllTextClass),this.$showAllButton.appendChild(this.$showAllText),this.$showAllButton.addEventListener("click",(()=>this.onShowOrHideAllToggle())),"onbeforematch"in document&&document.addEventListener("beforematch",(t=>this.onBeforeMatch(t)))}initSectionHeaders(){this.$sections.forEach(((t,e)=>{const n=t.querySelector(`.${this.sectionHeaderClass}`);if(!n)throw new ElementError({componentName:"Accordion",identifier:`Section headers (\`<div class="${this.sectionHeaderClass}">\`)`});this.constructHeaderMarkup(n,e),this.setExpanded(this.isExpanded(t),t),n.addEventListener("click",(()=>this.onSectionToggle(t))),this.setInitialState(t)}))}constructHeaderMarkup(t,e){const n=t.querySelector(`.${this.sectionButtonClass}`),i=t.querySelector(`.${this.sectionHeadingClass}`),s=t.querySelector(`.${this.sectionSummaryClass}`);if(!i)throw new ElementError({componentName:"Accordion",identifier:`Section heading (\`.${this.sectionHeadingClass}\`)`});if(!n)throw new ElementError({componentName:"Accordion",identifier:`Section button placeholder (\`<span class="${this.sectionButtonClass}">\`)`});const o=document.createElement("button");o.setAttribute("type","button"),o.setAttribute("aria-controls",`${this.$module.id}-content-${e+1}`);for(const d of Array.from(n.attributes))"id"!==d.nodeName&&o.setAttribute(d.nodeName,`${d.nodeValue}`);const r=document.createElement("span");r.classList.add(this.sectionHeadingTextClass),r.id=n.id;const a=document.createElement("span");a.classList.add(this.sectionHeadingTextFocusClass),r.appendChild(a),a.innerHTML=n.innerHTML;const l=document.createElement("span");l.classList.add(this.sectionShowHideToggleClass),l.setAttribute("data-nosnippet","");const c=document.createElement("span");c.classList.add(this.sectionShowHideToggleFocusClass),l.appendChild(c);const h=document.createElement("span"),u=document.createElement("span");if(u.classList.add(this.upChevronIconClass),c.appendChild(u),h.classList.add(this.sectionShowHideTextClass),c.appendChild(h),o.appendChild(r),o.appendChild(this.getButtonPunctuationEl()),null!=s&&s.parentNode){const t=document.createElement("span"),e=document.createElement("span");e.classList.add(this.sectionSummaryFocusClass),t.appendChild(e);for(const n of Array.from(s.attributes))t.setAttribute(n.nodeName,`${n.nodeValue}`);e.innerHTML=s.innerHTML,s.parentNode.replaceChild(t,s),o.appendChild(t),o.appendChild(this.getButtonPunctuationEl())}o.appendChild(l),i.removeChild(n),i.appendChild(o)}onBeforeMatch(t){const e=t.target;if(!(e instanceof Element))return;const n=e.closest(`.${this.sectionClass}`);n&&this.setExpanded(!0,n)}onSectionToggle(t){const e=this.isExpanded(t);this.setExpanded(!e,t),this.storeState(t)}onShowOrHideAllToggle(){const t=!this.checkIfAllSectionsOpen();this.$sections.forEach((e=>{this.setExpanded(t,e),this.storeState(e)})),this.updateShowAllButton(t)}setExpanded(t,e){const n=e.querySelector(`.${this.upChevronIconClass}`),i=e.querySelector(`.${this.sectionShowHideTextClass}`),s=e.querySelector(`.${this.sectionButtonClass}`),o=e.querySelector(`.${this.sectionContentClass}`);if(!o)throw new ElementError({componentName:"Accordion",identifier:`Section content (\`<div class="${this.sectionContentClass}">\`)`});if(!n||!i||!s)return;const r=t?this.i18n.t("hideSection"):this.i18n.t("showSection");i.textContent=r,s.setAttribute("aria-expanded",`${t}`);const a=[],l=e.querySelector(`.${this.sectionHeadingTextClass}`);l&&a.push(`${l.textContent}`.trim());const c=e.querySelector(`.${this.sectionSummaryClass}`);c&&a.push(`${c.textContent}`.trim());const h=t?this.i18n.t("hideSectionAriaLabel"):this.i18n.t("showSectionAriaLabel");a.push(h),s.setAttribute("aria-label",a.join(" , ")),t?(o.removeAttribute("hidden"),e.classList.add(this.sectionExpandedClass),n.classList.remove(this.downChevronIconClass)):(o.setAttribute("hidden","until-found"),e.classList.remove(this.sectionExpandedClass),n.classList.add(this.downChevronIconClass));const u=this.checkIfAllSectionsOpen();this.updateShowAllButton(u)}isExpanded(t){return t.classList.contains(this.sectionExpandedClass)}checkIfAllSectionsOpen(){return this.$sections.length===this.$module.querySelectorAll(`.${this.sectionExpandedClass}`).length}updateShowAllButton(t){this.$showAllButton&&this.$showAllText&&this.$showAllIcon&&(this.$showAllButton.setAttribute("aria-expanded",t.toString()),this.$showAllText.textContent=t?this.i18n.t("hideAllSections"):this.i18n.t("showAllSections"),this.$showAllIcon.classList.toggle(this.downChevronIconClass,!t))}storeState(t){if(this.browserSupportsSessionStorage&&this.config.rememberExpanded){const e=t.querySelector(`.${this.sectionButtonClass}`);if(e){const t=e.getAttribute("aria-controls"),n=e.getAttribute("aria-expanded");t&&n&&window.sessionStorage.setItem(t,n)}}}setInitialState(t){if(this.browserSupportsSessionStorage&&this.config.rememberExpanded){const e=t.querySelector(`.${this.sectionButtonClass}`);if(e){const n=e.getAttribute("aria-controls"),i=n?window.sessionStorage.getItem(n):null;null!==i&&this.setExpanded("true"===i,t)}}}getButtonPunctuationEl(){const t=document.createElement("span");return t.classList.add("govuk-visually-hidden",this.sectionHeadingDividerClass),t.innerHTML=", ",t}}Accordion.moduleName="govuk-accordion",Accordion.defaults=Object.freeze({i18n:{hideAllSections:"Hide all sections",hideSection:"Hide",hideSectionAriaLabel:"Hide this section",showAllSections:"Show all sections",showSection:"Show",showSectionAriaLabel:"Show this section"},rememberExpanded:!0});const t={checkForSessionStorage:function(){const t="this is the test string";let e;try{return window.sessionStorage.setItem(t,t),e=window.sessionStorage.getItem(t)===t.toString(),window.sessionStorage.removeItem(t),e}catch(n){return!1}}};class Button extends GOVUKFrontendComponent{constructor(t,e={}){if(super(),this.$module=void 0,this.config=void 0,this.debounceFormSubmitTimer=null,!(t instanceof HTMLElement))throw new ElementError({componentName:"Button",element:t,identifier:"Root element (`$module`)"});this.$module=t,this.config=mergeConfigs(Button.defaults,e,normaliseDataset(t.dataset)),this.$module.addEventListener("keydown",(t=>this.handleKeyDown(t))),this.$module.addEventListener("click",(t=>this.debounce(t)))}handleKeyDown(t){const e=t.target;32===t.keyCode&&e instanceof HTMLElement&&"button"===e.getAttribute("role")&&(t.preventDefault(),e.click())}debounce(t){if(this.config.preventDoubleClick)return this.debounceFormSubmitTimer?(t.preventDefault(),!1):void(this.debounceFormSubmitTimer=window.setTimeout((()=>{this.debounceFormSubmitTimer=null}),1e3))}}function closestAttributeValue(t,e){const n=t.closest(`[${e}]`);return n?n.getAttribute(e):null}Button.moduleName="govuk-button",Button.defaults=Object.freeze({preventDoubleClick:!1});class CharacterCount extends GOVUKFrontendComponent{constructor(t,e={}){var n,i;if(super(),this.$module=void 0,this.$textarea=void 0,this.$visibleCountMessage=void 0,this.$screenReaderCountMessage=void 0,this.lastInputTimestamp=null,this.lastInputValue="",this.valueChecker=null,this.config=void 0,this.i18n=void 0,this.maxLength=void 0,!(t instanceof HTMLElement))throw new ElementError({componentName:"Character count",element:t,identifier:"Root element (`$module`)"});const s=t.querySelector(".govuk-js-character-count");if(!(s instanceof HTMLTextAreaElement||s instanceof HTMLInputElement))throw new ElementError({componentName:"Character count",element:s,expectedType:"HTMLTextareaElement or HTMLInputElement",identifier:"Form field (`.govuk-js-character-count`)"});const o=normaliseDataset(t.dataset);let r={};("maxwords"in o||"maxlength"in o)&&(r={maxlength:void 0,maxwords:void 0}),this.config=mergeConfigs(CharacterCount.defaults,e,r,o);const a=function(t,e){const n=[];for(const[i,s]of Object.entries(t)){const t=[];for(const{required:n,errorMessage:i}of s)n.every((t=>!!e[t]))||t.push(i);"anyOf"!==i||s.length-t.length>=1||n.push(...t)}return n}(CharacterCount.schema,this.config);if(a[0])throw new ConfigError(`Character count: ${a[0]}`);this.i18n=new I18n(extractConfigByNamespace(this.config,"i18n"),{locale:closestAttributeValue(t,"lang")}),this.maxLength=null!=(n=null!=(i=this.config.maxwords)?i:this.config.maxlength)?n:1/0,this.$module=t,this.$textarea=s;const l=`${this.$textarea.id}-info`,c=document.getElementById(l);if(!c)throw new ElementError({componentName:"Character count",element:c,identifier:`Count message (\`id="${l}"\`)`});`${c.textContent}`.match(/^\s*$/)&&(c.textContent=this.i18n.t("textareaDescription",{count:this.maxLength})),this.$textarea.insertAdjacentElement("afterend",c);const h=document.createElement("div");h.className="govuk-character-count__sr-status govuk-visually-hidden",h.setAttribute("aria-live","polite"),this.$screenReaderCountMessage=h,c.insertAdjacentElement("afterend",h);const u=document.createElement("div");u.className=c.className,u.classList.add("govuk-character-count__status"),u.setAttribute("aria-hidden","true"),this.$visibleCountMessage=u,c.insertAdjacentElement("afterend",u),c.classList.add("govuk-visually-hidden"),this.$textarea.removeAttribute("maxlength"),this.bindChangeEvents(),window.addEventListener("pageshow",(()=>this.updateCountMessage())),this.updateCountMessage()}bindChangeEvents(){this.$textarea.addEventListener("keyup",(()=>this.handleKeyUp())),this.$textarea.addEventListener("focus",(()=>this.handleFocus())),this.$textarea.addEventListener("blur",(()=>this.handleBlur()))}handleKeyUp(){this.updateVisibleCountMessage(),this.lastInputTimestamp=Date.now()}handleFocus(){this.valueChecker=window.setInterval((()=>{(!this.lastInputTimestamp||Date.now()-500>=this.lastInputTimestamp)&&this.updateIfValueChanged()}),1e3)}handleBlur(){this.valueChecker&&window.clearInterval(this.valueChecker)}updateIfValueChanged(){this.$textarea.value!==this.lastInputValue&&(this.lastInputValue=this.$textarea.value,this.updateCountMessage())}updateCountMessage(){this.updateVisibleCountMessage(),this.updateScreenReaderCountMessage()}updateVisibleCountMessage(){const t=this.maxLength-this.count(this.$textarea.value)<0;this.$visibleCountMessage.classList.toggle("govuk-character-count__message--disabled",!this.isOverThreshold()),this.$textarea.classList.toggle("govuk-textarea--error",t),this.$visibleCountMessage.classList.toggle("govuk-error-message",t),this.$visibleCountMessage.classList.toggle("govuk-hint",!t),this.$visibleCountMessage.textContent=this.getCountMessage()}updateScreenReaderCountMessage(){this.isOverThreshold()?this.$screenReaderCountMessage.removeAttribute("aria-hidden"):this.$screenReaderCountMessage.setAttribute("aria-hidden","true"),this.$screenReaderCountMessage.textContent=this.getCountMessage()}count(t){if(this.config.maxwords){var e;return(null!=(e=t.match(/\S+/g))?e:[]).length}return t.length}getCountMessage(){const t=this.maxLength-this.count(this.$textarea.value),e=this.config.maxwords?"words":"characters";return this.formatCountMessage(t,e)}formatCountMessage(t,e){if(0===t)return this.i18n.t(`${e}AtLimit`);const n=t<0?"OverLimit":"UnderLimit";return this.i18n.t(`${e}${n}`,{count:Math.abs(t)})}isOverThreshold(){if(!this.config.threshold)return!0;const t=this.count(this.$textarea.value);return this.maxLength*this.config.threshold/100<=t}}CharacterCount.moduleName="govuk-character-count",CharacterCount.defaults=Object.freeze({threshold:0,i18n:{charactersUnderLimit:{one:"You have %{count} character remaining",other:"You have %{count} characters remaining"},charactersAtLimit:"You have 0 characters remaining",charactersOverLimit:{one:"You have %{count} character too many",other:"You have %{count} characters too many"},wordsUnderLimit:{one:"You have %{count} word remaining",other:"You have %{count} words remaining"},wordsAtLimit:"You have 0 words remaining",wordsOverLimit:{one:"You have %{count} word too many",other:"You have %{count} words too many"},textareaDescription:{other:""}}}),CharacterCount.schema=Object.freeze({anyOf:[{required:["maxwords"],errorMessage:'Either "maxlength" or "maxwords" must be provided'},{required:["maxlength"],errorMessage:'Either "maxlength" or "maxwords" must be provided'}]});class Checkboxes extends GOVUKFrontendComponent{constructor(t){if(super(),this.$module=void 0,this.$inputs=void 0,!(t instanceof HTMLElement))throw new ElementError({componentName:"Checkboxes",element:t,identifier:"Root element (`$module`)"});const e=t.querySelectorAll('input[type="checkbox"]');if(!e.length)throw new ElementError({componentName:"Checkboxes",identifier:'Form inputs (`<input type="checkbox">`)'});this.$module=t,this.$inputs=e,this.$inputs.forEach((t=>{const e=t.getAttribute("data-aria-controls");if(e){if(!document.getElementById(e))throw new ElementError({componentName:"Checkboxes",identifier:`Conditional reveal (\`id="${e}"\`)`});t.setAttribute("aria-controls",e),t.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$module.addEventListener("click",(t=>this.handleClick(t)))}syncAllConditionalReveals(){this.$inputs.forEach((t=>this.syncConditionalRevealWithInputState(t)))}syncConditionalRevealWithInputState(t){const e=t.getAttribute("aria-controls");if(!e)return;const n=document.getElementById(e);if(n&&n.classList.contains("govuk-checkboxes__conditional")){const e=t.checked;t.setAttribute("aria-expanded",e.toString()),n.classList.toggle("govuk-checkboxes__conditional--hidden",!e)}}unCheckAllInputsExcept(t){document.querySelectorAll(`input[type="checkbox"][name="${t.name}"]`).forEach((e=>{t.form===e.form&&e!==t&&(e.checked=!1,this.syncConditionalRevealWithInputState(e))}))}unCheckExclusiveInputs(t){document.querySelectorAll(`input[data-behaviour="exclusive"][type="checkbox"][name="${t.name}"]`).forEach((e=>{t.form===e.form&&(e.checked=!1,this.syncConditionalRevealWithInputState(e))}))}handleClick(t){const e=t.target;if(!(e instanceof HTMLInputElement)||"checkbox"!==e.type)return;if(e.getAttribute("aria-controls")&&this.syncConditionalRevealWithInputState(e),!e.checked)return;"exclusive"===e.getAttribute("data-behaviour")?this.unCheckAllInputsExcept(e):this.unCheckExclusiveInputs(e)}}Checkboxes.moduleName="govuk-checkboxes";class ErrorSummary extends GOVUKFrontendComponent{constructor(t,e={}){if(super(),this.$module=void 0,this.config=void 0,!(t instanceof HTMLElement))throw new ElementError({componentName:"Error summary",element:t,identifier:"Root element (`$module`)"});this.$module=t,this.config=mergeConfigs(ErrorSummary.defaults,e,normaliseDataset(t.dataset)),this.config.disableAutoFocus||setFocus(this.$module),this.$module.addEventListener("click",(t=>this.handleClick(t)))}handleClick(t){const e=t.target;e&&this.focusTarget(e)&&t.preventDefault()}focusTarget(t){if(!(t instanceof HTMLAnchorElement))return!1;const e=getFragmentFromUrl(t.href);if(!e)return!1;const n=document.getElementById(e);if(!n)return!1;const i=this.getAssociatedLegendOrLabel(n);return!!i&&(i.scrollIntoView(),n.focus({preventScroll:!0}),!0)}getAssociatedLegendOrLabel(t){var e;const n=t.closest("fieldset");if(n){const e=n.getElementsByTagName("legend");if(e.length){const n=e[0];if(t instanceof HTMLInputElement&&("checkbox"===t.type||"radio"===t.type))return n;const i=n.getBoundingClientRect().top,s=t.getBoundingClientRect();if(s.height&&window.innerHeight){if(s.top+s.height-i<window.innerHeight/2)return n}}}return null!=(e=document.querySelector(`label[for='${t.getAttribute("id")}']`))?e:t.closest("label")}}ErrorSummary.moduleName="govuk-error-summary",ErrorSummary.defaults=Object.freeze({disableAutoFocus:!1});class ExitThisPage extends GOVUKFrontendComponent{constructor(t,e={}){if(super(),this.$module=void 0,this.config=void 0,this.i18n=void 0,this.$button=void 0,this.$skiplinkButton=null,this.$updateSpan=null,this.$indicatorContainer=null,this.$overlay=null,this.keypressCounter=0,this.lastKeyWasModified=!1,this.timeoutTime=5e3,this.keypressTimeoutId=null,this.timeoutMessageId=null,!(t instanceof HTMLElement))throw new ElementError({componentName:"Exit this page",element:t,identifier:"Root element (`$module`)"});const n=t.querySelector(".govuk-exit-this-page__button");if(!(n instanceof HTMLAnchorElement))throw new ElementError({componentName:"Exit this page",element:n,expectedType:"HTMLAnchorElement",identifier:"Button (`.govuk-exit-this-page__button`)"});this.config=mergeConfigs(ExitThisPage.defaults,e,normaliseDataset(t.dataset)),this.i18n=new I18n(extractConfigByNamespace(this.config,"i18n")),this.$module=t,this.$button=n;const i=document.querySelector(".govuk-js-exit-this-page-skiplink");i instanceof HTMLAnchorElement&&(this.$skiplinkButton=i),this.buildIndicator(),this.initUpdateSpan(),this.initButtonClickHandler(),"govukFrontendExitThisPageKeypress"in document.body.dataset||(document.addEventListener("keyup",this.handleKeypress.bind(this),!0),document.body.dataset.govukFrontendExitThisPageKeypress="true"),window.addEventListener("pageshow",this.resetPage.bind(this))}initUpdateSpan(){this.$updateSpan=document.createElement("span"),this.$updateSpan.setAttribute("role","status"),this.$updateSpan.className="govuk-visually-hidden",this.$module.appendChild(this.$updateSpan)}initButtonClickHandler(){this.$button.addEventListener("click",this.handleClick.bind(this)),this.$skiplinkButton&&this.$skiplinkButton.addEventListener("click",this.handleClick.bind(this))}buildIndicator(){this.$indicatorContainer=document.createElement("div"),this.$indicatorContainer.className="govuk-exit-this-page__indicator",this.$indicatorContainer.setAttribute("aria-hidden","true");for(let t=0;t<3;t++){const t=document.createElement("div");t.className="govuk-exit-this-page__indicator-light",this.$indicatorContainer.appendChild(t)}this.$button.appendChild(this.$indicatorContainer)}updateIndicator(){if(!this.$indicatorContainer)return;this.$indicatorContainer.classList.toggle("govuk-exit-this-page__indicator--visible",this.keypressCounter>0);this.$indicatorContainer.querySelectorAll(".govuk-exit-this-page__indicator-light").forEach(((t,e)=>{t.classList.toggle("govuk-exit-this-page__indicator-light--on",e<this.keypressCounter)}))}exitPage(){this.$updateSpan&&(this.$updateSpan.textContent="",document.body.classList.add("govuk-exit-this-page-hide-content"),this.$overlay=document.createElement("div"),this.$overlay.className="govuk-exit-this-page-overlay",this.$overlay.setAttribute("role","alert"),document.body.appendChild(this.$overlay),this.$overlay.textContent=this.i18n.t("activated"),window.location.href=this.$button.href)}handleClick(t){t.preventDefault(),this.exitPage()}handleKeypress(t){this.$updateSpan&&("Shift"!==t.key&&16!==t.keyCode&&16!==t.which||this.lastKeyWasModified?this.keypressTimeoutId&&this.resetKeypressTimer():(this.keypressCounter+=1,this.updateIndicator(),this.timeoutMessageId&&(window.clearTimeout(this.timeoutMessageId),this.timeoutMessageId=null),this.keypressCounter>=3?(this.keypressCounter=0,this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null),this.exitPage()):1===this.keypressCounter?this.$updateSpan.textContent=this.i18n.t("pressTwoMoreTimes"):this.$updateSpan.textContent=this.i18n.t("pressOneMoreTime"),this.setKeypressTimer()),this.lastKeyWasModified=t.shiftKey)}setKeypressTimer(){this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=window.setTimeout(this.resetKeypressTimer.bind(this),this.timeoutTime)}resetKeypressTimer(){if(!this.$updateSpan)return;this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null);const t=this.$updateSpan;this.keypressCounter=0,t.textContent=this.i18n.t("timedOut"),this.timeoutMessageId=window.setTimeout((()=>{t.textContent=""}),this.timeoutTime),this.updateIndicator()}resetPage(){document.body.classList.remove("govuk-exit-this-page-hide-content"),this.$overlay&&(this.$overlay.remove(),this.$overlay=null),this.$updateSpan&&(this.$updateSpan.setAttribute("role","status"),this.$updateSpan.textContent=""),this.updateIndicator(),this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.timeoutMessageId&&window.clearTimeout(this.timeoutMessageId)}}ExitThisPage.moduleName="govuk-exit-this-page",ExitThisPage.defaults=Object.freeze({i18n:{activated:"Loading.",timedOut:"Exit this page expired.",pressTwoMoreTimes:"Shift, press 2 more times to exit.",pressOneMoreTime:"Shift, press 1 more time to exit."}});class Header extends GOVUKFrontendComponent{constructor(t){if(super(),this.$module=void 0,this.$menuButton=void 0,this.$menu=void 0,this.menuIsOpen=!1,this.mql=null,!t)throw new ElementError({componentName:"Header",element:t,identifier:"Root element (`$module`)"});this.$module=t;const e=t.querySelector(".govuk-js-header-toggle");if(!e)return this;const n=e.getAttribute("aria-controls");if(!n)throw new ElementError({componentName:"Header",identifier:'Navigation button (`<button class="govuk-js-header-toggle">`) attribute (`aria-controls`)'});const i=document.getElementById(n);if(!i)throw new ElementError({componentName:"Header",element:i,identifier:`Navigation (\`<ul id="${n}">\`)`});this.$menu=i,this.$menuButton=e,this.setupResponsiveChecks(),this.$menuButton.addEventListener("click",(()=>this.handleMenuButtonClick()))}setupResponsiveChecks(){const t=getBreakpoint("desktop");if(!t.value)throw new ElementError({componentName:"Header",identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){this.mql&&this.$menu&&this.$menuButton&&(this.mql.matches?(this.$menu.removeAttribute("hidden"),this.$menuButton.setAttribute("hidden","")):(this.$menuButton.removeAttribute("hidden"),this.$menuButton.setAttribute("aria-expanded",this.menuIsOpen.toString()),this.menuIsOpen?this.$menu.removeAttribute("hidden"):this.$menu.setAttribute("hidden","")))}handleMenuButtonClick(){this.menuIsOpen=!this.menuIsOpen,this.checkMode()}}Header.moduleName="govuk-header";class NotificationBanner extends GOVUKFrontendComponent{constructor(t,e={}){if(super(),this.$module=void 0,this.config=void 0,!(t instanceof HTMLElement))throw new ElementError({componentName:"Notification banner",element:t,identifier:"Root element (`$module`)"});this.$module=t,this.config=mergeConfigs(NotificationBanner.defaults,e,normaliseDataset(t.dataset)),"alert"!==this.$module.getAttribute("role")||this.config.disableAutoFocus||setFocus(this.$module)}}NotificationBanner.moduleName="govuk-notification-banner",NotificationBanner.defaults=Object.freeze({disableAutoFocus:!1});class Radios extends GOVUKFrontendComponent{constructor(t){if(super(),this.$module=void 0,this.$inputs=void 0,!(t instanceof HTMLElement))throw new ElementError({componentName:"Radios",element:t,identifier:"Root element (`$module`)"});const e=t.querySelectorAll('input[type="radio"]');if(!e.length)throw new ElementError({componentName:"Radios",identifier:'Form inputs (`<input type="radio">`)'});this.$module=t,this.$inputs=e,this.$inputs.forEach((t=>{const e=t.getAttribute("data-aria-controls");if(e){if(!document.getElementById(e))throw new ElementError({componentName:"Radios",identifier:`Conditional reveal (\`id="${e}"\`)`});t.setAttribute("aria-controls",e),t.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$module.addEventListener("click",(t=>this.handleClick(t)))}syncAllConditionalReveals(){this.$inputs.forEach((t=>this.syncConditionalRevealWithInputState(t)))}syncConditionalRevealWithInputState(t){const e=t.getAttribute("aria-controls");if(!e)return;const n=document.getElementById(e);if(null!=n&&n.classList.contains("govuk-radios__conditional")){const e=t.checked;t.setAttribute("aria-expanded",e.toString()),n.classList.toggle("govuk-radios__conditional--hidden",!e)}}handleClick(t){const e=t.target;if(!(e instanceof HTMLInputElement)||"radio"!==e.type)return;const n=document.querySelectorAll('input[type="radio"][aria-controls]'),i=e.form,s=e.name;n.forEach((t=>{const e=t.form===i;t.name===s&&e&&this.syncConditionalRevealWithInputState(t)}))}}Radios.moduleName="govuk-radios";class SkipLink extends GOVUKFrontendComponent{constructor(t){var e;if(super(),this.$module=void 0,!(t instanceof HTMLAnchorElement))throw new ElementError({componentName:"Skip link",element:t,expectedType:"HTMLAnchorElement",identifier:"Root element (`$module`)"});this.$module=t;const n=this.$module.hash,i=null!=(e=this.$module.getAttribute("href"))?e:"";let s;try{s=new window.URL(this.$module.href)}catch(a){throw new ElementError(`Skip link: Target link (\`href="${i}"\`) is invalid`)}if(s.origin!==window.location.origin||s.pathname!==window.location.pathname)return;const o=getFragmentFromUrl(n);if(!o)throw new ElementError(`Skip link: Target link (\`href="${i}"\`) has no hash fragment`);const r=document.getElementById(o);if(!r)throw new ElementError({componentName:"Skip link",element:r,identifier:`Target content (\`id="${o}"\`)`});this.$module.addEventListener("click",(()=>setFocus(r,{onBeforeFocus(){r.classList.add("govuk-skip-link-focused-element")},onBlur(){r.classList.remove("govuk-skip-link-focused-element")}})))}}SkipLink.moduleName="govuk-skip-link";class Tabs extends GOVUKFrontendComponent{constructor(t){if(super(),this.$module=void 0,this.$tabs=void 0,this.$tabList=void 0,this.$tabListItems=void 0,this.keys={left:37,right:39,up:38,down:40},this.jsHiddenClass="govuk-tabs__panel--hidden",this.changingHash=!1,this.boundTabClick=void 0,this.boundTabKeydown=void 0,this.boundOnHashChange=void 0,this.mql=null,!t)throw new ElementError({componentName:"Tabs",element:t,identifier:"Root element (`$module`)"});const e=t.querySelectorAll("a.govuk-tabs__tab");if(!e.length)throw new ElementError({componentName:"Tabs",identifier:'Links (`<a class="govuk-tabs__tab">`)'});this.$module=t,this.$tabs=e,this.boundTabClick=this.onTabClick.bind(this),this.boundTabKeydown=this.onTabKeydown.bind(this),this.boundOnHashChange=this.onHashChange.bind(this);const n=this.$module.querySelector(".govuk-tabs__list"),i=this.$module.querySelectorAll("li.govuk-tabs__list-item");if(!n)throw new ElementError({componentName:"Tabs",identifier:'List (`<ul class="govuk-tabs__list">`)'});if(!i.length)throw new ElementError({componentName:"Tabs",identifier:'List items (`<li class="govuk-tabs__list-item">`)'});this.$tabList=n,this.$tabListItems=i,this.setupResponsiveChecks()}setupResponsiveChecks(){const t=getBreakpoint("tablet");if(!t.value)throw new ElementError({componentName:"Tabs",identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){var t;null!=(t=this.mql)&&t.matches?this.setup():this.teardown()}setup(){var t;this.$tabList.setAttribute("role","tablist"),this.$tabListItems.forEach((t=>{t.setAttribute("role","presentation")})),this.$tabs.forEach((t=>{this.setAttributes(t),t.addEventListener("click",this.boundTabClick,!0),t.addEventListener("keydown",this.boundTabKeydown,!0),this.hideTab(t)}));const e=null!=(t=this.getTab(window.location.hash))?t:this.$tabs[0];this.showTab(e),window.addEventListener("hashchange",this.boundOnHashChange,!0)}teardown(){this.$tabList.removeAttribute("role"),this.$tabListItems.forEach((t=>{t.removeAttribute("role")})),this.$tabs.forEach((t=>{t.removeEventListener("click",this.boundTabClick,!0),t.removeEventListener("keydown",this.boundTabKeydown,!0),this.unsetAttributes(t)})),window.removeEventListener("hashchange",this.boundOnHashChange,!0)}onHashChange(){const t=window.location.hash,e=this.getTab(t);if(!e)return;if(this.changingHash)return void(this.changingHash=!1);const n=this.getCurrentTab();n&&(this.hideTab(n),this.showTab(e),e.focus())}hideTab(t){this.unhighlightTab(t),this.hidePanel(t)}showTab(t){this.highlightTab(t),this.showPanel(t)}getTab(t){return this.$module.querySelector(`a.govuk-tabs__tab[href="${t}"]`)}setAttributes(t){const e=getFragmentFromUrl(t.href);if(!e)return;t.setAttribute("id",`tab_${e}`),t.setAttribute("role","tab"),t.setAttribute("aria-controls",e),t.setAttribute("aria-selected","false"),t.setAttribute("tabindex","-1");const n=this.getPanel(t);n&&(n.setAttribute("role","tabpanel"),n.setAttribute("aria-labelledby",t.id),n.classList.add(this.jsHiddenClass))}unsetAttributes(t){t.removeAttribute("id"),t.removeAttribute("role"),t.removeAttribute("aria-controls"),t.removeAttribute("aria-selected"),t.removeAttribute("tabindex");const e=this.getPanel(t);e&&(e.removeAttribute("role"),e.removeAttribute("aria-labelledby"),e.classList.remove(this.jsHiddenClass))}onTabClick(t){const e=this.getCurrentTab(),n=t.currentTarget;e&&n instanceof HTMLAnchorElement&&(t.preventDefault(),this.hideTab(e),this.showTab(n),this.createHistoryEntry(n))}createHistoryEntry(t){const e=this.getPanel(t);if(!e)return;const n=e.id;e.id="",this.changingHash=!0,window.location.hash=n,e.id=n}onTabKeydown(t){switch(t.keyCode){case this.keys.left:case this.keys.up:this.activatePreviousTab(),t.preventDefault();break;case this.keys.right:case this.keys.down:this.activateNextTab(),t.preventDefault()}}activateNextTab(){const t=this.getCurrentTab();if(null==t||!t.parentElement)return;const e=t.parentElement.nextElementSibling;if(!e)return;const n=e.querySelector("a.govuk-tabs__tab");n&&(this.hideTab(t),this.showTab(n),n.focus(),this.createHistoryEntry(n))}activatePreviousTab(){const t=this.getCurrentTab();if(null==t||!t.parentElement)return;const e=t.parentElement.previousElementSibling;if(!e)return;const n=e.querySelector("a.govuk-tabs__tab");n&&(this.hideTab(t),this.showTab(n),n.focus(),this.createHistoryEntry(n))}getPanel(t){const e=getFragmentFromUrl(t.href);return e?this.$module.querySelector(`#${e}`):null}showPanel(t){const e=this.getPanel(t);e&&e.classList.remove(this.jsHiddenClass)}hidePanel(t){const e=this.getPanel(t);e&&e.classList.add(this.jsHiddenClass)}unhighlightTab(t){t.parentElement&&(t.setAttribute("aria-selected","false"),t.parentElement.classList.remove("govuk-tabs__list-item--selected"),t.setAttribute("tabindex","-1"))}highlightTab(t){t.parentElement&&(t.setAttribute("aria-selected","true"),t.parentElement.classList.add("govuk-tabs__list-item--selected"),t.setAttribute("tabindex","0"))}getCurrentTab(){return this.$module.querySelector(".govuk-tabs__list-item--selected a.govuk-tabs__tab")}}function initAll(t){var e;if(t=void 0!==t?t:{},!isSupported())return void console.log(new SupportError);const n=[[Accordion,t.accordion],[Button,t.button],[CharacterCount,t.characterCount],[Checkboxes],[ErrorSummary,t.errorSummary],[ExitThisPage,t.exitThisPage],[Header],[NotificationBanner,t.notificationBanner],[Radios],[SkipLink],[Tabs]],i=null!=(e=t.scope)?e:document;n.forEach((([t,e])=>{i.querySelectorAll(`[data-module="${t.moduleName}"]`).forEach((n=>{try{"defaults"in t?new t(n,e):new t(n)}catch(i){console.log(i)}}))}))}Tabs.moduleName="govuk-tabs";export{Accordion,Button,CharacterCount,Checkboxes,ErrorSummary,ExitThisPage,Header,NotificationBanner,Radios,SkipLink,Tabs,initAll,version};//# sourceMappingURL=govuk-frontend.min.js.map
