const version="5.3.0";function normaliseString(e,t){const s=e?e.trim():"";let n,i=null==t?void 0:t.type;switch(i||(["true","false"].includes(s)&&(i="boolean"),s.length>0&&isFinite(Number(s))&&(i="number")),i){case"boolean":n="true"===s;break;case"number":n=Number(s);break;default:n=e}return n}function mergeConfigs(...e){const t={};for(const s of e)for(const e of Object.keys(s)){const n=t[e],i=s[e];isObject(n)&&isObject(i)?t[e]=mergeConfigs(n,i):t[e]=i}return t}function extractConfigByNamespace(e,t,s){const n=e.schema.properties[s];if("object"!==(null==n?void 0:n.type))return;const i={[s]:{}};for(const[o,r]of Object.entries(t)){let e=i;const t=o.split(".");for(const[n,i]of t.entries())"object"==typeof e&&(n<t.length-1?(isObject(e[i])||(e[i]={}),e=e[i]):o!==s&&(e[i]=normaliseString(r)))}return i[s]}function getFragmentFromUrl(e){if(e.includes("#"))return e.split("#").pop()}function getBreakpoint(e){const t=`--govuk-frontend-breakpoint-${e}`;return{property:t,value:window.getComputedStyle(document.documentElement).getPropertyValue(t)||void 0}}function setFocus(e,t={}){var s;const n=e.getAttribute("tabindex");function onBlur(){var s;null==(s=t.onBlur)||s.call(e),n||e.removeAttribute("tabindex")}n||e.setAttribute("tabindex","-1"),e.addEventListener("focus",(function(){e.addEventListener("blur",onBlur,{once:!0})}),{once:!0}),null==(s=t.onBeforeFocus)||s.call(e),e.focus()}function isSupported(e=document.body){return!!e&&e.classList.contains("govuk-frontend-supported")}function isObject(e){return!!e&&"object"==typeof e&&!function(e){return Array.isArray(e)}(e)}function normaliseDataset(e,t){const s={};for(const[n,i]of Object.entries(e.schema.properties))n in t&&(s[n]=normaliseString(t[n],i)),"object"===(null==i?void 0:i.type)&&(s[n]=extractConfigByNamespace(e,t,n));return s}class GOVUKFrontendError extends Error{constructor(...e){super(...e),this.name="GOVUKFrontendError"}}class SupportError extends GOVUKFrontendError{constructor(e=document.body){const t="noModule"in HTMLScriptElement.prototype?'GOV.UK Frontend initialised without `<body class="govuk-frontend-supported">` from template `<script>` snippet':"GOV.UK Frontend is not supported in this browser";super(e?t:'GOV.UK Frontend initialised without `<script type="module">`'),this.name="SupportError"}}class ConfigError extends GOVUKFrontendError{constructor(...e){super(...e),this.name="ConfigError"}}class ElementError extends GOVUKFrontendError{constructor(e){let t="string"==typeof e?e:"";if("object"==typeof e){const{componentName:s,identifier:n,element:i,expectedType:o}=e;t=`${s}: ${n}`,t+=i?` is not of type ${null!=o?o:"HTMLElement"}`:" not found"}super(t),this.name="ElementError"}}class GOVUKFrontendComponent{constructor(){this.checkSupport()}checkSupport(){if(!isSupported())throw new SupportError}}class I18n{constructor(e={},t={}){var s;this.translations=void 0,this.locale=void 0,this.translations=e,this.locale=null!=(s=t.locale)?s:document.documentElement.lang||"en"}t(e,t){if(!e)throw new Error("i18n: lookup key missing");let s=this.translations[e];if("number"==typeof(null==t?void 0:t.count)&&"object"==typeof s){const n=s[this.getPluralSuffix(e,t.count)];n&&(s=n)}if("string"==typeof s){if(s.match(/%{(.\S+)}/)){if(!t)throw new Error("i18n: cannot replace placeholders in string if no option data provided");return this.replacePlaceholders(s,t)}return s}return e}replacePlaceholders(e,t){const s=Intl.NumberFormat.supportedLocalesOf(this.locale).length?new Intl.NumberFormat(this.locale):void 0;return e.replace(/%{(.\S+)}/g,(function(e,n){if(Object.prototype.hasOwnProperty.call(t,n)){const e=t[n];return!1===e||"number"!=typeof e&&"string"!=typeof e?"":"number"==typeof e?s?s.format(e):`${e}`:e}throw new Error(`i18n: no data found to replace ${e} placeholder in string`)}))}hasIntlPluralRulesSupport(){return Boolean("PluralRules"in window.Intl&&Intl.PluralRules.supportedLocalesOf(this.locale).length)}getPluralSuffix(e,t){if(t=Number(t),!isFinite(t))return"other";const s=this.translations[e],n=this.hasIntlPluralRulesSupport()?new Intl.PluralRules(this.locale).select(t):this.selectPluralFormUsingFallbackRules(t);if("object"==typeof s){if(n in s)return n;if("other"in s)return console.warn(`i18n: Missing plural form ".${n}" for "${this.locale}" locale. Falling back to ".other".`),"other"}throw new Error(`i18n: Plural form ".other" is required for "${this.locale}" locale`)}selectPluralFormUsingFallbackRules(e){e=Math.abs(Math.floor(e));const t=this.getPluralRulesForLocale();return t?I18n.pluralRules[t](e):"other"}getPluralRulesForLocale(){const e=this.locale.split("-")[0];for(const t in I18n.pluralRulesMap){const s=I18n.pluralRulesMap[t];if(s.includes(this.locale)||s.includes(e))return t}}}I18n.pluralRulesMap={arabic:["ar"],chinese:["my","zh","id","ja","jv","ko","ms","th","vi"],french:["hy","bn","fr","gu","hi","fa","pa","zu"],german:["af","sq","az","eu","bg","ca","da","nl","en","et","fi","ka","de","el","hu","lb","no","so","sw","sv","ta","te","tr","ur"],irish:["ga"],russian:["ru","uk"],scottish:["gd"],spanish:["pt-PT","it","es"],welsh:["cy"]},I18n.pluralRules={arabic:e=>0===e?"zero":1===e?"one":2===e?"two":e%100>=3&&e%100<=10?"few":e%100>=11&&e%100<=99?"many":"other",chinese:()=>"other",french:e=>0===e||1===e?"one":"other",german:e=>1===e?"one":"other",irish:e=>1===e?"one":2===e?"two":e>=3&&e<=6?"few":e>=7&&e<=10?"many":"other",russian(e){const t=e%100,s=t%10;return 1===s&&11!==t?"one":s>=2&&s<=4&&!(t>=12&&t<=14)?"few":0===s||s>=5&&s<=9||t>=11&&t<=14?"many":"other"},scottish:e=>1===e||11===e?"one":2===e||12===e?"two":e>=3&&e<=10||e>=13&&e<=19?"few":"other",spanish:e=>1===e?"one":e%1e6==0&&0!==e?"many":"other",welsh:e=>0===e?"zero":1===e?"one":2===e?"two":3===e?"few":6===e?"many":"other"};class Accordion extends GOVUKFrontendComponent{constructor(t,s={}){if(super(),this.$module=void 0,this.config=void 0,this.i18n=void 0,this.controlsClass="govuk-accordion__controls",this.showAllClass="govuk-accordion__show-all",this.showAllTextClass="govuk-accordion__show-all-text",this.sectionClass="govuk-accordion__section",this.sectionExpandedClass="govuk-accordion__section--expanded",this.sectionButtonClass="govuk-accordion__section-button",this.sectionHeaderClass="govuk-accordion__section-header",this.sectionHeadingClass="govuk-accordion__section-heading",this.sectionHeadingDividerClass="govuk-accordion__section-heading-divider",this.sectionHeadingTextClass="govuk-accordion__section-heading-text",this.sectionHeadingTextFocusClass="govuk-accordion__section-heading-text-focus",this.sectionShowHideToggleClass="govuk-accordion__section-toggle",this.sectionShowHideToggleFocusClass="govuk-accordion__section-toggle-focus",this.sectionShowHideTextClass="govuk-accordion__section-toggle-text",this.upChevronIconClass="govuk-accordion-nav__chevron",this.downChevronIconClass="govuk-accordion-nav__chevron--down",this.sectionSummaryClass="govuk-accordion__section-summary",this.sectionSummaryFocusClass="govuk-accordion__section-summary-focus",this.sectionContentClass="govuk-accordion__section-content",this.$sections=void 0,this.browserSupportsSessionStorage=!1,this.$showAllButton=null,this.$showAllIcon=null,this.$showAllText=null,!(t instanceof HTMLElement))throw new ElementError({componentName:"Accordion",element:t,identifier:"Root element (`$module`)"});this.$module=t,this.config=mergeConfigs(Accordion.defaults,s,normaliseDataset(Accordion,t.dataset)),this.i18n=new I18n(this.config.i18n);const n=this.$module.querySelectorAll(`.${this.sectionClass}`);if(!n.length)throw new ElementError({componentName:"Accordion",identifier:`Sections (\`<div class="${this.sectionClass}">\`)`});this.$sections=n,this.browserSupportsSessionStorage=e.checkForSessionStorage(),this.initControls(),this.initSectionHeaders();const i=this.checkIfAllSectionsOpen();this.updateShowAllButton(i)}initControls(){this.$showAllButton=document.createElement("button"),this.$showAllButton.setAttribute("type","button"),this.$showAllButton.setAttribute("class",this.showAllClass),this.$showAllButton.setAttribute("aria-expanded","false"),this.$showAllIcon=document.createElement("span"),this.$showAllIcon.classList.add(this.upChevronIconClass),this.$showAllButton.appendChild(this.$showAllIcon);const e=document.createElement("div");e.setAttribute("class",this.controlsClass),e.appendChild(this.$showAllButton),this.$module.insertBefore(e,this.$module.firstChild),this.$showAllText=document.createElement("span"),this.$showAllText.classList.add(this.showAllTextClass),this.$showAllButton.appendChild(this.$showAllText),this.$showAllButton.addEventListener("click",(()=>this.onShowOrHideAllToggle())),"onbeforematch"in document&&document.addEventListener("beforematch",(e=>this.onBeforeMatch(e)))}initSectionHeaders(){this.$sections.forEach(((e,t)=>{const s=e.querySelector(`.${this.sectionHeaderClass}`);if(!s)throw new ElementError({componentName:"Accordion",identifier:`Section headers (\`<div class="${this.sectionHeaderClass}">\`)`});this.constructHeaderMarkup(s,t),this.setExpanded(this.isExpanded(e),e),s.addEventListener("click",(()=>this.onSectionToggle(e))),this.setInitialState(e)}))}constructHeaderMarkup(e,t){const s=e.querySelector(`.${this.sectionButtonClass}`),n=e.querySelector(`.${this.sectionHeadingClass}`),i=e.querySelector(`.${this.sectionSummaryClass}`);if(!n)throw new ElementError({componentName:"Accordion",identifier:`Section heading (\`.${this.sectionHeadingClass}\`)`});if(!s)throw new ElementError({componentName:"Accordion",identifier:`Section button placeholder (\`<span class="${this.sectionButtonClass}">\`)`});const o=document.createElement("button");o.setAttribute("type","button"),o.setAttribute("aria-controls",`${this.$module.id}-content-${t+1}`);for(const d of Array.from(s.attributes))"id"!==d.nodeName&&o.setAttribute(d.nodeName,`${d.nodeValue}`);const r=document.createElement("span");r.classList.add(this.sectionHeadingTextClass),r.id=s.id;const a=document.createElement("span");a.classList.add(this.sectionHeadingTextFocusClass),r.appendChild(a),a.innerHTML=s.innerHTML;const l=document.createElement("span");l.classList.add(this.sectionShowHideToggleClass),l.setAttribute("data-nosnippet","");const c=document.createElement("span");c.classList.add(this.sectionShowHideToggleFocusClass),l.appendChild(c);const h=document.createElement("span"),u=document.createElement("span");if(u.classList.add(this.upChevronIconClass),c.appendChild(u),h.classList.add(this.sectionShowHideTextClass),c.appendChild(h),o.appendChild(r),o.appendChild(this.getButtonPunctuationEl()),null!=i&&i.parentNode){const e=document.createElement("span"),t=document.createElement("span");t.classList.add(this.sectionSummaryFocusClass),e.appendChild(t);for(const s of Array.from(i.attributes))e.setAttribute(s.nodeName,`${s.nodeValue}`);t.innerHTML=i.innerHTML,i.parentNode.replaceChild(e,i),o.appendChild(e),o.appendChild(this.getButtonPunctuationEl())}o.appendChild(l),n.removeChild(s),n.appendChild(o)}onBeforeMatch(e){const t=e.target;if(!(t instanceof Element))return;const s=t.closest(`.${this.sectionClass}`);s&&this.setExpanded(!0,s)}onSectionToggle(e){const t=this.isExpanded(e);this.setExpanded(!t,e),this.storeState(e)}onShowOrHideAllToggle(){const e=!this.checkIfAllSectionsOpen();this.$sections.forEach((t=>{this.setExpanded(e,t),this.storeState(t)})),this.updateShowAllButton(e)}setExpanded(e,t){const s=t.querySelector(`.${this.upChevronIconClass}`),n=t.querySelector(`.${this.sectionShowHideTextClass}`),i=t.querySelector(`.${this.sectionButtonClass}`),o=t.querySelector(`.${this.sectionContentClass}`);if(!o)throw new ElementError({componentName:"Accordion",identifier:`Section content (\`<div class="${this.sectionContentClass}">\`)`});if(!s||!n||!i)return;const r=e?this.i18n.t("hideSection"):this.i18n.t("showSection");n.textContent=r,i.setAttribute("aria-expanded",`${e}`);const a=[],l=t.querySelector(`.${this.sectionHeadingTextClass}`);l&&a.push(`${l.textContent}`.trim());const c=t.querySelector(`.${this.sectionSummaryClass}`);c&&a.push(`${c.textContent}`.trim());const h=e?this.i18n.t("hideSectionAriaLabel"):this.i18n.t("showSectionAriaLabel");a.push(h),i.setAttribute("aria-label",a.join(" , ")),e?(o.removeAttribute("hidden"),t.classList.add(this.sectionExpandedClass),s.classList.remove(this.downChevronIconClass)):(o.setAttribute("hidden","until-found"),t.classList.remove(this.sectionExpandedClass),s.classList.add(this.downChevronIconClass));const u=this.checkIfAllSectionsOpen();this.updateShowAllButton(u)}isExpanded(e){return e.classList.contains(this.sectionExpandedClass)}checkIfAllSectionsOpen(){return this.$sections.length===this.$module.querySelectorAll(`.${this.sectionExpandedClass}`).length}updateShowAllButton(e){this.$showAllButton&&this.$showAllText&&this.$showAllIcon&&(this.$showAllButton.setAttribute("aria-expanded",e.toString()),this.$showAllText.textContent=e?this.i18n.t("hideAllSections"):this.i18n.t("showAllSections"),this.$showAllIcon.classList.toggle(this.downChevronIconClass,!e))}storeState(e){if(this.browserSupportsSessionStorage&&this.config.rememberExpanded){const t=e.querySelector(`.${this.sectionButtonClass}`);if(t){const e=t.getAttribute("aria-controls"),s=t.getAttribute("aria-expanded");e&&s&&window.sessionStorage.setItem(e,s)}}}setInitialState(e){if(this.browserSupportsSessionStorage&&this.config.rememberExpanded){const t=e.querySelector(`.${this.sectionButtonClass}`);if(t){const s=t.getAttribute("aria-controls"),n=s?window.sessionStorage.getItem(s):null;null!==n&&this.setExpanded("true"===n,e)}}}getButtonPunctuationEl(){const e=document.createElement("span");return e.classList.add("govuk-visually-hidden",this.sectionHeadingDividerClass),e.innerHTML=", ",e}}Accordion.moduleName="govuk-accordion",Accordion.defaults=Object.freeze({i18n:{hideAllSections:"Hide all sections",hideSection:"Hide",hideSectionAriaLabel:"Hide this section",showAllSections:"Show all sections",showSection:"Show",showSectionAriaLabel:"Show this section"},rememberExpanded:!0}),Accordion.schema=Object.freeze({properties:{i18n:{type:"object"},rememberExpanded:{type:"boolean"}}});const e={checkForSessionStorage:function(){const e="this is the test string";let t;try{return window.sessionStorage.setItem(e,e),t=window.sessionStorage.getItem(e)===e.toString(),window.sessionStorage.removeItem(e),t}catch(s){return!1}}};class Button extends GOVUKFrontendComponent{constructor(e,t={}){if(super(),this.$module=void 0,this.config=void 0,this.debounceFormSubmitTimer=null,!(e instanceof HTMLElement))throw new ElementError({componentName:"Button",element:e,identifier:"Root element (`$module`)"});this.$module=e,this.config=mergeConfigs(Button.defaults,t,normaliseDataset(Button,e.dataset)),this.$module.addEventListener("keydown",(e=>this.handleKeyDown(e))),this.$module.addEventListener("click",(e=>this.debounce(e)))}handleKeyDown(e){const t=e.target;" "===e.key&&t instanceof HTMLElement&&"button"===t.getAttribute("role")&&(e.preventDefault(),t.click())}debounce(e){if(this.config.preventDoubleClick)return this.debounceFormSubmitTimer?(e.preventDefault(),!1):void(this.debounceFormSubmitTimer=window.setTimeout((()=>{this.debounceFormSubmitTimer=null}),1e3))}}function closestAttributeValue(e,t){const s=e.closest(`[${t}]`);return s?s.getAttribute(t):null}Button.moduleName="govuk-button",Button.defaults=Object.freeze({preventDoubleClick:!1}),Button.schema=Object.freeze({properties:{preventDoubleClick:{type:"boolean"}}});class CharacterCount extends GOVUKFrontendComponent{constructor(e,t={}){var s,n;if(super(),this.$module=void 0,this.$textarea=void 0,this.$visibleCountMessage=void 0,this.$screenReaderCountMessage=void 0,this.lastInputTimestamp=null,this.lastInputValue="",this.valueChecker=null,this.config=void 0,this.i18n=void 0,this.maxLength=void 0,!(e instanceof HTMLElement))throw new ElementError({componentName:"Character count",element:e,identifier:"Root element (`$module`)"});const i=e.querySelector(".govuk-js-character-count");if(!(i instanceof HTMLTextAreaElement||i instanceof HTMLInputElement))throw new ElementError({componentName:"Character count",element:i,expectedType:"HTMLTextareaElement or HTMLInputElement",identifier:"Form field (`.govuk-js-character-count`)"});const o=normaliseDataset(CharacterCount,e.dataset);let r={};("maxwords"in o||"maxlength"in o)&&(r={maxlength:void 0,maxwords:void 0}),this.config=mergeConfigs(CharacterCount.defaults,t,r,o);const a=function(e,t){const s=[];for(const[n,i]of Object.entries(e)){const e=[];if(Array.isArray(i)){for(const{required:s,errorMessage:n}of i)s.every((e=>!!t[e]))||e.push(n);"anyOf"!==n||i.length-e.length>=1||s.push(...e)}}return s}(CharacterCount.schema,this.config);if(a[0])throw new ConfigError(`Character count: ${a[0]}`);this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(e,"lang")}),this.maxLength=null!=(s=null!=(n=this.config.maxwords)?n:this.config.maxlength)?s:1/0,this.$module=e,this.$textarea=i;const l=`${this.$textarea.id}-info`,c=document.getElementById(l);if(!c)throw new ElementError({componentName:"Character count",element:c,identifier:`Count message (\`id="${l}"\`)`});`${c.textContent}`.match(/^\s*$/)&&(c.textContent=this.i18n.t("textareaDescription",{count:this.maxLength})),this.$textarea.insertAdjacentElement("afterend",c);const h=document.createElement("div");h.className="govuk-character-count__sr-status govuk-visually-hidden",h.setAttribute("aria-live","polite"),this.$screenReaderCountMessage=h,c.insertAdjacentElement("afterend",h);const u=document.createElement("div");u.className=c.className,u.classList.add("govuk-character-count__status"),u.setAttribute("aria-hidden","true"),this.$visibleCountMessage=u,c.insertAdjacentElement("afterend",u),c.classList.add("govuk-visually-hidden"),this.$textarea.removeAttribute("maxlength"),this.bindChangeEvents(),window.addEventListener("pageshow",(()=>this.updateCountMessage())),this.updateCountMessage()}bindChangeEvents(){this.$textarea.addEventListener("keyup",(()=>this.handleKeyUp())),this.$textarea.addEventListener("focus",(()=>this.handleFocus())),this.$textarea.addEventListener("blur",(()=>this.handleBlur()))}handleKeyUp(){this.updateVisibleCountMessage(),this.lastInputTimestamp=Date.now()}handleFocus(){this.valueChecker=window.setInterval((()=>{(!this.lastInputTimestamp||Date.now()-500>=this.lastInputTimestamp)&&this.updateIfValueChanged()}),1e3)}handleBlur(){this.valueChecker&&window.clearInterval(this.valueChecker)}updateIfValueChanged(){this.$textarea.value!==this.lastInputValue&&(this.lastInputValue=this.$textarea.value,this.updateCountMessage())}updateCountMessage(){this.updateVisibleCountMessage(),this.updateScreenReaderCountMessage()}updateVisibleCountMessage(){const e=this.maxLength-this.count(this.$textarea.value)<0;this.$visibleCountMessage.classList.toggle("govuk-character-count__message--disabled",!this.isOverThreshold()),this.$textarea.classList.toggle("govuk-textarea--error",e),this.$visibleCountMessage.classList.toggle("govuk-error-message",e),this.$visibleCountMessage.classList.toggle("govuk-hint",!e),this.$visibleCountMessage.textContent=this.getCountMessage()}updateScreenReaderCountMessage(){this.isOverThreshold()?this.$screenReaderCountMessage.removeAttribute("aria-hidden"):this.$screenReaderCountMessage.setAttribute("aria-hidden","true"),this.$screenReaderCountMessage.textContent=this.getCountMessage()}count(e){if(this.config.maxwords){var t;return(null!=(t=e.match(/\S+/g))?t:[]).length}return e.length}getCountMessage(){const e=this.maxLength-this.count(this.$textarea.value),t=this.config.maxwords?"words":"characters";return this.formatCountMessage(e,t)}formatCountMessage(e,t){if(0===e)return this.i18n.t(`${t}AtLimit`);const s=e<0?"OverLimit":"UnderLimit";return this.i18n.t(`${t}${s}`,{count:Math.abs(e)})}isOverThreshold(){if(!this.config.threshold)return!0;const e=this.count(this.$textarea.value);return this.maxLength*this.config.threshold/100<=e}}CharacterCount.moduleName="govuk-character-count",CharacterCount.defaults=Object.freeze({threshold:0,i18n:{charactersUnderLimit:{one:"You have %{count} character remaining",other:"You have %{count} characters remaining"},charactersAtLimit:"You have 0 characters remaining",charactersOverLimit:{one:"You have %{count} character too many",other:"You have %{count} characters too many"},wordsUnderLimit:{one:"You have %{count} word remaining",other:"You have %{count} words remaining"},wordsAtLimit:"You have 0 words remaining",wordsOverLimit:{one:"You have %{count} word too many",other:"You have %{count} words too many"},textareaDescription:{other:""}}}),CharacterCount.schema=Object.freeze({properties:{i18n:{type:"object"},maxwords:{type:"number"},maxlength:{type:"number"},threshold:{type:"number"}},anyOf:[{required:["maxwords"],errorMessage:'Either "maxlength" or "maxwords" must be provided'},{required:["maxlength"],errorMessage:'Either "maxlength" or "maxwords" must be provided'}]});class Checkboxes extends GOVUKFrontendComponent{constructor(e){if(super(),this.$module=void 0,this.$inputs=void 0,!(e instanceof HTMLElement))throw new ElementError({componentName:"Checkboxes",element:e,identifier:"Root element (`$module`)"});const t=e.querySelectorAll('input[type="checkbox"]');if(!t.length)throw new ElementError({componentName:"Checkboxes",identifier:'Form inputs (`<input type="checkbox">`)'});this.$module=e,this.$inputs=t,this.$inputs.forEach((e=>{const t=e.getAttribute("data-aria-controls");if(t){if(!document.getElementById(t))throw new ElementError({componentName:"Checkboxes",identifier:`Conditional reveal (\`id="${t}"\`)`});e.setAttribute("aria-controls",t),e.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$module.addEventListener("click",(e=>this.handleClick(e)))}syncAllConditionalReveals(){this.$inputs.forEach((e=>this.syncConditionalRevealWithInputState(e)))}syncConditionalRevealWithInputState(e){const t=e.getAttribute("aria-controls");if(!t)return;const s=document.getElementById(t);if(s&&s.classList.contains("govuk-checkboxes__conditional")){const t=e.checked;e.setAttribute("aria-expanded",t.toString()),s.classList.toggle("govuk-checkboxes__conditional--hidden",!t)}}unCheckAllInputsExcept(e){document.querySelectorAll(`input[type="checkbox"][name="${e.name}"]`).forEach((t=>{e.form===t.form&&t!==e&&(t.checked=!1,this.syncConditionalRevealWithInputState(t))}))}unCheckExclusiveInputs(e){document.querySelectorAll(`input[data-behaviour="exclusive"][type="checkbox"][name="${e.name}"]`).forEach((t=>{e.form===t.form&&(t.checked=!1,this.syncConditionalRevealWithInputState(t))}))}handleClick(e){const t=e.target;if(!(t instanceof HTMLInputElement)||"checkbox"!==t.type)return;if(t.getAttribute("aria-controls")&&this.syncConditionalRevealWithInputState(t),!t.checked)return;"exclusive"===t.getAttribute("data-behaviour")?this.unCheckAllInputsExcept(t):this.unCheckExclusiveInputs(t)}}Checkboxes.moduleName="govuk-checkboxes";class ErrorSummary extends GOVUKFrontendComponent{constructor(e,t={}){if(super(),this.$module=void 0,this.config=void 0,!(e instanceof HTMLElement))throw new ElementError({componentName:"Error summary",element:e,identifier:"Root element (`$module`)"});this.$module=e,this.config=mergeConfigs(ErrorSummary.defaults,t,normaliseDataset(ErrorSummary,e.dataset)),this.config.disableAutoFocus||setFocus(this.$module),this.$module.addEventListener("click",(e=>this.handleClick(e)))}handleClick(e){const t=e.target;t&&this.focusTarget(t)&&e.preventDefault()}focusTarget(e){if(!(e instanceof HTMLAnchorElement))return!1;const t=getFragmentFromUrl(e.href);if(!t)return!1;const s=document.getElementById(t);if(!s)return!1;const n=this.getAssociatedLegendOrLabel(s);return!!n&&(n.scrollIntoView(),s.focus({preventScroll:!0}),!0)}getAssociatedLegendOrLabel(e){var t;const s=e.closest("fieldset");if(s){const t=s.getElementsByTagName("legend");if(t.length){const s=t[0];if(e instanceof HTMLInputElement&&("checkbox"===e.type||"radio"===e.type))return s;const n=s.getBoundingClientRect().top,i=e.getBoundingClientRect();if(i.height&&window.innerHeight){if(i.top+i.height-n<window.innerHeight/2)return s}}}return null!=(t=document.querySelector(`label[for='${e.getAttribute("id")}']`))?t:e.closest("label")}}ErrorSummary.moduleName="govuk-error-summary",ErrorSummary.defaults=Object.freeze({disableAutoFocus:!1}),ErrorSummary.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class ExitThisPage extends GOVUKFrontendComponent{constructor(e,t={}){if(super(),this.$module=void 0,this.config=void 0,this.i18n=void 0,this.$button=void 0,this.$skiplinkButton=null,this.$updateSpan=null,this.$indicatorContainer=null,this.$overlay=null,this.keypressCounter=0,this.lastKeyWasModified=!1,this.timeoutTime=5e3,this.keypressTimeoutId=null,this.timeoutMessageId=null,!(e instanceof HTMLElement))throw new ElementError({componentName:"Exit this page",element:e,identifier:"Root element (`$module`)"});const s=e.querySelector(".govuk-exit-this-page__button");if(!(s instanceof HTMLAnchorElement))throw new ElementError({componentName:"Exit this page",element:s,expectedType:"HTMLAnchorElement",identifier:"Button (`.govuk-exit-this-page__button`)"});this.config=mergeConfigs(ExitThisPage.defaults,t,normaliseDataset(ExitThisPage,e.dataset)),this.i18n=new I18n(this.config.i18n),this.$module=e,this.$button=s;const n=document.querySelector(".govuk-js-exit-this-page-skiplink");n instanceof HTMLAnchorElement&&(this.$skiplinkButton=n),this.buildIndicator(),this.initUpdateSpan(),this.initButtonClickHandler(),"govukFrontendExitThisPageKeypress"in document.body.dataset||(document.addEventListener("keyup",this.handleKeypress.bind(this),!0),document.body.dataset.govukFrontendExitThisPageKeypress="true"),window.addEventListener("pageshow",this.resetPage.bind(this))}initUpdateSpan(){this.$updateSpan=document.createElement("span"),this.$updateSpan.setAttribute("role","status"),this.$updateSpan.className="govuk-visually-hidden",this.$module.appendChild(this.$updateSpan)}initButtonClickHandler(){this.$button.addEventListener("click",this.handleClick.bind(this)),this.$skiplinkButton&&this.$skiplinkButton.addEventListener("click",this.handleClick.bind(this))}buildIndicator(){this.$indicatorContainer=document.createElement("div"),this.$indicatorContainer.className="govuk-exit-this-page__indicator",this.$indicatorContainer.setAttribute("aria-hidden","true");for(let e=0;e<3;e++){const e=document.createElement("div");e.className="govuk-exit-this-page__indicator-light",this.$indicatorContainer.appendChild(e)}this.$button.appendChild(this.$indicatorContainer)}updateIndicator(){if(!this.$indicatorContainer)return;this.$indicatorContainer.classList.toggle("govuk-exit-this-page__indicator--visible",this.keypressCounter>0);this.$indicatorContainer.querySelectorAll(".govuk-exit-this-page__indicator-light").forEach(((e,t)=>{e.classList.toggle("govuk-exit-this-page__indicator-light--on",t<this.keypressCounter)}))}exitPage(){this.$updateSpan&&(this.$updateSpan.textContent="",document.body.classList.add("govuk-exit-this-page-hide-content"),this.$overlay=document.createElement("div"),this.$overlay.className="govuk-exit-this-page-overlay",this.$overlay.setAttribute("role","alert"),document.body.appendChild(this.$overlay),this.$overlay.textContent=this.i18n.t("activated"),window.location.href=this.$button.href)}handleClick(e){e.preventDefault(),this.exitPage()}handleKeypress(e){this.$updateSpan&&("Shift"!==e.key||this.lastKeyWasModified?this.keypressTimeoutId&&this.resetKeypressTimer():(this.keypressCounter+=1,this.updateIndicator(),this.timeoutMessageId&&(window.clearTimeout(this.timeoutMessageId),this.timeoutMessageId=null),this.keypressCounter>=3?(this.keypressCounter=0,this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null),this.exitPage()):1===this.keypressCounter?this.$updateSpan.textContent=this.i18n.t("pressTwoMoreTimes"):this.$updateSpan.textContent=this.i18n.t("pressOneMoreTime"),this.setKeypressTimer()),this.lastKeyWasModified=e.shiftKey)}setKeypressTimer(){this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=window.setTimeout(this.resetKeypressTimer.bind(this),this.timeoutTime)}resetKeypressTimer(){if(!this.$updateSpan)return;this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null);const e=this.$updateSpan;this.keypressCounter=0,e.textContent=this.i18n.t("timedOut"),this.timeoutMessageId=window.setTimeout((()=>{e.textContent=""}),this.timeoutTime),this.updateIndicator()}resetPage(){document.body.classList.remove("govuk-exit-this-page-hide-content"),this.$overlay&&(this.$overlay.remove(),this.$overlay=null),this.$updateSpan&&(this.$updateSpan.setAttribute("role","status"),this.$updateSpan.textContent=""),this.updateIndicator(),this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.timeoutMessageId&&window.clearTimeout(this.timeoutMessageId)}}ExitThisPage.moduleName="govuk-exit-this-page",ExitThisPage.defaults=Object.freeze({i18n:{activated:"Loading.",timedOut:"Exit this page expired.",pressTwoMoreTimes:"Shift, press 2 more times to exit.",pressOneMoreTime:"Shift, press 1 more time to exit."}}),ExitThisPage.schema=Object.freeze({properties:{i18n:{type:"object"}}});class Header extends GOVUKFrontendComponent{constructor(e){if(super(),this.$module=void 0,this.$menuButton=void 0,this.$menu=void 0,this.menuIsOpen=!1,this.mql=null,!e)throw new ElementError({componentName:"Header",element:e,identifier:"Root element (`$module`)"});this.$module=e;const t=e.querySelector(".govuk-js-header-toggle");if(!t)return this;const s=t.getAttribute("aria-controls");if(!s)throw new ElementError({componentName:"Header",identifier:'Navigation button (`<button class="govuk-js-header-toggle">`) attribute (`aria-controls`)'});const n=document.getElementById(s);if(!n)throw new ElementError({componentName:"Header",element:n,identifier:`Navigation (\`<ul id="${s}">\`)`});this.$menu=n,this.$menuButton=t,this.setupResponsiveChecks(),this.$menuButton.addEventListener("click",(()=>this.handleMenuButtonClick()))}setupResponsiveChecks(){const e=getBreakpoint("desktop");if(!e.value)throw new ElementError({componentName:"Header",identifier:`CSS custom property (\`${e.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${e.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){this.mql&&this.$menu&&this.$menuButton&&(this.mql.matches?(this.$menu.removeAttribute("hidden"),this.$menuButton.setAttribute("hidden","")):(this.$menuButton.removeAttribute("hidden"),this.$menuButton.setAttribute("aria-expanded",this.menuIsOpen.toString()),this.menuIsOpen?this.$menu.removeAttribute("hidden"):this.$menu.setAttribute("hidden","")))}handleMenuButtonClick(){this.menuIsOpen=!this.menuIsOpen,this.checkMode()}}Header.moduleName="govuk-header";class NotificationBanner extends GOVUKFrontendComponent{constructor(e,t={}){if(super(),this.$module=void 0,this.config=void 0,!(e instanceof HTMLElement))throw new ElementError({componentName:"Notification banner",element:e,identifier:"Root element (`$module`)"});this.$module=e,this.config=mergeConfigs(NotificationBanner.defaults,t,normaliseDataset(NotificationBanner,e.dataset)),"alert"!==this.$module.getAttribute("role")||this.config.disableAutoFocus||setFocus(this.$module)}}NotificationBanner.moduleName="govuk-notification-banner",NotificationBanner.defaults=Object.freeze({disableAutoFocus:!1}),NotificationBanner.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class PasswordInput extends GOVUKFrontendComponent{constructor(e,t={}){if(super(),this.$module=void 0,this.config=void 0,this.i18n=void 0,this.$input=void 0,this.$showHideButton=void 0,this.$screenReaderStatusMessage=void 0,!(e instanceof HTMLElement))throw new ElementError({componentName:"Password input",element:e,identifier:"Root element (`$module`)"});const s=e.querySelector(".govuk-js-password-input-input");if(!(s instanceof HTMLInputElement))throw new ElementError({componentName:"Password input",element:s,expectedType:"HTMLInputElement",identifier:"Form field (`.govuk-js-password-input-input`)"});if("password"!==s.type)throw new ElementError("Password input: Form field (`.govuk-js-password-input-input`) must be of type `password`.");const n=e.querySelector(".govuk-js-password-input-toggle");if(!(n instanceof HTMLButtonElement))throw new ElementError({componentName:"Password input",element:n,expectedType:"HTMLButtonElement",identifier:"Button (`.govuk-js-password-input-toggle`)"});if("button"!==n.type)throw new ElementError("Password input: Button (`.govuk-js-password-input-toggle`) must be of type `button`.");this.$module=e,this.$input=s,this.$showHideButton=n,this.config=mergeConfigs(PasswordInput.defaults,t,normaliseDataset(PasswordInput,e.dataset)),this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(e,"lang")}),this.$showHideButton.removeAttribute("hidden");const i=document.createElement("div");i.className="govuk-password-input__sr-status govuk-visually-hidden",i.setAttribute("aria-live","polite"),this.$screenReaderStatusMessage=i,this.$input.insertAdjacentElement("afterend",i),this.$showHideButton.addEventListener("click",this.toggle.bind(this)),this.$input.form&&this.$input.form.addEventListener("submit",(()=>this.hide())),window.addEventListener("pageshow",(e=>{e.persisted&&"password"!==this.$input.type&&this.hide()})),this.hide()}toggle(e){e.preventDefault(),"password"!==this.$input.type?this.hide():this.show()}show(){this.setType("text")}hide(){this.setType("password")}setType(e){if(e===this.$input.type)return;this.$input.setAttribute("type",e);const t="password"===e,s=t?"show":"hide",n=t?"passwordHidden":"passwordShown";this.$showHideButton.innerText=this.i18n.t(`${s}Password`),this.$showHideButton.setAttribute("aria-label",this.i18n.t(`${s}PasswordAriaLabel`)),this.$screenReaderStatusMessage.innerText=this.i18n.t(`${n}Announcement`)}}PasswordInput.moduleName="govuk-password-input",PasswordInput.defaults=Object.freeze({i18n:{showPassword:"Show",hidePassword:"Hide",showPasswordAriaLabel:"Show password",hidePasswordAriaLabel:"Hide password",passwordShownAnnouncement:"Your password is visible",passwordHiddenAnnouncement:"Your password is hidden"}}),PasswordInput.schema=Object.freeze({properties:{i18n:{type:"object"}}});class Radios extends GOVUKFrontendComponent{constructor(e){if(super(),this.$module=void 0,this.$inputs=void 0,!(e instanceof HTMLElement))throw new ElementError({componentName:"Radios",element:e,identifier:"Root element (`$module`)"});const t=e.querySelectorAll('input[type="radio"]');if(!t.length)throw new ElementError({componentName:"Radios",identifier:'Form inputs (`<input type="radio">`)'});this.$module=e,this.$inputs=t,this.$inputs.forEach((e=>{const t=e.getAttribute("data-aria-controls");if(t){if(!document.getElementById(t))throw new ElementError({componentName:"Radios",identifier:`Conditional reveal (\`id="${t}"\`)`});e.setAttribute("aria-controls",t),e.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$module.addEventListener("click",(e=>this.handleClick(e)))}syncAllConditionalReveals(){this.$inputs.forEach((e=>this.syncConditionalRevealWithInputState(e)))}syncConditionalRevealWithInputState(e){const t=e.getAttribute("aria-controls");if(!t)return;const s=document.getElementById(t);if(null!=s&&s.classList.contains("govuk-radios__conditional")){const t=e.checked;e.setAttribute("aria-expanded",t.toString()),s.classList.toggle("govuk-radios__conditional--hidden",!t)}}handleClick(e){const t=e.target;if(!(t instanceof HTMLInputElement)||"radio"!==t.type)return;const s=document.querySelectorAll('input[type="radio"][aria-controls]'),n=t.form,i=t.name;s.forEach((e=>{const t=e.form===n;e.name===i&&t&&this.syncConditionalRevealWithInputState(e)}))}}Radios.moduleName="govuk-radios";class SkipLink extends GOVUKFrontendComponent{constructor(e){var t;if(super(),this.$module=void 0,!(e instanceof HTMLAnchorElement))throw new ElementError({componentName:"Skip link",element:e,expectedType:"HTMLAnchorElement",identifier:"Root element (`$module`)"});this.$module=e;const s=this.$module.hash,n=null!=(t=this.$module.getAttribute("href"))?t:"";let i;try{i=new window.URL(this.$module.href)}catch(a){throw new ElementError(`Skip link: Target link (\`href="${n}"\`) is invalid`)}if(i.origin!==window.location.origin||i.pathname!==window.location.pathname)return;const o=getFragmentFromUrl(s);if(!o)throw new ElementError(`Skip link: Target link (\`href="${n}"\`) has no hash fragment`);const r=document.getElementById(o);if(!r)throw new ElementError({componentName:"Skip link",element:r,identifier:`Target content (\`id="${o}"\`)`});this.$module.addEventListener("click",(()=>setFocus(r,{onBeforeFocus(){r.classList.add("govuk-skip-link-focused-element")},onBlur(){r.classList.remove("govuk-skip-link-focused-element")}})))}}SkipLink.moduleName="govuk-skip-link";class Tabs extends GOVUKFrontendComponent{constructor(e){if(super(),this.$module=void 0,this.$tabs=void 0,this.$tabList=void 0,this.$tabListItems=void 0,this.jsHiddenClass="govuk-tabs__panel--hidden",this.changingHash=!1,this.boundTabClick=void 0,this.boundTabKeydown=void 0,this.boundOnHashChange=void 0,this.mql=null,!e)throw new ElementError({componentName:"Tabs",element:e,identifier:"Root element (`$module`)"});const t=e.querySelectorAll("a.govuk-tabs__tab");if(!t.length)throw new ElementError({componentName:"Tabs",identifier:'Links (`<a class="govuk-tabs__tab">`)'});this.$module=e,this.$tabs=t,this.boundTabClick=this.onTabClick.bind(this),this.boundTabKeydown=this.onTabKeydown.bind(this),this.boundOnHashChange=this.onHashChange.bind(this);const s=this.$module.querySelector(".govuk-tabs__list"),n=this.$module.querySelectorAll("li.govuk-tabs__list-item");if(!s)throw new ElementError({componentName:"Tabs",identifier:'List (`<ul class="govuk-tabs__list">`)'});if(!n.length)throw new ElementError({componentName:"Tabs",identifier:'List items (`<li class="govuk-tabs__list-item">`)'});this.$tabList=s,this.$tabListItems=n,this.setupResponsiveChecks()}setupResponsiveChecks(){const e=getBreakpoint("tablet");if(!e.value)throw new ElementError({componentName:"Tabs",identifier:`CSS custom property (\`${e.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${e.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){var e;null!=(e=this.mql)&&e.matches?this.setup():this.teardown()}setup(){var e;this.$tabList.setAttribute("role","tablist"),this.$tabListItems.forEach((e=>{e.setAttribute("role","presentation")})),this.$tabs.forEach((e=>{this.setAttributes(e),e.addEventListener("click",this.boundTabClick,!0),e.addEventListener("keydown",this.boundTabKeydown,!0),this.hideTab(e)}));const t=null!=(e=this.getTab(window.location.hash))?e:this.$tabs[0];this.showTab(t),window.addEventListener("hashchange",this.boundOnHashChange,!0)}teardown(){this.$tabList.removeAttribute("role"),this.$tabListItems.forEach((e=>{e.removeAttribute("role")})),this.$tabs.forEach((e=>{e.removeEventListener("click",this.boundTabClick,!0),e.removeEventListener("keydown",this.boundTabKeydown,!0),this.unsetAttributes(e)})),window.removeEventListener("hashchange",this.boundOnHashChange,!0)}onHashChange(){const e=window.location.hash,t=this.getTab(e);if(!t)return;if(this.changingHash)return void(this.changingHash=!1);const s=this.getCurrentTab();s&&(this.hideTab(s),this.showTab(t),t.focus())}hideTab(e){this.unhighlightTab(e),this.hidePanel(e)}showTab(e){this.highlightTab(e),this.showPanel(e)}getTab(e){return this.$module.querySelector(`a.govuk-tabs__tab[href="${e}"]`)}setAttributes(e){const t=getFragmentFromUrl(e.href);if(!t)return;e.setAttribute("id",`tab_${t}`),e.setAttribute("role","tab"),e.setAttribute("aria-controls",t),e.setAttribute("aria-selected","false"),e.setAttribute("tabindex","-1");const s=this.getPanel(e);s&&(s.setAttribute("role","tabpanel"),s.setAttribute("aria-labelledby",e.id),s.classList.add(this.jsHiddenClass))}unsetAttributes(e){e.removeAttribute("id"),e.removeAttribute("role"),e.removeAttribute("aria-controls"),e.removeAttribute("aria-selected"),e.removeAttribute("tabindex");const t=this.getPanel(e);t&&(t.removeAttribute("role"),t.removeAttribute("aria-labelledby"),t.classList.remove(this.jsHiddenClass))}onTabClick(e){const t=this.getCurrentTab(),s=e.currentTarget;t&&s instanceof HTMLAnchorElement&&(e.preventDefault(),this.hideTab(t),this.showTab(s),this.createHistoryEntry(s))}createHistoryEntry(e){const t=this.getPanel(e);if(!t)return;const s=t.id;t.id="",this.changingHash=!0,window.location.hash=s,t.id=s}onTabKeydown(e){switch(e.key){case"ArrowLeft":case"ArrowUp":case"Left":case"Up":this.activatePreviousTab(),e.preventDefault();break;case"ArrowRight":case"ArrowDown":case"Right":case"Down":this.activateNextTab(),e.preventDefault()}}activateNextTab(){const e=this.getCurrentTab();if(null==e||!e.parentElement)return;const t=e.parentElement.nextElementSibling;if(!t)return;const s=t.querySelector("a.govuk-tabs__tab");s&&(this.hideTab(e),this.showTab(s),s.focus(),this.createHistoryEntry(s))}activatePreviousTab(){const e=this.getCurrentTab();if(null==e||!e.parentElement)return;const t=e.parentElement.previousElementSibling;if(!t)return;const s=t.querySelector("a.govuk-tabs__tab");s&&(this.hideTab(e),this.showTab(s),s.focus(),this.createHistoryEntry(s))}getPanel(e){const t=getFragmentFromUrl(e.href);return t?this.$module.querySelector(`#${t}`):null}showPanel(e){const t=this.getPanel(e);t&&t.classList.remove(this.jsHiddenClass)}hidePanel(e){const t=this.getPanel(e);t&&t.classList.add(this.jsHiddenClass)}unhighlightTab(e){e.parentElement&&(e.setAttribute("aria-selected","false"),e.parentElement.classList.remove("govuk-tabs__list-item--selected"),e.setAttribute("tabindex","-1"))}highlightTab(e){e.parentElement&&(e.setAttribute("aria-selected","true"),e.parentElement.classList.add("govuk-tabs__list-item--selected"),e.setAttribute("tabindex","0"))}getCurrentTab(){return this.$module.querySelector(".govuk-tabs__list-item--selected a.govuk-tabs__tab")}}function initAll(e){var t;if(e=void 0!==e?e:{},!isSupported())return void console.log(new SupportError);const s=[[Accordion,e.accordion],[Button,e.button],[CharacterCount,e.characterCount],[Checkboxes],[ErrorSummary,e.errorSummary],[ExitThisPage,e.exitThisPage],[Header],[NotificationBanner,e.notificationBanner],[PasswordInput,e.passwordInput],[Radios],[SkipLink],[Tabs]],n=null!=(t=e.scope)?t:document;s.forEach((([e,t])=>{n.querySelectorAll(`[data-module="${e.moduleName}"]`).forEach((s=>{try{"defaults"in e?new e(s,t):new e(s)}catch(n){console.log(n)}}))}))}Tabs.moduleName="govuk-tabs";export{Accordion,Button,CharacterCount,Checkboxes,ErrorSummary,ExitThisPage,Header,NotificationBanner,PasswordInput,Radios,SkipLink,Tabs,initAll,version};//# sourceMappingURL=govuk-frontend.min.js.map
