const version="5.8.0";function getFragmentFromUrl(t){if(t.includes("#"))return t.split("#").pop()}function getBreakpoint(t){const e=`--govuk-frontend-breakpoint-${t}`;return{property:e,value:window.getComputedStyle(document.documentElement).getPropertyValue(e)||void 0}}function setFocus(t,e={}){var n;const s=t.getAttribute("tabindex");function onBlur(){var n;null==(n=e.onBlur)||n.call(t),s||t.removeAttribute("tabindex")}s||t.setAttribute("tabindex","-1"),t.addEventListener("focus",(function(){t.addEventListener("blur",onBlur,{once:!0})}),{once:!0}),null==(n=e.onBeforeFocus)||n.call(t),t.focus()}function isSupported(t=document.body){return!!t&&t.classList.contains("govuk-frontend-supported")}function isObject(t){return!!t&&"object"==typeof t&&!function(t){return Array.isArray(t)}(t)}function formatErrorMessage(Component,t){return`${Component.moduleName}: ${t}`}class GOVUKFrontendError extends Error{constructor(...t){super(...t),this.name="GOVUKFrontendError"}}class SupportError extends GOVUKFrontendError{constructor(t=document.body){const e="noModule"in HTMLScriptElement.prototype?'GOV.UK Frontend initialised without `<body class="govuk-frontend-supported">` from template `<script>` snippet':"GOV.UK Frontend is not supported in this browser";super(t?e:'GOV.UK Frontend initialised without `<script type="module">`'),this.name="SupportError"}}class ConfigError extends GOVUKFrontendError{constructor(...t){super(...t),this.name="ConfigError"}}class ElementError extends GOVUKFrontendError{constructor(t){let e="string"==typeof t?t:"";if("object"==typeof t){const{component:n,identifier:s,element:i,expectedType:o}=t;e=s,e+=i?` is not of type ${null!=o?o:"HTMLElement"}`:" not found",e=formatErrorMessage(n,e)}super(e),this.name="ElementError"}}class InitError extends GOVUKFrontendError{constructor(t){super("string"==typeof t?t:formatErrorMessage(t,"Root element (`$root`) already initialised")),this.name="InitError"}}class GOVUKFrontendComponent{get $root(){return this._$root}constructor(t){this._$root=void 0;const e=this.constructor;if("string"!=typeof e.moduleName)throw new InitError("`moduleName` not defined in component");if(!(t instanceof e.elementType))throw new ElementError({element:t,component:e,identifier:"Root element (`$root`)",expectedType:e.elementType.name});this._$root=t,e.checkSupport(),this.checkInitialised();const n=e.moduleName;this.$root.setAttribute(`data-${n}-init`,"")}checkInitialised(){const t=this.constructor,e=t.moduleName;if(e&&function(t,e){return t instanceof HTMLElement&&t.hasAttribute(`data-${e}-init`)}(this.$root,e))throw new InitError(t)}static checkSupport(){if(!isSupported())throw new SupportError}}GOVUKFrontendComponent.elementType=HTMLElement;const t=Symbol.for("configOverride");class ConfigurableComponent extends GOVUKFrontendComponent{[t](t){return{}}get config(){return this._config}constructor(e,n){super(e),this._config=void 0;const s=this.constructor;if(void 0===s.defaults)throw new ConfigError(formatErrorMessage(s,"Config passed as parameter into constructor but no defaults defined"));const i=function(Component,t){if(void 0===Component.schema)throw new ConfigError(formatErrorMessage(Component,"Config passed as parameter into constructor but no schema defined"));const e={};for(const[n,s]of Object.entries(Component.schema.properties))n in t&&(e[n]=normaliseString(t[n],s)),"object"===(null==s?void 0:s.type)&&(e[n]=extractConfigByNamespace(Component.schema,t,n));return e}(s,this._$root.dataset);this._config=mergeConfigs(s.defaults,null!=n?n:{},this[t](i),i)}}function normaliseString(t,e){const n=t?t.trim():"";let s,i=null==e?void 0:e.type;switch(i||(["true","false"].includes(n)&&(i="boolean"),n.length>0&&isFinite(Number(n))&&(i="number")),i){case"boolean":s="true"===n;break;case"number":s=Number(n);break;default:s=t}return s}function mergeConfigs(...t){const e={};for(const n of t)for(const t of Object.keys(n)){const s=e[t],i=n[t];isObject(s)&&isObject(i)?e[t]=mergeConfigs(s,i):e[t]=i}return e}function extractConfigByNamespace(t,e,n){const s=t.properties[n];if("object"!==(null==s?void 0:s.type))return;const i={[n]:{}};for(const[o,r]of Object.entries(e)){let t=i;const e=o.split(".");for(const[s,i]of e.entries())"object"==typeof t&&(s<e.length-1?(isObject(t[i])||(t[i]={}),t=t[i]):o!==n&&(t[i]=normaliseString(r)))}return i[n]}class I18n{constructor(t={},e={}){var n;this.translations=void 0,this.locale=void 0,this.translations=t,this.locale=null!=(n=e.locale)?n:document.documentElement.lang||"en"}t(t,e){if(!t)throw new Error("i18n: lookup key missing");let n=this.translations[t];if("number"==typeof(null==e?void 0:e.count)&&"object"==typeof n){const s=n[this.getPluralSuffix(t,e.count)];s&&(n=s)}if("string"==typeof n){if(n.match(/%{(.\S+)}/)){if(!e)throw new Error("i18n: cannot replace placeholders in string if no option data provided");return this.replacePlaceholders(n,e)}return n}return t}replacePlaceholders(t,e){const n=Intl.NumberFormat.supportedLocalesOf(this.locale).length?new Intl.NumberFormat(this.locale):void 0;return t.replace(/%{(.\S+)}/g,(function(t,s){if(Object.prototype.hasOwnProperty.call(e,s)){const t=e[s];return!1===t||"number"!=typeof t&&"string"!=typeof t?"":"number"==typeof t?n?n.format(t):`${t}`:t}throw new Error(`i18n: no data found to replace ${t} placeholder in string`)}))}hasIntlPluralRulesSupport(){return Boolean("PluralRules"in window.Intl&&Intl.PluralRules.supportedLocalesOf(this.locale).length)}getPluralSuffix(t,e){if(e=Number(e),!isFinite(e))return"other";const n=this.translations[t],s=this.hasIntlPluralRulesSupport()?new Intl.PluralRules(this.locale).select(e):this.selectPluralFormUsingFallbackRules(e);if("object"==typeof n){if(s in n)return s;if("other"in n)return console.warn(`i18n: Missing plural form ".${s}" for "${this.locale}" locale. Falling back to ".other".`),"other"}throw new Error(`i18n: Plural form ".other" is required for "${this.locale}" locale`)}selectPluralFormUsingFallbackRules(t){t=Math.abs(Math.floor(t));const e=this.getPluralRulesForLocale();return e?I18n.pluralRules[e](t):"other"}getPluralRulesForLocale(){const t=this.locale.split("-")[0];for(const e in I18n.pluralRulesMap){const n=I18n.pluralRulesMap[e];if(n.includes(this.locale)||n.includes(t))return e}}}I18n.pluralRulesMap={arabic:["ar"],chinese:["my","zh","id","ja","jv","ko","ms","th","vi"],french:["hy","bn","fr","gu","hi","fa","pa","zu"],german:["af","sq","az","eu","bg","ca","da","nl","en","et","fi","ka","de","el","hu","lb","no","so","sw","sv","ta","te","tr","ur"],irish:["ga"],russian:["ru","uk"],scottish:["gd"],spanish:["pt-PT","it","es"],welsh:["cy"]},I18n.pluralRules={arabic:t=>0===t?"zero":1===t?"one":2===t?"two":t%100>=3&&t%100<=10?"few":t%100>=11&&t%100<=99?"many":"other",chinese:()=>"other",french:t=>0===t||1===t?"one":"other",german:t=>1===t?"one":"other",irish:t=>1===t?"one":2===t?"two":t>=3&&t<=6?"few":t>=7&&t<=10?"many":"other",russian(t){const e=t%100,n=e%10;return 1===n&&11!==e?"one":n>=2&&n<=4&&!(e>=12&&e<=14)?"few":0===n||n>=5&&n<=9||e>=11&&e<=14?"many":"other"},scottish:t=>1===t||11===t?"one":2===t||12===t?"two":t>=3&&t<=10||t>=13&&t<=19?"few":"other",spanish:t=>1===t?"one":t%1e6==0&&0!==t?"many":"other",welsh:t=>0===t?"zero":1===t?"one":2===t?"two":3===t?"few":6===t?"many":"other"};class Accordion extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.i18n=void 0,this.controlsClass="govuk-accordion__controls",this.showAllClass="govuk-accordion__show-all",this.showAllTextClass="govuk-accordion__show-all-text",this.sectionClass="govuk-accordion__section",this.sectionExpandedClass="govuk-accordion__section--expanded",this.sectionButtonClass="govuk-accordion__section-button",this.sectionHeaderClass="govuk-accordion__section-header",this.sectionHeadingClass="govuk-accordion__section-heading",this.sectionHeadingDividerClass="govuk-accordion__section-heading-divider",this.sectionHeadingTextClass="govuk-accordion__section-heading-text",this.sectionHeadingTextFocusClass="govuk-accordion__section-heading-text-focus",this.sectionShowHideToggleClass="govuk-accordion__section-toggle",this.sectionShowHideToggleFocusClass="govuk-accordion__section-toggle-focus",this.sectionShowHideTextClass="govuk-accordion__section-toggle-text",this.upChevronIconClass="govuk-accordion-nav__chevron",this.downChevronIconClass="govuk-accordion-nav__chevron--down",this.sectionSummaryClass="govuk-accordion__section-summary",this.sectionSummaryFocusClass="govuk-accordion__section-summary-focus",this.sectionContentClass="govuk-accordion__section-content",this.$sections=void 0,this.$showAllButton=null,this.$showAllIcon=null,this.$showAllText=null,this.i18n=new I18n(this.config.i18n);const n=this.$root.querySelectorAll(`.${this.sectionClass}`);if(!n.length)throw new ElementError({component:Accordion,identifier:`Sections (\`<div class="${this.sectionClass}">\`)`});this.$sections=n,this.initControls(),this.initSectionHeaders(),this.updateShowAllButton(this.areAllSectionsOpen())}initControls(){this.$showAllButton=document.createElement("button"),this.$showAllButton.setAttribute("type","button"),this.$showAllButton.setAttribute("class",this.showAllClass),this.$showAllButton.setAttribute("aria-expanded","false"),this.$showAllIcon=document.createElement("span"),this.$showAllIcon.classList.add(this.upChevronIconClass),this.$showAllButton.appendChild(this.$showAllIcon);const t=document.createElement("div");t.setAttribute("class",this.controlsClass),t.appendChild(this.$showAllButton),this.$root.insertBefore(t,this.$root.firstChild),this.$showAllText=document.createElement("span"),this.$showAllText.classList.add(this.showAllTextClass),this.$showAllButton.appendChild(this.$showAllText),this.$showAllButton.addEventListener("click",(()=>this.onShowOrHideAllToggle())),"onbeforematch"in document&&document.addEventListener("beforematch",(t=>this.onBeforeMatch(t)))}initSectionHeaders(){this.$sections.forEach(((t,e)=>{const n=t.querySelector(`.${this.sectionHeaderClass}`);if(!n)throw new ElementError({component:Accordion,identifier:`Section headers (\`<div class="${this.sectionHeaderClass}">\`)`});this.constructHeaderMarkup(n,e),this.setExpanded(this.isExpanded(t),t),n.addEventListener("click",(()=>this.onSectionToggle(t))),this.setInitialState(t)}))}constructHeaderMarkup(t,e){const n=t.querySelector(`.${this.sectionButtonClass}`),s=t.querySelector(`.${this.sectionHeadingClass}`),i=t.querySelector(`.${this.sectionSummaryClass}`);if(!s)throw new ElementError({component:Accordion,identifier:`Section heading (\`.${this.sectionHeadingClass}\`)`});if(!n)throw new ElementError({component:Accordion,identifier:`Section button placeholder (\`<span class="${this.sectionButtonClass}">\`)`});const o=document.createElement("button");o.setAttribute("type","button"),o.setAttribute("aria-controls",`${this.$root.id}-content-${e+1}`);for(const d of Array.from(n.attributes))"id"!==d.name&&o.setAttribute(d.name,d.value);const r=document.createElement("span");r.classList.add(this.sectionHeadingTextClass),r.id=n.id;const a=document.createElement("span");a.classList.add(this.sectionHeadingTextFocusClass),r.appendChild(a),Array.from(n.childNodes).forEach((t=>a.appendChild(t)));const c=document.createElement("span");c.classList.add(this.sectionShowHideToggleClass),c.setAttribute("data-nosnippet","");const l=document.createElement("span");l.classList.add(this.sectionShowHideToggleFocusClass),c.appendChild(l);const h=document.createElement("span"),u=document.createElement("span");if(u.classList.add(this.upChevronIconClass),l.appendChild(u),h.classList.add(this.sectionShowHideTextClass),l.appendChild(h),o.appendChild(r),o.appendChild(this.getButtonPunctuationEl()),i){const t=document.createElement("span"),e=document.createElement("span");e.classList.add(this.sectionSummaryFocusClass),t.appendChild(e);for(const n of Array.from(i.attributes))t.setAttribute(n.name,n.value);Array.from(i.childNodes).forEach((t=>e.appendChild(t))),i.remove(),o.appendChild(t),o.appendChild(this.getButtonPunctuationEl())}o.appendChild(c),s.removeChild(n),s.appendChild(o)}onBeforeMatch(t){const e=t.target;if(!(e instanceof Element))return;const n=e.closest(`.${this.sectionClass}`);n&&this.setExpanded(!0,n)}onSectionToggle(t){const e=!this.isExpanded(t);this.setExpanded(e,t),this.storeState(t,e)}onShowOrHideAllToggle(){const t=!this.areAllSectionsOpen();this.$sections.forEach((e=>{this.setExpanded(t,e),this.storeState(e,t)})),this.updateShowAllButton(t)}setExpanded(t,e){const n=e.querySelector(`.${this.upChevronIconClass}`),s=e.querySelector(`.${this.sectionShowHideTextClass}`),i=e.querySelector(`.${this.sectionButtonClass}`),o=e.querySelector(`.${this.sectionContentClass}`);if(!o)throw new ElementError({component:Accordion,identifier:`Section content (\`<div class="${this.sectionContentClass}">\`)`});if(!n||!s||!i)return;const r=t?this.i18n.t("hideSection"):this.i18n.t("showSection");s.textContent=r,i.setAttribute("aria-expanded",`${t}`);const a=[],c=e.querySelector(`.${this.sectionHeadingTextClass}`);c&&a.push(`${c.textContent}`.trim());const l=e.querySelector(`.${this.sectionSummaryClass}`);l&&a.push(`${l.textContent}`.trim());const h=t?this.i18n.t("hideSectionAriaLabel"):this.i18n.t("showSectionAriaLabel");a.push(h),i.setAttribute("aria-label",a.join(" , ")),t?(o.removeAttribute("hidden"),e.classList.add(this.sectionExpandedClass),n.classList.remove(this.downChevronIconClass)):(o.setAttribute("hidden","until-found"),e.classList.remove(this.sectionExpandedClass),n.classList.add(this.downChevronIconClass)),this.updateShowAllButton(this.areAllSectionsOpen())}isExpanded(t){return t.classList.contains(this.sectionExpandedClass)}areAllSectionsOpen(){return Array.from(this.$sections).every((t=>this.isExpanded(t)))}updateShowAllButton(t){this.$showAllButton&&this.$showAllText&&this.$showAllIcon&&(this.$showAllButton.setAttribute("aria-expanded",t.toString()),this.$showAllText.textContent=t?this.i18n.t("hideAllSections"):this.i18n.t("showAllSections"),this.$showAllIcon.classList.toggle(this.downChevronIconClass,!t))}getIdentifier(t){const e=t.querySelector(`.${this.sectionButtonClass}`);return null==e?void 0:e.getAttribute("aria-controls")}storeState(t,e){if(!this.config.rememberExpanded)return;const n=this.getIdentifier(t);if(n)try{window.sessionStorage.setItem(n,e.toString())}catch(s){}}setInitialState(t){if(!this.config.rememberExpanded)return;const e=this.getIdentifier(t);if(e)try{const n=window.sessionStorage.getItem(e);null!==n&&this.setExpanded("true"===n,t)}catch(n){}}getButtonPunctuationEl(){const t=document.createElement("span");return t.classList.add("govuk-visually-hidden",this.sectionHeadingDividerClass),t.textContent=", ",t}}Accordion.moduleName="govuk-accordion",Accordion.defaults=Object.freeze({i18n:{hideAllSections:"Hide all sections",hideSection:"Hide",hideSectionAriaLabel:"Hide this section",showAllSections:"Show all sections",showSection:"Show",showSectionAriaLabel:"Show this section"},rememberExpanded:!0}),Accordion.schema=Object.freeze({properties:{i18n:{type:"object"},rememberExpanded:{type:"boolean"}}});class Button extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.debounceFormSubmitTimer=null,this.$root.addEventListener("keydown",(t=>this.handleKeyDown(t))),this.$root.addEventListener("click",(t=>this.debounce(t)))}handleKeyDown(t){const e=t.target;" "===t.key&&e instanceof HTMLElement&&"button"===e.getAttribute("role")&&(t.preventDefault(),e.click())}debounce(t){if(this.config.preventDoubleClick)return this.debounceFormSubmitTimer?(t.preventDefault(),!1):void(this.debounceFormSubmitTimer=window.setTimeout((()=>{this.debounceFormSubmitTimer=null}),1e3))}}function closestAttributeValue(t,e){const n=t.closest(`[${e}]`);return n?n.getAttribute(e):null}Button.moduleName="govuk-button",Button.defaults=Object.freeze({preventDoubleClick:!1}),Button.schema=Object.freeze({properties:{preventDoubleClick:{type:"boolean"}}});class CharacterCount extends ConfigurableComponent{[t](t){let e={};return("maxwords"in t||"maxlength"in t)&&(e={maxlength:void 0,maxwords:void 0}),e}constructor(t,e={}){var n,s;super(t,e),this.$textarea=void 0,this.$visibleCountMessage=void 0,this.$screenReaderCountMessage=void 0,this.lastInputTimestamp=null,this.lastInputValue="",this.valueChecker=null,this.i18n=void 0,this.maxLength=void 0;const i=this.$root.querySelector(".govuk-js-character-count");if(!(i instanceof HTMLTextAreaElement||i instanceof HTMLInputElement))throw new ElementError({component:CharacterCount,element:i,expectedType:"HTMLTextareaElement or HTMLInputElement",identifier:"Form field (`.govuk-js-character-count`)"});const o=function(t,e){const n=[];for(const[s,i]of Object.entries(t)){const t=[];if(Array.isArray(i)){for(const{required:n,errorMessage:s}of i)n.every((t=>!!e[t]))||t.push(s);"anyOf"!==s||i.length-t.length>=1||n.push(...t)}}return n}(CharacterCount.schema,this.config);if(o[0])throw new ConfigError(formatErrorMessage(CharacterCount,o[0]));this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(this.$root,"lang")}),this.maxLength=null!=(n=null!=(s=this.config.maxwords)?s:this.config.maxlength)?n:1/0,this.$textarea=i;const r=`${this.$textarea.id}-info`,a=document.getElementById(r);if(!a)throw new ElementError({component:CharacterCount,element:a,identifier:`Count message (\`id="${r}"\`)`});`${a.textContent}`.match(/^\s*$/)&&(a.textContent=this.i18n.t("textareaDescription",{count:this.maxLength})),this.$textarea.insertAdjacentElement("afterend",a);const c=document.createElement("div");c.className="govuk-character-count__sr-status govuk-visually-hidden",c.setAttribute("aria-live","polite"),this.$screenReaderCountMessage=c,a.insertAdjacentElement("afterend",c);const l=document.createElement("div");l.className=a.className,l.classList.add("govuk-character-count__status"),l.setAttribute("aria-hidden","true"),this.$visibleCountMessage=l,a.insertAdjacentElement("afterend",l),a.classList.add("govuk-visually-hidden"),this.$textarea.removeAttribute("maxlength"),this.bindChangeEvents(),window.addEventListener("pageshow",(()=>this.updateCountMessage())),this.updateCountMessage()}bindChangeEvents(){this.$textarea.addEventListener("keyup",(()=>this.handleKeyUp())),this.$textarea.addEventListener("focus",(()=>this.handleFocus())),this.$textarea.addEventListener("blur",(()=>this.handleBlur()))}handleKeyUp(){this.updateVisibleCountMessage(),this.lastInputTimestamp=Date.now()}handleFocus(){this.valueChecker=window.setInterval((()=>{(!this.lastInputTimestamp||Date.now()-500>=this.lastInputTimestamp)&&this.updateIfValueChanged()}),1e3)}handleBlur(){this.valueChecker&&window.clearInterval(this.valueChecker)}updateIfValueChanged(){this.$textarea.value!==this.lastInputValue&&(this.lastInputValue=this.$textarea.value,this.updateCountMessage())}updateCountMessage(){this.updateVisibleCountMessage(),this.updateScreenReaderCountMessage()}updateVisibleCountMessage(){const t=this.maxLength-this.count(this.$textarea.value)<0;this.$visibleCountMessage.classList.toggle("govuk-character-count__message--disabled",!this.isOverThreshold()),this.$textarea.classList.toggle("govuk-textarea--error",t),this.$visibleCountMessage.classList.toggle("govuk-error-message",t),this.$visibleCountMessage.classList.toggle("govuk-hint",!t),this.$visibleCountMessage.textContent=this.getCountMessage()}updateScreenReaderCountMessage(){this.isOverThreshold()?this.$screenReaderCountMessage.removeAttribute("aria-hidden"):this.$screenReaderCountMessage.setAttribute("aria-hidden","true"),this.$screenReaderCountMessage.textContent=this.getCountMessage()}count(t){if(this.config.maxwords){var e;return(null!=(e=t.match(/\S+/g))?e:[]).length}return t.length}getCountMessage(){const t=this.maxLength-this.count(this.$textarea.value),e=this.config.maxwords?"words":"characters";return this.formatCountMessage(t,e)}formatCountMessage(t,e){if(0===t)return this.i18n.t(`${e}AtLimit`);const n=t<0?"OverLimit":"UnderLimit";return this.i18n.t(`${e}${n}`,{count:Math.abs(t)})}isOverThreshold(){if(!this.config.threshold)return!0;const t=this.count(this.$textarea.value);return this.maxLength*this.config.threshold/100<=t}}CharacterCount.moduleName="govuk-character-count",CharacterCount.defaults=Object.freeze({threshold:0,i18n:{charactersUnderLimit:{one:"You have %{count} character remaining",other:"You have %{count} characters remaining"},charactersAtLimit:"You have 0 characters remaining",charactersOverLimit:{one:"You have %{count} character too many",other:"You have %{count} characters too many"},wordsUnderLimit:{one:"You have %{count} word remaining",other:"You have %{count} words remaining"},wordsAtLimit:"You have 0 words remaining",wordsOverLimit:{one:"You have %{count} word too many",other:"You have %{count} words too many"},textareaDescription:{other:""}}}),CharacterCount.schema=Object.freeze({properties:{i18n:{type:"object"},maxwords:{type:"number"},maxlength:{type:"number"},threshold:{type:"number"}},anyOf:[{required:["maxwords"],errorMessage:'Either "maxlength" or "maxwords" must be provided'},{required:["maxlength"],errorMessage:'Either "maxlength" or "maxwords" must be provided'}]});class Checkboxes extends GOVUKFrontendComponent{constructor(t){super(t),this.$inputs=void 0;const e=this.$root.querySelectorAll('input[type="checkbox"]');if(!e.length)throw new ElementError({component:Checkboxes,identifier:'Form inputs (`<input type="checkbox">`)'});this.$inputs=e,this.$inputs.forEach((t=>{const e=t.getAttribute("data-aria-controls");if(e){if(!document.getElementById(e))throw new ElementError({component:Checkboxes,identifier:`Conditional reveal (\`id="${e}"\`)`});t.setAttribute("aria-controls",e),t.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$root.addEventListener("click",(t=>this.handleClick(t)))}syncAllConditionalReveals(){this.$inputs.forEach((t=>this.syncConditionalRevealWithInputState(t)))}syncConditionalRevealWithInputState(t){const e=t.getAttribute("aria-controls");if(!e)return;const n=document.getElementById(e);if(null!=n&&n.classList.contains("govuk-checkboxes__conditional")){const e=t.checked;t.setAttribute("aria-expanded",e.toString()),n.classList.toggle("govuk-checkboxes__conditional--hidden",!e)}}unCheckAllInputsExcept(t){document.querySelectorAll(`input[type="checkbox"][name="${t.name}"]`).forEach((e=>{t.form===e.form&&e!==t&&(e.checked=!1,this.syncConditionalRevealWithInputState(e))}))}unCheckExclusiveInputs(t){document.querySelectorAll(`input[data-behaviour="exclusive"][type="checkbox"][name="${t.name}"]`).forEach((e=>{t.form===e.form&&(e.checked=!1,this.syncConditionalRevealWithInputState(e))}))}handleClick(t){const e=t.target;if(!(e instanceof HTMLInputElement)||"checkbox"!==e.type)return;if(e.getAttribute("aria-controls")&&this.syncConditionalRevealWithInputState(e),!e.checked)return;"exclusive"===e.getAttribute("data-behaviour")?this.unCheckAllInputsExcept(e):this.unCheckExclusiveInputs(e)}}Checkboxes.moduleName="govuk-checkboxes";class ErrorSummary extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.config.disableAutoFocus||setFocus(this.$root),this.$root.addEventListener("click",(t=>this.handleClick(t)))}handleClick(t){const e=t.target;e&&this.focusTarget(e)&&t.preventDefault()}focusTarget(t){if(!(t instanceof HTMLAnchorElement))return!1;const e=getFragmentFromUrl(t.href);if(!e)return!1;const n=document.getElementById(e);if(!n)return!1;const s=this.getAssociatedLegendOrLabel(n);return!!s&&(s.scrollIntoView(),n.focus({preventScroll:!0}),!0)}getAssociatedLegendOrLabel(t){var e;const n=t.closest("fieldset");if(n){const e=n.getElementsByTagName("legend");if(e.length){const n=e[0];if(t instanceof HTMLInputElement&&("checkbox"===t.type||"radio"===t.type))return n;const s=n.getBoundingClientRect().top,i=t.getBoundingClientRect();if(i.height&&window.innerHeight){if(i.top+i.height-s<window.innerHeight/2)return n}}}return null!=(e=document.querySelector(`label[for='${t.getAttribute("id")}']`))?e:t.closest("label")}}ErrorSummary.moduleName="govuk-error-summary",ErrorSummary.defaults=Object.freeze({disableAutoFocus:!1}),ErrorSummary.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class ExitThisPage extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.i18n=void 0,this.$button=void 0,this.$skiplinkButton=null,this.$updateSpan=null,this.$indicatorContainer=null,this.$overlay=null,this.keypressCounter=0,this.lastKeyWasModified=!1,this.timeoutTime=5e3,this.keypressTimeoutId=null,this.timeoutMessageId=null;const n=this.$root.querySelector(".govuk-exit-this-page__button");if(!(n instanceof HTMLAnchorElement))throw new ElementError({component:ExitThisPage,element:n,expectedType:"HTMLAnchorElement",identifier:"Button (`.govuk-exit-this-page__button`)"});this.i18n=new I18n(this.config.i18n),this.$button=n;const s=document.querySelector(".govuk-js-exit-this-page-skiplink");s instanceof HTMLAnchorElement&&(this.$skiplinkButton=s),this.buildIndicator(),this.initUpdateSpan(),this.initButtonClickHandler(),"govukFrontendExitThisPageKeypress"in document.body.dataset||(document.addEventListener("keyup",this.handleKeypress.bind(this),!0),document.body.dataset.govukFrontendExitThisPageKeypress="true"),window.addEventListener("pageshow",this.resetPage.bind(this))}initUpdateSpan(){this.$updateSpan=document.createElement("span"),this.$updateSpan.setAttribute("role","status"),this.$updateSpan.className="govuk-visually-hidden",this.$root.appendChild(this.$updateSpan)}initButtonClickHandler(){this.$button.addEventListener("click",this.handleClick.bind(this)),this.$skiplinkButton&&this.$skiplinkButton.addEventListener("click",this.handleClick.bind(this))}buildIndicator(){this.$indicatorContainer=document.createElement("div"),this.$indicatorContainer.className="govuk-exit-this-page__indicator",this.$indicatorContainer.setAttribute("aria-hidden","true");for(let t=0;t<3;t++){const t=document.createElement("div");t.className="govuk-exit-this-page__indicator-light",this.$indicatorContainer.appendChild(t)}this.$button.appendChild(this.$indicatorContainer)}updateIndicator(){if(!this.$indicatorContainer)return;this.$indicatorContainer.classList.toggle("govuk-exit-this-page__indicator--visible",this.keypressCounter>0);this.$indicatorContainer.querySelectorAll(".govuk-exit-this-page__indicator-light").forEach(((t,e)=>{t.classList.toggle("govuk-exit-this-page__indicator-light--on",e<this.keypressCounter)}))}exitPage(){this.$updateSpan&&(this.$updateSpan.textContent="",document.body.classList.add("govuk-exit-this-page-hide-content"),this.$overlay=document.createElement("div"),this.$overlay.className="govuk-exit-this-page-overlay",this.$overlay.setAttribute("role","alert"),document.body.appendChild(this.$overlay),this.$overlay.textContent=this.i18n.t("activated"),window.location.href=this.$button.href)}handleClick(t){t.preventDefault(),this.exitPage()}handleKeypress(t){this.$updateSpan&&("Shift"!==t.key||this.lastKeyWasModified?this.keypressTimeoutId&&this.resetKeypressTimer():(this.keypressCounter+=1,this.updateIndicator(),this.timeoutMessageId&&(window.clearTimeout(this.timeoutMessageId),this.timeoutMessageId=null),this.keypressCounter>=3?(this.keypressCounter=0,this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null),this.exitPage()):1===this.keypressCounter?this.$updateSpan.textContent=this.i18n.t("pressTwoMoreTimes"):this.$updateSpan.textContent=this.i18n.t("pressOneMoreTime"),this.setKeypressTimer()),this.lastKeyWasModified=t.shiftKey)}setKeypressTimer(){this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=window.setTimeout(this.resetKeypressTimer.bind(this),this.timeoutTime)}resetKeypressTimer(){if(!this.$updateSpan)return;this.keypressTimeoutId&&(window.clearTimeout(this.keypressTimeoutId),this.keypressTimeoutId=null);const t=this.$updateSpan;this.keypressCounter=0,t.textContent=this.i18n.t("timedOut"),this.timeoutMessageId=window.setTimeout((()=>{t.textContent=""}),this.timeoutTime),this.updateIndicator()}resetPage(){document.body.classList.remove("govuk-exit-this-page-hide-content"),this.$overlay&&(this.$overlay.remove(),this.$overlay=null),this.$updateSpan&&(this.$updateSpan.setAttribute("role","status"),this.$updateSpan.textContent=""),this.updateIndicator(),this.keypressTimeoutId&&window.clearTimeout(this.keypressTimeoutId),this.timeoutMessageId&&window.clearTimeout(this.timeoutMessageId)}}ExitThisPage.moduleName="govuk-exit-this-page",ExitThisPage.defaults=Object.freeze({i18n:{activated:"Loading.",timedOut:"Exit this page expired.",pressTwoMoreTimes:"Shift, press 2 more times to exit.",pressOneMoreTime:"Shift, press 1 more time to exit."}}),ExitThisPage.schema=Object.freeze({properties:{i18n:{type:"object"}}});class Header extends GOVUKFrontendComponent{constructor(t){super(t),this.$menuButton=void 0,this.$menu=void 0,this.menuIsOpen=!1,this.mql=null;const e=this.$root.querySelector(".govuk-js-header-toggle");if(!e)return this;const n=e.getAttribute("aria-controls");if(!n)throw new ElementError({component:Header,identifier:'Navigation button (`<button class="govuk-js-header-toggle">`) attribute (`aria-controls`)'});const s=document.getElementById(n);if(!s)throw new ElementError({component:Header,element:s,identifier:`Navigation (\`<ul id="${n}">\`)`});this.$menu=s,this.$menuButton=e,this.setupResponsiveChecks(),this.$menuButton.addEventListener("click",(()=>this.handleMenuButtonClick()))}setupResponsiveChecks(){const t=getBreakpoint("desktop");if(!t.value)throw new ElementError({component:Header,identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){this.mql&&this.$menu&&this.$menuButton&&(this.mql.matches?(this.$menu.removeAttribute("hidden"),this.$menuButton.setAttribute("hidden","")):(this.$menuButton.removeAttribute("hidden"),this.$menuButton.setAttribute("aria-expanded",this.menuIsOpen.toString()),this.menuIsOpen?this.$menu.removeAttribute("hidden"):this.$menu.setAttribute("hidden","")))}handleMenuButtonClick(){this.menuIsOpen=!this.menuIsOpen,this.checkMode()}}Header.moduleName="govuk-header";class NotificationBanner extends ConfigurableComponent{constructor(t,e={}){super(t,e),"alert"!==this.$root.getAttribute("role")||this.config.disableAutoFocus||setFocus(this.$root)}}NotificationBanner.moduleName="govuk-notification-banner",NotificationBanner.defaults=Object.freeze({disableAutoFocus:!1}),NotificationBanner.schema=Object.freeze({properties:{disableAutoFocus:{type:"boolean"}}});class PasswordInput extends ConfigurableComponent{constructor(t,e={}){super(t,e),this.i18n=void 0,this.$input=void 0,this.$showHideButton=void 0,this.$screenReaderStatusMessage=void 0;const n=this.$root.querySelector(".govuk-js-password-input-input");if(!(n instanceof HTMLInputElement))throw new ElementError({component:PasswordInput,element:n,expectedType:"HTMLInputElement",identifier:"Form field (`.govuk-js-password-input-input`)"});if("password"!==n.type)throw new ElementError("Password input: Form field (`.govuk-js-password-input-input`) must be of type `password`.");const s=this.$root.querySelector(".govuk-js-password-input-toggle");if(!(s instanceof HTMLButtonElement))throw new ElementError({component:PasswordInput,element:s,expectedType:"HTMLButtonElement",identifier:"Button (`.govuk-js-password-input-toggle`)"});if("button"!==s.type)throw new ElementError("Password input: Button (`.govuk-js-password-input-toggle`) must be of type `button`.");this.$input=n,this.$showHideButton=s,this.i18n=new I18n(this.config.i18n,{locale:closestAttributeValue(this.$root,"lang")}),this.$showHideButton.removeAttribute("hidden");const i=document.createElement("div");i.className="govuk-password-input__sr-status govuk-visually-hidden",i.setAttribute("aria-live","polite"),this.$screenReaderStatusMessage=i,this.$input.insertAdjacentElement("afterend",i),this.$showHideButton.addEventListener("click",this.toggle.bind(this)),this.$input.form&&this.$input.form.addEventListener("submit",(()=>this.hide())),window.addEventListener("pageshow",(t=>{t.persisted&&"password"!==this.$input.type&&this.hide()})),this.hide()}toggle(t){t.preventDefault(),"password"!==this.$input.type?this.hide():this.show()}show(){this.setType("text")}hide(){this.setType("password")}setType(t){if(t===this.$input.type)return;this.$input.setAttribute("type",t);const e="password"===t,n=e?"show":"hide",s=e?"passwordHidden":"passwordShown";this.$showHideButton.innerText=this.i18n.t(`${n}Password`),this.$showHideButton.setAttribute("aria-label",this.i18n.t(`${n}PasswordAriaLabel`)),this.$screenReaderStatusMessage.innerText=this.i18n.t(`${s}Announcement`)}}PasswordInput.moduleName="govuk-password-input",PasswordInput.defaults=Object.freeze({i18n:{showPassword:"Show",hidePassword:"Hide",showPasswordAriaLabel:"Show password",hidePasswordAriaLabel:"Hide password",passwordShownAnnouncement:"Your password is visible",passwordHiddenAnnouncement:"Your password is hidden"}}),PasswordInput.schema=Object.freeze({properties:{i18n:{type:"object"}}});class Radios extends GOVUKFrontendComponent{constructor(t){super(t),this.$inputs=void 0;const e=this.$root.querySelectorAll('input[type="radio"]');if(!e.length)throw new ElementError({component:Radios,identifier:'Form inputs (`<input type="radio">`)'});this.$inputs=e,this.$inputs.forEach((t=>{const e=t.getAttribute("data-aria-controls");if(e){if(!document.getElementById(e))throw new ElementError({component:Radios,identifier:`Conditional reveal (\`id="${e}"\`)`});t.setAttribute("aria-controls",e),t.removeAttribute("data-aria-controls")}})),window.addEventListener("pageshow",(()=>this.syncAllConditionalReveals())),this.syncAllConditionalReveals(),this.$root.addEventListener("click",(t=>this.handleClick(t)))}syncAllConditionalReveals(){this.$inputs.forEach((t=>this.syncConditionalRevealWithInputState(t)))}syncConditionalRevealWithInputState(t){const e=t.getAttribute("aria-controls");if(!e)return;const n=document.getElementById(e);if(null!=n&&n.classList.contains("govuk-radios__conditional")){const e=t.checked;t.setAttribute("aria-expanded",e.toString()),n.classList.toggle("govuk-radios__conditional--hidden",!e)}}handleClick(t){const e=t.target;if(!(e instanceof HTMLInputElement)||"radio"!==e.type)return;const n=document.querySelectorAll('input[type="radio"][aria-controls]'),s=e.form,i=e.name;n.forEach((t=>{const e=t.form===s;t.name===i&&e&&this.syncConditionalRevealWithInputState(t)}))}}Radios.moduleName="govuk-radios";class ServiceNavigation extends GOVUKFrontendComponent{constructor(t){super(t),this.$menuButton=void 0,this.$menu=void 0,this.menuIsOpen=!1,this.mql=null;const e=this.$root.querySelector(".govuk-js-service-navigation-toggle");if(!e)return this;const n=e.getAttribute("aria-controls");if(!n)throw new ElementError({component:ServiceNavigation,identifier:'Navigation button (`<button class="govuk-js-service-navigation-toggle">`) attribute (`aria-controls`)'});const s=document.getElementById(n);if(!s)throw new ElementError({component:ServiceNavigation,element:s,identifier:`Navigation (\`<ul id="${n}">\`)`});this.$menu=s,this.$menuButton=e,this.setupResponsiveChecks(),this.$menuButton.addEventListener("click",(()=>this.handleMenuButtonClick()))}setupResponsiveChecks(){const t=getBreakpoint("tablet");if(!t.value)throw new ElementError({component:ServiceNavigation,identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){this.mql&&this.$menu&&this.$menuButton&&(this.mql.matches?(this.$menu.removeAttribute("hidden"),this.$menuButton.setAttribute("hidden","")):(this.$menuButton.removeAttribute("hidden"),this.$menuButton.setAttribute("aria-expanded",this.menuIsOpen.toString()),this.menuIsOpen?this.$menu.removeAttribute("hidden"):this.$menu.setAttribute("hidden","")))}handleMenuButtonClick(){this.menuIsOpen=!this.menuIsOpen,this.checkMode()}}ServiceNavigation.moduleName="govuk-service-navigation";class SkipLink extends GOVUKFrontendComponent{constructor(t){var e;super(t);const n=this.$root.hash,s=null!=(e=this.$root.getAttribute("href"))?e:"";let i;try{i=new window.URL(this.$root.href)}catch(a){throw new ElementError(`Skip link: Target link (\`href="${s}"\`) is invalid`)}if(i.origin!==window.location.origin||i.pathname!==window.location.pathname)return;const o=getFragmentFromUrl(n);if(!o)throw new ElementError(`Skip link: Target link (\`href="${s}"\`) has no hash fragment`);const r=document.getElementById(o);if(!r)throw new ElementError({component:SkipLink,element:r,identifier:`Target content (\`id="${o}"\`)`});this.$root.addEventListener("click",(()=>setFocus(r,{onBeforeFocus(){r.classList.add("govuk-skip-link-focused-element")},onBlur(){r.classList.remove("govuk-skip-link-focused-element")}})))}}SkipLink.elementType=HTMLAnchorElement,SkipLink.moduleName="govuk-skip-link";class Tabs extends GOVUKFrontendComponent{constructor(t){super(t),this.$tabs=void 0,this.$tabList=void 0,this.$tabListItems=void 0,this.jsHiddenClass="govuk-tabs__panel--hidden",this.changingHash=!1,this.boundTabClick=void 0,this.boundTabKeydown=void 0,this.boundOnHashChange=void 0,this.mql=null;const e=this.$root.querySelectorAll("a.govuk-tabs__tab");if(!e.length)throw new ElementError({component:Tabs,identifier:'Links (`<a class="govuk-tabs__tab">`)'});this.$tabs=e,this.boundTabClick=this.onTabClick.bind(this),this.boundTabKeydown=this.onTabKeydown.bind(this),this.boundOnHashChange=this.onHashChange.bind(this);const n=this.$root.querySelector(".govuk-tabs__list"),s=this.$root.querySelectorAll("li.govuk-tabs__list-item");if(!n)throw new ElementError({component:Tabs,identifier:'List (`<ul class="govuk-tabs__list">`)'});if(!s.length)throw new ElementError({component:Tabs,identifier:'List items (`<li class="govuk-tabs__list-item">`)'});this.$tabList=n,this.$tabListItems=s,this.setupResponsiveChecks()}setupResponsiveChecks(){const t=getBreakpoint("tablet");if(!t.value)throw new ElementError({component:Tabs,identifier:`CSS custom property (\`${t.property}\`) on pseudo-class \`:root\``});this.mql=window.matchMedia(`(min-width: ${t.value})`),"addEventListener"in this.mql?this.mql.addEventListener("change",(()=>this.checkMode())):this.mql.addListener((()=>this.checkMode())),this.checkMode()}checkMode(){var t;null!=(t=this.mql)&&t.matches?this.setup():this.teardown()}setup(){var t;this.$tabList.setAttribute("role","tablist"),this.$tabListItems.forEach((t=>{t.setAttribute("role","presentation")})),this.$tabs.forEach((t=>{this.setAttributes(t),t.addEventListener("click",this.boundTabClick,!0),t.addEventListener("keydown",this.boundTabKeydown,!0),this.hideTab(t)}));const e=null!=(t=this.getTab(window.location.hash))?t:this.$tabs[0];this.showTab(e),window.addEventListener("hashchange",this.boundOnHashChange,!0)}teardown(){this.$tabList.removeAttribute("role"),this.$tabListItems.forEach((t=>{t.removeAttribute("role")})),this.$tabs.forEach((t=>{t.removeEventListener("click",this.boundTabClick,!0),t.removeEventListener("keydown",this.boundTabKeydown,!0),this.unsetAttributes(t)})),window.removeEventListener("hashchange",this.boundOnHashChange,!0)}onHashChange(){const t=window.location.hash,e=this.getTab(t);if(!e)return;if(this.changingHash)return void(this.changingHash=!1);const n=this.getCurrentTab();n&&(this.hideTab(n),this.showTab(e),e.focus())}hideTab(t){this.unhighlightTab(t),this.hidePanel(t)}showTab(t){this.highlightTab(t),this.showPanel(t)}getTab(t){return this.$root.querySelector(`a.govuk-tabs__tab[href="${t}"]`)}setAttributes(t){const e=getFragmentFromUrl(t.href);if(!e)return;t.setAttribute("id",`tab_${e}`),t.setAttribute("role","tab"),t.setAttribute("aria-controls",e),t.setAttribute("aria-selected","false"),t.setAttribute("tabindex","-1");const n=this.getPanel(t);n&&(n.setAttribute("role","tabpanel"),n.setAttribute("aria-labelledby",t.id),n.classList.add(this.jsHiddenClass))}unsetAttributes(t){t.removeAttribute("id"),t.removeAttribute("role"),t.removeAttribute("aria-controls"),t.removeAttribute("aria-selected"),t.removeAttribute("tabindex");const e=this.getPanel(t);e&&(e.removeAttribute("role"),e.removeAttribute("aria-labelledby"),e.classList.remove(this.jsHiddenClass))}onTabClick(t){const e=this.getCurrentTab(),n=t.currentTarget;e&&n instanceof HTMLAnchorElement&&(t.preventDefault(),this.hideTab(e),this.showTab(n),this.createHistoryEntry(n))}createHistoryEntry(t){const e=this.getPanel(t);if(!e)return;const n=e.id;e.id="",this.changingHash=!0,window.location.hash=n,e.id=n}onTabKeydown(t){switch(t.key){case"ArrowLeft":case"Left":this.activatePreviousTab(),t.preventDefault();break;case"ArrowRight":case"Right":this.activateNextTab(),t.preventDefault()}}activateNextTab(){const t=this.getCurrentTab();if(null==t||!t.parentElement)return;const e=t.parentElement.nextElementSibling;if(!e)return;const n=e.querySelector("a.govuk-tabs__tab");n&&(this.hideTab(t),this.showTab(n),n.focus(),this.createHistoryEntry(n))}activatePreviousTab(){const t=this.getCurrentTab();if(null==t||!t.parentElement)return;const e=t.parentElement.previousElementSibling;if(!e)return;const n=e.querySelector("a.govuk-tabs__tab");n&&(this.hideTab(t),this.showTab(n),n.focus(),this.createHistoryEntry(n))}getPanel(t){const e=getFragmentFromUrl(t.href);return e?this.$root.querySelector(`#${e}`):null}showPanel(t){const e=this.getPanel(t);e&&e.classList.remove(this.jsHiddenClass)}hidePanel(t){const e=this.getPanel(t);e&&e.classList.add(this.jsHiddenClass)}unhighlightTab(t){t.parentElement&&(t.setAttribute("aria-selected","false"),t.parentElement.classList.remove("govuk-tabs__list-item--selected"),t.setAttribute("tabindex","-1"))}highlightTab(t){t.parentElement&&(t.setAttribute("aria-selected","true"),t.parentElement.classList.add("govuk-tabs__list-item--selected"),t.setAttribute("tabindex","0"))}getCurrentTab(){return this.$root.querySelector(".govuk-tabs__list-item--selected a.govuk-tabs__tab")}}function initAll(t){var e;if(t=void 0!==t?t:{},!isSupported())return void(t.onError?t.onError(new SupportError,{config:t}):console.log(new SupportError));const n=[[Accordion,t.accordion],[Button,t.button],[CharacterCount,t.characterCount],[Checkboxes],[ErrorSummary,t.errorSummary],[ExitThisPage,t.exitThisPage],[Header],[NotificationBanner,t.notificationBanner],[PasswordInput,t.passwordInput],[Radios],[ServiceNavigation],[SkipLink],[Tabs]],s={scope:null!=(e=t.scope)?e:document,onError:t.onError};n.forEach((([Component,t])=>{createAll(Component,t,s)}))}function createAll(Component,t,e){let n,s=document;var i;"object"==typeof e&&(s=null!=(i=e.scope)?i:s,n=e.onError);"function"==typeof e&&(n=e),e instanceof HTMLElement&&(s=e);const o=s.querySelectorAll(`[data-module="${Component.moduleName}"]`);return isSupported()?Array.from(o).map((e=>{try{return void 0!==t?new Component(e,t):new Component(e)}catch(s){return n?n(s,{element:e,component:Component,config:t}):console.log(s),null}})).filter(Boolean):(n?n(new SupportError,{component:Component,config:t}):console.log(new SupportError),[])}Tabs.moduleName="govuk-tabs";export{Accordion,Button,CharacterCount,Checkboxes,GOVUKFrontendComponent as Component,ConfigurableComponent,ErrorSummary,ExitThisPage,Header,NotificationBanner,PasswordInput,Radios,ServiceNavigation,SkipLink,Tabs,createAll,initAll,isSupported,version};//# sourceMappingURL=govuk-frontend.min.js.map
