<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Keymaps

You can customize the initial state of the module from the editor initialization

```js
const editor = grapesjs.init({
 keymaps: {
    // Object of keymaps
   defaults: {
     'your-namespace:keymap-name' {
       keys: '⌘+z, ctrl+z',
       handler: 'some-command-id'
     },
     ...
   }
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const keymaps = editor.Keymaps;
```

-   [getConfig][1]
-   [add][2]
-   [get][3]
-   [getAll][4]
-   [remove][5]
-   [removeAll][6]

## getConfig

Get module configurations

Returns **[Object][7]** Configuration object

## add

Add new keymap

### Parameters

-   `id` **[string][8]** Keymap id
-   `keys` **[string][8]** Keymap keys, eg. `ctrl+a`, `⌘+z, ctrl+z`
-   `handler` **([Function][9] \| [string][8])** Keymap handler, might be a function

### Examples

```javascript
// 'ns' is just a custom namespace
keymaps.add('ns:my-keymap', '⌘+j, ⌘+u, ctrl+j, alt+u', editor => {
 console.log('do stuff');
});
// or
keymaps.add('ns:my-keymap', '⌘+s, ctrl+s', 'some-gjs-command');

// listen to events
editor.on('keymap:emit', (id, shortcut, e) => {
 // ...
})
```

Returns **[Object][7]** Added keymap
 or just a command id as a string

## get

Get the keymap by id

### Parameters

-   `id` **[string][8]** Keymap id

### Examples

```javascript
keymaps.get('ns:my-keymap');
// -> {keys, handler};
```

Returns **[Object][7]** Keymap object

## getAll

Get all keymaps

### Examples

```javascript
keymaps.getAll();
// -> {id1: {}, id2: {}};
```

Returns **[Object][7]** 

## remove

Remove the keymap by id

### Parameters

-   `id` **[string][8]** Keymap id

### Examples

```javascript
keymaps.remove('ns:my-keymap');
// -> {keys, handler};
```

Returns **[Object][7]** Removed keymap

## removeAll

Remove all binded keymaps

Returns **this** 

[1]: #getconfig

[2]: #add

[3]: #get

[4]: #getAll

[5]: #remove

[6]: #removeall

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function
