<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## Modal

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 modal: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const modal = editor.Modal;
```

-   [open][2]
-   [close][3]
-   [isOpen][4]
-   [setTitle][5]
-   [getTitle][6]
-   [setContent][7]
-   [getContent][8]

## open

Open the modal window

### Parameters

-   `opts` **[Object][9]** Options (optional, default `{}`)
    -   `opts.title` **([String][10] \| [HTMLElement][11])?** Title to set for the modal
    -   `opts.content` **([String][10] \| [HTMLElement][11])?** Content to set for the modal

Returns **this** 

## close

Close the modal window

Returns **this** 

## isOpen

Checks if the modal window is open

Returns **[Boolean][12]** 

## setTitle

Set the title to the modal window

### Parameters

-   `title` **[string][10]** Title

### Examples

```javascript
modal.setTitle('New title');
```

Returns **this** 

## getTitle

Returns the title of the modal window

Returns **[string][10]** 

## setContent

Set the content of the modal window

### Parameters

-   `content` **([string][10] \| [HTMLElement][11])** Content

### Examples

```javascript
modal.setContent('<div>Some HTML content</div>');
```

Returns **this** 

## getContent

Get the content of the modal window

Returns **[string][10]** 

[1]: https://github.com/artf/grapesjs/blob/master/src/modal_dialog/config/config.js

[2]: #open

[3]: #close

[4]: #isopen

[5]: #settitle

[6]: #gettitle

[7]: #setcontent

[8]: #getcontent

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[11]: https://developer.mozilla.org/docs/Web/HTML/Element

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean
