<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## RichTextEditor

This module allows to customize the built-in toolbar of the Rich Text Editor and use commands from the [HTML Editing APIs][1].
It's highly recommended to keep this toolbar as small as possible, especially from styling commands (eg. 'fontSize') and leave this task to the Style Manager

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][2]

```js
const editor = grapesjs.init({
 rte: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const rte = editor.RichTextEditor;
```

-   [add][3]
-   [get][4]
-   [getAll][5]
-   [remove][6]
-   [getToolbarEl][7]

## add

Add a new action to the built-in RTE toolbar

### Parameters

-   `name` **[string][8]** Action name
-   `action` **[Object][9]** Action options (optional, default `{}`)

### Examples

```javascript
rte.add('bold', {
  icon: '<b>B</b>',
  attributes: {title: 'Bold',}
  result: rte => rte.exec('bold')
});
rte.add('link', {
  icon: document.getElementById('t'),
  attributes: {title: 'Link',}
  // Example on it's easy to wrap a selected content
  result: rte => rte.insertHTML(`<a href="#">${rte.selection()}</a>`)
});
// An example with fontSize
rte.add('fontSize', {
  icon: `<select class="gjs-field">
        <option>1</option>
        <option>4</option>
        <option>7</option>
      </select>`,
    // Bind the 'result' on 'change' listener
  event: 'change',
  result: (rte, action) => rte.exec('fontSize', action.btn.firstChild.value),
  // Callback on any input change (mousedown, keydown, etc..)
  update: (rte, action) => {
    const value = rte.doc.queryCommandValue(action.name);
    if (value != 'false') { // value is a string
      action.btn.firstChild.value = value;
    }
   }
  })
```

## get

Get the action by its name

### Parameters

-   `name` **[string][8]** Action name

### Examples

```javascript
const action = rte.get('bold');
// {name: 'bold', ...}
```

Returns **[Object][9]** 

## getAll

Get all actions

Returns **[Array][10]** 

## remove

Remove the action from the toolbar

### Parameters

-   `name` **[string][8]** 

### Examples

```javascript
const action = rte.remove('bold');
// {name: 'bold', ...}
```

Returns **[Object][9]** Removed action

## getToolbarEl

Get the toolbar element

Returns **[HTMLElement][11]** 

[1]: https://developer.mozilla.org/en-US/docs/Web/API/Document/execCommand

[2]: https://github.com/artf/grapesjs/blob/master/src/rich_text_editor/config/config.js

[3]: #add

[4]: #get

[5]: #getall

[6]: #remove

[7]: #gettoolbarel

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[11]: https://developer.mozilla.org/docs/Web/HTML/Element
