<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## StyleManager

With Style Manager you build categories (called sectors) of CSS properties which could be used to customize the style of components.
You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 styleManager: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const styleManager = editor.StyleManager;
```

-   [getConfig][2]
-   [addSector][3]
-   [getSector][4]
-   [removeSector][5]
-   [getSectors][6]
-   [addProperty][7]
-   [getProperty][8]
-   [removeProperty][9]
-   [getProperties][10]
-   [getModelToStyle][11]
-   [getModelToStyle][11]
-   [addType][12]
-   [getType][13]
-   [getTypes][14]
-   [createType][15]

## getConfig

Get configuration object

Returns **[Object][16]** 

## addSector

Add new sector to the collection. If the sector with the same id already exists,
that one will be returned

### Parameters

-   `id` **[string][17]** Sector id
-   `sector` **[Object][16]** Object representing sector
    -   `sector.name` **[string][17]** Sector's label (optional, default `''`)
    -   `sector.open` **[Boolean][18]** Indicates if the sector should be opened (optional, default `true`)
    -   `sector.properties` **[Array][19]&lt;[Object][16]>** Array of properties (optional, default `[]`)

### Examples

```javascript
var sector = styleManager.addSector('mySector',{
  name: 'My sector',
  open: true,
  properties: [{ name: 'My property'}]
});
```

Returns **Sector** Added Sector

## getSector

Get sector by id

### Parameters

-   `id` **[string][17]** Sector id

### Examples

```javascript
var sector = styleManager.getSector('mySector');
```

Returns **(Sector | null)** 

## removeSector

Remove a sector by id

### Parameters

-   `id` **[string][17]** Sector id

### Examples

```javascript
const removed = styleManager.removeSector('mySector');
```

Returns **Sector** Removed sector

## getSectors

Get all sectors

Returns **Sectors** Collection of sectors

## addProperty

Add property to the sector identified by id

### Parameters

-   `sectorId` **[string][17]** Sector id
-   `property` **[Object][16]** Property object
    -   `property.name` **[string][17]** Name of the property (optional, default `''`)
    -   `property.property` **[string][17]** CSS property, eg. `min-height` (optional, default `''`)
    -   `property.type` **[string][17]** Type of the property: integer | radio | select | color | file | composite | stack (optional, default `''`)
    -   `property.units` **[Array][19]&lt;[string][17]>** Unit of measure available, eg. ['px','%','em']. Only for integer type (optional, default `[]`)
    -   `property.unit` **[string][17]** Default selected unit from `units`. Only for integer type (optional, default `''`)
    -   `property.min` **[number][20]** Min possible value. Only for integer type (optional, default `null`)
    -   `property.max` **[number][20]** Max possible value. Only for integer type (optional, default `null`)
    -   `property.defaults` **[string][17]** Default value (optional, default `''`)
    -   `property.info` **[string][17]** Some description (optional, default `''`)
    -   `property.icon` **[string][17]** Class name. If exists no text will be displayed (optional, default `''`)
    -   `property.preview` **[Boolean][18]** Show layers preview. Only for stack type (optional, default `false`)
    -   `property.functionName` **[string][17]** Indicates if value need to be wrapped in some function, for istance `transform: rotate(90deg)` (optional, default `''`)
    -   `property.properties` **[Array][19]&lt;[Object][16]>** Nested properties for composite and stack type (optional, default `[]`)
    -   `property.layers` **[Array][19]&lt;[Object][16]>** Layers for stack properties (optional, default `[]`)
    -   `property.list` **[Array][19]&lt;[Object][16]>** List of possible options for radio and select types (optional, default `[]`)

### Examples

```javascript
var property = styleManager.addProperty('mySector',{
  name: 'Minimum height',
  property: 'min-height',
  type: 'select',
  defaults: '100px',
  list: [{
    value: '100px',
    name: '100',
   },{
     value: '200px',
     name: '200',
   }],
});
```

Returns **(Property | null)** Added Property or `null` in case sector doesn't exist

## getProperty

Get property by its CSS name and sector id

### Parameters

-   `sectorId` **[string][17]** Sector id
-   `name` **[string][17]** CSS property name, eg. 'min-height'

### Examples

```javascript
var property = styleManager.getProperty('mySector','min-height');
```

Returns **(Property | null)** 

## removeProperty

Remove a property from the sector

### Parameters

-   `sectorId` **[string][17]** Sector id
-   `name` **[string][17]** CSS property name, eg. 'min-height'

### Examples

```javascript
const property = styleManager.removeProperty('mySector', 'min-height');
```

Returns **Property** Removed property

## getProperties

Get properties of the sector

### Parameters

-   `sectorId` **[string][17]** Sector id

### Examples

```javascript
var properties = styleManager.getProperties('mySector');
```

Returns **Properties** Collection of properties

## getModelToStyle

Get what to style inside Style Manager. If you select the component
without classes the entity is the Component itself and all changes will
go inside its 'style' property. Otherwise, if the selected component has
one or more classes, the function will return the corresponding CSS Rule

### Parameters

-   `model` **Model** 

Returns **Model** 

## addType

Add new property type

### Parameters

-   `id` **[string][17]** Type ID
-   `definition` **[Object][16]** Definition of the type. Each definition contains
                               `model` (business logic), `view` (presentation logic)
                               and `isType` function which recognize the type of the
                               passed entity

### Examples

```javascript
styleManager.addType('my-type', {
 model: {},
 view: {},
 isType: (value) => {
   if (value && value.type == 'my-type') {
     return value;
   }
 },
})
```

## getType

Get type

### Parameters

-   `id` **[string][17]** Type ID

Returns **[Object][16]** Type definition

## getTypes

Get all types

Returns **[Array][19]** 

## createType

Create new property from type

### Parameters

-   `id` **[string][17]** Type ID
-   `options` **[Object][16]** Options (optional, default `{}`)
    -   `options.model` **[Object][16]** Custom model object (optional, default `{}`)
    -   `options.view` **[Object][16]** Custom view object (optional, default `{}`)

### Examples

```javascript
const propView = styleManager.createType('integer', {
 model: {units: ['px', 'rem']}
});
propView.render();
propView.model.on('change:value', ...);
someContainer.appendChild(propView.el);
```

Returns **PropertyView** 

[1]: https://github.com/artf/grapesjs/blob/master/src/style_manager/config/config.js

[2]: #getconfig

[3]: #addsector

[4]: #getsector

[5]: #removesector

[6]: #getsectors

[7]: #addproperty

[8]: #getproperty

[9]: #removeproperty

[10]: #getproperties

[11]: #getmodeltostyle

[12]: #addtype

[13]: #gettype

[14]: #gettypes

[15]: #createtype

[16]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[17]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[19]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[20]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number
