<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## DomComponents

With this module is possible to manage components inside the canvas. You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 domComponents: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const domComponents = editor.DomComponents;
```

-   [getWrapper][2]
-   [getComponents][3]
-   [addComponent][4]
-   [clear][5]
-   [load][6]
-   [store][7]
-   [addType][8]
-   [getType][9]
-   [getTypes][10]
-   [render][11]

## load

Load components from the passed object, if the object is empty will try to fetch them
autonomously from the selected storage
The fetched data will be added to the collection

### Parameters

-   `data` **[Object][12]** Object of data to load (optional, default `''`)

Returns **[Object][12]** Loaded data

## store

Store components on the selected storage

### Parameters

-   `noStore` **[Boolean][13]** If true, won't store

Returns **[Object][12]** Data to store

## getWrapper

Returns root component inside the canvas. Something like `<body>` inside HTML page
The wrapper doesn't differ from the original Component Model

### Examples

```javascript
// Change background of the wrapper and set some attribute
var wrapper = domComponents.getWrapper();
wrapper.set('style', {'background-color': 'red'});
wrapper.set('attributes', {'title': 'Hello!'});
```

Returns **Component** Root Component

## getComponents

Returns wrapper's children collection. Once you have the collection you can
add other Components(Models) inside. Each component can have several nested
components inside and you can nest them as more as you wish.

### Examples

```javascript
// Let's add some component
var wrapperChildren = domComponents.getComponents();
var comp1 = wrapperChildren.add({
  style: { 'background-color': 'red'}
});
var comp2 = wrapperChildren.add({
  tagName: 'span',
  attributes: { title: 'Hello!'}
});
// Now let's add an other one inside first component
// First we have to get the collection inside. Each
// component has 'components' property
var comp1Children = comp1.get('components');
// Procede as before. You could also add multiple objects
comp1Children.add([
  { style: { 'background-color': 'blue'}},
  { style: { height: '100px', width: '100px'}}
]);
// Remove comp2
wrapperChildren.remove(comp2);
```

Returns **Components** Collection of components

## addComponent

Add new components to the wrapper's children. It's the same
as 'domComponents.getComponents().add(...)'

### Parameters

-   `component` **([Object][12] | Component | [Array][14]&lt;[Object][12]>)** Component/s to add
    -   `component.tagName` **[string][15]** Tag name (optional, default `'div'`)
    -   `component.type` **[string][15]** Type of the component. Available: ''(default), 'text', 'image' (optional, default `''`)
    -   `component.removable` **[boolean][13]** If component is removable (optional, default `true`)
    -   `component.draggable` **[boolean][13]** If is possible to move the component around the structure (optional, default `true`)
    -   `component.droppable` **[boolean][13]** If is possible to drop inside other components (optional, default `true`)
    -   `component.badgable` **[boolean][13]** If the badge is visible when the component is selected (optional, default `true`)
    -   `component.stylable` **[boolean][13]** If is possible to style component (optional, default `true`)
    -   `component.copyable` **[boolean][13]** If is possible to copy&paste the component (optional, default `true`)
    -   `component.content` **[string][15]** String inside component (optional, default `''`)
    -   `component.style` **[Object][12]** Style object (optional, default `{}`)
    -   `component.attributes` **[Object][12]** Attribute object (optional, default `{}`)

### Examples

```javascript
// Example of a new component with some extra property
var comp1 = domComponents.addComponent({
  tagName: 'div',
  removable: true, // Can't remove it
  draggable: true, // Can't move it
  copyable: true, // Disable copy/past
  content: 'Content text', // Text inside component
  style: { color: 'red'},
  attributes: { title: 'here' }
});
```

Returns **(Component | [Array][14]&lt;Component>)** Component/s added

## render

Render and returns wrapper element with all components inside.
Once the wrapper is rendered, and it's what happens when you init the editor,
the all new components will be added automatically and property changes are all
updated immediately

Returns **[HTMLElement][16]** 

## clear

Remove all components

Returns **this** 

## addType

Add new component type.
Read more about this in [Define New Component][17]

### Parameters

-   `type` **[string][15]** Component ID
-   `methods` **[Object][12]** Component methods

Returns **this** 

## getType

Get component type.
Read more about this in [Define New Component][17]

### Parameters

-   `type` **[string][15]** Component ID

Returns **[Object][12]** Component type defintion, eg. `{ model: ..., view: ... }`

## removeType

Remove component type

### Parameters

-   `id`  
-   `type` **[string][15]** Component ID

Returns **([Object][12] \| [undefined][18])** Removed component type, undefined otherwise

## getTypes

Return the array of all types

Returns **[Array][14]** 

[1]: https://github.com/artf/grapesjs/blob/master/src/dom_components/config/config.js

[2]: #getwrapper

[3]: #getcomponents

[4]: #addcomponent

[5]: #clear

[6]: #load

[7]: #store

[8]: #addtype

[9]: #gettype

[10]: #gettypes

[11]: #render

[12]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[13]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[14]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[16]: https://developer.mozilla.org/docs/Web/HTML/Element

[17]: https://grapesjs.com/docs/modules/Components.html#define-new-component

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/undefined
