<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## DeviceManager

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 deviceManager: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const deviceManager = editor.DeviceManager;
```

-   [add][2]
-   [get][3]
-   [getAll][4]

## add

Add new device to the collection. URLs are supposed to be unique

### Parameters

-   `id` **[String][5]** Device id
-   `width` **[String][5]** Width of the device
-   `opts` **[Object][6]?** Custom options (optional, default `{}`)

### Examples

```javascript
deviceManager.add('tablet', '900px');
deviceManager.add('tablet2', '900px', {
 height: '300px',
 // At first, GrapesJS tries to localize the name by device id.
 // In case is not found, the `name` property is used (or `id` if name is missing)
 name: 'Tablet 2',
 widthMedia: '810px', // the width that will be used for the CSS media
});
```

Returns **Device** Added device

## get

Return device by name

### Parameters

-   `name` **[string][5]** Name of the device

### Examples

```javascript
var device = deviceManager.get('Tablet');
console.log(JSON.stringify(device));
// {name: 'Tablet', width: '900px'}
```

## getAll

Return all devices

### Examples

```javascript
var devices = deviceManager.getAll();
console.log(JSON.stringify(devices));
// [{name: 'Desktop', width: ''}, ...]
```

Returns **Collection** 

[1]: https://github.com/artf/grapesjs/blob/master/src/device_manager/config/config.js

[2]: #add

[3]: #get

[4]: #getAll

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object
