<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## I18n

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 i18n: {
   locale: 'en',
   localeFallback: 'en',
   messages: {
     it: { hello: 'Ciao', ... },
     ...
   }
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const i18n = editor.I18n;
```

### Events

-   `i18n:add` - New set of messages is added
-   `i18n:update` - The set of messages is updated
-   `i18n:locale` - Locale changed

## getConfig

Get module configurations

Returns **[Object][2]** Configuration object

## setLocale

Update current locale

### Parameters

-   `locale` **[String][3]** Locale value

### Examples

```javascript
i18n.setLocale('it');
```

Returns **this** 

## getLocale

Get current locale

Returns **[String][3]** Current locale value

## getMessages

Get all messages

### Parameters

-   `lang` **[String][3]?** Specify the language of messages to return
-   `opts` **[Object][2]?** Options (optional, default `{}`)
    -   `opts.debug` **[Boolean][4]?** Show warnings in case of missing language

### Examples

```javascript
i18n.getMessages();
// -> { en: { hello: '...' }, ... }
i18n.getMessages('en');
// -> { hello: '...' }
```

Returns **[Object][2]** 

## setMessages

Set new set of messages

### Parameters

-   `msg` **[Object][2]** Set of messages

### Examples

```javascript
i18n.getMessages();
// -> { en: { msg1: 'Msg 1', msg2: 'Msg 2', } }
i18n.setMessages({ en: { msg2: 'Msg 2 up', msg3: 'Msg 3', } });
// Set replaced
i18n.getMessages();
// -> { en: { msg2: 'Msg 2 up', msg3: 'Msg 3', } }
```

Returns **this** 

## addMessages

Update messages

### Parameters

-   `msg` **[Object][2]** Set of messages to add

### Examples

```javascript
i18n.getMessages();
// -> { en: { msg1: 'Msg 1', msg2: 'Msg 2', } }
i18n.addMessages({ en: { msg2: 'Msg 2 up', msg3: 'Msg 3', } });
// Set updated
i18n.getMessages();
// -> { en: { msg1: 'Msg 1', msg2: 'Msg 2 up', msg3: 'Msg 3', } }
```

Returns **this** 

## t

Translate the locale message

### Parameters

-   `key` **[String][3]** Label to translate
-   `opts` **[Object][2]?** Options for the translation (optional, default `{}`)
    -   `opts.params` **[Object][2]?** Params for the translation
    -   `opts.debug` **[Boolean][4]?** Show warnings in case of missing resources

### Examples

```javascript
obj.setMessages({
 en: { msg: 'Msg', msg2: 'Msg {test}'},
 it: { msg2: 'Msg {test} it'},
});
obj.t('msg');
// -> outputs `Msg`
obj.t('msg2', { params: { test: 'hello' } });  // use params
// -> outputs `Msg hello`
obj.t('msg2', { l: 'it', params: { test: 'hello' } });  // custom local
// -> outputs `Msg hello it`
```

Returns **[String][3]** 

[1]: https://github.com/artf/grapesjs/blob/master/src/i18n/config.js

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean
