<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## SelectorManager

Selectors in GrapesJS are used in CSS Composer inside Rules and in Components as classes. To illustrate this concept let's take
a look at this code:

```css
span > #send-btn.btn{
 ...
}
```

```html
<span>
  <button id="send-btn" class="btn"></button>
</span>
```

In this scenario we get:

-   span     -> selector of type `tag`
-   send-btn -> selector of type `id`
-   btn      -> selector of type `class`

So, for example, being `btn` the same class entity it'll be easier to refactor and track things.

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 selectorManager: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const selectorManager = editor.SelectorManager;
```

-   [getConfig][2]
-   [add][3]
-   [addClass][4]
-   [get][5]
-   [getAll][6]

## getConfig

Get configuration object

Returns **[Object][7]** 

## add

Add a new selector to collection if it's not already exists. Class type is a default one

### Parameters

-   `name` **([String][8] \| [Array][9])** Selector/s name
-   `opts` **[Object][7]** Selector options (optional, default `{}`)
    -   `opts.label` **[String][8]** Label for the selector, if it's not provided the label will be the same as the name (optional, default `''`)
    -   `opts.type` **[String][8]** Type of the selector. At the moment, only 'class' (1) is available (optional, default `1`)

### Examples

```javascript
const selector = selectorManager.add('selectorName');
// Same as
const selector = selectorManager.add('selectorName', {
  type: 1,
  label: 'selectorName'
});
// Multiple selectors
const selectors = selectorManager.add(['.class1', '.class2', '#id1']);
```

Returns **(Model | [Array][9])** 

## addClass

Add class selectors

### Parameters

-   `classes` **([Array][9] \| [string][8])** Array or string of classes

### Examples

```javascript
sm.addClass('class1');
sm.addClass('class1 class2');
sm.addClass(['class1', 'class2']);
// -> [SelectorObject, ...]
```

Returns **[Array][9]** Array of added selectors

## get

Get the selector by its name

### Parameters

-   `name` **([String][8] \| [Array][9])** Selector name
-   `type` **[String][8]** Selector type

### Examples

```javascript
const selector = selectorManager.get('selectorName');
// or get an array
const selectors = selectorManager.get(['class1', 'class2']);
```

Returns **(Model | [Array][9])** 

## getAll

Get all selectors

Returns **Collection** 

## escapeName

Return escaped selector name

### Parameters

-   `name` **[String][8]** Selector name to escape

Returns **[String][8]** Escaped name

[1]: https://github.com/artf/grapesjs/blob/master/src/selector_manager/config/config.js

[2]: #getconfig

[3]: #add

[4]: #addclass

[5]: #get

[6]: #getAll

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array
