<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## StorageManager

You can customize the initial state of the module from the editor initialization, by passing the following [Configuration Object][1]

```js
const editor = grapesjs.init({
 storageManager: {
   // options
 }
})
```

Once the editor is instantiated you can use its API. Before using these methods you should get the module from the instance

```js
const storageManager = editor.StorageManager;
```

-   [getConfig][2]
-   [isAutosave][3]
-   [setAutosave][4]
-   [getStepsBeforeSave][5]
-   [setStepsBeforeSave][6]
-   [setStepsBeforeSave][6]
-   [getStorages][7]
-   [getCurrent][8]
-   [getCurrentStorage][9]
-   [setCurrent][10]
-   [add][11]
-   [get][12]
-   [store][13]
-   [load][14]

## getConfig

Get configuration object

Returns **[Object][15]** 

## isAutosave

Checks if autosave is enabled

Returns **[Boolean][16]** 

## setAutosave

Set autosave value

### Parameters

-   `v` **[Boolean][16]** 

Returns **this** 

## getStepsBeforeSave

Returns number of steps required before trigger autosave

Returns **[number][17]** 

## setStepsBeforeSave

Set steps required before trigger autosave

### Parameters

-   `v` **[number][17]** 

Returns **this** 

## add

Add new storage

### Parameters

-   `id` **[string][18]** Storage ID
-   `storage` **[Object][15]** Storage wrapper
    -   `storage.load` **[Function][19]** Load method
    -   `storage.store` **[Function][19]** Store method

### Examples

```javascript
storageManager.add('local2', {
  load: function(keys, clb, clbErr) {
    var res = {};
    for (var i = 0, len = keys.length; i < len; i++){
      var v = localStorage.getItem(keys[i]);
      if(v) res[keys[i]] = v;
    }
    clb(res); // might be called inside some async method
    // In case of errors...
    // clbErr('Went something wrong');
  },
  store: function(data, clb, clbErr) {
    for(var key in data)
      localStorage.setItem(key, data[key]);
    clb(); // might be called inside some async method
  }
});
```

Returns **this** 

## get

Returns storage by id

### Parameters

-   `id` **[string][18]** Storage ID

Returns **([Object][15] | null)** 

## getStorages

Returns all storages

Returns **[Array][20]** 

## getCurrent

Returns current storage type

Returns **[string][18]** 

## setCurrent

Set current storage type

### Parameters

-   `id` **[string][18]** Storage ID

Returns **this** 

## store

Store key-value resources in the current storage

### Parameters

-   `data` **[Object][15]** Data in key-value format, eg. {item1: value1, item2: value2}
-   `clb` **[Function][19]** Callback function

### Examples

```javascript
storageManager.store({item1: value1, item2: value2});
```

Returns **([Object][15] | null)** 

## load

Load resource from the current storage by keys

### Parameters

-   `keys` **([string][18] \| [Array][20]&lt;[string][18]>)** Keys to load
-   `clb` **[Function][19]** Callback function

### Examples

```javascript
storageManager.load(['item1', 'item2'], res => {
 // res -> {item1: value1, item2: value2}
});
storageManager.load('item1', res => {
// res -> {item1: value1}
});
```

## getCurrentStorage

Get current storage

Returns **Storage** 

[1]: https://github.com/artf/grapesjs/blob/master/src/storage_manager/config/config.js

[2]: #getconfig

[3]: #isautosave

[4]: #setautosave

[5]: #getstepsbeforesave

[6]: #setstepsbeforesave

[7]: #getstorages

[8]: #getcurrent

[9]: #getcurrentstorage

[10]: #setcurrent

[11]: #add

[12]: #get

[13]: #store

[14]: #load

[15]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[16]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[17]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[18]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[19]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function

[20]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array
