'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _rdfaProcessor = require('./rdfa-processor');

var _rdfaProcessor2 = _interopRequireDefault(_rdfaProcessor);

var _rdfaGraph = require('./rdfa-graph');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var GraphRDFaProcessor = function (_RDFaProcessor) {
  _inherits(GraphRDFaProcessor, _RDFaProcessor);

  function GraphRDFaProcessor(target) {
    _classCallCheck(this, GraphRDFaProcessor);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(GraphRDFaProcessor).call(this, target));
  }

  _createClass(GraphRDFaProcessor, [{
    key: 'getObjectSize',
    value: function getObjectSize(obj) {
      var size = 0;
      for (var key in obj) {
        if (obj.hasOwnProperty(key)) {
          size++;
        }
      }
      return size;
    }
  }, {
    key: 'init',
    value: function init() {
      var thisObj = this;
      this.finishedHandlers.push(function (node) {
        for (var subject in thisObj.target.graph.subjects) {
          var snode = thisObj.target.graph.subjects[subject];
          if (thisObj.getObjectSize(snode.predicates) == 0) {
            delete thisObj.target.graph.subjects[subject];
          }
        }
      });
    }
  }, {
    key: 'newBlankNode',
    value: function newBlankNode() {
      return this.target.graph.newBlankNode();
    }
  }, {
    key: 'newSubjectOrigin',
    value: function newSubjectOrigin(origin, subject) {
      var snode = this.newSubject(null, subject);
      for (var i = 0; i < snode.origins.length; i++) {
        if (snode.origins[i] === origin) {
          return;
        }
      }
      snode.origins.push(origin);
      if (!origin.data) {
        Object.defineProperty(origin, "data", {
          value: snode,
          writable: false,
          configurable: true,
          enumerable: true
        });
      }
    }
  }, {
    key: 'newSubject',
    value: function newSubject(origin, subject) {
      var snode = this.target.graph.subjects[subject];
      if (!snode) {
        snode = new _rdfaGraph.RDFaSubject(this.target.graph, subject);
        this.target.graph.subjects[subject] = snode;
      }
      return snode;
    }
  }, {
    key: 'addTriple',
    value: function addTriple(origin, subject, predicate, object) {
      var snode = this.newSubject(origin, subject);
      var pnode = snode.predicates[predicate];
      if (!pnode) {
        pnode = new _rdfaGraph.RDFaPredicate(predicate);
        snode.predicates[predicate] = pnode;
      }

      for (var i = 0; i < pnode.objects.length; i++) {
        if (pnode.objects[i].type == object.type && pnode.objects[i].value == object.value) {
          if (pnode.objects[i].origin !== origin) {
            if (!Array.isArray(pnode.objects[i].origin)) {
              var origins = [];
              origins.push(pnode.objects[i].origin);
              pnode.objects[i].origin = origins;
            }
            pnode.objects[i].origin.push(origin);
          }
          return;
        }
      }
      pnode.objects.push(object);
      object.origin = origin;
      if (predicate == _rdfaProcessor2.default.typeURI) {
        snode.types.push(object.value);
      }
    }
  }, {
    key: 'copyProperties',
    value: function copyProperties() {
      var copySubjects = [];
      var patternSubjects = {};
      for (var subject in this.target.graph.subjects) {
        var snode = this.target.graph.subjects[subject];
        var pnode = snode.predicates[GraphRDFaProcessor.rdfaCopyPredicate];
        if (!pnode) {
          continue;
        }
        copySubjects.push(subject);
        for (var i = 0; i < pnode.objects.length; i++) {
          if (pnode.objects[i].type != _rdfaProcessor2.default.objectURI) {
            continue;
          }
          var target = pnode.objects[i].value;
          var patternSubjectNode = this.target.graph.subjects[target];
          if (!patternSubjectNode) {
            continue;
          }
          var patternTypes = patternSubjectNode.predicates[_rdfaProcessor2.default.typeURI];
          if (!patternTypes) {
            continue;
          }
          var isPattern = false;
          for (var j = 0; j < patternTypes.objects.length && !isPattern; j++) {
            if (patternTypes.objects[j].value == GraphRDFaProcessor.rdfaPatternType && patternTypes.objects[j].type == _rdfaProcessor2.default.objectURI) {
              isPattern = true;
            }
          }
          if (!isPattern) {
            continue;
          }
          patternSubjects[target] = true;
          for (var predicate in patternSubjectNode.predicates) {
            var targetPNode = patternSubjectNode.predicates[predicate];
            if (predicate == _rdfaProcessor2.default.typeURI) {
              if (targetPNode.objects.length == 1) {
                continue;
              }
              for (var j = 0; j < targetPNode.objects.length; j++) {
                if (targetPNode.objects[j].value != GraphRDFaProcessor.rdfaPatternType) {
                  var subjectPNode = snode.predicates[predicate];
                  if (!subjectPNode) {
                    subjectPNode = new _rdfaGraph.RDFaPredicate(predicate);
                    snode.predicates[predicate] = subjectPNode;
                  }
                  subjectPNode.objects.push({ type: targetPNode.objects[j].type,
                    value: targetPNode.objects[j].value,
                    language: targetPNode.objects[j].language,
                    origin: targetPNode.objects[j].origin });
                  snode.types.push(targetPNode.objects[j].value);
                }
              }
            } else {
              var subjectPNode = snode.predicates[predicate];
              if (!subjectPNode) {
                subjectPNode = new _rdfaGraph.RDFaPredicate(predicate);
                snode.predicates[predicate] = subjectPNode;
              }
              for (var j = 0; j < targetPNode.objects.length; j++) {
                subjectPNode.objects.push({ type: targetPNode.objects[j].type,
                  value: targetPNode.objects[j].value,
                  language: targetPNode.objects[j].language,
                  origin: targetPNode.objects[j].origin });
              }
            }
          }
        }
      }
      for (var i = 0; i < copySubjects.length; i++) {
        var snode = this.target.graph.subjects[copySubjects[i]];
        delete snode.predicates[GraphRDFaProcessor.rdfaCopyPredicate];
      }
      for (var subject in patternSubjects) {
        delete this.target.graph.subjects[subject];
      }
    }
  }]);

  return GraphRDFaProcessor;
}(_rdfaProcessor2.default);

exports.default = GraphRDFaProcessor;
;

GraphRDFaProcessor.rdfaCopyPredicate = "http://www.w3.org/ns/rdfa#copy";
GraphRDFaProcessor.rdfaPatternType = "http://www.w3.org/ns/rdfa#Pattern";
module.exports = exports['default'];