'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (document) {
  var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  var node = document.documentElement || document;
  var baseURI = options.baseURI ? options.baseURI : node.baseURI;

  var graph = new _rdfaGraph.RDFaGraph();

  var target = {
    graph: graph,
    baseURI: new _uriResolver2.default().parseURI(baseURI)
  };

  var processor = new _graphRdfaProcessor2.default(target);
  processor.process(node, options);
  return target.graph;
};

var _uriResolver = require('./uri-resolver');

var _uriResolver2 = _interopRequireDefault(_uriResolver);

var _graphRdfaProcessor = require('./graph-rdfa-processor');

var _graphRdfaProcessor2 = _interopRequireDefault(_graphRdfaProcessor);

var _rdfaGraph = require('./rdfa-graph');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

;
module.exports = exports['default'];