'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _uriResolver = require('./uri-resolver');

var _uriResolver2 = _interopRequireDefault(_uriResolver);

var _node = require('./node');

var _node2 = _interopRequireDefault(_node);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RDFaProcessor = function (_URIResolver) {
  _inherits(RDFaProcessor, _URIResolver);

  function RDFaProcessor(targetObject) {
    _classCallCheck(this, RDFaProcessor);

    var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(RDFaProcessor).call(this));

    if (targetObject) {
      _this.target = targetObject;
    } else {
      _this.target = {
        graph: {
          subjects: {},
          prefixes: {},
          terms: {}
        }
      };
    }
    _this.theOne = "_:" + new Date().getTime();
    _this.language = null;
    _this.vocabulary = null;
    _this.blankCounter = 0;
    _this.langAttributes = [{ namespaceURI: "http://www.w3.org/XML/1998/namespace", localName: "lang" }];
    _this.inXHTMLMode = false;
    _this.absURIRE = /[\w\_\-]+:\S+/;
    _this.finishedHandlers = [];
    _this.init();
    return _this;
  }

  _createClass(RDFaProcessor, [{
    key: 'newBlankNode',
    value: function newBlankNode() {
      this.blankCounter++;
      return "_:" + this.blankCounter;
    }
  }, {
    key: 'tokenize',
    value: function tokenize(str) {
      return RDFaProcessor.trim(str).split(/\s+/);
    }
  }, {
    key: 'parseSafeCURIEOrCURIEOrURI',
    value: function parseSafeCURIEOrCURIEOrURI(value, prefixes, base) {
      value = RDFaProcessor.trim(value);
      if (value.charAt(0) == '[' && value.charAt(value.length - 1) == ']') {
        value = value.substring(1, value.length - 1);
        value = value.trim(value);
        if (value.length == 0) {
          return null;
        }
        if (value == "_:") {
          // the one node
          return this.theOne;
        }
        return this.parseCURIE(value, prefixes, base);
      } else {
        return this.parseCURIEOrURI(value, prefixes, base);
      }
    }
  }, {
    key: 'parseCURIE',
    value: function parseCURIE(value, prefixes, base) {
      var colon = value.indexOf(":");
      if (colon >= 0) {
        var prefix = value.substring(0, colon);
        if (prefix == "") {
          // default prefix
          var uri = prefixes[""];
          return uri ? uri + value.substring(colon + 1) : null;
        } else if (prefix == "_") {
          // blank node
          return "_:" + value.substring(colon + 1);
        } else if (RDFaProcessor.NCNAME.test(prefix)) {
          var uri = prefixes[prefix];
          if (uri) {
            return uri + value.substring(colon + 1);
          }
        }
      }
      return null;
    }
  }, {
    key: 'parseCURIEOrURI',
    value: function parseCURIEOrURI(value, prefixes, base) {
      var curie = this.parseCURIE(value, prefixes, base);
      if (curie) {
        return curie;
      }
      return this.resolveAndNormalize(base, value);
    }
  }, {
    key: 'parsePredicate',
    value: function parsePredicate(value, defaultVocabulary, terms, prefixes, base, ignoreTerms) {
      if (value == "") {
        return null;
      }
      var predicate = this.parseTermOrCURIEOrAbsURI(value, defaultVocabulary, ignoreTerms ? null : terms, prefixes, base);
      if (predicate && predicate.indexOf("_:") == 0) {
        return null;
      }
      return predicate;
    }
  }, {
    key: 'parseTermOrCURIEOrURI',
    value: function parseTermOrCURIEOrURI(value, defaultVocabulary, terms, prefixes, base) {
      //alert("Parsing "+value+" with default vocab "+defaultVocabulary);
      value = RDFaProcessor.trim(value);
      var curie = this.parseCURIE(value, prefixes, base);
      if (curie) {
        return curie;
      } else {
        var term = terms[value];
        if (term) {
          return term;
        }
        var lcvalue = value.toLowerCase();
        term = terms[lcvalue];
        if (term) {
          return term;
        }
        if (defaultVocabulary && !this.absURIRE.exec(value)) {
          return defaultVocabulary + value;
        }
      }
      return this.resolveAndNormalize(base, value);
    }
  }, {
    key: 'parseTermOrCURIEOrAbsURI',
    value: function parseTermOrCURIEOrAbsURI(value, defaultVocabulary, terms, prefixes, base) {
      //alert("Parsing "+value+" with default vocab "+defaultVocabulary);
      value = RDFaProcessor.trim(value);
      var curie = this.parseCURIE(value, prefixes, base);
      if (curie) {
        return curie;
      } else if (terms) {
        if (defaultVocabulary && !this.absURIRE.exec(value)) {
          return defaultVocabulary + value;
        }
        var term = terms[value];
        if (term) {
          return term;
        }
        var lcvalue = value.toLowerCase();
        term = terms[lcvalue];
        if (term) {
          return term;
        }
      }
      if (this.absURIRE.exec(value)) {
        return this.resolveAndNormalize(base, value);
      }
      return null;
    }
  }, {
    key: 'resolveAndNormalize',
    value: function resolveAndNormalize(base, href) {
      var u = base.resolve(href);
      var parsed = this.parseURI(u);
      parsed.normalize();
      return parsed.spec;
    }
  }, {
    key: 'parsePrefixMappings',
    value: function parsePrefixMappings(str, target) {
      var values = this.tokenize(str);
      var prefix = null;
      var uri = null;
      for (var i = 0; i < values.length; i++) {
        if (values[i][values[i].length - 1] == ':') {
          prefix = values[i].substring(0, values[i].length - 1);
        } else if (prefix) {
          target[prefix] = this.target.baseURI ? this.target.baseURI.resolve(values[i]) : values[i];
          prefix = null;
        }
      }
    }
  }, {
    key: 'copyMappings',
    value: function copyMappings(mappings) {
      var newMappings = {};
      for (var k in mappings) {
        newMappings[k] = mappings[k];
      }
      return newMappings;
    }
  }, {
    key: 'ancestorPath',
    value: function ancestorPath(node) {
      var path = "";
      while (node && node.nodeType != _node2.default.DOCUMENT_NODE) {
        path = "/" + node.localName + path;
        node = node.parentNode;
      }
      return path;
    }
  }, {
    key: 'setContext',
    value: function setContext(node) {
      // We only recognized XHTML+RDFa 1.1 if the version is set propertyly
      if (node.localName == "html" && node.getAttribute("version") == "XHTML+RDFa 1.1") {
        this.setXHTMLContext();
      } else if (node.localName == "html" || node.namespaceURI == "http://www.w3.org/1999/xhtml") {
        if (node.ownerDocument.doctype) {
          if (node.ownerDocument.doctype.publicId == "-//W3C//DTD XHTML+RDFa 1.0//EN" && node.ownerDocument.doctype.systemId == "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd") {
            console.log("WARNING: RDF 1.0 is not supported.  Defaulting to HTML5 mode.");
            this.setHTMLContext();
          } else if (node.ownerDocument.doctype.publicId == "-//W3C//DTD XHTML+RDFa 1.1//EN" && node.ownerDocument.doctype.systemId == "http://www.w3.org/MarkUp/DTD/xhtml-rdfa-2.dtd") {
            this.setXHTMLContext();
          } else {
            this.setHTMLContext();
          }
        } else {
          this.setHTMLContext();
        }
      } else {
        this.setXMLContext();
      }
    }
  }, {
    key: 'setInitialContext',
    value: function setInitialContext() {
      this.vocabulary = null;
      // By default, the prefixes are terms are loaded to the RDFa 1.1. standard within the graph constructor
      this.langAttributes = [{ namespaceURI: "http://www.w3.org/XML/1998/namespace", localName: "lang" }];
    }
  }, {
    key: 'setXMLContext',
    value: function setXMLContext() {
      this.setInitialContext();
      this.inXHTMLMode = false;
      this.inHTMLMode = false;
    }
  }, {
    key: 'setHTMLContext',
    value: function setHTMLContext() {
      this.setInitialContext();
      this.langAttributes = [{ namespaceURI: "http://www.w3.org/XML/1998/namespace", localName: "lang" }, { namespaceURI: null, localName: "lang" }];
      this.inXHTMLMode = false;
      this.inHTMLMode = true;
    }
  }, {
    key: 'setXHTMLContext',
    value: function setXHTMLContext() {

      this.setInitialContext();

      this.inXHTMLMode = true;
      this.inHTMLMode = false;

      this.langAttributes = [{ namespaceURI: "http://www.w3.org/XML/1998/namespace", localName: "lang" }, { namespaceURI: null, localName: "lang" }];

      // From http://www.w3.org/2011/rdfa-context/xhtml-rdfa-1.1
      this.target.graph.terms["alternate"] = "http://www.w3.org/1999/xhtml/vocab#alternate";
      this.target.graph.terms["appendix"] = "http://www.w3.org/1999/xhtml/vocab#appendix";
      this.target.graph.terms["bookmark"] = "http://www.w3.org/1999/xhtml/vocab#bookmark";
      this.target.graph.terms["cite"] = "http://www.w3.org/1999/xhtml/vocab#cite";
      this.target.graph.terms["chapter"] = "http://www.w3.org/1999/xhtml/vocab#chapter";
      this.target.graph.terms["contents"] = "http://www.w3.org/1999/xhtml/vocab#contents";
      this.target.graph.terms["copyright"] = "http://www.w3.org/1999/xhtml/vocab#copyright";
      this.target.graph.terms["first"] = "http://www.w3.org/1999/xhtml/vocab#first";
      this.target.graph.terms["glossary"] = "http://www.w3.org/1999/xhtml/vocab#glossary";
      this.target.graph.terms["help"] = "http://www.w3.org/1999/xhtml/vocab#help";
      this.target.graph.terms["icon"] = "http://www.w3.org/1999/xhtml/vocab#icon";
      this.target.graph.terms["index"] = "http://www.w3.org/1999/xhtml/vocab#index";
      this.target.graph.terms["last"] = "http://www.w3.org/1999/xhtml/vocab#last";
      this.target.graph.terms["license"] = "http://www.w3.org/1999/xhtml/vocab#license";
      this.target.graph.terms["meta"] = "http://www.w3.org/1999/xhtml/vocab#meta";
      this.target.graph.terms["next"] = "http://www.w3.org/1999/xhtml/vocab#next";
      this.target.graph.terms["prev"] = "http://www.w3.org/1999/xhtml/vocab#prev";
      this.target.graph.terms["previous"] = "http://www.w3.org/1999/xhtml/vocab#previous";
      this.target.graph.terms["section"] = "http://www.w3.org/1999/xhtml/vocab#section";
      this.target.graph.terms["stylesheet"] = "http://www.w3.org/1999/xhtml/vocab#stylesheet";
      this.target.graph.terms["subsection"] = "http://www.w3.org/1999/xhtml/vocab#subsection";
      this.target.graph.terms["start"] = "http://www.w3.org/1999/xhtml/vocab#start";
      this.target.graph.terms["top"] = "http://www.w3.org/1999/xhtml/vocab#top";
      this.target.graph.terms["up"] = "http://www.w3.org/1999/xhtml/vocab#up";
      this.target.graph.terms["p3pv1"] = "http://www.w3.org/1999/xhtml/vocab#p3pv1";

      // other
      this.target.graph.terms["related"] = "http://www.w3.org/1999/xhtml/vocab#related";
      this.target.graph.terms["role"] = "http://www.w3.org/1999/xhtml/vocab#role";
      this.target.graph.terms["transformation"] = "http://www.w3.org/1999/xhtml/vocab#transformation";
    }
  }, {
    key: 'init',
    value: function init() {}
  }, {
    key: 'newSubjectOrigin',
    value: function newSubjectOrigin(origin, subject) {}
  }, {
    key: 'addTriple',
    value: function addTriple(origin, subject, predicate, object) {}
  }, {
    key: 'process',
    value: function process(node, options) {
      if (node.nodeType == _node2.default.DOCUMENT_NODE) {
        node = node.documentElement;
        this.setContext(node);
      } else if (node.parentNode.nodeType == _node2.default.DOCUMENT_NODE) {
        this.setContext(node);
      }
      var queue = [];
      // Fix for Firefox that includes the hash in the base URI
      var removeHash = function removeHash(baseURI) {
        var hash = baseURI.indexOf("#");
        if (hash >= 0) {
          baseURI = baseURI.substring(0, hash);
        }
        if (options && options.baseURIMap) {
          baseURI = options.baseURIMap(baseURI);
        }
        return baseURI;
      };
      queue.push({ current: node, context: this.push(null, removeHash(node.baseURI)) });
      while (queue.length > 0) {
        var item = queue.shift();
        if (item.parent) {
          // Sequence Step 14: list triple generation
          if (item.context.parent && item.context.parent.listMapping == item.listMapping) {
            // Skip a child context with exactly the same mapping
            continue;
          }
          //console.log("Generating lists for "+item.subject+", tag "+item.parent.localName);
          for (var predicate in item.listMapping) {
            var list = item.listMapping[predicate];
            if (list.length == 0) {
              this.addTriple(item.parent, item.subject, predicate, { type: RDFaProcessor.objectURI, value: "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil" });
              continue;
            }
            var bnodes = [];
            for (var i = 0; i < list.length; i++) {
              bnodes.push(this.newBlankNode());
              //this.newSubject(item.parent,bnodes[i]);
            }
            for (var i = 0; i < bnodes.length; i++) {
              this.addTriple(item.parent, bnodes[i], "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", list[i]);
              this.addTriple(item.parent, bnodes[i], "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", { type: RDFaProcessor.objectURI, value: i + 1 < bnodes.length ? bnodes[i + 1] : "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil" });
            }
            this.addTriple(item.parent, item.subject, predicate, { type: RDFaProcessor.objectURI, value: bnodes[0] });
          }
          continue;
        }
        var current = item.current;
        var context = item.context;

        //console.log("Tag: "+current.localName+", listMapping="+JSON.stringify(context.listMapping));

        // Sequence Step 1
        var skip = false;
        var newSubject = null;
        var currentObjectResource = null;
        var typedResource = null;
        var prefixes = context.prefixes;
        var prefixesCopied = false;
        var incomplete = [];
        var listMapping = context.listMapping;
        var listMappingDifferent = context.parent ? false : true;
        var language = context.language;
        var vocabulary = context.vocabulary;

        // TODO: the "base" element may be used for HTML+RDFa 1.1
        var base;
        if (!current.baseURI) {
          if (this.target.baseURI) {
            base = this.target.baseURI;
          } else {
            throw new Error('node.baseURI was null as baseURI must be specified as an option');
          }
        } else if (current.baseURI === 'about:blank') {
          if (this.target.baseURI) {
            base = this.target.baseURI;
          } else {
            throw new Error('node.baseURI is about:blank a valid URL must be provided with the baseURI option. If you use JSDOM call it with an `url` parameter or, set the baseURI option of this library');
          }
        } else {
          base = this.parseURI(removeHash(current.baseURI));
        }

        current.item = null;

        // Sequence Step 2: set the default vocabulary
        var vocabAtt = current.getAttributeNode("vocab");
        if (vocabAtt) {
          var value = RDFaProcessor.trim(vocabAtt.value);
          if (value.length > 0) {
            vocabulary = value;
            var baseSubject = base.spec;
            //this.newSubject(current,baseSubject);
            this.addTriple(current, baseSubject, "http://www.w3.org/ns/rdfa#usesVocabulary", { type: RDFaProcessor.objectURI, value: vocabulary });
          } else {
            vocabulary = this.vocabulary;
          }
        }

        // Sequence Step 3: IRI mappings
        // handle xmlns attributes
        for (var i = 0; i < current.attributes.length; i++) {
          var att = current.attributes[i];
          //if (att.namespaceURI=="http://www.w3.org/2000/xmlns/") {
          if (att.name.charAt(0) == "x" && att.name.indexOf("xmlns:") == 0) {
            if (!prefixesCopied) {
              prefixes = this.copyMappings(prefixes);
              prefixesCopied = true;
            }
            var prefix = att.name.substring(6);
            // TODO: resolve relative?
            var ref = RDFaProcessor.trim(att.value);
            prefixes[prefix] = this.target.baseURI ? this.target.baseURI.resolve(ref) : ref;
          }
        }
        // Handle prefix mappings (@prefix)
        var prefixAtt = current.getAttributeNode("prefix");
        if (prefixAtt) {
          if (!prefixesCopied) {
            prefixes = this.copyMappings(prefixes);
            prefixesCopied = true;
          }
          this.parsePrefixMappings(prefixAtt.value, prefixes);
        }

        // Sequence Step 4: language
        var xmlLangAtt = null;
        for (var i = 0; !xmlLangAtt && i < this.langAttributes.length; i++) {
          xmlLangAtt = current.getAttributeNodeNS(this.langAttributes[i].namespaceURI, this.langAttributes[i].localName);
        }
        if (xmlLangAtt) {
          var value = RDFaProcessor.trim(xmlLangAtt.value);
          if (value.length > 0) {
            language = value;
          } else {
            language = null;
          }
        }

        var relAtt = current.getAttributeNode("rel");
        var revAtt = current.getAttributeNode("rev");
        var typeofAtt = current.getAttributeNode("typeof");
        var propertyAtt = current.getAttributeNode("property");
        var datatypeAtt = current.getAttributeNode("datatype");
        var datetimeAtt = this.inHTMLMode ? current.getAttributeNode("datetime") : null;
        var contentAtt = current.getAttributeNode("content");
        var aboutAtt = current.getAttributeNode("about");
        var srcAtt = current.getAttributeNode("src");
        var resourceAtt = current.getAttributeNode("resource");
        var hrefAtt = current.getAttributeNode("href");
        var inlistAtt = current.getAttributeNode("inlist");

        var relAttPredicates = [];
        if (relAtt) {
          var values = this.tokenize(relAtt.value);
          for (var i = 0; i < values.length; i++) {
            var predicate = this.parsePredicate(values[i], vocabulary, context.terms, prefixes, base, this.inHTMLMode && propertyAtt != null);
            if (predicate) {
              relAttPredicates.push(predicate);
            }
          }
        }
        var revAttPredicates = [];
        if (revAtt) {
          var values = this.tokenize(revAtt.value);
          for (var i = 0; i < values.length; i++) {
            var predicate = this.parsePredicate(values[i], vocabulary, context.terms, prefixes, base, this.inHTMLMode && propertyAtt != null);
            if (predicate) {
              revAttPredicates.push(predicate);
            }
          }
        }

        // Section 3.1, bullet 7
        if (this.inHTMLMode && (relAtt != null || revAtt != null) && propertyAtt != null) {
          if (relAttPredicates.length == 0) {
            relAtt = null;
          }
          if (revAttPredicates.length == 0) {
            revAtt = null;
          }
        }

        if (relAtt || revAtt) {
          // Sequence Step 6: establish new subject and value
          if (aboutAtt) {
            newSubject = this.parseSafeCURIEOrCURIEOrURI(aboutAtt.value, prefixes, base);
          }
          if (typeofAtt) {
            typedResource = newSubject;
          }
          if (!newSubject) {
            if (current.parentNode.nodeType == _node2.default.DOCUMENT_NODE) {
              newSubject = removeHash(current.baseURI);
            } else if (context.parentObject) {
              // TODO: Verify: If the xml:base has been set and the parentObject is the baseURI of the parent, then the subject needs to be the new base URI
              newSubject = removeHash(current.parentNode.baseURI) == context.parentObject ? removeHash(current.baseURI) : context.parentObject;
            }
          }
          if (resourceAtt) {
            currentObjectResource = this.parseSafeCURIEOrCURIEOrURI(resourceAtt.value, prefixes, base);
          }

          if (!currentObjectResource) {
            if (hrefAtt) {
              currentObjectResource = this.resolveAndNormalize(base, encodeURI(hrefAtt.value));
            } else if (srcAtt) {
              currentObjectResource = this.resolveAndNormalize(base, encodeURI(srcAtt.value));
            } else if (typeofAtt && !aboutAtt && !(this.inXHTMLMode && (current.localName == "head" || current.localName == "body"))) {
              currentObjectResource = this.newBlankNode();
            }
          }
          if (typeofAtt && !aboutAtt && this.inXHTMLMode && (current.localName == "head" || current.localName == "body")) {
            typedResource = newSubject;
          } else if (typeofAtt && !aboutAtt) {
            typedResource = currentObjectResource;
          }
        } else if (propertyAtt && !contentAtt && !datatypeAtt) {
          // Sequence Step 5.1: establish a new subject
          if (aboutAtt) {
            newSubject = this.parseSafeCURIEOrCURIEOrURI(aboutAtt.value, prefixes, base);
            if (typeofAtt) {
              typedResource = newSubject;
            }
          }
          if (!newSubject && current.parentNode.nodeType == _node2.default.DOCUMENT_NODE) {
            newSubject = removeHash(current.baseURI);
            if (typeofAtt) {
              typedResource = newSubject;
            }
          } else if (!newSubject && context.parentObject) {
            // TODO: Verify: If the xml:base has been set and the parentObject is the baseURI of the parent, then the subject needs to be the new base URI
            newSubject = removeHash(current.parentNode.baseURI) == context.parentObject ? removeHash(current.baseURI) : context.parentObject;
          }
          if (typeofAtt && !typedResource) {
            if (resourceAtt) {
              typedResource = this.parseSafeCURIEOrCURIEOrURI(resourceAtt.value, prefixes, base);
            }
            if (!typedResource && hrefAtt) {
              typedResource = this.resolveAndNormalize(base, encodeURI(hrefAtt.value));
            }
            if (!typedResource && srcAtt) {
              typedResource = this.resolveAndNormalize(base, encodeURI(srcAtt.value));
            }
            if (!typedResource && (this.inXHTMLMode || this.inHTMLMode) && (current.localName == "head" || current.localName == "body")) {
              typedResource = newSubject;
            }
            if (!typedResource) {
              typedResource = this.newBlankNode();
            }
            currentObjectResource = typedResource;
          }
          //console.log(current.localName+", newSubject="+newSubject+", typedResource="+typedResource+", currentObjectResource="+currentObjectResource);
        } else {
            // Sequence Step 5.2: establish a new subject
            if (aboutAtt) {
              newSubject = this.parseSafeCURIEOrCURIEOrURI(aboutAtt.value, prefixes, base);
            }
            if (!newSubject && resourceAtt) {
              newSubject = this.parseSafeCURIEOrCURIEOrURI(resourceAtt.value, prefixes, base);
            }
            if (!newSubject && hrefAtt) {
              newSubject = this.resolveAndNormalize(base, encodeURI(hrefAtt.value));
            }
            if (!newSubject && srcAtt) {
              newSubject = this.resolveAndNormalize(base, encodeURI(srcAtt.value));
            }
            if (!newSubject) {
              if (current.parentNode.nodeType == _node2.default.DOCUMENT_NODE) {
                newSubject = removeHash(current.baseURI);
              } else if ((this.inXHTMLMode || this.inHTMLMode) && (current.localName == "head" || current.localName == "body")) {
                newSubject = removeHash(current.parentNode.baseURI) == context.parentObject ? removeHash(current.baseURI) : context.parentObject;
              } else if (typeofAtt) {
                newSubject = this.newBlankNode();
              } else if (context.parentObject) {
                // TODO: Verify: If the xml:base has been set and the parentObject is the baseURI of the parent, then the subject needs to be the new base URI
                newSubject = removeHash(current.parentNode.baseURI) == context.parentObject ? removeHash(current.baseURI) : context.parentObject;
                if (!propertyAtt) {
                  skip = true;
                }
              }
            }
            if (typeofAtt) {
              typedResource = newSubject;
            }
          }

        //console.log(current.tagName+": newSubject="+newSubject+", currentObjectResource="+currentObjectResource+", typedResource="+typedResource+", skip="+skip);

        var rdfaData = null;
        if (newSubject) {
          //this.newSubject(current,newSubject);
          if (aboutAtt || resourceAtt || typedResource) {
            var id = newSubject;
            if (typeofAtt && !aboutAtt && !resourceAtt && currentObjectResource) {
              id = currentObjectResource;
            }
            //console.log("Setting data attribute for "+current.localName+" for subject "+id);
            this.newSubjectOrigin(current, id);
          }
        }

        // Sequence Step 7: generate type triple
        if (typedResource) {
          var values = this.tokenize(typeofAtt.value);
          for (var i = 0; i < values.length; i++) {
            var object = this.parseTermOrCURIEOrAbsURI(values[i], vocabulary, context.terms, prefixes, base);
            if (object) {
              this.addTriple(current, typedResource, RDFaProcessor.typeURI, { type: RDFaProcessor.objectURI, value: object });
            }
          }
        }

        // Sequence Step 8: new list mappings if there is a new subject
        //console.log("Step 8: newSubject="+newSubject+", context.parentObject="+context.parentObject);
        if (newSubject && newSubject != context.parentObject) {
          //console.log("Generating new list mapping for "+newSubject);
          listMapping = {};
          listMappingDifferent = true;
        }

        // Sequence Step 9: generate object triple
        if (currentObjectResource) {
          if (relAtt && inlistAtt) {
            for (var i = 0; i < relAttPredicates.length; i++) {
              var list = listMapping[relAttPredicates[i]];
              if (!list) {
                list = [];
                listMapping[relAttPredicates[i]] = list;
              }
              list.push({ type: RDFaProcessor.objectURI, value: currentObjectResource });
            }
          } else if (relAtt) {
            for (var i = 0; i < relAttPredicates.length; i++) {
              this.addTriple(current, newSubject, relAttPredicates[i], { type: RDFaProcessor.objectURI, value: currentObjectResource });
            }
          }
          if (revAtt) {
            for (var i = 0; i < revAttPredicates.length; i++) {
              this.addTriple(current, currentObjectResource, revAttPredicates[i], { type: RDFaProcessor.objectURI, value: newSubject });
            }
          }
        } else {
          // Sequence Step 10: incomplete triples
          if (newSubject && !currentObjectResource && (relAtt || revAtt)) {
            currentObjectResource = this.newBlankNode();
            //alert(current.tagName+": generated blank node, newSubject="+newSubject+" currentObjectResource="+currentObjectResource);
          }
          if (relAtt && inlistAtt) {
            for (var i = 0; i < relAttPredicates.length; i++) {
              var list = listMapping[relAttPredicates[i]];
              if (!list) {
                list = [];
                listMapping[predicate] = list;
              }
              //console.log("Adding incomplete list for "+predicate);
              incomplete.push({ predicate: relAttPredicates[i], list: list });
            }
          } else if (relAtt) {
            for (var i = 0; i < relAttPredicates.length; i++) {
              incomplete.push({ predicate: relAttPredicates[i], forward: true });
            }
          }
          if (revAtt) {
            for (var i = 0; i < revAttPredicates.length; i++) {
              incomplete.push({ predicate: revAttPredicates[i], forward: false });
            }
          }
        }

        // Step 11: Current property values
        if (propertyAtt) {
          var datatype = null;
          var content = null;
          if (datatypeAtt) {
            datatype = datatypeAtt.value == "" ? RDFaProcessor.PlainLiteralURI : this.parseTermOrCURIEOrAbsURI(datatypeAtt.value, vocabulary, context.terms, prefixes, base);
            if (datetimeAtt && !contentAtt) {
              content = datetimeAtt.value;
            } else {
              content = datatype == RDFaProcessor.XMLLiteralURI || datatype == RDFaProcessor.HTMLLiteralURI ? null : contentAtt ? contentAtt.value : current.textContent;
            }
          } else if (contentAtt) {
            datatype = RDFaProcessor.PlainLiteralURI;
            content = contentAtt.value;
          } else if (datetimeAtt) {
            content = datetimeAtt.value;
            datatype = RDFaProcessor.deriveDateTimeType(content);
            if (!datatype) {
              datatype = RDFaProcessor.PlainLiteralURI;
            }
          } else if (!relAtt && !revAtt) {
            if (resourceAtt) {
              content = this.parseSafeCURIEOrCURIEOrURI(resourceAtt.value, prefixes, base);
            }
            if (!content && hrefAtt) {
              content = this.resolveAndNormalize(base, encodeURI(hrefAtt.value));
            } else if (!content && srcAtt) {
              content = this.resolveAndNormalize(base, encodeURI(srcAtt.value));
            }
            if (content) {
              datatype = RDFaProcessor.objectURI;
            }
          }
          if (!datatype) {
            if (typeofAtt && !aboutAtt) {
              datatype = RDFaProcessor.objectURI;
              content = typedResource;
            } else {
              content = current.textContent;
              if (this.inHTMLMode && current.localName == "time") {
                datatype = RDFaProcessor.deriveDateTimeType(content);
              }
              if (!datatype) {
                datatype = RDFaProcessor.PlainLiteralURI;
              }
            }
          }
          var values = this.tokenize(propertyAtt.value);
          for (var i = 0; i < values.length; i++) {
            var predicate = this.parsePredicate(values[i], vocabulary, context.terms, prefixes, base);
            if (predicate) {
              if (inlistAtt) {
                var list = listMapping[predicate];
                if (!list) {
                  list = [];
                  listMapping[predicate] = list;
                }
                list.push(datatype == RDFaProcessor.XMLLiteralURI || datatype == RDFaProcessor.HTMLLiteralURI ? { type: datatype, value: current.childNodes } : { type: datatype ? datatype : RDFaProcessor.PlainLiteralURI, value: content, language: language });
              } else {
                if (datatype == RDFaProcessor.XMLLiteralURI || datatype == RDFaProcessor.HTMLLiteralURI) {
                  this.addTriple(current, newSubject, predicate, { type: datatype, value: current.childNodes });
                } else {
                  this.addTriple(current, newSubject, predicate, { type: datatype ? datatype : RDFaProcessor.PlainLiteralURI, value: content, language: language });
                  //console.log(newSubject+" "+predicate+"="+content);
                }
              }
            }
          }
        }

        // Sequence Step 12: complete incomplete triples with new subject
        if (newSubject && !skip) {
          for (var i = 0; i < context.incomplete.length; i++) {
            if (context.incomplete[i].list) {
              //console.log("Adding subject "+newSubject+" to list for "+context.incomplete[i].predicate);
              // TODO: it is unclear what to do here
              context.incomplete[i].list.push({ type: RDFaProcessor.objectURI, value: newSubject });
            } else if (context.incomplete[i].forward) {
              //console.log(current.tagName+": completing forward triple "+context.incomplete[i].predicate+" with object="+newSubject);
              this.addTriple(current, context.subject, context.incomplete[i].predicate, { type: RDFaProcessor.objectURI, value: newSubject });
            } else {
              //console.log(current.tagName+": completing reverse triple with object="+context.subject);
              this.addTriple(current, newSubject, context.incomplete[i].predicate, { type: RDFaProcessor.objectURI, value: context.subject });
            }
          }
        }

        var childContext = null;
        var listSubject = newSubject;
        if (skip) {
          // TODO: should subject be null?
          childContext = this.push(context, context.subject);
          // TODO: should the entObject be passed along?  If not, then intermediary children will keep properties from being associated with incomplete triples.
          // TODO: Verify: if the current baseURI has changed and the parentObject is the parent's base URI, then the baseURI should change
          childContext.parentObject = removeHash(current.parentNode.baseURI) == context.parentObject ? removeHash(current.baseURI) : context.parentObject;
          childContext.incomplete = context.incomplete;
          childContext.language = language;
          childContext.prefixes = prefixes;
          childContext.vocabulary = vocabulary;
        } else {
          childContext = this.push(context, newSubject);
          childContext.parentObject = currentObjectResource ? currentObjectResource : newSubject ? newSubject : context.subject;
          childContext.prefixes = prefixes;
          childContext.incomplete = incomplete;
          if (currentObjectResource) {
            //console.log("Generating new list mapping for "+currentObjectResource);
            listSubject = currentObjectResource;
            listMapping = {};
            listMappingDifferent = true;
          }
          childContext.listMapping = listMapping;
          childContext.language = language;
          childContext.vocabulary = vocabulary;
        }
        if (listMappingDifferent) {
          //console.log("Pushing list parent "+current.localName);
          queue.unshift({ parent: current, context: context, subject: listSubject, listMapping: listMapping });
        }
        for (var child = current.lastChild; child; child = child.previousSibling) {
          if (child.nodeType == _node2.default.ELEMENT_NODE) {
            //console.log("Pushing child "+child.localName);
            queue.unshift({ current: child, context: childContext });
          }
        }
      }

      if (this.inHTMLMode) {
        this.copyProperties();
      }

      for (var i = 0; i < this.finishedHandlers.length; i++) {
        this.finishedHandlers[i](node);
      }
    }
  }, {
    key: 'copyProperties',
    value: function copyProperties() {}
  }, {
    key: 'push',
    value: function push(parent, subject) {
      return {
        parent: parent,
        subject: subject ? subject : parent ? parent.subject : null,
        parentObject: null,
        incomplete: [],
        listMapping: parent ? parent.listMapping : {},
        language: parent ? parent.language : this.language,
        prefixes: parent ? parent.prefixes : this.target.graph.prefixes,
        terms: parent ? parent.terms : this.target.graph.terms,
        vocabulary: parent ? parent.vocabulary : this.vocabulary
      };
    }
  }]);

  return RDFaProcessor;
}(_uriResolver2.default);

exports.default = RDFaProcessor;
;

RDFaProcessor.XMLLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
RDFaProcessor.HTMLLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#HTML";
RDFaProcessor.PlainLiteralURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral";
RDFaProcessor.objectURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#object";
RDFaProcessor.typeURI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

RDFaProcessor.nameChar = '[-A-Z_a-zÀ-ÖØ-öø-˿Ͱ-ͽͿ-῿‌-‍⁰-↏Ⰰ-⿯、-퟿豈-﷏ﷰ-�က0-F.0-9·̀-ͯ‿-⁀]';
RDFaProcessor.nameStartChar = '[A-Za-zÀ-ÖØ-öø-ÿĀ-ıĴ-ľŁ-ňŊ-žƀ-ǃǍ-ǰǴ-ǵǺ-ȗɐ-ʨʻ-ˁΆΈ-ΊΌΎ-ΡΣ-ώϐ-ϖϚϜϞϠϢ-ϳЁ-ЌЎ-яё-ќў-ҁҐ-ӄӇ-ӈӋ-ӌӐ-ӫӮ-ӵӸ-ӹԱ-Ֆՙա-ֆא-תװ-ײء-غف-يٱ-ڷں-ھۀ-ێې-ۓەۥ-ۦअ-हऽक़-ॡঅ-ঌএ-ঐও-নপ-রলশ-হড়-ঢ়য়-ৡৰ-ৱਅ-ਊਏ-ਐਓ-ਨਪ-ਰਲ-ਲ਼ਵ-ਸ਼ਸ-ਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઋઍએ-ઑઓ-નપ-રલ-ળવ-હઽૠଅ-ଌଏ-ଐଓ-ନପ-ରଲ-ଳଶ-ହଽଡ଼-ଢ଼ୟ-ୡஅ-ஊஎ-ஐஒ-கங-சஜஞ-டண-தந-பம-வஷ-ஹఅ-ఌఎ-ఐఒ-నప-ళవ-హౠ-ౡಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹೞೠ-ೡഅ-ഌഎ-ഐഒ-നപ-ഹൠ-ൡก-ฮะา-ำเ-ๅກ-ຂຄງ-ຈຊຍດ-ທນ-ຟມ-ຣລວສ-ຫອ-ຮະາ-ຳຽເ-ໄཀ-ཇཉ-ཀྵႠ-Ⴥა-ჶᄀᄂ-ᄃᄅ-ᄇᄉᄋ-ᄌᄎ-ᄒᄼᄾᅀᅌᅎᅐᅔ-ᅕᅙᅟ-ᅡᅣᅥᅧᅩᅭ-ᅮᅲ-ᅳᅵᆞᆨᆫᆮ-ᆯᆷ-ᆸᆺᆼ-ᇂᇫᇰᇹḀ-ẛẠ-ỹἀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼΩK-Å℮ↀ-ↂぁ-ゔァ-ヺㄅ-ㄬ가-힣一-龥〇〡-〩_]';

RDFaProcessor.NCNAME = new RegExp('^' + RDFaProcessor.nameStartChar + RDFaProcessor.nameChar + '*$');

RDFaProcessor.trim = function (str) {
  return str.replace(/^\s\s*/, '').replace(/\s\s*$/, '');
};

RDFaProcessor.dateTimeTypes = [{ pattern: /-?P(?:[0-9]+Y)?(?:[0-9]+M)?(?:[0-9]+D)?(?:T(?:[0-9]+H)?(?:[0-9]+M)?(?:[0-9]+(?:\.[0-9]+)?S)?)?/,
  type: "http://www.w3.org/2001/XMLSchema#duration" }, { pattern: /-?(?:[1-9][0-9][0-9][0-9]|0[1-9][0-9][0-9]|00[1-9][0-9]|000[1-9])-[0-9][0-9]-[0-9][0-9]T(?:[0-1][0-9]|2[0-4]):[0-5][0-9]:[0-5][0-9](?:\.[0-9]+)?(?:Z|[+\-][0-9][0-9]:[0-9][0-9])?/,
  type: "http://www.w3.org/2001/XMLSchema#dateTime" }, { pattern: /-?(?:[1-9][0-9][0-9][0-9]|0[1-9][0-9][0-9]|00[1-9][0-9]|000[1-9])-[0-9][0-9]-[0-9][0-9](?:Z|[+\-][0-9][0-9]:[0-9][0-9])?/,
  type: "http://www.w3.org/2001/XMLSchema#date" }, { pattern: /(?:[0-1][0-9]|2[0-4]):[0-5][0-9]:[0-5][0-9](?:\.[0-9]+)?(?:Z|[+\-][0-9][0-9]:[0-9][0-9])?/,
  type: "http://www.w3.org/2001/XMLSchema#time" }, { pattern: /-?(?:[1-9][0-9][0-9][0-9]|0[1-9][0-9][0-9]|00[1-9][0-9]|000[1-9])-[0-9][0-9]/,
  type: "http://www.w3.org/2001/XMLSchema#gYearMonth" }, { pattern: /-?[1-9][0-9][0-9][0-9]|0[1-9][0-9][0-9]|00[1-9][0-9]|000[1-9]/,
  type: "http://www.w3.org/2001/XMLSchema#gYear" }];

RDFaProcessor.deriveDateTimeType = function (value) {
  for (var i = 0; i < RDFaProcessor.dateTimeTypes.length; i++) {
    //console.log("Checking "+value+" against "+RDFaProcessor.dateTimeTypes[i].type);
    var matched = RDFaProcessor.dateTimeTypes[i].pattern.exec(value);
    if (matched && matched[0].length == value.length) {
      //console.log("Matched!");
      return RDFaProcessor.dateTimeTypes[i].type;
    }
  }
  return null;
};
module.exports = exports['default'];